{
---------------------------------------------------------------
Code generated by MAS-CompMaker, 2000-2002 Mats Asplund http://go.to/mdp
---------------------------------------------------------------

Component Name: TmDipSwitch
        Author: Mats Asplund
 Creation Date: 2003-03-12
       Version: 1.0
   Description: A DIP-switch imitation component
        E-mail: masprod@telia.com
       Website: http://go.to/masdp
  Legal Issues: All rigths reserved 2003 by Mats Asplund


Usage:
  This software is provided 'as-is', without any express or
  implied warranty.  In no event will the author be held liable
  for any  damages arising from the use of this software.

  Permission is granted to anyone to use this software for any
  purpose, including commercial applications, and to alter it
  and redistribute it freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented,
     you must not claim that you wrote the original software.
     If you use this software in a product, an acknowledgment
     in the product documentation would be appreciated but is
     not required.

  2. Altered source versions must be plainly marked as such, and
     must not be misrepresented as being the original software.

  3. This notice may not be removed or altered from any source
     distribution.

  4. If you decide to use this software in any of your applications.
     Send me an EMail and tell me about it.

Quick Reference:
  TmDipSwitch inherits from TGraphicControl (TGC)

  Key-Properties:
     property Orientation: TDipOrientation read fOrientation write SetOrientation;
     property State: boolean read fState write SetState;

  Key-Events:
     property OnChange: TOnChangeEvent read fOnChange write fOnChange;

---------------------------------------------------------------
}

unit mDIPSwitch;

interface

uses
  Windows, Messages, SysUtils, Classes, ExtCtrls, Forms, Controls, Graphics;

type
  TDipOrientation = (dipVertical, dipHorizontal);
  TOnChangeEvent = procedure(Sender: TObject; State: boolean) of Object;

  TGC = class(TGraphicControl)
  private
    FPicture: TPicture;
    FOnProgress: TProgressEvent;
    FStretch: Boolean;
    FCenter: Boolean;
    FIncrementalDisplay: Boolean;
    FTransparent: Boolean;
    FDrawing: Boolean;
    FProportional: Boolean;
    procedure PictureChanged(Sender: TObject);
    procedure SetCenter(Value: Boolean);
    procedure SetPicture(Value: TPicture);
    procedure SetStretch(Value: Boolean);
    procedure SetProportional(Value: Boolean);
  protected
    function CanAutoSize(var NewWidth, NewHeight: Integer): Boolean; override;
    function DestRect: TRect;
    function DoPaletteChange: Boolean;
    function GetPalette: HPALETTE; override;
    procedure Paint; override;
    procedure Progress(Sender: TObject; Stage: TProgressStage;
      PercentDone: Byte; RedrawNow: Boolean; const R: TRect; const Msg: string); dynamic;
    property Picture: TPicture read FPicture write SetPicture;
    property Stretch: Boolean read FStretch write SetStretch default False;
    property Proportional: Boolean read FProportional write SetProportional default false;
    property Center: Boolean read FCenter write SetCenter default False;
    property OnClick;
  published
    property Align;
    property Anchors;
    property Enabled;
    property ParentShowHint;
    property ShowHint;
    property Visible;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  end;

  TmDipSwitch = class(TGC)
  private
    { Private declarations }
     fAbout: String;
     TheBitmap: TBitmap;
    fState: boolean;
    fOrientation: TDipOrientation;
    fOnChange: TOnChangeEvent;
    procedure SetAbout(Value: String);
    procedure SetState(const Value: boolean);
    procedure SetOrientation(const Value: TDipOrientation);
    procedure DrawComp;
    procedure Changed(Sender: TObject);
  protected
    { Protected declarations }
  public
    { Public declarations }
     constructor Create(AOwner: TComponent); override;
     destructor Destroy; override;
  published
    { Published declarations }
     property Orientation: TDipOrientation read fOrientation write SetOrientation;
     property State: boolean read fState write SetState;
     property OnChange: TOnChangeEvent read fOnChange write fOnChange;
     property About: String read fAbout write SetAbout;
  end;

procedure Register;

implementation
{$R *.res}

procedure Register;
begin
  RegisterComponents('MAs Prod.', [TmDipSwitch]);
end;

constructor TmDipSwitch.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  AutoSize:= true;
  TheBitmap := TBitmap.Create;
  TheBitmap.Handle := LoadBitmap(Hinstance, 'V0');
  Picture.Bitmap:= TheBitmap;
  OnClick:= Changed;
  fAbout := 'Version 1.0, 2003  Mats Asplund';
end;

destructor TmDipSwitch.Destroy;
begin
  inherited Destroy;
end;

procedure TmDipSwitch.DrawComp;
begin
  if fState and (fOrientation = dipVertical) then
    TheBitmap.Handle := LoadBitmap(Hinstance, 'V1');
  if not fState and (fOrientation = dipVertical) then
    TheBitmap.Handle := LoadBitmap(Hinstance, 'V0');
  if fState and (fOrientation = dipHorizontal) then
    TheBitmap.Handle := LoadBitmap(Hinstance, 'H1');
  if not fState and (fOrientation = dipHorizontal) then
    TheBitmap.Handle := LoadBitmap(Hinstance, 'H0');
  Picture.Bitmap:= TheBitmap;
end;

procedure TmDipSwitch.SetOrientation(const Value: TDipOrientation);
begin
  fOrientation := Value;
  DrawComp;
end;

procedure TmDipSwitch.SetState(const Value: boolean);
begin
  fState := Value;
  DrawComp;
end;

procedure TmDipSwitch.Changed(Sender: TObject);
begin
  if Enabled then
  begin
    fState:= not fState;
    DrawComp;
    if Assigned(fOnChange) then fOnChange(self, fState);
  end;
end;

procedure TmDipSwitch.SetAbout(Value: String);
begin
  Exit;
end;

{TGC}

constructor TGC.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csReplicatable];
  FPicture := TPicture.Create;
  FPicture.OnChange := PictureChanged;
  FPicture.OnProgress := Progress;
  Height := 105;
  Width := 105;
end;

destructor TGC.Destroy;
begin
  FPicture.Free;
  inherited Destroy;
end;

function TGC.GetPalette: HPALETTE;
begin
  Result := 0;
  if FPicture.Graphic <> nil then
	Result := FPicture.Graphic.Palette;
end;

function TGC.DestRect: TRect;
var
  w, h, cw, ch: Integer;
  xyaspect: Double;
begin
  w := Picture.Width;
  h := Picture.Height;
  cw := ClientWidth;
  ch := ClientHeight;
  if Stretch or (Proportional and ((w > cw) or (h > ch))) then
  begin
	if Proportional and (w > 0) and (h > 0) then
	begin
      xyaspect := w / h;
      if w > h then
      begin
        w := cw;
        h := Trunc(cw / xyaspect);
        if h > ch then  // woops, too big
        begin
          h := ch;
          w := Trunc(ch * xyaspect);
        end;
      end
      else
      begin
        h := ch;
        w := Trunc(ch * xyaspect);
        if w > cw then  // woops, too big
        begin
          w := cw;
          h := Trunc(cw / xyaspect);
        end;
      end;
    end
    else
    begin
      w := cw;
      h := ch;
    end;
  end;

  with Result do
  begin
    Left := 0;
    Top := 0;
    Right := w;
    Bottom := h;
  end;

  if Center then
	OffsetRect(Result, (cw - w) div 2, (ch - h) div 2);
end;

procedure TGC.Paint;
var
  Save: Boolean;
begin
  if csDesigning in ComponentState then
	with inherited Canvas do
	begin
	  Pen.Style := psDash;
	  Brush.Style := bsClear;
	  Rectangle(0, 0, Width, Height);
	end;
  Save := FDrawing;
  FDrawing := True;
  try
	with inherited Canvas do
	  StretchDraw(DestRect, Picture.Graphic);
  finally
	FDrawing := Save;
  end;
end;

function TGC.DoPaletteChange: Boolean;
var
  ParentForm: TCustomForm;
  Tmp: TGraphic;
begin
  Result := False;
  Tmp := Picture.Graphic;
  if Visible and (not (csLoading in ComponentState)) and (Tmp <> nil) and
	(Tmp.PaletteModified) then
  begin
	if (Tmp.Palette = 0) then
	  Tmp.PaletteModified := False
	else
	begin
	  ParentForm := GetParentForm(Self);
	  if Assigned(ParentForm) and ParentForm.Active and Parentform.HandleAllocated then
	  begin
		if FDrawing then
		  ParentForm.Perform(wm_QueryNewPalette, 0, 0)
		else
		  PostMessage(ParentForm.Handle, wm_QueryNewPalette, 0, 0);
		Result := True;
		Tmp.PaletteModified := False;
	  end;
	end;
  end;
end;

procedure TGC.Progress(Sender: TObject; Stage: TProgressStage;
  PercentDone: Byte; RedrawNow: Boolean; const R: TRect; const Msg: string);
begin
  if FIncrementalDisplay and RedrawNow then
  begin
	if DoPaletteChange then Update
	else Paint;
  end;
  if Assigned(FOnProgress) then FOnProgress(Sender, Stage, PercentDone, RedrawNow, R, Msg);
end;

procedure TGC.SetCenter(Value: Boolean);
begin
  if FCenter <> Value then
  begin
	FCenter := Value;
	PictureChanged(Self);
  end;
end;

procedure TGC.SetPicture(Value: TPicture);
begin
  FPicture.Assign(Value);
end;

procedure TGC.SetStretch(Value: Boolean);
begin
  if Value <> FStretch then
  begin
	FStretch := Value;
	PictureChanged(Self);
  end;
end;

procedure TGC.SetProportional(Value: Boolean);
begin
  if FProportional <> Value then
  begin
	FProportional := Value;
	PictureChanged(Self);
  end;
end;

procedure TGC.PictureChanged(Sender: TObject);
var
  G: TGraphic;
begin
  if AutoSize and (Picture.Width > 0) and (Picture.Height > 0) then
	SetBounds(Left, Top, Picture.Width, Picture.Height);
  G := Picture.Graphic;
  if G <> nil then
  begin
	if not ((G is TMetaFile) or (G is TIcon)) then
	  G.Transparent := FTransparent;
	if (not G.Transparent) and Stretch and not Proportional then
	  ControlStyle := ControlStyle + [csOpaque]
	else  // picture might not cover entire clientrect
	  ControlStyle := ControlStyle - [csOpaque];
	if DoPaletteChange and FDrawing then Update;
  end
  else ControlStyle := ControlStyle - [csOpaque];
  if not FDrawing then Invalidate;
end;

function TGC.CanAutoSize(var NewWidth, NewHeight: Integer): Boolean;
begin
  Result := True;
  if not (csDesigning in ComponentState) or (Picture.Width > 0) and
    (Picture.Height > 0) then
  begin
    if Align in [alNone, alLeft, alRight] then
      NewWidth := Picture.Width;
    if Align in [alNone, alTop, alBottom] then
      NewHeight := Picture.Height;
  end;
end;

end.
