
{===============================================================}
{								}
{	Mixer comtrols test application - main form		}
{	a code by Lake Unanimated / unanimated@geocities.com	}
{								}
{								}
{	Copyright (c) 2000 Lake of Soft, Ltd			}
{	All Rights Reserved					}
{								}
{===============================================================}
{$B-}

unit uMPMain;

interface

uses
  Windows, Forms, MsMixerThorax, StdCtrls, Controls, Classes, ComCtrls, MMSystem,
  ExtCtrls, MsMixerControl, Menus, Contnrs;

type
  TformMixMain = class(TForm)
    tvMain: TTreeView;
    Splitter1: TSplitter;
    PopupMenu1: TPopupMenu;
    FullExpand1: TMenuItem;
    FullCollapse1: TMenuItem;
    Enum1: TMenuItem;
    N1: TMenuItem;
    Panel2: TPanel;
    ComboBox1: TComboBox;
    Label1: TLabel;
    Button1: TButton;
    StatusBar1: TStatusBar;
    Timer1: TTimer;
    Button2: TButton;
    pcMain: TPageControl;
    Button3: TButton;
    CheckBox1: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FullExpand1Click(Sender: TObject);
    procedure FullCollapse1Click(Sender: TObject);
    procedure Enum1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
    fSysMixer: tMsMixerSystem;
    fMixers  : tObjectList;
    function  GetMixerIndex: Integer;
    procedure DisplayLine(aNode: tTreeNode; aCaps: pMixerLine);
    procedure DisplayLineControl(aNode: tTreeNode; aControl: tMsMixerControl);
    procedure EnumTree;
    procedure RebuildMixers;
  public
    { Public declarations }
    property MixerIndex: Integer read GetMixerIndex;
  end;

var
  formMixMain: TformMixMain;

implementation

uses
  SysUtils, Graphics, CoreAPITools, uMPAbout;

{$R *.DFM}

procedure TformMixMain.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  fSysMixer := tMsMixerSystem.Create(Self);
  fMixers   := tObjectList.Create;
  with ComboBox1 do begin
    Clear;
    for i := 0 to fSysMixer.MixerCount - 1 do Items.Add(fSysMixer[i].MixerCaps.szPname);
    if (Items.Count > 0) then ItemIndex := 0;
  end;
end;

function BitsStr(aBits, aFlag: Cardinal; const aStr: string): string;
begin
  if ((aBits and aFlag) <> 0) then Result := ' [' + aStr + ']'
			      else Result := '';
end;

procedure TformMixMain.DisplayLine(aNode: tTreeNode; aCaps: pMixerLine);
var
  S: string;
begin
  with tvMain.Items, aCaps^ do begin
    AddChild(aNode, 'cbStruct - '      + IntToStr(cbStruct));
    AddChild(aNode, 'dwDestination - ' + IntToStr(dwDestination));
    AddChild(aNode, 'dwSource - '      + IntToStr(dwSource));
    AddChild(aNode, 'dwLineID - '      + IntToHex(dwLineID, 8));
    AddChild(aNode, 'fdwLine - '       + BitsStr (fdwLine, MIXERLINE_LINEF_ACTIVE,        'MIXERLINE_LINEF_ACTIVE') +
					 BitsStr (fdwLine, MIXERLINE_LINEF_DISCONNECTED , 'MIXERLINE_LINEF_DISCONNECTED') +
					 BitsStr (fdwLine, MIXERLINE_LINEF_SOURCE ,       'MIXERLINE_LINEF_SOURCE'));
    case dwComponentType of
      MIXERLINE_COMPONENTTYPE_DST_DIGITAL	: S := 'DST_DIGITAL';
      MIXERLINE_COMPONENTTYPE_DST_HEADPHONES	: S := 'DST_HEADPHONES';
      MIXERLINE_COMPONENTTYPE_DST_LINE		: S := 'DST_LINE';
      MIXERLINE_COMPONENTTYPE_DST_MONITOR	: S := 'DST_MONITOR';
      MIXERLINE_COMPONENTTYPE_DST_SPEAKERS	: S := 'DST_SPEAKERS';
      MIXERLINE_COMPONENTTYPE_DST_TELEPHONE	: S := 'DST_TELEPHONE';
      MIXERLINE_COMPONENTTYPE_DST_UNDEFINED	: S := 'DST_UNDEFINED';
      MIXERLINE_COMPONENTTYPE_DST_VOICEIN	: S := 'DST_VOICEIN';
      MIXERLINE_COMPONENTTYPE_DST_WAVEIN	: S := 'DST_WAVEIN';
      MIXERLINE_COMPONENTTYPE_SRC_ANALOG	: S := 'SRC_ANALOG';
      MIXERLINE_COMPONENTTYPE_SRC_AUXILIARY	: S := 'SRC_AUXILIARY';
      MIXERLINE_COMPONENTTYPE_SRC_COMPACTDISC	: S := 'SRC_COMPACTDISC';
      MIXERLINE_COMPONENTTYPE_SRC_DIGITAL	: S := 'SRC_DIGITAL';
      MIXERLINE_COMPONENTTYPE_SRC_LINE		: S := 'SRC_LINE';
      MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE	: S := 'SRC_MICROPHONE';
      MIXERLINE_COMPONENTTYPE_SRC_PCSPEAKER	: S := 'SRC_PCSPEAKER';
      MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER	: S := 'SRC_SYNTHESIZER';
      MIXERLINE_COMPONENTTYPE_SRC_TELEPHONE	: S := 'SRC_TELEPHONE';
      MIXERLINE_COMPONENTTYPE_SRC_UNDEFINED	: S := 'SRC_UNDEFINED';
      MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT	: S := 'SRC_WAVEOUT';
      else S := '<unknown>';
    end;
    AddChild(aNode, 'dwComponentType - ' + S);
    AddChild(aNode, 'dwUser - '          + IntToStr(dwUser));
    AddChild(aNode, 'cChannels - '       + IntToStr(cChannels));
    AddChild(aNode, 'cConnections - '    + IntToStr(cConnections));
    AddChild(aNode, 'cControls - '       + IntToStr(cControls));
    AddChild(aNode, 'szShortName - '     + szShortName);
    AddChild(aNode, 'szName - '          + szName);
    AddChild(aNode, 'Target.szPname - '  + Target.szPname);
  end;
end;

procedure TformMixMain.DisplayLineControl(aNode: tTreeNode; aControl: tMsMixerControl);
var
  i: Integer;
  S: string;
  C: Cardinal;
  N: tTreeNode;
begin
  with tvMain.Items, aControl.ControlCaps^ do begin
    AddChild(aNode, 'cbStruct - '    + IntToStr(cbStruct));
    AddChild(aNode, 'dwControlID - ' + IntToHex(dwControlID, 8));
    case dwControlType of
      MIXERCONTROL_CONTROLTYPE_CUSTOM	     : S := 'CONTROLTYPE_CUSTOM';
      MIXERCONTROL_CONTROLTYPE_BASS          : S := 'CONTROLTYPE_BASS';
      MIXERCONTROL_CONTROLTYPE_EQUALIZER     : S := 'CONTROLTYPE_EQUALIZER';
      MIXERCONTROL_CONTROLTYPE_FADER         : S := 'CONTROLTYPE_FADER';
      MIXERCONTROL_CONTROLTYPE_TREBLE        : S := 'CONTROLTYPE_TREBLE';
      MIXERCONTROL_CONTROLTYPE_VOLUME        : S := 'CONTROLTYPE_VOLUME';
      MIXERCONTROL_CONTROLTYPE_MIXER         : S := 'CONTROLTYPE_MIXER';
      MIXERCONTROL_CONTROLTYPE_MULTIPLESELECT: S := 'CONTROLTYPE_MULTIPLESELECT';
      MIXERCONTROL_CONTROLTYPE_MUX           : S := 'CONTROLTYPE_MUX';
      MIXERCONTROL_CONTROLTYPE_SINGLESELECT  : S := 'CONTROLTYPE_SINGLESELECT';
      MIXERCONTROL_CONTROLTYPE_BOOLEANMETER  : S := 'CONTROLTYPE_BOOLEANMETER';
      MIXERCONTROL_CONTROLTYPE_PEAKMETER     : S := 'CONTROLTYPE_PEAKMETER';
      MIXERCONTROL_CONTROLTYPE_SIGNEDMETER   : S := 'CONTROLTYPE_SIGNEDMETER';
      MIXERCONTROL_CONTROLTYPE_UNSIGNEDMETER : S := 'CONTROLTYPE_UNSIGNEDMETER';
      MIXERCONTROL_CONTROLTYPE_DECIBELS      : S := 'CONTROLTYPE_DECIBELS';
      MIXERCONTROL_CONTROLTYPE_PERCENT       : S := 'CONTROLTYPE_PERCENT';
      MIXERCONTROL_CONTROLTYPE_SIGNED        : S := 'CONTROLTYPE_SIGNED';
      MIXERCONTROL_CONTROLTYPE_UNSIGNED      : S := 'CONTROLTYPE_UNSIGNED';
      MIXERCONTROL_CONTROLTYPE_PAN           : S := 'CONTROLTYPE_PAN';
      MIXERCONTROL_CONTROLTYPE_QSOUNDPAN     : S := 'CONTROLTYPE_QSOUNDPAN';
      MIXERCONTROL_CONTROLTYPE_SLIDER        : S := 'CONTROLTYPE_SLIDER';
      MIXERCONTROL_CONTROLTYPE_BOOLEAN       : S := 'CONTROLTYPE_BOOLEAN';
      MIXERCONTROL_CONTROLTYPE_BUTTON        : S := 'CONTROLTYPE_BUTTON';
      MIXERCONTROL_CONTROLTYPE_LOUDNESS      : S := 'CONTROLTYPE_LOUDNESS';
      MIXERCONTROL_CONTROLTYPE_MONO          : S := 'CONTROLTYPE_MONO';
      MIXERCONTROL_CONTROLTYPE_MUTE          : S := 'CONTROLTYPE_MUTE';
      MIXERCONTROL_CONTROLTYPE_ONOFF         : S := 'CONTROLTYPE_ONOFF';
      MIXERCONTROL_CONTROLTYPE_STEREOENH     : S := 'CONTROLTYPE_STEREOENH';
      MIXERCONTROL_CONTROLTYPE_MICROTIME     : S := 'CONTROLTYPE_MICROTIME';
      MIXERCONTROL_CONTROLTYPE_MILLITIME     : S := 'CONTROLTYPE_MILLITIME';
      else begin
	S := '<unknown>';
	C := dwControlType;
	if (C > 1) then ;
      end;
    end;
    AddChild(aNode, 'dwControlType - '  + S);
    AddChild(aNode, 'fdwControl - '     + BitsStr(fdwControl, MIXERCONTROL_CONTROLF_DISABLED, 'CONTROLF_DISABLED') +
					  BitsStr(fdwControl, MIXERCONTROL_CONTROLF_MULTIPLE, 'CONTROLF_MULTIPLE') +
					  BitsStr(fdwControl, MIXERCONTROL_CONTROLF_UNIFORM,  'CONTROLF_UNIFORM'));
    AddChild(aNode, 'cMultipleItems - ' + IntToStr(cMultipleItems));
    AddChild(aNode, 'szShortName - '    + szShortName);
    AddChild(aNode, 'szName - '         + szName);
    N := AddChild(aNode, 'Details');
    AddChild(N, 'cbStruct - '       + IntToStr(aControl.ControlDetails.cbStruct));
    AddChild(N, 'cChannels - '      + IntToStr(aControl.ControlDetails.cChannels));
    AddChild(N, 'cMultipleItems - ' + IntToStr(aControl.ControlDetails.cMultipleItems));
    AddChild(N, 'cbDetails - '      + IntToStr(aControl.ControlDetails.cbDetails));
    if (aControl.ListTextItems.Count > 1) then begin
      N := AddChild(N, 'Line text');
      for i := 0 to aControl.ListTextItems.Count - 1 do
	AddChild(N, 'Line #' + IntToStr(i) + ' - ' + aControl.ListTextItems[i]);
    end;
  end;
end;

function TformMixMain.GetMixerIndex: Integer;
begin
  Result := ComboBox1.ItemIndex;
  if (Result >= Integer(fSysMixer.MixerCount)) then Result := fSysMixer.MixerCount - 1;
end;

procedure TformMixMain.FullExpand1Click(Sender: TObject);
begin
  tvMain.FullExpand;
end;

procedure TformMixMain.FullCollapse1Click(Sender: TObject);
begin
  tvMain.FullCollapse;
end;

procedure TformMixMain.Enum1Click(Sender: TObject);
begin
  EnumTree;
end;

procedure TformMixMain.EnumTree;
var
  i: Integer;
  j: Integer;
  k: Integer;
  z: Integer;
  N1: tTreeNode;
  N2: tTreeNode;
  N3: tTreeNode;
  N4: tTreeNode;
begin
  with tvMain.Items, fSysMixer do begin
    BeginUpdate;
    try
      Clear;
      N1 := AddChild(nil, 'Audio Mixers');
      for i := 0 to MixerCount - 1 do begin
	N2 := AddChild(AddChild(N1, fSysMixer[i].MixerCaps.szPname), 'Root lines');
	fSysMixer[i].EnumLines;
	for j := 0 to fSysMixer[i].LineCount - 1 do begin
	  N3 := AddChild(N2, 'Line #' + IntToStr(j));
	  DisplayLine(N3, fSysMixer[i][j].LineCaps);
	  fSysMixer[i][j].EnumSourceLines;
	  N3 := AddChild(N3, 'Source Lines:');
	  for k := 0 to fSysMixer[i][j].SourceLineCount - 1 do begin
	    N4 := AddChild(N3, 'Line #' + IntToStr(k));
	    DisplayLine(N4, fSysMixer[i][j][k].LineCaps);
	    fSysMixer[i][j][k].EnumControls;
	    N4 := AddChild(N4, 'Controls');
	    for z := 0 to fSysMixer[i][j][k].ControlCount - 1 do
	      DisplayLineControl(AddChild(N4, 'Conrol #' + IntToStr(z)), fSysMixer[i][j][k].ControlByIndex[z]);
	  end;
	  fSysMixer[i][j].EnumControls;
	  N3 := AddChild(N3.Parent, 'Controls:');
	  for z := 0 to fSysMixer[i][j].ControlCount - 1 do
	    DisplayLineControl(AddChild(N3, 'Conrol #' + IntToStr(z)), fSysMixer[i][j].ControlByIndex[z]);
	end;
      end;
    finally
      EndUpdate;
    end;
  end;
end;

procedure TformMixMain.FormShow(Sender: TObject);
begin
  RebuildMixers;
end;

procedure TformMixMain.RebuildMixers;
var
  i: Integer;
  lTS: tTabSheet;
  lMx: tvcMixer;
begin
  if (MixerIndex >= 0) then begin
    fMixers.Clear;
    while (pcMain.PageCount > 0) do pcMain.Pages[0].Free;
    fSysMixer[MixerIndex].EnumLines;
    for i := 0 to fSysMixer[MixerIndex].LineCount - 1 do begin
      lTS := tTabSheet.Create(Self);
      lTS.Caption := fSysMixer[MixerIndex][i].LineCaps.szName;
      lTS.PageControl := pcMain;
      lMx := tvcMixer.Create(Self);
      with lMx do begin
	MixerIndex := MixerIndex;
	ShowDisconnectedLines := CheckBox1.Checked;
	Align := alClient;
	LinesDestMode  := ldCustom;
	LineDest       := i;
	PeakMeterBias  := -8192;
	PeakMeterScale := 4;
	LineWidth      := 60;
      end;
      lTS.InsertControl(lMx);
      fMixers.Add(lMx);
      lMx.Open;
    end;
  end
  else InfoMessageBox('No mixer(s) available.', 'Information', MB_OK + MB_ICONINFORMATION, Handle);
end;

procedure TformMixMain.Button1Click(Sender: TObject);
begin
  RebuildMixers;
end;

procedure TformMixMain.Timer1Timer(Sender: TObject);
begin
  StatusBar1.Panels[0].Text := 'Mem: ' + Int2Str(AllocMemSize, '`');
end;

procedure TformMixMain.Button2Click(Sender: TObject);
begin
  formMPAbout.Show;
end;

procedure TformMixMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if CanClose then fMixers.Free;
end;

procedure TformMixMain.Button3Click(Sender: TObject);
begin
  Close;
end;

end.

