
{===============================================================}
{								}
{	Core API tools						}
{	a code by Lake Unanimated / unanimated@geocities.com	}
{								}
{								}
{	Copyright (c) 1999, 2000 Lake of Soft, Ltd		}
{	All Rights Reserved					}
{							       	}
{===============================================================}
{$B-}

unit CoreAPITools;

interface

uses
  Windows, SysUtils, Classes;

const
  CRLF	= #13#10;	// this is the key for any program :)

{$IFDEF VER110}
type
  LongWord	= Cardinal;

  {$DEFINE NO64}
  {$DEFINE VER_D4}

{$ENDIF}

{$IFDEF VER120}
  {$DEFINE VER_D4}
{$ENDIF}

{$IFDEF VER125}
  {$DEFINE VER_D4}
{$ENDIF}

type
  pBytes = ^tBytes;
  tBytes = array[0..High(Integer)-16] of Byte;

  // this record is used to store and access created file mappings
  tFileMappingRecord = record
    fFileHandle	: tHandle;
    fFileMapping: tHandle;
    fFileLength	: LongWord;
    case Integer of
      1: (fFileBase: Pointer);
      2: (fBytes   : pChar);
  end;

  tCharSet = set of Char;

  t_StringList = class(tStringList)
  private
    fMe: tStringList;
  public
    constructor Create;
    //
    property Me: tStringList read fMe;
  end;

// creates new file mapping (contents of file can be accessed by pointer);
//  aFileName -- file name to create mapping of;
//  aFMR -- if Result is true you can use aFMR.fFileBase to access file contents
function NewFileMapping(const aFileName: string; var aFMR: tFileMappingRecord): Boolean;

// this function frees up resources taken by NewFileMapping
function FreeFileMapping(var aFMR: tFileMappingRecord): Boolean;

// I have no time to test this function
function SeekBuf(Buf1: Pointer; Buf1Size: Integer; Buf2: Pointer; Buf2Size: Integer): Integer;

// fast way to seek a substring in string (or any buffer)
// aBuf -- pointer to buffer to seek in;
// aBufSize -- size of buffer;
// aStr -- substring to seek;
// IgnoreCase -- ignore or not the case (international characters not supported!);
//               (for binary seeking set this parameter to False);
// Result -- position in aBuf of firt occurance of aStr or -1 if none;
//           (0 means start of buffer);
function SeekStr(aBuf: Pointer; aBufSize: Integer; const aStr: string; IgnoreCase: Boolean): Integer;

const
  // change this in runtime, if you want
  regDefRoot 	  = 'Software\HammerSoft\Projects\';
  regRoot: string = regDefRoot;

//
const
  regRootKey: hKey = HKEY_CURRENT_USER;	// may change to something like HKEY_LOCAL_MACHINE

// used to read value from registry;
// aAppName -- application title (i.e. 'ASWS', 'Project1', ...);
//             it will be used to create registry key name: [HKEY_CURRENT_USER\regRoot\aAppName]
// aKeyName -- name of registry key to get (i.e. 'Settings', 'Form1\Left', ...);
//             (do not add '\' after key name!);
// aDefValue -- will be returned if key (aKeyName) does not exists;
// NOTE: key will NOT be created, use SetRegStr to do this.
function GetRegStr(const aAppName, aKeyName, aDefValue: string): string;

// used to write value to registry;
// aAppName -- application title (i.e. 'ASWS', 'Project1', ...);
//             it will be used to create registry key name: [HKEY_CURRENT_USER\regRoot\aAppName]
// aKeyName -- name of registry key to set (i.e. 'Settings', 'Form1\Left', ...);
// aKeyValue -- value to be set;
// if key doesn't exists, it will be created.
procedure SetRegStr(const aAppName, aKeyName, aKeyValue: string);

// like SetRegStr but works with integer
procedure SetRegInt(const aAppName, aKeyName: string; aKeyValue: Integer);

// like GetRegStr but works with integer
function GetRegInt(const aAppName, aKeyName: string; aDefValue: Integer): Integer;

// correctly adds '\' to the given path:
//   C:\temp\	=> C:\temp\
//   C:\temp	=> C:\temp\
//   C:\        => C:\
//   C:		=> C:
//   C:\temp/	=> C:\temp/
function AddBackSlash(const aPath: string): string;

// safetly converts a string to Integer;
// if error occured, then returns aDefValue
function Str2Int(const aStr: string; aDefValue: Integer; RemoveThousandsChar: Boolean = False): Integer;

// just reads all text from file
function ReadTextFile(const aFileName: string): string;

// adds string to text file
// (optionally adding CR LF after inserted line)
function AddTextToFile(const aFileName, aText: string; AddCRLF: Boolean = True): Boolean;

{added -d2000.05.06 : function AddBufToFile() }
function AddBufToFile(const aFileName: string; aData: Pointer; aSize: Cardinal; AddCRLF: Boolean = True): Boolean;

{added -d2000.03.11 : function WriteTextToFile() }
//
function WriteTextToFile(const aFileName, aText: string; aPos, aOrigin: Integer; AddCRLF: Boolean = True): Boolean;

{added -d2000.05.06 : function WriteBufToFile() }
function WriteBufToFile(const aFileName: string; aData: Pointer; aSize: Cardinal; aPos, aOrigin: Integer; AddCRLF: Boolean = True): Boolean;

// if A < B then result is A, else B
function Min(A, B: Integer): Integer;

// if A > B then result is A, else B
function Max(A, B: Integer): Integer;

// works more correctly with russian/ukranian dates
function Date2Str(const aDate: tDateTime): string;

// converts hexadecimal string into integer
function Hex2Int(const S: string): Integer;

// converts hexadecimal string into integer64
{$IFNDEF NO64}
function Hex2Int64(const S: string): Int64;
{$ENDIF}

//
function GoodHex(const S: string): Boolean;

// changes "unprintable" characters into #xx equialents
function Str2ASCII(const aStr: string): string;

// changes all #xx characters into real ones
function ASCII2Str(const aStr: string): string;

// will convert given date into string
function Date2EngStr(aDate: tDateTime): string;

// converts string to date
// NOTE: use only with strings created by Date2EngStr
function EngStr2Date(const aStr: string): Integer;

// encodes string into base64 format
function Base64Encode(const aInput: string): string;

// decodes string from base64 format
function Base64Decode(const aInput: string): string;

// sets user long data for window
procedure SetWindowULong(aHandle: tHandle; aLong: Integer);

// returns window (if any) having user data = ProgID
function FindWindowULong(ProgID: Integer): hWnd;

// returns the size of file
function FileSize(const FileName: string): LongWord;

{ deleted -d2000.02.26 : replaced with DirectoryExists( ) }
//
{function PathExists(const Path: string): Boolean;}

{ fixed -d2000.02.14 : added aFileAttrMask parameter }
//
function ScanPath(const Path, Masks: string; RecurseDirs: Boolean; aFileAttrMask: Integer = faReadOnly + faArchive): string;

//
function UnderNT: Boolean;

//
function GetTmpFolder: string;

{ deleted -d2000.02.26 : replaced with ForceDirectories( ) }
//
{function CreatePath(const DirectoryName: string): string;}

//
function ParseString(const aString: string; const Delimiters: tCharSet; OutStrings: tStrings): Integer;

//
function GetDefOutPath: string;

//
function RunProgram(const aExeName, aParams: string; aHidden: Boolean): Boolean;

{fixed -d2000.01.08 	: fixed some years bugs ( < 1600 )
			  also fixed 005 -> 0005 (not 2005) year convertion }
//
function FixDate(const aDate, aDelimiter: string; out GoodDate, LocalDate: string): Boolean;

{fixed -d2000.27.03	: added UseAscii2Str parameter }
//
function ReplaceTokens(const aData: string; aDelimChar: Char; aTokens: tStrings; strOpenChars: tCharSet; UseAscii2Str: Boolean = False): string;

//
function BoolStr(Switch: Boolean; const StrFalse, StrTrue: string): string;

//
function BestFitFromBeginning(const aStr, aList: string): Integer;

{added -d2000.01.08 : function Oem2Ansi() }
//
function Oem2Ansi(const aStr: string): string;

{added -d2000.01.19 : function InfoMessageBox() }
//
function InfoMessageBox(const aMessage, aTitle: string; aStyle: LongWord = MB_OK + MB_ICONINFORMATION; aHandle: hWnd = 0): Integer;

{added -d2000.01.24 : function FindSwitch() }
//
function FindSwitch(const Switch: string): Boolean;

{added -d2000.02.05 : function LocateFile() }
//
function LocateFile(const aBasePath, aFileName: string; CanCreate: Boolean = False): string;

{added -d2000.02.07 : function CurMaxToPercent() }
{fixed -d2000.04.22 : internal small fix }
//
function CurMaxToPercent(aCur, aMax: Integer): Integer;

{added -d2000.02.18 : function Int2Str() }
//
function Int2Str(aInt: Integer; aThousandsChar: Char = ' '): string;

{added -d2000.02.26 : DirectoryExists() }
// taken from FileCtrl
function DirectoryExists(const Name: string): Boolean;

{added -d2000.02.26 : ForceDirectories() }
{fixed -d2000.04.04 : converted into boolean function }
// taken from FileCtrl
function ForceDirectories(Dir: string): Boolean;

{added -d2000.03.11 : LocateFolder() }
{fxied -d2000.03.30 : inside fix }
//
function LocateFolder(const aBasePath, aFolderPath: string; CanCreate: Boolean = False): string;

{added -d2000.03.11 : CRC32() }
// taken from SPICore.pas
function CRC32(aData: Pointer; aSize: DWORD): LongWord;

{added -d2000.03.23 : Str2Float() }
//
function Str2Float(const aStr: string; const aDefValue: Extended): Extended;

{added -d2000.03.23 : Bool2Str() }
//
function Bool2Str(Value: Boolean): string;

{added -d2000.03.23 : Str2Bool() }
//
function Str2Bool(const aStr: string): Boolean;

{$IFDEF VER_D4}
{added -d2000.05.29 : AnsiSameText() for D4 compatibility }
function AnsiSameText(const S1, S2: string): Boolean;
{$ENDIF}

{==================>}
implementation

uses
  Registry;

{ t_StringList }

constructor t_StringList.Create;
begin
  inherited;
  fMe := Self;
end;

//
function GetRegStr(const aAppName, aKeyName, aDefValue: string): string;
begin
  Result := aDefValue;
  with tRegistry.Create do try
    RootKey := regRootKey;
    if OpenKey(regRoot + aAppName, False) then begin
      if ValueExists(aKeyName) then Result := ReadString(aKeyName);
      CloseKey;
    end;
  finally
    Free;
  end;
end;

//
procedure SetRegStr(const aAppName, aKeyName, aKeyValue: string);
begin
  with tRegistry.Create do try
    RootKey := regRootKey;
    if OpenKey(regRoot + aAppName, True) then begin
      WriteString(aKeyName, aKeyValue);
      CloseKey;
    end;
  finally
    Free;
  end;
end;

//
procedure SetRegInt(const aAppName, aKeyName: string; aKeyValue: Integer);
begin
  with tRegistry.Create do try
    RootKey := regRootKey;
    if OpenKey(regRoot + aAppName, True) then begin
      WriteInteger(aKeyName, aKeyValue);
      CloseKey;
    end;
  finally
    Free;
  end;
end;

//
function GetRegInt(const aAppName, aKeyName: string; aDefValue: Integer): Integer;
begin
  Result := aDefValue;
  with tRegistry.Create do try
    RootKey := regRootKey;
    if OpenKey(regRoot + aAppName, False) then begin
      if ValueExists(aKeyName) then Result := ReadInteger(aKeyName);
      CloseKey;
    end;
  finally
    Free;
  end;
end;

//
function NewFileMapping(const aFileName: string; var aFMR: tFileMappingRecord): Boolean;
begin
  Result := False;
  with aFMR do begin
    fFileHandle := CreateFile(PChar(aFileName), GENERIC_READ, FILE_SHARE_READ + FILE_SHARE_WRITE, nil, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    if (fFileHandle <> INVALID_HANDLE_VALUE) then begin
      fFileMapping := CreateFileMapping(fFileHandle, nil, PAGE_READONLY, 0, 0, nil);
      if (fFileMapping <> 0) then begin
	fFileBase := MapViewOfFile(fFileMapping, FILE_MAP_READ, 0, 0, 0);
	Result := (fFileBase <> nil);
	if Result then fFileLength := FileSeek(fFileHandle, 0, 2);
      end;
    end;
  end;
end;

//
function FreeFileMapping(var aFMR: tFileMappingRecord): Boolean;
begin
  Result := False;
  with aFMR do
    if (fFileHandle <> INVALID_HANDLE_VALUE) then begin
      UnmapViewOfFile(fFileBase);
      CloseHandle(fFileMapping);
      CloseHandle(fFileHandle);
      Result := True;
    end;
  if Result then FillChar(aFMR, SizeOf(aFMR), #0);
end;

// 
function SeekBuf(Buf1: Pointer; Buf1Size: Integer; Buf2: Pointer; Buf2Size: Integer): Integer;
var
  Pos1 : Integer;
  Found: Boolean;
begin
  Result := -1;		// not found
  if (Buf2Size <= Buf1Size) then begin
    asm
	cld
    end;
    Pos1 := 0;
    while (Pos1 <= Buf1Size - Buf2Size) do begin
      asm
	push	edi
	push	esi
	push	ecx

	mov	ecx, Buf2Size
	mov	edi, Buf1
	mov	esi, Buf2
	add	edi, Pos1

	repz	cmpsb

	mov	Found, False
	jnz     @Skip

	or	ecx, ecx
	jnz	@Skip

	mov	Found, True
  @Skip:

	pop	ecx
	pop     esi
	pop	edi
      end;
      if Found then Break;
      Inc(Pos1);
    end;
    if Found then Result := Pos1;
  end;
end;

//
function SeekStr(aBuf: Pointer; aBufSize: Integer; const aStr: string; IgnoreCase: Boolean): Integer;
var
  P : pChar;
  i : Integer;
  j : Integer;
  M : Integer;
  OK: Boolean;
begin
  P := pChar(aBuf);
  i := 0;	// pos in aBuf
  j := 0;	// size of mached bytes
  M := Length(aStr);
  while (j < M) and (i < aBufSize) do begin
    if IgnoreCase then OK := (UpCase(P[i]) = UpCase(aStr[j + 1]))
		  else OK := (P[i] = aStr[j + 1]);
    if OK then Inc(j)
	  else j := 0;
    Inc(i);
  end;
  if (j = M) then Result := i - M// - 1 a bug?
	     else Result := -1;
end;

//
function AddBackSlash(const aPath: string): string;
var
  L: Integer;
begin
  Result := Trim(aPath);
  L := Length(Result);
  if (L > 0) then
    if not (Result[L] in ['/', '\', ':']) then Result := Result + '\';
end;

//
function Str2Int(const aStr: string; aDefValue: Integer; RemoveThousandsChar: Boolean{ = False}): Integer;
var
  lC: Integer;
  lS: string;
   i: Integer;
begin
  lS := Trim(aStr);
  Result := aDefValue;
  if (lS <> '') then begin
    if RemoveThousandsChar then begin
      i := Length(lS) - 3;
      while (i > 1) do begin
	Delete(lS, i, 1);
	Dec(i, 4);
      end;
    end;
    Val(Trim(lS), Result, lC);
    if (lC <> 0) then Result := aDefValue;
  end;
end;

//
function ReadTextFile(const aFileName: string): string;
var
  lF: Integer;
  lZ: Integer;
begin
  lF := FileOpen(aFileName, fmOpenRead + fmShareDenyNone);
  if (lF > 0) then begin
    lZ := FileSeek(lF, 0, 2);
    FileSeek(lF, 0, 0);
    SetLength(Result, lZ);
    if (lZ > 0) then FileRead(lF, Result[1], lZ);
  end
  else Result := '';
  FileClose(lF);
end;

//
function AddTextToFile(const aFileName, aText: string; AddCRLF: Boolean{ = True}): Boolean;
begin
  Result := WriteTextToFile(aFileName, aText, 0, 2, AddCRLF);
end;

function AddBufToFile(const aFileName: string; aData: Pointer; aSize: Cardinal; AddCRLF: Boolean{ = True}): Boolean;
begin
  Result := WriteBufToFile(aFileName, aData, aSize, 0, 2, AddCRLF);
end;

function WriteTextToFile(const aFileName, aText: string; aPos, aOrigin: Integer; AddCRLF: Boolean{ = True}): Boolean;
begin
  Result := WriteBufToFile(aFileName, Pointer(aText), Length(aText), aPos, aOrigin, AddCRLF);
end;

function WriteBufToFile(const aFileName: string; aData: Pointer; aSize: Cardinal; aPos, aOrigin: Integer; AddCRLF: Boolean{ = True}): Boolean;
const
  lS: string = #13#10;
var
  lF: Integer;
begin
  Result := False;
  if FileExists(aFileName) then lF := FileOpen(aFileName, fmOpenWrite + fmShareDenyNone)
			   else lF := FileCreate(aFileName);
  if (lF >= 0) then try
    FileSeek(lF, aPos, aOrigin);
    Result := (FileWrite(lF, aData^, aSize) = Integer(aSize));
    if AddCRLF then Result := Result and (FileWrite(lF, lS[1], 2) = 2);
  finally
    FileClose(lF);
  end;
end;

//
function Min(A{eax}, B{edx}: Integer):{eax} Integer;
begin
  if (A < B) then Result := A
	     else Result := B;
{asm
	cmp	eax, edx
	jbe	@exit
	mov	eax, edx
  @exit:}
end;

//
function Max(A{eax}, B{edx}: Integer):{eax} Integer;
begin
  if (A > B) then Result := A
	     else Result := B;
{asm
	cmp	eax, edx
	jae	@exit
	mov	eax, edx
  @exit:}
end;

//
function Date2Str(const aDate: tDateTime{; const aMask: string}): string;
var
  lST: tSystemTime;
  lY,
  lM,
  lD: Word;
  lB: array[0..255] of Char;
begin
  DecodeDate(aDate, lY, lM, lD);
  lST.wYear  := lY;
  lST.wMonth := lM;
  lST.wDay   := lD;
  if (GetDateFormat({LOCALE_SYSTEM_DEFAULT} GetThreadLocale, DATE_LONGDATE, @lST, nil, lB, 255) > 0) then Result := lB
                                                                                                     else Result := '';
end;

function HexD(C: Char): Byte;
begin
  case UpCase(C) of
    '0'..'9': Result := Ord(C) - Ord('0');
    'A'..'F': Result := Ord(UpCase(C)) - Ord('A') + 10;
    else Result := 0;
  end;
end;

//
function Hex2Int(const S: string): Integer;
var
  H: string;
  M: Integer;
begin
  H := Trim(S);
  M := Length(H);
  Result := 0;
  while (M > 0) do begin
    Result := Result + HexD(H[Length(H) - M + 1]) shl ((M - 1) shl 2);
    Dec(M);
  end;
end;

{$IFNDEF NO64}
function Hex2Int64(const S: string): Int64;
var
  H: string;
  M: Integer;
begin
  H := Trim(S);
  M := Length(H);
  Result := 0;
  while (M > 0) do begin
	Result := Result + HexD(H[Length(H) - M + 1]) shl ((M - 1) shl 2);
	Dec(M);
  end;
end;
{$ENDIF}

function GoodHex(const S: string): Boolean;
var
  i: Integer;
begin
  Result := (S <> '');
  if Result then
    for i := 1 to Length(S) do
      if not (UpCase(S[i]) in ['0'..'9', 'A'..'Z']) then begin
	Result := False;
	Break;
      end;
end;

function Str2ASCII(const aStr: string): string;
var
  i: Integer;
  j: Integer;
  B: Boolean;
  LS: Integer;
begin
  Result := '';
  LS := Length(aStr);
  j := 1;
  B := False;
  repeat
    B := not B;
    i := j;
    while (j <= LS) and ((aStr[j] in [#00..#31, '#']) xor B) do Inc(j);
    if (j > i) then
      if B then Result := Result + Copy(aStr, i, j - i)
      else
	for i := i to j - 1 do
	  Result := Result + '#' + IntToHex(Byte(aStr[i]), 2);
  until (j >= LS);
end;

function ASCII2Str(const aStr: string): string;
var
  i: Integer;
  j: Integer;
  LS: Integer;
begin
  Result := '';
  j  := 1;
  LS := Length(aStr);
  while (j <= LS) do begin
    i := j;
    while (j <= LS) and (aStr[j] <> '#') do Inc(j);
    if (j > i) then Result := Result + Copy(aStr, i, j - i);
    if (j + 2 <= Length(aStr)) then begin
      Result := Result + Char(Hex2Int(aStr[j + 1] + aStr[j + 2]));
      Inc(j, 2);
    end;
    Inc(j);
  end;
end;

const
  MonthStr = 'JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC';

function Date2EngStr(aDate: tDateTime): string;
var
  lY,
  lM,
  lD: Word;
begin
  DecodeDate(aDate, lY, lM, lD);
  Result := IntToStr(lD) + ' ' + Copy(MonthStr, (lM - 1) * 3 + 1, 3) + ' ' + IntToStr(lY);
end;

function EngStr2Date(const aStr: string): Integer;
var
  lD,
  lM,
  lY: Integer;
begin
  lD := Str2Int(Copy(aStr, 1, 2), 0);
  lM := Pos(Copy(aStr, Pos(' ', aStr) + 1, 3), MonthStr) div 3 + 1;
  lY := Str2Int(Copy(aStr, Pos(' ', aStr) + 1 + 3 + 1, Length(aStr)), 0);
  Result := Trunc(EncodeDate(lY, lM, lD));
end;

function Base64Encode(const aInput: string): string;
const
  Base64: string[64] = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
var
  L: Integer;
  Z: Integer;
  P: string;
  j: Integer;
  i: Integer;
begin
  Result := '';
  i := 1;
  Z := Length(aInput);
  while (i <= Z) do begin
    P := '';
    L := Ord(aInput[i]) shl 16;
    Inc(i);
    if (i <= Z) then begin
      L := L + Ord(aInput[i]) shl 8;
      Inc(i);
      if (i <= Z) then L := L + Ord(aInput[i])
		  else P := '=';
    end
    else P := '==';
    for j := 1 to 4 - Length(P) do begin
      Result := Result + Base64[(L and $FC0000) shr 18 + 1];
      L := L shl 6;
    end;
    Result := Result + P;
    if (P <> '') then Break;
    Inc(i);
  end;
end;

function Char2Int(C: Char): Integer;
begin
  case C of
    'A'..'Z': Result := Ord(C) - Ord('A');
    'a'..'z': Result := Ord(C) - Ord('a') + 26;
    '0'..'9': Result := Ord(C) - Ord('0') + 52;
    '+'     : Result := 62;
    else      Result := 63;
  end;
end;

function Base64Decode(const aInput: string): string;
var
  Z: Integer;
  L: Integer;
  i: Integer;
  j: Integer;
  V: Byte;
begin
  //
  Result := '';
  i := 1;
  Z := Length(aInput);
  while (i <= Z) do begin
    V := 3;
    L := Char2Int(aInput[i]) shl 18;
    Inc(i);
    if (i <= Z) then begin
      L := L + Char2Int(aInput[i]) shl 12;
      Inc(i);
      {$B-}
      if (i <= Z) and (aInput[i] <> '=') then begin
	L := L + Char2Int(aInput[i]) shl 6;
	Inc(i);
	if (i <= Z) and (aInput[i] <> '=') then L := L + Char2Int(aInput[i])
	else V := 2	// only two chars are valid
      end
      else V := 1;	// only first is valid
    end
    else V := 0;	// not valid at all
    for j := 1 to V do begin
      Result := Result + Chr((L and $FF0000) shr 16);
      L := L shl 8;
    end;
    Inc(i);
    if (V <> 3) then Break;
  end;
end;

//
procedure SetWindowULong(aHandle: tHandle; aLong: Integer);
begin
  SetWindowLong(aHandle, GWL_USERDATA, aLong);
end;

//
type
  phWnd = ^hWnd;

var
  MyID: Integer;

function EnumFunc(Wnd: hWnd; lParam: phWnd): Bool; stdcall;
var
  lID: Integer;
begin
  lID := GetWindowLong(Wnd, GWL_USERDATA);
  if (lID = MyID) then begin
    lParam^ := Wnd;
    Result  := False;
  end
  else Result := True;
end;

//
function FindWindowULong(ProgID: Integer): hWnd;
begin
  MyID   := ProgID;
  Result := 0;
  EnumWindows(@EnumFunc, Integer(@Result));
end;

//
function FileSize(const FileName: string): LongWord;
var
  H: tHandle;
begin
  Result := 0;
  H := FileOpen(FileName, fmOpenRead + fmShareDenyNone);
  if (H <> INVALID_HANDLE_VALUE) then begin
    Result := FileSeek(H, 0, FILE_END);
    FileClose(H);
  end;
end;

//
{function PathExists(const Path: string): Boolean;
var
  Handle  : tHandle;
  FindData: tWin32FindData;
  lPath   : string;
begin
  lPath := Path;
  if (lPath <> '') and (lPath[Length(lPath)] in ['\', '/']) then Delete(lPath, Length(lPath), 1);
  Handle := FindFirstFile(pChar(lPath), FindData);
  if (Handle <> INVALID_HANDLE_VALUE) then begin
    Windows.FindClose(Handle);
    Result := ((FindData.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY) <> 0);
  end
  else Result := False;
end;}

//
function ScanPath(const Path, Masks: string; RecurseDirs: Boolean; aFileAttrMask: Integer{ = faReadOnly + faArchive}): string;
var
{$IFDEF NO64}
  lMasks: tStringList;
{$ELSE}
  lMasks: array of string;
{$ENDIF}

  procedure AddMask(const aMask: string);
  {$IFNDEF NO64}
  var
    L: Integer;
  {$ENDIF}
  begin
    {$IFDEF NO64}
    lMasks.Add(Trim(aMask));
    {$ELSE}
    L := Length(lMasks);
    SetLength(lMasks, L + 1);
    lMasks[L] := Trim(aMask);
    {$ENDIF}
  end;

  procedure ScanDir(const Directory: string; GoSubDirs: Boolean);
  var
    i : Integer;
    F : tSearchRec;
    OK: Integer;
    lD: string;
    lIncludeDir: Boolean;
  begin
    lD := AddBackSlash(Directory);
    // scan dirs
    if GoSubDirs then begin
      OK := FindFirst(lD + '*.*', faDirectory, F);
      try
	while (OK = 0) do begin
	  if (F.Name <> '.') and (F.Name <> '..') and ((faDirectory and F.Attr) <> 0) then ScanDir(lD + F.Name, True);
	  OK := FindNext(F);
	end;
      finally
	FindClose(F);
      end;
    end;
    // scan files
    lIncludeDir := ((aFileAttrMask and faDirectory) <> 0);
    for i := 0 to {$IFDEF NO64} lMasks.Count - 1 {$ELSE} Length(lMasks) - 1 {$ENDIF} do begin
      OK := FindFirst(lD + lMasks[i], aFileAttrMask, F);
      try
	while (OK = 0) do begin
	  if ((F.Attr and aFileAttrMask) <> 0) then
	    if (lIncludeDir and (F.Name <> '.') and (F.Name <> '..')) or
	      not lIncludeDir then Result := Result + lD + F.Name + #13#10;
	  OK := FindNext(F);
	end;
      finally
	FindClose(F);
      end;
    end;
  end;

var
  lM: string;
  lP: Integer;
begin
  {$IFDEF NO64}
  lMasks := tStringList.Create;
  {$ELSE}
  FillChar(lMasks, SizeOf(lMasks), #0);
  {$ENDIF}
  lM := Trim(Masks);
  repeat
    lP := Pos(#6, lM);
    if (lP > 0) then begin
      AddMask(Copy(lM, 1, lP - 1));
      Delete(lM, 1, lP);
    end
    else AddMask(lM);
  until (lP <= 0) or (lM = '');
  Result := '';
  ScanDir(Path, RecurseDirs);
  {$IFDEF NO64}
  lMasks.Free;
  {$ELSE}
  lMasks := nil;
  {$ENDIF}
end;

function UnderNT: Boolean;
begin
  Result := (GetVersion and $80000000 = 0);
end;

function GetTmpFolder: string;
var
  P: array[0..MAX_PATH] of Char;
begin
  GetTempPath(MAX_PATH, P);
  Result := P;
end;

{function CreatePath(const DirectoryName: string): string;
begin
  Result := DirectoryName;
  if PathExists(DirectoryName) then
  else
    if CreateDirectory(pChar(DirectoryName), nil) then
						  else Result := '';
end;}

function ParseString(const aString: string; const Delimiters: tCharSet; OutStrings: tStrings): Integer;
var
  i: Integer;
  W: string;
begin
  OutStrings.Clear;
  W := '';
  i := 1;
  while (i <= Length(aString)) do begin
    if (aString[i] in Delimiters) then begin
      OutStrings.Add(W);
      W := '';
      while (aString[i] in Delimiters) and (i < Length(aString)) do Inc(i);
      if (i <= Length(aString)) then Dec(i);
    end
    else W := W + aString[i];
    Inc(i);
  end;
  if (W <> '') then OutStrings.Add(W);
  Result := OutStrings.Count;
end;

function GetDefOutPath: string;
begin
  Result := '';
  // HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders - Personal
  // HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders - Personal
  with tRegistry.Create do try
    // default root it HCU
    if OpenKey('SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False) then
      if ValueExists('Personal') then Result := ReadString('Personal');
    if (Trim(Result) = '') then
      if OpenKey('SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders', False) then
	if ValueExists('Personal') then Result := ReadString('Personal');
  finally
    Free;
  end;
  if (Trim(Result) = '') then Result := GetTmpFolder;
end;

//
function RunProgram(const aExeName, aParams: string; aHidden: Boolean): Boolean;
var
  lS : string;
  lSI: tStartupInfo;
  lPI: tProcessInformation;
begin
  lSI.cb := SizeOf(lSI);
  lSI.dwFlags := STARTF_USESHOWWINDOW;
  if aHidden then lSI.wShowWindow := SW_HIDE
	     else lSI.wShowWindow := SW_SHOWNORMAL;
  lS := Trim(aExeName + ' ' + aParams);
  Result := CreateProcess(nil, {'C:\COMMAND.COM'}pChar(lS), nil, nil, False, 0, nil, 'C:\', lSI, lPI);
end;

//
function FixDate(const aDate, aDelimiter: string; out GoodDate, LocalDate: string): Boolean;
// default format:
//   D[D] M[M] YY[YY]
// valid formats:
//   D[D] M[M] YY[YY]
//   M[M] D[D] YY[YY]
var
  i: Integer;
  W,
  D,
  M,
  Y: Integer;
  _D, _M, _Y: Word;
  lYearLeadZeros: Boolean;
  S: string;
  Z: string;
  T: tDateTime;
begin
  Result := False;
  S := Trim(aDate) + ' ';
  D := -1;
  M := -1;
  Y := -1;
  if (S <> '') then begin
    i := 1;
    Z := '';
    lYearLeadZeros := False;
    while (i <= Length(S)) do begin
      if (S[i] in ['0'..'9']) then Z := Z + S[i]
      else
	if (Z = '') then
	else begin
	  if (D < 0) then D := Str2Int(Z, -1) else
	  if (M < 0) then M := Str2Int(Z, -1)
	  else begin
	    Y := Str2Int(Z, -1);
	    lYearLeadZeros := (Length(Trim(Z)) > 2);
	    Break;
	  end;
	  Z := '';
	end;
      Inc(i);
    end;
    if (D > 0) and (M > 0) and (Y >= 0) then begin
      if (M > 12) then begin  // swap mounth and date
	W := M;
	M := D;
	D := W;
      end;
      if (Y < 100) and not lYearLeadZeros then begin
	DecodeDate(Date, _Y, _M, _D);
	if ((_Y mod 100) > 50) then	// if current year > xx50
	  if (Y < 10) then Y := Y + (_Y div 100) * 100 + 100	// in 1998, 02 -> 2002
		      else Y := Y + (_Y div 100) * 100		// in 1998, 17 -> 1917
	else
	  if (Y > 50) then Y := Y + (_Y div 100) * 100 - 100	// in 2030, 98 -> 1998
		      else Y := Y + (_Y div 100) * 100          // in 2047, 33 -> 2033
      end;
      T := Date;
      try
	T := EncodeDate(Y, M, D);
	W := 1;
      except
	W := -1;
      end;
      if (W > 0) then begin
	GoodDate := IntToStr(D) + aDelimiter + IntToStr(M) + aDelimiter + IntToStr(Y);
	if (Y > 1600) then LocalDate := Date2Str(T)
		      else DateTimeToString(LocalDate, LongDateFormat, T);
	Result   := True;
      end;
    end;
  end;
end;

//
function ReplaceTokens(const aData: string; aDelimChar: Char; aTokens: tStrings; strOpenChars: tCharSet; UseAscii2Str: Boolean{ = False}): string;
var
  i: Integer;
  V: Integer;
  K: Char;
  S: string;
begin
  //
  i := 1;
  V := -1;
  K := ' ';
  Result := '';
  while (i <= Length(aData)) do begin
    if (K <> ' ') then
      if (aData[i] = K) then K := ' '	// at end of string
      else				// we still inside of string
    else
      if (aData[i] = aDelimChar) then
	if (V > 0) then begin	// we found %xxx% var
	  S := Copy(aData, V + 1, i - V - 1);
	  if UseAscii2Str then Result := Result + Ascii2Str(aTokens.Values[S])
			  else Result := Result + aTokens.Values[S];
	  V := -1;
	  Inc(i);
	  Continue;
	end
	else begin	// at start of %xxx var
	  V := i;
	  Inc(i);
	  Continue;
	end
      else
	if (aData[i] in StrOpenChars) then K := aData[i];	// at start of string
    if (V < 0) then Result := Result + aData[i];
    Inc(i);
  end;
end;

//
function BoolStr(Switch: Boolean; const StrFalse, StrTrue: string): string;
begin
  if Switch then Result := StrTrue
	    else Result := StrFalse;
end;

//
function BestFitFromBeginning(const aStr, aList: string): Integer;
var
  j: Integer;
begin
  Result := -1;
  if (aStr <> '') then
    with tStringList.Create do try
      Text := aList;
      // remember original order
      for j := 0 to Count - 1 do Objects[j] := Pointer(j);
      Sort;
      for j := Count - 1 downto 0 do
	if (Strings[j] <> '') and (Pos(Strings[j], aStr) = 1) then begin
	  Result := Integer(Objects[j]);
	  Break;
	end;
    finally
      Free;
    end;
end;

//
function Oem2Ansi(const aStr: string): string;
var
  P: pChar;
begin
  if (Length(aStr) > 0) then begin
    P := AllocMem(Length(aStr) + 1);
    try
      if OemToChar(pChar(aStr), P) then Result := P;
    finally
      ReallocMem(P, 0);
    end;
  end
  else Result := '';
end;

//
function InfoMessageBox(const aMessage, aTitle: string; aStyle: LongWord{ = MB_OK + MB_ICONINFORMATION}; aHandle: hWnd{ = 0}): Integer;
begin
  Result := MessageBox(aHandle, pChar(aMessage), pChar(aTitle), aStyle);
end;

//
function FindSwitch(const Switch: string): Boolean;
begin
  Result := FindCmdLineSwitch(Switch, ['-', '/'], True);
end;

//
function LocateFile(const aBasePath, aFileName: string; CanCreate: Boolean{ = False}): string;
var
  lBP: string;
  lFH: Integer;
begin
  if (Trim(aFileName) <> '') then begin
    lBP := AddBackSlash(aBasePath);
    if ((Pos('.\', aFileName) = 1) or (Pos('./', aFileName) = 1)) then Result := lBP + Copy(aFileName, 3, Length(aFileName))
    else
      if (aFileName[1] in ['\', '/']) then Result := lBP[1] + ':' + aFileName
				      else Result := lBP + aFileName;
    if not FileExists(Result) then
      if CanCreate then begin
	lFH := FileCreate(Result);
	if (lFH = -1) then Result := aFileName
		      else FileClose(lFH);
      end
      else Result := aFileName;
  end
  else Result := '';
end;

//
function CurMaxToPercent(aCur, aMax: Integer): Integer;
begin
  if (aMax <> 0) and (aCur < aMax) then Result := (100 * Abs(aCur)) div Abs(aMax)
		                   else Result := 100;
end;

//
function Int2Str(aInt: Integer; aThousandsChar: Char{ = ' '}): string;
var
  i: Integer;
begin
  Result := IntToStr(aInt);
  if (aThousandsChar <> ' ') then begin
    i := Length(Result) - 3;
    while (i >= 1) do begin
      Insert(aThousandsChar, Result, i + 1);
      Dec(i, 3);
    end;
  end;
end;

//
function DirectoryExists(const Name: string): Boolean;
var
  Code: Integer;
begin
  Code := GetFileAttributes(PChar(Name));
  Result := (Code <> -1) and (Code and FILE_ATTRIBUTE_DIRECTORY <> 0);
end;

//
function ForceDirectories(Dir: string): Boolean;
begin
  if (Dir <> '') then begin
    if (AnsiLastChar(Dir) <> nil) and (AnsiLastChar(Dir)^ = '\') then Delete(Dir, Length(Dir), 1);
    if (Length(Dir) < 3) or DirectoryExists(Dir) or (ExtractFilePath(Dir) = Dir) then begin
      Result := True;
      Exit; // avoid 'xyz:\' problem.
    end;
    Result := ForceDirectories(ExtractFilePath(Dir));
    if Result then Result := CreateDir(Dir);
  end
  else Result := True;
end;

//
function LocateFolder(const aBasePath, aFolderPath: string; CanCreate: Boolean{ = False}): string;
var
  lBP: string;
begin
  if (Trim(aFolderPath) <> '') then begin
    if (Trim(aBasePath) <> '') then lBP := aBasePath
			       else lBP := GetCurrentDir;
    lBP := AddBackSlash(lBP);
    if ((Pos('.\', aFolderPath) = 1) or (Pos('./', aFolderPath) = 1)) then Result := lBP + Copy(aFolderPath, 3, Length(aFolderPath))
    else
      if (aFolderPath[1] in ['\', '/']) then Result := lBP[1] + ':' + aFolderPath
					else Result := lBP + aFolderPath;
    if not DirectoryExists(Result) and CanCreate then ForceDirectories(Result);
    {fixed -d2000.03.30 : inside bug }
    if not DirectoryExists(Result) then Result := aFolderPath;
  end
  else Result := '';
end;

//
{
  based on CRC32Calc() function taken from Version Information component

  VERSION INFORMATION V1.3b (c) 1998 by Alexander Burlakov aka Hunter
			       E-mail: Hunter@hptmts.tvcom.ru
			       URL: http://www.chat.ru/~hunterml/
}
function CRC32(aData: Pointer; aSize: DWORD): LongWord;
var
  R: DWORD;
begin
  asm
	push	eax
	push	ebx
	push	ecx
	push	edx

	mov	eax, -1
	mov	edx, aData
	mov	ecx, aSize

	or	edx, edx	// no data?
	je      @GoExit

	jecxz   @GoExit		// no size?

  @Loop:
	movzx	ebx, al
	xor	bl, [edx]
	shr	eax, 8
	and	eax, 00FFFFFFh
	xor	eax, cs:[ebx + offset @CRC32Table]
	inc	edx
	loop	@Loop

  @GoExit:
	jmp	@Exit

  @CRC32Table:

DD 000000000h, 077073096h, 0ee0e612ch, 0990951bah
DD 0076dc419h, 0706af48fh, 0e963a535h, 09e6495a3h
DD 00edb8832h, 079dcb8a4h, 0e0d5e91eh, 097d2d988h
DD 009b64c2bh, 07eb17cbdh, 0e7b82d07h, 090bf1d91h
DD 01db71064h, 06ab020f2h, 0f3b97148h, 084be41deh
DD 01adad47dh, 06ddde4ebh, 0f4d4b551h, 083d385c7h
DD 0136c9856h, 0646ba8c0h, 0fd62f97ah, 08a65c9ech
DD 014015c4fh, 063066cd9h, 0fa0f3d63h, 08d080df5h
DD 03b6e20c8h, 04c69105eh, 0d56041e4h, 0a2677172h
DD 03c03e4d1h, 04b04d447h, 0d20d85fdh, 0a50ab56bh
DD 035b5a8fah, 042b2986ch, 0dbbbc9d6h, 0acbcf940h
DD 032d86ce3h, 045df5c75h, 0dcd60dcfh, 0abd13d59h
DD 026d930ach, 051de003ah, 0c8d75180h, 0bfd06116h
DD 021b4f4b5h, 056b3c423h, 0cfba9599h, 0b8bda50fh
DD 02802b89eh, 05f058808h, 0c60cd9b2h, 0b10be924h
DD 02f6f7c87h, 058684c11h, 0c1611dabh, 0b6662d3dh
DD 076dc4190h, 001db7106h, 098d220bch, 0efd5102ah
DD 071b18589h, 006b6b51fh, 09fbfe4a5h, 0e8b8d433h
DD 07807c9a2h, 00f00f934h, 09609a88eh, 0e10e9818h
DD 07f6a0dbbh, 0086d3d2dh, 091646c97h, 0e6635c01h
DD 06b6b51f4h, 01c6c6162h, 0856530d8h, 0f262004eh
DD 06c0695edh, 01b01a57bh, 08208f4c1h, 0f50fc457h
DD 065b0d9c6h, 012b7e950h, 08bbeb8eah, 0fcb9887ch
DD 062dd1ddfh, 015da2d49h, 08cd37cf3h, 0fbd44c65h
DD 04db26158h, 03ab551ceh, 0a3bc0074h, 0d4bb30e2h
DD 04adfa541h, 03dd895d7h, 0a4d1c46dh, 0d3d6f4fbh
DD 04369e96ah, 0346ed9fch, 0ad678846h, 0da60b8d0h
DD 044042d73h, 033031de5h, 0aa0a4c5fh, 0dd0d7cc9h
DD 05005713ch, 0270241aah, 0be0b1010h, 0c90c2086h
DD 05768b525h, 0206f85b3h, 0b966d409h, 0ce61e49fh
DD 05edef90eh, 029d9c998h, 0b0d09822h, 0c7d7a8b4h
DD 059b33d17h, 02eb40d81h, 0b7bd5c3bh, 0c0ba6cadh
DD 0edb88320h, 09abfb3b6h, 003b6e20ch, 074b1d29ah
DD 0ead54739h, 09dd277afh, 004db2615h, 073dc1683h
DD 0e3630b12h, 094643b84h, 00d6d6a3eh, 07a6a5aa8h
DD 0e40ecf0bh, 09309ff9dh, 00a00ae27h, 07d079eb1h
DD 0f00f9344h, 08708a3d2h, 01e01f268h, 06906c2feh
DD 0f762575dh, 0806567cbh, 0196c3671h, 06e6b06e7h
DD 0fed41b76h, 089d32be0h, 010da7a5ah, 067dd4acch
DD 0f9b9df6fh, 08ebeeff9h, 017b7be43h, 060b08ed5h
DD 0d6d6a3e8h, 0a1d1937eh, 038d8c2c4h, 04fdff252h
DD 0d1bb67f1h, 0a6bc5767h, 03fb506ddh, 048b2364bh
DD 0d80d2bdah, 0af0a1b4ch, 036034af6h, 041047a60h
DD 0df60efc3h, 0a867df55h, 0316e8eefh, 04669be79h
DD 0cb61b38ch, 0bc66831ah, 0256fd2a0h, 05268e236h
DD 0cc0c7795h, 0bb0b4703h, 0220216b9h, 05505262fh
DD 0c5ba3bbeh, 0b2bd0b28h, 02bb45a92h, 05cb36a04h
DD 0c2d7ffa7h, 0b5d0cf31h, 02cd99e8bh, 05bdeae1dh
DD 09b64c2b0h, 0ec63f226h, 0756aa39ch, 0026d930ah
DD 09c0906a9h, 0eb0e363fh, 072076785h, 005005713h
DD 095bf4a82h, 0e2b87a14h, 07bb12baeh, 00cb61b38h
DD 092d28e9bh, 0e5d5be0dh, 07cdcefb7h, 00bdbdf21h
DD 086d3d2d4h, 0f1d4e242h, 068ddb3f8h, 01fda836eh
DD 081be16cdh, 0f6b9265bh, 06fb077e1h, 018b74777h
DD 088085ae6h, 0ff0f6a70h, 066063bcah, 011010b5ch
DD 08f659effh, 0f862ae69h, 0616bffd3h, 0166ccf45h
DD 0a00ae278h, 0d70dd2eeh, 04e048354h, 03903b3c2h
DD 0a7672661h, 0d06016f7h, 04969474dh, 03e6e77dbh
DD 0aed16a4ah, 0d9d65adch, 040df0b66h, 037d83bf0h
DD 0a9bcae53h, 0debb9ec5h, 047b2cf7fh, 030b5ffe9h
DD 0bdbdf21ch, 0cabac28ah, 053b39330h, 024b4a3a6h
DD 0bad03605h, 0cdd70693h, 054de5729h, 023d967bfh
DD 0b3667a2eh, 0c4614ab8h, 05d681b02h, 02a6f2b94h
DD 0b40bbe37h, 0c30c8ea1h, 05a05df1bh, 02d02ef8dh

  @Exit:
	mov	R, eax

	pop     edx
	pop     ecx
	pop	ebx
	pop	eax
  end;
  Result := R;
end;

function Str2Float(const aStr: string; const aDefValue: Extended): Extended;
begin
  if not TextToFloat(PChar(aStr), Result, fvExtended) then Result := aDefValue;
end;

function Bool2Str(Value: Boolean): string;
begin
  if Value then Result := '1'
	   else Result := '0';
end;

function Str2Bool(const aStr: string): Boolean;
begin
  Result := (Trim(aStr) <> '') and (UpCase(Trim(aStr)[1]) in ['1', 'Y']); 
end;

{$IFDEF VER_D4}
function AnsiSameText(const S1, S2: string): Boolean;
begin
  Result := CompareString(LOCALE_USER_DEFAULT, NORM_IGNORECASE, PChar(S1), Length(S1), PChar(S2), Length(S2)) = 2;
end;
{$ENDIF}

end.


