unit LGsamp;

interface

uses
   Classes, Controls, StdCtrls, Forms, SysUtils, LiveGUID;

type
   TformLGsample = class(TForm)
      lblOriginal: TLabel;
      lblOriginalValue: TLabel;
      lblClean: TLabel;
      lblCleanValue: TLabel;
      lblAllTokensHex: TLabel;
      lblAllTokensHexValue: TLabel;
      lblAllTokensDec: TLabel;
      lblAllTokensDecValue: TLabel;
      lblHex0104: TLabel;
      lblHex0104Value: TLabel;
      lblDec0104: TLabel;
      lblDec0104Value: TLabel;
      lblHex0508: TLabel;
      lblHex0508Value: TLabel;
      lblDec0508: TLabel;
      lblDec0508Value: TLabel;
      lblHex0912: TLabel;
      lblHex0912Value: TLabel;
      lblDec0912: TLabel;
      lblDec0912Value: TLabel;
      lblHex1316: TLabel;
      lblHex1316Value: TLabel;
      lblDec1316: TLabel;
      lblDec1316Value: TLabel;
      lblRebuilt: TLabel;
      lblRebuiltValue: TLabel;
      lblNICMACaddress: TLabel;
      lblNICMACaddressValue: TLabel;
      procedure FormCreate(Sender: TObject);

      private
      { Private declarations }

      public
      { Public declarations }
   end;

var
   formLGsample: TformLGsample;

implementation

{$R *.DFM}

procedure TformLGsample.FormCreate(Sender: TObject);
var
   original, g : TLiveGUID;
   st : TLGStrTokens;
   ht : TLGHexTokens;

begin
   original := TLiveGUID.Create;                    // create a LG object

   lblOriginalValue.Caption := original.GUIDstring; // display the GUID string

   g := TLiveGUID.Create;                    // create a second LG object
   original.AssignTo(g);                     // assign the original one to it
   original.Free;                            // discard the original LG object

   lblCleanValue.Caption := g.GUIDstringClean; // display the clean GUID string

   ht := g.HexTokens;             // get all tokens at once as hex strings
   lblAllTokensHexValue.Caption := ht[1] + ' ' + ht[2] + ' ' + // display them
                                   ht[3] + ' ' + ht[4];

   st := g.StrTokens;             // get all tokens at once as decimal strings
   lblAllTokensDecValue.Caption := st[1] + ' ' + st[2] + ' ' + // display them
                                   st[3] + ' ' + st[4];

   lblHex0104Value.Caption := g.HexToken[1]; // get and display each single token
   lblDec0104Value.Caption := g.StrToken[1];

   lblHex0508Value.Caption := g.HexToken[2];
   lblDec0508Value.Caption := g.StrToken[2];

   lblHex0912Value.Caption := g.HexToken[3];
   lblDec0912Value.Caption := g.StrToken[3];

   lblHex1316Value.Caption := g.HexToken[4];
   lblDec1316Value.Caption := g.StrToken[4];

                           // set the LG object GUID from the displayed tokens
   g.SetHexTokens(lblHex0104Value.Caption, lblHex0508Value.Caption,
                  lblHex0912Value.Caption, lblHex1316Value.Caption);
   lblRebuiltValue.Caption := g.GUIDstring;        // display the GUID string

                                // show the Network Interface Card MAC address
   lblNICMACaddressValue.Caption := g.NICMACaddress;

   g.Free;                                     // discard the second LG object
end;

end.
