unit ShowAllU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,SLabel,SImage,SDBRchTx,SDBText,SMemo,SRichT,SShape,
  CheckLst, Placemnt;

type
  TShowAll = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Splitter1: TSplitter;
    Button7: TButton;
    Button8: TButton;
    ListBox1: TCheckListBox;
    FormPlacement1: TFormPlacement;
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Init;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button2Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
  private
    { Private declarations }
  public
    RootKey    : HKEY;
    SubKey     : String;

   procedure LoadAll;
   procedure SaveAll;
   procedure LoadChecked;
   procedure SaveChecked;
    { Public declarations }
  end;

var
  ShowAll: TShowAll;
  SubKey:string;

implementation

{$R *.DFM}

procedure TShowAll.LoadChecked;
var  i: Integer;
begin
  for i := 0 to ListBox1.Items.Count-1 do
   if ListBox1.Checked[i] then
     begin
     if (ListBox1.Items.Objects[i] IS TSaveQRMemo) then
     (ListBox1.Items.Objects[i] as TSaveQRMemo).LoadFromReg(SubKey,RootKey);

     if (ListBox1.Items.Objects[i] IS TSaveQRLabel) then
      (ListBox1.Items.Objects[i] as TSaveQRLabel).LoadFromReg(SubKey,RootKey);

     if (ListBox1.Items.Objects[i] IS TSaveQRImage) then
      (ListBox1.Items.Objects[i] as TSaveQRImage).LoadFromReg(SubKey,RootKey);

     if (ListBox1.Items.Objects[i] IS TSaveQRShape) then
      (ListBox1.Items.Objects[i] as TSaveQRShape).LoadFromReg(SubKey,RootKey);

     if (ListBox1.Items.Objects[i] IS TSaveQRDBRichText) then
      (ListBox1.Items.Objects[i] as TSaveQRDBRichText).LoadFromReg(SubKey,RootKey);

     if (ListBox1.Items.Objects[i] IS TSaveQRDBText) then
      (ListBox1.Items.Objects[i] as TSaveQRDBText).LoadFromReg(SubKey,RootKey);

     if (ListBox1.Items.Objects[i] IS TSaveQRRichText) then
      (ListBox1.Items.Objects[i] as TSaveQRRichText).LoadFromReg(SubKey,RootKey);
     end;
end;



procedure TShowAll.SaveChecked;
var  i: Integer;
begin
 for i := 0 to ListBox1.Items.Count-1 do
  if ListBox1.Checked[i] then
    begin
         if (ListBox1.Items.Objects[i] IS TSaveQRMemo) then
         (ListBox1.Items.Objects[i] as TSaveQRMemo).SaveToReg(SubKey,RootKey);

         if (ListBox1.Items.Objects[i] IS TSaveQRLabel) then
         (ListBox1.Items.Objects[i] as TSaveQRLabel).SaveToReg(SubKey,RootKey);

         if (ListBox1.Items.Objects[i] IS TSaveQRImage) then
         (ListBox1.Items.Objects[i] as TSaveQRImage).SaveToReg(SubKey,RootKey);;

         if (ListBox1.Items.Objects[i] IS TSaveQRShape) then
         (ListBox1.Items.Objects[i] as TSaveQRShape).SaveToReg(SubKey,RootKey);;

         if (ListBox1.Items.Objects[i] IS TSaveQRDBRichText) then
         (ListBox1.Items.Objects[i] as TSaveQRDBRichText).SaveToReg(SubKey,RootKey);

         if (ListBox1.Items.Objects[i] IS TSaveQRDBText) then
         (ListBox1.Items.Objects[i] as TSaveQRDBText).SaveToReg(SubKey,RootKey);

         if (ListBox1.Items.Objects[i] IS TSaveQRRichText) then
         (ListBox1.Items.Objects[i] as TSaveQRRichText).SaveToReg(SubKey,RootKey);
    end;
end;

procedure TShowAll.Init;
var  i: Integer;
begin
  for I := 0 to Owner.ComponentCount-1 do
 begin
  if (Owner.Components[I] IS TSaveQRLabel) or
     (Owner.Components[I] IS TSaveQRImage) or
     (Owner.Components[I] IS TSaveQRDBRichText) or
     (Owner.Components[I] IS TSaveQRDBText) or
     (Owner.Components[I] IS TSaveQRRichText) or
     (Owner.Components[I] IS TSaveQRShape) or
     (Owner.Components[I] IS TSaveQRMemo)
   then
     ListBox1.Items.InsertObject(0, Owner.Components[I].Name+':'+Owner.Components[I].ClassName,
     Owner.Components[I] as TObject);
 end;
 end;

procedure TShowAll.FormShow(Sender: TObject);
var c:boolean;
begin
c:=ListBox1.Items.Count > 0;
button1.Enabled:=c;
Button2.Enabled:=c;
button4.Enabled:=c;
button5.Enabled:=c;
Button6.Enabled:=c;
end;


procedure TShowAll.Button1Click(Sender: TObject);
begin
if ListBox1.ItemIndex = -1 then
 MessageDlg('You should select the component before you decide to change '+#13+#10+'its settings.', mtError, [mbOK], 0)
else
begin
  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRMemo) then
     (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRMemo).Execute;

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRLabel) then
      (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRLabel).Execute;

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRImage) then
      (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRImage).Execute;

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRShape) then
      (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRShape).Execute;

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRDBRichText) then
      (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRDBRichText).Execute;

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRDBText) then
     (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRDBText).Execute;

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRRichText) then
     (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRRichText).Execute;

end;

end;

procedure TShowAll.FormCreate(Sender: TObject);
begin
Init;
end;

procedure TShowAll.FormClose(Sender: TObject; var Action: TCloseAction);
begin
Release;
end;

procedure TShowAll.Button2Click(Sender: TObject);
begin
if ListBox1.ItemIndex = -1 then
 MessageDlg('You should select the component before you decide to change '+#13+#10+'its settings.', mtError, [mbOK], 0)
else
begin
  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRMemo) then
     (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRMemo).SaveToReg(SubKey,RootKey);

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRLabel) then
      (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRLabel).SaveToReg(SubKey,RootKey);

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRImage) then
      (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRImage).SaveToReg(SubKey,RootKey);

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRShape) then
      (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRShape).SaveToReg(SubKey,RootKey);

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRDBRichText) then
      (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRDBRichText).SaveToReg(SubKey,RootKey);

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRDBText) then
     (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRDBText).SaveToReg(SubKey,RootKey);

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRRichText) then
     (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRRichText).SaveToReg(SubKey,RootKey);

end;
end;

procedure TShowAll.Button5Click(Sender: TObject);
begin
if ListBox1.ItemIndex = -1 then
 MessageDlg('You should select the component before you decide to change '+#13+#10+'its settings.', mtError, [mbOK], 0)
else
begin
  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRMemo) then
     (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRMemo).LoadFromReg(SubKey,RootKey);

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRLabel) then
      (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRLabel).LoadFromReg(SubKey,RootKey);

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRImage) then
      (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRImage).LoadFromReg(SubKey,RootKey);

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRShape) then
      (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRShape).LoadFromReg(SubKey,RootKey);

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRDBRichText) then
      (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRDBRichText).LoadFromReg(SubKey,RootKey);

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRDBText) then
     (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRDBText).LoadFromReg(SubKey,RootKey);

  if (ListBox1.Items.Objects[ListBox1.ItemIndex] IS TSaveQRRichText) then
     (ListBox1.Items.Objects[ListBox1.ItemIndex] as TSaveQRRichText).LoadFromReg(SubKey,RootKey);

end;
end;

procedure TShowAll.Button6Click(Sender: TObject);
begin
 LoadAll;
end;

procedure TShowAll.LoadAll;
var  i: Integer;
begin
  for i := 0 to ListBox1.Items.Count-1 do
 begin
     if (ListBox1.Items.Objects[i] IS TSaveQRMemo) then
     (ListBox1.Items.Objects[i] as TSaveQRMemo).LoadFromReg(SubKey,RootKey);

     if (ListBox1.Items.Objects[i] IS TSaveQRLabel) then
      (ListBox1.Items.Objects[i] as TSaveQRLabel).LoadFromReg(SubKey,RootKey);

     if (ListBox1.Items.Objects[i] IS TSaveQRImage) then
      (ListBox1.Items.Objects[i] as TSaveQRImage).LoadFromReg(SubKey,RootKey);

     if (ListBox1.Items.Objects[i] IS TSaveQRShape) then
      (ListBox1.Items.Objects[i] as TSaveQRShape).LoadFromReg(SubKey,RootKey);

     if (ListBox1.Items.Objects[i] IS TSaveQRDBRichText) then
      (ListBox1.Items.Objects[i] as TSaveQRDBRichText).LoadFromReg(SubKey,RootKey);

     if (ListBox1.Items.Objects[i] IS TSaveQRDBText) then
      (ListBox1.Items.Objects[i] as TSaveQRDBText).LoadFromReg(SubKey,RootKey);

     if (ListBox1.Items.Objects[i] IS TSaveQRRichText) then
      (ListBox1.Items.Objects[i] as TSaveQRRichText).LoadFromReg(SubKey,RootKey);

     end;
end;

procedure TShowAll.SaveAll;
var  i: Integer;
begin
  for i := 0 to ListBox1.Items.Count-1 do
 begin
     if (ListBox1.Items.Objects[i] IS TSaveQRMemo) then
     (ListBox1.Items.Objects[i] as TSaveQRMemo).SaveToReg(SubKey,RootKey);

     if (ListBox1.Items.Objects[i] IS TSaveQRLabel) then
      (ListBox1.Items.Objects[i] as TSaveQRLabel).SaveToReg(SubKey,RootKey);

     if (ListBox1.Items.Objects[i] IS TSaveQRImage) then
      (ListBox1.Items.Objects[i] as TSaveQRImage).SaveToReg(SubKey,RootKey);;

     if (ListBox1.Items.Objects[i] IS TSaveQRShape) then
      (ListBox1.Items.Objects[i] as TSaveQRShape).SaveToReg(SubKey,RootKey);;

     if (ListBox1.Items.Objects[i] IS TSaveQRDBRichText) then
      (ListBox1.Items.Objects[i] as TSaveQRDBRichText).SaveToReg(SubKey,RootKey);

     if (ListBox1.Items.Objects[i] IS TSaveQRDBText) then
      (ListBox1.Items.Objects[i] as TSaveQRDBText).SaveToReg(SubKey,RootKey);

     if (ListBox1.Items.Objects[i] IS TSaveQRRichText) then
      (ListBox1.Items.Objects[i] as TSaveQRRichText).SaveToReg(SubKey,RootKey);


    end;
end;



procedure TShowAll.Button4Click(Sender: TObject);
begin
SaveAll;
end;

procedure TShowAll.Button3Click(Sender: TObject);
begin
close;
end;

procedure TShowAll.ListBox1DblClick(Sender: TObject);
begin
if Button1.Enabled then Button1.Click;
end;

procedure TShowAll.Button7Click(Sender: TObject);
begin
LoadChecked;
end;

procedure TShowAll.Button8Click(Sender: TObject);
begin
SaveChecked;
end;

end.
