unit SaveQRep;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,ShowAllU;

type
   TRootKey =(rkCurrentUser, rkLocalMachine);
type
  TSaveQRep = class(TComponent)
  private
    { Private declarations }
  protected
    { Protected declarations }
   VRootKey    : TRootKey;
   VSubKey     : String;

  public
    procedure SaveAll;
    procedure LoadAll;
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure Execute;
    { Public declarations }
  published
    { Published declarations }
     property RootKey  : TRootKey
                         read   VRootKey
                         write  VRootKey;

     property SubKey   : String
                         read  VSubKey
                         write VSubKey;
  end;

procedure Register;

implementation

procedure TSaveQRep.LoadAll;
begin
 ShowAll:=TShowAll.Create(Owner);

 ShowAll.SubKey:=VSubKey;
 if (VRootKey = rkCurrentUser) then
  ShowAll.RootKey:=HKEY_CURRENT_USER else
  ShowAll.RootKey:=HKEY_CLASSES_ROOT;

 ShowAll.LoadAll;

 ShowAll.Release;
end;

procedure TSaveQRep.SaveAll;
begin
 ShowAll:=TShowAll.Create(Owner);
 
 ShowAll.SubKey:=VSubKey;
 if (VRootKey = rkCurrentUser) then
  ShowAll.RootKey:=HKEY_CURRENT_USER else
  ShowAll.RootKey:=HKEY_CLASSES_ROOT;

 ShowAll.SaveAll;

 ShowAll.Release;
end;


procedure TSaveQRep.Execute;
 begin
   ShowAll:=TShowAll.Create(Owner);
   ShowAll.SubKey:=VSubKey;

 if (VRootKey = rkCurrentUser) then
  ShowAll.RootKey:=HKEY_CURRENT_USER else
  ShowAll.RootKey:=HKEY_CLASSES_ROOT;

   ShowAll.ShowModal;
 end;


constructor TSaveQRep.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);

  RootKey:=rkCurrentUser;
  SubKey:='Software\'+Application.Name;
end;

destructor  TSaveQRep.Destroy;
begin
  inherited Destroy;
end;

procedure Register;
begin
  RegisterComponents('kngComponents', [TSaveQRep]);
end;

end.
 