unit SMemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,Registry,QRCTRLS,ConfigU,QuickRpt,StdCtrls,RXSpin;

type
  TSaveQRMemo = class(TQRMemo)
  private

    { Private declarations }
  protected
   TMPSubKey   : String;
   VOnDlbClick : TNotifyEvent;
    { Protected declarations }
   procedure MouseDblClick(var Message: TMessage); message WM_LBUTTONDBLCLK;
   procedure ScrollBar1Changed(Sender: TObject);
   procedure ScrollBar2Changed(Sender: TObject);
   procedure StyleChanged(Sender: TObject);
   procedure SizeChanged(Sender: TObject);
   procedure FontChanged(Sender: TObject);
   procedure ColorChanged(Sender: TObject);
   procedure ColChanged(Sender: TObject);
   procedure OnSwitch(Sender: TObject);
   procedure OnAlignChanged(Sender: TObject);
   procedure WidthHeight(Sender: TObject);
   procedure TextChanged(Sender: TOBject);
  public
    procedure Execute;
    procedure SaveToReg(SubKey:string;RootKey:HKEY);
    procedure LoadFromReg(SubKey:string;RootKey:HKEY);
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;

    { Public declarations }
  published
     property OnDoubleClick: TNotifyEvent
                         read VOnDlbClick
                         write VOnDlbClick;
    { Published declarations }
  end;

procedure Register;

implementation

procedure TSaveQRMemo.OnAlignChanged(Sender: TObject);
 begin
   case Config.align.ItemIndex of
    0: Alignment:=taCenter;
    1: Alignment:=taLeftJustify;
    2: Alignment:=taRightJustify;
   end;
 end;

procedure TSaveQRMemo.WidthHeight(Sender: TObject);
 begin
  if (Sender as TRxSpinEdit).Name = 'width' then
   width:=Config.width.AsInteger;

  if (Sender as TRxSpinEdit).Name = 'height' then
   Height:=Config.height.AsInteger;
try
  Config.ScrollBar1.Max:=round((Parent as TQuickRep).Page.Width-(width*(Parent as TQuickRep).Page.Width/(Parent as TQuickRep).Width));
  Config.ScrollBar2.Max:=round((Parent as TQuickRep).Page.Length-(height*(Parent as TQuickRep).Page.length/(Parent as TQuickRep).Height));
except
end;

try
  Config.ScrollBar1.Max:=round((Parent as TQRBand).Size.Width-(width*(Parent as TQRBand).Size.Width/(Parent as TQRBand).Width));
  Config.ScrollBar2.Max:=round((Parent as TQRBand).Size.Length-(height*(Parent as TQRBand).Size.length/(Parent as TQRBand).Height));
except
end;

end;

procedure TSaveQRMemo.OnSwitch(Sender: TObject);
 begin
  if (Sender as TCheckBox).Name = 'penabled' then
   enabled:=Config.penabled.Checked;

  if (Sender as TCheckBox).Name = 'pvisible' then
   visible:=Config.pvisible.Checked;

  if (Sender as TCheckBox).Name = 'ptransparent' then
   transparent:=Config.ptransparent.Checked;

  if (Sender as TCheckBox).Name = 'pasize' then
   AutoSize:=Config.pasize.Checked;

  if (Sender as TCheckBox).Name = 'pwordwrap' then
   WordWrap:=Config.pwordwrap.Checked;

 config.width.Enabled:=NOT config.pasize.Checked;
 config.height.Enabled:=NOT config.pasize.Checked;
 end;

procedure TSaveQRMemo.TextChanged(Sender: TOBject);
 begin
   Lines.Text:=Config.ptext.Lines.Text;
   Refresh;
 end;

procedure TSaveQRMemo.ColChanged(Sender: TObject);
 begin
  Color:=Config.ColorComboBox2.ColorValue;
 end;

procedure TSaveQRMemo.ColorChanged(Sender: TObject);
 begin
  font.Color:=Config.ColorComboBox1.ColorValue;
 end;

procedure TSaveQRMemo.FontChanged(Sender: TObject);
 begin
  font.Name:=Config.FontComboBox1.FontName;
 end;

procedure TSaveQRMemo.SizeChanged(Sender: TObject);
 begin
  font.Size:=round(Config.size.value);
 end;

procedure TSaveQRMemo.StyleChanged(Sender: TObject);
 begin
  if Config.style.Checked[0] then Font.Style:=[fsBold] else Font.Style:=[];
  if Config.style.Checked[1] then Font.Style:=Font.Style+[fsItalic] else Font.Style:=Font.Style-[fsItalic];
  if Config.style.Checked[2] then Font.Style:=Font.Style+[fsUnderline] else Font.Style:=Font.Style-[fsUnderline];
  if Config.style.Checked[3] then Font.Style:=Font.Style+[fsStrikeOut] else Font.Style:=Font.Style-[fsStrikeOut];
 end;

procedure TSaveQRMemo.ScrollBar1Changed(Sender: TObject);
 begin
    Size.Left:=Config.ScrollBar1.Position;
    Config.Label3.Caption:=IntToStr(config.ScrollBar1.Position);
 end;

procedure TSaveQRMemo.ScrollBar2Changed(Sender: TObject);
 begin
    Size.Top:=Config.ScrollBar2.Position;
    Config.Label4.Caption:=IntToStr(config.ScrollBar2.Position);
 end;


procedure TSaveQRMemo.Execute;
 begin
  Config:=TConfig.Create(Owner);
  Config.Caption:='Config of component: '+Self.Name;
(*Settings for position*)
  Config.ScrollBar1.OnChange:=ScrollBar1Changed;
  Config.ScrollBar2.OnChange:=ScrollBar2Changed;

try
  Config.ScrollBar1.Max:=round((Parent as TQuickRep).Page.Width-(width*(Parent as TQuickRep).Page.Width/(Parent as TQuickRep).Width));
  Config.ScrollBar2.Max:=round((Parent as TQuickRep).Page.Length-(height*(Parent as TQuickRep).Page.length/(Parent as TQuickRep).Height));
except
end;
try
  Config.ScrollBar1.Max:=round((Parent as TQRBand).Size.Width-(width*(Parent as TQRBand).Size.Width/(Parent as TQRBand).Width));
  Config.ScrollBar2.Max:=round((Parent as TQRBand).Size.Length-(height*(Parent as TQRBand).Size.length/(Parent as TQRBand).Height));
except
end;

  Config.ScrollBar1.Position:=round(Size.left);
  Config.ScrollBar2.Position:=round(Size.top);
  Config.width.OnChange:=WidthHeight;
  Config.height.OnChange:=WidthHeight;

  Config.width.Value:=Width;
  Config.height.value:=height;

(*Settings for font*)
  Config.style.OnClickCheck:=StyleChanged;
    Config.style.Checked[0]:= fsBold in Font.Style;
    Config.style.Checked[1]:= fsItalic in Font.Style;
    Config.style.Checked[2]:= fsUnderline in  Font.Style;
    Config.style.Checked[3]:=fsStrikeOut in Font.Style;


  case Alignment of
    taCenter:       Config.align.ItemIndex:=0;
    taLeftJustify:  Config.align.ItemIndex:=1;
    taRightJustify: Config.align.ItemIndex:=2;
   end;

   Config.align.Visible:=true;
   Config.label11.visible:=true;
   Config.align.OnChange:=OnAlignChanged;

  Config.size.OnChange:=SizeChanged;
   Config.size.Value:=font.size;

  Config.FontComboBox1.OnChange:=FontChanged;
   Config.FontComboBox1.FontName:=Font.Name;

  Config.ColorComboBox1.OnChange:=ColorChanged;
   Config.ColorComboBox1.ColorValue:=Font.Color;

  Config.ptext.OnChange:=TextChanged;
   Config.ptext.lines.Text:=lines.text;


(*Setting the switches ...*)
  Config.ptext.Visible:=true;
  Config.penabled.OnClick:=OnSwitch;
  Config.pvisible.OnClick:=OnSwitch;
  Config.ptransparent.OnClick:=OnSwitch;
  Config.pasize.OnClick:=OnSwitch;
  Config.pwordwrap.OnClick:=OnSwitch;
  Config.ColorComboBox2.OnChange:=ColChanged;


  Config.ColorComboBox2.ColorValue:=Color;
  Config.penabled.Checked:=enabled;
  Config.pvisible.Checked:=visible;
  Config.ptransparent.Checked:=transparent;
  Config.pasize.Checked:=AutoSize;
  Config.pwordwrap.Checked:=WordWrap;
  Config.pwordwrap.Visible:=true;

//  Config.Show;
  Config.ShowModal;
  Config.Release;

 end;

procedure TSaveQRMemo.MouseDblClick(var Message: TMessage);
 begin
 end;

procedure TSaveQRMemo.SaveToReg(SubKey:string;RootKey:HKEY);
//This proccedure writes the info of selected QRDBText to registry
var Regy:TRegistry;
    a:integer;
 begin
    Regy:=TRegistry.Create;

    Regy.RootKey:=RootKey;
    TMPSubKey:=SubKey;
    if TMPSubKey = '' then TMPSubKey:='Software\knG\';
    TMPSubKey:=TMPSubKey+Owner.Name+'\'+Name;

    Regy.OpenKey(TMPSubKey,true);
    Regy.WriteFloat('PosX',Size.Left);
    Regy.WriteFloat('PosY',Size.Top);

     case Alignment of
       taCenter:       a:=0;
       taLeftJustify:  a:=1;
       taRightJustify: a:=2;
     end;
     
    Regy.WriteInteger('Alignment',a);
    Regy.WriteInteger('Color',Color);


    Regy.WriteInteger('FontSize',font.size);
    Regy.WriteString('FontName',Font.Name);
    Regy.WriteInteger('FontColor',Font.Color);
    if fsBold in font.style then
     Regy.WriteBool('Bold',true) else
     Regy.WriteBool('Bold',false);

    if fsItalic in font.style then
     Regy.WriteBool('Italic',true) else
     Regy.WriteBool('Italic',false);

    if fsUnderline in font.style then
     Regy.WriteBool('Underlined',true) else
     Regy.WriteBool('Underlined',false);

    if fsStrikeOut in font.style then
     Regy.WriteBool('StrikeOut',true) else
     Regy.WriteBool('StrikeOut',false);

     Regy.WriteBool('Enabled',enabled);
     Regy.WriteBool('Visible',visible);
     Regy.WriteBool('AutoSize',AutoSize);
     Regy.WriteBool('Transparent',transparent);
     Regy.WriteBool('WordWrap',WordWrap);
     Regy.WriteInteger('Width',width);
     Regy.WriteInteger('Height',height);

     Regy.WriteString('Text',Lines.Text);

    Regy.Free;
  end;

procedure TSaveQRMemo.LoadFromReg(SubKey:string;RootKey:HKEY);
//This proccedure writes the info of selected QRDBText to registry
var Regy:TRegistry;
 begin
    Regy:=TRegistry.Create;

    Regy.RootKey:=RootKey;
    TMPSubKey:=SubKey;
    if TMPSubKey = '' then TMPSubKey:='Software\knG\';
    TMPSubKey:=TMPSubKey+Owner.Name+'\'+Name;

 if  Regy.OpenKey(TMPSubKey,false)
 then
  begin
    Size.Left:=Regy.ReadFloat('PosX');
    Size.Top:=Regy.ReadFloat('PosY');

   case Regy.ReadInteger('Alignment') of
    0: Alignment:=taCenter;
    1: Alignment:=taLeftJustify;
    2: Alignment:=taRightJustify;
   end;


    Font.Size:=Regy.ReadInteger('FontSize');
    Font.Name:=Regy.ReadString('FontName');
    Font.Color:=Regy.ReadInteger('FontColor');

     if Regy.ReadBool('Bold') then
      Font.Style:=Font.Style+[fsBold];

     if Regy.ReadBool('Italic') then
      Font.Style:=Font.Style+[fsItalic];

     if Regy.ReadBool('Underlined') then
      Font.Style:=Font.Style+[fsUnderline];

     if Regy.ReadBool('StrikeOut') then
      Font.Style:=Font.Style+[fsStrikeOut];


     Enabled:=Regy.ReadBool('Enabled');
     Visible:=Regy.ReadBool('Visible');
     AutoSize:=Regy.ReadBool('AutoSize');
     Transparent:=Regy.ReadBool('Transparent');
     WordWrap:=Regy.ReadBool('WordWrap');
     width:=Regy.ReadInteger('Width');
     Height:=Regy.ReadInteger('Height');

     Lines.Text:=Regy.ReadString('Text');
     Color:=Regy.ReadInteger('Color');
  end;
    Regy.Free;
 end;

destructor  TSaveQRMemo.Destroy;
begin
  inherited Destroy;
end;

constructor TSaveQRMemo.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
end;

procedure Register;
begin
  RegisterComponents('kngComponents', [TSaveQRMemo]);
end;

end.
