unit SLabel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,Registry,QRCTRLS,ConfigU,QuickRpt,StdCtrls,RXSpin;


type
  TSaveQRLabel = class(TQRLabel)
  private
    { Private declarations }
  protected
   TMPSubKey   : String;
   VOnDlbClick : TNotifyEvent;
    { Protected declarations }
   procedure MouseDblClick(var Message: TMessage); message WM_LBUTTONDBLCLK;
   procedure ScrollBar1Changed(Sender: TObject);
   procedure ScrollBar2Changed(Sender: TObject);
   procedure StyleChanged(Sender: TObject);
   procedure SizeChanged(Sender: TObject);
   procedure FontChanged(Sender: TObject);
   procedure ColorChanged(Sender: TObject);
   procedure OnSwitch(Sender: TObject);
   procedure OnAlignChanged(Sender: TObject);
   procedure WidthHeight(Sender: TObject);
   procedure ColChanged(Sender: TObject);
   procedure TextChanged(Sender: TOBject);   
  public
    procedure Execute;
    procedure SaveToReg(SubKey:String;RootKey:HKEY);
    procedure LoadFromReg(SubKey:String;RootKey:HKEY);
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;

    { Public declarations }
  published
     property OnDoubleClick: TNotifyEvent
                         read VOnDlbClick
                         write VOnDlbClick;
    { Published declarations }
  end;

procedure Register;

implementation

procedure TSaveQRLabel.TextChanged(Sender: TOBject);
 begin
   Caption:=Config.pcaption.Text;
   Refresh;
 end;

procedure TSaveQRLabel.ColChanged(Sender: TObject);
 begin
  Color:=Config.ColorComboBox2.ColorValue;
 end;

procedure TSaveQRLabel.WidthHeight(Sender: TObject);
 begin
  if (Sender as TRxSpinEdit).Name = 'width' then
   width:=Config.width.AsInteger;

  if (Sender as TRxSpinEdit).Name = 'height' then
   Height:=Config.height.AsInteger;
try
  Config.ScrollBar1.Max:=round((Parent as TQuickRep).Page.Width-(width*(Parent as TQuickRep).Page.Width/(Parent as TQuickRep).Width));
  Config.ScrollBar2.Max:=round((Parent as TQuickRep).Page.Length-(height*(Parent as TQuickRep).Page.length/(Parent as TQuickRep).Height));
except
end;
try
  Config.ScrollBar1.Max:=round((Parent as TQRBand).Size.Width-(width*(Parent as TQRBand).Size.Width/(Parent as TQRBand).Width));
  Config.ScrollBar2.Max:=round((Parent as TQRBand).Size.Length-(height*(Parent as TQRBand).Size.length/(Parent as TQRBand).Height));
except
end;

end;

procedure TSaveQRLabel.OnSwitch(Sender: TObject);
 begin
  if (Sender as TCheckBox).Name = 'penabled' then
   enabled:=Config.penabled.checked;

  if (Sender as TCheckBox).Name = 'pvisible' then
   visible:=Config.pvisible.checked;

  if (Sender as TCheckBox).Name = 'ptransparent' then
   transparent:=Config.ptransparent.checked;

  if (Sender as TCheckBox).Name = 'pasize' then
   AutoSize:=Config.pasize.checked;

 config.width.Enabled:=NOT config.pasize.checked;
 config.height.Enabled:=NOT config.pasize.checked;

if Config.pcaption.Visible then
 Caption:=Config.pcaption.Text;

 end;

procedure TSaveQRLabel.OnAlignChanged(Sender: TObject);
 begin
   case Config.align.ItemIndex of
    0: Alignment:=taCenter;
    1: Alignment:=taLeftJustify;
    2: Alignment:=taRightJustify;
   end;
 end;


procedure TSaveQRLabel.ColorChanged(Sender: TObject);
 begin
  font.Color:=Config.ColorComboBox1.ColorValue;
 end;

procedure TSaveQRLabel.FontChanged(Sender: TObject);
 begin
  font.Name:=Config.FontComboBox1.FontName;
 end;

procedure TSaveQRLabel.SizeChanged(Sender: TObject);
 begin
  font.Size:=round(Config.size.value);
 end;

procedure TSaveQRLabel.StyleChanged(Sender: TObject);
 begin
  if Config.style.Checked[0] then Font.Style:=[fsBold] else Font.Style:=[];
  if Config.style.Checked[1] then Font.Style:=Font.Style+[fsItalic] else Font.Style:=Font.Style-[fsItalic];
  if Config.style.Checked[2] then Font.Style:=Font.Style+[fsUnderline] else Font.Style:=Font.Style-[fsUnderline];
  if Config.style.Checked[3] then Font.Style:=Font.Style+[fsStrikeOut] else Font.Style:=Font.Style-[fsStrikeOut];
 end;

procedure TSaveQRLabel.ScrollBar1Changed(Sender: TObject);
 begin
    Size.Left:=Config.ScrollBar1.Position;
    Config.Label3.Caption:=IntToStr(config.ScrollBar1.Position);
 end;

procedure TSaveQRLabel.ScrollBar2Changed(Sender: TObject);
 begin
    Size.Top:=Config.ScrollBar2.Position;
    Config.Label4.Caption:=IntToStr(config.ScrollBar2.Position);
 end;


procedure TSaveQRLabel.Execute;
 begin
  Config:=TConfig.Create(Owner);
  Config.Caption:='Config of component: '+Self.Name;
(*Settings for position*)
  Config.ScrollBar1.OnChange:=ScrollBar1Changed;
  Config.ScrollBar2.OnChange:=ScrollBar2Changed;

try
  Config.ScrollBar1.Max:=round((Parent as TQuickRep).Page.Width-(width*(Parent as TQuickRep).Page.Width/(Parent as TQuickRep).Width));
  Config.ScrollBar2.Max:=round((Parent as TQuickRep).Page.Length-(height*(Parent as TQuickRep).Page.length/(Parent as TQuickRep).Height));
except
end;
try
  Config.ScrollBar1.Max:=round((Parent as TQRBand).Size.Width-(width*(Parent as TQRBand).Size.Width/(Parent as TQRBand).Width));
  Config.ScrollBar2.Max:=round((Parent as TQRBand).Size.Length-(height*(Parent as TQRBand).Size.length/(Parent as TQRBand).Height));
except
end;

  Config.ScrollBar1.Position:=round(Size.left);
  Config.ScrollBar2.Position:=round(Size.top);

  Config.width.OnChange:=WidthHeight;
  Config.height.OnChange:=WidthHeight;

  Config.width.Value:=Width;
  Config.height.value:=height;

(*Settings for font*)
  Config.style.OnClickCheck:=StyleChanged;
    Config.style.Checked[0]:= fsBold in Font.Style;
    Config.style.Checked[1]:= fsItalic in Font.Style;
    Config.style.Checked[2]:= fsUnderline in  Font.Style;
    Config.style.Checked[3]:=fsStrikeOut in Font.Style;

  Config.size.OnChange:=SizeChanged;
   Config.size.Value:=font.size;

  Config.FontComboBox1.OnChange:=FontChanged;
   Config.FontComboBox1.FontName:=Font.Name;

  Config.ColorComboBox1.OnChange:=ColorChanged;
   Config.ColorComboBox1.ColorValue:=Font.Color;

  Config.ColorComboBox2.ColorValue:=Color;

  Config.penabled.checked:=enabled;
  Config.pvisible.checked:=visible;
  Config.ptransparent.checked:=transparent;
  Config.pasize.checked:=AutoSize;

(*Setting the switches ...*)
  Config.penabled.OnClick:=OnSwitch;
  Config.pvisible.OnClick:=OnSwitch;
  Config.ptransparent.OnClick:=OnSwitch;
  Config.pasize.OnClick:=OnSwitch;
  Config.align.OnChange:=OnAlignChanged;
  Config.ColorComboBox2.OnChange:=ColChanged;

  Config.pcaption.OnChange:=TextChanged;
   Config.pcaption.Text:=Caption;

  Config.align.Visible:=true;
  Config.Label11.visible:=true;

   case Alignment of
    taCenter:       Config.align.ItemIndex:=0;
    taLeftJustify:  Config.align.ItemIndex:=1;
    taRightJustify: Config.align.ItemIndex:=2;
   end;

  Config.pcaption.Visible:=true;
  Config.ShowModal;
   if NOT config.cancel then
   begin
    Size.Left:=Config.ScrollBar1.Position;
    Size.Top:=Config.ScrollBar2.Position;
   end;
  Config.Release;
  end;

 procedure TSaveQRLabel.MouseDblClick(var Message: TMessage);
 begin
  Execute;
 end;

procedure TSaveQRLabel.SaveToReg(SubKey:String;RootKey:HKEY);
//This proccedure writes the info of selected QRLabel to registry

var Regy:TRegistry;
    a:integer;
 begin
    Regy:=TRegistry.Create;


    Regy.RootKey:=RootKey;
    TMPSubKey:=SubKey;
    if TMPSubKey = '' then TMPSubKey:='Software\knG\';
    TMPSubKey:=TMPSubKey+Owner.Name+'\'+Name;

    Regy.OpenKey(TMPSubKey,true);
    Regy.WriteFloat('PosX',Size.Left);
    Regy.WriteFloat('PosY',Size.Top);
    Regy.WriteInteger('Color',Color);


    Regy.WriteInteger('FontSize',font.size);
    Regy.WriteString('FontName',Font.Name);
    Regy.WriteInteger('FontColor',Font.Color);
    if fsBold in font.style then
     Regy.WriteBool('Bold',true) else
     Regy.WriteBool('Bold',false);

    if fsItalic in font.style then
     Regy.WriteBool('Italic',true) else
     Regy.WriteBool('Italic',false);

    if fsUnderline in font.style then
     Regy.WriteBool('Underlined',true) else
     Regy.WriteBool('Underlined',false);

    if fsStrikeOut in font.style then
     Regy.WriteBool('StrikeOut',true) else
     Regy.WriteBool('StrikeOut',false);

     Regy.WriteBool('Enabled',enabled);
     Regy.WriteBool('Visible',visible);
     Regy.WriteBool('AutoSize',AutoSize);
     Regy.WriteBool('Transparent',transparent);

     Regy.WriteInteger('Width',width);
     Regy.WriteInteger('Height',height);

     case Alignment of
       taCenter:       a:=0;
       taLeftJustify:  a:=1;
       taRightJustify: a:=2;
     end;
    Regy.WriteInteger('Alignment',a);
    Regy.WriteString('Caption',Caption);
    Regy.Free;
  end;

procedure TSaveQRLabel.LoadFromReg(SubKey:String;RootKey:HKEY);
//This proccedure writes the info of selected QRLabel to registry
var Regy:TRegistry;
 begin
    Regy:=TRegistry.Create;

    Regy.RootKey:=RootKey;
    TMPSubKey:=SubKey;
    if TMPSubKey = '' then TMPSubKey:='Software\knG\';
    TMPSubKey:=TMPSubKey+Owner.Name+'\'+Name;

 if  Regy.OpenKey(TMPSubKey,false)
 then
  begin
    Size.Left:=Regy.ReadFloat('PosX');
    Size.Top:=Regy.ReadFloat('PosY');
    Font.Size:=Regy.ReadInteger('FontSize');
    Font.Name:=Regy.ReadString('FontName');
    Font.Color:=Regy.ReadInteger('FontColor');

     if Regy.ReadBool('Bold') then
      Font.Style:=Font.Style+[fsBold];

     if Regy.ReadBool('Italic') then
      Font.Style:=Font.Style+[fsItalic];

     if Regy.ReadBool('Underlined') then
      Font.Style:=Font.Style+[fsUnderline];

     if Regy.ReadBool('StrikeOut') then
      Font.Style:=Font.Style+[fsStrikeOut];


     Enabled:=Regy.ReadBool('Enabled');
     Visible:=Regy.ReadBool('Visible');
     AutoSize:=Regy.ReadBool('AutoSize');
     Transparent:=Regy.ReadBool('Transparent');

     width:=Regy.ReadInteger('Width');
     Height:=Regy.ReadInteger('Height');

    Color:=Regy.ReadInteger('Color');
     case Regy.ReadInteger('Alignment') of
      0: Alignment:=taCenter;
      1: Alignment:=taLeftJustify;
      2: Alignment:=taRightJustify;
     end;

      Caption:=Regy.ReadString('Caption');     

  end;
    Regy.Free;

 end;

destructor  TSaveQRLabel.Destroy;
begin
  inherited Destroy;
end;

constructor TSaveQRLabel.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);

end;

procedure Register;
begin
  RegisterComponents('knGComponents', [TSaveQRLabel]);
end;

end.
