unit SImage;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,Registry,QRCTRLS,ConfigU,QuickRpt,StdCtrls,RXSpin;

type
  TSaveQRImage = class(TQRImage)
  private

    { Private declarations }
  protected
   TMPSubKey   : String;
   VOnDlbClick : TNotifyEvent;
    { Protected declarations }
   procedure MouseDblClick(var Message: TMessage); message WM_LBUTTONDBLCLK;
   procedure ScrollBar1Changed(Sender: TObject);
   procedure ScrollBar2Changed(Sender: TObject);
   procedure OnSwitch(Sender: TObject);
   procedure WidthHeight(Sender: TObject);
  public
    procedure Execute;
    procedure SaveToReg(SubKey:string;RootKey:HKEY);
    procedure LoadFromReg(SubKey:string;RootKey:HKEY);
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;

    { Public declarations }
  published
     property OnDoubleClick: TNotifyEvent
                         read VOnDlbClick
                         write VOnDlbClick;
    { Published declarations }
  end;

procedure Register;

implementation

procedure TSaveQRImage.WidthHeight(Sender: TObject);
 begin
  if (Sender as TRxSpinEdit).Name = 'width' then
   width:=Config.width.AsInteger;

  if (Sender as TRxSpinEdit).Name = 'height' then
   Height:=Config.height.AsInteger;
try
  Config.ScrollBar1.Max:=round((Parent as TQuickRep).Page.Width-(width*(Parent as TQuickRep).Page.Width/(Parent as TQuickRep).Width));
  Config.ScrollBar2.Max:=round((Parent as TQuickRep).Page.Length-(height*(Parent as TQuickRep).Page.length/(Parent as TQuickRep).Height));
except
end;
try
  Config.ScrollBar1.Max:=round((Parent as TQRBand).Size.Width-(width*(Parent as TQRBand).Size.Width/(Parent as TQRBand).Width));
  Config.ScrollBar2.Max:=round((Parent as TQRBand).Size.Length-(height*(Parent as TQRBand).Size.length/(Parent as TQRBand).Height));
except
end;

end;

procedure TSaveQRImage.OnSwitch(Sender: TObject);
 begin
  if (Sender as TCheckBox).Name = 'penabled' then
   enabled:=Config.penabled.checked;

  if (Sender as TCheckBox).Name = 'pvisible' then
   visible:=Config.pvisible.checked;

  if (Sender as TCheckBox).Name = 'ptransparent' then
   transparent:=Config.ptransparent.checked;

  if (Sender as TCheckBox).Name = 'pasize' then
   AutoSize:=Config.pasize.checked;

 config.width.Enabled:=NOT config.pasize.Checked;
 config.height.Enabled:=NOT config.pasize.Checked;

 end;

procedure TSaveQRImage.ScrollBar1Changed(Sender: TObject);
 begin
    Size.Left:=Config.ScrollBar1.Position;
    Config.Label3.Caption:=IntToStr(config.ScrollBar1.Position);
 end;

procedure TSaveQRImage.ScrollBar2Changed(Sender: TObject);
 begin
    Size.Top:=Config.ScrollBar2.Position;
    Config.Label4.Caption:=IntToStr(config.ScrollBar2.Position);
 end;


procedure TSaveQRImage.Execute;
 begin
  Config:=TConfig.Create(Owner);
  Config.Caption:='Config of component: '+Self.Name;
(*Settings for position*)
  Config.ScrollBar1.OnChange:=ScrollBar1Changed;
  Config.ScrollBar2.OnChange:=ScrollBar2Changed;

try
  Config.ScrollBar1.Max:=round((Parent as TQuickRep).Page.Width-(width*(Parent as TQuickRep).Page.Width/(Parent as TQuickRep).Width));
  Config.ScrollBar2.Max:=round((Parent as TQuickRep).Page.Length-(height*(Parent as TQuickRep).Page.length/(Parent as TQuickRep).Height));
except
end;
try
  Config.ScrollBar1.Max:=round((Parent as TQRBand).Size.Width-(width*(Parent as TQRBand).Size.Width/(Parent as TQRBand).Width));
  Config.ScrollBar2.Max:=round((Parent as TQRBand).Size.Length-(height*(Parent as TQRBand).Size.length/(Parent as TQRBand).Height));
except
end;


  Config.ScrollBar1.Position:=round(Size.left);
  Config.ScrollBar2.Position:=round(Size.top);
  Config.width.OnChange:=WidthHeight;
  Config.height.OnChange:=WidthHeight;

  Config.width.Value:=Width;
  Config.height.value:=height;


  Config.GFont.Visible:=false;

(*Setting the switches ...*)
  Config.penabled.OnClick:=OnSwitch;
  Config.pvisible.OnClick:=OnSwitch;
  Config.ptransparent.OnClick:=OnSwitch;
  Config.pasize.OnClick:=OnSwitch;

  Config.penabled.Checked:=enabled;
  Config.pvisible.Checked:=visible;
  Config.ptransparent.Checked:=transparent;
  Config.pasize.Checked:=AutoSize;
  Config.ColorComboBox1.Visible:=false;

  Config.ShowModal;
   if NOT config.cancel then
   begin
    Size.Left:=Config.ScrollBar1.Position;
    Size.Top:=Config.ScrollBar2.Position;
   end;
  Config.Release;
 end;

procedure TSaveQRImage.MouseDblClick(var Message: TMessage);
 begin
  Execute;
 end;

procedure TSaveQRImage.SaveToReg(SubKey:string;RootKey:HKEY);
//This proccedure writes the info of selected QRDBText to registry
var Regy:TRegistry;
 begin
    Regy:=TRegistry.Create;

    Regy.RootKey:=RootKey;
    TMPSubKey:=SubKey;
    if TMPSubKey = '' then TMPSubKey:='Software\knG\';
    TMPSubKey:=TMPSubKey+Owner.Name+'\'+Name;

    Regy.OpenKey(TMPSubKey,true);
    Regy.WriteFloat('PosX',Size.Left);
    Regy.WriteFloat('PosY',Size.Top);
     Regy.WriteBool('Enabled',enabled);
     Regy.WriteBool('Visible',visible);
     Regy.WriteBool('AutoSize',AutoSize);
     Regy.WriteBool('Transparent',transparent);
     Regy.WriteInteger('Width',width);
     Regy.WriteInteger('Height',height);

    Regy.Free;
  end;

procedure TSaveQRImage.LoadFromReg(SubKey:string;RootKey:HKEY);
//This proccedure writes the info of selected QRDBText to registry
var Regy:TRegistry;
 begin
    Regy:=TRegistry.Create;

    Regy.RootKey:=RootKey;
    TMPSubKey:=SubKey;
    if TMPSubKey = '' then TMPSubKey:='Software\knG\';
    TMPSubKey:=TMPSubKey+Owner.Name+'\'+Name;

 if  Regy.OpenKey(TMPSubKey,false)
 then
  begin
    Size.Left:=Regy.ReadFloat('PosX');
    Size.Top:=Regy.ReadFloat('PosY');
     Enabled:=Regy.ReadBool('Enabled');
     Visible:=Regy.ReadBool('Visible');
     AutoSize:=Regy.ReadBool('AutoSize');
     Transparent:=Regy.ReadBool('Transparent');
     width:=Regy.ReadInteger('Width');
     Height:=Regy.ReadInteger('Height');

  end;
    Regy.Free;

 end;

destructor  TSaveQRImage.Destroy;
begin
  inherited Destroy;
end;

constructor TSaveQRImage.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
end;

procedure Register;
begin
  RegisterComponents('kngComponents', [TSaveQRImage]);
end;

end.
