unit PrimeTop;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TPrimeForm = class(TForm)
    cmOk: TBitBtn;
    cmCancel: TBitBtn;
    Label1: TLabel;
    fdFrom: TEdit;
    Label2: TLabel;
    fdFound: TLabel;
    fdList: TListBox;
    Label3: TLabel;
    fdUpto: TEdit;
    Label4: TLabel;
    cmStop: TSpeedButton;
    Label5: TLabel;
    procedure cmOkClick(Sender: TObject);
    procedure cmCancelClick(Sender: TObject);
    procedure cmStopClick(Sender: TObject);
  private
      Stop : Boolean;
  public
    { Public declarations }
  end;

var
  PrimeForm: TPrimeForm;

implementation
uses Sinteger;

{$R *.DFM}

procedure TPrimeForm.cmOkClick(Sender: TObject);
  var i, n, From, Upto : Integer;
begin
  From := StrToInt(fdFrom.Text);
  Upto := StrToInt(fdUpto.Text);
  cmOk    .Enabled := False;
  cmCancel.Enabled := False;
  cmStop  .Visible := True;
  try
    n := 0;
    fdList.Clear;
    fdFound.Caption := IntToStr(n);
    Application.ProcessMessages;
    for i:=From to Upto do
    begin
      if IsPrime(i) then
      begin
        Inc(n);
        fdFound.Caption := IntToStr(n);
        fdList.Items.Add(IntToStr(i));
        fdList.ItemIndex := fdList.Items.Count - 1
      end;
      Application.ProcessMessages;
      if Stop then Break;
    end;
  finally
    cmOk    .Enabled := True;
    cmCancel.Enabled := True;
    cmStop  .Visible := False;
  end
end;

procedure TPrimeForm.cmCancelClick(Sender: TObject);
begin
  Close
end;

procedure TPrimeForm.cmStopClick(Sender: TObject);
begin
  Stop := True
end;

end.
