unit OnlyTop;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TForm1 = class(TForm)
    cmOk: TBitBtn;
    cmCancel: TBitBtn;
    Label1: TLabel;
    fdDiv: TEdit;
    Label2: TLabel;
    fdMore: TLabel;
    Label3: TLabel;
    cmStop: TSpeedButton;
    fdFound: TLabel;
    procedure cmOkClick(Sender: TObject);
    procedure cmStopClick(Sender: TObject);
    procedure cmCancelClick(Sender: TObject);
  private
      Stop : Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
uses Sinteger;

{$R *.DFM}

procedure TForm1.cmOkClick(Sender: TObject);
  var m, s, d : string;
      i, n : Integer;
begin
  fdFound.Caption := '';
  Stop := False;
  d := fdDiv.Text;
  n := Length(d);
  if (n < 1) or not IsSint(d) then
    raise Exception.Create('Divisor must be numeric');
  if not (d[n] in ['1','3','7','9']) then
    raise Exception.Create('The last digit of the divisor must be 1, 3, 7 or 9');
  cmOk    .Enabled := False;
  cmCancel.Enabled := False;
  cmStop  .Visible := True;
  try
    repeat
      fdMore.Caption := IntToStr(n);
      Application.ProcessMessages;
      if Stop then Break;
      SetLength(s, n);
      for i:=1 to n do s[i] := '1';           // 11111...
      m := Sdiv(s, d);
      if Smul(m, d) = s then
      begin
        fdFound.Caption := 'Found at '+ fdMore.Caption;
        if Application.MessageBox('Continue?', 'Found!',
          MB_YESNO) = IDNO then Break;
      end;
      Inc(n);
    until False;
  finally
    cmOk    .Enabled := True;
    cmCancel.Enabled := True;
    cmStop  .Visible := False;
  end
end;

procedure TForm1.cmStopClick(Sender: TObject);
begin
  Stop := True
end;

procedure TForm1.cmCancelClick(Sender: TObject);
begin
  Close
end;

end.
