{!!}
{0.00-020  03 Dec 02 10:00   [17313]   User : Grahame Grieve          prepare for hl7_dict release}
{0.00-019  13 Nov 02 10:31   [17055]   User : Grahame Grieve          add dispose object for convenience}
{0.00-018  11 Jan 02 17:35    User : Kevin Moynihan          Grahame's fixes for kevin's work}
{0.00-017  11 Jan 02 16:16    User : Kevin Moynihan          Minor problem with Assert on HashSize}
{0.00-016  11 Jan 02 15:39    User : Kevin Moynihan          Coding Standards for New Application}
{0.00-015  19 Oct 01 17:23    User : Grahame on Red Hat          Compile OK for Kylix}
{0.00-014  05 Sep 01 19:35    User : Grahame Grieve          clear procedure}
{0.00-013  27 Aug 01 14:22    User : Grahame Grieve          fix compile problem}
{0.00-012  27 Aug 01 07:36    User : Grahame Grieve          control hash size}
{0.00-011  12 Feb 01 16:45    User : Grahame Grieve    }
{0.00-010  23 Jan 01 14:40    User : Jeff Sinclair     }
{0.00-009  04 Jan 01 17:12    User : Grahame Grieve    }
{0.00-008  13 Dec 00 09:51    User : Grahame Grieve    }
{0.00-007  28 Sep 00 10:25    User : Grahame Grieve    }
{0.00-006  08 Jun 00 23:33    User : Grahame Grieve    }
{0.00-005  07 Jun 00 17:28    User : Grahame Grieve    }
{0.00-004  11 Apr 00 22:39    User : Grahame Grieve    }
{0.00-003  11 Apr 00 14:00    User : Andrew Cumming    }
{0.00-002  11 Apr 00 12:14    User : Grahame Grieve    }
{0.00-001  08 Apr 00 23:28    User : Grahame Grieve    }
{0.00-000  08 Apr 00 22:37    User : Grahame Grieve
Comment:
          File First added to CodeVault}

{

This unit delivers high speed list management where the items
in the list are identified by a unique numerical key and only
ever retrieved using this value.

This list is stored as a hashed series of sorted dynamic arrays.
Retrieval is very fast, particularly for >100000 items.

Each key is associated with another item. This can be an
object, a pointer, or an integer. if you wish to store
some other kind of 4 byte item you can, but you must
typecast it to one of these types. All the items are stored
as 4 byte longints internally.

Since the item may point to memory, an event OnDispose is provided
to allow the using application to clean up the memory. This is called
anytime an item is dropped. It's up to the calling application to manage
the type of entity being dropped; this code does not differentiate
between numbers, pointers, and objects, and the event is called for
all of them.

This unit is 16bit safe.

To allow tracking of memory usage in the list, all memory is accounted
for in the property MemoryUsage.

Hash Sizes
==========

The default hash size is 256. It's generally appropriate to use a
hash size about 1% of the expected size of the list. However the
list is still blndingly fast at 0.1% and 1,000,000 items so it's not
that critical

For a hash size 1000, on 450MHz computer, this:

  For i := 0 to 1000000 do
    keylist.AsInt[i] := i + 1;

takes 3500ms , and this:

  For i := 0 to 1000000 do
    if keylist.AsInt[i] <> i + 1 then
      raise expcetion....

takes about 500ms
}

{$R-}

unit oopklist;

interface

uses
  Classes,
  HL7_Dict_Utils;

const
  DEFAULT_HASH_SIZE = 100;
  DEFAULT_ALLOCATION_SIZE = 16;

type
  TOnDisposeEvent = procedure(APtr: pointer) of object;

  TKeyList = class;

  TPair = record
    key,
    Value: Longint;
  end;

  TPairArray = array [0..0] of TPair;
  pPairArray = ^TPairArray;

  TKeyListSection = class(THL7BaseObject)
  Private
    FCount,
    FAllocated: Longint;
    Fitems: pPairArray;
    FList: TKeyList;
    procedure Grow;
    function FindItem(AKey: Longint; var VIndex: Longint): Boolean;
    procedure AddItem(AKey, AValue: Longint);
    function GetItem(AKey, ADefaultValue: Longint): Longint;
    procedure Delete(AKey: Longint);
  Public
    constructor Create(AOwner: TKeyList);
    destructor Destroy; Override;
  end;

  TSectionList = array [0..(MAXINT - 4) div sizeof(TKeyListSection)] of TKeyListSection;
  pSectionList = ^TSectionList;

  TKeyProgressRec = record
    Step1, Step2: Integer;
  end;

  TKeyList = class(THL7BaseObject)
  Private
    FHashSize: Longint;
    FHashTable: pSectionList;

    FMemoryUsage: Longint;
    FOnDispose: TOnDisposeEvent;
    FCount: Integer;

    function GetAsInt(AKey: Longint): Longint;
    function GetAsPointer(AKey: Longint): pointer;
    function GetAsObj(AKey: Longint): TObject;
    procedure SetAsInt(AKey: Longint; const AValue: Longint);
    procedure SetAsPointer(AKey: Longint; const AValue: pointer);
    procedure SetAsObj(AKey: Longint; const AValue: TObject);
    procedure init(AHashSize: Longint);
    function GetExists(AKey: Longint): Boolean;
  Public
    constructor Create(AHashSize: Integer = DEFAULT_HASH_SIZE);
    constructor createSize(AHashSize: Longint);
    destructor Destroy; Override;
    property HashSize: Longint Read FHashSize;
    property MemoryUsage: Longint Read FMemoryUsage;
    property AsPtr[AKey: Longint]: pointer Read GetAsPointer Write SetAsPointer;
    property AsInt[AKey: Longint]: Longint Read GetAsInt Write SetAsInt;
    property AsObj[AKey: Longint]: TObject Read GetAsObj Write SetAsObj; default;
    property Exists[AKey: Longint]: Boolean Read GetExists;
    property Count: Integer Read FCount;
    property OnDispose: TOnDisposeEvent Read FOnDispose Write FOnDispose;
    procedure Delete(AKey: Longint);
    function GetFirstKey(var VProgressRec: TKeyProgressRec; var VKey: Integer): Boolean;
    function GetNextKey(var VProgressRec: TKeyProgressRec; var VKey: Integer): Boolean;
    procedure Clear;
    procedure DisposeObject(APtr: pointer);
  end;

  TKeyStringList = class(TStringList)
  Private
    procedure QuickSort(ALowValue, AHighValue: Longint);
  Public
    function Find(const AKeyString: String; var VIndex: Integer): Boolean; Override;
    procedure Sort; Override;
  end;

resourcestring
  KdeVersionMark = {!!uv}'!-!oopklist.pas,0.00-020,03 Dec 02 10:00,9011';

implementation

uses
  SysUtils;

{ TKeyList }

constructor TKeyList.Create;
begin
  inherited Create;
  init(DEFAULT_HASH_SIZE);
  FCount := 0;
end;

constructor TKeyList.createSize(AHashSize: Longint);
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(AHashSize > 10, 'Hash size must be at least 10');
  inherited Create;
  init(AHashSize);
end;

procedure TKeyList.init(AHashSize: Longint);
var
  i: Longint;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(AHashSize > 10, 'Hash size must be at least 10');

  FHashSize := AHashSize;
  GetMem(FHashTable, FHashSize * sizeof(pointer));
  FMemoryUsage := FHashSize * sizeof(pointer);
  for i := 0 to FHashSize - 1 do
    begin
    FHashtable^[i] := TKeyListSection.Create(self);
    end;
end;

destructor TKeyList.Destroy;
var 
  i: Longint;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');

  for i := 0 to FHashSize - 1 do
    begin
    FreeAndNil(FHashtable^[i]);
    end;
  FreeMem(FHashTable, FHashSize * sizeof(pointer));
  FHashTable := NIL;
  inherited Destroy;
end;

function TKeyList.GetAsInt(AKey: Longint): Longint;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(AKey >= 0, 'Does not support negative integers');

  Result := FHashTable^[AKey mod FHashSize].GetItem(AKey, Longint($FFFFFFFF));
end;

function TKeyList.GetAsPointer(AKey: Longint): pointer;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(AKey >= 0, 'Does not support negative integers');

  Result := pointer(FHashTable^[AKey mod FHashSize].GetItem(AKey, 0));
end;

function TKeyList.GetAsObj(AKey: Longint): TObject;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(AKey >= 0, 'Does not support negative integers');

  Result := TObject(FHashTable^[AKey mod FHashSize].GetItem(AKey, 0));
end;

procedure TKeyList.SetAsInt(AKey: Longint; const AValue: Longint);
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(AKey >= 0, 'Does not support negative integers');
  // AValue can be any Integer

  FHashTable^[AKey mod FHashSize].AddItem(AKey, AValue);
end;

procedure TKeyList.SetAsPointer(AKey: Longint; const AValue: pointer);
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(AKey >= 0, 'Does not support negative integers');
  // AValue can be any Value

  FHashTable^[Akey mod FHashSize].AddItem(Akey, Longint(Avalue));
end;

procedure TKeyList.SetAsObj(AKey: Longint; const AValue: TObject);
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(AKey >= 0, 'Does not support negative integers');
  // AValue can be any TObject

  FHashTable^[AKey mod FHashSize].AddItem(AKey, Longint(AValue));
end;

function TKeyList.GetExists(AKey: Longint): Boolean;
var
  Ldummy: Longint;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(AKey >= 0, 'Does not support negative integers');

  Result := FHashTable^[AKey mod FHashSize].FindItem(AKey, LDummy);
end;

procedure TKeyList.Delete(AKey: LongInt);
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(AKey >= 0, 'Does not support negative integers');

  FHashTable^[AKey mod FHashSize].Delete(AKey);
end;

function TKeyList.GetFirstKey(var VProgressRec: TKeyProgressRec; var VKey: Integer): Boolean;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');

  // VProgressRec just a return only. No checking required

  // Leave VKey as is. It could have a value in it that the user will use
  // if this routine returns FALSE. Of course this is not a good thing for
  // the programmer to do. The return value should only be relied on
  // when the function returns TRUE

  VProgressRec.Step1 := -1;
  VProgressRec.Step2 := 0;
  Result := GetNextKey(VProgressRec, VKey);
end;

function TKeyList.GetNextKey(var VProgressRec: TKeyProgressRec; var VKey: Integer): Boolean;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');

  // VProgressRec just a return only. No checking required

  // Leave VKey as is. It could have a value in it that the user will use
  // if this routine returns FALSE. Of course this is not a good thing for
  // the programmer to do. The return value should only be relied on
  // when the function returns TRUE

  if VProgressRec.Step1 = -1 then
    begin
    inc(VProgressRec.Step1);
    end
  else
    begin
    inc(VProgressRec.Step2);
    end;
  while (VProgressRec.Step1 < FHashSize) and (FHashTable^[VProgressRec.Step1].FCount <= VProgressRec.Step2) do
    begin
    inc(VProgressRec.Step1);
    VProgressRec.Step2 := 0;
    end;
  Result := (VProgressRec.Step1 < FHashSize) and (FHashTable^[VProgressRec.Step1].FCount > VProgressRec.Step2);
  if Result then
    begin
    VKey := FHashTable^[VProgressRec.Step1].Fitems[VProgressRec.Step2].key;
    end;
end;

procedure TKeyList.Clear;
var
  LP: TKeyProgressRec;
  LK: Integer;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  if GetFirstKey(LP, LK) then
    begin
    Delete(LK);
    while GetNextKey(LP, LK) do
      begin
      Delete(LK);
      end;
    end;
end;

procedure TKeyList.DisposeObject(APtr: pointer);
begin
  FreeAndNil(APtr);
end;

{ TKeyListSection }

constructor TKeyListSection.Create(AOwner: TKeyList);
begin
  inherited Create;
  Assert(Assigned(AOwner), 'Owner not assigned in Create');
  FList := AOwner;
  FCount := 0;
  FAllocated := DEFAULT_ALLOCATION_SIZE;
  GetMem(Fitems, FAllocated * sizeof(TPair));
  inc(FList.FMemoryUsage, FAllocated * sizeof(TPair));
end;

destructor TKeyListSection.Destroy;
var
  i: Longint;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(FCount >= 0, 'Count cannot be negative');
  Assert(FAllocated >= DEFAULT_ALLOCATION_SIZE, 'Illegal size of FAllocated variable ' + IntToStr(FAllocated));
  if assigned(FList.FOnDispose) then
    begin
    for i := 0 to FCount - 1 do
      begin
      FList.FOnDispose(pointer(Fitems^[i].Value));
      end;
    end;
  FreeMem(Fitems, FAllocated * sizeof(TPair));
  Fitems := NIL;
  inherited Destroy;
end;

procedure TKeyListSection.AddItem(AKey, AValue: Longint);
var
  i: Longint;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(AKey >= 0, 'Does not support negative integers');
  Assert(FCount >= 0, 'Count cannot be negative');
  Assert(FAllocated >= DEFAULT_ALLOCATION_SIZE, 'Illegal size of FAllocated variable ' + IntToStr(FAllocated));
  // AValue can be any Integer

  if FindItem(Akey, i) then
    begin
    if assigned(FList.FOnDispose) then
      begin
      Flist.FOnDispose(pointer(Fitems^[i].Value));
      end;
    Fitems^[i].Value := AValue;
    end
  else
    begin
    if FCount = FAllocated then
      begin
      Grow;
      end;
    if I < FCount then
      begin
      System.Move(Fitems^[i], Fitems^[i + 1], (FCount - I) * SizeOf(TPair));
      end;
    Fitems^[i].key := AKey;
    Fitems^[i].Value := AValue;
    Inc(FCount);
    inc(FList.FCount);
    end;
end;

function TKeyListSection.FindItem(AKey: Longint; var VIndex: Longint): Boolean;
var
  L, H, I, C: Longint;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(AKey >= 0, 'Does not support negative integers');
  Assert(FCount >= 0, 'Count cannot be negative');
  Assert(FAllocated >= DEFAULT_ALLOCATION_SIZE, 'Illegal size of FAllocated variable ' + IntToStr(FAllocated));
  VIndex := 0;   // Initialise. Will be set in this function

  Result := False;
  L := 0;
  H := FCount - 1;
  while L <= H do
    begin
    I := (L + H) shr 1;
    C := Fitems^[I].key - AKey;
    if C < 0 then
      begin
      L := I + 1
      end
    else
      begin
      H := I - 1;
      if C = 0 then
        begin
        Result := True;
        L := I;
        end;
      end;
    end;
  VIndex := L;
end;

function TKeyListSection.GetItem(AKey, ADefaultValue: Longint): Longint;
var
  i: Longint;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(AKey >= 0, 'Does not support negative integers');
  Assert(FCount >= 0, 'Count cannot be negative');
  Assert(FAllocated >= DEFAULT_ALLOCATION_SIZE, 'Illegal size of FAllocated variable ' + IntToStr(FAllocated));
  // ADefault - values can be any Integer

  if FindItem(AKey, i) then
    begin
    Result := Fitems^[i].Value;
    end
  else
    begin
    Result := ADefaultValue;
    end;
end;

procedure TKeyListSection.Grow;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(FCount >= 0, 'Count cannot be negative');
  Assert(FAllocated >= DEFAULT_ALLOCATION_SIZE, 'Illegal size of FAllocated variable ' + IntToStr(FAllocated));
  inc(FAllocated, DEFAULT_ALLOCATION_SIZE);
  inc(FList.FMemoryUsage, DEFAULT_ALLOCATION_SIZE * sizeof(TPair));
  ReallocMem(Fitems, FAllocated * SizeOf(TPair));
end;


procedure TKeyListSection.Delete(Akey: LongInt);
var
  i: Longint;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(AKey >= 0, 'Does not support negative integers');
  Assert(FCount >= 0, 'Count cannot be negative');
  Assert(FAllocated >= DEFAULT_ALLOCATION_SIZE, 'Illegal size of FAllocated variable ' + IntToStr(FAllocated));

  if FindItem(Akey, i) then
    begin
    if assigned(Flist.FOnDispose) then
      begin
      Flist.FOnDispose(pointer(Fitems^[i].Value));
      end;
    Dec(FCount);
    Dec(Flist.FCount);
    if I < FCount then
      begin
      System.Move(Fitems^[I + 1], Fitems^[I], (FCount - I) * SizeOf(TPair));
      end;
    end;
end;

{ TKeyStringList }

function min(ANumber1, ANumber2: Longint): Longint;
begin
  // ANumber1 and ANumber2 can theoretically have any value so not check.

  if ANumber1 < ANumber2 then
    begin
    Result := ANumber1;
    end
  else
    begin
    Result := ANumber2;
    end;
end;

function SCompare(const AString1, AString2: String): Longint;
var
  i: Longint;
  LMinStringLen: Integer;
begin
  // Astring1 and AString2 can have any value

  LMinStringLen := min(length(AString1), length(AString2));
  for i := 1 to LMinStringLen do
    begin
    if AString1[i] < AString2[i] then
      begin
      Result := -1;
      exit
      end
    else if AString1[i] > AString2[i] then
      begin
      Result := 1;
      exit
      end;
    end;
  if length(AString1) < length(AString2) then
    Result := -1
  else if length(AString1) > length(AString2) then
    Result := 1
  else
    Result := 0;
end;

function TKeyStringList.Find(const AKeyString: String; var VIndex: Integer): Boolean;
var
  L, H, I, C: Longint;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  // AKeyString does not have any limits on its value
  VIndex := 0;  // Initialise to 0
  Assert(Count >= 0, 'Count cannot be negative');

  Result := False;
  L := 0;
  H := Count - 1;
  while L <= H do
    begin
    I := (L + H) shr 1;
    c := SCompare(Strings[i], AKeyString);
    if C < 0 then
      begin
      L := I + 1
      end
    else
      begin
      H := I - 1;
      if C = 0 then
        begin
        Result := True;
        if Duplicates <> dupAccept then
          begin
          L := I;
          end;
        end;
      end;
    end;
  VIndex := L;
end;

procedure TKeyStringList.QuickSort(ALowValue, AHighValue: Longint);
var
  I, J: Longint;
  P: String;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(ALowValue >= 0, 'Negative integer key value not allowed');
  Assert(AHighValue >= 0, 'Negative integer key value not allowed');
  Assert(Count >= 0, 'Count cannot be negative');

  repeat
    I := ALowValue;
    J := AHighValue;
    P := Strings[(ALowValue + AHighValue) shr 1];
    repeat
      while SCompare(Strings[I], P) < 0 do
        begin
        Inc(I);
        end;
      while SCompare(Strings[J], P) > 0 do
        begin
        Dec(J);
        end;
      if I <= J then
        begin
        Exchange(I, J);
        Inc(I);
        Dec(J);
        end;
    until I > J;
    if ALowValue < J then
      begin
      QuickSort(ALowValue, J);
      end;
    ALowValue := I;
  until I >= AHighValue;
end;

procedure TKeyStringList.Sort;
begin
  Assert(Assigned(Self), 'Try to use uninstantiated instance');
  Assert(Count >= 0, 'Count cannot be negative');
  if Count > 0 then
    begin
    QuickSort(0, Count - 1);
    end;
end;

begin
  if kdeVersionMark = '' then
    exit; {never remove this check - see Jeff Sinclair }
end.
