unit KDate;

interface

{!!}
{0.00-054  03 Dec 02 10:00   [17313]   User : Grahame Grieve          prepare for hl7_dict release}
{0.00-053  18 Jul 02 11:48   [15244]   User : Andrew Cumming          removed warnings}
{0.00-052  30 Apr 02 19:28   [11885]   User : Bob Hall              Expose RecogniseDay and IsADayOfWeek}
{0.00-051  25 Mar 02 22:49   [15158]   User : Bob Hall              CheckDateIsValid & EnforceDateIsValid}
{0.00-050  27 Feb 02 14:52   [15060]   User : Grahame Grieve          better error information in exceptions}
{0.00-049  19 Feb 02 15:58   [15060]   User : Grahame Grieve          change to way unimportant exceptions are handled}
{0.00-048  19 Feb 02 14:17   [14435]   User : Grahame on Red Hat          case of include file}
{0.00-047  13 Feb 02 11:18   [14435]   User : Grahame Grieve          Define Year Length}
{0.00-046  08 Feb 02 18:06   [14002]   User : Grahame on Red Hat          fix case}
{0.00-045  30 Jan 02 16:47   [14860]   User : Kevin Moynihan          DUnit updates}
{0.00-044  10 Jan 02 17:36    User : Grahame on Red Hat          Linux changes}
{0.00-043  29 Oct 01 11:42    User : Gordon Chalmers          add daylight saving bias to gettimezoneinfo}
{0.00-042  19 Oct 01 22:22    User : Grahame Grieve          fix compile defines}
{0.00-041  19 Oct 01 17:25    User : Grahame on Red Hat          Compile OK for Kylix}
{0.00-040  18 Oct 01 15:30    User : Grahame Grieve          Move TTimeStamp from OCIH to kdate}
{0.00-039  27 Sep 01 11:46    User : Grahame Grieve          Move code between kdate and kscript for hl7_dict release}
{0.00-038  05 Sep 01 08:29    User : Grahame Grieve          handle time overflows}
{0.00-037  17 Jul 01 08:58    User : Grahame Grieve          Change internal KScript Date Format}
{0.00-036  15 Jun 01 07:58    User : Grahame Grieve       }
{0.00-035  12 Jun 01 10:12    User : Gordon Chalmers      }
{0.00-034  20 Apr 01 14:23    User : Grahame Grieve       }
{0.00-033  16 Mar 01 11:37    User : Grahame Grieve    }
{0.00-032  12 Feb 01 16:45    User : Grahame Grieve     }
{0.00-031  11 Dec 00 09:46    User : Grahame Grieve     }
{0.00-030  26 Oct 00 16:38    User : Gordon Chalmers    }
{0.00-029  24 Oct 00 10:51    User : Gordon Chalmers    }
{0.00-028  04 Oct 00 22:21    User : Grahame Grieve     }
{0.00-027  28 Sep 00 17:08    User : Grahame Grieve     }
{0.00-026  04 Aug 00 10:16    User : Gordon Chalmers    }
{0.00-025  18 May 00 21:31    User : Grahame Grieve     }
{0.00-024  22 Feb 00 16:50    User : Grahame Grieve     }
{0.00-023  04 Jan 00 11:56    User : Gordon Chalmers    }
{0.00-022  04 Jan 00 10:40    User : Gordon Chalmers    }
{0.00-021  04 Jan 00 9:19    User : Grahame Grieve      }
{0.00-020  04 Jan 00 9:12    User : Grahame Grieve      }
{0.00-019  28 Dec 99 18:18    User : Grahame Grieve     }
{0.00-018  20 Dec 99 9:28    User : Anderson Miller     }
{0.00-017  08 Nov 99 10:09    User : Grahame Grieve     }
{0.00-016  07 Nov 99 16:53    User : Grahame Grieve     }
{0.00-015  07 Nov 99 12:03    User : Grahame Grieve     }
{0.00-014  21 Oct 99 9:30    User : Grahame Grieve      }
{0.00-013  14 Sep 99 8:22    User : Jeff Sinclair       }
{0.00-012  13 Sep 99 18:03    User : Jeff Sinclair      }
{0.00-011  08 Sep 99 11:35    User : Grahame Grieve     }
{0.00-010  12 Jul 99 8:20    User : Grahame Grieve      }
{0.00-009  07 Jul 99 10:43    User : Jeff Sinclair      }
{0.00-008  08 Jun 99 10:21    User : Grahame Grieve     }
{0.00-007  04 Jun 99 1:47    User : Grahame Grieve      }
{0.00-006  02 Jun 99 16:55    User : Gordon Chalmers    }
{0.00.005  27 May 99 18:01    User : Grahame Grieve     }
{0.00.004  07 Apr 99 13:57    User : Grahame Grieve     }
{0.00.003  07 Apr 99 13:48    User : Grahame Grieve     }
{0.00.002  06 Apr 99 20:34    User : Grahame Grieve     }
{0.00.001  02 Jul 97 16:25    User : Anderson Miller    }
{0.00.000  14 Jul 98 13:05    User : Grahame Grieve
Comment:
          File First added to CodeVault}

{$I HL7_Dict.inc}

uses
  Classes,
  SysConst,
  SysUtils;

type
  EKDateFormatError = class(Exception);

  { transfer types for DATE, TIME, TIMESTAMP }
  TDate = record
    year: Smallint;
    month: Word;
    day: Word;
  end;
  TTime = record
    hour: Word;
    minute: Word;
    second: Word;
  end;
  TTimeStamp = record
    year: Smallint;
    month: Word;
    day: Word;
    hour: Word;
    minute: Word;
    second: Word;
    fraction: Cardinal;
  end;

function TimeStamp(Year: SmallInt;
  Month: Word;
  Day: Word;
  Hour: Word;
  Minute: Word;
  Second: Word;
  Fraction: Cardinal): TTimeStamp;

function TSEqual(TS1, TS2: TTimeStamp): Boolean;
function TSCompare(TS1, TS2: TTimeStamp): Integer;
function TSToDateTime(TS: TTimeStamp): TDateTime;
function DateTimeToTS(DateTime: TDateTime): TTimeStamp;
function NullTS: TTimeStamp;
function TSNull(TS: TTimeStamp): Boolean;
function TSAsDate(TS: TTimeStamp): TDate;
function DateAsTS(D: TDate): TTimeStamp;
function TSAsTime(TS: TTimeStamp): TTime;
function TimeAsTS(T: TTime): TTimeStamp;

function ReadDate(const format, date: String; AllowBlankTimes: Boolean = False; allowNoDay: Boolean = False; allownodate: Boolean = False): TTimeStamp;
function DTReadDate(const format, date: String; AllowBlankTimes: Boolean = False): TDateTime;
function OpenReadDate(adate: String; AllowNoDay: Boolean = False): TTimeStamp;
function OpenReadTime(atime: String): TDateTime;
procedure IncrementMonth(var d: TTimeStamp);
procedure IncrementYear(var d: TTimeStamp);
procedure IncrementWeekDay(var d: TTimeStamp);
procedure IncrementQuarter(var d: TTimeStamp);
procedure IncrementWeek(var d: TTimeStamp);
function DTIncrementMonth(var d: TDateTime): TDateTime;
procedure IncrementDay(var d: TTimeStamp);
function DTIncrementDay(var d: TDateTime): TDateTime;
procedure FindBlock(ch: Char; const s: String; var start, blength: Integer);

function FormatTimeStamp(const Aformat: String; const ATTimeStamp: TTimeStamp): String;

var
  iPreCentWindow: Integer; //used in initialisation

{------------------------------------------------------------------------------
   Date/Time Routines and constants                                                }

const
  MINUTE_LENGTH = 1 / (24 * 60);
  SECOND_LENGTH = MINUTE_LENGTH / 60;
  MILLISECOND_LENGTH = MINUTE_LENGTH / (60 * 1000);
  YEAR_LENGTH = 365;
  AVERAGE_YEAR_LENGTH = 365.25;
  AVERAGE_MONTH_LENGTH = 365.25 / 12;


  {$IFNDEF LINUX}
function GetTimeZoneBias: TDateTime;
  {$ENDIF}

function ThisYear: Integer;
function GetMonthShortName(i: Integer): String;
function GetMonthLongName(i: Integer; Awid: Byte = 255): String;
function GetDayName(i: Integer): String;
function ReadMonthName(s: String): Integer;
function DescribePeriod(Period: TDateTime): String;
function NowAsString: String;  // returns the current date and time as a string in form ccyymmddhhmmssmmm
function CheckDateIsValid(Ayear, Amonth, Aday: Word; var Verr: String): Boolean;
procedure EnforceDateIsValid(Ayear, Amonth, Aday: Word);
function CheckTTimeStampIsValid(const ATimeStamp: TTimeStamp; var Verr: String): Boolean;
procedure EnforceTTimeStampIsValid(const ATimeStamp: TTimeStamp);
function RecogniseDay(s: String): Integer;
function IsADayOfWeek(s: String): Boolean;

resourcestring
  KdeVersionMark = {!!uv}'!-!KDate.pas,0.00-054,03 Dec 02 10:00,2251';

implementation

uses
  HL7_Dict_Utils
{$IFNDEF LINUX}
    , Windows
{$ENDIF}
{$IFDEF INKESTRAL}
    , DebugExceptionRegistry{$ENDIF};

function CheckDateIsValid(Ayear, Amonth, Aday: Word; var Verr: String): Boolean;
  function DayOkForMonth: Boolean;
    begin
    Result := False;
    case Amonth of
      1, 3, 5, 7, 8, 10, 12:
        begin
        if Aday > 31 then
          begin
          Verr := 'Day ' + IntToStr(Aday) + ' too large for ' + GetMonthLongName(Amonth);
          exit;
          end;
        end;
      4, 6, 9, 11:
        begin
        if Aday > 30 then
          begin
          Verr := 'Day ' + IntToStr(Aday) + ' too large for ' + GetMonthLongName(Amonth);
          exit;
          end;
        end;
      2:
        begin
        if IsLeapYear(Ayear) then
          begin
          if Aday > 29 then
            begin
            Verr := 'Day ' + IntToStr(Aday) + ' too large for February';
            exit;
            end;
          end
        else
          begin
          if Aday = 29 then
            begin
            Verr := 'Day 29 too large for February in non-leap years';
            exit;
            end
          else if Aday > 28 then
            begin
            Verr := 'Day ' + IntToStr(Aday) + ' too large for February';
            exit;
            end;
          end;
        end;
      else
        begin
        Verr := 'Day ' + IntToStr(Aday) + ', Month ' + IntToStr(AMonth) + ', - Month is invalid';
        exit;
        end;
      end; //case
    Result := True;
    end;
begin
  Result := False;
  if (Ayear < 1000) or (Ayear > 3000) then
    begin
    Verr := 'Year ' + IntToStr(Ayear) + ' is invalid';
    exit;
    end;
  if (Amonth < 1) or (Amonth > 12) then
    begin
    Verr := 'Month ' + IntToStr(Amonth) + ' is invalid';
    exit;
    end;
  if Aday < 1 then
    begin
    Verr := 'Day ' + IntToStr(Aday) + ' is invalid';
    exit;
    end
  else if not DayOkForMonth then
    exit;
  Result := True;
end;

procedure EnforceDateIsValid(Ayear, Amonth, Aday: Word);
var
  LErr: String;
begin
  if not CheckDateIsValid(Ayear, Amonth, Aday, Lerr) then
    raise EKDateFormatError.Create(Lerr);
end;

function CheckTTimeStampIsValid(const ATimeStamp: TTimeStamp; var Verr: String): Boolean;
  function DumpTTimeStamp: String;
    begin
    Result := 'TTimeStamp <yr ' + IntToStr(ATimeStamp.year) + ', mo ' + IntToStr(ATimeStamp.month) + ', da ' + IntToStr(ATimeStamp.day) + ', hr ' +
      IntToStr(ATimeStamp.hour) + ', mi ' + IntToStr(ATimeStamp.minute) + ', se ' + IntToStr(ATimeStamp.second) + ', fr ' + IntToStr(ATimeStamp.fraction) + '>';
    end;
var
  LErr: String;
begin
  Verr := '';
  Result := False;
  if not CheckDateIsValid(ATimeStamp.year, ATimeStamp.month, ATimeStamp.day, LErr) then
    begin
    Verr := DumpTTimeStamp + ' is invalid: ' + LErr;
    exit;
    end;
  if ATimeStamp.hour > 23 then
    begin
    Verr := 'Hour in ' + DumpTTimeStamp + ' is invalid';
    exit;
    end;
  if ATimeStamp.minute > 59 then
    begin
    Verr := 'Minute in ' + DumpTTimeStamp + ' is invalid';
    exit;
    end;
  if ATimeStamp.second > 59 then
    begin
    Verr := 'Second in ' + DumpTTimeStamp + ' is invalid';
    exit;
    end;
  Result := True;
end;

procedure EnforceTTimeStampIsValid(const ATimeStamp: TTimeStamp);
var
  LErr: String;
begin
  if not CheckTTimeStampIsValid(ATimeStamp, Lerr) then
    raise EKDateFormatError.Create(Lerr);
end;

function FormatTimeStamp(const Aformat: String; const ATTimeStamp: TTimeStamp): String;
begin
  EnforceTTimeStampIsValid(ATTimeStamp);
  Result := Aformat;
  if not ReplaceSubString(Result, 'yyyy', PadString(IntToStr(ATTimeStamp.year), 4, '0', True)) then
    replaceSubstring(Result, 'yy', copy(IntToStr(ATTimeStamp.year), 3, 2));
  if not ReplaceSubString(Result, 'mmmm', GetMonthLongName(ATTimeStamp.month, 4)) then
    if not ReplaceSubString(Result, 'mmm', GetMonthShortName(ATTimeStamp.month)) then
      if not ReplaceSubString(Result, 'mm', PadString(IntToStr(ATTimeStamp.month), 2, '0', True)) then
        ReplaceSubString(Result, 'm', IntToStr(ATTimeStamp.month));
  if not ReplaceSubString(Result, 'dd', PadString(IntToStr(ATTimeStamp.day), 2, '0', True)) then
    ReplaceSubString(Result, 'd', IntToStr(ATTimeStamp.day));
  ReplaceSubString(Result, 'hh', PadString(IntToStr(ATTimeStamp.hour), 2, '0', True));
  ReplaceSubString(Result, 'nn', PadString(IntToStr(ATTimeStamp.minute), 2, '0', True));
  ReplaceSubString(Result, 'ss', PadString(IntToStr(ATTimeStamp.second), 2, '0', True));
end;

function UserStrToInt(st, Info: String): Integer; { raise an EHL7UserException }
var
  E: Integer;
begin
  Val(St, Result, E);
  if E <> 0 then
    raise EHL7UserException.CreateFmt(SInvalidInteger + ' reading ' + Info, [St]);
end;


function ReadDate(const format, date: String; AllowBlankTimes: Boolean = False; allowNoDay: Boolean = False; allowNoDate: Boolean = False): TTimeStamp;
var 
  start, length: Integer;
  s: String;
  tmp: String;
begin
  Result.year := 0;
  Result.month := 0;
  Result.day := 0;
  Result.hour := 0;
  Result.minute := 0;
  Result.second := 0;
  Result.fraction := 0;
  FindBlock('y', Format, start, length);
  tmp := copy(date, start, length);
  if lowercase(tmp) = 'nown' then
    exit;
  if (tmp = '') and AllowNoDate then
    // we don't bother with the year
  else
    begin
    Result.year := UserStrToInt(tmp, 'Year from "' + date + '"');
    if Result.year < 100 then
      if abs(Result.year) > TwoDigitYearCenturyWindow then      //abs as result.year is a smallint, twodigityearcenturywindow is a word (range checking)
        inc(Result.year, 1900)
      else
        inc(Result.year, 2000);
    end;
  FindBlock('m', Format, start, length);
  s := lowercase(copy(date, start, length));
  if AllowNoDate and (tmp = '') then
    // we don't worry about the month
  else
    begin
    if length > 2 then
      begin
      if (s = 'jan') or (s = 'january') then 
        Result.month := 1  
      else if (s = 'feb') or (s = 'february') then 
        Result.month := 2  
      else if (s = 'mar') or (s = 'march') then 
        Result.month := 3  
      else if (s = 'apr') or (s = 'april') then 
        Result.month := 4  
      else if (s = 'may') then 
        Result.month := 5  
      else if (s = 'jun') or (s = 'june') then 
        Result.month := 6  
      else if (s = 'jul') or (s = 'july') then 
        Result.month := 7  
      else if (s = 'aug') or (s = 'august') then 
        Result.month := 8  
      else if (s = 'sep') or (s = 'september') then 
        Result.month := 9  
      else if (s = 'oct') or (s = 'october') then 
        Result.month := 10 
      else if (s = 'nov') or (s = 'november') then 
        Result.month := 11
      else if (s = 'dec') or (s = 'december') then 
        Result.month := 12 
      else
        raise EHL7UserException.Create('The Month "' + s + '" is unknown');
      end
    else
      Result.month := UserStrToInt(s, 'Month from "' + date + '"');
    if (Result.month > 12) or (Result.month < 1) then 
      raise EKDateFormatError.Create('invalid month ' + IntToStr(Result.month));
    end;
  FindBlock('d', Format, start, length);
  tmp := copy(date, start, length);
  if (AllowNoday or AllowNoDate) and (tmp = '') then
    // we don't check the day
  else
    begin
    Result.day := UserStrToInt(tmp, 'Day from "' + date + '"');
    EnforceDateIsValid(Result.year, Result.month, Result.day);
    end;
  FindBlock('h', Format, start, length);
  if length <> 0 then
    if AllowBlankTimes then
      Result.hour := StrToIntDef(copy(date, start, length), 0)
    else
      Result.hour := UserStrToInt(copy(date, start, length), 'Hour from "' + date + '"');
  FindBlock('s', Format, start, length);
  if length <> 0 then
    if AllowBlankTimes then
      Result.second := StrToIntDef(copy(date, start, length), 0)
    else
      Result.second := UserStrToInt(copy(date, start, length), 'Second from "' + date + '"');
  FindBlock('n', Format, start, length);
  if length <> 0 then
    if AllowBlankTimes then
      Result.minute := StrToIntDef(copy(date, start, length), 0)
    else
      Result.minute := UserStrToInt(copy(date, start, length), 'Minute from "' + date + '"');
  FindBlock('x', Format, start, length);
  if length <> 0 then
    if uppercase(copy(date, start, length)) = 'AM' then
      begin
      if Result.hour = 12 then
        Result.hour := 0
      end
    else
      begin
      inc(Result.hour, 12);
      end;

  if Result.hour = 24 then
    begin
    Result.hour := 0;
    incrementDay(Result);
    end;
end;

function DTReadDate(const format, date: String; AllowBlankTimes: Boolean = False): TDateTime;
begin
  Result := TSToDateTime(ReadDate(format, date, allowblankTimes));
end;

function RecogniseMonth(s: String): Integer;
begin
  if isANumber(s) then
    begin
    Result := StrToInt(s);
    if (Result < 1) or (Result > 12) then
      raise EKDateFormatError.Create(s + ' is not a valid month');
    end
  else
    begin
    s := lowercase(s);
    if s = 'jan' then
      Result := 1 
    else if s = 'january' then 
      Result := 1 
    else if s = 'feb' then 
      Result := 2 
    else if s = 'february' then 
      Result := 2 
    else if s = 'mar' then 
      Result := 3 
    else if s = 'march' then 
      Result := 3 
    else if s = 'apr' then 
      Result := 4 
    else if s = 'april' then 
      Result := 4 
    else if s = 'may' then 
      Result := 5 
    else if s = 'jun' then 
      Result := 6 
    else if s = 'june' then 
      Result := 6 
    else if s = 'jul' then 
      Result := 7 
    else if s = 'july' then 
      Result := 7 
    else if s = 'aug' then 
      Result := 8 
    else if s = 'august' then 
      Result := 8 
    else if s = 'sep' then 
      Result := 9 
    else if s = 'sept' then 
      Result := 9 
    else if s = 'september' then 
      Result := 9 
    else if s = 'oct' then 
      Result := 10 
    else if s = 'october' then 
      Result := 10 
    else if s = 'nov' then 
      Result := 11 
    else if s = 'november' then 
      Result := 11 
    else if s = 'dec' then 
      Result := 12
    else if s = 'december' then 
      Result := 12 
    else
      raise EKDateFormatError.Create(s + ' is not a valid month');
    end;
end;

function RecogniseDay(s: String): Integer;
begin
  s := lowercase(s);
  if s = 'sun' then
    Result := 1
  else if s = 'sunday' then
    Result := 1
  else if s = 'mon' then
    Result := 2
  else if s = 'monday' then
    Result := 2
  else if s = 'tues' then
    Result := 3
  else if s = 'tuesday' then
    Result := 3
  else if s = 'wed' then
    Result := 4
  else if s = 'wednesday' then
    Result := 4
  else if s = 'thurs' then
    Result := 5
  else if s = 'thursday' then
    Result := 5
  else if s = 'fri' then
    Result := 6
  else if s = 'friday' then
    Result := 6
  else if s = 'sat' then
    Result := 7
  else if s = 'saturday' then
    Result := 7
  else
    raise EKDateFormatError.Create(s + ' is not a valid day of the week');
end;

function IsADayOfWeek(s: String): Boolean;
begin
  try
    RecogniseDay(s);
    Result := True;
  except
    Result := False;
    end;
end;

function ThisYear: Integer;
var
  y, m, d: Word;
begin
  DecodeDate(now, y, m, d);
  Result := y;
end;

function ThisCentury: Integer;
begin
  Result := (ThisYear div 100) * 100;
end;

function isNumeric(ch: Char): Boolean;
begin
  Result := ch in ['0'..'9'];
end;

function isLetter(ch: Char): Boolean;
begin
  Result := ch in ['A'..'Z', 'a'..'z'];
end;

function isAlphaNumericChar(ch: Char): Boolean;
begin
  Result := (isNumeric(ch) or isLetter(ch));
end;


function ReadTokens(const d: String; tokens: TStringList): String;
var 
  i, c: Integer;
  s: String;
begin
  i := 1;
  c := 0;
  Result := '';
  tokens.add('');
  while (i <= length(d)) and (d[i] = ' ') do 
    inc(i);
  while i <= length(d) do
    begin
    if isAlphaNumericChar(d[i]) then
      begin
      tokens[c] := tokens[c] + d[i];
      inc(i);
      end
    else
      begin
      inc(c);
      inc(i);
      tokens.add('');
      while (i <= length(d)) and (d[i] = ' ') do 
        inc(i);
      end;
    end;
  for i := tokens.Count - 1 downto 0 do
    if (tokens[i] = '') or (lowercase(tokens[i]) = 'rd') or (lowercase(tokens[i]) = 'th') or (lowercase(tokens[i]) = 'st') or (lowercase(tokens[i]) = 'nd') then
      tokens.Delete(i)
  else if (IsADayOfWeek(tokens[i])) then
    begin
    Result := tokens[i];
    tokens.Delete(i);
    end
  else
    begin
    s := lowercase(copy(tokens[i], length(tokens[i]) - 1, 2));
    if (s = 'rd') or (s = 'th') or (s = 'st') or (s = 'nd') then
      tokens[i] := copy(tokens[i], 1, length(tokens[i]) - 2);
    end;
end;

function ReadYear(tokens: TStringList; date: String): Integer;
var
  year: String;
  t: Integer;
begin
  if tokens.Count = 2 then
    Result := ThisYear
  else
    begin
    year := tokens[2];
    if not isANumber(year) then
      raise EKDateFormatError.Create('The year ' + tokens[2] + ' is not a valid number');
    t := UserStrToInt(year, 'Year from "' + date + '"');
    if length(year) = 2 then
      begin
      if t > TwoDigitYearCenturyWindow then
        Result := t + ThisCentury - 100
      else
        Result := t + ThisCentury;
      end
    else
      Result := t;
    end;
end;

procedure ReadMonthDay(tokens: TStringList; date: String; var ts: TTimeStamp);
var
  t1, t2: Integer;
  month, day: String;
begin
  if isANumber(tokens[0]) and isANumber(tokens[1]) then
    begin
    //ok have a problem - which is the month?
    t1 := UserStrToInt(tokens[0], 'Month/day from "' + date + '"');
    t2 := UserStrToInt(tokens[1], 'Month/day from "' + date + '"');
    if t1 < 1 then
      raise EKDateFormatError.Create('invalid number ' + tokens[0]);
    if t2 < 1 then
      raise EKDateFormatError.Create('invalid number ' + tokens[1]);
    if t1 > 12 then
      begin
      ts.day := t1;
      ts.month := t2;
      end
    else if t2 > 12 then
      begin
      ts.day := t2;
      ts.month := t1;
      end
    else
      begin
      { // causing all sorts of problems in NT services
      if pos('d', LowerCase(ShortDateFormat)) > pos('m', LowerCase(ShortDateFormat)) then
        begin
        ts.day := t2;
        ts.month := t1;
        end
      else
        begin
        }
      ts.day := t1;
      ts.month := t2;

        {
        end
        }
      end;
    end
  else if not isANumber(tokens[0]) and not isANumber(tokens[1]) then
    raise EKDateFormatError.Create('Couldn''t find a valid number for the day of month')
  else
    begin
    if not isANumber(tokens[0]) then
      begin
      month := tokens[0];
      day := tokens[1];
      end
    else
      begin
      month := tokens[1];
      day := tokens[0];
      end;
    ts.day := UserStrToInt(day, 'Day from "' + date + '"');
    ts.month := RecogniseMonth(month);
    end;
end;

function CanRecogniseMonth(s: String): Boolean;
begin
  try
    RecogniseMonth(s);
    Result := True;
  except
    Result := False;
    end;
end;

function StrToIntWithError(s, n: String): Integer;
begin
  try
    Result := StrToInt(s);
  except
    raise EHL7UserException.Create(n + ' [' + s + '] is not a valid integer');
    end;
end;

function OpenReadDate(adate: String; AllowNoDay: Boolean = False): TTimeStamp;
var
  tokens: TStringList;
  KnownDayOfWeek: String;
  AddedDay: Boolean;
  //    t, t1,t2:integer;
  //    s, month, day, KnownDayOfWeek:string;
begin
  AddedDay := False;
  try
    if SameText(adate, 't') then
      begin
      Result := DateTimeToTS(trunc(now));
      exit;
      end;
    if (SameText(adate, 'p')) or (SameText(adate, 'y')) then
      begin
      Result := DateTimeToTS(trunc(now) - 1);
      exit;
      end;
    if ((adate[1] = '+') or (adate[1] = '-')) and IsANumber(copy(adate, 2, length(aDate) - 1)) then
      begin
      if (adate[1] = '+') then
        Result := DateTimeToTS(trunc(now) + StrToIntWithError(copy(adate, 2, length(adate) - 1), 'number'))
      else
        Result := DateTimeToTS(trunc(now) - StrToIntWithError(copy(adate, 2, length(adate) - 1), 'number'))
      end;
    ReplaceSubString(adate, '+', ' ');
    fillchar(Result, sizeof(Result), #0);
    tokens := TStringList.Create;
    try
      KnownDayOfWeek := ReadTokens(adate, tokens);
      if (tokens.Count > 3) or (tokens.Count < 2) then
        raise EKDateFormatError.Create('Basic error trying to understand date - ' + IntToStr(tokens.Count) + ' sections found');
      if AllowNoDay and CanRecogniseMonth(tokens[0]) and (tokens.Count = 2) then
        begin
        tokens.insert(0, '1');
        AddedDay := True;
        end;
      Result.Year := ReadYear(tokens, adate);
      ReadMonthDay(tokens, adate, Result);
      EnforceDateIsValid(Result.year, Result.month, Result.Day);
      if KnownDayOfWeek <> '' then
        begin
        if DayOfWeek(TSToDateTime(Result)) <> RecogniseDay(KnownDayOfWeek) then
          raise EKDateFormatError.Create('The Day of week given did not match the date given (' + GetDayName(DayOfWeek(TSToDateTime(Result))) + ')');
        end;
      if AddedDay then
        Result.Day := 0;
    finally
      tokens.Free;
      end;
  except
    on e:
    EKDateFormatError do
      begin
      e.message := 'Date "' + adate + '" does not appear to be a valid date: ' + e.message;
      raise;
      end;
    on e:
    Exception do
      raise EKDateFormatError.Create('Date "' + adate + '" does not appear to be a valid date: ' + e.message);
    end;
end;

function OpenReadTime(atime: String): TDateTime;
  function bit(s, f: Integer; desc: String): Integer;
    begin
    try
      Result := UserStrToInt(substring(atime, s, f + 1), desc + ' from "' + atime + '"');
    except
      on e:
      Exception do
        begin
        e.message := 'time ' + atime + ' does not appear to be a valid time';
        raise;
        end;
      end;
    end;
var
  h, n, s: Integer;
  IsPM: Boolean;
begin
  n := 0;
  s := 0;
  atime := Uppercase(stripchar(atime, ' '));
  IsPM := False;
  if (pos('AM', atime) = length(atime) - 1) or (pos('PM', atime) = length(atime) - 1) then
    begin
    IsPM := pos('PM', atime) = length(atime) - 1;
    atime := copy(atime, 1, length(atime) - 2);
    end;
  case length(atime) of
    1:
      h := bit(1, 1, 'hour');
    2:
      h := bit(1, 2, 'hour');
    3:
      begin
      h := bit(1, 1, 'hour');
      n := bit(2, 3, 'minute');
      end;
    4:
      begin
      if atime[2] = ':' then
        begin
        h := bit(1, 1, 'hour');
        n := bit(3, 4, 'minute');
        end
      else
        begin
        h := bit(1, 2, 'hour');
        n := bit(3, 4, 'minute');
        end;
      end;
    5:
      if atime[3] = ':' then
        begin
        h := bit(1, 2, 'hour');
        n := bit(4, 5, 'minute');
        end
      else
        begin
        h := bit(1, 1, 'hour');
        n := bit(2, 3, 'minute');
        s := bit(4, 5, 'second');
        end;
    6:
      begin
      h := bit(1, 2, 'hour');
      n := bit(3, 4, 'minute');
      s := bit(5, 6, 'second');
      end;
    7:
      begin
      h := bit(1, 1, 'hour');
      n := bit(3, 4, 'minute');
      s := bit(6, 7, 'second');
      end;
    8:
      begin
      h := bit(1, 2, 'hour');
      n := bit(4, 5, 'minute');
      s := bit(7, 8, 'second');
      end;
    else 
      raise EKDateFormatError.Create('time ' + atime + ' does not appear to be a valid time');
    end;
  if isPM then
    begin
    if h = 12 then
      h := 0
    else if h > 12 then
      raise Exception.Create('invalid date format with "PM" - hour is greater than 12')
    else
      h := h + 12;
    end;
  while s >= 60 do
    begin
    inc(n);
    dec(s, 60);
    end;
  while n >= 60 do
    begin
    inc(h);
    dec(n, 60);
    end;
  if h > 23 then
    h := 23;
  Result := EncodeTime(h, n, s, 0);
end;

procedure IncrementMonth(var d: TTimeStamp);
begin
  if d.month = 12 then
    begin
    inc(d.year);
    d.month := 1
    end
  else
    inc(d.month);
end;

procedure IncrementWeek(var d: TTimeStamp);
var 
  i: Integer;
begin
  for i := 1 to 7 do
    IncrementDay(d);
end;

procedure IncrementWeekDay(var d: TTimeStamp);
begin
  IncrementDay(d);
  while (dayofweek(TStoDateTime(d)) = 1) or (dayofweek(TStoDateTime(d)) = 7) do
    IncrementDay(d);
end;

procedure IncrementQuarter(var d: TTimeStamp);
var 
  i: Integer;
begin
  for i := 1 to 3 do
    Incrementmonth(d);
end;

procedure IncrementYear(var d: TTimeStamp);
begin
  inc(d.year);
end;

function DTIncrementMonth(var d: TDateTime): TDateTime;
var 
  dtimestamp: TTimeStamp;
begin
  dtimestamp := DateTimetoTS(d);
  IncrementMonth(dtimestamp);
  Result := TSToDateTime(dtimestamp);
end;


procedure IncrementDay(var d: TTimeStamp);
begin
  inc(d.day);
  case d.month of
    1:
      if d.day = 32 then
        begin
        d.month := 2;
        d.day := 1;
        end;
    2:
      if (IsLeapYear(d.year) and (d.day = 30)) or (not IsLeapYear(d.year) and (d.day = 29)) then
        begin
        d.month := 3;
        d.day := 1;
        end;
    3:
      if d.day = 32 then
        begin
        d.month := 4;
        d.day := 1;
        end;
    4:
      if d.day = 31 then
        begin
        d.month := 5;
        d.day := 1;
        end;
    5:
      if d.day = 32 then
        begin
        d.month := 6;
        d.day := 1;
        end;
    6:
      if d.day = 31 then
        begin
        d.month := 7;
        d.day := 1;
        end;
    7:
      if d.day = 32 then
        begin
        d.month := 8;
        d.day := 1;
        end;
    8:
      if d.day = 32 then
        begin
        d.month := 9;
        d.day := 1;
        end;
    9:
      if d.day = 31 then
        begin
        d.month := 10;
        d.day := 1;
        end;
    10:
      if d.day = 32 then
        begin
        d.month := 11;
        d.day := 1;
        end;
    11:
      if d.day = 31 then
        begin
        d.month := 12;
        d.day := 1;
        end;
    12:
      if d.day = 32 then
        begin
        inc(d.year);
        d.month := 1;
        d.day := 1;
        end;
    else 
      raise Exception.Create('unknown month in NextDay');
    end;
end;

function DTIncrementDay(var d: TDateTime): TDateTime;
var 
  dtimestamp: TTimeStamp;
begin
  dtimestamp := DateTimetoTS(d);
  IncrementDay(dtimestamp);
  Result := TSToDateTime(dtimestamp);
end;

{$IFNDEF LINUX}

function GetTimeZoneBias: TDateTime;
var 
  lpTimeZoneInformation: TTimeZoneInformation;
  DaylightBias: Boolean;
  bias: Integer;
begin
  DaylightBias := GetTimeZoneInformation(lpTimeZoneInformation) = TIME_ZONE_ID_DAYLIGHT;
  bias := lpTimeZoneInformation.bias;
  if DaylightBias then
    bias := bias + lpTimeZoneInformation.daylightbias
  else
    bias := bias + lpTimeZoneInformation.standardbias;
  Result := (bias / 1440);
end;
{$ENDIF}

function GetMonthShortName(i: Integer): String;
begin
  case i of
    1:
      Result := 'Jan';
    2:
      Result := 'Feb';
    3:
      Result := 'Mar';
    4:
      Result := 'Apr';
    5:
      Result := 'May';
    6:
      Result := 'Jun';
    7:
      Result := 'Jul';
    8:
      Result := 'Aug';
    9:
      Result := 'Sep';
    10:
      Result := 'Oct';
    11:
      Result := 'Nov';
    12:
      Result := 'Dec';
    else 
      Result := PadString(IntToStr(i), 3, '0', True);
    end;
end;

function GetMonthLongName(i: Integer; Awid: Byte = 255): String;
begin
  case i of
    1:
      Result := 'January';
    2:
      Result := 'February';
    3:
      Result := 'March';
    4:
      Result := 'April';
    5:
      Result := 'May';
    6:
      Result := 'June';
    7:
      Result := 'July';
    8:
      Result := 'August';
    9:
      Result := 'September';
    10:
      Result := 'October';
    11:
      Result := 'November';
    12:
      Result := 'December';
    else 
      begin
      Result := IntToStr(i);
      if Awid <> 255 then
        if length(Result) < Awid then
          Result := PadString(Result, AWid, '0', True);
      end;
    end;
end;

procedure FindBlock(ch: Char; const s: String; var start, blength: Integer);
begin
  start := pos(ch, s);
  if start = 0 then
    blength := 0
  else
    begin
    blength := 1;
    while (start + blength <= length(s)) and (s[start + blength] = ch) do 
      inc(blength);
    end;
end;


function GetDayName(i: Integer): String;
begin
  case i of
    1:
      Result := 'Sunday';
    2:
      Result := 'Monday';
    3:
      Result := 'Tuesday';
    4:
      Result := 'Wednesday';
    5:
      Result := 'Thursday';
    6:
      Result := 'Friday';
    7:
      Result := 'Saturday';
    else 
      raise Exception.Create(IntToStr(i) + ' is not a valid day of the week');
    end;
end;

function ReadMonthName(s: String): Integer;
begin
  s := lowercase(s);
  if s = 'jan' then 
    Result := 1 
  else if s = 'feb' then 
    Result := 2 
  else if s = 'mar' then 
    Result := 3 
  else if s = 'apr' then 
    Result := 4 
  else if s = 'may' then 
    Result := 5 
  else if s = 'jun' then 
    Result := 6 
  else if s = 'jul' then 
    Result := 7 
  else if s = 'aug' then 
    Result := 8 
  else if s = 'sep' then 
    Result := 9 
  else if s = 'oct' then 
    Result := 10 
  else if s = 'nov' then 
    Result := 11 
  else if s = 'dec' then 
    Result := 12 
  else if s = 'january' then   
    Result := 1 
  else if s = 'february' then  
    Result := 2 
  else if s = 'march' then     
    Result := 3 
  else if s = 'april' then     
    Result := 4 
  else if s = 'june' then      
    Result := 6 
  else if s = 'july' then      
    Result := 7 
  else if s = 'august' then    
    Result := 8 
  else if s = 'september' then 
    Result := 9
  else if s = 'october' then   
    Result := 10 
  else if s = 'november' then  
    Result := 11 
  else if s = 'december' then  
    Result := 12 
  else
    Result := -1;
end;

function DescribePeriod(Period: TDateTime): String;
begin
  if period < 0 then
    period := -period;
  if Period < SECOND_LENGTH then
    Result := IntToStr(trunc(Period * 1000 / SECOND_LENGTH)) + 'ms'
  else if Period < 180 * SECOND_LENGTH then
    Result := IntToStr(trunc(Period / SECOND_LENGTH)) + 'sec'
  else if Period < 180 * MINUTE_LENGTH then
    Result := IntToStr(trunc(Period / MINUTE_LENGTH)) + 'min'
  else if Period < 72 * 60 * MINUTE_LENGTH then
    Result := IntToStr(trunc(Period / (MINUTE_LENGTH * 60))) + 'hr'
  else
    Result := IntToStr(trunc(Period)) + ' days';
end;

{$IFNDEF LINUX}

function NowAsString: String;
var
  SystemTime: TSystemTime;
begin
  GetLocalTime(SystemTime);
  with SystemTime do
    Result := PadString(IntToStr(wYear), 4, '0', False) +
      PadString(IntToStr(wMonth), 2, '0', True) +
      PadString(IntToStr(wDay), 2, '0', True) +
      PadString(IntToStr(wHour), 2, '0', True) +
      PadString(IntToStr(wMinute), 2, '0', True) +
      PadString(IntToStr(wSecond), 2, '0', True) +
      PadString(IntToStr(wMilliseconds), 3, '0', True);
end;
{$ELSE}

function NowAsString: String;
begin
  Result := FormatDateTime('yyyymmddhhnnsszzz', now);
end;
{$ENDIF}


function TimeStamp(Year: SmallInt;
  Month: Word;
  Day: Word;
  Hour: Word;
  Minute: Word;
  Second: Word;
  Fraction: Cardinal): TTimeStamp;
begin  
  Result.Year := Year;
  Result.Month := Month;
  Result.Day := Day;
  Result.Hour := Hour;
  Result.Minute := Minute;
  Result.Second := Second;
  Result.Fraction := Fraction;
end;

function TSEqual(TS1, TS2: TTimeStamp): Boolean;
begin  
  Result := (TS1.Year = TS2.Year) and (TS1.Month = TS2.Month) and (TS1.Day = TS2.Day) and (TS1.Hour = TS2.Hour) and (TS1.Minute = TS2.Minute) and (TS1.Second = TS2.Second) and (TS1.Fraction = TS2.Fraction);
end;

function TSSmaller(TS1, TS2: TTimeStamp): Boolean;
begin  
  if TS1.Year <> TS2.Year then    
    Result := TS1.Year < TS2.Year  
  else if TS1.Month <> TS2.Month then    
    Result := TS1.Month < TS2.Month  
  else if TS1.Day <> TS2.Day then    
    Result := TS1.Day < TS2.Day  
  else if TS1.Hour <> TS2.Hour then    
    Result := TS1.Hour < TS2.Hour  
  else if TS1.Minute <> TS2.Minute then    
    Result := TS1.Minute < TS2.Minute  
  else if TS1.Second <> TS2.Second then    
    Result := TS1.Second < TS2.Second  
  else if TS1.Fraction <> TS2.Fraction then    
    Result := TS1.Fraction < TS2.Fraction  
  else    
    Result := False;
end;

function TSCompare(TS1, TS2: TTimeStamp): Integer;
begin  
  if TSEqual(TS1, TS2) then    
    Result := 0  
  else if TSSmaller(TS1, TS2) then    
    Result := -1  
  else    
    Result := 1;
end;

function TSToDateTime(TS: TTimeStamp): TDateTime;
begin  
  with TS do 
    Result := EncodeDate(Year, Month, Day) + EncodeTime(Hour, Minute, Second, Fraction div 1000000);
end;

function DateTimeToTS(DateTime: TDateTime): TTimeStamp;
var
  DTYear, DTMonth, DTDay, DTHour, DTMinute, DTSecond, DTFraction: Word;
begin  
  DecodeDate(DateTime, DTYear, DTMonth, DTDay);
  DecodeTime(DateTime, DTHour, DTMinute, DTSecond, DTFraction);
  with Result do 
    begin    
    Year := DTYear;
    Month := DTMonth;
    Day := DTDay;
    Hour := DTHour;
    Minute := DTMinute;
    Second := DTSecond;
    Fraction := DTFraction * 1000000;
    end;
end;

function NullTS: TTimeStamp;
begin  
  Result := DateTimeToTS(0);
end;

function TSNull(TS: TTimeStamp): Boolean;
begin  
  Result := TSEqual(TS, NullTS);
end;

function TSAsDate(TS: TTimeStamp): TDate;
begin  
  with Result do 
    begin    
    Year := TS.Year;
    Month := TS.Month;
    Day := TS.Day;
    end;
end;

function DateAsTS(D: TDate): TTimeStamp;
begin  
  Result := NullTS;
  with Result do 
    begin    
    Year := D.Year;
    Month := D.Month;
    Day := D.Day;
    end;
end;

function TSAsTime(TS: TTimeStamp): TTime;
begin  
  with Result do 
    begin    
    Hour := TS.Hour;
    Minute := TS.Minute;
    Second := TS.Second;
    end;
end;

function TimeAsTS(T: TTime): TTimeStamp;
begin  
  Result := NullTS;
  with Result do 
    begin    
    Hour := T.Hour;
    Minute := T.Minute;
    Second := T.Second;
    end;
end;

initialization
  {$IFDEF INKESTRAL}
  RegisterUnimportantExceptionClass(EKDateFormatError);
  {$ENDIF}

  iPreCentWindow := ((ThisYear mod 100)) - 70;
  if iPreCentWindow < 0 then
    iPreCentWindow := iPreCentWindow + 100;
  TwoDigitYearCenturyWindow := iPreCentWindow;
  if kdeVersionMark = '' then
    exit; {never remove this check - see Jeff Sinclair }
end.
