{
 Copyright 1998 - 2002  Kestral Computing P/L
 http://www.kestral.com.au    http://www.hl7connect.com
}

{!!}
{0.00-002  03 Dec 02 11:30   [17313]   User : Grahame Grieve          fix for kestral base object}
{0.00-001  03 Dec 02 10:00   [17313]   User : Grahame Grieve          prepare for hl7_dict release}
{0.00-000  18 Jul 02 14:45   []        User : Grahame Grieve          File First added to CodeVault}

unit HL7_Dict_Utils;

{$I hl7_dict.inc}

interface

uses
  Classes,
  {$IFDEF DEVELOPMENT}
  IdSoapDebug,
  {$ENDIF}
  {$IFDEF INKESTRAL}
  KBase,
  {$ENDIF}
  SyncObjs,
  SysUtils,
  Windows;

const
  CRLF = #13#10;

type
  {$IFDEF INKESTRAL}
  THL7BaseObject = class {$IFDEF DEVELOPMENT}(TBaseObject){$ENDIF}
  Public
    function TestValid(AClass: TClass): Boolean;
  end;

  EHL7UserException = EUserException;

  {$ELSE}

  THL7BaseObject = class {$IFDEF DEVELOPMENT}(TIdBaseObject){$ENDIF}
  Public
    function TestValid(AClass: TClass): Boolean;
  end;

  EHL7UserException = Exception;
  {$ENDIF}

{
THL7StringList and THL7CriticalSection are borrowed from IndySoap to avoid
having unit dependencies into IndySoap
}

type
  // owns objects
  THL7StringList = class(TStringList)
  Private
    FOwnsObjects: Boolean;
  Public
    constructor Create(AOwnsObjects: Boolean = False);
    destructor Destroy; Override;
    procedure Clear; Override;
    procedure Delete(AIndex: Integer); Override;
    property OwnsObjects: Boolean Read FOwnsObjects Write FOwnsObjects;
    function TestValid(AClassType: TClass = NIL): Boolean;
  end;

  // has LockedToMe
  THL7CriticalSection = class(TSynchroObject)
  Protected
    FSection: TRTLCriticalSection;
    FOwnerThread: Cardinal;
    FOwnerThreadCount: Cardinal;
  Public
    constructor Create;
    destructor Destroy; Override;
    procedure Acquire; Override;
    procedure Release; Override;
    procedure Enter;
    procedure Leave;
    function LockedToMe: Boolean;
  end;

  TDirectoryListFileInfo = class(TObject)
  Private
    FDate: TDateTime;
    FSize: Integer;
  Public
    property Date: TDateTime Read FDate;
    property Size: Integer Read FSize;
  end;

  TDirectoryList = class(THL7StringList)
  Private
    procedure ReadDirectory(const AFolder, AExtension: String);
  Public
    constructor Create(const AFolder, AExtension: String);
  end;

function PadString(const AStr: String; AWidth: Integer; APadChar: Char; APadLeft: Boolean): String;
procedure StringAppendStart(var VStr: String; var VLen: Integer);
procedure StringAppend(var VStr: String; AStrToAdd: String; var VLen: Integer; ADivChar: Char = #0);
procedure StringAppendCRLF(var VStr: String; AStrToAdd: String; var VLen: Integer; ADivChar: Char = #0);
procedure StringAppendClose(var VStr: String; ALen: Integer);
procedure CommaAdd(var AStr: String; AStrToAdd: String);
function StripChar(AStr: String; AChar: Char): String;
function isANumber(const AStr: String): Boolean;
function TitleCase(const AStr: String): String;
function LowCase(AChar: Char): Char;
procedure Split(const AStr, AToken: String; var ALeft, ARight: String);
function MimeEnCode(const AStr: String; AExceptions: String = ''): String;
function StripSoln(const AStr: String): String;
function StrToIntWithError(AStr, AErrorMessage: String): Integer;
function Substring(AStr: String; ABeginPos, AEndPos: Integer): String;
function UnixToDos(const AStr: String): String;
function DosToUnix(const AStr: String): String;
function GetStringCell(const ADelimitedString: String; ACell: Cardinal; ADelimiter: Char): String;
  {$IFNDEF VER140}
function DirectoryExists(const Directory: String): Boolean;
function IncludeTrailingPathDelimiter(const S: String): String;
  {$ENDIF}
function ExtractFileNameNoExt(const AStr: String): String;
function ReplaceSubString(var AStr: String; const ASearchStr, AReplaceStr: String): Boolean;

resourcestring 
  KdeVersionMark = {!!uv}'!-!HL7_Dict_Utils.pas,0.00-002,03 Dec 02 11:30,14145';

implementation

uses
  Math;

function PadString(const AStr: String; AWidth: Integer; APadChar: Char; APadLeft: Boolean): String;
begin
  if Length(AStr) >= AWidth then
    Result := AStr
  else
    begin
    SetLength(Result, AWidth);
    FillChar(Result[1], AWidth, APadChar);
    if AStr <> '' then
      if APadLeft then
        Move(AStr[1], Result[(AWidth - Length(AStr)) + 1], Length(AStr))
      else
        Move(AStr[1], Result[1], Length(AStr))
    end;
end;

procedure StringAppendStart(var VStr: String; var VLen: Integer);
begin
  VLen := Length(VStr);
  SetLength(VStr, Length(VStr) + 4096);
end;

procedure StringAppend(var VStr: String; AStrToAdd: String; var VLen: Integer; ADivChar: Char = #0);
  //procedure StringAppend(var s: String; ns: String; var len: Integer; divchar: Char = #0);
var
  LOffset: Integer;
begin
  if (AStrToAdd = '') and (ADivChar = #0) then
    begin
    exit;
    end;
  if (ADivChar <> #0) and (VLen <> 0) then
    LOffset := 1
  else
    LOffset := 0;
  if VLen + LOffset + length(AStrToAdd) > length(VStr) then
    SetLength(VStr, length(VStr) + Max(4096, LOffset + length(AStrToAdd)));
  if LOffset = 1 then
    VStr[VLen + 1] := ADivChar;
  move(AStrToAdd[1], VStr[VLen + LOffset + 1], length(AStrToAdd));
  inc(VLen, LOffset + length(AStrToAdd));
end;

procedure StringAppendCRLF(var VStr: String; AStrToAdd: String; var VLen: Integer; ADivChar: Char = #0);
begin
  StringAppend(VStr, AStrToAdd, VLen);
  StringAppend(VStr, CRLF, VLen);
end;

procedure StringAppendClose(var VStr: String; ALen: Integer);
begin
  SetLength(VStr, ALen);
end;

procedure CommaAdd(var AStr: String; AStrToAdd: String);
begin
  if AStr = '' then
    AStr := AStrToAdd
  else
    AStr := AStr + ', ' + AStrToAdd;
end;

function StripChar(AStr: String; AChar: Char): String;
var
  i: Integer;
begin
  for i := Length(AStr) downto 1 do
    if AStr[i] = AChar then
      Delete(AStr, i, 1);
  Result := AStr;
end;

function isANumber(const AStr: String): Boolean;
var
  LVal: Integer;
  LErr: Integer;
begin
  if AStr = '' then
    begin
    Result := False
    end
  else
    begin
    Val(AStr, LVal, LErr);
    if LVal = -1 then
      begin
      // do nothing but remove hint
      end;
    Result := LErr = 0;
    end;
end;

function LowCase(AChar: Char): Char;
asm
{ ->    AL      Character       }
{ <-    AL      Result          }

        CMP     AL,'A'
        JB      @@exit
        CMP     AL,'Z'
        JA      @@exit
        ADD     AL,'a' - 'A'
@@exit:
end;

procedure Split(const AStr, AToken: String; var ALeft, ARight: String);
var
  i: Integer;
  LLocalStr: String;
begin
  { It is possible that left or right may be the same
     variable as src. so we copy it first }
  LLocalStr := AStr;
  i := Pos(AToken, LLocalStr);
  if i = 0 then
    begin
    ALeft := LLocalStr;
    ARight := '';
    end
  else
    begin
    ALeft := Copy(LLocalStr, 1, i - 1);
    ARight := Copy(LLocalStr, i + Length(AToken), Length(LLocalStr));
    end;
end;

function MimeEnCode(const AStr: String; AExceptions: String = ''): String;
var
  i, LStrLength: Integer;
  LTempLength: Integer;
begin
  Result := '';
  StringAppendStart(Result, LTempLength);
  try
    LStrLength := Length(AStr);
    i := 1;
    while i <= LStrLength do
      begin
      case AStr[i] of
        '0'..'9', 'A'..'Z', 'a'..'z', ':', '@', '/':
          StringAppend(Result, AStr[i], LTempLength);
        ' ':
          StringAppend(Result, '+', LTempLength);
        else
          if Pos(AStr[i], AExceptions) > 0 then
            StringAppend(Result, AStr[i], LTempLength)
          else
            StringAppend(Result, '%' + IntToHex(Ord(AStr[i]), 2), LTempLength);
        end;
      inc(i);
      end;
  finally
    StringAppendClose(Result, LTempLength);
    end;
end;

function StripSoln(const AStr: String): String;
begin
  Result := AStr;
  while (Length(Result) > 0) and (Result[1] in [#13, #10, ' ', #9]) do
    Delete(Result, 1, 1);
end;

function StrToIntWithError(AStr, AErrorMessage: String): Integer;
var
  E: Integer;
begin
  Val(AStr, Result, E);
  if E <> 0 then
    begin
    raise EConvertError.CreateFmt('%s [%s] is not a valid Integer (char %d)', [AErrorMessage, AStr, E]);
    end;
end;

function Substring(AStr: String; ABeginPos, AEndPos: Integer): String;
begin
  Result := Copy(AStr, ABeginPos, AEndPos - ABeginPos);
end;

function UnixToDos(const AStr: String): String;
var
  i: Integer;
begin
  Result := AStr;
  for i := Length(Result) downto 1 do
    if Result[i] = #13 then
      Insert(#10, Result, i + 1);
end;

function DosToUnix(const AStr: String): String;
var
  i: Integer;
begin
  Result := AStr;
  for i := Length(Result) downto 1 do
    if Result[i] = #10 then
      Delete(Result, i, 1);
end;

function GetStringCell(const ADelimitedString: String; ACell: Cardinal; ADelimiter: Char): String; Overload;
  // returns the string corresponding to cell ACell in a delimited string
  // first cell is 0. returns '' if ACell > actual number
var
  LCurrentCell, j, k: Cardinal;
begin
  j := 1;
  LCurrentCell := 0;
  if (length(ADelimitedString) > 0) and (ADelimitedString[1] = ADelimiter) and (ACell = 0) then
    begin
    Result := '';
    exit;
    end;
  while (LCurrentCell < ACell) and (j < Cardinal(length(ADelimitedString))) do
    begin
    if ADelimitedString[j] = ADelimiter then
      inc(LCurrentCell);
    if (LCurrentCell < ACell) then
      inc(j);
    end;
  if LCurrentCell < ACell then
    Result := ''
  else
    begin
    k := j;
    while (k < Cardinal(length(ADelimitedString))) and (ADelimitedString[k + 1] <> ADelimiter) do
      inc(k);
    if LCurrentCell = 0 then
      Result := copy(ADelimitedString, j, (k - j) + 1)
    else
      Result := copy(ADelimitedString, j + 1, (k - j));
    end;
end;

{$IFNDEF VER140}
function DirectoryExists(const Directory: String): Boolean;
var
  Code: Integer;
begin
  Code := GetFileAttributes(PChar(Directory));
  Result := (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code <> 0);
end;

const
  PathDelim = '\';

function IsPathDelimiter(const S: String; Index: Integer): Boolean;
begin
  Result := (Index > 0) and (Index <= Length(S)) and (S[Index] = PathDelim) and (ByteType(S, Index) = mbSingleByte);
end;

function IncludeTrailingPathDelimiter(const S: String): String;
begin
  Result := S;
  if not IsPathDelimiter(Result, Length(Result)) then
    Result := Result + PathDelim;
end;
{$ENDIF}

function ExtractFileNameNoExt(const AStr: String): String;
var
  LTemp: String;
  i: Integer;
begin
  LTemp := ExtractFilename(AStr);
  i := length(LTemp);
  while (i > 0) and ((LTemp[i] > '.') or (LTemp[i] = '*')) do
    Dec(i);
  if i = 0 then
    Result := LTemp
  else
    Result := Copy(LTemp, 1, i - 1);
end;

function ReplaceSubString(var AStr: String; const ASearchStr, AReplaceStr: String): Boolean;
var
  LPos, LLen: Integer;
  LHoldingStr: String;
begin
  LLen := length(ASearchStr);
  Result := False;
  LHoldingStr := '';
  while Pos(ASearchStr, AStr) > 0 do
    begin
    LPos := Pos(ASearchStr, AStr);
    LHoldingStr := LHoldingStr + Copy(AStr, 1, LPos - 1) + AReplaceStr;
    AStr := Copy(AStr, LPos + LLen, length(AStr));
    Result := True;
    end;
  AStr := LHoldingStr + AStr;
end;

{ THL7StringList }

constructor THL7StringList.Create;
begin
  inherited Create;
  FOwnsObjects := AOwnsObjects;
  {$IFDEF DEVELOPMENT}
  IdObjectRegister(self);
  {$ENDIF}
end;


destructor THL7StringList.Destroy;
const 
  ASSERT_LOCATION = 'HL7_Dict_Utils.THL7StringList.Destroy';
begin
  assert(assigned(self), ASSERT_LOCATION + ': self is nil');
  Clear;
  {$IFDEF DEVELOPMENT}
  IdObjectDeregister(self);
  {$ENDIF}
  inherited Destroy;
end;

procedure THL7StringList.Clear;
const 
  ASSERT_LOCATION = 'HL7_Dict_Utils.THL7StringList.Clear';
var
  i: Integer;
  LObj: TObject;
begin
  assert(assigned(self), ASSERT_LOCATION + ': self is nil');
  if FOwnsObjects then
    begin
    for i := Count - 1 downto 0 do
      begin
      LObj := objects[i];
      objects[i] := NIL;
      Delete(i);
      FreeAndNil(LObj);
      end;
    end;
  inherited Clear;
end;

procedure THL7StringList.Delete(AIndex: Integer);
const 
  ASSERT_LOCATION = 'HL7_Dict_Utils.THL7StringList.Delete';
begin
  assert(assigned(self), ASSERT_LOCATION + ': self is nil');
  // AIndex checked in ancestor
  if FOwnsObjects then
    begin
    Objects[AIndex].Free;    // can't use FreeAndNil
    Objects[AIndex] := NIL;
    end;
  inherited Delete(AIndex);
end;

function THL7StringList.TestValid(AClassType: TClass): Boolean;
const 
  ASSERT_LOCATION = 'HL7_Dict_Utils.THL7StringList.TestValid';
begin
  {$IFDEF DEVELOPMENT}
  Result := IdObjectTestValid(self);
  {$ELSE}
  Result := Assigned(self);
  {$ENDIF}
  if Result and assigned(AClassType) then
    begin
    Result := self is AClassType;
    end;
end;

function TitleCase(const AStr: String): String;
var
  i: Integer;
begin
  Result := AStr;
  if Result <> '' then
    begin
    Result[1] := Upcase(Result[1]);
    for i := 2 to Length(Result) do
      if Result[i - 1] in [' ', '_', '.', '-', '/', '\', '''', '(', ')', ','] then
        Result[i] := Upcase(Result[i])
    else
      Result[i] := Lowcase(Result[i]);
    end;
end;

{ THL7CriticalSection }

constructor THL7CriticalSection.Create;
begin
  inherited Create;
  IdObjectRegister(self);
  InitializeCriticalSection(FSection);
  FOwnerThread := 0;
  FOwnerThreadCount := 0;
end;

destructor THL7CriticalSection.Destroy;
const 
  ASSERT_LOCATION = 'HL7_Dict_Utils.THL7CriticalSection.Destroy';
begin
  Assert(Assigned(Self), ASSERT_LOCATION + ': Self is nil');
  IdObjectDeregister(self);
  DeleteCriticalSection(FSection);
  inherited Destroy;
end;

procedure THL7CriticalSection.Acquire;
const 
  ASSERT_LOCATION = 'HL7_Dict_Utils.THL7CriticalSection.Acquire';
begin
  Assert(Assigned(Self), ASSERT_LOCATION + ': Self is nil');
  EnterCriticalSection(FSection);
  assert((FOwnerThread = 0) or (FOwnerThread = GetCurrentThreadid));
  if FOwnerThread = GetCurrentThreadid then
    begin
    inc(FOwnerThreadCount);
    end
  else
    begin
    FOwnerThread := GetCurrentThreadId;
    FOwnerThreadCount := 1;
    end;
end;

procedure THL7CriticalSection.Release;
const 
  ASSERT_LOCATION = 'HL7_Dict_Utils.THL7CriticalSection.Release';
begin
  Assert(Assigned(Self), ASSERT_LOCATION + ': Self is nil');
  Assert(FOwnerThread = GetCurrentThreadID);
  dec(FOwnerThreadCount);
  if FOwnerThreadCount = 0 then
    FOwnerThread := 0;
  LeaveCriticalSection(FSection);
end;

procedure THL7CriticalSection.Enter;
begin
  Acquire;
end;

procedure THL7CriticalSection.Leave;
begin
  Release;
end;

function THL7CriticalSection.LockedToMe: Boolean;
const 
  ASSERT_LOCATION = 'HL7_Dict_Utils.THL7CriticalSection.LockedToMe';
begin
  Assert(Assigned(Self), ASSERT_LOCATION + ': Self is nil');
  Result := FOwnerThread = GetCurrentThreadId;
end;



{ TDirectoryList }

constructor TDirectoryList.Create(const AFolder, AExtension: String);
begin
  inherited Create(True);
  assert(AFolder <> '');
  assert(AExtension <> '');
  ReadDirectory(AFolder, AExtension);
end;

procedure TDirectoryList.ReadDirectory(const AFolder, AExtension: String);
var
  LSearchRec: TSearchRec;
  LFound: Integer;
  d: TDirectoryListFileInfo;
begin
  assert(assigned(self));
  assert(AFolder <> '');
  assert(AExtension <> '');
  LFound := FindFirst(IncludeTrailingPathDelimiter(Afolder) + '*.' + AExtension, faAnyfile, LSearchRec);
  try
    while LFound = 0 do
      begin
      if not (LSearchRec.Attr and faDirectory = faDirectory) then
        begin
        d := TDirectoryListFileInfo.Create;
        d.FSize := LSearchRec.Size;
        d.FDate := FileDateToDateTime(LSearchRec.Time);
        AddObject(IncludeTrailingPathDelimiter(AFolder) + LSearchRec.Name, d);
        end;
      LFound := FindNext(LSearchRec);
      end;
  finally
    sysutils.FindClose(LSearchRec);
    end;
end;

{ THL7BaseObject }

function THL7BaseObject.TestValid(AClass: TClass): Boolean;
begin
  Result := True;
end;


initialization
  if kdeVersionMark = '' then 
    exit; {never remove this check - see the National Development Manager } 
end.
