{!!}
{0.00-016  03 Dec 02 10:00   [17313]   User : Grahame Grieve          prepare for hl7_dict release}
{0.00-015  13 Nov 02 10:36   [15715]   User : Grahame Grieve          remove licensed property}
{0.00-014  18 Jul 02 13:09   [15715]   User : Grahame Grieve          rewrite HL7_Dict}
{0.00-013  11 Feb 02 11:49   [14984]   User : Grahame Grieve          fax case, add lock names}
{0.00-012  09 Feb 02 22:51   [14002]   User : Grahame Grieve          fix case of unit declaration}
{0.00-011  07 Nov 01 12:58    User : Grahame Grieve          message segments}
{0.00-010  09 Oct 01 10:33    User : Grahame Grieve          xml support}
{0.00-009  27 Sep 01 14:08    User : Grahame Grieve          fix text format problem}
{0.00-008  03 Sep 01 12:06    User : Grahame Grieve          encrypt hl7dict.des}
{0.00-007  14 Aug 01 16:10    User : Grahame Grieve          blow up if no dictionary found}
{0.00-006  23 Jul 01 16:45    User : Grahame Grieve          change description text}
{0.00-005  10 Jul 01 17:54    User : Grahame Grieve       }
{0.00-004  12 Feb 01 18:17    User : Grahame Grieve    }
{0.00-003  10 Jan 01 12:42    User : Grahame Grieve    }
{0.00-002  25 Oct 00 09:02    User : Jeff Sinclair     }
{0.00-001  16 Oct 00 09:11    User : Grahame Grieve    }
{0.00-000  02 Oct 00 12:15    User : Grahame Grieve
Comment:
          File First added to CodeVault}

unit HL7_Dict_Text;

interface

uses
  Classes,
  HL7_Dict;

type
  TWritingContext = class
  Private
    Writer: TWriter;
    Stream: TmemoryStream;
  end;

  TAbstractCryptor = class
  Public
    procedure Encrypt(m: TMemoryStream); Virtual; Abstract;
    procedure Decrypt(m: TMemoryStream); Virtual; Abstract;
  end;

     {
       a note about licensing support.  HL7 rules concerning the distribution
       of the database this creates/uses are complex. Licencing support is
       introduced to allow distinction between licensed and unlicensed
       copies of the text database, and the program to do different things
       with them }

  THL7TextDictionary = class(THL7DictionaryDatabase)
  Private
    FCryptSvc: TAbstractCryptor;
    FFileName: String;
    FStreamList: TStringList;
    FIsWriting: Boolean;
    FLicenced: Boolean;
    procedure LoadDictionary;
    function CreateContext(Name: String): pointer;
    function GetWritingContext(Name: String): TWritingContext;
  Protected
    function VersionDefined(version: String; var desc: String): Boolean; Override;
    procedure ListVersions(VersionList: TStringList); Override;
    procedure AddVersion(Version, Description: String); Override;

    function StartLoadFields(Code, version: String): pointer; Override;
    function GetNextField(p: pointer; var Code: String; var DI: Integer;
      var Req, Rep: String;
      var RepCount, FNum: Integer): Boolean; Override;
    procedure CloseLoadFields(p: pointer); Override;
    function CountFields(version: String): Integer; Override;
    procedure AddField(Version, Code: String; Di: Integer; Req, Rep: String;
      RepCount, FNum: Integer); Override;

    function StartLoadComponents(Version: String): pointer; Override;
    function GetNextComponent(p: pointer; var Desc: String; var tid: Integer;
      var code: String; var cnum: Integer): Boolean; Override;
    procedure CloseLoadComponents(p: pointer); Override;
    function CountComponents(version: String): Integer; Override;
    procedure AddComponent(Version: String; Desc: String; tid: Integer;
      code: String; cnum: Integer); Override;

    function StartLoadDataElements(Version: String): pointer; Override;
    function GetNextElement(p: pointer; var desc, struc: String;
      var len, tid, di: Integer): Boolean; Override;
    procedure CloseLoadDataElements(p: pointer); Override;
    function CountDataElements(version: String): Integer; Override;
    procedure AddDataElement(Version: String; desc, struc: String;
      len, tid, di: Integer); Override;

    function StartLoadDataTypes(Version: String): pointer; Override;
    function GetNextDataType(p: pointer; var Name, desc: String;
      var len: Integer): Boolean; Override;
    procedure CloseLoadDataTypes(p: pointer); Override;
    function CountDataTypes(version: String): Integer; Override;
    procedure AddDataType(Version: String; Name, desc: String; len: Integer); Override;

    function StartLoadSegment(Code, Version: String): pointer; Override;
    function GetNextSegment(p: pointer; var code, desc: String): Boolean; Override;
    procedure CloseLoadSegments(p: pointer); Override;
    function CountSegments(version: String): Integer; Override;
    procedure AddSegment(version: String; code, desc: String); Override;

    function StartLoadStructures(Version: String): pointer; Override;
    function GetNextStructure(p: pointer; var struc, desc, code: String;
      var elem: Integer): Boolean; Override;
    procedure CloseLoadStructures(p: pointer); Override;
    function CountStructures(version: String): Integer; Override;
    procedure AddStructure(Version, struc, desc, code: String; elem: Integer); Override;

    function StartLoadStructureComps(Version: String): pointer; Override;
    function GetNextStructureComp(p: pointer; var struc: String;
      var fNum, cNum: Integer): Boolean; Override;
    procedure CloseLoadStructureComps(p: pointer); Override;
    function CountStructureComps(version: String): Integer; Override;
    procedure AddStructureComp(Version, struc: String; FNum, CNum: Integer); Override;

    function StartLoadTables(Version: String): pointer; Override;
    function GetNextTable(p: pointer; var desc: String;
      var tid: Integer): Boolean; Override;
    procedure CloseLoadTables(p: pointer); Override;
    function CountTables(version: String): Integer; Override;
    procedure AddTable(Version: String; desc: String; tid: Integer); Override;

    function StartLoadTableItems(Version: String): pointer; Override;
    function GetNextTableItem(p: pointer; var tid, sNum: Integer;
      var Value, desc: String): Boolean; Override;
    procedure CloseLoadTableItems(p: pointer); Override;
    function CountTableItems(version: String): Integer; Override;
    procedure AddTableItem(Version: String; tid, sNum: Integer;
      Value, desc: String); Override;

    function StartLoadEventList(Version: String): pointer; Override;
    function GetNextEvent(p: pointer; var code, desc: String): Boolean; Override;
    procedure CloseLoadEventList(p: pointer); Override;
    function CountEvents(version: String): Integer; Override;
    procedure AddEvent(Version, code, desc: String); Override;

    function StartLoadEventDetails(Version: String): pointer; Override;
    function GetNextEventDetails(p: pointer; var EventCode, SendMsg, SendStruct,
      RetMsg, RetStruct: String; var FieldNum: Integer): Boolean; Override;
    procedure CloseLoadEventDetails(p: pointer); Override;
    function CountEventDetails(version: String): Integer; Override;
    procedure AddEventDetails(Version, EventCode, SendMsg, SendStruct,
      RetMsg, RetStruct: String; FieldNum: Integer); Override;

    function StartLoadMsgStructs(Version: String): pointer; Override;
    function GetNextMsgStructs(p: pointer; var Name, Desc, ExampleEvent,
      ExampleMsgType, action: String): Boolean; Override;
    procedure CloseLoadMsgStructs(p: pointer); Override;
    function CountMsgStructs(version: String): Integer; Override;
    procedure AddMsgStruct(Version, Name, Desc, ExampleEvent,
      ExampleMsgType, action: String); Override;

    function StartLoadMsgStructSegments(Version: String): pointer; Override;
    function GetNextMsgStructSegments(p: pointer; var MsgStruct: String;
      var FieldNum: Integer; var SegCode, GroupName: String;
      var Repeats, Optional: Boolean): Boolean; Override;
    procedure CloseLoadMsgStructSegments(p: pointer); Override;
    function CountMsgStructSegments(version: String): Integer; Override;
    procedure AddMsgStructSegment(Version, MsgStruct: String;
      FieldNum: Integer; SegCode, GroupName: String;
      Repeats, Optional: Boolean); Override;

    function StartLoadEvntMsgSegments(Version: String): pointer; Override;
    function GetNextEvntMsgSegments(p: pointer; var MsgStruct: String; var FieldNum: Integer; var SegCode, GroupName: String; var Repeats, Optional: Boolean): Boolean; Override;
    procedure CloseLoadEvntMsgSegments(p: pointer); Override;
    function CountEvntMsgSegments(version: String): Integer; Override;
    procedure AddEvntMsgSegment(Version, MsgStruct: String; FieldNum: Integer; SegCode, GroupName: String; Repeats, Optional: Boolean); Override;

    procedure PrepareForLoad(wipe: Boolean); Override;
    procedure DoneLoading(TransferEvent: TOnTransferProgress); Override;
  Public
    constructor Create(AHl7Dict: String; ACryptor: TAbstractCryptor; ASuppressException: Boolean = False);
    destructor Destroy; Override;
    function SourceDescription(fulldetails: Boolean): String; Override;
  end;

  {$IFDEF WIN32}
resourcestring
  KdeVersionMark = {!!uv}'!-!HL7_Dict_Text.pas,0.00-016,03 Dec 02 10:00,9466';
  {$ENDIF}

implementation

uses
  HL7_Dict_Utils,
  SysUtils;


{ THL7TextDictionary }

constructor THL7TextDictionary.Create(AHl7Dict: String; ACryptor: TAbstractCryptor; ASuppressException: Boolean = False);
begin
  inherited Create;
  Fcryptsvc := ACryptor;
  FStreamList := THL7StringList.Create(True);
  FStreamList.Sorted := True;
  FFileName := AHl7Dict;
  FIsWriting := False;
  if FileExists(FFileName) then
    LoadDictionary
  else if not ASuppressException then
    raise EBaseHL7Exception.Create(hecNoDictionary, 'Dictionary "' + FFileName + '" not found');
end;

destructor THL7TextDictionary.Destroy;
begin
  FStreamList.Free;
  if assigned(FCryptSvc) then
    FCryptSvc.Free;
  inherited;
end;

procedure THL7TextDictionary.LoadDictionary;
var
  f: TFileStream;
  decrypt: TMemoryStream;
  r: TReader;
  n, s: String;
  m: TMemoryStream;
begin
  f := TFileStream.Create(FFileName, fmOpenRead + fmShareDenyWrite);
  try
    decrypt := TMemoryStream.Create;
    try
      decrypt.LoadFromStream(f);
      if assigned(FCryptSvc) then
        FCryptSvc.Decrypt(decrypt);
      decrypt.Position := 0;
      r := TReader.Create(decrypt, 65536);
      try
        FLicenced := r.ReadBoolean;
        r.ReadListBegin;
        while not r.EndOfList do
          begin
          n := r.readString;
          s := r.readstring;
          m := TMemoryStream.Create;
          m.Write(s[1], length(s));
          FStreamList.AddObject(n, m);
          end;
        r.ReadListEnd;
      finally
        r.Free;
        end;
    finally
      decrypt.Free;
      end;
  finally
    f.Free;
    end;
end;

{------------------------------------------------------------------------------
  Helper function
 ------------------------------------------------------------------------------}

function THL7TextDictionary.CreateContext(Name: String): pointer;
var
  i: Integer;
  s: TMemoryStream;
  r: TReader;
begin
  Result := NIL;
  try
    if not FStreamList.Find(Name, i) then
      exit;
    s := FStreamList.objects[i] as TMemoryStream;
    s.position := 0;
    r := TReader.Create(s, 4096);
    r.ReadListBegin;
    Result := r;
  except
    Result := NIL;
    end;
end;

function THL7TextDictionary.GetWritingContext(Name: String): TWritingContext;
var
  i: Integer;
begin
  if not FIsWriting then
    raise Exception.Create('Call to add a record without first calling PrepareForLoad');
  if FStreamList.find(Name, i) then
    Result := FStreamList.objects[i] as TWritingContext
  else
    begin
    Result := TWritingContext.Create;
    Result.Stream := TMemoryStream.Create;
    Result.writer := TWriter.Create(Result.Stream, 4096);
    Result.Writer.WriteListBegin;
    FStreamList.AddObject(Name, Result);
    end;
end;

procedure THL7TextDictionary.PrepareForLoad(wipe: Boolean);
begin
  FStreamList.Clear;
  FisWriting := True;
end;

function MemAsString(AMemoryStream: TMemoryStream): String;
begin
  SetLength(Result, AMemoryStream.size);
  AMemoryStream.position := 0;
  AMemoryStream.Read(Result[1], AMemoryStream.size);
end;

procedure THL7TextDictionary.DoneLoading;
var 
  i, c, t: Integer;
  w: TWritingContext;
  m: TMemoryStream;
  f: TFileStream;
  wr: TWriter;
  dummy: Boolean;
begin
  t := 0;
  for i := 0 to FStreamList.Count - 1 do
    begin
    TransferEvent(self, 'All', 'Closing Contexts', i, FStreamList.Count, dummy);
    w := FStreamList.objects[i] as TWritingContext;
    w.Writer.WriteListEnd;
    w.writer.Free;
    w.stream.position := 0;
    inc(t, w.stream.size);
    end;
  c := 0;
  m := TMemoryStream.Create;
  try
    wr := TWriter.Create(m, 65536);
    try
      wr.WriteBoolean(True);
      wr.WriteListBegin;
      for i := 0 to FStreamList.Count - 1 do
        begin
        TransferEvent(self, 'All', 'Encrypt, Save', c, t, dummy);
        w := FStreamList.objects[i] as TWritingContext;
        wr.WriteString(FStreamList[i]);
        wr.WriteString(MemAsString(w.stream));
        inc(c, w.stream.size);
        w.stream.Free;
        end;
      wr.WriteListEnd;
    finally
      wr.Free;
      end;
    m.position := 0;
    if assigned(FCryptSvc) then
      begin
      FCryptSvc.Encrypt(m);
      m.position := 0;
      end;
    f := TFileStream.Create(FFileName, fmCreate);
    try
      m.SaveToStream(f);
    finally
      f.Free;
      end;
  finally
    m.Free;
    end;
  FStreamList.Clear;
  LoadDictionary;
end;


{------------------------------------------------------------------------------
  Versions
 ------------------------------------------------------------------------------}

function THL7TextDictionary.VersionDefined(version: String; var desc: String): Boolean;
var 
  r: TReader;
begin
  Result := False;
  r := TReader(CreateContext('Versions'));
  try
    while not r.EndOfList do
      begin
      Result := (lowercase(Version) = lowercase(r.ReadString));
      if Result then
        begin
        desc := r.readString;
        exit;
        end
      else
        r.ReadString;
      end;
  finally
    r.Free;
    end;
end;

procedure THL7TextDictionary.ListVersions(VersionList: TStringList);
var 
  c: TReader;
begin
  c := TReader(CreateContext('Versions'));
  if c = NIL then
    exit;
  try
    while not c.EndOfList do
      begin
      versionlist.add(c.ReadString);
      c.ReadString;
      end;
  finally
    c.Free;
    end;
end;

procedure THL7TextDictionary.AddVersion(Version, Description: String);
begin
  with GetWritingContext('Versions').Writer do
    begin
    writestring(Version);
    WriteString(Description);
    end;
end;

{------------------------------------------------------------------------------
  Fields
 ------------------------------------------------------------------------------}

function THL7TextDictionary.StartLoadFields(Code, version: String): pointer;
begin
  Result := CreateContext('Field-' + version + '-' + Code);
end;

function THL7TextDictionary.GetNextField(p: pointer; var Code: String; var DI: Integer;
  var Req, Rep: String;
  var RepCount, FNum: Integer): Boolean;
begin
  if p = NIL then
    begin
    Result := False;
    exit;
    end;
  with (TReader(p)) do
    begin
    Result := not EndOfList;
    if Result then
      begin
      Code := ReadString;
      DI := ReadInteger;
      Rep := ReadString;
      Req := ReadString;
      RepCount := ReadInteger;
      FNum := ReadInteger;
      end;
    end;
end;

procedure THL7TextDictionary.CloseLoadFields(p: pointer);
begin
  if p <> NIL then
    (TReader(p)).Free;
end;

function THL7TextDictionary.CountFields(version: String): Integer;
begin
  Result := 0; // this isn't really valid but it will never be used
end;

procedure THL7TextDictionary.AddField(Version, Code: String; Di: Integer; Req, Rep: String;
  RepCount, FNum: Integer);
begin
  with GetWritingContext('Field-' + version + '-' + Code).Writer do
    begin
    WriteString(Code);
    WriteInteger(DI);
    WriteString(Rep);
    WriteString(Req);
    WriteInteger(RepCount);
    WriteInteger(FNum);
    end;
end;


function THL7TextDictionary.StartLoadComponents(Version: String): pointer;
begin
  Result := CreateContext('Components-' + version);
end;

function THL7TextDictionary.GetNextComponent(p: pointer; var Desc: String; var tid: Integer;
  var code: String; var cnum: Integer): Boolean;
begin
  if p = NIL then
    begin
    Result := False;
    exit;
    end;
  with TReader(p) do
    begin
    Result := not EndOfList;
    if Result then
      begin
      Desc := ReadString;
      tid := ReadInteger;
      code := ReadString;
      cnum := ReadInteger;
      end;
    end;
end;

procedure THL7TextDictionary.CloseLoadComponents(p: pointer);
begin
  if p <> NIL then
    TReader(p).Free;
end;

function THL7TextDictionary.CountComponents(version: String): Integer;
begin
  Result := 0; // this isn't really valid but it will never be used
end;

procedure THL7TextDictionary.AddComponent(Version: String; Desc: String; tid: Integer;
  code: String; cnum: Integer);
begin
  with GetWritingContext('Components-' + version).Writer do
    begin
    WriteString(Desc);
    WRiteInteger(tid);
    WriteString(code);
    WRiteInteger(cnum);
    end;
end;


function THL7TextDictionary.StartLoadDataElements(Version: String): pointer;
begin
  Result := CreateContext('DataElements-' + version);
end;

function THL7TextDictionary.GetNextElement(p: pointer; var desc, struc: String;
  var len, tid, di: Integer): Boolean;
begin
  if p = NIL then
    begin
    Result := False;
    exit;
    end;
  with TReader(p) do
    begin
    Result := not EndOfList;
    if Result then
      begin
      desc := ReadString;
      Struc := readString;
      len := ReadInteger;
      tid := readInteger;
      di := ReadInteger;
      end;
    end;
end;

procedure THL7TextDictionary.CloseLoadDataElements(p: pointer);
begin
  if p <> NIL then
    TReader(p).Free;
end;

function THL7TextDictionary.CountDataElements(version: String): Integer;
begin
  Result := 0; // this isn't really valid but it will never be used
end;

procedure THL7TextDictionary.AddDataElement(Version: String; desc, struc: String;
  len, tid, di: Integer);
begin
  with GetWritingContext('DataElements-' + version).Writer do
    begin
    WriteString(desc);
    WriteString(struc);
    WriteInteger(len);
    WriteInteger(tid);
    WriteInteger(di);
    end;
end;


function THL7TextDictionary.StartLoadDataTypes(Version: String): pointer;
begin
  Result := CreateContext('DataTypes-' + Version);
end;

function THL7TextDictionary.GetNextDataType(p: pointer; var Name, desc: String;
  var len: Integer): Boolean;
begin
  if p = NIL then
    begin
    Result := False;
    exit;
    end;
  with TReader(p) do
    begin
    Result := not EndOfList;
    if Result then
      begin
      Name := ReadString;
      desc := ReadString;
      len := ReadInteger;
      end;
    end;
end;

procedure THL7TextDictionary.CloseLoadDataTypes(p: pointer);
begin
  if p <> NIL then
    TReader(p).Free;
end;

function THL7TextDictionary.CountDataTypes(version: String): Integer;
begin
  Result := 0; // this isn't really valid but it will never be used
end;

procedure THL7TextDictionary.AddDataType(Version: String; Name, desc: String; len: Integer);
begin
  with GetWritingContext('DataTypes-' + Version).Writer do
    begin
    WriteString(Name);
    WriteString(desc);
    WriteInteger(len);
    end;
end;


function THL7TextDictionary.StartLoadSegment(Code, Version: String): pointer;
begin
  if code = '' then
    Result := CreateContext('Segments-' + version)
  else
    Result := CreateContext('Segment-' + version + '-' + code);
end;

function THL7TextDictionary.GetNextSegment(p: pointer; var code, desc: String): Boolean;
begin
  if p = NIL then
    begin
    Result := False;
    exit;
    end;
  with TReader(p) do
    begin
    Result := not EndOfList;
    if Result then
      begin
      code := ReadString;
      desc := ReadString;
      end;
    end;
end;

procedure THL7TextDictionary.CloseLoadSegments(p: pointer);
begin
  if p <> NIL then
    TReader(p).Free;
end;

function THL7TextDictionary.CountSegments(version: String): Integer;
begin
  Result := 0; // this isn't really valid but it will never be used
end;

procedure THL7TextDictionary.AddSegment(version: String; code, desc: String);
begin
  with GetWritingContext('Segment-' + version + '-' + code).Writer do
    begin
    WriteString(Code);
    WriteString(Desc);
    end;
  with GetWritingContext('Segments-' + version).Writer do
    begin
    WriteString(Code);
    WriteString(Desc);
    end;
end;


function THL7TextDictionary.StartLoadStructures(Version: String): pointer;
begin
  Result := CreateContext('Structures-' + Version);
end;

function THL7TextDictionary.GetNextStructure(p: pointer; var struc, desc, code: String;
  var elem: Integer): Boolean;
begin
  if p = NIL then
    begin
    Result := False;
    exit;
    end;
  with TReader(p) do
    begin
    Result := not EndOfList;
    if Result then
      begin
      struc := readString;
      desc := readString;
      code := readString;
      elem := readInteger;
      end;
    end;
end;

procedure THL7TextDictionary.CloseLoadStructures(p: pointer);
begin
  if p <> NIL then
    TReader(p).Free;
end;

function THL7TextDictionary.CountStructures(version: String): Integer;
begin
  Result := 0; // this isn't really valid but it will never be used
end;

procedure THL7TextDictionary.AddStructure(Version, struc, desc, code: String; elem: Integer);
begin
  with GetWritingContext('Structures-' + Version).Writer do
    begin
    WriteString(struc);
    WriteString(desc);
    WriteString(code);
    WriteInteger(elem);
    end;
end;


function THL7TextDictionary.StartLoadStructureComps(Version: String): pointer;
begin
  Result := CreateContext('StructureComps-' + Version);
end;

function THL7TextDictionary.GetNextStructureComp(p: pointer; var struc: String;
  var fNum, cNum: Integer): Boolean;
begin
  if p = NIL then
    begin
    Result := False;
    exit;
    end;
  with TReader(p) do
    begin
    Result := not EndOfList;
    if Result then
      begin
      struc := ReadString;
      fNum := ReadInteger;
      cNum := ReadInteger;
      end;
    end;
end;

procedure THL7TextDictionary.CloseLoadStructureComps(p: pointer);
begin
  if p <> NIL then
    TReader(p).Free;
end;

function THL7TextDictionary.CountStructureComps(version: String): Integer;
begin
  Result := 0; // this isn't really valid but it will never be used
end;

procedure THL7TextDictionary.AddStructureComp(Version, struc: String; FNum, CNum: Integer);
begin
  with GetWritingContext('StructureComps-' + Version).Writer do
    begin
    WriteString(Struc);
    WriteInteger(FNum);
    WriteInteger(CNum);
    end;
end;


function THL7TextDictionary.StartLoadTables(Version: String): pointer;
begin
  Result := CreateContext('Tables-' + Version);
end;

function THL7TextDictionary.GetNextTable(p: pointer; var desc: String;
  var tid: Integer): Boolean;
begin
  if p = NIL then
    begin
    Result := False;
    exit;
    end;
  with TReader(p) do
    begin
    Result := not EndOfList;
    if Result then
      begin
      desc := ReadString;
      tid := ReadInteger;
      end;
    end;
end;

procedure THL7TextDictionary.CloseLoadTables(p: pointer);
begin
  if p <> NIL then
    TReader(p).Free;
end;

function THL7TextDictionary.CountTables(version: String): Integer;
begin
  Result := 0; // this isn't really valid but it will never be used
end;

procedure THL7TextDictionary.AddTable(Version: String; desc: String; tid: Integer);
begin
  with GetWritingContext('Tables-' + Version).Writer do
    begin
    WriteString(desc);
    WriteInteger(tid);
    end;
end;


function THL7TextDictionary.StartLoadTableItems(Version: String): pointer;
begin
  Result := CreateContext('tableitems' + Version);
end;

function THL7TextDictionary.GetNextTableItem(p: pointer; var tid, sNum: Integer;
  var Value, desc: String): Boolean;
begin
  if p = NIL then
    begin
    Result := False;
    exit;
    end;
  with TReader(p) do
    begin
    Result := not EndOfList;
    if Result then
      begin
      tid := ReadInteger;
      sNum := ReadInteger;
      Value := ReadString;
      desc := ReadString;
      end;
    end;
end;

procedure THL7TextDictionary.CloseLoadTableItems(p: pointer);
begin
  if p <> NIL then
    TReader(p).Free;
end;

function THL7TextDictionary.CountTableItems(version: String): Integer;
begin
  Result := 0; // this isn't really valid but it will never be used
end;

procedure THL7TextDictionary.AddTableItem(Version: String; tid, sNum: Integer;
  Value, desc: String);
begin
  with GetWritingContext('tableitems' + Version).Writer do
    begin
    WriteInteger(tid);
    WriteInteger(sNum);
    WriteString(Value);
    WriteString(desc);
    end;
end;

function THL7TextDictionary.StartLoadEventList(Version: String): pointer;
begin
  Result := CreateContext('Events-' + Version);
end;

function THL7TextDictionary.GetNextEvent(p: pointer; var code, desc: String): Boolean;
begin
  if p = NIL then
    begin
    Result := False;
    exit;
    end;
  with TReader(p) do
    begin
    Result := not EndOfList;
    if Result then
      begin
      code := ReadString;
      desc := ReadString;
      end;
    end;
end;

procedure THL7TextDictionary.CloseLoadEventList(p: pointer);
begin
  if p <> NIL then
    TReader(p).Free;
end;

function THL7TextDictionary.CountEvents(version: String): Integer;
begin
  Result := 0; // this isn't really valid but it will never be used
end;

procedure THL7TextDictionary.AddEvent(Version, code, desc: String);
begin
  with GetWritingContext('events-' + Version).Writer do
    begin
    WriteString(code);
    WriteString(desc);
    end;
end;

function THL7TextDictionary.StartLoadMsgStructs(Version: String): pointer;
begin
  Result := CreateContext('MsgStructs-' + Version);
end;

function THL7TextDictionary.GetNextMsgStructs(p: pointer; var Name, Desc, ExampleEvent, ExampleMsgType, action: String): Boolean;
begin
  if p = NIL then
    begin
    Result := False;
    exit;
    end;
  with TReader(p) do
    begin
    Result := not EndOfList;
    if Result then
      begin
      Name := ReadString;
      Desc := ReadString;
      ExampleEvent := ReadString;
      ExampleMsgType := ReadString;
      action := ReadString;
      end;
    end;
end;

procedure THL7TextDictionary.CloseLoadMsgStructs(p: pointer);
begin
  if p <> NIL then
    TReader(p).Free;
end;

function THL7TextDictionary.CountMsgStructs(version: String): Integer;
begin
  Result := 0; // this isn't really valid but it will never be used
end;

procedure THL7TextDictionary.AddMsgStruct(Version, Name, Desc, ExampleEvent, ExampleMsgType, action: String);
begin
  with GetWritingContext('MsgStructs-' + Version).Writer do
    begin
    WriteString(Name);
    WriteString(Desc);
    WriteString(ExampleEvent);
    WriteString(ExampleMsgType);
    WriteString(action);
    end;
end;

function THL7TextDictionary.StartLoadEventDetails(Version: String): pointer;
begin
  Result := CreateContext('EventMsgType-' + Version);
end;

function THL7TextDictionary.GetNextEventDetails(p: pointer; var EventCode, SendMsg, SendStruct, RetMsg, RetStruct: String; var FieldNum: Integer): Boolean;
begin
  if p = NIL then
    begin
    Result := False;
    exit;
    end;
  with TReader(p) do
    begin
    Result := not EndOfList;
    if Result then
      begin
      EventCode := ReadString;
      SendMsg := ReadString;
      SendStruct := ReadString;
      RetMsg := ReadString;
      RetStruct := ReadString;
      FieldNum := ReadInteger;
      end;
    end;
end;

procedure THL7TextDictionary.CloseLoadEventDetails(p: pointer);
begin
  if p <> NIL then
    TReader(p).Free;
end;

function THL7TextDictionary.CountEventDetails(version: String): Integer;
begin
  Result := 0; // this isn't really valid but it will never be used
end;

procedure THL7TextDictionary.AddEventDetails(Version, EventCode, SendMsg,
  SendStruct, RetMsg, RetStruct: String; FieldNum: Integer);
begin
  with GetWritingContext('EventMsgType-' + Version).Writer do
    begin
    WriteString(EventCode);
    WriteString(SendMsg);
    WriteString(SendStruct);
    WriteString(RetMsg);
    WriteString(RetStruct);
    WriteInteger(FieldNum);
    end;
end;

function THL7TextDictionary.StartLoadMsgStructSegments(Version: String): pointer;
begin
  Result := CreateContext('StructSegment-' + Version);
end;

function THL7TextDictionary.GetNextMsgStructSegments(p: pointer;
  var MsgStruct: String; var FieldNum: Integer; var SegCode, GroupName: String;
  var Repeats, Optional: Boolean): Boolean;
begin
  if p = NIL then
    begin
    Result := False;
    exit;
    end;
  with TReader(p) do
    begin
    Result := not EndOfList;
    if Result then
      begin
      MsgStruct := ReadString;
      FieldNum := ReadInteger;
      SegCode := ReadString;
      GroupName := ReadString;
      Repeats := ReadBoolean;
      Optional := ReadBoolean;
      end;
    end;
end;

procedure THL7TextDictionary.CloseLoadMsgStructSegments(p: pointer);
begin
  if p <> NIL then
    TReader(p).Free;
end;

function THL7TextDictionary.CountMsgStructSegments(version: String): Integer;
begin
  Result := 0; // this isn't really valid but it will never be used
end;

procedure THL7TextDictionary.AddMsgStructSegment(Version, MsgStruct: String; FieldNum: Integer; SegCode, GroupName: String;
  Repeats, Optional: Boolean);
begin
  with GetWritingContext('StructSegment-' + Version).Writer do
    begin
    WriteString(MsgStruct);
    WriteInteger(FieldNum);
    WriteString(SegCode);
    WriteString(GroupName);
    WriteBoolean(Repeats);
    WriteBoolean(Optional);
    end;
end;

function THL7TextDictionary.StartLoadEvntMsgSegments(Version: String): pointer;
begin
  Result := CreateContext('EvntMsgSegments-' + Version);
end;

function THL7TextDictionary.GetNextEvntMsgSegments(p: pointer; var MsgStruct: String; var FieldNum: Integer;
  var SegCode, GroupName: String; var Repeats, Optional: Boolean): Boolean;
begin
  if p = NIL then
    begin
    Result := False;
    exit;
    end;
  with TReader(p) do
    begin
    Result := not EndOfList;
    if Result then
      begin
      MsgStruct := ReadString;
      FieldNum := ReadInteger;
      SegCode := ReadString;
      GroupName := ReadString;
      Repeats := ReadBoolean;
      Optional := ReadBoolean;
      end;
    end;
end;

procedure THL7TextDictionary.CloseLoadEvntMsgSegments(p: pointer);
begin
  if p <> NIL then
    TReader(p).Free;
end;

function THL7TextDictionary.CountEvntMsgSegments(version: String): Integer;
begin
  Result := 0; // this isn't really valid but it will never be used
end;

procedure THL7TextDictionary.AddEvntMsgSegment(Version, MsgStruct: String; FieldNum: Integer; SegCode, GroupName: String; Repeats, Optional: Boolean);
begin
  with GetWritingContext('EvntMsgSegments-' + Version).Writer do
    begin
    WriteString(MsgStruct);
    WriteInteger(FieldNum);
    WriteString(SegCode);
    WriteString(GroupName);
    WriteBoolean(Repeats);
    WriteBoolean(Optional);
    end;
end;

function THL7TextDictionary.SourceDescription(fulldetails: Boolean): String;
begin
  if fulldetails then
    Result := 'Embedded at ' + FFileName
  else
    Result := 'Embedded';
end;

initialization
  {$IFDEF WIN32}
  if kdeVersionMark = '' then
    exit; {never remove this check - see Jeff Sinclair }
  {$ENDIF}
  {$IFDEF WIN32}
  if kdeVersionMark = '' then 
    exit; {never remove this check - see Jeff Sinclair } 
  {$ENDIF}
end.
