{!!}
{0.00-008  06 Dec 02 09:18   [17313]   User : Grahame Grieve          fix for release}
{0.00-007  03 Dec 02 10:00   [17313]   User : Grahame Grieve          prepare for hl7_dict release}
{0.00-006  18 Jul 02 13:09   [15715]   User : Grahame Grieve          rewrite HL7_Dict}
{0.00-005  09 Feb 02 22:50   [14002]   User : Grahame Grieve          fix case of unit declaration}
{0.00-004  07 Nov 01 12:59    User : Grahame Grieve          message segment maps}
{0.00-003  09 Oct 01 10:33    User : Grahame Grieve          xml support}
{0.00-002  27 Sep 01 13:08    User : Grahame Grieve          remove hint}
{0.00-001  16 May 01 13:15    User : Grahame Grieve       }
{0.00-000  10 Jan 01 12:37    User : Grahame Grieve
Comment:
          File First added to CodeVault}


{ a BDE Alias pointing to the HL7 access database must exist }

unit HL7_Dict_BDE;

interface

uses
  Classes,
  DBTables,
  HL7_Dict,
  HL7_Dict_Const;

type
  THL7BDEDictionary = class(THL7DictionaryDatabase)
  Private
    FDBName: String;
    FNamePrefix: String;
    function GetConnection(usage: String): TQuery;
    procedure GeneralClose(ALQuery: TQuery);
    function GenericCount(sql: String): Integer;
  Protected
    function VersionDefined(version: String; var desc: String): Boolean; Override;
    procedure ListVersions(VersionList: TStringList); Override;
    procedure AddVersion(Version, Description: String); Override;

    function StartLoadFields(Code, version: String): pointer; Override;
    function GetNextField(p: pointer; var Code: String; var DI: Integer; var Req, Rep: String; var RepCount, FNum: Integer): Boolean; Override;
    procedure CloseLoadFields(p: pointer); Override;
    function CountFields(version: String): Integer; Override;
    procedure AddField(Version, Code: String; Di: Integer; Req, Rep: String; RepCount, FNum: Integer); Override;

    function StartLoadComponents(Version: String): pointer; Override;
    function GetNextComponent(p: pointer; var Desc: String; var tid: Integer; var code: String; var cnum: Integer): Boolean; Override;
    procedure CloseLoadComponents(p: pointer); Override;
    function CountComponents(version: String): Integer; Override;
    procedure AddComponent(Version: String; Desc: String; tid: Integer; code: String; cnum: Integer); Override;

    function StartLoadDataElements(Version: String): pointer; Override;
    function GetNextElement(p: pointer; var desc, struc: String; var len, tid, di: Integer): Boolean; Override;
    procedure CloseLoadDataElements(p: pointer); Override;
    function CountDataElements(version: String): Integer; Override;
    procedure AddDataElement(Version: String; desc, struc: String; len, tid, di: Integer); Override;

    function StartLoadDataTypes(Version: String): pointer; Override;
    function GetNextDataType(p: pointer; var Name, desc: String; var len: Integer): Boolean; Override;
    procedure CloseLoadDataTypes(p: pointer); Override;
    function CountDataTypes(version: String): Integer; Override;
    procedure AddDataType(Version: String; Name, desc: String; len: Integer); Override;

    function StartLoadSegment(Code, Version: String): pointer; Override;
    function GetNextSegment(p: pointer; var code, desc: String): Boolean; Override;
    procedure CloseLoadSegments(p: pointer); Override;
    function CountSegments(version: String): Integer; Override;
    procedure AddSegment(version: String; code, desc: String); Override;

    function StartLoadStructures(Version: String): pointer; Override;
    function GetNextStructure(p: pointer; var struc, desc, code: String; var elem: Integer): Boolean; Override;
    procedure CloseLoadStructures(p: pointer); Override;
    function CountStructures(version: String): Integer; Override;
    procedure AddStructure(Version, struc, desc, code: String; elem: Integer); Override;

    function StartLoadStructureComps(Version: String): pointer; Override;
    function GetNextStructureComp(p: pointer; var struc: String; var fNum, cNum: Integer): Boolean; Override;
    procedure CloseLoadStructureComps(p: pointer); Override;
    function CountStructureComps(version: String): Integer; Override;
    procedure AddStructureComp(Version, struc: String; FNum, CNum: Integer); Override;

    function StartLoadTables(Version: String): pointer; Override;
    function GetNextTable(p: pointer; var desc: String; var tid: Integer): Boolean; Override;
    procedure CloseLoadTables(p: pointer); Override;
    function CountTables(version: String): Integer; Override;
    procedure AddTable(Version: String; desc: String; tid: Integer); Override;

    function StartLoadTableItems(Version: String): pointer; Override;
    function GetNextTableItem(p: pointer; var tid, sNum: Integer; var Value, desc: String): Boolean; Override;
    procedure CloseLoadTableItems(p: pointer); Override;
    function CountTableItems(version: String): Integer; Override;
    procedure AddTableItem(Version: String; tid, sNum: Integer; Value, desc: String); Override;

    function StartLoadEventList(Version: String): pointer; Override;
    function GetNextEvent(p: pointer; var code, desc: String): Boolean; Override;
    procedure CloseLoadEventList(p: pointer); Override;
    function CountEvents(version: String): Integer; Override;
    procedure AddEvent(Version, code, desc: String); Override;

    function StartLoadMsgStructs(Version: String): pointer; Override;
    function StartLoadEventDetails(Version: String): pointer; Override;
    function GetNextEventDetails(p: pointer; var EventCode, SendMsg, SendStruct, RetMsg, RetStruct: String; var FieldNum: Integer): Boolean; Override;
    procedure CloseLoadEventDetails(p: pointer); Override;
    function CountEventDetails(version: String): Integer; Override;
    procedure AddEventDetails(Version, EventCode, SendMsg, SendStruct, RetMsg, RetStruct: String; FieldNum: Integer); Override;

    function GetNextMsgStructs(p: pointer; var Name, Desc, ExampleEvent, ExampleMsgType, action: String): Boolean; Override;
    procedure CloseLoadMsgStructs(p: pointer); Override;
    function CountMsgStructs(version: String): Integer; Override;
    procedure AddMsgStruct(Version, Name, Desc, ExampleEvent, ExampleMsgType, action: String); Override;

    function StartLoadMsgStructSegments(Version: String): pointer; Override;
    function GetNextMsgStructSegments(p: pointer; var MsgStruct: String; var FieldNum: Integer; var SegCode, GroupName: String; var Repeats, Optional: Boolean): Boolean; Override;
    procedure CloseLoadMsgStructSegments(p: pointer); Override;
    function CountMsgStructSegments(version: String): Integer; Override;
    procedure AddMsgStructSegment(Version, MsgStruct: String; FieldNum: Integer; SegCode, GroupName: String; Repeats, Optional: Boolean); Override;

    function StartLoadEvntMsgSegments(Version: String): pointer; Override;
    function GetNextEvntMsgSegments(p: pointer; var MsgStruct: String; var FieldNum: Integer; var SegCode, GroupName: String; var Repeats, Optional: Boolean): Boolean; Override;
    procedure CloseLoadEvntMsgSegments(p: pointer); Override;
    function CountEvntMsgSegments(version: String): Integer; Override;
    procedure AddEvntMsgSegment(Version, MsgStruct: String; FieldNum: Integer; SegCode, GroupName: String; Repeats, Optional: Boolean); Override;
    procedure PrepareForLoad(wipe: Boolean); Override;
    procedure DoneLoading(TransferEvent: TOnTransferProgress); Override;
  Public
    constructor Create(hl7Alias: String);
    destructor Destroy; Override;
    function SourceDescription(fulldetails: Boolean): String; Override;
    property NamePrefix: String Read FNamePrefix Write FNamePrefix;
  end;

resourcestring
  KdeVersionMark = {!!uv}'!-!HL7_Dict_BDE.pas,0.00-008,06 Dec 02 09:18,9961';

implementation

uses
  SysUtils;

function SQLWrapString(const AStr: String): String;
var
  i: Integer;
begin
  Result := AStr;
  for i := Length(Result) downto 1 do
    if Result[i] = '''' then
      Insert('''', Result, i);
end;

procedure ConvertCharacter(ATableName, AVersion: String; var VSQLValue: String);
var
  i, j, k: Integer;
  LTmpStr, LTmpStr1: String;
begin
  for i := 1 to Length(VSQLValue) do
    begin
    if VSQLValue[i] = #145 then  // we found  (Left Single Quotation Mark)
      begin
      VSQLValue[i] := '''';
      end
    else if VSQLValue[i] = #146 then // we found  (Right Single Quotation Mark)
      begin
      VSQLValue[i] := '''';
      end
    else if VSQLValue[i] = #147 then // we found  (Left Double Quotation Mark)
      begin
      VSQLValue[i] := '"';
      end
    else if VSQLValue[i] = #148 then // we found  (Right Double Quotation Mark)
      begin
      VSQLValue[i] := '"';
      end
    else if VSQLValue[i] = #150 then // we found  (En Dash)
      begin
      VSQLValue[i] := '-';
      end
    else if VSQLValue[i] = #151 then // we found  (Em Dash)
      begin
      VSQLValue[i] := '-';
      end
    else if VSQLValue[i] = #180 then // we found  (Acute Accent)
      begin
      VSQLValue[i] := ''''
      end
    else if VSQLValue[i] = #189 then // we found  (Vulgar Fraction One Half)
      begin
      LTmpStr := Copy(VSQLValue, 1, i - 1);
      LTmpStr1 := LTmpStr;
      LTmpStr1[i] := '.';
      LTmpStr1[i + 1] := '5';
      k := i + 1;
      for j := k to Length(VSQLValue) do
        begin
        LTmpStr1[j] := VSQLValue[i];
        end;
      VSQLValue := LTmpStr1;
      Break;
      end
    else if VSQLValue[i] = #196 then // we found  (Latin Capital Letter A with Diaeresis)
      begin
      VSQLValue[i] := 'A';
      end
    else if VSQLValue[i] = #220 then // we found  (Latin Capital Letter U with Diaeresis)
      begin
      VSQLValue[i] := 'U';
      end
    else if VSQLValue[i] = #223 then // we found  (Latin Small Letter Sharp S)
      begin
      VSQLValue[i] := 's';
      end
    else if VSQLValue[i] = #228 then // we found  (Latin Small Letter A with Diaeresis)
      begin
      VSQLValue[i] := 'a';
      end
    else if VSQLValue[i] = #246 then // we found  (Latin Small Letter O with Diaeresis)
      begin
      VSQLValue[i] := 'o';
      end
    else if VSQLValue[i] = #252 then // we found  (Latin Small Letter U with Diaeresis)
      begin
      VSQLValue[i] := 'u'
      end;
    end;
end;

{ THL7BDEDictionary }

constructor THL7BDEDictionary.Create(hl7Alias: String);
begin
  inherited Create;
  FDBName := hl7Alias;
end;

destructor THL7BDEDictionary.Destroy;
begin
  inherited;
end;

function THL7BDEDictionary.SourceDescription(fulldetails: Boolean): String;
begin
  Result := 'BDE Database ' + FDBName;
end;

function THL7BDEDictionary.GetConnection(usage: String): TQuery;
begin
  Result := TQuery.Create(NIL);
  Result.DatabaseName := FDBName;
end;

procedure THL7BDEDictionary.GeneralClose(ALQuery: TQuery);
begin
  FreeAndNil(ALQuery);
end;

function THL7BDEDictionary.GenericCount(sql: String): Integer;
var
  LQuery: TQuery;
begin
  LQuery := GetConnection('Count');
  try
    LQuery.sql.Text := sql;
    LQuery.Open;
    LQuery.First;
    Result := LQuery.Fields[0].AsInteger;
    LQuery.Close;
  finally
    GeneralClose(LQuery);
    end;
end;

function THL7BDEDictionary.VersionDefined(version: String; var desc: String): Boolean;
var
  LQuery: TQuery;
begin
  LQuery := GetConnection('VersionDefined');
  try
    LQuery.Sql.Text := 'select ' + FN_DESCRIPTION + ' from ' + NamePrefix + TN_VERSIONS + ' where ' + FN_VERSION + ' = ''' + Version + '''';
    LQuery.Open;
    LQuery.First;
    Result := not LQuery.EOF;
    if Result then
      desc := LQuery.FieldByName(FN_DESCRIPTION).AsString;
  finally
    GeneralClose(LQuery);
    end;
end;

procedure THL7BDEDictionary.ListVersions(VersionList: TStringList);
var
  LQuery: TQuery;
begin
  LQuery := GetConnection('ListVersions');
  try
    LQuery.Sql.Text := 'select ' + FN_VERSION + ' from ' + NamePrefix + TN_VERSIONS;
    LQuery.Open;
    LQuery.First;
    while not LQuery.EOF do
      begin
      VersionList.Add(LQuery.FieldByName(FN_VERSION).AsString);
      LQuery.Next;
      end;
  finally
    GeneralClose(LQuery);
    end;
end;

procedure THL7BDEDictionary.AddVersion(Version, Description: String);
begin
  raise Exception.Create('Not supported');
end;


function THL7BDEDictionary.StartLoadFields(Code, version: String): pointer;
var 
  LQuery: TQuery;
begin
  LQuery := GetConnection('LoadFields');
  try
    if Code <> '' then
      LQuery.Sql.Text := 'select ' + FN_SEGCODE + ', ' + FN_DATAITEM + ', ' + FN_REQOPT + ', ' + FN_REPNAL + ', ' + FN_REPCOUNT + ', ' + FN_FIELDNUM + ' from ' +
        NamePrefix + TN_SEGDATELEM + ' where ' + FN_SEGCODE + ' = ''' + Code + ''' ' +
        'and ' + FN_VERSION + ' = ''' + version + ''' order by ' + FN_FIELDNUM
    else
      LQuery.Sql.Text := 'select ' + FN_SEGCODE + ', ' + FN_DATAITEM + ', ' + FN_REQOPT + ', ' + FN_REPNAL + ', ' + FN_REPCOUNT + ', ' + FN_FIELDNUM + ' from ' +
        NamePrefix + TN_SEGDATELEM + ' where ' + FN_VERSION + ' = ''' + version + ''' order by ' + FN_FIELDNUM;
    LQuery.Open;
    LQuery.First;
    Result := pointer(LQuery);
  except
    GeneralClose(LQuery);
    raise;
    end;
end;

function THL7BDEDictionary.GetNextField(p: pointer; var Code: String; var DI: Integer; var Req, Rep: String;
  var RepCount, fNum: Integer): Boolean;
var
  LQuery: TQuery;
begin
  LQuery := TQuery(p);
  Result := not LQuery.EOF;
  if Result then
    begin
    code := LQuery.FieldByName(FN_SEGCODE).AsString;
    di := LQuery.FieldByName(FN_DATAITEM).AsInteger;
    req := LQuery.FieldByName(FN_REQOPT).AsString;
    rep := LQuery.FieldByName(FN_REPNAL).AsString;
    repcount := LQuery.FieldByName(FN_REPCOUNT).AsInteger;
    fNum := LQuery.FieldByName(FN_FIELDNUM).AsInteger;
    LQuery.Next;
    end;
end;

procedure THL7BDEDictionary.CloseLoadFields(p: pointer);
begin
  GeneralClose(TQuery(p));
end;

function THL7BDEDictionary.CountFields(version: String): Integer;
begin
  Result := GenericCount('Select count(*) from ' + NamePrefix + TN_SEGDATELEM + ' where ' + FN_VERSION + ' = ''' + version + '''');
end;

procedure THL7BDEDictionary.AddField(Version, Code: String; Di: Integer; Req, Rep: String; RepCount, fNum: Integer);
begin
  raise Exception.Create('Not supported');
end;

function THL7BDEDictionary.StartLoadComponents(Version: String): pointer;
var 
  LQuery: TQuery;
begin
  LQuery := GetConnection('ListVersions');
  try
    LQuery.Sql.Text := 'select ' + FN_COMPNUM + ', ' + FN_DESCRIPTION + ', ' + FN_TABLEID + ', ' + FN_DTCODE + ' from ' + NamePrefix + TN_COMPLIST + ' where ' + FN_VERSION + ' = ''' + Version + '''';
    LQuery.Open;
    LQuery.First;
    Result := pointer(LQuery);
  except
    GeneralClose(LQuery);
    raise;
    end;
end;

function THL7BDEDictionary.GetNextComponent(p: pointer; var Desc: String; var tid: Integer;
  var code: String; var cnum: Integer): Boolean;
var 
  LQuery: TQuery;
begin
  LQuery := TQuery(p);
  Result := not LQuery.EOF;
  if Result then
    begin
    Desc := LQuery.FieldByName(FN_DESCRIPTION).AsString;
    tid := LQuery.FieldByName(FN_TABLEID).AsInteger;
    code := LQuery.FieldByName(FN_DTCODE).AsString;
    cnum := LQuery.FieldByName(FN_COMPNUM).AsInteger;
    LQuery.Next;
    end;
end;

procedure THL7BDEDictionary.CloseLoadComponents(p: pointer);
begin
  GeneralClose(TQuery(p));
end;

function THL7BDEDictionary.CountComponents(version: String): Integer;
begin
  Result := GenericCount('select count(*) from ' + NamePrefix + TN_COMPLIST + ' where ' + FN_VERSION + ' = ''' + Version + '''');
end;

procedure THL7BDEDictionary.AddComponent(Version: String; Desc: String; tid: Integer; code: String; cnum: Integer);
begin
  raise Exception.Create('Not supported');
end;


function THL7BDEDictionary.StartLoadDataElements(Version: String): pointer;
var 
  LQuery: TQuery;
begin
  LQuery := GetConnection('loadDataElements');
  try
    LQuery.Sql.Text := 'select ' + FN_DATAITEM + ', ' + FN_DESCRIPTION + ', ' + FN_DATASTRUC + ', ' + FN_LENGTH + ', ' + FN_TABLEID + ' from ' +
      NamePrefix + TN_DATAELEM + ' where ' + FN_VERSION + ' = ''' + Version + '''';
    LQuery.Open;
    LQuery.First;
    Result := pointer(LQuery);
  except
    GeneralClose(LQuery);
    raise;
    end;
end;

function THL7BDEDictionary.GetNextElement(p: pointer; var desc, struc: String;
  var len, tid, di: Integer): Boolean;
var 
  LQuery: TQuery;
begin
  LQuery := TQuery(p);
  Result := not LQuery.EOF;
  if Result then
    begin
    desc := LQuery.FieldByName(FN_DESCRIPTION).AsString;
    struc := LQuery.FieldByName(FN_DATASTRUC).AsString;
    len := LQuery.FieldByName(FN_LENGTH).AsInteger;
    tid := LQuery.FieldByName(FN_TABLEID).AsInteger;
    di := LQuery.FieldByName(FN_DATAITEM).AsInteger;
    LQuery.Next;
    end;
end;

procedure THL7BDEDictionary.CloseLoadDataElements(p: pointer);
begin
  GeneralClose(TQuery(p));
end;

function THL7BDEDictionary.CountDataElements(version: String): Integer;
begin
  Result := GenericCount('Select count(*) from ' + NamePrefix + TN_DATAELEM + ' where ' + FN_VERSION + ' = ''' + Version + '''');
end;

procedure THL7BDEDictionary.AddDataElement(Version: String; desc, struc: String; len, tid, di: Integer);
begin
  raise Exception.Create('Not supported');
end;


function THL7BDEDictionary.StartLoadDataTypes(Version: String): pointer;
var 
  LQuery: TQuery;
begin
  LQuery := GetConnection('LoadDataTypes');
  try
    LQuery.Sql.Text := 'select ' + FN_DTCODE + ', ' + FN_DESCRIPTION + ', ' + FN_LENGTH + ' from ' + NamePrefix + TN_DATATYPES + ' where ' + FN_VERSION + ' = ''' + Version + '''';
    LQuery.Open;
    LQuery.First;
    Result := pointer(LQuery);
  except
    GeneralClose(LQuery);
    raise;
    end;
end;

function THL7BDEDictionary.GetNextDataType(p: pointer; var Name, desc: String;
  var len: Integer): Boolean;
var 
  LQuery: TQuery;
begin
  LQuery := TQuery(p);
  Result := not LQuery.EOF;
  if Result then
    begin
    Name := LQuery.FieldByName(FN_DTCODE).AsString;
    desc := LQuery.FieldByName(FN_DESCRIPTION).AsString;
    len := LQuery.FieldByName(FN_LENGTH).AsInteger;
    LQuery.Next;
    end;
end;

procedure THL7BDEDictionary.CloseLoadDataTypes(p: pointer);
begin
  GeneralClose(TQuery(p));
end;

function THL7BDEDictionary.CountDataTypes(version: String): Integer;
begin
  Result := GenericCount('Select count(*) from ' + NamePrefix + TN_DATATYPES + ' where ' + FN_VERSION + ' = ''' + Version + '''');
end;

procedure THL7BDEDictionary.AddDataType(Version: String; Name, desc: String; len: Integer);
begin
  raise Exception.Create('Not supported');
end;


function THL7BDEDictionary.StartLoadSegment(Code, Version: String): pointer;
var
  LQuery: TQuery;
begin
  LQuery := GetConnection('LoadSegment');
  try
    if code <> '' then
      LQuery.Sql.Text := 'select ' + FN_DESCRIPTION + ', ' + FN_SEGCODE + ' from ' + NamePrefix + TN_SEGMENTS + ' where ' + FN_SEGCODE + ' = ''' + code + ''' and ' + FN_VERSION + ' = ''' + Version + ''''
    else
      LQuery.Sql.Text := 'select ' + FN_DESCRIPTION + ', ' + FN_SEGCODE + ' from ' + NamePrefix + TN_SEGMENTS + ' where ' + FN_VERSION + ' = ''' + Version + ''' order by ' + FN_SEGCODE + ' asc';
    LQuery.Open;
    LQuery.First;
    Result := pointer(LQuery);
  except
    GeneralClose(LQuery);
    raise
    end;
end;

function THL7BDEDictionary.GetNextSegment(p: pointer; var code, desc: String): Boolean;
var 
  LQuery: TQuery;
begin
  LQuery := TQuery(p);
  Result := not LQuery.EOF;
  if Result then
    begin
    code := LQuery.FieldByName(FN_SEGCODE).AsString;
    desc := LQuery.FieldByName(FN_DESCRIPTION).AsString;
    LQuery.Next;
    end;
end;

procedure THL7BDEDictionary.CloseLoadSegments(p: pointer);
begin
  GeneralClose(TQuery(p));
end;

function THL7BDEDictionary.CountSegments(version: String): Integer;
begin
  Result := GenericCount('select count(*) from ' + NamePrefix + TN_SEGMENTS + ' where ' + FN_VERSION + ' = ''' + Version + '''')
end;

procedure THL7BDEDictionary.AddSegment(version: String; code, desc: String);
begin
  raise Exception.Create('Not supported');
end;


function THL7BDEDictionary.StartLoadStructures(Version: String): pointer;
var 
  LQuery: TQuery;
begin
  LQuery := GetConnection('LoadStructures');
  try
    LQuery.Sql.Text := 'select ' + FN_DATASTRUC + ', ' + FN_DESCRIPTION + ', ' + FN_DTCODE + ', ' + FN_ELEMENTARY + ' from ' + NamePrefix + TN_DATASTRUCS + ' where ' + FN_VERSION + ' = ''' + Version + '''';
    LQuery.Open;
    LQuery.First;
    Result := pointer(LQuery);
  except
    GeneralClose(LQuery);
    raise
    end;
end;

function THL7BDEDictionary.GetNextStructure(p: pointer; var struc, desc, code: String;
  var elem: Integer): Boolean;
var 
  LQuery: TQuery;
begin
  LQuery := TQuery(p);
  Result := not LQuery.EOF;
  if Result then
    begin
    struc := LQuery.FieldByName(FN_DATASTRUC).AsString;
    desc := LQuery.FieldByName(FN_DESCRIPTION).AsString;
    code := LQuery.FieldByName(FN_DTCODE).AsString;
    if LQuery.FieldByName(FN_ELEMENTARY).AsBoolean then
      begin
      elem := 1
      end
    else
      begin
      elem := 0
      end;
    LQuery.Next;
    end;
end;

procedure THL7BDEDictionary.CloseLoadStructures(p: pointer);
begin
  GeneralClose(TQuery(p));
end;

function THL7BDEDictionary.CountStructures(version: String): Integer;
begin
  Result := GenericCount('Select count(*) from ' + NamePrefix + TN_DATASTRUCS + ' where ' + FN_VERSION + ' = ''' + Version + '''')
end;

procedure THL7BDEDictionary.AddStructure(Version, struc, desc, code: String; elem: Integer);
begin
  raise Exception.Create('Not supported');
end;


function THL7BDEDictionary.StartLoadStructureComps(Version: String): pointer;
var
  LQuery: TQuery;
begin
  LQuery := GetConnection('LoadStructures');
  try
    LQuery.Sql.Text := 'select ' + FN_DATASTRUC + ', ' + FN_FIELDNUM + ', ' + FN_COMPNUM + ' from ' + NamePrefix + TN_DSCOMPS + ' where ' + FN_VERSION + ' = ''' + Version + ''' order by ' + FN_DATASTRUC + ', ' + FN_FIELDNUM;
    LQuery.Open;
    LQuery.First;
    Result := pointer(LQuery);
  except
    GeneralClose(LQuery);
    raise
    end;
end;

function THL7BDEDictionary.GetNextStructureComp(p: pointer; var struc: String;
  var fNum, cNum: Integer): Boolean;
var 
  LQuery: TQuery;
begin
  LQuery := TQuery(p);
  Result := not LQuery.EOF;
  if Result then
    begin
    struc := LQuery.FieldByName(FN_DATASTRUC).AsString;
    fNum := LQuery.FieldByName(FN_FIELDNUM).AsInteger;
    cNum := LQuery.FieldByName(FN_COMPNUM).AsInteger;
    LQuery.Next;
    end;
end;

procedure THL7BDEDictionary.CloseLoadStructureComps(p: pointer);
begin
  GeneralClose(TQuery(p));
end;

function THL7BDEDictionary.CountStructureComps(version: String): Integer;
begin
  Result := GenericCount('Select count(*) from ' + NamePrefix + TN_DSCOMPS + ' where ' + FN_VERSION + ' = ''' + Version + '''');
end;

procedure THL7BDEDictionary.AddStructureComp(Version, struc: String; FNum, CNum: Integer);
begin
  raise Exception.Create('Not supported');
end;

function THL7BDEDictionary.StartLoadTables(Version: String): pointer;
var 
  LQuery: TQuery;
begin
  LQuery := GetConnection('LoadTables');
  try
    LQuery.Sql.Text := 'select ' + FN_TABLEID + ', ' + FN_DESCRIPTION + ' from ' + NamePrefix + TN_TABLES + ' where ' + FN_VERSION + ' = ''' + Version + '''';
    LQuery.Open;
    LQuery.First;
    Result := pointer(LQuery);
  except
    GeneralClose(LQuery);
    raise
    end;
end;

function THL7BDEDictionary.GetNextTable(p: pointer; var desc: String;
  var tid: Integer): Boolean;
var 
  LQuery: TQuery;
begin
  LQuery := TQuery(p);
  Result := not LQuery.EOF;
  if Result then
    begin
    desc := LQuery.FieldByName(FN_DESCRIPTION).AsString;
    tid := LQuery.FieldByName(FN_TABLEID).AsInteger;
    LQuery.Next;
    end;
end;

procedure THL7BDEDictionary.CloseLoadTables(p: pointer);
begin
  GeneralClose(TQuery(p));
end;

function THL7BDEDictionary.CountTables(version: String): Integer;
begin
  Result := GenericCount('Select count(*) from ' + NamePrefix + TN_TABLES + ' where ' + FN_VERSION + ' = ''' + Version + '''');
end;

procedure THL7BDEDictionary.AddTable(Version: String; desc: String; tid: Integer);
begin
  raise Exception.Create('Not supported');
end;

function THL7BDEDictionary.StartLoadTableItems(Version: String): pointer;
var 
  LQuery: TQuery;
begin
  LQuery := GetConnection('LoadTableItems');
  try
    LQuery.Sql.Text := 'select ' + FN_TABLEID + ', ' + FN_TABLEVALS + ', ' + FN_DESCRIPTION + ', ' + FN_SORTNUM + ' from ' + NamePrefix + TN_TABLEVALS + ' where ' + FN_VERSION + ' = ''' + Version + '''';
    LQuery.Open;
    LQuery.First;
    Result := pointer(LQuery);
  except
    GeneralClose(LQuery);
    raise
    end;
end;

function THL7BDEDictionary.GetNextTableItem(p: pointer; var tid, sNum: Integer;
  var Value, desc: String): Boolean;
var 
  LQuery: TQuery;
begin
  LQuery := TQuery(p);
  Result := not LQuery.EOF;
  if Result then
    begin
    tid := LQuery.FieldByName(FN_TABLEID).AsInteger;
    sNum := LQuery.FieldByName(FN_SORTNUM).AsInteger;
    Value := LQuery.FieldByName(FN_TABLEVALS).AsString;
    desc := LQuery.FieldByName(FN_DESCRIPTION).AsString;
    LQuery.Next;
    end;
end;

procedure THL7BDEDictionary.CloseLoadTableItems(p: pointer);
begin
  GeneralClose(TQuery(p));
end;

function THL7BDEDictionary.CountTableItems(version: String): Integer;
begin
  Result := GenericCount('Select count(*)  from ' + NamePrefix + TN_TABLEVALS + ' where ' + FN_VERSION + ' = ''' + Version + '''');
end;

procedure THL7BDEDictionary.AddTableItem(Version: String; tid, sNum: Integer; Value, desc: String);
begin
  raise Exception.Create('Not supported');
end;

function THL7BDEDictionary.StartLoadEventList(Version: String): pointer;
var
  LQuery: TQuery;
begin
  LQuery := GetConnection('LoadEventList');
  try
    LQuery.Sql.Text := 'select ' + FN_EVNTCODE + ', ' + FN_DESCRIPTION + ' from ' + NamePrefix + TN_EVENTS + ' where ' + FN_VERSION + ' = ''' + Version + '''';
    LQuery.Open;
    LQuery.First;
    Result := pointer(LQuery);
  except
    GeneralClose(LQuery);
    raise
    end;
end;

function THL7BDEDictionary.GetNextEvent(p: pointer; var code, desc: String): Boolean;
var 
  LQuery: TQuery;
begin
  LQuery := TQuery(p);
  Result := not LQuery.EOF;
  if Result then
    begin
    code := LQuery.FieldByName(FN_EVNTCODE).AsString;
    desc := LQuery.FieldByName(FN_DESCRIPTION).AsString;
    LQuery.Next;
    end;
end;

procedure THL7BDEDictionary.CloseLoadEventList(p: pointer);
begin
  GeneralClose(TQuery(p));
end;

function THL7BDEDictionary.CountEvents(version: String): Integer;
begin
  Result := GenericCount('Select count(*) from ' + NamePrefix + TN_EVENTS + ' where ' + FN_VERSION + ' = ''' + Version + '''');
end;

procedure THL7BDEDictionary.AddEvent(Version, code, desc: String);
begin
  raise Exception.Create('Not supported');
end;

function THL7BDEDictionary.StartLoadMsgStructs(Version: String): pointer;
var 
  LQuery: TQuery;
begin
  LQuery := GetConnection('LoadEventList');
  try
    LQuery.Sql.Text := 'select ' + FN_MSG_STRUCT + ', ' + FN_DESCRIPTION + ', ' + FN_XMPL_EVENT + ', ' + FN_XMPL_MTYPE + ', ' + FN_ACTION + ' from ' + NamePrefix + TN_MSGSTRUCTS + ' where ' + FN_VERSION + ' = ''' + Version + '''';
    LQuery.Open;
    LQuery.First;
    Result := pointer(LQuery);
  except
    GeneralClose(LQuery);
    raise
    end;
end;

function THL7BDEDictionary.GetNextMsgStructs(p: pointer; var Name, Desc, ExampleEvent, ExampleMsgType, action: String): Boolean;
var 
  LQuery: TQuery;
begin
  LQuery := TQuery(p);
  Result := not LQuery.EOF;
  if Result then
    begin
    Name := LQuery.FieldByName(FN_MSG_STRUCT).AsString;
    Desc := LQuery.FieldByName(FN_DESCRIPTION).AsString;
    ExampleEvent := LQuery.FieldByName(FN_XMPL_EVENT).AsString;
    ExampleMsgType := LQuery.FieldByName(FN_XMPL_MTYPE).AsString;
    action := LQuery.FieldByName(FN_ACTION).AsString;
    LQuery.Next;
    end;
end;

procedure THL7BDEDictionary.CloseLoadMsgStructs(p: pointer);
begin
  GeneralClose(TQuery(p));
end;

function THL7BDEDictionary.CountMsgStructs(version: String): Integer;
begin
  Result := GenericCount('Select count(*) from ' + NamePrefix + TN_MSGSTRUCTS + ' where ' + FN_VERSION + ' = ''' + Version + '''');
end;

procedure THL7BDEDictionary.AddMsgStruct(Version, Name, Desc, ExampleEvent, ExampleMsgType, action: String);
begin
  raise Exception.Create('Not supported');
end;


function THL7BDEDictionary.StartLoadEventDetails(Version: String): pointer;
var 
  LQuery: TQuery;
begin
  LQuery := GetConnection('LoadEventList');
  try
    LQuery.Sql.Text := 'select ' + FN_EVNTCODE + ', ' + FN_FIELDNUM + ', ' + FN_MSGTYP_SEND + ', ' + FN_MSGTYP_RETN + ', ' + FN_MSGSTRUC_SEND + ', ' + FN_MSGSTRUC_RETN + ', ' + FN_FIELDNUM + ' from ' + NamePrefix + TN_EVENTMSGTYP + ' where ' + FN_VERSION + ' = ''' + Version + '''';
    LQuery.Open;
    LQuery.First;
    Result := pointer(LQuery);
  except
    GeneralClose(LQuery);
    raise
    end;
end;

function THL7BDEDictionary.GetNextEventDetails(p: pointer; var EventCode, SendMsg, SendStruct, RetMsg, RetStruct: String; var FieldNum: Integer): Boolean;
var 
  LQuery: TQuery;
begin
  LQuery := TQuery(p);
  Result := not LQuery.EOF;
  if Result then
    begin
    EventCode := LQuery.FieldByName(FN_EVNTCODE).AsString;
    SendMsg := LQuery.FieldByName(FN_MSGTYP_SEND).AsString;
    RetMsg := LQuery.FieldByName(FN_MSGTYP_RETN).AsString;
    SendStruct := LQuery.FieldByName(FN_MSGSTRUC_SEND).AsString;
    RetStruct := LQuery.FieldByName(FN_MSGSTRUC_RETN).AsString;
    FieldNum := LQuery.FieldByName(FN_FIELDNUM).AsInteger;
    LQuery.Next;
    end;
end;

procedure THL7BDEDictionary.CloseLoadEventDetails(p: pointer);
begin
  GeneralClose(TQuery(p));
end;

function THL7BDEDictionary.CountEventDetails(version: String): Integer;
begin
  Result := GenericCount('Select count(*) from ' + NamePrefix + TN_EVENTMSGTYP + ' where ' + FN_VERSION + ' = ''' + Version + '''');
end;

procedure THL7BDEDictionary.AddEventDetails(Version, EventCode, SendMsg, SendStruct, RetMsg, RetStruct: String; FieldNum: Integer);
begin
  raise Exception.Create('Not supported');
end;

function THL7BDEDictionary.StartLoadMsgStructSegments(Version: String): pointer;
var
  LQuery: TQuery;
  s: String;
begin
  LQuery := GetConnection('LoadEventList');
  try
    s := 'select ' + FN_MSG_STRUCT + ', ' + FN_FIELDNUM + ', ' + FN_SEGCODE + ', ' + FN_GROUPNAME + ', ' + FN_REPNAL + ', ' + FN_OPTNAL +
      ' from ' + NamePrefix + TN_STRUCTSEGS + ' where ' + FN_VERSION + ' = ''' + Version + ''' order by ' + FN_MSG_STRUCT + ', ' + FN_FIELDNUM;
    LQuery.Sql.Text := s;
    LQuery.Open;
    LQuery.First;
    Result := pointer(LQuery);
  except
    GeneralClose(LQuery);
    raise
    end;
end;

function THL7BDEDictionary.GetNextMsgStructSegments(p: pointer;
  var MsgStruct: String; var FieldNum: Integer; var SegCode, GroupName: String;
  var Repeats, Optional: Boolean): Boolean;
var 
  LQuery: TQuery;
begin
  LQuery := TQuery(p);
  Result := not LQuery.EOF;
  if Result then
    begin
    MsgStruct := LQuery.FieldByName(FN_MSG_STRUCT).AsString;
    FieldNum := LQuery.FieldByName(FN_FIELDNUM).AsInteger;
    SegCode := LQuery.FieldByName(FN_SEGCODE).AsString;
    GroupName := LQuery.FieldByName(FN_GROUPNAME).AsString;
    Repeats := LQuery.FieldByName(FN_REPNAL).AsBoolean;
    Optional := LQuery.FieldByName(FN_OPTNAL).AsBoolean;
    LQuery.Next;
    end;
end;

procedure THL7BDEDictionary.CloseLoadMsgStructSegments(p: pointer);
begin
  GeneralClose(TQuery(p));
end;

function THL7BDEDictionary.CountMsgStructSegments(version: String): Integer;
begin
  Result := GenericCount('Select count(*) from ' + NamePrefix + TN_STRUCTSEGS + ' where ' + FN_VERSION + ' = ''' + Version + '''');
end;

function BoolToNum(b: Boolean): String;
begin
  if b then
    Result := '1'
  else
    Result := '0';
end;

procedure THL7BDEDictionary.AddMsgStructSegment(Version, MsgStruct: String; FieldNum: Integer; SegCode, GroupName: String; Repeats, Optional: Boolean);
begin
  raise Exception.Create('Not supported');
end;

function THL7BDEDictionary.StartLoadEvntMsgSegments(Version: String): pointer;
var
  LQuery: TQuery;
  s: String;
begin
  LQuery := GetConnection('LoadEventList');
  try
    s := 'select ' + FN_EVNTCODE + ', ' + FN_MSGTYPE + ', ' + FN_FIELDNUM + ', ' + FN_SEGCODE + ', ' + FN_GROUPNAME + ', ' + FN_REPNAL + ', ' + FN_OPTNAL +
      ' from ' + NamePrefix + TN_EVNTMSGSEGS + ' where ' + FN_VERSION + ' = ''' + Version + ''' order by ' + FN_MSGTYPE + ', ' + FN_EVNTCODE + ', ' + FN_FIELDNUM;
    LQuery.Sql.Text := s;
    LQuery.Open;
    LQuery.First;
    Result := pointer(LQuery);
  except
    GeneralClose(LQuery);
    raise
    end;
end;

function THL7BDEDictionary.GetNextEvntMsgSegments(p: pointer; var MsgStruct: String; var FieldNum: Integer; var SegCode, GroupName: String; var Repeats, Optional: Boolean): Boolean;
var 
  LQuery: TQuery;
begin
  LQuery := TQuery(p);
  Result := not LQuery.EOF;
  if Result then
    begin
    MsgStruct := LQuery.FieldByName(FN_MSGTYPE).AsString + '_' + LQuery.FieldByName(FN_EVNTCODE).AsString;
    FieldNum := LQuery.FieldByName(FN_FIELDNUM).AsInteger;
    SegCode := LQuery.FieldByName(FN_SEGCODE).AsString;
    GroupName := LQuery.FieldByName(FN_GROUPNAME).AsString;
    Repeats := LQuery.FieldByName(FN_REPNAL).AsBoolean;
    Optional := LQuery.FieldByName(FN_OPTNAL).AsBoolean;
    LQuery.Next;
    end;
end;

procedure THL7BDEDictionary.CloseLoadEvntMsgSegments(p: pointer);
begin
  GeneralClose(TQuery(p));
end;

function THL7BDEDictionary.CountEvntMsgSegments(version: String): Integer;
begin
  Result := GenericCount('Select count(*) from ' + NamePrefix + TN_EVNTMSGSEGS + ' where ' + FN_VERSION + ' = ''' + Version + '''');
end;

procedure THL7BDEDictionary.AddEvntMsgSegment(Version, MsgStruct: String; FieldNum: Integer; SegCode, GroupName: String; Repeats, Optional: Boolean);
begin
  raise Exception.Create('Not supported');
end;

procedure THL7BDEDictionary.PrepareForLoad(wipe: Boolean);
begin
  raise Exception.Create('Not supported');
end;

procedure THL7BDEDictionary.DoneLoading(TransferEvent: TOnTransferProgress);
begin
  raise Exception.Create('Not supported');
end;

initialization
  if kdeVersionMark = '' then
    exit; {never remove this check - see Jeff Sinclair }
end.
