{
 Copyright 1998 - 2002  Kestral Computing P/L
 http://www.kestral.com.au    http://www.hl7connect.com
}

{
 Welcome to the Kestral HL7 Libary
 =================================

 This library is an open source implementation of a DOM + ITS based parser for HL7

 What does this library do?
 --------------------------
   You can use this library to parse read and write HL7 messages in either
   ER/7 or XML format. The messages can be validated against the HL7 standard.
   The programmer interacts with messages through a standard DOM of HL7 messages.
   Fields can be referred to by names or numbers depending on preference. In
   addition, this library can be used to generate some useful tabular views
   of HL7 messages and dictionary information

 What do you need to work with this library?
 -------------------------------------------
   You need Delphi v5 and the official HL7 Access database. And the XML schemas

   These units were developed under Delphi 5. Other versions of Delphi and
   CBuilder may work but nothing has been done to test this. Please inform
   us if it works on other platforms.

   You need to get the HL7 Access database from www.hl7.org. You may not
   be able to distribute the database. This code contains support for porting
   the access database to another format that may be distributed subject
   to a different set of restrictions. For further information, contact
   markmcd@hl7.org

 Work still to be done
 ---------------------
    - Linux support is planned and partially implemented
    - .Net support is planned
    - a (simple) COM Wrapper is planned to allow for an ActiveX object
    - support for V2.5 (when released)

   V3 will not be supported by this package.

 Format Escape Sequences
 -----------------------
 The HL7 standard mixes escape sequences for message specific format
 issues with escape sequences for application level stuff like highlighting
 and text layout control.
 This library handles this by maintaining the escape sequences as is. For
 internal reasons the escape character is replaced by a #1 (INTERNAL_ESCAPE_CHAR)
 if you wish to include an escape sequence in a TX or FT field, include it
 in the content with INTERNAL_ESCAPE_CHAR instead of the HL7 escape character.
 It will be replaced with the HL7 Escape character when the message is written


 Known Non-Compliances
 ----------------------
   No non-compliances are known to exist. If you find one, treat it
   as a bug. Bugs can be reported on the hl7 tools mailing list (see below).

 Contacting the maintainer
 -------------------------
   You can contact the maintainer directly at grahame@hl7connect.com.
   A mailing list for all developers working with hl7_dict.pas is also
   available. To go on this list, see
   http://www.hl7connect.com/develop/main/email_reg.ksp

}

{
 Kestral Internal Version History. note the inclusion of
 2 further references to the version at the end of the
 interface and implementation sections. This embeds the
 version number of this unit into the executable as a
 resource string that you can decode with a seperate
 executable
}

{!!}
{0.00-129  03 Dec 02 10:00   [17313]   User : Grahame Grieve          prepare for hl7_dict release}
{0.00-128  13 Nov 02 10:36   [15715]   User : Grahame Grieve          many small fixes}
{0.00-127  01 Aug 02 08:12   [15715]   User : Grahame Grieve          fix bug where subcomponent contents was lost}
{0.00-126  26 Jul 02 09:03   [14141]   User : Anderson Miller         fix for xml schema version specific errors}
{0.00-125  24 Jul 02 17:44   [14049]   User : Grahame Grieve          remove hints and warnings}
{0.00-124  18 Jul 02 13:14   [15715]   User : Grahame Grieve          Major rewrite - XML encoding, assertions}
{0.00-123  05 Jun 02 12:27   [15715]   User : Grahame Grieve          fix minor leak}
{0.00-122  29 Apr 02 14:21   [14860]   User : Anderson Miller         reformat structures view}
{0.00-121  15 Mar 02 09:48   [15213]   User : Ryan Parasuraman        Compatibility fixes for previous HL7 versions}
{0.00-120  07 Mar 02 13:32   [14217]   User : Grahame Grieve          Add CountSegments, and work on showing which events use which segments}
{0.00-119  27 Feb 02 14:52   [15060]   User : Grahame Grieve          xml changes}
{0.00-118  19 Feb 02 15:58   [15060]   User : Grahame Grieve          change to way unimportant exceptions are handled}
{0.00-117  11 Feb 02 11:49   [14984]   User : Grahame Grieve          fax case, add lock names}
{0.00-116  09 Feb 02 22:49   [14002]   User : Grahame Grieve          fix case of unit declaration}
{0.00-115  08 Feb 02 22:10   [14976]   User : Grahame Grieve          fix for v2.2}
{0.00-114  08 Feb 02 16:53   [14976]   User : Grahame Grieve          Symphonia issue when segments have no defined fields}
{0.00-113  08 Feb 02 11:58   [14960]   User : Grahame Grieve          Add ParseContent}
{0.00-112  06 Feb 02 17:40   [13579]   User : Grahame Grieve          suppression of StructName in message}
{0.00-111  04 Feb 02 14:37   [14831]   User : Grahame Grieve          make sure properties are reflected in HL7 content}
{0.00-110  30 Jan 02 15:17   [14860]   User : Kevin Moynihan          Dunit testing fixes}
{0.00-109  30 Jan 02 14:05   [14860]   User : Kevin Moynihan          DUnit testing fixes}
{0.00-108  30 Jan 02 09:33   [14831]   User : Grahame Grieve          addfields, better cloning}
{0.00-107  21 Jan 02 10:56             User : Grahame Grieve          fix batch analysis bug - eoln finding}
{0.00-106  16 Jan 02 08:14             User : Zhu Gladding            fix problem where repeat fields were ignored if first field not valid}
{0.00-105  21 Dec 01 23:24             User : Grahame Grieve          fix repeats access violation}
{0.00-104  02 Dec 01 18:55             User : Bob Hall                trap out of bounds array error in GetRepeats}
{0.00-103  01 Dec 01 16:02             User : Grahame Grieve          insertsegment}
{0.00-102  07 Nov 01 16:40             User : Grahame Grieve          working on Segment Map}
{0.00-101  07 Nov 01 12:59             User : Grahame Grieve          message segment maps}
{0.00-100  20 Oct 01 11:59             User : Bob Hall                Replace IFDEF MSWINDOWS with IFNDEF LINUX}
{0.00-099  19 Oct 01 17:33             User : Grahame on Red Hat      Compile OK for Kylix}
{0.00-098  17 Oct 01 10:34             User : Grahame Grieve          Subcomponent fixes}
{0.00-097  15 Oct 01 16:57             User : Grahame Grieve          Support for sub-components. Change Cell props to auto ref child props}
{0.00-096  09 Oct 01 10:33             User : Grahame Grieve          xml support}
{0.00-095  30 Sep 01 22:30             User : Kevin Moynihan          version conversion}
{0.00-094  27 Sep 01 14:37             User : Anderson Miller         check case of HL7Connect}
{0.00-093  27 Sep 01 13:08             User : Grahame Grieve          fix doco and link}
{0.00-092  27 Sep 01 11:48             User : Grahame Grieve          Move code between kdate and kscript for hl7_dict release}
{0.00-091  25 Sep 01 17:40             User : Grahame Grieve          fix flag value}
{0.00-090  25 Sep 01 13:27             User : Grahame Grieve          fixes for batches and repeats}
{0.00-089  24 Sep 01 08:37             User : Grahame Grieve          Script documentation update}
{0.00-088  23 Sep 01 20:39             User : Grahame Grieve          change BuildAsReply - fix MsgID, Use index not name}
{0.00-087  22 Sep 01 23:57             User : Grahame Grieve          better parsing error messages}
{0.00-086  21 Sep 01 00:29             User : Grahame Grieve          fixes to table presentation}
{0.00-085  20 Sep 01 14:06             User : Grahame Grieve          fix problem getting Event Type in V2.1}
{0.00-084  20 Sep 01 11:46             User : Andrew Cumming          Removed ANOTHER warning}
{0.00-083  20 Sep 01 13:02             User : Grahame Grieve          finish - batch support, bugs fixed, config overhauled, doco'ed}
{0.00-082  19 Sep 01 12:01             User : Grahame Grieve          finish batch support}
{0.00-081  18 Sep 01 08:57             User : Grahame Grieve          Batch Support Part #1}
{0.00-080  15 Sep 01 11:31             User : Grahame Grieve          remove hints and warnings}
{0.00-079  03 Sep 01 10:07             User : Grahame Grieve          add clear all}
{0.00-078  31 Aug 01 19:20             User : Bob Hall                Add function AddComponent}
{0.00-077  27 Aug 01 09:09             User : Grahame Grieve          fix leaks, range checking issues}
{0.00-076  20 Aug 01 15:40             User : Grahame Grieve          fixes for views}
{0.00-075  17 Aug 01 10:02             User : Tony Farlie             Fixed check for wildcard being repeatable}
{0.00-074  17 Aug 01 11:10             User : Grahame Grieve          make GetExceptionCode public}
{0.00-073  17 Aug 01 09:06             User : Tony Farlie             Check for wildcard when determining if repeatable is true.}
{0.00-072  15 Aug 01 12:54             User : Anderson Miller         added style sheet to dictionary}
{0.00-071  14 Aug 01 16:10             User : Grahame Grieve          Fix for MessageType in v2.1}
{0.00-070  13 Aug 01 08:54             User : Grahame Grieve          fix SetRawContent - allowed even if not relevent (internal use)}
{0.00-069  13 Aug 01 08:08             User : Grahame Grieve          change to exception names, prevent writing irrelevent cells}
{0.00-068  07 Aug 01 11:56             User : Grahame Grieve          clean up global objects}
{0.00-067  31 Jul 01 08:13             User : Grahame Grieve          Further script doco changes + refined error handling}
{0.00-066  30 Jul 01 09:04             User : Grahame Grieve          fix scripting comments}
{0.00-065  26 Jul 01 12:10             User : Grahame Grieve          fix scripting documentation}
{0.00-064  26 Jul 01 10:31             User : Grahame Grieve          comments for scripting}
{0.00-063  24 Jul 01 12:23             User : Andrew Cumming          Added some wrapper uses statements}
{0.00-062  24 Jul 01 11:06             User : Andrew Cumming          rearranged property exposure code}
{0.00-061  23 Jul 01 16:45             User : Grahame Grieve          script functionality definitions and property changes}

// Kestral script system directives


{
Script system comments
======================

Several Kestral products expose the functionality encapsulated in this unit
to the Microsoft Scripting Engine. To suppport this functionality, this unit
is automatically parsed to generate further RTTI and related info not usually
generated by the compiler.

There is some idiosyncrasies caused by this. In particular, property access
functions for indexed properties must be public. In the public section, these
are wrapped by Script Hide and Script Show commands - to indicate that they
are in the public use for the scripting system only

This is also the reason there is published properties. Properties must be
exposed using RTTI before they are accessible internally in the scripting
engine. Just saying they are stored is not enough. The documentation that
does exist in this unit documenting the classes and their members is in the
script system syntax

All of the scripting documentation is left in the unit in order to make
the documentation available to developers. Note that the script comments
are sometimes geared towards javascript or VBScript syntax rather then
Pascal, but the concepts are always the same

The script system does not expose some classes in this unit. This is defined
below:
}

{!Wrapper uses Classes,HL7_Dict_Utils}
{!ignore THL7DictionaryDatabase}
{!ignore THL7DictionaryClass}
{!ignore THL7DictSegmentMapNode}

{ and finally, the actual code....}

unit HL7_Dict;

{$I hl7_dict.inc}

interface

uses
  Classes,
  Contnrs,
  HL7_Dict_Utils,
  oopklist,
  SysUtils,
  XDOM_2_3;

const
  // characters used to start and finish standard HL7 tcp/ip packets
  // these acquire a ubiquitious use in HL7 so are defined here
  START_BLOCK = #$0B;
  END_BLOCK = #$1C#$0D;

  // this character is used internally as the escape character in TX, FT and CF
  INTERNAL_ESCAPE_CHAR = #1;

  {$IFNDEF VER140}
  PathDelim = '\';
  {$ENDIF}

type
     {@Enum THL7ErrorCondition
      these are the possible error conditions described for the Error Condition
      Field MSA-6. In the standard, the error conditions are divided into AE and
      AR types. You can choose to follow this standard but it is not imposed on
      you. Note: There seems to be some inconsistencies in the standard regarding
      the categorisations for ACK types given to the error conditions
     }

  THL7ErrorCondition = (hecAccepted,                                                           // AA
    hecSequenceError, hecRequiredField, hecDataTypeError, hecNoTableValue, // AE
    hecUnsMsgType, hecUnsEvntCode, hecUnsProcID, hecUnsVersion,
    hecSuperfluousSeg, hecRequiredSeg,
    hecUnknownKey, hecDuplicateKey, hecRecordLocked, hecInternalError,     // AR

    // internals - all mapped to 207 (hecInternalError) in message
    // but provided here in case useful

    hecDictionaryError,   // internal invalidity in dictionary - i.e. specified non-existent data-type etc
    hecBadSegCode,        // message or application attempted to use an undefined segment.
    // although often this is quashed and handled (Z segment support)
    hecNoDictionary,      // couldn't find dictionary??
    hecHL7LibraryError,   // Error in code - not complete in that section
    hecApplicationError,  // Error in Appliction - tried to do something wrong
    hecBadField,          // contents of a field are OK syntactically but application didn't like them
    hecBadMessage,        // couldn't begin to decode message or format was bad
    hecXML);              // an xml error

  THL7EncodingOptions = (
    eoOptimisticMapping,   // when writing XML, how the segments are mapped against the segment
                           // structure. If this is not defined, then the list of segments must
                           // match the expected list. If this is not defined, then the mapping
                           // code will attempt to deal with unexpected segments. Note that in
                           // optimistic mapping, things can go quite badly wrong if they do go
                           // wrong

    eoAllowMappingToFail); // If this is set, then if mapping fails, any remaining segments not
                           // mapped will be mapped into the root segment. If this is not set,
                           // and mapping fails, then an exception will be raised and encoding
                           // will fail

  THL7EncodingOptionSet = Set of THL7EncodingOptions;


  // when you raise an EBaseHL7Exception, and then this is subsequently
  // passed back in to AnswerMsg.SetExecption, the Error Code (AE/AR) will
  // automatically be determined from the error condition.
  // There's some inconsistencies in the standard here. If you don't like
  // the way this works, you can override it by raising a EHL7RejectException
  // or a EHL7ErrorException, which dictate the code used (AR/AE respectively)

  EBaseHL7Exception = class(Exception)
  Private
    FCondition: THL7ErrorCondition;
  Public
    constructor Create(HL7Condition: THL7ErrorCondition; AMessage: String);
  end;

  EHL7RejectException = class(EBaseHL7Exception);
  EHL7ErrorException = class(EBaseHL7Exception);
  EHL7SegmentOrderException = class(EHL7ErrorException)
  Public
    constructor Create(AMessage: String);
  end;
  EHL7ProgrammerException = class(EHL7RejectException); // programmer has done something wrong
  EHL7LibraryException = class(EHL7RejectException); // something wrong with the library itself

  EHL7TrivialException = class(EBaseHL7Exception);
  EHL7TrivialProcessException = class(EHL7ErrorException);
  // these types are introduced so the debugger can be set to ignore some common exceptions

  THL7DictStructure = class;
  THL7DictEvent = class;
  THL7Dictionary = class;
  THL7DictionaryList = class;
  THL7DataElement = class;
  THL7Component = class;
  THL7Segment = class;
  THL7Message = class;

  TOnTransferProgress = procedure(Sender: TObject; Version, Table: String; Count, total: Integer; var abort: Boolean) of object;

{ abstract class for access to a particular implementation of the standard
HL7 Dictionary. Known Implementations:
  Unit                Class                    Description
  hl7_dict_odbc.pas   THL7AccessDictionary     Direct access to Native HL7 Dictionary using ODBCExpress
  hl7_dict_odbc.pas   THL7RDBMSDictionary      Access to implementation of HL7 Dictionary in any database
  hl7_dict_bde.pas    THL7BDEDictionary        Direct Access to Native Hl7 Dictionary using BDE.
  hl7_dict_text.pas   THL7TextDictionary       Text implementation of HL7Dictionary (for distribution)

note: hl7_dict_odbc is not suitable for open release due to dependence on multiple 3rd party libraries
that have undergone significant change by Kestral}

  THL7DictionaryDatabase = class(THL7BaseObject)
  Private
    FOnTransferProgress: TOnTransferProgress;
    procedure TransferVersion(AVersion: String; ADest: THL7DictionaryDatabase);

  Protected
    procedure PrepareForLoad(wipe: Boolean); Virtual; Abstract;
    procedure DoneLoading(TransferEvent: TOnTransferProgress); Virtual; Abstract;

    function VersionDefined(version: String; var Desc: String): Boolean; Virtual; Abstract;
    procedure ListVersions(VersionList: TStringList); Virtual; Abstract;
    procedure AddVersion(Version, description: String); Virtual; Abstract;

    function StartLoadFields(Code, version: String): pointer; Virtual; Abstract;
    function GetNextField(p: pointer; var Code: String; var DI: Integer;
      var Req, Rep: String;
      var RepCount, FNum: Integer): Boolean; Virtual; Abstract;
    procedure CloseLoadFields(p: pointer); Virtual; Abstract;
    function CountFields(version: String): Integer; Virtual; Abstract;
    procedure AddField(Version, Code: String; Di: Integer; Req, Rep: String;
      RepCount, FNum: Integer); Virtual; Abstract;

    function StartLoadComponents(Version: String): pointer; Virtual; Abstract;
    function GetNextComponent(p: pointer; var Desc: String; var tid: Integer;
      var code: String; var cnum: Integer): Boolean; Virtual; Abstract;
    procedure CloseLoadComponents(p: pointer); Virtual; Abstract;
    function CountComponents(version: String): Integer; Virtual; Abstract;
    procedure AddComponent(Version: String; Desc: String; tid: Integer;
      code: String; cnum: Integer); Virtual; Abstract;

    function StartLoadDataElements(Version: String): pointer; Virtual; Abstract;
    function GetNextElement(p: pointer; var desc, struc: String;
      var len, tid, di: Integer): Boolean; Virtual; Abstract;
    procedure CloseLoadDataElements(p: pointer); Virtual; Abstract;
    function CountDataElements(version: String): Integer; Virtual; Abstract;
    procedure AddDataElement(Version: String; desc, struc: String;
      len, tid, di: Integer); Virtual; Abstract;

    function StartLoadDataTypes(Version: String): pointer; Virtual; Abstract;
    function GetNextDataType(p: pointer; var Name, desc: String;
      var len: Integer): Boolean; Virtual; Abstract;
    procedure CloseLoadDataTypes(p: pointer); Virtual; Abstract;
    function CountDataTypes(version: String): Integer; Virtual; Abstract;
    procedure AddDataType(Version: String; Name, desc: String; len: Integer); Virtual; Abstract;

    function StartLoadSegment(Code, Version: String): pointer; Virtual; Abstract;
    function GetNextSegment(p: pointer; var code, desc: String): Boolean; Virtual; Abstract;
    procedure CloseLoadSegments(p: pointer); Virtual; Abstract;
    function CountSegments(version: String): Integer; Virtual; Abstract;
    procedure AddSegment(version: String; code, desc: String); Virtual; Abstract;

    function StartLoadStructures(Version: String): pointer; Virtual; Abstract;
    function GetNextStructure(p: pointer; var struc, desc, code: String;
      var elem: Integer): Boolean; Virtual; Abstract;
    procedure CloseLoadStructures(p: pointer); Virtual; Abstract;
    function CountStructures(version: String): Integer; Virtual; Abstract;
    procedure AddStructure(Version, struc, desc, code: String; elem: Integer); Virtual; Abstract;

    function StartLoadStructureComps(Version: String): pointer; Virtual; Abstract;
    function GetNextStructureComp(p: pointer; var struc: String;
      var fNum, cNum: Integer): Boolean; Virtual; Abstract;
    procedure CloseLoadStructureComps(p: pointer); Virtual; Abstract;
    function CountStructureComps(version: String): Integer; Virtual; Abstract;
    procedure AddStructureComp(Version, struc: String; fNum, cNum: Integer); Virtual; Abstract;

    function StartLoadTables(Version: String): pointer; Virtual; Abstract;
    function GetNextTable(p: pointer; var desc: String;
      var tid: Integer): Boolean; Virtual; Abstract;
    procedure CloseLoadTables(p: pointer); Virtual; Abstract;
    function CountTables(version: String): Integer; Virtual; Abstract;
    procedure AddTable(Version: String; desc: String; tid: Integer); Virtual; Abstract;

    function StartLoadTableItems(Version: String): pointer; Virtual; Abstract;
    function GetNextTableItem(p: pointer; var tid, sNum: Integer;
      var Value, desc: String): Boolean; Virtual; Abstract;
    procedure CloseLoadTableItems(p: pointer); Virtual; Abstract;
    function CountTableItems(version: String): Integer; Virtual; Abstract;
    procedure AddTableItem(Version: String; tid, sNum: Integer;
      Value, desc: String); Virtual; Abstract;

    function StartLoadEventList(Version: String): pointer; Virtual; Abstract;
    function GetNextEvent(p: pointer; var code, desc: String): Boolean; Virtual; Abstract;
    procedure CloseLoadEventList(p: pointer); Virtual; Abstract;
    function CountEvents(version: String): Integer; Virtual; Abstract;
    procedure AddEvent(Version, code, desc: String); Virtual; Abstract;

    function StartLoadEventDetails(Version: String): pointer; Virtual; Abstract;
    function GetNextEventDetails(p: pointer; var EventCode, SendMsg, SendStruct,
      RetMsg, RetStruct: String; var FieldNum: Integer): Boolean; Virtual; Abstract;
    procedure CloseLoadEventDetails(p: pointer); Virtual; Abstract;
    function CountEventDetails(version: String): Integer; Virtual; Abstract;
    procedure AddEventDetails(Version, EventCode, SendMsg, SendStruct,
      RetMsg, RetStruct: String; FieldNum: Integer); Virtual; Abstract;

    function StartLoadMsgStructs(Version: String): pointer; Virtual; Abstract;
    function GetNextMsgStructs(p: pointer; var Name, Desc, ExampleEvent,
      ExampleMsgType, action: String): Boolean; Virtual; Abstract;
    procedure CloseLoadMsgStructs(p: pointer); Virtual; Abstract;
    function CountMsgStructs(version: String): Integer; Virtual; Abstract;
    procedure AddMsgStruct(Version, Name, Desc, ExampleEvent,
      ExampleMsgType, action: String); Virtual; Abstract;

    function StartLoadMsgStructSegments(Version: String): pointer; Virtual; Abstract;
    function GetNextMsgStructSegments(p: pointer; var MsgStruct: String; var FieldNum: Integer; var SegCode, GroupName: String; var Repeats, Optional: Boolean): Boolean; Virtual; Abstract;
    procedure CloseLoadMsgStructSegments(p: pointer); Virtual; Abstract;
    function CountMsgStructSegments(version: String): Integer; Virtual; Abstract;
    procedure AddMsgStructSegment(Version, MsgStruct: String; FieldNum: Integer; SegCode, GroupName: String; Repeats, Optional: Boolean); Virtual; Abstract;

    function StartLoadEvntMsgSegments(Version: String): pointer; Virtual; Abstract;
    function GetNextEvntMsgSegments(p: pointer; var MsgStruct: String; var FieldNum: Integer; var SegCode, GroupName: String; var Repeats, Optional: Boolean): Boolean; Virtual; Abstract;
    procedure CloseLoadEvntMsgSegments(p: pointer); Virtual; Abstract;
    function CountEvntMsgSegments(version: String): Integer; Virtual; Abstract;
    procedure AddEvntMsgSegment(Version, MsgStruct: String; FieldNum: Integer; SegCode, GroupName: String; Repeats, Optional: Boolean); Virtual; Abstract;
  Public
    function SourceDescription(fulldetails: Boolean): String; Virtual; Abstract;
    procedure TransferDatabase(ADest: THL7DictionaryDatabase; AWipe: Boolean);
    property OnTransferProgress: TOnTransferProgress Read FOnTransferProgress Write FOnTransferProgress;
  end;

  THL7DictionaryClass = class(THL7BaseObject)
  Protected
    FDictionary: THL7Dictionary;
    function View(AURLPrefix: String; AOptions: TStringList): String; Virtual; Abstract;
  Public
    constructor Create(ADict: THL7Dictionary); Virtual;
  end;

  {@Class THL7TableItem
  A specific entry in an HL7 Table
  }
  THL7TableItem = class(THL7BaseObject)
  Private
    FID: Integer;
    FCode: String;
    FDescription: String;
  Published
    {@member ID
    Numerical ID of table item
    }
    property ID: Integer Read FID;

    {@member Code
    Code for table item
    }
    property Code: String Read FCode;

    {@member Description
    Description of Table Item
    }
    property Description: String Read FDescription;
  end;

  {@Class THL7DictTable
  Definition of a table
  }
  THL7DictTable = class(THL7DictionaryClass)
  Private
    FDesc: String;
    FID: Integer;
    FValuesByID: THL7StringList;
    FValuesByCode: TStringList;
    function HTMLView: String;
  Public
    constructor Create(ADict: THL7Dictionary); Override;
    destructor Destroy; Override;
    {!Script Hide}
    function View(AURLPrefix: String; AOptions: TStringList): String; Override;
    {!Script Show}
  Published
    {@member ID
    Numerical ID of table
    }
    property ID: Integer Read FID;

    {@member Desc
    Description of table
    }
    property Desc: String Read FDesc;

    {@member ValuesByID
    List of values ordered by ID
    }
    property ValuesByID: THL7StringList Read FValuesByID;

    {@member ValuesByCode
    List of values ordered by Code
    }
    property ValuesByCode: TStringList Read FValuesByCode;
  end;

  {@Class THL7DictDataType
  Definition of a data type
  }
  THL7DictDataType = class(THL7DictionaryClass)
  Private
    FDesc, FName: String;
    FLength: Integer;
    function GetDesc: String;
  Public
    constructor Create(ADict: THL7Dictionary); Override;
    destructor Destroy; Override;
    {!Script Hide}
    function View(AURLPrefix: String; AOptions: TStringList): String; Override;
    {!Script Show}

    {@member Escapable
    Whether content of this type should be escaped (ER/7)
    }
    function Escapable(AEscapeMode : boolean): Boolean;
  Published
    {@member Length
    Length of the Data type
    }
    property Length: Integer Read FLength;

    {@member Name
    Name of the Data type
    }
    property Name: String Read FName;

    {@member Desc
    Description of the Data type
    }
    property Desc: String Read GetDesc;
  end;

  {@Class THL7DictComponent
  Definition of a component
  }
  THL7DictComponent = class(THL7DictionaryClass)
  Private
    FDescription: String;
    FTableID: Integer;
    FDataTypeCode: String;
    FDataType: THL7DictDataType;
    FStruct: THL7DictStructure;
    FTableObj: THL7DictTable;
    function GetDataType: THL7DictDataType;
  Public
    constructor Create(ADict: THL7Dictionary); Override;
    destructor Destroy; Override;
    {!Script Hide}
    function View(AURLPrefix: String; AOptions: TStringList): String; Override;
    {!Script Show}
  Published
    {@member DataType
    Type of component
    }
    property DataType: THL7DictDataType Read GetDataType;

    {@member Table
    table for component if defined
    }
    property Table: Integer Read FTableID;

    {@member Description
    Description of component
    }
    property Description: String Read FDescription;
  end;

  {@Class THL7DictStructure
  Definition of a structure
  }
  THL7DictStructure = class(THL7DictionaryClass)
  Private
    Fname: String;
    FDesc: String;
    FDataTypeCode: String;
    FDataType: THL7DictDataType;
    FComponents: TStringList;
  Public
    constructor Create(ADict: THL7Dictionary); Override;
    destructor Destroy; Override;

    {!Script Hide}
    function View(AURLPrefix: String; AOptions: TStringList): String; Override;
    {!Script Show}

    function GetComponents(AName: String): THL7DictComponent;

    {@member Components
    Get a particular component (if a complex type)
    }
    property Components[AName: String]: THL7DictComponent Read GetComponents;
  Published
    {@member DataType
    Data type - if the type is a simple one
    }
    property DataType: THL7DictDataType Read FDataType;

    {@member ComponentList
    Components - if it is a complex type
    }
    property ComponentList: TStringList Read FComponents;
  end;


  {@Class THL7DictDataElement
  Information about a data element definition
  }
  THL7DictDataElement = class(THL7DictionaryClass)
  Private
    FDescription: String;
    FStructure: String;
    FStructureObj: THL7DictStructure;
    FLength: Integer;
    FTable: Integer;
    FTableObj: THL7DictTable;
    function GetStructureObj: THL7DictStructure;
  Public
    constructor Create(ADict: THL7Dictionary); Override;
    destructor Destroy; Override;
    {!Script Hide}
    function View(AURLPrefix: String; AOptions: TStringList): String; Override;
    property Structure: String Read FStructure;
    {!Script Show}
  Published
    {@member Description
    Description of the dataelement type
    }
    property Description: String Read FDescription;

    {@member StructureObj
    Structural definition of Data Element
    }
    property StructureObj: THL7DictStructure Read GetStructureObj;

    {@member Length
    Length limit of data element (for simple types)
    }
    property Length: Integer Read FLength;

    {@member Table
    Table ID if table is defined for this field
    }
    property Table: Integer Read FTable;
  end;

  {@Class THL7DictSegmentField
  Information about a particular field in a Segment
  }
  THL7DictSegmentField = class(THL7DictionaryClass)
  Private
    FIndex: Integer;
    FDataElement: Integer;
    FRequired: Boolean;
    FRepeatable: Boolean;
    FRepeats: Integer;
    function GetDataElementObj: THL7DictDataElement;
    function GetRepeatable: Boolean;
  Public
    constructor Create(ADict: THL7Dictionary); Override;
    destructor Destroy; Override;
    {!Script Hide}
    function View(AURLPrefix: String; AOptions: TStringList): String; Override;
    {!Script Show}
    property DataElement: Integer Read FDataElement;
  Published
    {@member DataElementObj
    Link to the formal definition for the data element in this field
    }
    property DataElementObj: THL7DictDataElement Read GetDataElementObj;

    {@member Required
    whether this field is required
    }
    property Required: Boolean Read FRequired;

    {@member Repeatable
    whether the field is repeatable
    }
    property Repeatable: Boolean Read GetRepeatable;

    {@member Repeats
    if this field is repeatable, the number of repeats. 0 = no limit
    }
    property Repeats: Integer Read FRepeats;
  end;

  {@Class THL7DictSegment
  Information pertaining to a segment
  }
  THL7DictSegment = class(THL7DictionaryClass)
  Private
    FName: String;
    FDesc: String;
    FFields: TStringList;
    procedure LoadFields(Adb: THL7DictionaryDatabase; AVersion: String);
  Public
    constructor Create(ADict: THL7Dictionary); Override;
    destructor Destroy; Override;
    {!Script Hide}
    function View(AURLPrefix: String; AOptions: TStringList): String; Override;
    {!Script Show}
  Published
    {@member Name
    Name of the segment (3 letter code)
    }
    property Name: String Read FName;

    {@member Desc
    Description of the segment
    }
    property Desc: String Read FDesc;

    {@member Fields
    Fields for the segment
    }
    property Fields: TStringList Read FFields;
  end;

  THL7SegmentGroup = class(TObjectList)
  Private
    FGroupName: String;
  end;

  {@Class THL7DictSegmentMapNode
  Abstract type for an item in the Segment Map
  }
  THL7DictSegmentMapNode = class(THL7DictionaryClass)
  Private
    FOptional: Boolean;
    FRepeating: Boolean;
    function QuickView(AURLPrefix: String; AIndent: Integer): String; Virtual; Abstract;
    function DescribeCardinality: String;
  Public
    {@member Optional
    Whether Segment Node is optional
    }
    property Optional: Boolean Read FOptional;
    {@member Repeating
    Whether Segment Node can repeat
    }
    property Repeating: Boolean Read FRepeating;
  end;

  {@Class THL7DictSegmentMapSegment
  An entry for a segment in a Segment Map
  }
  THL7DictSegmentMapSegment = class(THL7DictSegmentMapNode)
  Private
    FSegCode: String;
    function QuickView(AURLPrefix: String; AIndent: Integer): String; Override;
  Protected
    function View(AURLPrefix: String; AOptions: TStringList): String; Override;
  Public
    {@member SegCode
    3 letter code for segment
    }
    property SegCode: String Read FSegCode;
  end;

   {@Class THL7DictSegmentMapGroup
     An Entry for a group in a Segment Map
   }
  THL7DictSegmentMapGroup = class(THL7DictSegmentMapNode)
  Private
    FNodeList: THL7StringList;
    FGroupName: String;
    FSegNum: Integer;
    FIsChoiceGroup: Boolean;

    function GetNode(i: Integer): THL7DictSegmentMapNode;
    function GetNodeCount: Integer;
    function QuickView(AURLPrefix: String; AIndent: Integer): String; Override;
    function BuildSegmentMap(AGroupName: String; ASegmentList: TStringList; var VSegIndex: Integer; AOptions : THL7EncodingOptionSet; AOptional: Boolean): THL7SegmentGroup;
  Protected
    function View(AURLPrefix: String; AOptions: TStringList): String; Override;
  Public
    constructor Create(ADict: THL7Dictionary); Override;
    destructor Destroy; Override;

    {@member GroupName
    Name of this group. This is taken from the v2.xml std schemas.
    }
    property GroupName: String Read FGroupName;

    {@member NodeCount
    Number of Nodes in this Group
    }
    property NodeCount: Integer Read GetNodeCount;

    {@member Node
    Get the ith Node
    }
    property Node [i: Integer]: THL7DictSegmentMapNode Read GetNode;
  end;

  {@Class THL7DictMessageStruct
  Structure ID - required for XML encoding
  }
  THL7DictMessageStruct = class(THL7DictionaryClass)
  Private
    FName: String;
    FDesc: String;
    FExampleEvent: String;
    FExampleMsgType: String;
    FAction: String;

    FSegmentMap: THL7DictSegmentMapGroup;
    FXMLMap: THL7DictSegmentMapGroup;

    // database loading support
    FLoadList: TObjectStack;
    FHighestField: Integer;
    FNoProcess: Boolean;

    function UsesSegment(ASegCode: String): Boolean;
    function DescribeWithLink(AURLPrefix: String; AOptions: TStringList; AEvent: THL7DictEvent): String;
    procedure StartLoading;
    procedure Load(AFieldNum: Integer; ASegmentName, AGroupName: String; ARepeats, AOptional: Boolean);
    procedure FinishLoading;
    procedure LoadXMLMap;
  Public
    constructor Create(ADict: THL7Dictionary); Override;
    destructor Destroy; Override;
    {!Script Hide}
    function View(AURLPrefix: String; AOptions: TStringList): String; Override;
    {!Script Show}
  Published
    {@Name
    Name of Message Structure. Some names are '?' - predates serious HL7 interest in
    managing the name of the structure
    }
    property Name: String Read FName;

    {@Description
    Description of Message Structure if available in HL7 standard
    }
    property Description: String Read FDesc;

    {@ExampleEvent
    Nominated example event for this type. Note that there may be more than one event for a given type
    }
    property ExampleEvent: String Read FExampleEvent;

    {@ExampleMsgType
    Nominated example Message Type for this type. Note that there may be more than one message type for a given type
    }
    property ExampleMsgType: String Read FExampleMsgType;

    {@Action
    From the standard. Meaning?
    }
    property Action: String Read FAction;

    {@member SegmentMap
    the Segment Map for this message
    }
    property SegmentMap: THL7DictSegmentMapGroup Read FSegmentMap;
  end;

  THL7SchemaStore = class(THL7BaseObject)
  Private
    FSchemaStore: TFileName;
    FSchemaDir: String;
    FSchemaMap: TStringList;
    FWriting: Boolean;
    FDomErr : string;
    procedure LoadSchemasFromStore;
    procedure StartBuild;
    procedure StopBuild;
    procedure WriteStoredGroup(AWriter: TWriter; AGroup: THL7DictSegmentMapGroup);
    procedure SaveSchemaMap(AVersion: String; AMap: THL7DictSegmentMapGroup);

    procedure ReadVersionSchemas(AVersion, ADirectory: String);
    procedure ReadSchemaGroup(ADom: TdomDocument; AGroup: THL7DictSegmentMapGroup; AVersion, AStruct: String);
    function LoadSchemaFromXML(AFileName: String; AVersion, AStruct: String): THL7DictSegmentMapGroup;
    function LoadSchemaFromStore(AVersion, AStruct, AFileName: String): THL7DictSegmentMapGroup;
    procedure ReadStoredGroup(AReader: TReader; AGroup: THL7DictSegmentMapGroup; AStruct: String);
    procedure DOMReadError(ASender: TObject; AError: TdomError; var VGo: boolean);
  Public
    constructor Create(ASchemaStore: TFileName; ASchemaDirectory: String);
    destructor Destroy; Override;
    function LoadSchemaMap(AVersion: String; AStruct: String): THL7DictSegmentMapGroup;
    procedure BuildFromSchemas;
  end;

  {@Class THL7DictEvent
  Name and description for a given event
  }
  THL7DictEvent = class(THL7DictionaryClass)
  Private
    FDesc: String;
    FName: String;
    FMessageTypes: TStringList;
    function ListMessageTypes: String;
  Public
    constructor Create(ADict: THL7Dictionary); Override;
    destructor Destroy; Override;
    {!Script Hide}
    function View(AURLPrefix: String; AOptions: TStringList): String; Override;
    {!Script Show}
  Published
    {@member Name
    name of event
    }
    property Name: String Read FName Write FName;

    {@member Desc
    Description of event
    }
    property Desc: String Read FDesc Write FDesc;

    {@member MessageTypes
    List of Message Types (with TDictMessageStructure in objects)
    }
    property MessageTypes: TStringList Read FMessageTypes;
  end;

   {@Class THL7Dictionary
     Encapsulates all the information known about a particular version
     of HL7
   }
  THL7Dictionary = class(THL7BaseObject)
  Private
    FOwner: THL7DictionaryList;
    FVersion: String;
    FMaxTableID: Integer;
    FTables: TKeyList;
    FMaxDataID: Integer;
    FDataElements: TKeyList;
    FSegments: TStringList;
    FLock: THL7CriticalSection;
    FStructures: TStringList;
    FComponents: TKeyList;
    FMaxCompID: Integer;
    FDataTypes: TStringList;
    FEvents: TStringList;
    FMsgStructs: TStringList;
    NonValidSegmentList: TStringList;
    procedure LoadTables;
    procedure LoadDataElements;
    procedure LoadStructures;
    procedure LoadComponents;
    procedure LoadDataTypes;
    procedure LoadEvents;
    procedure LoadMsgStructs;
    function LoadSegment(ACode: String): THL7DictSegment;
    procedure DropItem(APtr: pointer);
    procedure CheckVersionDefined;
    function GetEvent(AEventName: String): THL7DictEvent;
    function GetStructure(AStructName: String): THL7DictMessageStruct;
    procedure LinkComponents;
    function SupportsXMLSchema: Boolean;
    function ViewElement(AURLPrefix: String; AOptions: TStringList; var VTitle: String): String;
    function ViewEvents(AURLPrefix: String; AOptions: TStringList; var VTitle: String): String;
    function ViewMsgTypes(AURLPrefix: String; AOptions: TStringList; var VTitle: String): String;
    function ViewSegment(AURLPrefix: String; AOptions: TStringList; var VTitle: String): String;
    function ViewStructure(AURLPrefix: String; AOptions: TStringList; var VTitle: String): String;
    function ViewTable(AURLPrefix: String; AOptions: TStringList; var VTitle: String): String;
  Public
    constructor Create(AVersion: String; AOwner: THL7DictionaryList);
    destructor Destroy; Override;

    {!Script Hide}
    procedure LoadEventList(AEventList: TStringList);
    procedure LoadEventClassList(AClassList: TStringList);
    function View(AURLPrefix: String; AOptions: TStringList; var VTitle: String): String;
    {!Script Show}

    function GetSegment(ACode: String): THL7DictSegment;

    {@member Segment
    Return a handle to dictionary information for a given segment
    }
    property Segment[ACode: String]: THL7DictSegment Read GetSegment;
  end;

  {@Class THL7DictionaryList
  Root of the HL7 Dictionary tree - holds the Version Specific Dictionaries.
  }
  THL7DictionaryList = class(THL7BaseObject)
  Private
    FDatabase: THL7DictionaryDatabase;
    FSchema: THL7SchemaStore;
    FDicts: TStringList;
    FStoredVersions: TStringList;
    FLock: THL7CriticalSection;
    FSuppressEscapingByDefault: boolean;
    procedure SetDatabase(ADatabase: THL7DictionaryDatabase);
  Public
    constructor Create(ADatabase: THL7DictionaryDatabase; ASchema: THL7SchemaStore);
    destructor Destroy; Override;

    {!Script Hide}
    function GetDictionary(AVersion: String): THL7Dictionary;

    // this is provided for historical interfaces that are already set up to handle escaping themselves.
    // if this is true then by default all messages will not do escaping when reading or writing messages.
    // this is not compatible with use of XML
    property SuppressEscapingByDefault : boolean read FSuppressEscapingByDefault write FSuppressEscapingByDefault;

    // link to raw database object. Usually the only need to use this
    // directly is to get a description of it's source
    property Database: THL7DictionaryDatabase Read FDatabase Write SetDatabase;
    property SchemaStore: THL7SchemaStore Read FSchema;
    {!Script Show}

    {@member LoadVersion
    Load the specified version. An exception will occur it the
    specified version does not exist in the dictionary
    }
    procedure LoadVersion(AVersion: String);

    {@member Dictionary
    Get the dictionary for a particular version. If the version is
    not already loaded, LoadVersion will be called internally
    }
    property Dictionary[AVersion: String]: THL7Dictionary Read GetDictionary; default;

    {@member Versions
    A list of the version loaded
    }
    function Versions: String;
  Published
    {@member VersionList
    Direct access to the loaded version list. (not known why this would be required?)
    }
    property VersionList: TStringList Read FDicts;

    {@member StoredVersionList
    list of stored versions (Versions are generally only loaded as required)
    }
    property StoredVersionList: TStringList Read FStoredVersions;
  end;


  //HL7 message as encoded packet
  THL7Packet = String;

  // encapsulates the properties required to allow a decoder to decode
  THL7SegmentOwner = class(THL7BaseObject)
  Private
    FDicts: THL7DictionaryList;
    FDict: THL7Dictionary;
    FFieldDelimiter: Char;
    FComponentDelimiter: Char;
    FSubComponentDelimiter: Char;
    FRepetitionDelimiter: Char;
    FEscapeCharacter: Char;
    FVersion: String;
    FSegments: TStringList;
    FSuppressEscaping: boolean;
    FSuppressEscapingSet : boolean;
    procedure SetDicts(const AValue: THL7DictionaryList);
    procedure DropMetaData; Virtual;
    procedure SetSuppressEscaping(const Value: boolean);
  Public
    constructor Create;
  Published
    destructor Destroy; Override;
    {@member Dictionaries
    Link to Dictionary lists used for this message
    }
    property Dictionaries: THL7DictionaryList Read FDicts Write SetDicts;
    property SuppressEscaping : boolean read FSuppressEscaping write SetSuppressEscaping;
  end;

  { this is the abstract definition of an ITS Class. below, the following ITS classes
  are defined:

  THL7ER7  Standard Vertical Bar encoding
  THL7XML  XML encoding (not implemented yet)
  }

  THL7AbstractITS = class(THL7BaseObject)
  Private
    FSegOwner: THL7SegmentOwner;
    FIsMessage: Boolean;
    FPacket: THL7Packet;

    function Encode(AMsg: THL7SegmentOwner; AOptions : THL7EncodingOptionSet; ASpecificSegment: THL7Segment = NIL): THL7Packet; Virtual; Abstract;
    procedure Decode(AMsg: THL7SegmentOwner; APacket: THL7Packet; AVersionOverride: String; ASegmentLimit: Integer); Virtual; Abstract;
    procedure ExtraDecode(AMsg: THL7SegmentOwner; APacket: THL7Packet); Virtual; Abstract;
    procedure SplitMessage(var VContent, VMessage, VSegmentID: String); Virtual; Abstract;
  Public
    constructor Create; Virtual;
  end;

  THL7ITSClass = class of THL7AbstractITS;

  TValidationOptions = (voSegmentOrder, voRequired, voDateFormat);
  TValidationOptionSet = set of TValidationOptions;

  {@Class THL7CommonDataCell
  The common Component lays down common content management for the
  subcomponent, component and DataElement classes.
  }
  THL7CommonDataCell = class(THL7BaseObject)
  Private
    FLevel : integer;
    FElementIndex: Integer;
    FDefined: Boolean;
    FRawContent: String;
    FIsDate: Boolean;
    FValid: Boolean;
    function GetDefined: Boolean; Virtual;
    function GetAsDateTime: TDateTime;
    function GetAsFloat: Double;
    function GetAsInteger: Integer;
    function GetAsString: String;
    function GetIsDate: Boolean;
    procedure SetDefined(const AValue: Boolean);
    procedure SetAsString(const AValue: String);
    procedure SetAsDateTime(const AValue: TDateTime);
    procedure SetAsInteger(const AValue: Integer);
    procedure SetAsFloat(const AValue: Double);
    function GetRawContent: String;
    procedure SetRawContent(const AValue: String);
  Protected
    // how to get the table will depend on the descendent
    function GetTable: THL7DictTable; Virtual; Abstract;
    function GetFieldName: String; Virtual; Abstract;
    function MyName: String; Virtual; Abstract;
    function GetFirstChild: THL7CommonDataCell; Virtual; Abstract;
    function GetHasChildren: Boolean; Virtual; Abstract;
    function GetChildCount : integer; Virtual; Abstract;
    function GetNthChild(i:integer):THl7CommonDataCell; Virtual; Abstract;
    function GetEscapable(AEscapeMode : boolean) : boolean; Virtual; Abstract;
  Public
    constructor Create(ALevel, AIndex: Integer); Virtual;
    destructor Destroy; Override;

    {@Member Valid
    False if the element failed the internal validation checks
    }
    property Valid: Boolean Read FValid;

    {@Member AsDateTimeWithReject
    Gets the content of the cell as a DateTime. If the contents are not a valid
    date, an exception with the message Desc will be raised (this is to assist
    in tracking down which field was responsible for the problem
    }
    function AsDateTimeWithReject(Desc: String): TDateTime;

    {@Member TableDefined
    Check if a table is defined for this component. If the cell has children,
    the result for the first child will be returned.
    }
    function TableDefined: Boolean;

    {@Member ValueInTable
    checks to see if a table is defined, then if the value provided is from the table.
    either code, or description is accepted. If the cell has children,
    the result for the first child will be returned.
    }
    function ValueInTable: Boolean;

    {@Member AsTableCode
    return the code for the item provided, whether a code or text was provided.
    If the cell has children, the result for the first child will be returned.
    }
    function AsTableCode(var VCode: String): Boolean;

    {@Member AddTableCode
    look up the value provided in the table and insert the code
    if value is non numeric this will return false if the code was not found
    If the cell has children, the result for the first child will be returned..
    }
    function AddTableCode(ACode: String): Boolean;

    {@Member ParseContent
    Take a valid HL7 substring (i.e. content^content^content^, and
    read it into the cell as if it were parsing a message. Any valid
    content will be overwritten. The default ITS is ER/7
    }
    procedure ParseContent(AString: String; AITSClass: THL7ITSClass = NIL);
  Published

    {@Member  AsString
    Get the contents of the cell as a string. If the cell has children,
    the contents of the first child will be returned.
    }
    property AsString: String Read GetAsString Write SetAsString;

    {@Member  AsInteger
    Get the contents of the cell as an integer. If the contents are
    not an integer, an exception will be raised. If the cell has children,
    the contents of the first child will be returned.
    }
    property AsInteger: Integer Read GetAsInteger Write SetAsInteger;

    {@Member  AsDateTime
    Get the contents of the cell as a datetime. If the contents are
    not a datetime, then an exception will be raised. if the content is
    blank, then the result will be 0. If the cell has children,
    the contents of the first child will be returned.
    }
    property AsDateTime: TDateTime Read GetAsDateTime Write SetAsDateTime;

    {@Member  AsFloat
    Get the contents of the cell as a Float. If the contents are not
    a number, then an exception will be raised. If the cell has children,
    the contents of the first child will be returned.
    }
    property AsFloat: Double Read GetAsFloat Write SetAsFloat;


    {@Member  Defined
    True if the contents are defined. This is relevent when the
    contents are empty, whether this is known empty, or unknown.
    i.e. true means that the cell contents are "".

    If the cell has children, the contents of the first child will be returned.
    }
    property Defined: Boolean Read GetDefined Write SetDefined;

    {@Member  GetHasChildren
    True if there is children of this cell
    }
    property HasChildren: Boolean Read GetHasChildren;

    {@Member  IsDate
    true if the field should contain a date according to the
    dictionary. The contents of the cell are not checked. If the cell
    has children, the value for the first child will be returned.
    }
    property IsDate: Boolean Read GetIsDate;

    {@Member  RawContent
    return the raw content of the cell (only when message was read from
    source, will be '' when building a new message).

    Unlike all the other properties, this will not return the value
    for this first child. Even if children exist, this will return the
    value for this cell, Although it will usually be empty if children
    exist.
    }
    property RawContent: String Read GetRawContent Write SetRawContent;

    {@Member  ClearAll
    Remove any content associated with the cell, and also in any
    children if they exist
    }
    procedure ClearAll; Virtual;
  end;

  {@Class THL7Component
  Encapsulates a component
  }
  THL7Component = class(THL7CommonDataCell)
  Private
    FDictComp: THL7DictComponent;
    FParent: THL7CommonDataCell;
    FField : THL7DataElement;
    FSubComponents: TObjectList;
    function BuildView(AHtml, AFull: Boolean; APrefix : string; AOffset, ACIndex: Integer): String;
    function GetSubComponentCount: Integer;
    procedure MakeForBuild;
    procedure Clone(AComp : THL7Component);
  Protected
    function GetDefined: Boolean; Override;
    function GetTable: THL7DictTable; Override;
    function GetFieldName: String; Override;
    function MyName: String; Override;
    function GetFirstChild: THL7CommonDataCell; Override;
    function GetHasChildren: Boolean; Override;
    function GetChildCount : integer; Override;
    function GetNthChild(i:integer):THl7CommonDataCell; Override;
    function GetEscapable(AEscapeMode : boolean) : boolean; Override;
  Public
    constructor Create(ALevel, AIndex: Integer); Override;
    destructor Destroy; Override;

    function GetSubComponents(s: String): THL7Component;

    {@member SubComponents
    List of subcomponents (not yet supported)
    }
    property SubComponents[s: String]: THL7Component Read GetSubComponents;

    {@member AddSubComponent
    Add a subcomponent manually to the Component, and return a handle to it.
    Will add intervening subcomponents if they do not exist.
    SubComponent format is unlimited string.
    If the subcomponent already exists, just return it.
    If subcomponent requested is > 100, return nil.
    }
    function AddSubComponent(ANum: Integer): THL7Component;

  Published
    {@member Definition
    Dictionary information about this component
    }
    property Definition: THL7DictComponent Read FDictComp;

    {@member SubComponentCount
    The number of subcomponents
    }
    property SubComponentCount: Integer Read GetSubComponentCount;

    procedure ClearAll; Override;
  end;

  {@Enum TCloneItemOptions
  AOptions for cloning segments
  }
  TCloneItemOptions = (cloneAllowUnknownContent, cloneOverwriteEmpty, cloneOverwriteUnDefined);
  TCloneItemOptionSet = set of TCloneItemOptions;

  {@Class THL7DataElement
  Encapsulates a Data Element (or Field)
  }
  THL7DataElement = class(THL7CommonDataCell)
  Private
    FDefinition: THL7DictSegmentField;
    FAltDefinition: String;
    FFirstInstance: Boolean;
    FSegment: THL7Segment;
    FRepeatList: TObjectList;
    Primary: THL7DataElement;
    FComponents: TStringList;
    function GetDefined: Boolean; Override;
    function BuildView(AHtml, AFull: Boolean; AOffset, AIndex: Integer): String;
    function LocalBuildView(AHtml, AFull: Boolean; AOffset, AIndex: Integer): String;
    procedure Validate(AMsg: THL7Message; AOptions: TValidationOptionSet);
    function GetComponentCount: Integer;
    function GetRepeatCount: Integer;
    procedure ChangeVersion(ANewDict: THL7Dictionary; ADeleteInvalidContent: Boolean; ADefinition: THL7DictSegmentField);
    procedure SetType(AType: String);
    procedure Clone(ADataElement : THL7DataElement);
  Protected
    function GetTable: THL7DictTable; Override;
    function GetFieldName: String; Override;
    function MyName: String; Override;
    function GetHasChildren: Boolean; Override;
    function GetFirstChild: THL7CommonDataCell; Override;
    function GetChildCount : integer; Override;
    function GetNthChild(i:integer):THl7CommonDataCell; Override;
    function GetEscapable(AEscapeMode : boolean) : boolean; Override;
  Public
    constructor Create(ALevel, AIndex: Integer); Override;
    destructor Destroy; Override;

    function GetComponents(AName: String): THL7Component;
    function GetRepeats(i: Integer): THL7DataElement;


    {@member Components
      List of Components - either if they are defined in the dictionary
      or if they were found when reading a message
    }
    property Components[AName: String]: THL7Component Read GetComponents; default;

    {@member Repeats
    Repeat 0 is the element itself, repeat 1 is the first of the actual repeats
    }
    property Repeats[i: Integer]: THL7DataElement Read GetRepeats;

    {@member ChooseRepeat
    choose repeat will scan the repeat list looking for "Value" (not case
    sensitive) in "Location". If location is '' then the base element is
    returned. However it is expected that a component will be Specified.
    A typical use for this is like this:
      msg['PID-3'].ChooseRepeat('5', 'MC')['1'].AsString
    or
     msg['PID-3'].ChooseRepeat('Identifier type code', 'MC')['ID'].AsString
    which will return the patients medicare number if available, or ''
    }
    function ChooseRepeat(ALocation, AValue: String): THL7DataElement;

    {@member MakeForBuild
    Populate the field with components etc from the database. Since this is
    done automatically when a segment is added to the message, it is
    not usually required to call this method
    }
    procedure MakeForBuild;

    {@member AddComponent
    Add a component manually to the field, and return a handle to it.
    Will add intervening components if they do not exist.
    Component format is unlimited string.
    If the component already exists, just return it.
    If component requested is > 100, return nil.
    }
    function AddComponent(ANum: Integer): THL7Component;

    {@member AddRepeat
    Add a repeat, and return the cell that is the new repeat.
    }
    function AddRepeat: THL7DataElement;

    {@member CloneDataElement
    Clone the data element. This is not usually called directly, it is
    called from Segment.CloneSegment
    }
    procedure CloneDataElement(ASourceDataElement: THL7DataElement; AOptions: TCloneItemOptionSet);

    procedure ClearAll; Override;
  Published
    {@member Definition
    Dictionary information about this data element
    }
    property Definition: THL7DictSegmentField Read FDefinition;

    {@member ComponentCount
    Number of Components
    }
    property ComponentCount: Integer Read GetComponentCount;

    {@member ComponentList
    List of Components. Use Components property in preference
    }
    property ComponentList: TStringList Read FComponents;

    {@member RepeatCount
    Number of repeats
    }
    property RepeatCount: Integer Read GetRepeatCount;
  end;

  {@Class THL7Segment
  Encapsulates a Segment
  }
  THL7Segment = class(THL7BaseObject)
  Private
    FOwner: THL7SegmentOwner;
    FSegmentContent: String;
    FCode: String;
    FDefinition: THL7DictSegment;
    FFields: TObjectList;
    function BuildView(AHtml, AFull: Boolean; AOffset: Integer): String;
    procedure ChangeVersion(ANewDict: THL7Dictionary; ADeleteInvalidContent: Boolean; ADefinition: THL7DictSegment);
    function GetSegmentIndex: Integer;
    procedure Validate(AMsg: THL7Message; AOptions: TValidationOptionSet);
  Public
    constructor Create(ACode: String; AOwner: THL7SegmentOwner);
    destructor Destroy; Override;

    function GetFieldByName(AFieldName: String): THL7DataElement;
    function GetElement(ACode: String): THL7CommonDataCell;

    {@member BuildFields
    Populate the segment with fields from the database. Since this is
    done automatically when a segment is added to the message, it is
    not usually required to call this method
    }
    procedure BuildFields;

    {@member FieldByName
    Get a field by name or number. if you use a name, be careful to
    use exactly what is in the Official HL7 Database - field spellings
    and punctuation varies from version to version
    }
    property FieldByName[AFieldName: String]: THL7DataElement Read GetFieldByName; default;

    {@member Element
    Get a element or component.
      "1" will get data element 1
      "2.3" will get component 3 of data element 2
    will return nil if requested cell not found. You can
    also use "-" instead of "."
    }
    property Element[ACode: String]: THL7CommonDataCell Read GetElement;

    {@member AddField
    Add a Data Element manually to the Segment, and return a handle to it.
    Will add intervening fields if they do not exist.
    field format is unlimited string.
    If the field already exists, just return it.
    If field requested is > 100, return nil.
    }
    function AddField(AFieldNum: Integer): THL7DataElement;

    {@member CloneSegment
    CloneSegment is used to copy the contents of a segment in one
    message into another message. Cloning should be able to deal with
    custom content, and with version translation issues, although this
    may be limited by lack of information.

    the AOptions available are:
      cloneAllowUnknownContent  If this is not defined, non-dictionary content will be ignored
      cloneOverwriteEmpty       If this is defined, empty fields in the source will overwrite any existing content in the destination
      cloneOverwriteUnDefined   If this is defined, undefined fields in the source will overwrite any existing content in the destination
    }
    procedure CloneSegment(ASourceSegment: THL7Segment; AOptions: TCloneItemOptionSet);
  Published
    {@member Fields
    Direct list of fields. Use FieldByName or Element in preference
    }
    property Fields: TObjectList Read FFields;

    {@member SegmentIndex
    returns the numerical ID of the segment in the message
    }
    property SegmentIndex: Integer Read GetSegmentIndex;

    {@member Definition
    Dictionary information about this segment
    }
    property Definition: THL7DictSegment Read FDefinition;

    {@member SegmentContent
    Raw content of segment before it was parsed into Data Elements and Components
    }
    property SegmentContent: String Read FSegmentContent;

    {@member Code
    3 letter code identifying the segment type
    }
    property Code: String Read FCode;
  end;

  {@Class THL7Message
  Encapsulates a single logical HL7Message.

  To read an existing message, create an HL7Message and then decode a source message.

  To create a reply, create an HL7Message, and then use BuildAsReply.

  To create a new message, create a message, set it's version, and then add
  the segments that you require and populate them with values. When finished,
  call Encode
  }
  THL7Message = class(THL7SegmentOwner)
  Private
    FEvent, FMessageType, FStructID: String;
    FMsgID, FSource: String;
    FDecodeTime: TDateTime;
    FStructure: THL7DictMessageStruct;
    FValidationNotes: TStringList;
    FAddStructName: Boolean;
    FSegmentMap: THL7SegmentGroup;
    function TryLoadStruct: Boolean;
    function GetEvent: String;
    function BuildView(AHtml, AFull: Boolean; AOffset: Integer): String;
    procedure SetVersion(const AValue: String);
    procedure SetEvent(const AValue: String);
    procedure SetMessageType(const AValue: String);
    procedure SetStructID(const AValue: String);
    procedure SetMsgID(const AValue: String);
    procedure AddValidationNote(ASegment, ACellID, ACellName, AError: String);
    procedure BuildSegmentMap(AOptions: THL7EncodingOptionSet);
    procedure BuildXMLSegmentMap(AOptions: THL7EncodingOptionSet);
    procedure DropMetaData; Override;
    procedure ResolveVariableTypes;
    function GetSegmentCount: Integer;
  Public
    constructor Create;
    destructor Destroy; Override;

    function GetSegment(ACode: String; i: Integer): THL7Segment;
    function GetElement(ACode: String): THL7CommonDataCell;

    {@member ChangeVersion
    Change the Version of the message to the version specified.
    ChangeVersion is not very elegant - use with care.

    if DeleteInvalidContent is true, anything in the message but
    not in the dictionary for the specified version is deleted.

    There is many issues with this procedure that are yet to be
    determined, including:
     * downgrading a message into a version where the event or message type does not exist
     * upgrading a message into a version which contains compulsory segments
    not defined in the initial version. (If this happens anywhere in the standard?)
    }
    procedure ChangeVersion(ANewVersion: String; ADeleteInvalidContent: Boolean);

    {@member Segment
    Retrieve a given segment (3 letter code).
    There may be multiple xxx segments in a message. Segment 0 is
    the first repeat of a given segment.
    }
    property Segment[ACode: String; i: Integer]: THL7Segment Read GetSegment;

    {@member Element
    Element is the most convenient way to retrieve a field
    Code is a string with format SEGn-N.O.P
      Seg - 3 letter code of segment
      n   - repeat of segment. Defaults to 0 (First segment) if not found
      N   - Data Element index (starts at 1)
      O   - Component Element index (starts at 1) [optional]
      P   - Subcomponent index  [optional]

    SEGn-N-O-P is also accepted
    }
    property Element[ACode: String]: THL7CommonDataCell Read GetElement; default;

    {@member Decode
    decode converts a message into a DOM type tree integrated with the
    dictionary.

    If VersionOverride is provided, a version of HL7 different to that
    claimed by the message will be used - a way to handle exceptions to
    the standard.

    If a segmentlimit is provided, only the first few segments will be
    decoded up to the specified limit. This is to support high-throughput
    applications only interested in the MSH (and perhaps the EVN). Note
    that PID's can be scattered through the message so it is dangerous
    to examine the PID segment if a segment limit has been set

    You can also nominate an ITSClass. The library will choose
    the right class for all messages currently observed, so this
    is not usually necessary

    }
    procedure Decode(APacket: THL7Packet; AVersionOverride: String = ''; ASegmentLimit: Integer = 0; AITSClass: THL7ITSClass = NIL);

    {!script hide}
    function EnCodeClass(AITSClass: THl7ITSClass = NIL; AOptions : THL7EncodingOptionSet = []): THL7Packet;
    {!Script Show}

    {@member EnCode
    Encode and return the encoded message, using the ITS specified
    by the parameters. Valid values are
      ER7    (the famous vertical bars)
      XML
    The default value is ER7
    }
    function EnCode(AITS: String = 'ER7'): THL7Packet;

    {@member BuildAsReply
    Build this message as a reply to the given message. Add sequence numbering
    info if provided
    }
    procedure BuildAsReply(AMsg: THL7Message; AUseSequenceNum: Boolean = False; ASequenceNum: Int64 = 0);

    {@member AppAckRequired
      true if message information indicates that an application acknowledge
      is required.
    }
    function AppAckRequired: Boolean;

    {@member SetException
    Populate NACK message according to the information contained in the
    exception. BuildAsReply must have been used already
    }
    procedure SetException(AExcept: Exception);

    {@member SetExceptionMessage
    Populate NACK message using the String in MSA-3. The message will
    be an AE unless MakeReject is true, in which case it will be an AR.
    BuildAsReply must have been used already
    }
    procedure SetExceptionMessage(AMsg: String; AMakeReject: Boolean = False);

    {@member View
    return a full analysis of the message.
    }
    function View(AHtml, AFull, AValidate: Boolean): String;

    {@member AddSegment
    Add the specifed segment to the message and build it's Data Elements and components
    }
    function AddSegment(ACode: String): THL7Segment;

    {@member InsertSegment
    Add the specifed to the segment to the message at the point nominated and build it's Data Elements and components
    If Index is 0, the string is inserted at the beginning of the list. If Index is 1, the string is put in
    the second position of the list, and so on.
    }
    function InsertSegment(AIndex: Integer; ACode: String): THL7Segment;

    {@member DropSegments
    Drop any segments with the given code from the message
    }
    procedure DropSegments(ACode: String);

    {@member CloneSegment
    Copy a segment from another message - add it to this message as
    a new segment. All information whether in dictionary or not will
    be copied across
    }
    procedure CloneSegment(ASegment: THL7Segment); // copy a segment from another message

    {@member AddMSHForBuild
    special case - this puts an MSH in place and populates it as much as possible from known information
    }
    procedure AddMSHForBuild;

    {@member AddMSHForBuild
    special case - this puts an MSH in place and populates it as much as possible from known information
    }
    function CountSegment(ACode: String): Integer;

    {@member Validate
      Check that the message conforms to the HL7 standard
    }
    procedure Validate(AOptions: TValidationOptionSet);


    {@member GetSegmentByIndex
      Retuirn the ith segment - for iterating the segments. the index if 0 based
      i.e. the first segment is 0, and the last segment is SegmentCount -1
    }
    function GetSegmentByIndex(AIndex: Integer): THL7Segment;
  Published

    {@member ShowStructName
    If it can be determined, the Structure of the message will automatically
    be inserted at MSH-9-3. You can suppress this behaviour by setting this
    to false (default is true)
    }
    property AddStructName: Boolean Read FAddStructName Write FAddStructName;

    {@member Version
    Version of message. This should be treated as read-only
    except when building a message before any segments have been added.

    If you want to change the version after the message has segments,
    use ChangeVersion
    }
    property Version: String Read FVersion Write SetVersion;

    {@member Event
    The event for this message
    }
    property Event: String Read GetEvent Write SetEvent;

    {@member MessageType
    The Message type for this message. Setting this will alter the value of the MSH segment if one exists
    }
    property MessageType: String Read FMessageType Write SetMessageType;

    {@member StructName
    The Name of the Message type for this message. Setting this will alter the value of the MSH segment if one exists
    }
    property StructName: String Read FStructID Write SetStructID;

    {@member  MsgID
    The message ID of this message. This should be treated as read-only
    except when building a message before any segments have been added.
    Setting this will alter the value of the MSH segment if one exists.
    }
    property MsgID: String Read FMsgID Write SetMsgID;

    {@member Structure
    Dictionary information about the structure for this message
    }
    property Structure: THL7DictMessageStruct Read FStructure;

    {@member Segments
    Full segment list. This is provided so that you can iterate the segments,
    but you shouldn't change this directly. This is deprecated - Use SegmentCount and GetSegmentByIndex instead
    }
    property Segments: TStringList Read FSegments;

    {@member SegmentCount
    The number of segments in the message.
    }
    property SegmentCount: Integer Read GetSegmentCount;

    {@member Source
    Full source for the original message (when reading)
    }
    property Source: String Read FSource;

    {@member ValidationNotes
      A list of problems found in the message when validating
    }
    property ValidationNotes: TStringList Read FValidationNotes;
  end;

  THL7ER7 = class(THL7AbstractITS)
  Private
    function Escape(AContent: String): String;
    function EncodeComponent(AComp: THL7Component): String;
    function EncodeDataElement(Ade: THL7DataElement): String;
    function EncodeSegment(ASeg: THL7Segment): String;
    function Encode(AMsg: THL7SegmentOwner; AOptions : THL7EncodingOptionSet; ASpecificSegment: THL7Segment = NIL): THL7Packet; Override;

    function UnEscape(AContent: String): String;
    procedure ParseCell(ACell: THL7CommonDataCell);
    procedure ParseDataElement(ADe: THL7DataElement; var VCursor: Integer);
    procedure DecodeSegment(var VCursor: Integer);
    function PreDecode: String;
    procedure Decode(AMsg: THL7SegmentOwner; APacket: THL7Packet; AVersionOverride: String; ASegmentLimit: Integer); Override;
    procedure ExtraDecode(AMsg: THL7SegmentOwner; APacket: THL7Packet); Override;
    procedure SplitMessage(var VContent, VMessage, VSegmentID: String); Override;
  end;

  THL7XML = class(THL7AbstractITS)
  Private
    FMsg: THL7Message;
    FDomError : string;
    function BuildXCharData(s:string):String;
    procedure BuildEscapedText(ADom: TdomDocument; ANode: TDomElement; AStr : string);
    function EncodeComponent(ADom: TdomDocument; AComp: THL7Component; AStruct: THL7DictStructure): TdomElement;
    function EncodeDataElement(ADom: TdomDocument; Ade: THL7DataElement; AFieldName: String): TdomElement;
    function EncodeSegment(ADom: TdomDocument; ASeg: THL7Segment): TdomElement;
    function Encode(AMsg: THL7SegmentOwner; AOptions : THL7EncodingOptionSet; ASpecificSegment: THL7Segment = NIL): THL7Packet; Override;

    procedure Decode(AMsg: THL7SegmentOwner; APacket: THL7Packet; AVersionOverride: String; ASegmentLimit: Integer); Override;
    procedure ExtraDecode(AMsg: THL7SegmentOwner; APacket: THL7Packet); Override;
    procedure SplitMessage(var VContent, VMessage, VSegmentID: String); Override;
    procedure ReadMessage(ARootElement: TdomElement);
    procedure ReadSegment(ASegmentRoot: TdomElement);
    procedure ReadField(AField: THL7DataElement; AFieldRoot: TdomElement);
    procedure ReadComponent(AComp: THL7Component; ACompRoot: TdomElement);
    procedure PreProcessMSGSegment(AMSHElement: TdomElement);
    procedure PostProcessMSGSegment;
    procedure EncodeSegments(ADom: TdomDocument; AParent: TdomElement; AGroup: THL7SegmentGroup);
    procedure ReadSegmentSeries(ANode: TdomNode);
    procedure DOMReadError(ASender: TObject; AError: TdomError;      var VGo: boolean);
  end;

  THL7Batch = class;

  THL7SeekMode = (hsmMessage, hsmBatch, hsmOffset);

  TBatchProgressEvent = procedure(i, t: Integer) of object;

  {@Class THL7BatchMessage
  A single message in a batch. The message is stored as plain text, not as a structured tree
  }
  THL7BatchMessage = class(THL7BaseObject)
  Private
    FCarrier: TObject;
    FBatch: THL7Batch;
    FContent: String;
    procedure SetContent(s: String);
  Public
    constructor Create(ABatch: THL7Batch);

    {!Script Hide}
    property Carrier: TObject Read FCarrier Write FCarrier;
    property Batch: THL7Batch Read FBatch;
    {!Script Show}

  Published
    {@member Content
    The Content of the Message
    }
    property Content: String Read FContent Write SetContent;

  end;

  {@Class THL7BatchElement
  Common ancestor for THL7Batch and THL7File classes
  }
  THL7BatchElement = class(THL7SegmentOwner)
  Private
    FCarrier: TObject;
    function GetHeader: THL7Segment;
    function GetTrailer: THL7Segment;
  Public
    {!Script Hide}
    property Carrier: TObject Read FCarrier Write FCarrier;
    {!Script Show}
  Published
    {@member Header
    Handle to Header Segment (FHS or BHS)
    }
    property Header: THL7Segment Read GetHeader;

    {@member Trailer
    Handle to Trailer Segment (FHS or BHS)
    }
    property Trailer: THL7Segment Read GetTrailer;
  end;

  THL7File = class;


  {@Class THL7Batch
  A single batch contained in an HL7 Batch File. If you create
  a batch manually to add to the File, you must call Init
  }
  THL7Batch = class(THL7BatchElement)
  Private
    FDict: THL7Dictionary;
    FMessages: TStringList;
    FFile: THL7File;
    FMsgCount: Integer;
    procedure MessagesChanged(ASender: TObject);
    procedure Encode(AITS: THL7AbstractITS; AStream: TStream);
    procedure Decode(AITS: THL7AbstractITS; AVersion: String; AProgressEvent: TBatchProgressEvent; ATotal: Integer; var VSegID, VTmp, VContent: String);
    function GetBatchID: String;
    procedure SetBatchID(AValue: String);
    function GetReplyBatchID: String;
    procedure SetReplyBatchID(AValue: String);

  Public
    constructor Create(AFile: THL7File);
    destructor Destroy; Override;

    {@member Init
    Reset & Populate all the internal fields. The version is required but only the
    BHS-3 field differs between versions

    If you create a batch manually, then you need to call init and provide a version number
    }
    procedure Init(AVersion: String);

    {@member AddMessage
    Add the message to the batch.
    }
    procedure AddMessage(ACnt: String);

  Published
    {@member Messages
    List of THL7BatchMessages in the batch
    }
    property Messages: TStringList Read FMessages;

    {@member BatchID
    ID of this batch (BHS-11). If the ID is #1 and there is only 1 batch in the file,
    the BHS and BTS segments will not be written in the file when it is
    encoded
    }
    property BatchID: String Read GetBatchID Write SetBatchID;

    {@member ReplyBatchID
    ID that this batch is in response to(BHS-12)
    }
    property ReplyBatchID: String Read GetReplyBatchID Write SetReplyBatchID;

  end;

  {@Class THL7File
  Encapsulates an HL7 Batch File that conforms to the 2.x standards.
  }
  THL7File = class(THL7BatchElement)
  Private
    FDict: THL7Dictionary;
    FBatchList: TStringList;

    // cursor
    FTotalCount: Integer;
    FCursor: Integer;
    FBatchCursor: Integer;
    FCurrentBatch: THL7Batch;
    FCurrentMessage: THL7BatchMessage;

    procedure Recount;
    procedure Locate;

    procedure SetPosition(const AValue: Longint);
    function GetCurrentBatch: THL7Batch;
    function GetCurrentMessage: THL7BatchMessage;
    procedure BatchListChanged(ASender: TObject);
    function GetFileID: String;
    function GetReplyFileID: String;
    procedure SetReplyFileID(const AValue: String);
    procedure SetFileID(const AValue: String);
  Public
    constructor Create;
    destructor Destroy; Override;

    {@member InitForBuild
    The version parameter is the version of the FHS, FTS, BHS and BTS
    segments used in the structure. All versions have the same field
    list, though field name spellings and field sizes differ slightly across the
    versions, and the type of the last field of the BTS segment differs.
    in practice it will matter little which version is used.
    }
    procedure InitForBuild(Version: String = '2.3.1');

    {@member AddBatch
    Add a Batch and make it the current batch
    }
    function AddBatch: THL7Batch;

    {@member LoadFromFile
    Load the batch from the nominated file
    }
    procedure LoadFromFile(AFilename: String; AProgressEvent: TBatchProgressEvent = NIL; AVersion: String = '2.3.1'; AITSClass: THL7ITSClass = NIL);

    {@member SaveToFile
    Save the batch to the nominated file
    }
    procedure SaveToFile(AFilename: String; AProgressEvent: TBatchProgressEvent = NIL; AITSClass: THL7ITSClass = NIL);

    {!Script Hide}
    procedure SetBatch(AIndex: Longint);
    // setbatch will set the cursor to the beginning of the nth batch
    // if the batch is empty then the position will be -1, even though
    // there is messages in other batches
    {!Script Show}

    {@member Seek
    Set the cursor to the specified location. Origin can be
      0 : From Beginning
      1 : From current location
      2 : From End
    You must use a negative number when seeking from the end
    }
    function Seek(AOffset: Longint; AOrigin: Word = soFromBeginning): Integer;

    {@member First
    Set the Cursor position to before the first message
    }
    procedure First;

    {@member Next
    Move to the cursor position 1 message further towards the end of the file. Return true if a message is found
    }
    function Next: Boolean;

    {@member Prev
    Move to the cursor position 1 message further towards the beginning of the file. Return true if a message is found
    }
    function Prev: Boolean;

    {@member Last
    Set the Cursor position to after the last message
    }
    procedure Last;

    {@member GetMessage
    Get the nth message. Index hs the same meaning as the value of the cursor
    }
    function GetMessage(AIndex: Integer): THL7BatchMessage;

  Published
    {@member CurrentMessage
    The current message identified by the cursor. Note: CurrentMessage
    may be null, if there is no messages, or if the cursor has been moved
    to an batch that contains no messages, or if First or Last has been
    used
    }
    property CurrentMessage: THL7BatchMessage Read GetCurrentMessage;

    {@member CurrentBatch
    current batch is the batch for the current message. This can
    also be null if First or Last has been used, or if there is no
    batches in the file
    }
    property CurrentBatch: THL7Batch Read GetCurrentBatch;

    {@member MessageCount
    The total number of messages in the batch
    }
    property MessageCount: Integer Read FTotalCount;

    {@member Position
    Current Cursor position
    }
    property Position: Longint Read FCursor Write SetPosition;

    {@member FileID
    the ID of the file (FHS-11)
    }
    property FileID: String Read GetFileID Write SetFileID;

    {@member ReplyFileID
    the ID the file that this file is in response to (FHS-12)
    }
    property ReplyFileID: String Read GetReplyFileID Write SetReplyFileID;

    {@member BatchList
    a list of batches in this file
    }
    property BatchList: TStringList Read FBatchList;

  end;

const
  FULL_VALIDATION = [voSegmentOrder, voRequired, voDateFormat];
  FULL_ESCAPING = FALSE;
  XML_ONLY_ESCAPING = TRUE;

{@routine HardCodedNack
This is provided for use when the HL7 infrastructure has completely failed.
This routine will generate a valid error message from the information given.
}
function HardCodedNack(AVersion, AErrMsg, AMsgid: String): THL7Packet;

{@routine GetExceptionConditionCode
Convert an HL7 Error code to the numerical representation
}
function GetExceptionConditionCode(ACond: THL7ErrorCondition): String;

  { this is global, but you do need to initialize it somewhere early.... }

var
  GHL7Dict: THL7DictionaryList = NIL;

resourcestring
  KdeVersionMark = {!!uv}'!-!HL7_Dict.pas,0.00-129,03 Dec 02 10:00,9359';
  {this embeds the value of the string in the executable from where it can be extracted to display the version of this unit incorporated in the executable}

implementation

uses
  KDate;

const
  ASSERT_UNIT = 'hl7_dict';

{ utility functions }

function LeftPad(html: Boolean; i: Integer; s: String = ''): String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.LeftPad';
var
  j: Integer;
  l: Integer;
begin
  if html then
    begin
    Result := s;
    if s = '' then
      begin
      l := i + 2
      end
    else
      begin
      l := i - length(s);
      end;
    for j := 1 to l do
      begin
      Result := '&nbsp;' + Result
      end;
    end
  else
    begin
    Result := PadString(s, i, ' ', True);
    end;
end;

function CellString(const s: String): String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.CellString';
begin
  if s = '' then
    begin
    Result := '&nbsp;'
    end
  else
    begin
    Result := s;
    end;
end;

function HTMLPad(AIndent: Integer): String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.HTMLPad';
var 
  i: Integer;
begin
  Result := '';
  for i := 1 to AIndent * 3 do
    begin
    Result := Result + '&nbsp;';
    end;
end;

function HardCodedNack(AVersion, AErrMsg, AMsgid: String): THL7Packet;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.HardCodedNack';
begin
  if AErrMsg = '' then
    begin
    AErrMsg := 'Total Failure of Kestral HL7 Engine';
    end;
  if AVersion = '' then
    begin
    AVersion := '2.2';
    end;
  Result := 'MSH|^~\&|Kestral|hl7engine|||200008251511||ADT^AXX|0|P|' + AVersion + #13 +
    'MSA|AE|' + AMsgId + '|' + AErrMsg + ' (Hardcoded NACK)' + #13;
end;

// this function is used to find xml special characters that need to be
// converted to HL7 \Xnn\ sequences

function HL7EscapeHexChars(AStr : String):String;
var
  LInEscape : boolean;
  LLen : integer;
  i : integer;
begin
  LInEscape := false;
  result := '';
  StringAppendStart(result, LLen);
  for i := 1 to length(AStr) do
    begin
    if AStr[i] in [' '..'~'] then
      begin
      if LInEscape then
        begin
        StringAppend(result, INTERNAL_ESCAPE_CHAR, LLen);
        LInEscape := false;
        end;
      StringAppend(result, AStr[i], LLen);
      end
    else
      begin
      if not LInEscape then
        begin
        StringAppend(result, INTERNAL_ESCAPE_CHAR+'X', LLen);
        LInEscape := true;
        end;
      StringAppend(result, IntToHex(ord(AStr[i]), 2), LLen);
      end;
    end;
  StringAppendClose(result, LLen);
end;

function AllContentHex(s:string):boolean;
var
  i : integer;
begin
  result := true;
  for i := 1 to length(s) do
    begin
    result := result and (Upcase(s[i]) in ['0'..'9', 'A'..'F']);
    end;
end;

{ EBaseHL7Exception }

constructor EBaseHL7Exception.Create(HL7Condition: THL7ErrorCondition; AMessage: String);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.EBaseHL7Exception.Create';
begin
  FCondition := HL7Condition;
  inherited Create(AMessage);
end;

{ EHL7SegmentOrderException }

constructor EHL7SegmentOrderException.Create(AMessage: String);
begin
  inherited Create(hecSequenceError, AMessage);
end;

{ THL7DictionaryClass }

constructor THL7DictionaryClass.Create(ADict: THL7Dictionary);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictionaryClass.Create';
begin
  inherited Create;
  FDictionary := ADict;
end;

{ THL7DictTable }

constructor THL7DictTable.Create;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictTable.Create';
begin
  inherited Create(ADict);
  FDesc := '';
  FValuesByID := THL7StringList.Create(True);
  FValuesByID.sorted := True;
  FValuesByID.Duplicates := dupError;
  FValuesByCode := TStringList.Create;
  FValuesByCode.sorted := True;
end;

destructor THL7DictTable.Destroy;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictTable.Destroy';
begin
  FreeAndNil(FValuesByID);
  FreeAndNil(FValuesByCode);
  inherited;
end;

function THL7DictTable.HTMLView: String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictTable.HTMLView';
var
  i: Integer;
  LItem: THL7TableItem;
begin
  Result := '<table border=0 cellspacing=0 cellpadding=0 class="tbl">' + crlf;
  for i := 0 to FValuesByID.Count - 1 do
    begin
    LItem := FValuesByID.objects[i] as THL7TableItem;
    if odd(i) then
      begin
      Result := Result +
        ' <tr>' +
        '<td valign="top">' + CellString(LItem.FCode) + '</td>' +
        '<td valign="top">&nbsp;&nbsp;</td>' +
        '<td valign="top">' + IntToStr(LItem.FID) + '</td>' +
        '<td valign="top">&nbsp;&nbsp;</td>' +
        '<td valign="top">' + CellString(LItem.FDescription) + '</td>' +
        '</tr>' + crlf
      end
    else
      begin
      Result := Result +
        ' <tr class=dicttblbg>' +
        '<td valign="top">' + CellString(LItem.FCode) + '</td>' +
        '<td valign="top">&nbsp;&nbsp;</td>' +
        '<td valign="top">' + IntToStr(LItem.FID) + '</td>' +
        '<td valign="top">&nbsp;&nbsp;</td>' +
        '<td valign="top">' + CellString(LItem.FDescription) + '</td>' +
        '</tr>' + crlf;
      end;
    end;
  Result := Result + '</table><p>' + crlf;
end;

function THL7DictTable.View(AURLPrefix: String; AOptions: TStringList): String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictTable.View';
var
  i: Integer;
  LItem: THL7TableItem;
begin
  Result :=
    '<b>Table ' + PadString(IntToStr(FID), 4, '0', True) + ' ' + FDesc + '</b><p>' + crlf +
    ' <blockquote>' + crlf +
    '  <table cellspacing=0 cellpadding=0 border=0 class="tbl">' + crlf;
  for i := 0 to FValuesByID.Count - 1 do
    begin
    LItem := FValuesByID.objects[i] as THL7TableItem;
    if odd(i) then
      begin
      Result := Result +
        '  <tr>' +
        '<td valign="top">' + CellString(LItem.FCode) + '</td>' +
        '<td valign="top">&nbsp;&nbsp;</td>' +
        '<td valign="top">' + IntToStr(LItem.FID) + '</td>' +
        '<td valign="top">&nbsp;&nbsp;</td>' +
        '<td valign="top">' + CellString(LItem.FDescription) + '</td>' +
        '</tr>' + crlf
      end
    else
      begin
      Result := Result +
        '  <tr class=dicttblbg>' +
        '<td valign="top">' + CellString(LItem.FCode) + '</td>' +
        '<td valign="top">&nbsp;&nbsp;</td>' +
        '<td valign="top">' + IntToStr(LItem.FID) + '</td>' +
        '<td valign="top">&nbsp;&nbsp;</td>' +
        '<td valign="top">' + CellString(LItem.FDescription) + '</td>' +
        '</tr>' + crlf;
      end;
    end;
  Result := Result +
    '  </table>' +
    ' </blockquote><p>' + crlf;
end;

{ THL7DictDataElement }

constructor THL7DictDataElement.Create;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictDataElement.Create';
begin
  inherited Create(ADict);
  FDescription := '';
  FStructure := '';
  FLength := 0;
  FTable := 0;
  FTableObj := NIL;
end;

destructor THL7DictDataElement.Destroy;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictDataElement.Destroy';
begin
  inherited;
end;

function THL7DictDataElement.GetStructureObj: THL7DictStructure;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictDataElement.GetStructureObj';
var
  i: Integer;
begin
  if not Assigned(FStructureObj) then
    begin
    if FDictionary.FStructures.find(FStructure, i) then
      begin
      FStructureObj := FDictionary.FStructures.objects[i] as THL7DictStructure
      end
    else
      begin
      raise EBaseHL7Exception.Create(hecDictionaryError, 'attempt to load undefined structure ' + FStructure);
      end;
    end;
  Result := FStructureObj;
end;

function THL7DictDataElement.View(AURLPrefix: String; AOptions: TStringList): String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictDataElement.View';
var
  LStruc: THL7DictStructure;
  i: Integer;
begin
  if FDictionary.FStructures.Find(FStructure, i) then
    begin
    LStruc := FDictionary.FStructures.objects[i] as THL7DictStructure
    end
  else
    begin
    raise EBaseHL7Exception.Create(hecDictionaryError, 'unknown structure type ' + FStructure);
    end;
  AOptions.values['quick'] := 'yes';
  if FTable = 0 then
    begin
    Result := '<td valign="top">' + CellString(FDescription) + '</td>' +
      '<td>&nbsp;&nbsp;</td>' +
      LStruc.View(AURLPrefix, AOptions) +
      '<td>&nbsp;&nbsp;</td>' +
      '<td valign="top">' + IntToStr(FLength) + '</td>' +
      '<td valign="top">&nbsp;</td>' +
      '<td>&nbsp;&nbsp;</td>' + crlf
    end
  else
    begin
    Result := '<td valign="top">' + CellString(FDescription) + '</td>' +
      '<td>&nbsp;&nbsp;</td>' +
      LStruc.View(AURLPrefix, AOptions) +
      '<td>&nbsp;&nbsp;</td>' +
      '<td valign="top">' + IntToStr(FLength) + '</td>';

    if FTableObj.FValuesByID.Count > 0 then
      begin
      Result := Result +
        '<td>&nbsp;&nbsp;</td>' +
        '<td valign="top"><a href="' + AURLPrefix + 'view=table&tableid=' + IntToStr(FTable) + '">' + FTableObj.FDesc + '</a></td>' + crlf
      end
    else
      begin
      Result := Result +
        '<td valign="top" colspan=2>&nbsp;</td>' + crlf
      end
    end;
end;

{ THL7DictSegmentField }

constructor THL7DictSegmentField.Create;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegmentField.Create';
begin
  inherited Create(ADict);
  FIndex := 0;
  FDataElement := 0;
  FRequired := False;
  FRepeatable := False;
  FRepeats := 0;
end;

destructor THL7DictSegmentField.Destroy;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegmentField.Destroy';
begin
  inherited;
end;

function THL7DictSegmentField.GetDataElementObj: THL7DictDataElement;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegmentField.GetDataElementObj';
begin
  Result := FDictionary.FDataElements[FDataElement] as THL7DictDataElement;
end;

function THL7DictSegmentField.GetRepeatable: Boolean;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegmentField.GetRepeatable';
begin
  if DataElementObj.StructureObj.FDataTypeCode = '*' then
    begin
    Result := True
    end
  else
    begin
    Result := FRepeatable;
    end;
end;

function THL7DictSegmentField.View(AURLPrefix: String; AOptions: TStringList): String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegmentField.View';
var
  LReq: String;
  LRep: String;
  LElement: THL7DictDataElement;
begin
  if FRequired then
    begin
    LReq := 'true'
    end
  else
    begin
    LReq := '';
    end;
  if not FRepeatable then
    begin
    LRep := ''
    end
  else if FRepeats = 0 then
    begin
    LRep := 'Y'
    end
  else
    begin
    LRep := 'Y(' + IntToStr(FRepeats) + ')';
    end;
  LElement := DataElementObj;
  Result := '<td valign="top">' + IntToStr(FIndex) + '</td>' +
    '<td>&nbsp;&nbsp;</td>' +
    LElement.View(AURLPrefix, AOptions) +
    '<td valign="top">&nbsp;&nbsp;</td>' +
    '<td valign="top">' + CellString(LReq) + '</td>' +
    '<td valign="top">&nbsp;&nbsp;</td>' +
    '<td valign="top">' + CellString(LRep) + '</td>';
end;

{ THL7DictSegment }

constructor THL7DictSegment.Create;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegment.Create';
begin
  inherited Create(ADict);
  FName := '';
  FDesc := '';
  FFields := THL7StringList.Create(True);
end;

destructor THL7DictSegment.Destroy;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegment.Destroy';
begin
  FreeAndNil(FFields);
  inherited;
end;

procedure THL7DictSegment.LoadFields(Adb: THL7DictionaryDatabase; AVersion: String);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegment.LoadFields';
var
  LField: THL7DictSegmentField;
  i: Integer;
  LDI: Integer;
  LRepCount: Integer;
  LNum: Integer;
  p: pointer;
  LReq: String;
  LRep: String;
  LCode: String;
begin
  p := Adb.StartLoadFields(FName, AVersion);
  try
    i := 0;
    while Adb.GetNextField(p, LCode, LDI, LReq, LRep, LRepCount, LNum) do
      begin
      LField := THL7DictSegmentField.Create(FDictionary);
      inc(i);
      LField.FIndex := i;
      LField.FDataElement := LDI;
      LField.FRequired := LReq = 'R';
      if (LRep = 'Y') or (LRepCount > 0) then
        begin
        LField.FRepeatable := True;
        LField.FRepeats := LRepCount;
        end
      else
        begin
        LField.FRepeatable := False;
        end;
      FFields.AddObject(StripChar(LField.DataElementObj.FDescription, ' '), LField);
      end;
  finally
    Adb.CloseLoadFields(p);
    end;
end;

function THL7DictSegment.View(AURLPrefix: String; AOptions: TStringList): String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegment.View';
var
  i: Integer;
  j: Integer;
  LEvent: THL7DictEvent;
  LStruct: THL7DictMessageStruct;
begin
  Result := '<h3>' + FName + ' ' + FDesc + '</h3>' + crlf +
    '<table border=0 cellspacing=0 cellpadding=1 class="tbl">' + crlf +
    '<tr>' +
    '<td valign="top" colspan=2>&nbsp;&nbsp;</td>' +
    '<td valign="top">Desc</td>' +
    '<td valign="top">&nbsp;&nbsp;</td>' +
    '<td valign="top">Data Type</td>' +
    '<td valign="top">&nbsp;&nbsp;</td>' +
    '<td valign="top">Size</td>' +
    '<td valign="top">&nbsp;&nbsp;</td>' +
    '<td valign="top">Table</td>' +
    '<td valign="top">&nbsp;&nbsp;</td>' +
    '<td valign="top">Required</td>' +
    '<td valign="top">&nbsp;&nbsp;</td>' +
    '<td valign="top">Repetition</td>' +
    '</tr>' + crlf;
  for i := 0 to FFields.Count - 1 do
    begin
    if odd(i) then
      begin
      Result := Result + '<tr>' + (FFields.objects[i] as THL7DictSegmentField).View(AURLPrefix, AOptions) + '</tr>' + crlf
      end
    else
      begin
      Result := Result + '<tr class=dicttblbg>' + (FFields.objects[i] as THL7DictSegmentField).View(AURLPrefix, AOptions) + '</tr>' + crlf;
      end;
    end;

  Result := Result + '</table>' + crlf;
  Result := Result +
    '<p><hr>' + crlf;
  Result := Result +
    '<b>Events using this segment</b><p>' + crlf +
    '<ul>' + crlf;
  for i := 0 to FDictionary.FEvents.Count - 1 do
    begin
    LEvent := FDictionary.FEvents.Objects[i] as THL7DictEvent;
    for j := 0 to LEvent.FMessageTypes.Count - 1 do
      begin
      LStruct := LEvent.FMessageTypes.objects[j] as THL7DictMessageStruct;
      if LStruct.UsesSegment(FName) then
        begin
        Result := Result + ' <li>' + LStruct.DescribeWithLink(AURLPrefix, AOptions, LEvent);
        end;
      end;
    end;
  Result := Result +
    '</ul>' + crlf;
end;

{ THL7Dictionary }

constructor THL7Dictionary.Create(AVersion: String; AOwner: THL7DictionaryList);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.Create';
begin
  inherited Create;
  FLock := THL7CriticalSection.Create;
  FVersion := AVersion;
  fowner := AOwner;
  FMaxTableID := 0;
  FMaxDataID := 0;
  FMaxCompID := 0;
  FTables := TKeyList.Create(32);
  FTables.OnDispose := DropItem;
  FDataElements := TKeyList.Create(100);
  FDataElements.OnDispose := DropItem;
  FComponents := TKeyList.Create(40);
  FComponents.OnDispose := Dropitem;
  FSegments := THL7StringList.Create(True);
  FSegments.Sorted := True;
  FStructures := THL7StringList.Create(True);
  FStructures.Sorted := True;
  FDataTypes := THL7StringList.Create(True);
  FDataTypes.Sorted := True;
  FEvents := THL7StringList.Create(True);
  FEvents.sorted := True;
  FMsgStructs := THL7StringList.Create(True);
  FMsgStructs.Sorted := True;
  NonValidSegmentList := TStringList.Create;
  NonValidSegmentList.sorted := True;
  NonValidSegmentList.Duplicates := dupIgnore;
  CheckVersionDefined;
  LoadDataTypes;
  LoadComponents;
  LoadStructures;
  LinkComponents;
  LoadTables;
  LoadDataElements;
  LoadMsgStructs;
  LoadEvents;
end;

destructor THL7Dictionary.Destroy;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.Destroy';
begin
  FreeAndNil(FMsgStructs);
  FreeAndNil(FStructures);
  FreeAndNil(FEvents);
  FreeAndNil(FTables);
  FreeAndNil(FDataElements);
  FreeAndNil(FSegments);
  FreeAndNil(FComponents);
  FreeAndNil(FDataTypes);
  FreeAndNil(NonValidSegmentList);
  FreeAndNil(FLock);
  inherited;
end;

procedure THL7Dictionary.CheckVersionDefined;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.CheckVersionDefined';
var
  LDesc: String;
begin
  if not FOwner.FDatabase.VersionDefined(FVersion, LDesc) then
    begin
    raise EBaseHL7Exception.Create(hecUnsVersion, 'HL7 version ' + FVersion + ' is not defined in the HL7 dictionary');
    end;
end;

procedure THL7Dictionary.DropItem(APtr: pointer);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.DropItem';
begin
  FreeAndNil(TObject(APtr));
end;

function THL7Dictionary.GetSegment(ACode: String): THL7DictSegment;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.GetSegment';
var
  i: Integer;
begin
  Result := NIL;
  FLock.Enter;
  try
    if FSegments.Find(ACode, i) then
      begin
      Result := FSegments.Objects[i] as THL7DictSegment
      end
    else if NonValidSegmentList.Find(ACode, i) then
      begin
      raise EHL7TrivialException.Create(hecBadSegCode, 'HL7 segment ''' + ACode + ''' not found in dictionary (' + FVersion + ')')
      end
    else
      begin
      Result := LoadSegment(ACode);
      FSegments.AddObject(ACode, Result);
      end;
  finally
    FLock.Leave;
    end;
end;

procedure THL7Dictionary.LoadComponents;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.LoadComponents';
var
  LDictComp: THL7DictComponent;
  LPtr: pointer;
  i: Integer;
  LTableId: Integer;
  LCompID: Integer;
  LDesc: String;
  LCode: String;
begin
  LPtr := FOwner.FDatabase.StartLoadComponents(FVersion);
  try
    while FOwner.FDatabase.GetNextComponent(LPtr, LDesc, LTableId, LCode, LCompID) do
      begin
      LDictComp := THL7DictComponent.Create(Self);
      LDictComp.FDescription := LDesc;
      LDictComp.FTableID := LTableId;
      if LDictComp.FTableID <> 0 then
        begin
        LDictComp.FTableObj := FTables[LDictComp.FTableID] as THL7DictTable;
        end;
      LDictComp.FDataTypeCode := LCode;
      if FDataTypes.Find(LDictComp.FdataTypeCode, i) then
        begin
        LDictComp.FDataType := FDataTypes.objects[i] as THL7DictDataType;
        end;
      FComponents[LCompID] := LDictComp;
      if LCompID > FMaxCompID then
        begin
        FMaxCompID := LCompID;
        end;
      end;
  finally
    FOwner.FDatabase.CloseLoadComponents(LPtr);
    end;
end;

procedure THL7Dictionary.LinkComponents;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.LinkComponents';
var
  LRec: TKeyProgressRec;
  LKey: Integer;
  i: Integer;
  s: String;
begin
  if FComponents.GetFirstKey(LRec, LKey) then
    begin
    repeat
      s := (FComponents.AsObj[LKey] as THL7DictComponent).FDataTypeCode;
      if FStructures.Find(s, i) then
        begin
        (FComponents.AsObj[LKey] as THL7DictComponent).FStruct := FStructures.objects[i] as THL7DictStructure;
        end;
    until not FComponents.GetNextKey(LRec, LKey);
    end
end;

procedure THL7Dictionary.LoadDataElements;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.LoadDataElements';
var
  LDictDataElement: THL7DictDataElement;
  LPtr: pointer;
  LDesc: String;
  LStruc: String;
  LLen: Integer;
  LTableId: Integer;
  LDataId: Integer;
begin
  LPtr := FOwner.FDatabase.StartLoadDataElements(FVersion);
  try
    while FOwner.FDatabase.GetNextElement(LPtr, LDesc, LStruc, LLen, LTableId, LDataId) do
      begin
      LDictDataElement := THL7DictDataElement.Create(self);
      LDictDataElement.FDescription := LDesc;
      LDictDataElement.FStructure := LStruc;
      LDictDataElement.FLength := LLen;
      LDictDataElement.FTable := LTableId;
      if LDictDataElement.FTable <> 0 then
        begin
        LDictDataElement.FTableObj := FTables[LDictDataElement.FTable] as THL7DictTable;
        end;
      FDataElements[LDataId] := LDictDataElement;
      if LDataId > FMaxDataID then
        begin
        FMaxDataID := LDataId;
        end;
      end;
  finally
    FOwner.FDatabase.CloseLoadDataElements(LPtr);
    end;
end;

procedure THL7Dictionary.LoadDataTypes;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.LoadDataTypes';
var
  LDictDataType: THL7DictDataType;
  LPtr: pointer;
  LName: String;
  LDesc: String;
  LLen: Integer;
begin
  LPtr := FOwner.FDatabase.StartLoadDataTypes(FVersion);
  try
    while FOwner.Fdatabase.GetNextDataType(LPtr, LName, LDesc, LLen) do
      begin
      LDictDataType := THL7DictDataType.Create(Self);
      LDictDataType.FName := LName;
      LDictDataType.FDesc := LDesc;
      LDictDataType.FLength := LLen;
      FDataTypes.AddObject(LDictDataType.FName, LDictDataType);
      end;
  finally
    FOwner.FDatabase.CloseLoadDataTypes(LPtr);
    end;
end;

function THL7Dictionary.LoadSegment(ACode: String): THL7DictSegment;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.LoadSegment';
var
  LPtr: pointer;
  LDesc: String;
begin
  assert(FLock.LockedToMe, '');
  Result := THL7DictSegment.Create(Self);
  LPtr := FOwner.FDatabase.StartLoadSegment(ACode, FVersion);
  try
    if not FOwner.FDatabase.GetNextSegment(LPtr, ACode, LDesc) then
      begin
      NonValidSegmentList.add(ACode);
      FreeAndNil(Result);
      raise EHL7TrivialException.Create(hecBadSegCode, 'HL7 segment ''' + ACode + ''' not found in dictionary (' + FVersion + ')')
      end
    else
      begin
      if copy(LDesc, 4, 3) = ' - ' then
        begin
        Result.FDesc := copy(LDesc, 7, length(LDesc));
        end
      else
        begin
        Result.FDesc := LDesc;
        end;
      end;
    Result.FName := ACode;
  finally
    FOwner.FDatabase.CloseLoadSegments(LPtr);
    end;
  Result.LoadFields(FOwner.FDatabase, FVersion);
end;

procedure THL7Dictionary.LoadEventList(AEventList: TStringList);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.LoadEventList';
var
  LPtr: pointer;
  LCode: String;
  LDesc: String;
begin
  LPtr := FOwner.FDatabase.StartLoadEventList(FVersion);
  try
    while FOwner.FDatabase.GetNextEvent(LPtr, LCode, LDesc) do
      begin
      AEventList.Values[LCode] := LDesc;
      end;
  finally
    FOwner.FDatabase.CloseLoadEventList(LPtr);
    end;
end;

procedure THL7Dictionary.LoadEventClassList(AClassList: TStringList);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.LoadEventClassList';
var
  c: Char;
  i: Integer;
begin
  LoadEvents;
  for i := 0 to FEvents.Count - 1 do
    begin
    c := (FEvents.objects[i] as THL7DictEvent).Name[1];
    if AClassList.indexof(c) = -1 then
      begin
      AClassList.Add(c);
      end;
    end;
end;


procedure THL7Dictionary.LoadEvents;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.LoadEvents';
var
  LDictEvent: THL7DictEvent;
  LDictMsgStruct: THL7DictMessageStruct;
  LPtr: pointer;
  LName: String;
  LDesc: String;
  LSendMsg: String;
  LSendStruct: String;
  LRetMsg: String;
  LRetStruct: String;
  LFieldNum: Integer;
begin
  LPtr := FOwner.FDatabase.StartLoadEventList(FVersion);
  try
    while FOwner.FDatabase.GetNextEvent(LPtr, LName, LDesc) do
      begin
      LDictEvent := THL7DictEvent.Create(Self);
      LDictEvent.FName := LName;
      LDictEvent.FDesc := LDesc;
      FEvents.AddObject(LDictEvent.FName, LDictEvent);
      end;
  finally
    FOwner.FDatabase.CloseLoadEventList(LPtr);
    end;
  LPtr := FOwner.FDatabase.StartLoadEventDetails(FVersion);
  try
    while FOwner.Fdatabase.GetNextEventDetails(LPtr, LName, LSendMsg, LSendStruct, LRetMsg, LRetStruct, LFieldNum) do
      begin
      LDictEvent := GetEvent(LName);
      LDictMsgStruct := GetStructure(LSendStruct);
      if LDictEvent.FMessageTypes.IndexOf(LSendStruct) = -1 then
        begin
        LDictEvent.FMessageTypes.AddObject(LSendStruct, LDictMsgStruct);
        end;
      LDictMsgStruct := GetStructure(LRetStruct);
      if LDictEvent.FMessageTypes.IndexOf(LRetMsg) = -1 then
        begin
        LDictEvent.FMessageTypes.AddObject(LRetMsg, LDictMsgStruct);
        end;
      end;
  finally
    FOwner.FDatabase.CloseLoadEventDetails(LPtr);
    end;
end;

procedure THL7Dictionary.LoadMsgStructs;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.LoadMsgStructs';
var
  LStruc: THL7DictMessageStruct;
  LPtr: pointer;
  LFieldNum: Integer;
  LStructName: String;
  LSegCode: String;
  LGroupName: String;
  LLastStruct: String;
  LName: String;
  LDesc: String;
  LExampleEvent: String;
  LExampleMsgType: String;
  LAction: String;
  LRepeats: Boolean;
  LOptional: Boolean;
begin
  LPtr := FOwner.FDatabase.StartLoadMsgStructs(FVersion);
  try
    while FOwner.Fdatabase.GetNextMsgStructs(LPtr, LName, LDesc, LExampleEvent, LExampleMsgType, LAction) do
      begin
      LStruc := THL7DictMessageStruct.Create(self);
      LStruc.FName := LName;
      LStruc.FDesc := LDesc;
      LStruc.FExampleEvent := LExampleEvent;
      LStruc.FExampleMsgType := LExampleMsgType;
      LStruc.FAction := LAction;
      FMsgStructs.AddObject(LStruc.FName, LStruc);
      end;
  finally
    FOwner.FDatabase.CloseLoadMsgStructs(LPtr);
    end;
  // now that the structures are loaded, we will load the
  // segment maps. Due to the way the segment map database
  // is read, segment maps will be read structure by structure,
  // in segment order.
  LStruc := NIL;
  LLastStruct := '';
  LPtr := FOwner.FDatabase.StartLoadMsgStructSegments(FVersion);
  try
    while FOwner.Fdatabase.GetNextMsgStructSegments(LPtr, LStructName, LFieldNum, LSegCode, LGroupName, LRepeats, LOptional) do
      begin
      if LLastStruct <> LStructName then
        begin
        if assigned(LStruc) then
          begin
          LStruc.FinishLoading;
          end;
        if FMsgStructs.IndexOf(LStructName) > -1 then
          begin
          LStruc := FMsgStructs.Objects[FMsgStructs.IndexOf(LStructName)] as THL7DictMessageStruct;
          LStruc.StartLoading;
          end
        else
          begin
          LStruc := NIL;
          end;
        LLastStruct := LStructName;
        end;
      if assigned(LStruc) then
        begin
        LStruc.Load(LFieldNum, LSegCode, LGroupName, LRepeats, LOptional);
        end;
      end;
  finally
    FOwner.FDatabase.CloseLoadMsgStructSegments(LPtr);
    end;
  LStruc := NIL;
  LLastStruct := '';
  LPtr := FOwner.FDatabase.StartLoadEvntMsgSegments(FVersion);
  try
    while FOwner.Fdatabase.GetNextEvntMsgSegments(LPtr, LStructName, LFieldNum, LSegCode, LGroupName, LRepeats, LOptional) do
      begin
      if LLastStruct <> LStructName then
        begin
        if assigned(LStruc) then
          begin
          LStruc.FinishLoading;
          end;
        if FMsgStructs.IndexOf(LStructName) > -1 then
          begin
          LStruc := FMsgStructs.Objects[FMsgStructs.IndexOf(LStructName)] as THL7DictMessageStruct;
          LStruc.StartLoading;
          end
        else
          begin
          LStruc := NIL;
          end;
        LLastStruct := LStructName;
        end;
      if assigned(LStruc) then
        begin
        LStruc.Load(LFieldNum, LSegCode, LGroupName, LRepeats, LOptional);
        end;
      end;
  finally
    FOwner.FDatabase.CloseLoadEvntMsgSegments(LPtr);
    end;
end;


procedure THL7Dictionary.LoadStructures;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.LoadStructures';
var
  LDictStruc: THL7DictStructure;
  LDictComp: THL7DictComponent;
  LPtr: pointer;
  LLast: String;
  LStruc: String;
  LDesc: String;
  LCode: String;
  i: Integer;
  LElem: Integer;
  LFNum: Integer;
  LCNum: Integer;
begin
  LPtr := FOwner.FDatabase.StartLoadStructures(FVersion);
  try
    while FOwner.FDatabase.GetNextStructure(LPtr, LStruc, LDesc, LCode, LElem) do
      begin
      LDictStruc := THL7DictStructure.Create(self);
      LDictStruc.Fname := LStruc;
      LDictStruc.FDesc := LDesc;
      LDictStruc.FDataTypeCode := LCode;
      if FDataTypes.find(LDictStruc.FdataTypeCode, i) then
        begin
        LDictStruc.FDataType := FDataTypes.objects[i] as THL7DictDataType
        end
      else
        begin
        LDictStruc.FDataType := NIL;
        end;
      FStructures.AddObject(StripChar(LDictStruc.Fname, ' '), LDictStruc);
      end;
  finally
    FOwner.FDatabase.CloseLoadStructures(LPtr);
    end;
  LPtr := FOwner.FDatabase.StartLoadStructureComps(FVersion);
  try
    LLast := '';
    LDictStruc := NIL;
    while FOwner.FDatabase.GetNextStructureComp(LPtr, LStruc, LFNum, LCNum) do
      begin
      if LStruc <> LLast then
        begin
        LLast := LStruc;
        FStructures.find(LLast, i);
        LDictStruc := FStructures.objects[i] as THL7DictStructure;
        end;
      LDictComp := FComponents[LCNum] as THL7DictComponent;
      LDictStruc.FComponents.AddObject(StripChar(LDictComp.FDescription, ' '), LDictComp);
      end;
  finally
    FOwner.FDatabase.CloseLoadStructureComps(LPtr);
    end;
end;

procedure THL7Dictionary.LoadTables;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.LoadTables';
var
  LDictTable: THL7DictTable;
  LTableItem: THL7TableItem;
  LPtr: pointer;
  LDesc: String;
  LValue: String;
  LTableId: Integer;
  LSNum: Integer;
  i: Integer;
begin
  LPtr := FOwner.FDatabase.StartLoadTables(FVersion);
  try
    while FOwner.FDatabase.GetNextTable(LPtr, LDesc, LTableId) do
      begin
      LDictTable := THL7DictTable.Create(Self);
      LDictTable.FID := LTableId;
      LDictTable.FDesc := LDesc;
      FTables[LTableId] := LDictTable;
      if LTableId > FMaxTableID then
        begin
        FMaxTableID := LTableId;
        end;
      end;
  finally
    FOwner.FDatabase.CloseLoadTables(LPtr);
    end;
  LPtr := FOwner.FDatabase.StartLoadTableItems(FVersion);
  try
    while FOwner.FDatabase.GetNextTableItem(LPtr, LTableId, LSNum, LValue, LDesc) do
      begin
      LDictTable := FTables[LTableId] as THL7DictTable;
      if not LDictTable.FValuesByID.find(PadString(IntToStr(LSNum), 4, '0', True), i) then
      // table 191 in the access dictionary contains duplicate
      // values for sNum for v2.3.1. ?origin. but we won't store them,
      // since they don't appear(?) to be correct
        begin
        LTableItem := THL7TableItem.Create;
        LTableItem.FID := LSNum;
        LTableItem.FCode := LValue;
        LTableItem.FDescription := LDesc;
        LDictTable.FValuesByID.AddObject(PadString(IntToStr(LSNum), 4, '0', True), LTableItem);
        LDictTable.FValuesByCode.AddObject(LTableItem.FCode, LTableItem);
        end;
      end;
  finally
    FOwner.FDatabase.CloseLoadTableItems(LPtr);
    end;
end;

function THL7Dictionary.ViewTable(AURLPrefix: String; AOptions: TStringList; var VTitle: String): String;
const
  ASSERT_LOCATION = ASSERT_UNIT + '.THL7Dictionary.ViewTable';
var
  LStr: String;
  i, j : integer;
begin
  LStr := AOptions.values['tableid'];
  VTitle := 'Table ' + LStr + ' (v' + FVersion + ')';
  try
    if LStr <> '' then
      begin
      Result := (Ftables[StrToInt(LStr)] as THL7DictTable).View(AURLPrefix, AOptions)
      end
    else
      begin
      Result := ' <span style="font-weight:bold;">Tables Defined in HL7</span><p>' + CRLF +
        '<table border=0 cellpadding=0 cellspacing=0 class="tbl">' + CRLF;
      j := 0;
      for i := 1 to FMaxTableID do
        begin
        if FTables.Exists[i] then
          begin
          if (Ftables[i] as THL7DictTable).FDesc <> '' then
            begin
            if Odd(j) then
              begin
              Result := Result +
                '<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;</td><td>' + PadString(IntToStr(i), 4, '0', True) +
                '&nbsp;&nbsp;</td><td><a href="' + AURLPrefix + 'view=table&tableid=' + IntToStr(i) + '">' +
                (Ftables[i] as THL7DictTable).FDesc + '</td></tr>' + CRLF
              end
            else
              begin
              Result := Result +
                '<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;</td><td>' + PadString(IntToStr(i), 4, '0', True) +
                '&nbsp;&nbsp;</td><td class="dicttblbg"><a href="' + AURLPrefix + 'view=table&tableid=' + IntToStr(i) + '">' +
                (Ftables[i] as THL7DictTable).FDesc + '</td></tr>' + CRLF;
              end;
            inc(j);
            end;
          end;
        end;
      Result := Result + '</table></p>' + CRLF;
      end;
  except
    Result := Result + '<p>Table <span style="font-weight:bold;">' + LStr + '</span>, not supported in version V' + FVersion + '</p><br />' + CRLF;
    end;
end;

function THL7Dictionary.ViewElement(AURLPrefix: String; AOptions: TStringList; var VTitle: String): String;
const
  ASSERT_LOCATION = ASSERT_UNIT + '.THL7Dictionary.ViewElement';
var
  i : integer;
  LSortList : TStringList;
begin
  LSortList := TStringList.Create;
  try
    for i := 1 to FMaxDataID do
      begin
      if FDataElements.Exists[i] then
        begin
        LSortList.Add((FDataElements[i] as THL7DictDataElement).View(AURLPrefix, AOptions));
        end;
      end;
    VTitle := 'Elements (v' + FVersion + ')';

    // Grahame to look at
    // the sort list needs to sort on a value other than the key, otherwise the sorted list
    // will display sorted values like 1, 10, 100, 102, 11, 12 etc
    // table country codes is a good example or  source of specimen

    LSortList.Sort;
    Result :=
      ' <b>Data Elements Defined in HL7</b><p>' + CRLF +
      ' <table border=0 cellspacing=0 cellpadding=1 class="tbl">' + CRLF +
      ' <tr>' +
      '<td class="tblhead">Name</td>' +
      '<td>&nbsp;&nbsp;</td>' +
      '<td class="tblhead">Structure</td>' +
      '<td>&nbsp;&nbsp;</td>' +
      '<td class="tblhead">Length</td>' +
      '<td>&nbsp;&nbsp;</td>' +
      '<td class="tblhead">Table</td>' +
      '</tr>' + CRLF;

    for i := 0 to LSortList.Count - 1 do
      begin
      if Odd(i) then
        begin
        Result := Result + ' <tr>' + LSortList[i] + '</tr>' + CRLF
        end
      else
        begin
        Result := Result + ' <tr class=dicttblbg>' + LSortList[i] + '</tr>' + CRLF;
        end;
      end;

    Result := Result +
      ' </table>' + CRLF;
  finally
    FreeAndNil(LSortList);
    end;
end;

function THL7Dictionary.ViewSegment(AURLPrefix: String; AOptions: TStringList; var VTitle: String): String;
const
  ASSERT_LOCATION = ASSERT_UNIT + '.THL7Dictionary.ViewSegment';
var
  LStr : String;
  i : integer;
  LSegment : THL7DictSegment;
  LPtr : pointer;
  LSegCode : String;
  LDesc : String;
begin
  LStr := Uppercase(AOptions.values['segmentid']);
  if LStr <> '' then
    begin
    VTitle := 'Segment ' + LStr + ' (v' + FVersion + ')';
    LSegment := GetSegment(LStr);
    if LSegment = NIL then
      begin
      Result := 'Segment ' + LStr + ' was not recognised'
      end
    else
      begin
      Result := LSegment.View(AURLPrefix, AOptions)
      end;
    end
  else
    begin
    VTitle := 'Segments (v' + FVersion + ')';
    Result :=
      ' <b>Segments Currently Loaded</b><p>' + CRLF;
    for i := 0 to FSegments.Count - 1 do
      begin
      Result := Result +
        '  <a href="' + AURLPrefix + 'view=segment&segmentid=' + FSegments[i] + '">' + FSegments[i] + '</a><br>' + CRLF;
      end;
    Result := Result +
      '<p>' + CRLF +
      ' <b>Unloaded Segments</b><p>' + CRLF +
      'Segments are only loaded when encountered. If you wish to load a segment not listed, enter it here:<br>' + CRLF +
      '<form method="get" action="' + AURLPrefix + '">' + CRLF +
      ' <input type="hidden" name="version" value="' + AOptions.values['version'] + '">' + CRLF +
      ' <input type="hidden" name="view" value="segment">' + CRLF +
      ' <input type="text" name="segmentid" value="" size="6" maxlength="3">' +
      ' <input type="submit" value="View">' + CRLF +
      '</form>' + CRLF +
      '<p>' + CRLF +
      'Or choose from this list:' + CRLF +
      '<ul>' + CRLF;
    LPtr := FOwner.FDatabase.StartLoadSegment('', FVersion);
    try
      while FOwner.FDatabase.GetNextSegment(LPtr, LSegCode, LDesc) do
        begin
        if FSegments.indexof(LSegCode) = -1 then
          begin
          Result := Result +
            ' <li> <a href="' + AURLPrefix + 'view=segment&segmentid=' + LSegCode + '">' + LSegCode + '</a> ' + LDesc + CRLF;
          end;
        end;
    finally
      FOwner.FDatabase.CloseLoadSegments(LPtr);
      end;
    Result := Result + '</ul>' + CRLF;
    end;
end;

function THL7Dictionary.ViewStructure(AURLPrefix: String; AOptions: TStringList; var VTitle: String): String;
const
  ASSERT_LOCATION = ASSERT_UNIT + '.THL7Dictionary.ViewStructure';
var
  LStr: String;
  i : integer;
begin
  LStr := AOptions.values['structureid'];
  VTitle := 'Structure ' + LStr + ' (v' + FVersion + ')';
  if LStr <> '' then
    begin
    if FStructures.find(LStr, i) then
      begin
      Result := (FStructures.objects[i] as Thl7DictStructure).View(AURLPrefix, AOptions)
      end
    else
      begin
      Result := 'Structure ' + LStr + ' was not recognised';
      end;
    end
  else
    begin
    AOptions.values['quick'] := 'yes';
    AOptions.values['quickstruct'] := 'yes';
    Result :=
      ' <b>Structures</b><p>' + CRLF +
      ' <table border=0 cellspacing=0 cellpadding=1 class="tbl">' + CRLF +
      '  <tr>' +
      '<td class="tblhead">Name&nbsp;&nbsp;&nbsp;</td>' +
      '<td class="tblhead">Description&nbsp;&nbsp;&nbsp;</td>' +
      '<td class="tblhead">Type</td>' +
      '</tr>' + CRLF;

    for i := 0 to FStructures.Count - 1 do
      begin
      if Odd(i) then
        begin
        Result := Result + '  <tr>' + (FStructures.objects[i] as Thl7DictStructure).View(AURLPrefix, AOptions) + '</tr>' + CRLF
        end
      else
        begin
        Result := Result + '  <tr class=dicttblbg>' + (FStructures.objects[i] as Thl7DictStructure).View(AURLPrefix, AOptions) + '</tr>' + CRLF;
        end;
      end;
    Result := Result +
      ' </table>' + CRLF;
    AOptions.values['quickstruct'] := 'no';
    end;
end;

function THL7Dictionary.ViewEvents(AURLPrefix: String; AOptions: TStringList; var VTitle: String): String;
const
  ASSERT_LOCATION = ASSERT_UNIT + '.THL7Dictionary.ViewEvents';
var
  LStr: String;
  i : integer;
begin
  LStr := AOptions.values['eventid'];
  if LStr <> '' then
    begin
    VTitle := 'Event ' + LStr + ' (v' + FVersion + ')';
    if FEvents.find(LStr, i) then
      begin
      Result := (FEvents.objects[i] as THL7DictEvent).View(AURLPrefix, AOptions)
      end
    else
      begin
      Result := 'Event ' + LStr + ' was not recognised';
      end;
    end
  else
    begin
    VTitle := 'Event List (v' + FVersion + ')';
    Result := '<b>Events</b>' + CRLF +
      '<ul>' + CRLF;

    for i := 0 to FEvents.Count - 1 do
      begin
      Result := Result + '<li><a href="' + AURLPrefix + 'view=events&eventid=' + FEvents[i] + '"">' + FEvents[i] + '</a> ' + (FEvents.objects[i] as THL7DictEvent).ListMessageTypes + ' ' + (FEvents.objects[i] as THL7DictEvent).FDesc + CRLF;
      end;
    Result := Result + '</ul>' + CRLF;
    end
end;

function THL7Dictionary.ViewMsgTypes(AURLPrefix: String; AOptions: TStringList; var VTitle: String): String;
const
  ASSERT_LOCATION = ASSERT_UNIT + '.THL7Dictionary.ViewMsgTypes';
var
  LStr: String;
  i, j : integer;
  LEvent : THL7DictEvent;
begin
  LStr := AOptions.values['msgid'];
  if LStr = '' then
    begin
    result := '';
    for i := 0 to FMsgStructs.count - 1 do
      begin
      result := result + '<a href="'+AURLPrefix+'view=msgtypes&msgid='+FMsgStructs[i]+'">'+FMsgStructs[i]+'</a><br>'+crlf;
      end;
    end
  else
    begin
    i := FMsgStructs.Indexof(LStr);
    if i = -1 then
      begin
      result := 'Unknown Message structure "'+LStr+'"';
      end
    else
      begin
      result := (FMsgStructs.Objects[i] as THL7DictMessageStruct).View(AURLPrefix, AOptions);
      result := result +'<hr>';
      Result := Result +
       '<b>Events using this srtucture</b><p>' + crlf +
       '<ul>' + crlf;
      for i := 0 to FEvents.Count - 1 do
        begin
        LEvent := FEvents.Objects[i] as THL7DictEvent;
        if LEvent.FMessageTypes.Indexof(LStr) > -1 then
          begin
          Result := Result + ' <li><a href="'+AURLPrefix+'view=events&eventid='+LEvent.FName+'">' + LEvent.FName+'</a> : '+LEvent.FDesc;
          end;
        end;
      Result := Result +
        '</ul>' + crlf;
      end;
    end;
end;

function THL7Dictionary.View(AURLPrefix: String; AOptions: TStringList; var VTitle: String): String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.View';
var
  i : integer;
  LStr: String;
  LTop : string;
begin
  LStr := AOptions.Values['view'];
  if LStr = '' then
    begin
    VTitle := 'HL7 Version ' + FVersion;
    Result :=
      '<h2>' + VTitle + '</h2>' + CRLF +
      '<a href="' + AURLPrefix + 'view=segment">Segments</a><br>' + CRLF +
      '<blockquote>' + CRLF;
    for i := 0 to FSegments.Count - 1 do
      begin
      Result := Result +
        '  <a href="' + AURLPrefix + 'view=segment&segmentid=' + FSegments[i] + '">' + FSegments[i] + '</a><br>' + CRLF;
      end;
    Result := Result +
      '</blockquote>' + CRLF +
      '<a href="' + AURLPrefix + 'view=element">Elements</a><br>' + CRLF +
      '<a href="' + AURLPrefix + 'view=table">Tables</a><br>' + CRLF +
      '<a href="' + AURLPrefix + 'view=structure">Structures</a><br>' + CRLF +
      '<a href="' + AURLPrefix + 'view=events">Events</a><br>' + CRLF +
      '<a href="' + AURLPrefix + 'view=msgtypes">Message Types</a><br>' + CRLF
    end
  else
    begin
    if LStr = 'table' then
      begin
      result := Viewtable(AUrlPrefix, AOptions, VTitle);
      end
    else if LStr = 'element' then
      begin
      result := ViewElement(AUrlPrefix, AOptions, VTitle);
      end
    else if LStr = 'segment' then
      begin
      result := ViewSegment(AUrlPrefix, AOptions, VTitle);
      end
    else if LStr = 'structure' then
      begin
      result := ViewStructure(AUrlPrefix, AOptions, VTitle);
      end
    else if LStr = 'events' then
      begin
      result := ViewEvents(AUrlPrefix, AOptions, VTitle);
      end
    else if LStr = 'msgtypes' then
      begin
      result := ViewMsgTypes(AUrlPrefix, AOptions, VTitle);
      end
    else
      begin
      raise EHL7LibraryException.Create(hecHL7LibraryError, 'Unknown view mode');
      end;

    LTop := '<a href="' + AURLPrefix + '">Version ' + FVersion + ' Home</a>' + CRLF;
    LStr := '';
    for i := 0 to AOptions.Count - 1 do
      begin
      if not SameText(AOptions.names[i], 'Version') then
        begin
        LStr := LStr + '&' + AOptions.names[i] + '=' + AOptions.values[AOptions.names[i]];
        end;
      end;
    for i := 0 to FOwner.FStoredVersions.Count - 1 do
      begin
      if FOwner.FStoredVersions[i] <> FVersion then
        begin
        LTop := LTop + '&nbsp;&nbsp;&nbsp;&nbsp;<a href="?version=' + FOwner.FStoredVersions[i] + LStr + '">' + FOwner.FStoredVersions[i] + '</a>'
        end
      else
        begin
        LTop := LTop + '&nbsp;&nbsp;&nbsp;&nbsp;' + FOwner.FStoredVersions[i];
        end;
      end;
    LTop := LTop + '<p>';
    Result := LTop + Result;
    end;
end;

function THL7Dictionary.GetEvent(AEventName: String): THL7DictEvent;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.GetEvent';
var
  i: Integer;
begin
  i := FEvents.IndexOf(AEventName);
  if i = -1 then
    begin
    Result := NIL
    end
  else
    begin
    Result := FEvents.Objects[i] as THL7DictEvent;
    end;
end;

function THL7Dictionary.GetStructure(AStructName: String): THL7DictMessageStruct;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.GetStructure';
var
  i: Integer;
begin
  i := FMsgStructs.IndexOf(AStructName);
  if i = -1 then
    begin
    Result := NIL
    end
  else
    begin
    Result := FMsgStructs.Objects[i] as THL7DictMessageStruct;
    end;
end;

function THL7Dictionary.SupportsXMLSchema: Boolean;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Dictionary.SupportsXMLSchema';
begin
  Result := FVersion >= '2.3.1';
end;

{ THL7CommonDataCell }

constructor THL7CommonDataCell.Create(ALevel, AIndex: Integer);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.Create';
begin
  inherited Create;
  FLevel := ALevel;
  FElementIndex := AIndex;
  FDefined := False;
  FIsDate := False;
  FValid := True;
end;

destructor THL7CommonDataCell.Destroy;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.Destroy';
begin
  inherited;
end;

function THL7CommonDataCell.AddTableCode(ACode: String): Boolean;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.AddTableCode';
var
  i: Integer;
  LTable: THL7DictTable;
begin
  if self = NIL then
    raise EHL7ProgrammerException.Create(hecApplicationError, 'Attempt to use an undefined cell');
  LTable := GetTable;
  if not assigned(LTable) then
    begin
    raise EBaseHL7Exception.Create(hecNoTableValue, 'No Table Defined')
    end
  else if isANumber(ACode) then
    begin
    if LTable.FValuesByID.Find(ACode, i) then
      begin
      Result := True;
      RawContent := (LTable.FValuesByID.objects[i] as THL7TableItem).FCode;
      end
    else
      raise EBaseHL7Exception.Create(hecNoTableValue, 'Table Item "' + ACode + '" not found in table ' + LTable.FDesc)
    end
  else
    begin
    if LTable.FValuesByCode.Find(ACode, i) then
      begin
      Result := True;
      RawContent := ACode;
      end
    else
      raise EBaseHL7Exception.Create(hecNoTableValue, 'Table Item "' + ACode + '" not found in table ' + LTable.FDesc)
    end;
end;

function THL7CommonDataCell.AsTableCode(var VCode: String): Boolean;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.AsTableCode';
var
  i: Integer;
  LTable: THL7DictTable;
begin
  if self = NIL then
    begin
    raise EHL7ProgrammerException.Create(hecApplicationError, 'Attempt to use an undefined cell');
    end;
  Result := False;
  LTable := GetTable;
  if Assigned(LTable) then
    begin
    if LTable.FValuesByCode.Find(FRawContent, i) then
      begin
      Result := True;
      VCode := FRawContent;
      end
    else if LTable.FValuesByID.Find(FRawContent, i) then
      begin
      Result := True;
      VCode := (LTable.FValuesByID.objects[i] as THL7TableItem).FCode;
      end;
    end;
end;

function THL7CommonDataCell.TableDefined: Boolean;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.TableDefined';
var
  LTable: THL7DictTable;
begin
  if self = NIL then
    begin
    raise EHL7ProgrammerException.Create(hecApplicationError, 'Attempt to use an undefined cell');
    end;
  LTable := GetTable;
  Result := assigned(LTable);
end;

function THL7CommonDataCell.ValueInTable: Boolean;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.ValueInTable';
var
  i: Integer;
  LTable: THL7DictTable;
begin
  if self = NIL then
    begin
    raise EHL7ProgrammerException.Create(hecApplicationError, 'Attempt to use an undefined cell');
    end;
  LTable := GetTable;
  Result := Assigned(LTable) and LTable.FValuesByCode.Find(FRawContent, i);
end;

function THL7CommonDataCell.GetDefined: Boolean;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.GetDefined';
begin
  if self = NIL then
    begin
    Result := False
    end
  else if GetHasChildren then
    begin
    Result := GetFirstChild.GetDefined
    end
  else
    begin
    Result := FDefined;
    end;
end;

procedure THL7CommonDataCell.SetDefined(const AValue: Boolean);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.SetDefined';
begin
  if self = NIL then
    raise EHL7ProgrammerException.Create(hecApplicationError, 'Attempt to use an undefined cell');
  if GetHasChildren then
    begin
    GetFirstChild.SetDefined(AValue)
    end
  else
    begin
    FDefined := AValue;
    if not FDefined then
      begin
      FRawContent := '';
      end;
    end;
end;

function THL7CommonDataCell.GetAsDateTime: TDateTime;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.GetAsDateTime';
begin
  if self = NIL then
    begin
    Result := 0
    end
  else if GetHasChildren then
    begin
    Result := GetFirstChild.GetAsDateTime
    end
  else
    begin
    if FRawContent = '' then
      begin
      Result := 0
      end
    else
      begin
      Result := DTReadDate('yyyymmddhhnnss', FRawContent, True);
      end;
    end;
end;

function THL7CommonDataCell.AsDateTimeWithReject(Desc: String): TDateTime;
const 
  ASSERT_LOCATION = 'THL7CommonDataCell.GetAsDateTime:THL7CommonDataCell.GetAsDateTime:HL7_Dict.THL7CommonDataCell.AsDateTimeWithReject';
var
  LName: String;
begin
  if self = NIL then
    begin
    raise EHL7RejectException.Create(hecBadField, 'Unable to read non-existent field for ' + LName + ' [' + desc + ']')
    end
  else if GetHasChildren then
    begin
    Result := GetFirstChild.AsDateTimeWithReject(Desc)
    end
  else
    begin
    LName := GetFieldName;
    if FRawContent = '' then
      begin
      raise EHL7RejectException.Create(hecBadField, 'Unable to read empty date for ' + LName + ' [' + desc + ']')
      end
    else
      begin
      try
        Result := DTReadDate('yyyymmddhhnnss', FRawContent, True);
      except
        on e:
        Exception do
          raise EHL7RejectException.Create(hecDataTypeError, 'Exception reading date "' + FRawContent + '" for field "' + LName + ' [' + Desc + ']": ' + e.message)
        end;
      end;
    end;
end;

procedure THL7CommonDataCell.SetAsDateTime(const AValue: TDateTime);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.SetAsDateTime';
begin
  if self = NIL then
    begin
    raise EHL7ProgrammerException.Create(hecApplicationError, 'Attempt to use an undefined cell');
    end;
  if GetHasChildren then
    begin
    GetFirstChild.SetAsDateTime(AValue)
    end
  else
    begin
    FDefined := True;
    FRawContent := FormatDateTime('yyyymmddhhnnss', AValue);
    end;
end;

function THL7CommonDataCell.GetAsFloat: Double;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.GetAsFloat';
begin
  if self = NIL then
    begin
    Result := 0
    end
  else if GetHasChildren then
    begin
    Result := GetFirstChild.GetAsFloat
    end
  else
    begin
    raise EHL7LibraryException.Create(hecHL7LibraryError, 'yet to be done');
    end;
end;

procedure THL7CommonDataCell.SetAsFloat(const AValue: Double);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.SetAsFloat';
begin
  if self = NIL then
    begin
    raise EHL7ProgrammerException.Create(hecApplicationError, 'Attempt to use an undefined cell');
    end;
  if GetHasChildren then
    begin
    GetFirstChild.SetAsFloat(AValue)
    end
  else
    begin
    raise EHL7LibraryException.Create(hecHL7LibraryError, 'yet to be done');
    end;
end;

function THL7CommonDataCell.GetAsInteger: Integer;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.GetAsInteger';
begin
  if self = NIL then
    begin
    raise EHL7ProgrammerException.Create(hecApplicationError, 'Attempt to use an undefined cell')
    end
  else if GetHasChildren then
    begin
    Result := GetFirstChild.GetAsInteger
    end
  else
    begin
    Result := StrToInt(FRawContent);
    end;
end;

procedure THL7CommonDataCell.SetAsInteger(const AValue: Integer);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.SetAsInteger';
begin
  if self = NIL then
    begin
    raise EHL7ProgrammerException.Create(hecApplicationError, 'Attempt to use an undefined cell')
    end
  else if GetHasChildren then
    begin
    GetFirstChild.SetAsInteger(AValue)
    end
  else
    begin
    FDefined := True;
    FRawContent := IntToStr(AValue);
    end;
end;

function THL7CommonDataCell.GetAsString: String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.GetAsString';
begin
  if self = NIL then
    begin
    Result := ''
    end
  else if GetHasChildren then
    begin
    Result := GetFirstChild.GetAsString
    end
  else
    begin
    Result := FRawContent;
    end;
end;

function THL7CommonDataCell.GetIsDate: Boolean;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.GetIsDate';
begin
  if self = NIL then
    begin
    Result := False
    end
  else if GetHasChildren then
    begin
    Result := GetFirstChild.GetIsDate
    end
  else
    begin
    Result := FIsDate;
    end;
end;

function THL7CommonDataCell.GetRawContent: String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.GetRawContent';
begin
  if self = NIL then
    begin
    Result := ''
    end
  else
    begin
    if GetHasChildren then
      begin
      result := GetFirstChild.GetRawContent;
      end
    else
      begin
      Result := FRawContent;
      end;
    end;
end;

procedure THL7CommonDataCell.SetAsString(const AValue: String);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.SetAsString';
begin
  if self = NIL then
    begin
    raise EHL7ProgrammerException.Create(hecApplicationError, 'Attempt to use an undefined cell');
    end;
  if GetHasChildren then
    begin
    GetFirstChild.SetAsString(AValue)
    end
  else
    begin
    FDefined := True;
    if AValue = '' then
      begin
      FRawContent := '""'
      end
    else
      begin
      FRawContent := AValue;
      end
    end;
end;

procedure THL7CommonDataCell.SetRawContent(const AValue: String);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.SetRawContent';
begin
  if self = NIL then
    begin
    raise EHL7ProgrammerException.Create(hecApplicationError, 'Attempt to use an undefined cell');
    end;
  if GetHasChildren then
    begin
    GetFirstChild.SetRawContent(AValue);
    end
  else
    begin
    if AValue = '""' then
      begin
      FRawContent := '';
      FDefined := True;
      end
    else if AValue = '' then
      begin
      FRawContent := '';
      FDefined := False;
      end
    else
      begin
      FRawContent := AValue;
      FDefined := True;
      end;
    end;
end;


procedure THL7CommonDataCell.ClearAll;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.ClearAll';
begin
  FDefined := False;
  FRawContent := '';
  FIsDate := False;
end;

procedure THL7CommonDataCell.ParseContent(AString: String; AITSClass: THL7ITSClass);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7CommonDataCell.ParseContent';
var
  LITS: THL7ER7;
begin
  ClearAll;
  if AITSClass = THL7XML then
    begin
    raise EHL7ProgrammerException.Create(hecApplicationError, 'THL7CommonDataCell.ParseContent: XML not supported yet');
    end;
  LITS := THL7ER7.Create;
  try
    if Self is THL7DataElement then
      begin
      FRawContent := AString;
      LITS.FSegOwner := (self as THL7DataElement).FSegment.FOwner;
      LITS.ParseCell(self as THL7DataElement)
      end
    else if Self is THL7Component then
      begin
      FRawContent := AString;
      LITS.FSegOwner := (self as THL7Component).FField.FSegment.FOwner;
      LITS.ParseCell(self as THL7Component)
      end
    else
      begin
      raise EHL7ProgrammerException.Create(hecApplicationError, 'Unknown type "' + ClassName + '" in THL7CommonDataCell.ParseContent');
      end;
  finally
    FreeAndNil(LITS);
    end;
end;

{ THL7DataElement }

constructor THL7DataElement.Create;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.Create';
begin
  inherited Create(ALevel, AIndex);
  assert(ALevel = 0, ASSERT_LOCATION+': Levle should be 0 for Data Elements');
  FRepeatList := TObjectList.Create;
  FComponents := THL7StringList.Create(True);
  FDefined := False;
  FFirstInstance := True;
end;

destructor THL7DataElement.Destroy;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.Destroy';
begin
  FreeAndNil(FRepeatList);
  FreeAndNil(FComponents);
  inherited;
end;

function THL7DataElement.AddRepeat: THL7DataElement;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.AddRepeat';
begin
  Result := THL7DataElement.Create(0, FElementIndex);
  Result.FDefinition := FDefinition;
  Result.FFirstInstance := False;
  Result.FSegment := FSegment;
  Result.Primary := self;
  Result.MakeForBuild;
  FRepeatList.Add(Result);
end;

function THL7DataElement.BuildView(AHtml, AFull: Boolean; AOffset, AIndex: Integer): String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.BuildView';
var
  i: Integer;
begin
  Result := LocalBuildView(Ahtml, Afull, Aoffset, Aindex);
  if FRepeatList.Count > 0 then
    begin
    if Ahtml then
      begin
      Result := Result + LeftPad(Ahtml, Aoffset + 2) + 'Repeats = ' + IntToStr(FRepeatList.Count) + '<br>' + crlf;
      for i := 1 to FRepeatList.Count do
        begin
        Result := Result + GetRepeats(i).LocalBuildView(Ahtml, Afull, Aoffset + 4, Aindex);
        end
      end
    else
      begin
      Result := Result + LeftPad(Ahtml, Aoffset) + 'Repeats = ' + IntToStr(FRepeatList.Count) + crlf;
      for i := 1 to FRepeatList.Count do
        begin
        Result := Result + GetRepeats(i).LocalBuildView(Ahtml, Afull, Aoffset + 4, Aindex);
        end
      end;
    end;
end;

function THL7DataElement.GetComponentCount: Integer;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.GetComponentCount';
begin
  Result := FComponents.Count;
end;

function THL7DataElement.GetComponents(AName: String): THL7Component;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.GetComponents';
var
  i: Integer;
begin
  AName := StripChar(AName, ' ');
  if isANumber(AName) then
    begin
    i := StrToInt(AName) - 1
    end
  else
    begin
    i := FComponents.indexof(AName);
    end;
  if (i > -1) and (i < FComponents.Count) then
    begin
    Result := FComponents.objects[i] as THL7Component
    end
  else if IsANumber(AName) then
    begin
    Result := NIL
    end
  else
    begin
    raise EBaseHL7Exception.Create(hecInternalError, 'Attempt to use unknown component ' + AName + ' from a list of ' + FComponents.CommaText);
    end;
end;

function THL7DataElement.GetRepeatCount: Integer;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.GetRepeatCount';
begin
  Result := FRepeatList.Count;
end;

function THL7DataElement.GetRepeats(i: Integer): THL7DataElement;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.GetRepeats';
begin
  if i = 0 then
    begin
    Result := self
    end
  else if i > FRepeatList.Count then
    begin
    Result := NIL
    end
  else
    begin
    Result := FRepeatList.Items[i - 1] as THL7DataElement;
    end;
end;

function THL7DataElement.LocalBuildView(AHtml, AFull: Boolean; AOffset, AIndex: Integer): String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.LocalBuildView';
var
  i: Integer;
  s: String;
begin
  if Aindex <> -1 then
    begin
    s := Leftpad(Ahtml, 2, IntToStr(Aindex))
    end
  else
    begin
    s := '';
    end;
  if ahtml then
    begin
    Result := LeftPad(Ahtml, Aoffset) + s + ' ';
    if FDefinition = NIL then
      begin
      Result := Result + 'Unknown'
      end
    else
      begin
      Result := Result + FDefinition.DataElementObj.FDescription;
      end;
    if (FComponents.Count = 0) then
      begin
      Result := Result + ' = "' + FRawContent + '"<br>' + crlf;
      end
    else
      begin
      Result := Result + '<br>' + crlf;
      for i := 0 to FComponents.Count - 1 do
        begin
        Result := Result + (FComponents.objects[i] as THL7Component).BuildView(Ahtml, Afull, inttostr(AIndex), Aoffset + 2, i + 1);
        end;
      end;
    end
  else
    begin
    Result := LeftPad(Ahtml, Aoffset) + s + ' ';
    if FDefinition = NIL then
      begin
      Result := Result + 'Unknown'
      end
    else
      begin
      Result := Result + FDefinition.DataElementObj.FDescription;
      end;
    Result := Result + '=' + FRawContent + crlf;
    for i := 0 to FComponents.Count - 1 do
      begin
      Result := Result + (FComponents.objects[i] as THL7Component).BuildView(Ahtml, Afull, inttostr(AIndex), Aoffset + 6, i + 1);
      end;
    end;
end;

procedure THL7DataElement.MakeForBuild;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.MakeForBuild';
var
  i: Integer;
  LStructureDict: THL7DictStructure;
  LComp: THL7Component;
begin
  if FDefinition = NIL then
    exit;
  LStructureDict := FDefinition.DataElementObj.StructureObj;
  for i := 0 to LStructureDict.FComponents.Count - 1 do
    begin
    LComp := THL7Component.Create(1, i + 1);
    LComp.FParent := self;
    LComp.FField := self;
    LComp.FDefined := False;
    LComp.FDictComp := (LStructureDict.FComponents.objects[i]) as THL7DictComponent;
    FComponents.addObject(StripChar(LComp.FDictComp.FDescription, ' '), LComp);
    LComp.MakeForBuild;
    end;
end;

function THL7DataElement.AddComponent(ANum: Integer): THL7Component;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.AddComponent';
var
  i: Integer;
  LComp: THL7Component;
begin
  Result := NIL;
  if (ANum > 100) or (ANum < 1) then
    begin
    exit;
    end;
  Result := Components[IntToStr(ANum)];
  if Result <> NIL then
    begin
    exit;
    end;
  for i := 1 to ANum do
    begin
    LComp := Components[IntToStr(i)];
    if LComp = NIL then
      begin
      LComp := THL7Component.Create(1, i);
      LComp.FField := self;
      LComp.FParent := self;
      LComp.FDefined := False;
      LComp.FDictComp := NIL;
      FComponents.addObject('Component' + IntToStr(i), LComp);
      if i = 1 then
        begin
        // we just added the first component.
        LComp.FRawContent := FRawContent;
        LComp.FDefined := FDefined;
        FRawContent := '';
        FDefined := False;
        end;
      end;
    end;
  Result := Components[IntToStr(ANum)];
end;

//
procedure THL7DataElement.Validate(AMsg: THL7Message; AOptions: TValidationOptionSet);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.Validate';
var
  LDef: Boolean;
  i: Integer;
  s: String;
begin
  if (voRequired in AOptions) and assigned(Definition) and Definition.FRequired then
    begin
    if not GetHasChildren then
      begin
      LDef := FRawContent <> ''
      end
    else
      begin
      LDef := False;
      for i := 0 to FComponents.Count - 1 do
        begin
        LDef := LDef or (FComponents.objects[i] as THL7Component).FDefined;
        end;
      end;
    if not LDef then
      begin
      FValid := False;
      AMsg.AddValidationNote(FSegment.FDefinition.FName, IntToStr(FElementIndex), (AMsg.FDict.FDataElements[FDefinition.FDataElement] as THL7DictDataElement).FDescription, 'required but not provided');
      end;
    end;
  if assigned(Definition) then
    begin
    s := Definition.GetDataElementObj.StructureObj.FDataTypeCode;
    end
  else
    begin
    s := '';
    end;
  FIsDate := (s = 'DT') or (s = 'TM') or (s = 'TS');
  if (voDateFormat in AOptions) and FIsDate and (FRawContent <> '') then
    begin
    if (s = 'DT') then
      begin
      try
        ReadDate('yyyymmdd', FRawContent, True, True);
      except
        FValid := False;
        AMsg.AddValidationNote(FSegment.FDefinition.FName, IntToStr(FElementIndex), (Amsg.FDict.FDataElements[FDefinition.FDataElement] as THL7DictDataElement).FDescription, 'is a Timestamp but the format is wrong');
        end;
      end
    else if (s = 'TM') then
      begin
      try
        ReadDate('hhnnss', FRawContent, True, True, True);
      except
        FValid := False;
        Amsg.AddValidationNote(FSegment.FDefinition.FName, IntToStr(FElementIndex), (Amsg.FDict.FDataElements[FDefinition.FDataElement] as THL7DictDataElement).FDescription, 'is a Timestamp but the format is wrong');
        end;
      end
    else {s = 'TS'}
      begin
      try
        ReadDate('yyyymmddhhnnss', FRawContent, True, False);
      except
        FValid := False;
        Amsg.AddValidationNote(FSegment.FDefinition.FName, IntToStr(FElementIndex), (Amsg.FDict.FDataElements[FDefinition.FDataElement] as THL7DictDataElement).FDescription, 'is a Timestamp but the format is wrong');
        end;
      end;
    end;
  if FRepeatList.Count > 0 then
    begin
    if not FDefinition.Repeatable then
      begin
      FValid := False;
      Amsg.AddValidationNote(FSegment.FDefinition.FName, IntToStr(FElementIndex), (Amsg.FDict.FDataElements[FDefinition.FDataElement] as THL7DictDataElement).FDescription, 'repeats but repetition was not expected');
      for i := 0 to FRepeatList.Count - 1 do
        begin
        (FRepeatList.Items[i] as THL7CommonDataCell).FValid := False;
        end;
      end;
    end;
end;

function THL7DataElement.GetTable: THL7DictTable;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.GetTable';
begin
  if assigned(FDefinition) and assigned(FDefinition.DataElementObj) and
    assigned(FDefinition.DataElementObj.FStructureObj) and
    (FDefinition.DataElementObj.FStructureObj.FComponents.Count = 0) then
    begin
    Result := FDefinition.DataElementObj.FTableObj
    end
  else
    begin
    Result := NIL;
    end;
end;

function THL7DataElement.GetFieldName: String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.GetFieldName';
begin
  if assigned(FDefinition) and assigned(FDefinition.DataElementObj) then
    begin
    Result := FDefinition.DataElementObj.FDescription
    end
  else
    begin
    Result := '(unknown)';
    end;
end;

function THL7DataElement.GetDefined: Boolean;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.GetDefined';
var
  i: Integer;
begin
  if self = NIL then
    begin
    Result := False
    end
  else
    begin
    for i := 0 to FComponents.Count - 1 do
      begin
      Result := (FComponents.objects[i] as THL7Component).GetDefined;
      if Result then
        begin
        exit;
        end;
      end;
    Result := inherited GetDefined;
    end
end;

{ note concerning cloneAllowUnknownContent: This is only strictly
accurate when CloneDataElement has not already had it's structure
changed to different to the dictionary by calling CloneDataElement
with cloneAllowUnknownContent set on, or by manually adding items,
or where the DataElement was read from a message that already differed
from the dictionary. In this case the content will be considered as
"known" operationally even though it will not be found in the
dictionary and FDefinition will be nil }

procedure THL7DataElement.CloneDataElement(ASourceDataElement: THL7DataElement; AOptions: TCloneItemOptionSet);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.CloneDataElement';
var
  LSrcComp: THL7Component;
  LDstComp: THL7Component;
  i: Integer;
begin
  if ASourceDataElement.FComponents.Count = 0 then
    begin
    if Self.FComponents.Count > 0 then
      begin
      { we will treat the Source as if it were Component #0 }
      LDstComp := Self.FComponents.objects[0] as THL7Component;
      if ASourceDataElement.FRawContent <> '' then
        begin
        LDstComp.RawContent := ASourceDataElement.FRawContent;
        end;
      { for this case, we will ignore the AOptions where the Source is empty or undefined.
        I'm unsure about this wisdom of this, but Components and Defined works differently  Grahame 16/5/2001 }
      end
    else
      begin
      { no components - work with the base DataElement }
      if ASourceDataElement.FDefined then
        begin
        if ASourceDataElement.FRawContent = '' then
          begin
          if cloneOverwriteEmpty in AOptions then
            begin
            self.RawContent := ASourceDataElement.FRawContent;
            end;
          end
        else
          begin
          self.RawContent := ASourceDataElement.FRawContent;
          end;
        end
      else
        begin
        if cloneOverwriteUnDefined in AOptions then
          begin
          self.RawContent := '';
          self.Defined := False;
          end;
        end;
      end;
    end
  else
    begin
    { if there is no components existing on Self then we are leaving the dictionary.
      If we are allowing this, then we need to move the content of DataElement into the
      a component prior to beginning the copy }
    if (self.FComponents.Count = 0) and (cloneAllowUnknownContent in AOptions) then
      begin
      LDstComp := THL7Component.Create(1, 1);
      LDstComp.FField := self;
      LDstComp.FParent := self;
      LDstComp.FDefined := False;
      LDstComp.FDictComp := NIL;
      FComponents.addObject('default0', LDstComp);
      LDstComp.RawContent := Self.FRawContent;
      self.FDefined := False;
      end;
    if Self.FComponents.Count <> 0 then
      begin
      for i := 0 to ASourceDataElement.FComponents.Count - 1 do
        begin
        LSrcComp := ASourceDataElement.FComponents.objects[i] as THL7Component;
        if i >= self.FComponents.Count then
          begin
          if (cloneAllowUnknownContent in AOptions) then
            begin
            LDstComp := THL7Component.Create(1, i + 1);
            LDstComp.FField := self;
            LDstComp.FParent := self;
            LDstComp.FDefined := False;
            LDstComp.FDictComp := NIL;
            FComponents.addObject('unknown' + IntToStr(i), LDstComp);
            end
          else
            begin
            LDstComp := NIL;
            end;
          end
        else
          begin
          LDstComp := self.FComponents.objects[i] as THL7Component;
          end;
        if assigned(LDstComp) then
          begin
          LDstComp.RawContent := LSrcComp.FRawContent;
          end;
        end;
      end;
    end;
end;


function THL7DataElement.ChooseRepeat(ALocation, AValue: String): THL7DataElement;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.ChooseRepeat';
var
  LDe: THL7DataElement;
  i: Integer;
begin
  Result := NIL;
  for i := 0 to RepeatCount do
    begin
    Lde := Repeats[i];
    if ALocation = '' then
      begin
      if SameText(RawContent, AValue) then
        begin
        Result := Lde;
        end;
      end
    else if SameText(LDe.Components[ALocation].AsString, AValue) then
      begin
      Result := Lde;
      end;
    if assigned(Result) then
      begin
      exit;
      end;
    end;
end;

function THL7DataElement.MyName: String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.MyName';
begin
  Result := FSegment.FDefinition.FName + '-' + IntToStr(FElementIndex);
end;

procedure THL7DataElement.ClearAll;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.ClearAll';
var
  i: Integer;
begin
  inherited;
  FRepeatList.Clear;
  for i := 0 to FComponents.Count - 1 do
    begin
    (FComponents.objects[i] as THL7Component).ClearAll;
    end;
end;

procedure THL7DataElement.ChangeVersion(ANewDict: THL7Dictionary; ADeleteInvalidContent: Boolean; ADefinition: THL7DictSegmentField);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.ChangeVersion';
var
  i: Integer;
  LCmp: THL7Component;
  LCmpDfn: THL7DictComponent;
  LStructureDict: THL7DictStructure;
begin
  if ADefinition <> NIL then
    begin
    LStructureDict := ADefinition.DataElementObj.StructureObj;
    if (LStructureDict.FComponents.Count = 0) and (FComponents.Count > 0) and ADeleteInvalidContent then
      begin
      // special case - we need to move the content of the first component into the
      // data element, and then delete them all
      LCmp := FComponents.Objects[0] as THL7Component;
      FRawContent := LCmp.FRawContent;
      FDefined := LCmp.FDefined;
      end
    else
      for i := FComponents.Count - 1 downto 0 do
        begin
        LCmp := FComponents.Objects[i] as THL7Component;
        if i < LStructureDict.FComponents.Count then
          begin
          LCmpDfn := (LStructureDict.FComponents.objects[i]) as THL7DictComponent
          end
        else
          begin
          LCmpDfn := NIL;
          end;
        if (LCmpDfn = NIL) and ADeleteInvalidContent then
          begin
          FComponents.Delete(i)
          end
        else
          begin
          LCmp.FDictComp := LCmpDfn;
          end;
        end;
    end;
  FDefinition := ADefinition;
  if (FDefinition = NIL) or (not FDefinition.FRepeatable and ADeleteInvalidContent) then
    begin
    FRepeatList.Clear
    end
  else
    begin
    for i := 0 to FRepeatList.Count - 1 do
      begin
      (FRepeatList.Items[i] as THL7DataElement).ChangeVersion(ANewDict, ADeleteInvalidContent, ADefinition);
      end;
    end;
end;

function THL7DataElement.GetFirstChild: THL7CommonDataCell;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.GetFirstChild';
begin
  if GetHasChildren then
    begin
    Result := FComponents.objects[0] as THL7CommonDataCell
    end
  else
    begin
    Result := NIL;
    end;
end;

function THL7DataElement.GetHasChildren: Boolean;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.GetHasChildren';
begin
  if self = NIL then
    begin
    Result := False
    end
  else
    begin
    Result := FComponents.Count > 0
    end;
end;

procedure THL7DataElement.SetType(AType: String);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.SetType';
begin
  assert(self.TestValid(THL7DataElement), ASSERT_LOCATION + ': self is not valid');
  FAltDefinition := AType;
end;

procedure THL7DataElement.Clone(ADataElement : THL7DataElement);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.Clone';
var
  i : integer;
begin
  FRawContent := ADataElement.FRawContent;
  FDefined := ADataElement.FDefined;
  for i := 0 to ADataElement.FComponents.Count - 1 do
    begin
    if assigned(Components[IntToStr(i + 1)]) then
      begin
      Components[IntToStr(i + 1)].Clone(ADataElement.Components[IntToStr(i + 1)]);
      end;
    end;
end;

function THL7DataElement.GetChildCount: integer;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.GetChildCount';
begin
  result := FComponents.Count;
end;

function THL7DataElement.GetEscapable(AEscapeMode : boolean): boolean;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.GetEscapable';
begin
  result := assigned(FDefinition) and
            assigned(FDefinition.DataElementObj) and
            assigned(FDefinition.DataElementObj.FStructureObj) and
            assigned(FDefinition.DataElementObj.FStructureObj.DataType) and
            FDefinition.DataElementObj.FStructureObj.DataType.Escapable(AEscapeMode);
end;

function THL7DataElement.GetNthChild(i: integer): THl7CommonDataCell;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DataElement.GetNthChild';
begin
  result := AddComponent(i+1);
end;

{ THL7Segment }

procedure THL7Segment.BuildFields;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Segment.BuildFields';
var
  i: Integer;
  LDe: THL7DataElement;
begin
  if not assigned(FDefinition) then
    begin
    exit;
    end;
  //create, parse fields
  for i := 0 to FDefinition.FFields.Count - 1 do
    begin
    LDe := THL7DataElement.Create(0, i + 1);
    LDe.FDefinition := FDefinition.FFields.objects[i] as THL7DictSegmentField;
    LDe.FFirstInstance := True;
    LDe.FSegment := self;
    LDe.FRawContent := '';
    LDe.MakeForBuild;
    FFields.Add(LDe);
    end;
end;

constructor THL7Segment.Create;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Segment.Create';
begin
  inherited Create;
  FFields := TObjectList.Create;
  FCode := ACode;
  FOwner := aowner;
end;

destructor THL7Segment.Destroy;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Segment.Destroy';
begin
  FreeAndNil(FFields);
  inherited;
end;

function THL7Segment.BuildView(AHtml, AFull: Boolean; AOffset: Integer): String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Segment.BuildView';
var
  i: Integer;
begin
  if Ahtml then
    begin
    if assigned(FDefinition) then
      begin
      Result := TitleCase(FDefinition.FDesc) + '<span style="color:#DFDFDF;">(' + FSegmentContent + ')</span><br />' + crlf
      end
    else
      begin
      Result := '<span style="color:#DFDFDF;">(Unknown)</span><br />' + crlf;
      end;

    for i := 0 to FFields.Count - 1 do
      begin
      Result := Result + (FFields[i] as THL7DataElement).BuildView(Ahtml, Afull, Aoffset + 2, i + 1) + crlf;
      end;
    end
  else
    begin
    Result := ' ' + FDefinition.FDesc + crlf;
    for i := 0 to FFields.Count - 1 do
      begin
      Result := Result + (FFields[i] as THL7DataElement).BuildView(Ahtml, Afull, Aoffset + 2, i + 1);
      end;
    end;
end;

function THL7Segment.GetFieldByName(AFieldName: String): THL7DataElement;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Segment.GetFieldByName';
var
  i: Integer;
begin
  if IsANumber(AFieldName) then
    begin
    i := StrToInt(AFieldName) - 1
    end
  else
    begin
    AFieldName := StripChar(AFieldName, ' ');
    i := FDefinition.FFields.IndexOf(AFieldName);
    end;
  if i = -1 then
    begin
    raise EBaseHL7Exception.Create(hecInternalError, 'Field ' + AFieldName + ' not found in segment ' + FDefinition.FName + ' from list of fields ' + FDefinition.FFields.CommaText)
    end
  else if i >= FFields.Count then
    begin
    Result := NIL
    end
  else
    begin
    Result := FFields[i] as THL7DataElement;
    end;
end;

function THL7Segment.GetElement(ACode: String): THL7CommonDataCell;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Segment.GetElement';
var
  LLeft: String;
  LRight: String;
  LFieldIndex: Integer;
begin
  try
    if pos('.', ACode) > 0 then
      begin
      split(ACode, '.', LLeft, LRight)
      end
    else
      begin
      split(ACode, '-', LLeft, LRight);
      end;
    if LLeft = '' then
      begin
      raise EHL7ProgrammerException.Create(hecApplicationError, 'You must specify a field index');
      end;
    LFieldIndex := StrToInt(LLeft) - 1;
    if LFieldIndex >= FFields.Count then
      begin
      Result := NIL
      end
    else
      begin
      Result := FFields[LFieldIndex] as THL7CommonDataCell;
      if pos('.', LRight) > 0 then
        begin
        split(LRight, '.', LLeft, LRight)
        end
      else
        begin
        split(LRight, '-', LLeft, LRight);
        end;
      if LLeft <> '' then
        begin
        Result := (Result as THL7DataElement).Components[LLeft];
        if LRight <> '' then
          begin
          Result := (Result as THL7Component).SubComponents[LRight];
          end;
        end;
      end;
  except
    Result := NIL;
    // There has been some uncertainty about this, whether to go for a exception or not.
    // GDG 06/12/00, waiting for a rethink....
    end;
end;

{ There is some gotcha's with this - refer to comments for THl7DataElement.CloneDataElement }

procedure THL7Segment.CloneSegment(ASourceSegment: THL7Segment; AOptions: TCloneItemOptionSet);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Segment.CloneSegment';
var
  i: Integer;
  j: Integer;
  LSrcDE: THL7DataElement;     // working handle to DataElement in SourceSegment I am copying information from
  LDestDE: THL7DataElement;    // working handle to My DataElement that I am copying information into
  LSRepDE: THL7DataElement;    // working handle to a Repeat DataElement In SourceSegment that I am copying information from
  LDRepDE: THL7DataElement;    // working handle to a Repeat DataElement (mine) that I am copying information into
begin
  for i := 0 to ASourceSegment.FFields.Count - 1 do
    begin
    LSrcDE := ASourceSegment.Fields.items[i] as THL7DataElement;
    if i >= Self.FFields.Count then
      begin
      if (cloneAllowUnknownContent in AOptions) then
        begin
        LDestDE := THL7DataElement.Create(0, i + 1);
        Self.FFields.Add(LDestDE);
        LDestDE.FSegment := self;
        end
      else
        begin
        LDestDE := NIL;
        end;
      end
    else
      begin
      LDestDE := self.FFields[i] as THL7DataElement;
      end;

    if assigned(LDestDE) then
      begin
      LDestDE.CloneDataElement(LSrcDE, AOptions);
      if (cloneAllowUnknownContent in AOptions) or (LDestDE.RepeatCount > 0) then
        begin
        for j := 0 to LSrcDE.FRepeatList.Count - 1 do
          begin
          LSRepDE := LSrcDE.FRepeatList[j] as THL7DataElement;
          if j < LDestDE.RepeatCount then
            begin
            LDRepDE := LDestDE.FRepeatList[j] as THL7DataElement
            end
          else
            begin
            LDRepDE := NIL;
            end;
          if not assigned(LDRepDE) and (cloneAllowUnknownContent in AOptions) then
            begin
            LDRepDE := LDestDE.AddRepeat;
            end;
          if assigned(LDRepDE) then
            begin
            LDRepDE.CloneDataElement(LSRepDE, AOptions);
            end;
          end;
        end;
      end;
    end;
end;

procedure THL7Segment.ChangeVersion(ANewDict: THL7Dictionary; ADeleteInvalidContent: Boolean; ADefinition: THL7DictSegment);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Segment.ChangeVersion';
var
  i: Integer;
  LFld: THL7DataElement;
  LFldDfn: THL7DictSegmentField;
begin
  if ADefinition <> NIL then
    begin
    for i := FFields.Count - 1 downto 0 do
      begin
      LFld := FFields.Items[i] as THL7DataElement;
      if i < ADefinition.FFields.Count then
        begin
        LFldDfn := ADefinition.FFields.objects[i] as THL7DictSegmentField
        end
      else
        begin
        LFldDfn := NIL;
        end;
      if (LFldDfn = NIL) and ADeleteInvalidContent then
        begin
        FFields.Delete(i)
        end
      else
        begin
        LFld.ChangeVersion(ANewDict, ADeleteInvalidContent, LFldDfn);
        end
      end;
    end;
  FDefinition := ADefinition;
end;

function THL7Segment.GetSegmentIndex: Integer;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Segment.GetSegmentIndex';
begin
  Result := FOwner.FSegments.IndexOfObject(self);
end;

function THL7Segment.AddField(AFieldNum: Integer): THL7DataElement;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Segment.AddField';
var
  i: Integer;
  LField: THL7DataElement;
begin
  assert(self <> NIL, 'THL7Segment.AddField: Self is nil');
  assert(AFieldNum > 0, 'THL7Segment.AddField: AFieldNum is invalid');
  Result := NIL;
  if (AFieldNum > 100) or (AFieldNum < 1) then
    begin
    exit;
    end;
  Result := FieldByName[IntToStr(AFieldNum)];
  if Result <> NIL then
    begin
    exit;
    end;
  for i := 1 to AFieldNum do
    begin
    LField := FieldByName[IntToStr(i)];
    if LField = NIL then
      begin
      LField := THL7DataElement.Create(0, i);
      LField.FSegment := self;
      LField.FDefined := False;
      LField.FDefinition := NIL;
      FFields.add(LField);
      end;
    end;
  Result := FieldByName[IntToStr(AFieldNum)];
end;

procedure THL7Segment.Validate(AMsg: THL7Message; AOptions: TValidationOptionSet);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Segment.Validate';
var
  i: Integer;
  LStart: Integer;
begin
  assert(Self.TestValid(THL7Segment), ASSERT_LOCATION + ': self is not valid');
  assert(AMsg.TestValid(THL7Message), ASSERT_LOCATION + ': Message is not valid');
  if FCode = 'MSH' then
    begin
    // cause MSH-1 and MSH-2 are screwy - and if they were wrong we couldn't be doing this
    LStart := 2;
    end
  else
    begin
    LStart := 0;
    end;
  for i := LStart to FFields.Count - 1 do
    begin
    (FFields[i] as THL7DataElement).Validate(AMsg, AOptions);
    end;
end;

{ THL7Message }

constructor THL7Message.Create;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.Create';
begin
  inherited;
  if not assigned(GHL7Dict) then
    begin
    raise EBaseHL7Exception.Create(hecDictionaryError, 'No HL7 Dictionary defined');
    end;
  FValidationNotes := TStringList.Create;
  FStructure := NIL;
  FAddStructName := True;
  FSegmentMap := NIL;
end;

destructor THL7Message.Destroy;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.Destroy';
begin
  FreeAndNil(FSegmentMap);
  FreeAndNil(FValidationNotes);
  inherited;
end;

procedure THL7Message.Decode(APacket: THL7Packet; AVersionOverride: String = ''; ASegmentLimit: Integer = 0; AITSClass: THL7ITSClass = NIL);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.Decode';
var
  LPck: String;
  LIts: THL7AbstractITS;
begin
  DropMetaData;
  FSource := APacket;
  FSegments.Clear;
  FDecodeTime := Now;

  // determine ITS class of message:
  if AITSClass = NIL then
    begin
    if length(APacket) < 2 then
      begin
      raise EBaseHL7Exception.Create(hecBadMessage, 'The Message encoding type was not defined and the message is too short to determine the type (Packet="' + MimeEnCode(APacket) + '"');
      end;
    LPck := uppercase(StripSoln(copy(APacket, 1, 100)));
    if copy(LPck, 1, 3) = 'MSH' then
      begin
      AITSClass := THL7ER7
      end
    else if pos('DOCTYPE', LPck) > 0 then
      begin
      AITSClass := THL7XML
      end
    else if pos('<XML', LPck) > 0 then
      begin
      AITSClass := THL7XML
      end
    else if pos('<?XML', LPck) > 0 then
      begin
      AITSClass := THL7XML
      end
    else if pos('<', copy(LPck, 1, 10)) > 0 then
      begin
      AITSClass := THL7XML;
      end
    else if copy(LPck, 1, 3) = 'FHS' then
      begin
      raise EBaseHL7Exception.Create(hecBadMessage, 'The Message is actually a batch file. Use THL7File to assist with decoding the message')
      end
    else if LPck = '' then
      begin
      raise EBaseHL7Exception.Create(hecBadMessage, 'The Message was empty and could not be decoded')
      end
    else
      begin
      raise EBaseHL7Exception.Create(hecBadMessage, 'The Message encoding type was not defined and could not be observed (starting text = "' + copy(LPck, 1, 10) + '")');
      end
    end;

  LIts := AITSClass.Create;
  try
    LIts.decode(self, APacket, AVersionOverride, ASegmentLimit);
  finally
    FreeAndNil(LIts);
    end;
  ResolveVariableTypes;
end;

function THL7Message.EnCodeClass(AITSClass: THl7ITSClass = NIL; AOptions : THL7EncodingOptionSet = []): THL7Packet;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.EnCodeClass';
var
  LIts: THL7AbstractITS;
begin
  if AITSClass = NIL then
    begin
    AITSClass := THL7ER7;
    end;

  if FStructID = '' then
    begin
    TryLoadStruct;
    end;
  ResolveVariableTypes;

  LIts := AITSClass.Create;
  try
    Result := LIts.Encode(self, AOptions);
  finally
    FreeAndNil(LIts);
    end;
  FSource := Result;
end;

function THL7Message.EnCode(AITS: String = 'ER7'): THL7Packet;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.EnCode';
begin
  if SameText(AITS, '') or SameText(AITS, 'ER7') then
    begin
    Result := EnCodeClass(THL7ER7, [])
    end
  else if SameText(AITS, 'XML') then
    begin
    Result := EnCodeClass(THL7XML, [])
    end
  else
    begin
    raise EHL7ProgrammerException.Create(hecApplicationError, 'Unknown ITS type "' + AITS + '"');
    end
end;

function THL7Message.BuildView(AHtml, AFull: Boolean; AOffset: Integer): String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.BuildView';
var
  s: String;
  i: Integer;
begin
  s := '';
  if FValidationNotes.Count > 0 then
    if AHtml then
      begin
      s := '<b>Validation Failures</b><br>' + crlf;
      for i := 0 to FValidationNotes.Count - 1 do
        begin
        s := s + FValidationNotes[i] + '<br>' + crlf;
        end;
      s := s + '<p>' + crlf;
      end
    else
      begin
      s := FValidationNotes.Text + crlf;
      end;
  if AHtml then
    begin
    s := s + '<b>Structure</b><p>' + crlf;
    for i := 0 to FSegments.Count - 1 do
      begin
      s := s + '<b>' + FSegments[i] + '</b> ' + (FSegments.Objects[i] as THL7Segment).BuildView(Ahtml, Afull, 0);
      end;
    end
  else
    begin
    s := s + 'Structure:' + crlf;
    for i := 0 to FSegments.Count - 1 do
      begin
      s := S + FSegments[i] + (FSegments.Objects[i] as THL7Segment).BuildView(Ahtml, Afull, 2);
      end;
    end;
  Result := s;
end;

function THL7Message.View(Ahtml, Afull, AValidate: Boolean): String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.View';
begin
  if AValidate then
    begin
    Validate(FULL_VALIDATION);
    end;
  Result := BuildView(Ahtml, Afull, 0);
end;

function THL7Message.AppAckRequired: Boolean;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.AppAckRequired';
begin
  Result := False;
end;

procedure THL7Message.BuildAsReply(AMsg: THL7Message; AUseSequenceNum: Boolean = False; ASequenceNum: Int64 = 0);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.BuildAsReply';
var
  LSeg: THL7Segment;
  LSrcSeg: THL7Segment;
begin
  DropMetaData;
  FDicts := AMsg.FDicts;
  FDict := AMsg.FDict;
  FFieldDelimiter := AMsg.FFieldDelimiter;
  FComponentDelimiter := AMsg.FComponentDelimiter;
  FSubComponentDelimiter := AMsg.FSubComponentDelimiter;
  FRepetitionDelimiter := AMsg.FRepetitionDelimiter;
  FEscapeCharacter := AMsg.FEscapeCharacter;
  FVersion := AMsg.FVersion;
  FEvent := AMsg.FEvent;
  FMsgID := FormatDateTime('yyyymmddhhnnsszzz', Now);
  LSeg := THL7Segment.Create('MSH', self);
  LSeg.FDefinition := FDict.GetSegment('MSH');
  LSeg.BuildFields;
  LSrcSeg := AMsg.Segments.objects[0] as THL7Segment;
  Segments.AddObject('MSH', LSeg);
  try
    LSeg.FieldByName['12'].AsString := LSrcSeg.FieldByName['12'].AsString; // version
    if FVersion = '2.1' then
      begin
      LSeg.FieldByName['9'].AsString := 'ACK'    // message type
      end
    else
      begin
      LSeg.FieldByName['9'].Components['1'].AsString := 'ACK';
      LSeg.FieldByName['9'].Components['2'].AsString := LSrcSeg.FieldByName['9'].Components['2'].AsString;
      //^^      check other reply defined
      if FVersion >= '2.3.1' then
        begin
        LSeg.FieldByName['9'].Components['3'].AsString := 'ACK';
        //^^        StructID := 'ACK';
        end;
      end;

    // by default, the message id is a timestamp. Application can provide own contents if desired
    LSeg.FieldByName['10'].AsString := FMsgID;   //  MessageControlID

    // echo MSH3-6 flipped around. Application can modify if desired
    LSeg.FieldByName['3'].RawContent := LSrcSeg.FieldByName['5'].RawContent;
    LSeg.FieldByName['4'].RawContent := LSrcSeg.FieldByName['6'].RawContent;
    LSeg.FieldByName['5'].RawContent := LSrcSeg.FieldByName['3'].RawContent;
    LSeg.FieldByName['6'].RawContent := LSrcSeg.FieldByName['4'].RawContent;

    LSeg.FieldByName['7'].AsDateTime := Now;  // date / time of message
    LSeg.FieldByName['11'].AsString := LSrcSeg.FieldByName['11'].AsString;       //  ProcessingID
    // not sure if this is correct? echo MSH Sequence num in MSH.
    if AUseSequenceNum then
      LSeg.FieldByName['13'].AsString := LSrcSeg.FieldByName['13'].AsString;
  except
    end;
  LSeg := THL7Segment.Create('MSA', self);
  LSeg.FDefinition := FDict.GetSegment('MSA');
  LSeg.BuildFields;
  Segments.AddObject('MSA', LSeg);

  if FVersion = '2.1' then
    begin
    LSeg.FieldByName['1'].AsString := 'AA' // OK by default
    end
  else
    begin
    LSeg.FieldByName['1'].AsString := 'AA'; // OK by default
    end;
  LSeg.FieldByName['2'].AsString := AMsg.MsgID;
  // application may need to overrule in case of sequence sync
  if AUseSequenceNum then
    begin
    LSeg.FieldByName['4'].AsString := IntToStr(ASequenceNum);
    end;
end;

function THL7Message.GetSegment(ACode: String; i: Integer): THL7Segment;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.GetSegment';
var
  j: Integer;
begin
  Result := NIL;
  j := 0;
  while (j < FSegments.Count) do
    begin
    if AnsiCompareText(FSegments[j], Acode) = 0 then
      if i = 0 then
        begin
        Result := FSegments.objects[j] as THL7Segment;
        exit;
        end
      else
        begin
        dec(i);
        end;
    inc(j);
    end;
end;

procedure THL7Message.SetExceptionMessage(AMsg: String; AMakeReject: Boolean = False);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.SetExceptionMessage';
begin
  assert(self.TestValid(THL7Message), ASSERT_LOCATION + ': self is not valid');
  assert(Segment['MSA', 0].TestValid(THL7Segment), ASSERT_LOCATION + ': MSA Segment not found');

  if AMakeReject then
    begin
    Segment['MSA', 0].FieldByName['1'].AsString := 'AR'
    end
  else
    begin
    Segment['MSA', 0].FieldByName['1'].AsString := 'AE';
    end;
  Segment['MSA', 0].FieldByName['3'].AsString := AMsg;
end;

function GetExceptionConditionResponseCode(ACond: THL7ErrorCondition): String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.GetExceptionConditionResponseCode(cond';
begin
  case ACond of
    hecAccepted:
      begin
      {$IFDEF DEVELOPMENT}
      try
        raise EHL7ProgrammerException.Create(hecApplicationError, 'You shouldn''t have exceptions with this Error COndition')
      except
        end;
      Result := 'AA'; // although this should never be used
      {$ENDIF}
      end;
    hecSequenceError, hecRequiredField, hecDataTypeError, hecNoTableValue: // AE
      begin
      Result := 'AE';
      end;
    hecUnsEvntCode, hecUnsProcID, hecUnsVersion, hecUnknownKey, hecDuplicateKey, hecRecordLocked:
      begin
      Result := 'AR';
      end;
    else
    { other types - left as "else" there is multiple variants of InternalError }
      begin
      Result := 'AE';
      end;
    end;
end;

function GetExceptionConditionCode(ACond: THL7ErrorCondition): String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.GetExceptionConditionCode(cond';
begin
  case ACond of
    hecAccepted:
      begin
      {$IFDEF DEVELOPMENT}
      try
        raise EHL7ProgrammerException.Create(hecApplicationError, 'You shouldn''t have exceptions with this Error COndition')
      except
        end;
      Result := '0';
      {$ENDIF}
      end;
    hecSequenceError:
      Result := '100';
    hecRequiredField:
      Result := '101';
    hecDataTypeError:
      Result := '102';
    hecNoTableValue:
      Result := '103';
    hecUnsMsgType:
      Result := '200';
    hecUnsEvntCode:
      Result := '201';
    hecUnsProcID:
      Result := '202';
    hecUnsVersion:
      Result := '203';
    hecUnknownKey:
      Result := '204';
    hecDuplicateKey:
      Result := '205';
    hecRecordLocked:
      Result := '206';
    else
      { multiple variants of 207 }
      Result := '207';
    end;
end;

procedure THL7Message.SetException(AExcept: Exception);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.SetException';
begin
  DropMetaData;
  if Segment['MSA', 0] = NIL then
    begin
    AddSegment('MSA');
    end;
  if AExcept is EBaseHL7Exception then
    begin
    if AExcept is EHl7RejectException then
      begin
      Element['MSA-1'].AsString := 'AR'
      end
    else if AExcept is EHL7ErrorException then
      begin
      Element['MSA-1'].AsString := 'AE'
      end
    else
      begin
      Element['MSA-1'].AsString := GetExceptionConditionResponseCode((AExcept as EBaseHL7Exception).FCondition);
      end;
    if FVersion <> '2.1' then
      begin
      Element['MSA-6.1'].AsString := GetExceptionConditionCode((AExcept as EBaseHL7Exception).FCondition);
      end;
    end
  else
  // not sure whether to put AE or AR here. this error presumably rates as an
  // internal error since it is a plain error - a database problem? We will
  // use AE but use a 207 code - in a sense this is a dollar each way but
  // Kestral custom is to put AE
    begin
    if FVersion <> '2.1' then
      begin
      Element['MSA-6.1'].AsString := '207';
      end;
    Element['MSA-1'].AsString := 'AE';
    end;
  Element['MSA-3'].AsString := AExcept.message;
end;

function THL7Message.AddSegment(ACode: String): THL7Segment;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.AddSegment';
begin
  DropMetaData;
  Result := THL7Segment.Create(ACode, self);
  try
    Result.FDefinition := FDict.GetSegment(ACode);
  except
    Result.FDefinition := NIL;
    end;
  Result.BuildFields;
  Segments.AddObject(ACode, Result);
end;

procedure THL7Message.SetVersion(const AValue: String);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.SetVersion';
begin
  DropMetaData;
  if FSegments.Count > 0 then
    begin
    raise EBaseHL7Exception.Create(hecApplicationError, 'Attempt to set a version with segments in the message');
    end;
  FVersion := AValue;
  FDict := FDicts[AValue];
  if GetSegment('MSH', 0) <> NIL then
    begin
    GetSegment('MSH', 0).FieldByName['VersionID'].AsString := FVersion;
    end;
end;

// SEGn-N.O.P
function THL7Message.GetElement(ACode: String): THL7CommonDataCell;
const 
  ASSERT_LOCATION = 'THL7Message.SetVersionTHL7Message.SetVersionHL7_Dict.THL7Message.GetElement';
var
  LLeft: String;
  LRight: String;
  LSeg: String;
  LSegIndex: Integer;
begin
  try
    split(ACode, '-', LLeft, LRight);
    LSeg := copy(LLeft, 1, 3);
    if LSeg = '' then
      begin
      raise EHL7ProgrammerException.Create(hecApplicationError, 'You must specify a segment');
      end;
    if length(LLeft) <= 3 then
      begin
      LSegIndex := 0
      end
    else
      begin
      LSegIndex := StrToInt(copy(LLeft, 4, $FF));
      end;

    if assigned(Segment[LSeg, LSegIndex]) then
      begin
      Result := Segment[LSeg, LSegIndex].Element[LRight]
      end
    else
      begin
      Result := NIL;
      end;
  except
    Result := NIL;
    end;
end;

procedure THL7Message.SetEvent(const AValue: String);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.SetEvent';
begin
  DropMetaData;
  FEvent := AValue;
  if not assigned(FStructure) then
    begin
    TryLoadStruct;
    end;
  if GetSegment('MSH', 0) <> NIL then
    begin
    if GetSegment('MSH', 0).FieldByName['9'].ComponentCount = 0 then
      begin
      GetSegment('MSH', 0).FieldByName['9'].AsString := FEvent
      end
    else
      begin
      GetSegment('MSH', 0).FieldByName['9'].Components['2'].AsString := FEvent;
      end;
    end;
end;

procedure THL7Message.SetMessageType(const AValue: String);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.SetMessageType';
begin
  DropMetaData;
  FMessageType := AValue;
  if not assigned(FStructure) then
    begin
    TryLoadStruct;
    end;
  if GetSegment('MSH', 0) <> NIL then
    begin
    if GetSegment('MSH', 0).FieldByName['9'].ComponentCount = 0 then
      begin
      GetSegment('MSH', 0).FieldByName['9'].AsString := FMessageType
      end
    else
      begin
      GetSegment('MSH', 0).FieldByName['9'].Components['1'].AsString := FMessageType;
      end
    end;
end;

procedure THL7Message.SetMsgID(const AValue: String);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.SetMsgID';
begin
  FMsgID := AValue;
  if GetSegment('MSH', 0) <> NIL then
    begin
    GetSegment('MSH', 0).FieldByName['10'].AsString := FMsgID;
    end;
end;

procedure THL7Message.DropSegments(ACode: String);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.DropSegments';
var
  i: Integer;
begin
  DropMetaData;
  i := FSegments.indexof(ACode);
  while i <> -1 do
    begin
    FSegments.Delete(i);
    i := FSegments.indexof(ACode);
    end;
end;

procedure THL7Message.CloneSegment(ASegment: THL7Segment);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.CloneSegment';
var
  LSegment: THL7Segment;
  i: Integer;
begin
  DropMetaData;
  LSegment := AddSegment(ASegment.Definition.Name);
  for i := 0 to ASegment.Fields.Count - 1 do
    begin
    if assigned(LSegment[IntToStr(i + 1)]) then
      begin
      LSegment[IntToStr(i + 1)].Clone(ASegment[IntToStr(i + 1)]);
      end;
    end;
end;

procedure THL7Message.AddMSHForBuild;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.AddMSHForBuild';
var
  LSeg: THL7Segment;
begin
  DropMetaData;
  LSeg := AddSegment('MSH');
  LSeg.FieldByName['VersionID'].AsString := FVersion;
  if FVersion = '2.1' then
    begin
    LSeg.FieldByName['9'].AsString := FMessageType
    end
  else
    begin
    LSeg.FieldByName['9'].Components['2'].AsString := FEvent;
    LSeg.FieldByName['9'].Components['1'].AsString := FMessageType;
    if FVersion >= '2.3.1' then
      begin
      TryLoadStruct;
      if FStructID <> '' then
        begin
        LSeg.FieldByName['9'].Components['3'].AsString := FStructID;
        end;
      end;
    end;
  LSeg.FieldByName['7'].AsDateTime := Now;
  if FMsgID <> '' then
    begin
    LSeg.FieldByName['10'].AsString := FMsgID;
    end;
end;

function THL7Message.GetEvent: String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.GetEvent';
var
  LSeg: THL7Segment;
begin
  Result := '';
  if FEvent <> '' then
    begin
    Result := FEvent
    end
  else
    begin
    LSeg := GetSegment('EVN', 0);
    if assigned(LSeg) then
      begin
      Result := LSeg.FieldByName['1'].AsString;
      end;
    end;
end;

procedure THL7Message.AddValidationNote(ASegment, ACellID, ACellName, AError: String);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.AddValidationNote';
begin
  FValidationNotes.add(ASegment + '-' + ACellID + ' [' + ACellName + ']: ' + AError)
end;

procedure THL7Message.ChangeVersion(ANewVersion: String; ADeleteInvalidContent: Boolean);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.ChangeVersion';
var
  LNewDict: THL7Dictionary;
  i: Integer;
  LSeg: THL7Segment;
  LSegDfn: THL7DictSegment;
begin
  DropMetaData;
  LNewDict := FDicts.Dictionary[ANewVersion];
  for i := FSegments.Count - 1 downto 0 do
    begin
    LSeg := FSegments.Objects[i] as THL7Segment;
    LSegDfn := LNewDict.GetSegment(LSeg.FCode);
    if (LSegDfn = NIL) and ADeleteInvalidContent then
      begin
      FSegments.Delete(i)
      end
    else
      begin
      LSeg.ChangeVersion(LNewDict, ADeleteInvalidContent, LSegDfn);
      end;
    end;
  FDict := LNewDict;
  FVersion := ANewVersion;
  LSeg := GetSegment('MSH', 0);
  if assigned(LSeg) then
    begin
    LSeg.Element['12'].AsString := FVersion
    end;
end;

procedure THL7Message.SetStructID(const AValue: String);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.SetStructID';
begin
  DropMetaData;
  FStructID := AValue;
  FStructure := FDict.GetStructure(AValue);
  if FAddStructName and (assigned(GetSegment('MSH', 0))) and (assigned(GetSegment('MSH', 0).Element['9-3'])) then
    GetSegment('MSH', 0).Element['9-3'].AsString := FStructID;
end;

function THL7Message.TryLoadStruct: Boolean;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.TryLoadStruct';
var
  LEvent: THL7DictEvent;
  LMsg: THL7DictMessageStruct;
  s: String;
  i: Integer;
begin
  DropMetaData;
  Result := False;
  LEvent := FDict.GetEvent(FEvent);
  if assigned(LEvent) then
    begin
    s := '';
    for i := 0 to LEvent.FMessageTypes.Count - 1 do
      begin
      if SameText(LEvent.FMessageTypes[i], FMessageType) then
        begin
        if s <> '' then
          Result := False
        else
          begin
          LMsg := LEvent.FMessageTypes.Objects[i] as THL7DictMessageStruct;
          if assigned(LMsg) then
            s := LMsg.FName
          else
            s := '?';
          Result := True;
          end;
        end;
      end;
    if Result then
      SetStructID(s);
    end
  else
    begin
    if FMessageType = 'ACK' then
      begin
      SetStructID('ACK');
      end;
    end;
end;

function THL7Message.InsertSegment(AIndex: Integer; ACode: String): THL7Segment;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.InsertSegment';
begin
  DropMetaData;
  Result := THL7Segment.Create(ACode, self);
  Result.FDefinition := FDict.GetSegment(ACode);
  Result.BuildFields;
  Segments.InsertObject(AIndex, ACode, Result);
end;

function THL7Message.CountSegment(ACode: String): Integer;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.CountSegment';
var
  i: Integer;
begin
  Result := 0;
  for i := 0 to FSegments.Count - 1 do
    begin
    if Sametext(FSegments[i], ACode) then
      begin
      inc(Result);
      end;
    end;
end;

procedure THL7Message.Validate(AOptions: TValidationOptionSet);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.Validate';
var
  i: Integer;
begin
{  if (voSegmentOrder in AOptions) then
    begin
    BuildSegmentMap;
    end;}
  for i := 0 to FSegments.Count - 1 do
    begin
    (FSegments.Objects[i] as THL7Segment).Validate(self, AOptions);
    end;
end;

procedure THL7Message.BuildSegmentMap(AOptions: THL7EncodingOptionSet);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.BuildSegmentMap';
var
  LSegIndex: Integer;
begin
  assert(Self.testValid(THL7Message), ASSERT_LOCATION + ': self is not valid');
  assert(self.FStructure.TestValid(THL7DictMessageStruct), ASSERT_LOCATION + ': Structure is not valid');
  DropMetaData;
  LSegIndex := 0;
  FSegmentMap := FStructure.FSegmentMap.BuildSegmentMap('Root', FSegments, LSegIndex, AOptions, False);
  assert(assigned(FSegmentMap), ASSERT_LOCATION + ': Unable to build a segment Map?');

  if LSegIndex < FSegments.Count then
    begin
    raise EHL7SegmentOrderException.Create('The message "' + FMsgID + '" contained some segments not included in the message segment list. The First Segment is "' + FSegments[LSegIndex] + '" (#' + IntToStr(LSegIndex) + ')');
    end;
end;

procedure THL7Message.BuildXMLSegmentMap(AOptions: THL7EncodingOptionSet);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.BuildSegmentMap';
var
  LSegIndex: Integer;
begin
  assert(Self.testValid(THL7Message), ASSERT_LOCATION + ': self is not valid');
  assert(self.FStructure.TestValid(THL7DictMessageStruct), ASSERT_LOCATION + ': Structure is not valid');
  DropMetaData;
  LSegIndex := 0;
  if assigned(FStructure) then
    begin
    if not assigned(FStructure.FXMLMap) then
      begin
      FStructure.LoadXMLMap;
      end;
    if Assigned(FStructure.FXMLMap) then
      begin
      FSegmentMap := FStructure.FXMLMap.BuildSegmentMap('Root', FSegments, LSegIndex, AOptions, False);
      assert(assigned(FSegmentMap), ASSERT_LOCATION + ': Unable to build a segment Map?');

      if LSegIndex < FSegments.Count then
        begin
        raise EHL7SegmentOrderException.Create('The message "' + FMsgID + '" contained some segments not included in the message segment list. The First Segment is "' + FSegments[LSegIndex] + '" (#' + IntToStr(LSegIndex) + ')');
        end;
      end;
    end;
end;

procedure THL7Message.DropMetaData;
begin
  FreeAndNil(FSegmentMap);
end;

procedure THL7Message.ResolveVariableTypes;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Message.ResolveVariableTypes';
var
  i: Integer;
  s: String;
begin
  for i := 0 to FSegments.Count - 1 do
    begin
    if FSegments[i] = 'OBX' then
      begin
      s := ((FSegments.Objects[i] as THL7Segment).FFields.Items[1] as THL7DataElement).AsString;
      if s = '' then
        begin
        s := 'ST';
        end;
      ((FSegments.Objects[i] as THL7Segment).FFields.Items[4] as THL7DataElement).SetType(s);
      end;
    end;
end;

function THL7Message.GetSegmentByIndex(AIndex: Integer): THL7Segment;
begin
  Result := FSegments.objects[AIndex] as THL7Segment;
end;

function THL7Message.GetSegmentCount: Integer;
begin
  Result := FSegments.Count;
end;

{ THL7DictEvent }

constructor THL7DictEvent.Create(ADict: THL7Dictionary);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictEvent.Create';
begin
  inherited;
  FDesc := '';
  FMessageTypes := THL7StringList.Create(False);
end;

destructor THL7DictEvent.Destroy;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictEvent.Destroy';
begin
  FreeAndNil(FMessageTypes);
  inherited;
end;

function THL7DictEvent.ListMessageTypes: String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictEvent.ListMessageTypes';
var
  i: Integer;
begin
  Result := '';
  for i := 0 to FMessageTypes.Count - 1 do
    begin
    CommaAdd(Result, (FMessageTypes.objects[i] as THL7DictMessageStruct).FName);
    end;
end;

function THL7DictEvent.View(AURLPrefix: String; AOptions: TStringList): String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictEvent.View';
var
  i: Integer;
begin
  Result :=
    '<H2>Event ' + Fname + '</H2>' + crlf +
    FDesc + crlf;
  for i := 0 to FMessageTypes.Count - 1 do
    begin
    Result := Result + '<p><hr><h3>' + FMessageTypes[i] + ': ';
    if assigned(FMessageTypes.objects[i]) then
      begin
      Result := Result + (FMessageTypes.objects[i] as THL7DictMessageStruct).FDesc + '</h3>' + crlf +
        '<blockquote>' + crlf +
        (FMessageTypes.objects[i] as THL7DictMessageStruct).View(AURLPrefix, AOptions) +
        '</blockquote>' + crlf;
      end
    else
      Result := Result + ' <span style="color:#800000;">Not Loaded?</span></h3>' + crlf;
    end;
  Result := Result + '<hr>' + crlf;
end;

{ THL7DictionaryList }

constructor THL7DictionaryList.Create;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictionaryList.Create';
begin
  inherited Create;
  FSchema := ASchema;
  FDicts := THL7StringList.Create(True);
  FDicts.Sorted := True;
  FStoredVersions := TStringList.Create;
  FStoredVersions.sorted := True;
  SetDatabase(ADatabase);
  FLock := THL7CriticalSection.Create;
end;

destructor THL7DictionaryList.Destroy;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictionaryList.Destroy';
begin
  FreeAndNil(FStoredVersions);
  FreeAndNil(FDicts);
  FreeAndNil(FDatabase);
  FreeAndNil(FSchema);
  FreeAndNil(FLock);
  inherited;
end;

function THL7DictionaryList.GetDictionary(AVersion: String): THL7Dictionary;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictionaryList.GetDictionary';
var
  i: Integer;
begin
  repeat
    FLock.Enter;
    try
      Result := NIL;
      if FDicts.Find(AVersion, i) then
        Result := FDicts.objects[i] as THL7Dictionary;
      if Result = NIL then
        LoadVersion(AVersion);
    finally
      FLock.Leave;
      end;
  until Result <> NIL;
end;

procedure THL7DictionaryList.LoadVersion(AVersion: String);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictionaryList.LoadVersion';
var
  LDict: THL7Dictionary;
  i: Integer;
begin
  LDict := THL7Dictionary.Create(AVersion, self);
  FLock.Enter;
  try
    if FDicts.Find(AVersion, i) then
      FreeAndNil(LDict)
    else
      FDicts.AddObject(AVersion, LDict)
    finally
      FLock.Leave;
    end;
end;

procedure THL7DictionaryList.SetDatabase(ADatabase: THL7DictionaryDatabase);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictionaryList.SetDatabase';
begin
  FDatabase := ADatabase;
  if ADatabase = NIL then
    begin
    FDicts := NIL;
    FreeAndNil(FStoredVersions);
    FStoredVersions := NIL;
    raise EBaseHL7Exception.Create(hecNoDictionary, 'Can not make Dictionary list without DB');
    end;
  FDatabase.ListVersions(FStoredVersions);
end;

function THL7DictionaryList.Versions: String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictionaryList.Versions';
begin
  Result := FDicts.CommaText;
end;

{ THL7DictComponent }

constructor THL7DictComponent.Create(ADict: THL7Dictionary);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictComponent.Create';
begin
  inherited;
  FTableObj := NIL;
end;

destructor THL7DictComponent.Destroy;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictComponent.Destroy';
begin
  inherited;
end;

function THL7DictComponent.GetDataType: THL7DictDataType;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictComponent.GetDataType';
begin
  Result := FDataType;
end;

function THL7DictComponent.View(AURLPrefix: String; AOptions: TStringList): String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictComponent.View';
begin
  Result := '<td valign="top">' + CellString(FDescription) + '</td>' +
    '<td>&nbsp;&nbsp;</td>';

  if assigned(FStruct) and (FStruct.FComponents.Count > 0) then
    begin
    Result := Result +
      '<td valign="top"><a href="' + AURLPrefix + 'view=structure&structureid=' + FStruct.Fname + '">' + FDataType.View(AURLPrefix, AOptions) + '</a></td>' +
      '<td>&nbsp;&nbsp;</td>'
    end
  else if assigned(FDataType) then
    begin
    Result := Result +
      '<td valign="top">' + FDataType.View(AURLPrefix, AOptions) + '</td>' +
      '<td>&nbsp;&nbsp;</td>'
    end
  else
    Result := Result +
      '<td valign="top">Unknown Data Type</td>' +
      '<td>&nbsp;&nbsp;</td>';

  if FTableID <> 0 then
    begin
    if not assigned(FTableObj) then
      FTableObj := FDictionary.FTables[FTableID] as THL7DictTable;
    Result := Result + '<td valign="top"><a href="' + AURLPrefix + 'view=table&tableid=' + IntToStr(FTableID) + '">' + FTableObj.FDesc + '</a></td>';
    end
  else
    Result := Result + '<td valign="top" colspan=3>&nbsp;</td>';

  if assigned(FTableObj) and (AOptions.values['ExpandTable'] = 'yes') then
    Result := Result + '<td valign="top">&nbsp;&nbsp;</td><td valign="top">' + FTableObj.HTMLView + '</td>'
end;

{ THL7DictStructure }

constructor THL7DictStructure.Create(ADict: THL7Dictionary);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictStructure.Create';
begin
  inherited;
  FComponents := TStringList.Create;
end;

destructor THL7DictStructure.Destroy;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictStructure.Destroy';
begin
  FreeAndNil(FComponents);
  inherited;
end;

function THL7DictStructure.GetComponents(AName: String): THL7DictComponent;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictStructure.GetComponents';
begin
  raise EBaseHL7Exception.Create(hecHl7LibraryError, 'not done yet');
end;

function THL7DictStructure.View(AURLPrefix: String; AOptions: TStringList): String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictStructure.View';
var
  i: Integer;
begin
  if AOptions.values['quick'] = 'yes' then
    begin
    if FComponents.Count = 0 then
      begin
      if FDictionary.FDataTypes.find(FDataTypeCode, i) then
        begin
        if AOptions.Values['quickstruct'] = 'yes' then
          begin
          Result := '<td style="vertical-align:top;">' + CellString(FDataTypeCode) + ':</td><td style="vertical-align:top;">&nbsp;</td><td style="vertical-align:top;"><i>(' + FDesc + ')</i></td>'
          end
        else
          begin
          Result := '<td style="vertical-align:top;">' + (FDictionary.FDataTypes.objects[i] as THL7DictDataType).View(AURLPrefix, AOptions) + '</td>'
          end;
        end
      else
        begin
        Result := '<td style="vertical-align:top;">' + CellString(FDataTypeCode) + '</td><td style="vertical-align:top;">:' + CellString(FDataTypeCode) + '</td>'
        end;
      end
    else
      begin
      if AOptions.Values['quickstruct'] = 'yes' then
        begin
        Result := '<td style="vertical-align:top;">' + CellString(FDataTypeCode) + ':</td><td style="vertical-align:top;"><a href="' + AURLPrefix + 'view=structure&structureid=' + FName + '">Complex</a></td><td style="vertical-align:top;"><i>(' + FDesc + ')</i></td>'
        end
      else
        begin
        Result := '<td style="vertical-align:top;">' + CellString(FDataTypeCode) + ': <a href="' + AURLPrefix + 'view=structure&structureid=' + FName + '">Complex</a> <i>(' + FDesc + ')</i></td>'
        end;
      end;
    end
  else
    begin
    if (FComponents.Count = 0) then
      begin
      Result := 'Error : how did you get here?'
      end
    else
      begin
      AOptions.values['ExpandTable'] := 'yes';
      Result :=
        '<span style="font-weight:bold;">Data Structure Definition</span> for ' + FName + '<p>' + crlf +
        FDesc + '<p>' + crlf +
        'Components:<br><br>' + crlf +
        '<table  border=0 cellspacing=0 cellpadding=1 class="tbl">' + crlf +
        '<tr>' +
        '<td style="vertical-align:top; font-weight:bold;">ID</td>' +
        '<td style="vertical-align:top; font-weight:bold;">&nbsp;&nbsp;</td>' +
        '<td style="vertical-align:top; font-weight:bold;">Name</td>' +
        '<td style="vertical-align:top; font-weight:bold;">&nbsp;&nbsp;</td>' +
        '<td style="vertical-align:top; font-weight:bold;">Data Type</td>' +
        '<td style="vertical-align:top; font-weight:bold;">&nbsp;&nbsp;</td>' +
        '<td style="vertical-align:top; font-weight:bold;">Table</td>' +
        '<td style="vertical-align:top; font-weight:bold;">&nbsp;</td>' +
        '<td style="vertical-align:top; font-weight:bold;">Table Values</td>' +
        '</tr>' + crlf;
      for i := 0 to FComponents.Count - 1 do
        begin
        if Odd(i) then
          begin
          Result := Result +
            '<tr><td style="vertical-align:top;">' + IntToStr(i + 1) + '</td>' +
            '<td style="vertical-align:top;">&nbsp;&nbsp;</td>' +
            (FComponents.objects[i] as THL7DictComponent).View(AURLPrefix, AOptions) + '</tr>' + crlf
          end
        else
          begin
          Result := Result +
            '<tr class=dicttblbg><td style="vertical-align:top;">' + IntToStr(i + 1) + '</td>' +
            '<td style="vertical-align:top;">&nbsp;&nbsp;</td>' +
            (FComponents.objects[i] as THL7DictComponent).View(AURLPrefix, AOptions) + '</tr>' + crlf;
          end;
        end;
      Result := Result + '</table>';
      end;
    end;
end;

{ THL7Component }

constructor THL7Component.Create;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.Create';
begin
  inherited Create(ALevel, AIndex);
  FDefined := False;
  FSubComponents := TObjectList.Create;
end;

destructor THL7Component.Destroy;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.Destroy';
begin
  FreeAndNil(FSubComponents);
  inherited;
end;

function THL7Component.GetSubComponentCount: Integer;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.GetSubComponentCount';
begin
  Result := FSubComponents.Count;
end;

function THL7Component.GetSubComponents(s: String): THL7Component;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.GetSubComponents';
var
  i: Integer;
begin
  i := StrToIntWithError(s, 'Sub Component Index') - 1;
  if (i < 0) or (i >= FSubComponents.Count) then
    Result := NIL
  else
    Result := FSubComponents.Items[i] as THL7Component;
end;

function THL7Component.BuildView(Ahtml, Afull: Boolean; APrefix : string; Aoffset, AcIndex: Integer): String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.BuildView';
var
  i: Integer;
begin
  Result := LeftPad(Ahtml, Aoffset) + LeftPad(Ahtml, 4, APrefix + '.' + IntToStr(AcIndex)) + ' ';
  if assigned(FDictComp) then
    Result := Result + FDictComp.FDescription
  else
    Result := Result + 'unknown';
  if FSubComponents.Count > 0 then
    begin
    Result := Result + '<br>' + crlf;
    for i := 0 to FSubComponents.Count - 1 do
      begin
      Result := Result + (FSubComponents.Items[i] as THL7Component).BuildView(Ahtml, Afull, APrefix + '.' + IntToStr(AcIndex), Aoffset + 4, i+1);
      end;
    end
  else
    begin
    if Ahtml then
      Result := Result + '="' + FRawContent + '"<br>' + crlf
    else
      Result := Result + '=' + FRawContent + crlf;
    end;
end;

function THL7Component.GetTable: THL7DictTable;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.GetTable';
begin
  if Assigned(FDictComp) then
    Result := FDictComp.FTableObj
  else
    Result := NIL;
end;

function THL7Component.GetFieldName: String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.GetFieldName';
begin
  if Assigned(FDictComp) then
    Result := FDictComp.FDescription
  else
    Result := 'Unknown';
end;

function THL7Component.MyName: String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.MyName';
begin
  Result := FParent.MyName + '.' + IntToStr(FElementIndex);
end;

procedure THL7Component.ClearAll;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.ClearAll';
var
  i: Integer;
begin
  inherited;
  for i := 0 to FSubComponents.Count - 1 do
    (FSubComponents.Items[i] as THL7CommonDataCell).ClearAll;
end;

function THL7Component.GetFirstChild: THL7CommonDataCell;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.GetFirstChild';
begin
  if GetHasChildren then
    Result := FSubComponents.Items[0] as THL7CommonDataCell
  else
    Result := NIL;
end;

function THL7Component.GetHasChildren: Boolean;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.GetHasChildren';
begin
  if self = NIL then
    Result := False
  else
    Result := FSubComponents.Count > 0;
end;

function THL7Component.AddSubComponent(ANum: Integer): THL7Component;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.AddSubComponent';
var
  i: Integer;
  LSubComp: THL7Component;
begin
  Result := NIL;
  if (ANum > 100) or (ANum < 1) then
    exit;
  Result := SubComponents[IntToStr(ANum)];
  if Result <> NIL then
    exit;
  for i := 1 to ANum do
    begin
    LSubComp := SubComponents[IntToStr(i)];
    if LSubComp = NIL then
      begin
      LSubComp := THL7Component.Create(Flevel + 1, i);
      LSubComp.FParent := self;
      LSubComp.FField := FField;
      LSubComp.FDefined := False;
      FSubComponents.add(LSubComp);
      if i = 1 then
        begin
        // we just added the first component.
        LSubComp.FRawContent := FRawContent;
        LSubComp.FDefined := FDefined;
        FRawContent := '';
        FDefined := False;
        end;
      end;
    end;
  Result := SubComponents[IntToStr(ANum)];
end;

function THL7Component.GetDefined: Boolean;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.GetDefined';
var
  i: Integer;
begin
  if self = NIL then
    Result := False
  else
    begin
    for i := 0 to FSubComponents.Count - 1 do
      begin
      Result := (FSubComponents.Items[i] as THL7Component).GetDefined;
      if Result then
        exit;
      end;
    Result := inherited GetDefined;
    end
end;

procedure THL7Component.MakeForBuild;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.MakeForBuildTHL7Component.MakeForBuild';
var
  i: Integer;
  LSub: THL7Component;
begin
  assert(assigned(FDictComp), ASSERT_LOCATION + ': Dict Comp is not valid');
  if assigned(FDictComp.FStruct) and (FDictComp.FStruct.FComponents.Count > 0) then
    begin
    for i := 0 to FDictComp.FStruct.FComponents.Count - 1 do
      begin
      LSub := THL7Component.Create(FLevel + 1, i+1);
      LSub.FField := FField;
      LSub.FParent := self;
      LSub.FDictComp := FDictComp.FStruct.FComponents.objects[i] as THL7DictComponent;
      LSub.MakeForBuild;
      FSubComponents.Add(LSub);
      end;
    end;
end;

procedure THL7Component.Clone(AComp : THL7Component);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.MakeForBuildTHL7Component.Clone';
var
  i : integer;
begin
  FRawContent := AComp.FRawContent;
  FDefined := AComp.FDefined;
  for i := 0 to AComp.FSubComponents.Count - 1 do
    begin
    if assigned(GetSubComponents(IntToStr(i))) then
      begin
      GetSubComponents(IntToStr(i)).Clone(AComp.GetSubComponents(IntToStr(i)));
      end;
    end;
end;

function THL7Component.GetChildCount: integer;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.MakeForBuildTHL7Component.GetChildCount';
begin
  result := FSubComponents.count;
end;

function THL7Component.GetNthChild(i: integer): THl7CommonDataCell;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.MakeForBuildTHL7Component.GetNthChild';
var
  LSubComp : THL7Component;
begin
  assert(self.TestValid(THL7Component), ASSERT_LOCATION+': self is not valid');
  assert(i >= 0, ASSERT_LOCATION+': i < 0');
  while i >= FSubComponents.Count do
    begin
    LSubComp := THL7Component.Create(FLevel + 1, i+1);
    LSubComp.FField := FField;
    LSubComp.FParent := Self;
    LSubComp.FDefined := False;
    LSubComp.FDictComp := NIL;
    FSubComponents.Add(LSubComp);
    if FSubComponents.Count = 1 then
      begin
      // we just added the first sub component.
      LSubComp.FRawContent := FRawContent;
      LSubComp.FDefined := FDefined;
      FRawContent := '';
      FDefined := False;
      end;
    end;
  Result := FSubComponents.Items[i] as THL7Component;
end;

function THL7Component.GetEscapable(AEscapeMode : boolean): boolean;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Component.MakeForBuildTHL7Component.GetEscapable';
begin
  result := assigned(FDictComp) and
            assigned(FDictComp.FStruct) and
            assigned(FDictComp.FStruct.DataType) and
            FDictComp.FStruct.DataType.Escapable(AEscapeMode);
end;

{ THL7DictDataType }

constructor THL7DictDataType.Create(ADict: THL7Dictionary);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictDataType.Create';
begin
  inherited;
end;

destructor THL7DictDataType.Destroy;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictDataType.Destroy';
begin
  inherited;
end;

function THL7DictDataType.Escapable(AEscapeMode : boolean): Boolean;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictDataType.Escapable';
begin
  if FName = '*' then
    begin
    // this is a work around for OBX-5, where the data type depends on another field.
    // we will escape anyway. This will be reviewed in the future
    Result := True
    end
  else
    begin
    Result := ((AEscapeMode = FULL_ESCAPING) and (FName = 'ST')) or (FName = 'TX') or (FName = 'FT') or (FName = 'CF');
    end;
end;

function THL7DictDataType.GetDesc: String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictDataType.GetDesc';
begin
  Result := FDesc;
end;

function THL7DictDataType.View(AURLPrefix: String; AOptions: TStringList): String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictDataType.View';
begin
  if FLength <> 0 then
    Result := FName + ': ' + FDesc + ' (' + IntToStr(FLength) + ')'
  else
    Result := FName + ': ' + FDesc;
end;

{ THL7DictionaryDatabase }

procedure THL7DictionaryDatabase.TransferDatabase(ADest: THL7DictionaryDatabase; AWipe: Boolean);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictionaryDatabase.TransferDatabase';
var
  LList: TStringList;
  i: Integer;
begin
  ADest.PrepareForLoad(AWipe);
  LList := TStringList.Create;
  try
    ListVersions(LList);
    for i := 0 to LList.Count - 1 do
      TransferVersion(LList[i], Adest);
  finally
    FreeAndNil(LList);
    end;
  ADest.DoneLoading(FOnTransferProgress);
end;

procedure THL7DictionaryDatabase.TransferVersion(AVersion: String; ADest: THL7DictionaryDatabase);
const 
  ASSERT_LOCATION = 'THL7DictionaryDatabase.TransferDatabaseTHL7DictionaryDatabase.TransferDatabaseHL7_Dict.THL7DictionaryDatabase.TransferVersion';
var
  LDesc: String;
  t: Integer;
  I: Integer;
  i1: Integer;
  i2: Integer;
  i3: Integer;
  s1: String;
  s2: String;
  s3: String;
  s4: String;
  s5: String;
  b1: Boolean;
  b2: Boolean;
  p: pointer;
  LWantAbort: Boolean;
begin
  if not VersionDefined(AVersion, LDesc) then
    raise EHL7LibraryException.Create(hecHL7LibraryError, 'Version is not defined (impossible)');
  ADest.AddVersion(AVersion, LDesc);

  t := CountFields(AVersion);
  i := 0;
  p := StartLoadFields('', AVersion);
  try
    while GetNextField(p, s3, i1, s1, s2, i2, i3) do
      begin
      FOnTransferProgress(self, AVersion, 'Fields', i, t, LWantAbort);
      if LWantAbort then
        Abort;
      inc(i);
      ADest.AddField(AVersion, s3, i1, s1, s2, i2, i3);
      end;
  finally
    CloseLoadFields(p);
    end;

  t := CountComponents(AVersion);
  i := 0;
  p := StartLoadComponents(AVersion);
  try
    while GetNextComponent(p, s1, i1, s2, i2) do
      begin
      FOnTransferProgress(self, AVersion, 'Components', i, t, LWantAbort);
      if LWantAbort then
        Abort;
      inc(i);
      ADest.AddComponent(AVersion, s1, i1, s2, i2);
      end;
  finally
    CloseLoadComponents(p);
    end;

  t := CountDataElements(AVersion);
  i := 0;
  p := StartLoadDataElements(AVersion);
  try
    while GetNextElement(p, s1, s2, i1, i2, i3) do
      begin
      FOnTransferProgress(self, AVersion, 'Data Elements', i, t, LWantAbort);
      if LWantAbort then
        Abort;
      inc(i);
      ADest.AddDataElement(AVersion, s1, s2, i1, i2, i3);
      end;
  finally
    CloseLoadDataElements(p);
    end;

  t := CountDataTypes(AVersion);
  i := 0;
  p := StartLoadDataTypes(AVersion);
  try
    while GetNextDataType(p, s1, s2, i1) do
      begin
      FOnTransferProgress(self, AVersion, 'Data Types', i, t, LWantAbort);
      if LWantAbort then
        Abort;
      inc(i);
      ADest.AddDataType(AVersion, s1, s2, i1);
      end;
  finally
    CloseLoadDataTypes(p);
    end;

  t := CountSegments(AVersion);
  i := 0;
  p := StartLoadSegment('', AVersion);
  try
    while GetNextSegment(p, s1, s2) do
      begin
      FOnTransferProgress(self, AVersion, 'Segments', i, t, LWantAbort);
      if LWantAbort then
        Abort;
      inc(i);
      ADest.AddSegment(AVersion, s1, s2);
      end;
  finally
    CloseLoadSegments(p);
    end;

  t := CountStructures(AVersion);
  i := 0;
  p := StartLoadStructures(AVersion);
  try
    while GetNextStructure(p, s1, s2, s3, i1) do
      begin
      FOnTransferProgress(self, AVersion, 'Structures', i, t, LWantAbort);
      if LWantAbort then
        Abort;
      inc(i);
      ADest.AddStructure(AVersion, s1, s2, s3, i1);
      end;
  finally
    CloseLoadStructures(p);
    end;

  t := CountStructureComps(AVersion);
  i := 0;
  p := StartLoadStructureComps(AVersion);
  try
    while GetNextStructureComp(p, s1, i1, i2) do
      begin
      FOnTransferProgress(self, AVersion, 'Structure Components', i, t, LWantAbort);
      if LWantAbort then
        Abort;
      inc(i);
      ADest.AddStructureComp(AVersion, s1, i1, i2);
      end;
  finally
    CloseLoadStructureComps(p);
    end;

  t := CountTables(AVersion);
  i := 0;
  p := StartLoadTables(AVersion);
  try
    while GetNextTable(p, s1, i1) do
      begin
      FOnTransferProgress(self, AVersion, 'Tables', i, t, LWantAbort);
      if LWantAbort then
        Abort;
      inc(i);
      ADest.AddTable(AVersion, s1, i1);
      end;
  finally
    CloseLoadTables(p);
    end;

  t := CountTableItems(AVersion);
  i := 0;
  p := StartLoadTableItems(AVersion);
  try
    while GetNextTableItem(p, i1, i2, s1, s2) do
      begin
      FOnTransferProgress(self, AVersion, 'Table Items', i, t, LWantAbort);
      if LWantAbort then
        Abort;
      inc(i);
      try
        ADest.AddTableItem(AVersion, i1, i2, s1, s2);
      except
        // nothing
        end;
      end;
  finally
    CloseLoadTableitems(p);
    end;

  t := CountEvents(AVersion);
  i := 0;
  p := StartLoadEventList(AVersion);
  try
    while GetNextEvent(p, s1, s2) do
      begin
      FOnTransferProgress(self, AVersion, 'Events', i, t, LWantAbort);
      if LWantAbort then
        Abort;
      inc(i);
      ADest.AddEvent(AVersion, s1, s2);
      end;
  finally
    CloseLoadEventList(p);
    end;

  t := CountEventDetails(AVersion);
  i := 0;
  p := StartLoadEventDetails(AVersion);
  try
    while GetNextEventDetails(p, s1, s2, s3, s4, s5, i1) do
      begin
      FOnTransferProgress(self, AVersion, 'Event Details', i, t, LWantAbort);
      if LWantAbort then
        Abort;
      inc(i);
      ADest.AddEventDetails(AVersion, s1, s2, s3, s4, s5, i1);
      end;
  finally
    CloseLoadEventDetails(p);
    end;

  t := CountMsgStructs(AVersion);
  i := 0;
  p := StartLoadMsgStructs(AVersion);
  try
    while GetNextMsgStructs(p, s1, s2, s3, s4, s5) do
      begin
      FOnTransferProgress(self, AVersion, 'Structures', i, t, LWantAbort);
      if LWantAbort then
        Abort;
      inc(i);
      ADest.AddMsgStruct(AVersion, s1, s2, s3, s4, s5);
      end;
  finally
    CloseLoadMsgStructs(p);
    end;

  t := CountMsgStructSegments(AVersion);
  i := 0;
  p := StartLoadMsgStructSegments(AVersion);
  try
    while GetNextMsgStructSegments(p, s1, i1, s2, s3, b1, b2) do
      begin
      FOnTransferProgress(self, AVersion, 'Struct Segments', i, t, LWantAbort);
      if LWantAbort then
        Abort;
      inc(i);
      ADest.AddMsgStructSegment(AVersion, s1, i1, s2, s3, b1, b2);
      end;
  finally
    CloseLoadMsgStructSegments(p);
    end;

  t := CountEvntMsgSegments(AVersion);
  i := 0;
  p := StartLoadEvntMsgSegments(AVersion);
  try
    while GetNextEvntMsgSegments(p, s1, i1, s2, s3, b1, b2) do
      begin
      FOnTransferProgress(self, AVersion, 'Struct Segments', i, t, LWantAbort);
      if LWantAbort then
        Abort;
      inc(i);
      ADest.AddEvntMsgSegment(AVersion, s1, i1, s2, s3, b1, b2);
      end;
  finally
    CloseLoadEvntMsgSegments(p);
    end;
end;

{ THL7AbstractITS }

constructor THL7AbstractITS.Create;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7AbstractITS.Create';
begin
  inherited;
  FIsMessage := False;
end;

{ THL7ER7 }

function THL7ER7.Escape(AContent: String): String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7AbstractITS.Escape';
var
  i: Integer;
  Llen : integer;
begin
  Result := '';
  StringAppendStart(result, LLen);
  for i := 1 to length(AContent) do
    begin
    if AContent[i] = FSegOwner.FFieldDelimiter then
      begin
      StringAppend(Result, FSegOwner.FEscapeCharacter + 'F' + FSegOwner.FEscapeCharacter, LLen);
      end
    else if AContent[i] = FSegOwner.FComponentDelimiter then
      begin
      StringAppend(Result, FSegOwner.FEscapeCharacter + 'S' + FSegOwner.FEscapeCharacter, LLen);
      end
    else if AContent[i] = FSegOwner.FSubComponentDelimiter then
      begin
      StringAppend(Result, FSegOwner.FEscapeCharacter + 'T' + FSegOwner.FEscapeCharacter, LLen);
      end
    else if AContent[i] = FSegOwner.FRepetitionDelimiter then
      begin
      StringAppend(Result, FSegOwner.FEscapeCharacter + 'R' + FSegOwner.FEscapeCharacter, LLen);
      end
    else if AContent[i] = FSegOwner.FEscapeCharacter then
      begin
      StringAppend(Result, FSegOwner.FEscapeCharacter + 'E' + FSegOwner.FEscapeCharacter, LLen);
      end
    else if AContent[i] = INTERNAL_ESCAPE_CHAR then
      begin
      StringAppend(Result, FSegOwner.FEscapeCharacter, LLen);
      end
    else
      begin
      StringAppend(Result, AContent[i], LLen);
      end
    end;
  StringAppendClose(result, LLen);
end;

function THL7ER7.Encode(AMsg: THL7SegmentOwner; AOptions: THL7EncodingOptionSet; ASpecificSegment: THL7Segment = NIL): THL7Packet;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7ER7.Encode';
var
  i: Integer;
begin
  FSegOwner := AMsg;
  if assigned(ASpecificSegment) then
    Result := EncodeSegment(ASpecificSegment)
  else
    begin
    Result := '';
    for i := 0 to Amsg.FSegments.Count - 1 do
      Result := Result + EncodeSegment(Amsg.FSegments.objects[i] as THL7Segment);
    end;
end;


function THL7ER7.EncodeSegment(ASeg: THL7Segment): String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7ER7.EncodeSegment';
var
  i: Integer;
  s: String;
begin
  Result := ASeg.FCode;
  if (Result = 'MSH') or (Result = 'FHS') or (Result = 'BHS') then
    begin
    Result := Result + FSegOwner.FFieldDelimiter + FSegOwner.FComponentDelimiter + FSegOwner.FRepetitionDelimiter + FSegOwner.FEscapeCharacter + FSegOwner.FSubComponentDelimiter;
    s := '';
    for i := 2 to Aseg.FFields.Count - 1 do
      begin
      s := s + FSegOwner.FFieldDelimiter + EncodeDataElement(Aseg.FFields[i] as THL7DataElement);
      if (Aseg.FFields[i] as THL7DataElement).GetDefined then
        begin
        Result := Result + s;
        s := '';
        end
      end
    end
  else
    begin
    s := '';
    for i := 0 to Aseg.FFields.Count - 1 do
      begin
      s := s + FSegOwner.FFieldDelimiter + EncodeDataElement(Aseg.FFields[i] as THL7DataElement);
      if ((Aseg.FFields[i] as THL7DataElement).GetDefined) or (i = 0) then
        begin
        Result := Result + s;
        s := '';
        end
      end
    end;
  Result := Result + #13;
end;

function THL7ER7.EncodeDataElement(Ade: THL7DataElement): String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7ER7.EncodeDataElement';
var
  i: Integer;
  s: String;
  LDef: Boolean;
begin
  // this may become relevent if a programmer has assigned something to the
  // field, or if FComponents.count <> 0 it will be not Relevent
  if not Ade.GetHasChildren then
    LDef := Ade.FDefined
  else
    begin
    LDef := False;
    for i := 0 to Ade.FComponents.Count - 1 do
      begin
      if LDef then
        break;
      LDef := (Ade.FComponents.objects[i] as THL7Component).GetDefined;
      end;
    end;
  if not LDef then
    Result := ''
  else
    begin
    if not Ade.GetHasChildren then
      begin
      if Ade.FDefined then
        if Ade.FRawContent <> '' then
          begin
          if not FSegOwner.FSuppressEscaping and Ade.GetEscapable(FULL_ESCAPING) then
            begin
            Result := Escape(Ade.FRawContent)
            end
          else
            begin
            Result := Ade.FRawContent;
            end;
          end
        else
          Result := '""'
      else
        Result := '';
      end
    else
      begin
      Result := EncodeComponent(Ade.FComponents.objects[0] as THL7Component);
      s := '';
      for i := 1 to Ade.FComponents.Count - 1 do
        begin
        s := s + FSegOwner.FComponentDelimiter + EncodeComponent(Ade.FComponents.objects[i] as THL7Component);
        if (Ade.FComponents.objects[i] as THL7Component).GetDefined then
          begin
          Result := Result + s;
          s := '';
          end;
        end;
      end;
    end;
  // recursive call to this routine. Repeat Elements will only be encoded if
  // the first in the list is defined
  for i := 0 to Ade.FRepeatList.Count - 1 do
    Result := Result + FSegOwner.FRepetitionDelimiter + EncodeDataElement(Ade.FRepeatList[i] as THL7DataElement);
end;

function THL7ER7.EncodeComponent(AComp: THL7Component): String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7ER7.EncodeComponent';
var
  i: Integer;
  s: String;
  ADelimiter : Char;
begin
  ADelimiter := FSegOwner.FSubComponentDelimiter;
  if (AComp.FLevel <= 2) and AComp.GetHasChildren then
    begin
    Result := EncodeComponent(AComp.FSubComponents[0] as THL7Component);
    s := '';
    for i := 1 to AComp.FSubComponents.Count - 1 do
      begin
      s := s + ADelimiter + EncodeComponent(AComp.FSubComponents[i] as THL7Component);
      if (AComp.FSubComponents[i] as THL7Component).GetDefined then
        begin
        Result := Result + s;
        s := '';
        end;
      end;
    end
  else
    begin
    if AComp.FDefined then
      begin
      if AComp.FRawContent = '' then
        Result := '""'
      else if not FSegOwner.FSuppressEscaping and AComp.GetEscapable(FULL_ESCAPING) then
        begin
        Result := Escape(AComp.FRawContent)
        end
      else
        begin
        Result := AComp.FRawContent;
        end;
      end
    else
      begin
      Result := '';
      end;
    end;
end;

function THL7ER7.UnEscape(AContent: String): String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7ER7.UnEscape';
var
  s: String;
  i: Integer;
  j: Integer;
  LLen : integer;
begin
   Result := '';
  StringAppendStart(result, LLen);
  i := 1;
  while i <= length(AContent) do
    begin
    if AContent[i] = FSegOwner.FEscapeCharacter then
      begin
      inc(i);
      j := i;
      while (i <= length(AContent)) and (AContent[i] <> FSegOwner.FEscapeCharacter) do
        begin
        inc(i);
        end;
      if i > Length(AContent) then
        begin
        // ok, well, we guess that it wasn't an escape after all - it wasn't closed
        // People forgot to escape their content fairly often
        StringAppend(result, Substring(AContent, j-1, i), LLen);
        end
      else
        begin
        // we could just assume that the contents are valid, but people are so
        // good at forgetting to escape their content that we'll try to second
        // guess them. One consequence of this code is that if people screw up
        // their escape sequence, we're likely to just not consider it as an
        // escape sequence
        s := Substring(AContent, j, i);
        if Uppercase(s) = 'F' then
          begin
          StringAppend(result, FSegOwner.FFieldDelimiter, Llen);
          end
        else if Uppercase(s) = 'S' then
          begin
          StringAppend(result, FSegOwner.FComponentDelimiter, Llen);
          end
        else if Uppercase(s) = 'T' then
          begin
          StringAppend(result, FSegOwner.FSubComponentDelimiter, Llen);
          end
        else if Uppercase(s) = 'R' then
          begin
          StringAppend(result, FSegOwner.FRepetitionDelimiter, Llen);
          end
        else if Uppercase(s) = 'E' then
          begin
          StringAppend(result, FSegOwner.FEscapeCharacter, Llen);
          end
        else if (s[1] = '.') or (s[i] = 'Z') or (Uppercase(s) = 'H') or (Uppercase(s) = 'N') then
          begin
          //ok, we don't second guess the contents - we assume that they are a valid escape
          StringAppend(result, INTERNAL_ESCAPE_CHAR+s+INTERNAL_ESCAPE_CHAR, Llen);
          end
        else if (Upcase(s[1]) = 'X') then
          begin
          if ((length(s) mod 2) = 1) and AllContentHex(Copy(s, 2, length(s)-1)) then
            begin
            StringAppend(result, INTERNAL_ESCAPE_CHAR+s+INTERNAL_ESCAPE_CHAR, Llen);
            end
          else
            begin
            StringAppend(result, Substring(AContent, j-1, i+1), LLen);
            end;
          end
        else if (Upcase(s[1]) = 'C') or (Upcase(s[1]) = 'M') then
          begin
          if ((Upcase(s[1]) = 'C') and (length(s) = 5)) or ((Upcase(s[1]) = 'M') and (length(s) = 7)) and AllContentHex(Copy(s, 2, length(s)-1)) then
            begin
            StringAppend(result, INTERNAL_ESCAPE_CHAR+s+INTERNAL_ESCAPE_CHAR, Llen);
            end
          else
            begin
            StringAppend(result, Substring(AContent, j-1, i+1), LLen);
            end;
          end
        else
          begin
          StringAppend(result, Substring(AContent, j-1, i+1), LLen);
          end;
        end;
      end
    else
      begin
      StringAppend(result, AContent[i], LLen);
      end;
    inc(i);
    end;
  StringAppendClose(result, LLen);
end;

function THL7ER7.PreDecode: String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7ER7.PreDecode';
var
  s: String;
begin
  // basics: this checks that the MSH appears to be valid, records the delimiters,
  // and checks the version
  s := copy(FPacket, 1, 3);
  if s = 'MSH' then
    FIsMessage := True
  else if (s = 'FHS') or (s = 'BHS') or (s = 'BTS') or (s = 'FTS') then
    FIsMessage := False
  else
    raise EBaseHL7Exception.Create(hecBadMessage, 'Packet "' + copy(FPacket, 1, 12) + '"does not appear to be valid HL7/ER7: starting MSH not found');

  if pos(#13, FPacket) = 0 then
    raise EBaseHL7Exception.Create(hecBadMessage, 'Packet does not appear to be valid HL7/ER7: Segment Delimiter not found');

  FSegOwner.FFieldDelimiter := FPacket[4];
  FSegOwner.FComponentDelimiter := FPacket[5];
  FSegOwner.FRepetitionDelimiter := FPacket[6];
  FSegOwner.FEscapeCharacter := FPacket[7];
  FSegOwner.FSubComponentDelimiter := FPacket[8];
end;


procedure THL7ER7.ExtraDecode(AMsg: THL7SegmentOwner; APacket: THL7Packet);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7ER7.ExtraDecode';
var
  i: Integer;
begin
  FSegOwner := AMsg;
  Fpacket := DosToUnix(APacket);
  if length(Fpacket) > 0 then
    begin
    if FPacket[1] = #13 then
      Delete(FPacket, 1, 1);
    if Fpacket[length(Fpacket)] <> #13 then
      Fpacket := Fpacket + #13;
    end;
  i := 1;
  while (i < length(FPacket)) do
    DecodeSegment(i);
end;

procedure THL7ER7.Decode(AMsg: THL7SegmentOwner; APacket: THL7Packet; AVersionOverride: String; ASegmentLimit: Integer);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7ER7.Decode';
var
  i: Integer;
  LSeg: THL7Segment;
  LMsg: THL7Message;
begin
  FSegOwner := AMsg;

  // some systems are somewhat careless about how they wrap a packet
  // some systems prepend a #13 to the message
  // some fail to append a #13.
  // some even send HL7 segment delimiters as  #13#10 instead of #13
  Fpacket := dostounix(APacket);
  if length(FPacket) > 0 then
    begin
    if FPacket[1] = #13 then
      Delete(FPacket, 1, 1);
    if Fpacket[length(Fpacket)] <> #13 then
      Fpacket := Fpacket + #13;
    end;

  // 1. initial check of MSH: version and delimiters
  PreDecode;
  if FIsMessage then
    begin
    FSegOwner.FVersion := GetStringCell(GetStringCell(GetStringCell(GetStringCell(FPacket, 0, #13), 11, FSegOwner.FFieldDelimiter), 0, FSegOwner.FComponentDelimiter), 0, FSegOwner.FSubComponentDelimiter);
    if FSegOwner.FVersion = '' then
      raise EBaseHL7Exception.Create(hecBadMessage, 'Packet does not appear to be valid HL7/ER7: Version could not be determined');
    end;

  //2. Choose Decoding Version
  if (AVersionOverride = '') then
    AVersionOverride := FSegOwner.FVersion
  else
    FSegOwner.FVersion := AVersionOverride;// make sure reports the right version

  FSegOwner.FDict := FSegOwner.Fdicts[AVersionOverride];
  if not assigned(FSegOwner.FDict) then
    raise EBaseHL7Exception.Create(hecUnsVersion, 'Version ' + AVersionOverride + ' not known');

  // decode MSH
  i := 1;
  DecodeSegment(i);

  if FIsMessage then
    begin
    LMsg := AMsg as THL7Message;

    // post MSH processing
    LSeg := LMsg.FSegments.objects[0] as THL7Segment;
    LMsg.FVersion := LSeg.Element['12'].AsString;
    if LMsg.FVersion = '2.1' then
      begin
      LMsg.FMessageType := LSeg.Element['9'].AsString;
      LMsg.FEvent := '';
      end
    else
      begin
      LMsg.FMessageType := LSeg.Element['9.1'].AsString;
      LMsg.FEvent := LSeg.Element['9.2'].AsString;
      if LMsg.FVersion >= '2.3.1' then
        if LSeg.Element['9.3'].AsString <> '' then
          LMsg.StructName := LSeg.Element['9.3'].AsString
        else
          LMsg.TryLoadStruct;
      end;
    LMsg.FMsgID := LSeg.Element['10'].AsString;

    // 5. decode remaining segments
    while (i < length(FPacket)) and ((ASegmentLimit = 0) or (LMsg.FSegments.Count < ASegmentLimit)) do
      DecodeSegment(i);
    end;
end;

procedure THL7ER7.DecodeSegment(var VCursor: Integer);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7ER7.DecodeSegment';
var
  LSegCode: String;
  i: Integer;
  LSeg: THL7Segment;
  LDe: THL7DataElement;
  LStartPoint: Integer;
begin
  LStartPoint := VCursor;

  if (VCursor + 3 > length(FPacket)) then //we are either missing a #13 or have an invalid segment code
    raise EBaseHL7Exception.Create(hecBadMessage, 'Remaining length in message too short for a valid segment.' + #13 + 'Remainder of packet: ' + StringReplace(copy(FPacket, VCursor, length(FPacket)), #13, '<CR>', [rfReplaceAll]));

  //recognise segment
  LSegCode := copy(FPacket, VCursor, 3);
  if pos(#13, LSegCode) <> 0 then //check that the segcode is a valid length (length must be 3 chars)
    raise EBaseHL7Exception.Create(hecBadMessage, 'Segment code too short or contains <CR>: ' + StringReplace(LSegCode, #13, '<CR>', [rfReplaceAll]));

  inc(VCursor, 3);
  if (LSegCode <> 'MSH') and (LSegCode <> 'FHS') and (LSegCode <> 'BHS') then // special case: field is it's own delimiter for first MSH field
    if FPacket[VCursor] <> #13 then
      inc(VCursor);

  LSeg := THL7Segment.Create(LSegCode, FSegOwner);
  //load dict
  try
    LSeg.FDefinition := FSegOwner.FDict.Segment[LSegCode];
  except
    LSeg.FDefinition := NIL;
    end;

  if assigned(LSeg.FDefinition) then
    begin
    LSeg.BuildFields;
    end;

  // parse known fields
  for i := 0 to LSeg.FFields.Count - 1 do
    begin
    LDe := LSeg.FFields.Items[i] as THL7DataElement;
    ParseDataElement(LDe, VCursor);
    end;

  // more special hacks for MSH, etc
  if (LSegCode = 'MSH') or (LSegCode = 'FHS') or (LSegCode = 'BHS') then // special case: field is it's own delimiter for first MSH field
    begin
    (LSeg.FFields.Items[0] as THL7DataElement).RawContent := FSegOwner.FFieldDelimiter;
    (LSeg.FFields.Items[1] as THL7DataElement).RawContent := FSegOwner.FComponentDelimiter + FSegOwner.FRepetitionDelimiter + FSegOwner.FEscapeCharacter + FSegOwner.FSubComponentDelimiter;
    end;

  //load remaining fields
  while FPacket[VCursor] <> #13 do
    begin
    LDe := THL7DataElement.Create(0, LSeg.FFields.Count + 1);
    LDe.FSegment := LSeg;
    ParseDataElement(LDe, VCursor);
    LSeg.FFields.Add(LDe);
    end;

  LSeg.FSegmentContent := Substring(FPacket, LStartPoint, VCursor);

  //run cursor past segment
  inc(VCursor);

  FSegOwner.FSegments.AddObject(LSegCode, LSeg);
end;

procedure THL7ER7.ParseDataElement(Ade: THL7DataElement; var VCursor: Integer);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7ER7.ParseDataElement';
var
  LStartPos: Integer;
  LFocus: THL7DataElement;
  LRepeatFound: Boolean;
  i: Integer;
begin
  LFocus := Ade;
  repeat
    LStartPos := VCursor;
    LRepeatFound := False;
    while (VCursor < length(FPacket)) and (FPacket[VCursor] <> #13) and (FPacket[VCursor] <> FSegOwner.FFieldDelimiter) and (FPacket[VCursor] <> FSegOwner.FRepetitionDelimiter) do
      inc(VCursor);
    LFocus.FRawContent := SubString(FPacket, LStartPos, VCursor);
    if (VCursor < length(FPacket)) and (FPacket[VCursor] = FSegOwner.FRepetitionDelimiter) then
      begin
      inc(VCursor);
      LRepeatFound := True;
      LFocus := THL7DataElement.Create(0, Ade.FElementIndex);
      LFocus.FDefinition := Ade.FDefinition;
      LFocus.FFirstInstance := False;
      LFocus.FSegment := Ade.Fsegment;
      LFocus.primary := Ade;
      LFocus.MakeForBuild;
      ADe.FRepeatList.Add(LFocus);
      end;
  until not LRepeatFound;
  if (VCursor <= length(FPacket)) and (FPacket[VCursor] <> #13) then
    inc(VCursor);
  // we will do this whether there is any contents or not to allow the
  // components defined in the HL7 dictionary to be created
  ParseCell(Ade);
  for i := 0 to Ade.FRepeatList.Count - 1 do
    ParseCell(Ade.FRepeatList.Items[i] as THL7DataElement);
end;

procedure THL7ER7.ParseCell(ACell: THL7CommonDataCell);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7ER7.ParseComponents';
var
  LSep : char;
  LNSep : char;
  LSubComp : THL7CommonDataCell;
  s: String;
  t: String;
  i : integer;
begin
  // get seperator
  if ACell.FLevel = 0 then
    begin
    // we are a data element, we will be looking for the component seperator
    LSep := FSegOwner.FComponentDelimiter;
    LNSep := FSegOwner.FSubComponentDelimiter;
    end
  else
    begin
    // we are a Component *or lower*, and we will be looking for the subcomponent seperator
    // (if we are lower, then we won't find anything)
    LSep := FSegOwner.FSubComponentDelimiter;
    LNSep := #0;
    end;

  // if children are defined or a seperator is found, then we will break content up into children
  if ACell.GetHasChildren or (pos(LSep, ACell.FRawContent) > 0) or (pos(LNSep, ACell.FRawContent) > 0) then
    begin
    i := 0;
    s := ACell.FRawContent;
    while s <> '' do
      begin
      split(s, LSep, t, s);
      LSubComp := ACell.GetNthChild(i);
      LSubComp.FRawContent := t;
      ParseCell(LSubComp);
      inc(i);
      end;
    ACell.FRawContent := '';
    ACell.FDefined := False;
    end
  else
    begin
    // we didn't do this before in case we were going to break into components
    ACell.SetRawContent(ACell.FRawContent);
    if (ACell.FRawContent <> '') and not FSegOwner.FSuppressEscaping and ACell.GetEscapable(FULL_ESCAPING) then
      begin
      ACell.FRawContent := UnEscape(ACell.FRawContent);
      end;
    end;
end;

procedure THL7ER7.SplitMessage(var VContent, VMessage, VSegmentID: String);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7ER7.SplitMessage';
var
  i: Integer;
begin
  i := 1;
  while
    (i < length(VContent)) and
    ((Vcontent[i] <> #13) or (pos('|' + copy(Vcontent, i + 1, 3) + '|', '|MSH|FHS|FTS|BHS|BTS|') = 0)) do
    inc(i);
  VMessage := copy(VContent, 1, i);
  Delete(VContent, 1, i);
  if (length(VMessage) > 0) and (VMessage[1] = #10) then
    Delete(VContent, 1, 1);
  VSegmentID := copy(VMessage, 1, 3);
end;

{ THL7Batch }

constructor THL7Batch.Create(AFile: THL7File);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Batch.Create';
begin
  inherited Create;
  FMessages := THL7StringList.Create(True);
  FFile := AFile;
  FMsgCount := 0;
  FMessages.OnChange := MessagesChanged;
end;

destructor THL7Batch.Destroy;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Batch.Destroy';
begin
  FreeAndNil(FMessages);
  inherited;
end;

procedure THL7Batch.Encode(AIts: THL7AbstractITS; AStream: TStream);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Batch.Encode';
var
  i: Integer;
  HeaderContent: String;
  TrailerContent: String;
begin
  if BatchID <> '#1' then
    begin
    HeaderContent := AIts.Encode(self, [], Header);
    AStream.Write(HeaderContent[1], length(HeaderContent));
    end;

  for i := 0 to FMessages.Count - 1 do
    AStream.Write((FMessages.Objects[i] as THL7BatchMessage).FContent[1], length((FMessages.Objects[i] as THL7BatchMessage).FContent));

  Trailer['1'].AsInteger := FMessages.Count;
  if BatchID <> '#1' then
    begin
    TrailerContent := AIts.Encode(self, [], Trailer);
    AStream.Write(TrailerContent[1], length(TrailerContent));
    end;
end;

function THL7Batch.GetBatchID: String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Batch.GetBatchID';
begin
  Result := Header.Element['11'].AsString;
end;

procedure THL7Batch.SetBatchID(AValue: String);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Batch.SetBatchID';
begin
  Header.Element['11'].AsString := AValue;
end;

function THL7Batch.GetReplyBatchID: String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Batch.GetReplyBatchID';
begin
  Result := Header.Element['12'].AsString;
end;

procedure THL7Batch.SetReplyBatchID(AValue: String);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Batch.SetReplyBatchID';
begin
  Header.Element['12'].AsString := AValue;
end;


procedure THL7Batch.Init(AVersion: String);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Batch.Init';
var
  LSeg: THL7Segment;
begin
  FDict := GHL7Dict.Dictionary[AVersion];
  LSeg := THL7Segment.Create('BHS', self);
  LSeg.FDefinition := FDict.GetSegment('BHS');
  LSeg.BuildFields;
  LSeg['7'].AsDateTime := now;
  FSegments.AddObject('BHS', LSeg);
  LSeg := THL7Segment.Create('BTS', self);
  LSeg.FDefinition := FDict.GetSegment('BTS');
  LSeg.BuildFields;
  FSegments.AddObject('BTS', LSeg);
end;

procedure THL7Batch.Decode(Aits: THL7AbstractITS; AVersion: String; AProgressEvent: TBatchProgressEvent; ATotal: Integer; var VSegID, Vtmp, Vcontent: String);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Batch.Decode';
var
  LBatchMsg: THL7BatchMessage;
begin
  // tmp contains batch header. decode messages including batch trailer until batch trailer found
  if VSegID = 'BHS' then
    begin
    Aits.Decode(self, Vtmp, AVersion, 0);
    Aits.splitMessage(VContent, Vtmp, VSegID);
    end
  else
    begin
    Init(AVersion);
    BatchID := '#1';
    end;
  while (VSegID = 'MSH') do
    begin
    if assigned(AProgressEvent) then
      AProgressEvent(ATotal - length(VContent), ATotal);
    LBatchMsg := THL7BatchMessage.Create(self);
    LBatchMsg.Content := VTmp;
    // this is a hack way to get the message ID. It assumes that
    // the message field delimiter is the same as the batch field delimiter.
    // the standard is not clear on whether this is required or not.
    // but it is a significant performance issue. If the field delimiter is
    // different, the id will be ""
    FMessages.AddObject(GetStringCell(GetStringCell(VTmp, 0, #13), 9, FFieldDelimiter), LBatchMsg);
    Aits.splitMessage(VContent, VTmp, VSegID);
    end;
  if (VSegID <> 'BTS') and (VSegID <> 'FTS') then
    raise EBaseHL7Exception.Create(hecBadMessage, 'Error reading HL7 Batch: unexpected segment ' + VSegID + ' found');
  if VSegID = 'BTS' then
    Aits.ExtraDecode(self, Vtmp);
end;

procedure THL7Batch.MessagesChanged(ASender: TObject);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Batch.MessagesChanged';
begin
  FFile.Recount;
end;

function THL7BatchElement.GetHeader: THL7Segment;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7BatchElement.GetHeader';
begin
  if FSegments.Count >= 1 then
    Result := FSegments.objects[0] as THL7Segment
  else
    Result := NIL;
end;

function THL7BatchElement.GetTrailer: THL7Segment;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7BatchElement.GetTrailer';
begin
  if FSegments.Count >= 2 then
    Result := FSegments.objects[1] as THL7Segment
  else
    Result := NIL;
end;

procedure THL7Batch.AddMessage(ACnt: String);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7Batch.AddMessage';
var
  LBatchMsg: THL7BatchMessage;
begin
  LBatchMsg := THL7BatchMessage.Create(self);
  LBatchMsg.Content := ACnt;
  FMessages.AddObject(GetStringCell(GetStringCell(ACnt, 0, #13), 9, FFieldDelimiter), LBatchMsg);
end;

{ THL7File }

constructor THL7File.Create;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.Create';
begin
  inherited;
  FBatchList := THL7StringList.Create(True);
  FBatchList.OnChange := BatchListChanged;

  FCursor := -1;
  FBatchCursor := -1;
  FTotalCount := 0;
  Locate;
end;

destructor THL7File.Destroy;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.Destroy';
begin
  FreeAndNil(FBatchList);
  inherited;
end;

procedure THL7File.InitForBuild(Version: String);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.InitForBuild';
var
  LSeg: THL7Segment;
begin
  FSegments.Clear;
  FBatchList.Clear;
  FVersion := Version;
  FCursor := -1;
  FBatchCursor := -1;
  FTotalCount := 0;
  FDict := GHL7Dict.Dictionary[Version];
  LSeg := THL7Segment.Create('FHS', self);
  LSeg.FDefinition := FDict.GetSegment('FHS');
  LSeg.BuildFields;
  LSeg['7'].AsDateTime := now;
  FSegments.AddObject('FHS', LSeg);
  LSeg := THL7Segment.Create('FTS', self);
  LSeg.FDefinition := FDict.GetSegment('FTS');
  LSeg.BuildFields;
  FSegments.AddObject('FTS', LSeg);
end;

procedure THL7File.LoadFromFile(AFilename: String; AProgressEvent: TBatchProgressEvent = NIL; AVersion: String = '2.3.1'; AITSClass: THL7ITSClass = NIL);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.LoadFromFile';
var
  LIts: THL7AbstractITS;
  LContent: String;
  LPck: String;
  LTmp: String;
  LSegID: String;
  LFile: TFileStream;
  LBatch: THL7Batch;
  LTotal: Integer;
begin
  FSegments.Clear;
  FBatchList.Clear;
  FCursor := -1;
  FBatchCursor := -1;
  FTotalCount := 0;
  FDict := GHL7Dict.Dictionary[AVersion];
  FVersion := AVersion;

  // read file into a string. This is not super effective performance wise
  // but does simplify the processing a great deal
  LFile := TFileStream.Create(AFilename, fmOpenRead + fmShareDenyWrite);
  try
    if LFile.Size <> 0 then
      begin
      SetLength(LContent, LFile.Size);
      LFile.Read(LContent[1], LFile.size);
      end
    else
      begin
      LContent := '';
      end;
    LTotal := LFile.size;
  finally
    FreeAndNil(LFile);
    end;

  if AITSClass = NIL then
    begin
    if length(LContent) < 2 then
      raise EBaseHL7Exception.Create(hecBadMessage, 'The File encoding type was not defined and the File is too short to determine the type (File="' + MimeEnCode(LContent) + '"');
    LPck := uppercase(StripSoln(copy(LContent, 1, 100)));
    if copy(LPck, 1, 1) = START_BLOCK then
      begin
      Delete(LPck, 1, 1);
      Delete(LContent, 1, 1);
      if copy(LContent, Length(LContent) - Length(END_BLOCK) + 1, Length(END_BLOCK)) = END_BLOCK then
        begin
        Delete(LContent, Length(LContent) - Length(END_BLOCK) + 1, Length(END_BLOCK));
        end;
      end;
    if copy(LPck, 1, 3) = 'FHS' then
      AITSClass := THL7ER7
    else if pos('DOCTYPE', LPck) > 0 then
      AITSClass := THL7XML
    else if pos('<?XML', LPck) > 0 then
      AITSClass := THL7XML
    else if pos('<XML', LPck) > 0 then
      AITSClass := THL7XML
    else if copy(LPck, 1, 3) = 'MSH' then
      raise EBaseHL7Exception.Create(hecBadMessage, 'The Bacth file is actually a single Message. Use THL7Message directly to assist with decoding the message')
    else if LPck = '' then
      raise EBaseHL7Exception.Create(hecBadMessage, 'The Batch was empty and could not be decoded')
    else
      raise EBaseHL7Exception.Create(hecBadMessage, 'The Batch encoding type was not defined and could not be observed (starting text = "' + copy(LPck, 1, 10) + '")');
    end;

  LIts := AITSClass.Create;
  try
    LIts.SplitMessage(LContent, LTmp, LSegID);
    if LSegID <> 'FHS' then
      raise EBaseHL7Exception.Create(hecBadMessage, 'Error reading HL7Batch file: unexpected segment ' + LSegID + ' found');
    LIts.Decode(self, LTmp, FVersion, 0);
    LIts.splitMessage(LContent, LTmp, LSegID);
    while (LSegID <> 'FTS') do
      begin
      if assigned(AProgressEvent) then
        AProgressEvent(length(LContent), LTotal);
      LBatch := THL7Batch.Create(self);
      LBatch.Decode(LIts, AVersion, AProgressEvent, LTotal, LSegID, LTmp, LContent);
      FBatchList.AddObject(LBatch.BatchID, LBatch);
      if LSegID <> 'FTS' then
        LIts.splitMessage(LContent, LTmp, LSegID);
      end;
    if (LSegID <> '') and (LSegID <> 'FTS') then
      raise EBaseHL7Exception.Create(hecBadMessage, 'Error reading HL7Batch file: unexpected segment ' + LSegID + ' found');
    LIts.ExtraDecode(self, LTmp);
  finally
    FreeAndNil(LIts);
    end;
  Recount;
  if LContent <> '' then
    raise EBaseHL7Exception.Create(hecBadMessage, 'Extra content in batch?');
end;

procedure THL7File.SaveToFile(AFilename: String; AProgressEvent: TBatchProgressEvent = NIL; AITSClass: THL7ITSClass = NIL);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.SaveToFile';
var 
  i: Integer;
  LHeaderContent: String;
  LTrailerContent: String;
  LIts: THL7AbstractITS;
  LFile: TFileStream;
begin
  if AITSClass = NIL then
    AITSClass := THL7ER7;

  LFile := TFileStream.Create(AFilename, fmCreate);
  try
    LIts := AITSClass.Create;
    try
      LHeaderContent := LIts.Encode(self, [], Header);
      LFile.Write(LHeaderContent[1], length(LHeaderContent));
      if (FBatchList.Count = 1) and (FBatchList[0] = '#1') then
        Trailer['1'].AsInteger := (FBatchList.Objects[0] as THL7Batch).FMessages.Count
      else
        Trailer['1'].AsInteger := FBatchList.Count;
      for i := 0 to FBatchList.Count - 1 do
        begin
        if assigned(AProgressEvent) then
          AProgressEvent(i, MessageCount);
        (FBatchList.Objects[i] as THL7Batch).encode(LIts, LFile);
        end;
      LTrailerContent := LIts.Encode(self, [], Trailer);
      LFile.Write(LTrailerContent[1], length(LTrailerContent));
    finally
      FreeAndNil(LIts);
      end;
  finally
    FreeAndNil(LFile);
    end;
end;

function THL7File.Seek(AOffset: Longint; AOrigin: Word = soFromBeginning): Integer;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.Seek';
begin
  case AOrigin of
    soFromBeginning:
      FCursor := AOffset;
    soFromCurrent:
      FCursor := FCursor + AOffset;
    soFromEnd:
      FCursor := FTotalCount + AOffset;
    else
      raise EBaseHL7Exception.Create(hecApplicationError, 'Unknown Origin Mode');
    end;
  if FCursor >= FTotalCount then
    FCursor := FTotalCount - 1;
  Result := FCursor;
  Locate;
end;

procedure THL7File.SetPosition(const AValue: Longint);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.SetPosition';
begin
  Seek(AValue, soFromBeginning);
end;

function THL7File.GetCurrentBatch: THL7Batch;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.GetCurrentBatch';
begin
  Result := FCurrentBatch;
end;

function THL7File.GetCurrentMessage: THL7BatchMessage;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.GetCurrentMessage';
begin
  Result := FCurrentMessage;
end;

procedure THL7File.BatchListChanged(ASender: TObject);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.BatchListChanged';
begin
  Recount;
end;

procedure THL7File.Locate;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.Locate';
var
  i: Integer;
  LCount: Integer;
begin
  FCurrentBatch := NIL;
  FCurrentMessage := NIL;
  if FCursor <> -1 then
    begin
    if FBatchList.Count = 0 then
      begin
      FCursor := -1
      end
    else
      begin
      LCount := 0;
      i := 0;
      FCurrentBatch := FBatchList.objects[i] as THL7Batch;
      while (i < FBatchList.Count) and (LCount + FCurrentBatch.FMessages.Count < FCursor) do
        begin
        inc(LCount, FCurrentBatch.FMessages.Count);
        inc(i);
        FCurrentBatch := FBatchList.objects[i] as THL7Batch;
        end;
      if (i = FBatchList.Count) or (LCount + FCurrentBatch.FMessages.Count <= FCursor) then
        begin
        FCursor := -1;
        FCurrentBatch := NIL;
        end
      else
        begin
        FCurrentMessage := FCurrentBatch.FMessages.objects[FCursor - LCount] as THL7BatchMessage
        end;
      end
    end
  else if FBatchCursor <> -1 then
    begin
    if (FBatchCursor < FBatchList.Count) then
      begin
      FCurrentBatch := FBatchList.objects[FBatchCursor] as THL7Batch;
      if FCurrentBatch.FMessages.Count > 0 then
        begin
        FCurrentMessage := FCurrentBatch.FMessages.objects[0] as THL7BatchMessage;
        // flip cursor over to Message mode;
        FCursor := 0;
        for i := 0 to FBatchCursor do
          inc(FCursor, (FBatchlist.Objects[i] as THL7Batch).FMessages.Count);
        end;
      end;
    end;
end;

procedure THL7File.Recount;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.Recount';
var
  i: Integer;
begin
  if not assigned(FBatchList) then
    exit;
  FTotalCount := 0;
  for i := 0 to FBatchList.Count - 1 do
    if assigned(FBatchlist.Objects[i]) then
      inc(FTotalCount, (FBatchlist.Objects[i] as THL7Batch).FMessages.Count);
  if FCursor >= FTotalCount then
    FCursor := FTotalCount - 1;
  Locate;
end;

procedure THL7File.SetBatch(AIndex: Integer);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.SetBatch';
begin
  if (AIndex >= 0) and (AIndex < FBatchList.Count) then
    begin
    FCursor := -1;
    FBatchCursor := Aindex;
    Locate;
    end;
end;

procedure THL7File.First;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.First';
begin
  FCursor := -1;
end;

procedure THL7File.Last;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.Last';
begin
  FCursor := FTotalCount;
end;

function THL7File.Next: Boolean;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.Next';
begin
  inc(FCursor);
  Locate;
  Result := FCursor <> -1;
end;

function THL7File.Prev: Boolean;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.Prev';
begin
  dec(FCursor);
  Locate;
  Result := FCursor <> -1;
end;

function THL7File.GetMessage(AIndex: Integer): THL7BatchMessage;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.GetMessage';
var
  i: Integer;
  c: Integer;
  LBatch: THL7Batch;
begin
  Result := NIL;
  if FBatchList.Count = 0 then
    exit;
  c := 0;
  i := 0;
  LBatch := FBatchList.objects[i] as THL7Batch;
  while (i < FBatchList.Count) and (c + LBatch.FMessages.Count < AIndex) do
    begin
    inc(c, LBatch.FMessages.Count);
    inc(i);
    LBatch := FBatchList.objects[i] as THL7Batch;
    end;
  if (i < FBatchList.Count) then
    Result := FCurrentBatch.FMessages.objects[FCursor - c] as THL7BatchMessage
end;

function THL7File.GetFileID: String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.GetFileID';
begin
  Result := Header.Element['11'].AsString;
end;

function THL7File.GetReplyFileID: String;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.GetReplyFileID';
begin
  Result := Header.Element['12'].AsString;
end;

procedure THL7File.SetFileID(const AValue: String);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.SetFileID';
begin
  Header.Element['11'].AsString := AValue;
end;

procedure THL7File.SetReplyFileID(const AValue: String);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.SetReplyFileID';
begin
  Header.Element['12'].AsString := AValue;
end;

function THL7File.AddBatch: THL7Batch;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7File.AddBatch';
var
  LBatch: THL7Batch;
begin
  LBatch := THL7Batch.Create(self);
  LBatch.Init(FVersion);
  LBatch.BatchID := FormatDateTime('yyyymmddhhnnsszzz', Now);
  FBatchList.AddObject(LBatch.batchID, LBatch);
  FCursor := -1;
  FCurrentMessage := NIL;
  FCurrentBatch := LBatch;
  Result := LBatch;
end;

{ THL7SegmentOwner }

constructor THL7SegmentOwner.Create;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SegmentOwner.Create';
begin
  inherited;
  FFieldDelimiter := '|';
  FComponentDelimiter := '^';
  FSubComponentDelimiter := '&';
  FRepetitionDelimiter := '~';
  FEscapeCharacter := '\';
  FDicts := GHL7Dict;
  FSegments := THL7StringList.Create(True);
end;

destructor THL7SegmentOwner.Destroy;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SegmentOwner.Destroy';
begin
  FreeAndNil(FSegments);
  inherited;
end;

procedure THL7SegmentOwner.DropMetaData;
begin
  // nothing
end;

procedure THL7SegmentOwner.SetDicts(const AValue: THL7DictionaryList);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SegmentOwner.SetDicts';
begin
  DropMetaData;
  FDicts := AValue;
  if not FSuppressEscapingSet then
    begin
    FSuppressEscaping := AValue.SuppressEscapingByDefault;
    end;
end;

procedure THL7SegmentOwner.SetSuppressEscaping(const Value: boolean);
begin
  FSuppressEscapingSet := true;
  FSuppressEscaping := Value;
end;

{ THL7BatchMessage }

constructor THL7BatchMessage.Create(ABatch: THL7Batch);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7BatchMessage.Create';
begin
  inherited Create;
  FBatch := ABatch;
end;

procedure THL7BatchMessage.SetContent(s: String);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7BatchMessage.SetContent';
begin
  if (s = '') or (s[length(s)] <> #13) then
    s := s + #13;
  FContent := s;
end;

{ THL7XML }

procedure THL7XML.SplitMessage(var VContent, VMessage, VSegmentID: String);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.SplitMessage';
begin
  // batch support
  raise EHL7LibraryException.Create(hecHL7LibraryError, 'Not supported yet');
end;

procedure THL7XML.ExtraDecode(AMsg: THL7SegmentOwner; APacket: THL7Packet);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.ExtraDecode';
begin
  // batch support
  raise EHL7LibraryException.Create(hecHL7LibraryError, 'Not supported yet');
end;

function THL7XML.Encode(AMsg: THL7SegmentOwner; AOptions: THL7EncodingOptionSet; ASpecificSegment: THL7Segment): THL7Packet;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.EncodeTHL7XML.Encode';
var
  LDomImpl: TDomImplementation;
  LDom: TdomDocument;
  LWriter : TDomToXmlParser;
begin
  assert(AMsg is THL7Message, ASSERT_LOCATION + ': Can only encode Messages in XML');
  assert(not AMsg.FSuppressEscaping, ASSERT_LOCATION+': unable to use XML encoding when Escaping is suppressed');
  FMsg := AMsg as THL7Message;
  FMsg.BuildXMLSegmentMap(AOptions);
  if not assigned(FMsg.FSegmentMap) then
    begin
    raise EHL7RejectException.Create(hecBadMessage, 'Unable to encode to XML - check version ('+FMsg.Version+'), message type ('+FMsg.FMessageType+'), and event ID ('+FMsg.FEvent+')');
    end;
  LDomImpl := TDomImplementation.Create(NIL);
  try
    LDom := LDomImpl.createDocument(FMsg.FStructID, NIL);
    try
      LDom.documentElement.setAttribute('xmlns', 'urn:hl7-org:v2xml');
      LDom.documentElement.setAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance');
      LDom.documentElement.setAttribute('xsi:schemaLocation', 'urn:hl7-org:v2xml ' + FMsg.FStructID + '.xsd');
      EncodeSegments(LDom, LDom.documentElement, FMsg.FSegmentMap);
      LWriter := TDomToXmlParser.create(nil);
      try
        LWriter.DOMImpl := LDomImpl;
        if not LWriter.writeToString(LDom, '', result) then
          begin
          raise EHL7ErrorException.create(hecXML, 'XML encoding failed with unknown cause (?)');
          end;
      finally
        FreeAndNil(LWriter);
      end;
    finally
      LDomImpl.FreeDocument(LDom);
      end;
  finally
    FreeAndNil(LDomImpl);
    end;
end;

procedure THL7XML.EncodeSegments(ADom: TdomDocument; AParent: TdomElement; AGroup: THL7SegmentGroup);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.EncodeSegmentTHL7XML.EncodeSegments';
var
  i: Integer;
  LNode: TdomElement;
begin
  for i := 0 to AGroup.Count - 1 do
    begin
    if AGroup.Items[i] is THL7Segment then
      begin
      AParent.appendChild(EncodeSegment(ADom, AGroup.Items[i] as THL7Segment));
      end
    else if AGroup.Items[i] is THL7SegmentGroup then
      begin
      LNode := ADom.createElement((AGroup.Items[i] as THL7SegmentGroup).FGroupName);
      AParent.appendChild(LNode);
      EncodeSegments(ADom, LNode, AGroup.Items[i] as THL7SegmentGroup);
      end
    else
      begin
      assert(False, ASSERT_LOCATION + ': unknown object in Segment Group list');
      end;
    end;
end;

function THL7XML.EncodeSegment(ADom: TdomDocument; ASeg: THL7Segment): TdomElement;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.EncodeSegmentTHL7XML.EncodeSegment';
var
  i: Integer;
  j: Integer;
  LNode: TdomElement;
  LStart : integer;
begin
  Result := ADom.createElement(ASeg.FCode);
  LStart := 0;
  if ASeg.FCode = 'MSH' then
    begin
    // MSH is given special handling because MSH 2 is mangled internally when reading it by ER7 (and special logic exists to save it internally)
    LNode := ADom.createElement('MSH.1');
    LNode.appendChild(ADom.createTextNode(FMsg.FFieldDelimiter));
    Result.appendChild(LNode);
    LNode := ADom.createElement('MSH.2');
    LNode.appendChild(ADom.createTextNode(FMsg.FComponentDelimiter + FMsg.FRepetitionDelimiter + FMsg.FEscapeCharacter + FMsg.FSubComponentDelimiter));
    Result.appendChild(LNode);
    LStart := 2;
    end;
  for i := LStart to ASeg.FFields.Count - 1 do
    begin
    LNode := EncodeDataElement(ADom, ASeg.Fields[i] as THL7DataElement, ASeg.Code + '.' + IntToStr(i + 1));
    if assigned(LNode) then
      begin
      if assigned((ASeg.Fields[i] as THL7DataElement).FDefinition) then
        begin
        //        LNode.setAttribute('desc', (ASeg.Fields[i] as THL7DataElement).FDefinition.DataElementObj.FDescription)
        end;
      Result.appendChild(LNode);
      end;
    for j := 0 to (ASeg.Fields[i] as THL7DataElement).FRepeatList.Count - 1 do
      begin
      LNode := EncodeDataElement(ADom, (ASeg.Fields[i] as THL7DataElement).FRepeatList[j] as THL7DataElement, ASeg.Code + '.' + IntToStr(i + 1));
      if assigned(LNode) then
        begin
        if assigned((ASeg.Fields[i] as THL7DataElement).FDefinition) then
          begin
          //          LNode.setAttribute('desc', (ASeg.Fields[i] as THL7DataElement).FDefinition.DataElementObj.FDescription)
          end;
        Result.appendChild(LNode);
        end;
      end;
    end;
end;

function THL7XML.EncodeDataElement(ADom: TdomDocument; Ade: THL7DataElement; AFieldName: String): TdomElement;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.EncodeDataElementTHL7XML.EncodeDataElement';
var
  i: Integer;
  LDef: Boolean;
  LStruc: THL7DictStructure;
  LNode: TdomElement;
begin
  Result := NIL;
  // this may become relevent if a programmer has assigned something to the
  // field, or if FComponents.count = 0 it will be not Relevent
  if not Ade.GetHasChildren or (Ade.FComponents.Count = 0) then
    LDef := Ade.FDefined
  else
    begin
    LDef := False;
    for i := 0 to Ade.FComponents.Count - 1 do
      begin
      if LDef then
        break;
      LDef := (Ade.FComponents.objects[i] as THL7Component).GetDefined;
      end;
    end;
  if LDef then
    begin
    Result := ADom.createElement(AFieldName);
    if not Ade.GetHasChildren or (Ade.FComponents.Count = 0) then  // count can become 0 if the version is changed
      begin
      if Ade.GetEscapable(XML_ONLY_ESCAPING) then
        begin
        BuildEscapedText(ADom, Result, Ade.FRawContent);
        end
      else
        begin
        Result.appendChild(ADom.createTextNode(Ade.FRawContent));
        end;
      end
    else
      begin
      LStruc := NIL;
      if (ADe.FAltDefinition <> '') then
        begin
        if FMsg.FDict.FStructures.find(ADe.FAltDefinition, i) then
          begin
          LStruc := FMsg.FDict.FStructures.objects[i] as THL7DictStructure;
          end;
        end
      else if assigned(Ade.FDefinition) then
        begin
        LStruc := Ade.FDefinition.DataElementObj.GetStructureObj;
        end;
      for i := 0 to Ade.FComponents.Count - 1 do
        begin
        LNode := EncodeComponent(ADom, Ade.FComponents.objects[i] as THL7Component, LStruc);
        if assigned(LNode) then
          begin
          Result.appendChild(LNode);
          end;
        end;
      assert(Result.hasChildNodes, ASSERT_LOCATION + ': Field had children and was defined, but contains no nodes');
      end;
    end;
end;

function THL7XML.EncodeComponent(ADom: TdomDocument; AComp: THL7Component; AStruct: THL7DictStructure): TdomElement;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.EncodeComponentTHL7XML.EncodeComponent';
  procedure MakeNode;
    begin
    if assigned(AStruct) then
      begin
      // special case: CE.
      if copy(AStruct.FName, 1, 3) = 'CE_' then
        begin
        Result := ADom.createElement('CE.' + IntToStr(AComp.FElementIndex))
        end
      else
        begin
        Result := ADom.createElement(AStruct.FName + '.' + IntToStr(AComp.FElementIndex))
        end;
      //      result.setAttribute('desc', (AStruct.FComponents.Objects[AComp.FElementIndex-1] as THL7DictComponent).FDescription);
      end
    else
      begin
      Result := ADom.createElement('UNK.' + IntToStr(AComp.FElementIndex))
      end;
    end;
var
  LNode: TdomElement;
  i: Integer;
  LDef: Boolean;
begin
  Result := NIL;
  if (AComp.FSubComponents.Count = 0) then
    begin
    if AComp.FDefined then
      begin
      MakeNode;
      if AComp.FRawContent = '' then
        begin
        Result.appendChild(ADom.createTextNode('""'));
        end
      else
        begin
        if AComp.GetEscapable(XML_ONLY_ESCAPING) then
          begin
          BuildEscapedText(ADom, Result, AComp.FRawContent);
          end
        else
          begin
          Result.appendChild(ADom.createTextNode(AComp.FRawContent));
          end;
        end;
      end;
    end
  else
    begin
    LDef := False;
    for i := 0 to AComp.FSubComponents.Count - 1 do
      begin
      LDef := LDef or (AComp.FSubComponents.Items[i] as THL7Component).Defined;
      end;
    if LDef then
      begin
      MakeNode;
      for i := 0 to AComp.FSubComponents.Count - 1 do
        begin
        if assigned(AComp.FDictComp) then
          begin
          LNode := EncodeComponent(ADom, AComp.FSubComponents.Items[i] as THL7Component, AComp.FDictComp.FStruct);
          end
        else
          begin
          LNode := EncodeComponent(ADom, AComp.FSubComponents.Items[i] as THL7Component, NIL);
          end;
        if assigned(LNode) then
          begin
          Result.appendChild(LNode);
          end;
        end;
      assert(Result.hasChildNodes, ASSERT_LOCATION + ': children should have existed');
      end;
    end;
end;

procedure THL7XML.ReadComponent(AComp: THL7Component; ACompRoot: TdomElement);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.ReadComponentTHL7XML.ReadComponent';
var
  LNode: TdomNode;
  LFound: Boolean;
  LName: String;
  LIndex: String;
  i: Integer;
  LSubComp: THL7Component;
begin
  assert(AComp <> NIL, ASSERT_LOCATION + ': Comp is not valid');
  assert(ACompRoot <> NIL, ASSERT_LOCATION + ': FieldRoot is not valid');

  { TODO : fix this for mixed content }
  LFound := False;
  LNode := ACompRoot.firstChild;
  while Assigned(LNode) do
    begin
    if (LNode is TdomElement) then
      begin
      LFound := True;
      Split(LNode.nodeName, '.', LName, LIndex);
      assert((LName <> '') and ((AComp.FDictComp = NIL) or (AComp.FDictComp.FStruct = NIL) or
        (LName = AComp.FDictComp.FStruct.FName)), ASSERT_LOCATION + ': The Component Name "' + LNode.nodeName + '" is not right');
      assert(isANumber(LIndex), ASSERT_LOCATION + ': The Component Index "' + Lnode.nodeName + '" is wrong');
      i := StrToIntWithError(LIndex, 'Component Index "' + Lnode.nodeName + '" is wrong');
      while (I > AComp.FSubComponents.Count) do
        begin
        LSubComp := THL7Component.Create(AComp.FLevel + 1, AComp.FSubComponents.Count + 1);
        LSubComp.FField := AComp.FField;
        LSubComp.FParent := AComp;
        LSubComp.FDictComp := NIL;
        AComp.FSubComponents.Add(LSubComp);
        end;
      LSubComp := AComp.FSubComponents.Items[i - 1] as THL7Component;
      ReadComponent(LSubComp, LNode as TdomElement);
      end;
    LNode := LNode.nextSibling;
    end;

  if not LFound then
    begin
    assert(ACompRoot.childNodes.length <= 1, ASSERT_LOCATION + ': There should only be one child if there is no elements');
    if ACompRoot.childNodes.length = 1 then
      begin
      AComp.RawContent := (ACompRoot.firstChild as TdomText).textContent;
      end;
    end;
end;

procedure THL7XML.ReadField(AField: THL7DataElement; AFieldRoot: TdomElement);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.ReadFieldTHL7XML.ReadField';
var
  LNode: TdomNode;
  LFound: Boolean;
  LName: String;
  LIndex: String;
  i: Integer;
  LComp: THL7Component;
  s : string;
begin
  assert(AField <> NIL, ASSERT_LOCATION + ': Field is not valid');
  assert(AFieldRoot <> NIL, ASSERT_LOCATION + ': FieldRoot is not valid');

  LFound := False;
  LNode := AFieldRoot.firstChild;
  while Assigned(LNode) do
    begin
    if (LNode is TdomElement) then
      begin
      // we may have mixed content
      // if the name of node has the format name.index then we accept it as a component rather than mixed content
      // once we have a component, then everything must be a component
      Split(LNode.nodeName, '.', LName, LIndex);
      LFound := LFound or ((length(LName) > 0) and (length(LIndex) > 0));
      if LFound then
        begin
        assert(LName <> '', ASSERT_LOCATION + ': The Component Name "' + LNode.nodeName + '" is not right');
        assert( (AField.FDefinition = NIL) or (AField.FDefinition.GetDataElementObj = NIL) or
                   (LName = AField.FDefinition.GetDataElementObj.FStructure) or
                   SameText(AField.FDefinition.GetDataElementObj.FStructure, 'varies') or
                   ( (LName = 'CE') and (copy(AField.FDefinition.GetDataElementObj.FStructure, 1, 2) = 'CE') ),
                   ASSERT_LOCATION + ': The Component Name "' + LNode.nodeName + '" is not right. Expected "'+AField.FDefinition.GetDataElementObj.FStructure+'", found "'+LName+'"');
        assert(isANumber(LIndex), ASSERT_LOCATION + ': The Component Index "' + Lnode.nodeName + '" is wrong');
        i := StrToIntWithError(LIndex, 'Component Index "' + Lnode.nodeName + '" is wrong');
        while (I > AField.FComponents.Count) do
          begin
          LComp := THL7Component.Create(AField.FLevel + 1, AField.FComponents.Count + 1);
          LComp.FField := AField;
          LComp.FParent := AField;
          LComp.FDefined := False;
          LComp.FDictComp := NIL;
          AField.FComponents.addObject(LName + '_' + IntToStr(AField.FComponents.Count + 1), LComp);
          end;
        LComp := AField.FComponents.objects[i - 1] as THL7Component;
        ReadComponent(LComp, LNode as TdomElement);
        end;
      end;
    LNode := LNode.nextSibling;
    end;

  if not LFound then
    begin
    if AFieldRoot.childNodes.length = 1 then
      begin
      assert(AFieldRoot.firstChild is TdomText, ASSERT_LOCATION+': found a node of type '+AFieldRoot.firstChild.ClassName+' attached to '+AFieldRoot.nodeName+' expecting a text node');
      AField.RawContent := (AFieldRoot.firstChild as TdomText).textContent; // no escaping
      end
    else if AFieldRoot.childNodes.length > 1 then
      begin
      // well, we have mixed content....
      assert(AField.GetEscapable(XML_ONLY_ESCAPING), ASSERT_LOCATION+': Encountered a mixed content field where it is not acceptable ('+AFieldRoot.nodeName+')');
      s := '';
      LNode := AFieldRoot.FirstChild;
      while assigned(LNode) do
        begin
        if LNode is TdomText then
          begin
          s := s + HL7EscapeHexChars((LNode as TdomText).textContent);
          end
        else if LNode is TdomElement then
          begin
          assert((LNode as TdomElement).nodeName = 'escape', ASSERT_LOCATION+': Encountered unexpected node in mixed content: '+(LNode as TdomElement).nodeName+' on '+AFieldRoot.nodeName);
          s := s + INTERNAL_ESCAPE_CHAR+ (LNode as TdomElement).getAttributeNormalizedValue('V')+INTERNAL_ESCAPE_CHAR;
          end
        else
          begin
          assert(false, ASSERT_LOCATION+': Unexpected node type '+LNode.ClassName+' on '+AFieldRoot.nodeName);
          end;
        LNode := LNode.nextSibling;
        end;
      AField.RawContent := s;
      end;
    end;
end;


procedure THL7XML.ReadSegment(ASegmentRoot: TdomElement);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.ReadSegmentTHL7XML.ReadSegment';
var
  LSeg: THL7Segment;
  LNode: TdomNode;
  LDE: THL7DataElement;
  LLast : integer;
  i: Integer;
begin
  assert(Assigned(ASegmentRoot), ASSERT_LOCATION + ': Segment node is not valid');
  LSeg := FMsg.AddSegment(ASegmentRoot.nodeName);
  LNode := ASegmentRoot.firstChild;
  LLast := -1;
  while assigned(LNode) do
    begin
    if LNode is TdomElement then
      begin
      assert(Copy(LNode.nodeName, 1, 4) = ASegmentRoot.nodeName + '.', ASSERT_LOCATION + ': The Node "' + LNode.nodeName + '" is not expected as a element of the "' + ASegmentRoot.nodeName + '" Segment');
      assert(isANumber(Copy(LNode.nodeName, 5, $F)), ASSERT_LOCATION + ': The Node "' + LNode.nodeName + '" is not expected as a element of the "' + ASegmentRoot.nodeName + '" Segment [#]');
      i := StrToIntWithError(Copy(LNode.nodeName, 5, $F), 'Node ' + LNode.nodeName);
      while i > LSeg.FFields.Count do
        begin
        LDE := THL7DataElement.Create(0, LSeg.FFields.Count + 1);
        LSeg.FFields.Add(LDE);
        LDE.FDefinition := NIL;
        LDE.FFirstInstance := True;
        LDE.FSegment := LSeg;
        LDE.FRawContent := '';
        end;
      if i = LLast then
        begin
        LDE := (LSeg.FFields.Items[i - 1] as THL7DataElement).AddRepeat;
        end
      else
        begin
        LLast := i;
        LDE := LSeg.FFields.Items[i - 1] as THL7DataElement;
        end;
      ReadField(LDE, LNode as TdomElement);
      end;
    LNode := LNode.nextSibling;
    end;
end;

procedure THL7XML.PreProcessMSGSegment(AMSHElement: TdomElement);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.PreProcessMSGSegmentTHL7XML.PreProcessMSGSegment';
var
  LVersionElement: TdomElement;
  LVer: String;
begin
  LVersionElement := AMSHElement.getFirstChildElement('MSH.12');
  assert(Assigned(LVersionElement), ASSERT_LOCATION + ': MSH.12 not found');
  LVersionElement := LVersionElement.getFirstChildElement('VID.1');
  assert(Assigned(LVersionElement), ASSERT_LOCATION + ': MSH.12-VID.1 not found');
  LVer := (LVersionElement.firstChild as TdomText).textContent;
  Assert(LVer <> '', ASSERT_LOCATION + ': MSH.12-VID.1 blank');
  FMsg.Version := LVer;
end;

procedure THL7XML.PostProcessMSGSegment;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.PostProcessMSGSegment';
var
  LSeg: THL7Segment;
begin
  LSeg := FMsg.FSegments.objects[0] as THL7Segment;
  if FMsg.FVersion = '2.1' then
    begin
    FMsg.FMessageType := LSeg.Element['9'].AsString;
    FMsg.FEvent := '';
    end
  else
    begin
    FMsg.FMessageType := LSeg.Element['9.1'].AsString;
    FMsg.FEvent := LSeg.Element['9.2'].AsString;
    if FMsg.FVersion >= '2.3.1' then
      begin
      if LSeg.Element['9.3'].AsString <> '' then
        FMsg.StructName := LSeg.Element['9.3'].AsString
      else
        FMsg.TryLoadStruct;
      end;
    end;
  FMsg.FMsgID := LSeg.Element['10'].AsString;
end;

procedure THL7XML.ReadSegmentSeries(ANode: TdomNode);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.ReadMessageTHL7XML.ReadSegmentSeries';
begin
  assert(self.TestValid(THL7XML), ASSERT_LOCATION + ': self is not valid');
  assert(assigned(ANode), ASSERT_LOCATION + ': Node is not valid');
  while assigned(Anode) do
    begin
    if ANode is TdomElement then
      begin
      if length(ANode.nodeName) = 3 then
        begin
        ReadSegment(ANode as TdomElement);
        end
      else
        begin
        ReadSegmentSeries(ANode.firstChild);
        end;
      end;
    ANode := ANode.nextSibling;
    end;
end;

procedure THL7XML.ReadMessage(ARootElement: TdomElement);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.ReadMessageTHL7XML.ReadMessage';
var
  LStructID: String;
  LNode: TdomNode;
begin
  assert(((length(ARootElement.nodeName) = 7) and (ARootElement.NodeName[4] = '_')) or (length(ARootElement.nodeName) = 3), ASSERT_LOCATION + ': Base Root Node should have an HL7 structure name, but is "' + ARootElement.NodeName + '"');
  LStructID := ARootElement.nodeName;
  LNode := ARootElement.firstChild;
  while assigned(LNode) and not (LNode is TdomElement) do
    begin
    LNode := LNode.nextSibling;
    end;
  assert(LNode.nodeName = 'MSH', ASSERT_LOCATION + ': The First Segment is "' + LNode.nodeName + '", but should be "MSH"');
  PreProcessMSGSegment(LNode as TdomElement);
  ReadSegment(LNode as TdomElement);
  PostProcessMSGSegment;
  LNode := LNode.nextSibling;
  ReadSegmentSeries(LNode);
  FMsg.TryLoadStruct;
  assert(LStructID = FMsg.StructName, ASSERT_LOCATION + ': Message Structure was "' + LStructID + '", but content calls for structure "' + FMsg.StructName + '"');
end;

procedure THL7XML.DOMReadError(ASender: TObject; AError: TdomError; var VGo: boolean);
const ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.DOMReadError';
begin
  assert(Self.TestValid(THL7XML), ASSERT_LOCATION+': self is not valid');
  assert(assigned(AError), ASSERT_LOCATION+': Error is nil');
  VGo := false;
  if assigned(AError.location.relatedNode) then
    begin
    FDomError := AError.code+': '+AError.message+' (at '+AError.location.relatedNode.localName+')';        { do not localize }
    end
  else
    begin
    FDomError := AError.code+': '+AError.message;
    end;
end;

procedure THL7XML.Decode(AMsg: THL7SegmentOwner; APacket: THL7Packet; AVersionOverride: String; ASegmentLimit: Integer);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.DecodeTHL7XML.Decode';
var
  LParser: TXmlToDomParser;
  LDom: TDomImplementation;
begin
  FSegOwner := AMsg;
  assert(not FSegOwner.FSuppressEscaping, ASSERT_LOCATION+': unable to use XML encoding when Escaping is suppressed');
  Fpacket := Apacket;
  FMsg := AMsg as THL7Message;

  LDom := TDomImplementation.Create(NIL);
  try
    LDom.OnError := DOMReadError;
    LParser := TXmlToDomParser.Create(NIL);
    try
      LParser.DOMImpl := LDom;
      try
        FDomError := '';
        LParser.StringToDom(APacket);
      except
        on e:Exception do
          begin
          if FDomError <> '' then
            e.message := e.message + ' '+FDomError;
          raise;
          end;
      end;
    finally
      FreeAndNil(LParser);
      end;
    (LDom.documents.item(0) as TdomDocument).resolveEntityReferences(erReplace);
    ReadMessage((LDom.documents.item(0) as TdomDocument).documentElement);
  finally
    FreeAndNil(LDom);
    end;
end;

procedure THL7XML.BuildEscapedText(ADom: TdomDocument; ANode: TDomElement; AStr: string);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.ReadMessageTHL7XML.BuildEscapedText';
var
  i, j : integer;
  s : string;
  LEsc : TdomElement;
begin
  i := 1;
  j := 1;
  while i <= length(AStr) do
    begin
    if AStr[i] = INTERNAL_ESCAPE_CHAR then
      begin
      ANode.appendChild(ADom.createTextNode(Substring(AStr, j, i)));
      inc(i);
      j := i;
      while (i <= length(AStr)) and (AStr[i] <> INTERNAL_ESCAPE_CHAR) do
        begin
        inc(i);
        end;
      assert(i <= length(AStr), ASSERT_LOCATION+': Content of escapable entity terminated during an escape sequence');
      s := Substring(AStr, j, i);
      case s[1] of
        'H', 'N', '.' :
          begin
          LEsc := ADom.createElement('escape');
          LEsc.setAttribute('V', s);
          ANode.appendChild(LEsc);
          end;
        'C', 'M', 'F', 'S', 'T', 'R', 'E', 'Z' :
          assert(false, ASSERT_LOCATION+': The escape sequence "'+s+'" is not supported in XML');
        'X': ANode.appendChild(ADom.createTextNode(BuildXCharData(copy(s, 2, length(s)-1))));
      else
        assert(false, ASSERT_LOCATION+': unknown escape sequence "'+s+'"');
      end;
      inc(i);
      j:= i;
      end
    else
      begin
      inc(i);
      end;
    end;
  ANode.appendChild(ADom.createTextNode(Substring(AStr, j, i)));
end;

function THL7XML.BuildXCharData(s: string): String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7XML.ReadMessageTHL7XML.BuildXCharData';
var
  i : integer;
begin
  assert(length(s) mod 2 = 0, ASSERT_LOCATION+': Hexadecimal data has an odd length');
  result := '';
  for i := 1 to length(S) div 2 do
    begin
    result := result + chr(StrToInt('$'+copy(s, (i*2)-1, 2)));
    end;
end;

{ THL7DictMessageStruct }

constructor THL7DictMessageStruct.Create(ADict: THL7Dictionary);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictMessageStruct.Create';
begin
  inherited;
  FSegmentMap := THL7DictSegmentMapGroup.Create(ADict);
  FHighestField := 0;
  FNoProcess := False;
end;

destructor THL7DictMessageStruct.Destroy;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictMessageStruct.Destroy';
begin
  FreeAndNil(FSegmentMap);
  FreeAndNil(FXMLMap);
  inherited;
end;

function THL7DictMessageStruct.View(AURLPrefix: String; AOptions: TStringList): String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictMessageStruct.View';
var
  LXMLError: String;
begin
  if not Assigned(FXMLMap) then
    begin
    if not FDictionary.SupportsXMLSchema then
      begin
      LXmlError := 'XML Encoding not defined for this version';
      end
    else
      begin
      try
        LXMLError := '';
        LoadXMLMap;
        if not assigned(FXMLMap) then
          begin
          LXMLError := '&lt;No Map&gt;'
          end;
      except
        on e:
        Exception do
          begin
          LXMLError := e.message;
          end;
        end;
      end;
    end;
  Result :=
    '<table border=1 cellspacing=0 cellpadding=2 class=tbl>' + crlf +
    '<tr>' + crlf +
    '<td style="vertical-align:top;">' + crlf +
    '<b>Database Map</b><br />' + crlf +
    '<table border=0 cellspacing=0 cellpadding=2 class=tbl>' + crlf +
    ' <tr style="background-color:#DFDFDF;">' + crlf +
    '  <th width=150 align="left">Segment</th><th>Cardinality</th>' + crlf +
    ' </tr>' + crlf +
    FSegmentMap.QuickView(AURLPrefix, - 1) +
    '</table>' + crlf +
    '</td>' + crlf +
    '<td style="vertical-align:top;">' + crlf +
    '<b>XML Map</b><br />' + crlf +
    '<table border=0 cellspacing=0 cellpadding=2 class=tbl>' + crlf +
    ' <tr style="background-color:#DFDFDF;">' + crlf +
    '  <th width=150 align="left">Segment</th><th>Cardinality</th>' + crlf +
    ' </tr>' + crlf;
  if LXMLError <> '' then
    begin
    Result := Result + '</table>' + crlf +
                       '<span class=error>' + LXMLError + '</span>';
    end
  else
    begin
    Result := Result + FXMLMap.QuickView(AURLPrefix, - 1) +
                       '</table>' + crlf;
    end;
  Result := Result +
    '</td>' + crlf +
    '</tr>' + crlf +
    '</table>' + crlf;
end;

function THL7DictMessageStruct.UsesSegment(ASegCode: String): Boolean;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictMessageStruct.UsesSegment';
var
  i: Integer;
  LNode: THL7DictSegmentMapNode;
begin
  Result := False;
  if assigned(FSegmentMap) then
    begin
    for i := 0 to FSegmentMap.FNodeList.Count - 1 do
      begin
      LNode := FSegmentMap.FNodeList.objects[i] as THL7DictSegmentMapNode;
      if (LNode is THL7DictSegmentMapSegment) and ((LNode as THL7DictSegmentMapSegment).FSegCode = ASegCode) then
        begin
        Result := True;
        break;
        end;
      end
    end;
end;

function THL7DictMessageStruct.DescribeWithLink(AURLPrefix: String; AOptions: TStringList; AEvent: THL7DictEvent): String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictMessageStruct.DescribeWithLink';
begin
  Result := '<a href="' + AURLPrefix + 'view=events&eventid=' + AEvent.FName + '">' + AEvent.FName + '</a>:' + FName + ' (' + AEvent.FDesc + ' : ' + FDesc + ')';
end;


procedure THL7DictMessageStruct.StartLoading;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictMessageStruct.StartLoading';
begin
  FLoadList := TObjectStack.Create;
  FLoadList.Push(FSegmentMap);
  FSegmentMap.FGroupName := FName;
end;

procedure THL7DictMessageStruct.Load(AFieldNum: Integer; ASegmentName, AGroupName: String; ARepeats, AOptional: Boolean);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictMessageStruct.Load';
var
  LFocus: THL7DictSegmentMapGroup;
  LSeg: THL7DictSegmentMapSegment;
  LGroup: THL7DictSegmentMapGroup;
begin
  assert(Assigned(FLoadList), ASSERT_LOCATION + ': LoadList not valid');
  if (FHighestField > AFieldNum) or (FNoProcess) then
    begin
    FNoProcess := True;
    exit;
    end;
  FHighestField := AFieldNum;
  LFocus := FLoadList.Peek as THL7DictSegmentMapGroup;
  assert(assigned(LFocus), ASSERT_LOCATION + ': current group not valid');
  if ASegmentName = '{' then
    begin
    if (LFocus.FNodeList.Count = 0) and not (LFocus.Repeating) then
      begin
      LFocus.FRepeating := True;
      end
    else
      begin
      LGroup := THL7DictSegmentMapGroup.Create(FDictionary);
      LGroup.FSegNum := AFieldNum;
      LGroup.FGroupName := AGroupName;
      LGroup.FOptional := False;
      LGroup.FRepeating := True; // cause it's a {
      LFocus.FNodeList.AddObject(AGroupName, LGroup);
      FLoadList.Push(LGroup);
      end;
    end
  else if ASegmentName = '<' then
    begin
    LGroup := THL7DictSegmentMapGroup.Create(FDictionary);
    LGroup.FSegNum := AFieldNum;
    LGroup.FIsChoiceGroup := True;
    LGroup.FGroupName := AGroupName;
    LGroup.FOptional := False;
    LGroup.FRepeating := True; // this is an artifact of HL7 v2 specification - groups are always repeating
    LFocus.FNodeList.AddObject(AGroupName, LGroup);
    FLoadList.Push(LGroup);
    end
  else if (ASegmentName = '}') then
    begin
    if not LFocus.Optional then
      begin
      FLoadList.Pop;
      end;
    end
  else if (ASegmentName = ']') or (ASegmentName = '>') then
    begin
    FLoadList.Pop;
    end
  else if ASegmentName = '[' then
    begin
    LGroup := THL7DictSegmentMapGroup.Create(FDictionary);
    LGroup.FSegNum := AFieldNum;
    LGroup.FGroupName := AGroupName;
    LGroup.FOptional := True;
    LGroup.FRepeating := False;
    LFocus.FNodeList.AddObject(AGroupName, LGroup);
    FLoadList.Push(LGroup);
    end
  else if ASegmentName = '|' then
    begin
    assert(LFocus.FIsChoiceGroup, ASSERT_LOCATION + ': Segment | encountered when not in Choice Segment');
    // we can safely ignore this on the assumption that there will be only one segment per choice item
    // there is no mandate for this but it is true in all existing choices and there won't be any more
    end
  else
    begin
    assert(length(ASegmentName) <= 3, ASSERT_LOCATION + ': Segment Name "' + ASegmentName + '" is not acceptable in Struct "' + FName + '"');
    LSeg := THL7DictSegmentMapSegment.Create(FDictionary);
    LSeg.FSegCode := ASegmentName;
    LSeg.FOptional := AOptional;
    LSeg.FRepeating := ARepeats;
    LFocus.FNodeList.AddObject(LSeg.FSegCode, LSeg);
    end;
end;

procedure THL7DictMessageStruct.FinishLoading;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictMessageStruct.FinishLoading';
begin
  assert(FLoadList.Count = 1, ASSERT_LOCATION + ': Unclosed segments found in Struct ' + FName);
  FreeAndNil(FLoadList);
end;

procedure THL7DictMessageStruct.LoadXMLMap;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictMessageStruct.LoadXMLMap';
begin
  assert(self.TestValid(THL7DictMessageStruct), ASSERT_LOCATION + ': self is not valid');
  assert(self.FDictionary.TestValid(THL7Dictionary), ASSERT_LOCATION + ': Dictionary is not valid');
  assert(self.FDictionary.FOwner.TestValid(THL7DictionaryList), ASSERT_LOCATION + ': Dictionary List is not valid');
  assert(self.FDictionary.FOwner.FSchema.TestValid(THL7SchemaStore), ASSERT_LOCATION + ': Schema store is not valid');
  FXMLMap := self.FDictionary.FOwner.FSchema.LoadSchemaMap(FDictionary.FVersion, FName);
end;

{ THL7DictSegmentMapGroup }

constructor THL7DictSegmentMapGroup.Create(ADict: THL7Dictionary);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegmentMapGroup.Create';
begin
  inherited;
  FNodeList := THL7StringList.Create(True);
end;

destructor THL7DictSegmentMapGroup.Destroy;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegmentMapGroup.Destroy';
begin
  FreeAndNil(FNodeList);
  inherited;
end;

function THL7DictSegmentMapGroup.GetNode(i: Integer): THL7DictSegmentMapNode;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegmentMapGroup.GetNode';
begin
  Result := FNodeList.objects[i] as THL7DictSegmentMapNode;
end;

function THL7DictSegmentMapGroup.GetNodeCount: Integer;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegmentMapGroup.GetNodeCount';
begin
  Result := FNodeList.Count;
end;

function THL7DictSegmentMapGroup.QuickView(AURLPrefix: String; AIndent: Integer): String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegmentMapGroup.view';
var
  i: Integer;
begin
  Result := '';
  if AIndent >= 0 then
    begin
    if FIsChoiceGroup then
      begin
      Result := Result + '<tr bgcolor="#EFEFEF"><td>' + HTMLPad(AIndent) + '&lt;Choice of:</td><td>' + DescribeCardinality + '</td></tr>' + crlf;
      end
    else
      begin
      Result := Result + '<tr bgcolor="#EFEFEF"><td>' + HTMLPad(AIndent);
      if FOptional then
        begin
        Result := Result + '[';
        end;
      if FRepeating then
        begin
        Result := Result + '{';
        end;
      Result := Result + FGroupName + '</td><td>' + DescribeCardinality + '</td></tr>' + crlf;
      end;
    end;
  inc(AIndent);
  for i := 0 to FNodeList.Count - 1 do
    begin
    Result := Result + (FNodeList.objects[i] as THL7DictSegmentMapNode).QuickView(AURLPrefix, AIndent);
    end;
  if AIndent > 0 then
    begin
    if FIsChoiceGroup then
      begin
      Result := Result + '<tr><td>' + HTMLPad(AIndent - 1) + '&gt;</td><td>&nbsp;</td></tr>' + crlf;
      end
    else
      begin
      Result := Result + '<tr bgcolor="#EFEFEF"><td>' + HTMLPad(AIndent - 1);
      if FRepeating then
        begin
        Result := Result + '}';
        end;
      if FOptional then
        begin
        Result := Result + ']';
        end;
      Result := Result + '</td><td>&nbsp;</td></tr>' + crlf;
      end;
    end;
end;

function SegCodeMatches(AMatchMask, ACode: String): Boolean;
var
  i: Integer;
begin
  for i := 1 to length(AMatchMask) do
    begin
    if AMatchMask[i] = '*' then
      begin
      ACode[i] := '*';
      end
    else if AMatchMask[i] = '?' then
      begin
      ACode[i] := '?';
      end;
    end;
  Result := AMatchMask = ACode;
end;

function THL7DictSegmentMapGroup.BuildSegmentMap(AGroupName: String; ASegmentList: TStringList; var VSegIndex: Integer; AOptions : THL7EncodingOptionSet; AOptional: Boolean): THL7SegmentGroup;
  procedure MakeResultExist;
    begin
    if not assigned(Result) then
      begin
      Result := THL7SegmentGroup.Create(False);
      Result.FGroupName := AGroupName;
      end;
    end;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegmentMapGroup.BuildSegmentMap';
var
  LNodeIndex: Integer;
  LSeg: THL7DictSegmentMapSegment;
  LGroup: THL7DictSegmentMapGroup;
  LList: TObjectList;
  LFound : boolean;
begin
  assert(Self.TestValid(THL7DictSegmentMapGroup), ASSERT_LOCATION + ': self is not valid');
  assert(Assigned(ASegmentList), ASSERT_LOCATION + ': Segment List is not valid');
  assert((VSegIndex >= 0) and (VSegIndex < ASegmentList.Count), ASSERT_LOCATION + ': VSegIndex is out of range in Group "' + GroupName + '" (' + IntToStr(VSegIndex) + '/' + IntToStr(ASegmentList.Count) + ')');

  LFound := false;
  Result := NIL;
  for LNodeIndex := 0 to FNodeList.Count - 1 do
    begin
    if FNodeList.Objects[LNodeIndex] is THL7DictSegmentMapSegment then
      begin
      LSeg := (FNodeList.Objects[LNodeIndex] as THL7DictSegmentMapSegment);
      if (VSegIndex < ASegmentList.Count) and (SegCodeMatches(LSeg.FSegCode, ASegmentList[VSegIndex])) then
        begin
        MakeResultExist;
        Result.Add(ASegmentList.Objects[VSegIndex]);
        inc(VSegIndex);
        LFound := true;
        if FIsChoiceGroup then
          begin
          break;
          end;
        end
      else
        begin
        if not LSeg.Optional then
          begin
          if AOptional then
            begin
            if not assigned(Result) then
              begin
              // well, we didn't have to find this segment, and the first required segment has not been found.
              // so we conclude that this optional segment is not present and *stop looking*
              exit;
              end
            else
              begin
              if (VSegIndex < ASegmentList.Count) then
                begin
                raise EHL7SegmentOrderException.Create('The Segment "' + LSeg.FSegCode + '" in the Optional Group "' + FGroupName + '" was not found but the segment has already been found, instead "' + ASegmentList[VSegIndex] + '" was found');
                end
              else
                begin
                raise EHL7SegmentOrderException.Create('The Segment "' + LSeg.FSegCode + '" in the Optional Group "' + FGroupName + '" was not found but the segment has already been found');
                end;
              end;
            end
          else
            begin
            if FIsChoiceGroup then
              begin
              // well, we aren't worried about it yet.
              end
            else if (VSegIndex < ASegmentList.Count) then
              begin
              raise EHL7SegmentOrderException.Create('The Segment "' + LSeg.FSegCode + '" in the Group "' + FGroupName + '" was not found, instead "' + ASegmentList[VSegIndex] + '" was found');
              end
            else
              begin
              raise EHL7SegmentOrderException.Create('The Segment "' + LSeg.FSegCode + '" in the Group "' + FGroupName + '" was not found');
              end;
            end;
          end;
        end;
      if LSeg.FRepeating then
        begin
        while (VSegIndex < ASegmentList.Count) and (LSeg.FSegCode = ASegmentList[VSegIndex]) do
          begin
          Result.Add(ASegmentList.Objects[VSegIndex]);
          inc(VSegIndex);
          end
        end;
      end
    else if FNodeList.Objects[LNodeIndex] is THL7DictSegmentMapGroup then
      begin
      LGroup := (FNodeList.Objects[LNodeIndex] as THL7DictSegmentMapGroup);
      if (VSegIndex < ASegmentList.Count) then
        begin
        LList := LGroup.BuildSegmentMap(LGroup.FGroupName, ASegmentList, VSegIndex, AOptions, LGroup.FOptional);
        end
      else
        begin
        LList := NIL;
        end;
      if assigned(LList) then
        begin
        MakeResultExist;
        Result.Add(LList);
        end
      else
        begin
        if not AOptional and not LGroup.FOptional then
          begin
          raise EHL7SegmentOrderException.Create('The Segment Group "' + LGroup.FGroupName + '" in the Group "' + FGroupName + '" was not found');
          end;
        end;
      if LGroup.FRepeating then
        begin
        repeat
          if (VSegIndex < ASegmentList.Count) then
            begin
            LList := LGroup.BuildSegmentMap(LGroup.FGroupName, ASegmentList, VSegIndex, AOptions, True); // cause repeats are always optional
            end
          else
            begin
            LList := NIL;
            end;
          if assigned(LList) then
            begin
            Result.Add(LList);
            end;
        until not assigned(LList);
        end;
      end
    else
      begin
      assert(False, ASSERT_LOCATION + ': unknown object in Segment Group list');
      end;
    end;
  if not FIsChoiceGroup and assigned(result) and (eoOptimisticMapping in AOptions) then
    begin
    // while there's Z segments, add them to this group
    while (VSegIndex < ASegmentList.Count) and (Copy(ASegmentList[VSegIndex], 1, 1) = 'Z') do
      begin
      Result.Add(ASegmentList.Objects[VSegIndex]);
      inc(VSegIndex);
      end;
    end;
  if FIsChoiceGroup and not LFound and not AOptional then
    begin
    raise EHL7SegmentOrderException.Create('No segments found in the The choice Group "' + FGroupName);
    end;
end;

{
 This code will operate on the Database Map and render it closer
 to the XML Map. However the XML Map differs in some significant
 ways from the Database Model, and so rather than try to map this
 to the XML Map, we prefer to actually read the XML schemas
 directly

procedure THL7DictSegmentMapGroup.Normalise;
const ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegmentMapGroup.Normalise';
var
  i : integer;
  LGroup : THL7DictSegmentMapGroup;
  LGroupN : THL7DictSegmentMapGroup;
  LSeg : THL7DictSegmentMapSegment;
begin
  assert(self.TestValid(THL7DictSegmentMapGroup), ASSERT_LOCATION+': self is not valid');
  assert(assigned(FNodeList), ASSERT_LOCATION+': NodeList is not valid');
  for i := 0 to FNodeList.count - 1 do
    begin
    if FNodeList.Objects[i] is THL7DictSegmentMapGroup then
      begin
      LGroup := FNodeList.Objects[i] as THL7DictSegmentMapGroup;
      if (LGroup.FNodeList.count = 1) then
        begin
        if (LGroup.FNodeList.Objects[0] is THL7DictSegmentMapSegment) then
          begin
          LSeg := THL7DictSegmentMapSegment.create(FDictionary);
          LSeg.FSegCode := (LGroup.FNodeList.Objects[0] as THL7DictSegmentMapSegment).FSegCode;
          LSeg.FOptional := LGroup.FOptional or (LGroup.FNodeList.Objects[0] as THL7DictSegmentMapSegment).FOptional;
          LSeg.FRepeating := LGroup.FRepeating or (LGroup.FNodeList.Objects[0] as THL7DictSegmentMapSegment).FRepeating;
          FNodeList.Objects[i].free;
          FNodeList.Objects[i] := LSeg;
          end
        else
          begin
          LGroupN := THL7DictSegmentMapGroup.create(FDictionary);
          FreeAndNil(LGroupN.FNodeList);
          LGroupN.FNodeList := (LGroup.FNodeList.Objects[0] as THL7DictSegmentMapGroup).FNodeList;
          (LGroup.FNodeList.Objects[0] as THL7DictSegmentMapGroup).FNodeList := nil;
          LGroupN.FOptional := LGroup.FOptional or (LGroup.FNodeList.Objects[0] as THL7DictSegmentMapGroup).FOptional;
          LGroupN.FRepeating := LGroup.FRepeating or (LGroup.FNodeList.Objects[0] as THL7DictSegmentMapGroup).FRepeating;
          FNodeList.Objects[i].free;
          FNodeList.Objects[i] := LGroupN;
          end;
        end
      else
        begin
        LGroup.Normalise;
        end;
      end;
    end;
end;
}

function THL7DictSegmentMapGroup.View(AURLPrefix: String; AOptions: TStringList): String;
begin
  Result := ''; // quickview is used instead
end;

{ THL7DictSegmentMapNode }

function THL7DictSegmentMapNode.DescribeCardinality: String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7DictSegmentMapNode.DescribeCardinality';
begin
  if FOptional then
    Result := '0..'
  else
    Result := '1..';
  if FRepeating then
    Result := Result + '*'
  else
    Result := Result + '1'
end;

{ THL7DictSegmentMapSegment }

function THL7DictSegmentMapSegment.QuickView(AURLPrefix: String; AIndent: Integer): String;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SegmentMapSegment.view';
begin
  Result := '<tr><td>' + HTMLPad(AIndent) + '<a href="' + AURLPrefix + 'view=segment&segmentid=' + FSegCode + '">' + FSegCode + '</a></td><td>' + DescribeCardinality + '</td></tr>' + crlf;
end;

function THL7DictSegmentMapSegment.View(AURLPrefix: String; AOptions: TStringList): String;
begin
  Result := ''; // quickview is used instead
end;

{ THL7SchemaStore }

constructor THL7SchemaStore.Create(ASchemaStore: TFileName; ASchemaDirectory: String);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SchemaStore.Create';
begin
  inherited Create;

  // at this point we do not require either of these to exist
  FSchemaStore := ASchemaStore;
  FSchemaDir := ASchemaDirectory;
  FSchemaMap := NIL;
  FWriting := False;
end;

destructor THL7SchemaStore.Destroy;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SchemaStore.destroy';
begin
  FreeAndNil(FSchemaMap);
  inherited;
end;

function THL7SchemaStore.LoadSchemaMap(AVersion, AStruct: String): THL7DictSegmentMapGroup;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SchemaStore.LoadSchemaMap';
begin
  assert(self.TestValid(THL7SchemaStore), ASSERT_LOCATION + ': self is not valid');
  assert(AVersion <> '', ASSERT_LOCATION + ': Version is blank');
  assert(AStruct <> '', ASSERT_LOCATION + ': Struct is blank');

  if FileExists(IncludeTrailingPathDelimiter(FSchemaDir) + 'v' + AVersion + PathDelim + AStruct + '.xsd') then
    begin
    Result := LoadSchemaFromXML(IncludeTrailingPathDelimiter(FSchemaDir) + 'v' + AVersion + PathDelim + AStruct + '.xsd', AVersion, AStruct);
    end
  else
    begin
    Result := LoadSchemaFromStore(AVersion, AStruct, IncludeTrailingPathDelimiter(FSchemaDir) + 'v' + AVersion + PathDelim + AStruct + '.xsd');
    end;
end;

procedure THL7SchemaStore.BuildFromSchemas;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SchemaStore.BuildFromSchemas';
begin
  assert(self.TestValid(THL7SchemaStore), ASSERT_LOCATION + ': self is not valid');
  assert(DirectoryExists(FSchemaDir), ASSERT_LOCATION + ': Schema Directory "' + FSchemaDir + '" not found');
  StartBuild;
  ReadVersionSchemas('2.3.1', IncludeTrailingPathDelimiter(FSchemaDir) + 'v2.3.1');
  ReadVersionSchemas('2.4', IncludeTrailingPathDelimiter(FSchemaDir) + 'v2.4');
  StopBuild;
end;

function StringMatchInList(Astr : string; AList : array of string):boolean;
var
 i : integer;
begin
  result := false;
  for i := low(AList) to High(AList) do
    begin
    result := result or SameText(AStr, AList[i]);
    end;
end;

procedure THL7SchemaStore.ReadVersionSchemas(AVersion, ADirectory: String);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SchemaStore.ReadVersionSchemas';
var
  LFiles: TDirectoryList;
  i: Integer;
  LMap: THL7DictSegmentMapGroup;
  LName : string;
begin
  assert(self.TestValid(THL7SchemaStore), ASSERT_LOCATION + ': self is not valid');
  assert(AVersion <> '', ASSERT_LOCATION + ': Version is blank');
  assert(DirectoryExists(ADirectory), ASSERT_LOCATION + ': Directory "' + ADirectory + '" not found');

  LFiles := TDirectoryList.Create(ADirectory, 'xsd');
  try
    for i := 0 to LFiles.Count - 1 do
      begin
      LName := ExtractFileNameNoExt(LFiles[i]);
      if not StringMatchInList(LName, ['batch', 'datatypes', 'fields', 'messages', 'segments']) then
        begin
        LMap := LoadSchemaFromXML(LFiles[i], AVersion, ExtractFileNameNoExt(LFiles[i]));
        try
          SaveSchemaMap(AVersion, LMap);
        finally
          FreeAndNil(LMap);
        end;
        end;
      end;
  finally
    FreeAndNil(LFiles);
    end;
end;

procedure THL7SchemaStore.StartBuild;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SchemaStore.StartBuild';
begin
  if assigned(FSchemaMap) then
    begin
    FSchemaMap.Clear;
    end
  else
    begin
    FSchemaMap := THL7StringList.Create(True);
    end;
  FWriting := True;
end;

procedure THL7SchemaStore.StopBuild;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SchemaStore.StopBuild';
var
  LFile: TFileStream;
  LWriter: TWriter;
  i: Integer;
begin
  FWriting := False;
  FSchemaMap.sort;
  LFile := TFileStream.Create(FSchemaStore, fmCreate);
  try
    LWriter := TWriter.Create(LFile, 8192);
    try
      LWriter.WriteListBegin;
      try
        for i := 0 to FSchemaMap.Count - 1 do
          begin
          LWriter.WriteString(FSchemaMap[i]);
          LWriter.WriteString((FSchemaMap.Objects[i] as TStringStream).DataString);
          end;
      finally
        LWriter.WriteListEnd;
        end;
    finally
      FreeAndNil(LWriter);
      end;
  finally
    FreeAndNil(LFile);
    end;
end;

procedure THL7SchemaStore.LoadSchemasFromStore;
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SchemaStore.LoadSchemasFromStore';
var
  LReader: TReader;
  LFile: TFileStream;
  LName: String;
  LStream: TStringStream;
  LStore: TStringList;
begin
  assert(self.TestValid(THL7SchemaStore), ASSERT_LOCATION + ': self is not valid');
  assert(FileExists(FSchemaStore), ASSERT_LOCATION + ': Schema Store "' + FSchemaStore + '" not found');
  LStore := THL7StringList.Create(True);
  try
    LFile := TFileStream.Create(FSchemaStore, fmOpenRead or fmShareDenyWrite);
    try
      LReader := TReader.Create(LFile, 8192);
      try
        LReader.ReadListBegin;
        while not LReader.EndOfList do
          begin
          LName := LReader.ReadString;
          LStream := TStringStream.Create(LReader.ReadString);
          LStore.AddObject(LName, LStream);
          end;
        LReader.ReadListEnd;
      finally
        FreeAndNil(LReader);
        end;
    finally
      FreeAndNil(LFile)
      end;
    LStore.Sort;
    FSchemaMap := LStore;
  except
    FreeAndNil(LStore);
    raise;
    end;
end;

procedure THL7SchemaStore.SaveSchemaMap(AVersion: String; AMap: THL7DictSegmentMapGroup);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SchemaStore.SaveSchemaMap';
var
  LStream: TStringStream;
  LWriter: TWriter;
begin
  assert(self.TestValid(THL7SchemaStore), ASSERT_LOCATION + ': self is not valid');
  assert(AVersion <> '', ASSERT_LOCATION + ': Version is blank');
  assert(AMap.TestValid(THL7DictSegmentMapGroup), ASSERT_LOCATION + ': Map is not valid');
  assert(FWriting, ASSERT_LOCATION + ': not currently writing');
  LStream := TStringStream.Create('');
  LWriter := TWriter.Create(LStream, 8192);
  try
    WriteStoredGroup(LWriter, AMap);
  finally
    FreeAndNil(LWriter);
    end;
  FSchemaMap.AddObject(AVersion + '/' + AMap.FGroupName, LStream);
end;

procedure THL7SchemaStore.WriteStoredGroup(AWriter: TWriter; AGroup: THL7DictSegmentMapGroup);
const 
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SchemaStore.WriteStoredGroup';
var
  i: Integer;
begin
  assert(self.TestValid(THL7SchemaStore), ASSERT_LOCATION + ': self is not valid');
  assert(Assigned(AWriter), ASSERT_LOCATION + ': Writer is not valid');
  assert(AGroup.TestValid(THL7DictSegmentMapGroup), ASSERT_LOCATION + ': Group is not valid');
  AWriter.WriteBoolean(AGroup.FIsChoiceGroup);
  AWriter.WriteListBegin;
  for i := 0 to AGroup.FNodeList.Count - 1 do
    begin
    AWriter.WriteString(AGroup.FNodeList[i]);
    if AGroup.FNodeList.Objects[i] is THL7DictSegmentMapSegment then
      begin
      AWriter.WriteBoolean(True);
      end
    else
      begin
      AWriter.WriteBoolean(False);
      WriteStoredGroup(AWriter, AGroup.FNodeList.Objects[i] as THL7DictSegmentMapGroup);
      end;
    AWriter.WriteBoolean((AGroup.FNodeList.Objects[i] as THL7DictSegmentMapNode).FOptional);
    AWriter.WriteBoolean((AGroup.FNodeList.Objects[i] as THL7DictSegmentMapNode).FRepeating);
    end;
  AWriter.WriteListEnd;
end;

procedure THL7SchemaStore.ReadStoredGroup(AReader: TReader; AGroup: THL7DictSegmentMapGroup; AStruct: String);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SchemaStore.ReadStoredGroup';
var
  LName: String;
  LFocus: THL7DictSegmentMapNode;
begin
  assert(self.TestValid(THL7DictMessageStruct), ASSERT_LOCATION + ': self is not valid');
  assert(Assigned(AReader), ASSERT_LOCATION + ': Reader is not valid');
  assert(AGroup.TestValid(THL7DictSegmentMapGroup), ASSERT_LOCATION + ': Group is not valid');
  assert(AStruct <> '', ASSERT_LOCATION + ': AStruct Name is blank');

  AGroup.FIsChoiceGroup := AReader.ReadBoolean;
  AReader.ReadListBegin;
  while not AReader.EndOfList do
    begin
    LName := AReader.ReadString;
    if AReader.ReadBoolean then
      begin
      LFocus := THL7DictSegmentMapSegment.Create(NIL);
      (LFocus as THL7DictSegmentMapSegment).FSegCode := LName;
      end
    else
      begin
      LFocus := THL7DictSegmentMapGroup.Create(NIL);
      (LFocus as THL7DictSegmentMapGroup).FGroupName := LName;
      ReadStoredGroup(AReader, LFocus as THL7DictSegmentMapGroup, AStruct);
      end;
    LFocus.FOptional := AReader.ReadBoolean;
    LFocus.FRepeating := AReader.ReadBoolean;
    AGroup.FNodeList.AddObject(LName, LFocus);
    end;
  AReader.ReadListEnd;
end;

function THL7SchemaStore.LoadSchemaFromStore(AVersion, AStruct, AFileName: String): THL7DictSegmentMapGroup;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SchemaStore.ReadSchemaGroup';
var
  i: Integer;
  LReader: TReader;
begin
  assert(self.TestValid(THL7SchemaStore), ASSERT_LOCATION + ': self is not valid');
  assert(AVersion <> '', ASSERT_LOCATION + ': Version is blank');
  assert(AStruct <> '', ASSERT_LOCATION + ': Struct is blank');

  if not assigned(FSchemaMap) then
    begin
    LoadSchemasFromStore;
    end;

  assert(Assigned(FSchemaMap), ASSERT_LOCATION + ': Schema Store not loaded');
  if FSchemaMap.Find(AVersion + '/' + AStruct, i) then
    begin
    LReader := TReader.Create(FSchemaMap.Objects[i] as TStream, 8192);
    try
      Result := THL7DictSegmentMapGroup.Create(NIL);
      try
        Result.FGroupName := AStruct;
        ReadStoredGroup(LReader, Result, AStruct);
      except
        FreeAndNil(Result);
        raise;
        end;
    finally
      FreeAndNil(LReader);
      end;
    end
  else
    begin
    assert(AStruct = 'NUL', ASSERT_LOCATION + ': No schema found for Version ' + AVersion + ' Structure "' + AStruct + '" (not in Schema Store; Also checked "' + AFileName + '"))');
    result := nil;
    end;
end;

function GetChildByAttributeValue(AElement : TdomElement; AName, AValue : string; ACaseSensitiveValue : boolean = false):TdomElement;
begin
  result := AElement.findFirstChildElement;
  while assigned(result) do
    begin
    if AnsiSameText(result.getAttributeLiteralValue(AName), AValue) and
         (not ACaseSensitiveValue or (result.getAttributeLiteralValue(AName) = AValue)) then
      begin
      exit;
      end;
    result := result.findNextSiblingElement;
    end;
end;

procedure THL7SchemaStore.ReadSchemaGroup(ADom: TdomDocument; AGroup: THL7DictSegmentMapGroup; AVersion, AStruct: String);
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SchemaStore.ReadSchemaGroup';
var
  LSchema : TdomElement;
  LElem : TdomElement;
  LNode: TdomNode;
  LName: String;
  LFocus: THL7DictSegmentMapNode;
begin
  assert(self.TestValid(THL7DictMessageStruct), ASSERT_LOCATION + ': self is not valid');
  assert(Assigned(ADom), ASSERT_LOCATION + ': Dom is not valid');
  assert(AGroup.TestValid(THL7DictSegmentMapGroup), ASSERT_LOCATION + ': Group is not valid');
  assert(AStruct <> '', ASSERT_LOCATION + ': AStruct Name is blank');

  LSchema := ADom.getFirstChildElement('xsd:schema');
  assert(assigned(LSchema), ASSERT_LOCATION + ': schema root not found ['+AVersion+'] "' + AStruct + '"');
  LElem := GetChildByAttributeValue(LSchema, 'name', AGroup.FGroupName);
  assert(Assigned(LElem), ASSERT_LOCATION + ': Definition for schema group "' + AGroup.FGroupName + '" not found for schema ['+AVersion+'] "' + AStruct + '"');
  LNode := LElem.getFirstChildElement('xsd:complexType');
  if not assigned(LNode) then
    begin
    assert(LElem.getAttributeLiteralValue('type') <> '', ASSERT_LOCATION+': No type information or reference found for group "'+AGroup.FGroupName+'" on struct ['+AVersion+'] "'+AStruct+'"');
    LNode := GetChildByAttributeValue(LSchema, 'name', LElem.getAttributeLiteralValue('type'));
    end;
  assert(assigned(LNode), ASSERT_LOCATION + ': Complex Type node not found for the group "' + AGroup.FGroupName + '" could be found in the struct ['+AVersion+'] "' + AStruct + '"');
  if assigned(LNode.getFirstChildElement('xsd:sequence')) then
    begin
    LNode := LNode.getFirstChildElement('xsd:sequence');
    end
  else
    begin
    AGroup.FIsChoiceGroup := true;
    LNode := LNode.getFirstChildElement('xsd:choice')
    end;
  assert(assigned(LNode), ASSERT_LOCATION + ': Sequence node not found for the group "' + AGroup.FGroupName + '" could be found in the struct ['+AVersion+'] "' + AStruct + '"');

  LNode := LNode.firstChild;
  while assigned(LNode) do
    begin
    if (LNode is TdomElement) and (LNode.nodeName = 'xsd:element') then
      begin
      LName := (LNode as TDomElement).getAttributeLiteralValue('ref');
      if length(LName) = 3 then
        begin
        LFocus := THL7DictSegmentMapSegment.Create(NIL);
        (LFocus as THL7DictSegmentMapSegment).FSegCode := LName;
        end
      else if (LName[1] = '(') and (Length(LName) = 5) then
        begin
        LFocus := THL7DictSegmentMapSegment.Create(NIL);
        (LFocus as THL7DictSegmentMapSegment).FSegCode := copy(LName, 2, 3);
        end
      else
        begin
        LFocus := THL7DictSegmentMapGroup.Create(NIL);
        (LFocus as THL7DictSegmentMapGroup).FGroupName := LName;
        ReadSchemaGroup(ADom, LFocus as THL7DictSegmentMapGroup, AVersion, AStruct);
        end;
      LFocus.FOptional := (LNode as TDomElement).getAttributeLiteralValue('minOccurs') = '0';
      LFocus.FRepeating := (LNode as TDomElement).getAttributeLiteralValue('maxOccurs') = 'unbounded';
      AGroup.FNodeList.AddObject(LName, LFocus);
      end;
    LNode := LNode.nextSibling;
    end;
end;

procedure THL7SchemaStore.DOMReadError(ASender: TObject; AError: TdomError; var VGo: boolean);
const ASSERT_LOCATION = ASSERT_UNIT+'.THL7SchemaStore.DOMReadError';
begin
  assert(Self.TestValid(THL7SchemaStore), ASSERT_LOCATION+': self is not valid');
  assert(assigned(AError), ASSERT_LOCATION+': Error is nil');
  VGo := false;
  if assigned(AError.location.relatedNode) then
    begin
    FDomErr := AError.code+': '+AError.message+' (at '+AError.location.relatedNode.localName+')';        { do not localize }
    end
  else
    begin
    FDomErr := AError.code+': '+AError.message;
    end;
end;


function THL7SchemaStore.LoadSchemaFromXML(AFileName, AVersion, AStruct: String): THL7DictSegmentMapGroup;
const
  ASSERT_LOCATION = ASSERT_UNIT+'.THL7SchemaStore.LoadSchemaFromXML';
var
  LParser: TXmlToDomParser;
  LDom: TDomImplementation;
begin
  assert(self.TestValid(THL7SchemaStore), ASSERT_LOCATION + ': self is not valid');
  assert(FileExists(AFileName), ASSERT_LOCATION + ': File "' + AFileName + '" not found');
  assert(AStruct <> '', ASSERT_LOCATION + ': Struct is blank');

  LDom := TDomImplementation.Create(NIL);
  try
    LDom.OnError := DOMReadError;
    LParser := TXmlToDomParser.Create(NIL);
    try
      LParser.DOMImpl := LDom;
      try
        FDomErr := '';
        LParser.fileToDom(AFileName);
      except
        on e:Exception do
          begin
          if FDomErr <> '' then
            e.message := e.message + ' '+FDomErr;
          raise;
          end;
      end;
    finally
      FreeAndNil(LParser);
    end;
    (LDom.documents.item(0) as TdomDocument).resolveEntityReferences(erReplace);
    Result := THL7DictSegmentMapGroup.Create(NIL);
    try
      Result.FGroupName := AStruct;
      ReadSchemaGroup(LDom.documents.item(0) as TdomDocument, Result, AVersion, AStruct);
    except
      FreeAndNil(Result);
      raise;
      end;
  finally
    FreeAndNil(LDom);
    end;
end;

initialization
  GHL7Dict := NIL;
  if kdeVersionMark = '' then
    exit;
finalization
  FreeAndNil(GHL7Dict);
end.

