unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, GPUnit, Menus, unit2, Grids;

const
  max_cases = 1000;
const
  term_max = 100;

type
  EParseError = class(Exception);


type
  Tmain_form = class(TForm)
    GP: TGPopulation;
    Memo1: TMemo;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Button3: TButton;
    Button4: TButton;
    Button2: TButton;
    LTerm: TListBox;
    LFn: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    TermMenu: TPopupMenu;
    FnMenu: TPopupMenu;
    AddNew1: TMenuItem;
    Edit1: TMenuItem;
    Delete1: TMenuItem;
    AddNew2: TMenuItem;
    Edit2: TMenuItem;
    Delete2: TMenuItem;
    Button5: TButton;
    GroupBox3: TGroupBox;
    g1: TStringGrid;
    l5: TLabel;
    l4: TLabel;
    DMenu: TPopupMenu;
    AddNewCase1: TMenuItem;
    DeleteCase1: TMenuItem;
    N1: TMenuItem;
    LoadData1: TMenuItem;
    SaveData1: TMenuItem;
    N2: TMenuItem;
    Reset1: TMenuItem;
    Label3: TLabel;
    Label4: TLabel;
    SD1: TSaveDialog;
    od1: TOpenDialog;
    Button1: TButton;
    procedure GPIndEval(Sender: TObject; Body: string);

    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure AddNew1Click(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure AddNew2Click(Sender: TObject);
    procedure Edit2Click(Sender: TObject);
    procedure Delete2Click(Sender: TObject);
    procedure GPAfterPopEval(Sender: TObject);
    procedure GPFitReached(Sender: TObject);
    procedure Reset1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure AddNewCase1Click(Sender: TObject);
    procedure DeleteCase1Click(Sender: TObject);
    procedure LoadData1Click(Sender: TObject);
    procedure SaveData1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

procedure update_gp_system; forward;

var
  main_form: Tmain_form;
  my_result: boolean;
  n_cases, case_no: cardinal;
  cases: array[1..term_max + 1, 1..max_cases] of boolean;

implementation

{$I ey.pas} {include the evaluation function sources}

{$R *.DFM}



procedure Tmain_form.GPIndEval(Sender: TObject; Body: string);
var
  r, j, f: integer;
begin
  f := 0;
  for j := 1 to n_cases do
    begin
      case_no := j;
      yylineno := 0;
      yyclear;
      yyinput := Body;
      r := yyparse;
      if (r <> 0) then raise EParseError.Create('Parsing Error');
      if my_result = cases[main_form.GP.GetTermCount + 1][case_no] then
        inc(f);
    end;
  GP.InstantFitness := round(100 * f / (n_cases));
  application.processmessages;
end;

procedure update_grid;
var
  i, p, k, j: integer;
begin
  with main_form do
    begin
      g1.colcount := 2;
      g1.Cells[0, 0] := 'in#';
      g1.Cells[1, 0] := 'out';
      g1.cells[0, 1] := '1';
      {g1.cells[1, 1] := '';}

      for i := 0 to Lterm.items.count - 1 do {update data grid}
        begin
          g1.colcount := g1.colcount + 1;
          g1.cells[g1.colcount - 1, 0] := g1.cells[g1.colcount - 2, 0];
          {g1.cols[g1.colcount - 2].clear;  }
          g1.cells[g1.colcount - 2, 0] := LTerm.items[i];
          l4.caption := inttostr(g1.colcount - 2);
          l5.caption := inttostr(g1.rowcount - 1);
        end;

      k := strtoint(l4.caption);
      n_cases := strtoint(l5.caption);
      for j := 1 to n_cases do
        begin
          g1.cells[0, j] := inttostr(j);
          {for i := 1 to k + 1 do
            if not cases[i, j] then
              g1.cells[i, j] := '0'
            else
              g1.cells[i, j] := '1'; }
        end;
    end;
end;

procedure update_gp_system;
var
  i, p, k, j: integer;
begin
  with main_form do
    begin
      Gp.init;

      k := strtoint(l4.caption);
      n_cases := strtoint(l5.caption);
      for i := 1 to k + 1 do
        begin
          for j := 1 to n_cases do
            if g1.cells[i, j] = '1' then
              cases[i, j] := true
            else
              cases[i, j] := false;
        end;

      for i := 0 to Lterm.items.count - 1 do {update terminal set }
        begin
          gp.addterm(LTerm.items[i]);
        end;

      for i := 0 to Lfn.items.count - 1 do {update function set }
        begin
          p := pos(',', Lfn.items[i]);
          gp.addfn(trim(copy(Lfn.items[i], 1, p - 2)), strtoint(trim(copy(Lfn.items[i], p + 2, 30))));
        end;







    end;
end;

procedure Tmain_form.Button2Click(Sender: TObject);
var
  i: integer;
begin
  GP.eval;

end;

procedure Tmain_form.Button3Click(Sender: TObject);
begin
  update_gp_system;
  GP.GenZero;
end;

procedure Tmain_form.Button4Click(Sender: TObject);
begin
  Gp.NextGen;
end;

procedure Tmain_form.Button5Click(Sender: TObject);
begin
update_gp_system;
  if not (gp.execute) then MessageDlg('Execution not completed.', mtWarning, [mbOK], 0);
  ;
end;





procedure Tmain_form.AddNew1Click(Sender: TObject);
begin
  add_form.caption := 'Add Terminal';
  add_form.l_par.visible := false;
  add_form.e_par.visible := false;
  if add_form.showmodal = mrOk then
    begin
      lterm.items.add(add_form.e_name.Text);
      g1.colcount := g1.colcount + 1;
      g1.cols[g1.colcount - 1] := g1.cols[g1.colcount - 2];
      g1.cols[g1.colcount - 2].clear;
    end;
  update_gp_system;
  update_grid;
end;

procedure Tmain_form.Edit1Click(Sender: TObject);
begin
  add_form.caption := 'Edit Terminal';
  add_form.l_par.visible := false;
  add_form.e_par.visible := false;
  add_form.e_name.text := lterm.items[lterm.itemindex];
  if add_form.showmodal = mrOk then
    lterm.items[lterm.itemindex] := add_form.e_name.Text;
  update_gp_system;
  update_grid;
end;

procedure Tmain_form.Delete1Click(Sender: TObject);
var
  p: integer;
begin
  if gp.gettermcount > 1 then
    begin
      p := lterm.itemindex;
      lterm.Items.delete(p);
      for i := p + 1 to g1.colcount - 2 do
        g1.cols[i] := g1.cols[i + 1];
      g1.cols[g1.colcount - 1].clear;
      update_gp_system;
      update_grid;
    end;
end;

procedure Tmain_form.AddNew2Click(Sender: TObject);
begin
  add_form.caption := 'Add Function';
  add_form.l_par.visible := True;
  add_form.e_par.visible := True;
  if add_form.showmodal = mrOk then
    lfn.items.add(add_form.e_name.Text + ' , ' + add_form.e_par.Text);
  update_gp_system;
end;

procedure Tmain_form.Edit2Click(Sender: TObject);
var
  p: smallint;
begin
  add_form.caption := 'Edit Function';
  add_form.l_par.visible := True;
  add_form.e_par.visible := True;

  p := pos(',', lfn.items[lfn.itemindex]);

  add_form.e_name.text := trim(copy(lfn.items[lfn.itemindex], 1, p - 2));
  add_form.e_par.text := trim(copy(lfn.items[lfn.itemindex], p + 2, 30));

  if add_form.showmodal = mrOk then
    lfn.items[lfn.itemindex] := add_form.e_name.Text + ' , ' + add_form.e_par.Text;
  update_gp_system;
end;

procedure Tmain_form.Delete2Click(Sender: TObject);
begin
  lfn.Items.delete(lfn.itemindex);
  update_gp_system;
end;

procedure Tmain_form.GPAfterPopEval(Sender: TObject);
var
  i: integer;
begin
  memo1.clear;
  memo1.lines.add('Generation: ' + inttostr(gp.Gen));
  memo1.lines.add('Best Individual #: ' + inttostr(gp.BestIndex));
  memo1.lines.add('Best Individual Fitness: ' + inttostr(gp.ind[gp.bestindex].fitness));
  memo1.lines.add('Best Individual Body: ' + gp.ind[gp.bestindex].body);
  memo1.lines.add('--------------------------');
  memo1.lines.add('No of terminals: ' + inttostr(Gp.GetTermCount));
  for i := 1 to gp.GetTermCount do
    memo1.lines.add(inttostr(i) + ') ' + gp.TermSet[i]);
  memo1.lines.add('No of functions: ' + inttostr(gp.GetFnCount));
  for i := 1 to gp.GetFnCount do
    memo1.lines.add(inttostr(i) + ') ' + gp.FnSet[i].fname + ' : ' + inttostr(gp.FnSet[i].n_par));
end;

procedure Tmain_form.GPFitReached(Sender: TObject);
begin
  MessageDlg('Minimum Specified Fitness Reached.' + #13 + #10 + 'Process Stopped.', mtInformation, [mbOK], 0);
  Gp.Stop;
end;

procedure Tmain_form.Reset1Click(Sender: TObject);
begin

  for i := 1 to g1.rowcount - 1 do
    g1.rows[i].clear;
  {l4.caption := inttostr(g1.colcount - 2);}
  g1.rowcount := 2;
  g1.cells[0, 1] := '1';
  l5.caption := inttostr(g1.rowcount - 1);
  update_grid;
end;

procedure Tmain_form.FormActivate(Sender: TObject);
begin
  g1.colcount := 2;
  g1.rowcount := 2;
  g1.Cells[0, 0] := 'in#';
  g1.Cells[1, 0] := 'out';
  g1.cells[0, 1] := '1';
  {g1.cells[1, 1] := '';}
  update_grid;
end;

procedure Tmain_form.AddNewCase1Click(Sender: TObject);
begin
  g1.rowcount := g1.rowcount + 1;
  l5.caption := inttostr(g1.rowcount - 1);
  g1.row := g1.rowcount - 1;
  update_grid;
end;

procedure Tmain_form.DeleteCase1Click(Sender: TObject);
var
  p: integer;
begin
  p := g1.row;
  if g1.rowcount > 2 then
    begin
      for i := p to g1.rowcount - 2 do
        g1.rows[i] := g1.rows[i + 1];
      g1.rows[g1.rowcount - 1].clear;
      g1.rowcount := g1.rowcount - 1;
      l5.caption := inttostr(g1.rowcount - 1);
    end
  else
    MessageDlg('minimum number of example cases reached', mtError, [mbOK], 0);
  update_grid;
end;

procedure Tmain_form.LoadData1Click(Sender: TObject);
var
  f: textfile;
  i, j: integer;
  n: integer;
  s: string;
begin
  if (od1.execute) then
    begin
      LTerm.Items.clear;
      assignfile(f, od1.filename);
      reset(f);
      readln(f, s);
      readln(f, n);
      l4.caption := inttostr(n);
      g1.colcount := n + 2;
      readln(f, n);
      l5.caption := inttostr(n);
      g1.rowcount := n + 1;

      for j := 0 to strtoint(l5.caption) + 1 do
        begin
          {if j > 0 then g1.cells[0, j] := inttostr(j);}
          for i := 1 to strtoint(l4.caption) + 1 do
            begin
              readln(f, s);
              if (j = 0) and (i < (strtoint(l4.caption) + 1)) then
                LTerm.Items.Add(trim(s));
              g1.cells[i, j] := trim(s);
            end;
        end;

(* readln(f,n);
l7.caption:=inttostr(n);
g2.rowcount:=n+1;
for j:=1 to strtoint(l7.caption)+1 do
 begin
 g2.cells[0,j]:=inttostr(j);
 readln(f,s);
 g2.cells[1,j]:=s;
 readln(f,n);
 g2.cells[2,j]:=inttostr(n);
 readln(f,s);
 g2.cells[3,j]:=s;
 end;  *)
      closefile(f);
      update_grid;
      update_gp_system;
    end;
end;

procedure Tmain_form.SaveData1Click(Sender: TObject);
var
  f: textfile;
  i, j: integer;
begin
  if (sd1.execute) then
    begin
      assignfile(f, sd1.filename);
      rewrite(f);
      writeln(f, 'genetix option');
      writeln(f, l4.caption); {no of terminals}
      writeln(f, l5.caption); {no of example cases}

      for j := 0 to strtoint(l5.caption) + 1 do
        begin
          for i := 1 to strtoint(l4.caption) + 1 do
            begin
              writeln(f, g1.cells[i, j]);
            end;
 {write(f,#13#10);}
        end;
(*
writeln(f,l7.caption); {no of functions}
for j:=1 to strtoint(l7.caption)+1 do
 begin
 writeln(f,g2.cells[1,j]);
 writeln(f,g2.cells[2,j]);
 writeln(f,g2.cells[3,j]);
 end; *)
      closefile(f);
    end;

end;

procedure Tmain_form.Button1Click(Sender: TObject);
begin
Gp.stop;
end;

end.

