unit VfW;

// This unit contains the AVIFile stuff from VfW.h, which
// is necessary to load and decode AVI files.
//
// Version     - 0.1.1
// Last Change - 02. September 1997

interface

uses Windows;

const AVIF_HASINDEX       = $00000010; // index at end of file?
      AVIF_MUSTUSEINDEX	  = $00000020;
      AVIF_ISINTERLEAVED  = $00000100;
      AVIF_WASCAPTUREFILE = $00010000;
      AVIF_COPYRIGHTED	  = $00020000;


      streamtypeVIDEO     = $73646976; // 'vids'
      streamtypeAUDIO     = $73647561; // 'auds'
      streamtypeMIDI      = $7364696D; // 'mids'
      streamtypeTEXT      = $73747874; // 'txts'

      // Flags for index
      AVIIF_LIST          = $00000001; // chunk is a 'LIST'
      AVIIF_TWOCC	  = $00000002;
      AVIIF_KEYFRAME      = $00000010; // this frame is a key frame
      AVIIF_FIRSTPART     = $00000020; // this frame is the start of a partial frame
      AVIIF_LASTPART      = $00000040; // this frame is the end of a partial frame
      AVIIF_MIDPART       = AVIIF_LASTPART+AVIIF_FIRSTPART;
      AVIIF_NOTIME	  = $00000100; // this frame doesn't take any time
      AVIIF_COMPUSE       = $0FFF0000; // these bits are for compressor use

      AVIERR_OK            =   0;
      AVIERR_UNSUPPORTED   =  -1;
      AVIERR_BADFORMAT     =  -2;
      AVIERR_MEMORY        =  -3;
      AVIERR_INTERNAL      =  -4;
      AVIERR_BADFLAGS      =  -5;
      AVIERR_BADPARAM      =  -6;
      AVIERR_BADSIZE       =  -7;
      AVIERR_BADHANDLE     =  -8;
      AVIERR_FILEREAD      =  -9;
      AVIERR_FILEWRITE     =  -10;
      AVIERR_FILEOPEN      =  -11;
      AVIERR_COMPRESSOR    =  -12;
      AVIERR_NOCOMPRESSOR  =  -13;
      AVIERR_USERABORT     =  -99;
      AVIERR_ERROR         =  -100;

      // AVI interface IDs
      IID_IAVIFile       : TGUID = (D1:$00020020;D2:$0;D3:$0;D4:($C0,$0,$0,$0,$0,$0,$0,$46));
      IID_IAVIStream     : TGUID = (D1:$00020021;D2:$0;D3:$0;D4:($C0,$0,$0,$0,$0,$0,$0,$46));
      IID_IAVIStreaming  : TGUID = (D1:$00020022;D2:$0;D3:$0;D4:($C0,$0,$0,$0,$0,$0,$0,$46));
      IID_IGetFrame      : TGUID = (D1:$00020023;D2:$0;D3:$0;D4:($C0,$0,$0,$0,$0,$0,$0,$46));
      IID_IAVIEditStream : TGUID = (D1:$00020024;D2:$0;D3:$0;D4:($C0,$0,$0,$0,$0,$0,$0,$46));

      // AVI class IDs
      CLSID_AVISimpleUnMarshal : TGUID = (D1:$00020009;D2:$0;D3:$0;D4:($C0,$0,$0,$0,$0,$0,$0,$46));
      CLSID_AVIFile            : TGUID = (D1:$00020000;D2:$0;D3:$0;D4:($C0,$0,$0,$0,$0,$0,$0,$46));

type PAVIFileInfoW = ^TAVIFileInfoW;
     TAVIFileInfoW = record
                       dwMaxBytesPerSec, // max. transfer rate
                       dwFlags,		     // the ever-present flags
                       dwCaps,
                       dwStreams,
                       dwSuggestedBufferSize,
                       dwWidth,
                       dwHeight,
                       dwScale,
                       dwRate,	         // dwRate/dwScale == samples/second
                       dwLength,
                       dwEditCount: DWORD;
                       szFileType: array[0..63] of WideChar; // descriptive string for file type
                     end;

     PAVIFileInfoA = ^TAVIFileInfoA;
     TAVIFileInfoA = record
                       dwMaxBytesPerSec, // max. transfer rate
                       dwFlags,		     // the ever-present flags
                       dwCaps,
                       dwStreams,
                       dwSuggestedBufferSize,
                       dwWidth,
                       dwHeight,
                       dwScale,
                       dwRate,	         // dwRate/dwScale == samples/second
                       dwLength,
                       dwEditCount: DWORD;
                       szFileType: array[0..63] of Char; // descriptive string for file type
                     end;
                     
     PAVIFileInfo  = ^TAVIFileInfo;
     TAVIFileInfo  = TAVIFileInfoA;

     TAVIStreamInfoA = record
                         fccType,
                         fccHandler,
                         dwFlags,        // contains AVITF_* flags
                         dwCaps: DWORD;
                         wPriority,
                         wLanguage: WORD;
                         dwScale,
                         dwRate,         // dwRate/dwScale == samples/second
                         dwStart,
                         dwLength,       // in units above...
                         dwInitialFrames,
                         dwSuggestedBufferSize,
                         dwQuality,
                         dwSampleSize: DWORD;
                         rcFrame: TRect;
                         dwEditCount,
                         dwFormatChangeCount,
                         szName:  array[0..63] of AnsiChar;
                       end;

     TAVIStreamInfoW = record
                         fccType,
                         fccHandler,
                         dwFlags,        // contains AVITF_* flags
                         dwCaps: DWORD;
                         wPriority,
                         wLanguage: WORD;
                         dwScale,
                         dwRate,         // dwRate/dwScale == samples/second
                         dwStart,
                         dwLength,       // in units above...
                         dwInitialFrames,
                         dwSuggestedBufferSize,
                         dwQuality,
                         dwSampleSize: DWORD;
                         rcFrame: TRect;
                         dwEditCount,
                         dwFormatChangeCount,
                         szName:  array[0..63] of WideChar;
                       end;

     PAVIStreamInfo = ^TAVIStreamInfo;
     TAVIStreamInfo = TAVIStreamInfoA;

     // IAVIStream interface
     PAVIStream = ^IAVIStream;
     IAVIStream = interface(IUnknown)
       function Create(lParam1, lParam2: Longint): HResult; stdcall;
       function Delete(lStart, lSamples: Longint): HResult; stdcall;
       function FindSample(lPos, lFlags: Longint): Longint; stdcall;
       function Info(var psi: TAVIStreamInfo; lSize: Longint): HResult; stdcall;
       function Read(lStart, lSamples: Longint; lpBuffer: Pointer; cbBuffer: Longint; var plBytes: Longint; var plSamples: Longint): HResult; stdcall;
       function ReadData(fcc: DWORD; lp: Pointer; var lpcb: Longint): HResult; stdcall;
       function ReadFormat(lPos: Longint; lpFormat: Pointer; var lpcbFormat: Longint): HResult; stdcall;
       function SetFormat(lPos: Longint; lpFormat: Pointer; lpcbFormat: Longint): HResult; stdcall;
       function SetInfo(var lpInfo: TAVIStreamInfoW; cbInfo: Longint): HResult; stdcall;
       function Write(lStart, lSamples: Longint; lpBuffer: Pointer; cbBuffer: Longint; dwFlags: DWORD; var plSampWritten: Longint; var plBytesWritten: Longint): HResult; stdcall;
       function WriteData(fcc: DWORD; lp: Pointer; cb:  Longint): HResult; stdcall;
     end;

     // IAVIFile interface
     PAVIFile = ^IAVIFile;
     IAVIFile = interface(IUnknown)
       function CreateStream(var ppStream: IAVIStream; pfi: PAVIFileInfo): HResult; stdcall;
       function DeleteStream(fccType: DWORD; lParam: Longint): HResult; stdcall;
       function EndRecord: HResult; stdcall;
       function GetStream(ppStream: PAVIStream; fccType: DWORD; lParam: Longint): HResult; stdcall;
       function Info(pfi: PAVIFileInfoW; lSize: Longint): HResult; stdcall;
       function ReadData(ckid: DWORD; lpData: Pointer; lpcbData: Longint): HResult; stdcall;
       function WriteData(ckid: DWORD; lpData: Pointer; cbData: Longint): HResult; stdcall;
     end;

     // IGetFrame interface
     // The functions 'BeginExtraction' and 'EndExtraction' have actually
     // the names 'Begin' and 'End', but we cannot use that identifiers for
     // obvious reasons.
     PGetFrame = ^IGetFrame;
     IGetFrame = interface(IUnknown)
       function BeginExtraction(lStart, lEnd, lRate: Longint): HResult; stdcall;
       function EndExtraction: HResult; stdcall;
       function GetFrame(lPos: Longint): PBitmapInfoHeader; stdcall;
       function SetFormat(lpbi: PBitmapInfoHeader; lpBits: Pointer; x, y, dx, dy: Integer): HResult; stdcall;
     end;

var AVILibLoaded : Boolean;

    AVIFileCreateStream : function(pfile: PAVIFile; ppavi: PAVISTREAM; psi: TAVIStreamInfoA): HResult; stdcall;
    AVIFileExit         : procedure; stdcall;
    AVIFileGetStream    : function(pfile: PAVIFile; var ppavi: PAVIStream; fccType: DWORD; lParam: Longint): HResult; stdcall;
    AVIFileInfo         : function(pfile: PAVIFile; pfi: PAVIFileInfo; lSize: Longint): HResult; stdcall;
    AVIFileInit         : procedure; stdcall;
    AVIFileOpen         : function(var ppfile: PAVIFile; szFile: LPCSTR; uMode: UINT; lpHandler: PGUID): HResult; stdcall;
    AVIFileRelease      : function(pfile: PAVIFile): ULONG; stdcall;
    AVIStreamGetFrame   : function(pgf:PGetFrame; lPos: Longint): Pointer; stdcall;
    AVIStreamGetFrameClose : function(pget: PGetFrame): HResult; stdcall;
    AVIStreamGetFrameOpen  : function(pavi: PAVIStream; lpbiWanted: PBitmapInfoHeader): PGetFrame; stdcall;
    AVIStreamSetFormat  : function(pavi: PAVIStream; lPos: Longint; lpFormat: Pointer; cbFormat: Longint): HResult; stdcall;
    AVIStreamInfo       : function(pavi: PAVIStream; psi: PAVIStreamInfo; lSize: Longint): HResult; stdcall;
    AVIStreamWrite      : function(pavi: PAVIStream; lStart, lSamples: Longint; lpBuffer: Pointer; cbBuffer: Longint; dwFlags: DWORD;
                                   var plSampWritten: Longint; var plBytesWritten: Longint): HResult; stdcall;
    AVIStreamRelease    : function(pavi: PAVISTREAM): ULONG; stdcall;

//------------------------------------------------------------------------------

implementation

uses SysUtils;

const AVILibrary = 'avifil32.dll';

var AVILibHandle : THandle;

//------------------------------------------------------------------------------

function InitAVILibrary: Boolean;

// load the AVI library and get proc addresses

var OldError: Longint;

begin
  OldError := SetErrorMode(SEM_NOOPENFILEERRORBOX);
  try
    try
      // try to load the DLL
      AVILibHandle:=LoadLibrary(AVILibrary);
      if AVILibHandle = 0 then Abort;
      // now read the relevant addresses
      AVIFileInfo:=GetProcAddress(AVILibHandle,'AVIFileInfo');
      AVIFileInit:=GetProcAddress(AVILibHandle,'AVIFileInit');
      AVIFileExit:=GetProcAddress(AVILibHandle,'AVIFileExit');
      AVIFileOpen:=GetProcAddress(AVILibHandle,'AVIFileOpenA');
      AVIFileCreateStream:=GetProcAddress(AVILibHandle,'AVIFileCreateStreamA');
      AVIFileGetStream:=GetProcAddress(AVILibHandle,'AVIFileGetStream');
      AVIStreamGetFrame:=GetProcAddress(AVILibHandle,'AVIStreamGetFrame');
      AVIStreamGetFrameClose:=GetProcAddress(AVILibHandle,'AVIStreamGetFrameClose');
      AVIStreamGetFrameOpen:=GetProcAddress(AVILibHandle,'AVIStreamGetFrameOpen');
      AVIStreamInfo:=GetProcAddress(AVILibHandle,'AVIStreamInfo');
      AVIStreamSetFormat:=GetProcAddress(AVILibHandle,'AVIStreamSetFormat');
      AVIStreamWrite:=GetProcAddress(AVILibHandle,'AVIStreamWrite');
      AVIStreamRelease:=GetProcAddress(AVILibHandle,'AVIStreamRelease');
      AVIFileRelease:=GetProcAddress(AVILibHandle,'AVIFileRelease');
      // we got so far, thus let's initialize the lib
      AVIFileInit;
      Result:=True;
    except
      Result:=False;
    end;
  finally
    SetErrorMode(OldError);
  end;
end;

//------------------------------------------------------------------------------

procedure UnloadAVILibrary;

begin
  if AVILibLoaded then
  begin
    AVIFileExit;
    FreeLibrary(AVILibhandle);
  end;
end;

//------------------------------------------------------------------------------

initialization
  AVILibLoaded:=InitAVILibrary;
finalization
  UnloadAVILibrary;
end.
