unit CSG;

// CSG         - Support routines for constructive solid geometrie, most of them
//               are taken from SGI's advanced programming samples
// Version     - 0.1.3
// Last Change - 19. Septmeber 1997
// for more information see history

interface

uses OpenGL;

type TCSGOperation = (A_OR_B,A_AND_B,A_SUB_B);
     TCSGGroup     = (CSG_A,CSG_B);

     TCSGOperator  = (Union,Intersection,Substraction);

procedure CSG_DoAND(A,B: array of GLEnum);
procedure CSG_DoOR(A,B: array of GLEnum);
procedure CSG_DoSUB(A,B: array of GLEnum);

//------------------------------------------------------------------------------

implementation

uses GLScene;

type PCSGNode = ^TCSGNode;
     TCSGNode = record
                  Operation   : TCSGOperator;
                  SceneObject : TSceneObject;
                  Left, Right : PCSGNode;
                end;

//------------------------------------------------------------------------------

function IsPrimitive(ANode: PCSGNode) : Boolean;

begin
  Result:=False;
  if assigned(ANode) then
    if not (assigned(Anode^.Left) or assigned(ANode^.Right)) then Result:=True;
end;

//------------------------------------------------------------------------------

procedure DrawLists(AList: array of GLEnum);

var I : Integer;

begin
  for I:=0 to AList[0]-1 do
  begin
    glPushMatrix;
    glCallList(AList[I+1]);
    glPopMatrix;
  end;
end;

//------------------------------------------------------------------------------

procedure FirstInsideSecond(A,B: array of GLEnum; Face, Test: GLEnum);

{Set stencil buffer to show the part of A (front or back face) that's inside B's volume.
 Requirements: GL_CULL_FACE enabled, depth func GL_LESS
 Side effects: depth test, stencil test, stencil op}

begin
  glEnable(GL_DEPTH_TEST);
  glColorMask(GL_FALSE,GL_FALSE,GL_FALSE,GL_FALSE);
  glCullFace(Face);  // controls which face of A to use
  DrawLists(A);      // draw a face of A into depth buffer
  // use stencil plane to find parts of B in A
  glDepthMask(GL_FALSE);
  glEnable(GL_STENCIL_TEST);
  glStencilFunc(GL_ALWAYS,0,0);
  glStencilOp(GL_KEEP,GL_KEEP,GL_INCR);
  glCullFace(GL_BACK);
  // increment the stencil where the front face of B is drawn
  DrawLists(B);
  glStencilOp(GL_KEEP,GL_KEEP,GL_DECR);
  glCullFace(GL_FRONT);
  // decrement the stencil buffer where the back of B is drawn
  DrawLists(B);
  glDepthMask(GL_TRUE);
  glColorMask(GL_TRUE,GL_TRUE,GL_TRUE,GL_TRUE);
  glStencilFunc(Test,0,1);
  glDisable(GL_DEPTH_TEST);
  glCullFace(Face);
  DrawLists(A);  // draw the part of A that's in B
end;

//------------------------------------------------------------------------------

procedure FixDepth(A: array of GLEnum);

begin
  glColorMask(GL_FALSE,GL_FALSE,GL_FALSE,GL_FALSE);
  glEnable(GL_DEPTH_TEST);
  glDisable(GL_STENCIL_TEST);
  glDepthFunc(GL_ALWAYS);
  DrawLists(A);
  glDepthFunc(GL_LESS);
end;

//------------------------------------------------------------------------------

procedure CSG_DoAND(A,B: array of GLEnum);

{Draw all parts of the OR'ed objects of A and the OR'ed objects of B, which
 are in both.}

begin
  FirstInsideSecond(B,A,GL_BACK,GL_NOTEQUAL);
  FixDepth(A);
  FirstInsideSecond(A,B,GL_BACK,GL_NOTEQUAL);
  glDisable(GL_STENCIL_TEST);
end;

//------------------------------------------------------------------------------

procedure CSG_DoOR(A,B: array of GLEnum);

// doing OR is really easy, simply draw all objects

begin
  DrawLists(A);
  DrawLists(B);
end;

//------------------------------------------------------------------------------

procedure CSG_DoSUB(A,B: array of GLEnum);

{Draw all parts of the OR'ed objects of A and the OR'ed objects of B, which
 are in A but not in B.}

begin
  FirstInsideSecond(B,A,GL_FRONT,GL_NOTEQUAL);
  FixDepth(A);
  FirstInsideSecond(A,B,GL_BACK,GL_EQUAL);
  glDisable(GL_STENCIL_TEST);
end;

//------------------------------------------------------------------------------

end.
