{ Written by William Schroeder (lqdshadow@yahoo.com) of
  Fields Financial Services, Inc.

  This code is freeware and may be used along with the supplied
  DLL in any form. This code and the associated DLL may be modified.
  All legal restrictions of use apply to the use of this code and
  the DLL.

  GIFVIEW.DLL exports only two functions:

  function GetGIFFile(AFileName: PChar): HBITMAP; stdcall;
  * Returns the handle to a Windows bitmap holding the image data
    extracted from the specified GIF file.

  function GetGIFBuffer(Buf: Pointer; BufSize: Integer): HBITMAP; stdcall;
  * Returns the handle to a Windows bitmap holding the image data
    extracted from a buffer that contains the entire contents of a
    GIF file.

  See TGif.SetFileName and TGif.SetGifBuffer for examples of use.
}

unit Gif; { Version 1.0 }

interface

uses
  Windows, Classes, ExtCtrls;

type
  TGif = class(TImage)
  private
    FFileName: String;
    procedure SetFileName(const Value: String);
  protected
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure SetGifBuffer(const NewBuf: Pointer; BufSize: LongInt);
  published
    property GIFFile: String read FFileName write SetFileName;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TGif]);
end;

{ TGif }

constructor TGif.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

destructor TGif.Destroy;
begin
  inherited Destroy;
end;

procedure TGif.SetFileName(const Value: String);
var
  GetGIFFile: function (AFileName: PChar): HBITMAP; stdcall;
  hDLLInst: THandle;
begin
  FFileName := Value;
  hDLLInst:= LoadLibrary('GIFVIEW.DLL');
  if (hDLLInst > 0) then
  begin
    try
      GetGIFFile := GetProcAddress(hDLLInst,'GetGIFFile');
      if Assigned(GetGIFFile) then
        Picture.Bitmap.Handle := GetGIFFile(PChar(FFileName));
    finally
      FreeLibrary(hDLLInst);
    end;
  end;
end;

procedure TGif.SetGifBuffer(const NewBuf: Pointer; BufSize: Integer);
var
  GetGIFBuffer: function (Buf: Pointer; BufSize: Integer): HBITMAP; stdcall;
  hDLLInst: THandle;
begin
  if (NewBuf <> nil) and (BufSize > 0) then
  begin
    hDLLInst:= LoadLibrary('GIFVIEW.DLL');
    if (hDLLInst > 0) then
    begin
      try
        GetGIFBuffer := GetProcAddress(hDLLInst,'GetGIFBuffer');
        if Assigned(GetGIFBuffer) then
          Picture.Bitmap.Handle := GetGIFBuffer(NewBuf, BufSize);
      finally
        FreeLibrary(hDLLInst);
      end;
    end;
  end;
end;

end.
