{***************************************************************
 *
 * Unit Name: stdabout
 * of Project: testexpert in C:\LIB\EnExperts
 * Purpose  :  To provide an about box with a standardised appearance
 *             Easy links to website and feedback email address
 * Copyright: Copyright  30/12/01 Peter Ivan Dunne, All rights reserved
 * No warranty Express or Implied you use
 * this code at your own risk!
 * Author   :Peter Ivan Dunne
 * History  :Created 30/12/01 12:19:40
 * Future   :Online registration, Online updates
 ****************************************************************}


unit stdabout;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls, Registry, RXCtrls, ShellApi;

type
  TAboutForm = class(TForm)
    OKButton: TButton;
    SecretPanel1: TSecretPanel;
    M: TMemo;
    VersionLabel: TLabel;
    Version: TLabel;
    CopyrightLabel: TLabel;
    ProgramIcon: TImage;
    ProductName: TLabel;
    EmailUrl: TLabel;
    UrlLabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure UrlLabelClick(Sender: TObject);
  private
    { Private declarations }
    R:TRegistry;
  public
    procedure DoDetails(FileName, Lang: String);
    { Public declarations }
  end;


var
  AboutForm: TAboutForm;
  OSVersionInfo:TOSVersionInfo;

procedure Showabout;

implementation

{$R *.DFM}

procedure Showabout;
begin
 try
  AboutForm:=TAboutForm.Create(application);
  AboutForm.ShowModal;
 finally
  AboutForm.Free;
 end;
end;

procedure TAboutForm.DoDetails(FileName,Lang: String);
{This section demonstrates how to get at the version info
in executables.}

const
  InfoNum = 14;
  InfoStr : array [1..InfoNum] of String =
    ('CompanyName', 'FileDescription', 'FileVersion',
     'InternalName', 'LegalCopyright', 'LegalTradeMarks',
     'OriginalFilename', 'ProductName', 'ProductVersion',
     'Comments','Email', 'URL', 'ProductKey',
     'UpdateKey');
var
  S         : String;
  n, Len, i : Dword;
  Buf       : PChar;
  Value     : PChar;
begin
  S := FileName;
  n := GetFileVersionInfoSize(PChar(S),n);
  if n > 0 then begin
    Buf := AllocMem(n);
    M.Lines.Add('FileVersionInfoSize='+IntToStr(n));
    GetFileVersionInfo(PChar(S),0,n,Buf);
    for i:=1 to InfoNum -4 do
     begin
      if VerQueryValue(Buf,PChar('StringFileInfo\'+lang+'\'+
                                 InfoStr[i]),Pointer(Value),Len) then
        M.Lines.Add(Format('%15s = %s',[InfoStr[i], Value]));
      end;
      if VerQueryValue(Buf,PChar('StringFileInfo\'+lang+'\'+
                                 InfoStr[8]),Pointer(Value),Len) then
        ProductName.Caption:=Value;
      if VerQueryValue(Buf,PChar('StringFileInfo\'+lang+'\'+
                                 InfoStr[5]),Pointer(Value),Len) then
        CopyrightLabel.Caption:=Value;
      if VerQueryValue(Buf,PChar('StringFileInfo\'+lang+'\'+
                                 InfoStr[9]),Pointer(Value),Len) then
        VersionLabel.Caption:=Value;
      if VerQueryValue(Buf,PChar('StringFileInfo\'+lang+'\'+
                                 InfoStr[11]),Pointer(Value),Len) then
        EmailUrl.Caption:='mailto:'+Value+'?subject='+application.title;
      if VerQueryValue(Buf,PChar('StringFileInfo\'+lang+'\'+
                                 InfoStr[12]),Pointer(Value),Len) then
        UrlLabel.Caption:=Value;
    FreeMem(Buf,n);
  end else
    M.Lines.Add('No FileVersionInfo found');
end;

{Borland TI}

procedure TAboutForm.FormCreate(Sender: TObject);
var
  TempFilename: array[0..255] of char;
  l:dWord;
  str:pchar;
  fUserName,WorkGroup,ComputerName,Comment:String;

begin
 Caption:=Application.Title;
 R:=TRegistry.Create;
 R.Rootkey:=Hkey_Local_Machine;
 R.LazyWrite:=false;
  R.OpenKey('System\CurrentControlSet\Services\VxD\VNETSUP', False);
  Workgroup := R.ReadString('Workgroup');
  ComputerName := R.ReadString('ComputerName');
  Comment := R.ReadString('Comment');
  R.CloseKey;
{   if not R.OpenKey('SOFTWARE\Microsoft\Windows NT\CurrentVersion', False)
   then    }
    R.OpenKey('SOFTWARE\Microsoft\Windows\CurrentVersion', False);
  str:=TempFileName;  l:=128;
  if not GetUserNameA(str,l) then FUserName:='Failure reading user name'
   else fusername:=str;
 with M.Lines do
 begin
// Process Windows info first
  Add(Format('User: %s on %s (%s) in domain:%s',[fUserName,ComputerName,Comment,Workgroup]));
  Add(Format('Running %s Version %s Registered to %s of %s',[R.ReadString('ProductName'),
   R.ReadString('VersionNumber'),R.ReadString('RegisteredOwner'),
   R.ReadString('RegisteredOrganization')]));
   R.CloseKey;
 end;
   with M.Lines do
    begin
     Add('');
     Add(Format('-- Version Information for %s in %s--',
      [Application.Title, Application.ExeName]));
     Add('');
    end;
  DoDetails(Application.ExeName,'040904E4');
  if isLibrary then
   begin
      GetModuleFileName(HInstance, TempFileName, SizeOf(TempFileName)-1);
      DoDetails(StrPas(TempFileName),'040904E4');
   end;
 R.Free;
end;

procedure TAboutForm.OKButtonClick(Sender: TObject);
begin
 Close;
end;

procedure TAboutForm.UrlLabelClick(Sender: TObject);
begin
 ShellExecute(Handle,'open',PChar(TLabel(Sender).Caption),nil,nil,SW_SHOW);
end;

end.

