{ Gauss6

 Autor

    (c) Jose Maria Gias
    email : sigecom@arrakis.es

 02.Ene.1999

 Delphi 4

 Freeware  - Esto es un ejemplo, por lo cual no se admiten reclamaciones ni se
             ofrecen garantas ni soporte de ninguna clase.

 Funciones Matemticas utilizadas
    - Delphi4\source\rtl\sys\math.pas
    - Estadstica Introduccin  - Universidad  nacional de educacin a distancia
    - Estadistica bsica practica - Wonnacott y Wonnacott
    ** Se han incorporado a la Unit las funciones necesarias **

 Ejemplo de Grfico de Distribucin de Frecuencias y Desviacin Estandar -
 Campana de Gauss en funcin de las muestras obtenidas y los valores de control
 de un proceso productivo normal.

 Se consideran los valores de Limites de control de Ingenieria para el proceso
 productivo y Tolerancias de Maquina como Limites de control

 Para utilizar en un Project retirar el codigo precedido de 'Demo' y pasarle los
 datos

 Para experimentar con lo valores, es posible cambiar el Sigma y las tolerancias

 El valor de Sigma para la generacion aleatoria de medidas se actualiza en cada
 captura de datos, generando la siguiente serie de medidas a partir del ultimo
 valor

}

unit gauss_6sp;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Teengine, Chart, Series, StdCtrls,
  Buttons, Mask, Spin, ArrowCha, Grids, TeeProcs, QrTee;

type
  TEstadistica = class(TForm)
    EditMedia: TEdit;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    BS1: TBarSeries;
    Chart1: TChart;
    LS2: TLineSeries;
    Label2: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    EditIncertidumbre: TEdit;
    EditVarianza: TEdit;
    EditSigma: TEdit;
    EditBajo: TMaskEdit;
    EditAlto: TMaskEdit;
    EditReco: TEdit;
    Label9: TLabel;
    Grid1: TStringGrid;
    EditSkew: TEdit;
    EditKurt: TEdit;
    Label7: TLabel;
    Label10: TLabel;
    EditCpTol: TEdit;
    EditCpKTol: TEdit;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    EditCpLim: TEdit;
    Label14: TLabel;
    EditCpKLim: TEdit;
    Label15: TLabel;
    Label16: TLabel;
    EditCpl: TEdit;
    EditCpu: TEdit;
    Label17: TLabel;
    EditCr: TEdit;
    Label18: TLabel;
    EditLimSup: TEdit;
    Label19: TLabel;
    EditLimInf: TMaskEdit;
    Label20: TLabel;
    EditTolSup: TMaskEdit;
    Label21: TLabel;
    EditTolInf: TMaskEdit;
    Chart2: TChart;
    LSTolInf: TFastLineSeries;
    LSMedida: TFastLineSeries;
    LSTolSup: TFastLineSeries;
    LSLimSup: TFastLineSeries;
    LSLimInf: TFastLineSeries;
    LSMenos3S: TFastLineSeries;
    LSMas3S: TFastLineSeries;
    Label22: TLabel;
    EditMenos3: TEdit;
    Label23: TLabel;
    EditMas3: TEdit;
    Label24: TLabel;
    EditCrTol: TEdit;
    Label8: TLabel;
    EditMa: TEdit;
    Label25: TLabel;
    EditMuestras: TEdit;
    LSMa: TFastLineSeries;
    Label26: TLabel;
    EditZInfLim: TMaskEdit;
    EditZSupLim: TEdit;
    Label27: TLabel;
    LSMS: TLineSeries;
    Label28: TLabel;
    EditFX: TEdit;
    LSMI: TLineSeries;
    SECantidad: TSpinEdit;
    Timer1: TTimer;
    CB1: TCheckBox;
    Cantidad: TLabel;
    Panel1: TPanel;
    BCerrar: TBitBtn;
    BB3d: TBitBtn;
    BRecalcular: TBitBtn;
    BBImprimir: TBitBtn;
    Series1: TBarSeries;
    procedure BRecalcularClick(Sender: TObject);
    procedure BCerrarClick(Sender: TObject);
    procedure BB3dClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SECantidadKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure EditLimSupChange(Sender: TObject);
    procedure EditLimInfChange(Sender: TObject);
    procedure EditTolSupChange(Sender: TObject);
    procedure EditTolInfChange(Sender: TObject);
    procedure EditSigmaChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CB1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure BBImprimirClick(Sender: TObject);
  private
    { Private declarations }
  public
    // Funciones extraidas de la libreria Math.Pas de Delphi 32

    //IntPower: Raise base to an integral power.  Fast.
    function IntPower(X: Double; I: Integer): Double;

    // Power: Raise base to any power.
    // For fractional exponents, or exponents > MaxInt, base must be > 0.
    function Power(Base, Exponent: Double): Double;

    // RandG produces random numbers with Gaussian distribution about the mean.
    // Useful for simulating data with sampling errors.
    function RandG(Mean, StdDev: Double): Double;

    procedure CopySeries(DestChart: TQRDBChart; SourceChart:TChart; AOwner:TComponent);
  end;

var
  Estadistica: TEstadistica;

  {Demo}
  Teorico,LimSup,LimInf,TolSup,TolInf,Sigma : Double;

  {Demo}
  Datos : array [1..1001] of Double;

  {La tabla Datos[..] la podemos traspasar desde cualquier otra unidad con
   cualquier cantidad de valores entre 5 y el valor necesario, 1001 en este caso.
   Tendr funcionalidad hasta que encuentre un valor 0 en que la dar por
   terminada}

implementation

uses Gausprsp;

{$R *.DFM}

procedure TEstadistica.BRecalcularClick(Sender: TObject);
var
 I,n,J : Integer;
 Frecuencia : array[1..21] of Double;
 NVeces : array[1..21] of Double;
 Y,M,S,P,V,K,W,e,x,Incer,Menor,Mayor,TopGra,M2,M3,M4,Kurt,Skew,Cp,Cpk,Cpl,Cpu,Cr,
 ZMas, ZMenos,CfAlto,CfAncho : Double;
 TxtGra : String;
begin

 {- Valores aleatorios para la demo.
  - En la aplicacion cargar los valores a medir en el array Datos[] y borrar
    las lineas etiquetadas con 'Demo'}

 {Demo}
 for I := 1 to 1000 do Datos[I] := 0;
 if Sigma < 0.2 then Sigma := 1;
 for I := 1 to SECantidad.Value do Datos[I] := RandG(Teorico + 0.3, Sigma);
 {End Demo}


{Clculo de la Media aritmtica}
 K := 0.0;
 I := 1;        {Utilizacin temporal para el Control del Bucle del array   }

 M := Datos[I]; {Utilizacin temporal de M para ver valor mnimo que sea > 0}

 W := 0.0;      {Utilizacin temporal de W para ver valor mximo}

 n := 0;        {Cantidad de valores > 0 en el array}

 {Como la tabla puede ser variable, se tendran en cuenta los datos hasta que vea
  el primer valor 0}
 while Datos[I] > 0 do begin
   K := K + Datos[I]; {Suma de valores para el calculo de la media aritmetica}
   if Datos[I] < M then M := Datos[I];
   if Datos[I] > W then W := Datos[I];
   n := n + 1;
   I := I + 1;
 end;

 {Muestra de los valores de control del proceso}
 EditMa.Text       := FloatToStr(Teorico);{Valor terico de ajuste de la medida}
 EditMuestras.Text := FloatToStr(n);     {Cantidad de muestras}
 EditLimSup.Text   := FloatToStr(LimSup);{Lmite superior de Ingeniera}
 EditLimInf.Text   := FloatToStr(LimInf);{Lmite Inferior de Ingeniera}
 EditTolSup.Text   := FloatToStr(TolSup);{Tolerancia superior del proceso}
 EditTolInf.Text   := FloatToStr(TolInf);{Tolerancia inferior del proceso}
 EditBajo.Text     := FloatToStr(M);     {Valor mas pequeo encontrado en la tabla Datos[]}
 if M < TolInf then EditBajo.Font.Color := clRed else EditBajo.Font.Color := clBlack;

 EditAlto.Text     := FloatToStr(W);     {Valor mas grande encontrado en la tabla Datos[]}
 if W > TolSup then EditAlto.Font.Color := clRed else EditAlto.Font.Color := clBlack;

 EditReco.Text     := FloatToStr(W-M);   {Diferencia entre la muestra mas grande y la mas pequea}
 M                 := K / n;
 EditMedia.Text    := FloatToStr(M); {Media aritmtica de los valores > 0 de la tabla}

 {Clculo de la varianza}
 K := 0;
 for I := 1 to n do K := K + ((Datos[I] - M)*(Datos[I] - M));
 V  := K / (n - 1);
 EditVarianza.Text := FloatToStr(V);

 {Clculo de la Desviacin Estandar "Sigma"}
 S               := Sqrt(V);
 EditSigma.Text  := FloatToStr(S);
 EditMenos3.Text := FloatToStr(M - (S*3)); {Valor de Menos 3 Sigma}
 EditMas3.Text   := FloatToStr(M + (S*3)); {Valor de Mas 3 Sigma}

 {Demo}
 Sigma := S; {Utilizado en la Demo para hacer dinamico el valor de Sigma}

 {Medida de asimetra del Momento 2 de la muestra}
 M2 := K / n;

 {Skeweness - Medidad de asimetra del Momento 3 de la muestra}
 K := 0;
 for I := 1 to n do K := K+((Datos[I]-M)*(Datos[I]-M)*(Datos[I]-M));
 M3   := K / n;
 Skew := M3 / Sqrt(M2*M2*M2);
 EditSkew.Text := FloatToStr(Skew);

 {Kurtosis - Medida de simetria del momento 4 de la muestra}
 K := 0;
 for I := 1 to n do K := K+((Datos[I]-M)*(Datos[I]-M)*(Datos[I]-M)*(Datos[I]-M));
 M4   := K / n;
 Kurt := (M4 / (M2*M2))-3;
 EditKurt.Text := FloatToStr(Kurt);

 {Clculo de la Capacidad de proceso  Cp. Es un indicatico de como es bueno un
  producto con respecto a lo especificado, indicando la uniformidad que el proceso
  es capaz de conseguir en relacin a la tolerancia. Se consideran Valores buenos
  para el proceso cuando son superiores a 1.33
  El Clculo se realiza contra los valores de Tolerancia y Limites con arreglo a los
  siguientes argumentos

  - El Cp con respecto a la tolerancia se calcula con K = 2 Sigma ya que generalmente
    es un parmetro de control de proceso para maquinaria entre otros.

  - El Cp con respecto a los Limites de ingenieria se calcula con K = 3 Sigma ya
    que suele utilizarse para el control del proceso productivo en el cual incluyen
    mas factores aleatorios}

 Cp             := (TolSup-TolInf)/(4*S);
 EditCpTol.Text := FloatToStr(Cp);
 if Cp < 1.33 then EditCpTol.Font.Color := clRed else EditCpTol.Font.Color := clBlack;

 Cp             := (LimSup-LimInf)/(6*S);
 EditCpLim.Text := FloatToStr(Cp);
 if Cp < 1.33 then EditCpLim.Font.Color := clRed else EditCpLim.Font.Color := clBlack;

 {Clculo del proceso contra el lmite inferior de ingeniera Cpl}
 Cpl          := (M-LimInf)/(3*S);
 EditCpl.Text := FloatToStr(Cpl);

 {Clculo del proceso contra el lmite superior de ingeniera Cpl}
 Cpu          := (LimSup-M)/(3*S);
 EditCpu.Text := FloatToStr(Cpu);

 {Clculo de la Capacidad de proceso CpK. Es un coeficiente de como es un proceso
  con respecto a sus especificaciones, indicando si el proceso producira medidas
  dentro de los limites de tolerancia. Se consideran valores buenos a partir
  de 1.33 y es el valor menor de Cpu y Cpl
  El Clculo se realiza contra los valores de Tolerancia y Limites con los mismos
  argumentos que para calcular el Cp}

 Cpk             := (TolSup-M)/(2*S);
 if Cpk > ((M-TolInf)/(2*S)) then CpK := ((M-TolInf)/(2*S));
 EditCpKTol.Text := FloatToStr(CpK);
 if Cpk < 1.33 then EditCpKTol.Font.Color := clRed else EditCpKTol.Font.Color := clBlack;

 Cpk             := (LimSup-M)/(3*S);
 if Cpk > ((M-LimInf)/(3*S)) then CpK := ((M-LimInf)/(3*S));
 EditCpKLim.Text := FloatToStr(CpK);
 if Cpk < 1.33 then EditCpKLim.Font.Color := clRed else EditCpkLim.Font.Color := clBlack;

 {Clculo del Cr. Es el inverso del Cp. Se muestra con respecto a los Lmites
  y Tolerancias}
 Cr             := (6*S)/(LimSup-LimInf);
 EditCr.Text    := FloatToStr(Cr);

 Cr             := (4*S)/(TolSup-TolInf);
 EditCrTol.Text := FloatToStr(Cr);

 {Clculo de la Z Superior para el posterior Clculo de los % fuera de Lmites
  con arreglo a las tablas normales}

  ZMas   := (LimSup - M)/S;
  EditZSupLim.Text := FloatToStr(ZMas);

 {Clculo de la Z Inferior para el posterior Clculo de los % fuera de Lmites
  con arreglo a las tablas normales}

  ZMenos := (M - LimInf)/S;
  EditZInfLim.Text := FloatToStr(ZMenos);

 {Incertidumbre de la medida

  La incertidumbre de la medida sirve para ayudar a establecer los lmites de
  control en un proceso, de forma que pueda acotarse con mayor exactitud las
  medidas que entraran dentro de los margenes de tolerancia con cierta
  fiabilidad. Podriamos resumirlo como la duda razonable del proceso de medida.

  Hay muchas formulas para el clculo de la incertidumbre, necesitando la
  mayora de ellas el conocimiento de la incertidumbre del patrn con el cual
  se han tomado las medidas, cosa que en este caso lgicamente desconocemos.

  Para este caso de muestra podemos utilizar una basada en tablas preestablecidas
  para el clculo, en funcin de la cantidad de medidas que tenga la muestra.

  La frmula que emplearemos y que se emplea en el Plan Nacional de Calidad
  Espaol es la siguiente:
                       S
   Incer = 2 * W * ---------
                    Sqrt(n)

   Incer : Incertidumbre de la medida
   W     : Valor de tablas que podemos ver en el cdigo del programa mas adelante
   S     : Sigma
   n     : Nmero de medidas de la muestra. mnimo 5 medidas }

  if n > 4 then begin
    if      n =  5 then W := 1.4
    else if n =  6 then W := 1.3
    else if n =  7 then W := 1.3
    else if n =  8 then W := 1.2
    else if n >= 9 then W := 1.0;

    Incer := 2 * W * (S / Sqrt(n));
    EditIncertidumbre.Text := FloatToStr(Incer);
  end;

 {Clculo de los valores mas pequeo y mas grande a representar en el grfico
  contando con los valores medidos y las tolerancias y limites de ingeniera
  para el proceso. lo utilizaremos para calcular los rangos de frecuencias}

 Menor := StrToFloat(EditBajo.Text);
 if Menor > TolInf    then Menor := TolInf;
 if Menor > LimInf    then Menor := LimInf;
 if Menor > (M-(3*S)) then Menor := M-(3*S);

 Mayor := StrToFloat(EditAlto.Text);
 if Mayor < TolSup    then Mayor := TolSup;
 if Mayor < LimSup    then Mayor := LimSup;
 if Mayor < (M+(3*S)) then Mayor := M+(3*S);

 {Distribucin de las frecuencias para contar las ocurrencias en cada rango de
  frecuencias con respecto a los valores extremos de Mayor y Menor con un valor
  de CfAncho para cada paso de frecuencia que ser utilizado para escalar los
  grficos.

  La tabla tiene 21 valores por que necesitamos conocer el principio y final de
  cada rango, aunque realmente solo utilizamos 20}

 CfAncho       := (Mayor-Menor) / 20;
 Frecuencia[1] := Menor;

 for I := 2 to 21 do Frecuencia[I] := Frecuencia[I-1] + CfAncho;

 {Contar las ocurrencias de las medidas ocurridas en cada rango para sacar la
  distribucion de frecuencias}

 for I := 1 to 21 do NVeces[I] := 0; {Inicializar la tabla}
 for I := 1 to 20 do
  for J := 1 to n do begin        {Utilizacin temporal de J}
   if(Datos[J] >= Frecuencia[I]) and (Datos[J] < Frecuencia[I+1]) then
    NVeces[I] := NVeces[I] + 1;
  end;

 {Mostrar las ocurrencias de frecuencias en un grid como ayuda de comprension}
 Grid1.Cells[0,0] := ' Valor';
 Grid1.Cells[1,0] := 'Cantidad';

 for I := 1 to 20 do begin
  {Limitar a 2 los decimales del valor convertido}
  TxtGra := FloatToStr(Frecuencia[I]);
  if Pos(',',TxtGra) > 0 then TxtGra := Copy(TxtGra,1,Pos(',',TxtGra)+1);
  Grid1.Cells[0,I] := '=> ' + TxtGra ;

  TxtGra := FloatToStr(Frecuencia[I+1]);
  if Pos(',',TxtGra) > 0 then TxtGra := Copy(TxtGra,1,Pos(',',TxtGra)+1);
  Grid1.Cells[0,I] := Grid1.Cells[0,I] + '  <' + TxtGra;

  Grid1.Cells[1,I] := FloatToStr(NVeces[I]);
 end;
 Grid1.Cells[0,21] := 'Total Muestras =';
 Grid1.Cells[1,21] := IntToStr(n);

 {Clculo del coeficiente de escala de altura para la correspondencia del Histograma
  y la Campana de gauss

  - Para superponer la campana de gauss sobre el histograma de frecuencias es preciso
    escalar la superficie del histograma a valor = 1 ya que la superficie de la
    campana de gauss de la distribucin normal es 1

    Posteriormente tanto la campana como el histograma habra que hacerlo proporcional
    al numero de muestras analizadas para poder relacionar las escalas del grfico

  - Primero ajustamos los valores de frecuencias en funcion del numero de muestras
     y el paso de anchura del grfico}

 for I  := 1 to 20 do if NVeces[I] > 0 then NVeces[I] := (NVeces[I]/n)*CfAncho;

 { - Calculamos primero el valor sumatorio de la altura todas las muestras, con
      lo cual ya tenemos escalado el histograma}

 CfAlto := 0;
 for I  := 1 to 20 do CfAlto := CfAlto + NVeces[I];

 { - Multiplicamos todos los valores por el inverso del CfAlto para que la suma
      sea 1}

 for I  := 1 to 20 do if NVeces[I] > 0 then NVeces[I] := (NVeces[I])*(1/CfAlto);

 { - Si ahora sumaramos la tabla NVeces veramos que es igual a 1. Por ejemplo :

     CfAlto := 0;
     for I  := 1 to 20 do CfAlto := CfAlto + NVeces[I];
     Grid1.Cells[1,21] := FloatToStr(CfAlto);}

{Campana de Gauss

  - La campana de Gauss sirve para averiguar las posibilidades tericas de que un
    valor comprendido entre -3 y +3 Sigma ocurra en la realidad, en base a las
    medidas tomadas en la muestra analizada. (Por debajo de +- 3 Sigma los valores
    esperados son muy pequeos)

    Para ello se calculan "J" valores (en este casos los suficientes para que se
    muestre la curva de manera uniforme) desde el rango menor de Sigma y el
    rango mayor de Sigma que hayamos elegido.

    La distribucin de la curva es siempre uniforme alcanzando el mayor valor en
    su punto central que es coincidente con la media aritmtica de la medicin
    efectuada.

    La esbeltez de la campana nos muestra la calidad o uniformidad del proceso
    medido y la fiabilidad terica de los resultados reales del proceso en la
    prctica. Cuanto mas esbelta sea la Campana, mejor ser el proceso, por el
    contrario si la campana est achatada mayor ser la dispersin en las
    medidas que obtendremos.

  S : Sigma
  x : Cada uno de los valores comprendidos entre -3S y + 3S con un rango de
      ((+3S) - (-3S)) / J.  Si necesitamos mas valores cambiamos el valor J
      Este valor es suficiente para ver la grfica en forma de curva.

  M : Media aritmtica de las medidas
  P : 3.14159265359
  Y : F(x)
  e : 2.7182

  - La formula del valor de Y para cada valor de F(x) que se denomina
    Funcin de densidad de probabilidad viene dada por:

                    1            - ((x - M)*(x-M))/(2*(S*S))
  F(x) = Y = ------------- * e
             S*(Sqrt(2*P))

     - En el valor superior de la curva, "e" esta elevado a 0  y por lo tanto
       vale 1(ya que tanto "x" como la media "M" valen lo mismo)}

 P := 3.14159265359;

 J := 100; {Value to obtain the curve of the rounded bell. To put it a greater
            value does not has object
            #Valor para conseguir la curva de la campana redondeada. El poner
             un valor mayor no tiene objeto}

 {Valor de incremento del punto de representacin de x en el grfico de linea,
 o lo que es lo mismo iremos representando J veces el valor de F(x) para cada
 punto entre el valor menor y el valor mayor }

 x := (Mayor - Menor) / J;

 EditFX.Text := FloatToStr(1/(S*(Sqrt(2*P)))); {Valor mayor de F(x)}

 LS2.Clear;
 for I := 1 to J do begin;
  K := ((((Menor+(I*x))-M)*((Menor+(I*x))-M)))/(2*(S*S)); {K = Exponente de "e"}
  e := Power(2.7182,-K); {Elevar "e" al valor del exponente K}
  Y := (1/(S*(Sqrt(2*P))))* e; {Valor final de F(x) para cada posible valor entre
                                los valores del grfico. Es el valor de Y en el Chart}

  {Para poder ver directamente en pantalla la relacin directa de la cantidad de
   muestras tanto encontradas en el histograma como probables segn la campana
   se multiplica por 'n' el valor escalado anteriormente 'Y * CfAncho'.
   Si se desearan ver los valores en % bastara con convertirlos tanto en la
   campana como en el histograma}

  LS2.AddXY((I/(J/20)),(Y*CfAncho)*n,'',clTeeColor);
 end;

 {Grfico de barras de Distribucin de Frecuencias

  - Una campana de Gauss por si misma a veces no es suficiente para describir
    el proceso de probabilidades, ya que es importante ver donde est la
    tendencia de las medidas y con ello su dispersin.

    Para ello se muestra en este grfico la cantidad de veces que se dan los
    valores de la medida entre cada uno de los rangos, determinados en este caso
    como ya hemos mostrado anteriormente por 20 rangos de frecuencia entre el
    valor menor y el valor mayor obtenido por los datos obtenidos en la muestra
    y las Tolerancias y Limites de Ingeniera para el proceso. Ejemplo:

    - Supongamos un proceso en el cual deseamos medir unas piezas obtenidas en
      un proceso productivo en una fbrica

    - Los lmites de ingeniera son los valores tericos extremos entre los que
      una pieza sera dada por vlida.

    - Las Tolerancias son los valores de lmite de ingeniera +- los valores de
      incertidumbre de la medida y que seran los valores entre los cuales
      daramos por aceptables las piezas, por ejemplo procedentes de una mquina.
      (Ver mas el concepto de incertidumbre explicado anteriormente)

    - Las piezas cuyos valores esten entre los de Tolerancia y Lmite seran
      rechazadas en principio por ser dudosas

 Mostrar las barras de frecuencias}

 BS1.Clear;
 for I := 1 to 20 do begin
  TxtGra := FloatToStr(Frecuencia[I]);
  if Pos(',',TxtGra) > 0 then TxtGra := Copy(TxtGra,1,Pos(',',TxtGra)+1);

  {Para poder ver directamente en pantalla la relacion directa de la cantidad de
   muestras tanto encontradas en el histograma como probables segun la campana
   se multiplica por 'n' el valor escalado anteriormente a 1 en 'NVeces[I]'}

  BS1.AddBar(NVeces[I]*n,TxtGra,clTeeColor)
 end;

 {Calcular el valor mas alto del grafico 'TopGra' para mostrar los valores de
  control del proceso con un pequeo margen por arriba. Esttica}

 TopGra := (1/(S*(Sqrt(2*P))))*CfAncho*n; {Valor mas alto de F(x) escalado con histograma}
 for I := 1 to 20 do if TopGra < (NVeces[I]*n) then TopGra := (NVeces[I]*n);

 LSMS.Clear;
 LSMS.AddXY(0,TopGra + (TopGra*0.05),'',clTeeColor);

 {Mostrar los limites de control del proceso}

 with Series1 do begin
  Clear;
  AddXY((((Teorico)-Menor)*20)/(Mayor-Menor),TopGra/6  ,'Ma' ,clBlue);   {Teorico}
  AddXY(((M-Menor)*20)        /(Mayor-Menor),TopGra/3.6,'Me' ,clBlack);   {Media}
  AddXY((((M-(3*S))-Menor)*20)/(Mayor-Menor),TopGra/2.5,'-3S',clGreen);  {-3S}
  AddXY((((M+(3*S))-Menor)*20)/(Mayor-Menor),TopGra/2  ,'+3S',clGreen);  {+3S}
  AddXY((((TolSup)-Menor)*20) /(Mayor-Menor),TopGra/1.4,'Ts' ,clFuchsia);{TolSup}
  AddXY((((TolInf)-Menor)*20) /(Mayor-Menor),TopGra/1.7,'Ti' ,clFuchsia);{TolInf}
  AddXY((((LimSup)-Menor)*20) /(Mayor-Menor),TopGra/1.1,'Ls',clRed);    {LimSup}
  AddXY((((LimInf)-Menor)*20) /(Mayor-Menor),TopGra/1.1,'Li',clRed);    {LimInf}
 end;

 {Grfico de lineas para ver la evolucin de la muestra.
  En algunos casos se hacen muestreos a lo largo del tiempo y es posible que exista
  una tendencia de desviacin del valor de muestreo en uno u otro sentido que por
  ejemplo al medir piezas sacadas de una mquina pueden suponer un desgaste o
  desajuste progresivo de la misma y para observarlo es bueno disponer de un
  grfico de lineas en el que podamos visualizar dicha tendencia de desviacin }

 LSTolSup.Clear;
 LSTolInf.Clear;
 LSMedida.Clear;
 LSLimSup.Clear;
 LSLimInf.Clear;
 LSMas3S.Clear;
 LSMenos3S.Clear;
 LSMI.Clear;
 LSMa.Clear;

 {Mostrar los valores en el grafico de lineas}
 for I := 1 to n do begin
  LSMedida.AddXY(I,Datos[I],'',clTeeColor);
 end;

 {Mostrar los limites de control en el grafico de lineas}

 LSTolSup.AddXY(0,TolSup,'',clTeeColor);
 LSTolSup.AddXY(n,TolSup,'',clTeeColor);
 LSTolInf.AddXY(0,TolInf,'',clTeeColor);
 LSTolInf.AddXY(n,TolInf,'',clTeeColor);
 LSLimSup.AddXY(0,LimSup,'',clTeeColor);
 LSLimSup.AddXY(n,LimSup,'',clTeeColor);
 LSLimInf.AddXY(0,LimInf,'',clTeeColor);
 LSLimInf.AddXY(n,LimInf,'',clTeeColor);
 LSMas3S.AddXY(0,(M+(3*S)),'',clTeeColor);
 LSMas3S.AddXY(n,(M+(3*S)),'',clTeeColor);
 LSMenos3S.AddXY(0,(M-(3*S)),'',clTeeColor);
 LSMenos3S.AddXY(n,(M-(3*S)),'',clTeeColor);
 LSMa.AddXY(0,(Teorico),'',clTeeColor);
 LSMa.AddXY(n,(Teorico),'',clTeeColor);

 {Mostrar la linea de limite inferior en el grafico}
 LSMI.AddXY(0,LimInf - (LimInf*0.05),'',clTeeColor);

end;

procedure TEstadistica.BCerrarClick(Sender: TObject);
begin
 Close;
end;

procedure TEstadistica.BB3dClick(Sender: TObject);
begin
 if Chart1.View3d then begin
  Chart1.View3d := False;
  Chart2.View3d := False;
 end else begin
  Chart1.View3d := True;
  Chart2.View3d := True;
 end;
end;

procedure TEstadistica.FormShow(Sender: TObject);
begin
 BRecalcularClick(nil);
end;

function TEstadistica.IntPower(X: Double; I: Integer): Double;
var
  Y: Integer;
begin
  Y := Abs(I);
  Result := 1.0;
  while Y > 0 do begin
    while not Odd(Y) do
    begin
      Y := Y shr 1;
      X := X * X
    end;
    Dec(Y);
    Result := Result * X
  end;
  if I < 0 then Result := 1.0 / Result
end;

function TEstadistica.Power(Base, Exponent: Double): Double;
begin
  { Make special cases of Exponent = 0 and Exponent = integer.
    Error if Base < 0 and Exponent not integer. }
  if Exponent = 0.0 then
    Result := 1.0               { By fiat, 0**0 = 1 }
  else if (Frac(Exponent) = 0.0) and (Exponent < MaxInt) then
    Result := IntPower(Base, Trunc(Exponent))
  else
  begin
   { if Base < 0.0 then ArgError;}
    Result := Exp(Exponent * Ln(Base))
  end
end;

function TEstadistica.RandG(Mean, StdDev: Double): Double;
{ Marsaglia-Bray algorithm }
var
  U1, S2: Extended;
begin
  repeat
    U1 := 2*Random - 1;
    S2 := Sqr(U1) + Sqr(2*Random-1);
  until S2 < 1;
  Result := Sqrt(-2*Ln(S2)/S2) * U1 * StdDev + Mean;
end;

procedure TEstadistica.SECantidadKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key = VK_RETURN then BRecalcular.SetFocus;
end;

procedure TEstadistica.EditLimSupChange(Sender: TObject);
begin
 if EditLimSup.Text = '' then Exit;
 LimSup := StrToFloat(EditLimSup.Text);
end;

procedure TEstadistica.EditLimInfChange(Sender: TObject);
begin
 if EditLimInf.Text = '' then Exit;
 LimInf := StrToFloat(EditLimInf.Text);
end;

procedure TEstadistica.EditTolSupChange(Sender: TObject);
begin
 if EditTolSup.Text = '' then Exit;
 TolSup := StrToFloat(EditTolSup.Text);
end;

procedure TEstadistica.EditTolInfChange(Sender: TObject);
begin
 if EditTolInf.Text = '' then Exit;
 TolInf := StrToFloat(EditTolInf.Text);
end;

procedure TEstadistica.EditSigmaChange(Sender: TObject);
begin
 if EditSigma.Text = '' then Exit;
 Sigma := StrToFloat(EditSigma.Text);
end;

procedure TEstadistica.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 Release;
end;

{Demo}
procedure TEstadistica.CB1Click(Sender: TObject);
begin
 if CB1.Checked then Timer1.Enabled := True else Timer1.Enabled := False;
end;

procedure TEstadistica.Timer1Timer(Sender: TObject);
begin
 if CB1.Checked then begin
  Timer1.Enabled := False;
  BRecalcularClick(nil);
  Timer1.Enabled := True;
 end;
end;

procedure TEstadistica.BBImprimirClick(Sender: TObject);
begin

 Application.CreateForm(TImpresoGrafico, ImpresoGrafico);

 with ImpresoGrafico do begin

  QRChart1.Chart.Assign(Chart1);
  QRChart2.Chart.Assign(Chart2);

  CopySeries(QRDBChart1,Chart1, self);
  CopySeries(QRDBChart2,Chart2, self);

  QRDBChart1.Gradient.Visible := False; // Color en el Chart1 del QuickReport
  QRDBChart2.Gradient.Visible := False; // Color en el Chart2 del QuickReport

  QMuestras.Caption    := Format('%7.0f',[StrToFloat(EditMuestras.Text)]);
  QMedia.Caption       := Format('%10.2f',[StrToFloat(EditMedia.Text)]);
  QBajo.Caption        := Format('%10.2f',[StrToFloat(EditBajo.Text)]);
  QAlto.Caption        := Format('%10.2f',[StrToFloat(EditAlto.Text)]);
  QMa.Caption          := Format('%10.2f',[StrToFloat(EditMa.Text)]);
  QLimSup.Caption      := Format('%10.2f',[StrToFloat(EditLimSup.Text)]);
  QLimInf.Caption      := Format('%10.2f',[StrToFloat(EditLimInf.Text)]);
  QTolSup.Caption      := Format('%10.2f',[StrToFloat(EditTolSup.Text)]);
  QTolInf.Caption      := Format('%10.2f',[StrToFloat(EditTolInf.Text)]);
  QVarianza.Caption    := Format('%10.2f',[StrToFloat(EditVarianza.Text)]);
  QSkew.Caption        := Format('%10.2f',[StrToFloat(EditSkew.Text)]);
  QKurt.Caption        := Format('%10.2f',[StrToFloat(EditKurt.Text)]);
  QVarianza.Caption    := Format('%10.2f',[StrToFloat(EditVarianza.Text)]);
  QCpTol.Caption       := Format('%10.2f',[StrToFloat(EditCpTol.Text)]);
  QCpkTol.Caption      := Format('%10.2f',[StrToFloat(EditCpkTol.Text)]);
  QCrTol.Caption       := Format('%10.2f',[StrToFloat(EditCrTol.Text)]);
  QCpLim.Caption       := Format('%10.2f',[StrToFloat(EditCpLim.Text)]);
  QCpKLim.Caption      := Format('%10.2f',[StrToFloat(EditCpkLim.Text)]);
  QCrLim.Caption       := Format('%10.2f',[StrToFloat(EditCr.Text)]);
  QCpuLim.Caption      := Format('%10.2f',[StrToFloat(EditCpu.Text)]);
  QCplLim.Caption      := Format('%10.2f',[StrToFloat(EditCpl.Text)]);
  QSigma.Caption       := Format('%10.2f',[StrToFloat(EditSigma.Text)]);
  QMas3Sigma.Caption   := Format('%10.2f',[StrToFloat(EditMas3.Text)]);
  QMenos3Sigma.Caption := Format('%10.2f',[StrToFloat(EditMenos3.Text)]);
  QRecorrido.Caption   := Format('%10.2f',[StrToFloat(EditReco.Text)]);
  QZSup.Caption        := Format('%10.2f',[StrToFloat(EditZSupLim.Text)]);
  QZInf.Caption        := Format('%10.2f',[StrToFloat(EditZInfLim.Text)]);
  QNombre.Caption      := Estadistica.Caption;

  QuickRep1.Preview; {Atencin. En algunas versiones de QuickReport, no Imprime}

  //  QuickRep1.Print;

  QuickRep1.Destroy;
 end;
end;

procedure TEstadistica.CopySeries(DestChart: TQRDBChart; SourceChart:TChart;
                                  AOwner:TComponent);
var
 tmpSeries: TChartSeries;
 tmpS: TChartSeriesClass;
 t: Longint;
begin
  for t:=0 to SourceChart.SeriesCount-1 do
  begin
    tmpS:=TChartSeriesClass(SourceChart.Series[t].ClassType);
    tmpSeries:=tmpS.Create(AOwner);
    tmpSeries.Assign(SourceChart.Series[t]);
    tmpSeries.Name:=(SourceChart.Series[t].Name) + 'copy';
    DestChart.AddSeries(tmpSeries);
  end;
end;

{Demo}
initialization

 Teorico := 23;
 LimSup  := 29;
 LimInf  := 18;
 TolSup  := 26;
 TolInf  := 20;
 Sigma   := 1;

end.
