unit IAgaloLED;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,Math,extctrls;

type
  TIALedClass = (ialcRect,ialcRound,ialcRomb,ialcHalfCircle,ialcTriangle,ialcTrapezium);
  TIABorderLedStyle = (iablsUp,iablsDown,iablsNone);
  TIAglPoly = array of TPoint;
  TIAxyRealPoint = record
    x : double;
    y : double;
  end;
  TIAxyPoly = array of TIAxyRealPoint;
  TIAglSubstanceMode = (iasmTile,iasmStretch);
  TIAgaloLED = class(TCustomControl)
  private
    FLedClass: TIALedClass;
    FLedPlasticDepth: integer;
    FInnerBorderDepth: integer;
    FAngle: integer;
    FGap: integer;
    FOuterBorderDepth: integer;
    FBorderSubstance: TBitmap;
    FBorderL,FBorderD : TBitmap;
    FLedPlasticSubstance: TBitmap;
    FBorderColor: TColor;
    FLedPlasticColor: TColor;
    FOuterBorderStyle: TIABorderLedStyle;
    FInnerBorderStyle: TIABorderLedStyle;
    FLedOn: Boolean;
    FLedHeight: integer;
    FLedWidth: integer;
    FLastHeight: integer;
    FLastWidth : integer;
    FLedPoints : TIAglPoly;
    FGapPoints : TIAglPoly;
    FInnerPoints : TIAglPoly;
    FOuterPoints : TIAglPoly;
    FLedPointsxy : TIAxyPoly;
    FGapPointsxy : TIAxyPoly;
    FInnerPointsxy : TIAxyPoly;
    FOuterPointsxy : TIAxyPoly;
    FPaintBitmap : TBitmap;
    FGapColor: TColor;
    FLedPlasticSubsMode: TIAglSubstanceMode;
    FBorderSubsMode: TIAglSubstanceMode;
    FGaloON: Boolean;
    FGaloONwas : Boolean;
    FGaloSize: integer;
    FGaloIntensity: integer;


    procedure DefineWidthHeight;
    procedure WMSIZE(var Message : TMessage);message WM_SIZE;
    procedure WMMOVE(var Message : TMessage);message WM_MOVE;
    procedure DefinePointArrays;
    procedure reinsertpoints;
    procedure RotatePolyPoints(Var Apoly : TIAxyPoly);
    procedure GetPaintBitmap;
    function  AngleIsDark(AAngle : Integer): Boolean;

    procedure SetBorderSubstance(Value: TBitmap);
    procedure SetLedPlasticSubstance(Value: TBitmap);
  protected
    { Protected declarations }
    procedure Paint; override;
    procedure CreateHandle; override;
    procedure Loaded; override;

    procedure SetHeight(Value: Integer);virtual;
    procedure SetWidth(Value: Integer);virtual;
    function GetHeight: integer;virtual;
    function GetWidth: integer;virtual;
    procedure SetLedClass(Value: TIALedClass);virtual;
    procedure SetAngle(Value: integer); virtual;
    procedure SetBorderColor(Value: TColor);    virtual;

    procedure SetGap(Value: integer);virtual;
    procedure SetInnerBorderDepth(Value: integer);virtual;
    procedure SetInnerBorderStyle(Value: TIABorderLedStyle);virtual;
    procedure SetGapColor(Value: TColor);virtual;

    procedure SetLedPlasticColor(Value: TColor);virtual;
    procedure SetLedPlasticDepth(Value: integer);virtual;

    procedure SetOuterBorderDepth(Value: integer);virtual;
    procedure SetOuterBorderStyle(Value: TIABorderLedStyle);virtual;
    procedure SetLedOn(Value: Boolean);virtual;
    procedure SetLedHeight(Value: integer);virtual;
    procedure SetLedWidth(Value: integer);virtual;
    procedure SetLedPlasticSubsMode(Value: TIAglSubstanceMode);virtual;
    procedure SetBorderSubsMode(Value: TIAglSubstanceMode);virtual;
    procedure SetGaloON(Value: Boolean);virtual;
    procedure SetGaloSize(Value: integer);virtual;
    procedure SetGaloIntensity(Value: integer);virtual;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;


  published
    { Published declarations }
    property BorderSubstance     : TBitmap read FBorderSubstance     write SetBorderSubstance     default nil;
    property LedPlasticSubstance : TBitmap read FLedPlasticSubstance write SetLedPlasticSubstance default nil;
    property Width: Integer read GetWidth write SetWidth default 24;
    property Height: Integer read GetHeight write SetHeight default 14;
    property LedClass : TIALedClass read FLedClass write SetLedClass default ialcRect;
    property LedPlasticDepth : integer read FLedPlasticDepth write SetLedPlasticDepth default 5;

    property Gap : integer read FGap write SetGap default 0;
    property GapColor : TColor read FGapColor write SetGapColor default clGray;
    property Angle : integer read FAngle write SetAngle default 0;
    property InnerBorderStyle : TIABorderLedStyle read FInnerBorderStyle write SetInnerBorderStyle default iablsNone;
    property OuterBorderStyle : TIABorderLedStyle read FOuterBorderStyle write SetOuterBorderStyle default iablsDown;
    property InnerBorderDepth : integer read FInnerBorderDepth write SetInnerBorderDepth default 0;
    property OuterBorderDepth : integer read FOuterBorderDepth write SetOuterBorderDepth default 2;
    property BorderColor : TColor read FBorderColor write SetBorderColor default clGray;
    property LedPlasticColor : TColor read FLedPlasticColor write SetLedPlasticColor default clRed;

    property LedOn : Boolean read FLedOn write SetLedOn;
    property LedWidth : integer read FLedWidth write SetLedWidth;
    property LedHeight : integer read FLedHeight write SetLedHeight;
    property LedPlasticSubsMode : TIAglSubstanceMode read FLedPlasticSubsMode write SetLedPlasticSubsMode default iasmTile;
    property BorderSubsMode : TIAglSubstanceMode read FBorderSubsMode write SetBorderSubsMode default iasmTile;
    property GaloON : Boolean read FGaloON write SetGaloON default false;
    property GaloSize : integer read FGaloSize write SetGaloSize default 10;
    property GaloIntensity : integer read FGaloIntensity write SetGaloIntensity default 5;

    property Anchors;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('TIA', [TIAgaloLED]);
end;
function GetDColor(Value : Tcolor): Tcolor;
var
  pR,pB,pG : pByte;
begin
  result:=colortoRGB(Value);
  pR:=@result;
  pG:=pByte(integer(pR)+1);
  pB:=pByte(integer(pG)+1);
  if pR^<32 then pR^:=0 else dec(pR^,32);
  if pG^<32 then pG^:=0 else dec(pG^,32);
  if pB^<32 then pB^:=0 else dec(pB^,32);
end;
function GetLColor(Value : Tcolor): Tcolor;
var
  pR,pB,pG : pByte;
begin
  result:=colortoRGB(Value);
  pR:=@result;
  pG:=pByte(integer(pR)+1);
  pB:=pByte(integer(pG)+1);
  if pR^>223 then pR^:=255 else inc(pR^,32);
  if pG^>223 then pG^:=255 else inc(pG^,32);
  if pB^>223 then pB^:=255 else inc(pB^,32);
end;
procedure Dark24Bitmap(var B : TBitmap;N : integer);
var
  i,j : integer;
  pB : PByteArray;
begin
  for i:=0 to B.Height-1 do
   begin
     pb:=B.ScanLine[i];
     for j:=0 to 3*B.Width-1 do
       begin
         if pb[j]<n then pb[j]:=0 else dec(pb[j],n);
       end;
   end;
end;

procedure Light24Bitmap(var B : TBitmap;N : integer);
var
  i,j : integer;
  pB : PByteArray;
begin
  for i:=0 to B.Height-1 do
   begin
     pb:=B.ScanLine[i];
     for j:=0 to 3*B.Width-1 do
       begin
         if pb[j]>(255-n) then pb[j]:=255 else inc(pb[j],n);
       end;
   end;
end;
{ TIAgaloLED }

function TIAgaloLED.AngleIsDark(AAngle: Integer): Boolean;
var s1,c1 : double;
begin
  s1:=sin(AAngle*pi/1800);c1:=cos(AAngle*pi/1800);
  if (S1>0) then
    begin
      if C1>-1/sqrt(2) then  result:=false else result:=true;
    end else
    begin
      if C1>1/sqrt(2) then result:=false else result:=true;
    end;
end;

constructor TIAgaloLED.Create(AOwner: TComponent);
begin
  inherited create(AOwner);
  inherited width:=24;
  inherited height:=14;
  FLedWidth:=22;
  FLedHeight:=12;
  FLedclass:=ialcRect;
  FGaloONwas:=false;

  FLedPlasticDepth:=5;
  FInnerBorderDepth:=0;
  FAngle:=0;
  FGap:=0;
  FOuterBorderDepth:=2;

  FBorderSubstance    :=TBitmap.create;
  FLedPlasticSubstance:=TBitmap.create;
  FBorderL:=TBitmap.create;
  FBorderD:=TBitmap.create;
  FBorderSubstance.PixelFormat:=pf24bit;
  FLedPlasticSubstance.PixelFormat:=pf24bit;
  FBorderL.PixelFormat:=pf24bit;
  FBorderD.PixelFormat:=pf24bit;

  FBorderColor:=clGray;
  FGapColor:=clGray;
  FLedPlasticColor:=clRed;
  FOuterBorderStyle:=iablsDown;
  FInnerBorderStyle:=iablsNone;
  FPaintBitmap := TBitmap.Create;
  FPaintBitmap.PixelFormat:=pf24bit;
  FPaintBitmap.Width:=24;
  FPaintBitmap.Height:=14;
  FLedPlasticSubsMode:=iasmTile;
  FBorderSubsMode:=iasmTile;
  FGaloON:=false;
  FGaloSize:=10;
  FGaloIntensity:=5;
end;

procedure TIAgaloLED.CreateHandle;
begin
  inherited CreateHandle;
  ControlStyle:=ControlStyle+[csOpaque];
  DefinePointArrays;
end;

procedure TIAgaloLED.DefinePointArrays;
var dX,N,i : integer;
    RGN : HRGN;
    x,y : double;
begin
  Dx:=FGap;
  if FInnerBorderStyle<>iablsNone then inc(dX,FInnerBorderDepth);
  if FOuterBorderStyle<>iablsNone then inc(dX,FOuterBorderDepth);
  case FLedClass of
    ialcRect :
      begin
        setlength(FLedPointsxy  ,4);
        setlength(FGapPointsxy  ,4);
        setlength(FInnerPointsxy,4);
        setlength(FOuterPointsxy,4);
        FLedPointsxy[0].x:=dx;FLedpointsxy[0].y:=dx;
        FLedPointsxy[1].x:=dx+FLedWidth;FLedpointsxy[1].y:=dx;
        FLedPointsxy[2].x:=dx+FLedWidth;FLedpointsxy[2].y:=dx+FLedHeight;
        FLedPointsxy[3].x:=dx;FLedpointsxy[3].y:=dx+FledHeight;

        FGapPointsxy[0].x:=dx-FGap;          FGapPointsxy[0].y:=dx-FGap;
        FGapPointsxy[1].x:=dx+FLedWidth+FGap;FGapPointsxy[1].y:=dx-FGap;
        FGapPointsxy[2].x:=dx+FLedWidth+FGap;FGapPointsxy[2].y:=dx+FLedHeight+FGap;
        FGapPointsxy[3].x:=dx-FGap;          FGapPointsxy[3].y:=dx+FledHeight+FGap;

        if FInnerBorderStyle<>iablsNone then
          begin
            FInnerPointsxy[0].x:=FGapPointsxy[0].x-FInnerBorderDepth;FInnerPointsxy[0].y:=FGapPointsxy[0].y-FInnerBorderDepth;
            FInnerPointsxy[1].x:=FGapPointsxy[1].x+FInnerBorderDepth;FInnerPointsxy[1].y:=FGapPointsxy[1].y-FInnerBorderDepth;
            FInnerPointsxy[2].x:=FGapPointsxy[2].x+FInnerBorderDepth;FInnerPointsxy[2].y:=FGapPointsxy[2].y+FInnerBorderDepth;
            FInnerPointsxy[3].x:=FGapPointsxy[3].x-FInnerBorderDepth;FInnerPointsxy[3].y:=FGapPointsxy[3].y+FInnerBorderDepth;
          end else
          begin
            FInnerPointsxy[0].x:=FGapPointsxy[0].x;FInnerPointsxy[0].y:=FGapPointsxy[0].y;
            FInnerPointsxy[1].x:=FGapPointsxy[1].x;FInnerPointsxy[1].y:=FGapPointsxy[1].y;
            FInnerPointsxy[2].x:=FGapPointsxy[2].x;FInnerPointsxy[2].y:=FGapPointsxy[2].y;
            FInnerPointsxy[3].x:=FGapPointsxy[3].x;FInnerPointsxy[3].y:=FGapPointsxy[3].y;
          end;
        if FOuterBorderStyle<>iablsNone then
          begin
            FOuterPointsxy[0].x:=FInnerPointsxy[0].x-FOuterBorderDepth;FOuterPointsxy[0].y:=FInnerPointsxy[0].y-FOuterBorderDepth;
            FOuterPointsxy[1].x:=FInnerPointsxy[1].x+FOuterBorderDepth;FOuterPointsxy[1].y:=FInnerPointsxy[1].y-FOuterBorderDepth;
            FOuterPointsxy[2].x:=FInnerPointsxy[2].x+FOuterBorderDepth;FOuterPointsxy[2].y:=FInnerPointsxy[2].y+FOuterBorderDepth;
            FOuterPointsxy[3].x:=FInnerPointsxy[3].x-FOuterBorderDepth;FOuterPointsxy[3].y:=FInnerPointsxy[3].y+FOuterBorderDepth;
          end else
          begin
            FOuterPointsxy[0].x:=FInnerPointsxy[0].x;FOuterPointsxy[0].y:=FInnerPointsxy[0].y;
            FOuterPointsxy[1].x:=FInnerPointsxy[1].x;FOuterPointsxy[1].y:=FInnerPointsxy[1].y;
            FOuterPointsxy[2].x:=FInnerPointsxy[2].x;FOuterPointsxy[2].y:=FInnerPointsxy[2].y;
            FOuterPointsxy[3].x:=FInnerPointsxy[3].x;FOuterPointsxy[3].y:=FInnerPointsxy[3].y;
          end;

        RotatePolyPoints(FLedPointsxy);
        RotatePolyPoints(FGapPointsxy);
        RotatePolyPoints(FInnerPointsxy);
        RotatePolyPoints(FOuterPointsxy);
      end;
    ialcRound :
      begin
        N:=max(FLedWidth,FLedHeight); if N<1 then N:=1;
        setlength(FLedPointsxy  ,2*N);
        setlength(FGapPointsxy  ,2*N);
        setlength(FInnerPointsxy,2*N);
        setlength(FOuterPointsxy,2*N);
        for i:=0 to 2*N-1 do
          begin
            x:=FLedWidth/2+dx+FledWidth*sin(i*pi/N)/2;
            y:=FLedHeight/2+dx-FledHeight*cos(i*pi/N)/2;
            FLedPointsxy[i].x:=x;
            FLedpointsxy[i].y:=y;
            x:=x+FGap*sin(i*pi/N);
            y:=y-FGap*cos(i*pi/N);
            FGapPointsxy[i].x:=x;
            FGapPointsxy[i].y:=y;
            if FInnerBorderStyle<>iablsNone then
              begin
                x:=x+FInnerBorderDepth*sin(i*pi/N);
                y:=y-FInnerBorderDepth*cos(i*pi/N);
                FInnerPointsxy[i].x:=x;
                FInnerPointsxy[i].y:=y;
              end else
              begin
                FInnerPointsxy[i].x:=FGapPointsxy[i].x;FInnerPointsxy[i].y:=FGapPointsxy[i].y;
              end;
            if FOuterBorderStyle<>iablsNone then
              begin
                FOuterPointsxy[i].x:=x+FOuterBorderDepth*sin(i*pi/N);
                FOuterPointsxy[i].y:=y-FOuterBorderDepth*cos(i*pi/N);
              end else
              begin
                FOuterPointsxy[i].x:=FInnerPointsxy[i].x;FOuterPointsxy[i].y:=FInnerPointsxy[i].y;
              end;
          end;

        RotatePolyPoints(FLedPointsxy);
        RotatePolyPoints(FGapPointsxy);
        RotatePolyPoints(FInnerPointsxy);
        RotatePolyPoints(FOuterPointsxy);
      end;
    ialcTrapezium :
      begin
        setlength(FLedPointsxy  ,4);
        setlength(FGapPointsxy  ,4);
        setlength(FInnerPointsxy,4);
        setlength(FOuterPointsxy,4);

        FLedPointsxy[0].x:=dx+FledWidth div 4;FLedpointsxy[0].y:=dx;
        FLedPointsxy[1].x:=dx+3*FledWidth div 4;FLedpointsxy[1].y:=dx;
        FLedPointsxy[2].x:=dx+FLedWidth;      FLedpointsxy[2].y:=dx+FledHeight;
        FLedPointsxy[3].x:=dx;                FLedpointsxy[3].y:=dx+FLedHeight;


        FGapPointsxy[0].x:=FLedPointsxy[0].x-fgap div 2;          FGapPointsxy[0].y:=FLedpointsxy[0].y-FGap;
        FGapPointsxy[1].x:=FLedPointsxy[1].x+fgap div 2;          FGapPointsxy[1].y:=FLedpointsxy[1].y-FGap;
        FGapPointsxy[2].x:=FLedPointsxy[2].x+FGap;     FGapPointsxy[2].y:=FLedpointsxy[2].y+FGap;
        FGapPointsxy[3].x:=FLedPointsxy[3].x-Fgap;     FGapPointsxy[3].y:=FLedpointsxy[3].y+FGap;

        if FInnerBorderStyle<>iablsNone then
          begin
            FInnerPointsxy[0].x:=FGapPointsxy[0].x-FInnerBorderDepth div 2;FInnerPointsxy[0].y:=FGapPointsxy[0].y-FInnerBorderDepth;
            FInnerPointsxy[1].x:=FGapPointsxy[1].x+FInnerBorderDepth div 2;FInnerPointsxy[1].y:=FGapPointsxy[1].y-FInnerBorderDepth;
            FInnerPointsxy[2].x:=FGapPointsxy[2].x+FInnerBorderDepth;FInnerPointsxy[2].y:=FGapPointsxy[2].y+FInnerBorderDepth;
            FInnerPointsxy[3].x:=FGapPointsxy[3].x-FInnerBorderDepth;FInnerPointsxy[3].y:=FGapPointsxy[3].y+FInnerBorderDepth;
          end else
          begin
            FInnerPointsxy[0].x:=FGapPointsxy[0].x;FInnerPointsxy[0].y:=FGapPointsxy[0].y;
            FInnerPointsxy[1].x:=FGapPointsxy[1].x;FInnerPointsxy[1].y:=FGapPointsxy[1].y;
            FInnerPointsxy[2].x:=FGapPointsxy[2].x;FInnerPointsxy[2].y:=FGapPointsxy[2].y;
            FInnerPointsxy[3].x:=FGapPointsxy[3].x;FInnerPointsxy[3].y:=FGapPointsxy[3].y;
          end;
        if FOuterBorderStyle<>iablsNone then
          begin
            FOuterPointsxy[0].x:=FInnerPointsxy[0].x-FOuterBorderDepth div 2;FOuterPointsxy[0].y:=FInnerPointsxy[0].y-FOuterBorderDepth;
            FOuterPointsxy[1].x:=FInnerPointsxy[1].x+FOuterBorderDepth div 2;FOuterPointsxy[1].y:=FInnerPointsxy[1].y-FOuterBorderDepth;
            FOuterPointsxy[2].x:=FInnerPointsxy[2].x+FOuterBorderDepth;FOuterPointsxy[2].y:=FInnerPointsxy[2].y+FOuterBorderDepth;
            FOuterPointsxy[3].x:=FInnerPointsxy[3].x-FOuterBorderDepth;FOuterPointsxy[3].y:=FInnerPointsxy[3].y+FOuterBorderDepth;
          end else
          begin
            FOuterPointsxy[0].x:=FInnerPointsxy[0].x;FOuterPointsxy[0].y:=FInnerPointsxy[0].y;
            FOuterPointsxy[1].x:=FInnerPointsxy[1].x;FOuterPointsxy[1].y:=FInnerPointsxy[1].y;
            FOuterPointsxy[2].x:=FInnerPointsxy[2].x;FOuterPointsxy[2].y:=FInnerPointsxy[2].y;
            FOuterPointsxy[3].x:=FInnerPointsxy[3].x;FOuterPointsxy[3].y:=FInnerPointsxy[3].y;
          end;

        RotatePolyPoints(FLedPointsxy);
        RotatePolyPoints(FGapPointsxy);
        RotatePolyPoints(FInnerPointsxy);
        RotatePolyPoints(FOuterPointsxy);
      end;
    ialcTriangle :
      begin
        setlength(FLedPointsxy  ,3);
        setlength(FGapPointsxy  ,3);
        setlength(FInnerPointsxy,3);
        setlength(FOuterPointsxy,3);

        FLedPointsxy[0].x:=dx+FledWidth div 2;FLedpointsxy[0].y:=dx;
        FLedPointsxy[1].x:=dx+FLedWidth;      FLedpointsxy[1].y:=dx+FledHeight;
        FLedPointsxy[2].x:=dx;                FLedpointsxy[2].y:=dx+FLedHeight;


        FGapPointsxy[0].x:=FLedPointsxy[0].x;          FGapPointsxy[0].y:=FLedpointsxy[0].y-FGap;
        FGapPointsxy[1].x:=FLedPointsxy[1].x+FGap;     FGapPointsxy[1].y:=FLedpointsxy[1].y+FGap;
        FGapPointsxy[2].x:=FLedPointsxy[2].x-Fgap;     FGapPointsxy[2].y:=FLedpointsxy[2].y+FGap;

        if FInnerBorderStyle<>iablsNone then
          begin
            FInnerPointsxy[0].x:=FGapPointsxy[0].x;                  FInnerPointsxy[0].y:=FGapPointsxy[0].y-FInnerBorderDepth;
            FInnerPointsxy[1].x:=FGapPointsxy[1].x+FInnerBorderDepth;FInnerPointsxy[1].y:=FGapPointsxy[1].y+FInnerBorderDepth;
            FInnerPointsxy[2].x:=FGapPointsxy[2].x-FInnerBorderDepth;FInnerPointsxy[2].y:=FGapPointsxy[2].y+FInnerBorderDepth;
          end else
          begin
            FInnerPointsxy[0].x:=FGapPointsxy[0].x;FInnerPointsxy[0].y:=FGapPointsxy[0].y;
            FInnerPointsxy[1].x:=FGapPointsxy[1].x;FInnerPointsxy[1].y:=FGapPointsxy[1].y;
            FInnerPointsxy[2].x:=FGapPointsxy[2].x;FInnerPointsxy[2].y:=FGapPointsxy[2].y;
          end;
        if FOuterBorderStyle<>iablsNone then
          begin
            FOuterPointsxy[0].x:=FInnerPointsxy[0].x;                  FOuterPointsxy[0].y:=FInnerPointsxy[0].y-FOuterBorderDepth;
            FOuterPointsxy[1].x:=FInnerPointsxy[1].x+FOuterBorderDepth;FOuterPointsxy[1].y:=FInnerPointsxy[1].y+FOuterBorderDepth;
            FOuterPointsxy[2].x:=FInnerPointsxy[2].x-FOuterBorderDepth;FOuterPointsxy[2].y:=FInnerPointsxy[2].y+FOuterBorderDepth;
          end else
          begin
            FOuterPointsxy[0].x:=FInnerPointsxy[0].x;FOuterPointsxy[0].y:=FInnerPointsxy[0].y;
            FOuterPointsxy[1].x:=FInnerPointsxy[1].x;FOuterPointsxy[1].y:=FInnerPointsxy[1].y;
            FOuterPointsxy[2].x:=FInnerPointsxy[2].x;FOuterPointsxy[2].y:=FInnerPointsxy[2].y;
          end;

        RotatePolyPoints(FLedPointsxy);
        RotatePolyPoints(FGapPointsxy);
        RotatePolyPoints(FInnerPointsxy);
        RotatePolyPoints(FOuterPointsxy);
      end;  
    ialcRomb :
      begin
        setlength(FLedPointsxy  ,4);
        setlength(FGapPointsxy  ,4);
        setlength(FInnerPointsxy,4);
        setlength(FOuterPointsxy,4);

        FLedPointsxy[0].x:=dx+FledWidth div 2;FLedpointsxy[0].y:=dx;
        FLedPointsxy[1].x:=dx+FLedWidth;      FLedpointsxy[1].y:=dx+FledHeight div 2;
        FLedPointsxy[2].x:=dx+FLedWidth div 2;FLedpointsxy[2].y:=dx+FLedHeight;
        FLedPointsxy[3].x:=dx;                FLedpointsxy[3].y:=dx+FledHeight div 2;

        FGapPointsxy[0].x:=FLedPointsxy[0].x;          FGapPointsxy[0].y:=FLedpointsxy[0].y-FGap;
        FGapPointsxy[1].x:=FLedPointsxy[1].x+FGap;     FGapPointsxy[1].y:=FLedpointsxy[1].y;
        FGapPointsxy[2].x:=FLedPointsxy[2].x;          FGapPointsxy[2].y:=FLedpointsxy[2].y+FGap;
        FGapPointsxy[3].x:=FLedPointsxy[3].x-FGap;     FGapPointsxy[3].y:=FLedpointsxy[3].y;

        if FInnerBorderStyle<>iablsNone then
          begin
            FInnerPointsxy[0].x:=FGapPointsxy[0].x;FInnerPointsxy[0].y:=FGapPointsxy[0].y-FInnerBorderDepth;
            FInnerPointsxy[1].x:=FGapPointsxy[1].x+FInnerBorderDepth;FInnerPointsxy[1].y:=FGapPointsxy[1].y;
            FInnerPointsxy[2].x:=FGapPointsxy[2].x;FInnerPointsxy[2].y:=FGapPointsxy[2].y+FInnerBorderDepth;
            FInnerPointsxy[3].x:=FGapPointsxy[3].x-FInnerBorderDepth;FInnerPointsxy[3].y:=FGapPointsxy[3].y;
          end else
          begin
            FInnerPointsxy[0].x:=FGapPointsxy[0].x;FInnerPointsxy[0].y:=FGapPointsxy[0].y;
            FInnerPointsxy[1].x:=FGapPointsxy[1].x;FInnerPointsxy[1].y:=FGapPointsxy[1].y;
            FInnerPointsxy[2].x:=FGapPointsxy[2].x;FInnerPointsxy[2].y:=FGapPointsxy[2].y;
            FInnerPointsxy[3].x:=FGapPointsxy[3].x;FInnerPointsxy[3].y:=FGapPointsxy[3].y;
          end;
        if FOuterBorderStyle<>iablsNone then
          begin
            FOuterPointsxy[0].x:=FInnerPointsxy[0].x;FOuterPointsxy[0].y:=FInnerPointsxy[0].y-FOuterBorderDepth;
            FOuterPointsxy[1].x:=FInnerPointsxy[1].x+FOuterBorderDepth;FOuterPointsxy[1].y:=FInnerPointsxy[1].y;
            FOuterPointsxy[2].x:=FInnerPointsxy[2].x;FOuterPointsxy[2].y:=FInnerPointsxy[2].y+FOuterBorderDepth;
            FOuterPointsxy[3].x:=FInnerPointsxy[3].x-FOuterBorderDepth;FOuterPointsxy[3].y:=FInnerPointsxy[3].y;
          end else
          begin
            FOuterPointsxy[0].x:=FInnerPointsxy[0].x;FOuterPointsxy[0].y:=FInnerPointsxy[0].y;
            FOuterPointsxy[1].x:=FInnerPointsxy[1].x;FOuterPointsxy[1].y:=FInnerPointsxy[1].y;
            FOuterPointsxy[2].x:=FInnerPointsxy[2].x;FOuterPointsxy[2].y:=FInnerPointsxy[2].y;
            FOuterPointsxy[3].x:=FInnerPointsxy[3].x;FOuterPointsxy[3].y:=FInnerPointsxy[3].y;
          end;

        RotatePolyPoints(FLedPointsxy);
        RotatePolyPoints(FGapPointsxy);
        RotatePolyPoints(FInnerPointsxy);
        RotatePolyPoints(FOuterPointsxy);
      end;
    ialcHalfCircle :
      begin
        N:=max(FLedWidth,FLedHeight); if N<1 then N:=1;
        setlength(FLedPointsxy  ,2*N+2);
        setlength(FGapPointsxy  ,2*N+2);
        setlength(FInnerPointsxy,2*N+2);
        setlength(FOuterPointsxy,2*N+2);
        for i:=0 to 2*N-1 do
          begin
            x:=dx+FledWidth*sin(i*pi/(2*N-1));
            y:=FLedHeight/2+dx- FledHeight*cos(i*pi/(2*N-1))/2;
            FLedPointsxy[i].x:=x;
            FLedpointsxy[i].y:=y;
            x:=x+FGap*sin(i*pi/(2*N-1));
            y:=y-FGap*cos(i*pi/(2*N-1));
            FGapPointsxy[i].x:=x;
            FGapPointsxy[i].y:=y;
            if FInnerBorderStyle<>iablsNone then
              begin
                x:=x+FInnerBorderDepth*sin(i*pi/(2*N-1));
                y:=y-FInnerBorderDepth*cos(i*pi/(2*N-1));
                FInnerPointsxy[i].x:=x;
                FInnerPointsxy[i].y:=y;
              end else
              begin
                FInnerPointsxy[i].x:=FGapPointsxy[i].x;FInnerPointsxy[i].y:=FGapPointsxy[i].y;
              end;
            if FOuterBorderStyle<>iablsNone then
              begin
                FOuterPointsxy[i].x:=x+FOuterBorderDepth*sin(i*pi/(2*N-1));
                FOuterPointsxy[i].y:=y-FOuterBorderDepth*cos(i*pi/(2*N-1));
              end else
              begin
                FOuterPointsxy[i].x:=FInnerPointsxy[i].x;FOuterPointsxy[i].y:=FInnerPointsxy[i].y;
              end;
          end;
            FLedPointsxy[2*N].x:=dx;
            FLedpointsxy[2*N].y:=dx+FLedHeight;
            FLedPointsxy[2*N+1].x:=dx;
            FLedpointsxy[2*N+1].y:=dx;

            FGapPointsxy[2*N].x:=FLedPointsxy[2*N].x-FGap;
            FGapPointsxy[2*N].y:=FLedPointsxy[2*N].y+FGap;
            FGapPointsxy[2*N+1].x:=FLedPointsxy[2*N+1].x-FGap;
            FGapPointsxy[2*N+1].y:=FLedPointsxy[2*N+1].y-FGap;

            if FInnerBorderStyle<>iablsNone then
              begin
                FInnerPointsxy[2*N].x:=FGapPointsxy[2*N].x-FInnerBorderDepth;
                FInnerPointsxy[2*N].y:=FGapPointsxy[2*N].y+FInnerBorderDepth;
                FInnerPointsxy[2*N+1].x:=FGapPointsxy[2*N+1].x-FInnerBorderDepth;
                FInnerPointsxy[2*N+1].y:=FGapPointsxy[2*N+1].y-FInnerBorderDepth;
              end else
              begin
                FInnerPointsxy[2*N].x:=FGapPointsxy[2*N].x;
                FInnerPointsxy[2*N].y:=FGapPointsxy[2*N].y;
                FInnerPointsxy[2*N+1].x:=FGapPointsxy[2*N+1].x;
                FInnerPointsxy[2*N+1].y:=FGapPointsxy[2*N+1].y;
              end;
            if FOuterBorderStyle<>iablsNone then
              begin
                FOuterPointsxy[2*N].x:=FInnerPointsxy[2*N].x-FOuterBorderDepth;
                FOuterPointsxy[2*N].y:=FInnerPointsxy[2*N].y+FOuterBorderDepth;
                FOuterPointsxy[2*N+1].x:=FInnerPointsxy[2*N+1].x-FOuterBorderDepth;
                FOuterPointsxy[2*N+1].y:=FInnerPointsxy[2*N+1].y-FOuterBorderDepth;
              end else
              begin
                FOuterPointsxy[2*N].x:=FInnerPointsxy[2*N].x;
                FOuterPointsxy[2*N].y:=FInnerPointsxy[2*N].y;
                FOuterPointsxy[2*N+1].x:=FInnerPointsxy[2*N+1].x;
                FOuterPointsxy[2*N+1].y:=FInnerPointsxy[2*N+1].y;
              end;
        RotatePolyPoints(FLedPointsxy);
        RotatePolyPoints(FGapPointsxy);
        RotatePolyPoints(FInnerPointsxy);
        RotatePolyPoints(FOuterPointsxy);
      end;
    else
      begin
        setlength(FLedPointsxy  ,4);
        setlength(FGapPointsxy  ,4);
        setlength(FInnerPointsxy,4);
        setlength(FOuterPointsxy,4);
        FLedPointsxy[0].x:=dx;FLedpointsxy[0].y:=dx;
        FLedPointsxy[1].x:=dx+FLedWidth;FLedpointsxy[1].y:=dx;
        FLedPointsxy[2].x:=dx+FLedWidth;FLedpointsxy[2].y:=dx+FLedHeight;
        FLedPointsxy[3].x:=dx;FLedpointsxy[3].y:=dx+FledHeight;

        FGapPointsxy[0].x:=dx-FGap;          FGapPointsxy[0].y:=dx-FGap;
        FGapPointsxy[1].x:=dx+FLedWidth+FGap;FGapPointsxy[1].y:=dx-FGap;
        FGapPointsxy[2].x:=dx+FLedWidth+FGap;FGapPointsxy[2].y:=dx+FLedHeight+FGap;
        FGapPointsxy[3].x:=dx-FGap;          FGapPointsxy[3].y:=dx+FledHeight+FGap;

        if FInnerBorderStyle<>iablsNone then
          begin
            FInnerPointsxy[0].x:=FGapPointsxy[0].x-FInnerBorderDepth;FInnerPointsxy[0].y:=FGapPointsxy[0].y-FInnerBorderDepth;
            FInnerPointsxy[1].x:=FGapPointsxy[1].x+FInnerBorderDepth;FInnerPointsxy[1].y:=FGapPointsxy[1].y-FInnerBorderDepth;
            FInnerPointsxy[2].x:=FGapPointsxy[2].x+FInnerBorderDepth;FInnerPointsxy[2].y:=FGapPointsxy[2].y+FInnerBorderDepth;
            FInnerPointsxy[3].x:=FGapPointsxy[3].x-FInnerBorderDepth;FInnerPointsxy[3].y:=FGapPointsxy[3].y+FInnerBorderDepth;
          end else
          begin
            FInnerPointsxy[0].x:=FGapPointsxy[0].x;FInnerPointsxy[0].y:=FGapPointsxy[0].y;
            FInnerPointsxy[1].x:=FGapPointsxy[1].x;FInnerPointsxy[1].y:=FGapPointsxy[1].y;
            FInnerPointsxy[2].x:=FGapPointsxy[2].x;FInnerPointsxy[2].y:=FGapPointsxy[2].y;
            FInnerPointsxy[3].x:=FGapPointsxy[3].x;FInnerPointsxy[3].y:=FGapPointsxy[3].y;
          end;
        if FOuterBorderStyle<>iablsNone then
          begin
            FOuterPointsxy[0].x:=FInnerPointsxy[0].x-FOuterBorderDepth;FOuterPointsxy[0].y:=FInnerPointsxy[0].y-FOuterBorderDepth;
            FOuterPointsxy[1].x:=FInnerPointsxy[1].x+FOuterBorderDepth;FOuterPointsxy[1].y:=FInnerPointsxy[1].y-FOuterBorderDepth;
            FOuterPointsxy[2].x:=FInnerPointsxy[2].x+FOuterBorderDepth;FOuterPointsxy[2].y:=FInnerPointsxy[2].y+FOuterBorderDepth;
            FOuterPointsxy[3].x:=FInnerPointsxy[3].x-FOuterBorderDepth;FOuterPointsxy[3].y:=FInnerPointsxy[3].y+FOuterBorderDepth;
          end else
          begin
            FOuterPointsxy[0].x:=FInnerPointsxy[0].x;FOuterPointsxy[0].y:=FInnerPointsxy[0].y;
            FOuterPointsxy[1].x:=FInnerPointsxy[1].x;FOuterPointsxy[1].y:=FInnerPointsxy[1].y;
            FOuterPointsxy[2].x:=FInnerPointsxy[2].x;FOuterPointsxy[2].y:=FInnerPointsxy[2].y;
            FOuterPointsxy[3].x:=FInnerPointsxy[3].x;FOuterPointsxy[3].y:=FInnerPointsxy[3].y;
          end;

        RotatePolyPoints(FLedPointsxy);
        RotatePolyPoints(FGapPointsxy);
        RotatePolyPoints(FInnerPointsxy);
        RotatePolyPoints(FOuterPointsxy);
      end;
  end;
  reinsertpoints;
  {
  FLedPoints : array of TPoint;
    FGapPoints : array of TPoint;
    FInnerPoints : array of TPoint;
    FOuterPoints : array of TPoint;
  }
  RGN:=CreatePolygonRGN(FOuterPoints[0],length(FOuterPoints),Alternate);
  SetWindowRGN(self.handle,RGN,TRUE);
end;

procedure TIAgaloLED.DefineWidthHeight;
var mW,mH,dX : integer;
begin
  Dx:=FGap;
  if FInnerBorderStyle<>iablsNone then inc(dX,FInnerBorderDepth);
  if FOuterBorderStyle<>iablsNone then inc(dX,FOuterBorderDepth);

  mW:=FLedWidth+2*Dx;
  mH:=FLedHeight+2*Dx;
  FLastWidth:= round(abs(mW*cos(pi*FAngle/1800))+abs(mH*sin(pi*FAngle/1800)));
  FLastHeight:=round(abs(mW*sin(pi*FAngle/1800))+abs(mH*cos(pi*FAngle/1800)));
  MoveWindow(self.handle,left,top,FLastWidth,FLastHeight,TRUE);
  DefinePointArrays;
end;

destructor TIAgaloLED.Destroy;
begin
  FPaintBitmap.free;
  if FBorderL<>nil then FBorderL.free;
  if FBorderD<>nil then FBorderD.free;
  if FBorderSubstance<>nil then FBorderSubstance.free;
  if FLedPlasticSubstance<>nil then FLedPlasticSubstance.free;
  inherited destroy;
end;

function TIAgaloLED.GetHeight: integer;
begin
  result:=inherited height;
end;



procedure TIAgaloLED.GetPaintBitmap;
var i,j,k,N,dx,TryAngle : integer;
    pR,pG,pB : pbyte;
    Color1 : TColor;
    pByte1 : pByteArray;
    x,y,w,h,dd,ddx,ddy : double;
    GapRGN,R1,DR,LR : HRGN;
    ar1 : array [0..3] of TPoint;
begin
  if (FBorderSubstance<>nil) and (FBorderSubstance.height<>0) and
     ((FBorderL.height=0) or (FBorderD.height=0))then
    begin
      FBorderL.Width:=FBorderSubstance.Width;
      FBorderL.Height:=FBorderSubstance.Height;
      FBorderL.PixelFormat:=pf24bit;
      FBorderL.Canvas.Draw(0,0,FBorderSubstance);
      FBorderD.Width:=FBorderSubstance.Width;
      FBorderD.Height:=FBorderSubstance.Height;
      FBorderD.PixelFormat:=pf24bit;
      FBorderD.Canvas.Draw(0,0,FBorderSubstance);
      Light24Bitmap(FBorderL,64);
      Dark24Bitmap(FBorderD,64);
    end;
  Dx:=FGap;
  if FInnerBorderStyle<>iablsNone then inc(dX,FInnerBorderDepth);
  if FOuterBorderStyle<>iablsNone then inc(dX,FOuterBorderDepth);
  FPaintBitmap.Width:=self.width;
  FPaintBitmap.height:=self.height;
  if FLedOn then k:=2 else k:=1;
  if (FLedPlasticSubstance=nil) or (FLedPlasticSubstance.Height=0) then
    begin

      Color1:=ColortoRGB(FledPlasticColor);
      pR:=@Color1;
      pG:=pbyte(integer(pr)+1);
      pB:=pbyte(integer(pG)+1);

      for i:=0 to FPaintBitmap.height-1 do
        begin
          pByte1:=FPaintBitmap.ScanLine[i];

            for j:=0 to FPaintBitmap.Width-1 do
              begin
                try
                  dd:=(FLedPlasticDepth/20)*min(FPaintBitmap.width/2-dx,FPaintBitmap.height/2-dx);
                  x:=j-dx-dd;y:=i-dx-dd;
                  w:=FPaintBitmap.width/2-dx-dd;
                  h:=FPaintBitmap.height/2-dx-dd;
                  N:=round(255-127*(abs(y-h)+abs(x-w))/(w+h));
                except
                  N:=0;
                end;
                  N:=N+(15-random(3*FLedPlasticDepth));

                if N>255 then N:=255;
                if N<0 then N:=0;
                pByte1[j*3]:=(pB^ *k div 2)* N div 255;
                pByte1[j*3+1]:=(pG^ *k div 2)* N div 255;
                pByte1[j*3+2]:=(pR^ *k div 2)* N div 255;
              end;
        end;

    end else
    begin
      if FLedPlasticSubsMode = iasmTile then
        begin
          for i:=0 to FPaintbitmap.Width div FLedPlasticSubstance.width do
            for j:=0 to FPaintbitmap.height div FLedPlasticSubstance.height do
              FPaintBitmap.Canvas.Draw(i*FPaintbitmap.Width div FLedPlasticSubstance.width,
                                       j*FPaintbitmap.height div FLedPlasticSubstance.height,
                                       FLedPlasticSubstance);
        end else
        begin
          FPaintBitmap.Canvas.StretchDraw(rect(0,0,FPaintbitmap.Width,FPaintbitmap.height),FLedPlasticSubstance);
        end;
      for i:=0 to FPaintBitmap.height-1 do
        begin
          pByte1:=FPaintBitmap.ScanLine[i];

            for j:=0 to FPaintBitmap.Width-1 do
              begin
                try
                  dd:=(FLedPlasticDepth/20)*min(FPaintBitmap.width/2-dx,FPaintBitmap.height/2-dx);
                  x:=j-dx-dd;y:=i-dx-dd;
                  w:=FPaintBitmap.width/2-dx-dd;
                  h:=FPaintBitmap.height/2-dx-dd;
                  N:=round(255-127*(abs(y-h)+abs(x-w))/(w+h));
                except
                  N:=0;
                end;
                  N:=N+(15-random(3*FLedPlasticDepth));

                if N>255 then N:=255;
                if N<0 then N:=0;
                pByte1[j*3]:=(pByte1[j*3] *k div 2)* N div 255;
                pByte1[j*3+1]:=(pByte1[j*3+1] *k div 2)* N div 255;
                pByte1[j*3+2]:=(pByte1[j*3+2] *k div 2)* N div 255;
              end;
        end;  
    end;

  if FGap<>0 then
    begin
      GapRGN:=CreaterectRGN(0,0,0,0);
      for i:=0 to length(FLedPoints)-1 do
        begin
          if i<>(length(FLedPoints)-1) then
            begin
              ar1[0].x:=FLedPoints[i].x;ar1[0].y:=FLedPoints[i].y;
              ar1[1].x:=FGapPoints[i].x;ar1[1].y:=FGapPoints[i].y;
              ar1[2].x:=FGapPoints[i+1].x;ar1[2].y:=FGapPoints[i+1].y;
              ar1[3].x:=FLedPoints[i+1].x;ar1[3].y:=FLedPoints[i+1].y;
            end else
            begin
              ar1[0].x:=FLedPoints[i].x;ar1[0].y:=FLedPoints[i].y;
              ar1[1].x:=FGapPoints[i].x;ar1[1].y:=FGapPoints[i].y;
              ar1[2].x:=FGapPoints[0].x;ar1[2].y:=FGapPoints[0].y;
              ar1[3].x:=FLedPoints[0].x;ar1[3].y:=FLedPoints[0].y;
            end;
          R1:=CreatePolygonRGN(ar1[0],4,Alternate);
          Combinergn(GapRGN,GapRGN,R1,RGN_OR);
          deleteobject(R1);
        end;


      if (FBorderSubstance=nil) or (FBorderSubstance.height=0) then
        begin
          FPaintBitmap.canvas.brush.color:=FGapColor;
          fillRGN(FPaintBitmap.canvas.handle,GapRGN,FPaintBitmap.canvas.brush.handle);
        end else
        begin
          selectClipRGN(FPaintBitmap.canvas.handle,GapRGN);
          if FBorderSubsMode = iasmTile then
            begin
              for i:=0 to FPaintbitmap.Width div FBorderSubstance.width do
                for j:=0 to FPaintbitmap.height div FBorderSubstance.height do
                  FPaintBitmap.Canvas.Draw(i*FBorderSubstance.width,
                                           j*FBorderSubstance.height,
                                           FBorderSubstance);
            end else
            begin
              FPaintBitmap.Canvas.StretchDraw(rect(0,0,FPaintbitmap.Width,FPaintbitmap.height),FBorderSubstance);
            end;
          selectClipRGN(FPaintBitmap.canvas.handle,0);
        end;
      deleteobject(GapRGN);
    end;
    // define the rgn of light and dark....
  //Outer Border...
  if OuterBorderStyle<>iablsNone then
    begin
      DR:=CreaterectRGN(0,0,0,0);
      LR:=CreaterectRGN(0,0,0,0);
      for i:=0 to length(FLedPoints)-1 do
        begin
          if i<>(length(FLedPoints)-1) then
            begin
              ar1[0].x:=FInnerPoints[i].x;ar1[0].y:=FInnerPoints[i].y;
              ar1[1].x:=FOuterPoints[i].x;ar1[1].y:=FOuterPoints[i].y;
              ar1[2].x:=FOuterPoints[i+1].x;ar1[2].y:=FOuterPoints[i+1].y;
              ar1[3].x:=FInnerPoints[i+1].x;ar1[3].y:=FInnerPoints[i+1].y;
            end else
            begin
              ar1[0].x:=FInnerPoints[i].x;ar1[0].y:=FInnerPoints[i].y;
              ar1[1].x:=FOuterPoints[i].x;ar1[1].y:=FOuterPoints[i].y;
              ar1[2].x:=FOuterPoints[0].x;ar1[2].y:=FOuterPoints[0].y;
              ar1[3].x:=FInnerPoints[0].x;ar1[3].y:=FInnerPoints[0].y;
            end;
          TryAngle:=0;
          if  OuterBorderStyle=iablsDown then inc(TryAngle,1800);
          ddx:=ar1[2].x-ar1[1].x;ddy:=ar1[1].y-ar1[2].y;
          if (abs(round(ddx))+abs(round(ddy)))<>0 then
            begin
              if round(ddx)=0 then
                begin
                  if ddy>0 then inc(TryAngle,900) else dec(TryAngle,900);
                end else
                begin
                  TryAngle:=Tryangle+round(1800*Arctan2(ddy/(abs(ddx)+abs(ddy)),ddx/(abs(ddx)+abs(ddy)))/pi);
                end;
            end;
          R1:=CreatePolygonRGN(ar1[0],4,Alternate);      
          if Angleisdark(TryAngle)      then
            Combinergn(DR,DR,R1,RGN_OR) else
            Combinergn(LR,LR,R1,RGN_OR);
          deleteobject(R1);  
        end;
      if (FBorderSubstance=nil) or (FBorderL.height=0) or (FBorderD.height=0) then
        begin
          FPaintBitmap.canvas.brush.color:=GetLColor(FBorderColor);
          fillRGN(FPaintBitmap.canvas.handle,LR,FPaintBitmap.canvas.brush.handle);
          FPaintBitmap.canvas.brush.color:=GetDColor(FBorderColor);
          fillRGN(FPaintBitmap.canvas.handle,DR,FPaintBitmap.canvas.brush.handle);
        end else
        begin
          selectClipRGN(FPaintBitmap.canvas.handle,LR);
          if FBorderSubsMode = iasmTile then
            begin
              for i:=0 to FPaintbitmap.Width div FBorderL.width do
                for j:=0 to FPaintbitmap.height div FBorderL.height do
                  FPaintBitmap.Canvas.Draw(i*FBorderL.width,
                                           j*FBorderL.height,
                                           FBorderL);
            end else
            begin
              FPaintBitmap.Canvas.StretchDraw(rect(0,0,FPaintbitmap.Width,FPaintbitmap.height),FBorderL);
            end;
          selectClipRGN(FPaintBitmap.canvas.handle,DR);
          if FLedPlasticSubsMode = iasmTile then
            begin
              for i:=0 to FPaintbitmap.Width div FBorderD.width do
                for j:=0 to FPaintbitmap.height div FBorderD.height do
                  FPaintBitmap.Canvas.Draw(i*FBorderD.width,
                                           j*FBorderD.height,
                                           FBorderD);
            end else
            begin
              FPaintBitmap.Canvas.StretchDraw(rect(0,0,FPaintbitmap.Width,FPaintbitmap.height),FBorderD);
            end;
          selectClipRGN(FPaintBitmap.canvas.handle,0);

        end;  
      deleteobject(LR);
      deleteobject(DR);
    end;
  //Inner Border...
  if InnerBorderStyle<>iablsNone then
    begin
      DR:=CreaterectRGN(0,0,0,0);
      LR:=CreaterectRGN(0,0,0,0);
      for i:=0 to length(FLedPoints)-1 do
        begin
          if i<>(length(FLedPoints)-1) then
            begin
              ar1[0].x:=FGapPoints[i].x;ar1[0].y:=FGapPoints[i].y;
              ar1[1].x:=FInnerPoints[i].x;ar1[1].y:=FInnerPoints[i].y;
              ar1[2].x:=FInnerPoints[i+1].x;ar1[2].y:=FInnerPoints[i+1].y;
              ar1[3].x:=FGapPoints[i+1].x;ar1[3].y:=FGapPoints[i+1].y;
            end else
            begin
              ar1[0].x:=FGapPoints[i].x;ar1[0].y:=FGapPoints[i].y;
              ar1[1].x:=FInnerPoints[i].x;ar1[1].y:=FInnerPoints[i].y;
              ar1[2].x:=FInnerPoints[0].x;ar1[2].y:=FInnerPoints[0].y;
              ar1[3].x:=FGapPoints[0].x;ar1[3].y:=FGapPoints[0].y;
            end;
          TryAngle:=0;
          if  InnerBorderStyle=iablsDown then inc(TryAngle,1800);
          ddx:=ar1[2].x-ar1[1].x;ddy:=ar1[1].y-ar1[2].y;
          if (abs(round(ddx))+abs(round(ddy)))<>0 then
            begin
              if round(ddx)=0 then
                begin
                  if ddy>0 then inc(TryAngle,900) else dec(TryAngle,900);
                end else
                begin
                  TryAngle:=Tryangle+round(1800*Arctan2(ddy/(abs(ddx)+abs(ddy)),ddx/(abs(ddx)+abs(ddy)))/pi);
                end;
            end;
          R1:=CreatePolygonRGN(ar1[0],4,Alternate);      
          if Angleisdark(TryAngle)      then
            Combinergn(DR,DR,R1,RGN_OR) else
            Combinergn(LR,LR,R1,RGN_OR);
          deleteobject(R1);  
        end;
      if (FBorderSubstance=nil) or (FBorderL.height=0)  or (FBorderD.height=0) then
        begin
          FPaintBitmap.canvas.brush.color:=GetLColor(FBorderColor);
          fillRGN(FPaintBitmap.canvas.handle,LR,FPaintBitmap.canvas.brush.handle);
          FPaintBitmap.canvas.brush.color:=GetDColor(FBorderColor);
          fillRGN(FPaintBitmap.canvas.handle,DR,FPaintBitmap.canvas.brush.handle);
        end else
        begin
          selectClipRGN(FPaintBitmap.canvas.handle,LR);
          if FBorderSubsMode = iasmTile then
            begin
              for i:=0 to FPaintbitmap.Width div FBorderL.width do
                for j:=0 to FPaintbitmap.height div FBorderL.height do
                  FPaintBitmap.Canvas.Draw(i*FBorderL.width,
                                           j*FBorderL.height,
                                           FBorderL);
            end else
            begin
              FPaintBitmap.Canvas.StretchDraw(rect(0,0,FPaintbitmap.Width,FPaintbitmap.height),FBorderL);
            end;
          selectClipRGN(FPaintBitmap.canvas.handle,DR);
          if FLedPlasticSubsMode = iasmTile then
            begin
              for i:=0 to FPaintbitmap.Width div FBorderD.width do
                for j:=0 to FPaintbitmap.height div FBorderD.height do
                  FPaintBitmap.Canvas.Draw(i*FBorderD.width,
                                           j*FBorderD.height,
                                           FBorderD);
            end else
            begin
              FPaintBitmap.Canvas.StretchDraw(rect(0,0,FPaintbitmap.Width,FPaintbitmap.height),FBorderD);
            end;
          selectClipRGN(FPaintBitmap.canvas.handle,0);
        end;  
      deleteobject(LR);
      deleteobject(DR);
    end;
end;

function TIAgaloLED.GetWidth: integer;
begin
  result:=inherited width;
end;

procedure TIAgaloLED.Loaded;
begin
  inherited Loaded;
  if (FBorderSubstance<>nil) and (FBorderSubstance.height<>0) then
    begin
      FBorderL.Width:=FBorderSubstance.Width;
      FBorderL.Height:=FBorderSubstance.Height;
      FBorderL.PixelFormat:=pf24bit;
      FBorderL.Canvas.Draw(0,0,FBorderSubstance);
      FBorderD.Width:=FBorderSubstance.Width;
      FBorderD.Height:=FBorderSubstance.Height;
      FBorderD.PixelFormat:=pf24bit;
      FBorderD.Canvas.Draw(0,0,FBorderSubstance);
      Light24Bitmap(FBorderL,64);
      Dark24Bitmap(FBorderD,64);
    end;  
end;


procedure TIAgaloLED.Paint;
var
  Gbmp : TBitmap;
  Gpoint : TPoint;
  H1 : HWND;
  DC : HDC;
  i,j,N : integer;
  pByte1 : pbytearray;
  C1 : Tcolor;
  pR,pG,pB : pbyte;
  rx,ry : double;
  RR : HRGN;
begin
      inherited paint;
      if assigned(parent) and (fGaloOn or FGaloOnwas) then
        begin
          RR:=CreateEllipticRGN(left-FGaloSize,top-FGalosize,left+width+FGalosize,top+height+FGalosize);
          RedrawWindow(self.parent.handle,nil,RR,RDW_INVALIDATE or RDW_UPDATENOW or RDW_NOCHILDREN);
          deleteobject(rr);
          if FGaloOnwas then FGaloOnwas:=false;
        end;
      self.Canvas.Draw(0,0,FPaintBitmap);
      if FLedon and FGaloOn and (FGaloSize>0) then
        begin
          GPoint:=self.GetClientOrigin;
          GBmp:=TBitmap.Create;
          GBmp.PixelFormat:=pf24bit;
          GBmp.Width:=width+2*FGaloSize;
          GBmp.Height:=height+2*FGalosize;
          H1:=getdesktopwindow;
          DC:=GetWindowDC(H1);
          bitblt(Gbmp.Canvas.handle,0,0,GBmp.Width,Gbmp.Height,DC,GPoint.x-FGalosize,GPoint.y-FGaloSize,SRCCOPY);
          C1:=ColortoRGB(FLedplasticcolor);
          pR:=@C1;
          pG:=pbyte(integer(pr)+1);
          pB:=pbyte(integer(pG)+1);
          for i:=0 to GBmp.height-1 do
            begin
              pByte1:=GBmp.ScanLine[i];
                for j:=0 to GBmp.Width-1 do
                  begin
                    try
                      ry:=2*i/Gbmp.Height-1;rx:=2*j/Gbmp.Width-1;
                      N:=round((FGaloIntensity /10)*(255-255*sqrt(sqr(rx)+sqr(ry))));
                    except
                      N:=0;
                    end;
                    if N>255 then N:=255;
                    if N<0 then N:=0;
                    pByte1[j*3]:=min(255,pByte1[j*3]+N*pB^ div 255);
                    pByte1[j*3+1]:=min(255,pByte1[j*3+1]+N*pG^ div 255);
                    pByte1[j*3+2]:=min(255,pByte1[j*3+2]+N*pR^ div 255);
                  end;
            end;

          bitblt(DC,GPoint.x-FGalosize,GPoint.y-FGaloSize,GBmp.Width,Gbmp.Height,Gbmp.Canvas.handle,0,0,SRCCOPY);
          releaseDC(H1,DC);
          GBmp.free;
        end;
end;

procedure TIAgaloLED.reinsertpoints;
var i : integer;
begin
  setlength(FLedPoints,length(FLedPointsxy));
  setlength(FGapPoints,length(FGapPointsxy));
  setlength(FInnerPoints,length(FInnerPointsxy));
  setlength(FOuterPoints,length(FOuterPointsxy));
  for i:=0 to length(FLedPointsxy)-1 do
    begin
      FLedpoints[i].x:=round(FLedpointsxy[i].x);
      FLedpoints[i].y:=round(FLedpointsxy[i].y);
    end;
  for i:=0 to length(FGapPointsxy)-1 do
    begin
      FGapPoints[i].x:=round(FGapPointsxy[i].x);
      FGapPoints[i].y:=round(FGapPointsxy[i].y);
    end;
  for i:=0 to length(FInnerPointsxy)-1 do
    begin
      FInnerPoints[i].x:=round(FInnerPointsxy[i].x);
      FInnerPoints[i].y:=round(FInnerPointsxy[i].y);
    end;
  for i:=0 to length(FOuterPointsxy)-1 do
    begin
      FOuterPoints[i].x:=round(FOuterPointsxy[i].x);
      FOuterPoints[i].y:=round(FOuterPointsxy[i].y);
    end;
end;

procedure TIAgaloLED.RotatePolyPoints(var Apoly: TIAxyPoly);
var i,dx : integer;
    x,y,dCx,Dcy : Double;
begin
  Dx:=FGap;
  if FInnerBorderStyle<>iablsNone then inc(dX,FInnerBorderDepth);
  if FOuterBorderStyle<>iablsNone then inc(dX,FOuterBorderDepth);
  dcX:=(FLedWidth+2*dx)*cos(FAngle*pi/1800)/2+(FLedHeight+2*dx)*sin(FAngle*pi/1800)/2;
  dcY:=-(FLedWidth+2*dx)*sin(FAngle*pi/1800)/2+(FLedHeight+2*dx)*cos(FAngle*pi/1800)/2;
  dcx:=width/2-dcx;
  dcy:=height/2-dcy;
  for i:=0 to length(APoly)-1 do
    begin
      x:=APoly[i].x*cos(FAngle*pi/1800)+APoly[i].y*sin(FAngle*pi/1800);
      y:=-APoly[i].x*sin(FAngle*pi/1800)+APoly[i].y*cos(FAngle*pi/1800);
      x:=x+dcx;
      y:=y+dcy;
      APoly[i].x:=x;
      APoly[i].y:=y;
    end;
end;

procedure TIAgaloLED.SetAngle(Value: integer);
begin
  if Value<>FAngle then
    begin
      while Value>1800 do dec(Value,3600);
      while Value<=-1800 do inc(Value,3600);
      FAngle := Value;
      DefineWidthHeight;
      GetPaintBitmap;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetBorderColor(Value: TColor);
begin
  if Value<>FBorderColor then
    begin
      FBorderColor := Value;
      GetPaintBitmap;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetBorderSubsMode(Value: TIAglSubstanceMode);
begin
  if Value<>FBorderSubsMode then
    begin
      FBorderSubsMode := Value;
      GetPaintBitmap;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetBorderSubstance(Value: TBitmap);
begin
  if (Value=nil) or (Value.Width=0) or (Value.Height=0) then
    begin
      FBorderSubstance.height:=0;
      FBorderL.height:=0;
      FBorderD.height:=0;
    end else
    begin
      FBorderSubstance.Width:=Value.Width;
      FBorderSubstance.Height:=Value.Height;
      FBorderSubstance.PixelFormat:=pf24bit;
      FBorderSubstance.Canvas.Draw(0,0,Value);
      FBorderL.Width:=Value.Width;
      FBorderL.Height:=Value.Height;
      FBorderL.PixelFormat:=pf24bit;
      FBorderL.Canvas.Draw(0,0,Value);
      FBorderD.Width:=Value.Width;
      FBorderD.Height:=Value.Height;
      FBorderD.PixelFormat:=pf24bit;
      FBorderD.Canvas.Draw(0,0,Value);
      Light24Bitmap(FBorderL,64);
      Dark24Bitmap(FBorderD,64);
    end;
  GetPaintBitmap;  
  invalidate;
end;

procedure TIAgaloLED.SetGaloIntensity(Value: integer);
begin
  if (Value<>FGaloIntensity) and (Value>0) and (value<11) then
    begin
      FGaloIntensity := Value;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetGaloON(Value: Boolean);
begin
  if Value<>FGaloOn then
    begin
      if FGaloOn and not Value then FGaloONwas:=true else FGaloONwas:=false;
      FGaloON := Value;

      invalidate;
    end;
end;

procedure TIAgaloLED.SetGaloSize(Value: integer);
begin
  if (Value<>FGaloSize) and (Value>=0) and (Value<50) then
    begin
      FGaloSize := Value;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetGap(Value: integer);
begin
  if (FGap<>Value) and (Value>=0) then
    begin
      FGap := Value;
      DefineWidthHeight;
      GetPaintBitmap;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetGapColor(Value: TColor);
begin
  if Value<>FGapColor then
    begin
      FGapColor := Value;
      GetPaintBitmap;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetHeight(Value: Integer);
begin
  if (abs(cos(pi*FAngle/1800))<1e-4) or (abs(sin(pi*FAngle/1800))<1e-4) then
    begin
      inherited height:=value;
      FLastHeight:=Value;
    end;
end;

procedure TIAgaloLED.SetInnerBorderDepth(Value: integer);
begin
  if  (FInnerBorderDepth<>Value) and (value>=0) then
    begin
      FInnerBorderDepth := Value;
      DefineWidthHeight;
      GetPaintBitmap;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetInnerBorderStyle(Value: TIABorderLedStyle);
begin
  if FInnerBorderStyle<>Value then
    begin
      FInnerBorderStyle := Value;
      DefineWidthHeight;
      GetPaintBitmap;
      invalidate;
    end;
end;







procedure TIAgaloLED.SetLedClass(Value: TIALedClass);
begin
  if FLedClass<>Value then
    begin
      FLedClass := Value;
      DefineWidthHeight;
      GetPaintBitmap;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetLedHeight(Value: integer);
begin
  if (FLedHeight<>Value) and (Value>=0) then
    begin
      FLedHeight := Value;
      DefineWidthHeight;
      GetPaintBitmap;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetLedOn(Value: Boolean);
begin
  if FLedOn<>Value then
    begin
      FLedOn := Value;
      GetPaintBitmap;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetLedPlasticColor(Value: TColor);
begin
  if FLedPlasticColor<>Value then
    begin
      FLedPlasticColor := Value;
      GetPaintBitmap;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetLedPlasticDepth(Value: integer);
begin
  if (FLedPlasticDepth<>Value) and (Value>=1) and (Value<11) then
    begin
      FLedPlasticDepth := Value;
      GetPaintBitmap;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetLedPlasticSubsMode(Value: TIAglSubstanceMode);
begin
  if Value<>FLedPlasticSubsMode then
    begin
      FLedPlasticSubsMode := Value;
      GetPaintBitmap;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetLedPlasticSubstance(Value: TBitmap);
begin
  if (Value=nil) or (Value.Width=0) or (Value.Height=0) then
    begin
      FLedPlasticSubstance.height:=0;
      GetPaintBitmap;
      invalidate;
    end else
    begin
      FLedPlasticSubstance.PixelFormat:=pf24bit;
      FLedPlasticSubstance.Width:=Value.Width;
      FLedPlasticSubstance.Height:=Value.Height;
      FLedPlasticSubstance.Canvas.Draw(0,0,Value);
      GetPaintBitmap;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetLedWidth(Value: integer);
begin
  if (FLedWidth<>Value) and (Value>=0) then
    begin
      FLedWidth := Value;
      DefineWidthHeight;
      GetPaintBitmap;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetOuterBorderDepth(Value: integer);
begin
  if (FOuterBorderDepth<>Value) and (Value>=0) then
    begin
      FOuterBorderDepth := Value;
      DefineWidthHeight;
      GetPaintBitmap;
      invalidate;
    end;
end;

procedure TIAgaloLED.SetOuterBorderStyle(Value: TIABorderLedStyle);
begin
  if FOuterBorderStyle<>value then
    begin
      FOuterBorderStyle := Value;
      DefineWidthHeight;
      GetPaintBitmap;
      invalidate;
    end;
end;



procedure TIAgaloLED.SetWidth(Value: Integer);
begin
  if (abs(cos(pi*FAngle/1800))<1e-4) or (abs(sin(pi*FAngle/1800))<1e-4) then
    begin
      inherited width:=value;
      FLastWidth:=Value;
    end;
end;    

procedure TIAgaloLED.WMMOVE(var Message: TMessage);
var r : Trect;
begin
  inherited;
    if assigned(Parent) and (FGaloOn) and (FLedOn) then
    begin
      r:=rect(0,0,parent.width-1,parent.height-1);
      invalidaterect(parent.handle,@r,true);
      RedrawWindow(self.parent.handle,@r,0,RDW_INVALIDATE or RDW_UPDATENOW or RDW_AllCHILDREN);
    end;
  Message.Result:=0;  
end;

procedure TIAgaloLED.WMSIZE(var Message: TMessage);
var dX : integer;
    r : Trect;
begin
  inherited;

  if (not ((abs(cos(pi*FAngle/1800))<1e-4) or (abs(sin(pi*FAngle/1800))<1e-4))) and
     ((FLastWidth<>Message.LParamLo) or (FLastHeight<>Message.LParamHi)) then
    begin
      MoveWindow(self.handle,left,top,FLastWidth,FLastHeight,TRUE);
      Message.Result:=0;
    end else
    begin
      if ((abs(cos(pi*FAngle/1800))<1e-4) or (abs(sin(pi*FAngle/1800))<1e-4)) then
        begin
          if abs(abs(cos(pi*FAngle/1800))-1)<1e-4 then
            begin //1...3
              FLedWidth :=Message.LParamLo;
              FLedHeight:=Message.LParamHi;
            end else
            begin
              FLedHeight:=Message.LParamLo;
              FLedwidth :=Message.LParamHi;
            end;
          Dx:=FGap;
          if FInnerBorderStyle<>iablsNone then inc(dX,FInnerBorderDepth);
          if FOuterBorderStyle<>iablsNone then inc(dX,FOuterBorderDepth);
          dec(FledWidth,2*dx);
          dec(FLedHeight,2*dx);
          if (FledWidth<0) or (FLedheight<0) then
            begin
              if FLedWidth<0  then FLedWidth :=0;
              if FLedHeight<0 then FLedHeight:=0;
              DefineWidthHeight;
              GetPaintBitmap;
            end;
          Message.Result:=0;
        end;
        DefineWidthHeight;
        GetPaintBitmap;
        Message.Result:=0;
    end;
  if assigned(Parent)  and (FGaloOn) and (FLedOn) then
    begin
      r:=rect(0,0,parent.width-1,parent.height-1);
      invalidaterect(parent.handle,@r,true);
      RedrawWindow(self.parent.handle,@r,0,RDW_INVALIDATE or RDW_UPDATENOW or RDW_AllCHILDREN);
    end;
end;

end.
