unit LKRegisterFormWizard;
{	The purpose of this Unit is to register selfmade form classes (descendants of TForm)
	that introduce new published properties.
	They appear in the "File/New"-Dialog on a page named "Form Classes".
	The new published properties are now visible in the object inspector.

	To register a Form you have to change some of the code below and then install
	the package, this unit is part of.
	The changes:
		Add the unit(s) that hold(s) your new form class(es) to the uses clause in the implementation section.
		Add a line like
				RegisterNewFormClass(TMyNewEnhancedForm);
		to the "Register" prcedure.
		Add the unit(s) that hold(s) your new form class(es) to the uses clause of the
				form template string (const lkFormTemplate).
		If you want, change the form template the way you want.
		Edit the Resource File "LKRegisterFormWizard.RES" to add a Symbol for your Form
			(Name it like your form class, full name, including the "T")

		Good luck,
		Lutz
}



{$R *.res}

interface

uses
	Windows,
	Forms,
	ToolsAPI;

type
	TLKFrmWiz = class(TInterfacedObject,
											IOTAWIzard,
											IOTARepositoryWizard,
											IOTAFormWizard)
		fFrmClassName: string;
		constructor Create(NewFormClassName: string);
		{ IOTANotifier }
		procedure AfterSave;
		procedure BeforeSave;
		procedure Destroyed;
		procedure Modified;
		{ IOTAWizard }
		function GetIDString: string;
		function GetName: string;
		function GetState: TWizardState;
		procedure Execute;
		{ IOTARepositoryWizard }
		function GetAuthor: string;
		function GetComment: string;
		function GetPage: string;
		function GetGlyph: HICON;
	end;

	TLKFormCreator = class(TInterfacedObject, IOTACreator, IOTAModuleCreator)
	private
		fFormClassName : string;
		fClassName : string;
		fUnitIdent : string;
		fFileName : string;
	public
		constructor Create(FormClassName: string);
		{ IOTACreator }
		function GetCreatorType: string;
		function GetExisting: Boolean;
		function GetFileSystem: string;
		function GetOwner: IOTAModule;
		function GetUnnamed: Boolean;
		{ IOTAModuleCreator }
		procedure FormCreated(const FormEditor: IOTAFormEditor);
		function GetAncestorName: string;
		function GetImplFileName: string;
		function GetIntfFileName: string;
		function GetFormName: string;
		function GetMainForm: Boolean;
		function GetShowForm: Boolean;
		function GetShowSource: Boolean;
		function NewFormFile(const FormIdent, AncestorIdent: string): IOTAFile;
		function NewImplSource(const ModuleIdent, FormIdent, AncestorIdent: string): IOTAFile;
		function NewIntfSource(const ModuleIdent, FormIdent, AncestorIdent: string): IOTAFile;
	end;

procedure RegisterNewFormClass(NewFormClass: TFormClass);
procedure Register;

/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
implementation

uses
	Classes,
  DsgnIntf,
	SysUtils,
	LKDemoForms;      {Replace this line with your own Forms unit}

{Add one call of RegisterNewFormClass for each new FormClass you want to use.}
procedure Register;
begin
	RegisterNewFormClass(TLKDemoForm);
end;


resourcestring
{This string constant holds the source that is shown in the Unit after creation of the Form.
	It uses some template strings that are replaced by the real names:
		%UnitIdent%			-> default name of the unit (e.g. unit1, unit2, ...)
		%ClassName% 		-> the forms class name (e.g. TMyForm1, TEnhandedForm3, ...)
		%AncestorName%	-> Name of the form classes ancestor (usually TForm)
		%FormName%			-> Name of the form variable (like in MyOwnForm: TMyOwnForm)
	}
	lkFormTemplate =
		'unit %UnitIdent%;'#13#10
		+ #13#10
		+ 'interface'#13#10
		+ #13#10
		+ 'uses'#13#10
		+ '	Windows,'#13#10
		+ '	Messages,'#13#10
		+ '	SysUtils,'#13#10
		+ '	Classes,'#13#10
		+ '	Graphics,'#13#10
		+ '	Controls,'#13#10
		+ '	Forms,'#13#10
		+ '	Dialogs,'#13#10
		+ #13#10
		+ '	LKDemoForms;'#13#10 		 									{Replace this line with your own Forms unit}
		+ #13#10
		+ #13#10
		+ 'type'#13#10
		+ '	%ClassName% = class(T%AncestorName%)'#13#10
		+ '	private'#13#10
		+ #13#10
		+ '	public'#13#10
		+ #13#10
		+ '	end;'#13#10
		+ #13#10
		+ 'var'#13#10
		+ '	%FormName%: %ClassName%;'#13#10
		+ #13#10
		+ 'implementation'#13#10
		+ #13#10
		+ '{$R *.DFM}'#13#10
		+ #13#10
		+ 'end.'#13#10;


//***************************************************************************************
// 		utility functions
//***************************************************************************************

//----------------------------------------------------------------------
{This procedure registers the "Wizard", that shows the forms Icon in the "File/New" window
	as well as the class of the new form.}
procedure RegisterNewFormClass(NewFormClass: TFormClass);
begin
	RegisterPackageWizard(TLKFrmWiz.Create(NewFormClass.ClassName) as IOTAWizard);
	RegisterCustomModule(NewFormClass, TCustomModule)
end;

//----------------------------------------------------------------------
function FindModuleInterface(AInterface: TGUID): IUnknown;
var
	I: Integer;
begin
	Result := nil;
	with BorlandIDEServices as IOTAModuleServices do
		for I := 0 to ModuleCount - 1 do
			if (Modules[I].QueryInterface(AInterface, Result) = S_OK) then
				Break;
end;

//----------------------------------------------------------------------
function GetProjectGroup: IOTAProjectGroup;
begin
	Result := FindModuleInterface(IOTAProjectGroup) as IOTAProjectGroup;
end;

//----------------------------------------------------------------------
function GetCurrentProject: IOTAProject;
var
	ProjectGroup: IOTAProjectGroup;
begin
	Result := nil;
	ProjectGroup := GetProjectGroup;
	if Assigned(ProjectGroup) then
		Result := ProjectGroup.ActiveProject
	else
		Result := FindModuleInterface(IOTAProject) as IOTAProject;
end;


//***************************************************************************************
//***************************************************************************************
{ TLKFrmWiz }
//***************************************************************************************


constructor TLKFrmWiz.Create(NewFormClassName: string);
begin
	inherited Create;
	fFrmClassName := NewFormClassName;
end;

procedure TLKFrmWiz.AfterSave;
begin //Tu Nix
end;

procedure TLKFrmWiz.BeforeSave;
begin //Tu Nix
end;

procedure TLKFrmWiz.Destroyed;
begin //Tu Nix
end;

procedure TLKFrmWiz.Modified;
begin //Tu Nix
end;

function TLKFrmWiz.GetAuthor: string;
begin
	Result := 'Lutz Kutscher';
end;

function TLKFrmWiz.GetComment: string;
begin
	Result := 'Wizard for new form classes';
end;

function TLKFrmWiz.GetGlyph: HICON;
begin
	Result := LoadIcon(HInstance, PChar(fFrmClassName));
	if Result = 0 then
		Result := LoadIcon(HInstance,'Standard')
end;

function TLKFrmWiz.GetIDString: string;
begin
	Result := 'LKutscher.UseMyOwnForm.'+fFrmClassName;
end;

function TLKFrmWiz.GetName: string;
begin
	Result := fFrmClassName;
end;

function TLKFrmWiz.GetPage: string;
begin
	Result := 'Form Classes';
end;

function TLKFrmWiz.GetState: TWizardState;
begin
	Result:=[wsEnabled];
end;

procedure TLKFrmWiz.Execute;
var
	ModuleServices : IOTAModuleServices;
begin
	ModuleServices:=BorlandIDEServices as IOTAModuleServices;
	ModuleServices.CreateModule(TLKFormCreator.Create(fFrmClassName));
end;



//***************************************************************************************
//***************************************************************************************
{ TOTAFile }
//***************************************************************************************

type
	TOTAFile = class(TInterfacedObject, IOTAFile)
	private
		FSource: string;
	public
		constructor Create(const ASource: string);
		{ IOTAFile }
		function GetSource: string;
		function GetAge: TDateTime;
	end;

constructor TOTAFile.Create(const ASource: string);
begin
	inherited Create;
	FSource:=ASource;
end;

function TOTAFile.GetAge: TDateTime;
begin
	Result:=-1;
end;

function TOTAFile.GetSource: string;
begin
	Result:=FSource;
end;


//***************************************************************************************
//***************************************************************************************
{ TLKFrmCreator }
//***************************************************************************************

//***************************************************************************************
constructor TLKFormCreator.Create(FormClassName: string);
var
	FrmName: string;
begin
	FrmName := FormClassName;
	Delete(FrmName, 1, 1);
	fFormClassName := FrmName;
	(BorlandIDEServices as IOTAModuleServices).GetNewModuleAndClassName(FormClassName,
																											fUnitIdent, fClassName, fFileName);
end;

//***************************************************************************************
function TLKFormCreator.GetCreatorType: string;
begin
	Result := sForm;
end;

//***************************************************************************************
function TLKFormCreator.GetExisting: Boolean;
begin
	Result := False;
end;

//***************************************************************************************
function TLKFormCreator.GetFileSystem: string;
begin
	Result:='';
end;

//***************************************************************************************
function TLKFormCreator.GetOwner: IOTAModule;
begin
	Result := GetCurrentProject;
end;

//***************************************************************************************
function TLKFormCreator.GetUnnamed: Boolean;
begin
	Result:=True;
end;

//***************************************************************************************
procedure TLKFormCreator.FormCreated(const FormEditor: IOTAFormEditor);
begin
end;

//***************************************************************************************
function TLKFormCreator.GetAncestorName: string;
begin
	Result := fFormClassName;
end;

//***************************************************************************************
function TLKFormCreator.GetImplFileName: string;
begin
	Result:=FFileName;
end;

//***************************************************************************************
function TLKFormCreator.GetIntfFileName: string;
begin
	Result:='';
end;

//***************************************************************************************
function TLKFormCreator.GetFormName: string;
var
	FrmName: string;
begin
	FrmName := fClassName;
	Delete(FrmName, 1, 1);
	Result := FrmName;
end;

//***************************************************************************************
function TLKFormCreator.GetMainForm: Boolean;
begin
//!!!!!!!!!!!!!!!!!!!!!!!
	Result := False;
end;

//***************************************************************************************
function TLKFormCreator.GetShowForm: Boolean;
begin
	Result := True;
end;

//***************************************************************************************
function TLKFormCreator.GetShowSource: Boolean;
begin
	Result := True;
end;

//***************************************************************************************
function TLKFormCreator.NewFormFile(const FormIdent, AncestorIdent: string): IOTAFile;
begin
	Result:=nil;
end;

//***************************************************************************************
function TLKFormCreator.NewImplSource(const ModuleIdent, FormIdent, AncestorIdent: string): IOTAFile;
var
	Src: string;
begin
	Src := lkFormTemplate;
	Src := StringReplace(Src, '%UnitIdent%', fUnitIdent, [rfReplaceAll]);
	Src := StringReplace(Src, '%ClassName%', fClassName, [rfReplaceAll]);
	Src := StringReplace(Src, '%FormName%', GetFormName, [rfReplaceAll]);
	Src := StringReplace(Src, '%AncestorName%', GetAncestorName, [rfReplaceAll]);

	Result:=TOTAFile.Create(Src);
end;

//***************************************************************************************
function TLKFormCreator.NewIntfSource(const ModuleIdent, FormIdent, AncestorIdent: string): IOTAFile;
begin
	Result:=nil;
end;


end.
