unit Example;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, OleCtrls, StdCtrls, ComCtrls, Buttons,
  Menus, ExploreCmdD4 ;

type
  TExplorerForm = class(TForm)
    Timer: TTimer;
    StatusBar: TStatusBar;
    SubPanel: TPanel;
    Panel: TPanel;
    Time: TEdit;
    NavigatePanel: TPanel;
    IndButt: TSpeedButton;
    AvButt: TSpeedButton;
    menuButt: TSpeedButton;
    Label1: TLabel;
    Address: TComboBox;
    Browser: TExplorerD4;
    procedure BrowserCommand(Command, Parameters: String);
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BrowserStatusTextChange(Sender: TObject;
      const Text: WideString);
    procedure BrowserTitleChange(Sender: TObject;
      const Text: WideString);
    procedure BrowserNavigateComplete(Sender: TObject;
      pDisp: IDispatch; var URL: OleVariant);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure IndButtClick(Sender: TObject);
    procedure AvButtClick(Sender: TObject);
    procedure menuButtClick(Sender: TObject);
    procedure AddressKeyPress(Sender: TObject; var Key: Char);
    procedure BrowserNewWindow2(Sender: TObject; var ppDisp: IDispatch;
      var Cancel: WordBool);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure HideAllPanels ;
  end;

var
  ExplorerForm: TExplorerForm;

implementation

{$R *.DFM}

uses FormEx, FormDB ;

procedure TExplorerForm.HideAllPanels ;
begin
     // This is to avoid to overlap the panels.
     // Only one is the panel visible.
     FormExample.SubPanel.Visible := false ;
     dbForm.SubPanel.Visible := false ;
end ;

// This procedure is connected to the OnCommand event of the TExplorerCommand
procedure TExplorerForm.BrowserCommand(Command, Parameters: String);
begin
     // Show a form over the browser page
     if Command='form' then
     begin
          HideAllPanels ;
          FormExample.SubPanel.parent := Panel ;
          if Parameters = 'show' then FormExample.ShowControls ( true ) ;
          if Parameters = 'showdisabled' then FormExample.ShowControls ( false ) ;

          if Parameters = '' then
             ShowMessage ( 'This command needs a parameter: usage form$show or form$showdisabled' )
          else
          begin
               FormExample.SubPanel.Visible := true ;
               Panel.visible := true ;
          end ;
     end ;

     // Show the message using the parameters
     if Command='dialog' then
        ShowMessage ( 'You have clicked the ' + Parameters + ' link' ) ;

     // Example of overlay single controls over the Web page
     if Command='time' then Time.visible := ( Parameters = 'show' ) ;

     // An example of database filtering
     if Command='dblist' then
     begin
          HideAllPanels ;
          try
             dbform.Table1.active := true ;

             dbform.SubPanel.parent := Panel ;

             dbform.Table1.Filtered := false ;
             if copy(Parameters, 1, 4) = 'less' then
                dbform.Table1.Filter := 'Length_In < ' + copy ( Parameters, 5, 2 ) ;
             if copy(Parameters, 1, 4) = 'more' then
                dbform.Table1.Filter := 'Length_In >= ' + copy ( Parameters, 5, 2 ) ;
             if copy(Parameters, 1, 4) = 'like' then
                dbform.Table1.Filter := 'Common_Name = ''' + copy ( Parameters, 5, 20 ) + '*''' ;
             if copy(Parameters, 1, 3) <> 'all' then
                dbform.Table1.Filtered := true ;

             dbForm.SubPanel.Visible := true ;
             Panel.visible := true ;
          except
                ShowMessage ('Exception. Probably you haven''t DBDEMOS installed' ) ;
          end ;
     end ;

     // But if you want you can show a toolbar
     if Command='toolbar' then NavigatePanel.Visible := ( Parameters = 'show' ) ;

     // You can also exitting the program
     if Command='exit' then Close ;
     if Command='shutdown' then Halt ;

     // This can be useful without the toolbar
     // Please note that there are some problem for these two command if
     // your web pages uses a predefined target frame. Use instead the target for
     // every link.
     if Command='previous' then IndButtClick ( Application ) ;
     if Command='next' then AvButtClick ( Application ) ;

     // If the shareware control goes out of command
     if Command='endsession' then
        ShowMessage ('You have reached the limit of 50 command for this shareware version') ;
end;

procedure TExplorerForm.FormShow(Sender: TObject);
var
   s : string ;
begin
     // We suppose that you use the directory structure
     // coming with the ZIP file
     s := ExtractFilePath ( paramStr (0) ) ;
     Browser.FirstPage := s + 'html\default.htm' ;
end;

procedure TExplorerForm.FormResize(Sender: TObject);
begin
     // Resize the panel to cover the main frame
     Panel.Top := 118 ;
     Panel.left := 214 ;
     Panel.Width := Browser.Width - Panel.Left - 14 ;
     Panel.Height := Browser.Height - Panel.Top - 1 ;

     // And let the Time Text object near the border
     Time.Left := ExplorerForm.Width - Time.Width - 30 ;
end;

procedure TExplorerForm.TimerTimer(Sender: TObject);
begin
     // To show the time
     Time.Text := formatDateTime ( 'dd mmmm yyyy hh:nn:ss', now ) ;
end;

procedure TExplorerForm.FormCreate(Sender: TObject);
begin
     // The application bitmaps are for 800x600 pixels
     // ExplorerForm.Width := 800 ;
     // ExplorerForm.Height := 550 ;
end;

procedure TExplorerForm.BrowserStatusTextChange(Sender: TObject;
  const Text: WideString);
begin
     // Show the current selected link in the status bar
     StatusBar.Panels[0].Text := Text ;
end;

procedure TExplorerForm.BrowserTitleChange(Sender: TObject;
  const Text: WideString);
begin
     // Show the current page title on the application caption
     ExplorerForm.Caption := Text + ' - TExplorerCommand sample' ;
end;

procedure TExplorerForm.BrowserNavigateComplete(Sender: TObject;
  pDisp: IDispatch; var URL: OleVariant);
begin
     // Hide the panel if visible when is the moment to
     // show a page
     if Panel.visible = true then
        Panel.Visible := false ;
end;

procedure TExplorerForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
     CanClose := false ;
     if ( messageDlg ( 'Do you want really exit this sample', mtConfirmation,
                       mbOKCancel, 0 ) = mrOK ) then CanClose := true ;
end;

procedure TExplorerForm.IndButtClick(Sender: TObject);
begin
     // Hide the panel if visible, otherwise goForward
     if Panel.visible = true then
        Panel.Visible := false
     else
         try
            Browser.GoBack ;
         except
         end ;
end;

procedure TExplorerForm.AvButtClick(Sender: TObject);
begin
     // Hide the panel if visible, otherwise goForward
     if Panel.visible = true then
        Panel.Visible := false
     else
         try
            Browser.GoForward ;
         except
         end ;
end;

procedure TExplorerForm.menuButtClick(Sender: TObject);
var
   null : OLEvariant ;
begin
     // Reload the application first page
     // Browser.WebNavigate ( Browser.FirstPage , '' ) ;

     // Provina
     null := 0 ;
     try
        Browser.EXECWB ( OLECMDID_PRINT, OLECMDEXECOPT_PROMPTUSER, null, null ) ;
     except
     end ;
end;

procedure TExplorerForm.AddressKeyPress(Sender: TObject; var Key: Char);
begin
     // Adds the last address to the list and navigate
     if key=#13 then
     begin
          key := #0 ;
          Address.Items.Add ( Address.text ) ;
          Browser.WebNavigate ( Address.Text, '' ) ;
     end ;
end;

procedure TExplorerForm.BrowserNewWindow2(Sender: TObject;
  var ppDisp: IDispatch; var Cancel: WordBool);
begin
     // Cancel := true ;
     ppDisp := Browser ;
     // Browser.Webnavigate ( Browser.LocationURL, '' ) ; 
end;

end.
