unit ExImgTst;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ExtCtrls, PgExImg;

type
  TMainForm = class(TForm)
    PgExImage1: TPgExImage;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    LoadImage1: TMenuItem;
    SaveImage1: TMenuItem;
    Exit1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Efects1: TMenuItem;
    Blure1: TMenuItem;
    Sharpen1: TMenuItem;
    Brightness1: TMenuItem;
    Invert1: TMenuItem;
    GrayScale1: TMenuItem;
    Envlope1: TMenuItem;
    About1: TMenuItem;
    Reload1: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure LoadImage1Click(Sender: TObject);
    procedure SaveImage1Click(Sender: TObject);
    procedure Blure1Click(Sender: TObject);
    procedure Sharpen1Click(Sender: TObject);
    procedure Brightness1Click(Sender: TObject);
    procedure Invert1Click(Sender: TObject);
    procedure GrayScale1Click(Sender: TObject);
    procedure Envlope1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Reload1Click(Sender: TObject);
  private
    FCurrentPicture : String;
  public
    Procedure Reload;
  end;

var
  MainForm: TMainForm;

implementation

uses BlurUnt, ShrpUnt, BritUnt, EnvMain;

{$R *.DFM}

procedure TMainForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.LoadImage1Click(Sender: TObject);
begin
  IF OpenDialog1.Execute Then
  Begin
    PgExImage1.Picture.LoadFromFile(OpenDialog1.FileName);
    FCurrentPicture := OpenDialog1.FileName;
  End;  
end;

procedure TMainForm.SaveImage1Click(Sender: TObject);
begin
  IF SaveDialog1.Execute Then
    PgExImage1.Picture.SaveToFile(SaveDialog1.FileName);
end;

procedure TMainForm.Blure1Click(Sender: TObject);
begin
  IF BlurForm.ShowModal = mrOk Then
  Begin
    PgExImage1.Blur(StrToInt(BlurForm.Edit1.Text),StrToInt(BlurForm.Edit2.Text));
    ShowMessage('Done');
  End;
end;

procedure TMainForm.Sharpen1Click(Sender: TObject);
begin
  IF SharpenForm.ShowModal = mrOk Then
  Begin
    PgExImage1.Sharpen(StrToInt(SharpenForm.Edit1.Text),StrToInt(SharpenForm.Edit2.Text));
    ShowMessage('Done');
  End;
end;

procedure TMainForm.Brightness1Click(Sender: TObject);
begin
  IF BrightnessForm.ShowModal = mrOk Then
  Begin
    PgExImage1.Brightness(StrToInt(SharpenForm.Edit1.Text));
    ShowMessage('Done');
  End;
end;

procedure TMainForm.Invert1Click(Sender: TObject);
begin
  PgExImage1.Invert;
end;

procedure TMainForm.GrayScale1Click(Sender: TObject);
begin
  PgExImage1.GreyScale;
end;

procedure TMainForm.Envlope1Click(Sender: TObject);
Var
  I : Integer;
Begin
  IF EnvelpsForm.ShowModal = mrOk Then
    With PgExImage1 Do
    Begin
      For I := 0 To 255 Do
      Begin
        RedEnvelop[I]   := EnvelpsForm.DArray[1,I];
        GreenEnvelop[I] := EnvelpsForm.DArray[2,I];
        BlueEnvelop[I]  := EnvelpsForm.DArray[3,I];
      End;
      ApplyEnvelops;
    End;
End;

procedure TMainForm.About1Click(Sender: TObject);
begin
 ShowMessage('The picture for tests is from www.corbis.com as a free picture download');
end;

Procedure TMainForm.Reload;
Begin
  PgExImage1.Picture.LoadFromFile(FCurrentPicture);
End;

procedure TMainForm.FormActivate(Sender: TObject);
begin
  FCurrentPicture := '1.bmp';
  Reload;
end;

procedure TMainForm.Reload1Click(Sender: TObject);
begin
  Reload;
end;

end.
