unit EnvMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Spin, Buttons;

const

 ArrayMax  = 255;
 MaxValue  = 255;
 MaxColors = 3;
 
type
  TEnvelpsForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Button1: TButton;
    Image3: TImage;
    Button2: TButton;
    Res: TSpinEdit;
    Label1: TLabel;
    ComboBox1: TComboBox;
    Image1: TImage;
    Image2: TImage;
    BitBtn1: TBitBtn;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Image3MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Image3MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image3MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    YOffset,
    MaxX,
    MaxY :Integer;
    MouseDown:Boolean;
    CurrentColor :Byte;
    procedure RepaintArray(AColor:Byte);
    procedure GenerateArray(AColor:Byte);
    function CalcX(i:Integer):Integer;
    function CalcI(X:Integer):Integer;
    function CalcY(i:Integer):Integer;
    function CalcJ(Y:Integer):Integer;
    function GetColor(AColor:Byte):TColor;
    function GetImage(AColor:Byte):TImage;
  Public
    DArray:array[1..MaxColors,0..ArrayMax] of Real; //data array for three colors
  End;

var
  EnvelpsForm : TEnvelpsForm;
  Cleared     : Boolean;

implementation

{$R *.DFM}

function TEnvelpsForm.GetImage(AColor:Byte):TImage;
begin
 case AColor of
  1:Result:=Image1;
  2:Result:=Image2;
  3:Result:=Image3;
 end;
 Result.BringToFront;
end;

function TEnvelpsForm.GetColor(AColor:Byte):TColor;
begin
 case AColor of
  1:Result:=clRed;
  2:Result:=clGreen;
  3:Result:=clBlue;
 end; 
end;

procedure TEnvelpsForm.GenerateArray(AColor:Byte);
var
 i:Integer;
begin
 YOffset:=GetImage(AColor).Height div 2; //new axle
 MaxX:=GetImage(AColor).Width;
 MaxY:=GetImage(AColor).Height;
 CurrentColor:=AColor;
 for i:=0 to ArrayMax do
  DArray[AColor,i]:=CalcY(1);
end;

function TEnvelpsForm.CalcX(i:Integer):Integer; //conver I to X
begin
 Result:=MaxX * i div ArrayMax;
end;

function TEnvelpsForm.CalcI(X:Integer):Integer; //conver X to I
begin
 Result:=ArrayMax * X div MaxX;
end;

function TEnvelpsForm.CalcY(i:Integer):Integer; //conver J to Y
begin
 Result:=(MaxY * i div MaxValue) + YOffset;
end;

function TEnvelpsForm.CalcJ(Y:Integer):Integer; //conver Y to J
begin
 Result:=MaxValue * (Y - YOffset) div MaxY;
end;

procedure TEnvelpsForm.RepaintArray(AColor:Byte);
var
 i:Integer;
begin
 GetImage(AColor).Picture.Assign(nil);
 GetImage(AColor).Canvas.MoveTo(0,YOffset);
 GetImage(AColor).Canvas.Pen.Color:=GetColor(AColor);
 for i:=0 to ArrayMax do
  GetImage(AColor).Canvas.LineTo(CalcX(i),CalcY(Trunc(DArray[AColor,i])));
end;

procedure TEnvelpsForm.Button1Click(Sender: TObject);
begin
 GenerateArray(1);
 GenerateArray(2);
 GenerateArray(3);
 RepaintArray(1);
 RepaintArray(2);
 RepaintArray(3);
 CurrentColor:=1;
end;

procedure TEnvelpsForm.Button2Click(Sender: TObject);
begin
 RepaintArray(1);
end;

procedure TEnvelpsForm.Image3MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 MouseDown:=True;
 Image1.Transparent:=False;
 Image2.Transparent:=False;
 Image3.Transparent:=False;
end;

procedure TEnvelpsForm.Image3MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
 i:Integer;
begin
 if MouseDown then
  begin
   RepaintArray(CurrentColor); //clear last curve
   for i:=X - (Res.Value div 2) to X + (Res.Value div 2) do //apply resolution
    if (i >= 0) and (i <= MaxX) then
     DArray[CurrentColor,CalcI(i)]:=CalcJ(Y);
   RepaintArray(CurrentColor); //draw new curve
   GetImage(CurrentColor).Repaint;
  end; 
end;

procedure TEnvelpsForm.Image3MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 MouseDown:=False;
 Image1.Transparent:=True;
 Image2.Transparent:=True;
 Image3.Transparent:=True;
end;

procedure TEnvelpsForm.ComboBox1Change(Sender: TObject);
begin
 CurrentColor:=ComboBox1.ItemIndex + 1;
end;

procedure TEnvelpsForm.FormActivate(Sender: TObject);
begin
  IF Not Cleared Then
  Begin
    ComboBox1.ItemIndex := 0;
    Button1Click(Self);
    Cleared := True;
  End;
end;

end.
