unit MessageDialogDemo1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, StdCtrls, Spin, EuMessageDialog, CheckLst, TB97,
  Menus, TB97Ctls, ToolWin, MenuBar, TB97Tlbr;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet2: TTabSheet;
    TabSheet1: TTabSheet;
    EuMessageDialog1: TEuMessageDialog;
    Bevel3: TBevel;
    Label8: TLabel;
    ComboBox1: TComboBox;
    Label9: TLabel;
    ComboBox2: TComboBox;
    Label10: TLabel;
    ComboBox3: TComboBox;
    Bevel4: TBevel;
    CheckListBox1: TCheckListBox;
    Label11: TLabel;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    Label3: TLabel;
    Edit3: TEdit;
    Label4: TLabel;
    Edit4: TEdit;
    Bevel5: TBevel;
    ComboBox4: TComboBox;
    Label12: TLabel;
    Label13: TLabel;
    Bevel1: TBevel;
    Label14: TLabel;
    Edit5: TEdit;
    Bevel6: TBevel;
    EuMessageDialog2: TEuMessageDialog;
    EuMessageDialog3: TEuMessageDialog;
    EuMessageDialog4: TEuMessageDialog;
    Label5: TLabel;
    RichEdit1: TRichEdit;
    Label15: TLabel;
    ComboBox5: TComboBox;
    CheckListBox2: TCheckListBox;
    Label16: TLabel;
    Bevel7: TBevel;
    Label19: TLabel;
    Label20: TLabel;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    MainMenu1: TMainMenu;
    MMain000001: TMenuItem;
    SMenu001001: TMenuItem;
    SMenu001002: TMenuItem;
    SMenu001003: TMenuItem;
    SMenu001004: TMenuItem;
    SMenu001005: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    MenuBar1: TMenuBar;
    MMain000002: TMenuItem;
    ListBox1: TListBox;
    Label6: TLabel;
    SMenu002001: TMenuItem;
    SMenu002002: TMenuItem;
    MMenu000003: TMenuItem;
    SMenu003101: TMenuItem;
    SMenu003102: TMenuItem;
    SMenu003103: TMenuItem;
    SMenu003104: TMenuItem;
    SMenu003001: TMenuItem;
    SMenu003002: TMenuItem;
    SMenu003003: TMenuItem;
    SMenu003004: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure ComboBoxChange(Sender: TObject);
    procedure SMenuClick(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
  private
    { Private declarations }
    procedure SetDialogEntryList;
    procedure DoExecute;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin

  ComboBox1.ItemIndex:=0;
  ComboBox2.ItemIndex:=1;
  ComboBox3.ItemIndex:=0;
  ComboBox4.ItemIndex:=0;
  ComboBox5.ItemIndex:=0;

  CheckListBox1.Checked[8]:=true;
  CheckListBox1.Checked[9]:=true;

  SpinEdit1.MaxValue:=Screen.Width;
  SpinEdit2.MaxValue:=Screen.Height;
end;

procedure TForm1.DoExecute;
var
  FCount: integer;
begin
  EuMessageDialog1.Buttons.ButtonList:=[];
  if CheckListBox1.Checked[0] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbCustom1];
  if CheckListBox1.Checked[1] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbCustom2];
  if CheckListBox1.Checked[2] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbCustom3];
  if CheckListBox1.Checked[3] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbCustom4];
  if CheckListBox1.Checked[4] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbYes];
  if CheckListBox1.Checked[5] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbYesToAll];
  if CheckListBox1.Checked[6] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbNo];
  if CheckListBox1.Checked[7] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbNoToAll];
  if CheckListBox1.Checked[8] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbOk];
  if CheckListBox1.Checked[9] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbCancel];
  if CheckListBox1.Checked[10] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbAbort];
  if CheckListBox1.Checked[11] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbRetry];
  if CheckListBox1.Checked[12] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbIgnore];
  if CheckListBox1.Checked[13] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbAll];
  if CheckListBox1.Checked[14] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbClose];
  if CheckListBox1.Checked[15] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbBack];
  if CheckListBox1.Checked[16] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbNext];
  if CheckListBox1.Checked[17] then EuMessageDialog1.Buttons.ButtonList:=EuMessageDialog1.Buttons.ButtonList+[dbHelp];
  EuMessageDialog1.Options:=[];
  if CheckListBox2.Checked[0] then EuMessageDialog1.Options:=EuMessageDialog1.Options+[doCenterText];
  if CheckListBox2.Checked[1] then EuMessageDialog1.Options:=EuMessageDialog1.Options+[doRightAlignText];
  if CheckListBox2.Checked[2] then EuMessageDialog1.Options:=EuMessageDialog1.Options+[doRTLReading];
  if CheckListBox2.Checked[3] then EuMessageDialog1.Options:=EuMessageDialog1.Options+[doPlaySystemSound];
  if CheckListBox2.Checked[4] then EuMessageDialog1.Options:=EuMessageDialog1.Options+[doCenterIcon];
  if CheckListBox2.Checked[5] then EuMessageDialog1.Options:=EuMessageDialog1.Options+[doCreateCustomButtonsLast];
  if CheckListBox2.Checked[6] then EuMessageDialog1.Options:=EuMessageDialog1.Options+[doRightAlignButtons];
  EuMessageDialog1.Buttons.CustomCaptions.CustomButton1Caption:=Edit1.Text;
  EuMessageDialog1.Buttons.CustomCaptions.CustomButton2Caption:=Edit2.Text;
  EuMessageDialog1.Buttons.CustomCaptions.CustomButton3Caption:=Edit3.Text;
  EuMessageDialog1.Buttons.CustomCaptions.CustomButton4Caption:=Edit4.Text;
  EuMessageDialog1.Caption:=Edit5.Text;
  EuMessageDialog1.Position.Left:=SpinEdit1.Value;
  EuMessageDialog1.Position.Top:=SpinEdit2.Value;
  EuMessageDialog1.Text:='';
  if RichEdit1.Lines.Count>0 then
  begin
    for FCount:=0 to RichEdit1.Lines.Count-1 do
    begin
      EuMessageDialog1.Text:=EuMessageDialog1.Text+RichEdit1.Lines[FCount];
    end;
  end;
  EuMessageDialog1.Execute;
end;

procedure TForm1.ComboBoxChange(Sender: TObject);
var
  FName: string;
begin
  FName:=TComboBox(Sender).Name;
  if FName='ComboBox1' then EuMessageDialog1.Bevel.Range:=TEuMessageDialogBevelRange(TComboBox(Sender).ItemIndex);
  if FName='ComboBox2' then EuMessageDialog1.Bevel.Shape:=TBevelShape(TComboBox(Sender).ItemIndex);
  if FName='ComboBox3' then EuMessageDialog1.Bevel.Style:=TBevelStyle(TComboBox(Sender).ItemIndex);
  if FName='ComboBox4' then EuMessageDialog1.Buttons.DefaultButton:=TEuMessageDialogDefaultButton(TComboBox(Sender).ItemIndex);
  if FName='ComboBox5' then EuMessageDialog1.Icon:=TEuMessageDialogIconType(TComboBox(Sender).ItemIndex);
end;

procedure TForm1.SMenuClick(Sender: TObject);
var
  FName: string;
  FIndex: integer;
begin
  FName:=(Sender as TMenuItem).Name;
  FIndex:=StrToInt(Copy(FName,Length(FName)-5,6));
  case FIndex of
    001001:  EuMessageDialog1.Clear;
    001002:  if OpenDialog1.Execute then EuMessageDialog1.LoadFromFile(OpenDialog1.Filename);
    001003:  if SaveDialog1.Execute then EuMessageDialog1.SaveToFile(SaveDialog1.Filename);
    001005:  Application.Terminate;
    002001:  PageControl1.ActivePage:=TabSheet1;
    002002:  PageControl1.ActivePage:=TabSheet2;
    003001:  DoExecute;
    003002:  EuMessageDialog1.ExecuteDialogItem(ListBox1.ItemIndex);
    003101:  EuMessageDialog1.Add;
    003102:  EuMessageDialog1.Insert(ListBox1.ItemIndex);
    003103:  EuMessageDialog1.Delete(ListBox1.ItemIndex);
    003104:  EuMessageDialog1.Clear;
  end;
  if (FIndex<002000) or (FIndex>003100) then SetDialogEntryList;
end;

procedure TForm1.SetDialogEntryList;
var
  FCount: integer;
begin
  Listbox1.Items.Clear;
  if EuMessageDialog1.Count>0 then
  begin
    for FCount:=0 to EuMessageDialog1.Count-1 do
    begin
      Listbox1.Items.Add('MessageDialog #'+InttoStr(FCount));
    end;
  end;
end;

procedure TForm1.ListBox1DblClick(Sender: TObject);
begin
  EuMessageDialog1.ExecuteDialogItem(Listbox1.ItemIndex);
end;

end.
