{-
  TEPanel & TEBackImage
  * TEPanel Properties
      BackImage :
        TEBackImage, image to be tiled.
      AbsoluteShow :
        Tile image with respect to top left of panel
      TileAlignment:
        Select image tiling origin
  * TEPanel Events
      OnMouseEnter : response to CM_MOUSEENTER
      OnMouseLeave : response to CM_MOUSELEAVE
  Author: Ekrem Karacan
  Send comments & suggestions to  savalak@hotmail.com
-}
unit EPANEL;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, JPEG;

type
  TEPanel = class;
  TTileAlignMent = (taTopLeft, taTopRight, taBottomLeft, taBottomRight);
  TEBackImage = class (TIMAGE)
     EPanels : TList;
     procedure MyOnchange(Sender : TObject);
  public
     constructor Create(AOwner : TComponent); override;
     destructor Destroy; override;
     procedure UnRegisterEPanel(E : TEPanel);
     procedure RegisterEPanel(E : TEPanel);
  end;
  TEPANEL = class(TPANEL)
  private
    { Private declarations }
    pTAl : TTileAlignment;
    pBackImage : TEBackImage;
    pAbsolute : Boolean;
    ponmouseenter, ponmouseleave, ncMV : TNotifyEvent;
  protected
    { Protected declarations }
  public
    { Public declarations }
    procedure Paint; override;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;

    procedure NCMOUSEMOVE(VAR T : TMESSAGE); message WM_CAPTURECHANGED;
    constructor Create(O : TComponent); override;
    destructor Destroy; override;
    procedure SetImage(Image : TEBackImage);
    function GetImage : TEBackImage;

    procedure SetTileAlignment(TAL : TTileAlignment);
    function GetTileAlignment : TTileAlignment;
  published
    { Published declarations }
    property TileAlignment : TTileAlignment read GetTileAlignMent write SetTileAlignment;
    property BackImage : TEBackImage read GetImage write SetImage;
    property onNCMouseMove : TnotifyEvent read NCMV write NCMV;
    property onMouseenter : TnotifyEvent read ponMouseenter write ponMouseenter;
    property onMouseleave : TnotifyEvent read ponMouseleave write ponMouseleave;
    property AbsoluteShow : Boolean read pAbsolute write pAbsolute;
  end;

procedure Register;

procedure TileImageAl(TA : TTileAlignment; DC : TCanvas; XP, YP, DW, DH : Integer; I : TIMAGE; BR : TPoint);
implementation

constructor TEPanel.Create(O : TComponent);
begin
   inherited Create(O);
   pBackImage := Nil;
   pTal := taTopLeft;
   pAbsolute := False;
end;
destructor  TEPanel.Destroy;
begin
   if Assigned(pBackImage) then
      pBackImage.UnregisterEPanel(Self);
   inherited Destroy;
end;
procedure TEPanel.Paint;
var       DC : HDC;
          P, PO, P1 : TPOINT;
          R : TRect;
begin
   P := Point(0, 0);
   P1 := Point(ClientWidth, ClientHeight);
   if owner is TFORM then
      begin
         P := CLIENTTOSCREEN(P);
         P1 := TCONTROL(OWNER).CLIENTTOSCREEN(POINT(TCONTROL(OWNER).ClientWidth, TCONTROL(OWNER).ClientHeight));
         Po := TCONTROL(OWNER).CLIENTTOSCREEN(POINT(0, 0));
         P1.X := P1.X-P.X;
         P1.Y := P1.Y-P.Y;
         P.X := P.X-Po.X;
         P.Y := P.Y-Po.Y;
      end;
   if (not Assigned(pBackImage))
   or (pBackImage.Picture.Width=0)
   or (pBackImage.Picture.Height=0) then
      inherited
   else
      begin
         if pAbsolute then
            P := Point(0, 0);
         TileImageAl(pTal, Canvas, P.X, P.Y, Width, Height, pBackImage, P1);
         if Caption <> '' then
            begin
               R := Self.BoundsRect;
               Canvas.Brush.Style := bsClear;
               Canvas.Font.Assign(Font);
               Canvas.TextOut((Width-Canvas.TextWidth(Caption)) div 2,
                              (Height-Canvas.TextHeight(Caption)) div 2,
                              Caption);
            end;
      end;
end;
procedure Register;
begin
  RegisterComponents('Ekrem', [TEPANEL, TEBackImage]);
end;
procedure TEPANEL.NCMOUSEMOVE(VAR T : TMESSAGE);
begin
   if assigned(NCMV) then
      NCMV(SELF);
end;
procedure TEPANEL.CMMouseEnter(var Message: TMessage);
begin
   if assigned(onmouseenter) then
      onmouseenter(SELF);

end;
procedure TEPANEL.CMMouseLeave(var Message: TMessage);
begin
   if assigned(onmouseleave) then
      onmouseleave(SELF);
end;
procedure TEPanel.SetImage(Image : TEBackImage);
begin
   if pBackImage <> Nil then
      pBackImage.UnRegisterEPanel(Self);
   pBackImage := Image;
   if pBackImage <> Nil then
      pBackImage.RegisterEPanel(Self);
   invalidate;
end;
function TEPanel.GetImage : TEBackImage;
begin
   Result := pBackImage;
end;
constructor TEBackImage.Create(AOwner : TComponent);
begin
   inherited;
   EPanels := TList.Create;
   Picture.OnChange := MyOnChange;
end;
destructor TEBackImage.Destroy;
var     I : Integer;
begin
   for I := EPanels.Count-1 downto 0 do
      if Assigned(EPanels[I]) then
         TEPanel(EPanels[I]).BackImage := Nil;
   EPanels.Free;
   EPanels := Nil;
   inherited;
end;
procedure TEBackImage.RegisterEPanel(E : TEPanel);
var     I : Integer;
begin
   if EPanels = Nil then
      Exit;
   I := EPanels.IndexOf(E);
   if I < 0 then
      EPanels.Add(E);
end;
procedure TEBackImage.MyOnChange(Sender : TObject);
var     I : Integer;
begin
   if EPanels = Nil then
      Exit;
   for I := 0 to EPanels.Count-1 do
      if Assigned(EPanels[I]) then
         TEPanel(EPanels[I]).Invalidate;
   invalidate;
end;
procedure TEBackImage.UnRegisterEPanel(E : TEPanel);
var     I : Integer;
begin
   if EPanels = Nil then
      Exit;
   I := EPanels.IndexOf(E);
   if I > 0 then
      EPanels.Delete(I);
end;
procedure TEPanel.SetTileAlignment(TAL : TTileAlignment);
begin
   if pTal = TAL then
      Exit;
   pTal := TAL;
   invalidate;
end;
function TEPanel.GetTileAlignment : TTileAlignment;
begin
   Result := pTal;
end;
procedure TileImageAl(TA : TTileAlignment; DC : TCanvas; XP, YP, DW, DH : Integer; I : TIMAGE; BR : TPoint);
var       X, Y, W, H : Integer;
          R : LONGBOOL;
begin
   W := I.Picture.Width;
   H := I.Picture.Height;
   if (W = 0) or (H = 0) then
      Exit;
   YP := - (YP mod H);
   case TA of
      TABOTTOMLEFT,
      TABOTTOMRIGHT:
         begin
            if (BR.Y-YP) mod H <> 0 then
               YP := BR.Y-(((BR.Y-YP) div H)+1)*H;
         end;
   end;
   XP := - (XP mod W);
   case TA of
      TATOPRIGHT,
      TABOTTOMRIGHT:
         begin
            if (BR.X-XP) mod W <> 0 then
               XP := BR.X-(((BR.X-XP) div W)+1)*W;
         end;
   end;
   Y := YP;
   if not I.Picture.Graphic.Empty then
    while Y < DH do
      begin
         X := XP;
         while X < DW do
            begin
               DC.Draw(X, Y, I.Picture.Graphic);
               Inc(X, W);
            end;
         Inc(Y, H);
      end
   else if not I.Picture.Bitmap.Empty then
    while Y < DH do
      begin
         X := XP;
         while X < DW do
            begin
               R:=BitBlt(DC.Handle,
                     X, Y, W, H,
                     I.Picture.Bitmap.Canvas.Handle,
                     0, 0,
                     SRCCOPY);
               Inc(X, W);
            end;
         Inc(Y, H);
      end;
end;
end.
