unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Mask, EkRtf;

type
  TForm1 = class(TForm)
    StaticText1: TStaticText;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    EdLnkAddress: TEdit;
    StaticText2: TStaticText;
    StaticText3: TStaticText;
    EdLnkName: TEdit;
    StaticText4: TStaticText;
    StaticText5: TStaticText;
    StaticText6: TStaticText;
    StaticText7: TStaticText;
    StaticText8: TStaticText;
    StaticText9: TStaticText;
    EdDRS: TMaskEdit;
    EdDRT: TMaskEdit;
    EdFloat: TEdit;
    EdInteger: TEdit;
    Btn1: TButton;
    Btn2: TButton;
    Btn3: TButton;
    EkRTF1: TEkRTF;
    StaticText10: TStaticText;
    StaticText11: TStaticText;
    DateTimePicker1: TDateTimePicker;
    TabSheet4: TTabSheet;
    GetBtn: TButton;
    ViewBtn: TButton;
    CloseBtn: TButton;
    Label1: TLabel;
    procedure Btn1Click(Sender: TObject);
    procedure Btn2Click(Sender: TObject);
    procedure Btn3Click(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure GetBtnClick(Sender: TObject);
    procedure ViewBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses ShellApi;

{$R *.DFM}

function RunFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
var
  zFileName, zParams, zDir: array[0..250] of Char;
begin
 Result := ShellExecute(Application.MainForm.Handle, nil,
   StrPCopy(zFileName, FileName), StrPCopy(zParams, Params),
   StrPCopy(zDir, DefaultDir), ShowCmd);
end;


function getnumber:string;
var Hour,Min,Sec,MSec:Word;
  SHour,SMin,SSec,SMSec:string;
begin
DecodeTime(Now(), Hour, Min, Sec, MSec);
SHour:=inttostr(Hour);
SMin:=inttostr(Min); sSec:=inttostr(Sec); sMsec:=inttostr(MSec);
if Hour<10 then SHour:='0'+SHour;
if Min<10 then SMin:='0'+SMin;
if Sec<10 then Ssec:='0'+Ssec;
result:=SHour+smin+ssec;
end;

procedure TForm1.Btn1Click(Sender: TObject);
begin
PageControl1.ActivePage:=TabSheet2;
end;

procedure TForm1.Btn2Click(Sender: TObject);
begin
PageControl1.ActivePage:=TabSheet3;
end;

procedure TForm1.Btn3Click(Sender: TObject);
begin
PageControl1.ActivePage:=TabSheet4;
end;

procedure TForm1.CloseBtnClick(Sender: TObject);
begin
Close;
end;

procedure TForm1.GetBtnClick(Sender: TObject);
var pt:string;
begin
   pt:=ExtractFilePath(Paramstr(0));
   With EkRtf1 do
   begin
       ClearVars;
       DecimalRSeparator:=EdDRS.text[1];
       DecimalRTerminator:=edDRT.text[1];
       CreateVar('linkvar',trim(EdLnkAddress.text)+'|'+trim(EdLnkName.text));
       CreateVar('number1',EdFloat.text);
       CreateVar('number2',EdInteger.text);
       //date format
       CreateVar('fullformat','d mmmm yyyy');
       CreateVar('fvar1','dd');
       CreateVar('fvar2','mm');
       CreateVar('fvar3','yyyy');
       CreateVar('date1',DateTimePicker1.Date,true);
   end;

  if FileExists(pt+'\formats.rtf') then
    begin
    EkRtf1.OutFile:=pt+'\fmt'+getnumber+'.rtf';
    EkRtf1.ExecuteOpen([],SW_SHOW);
    end else showmessage('Input file formats.rtf not found!. Place your compiled exe file into project source directory.');

end;

procedure TForm1.ViewBtnClick(Sender: TObject);
begin
if FileExists(ExtractFilePath(Paramstr(0))+'\formats.doc') then
   begin
   RunFile(ExtractFilePath(Paramstr(0))+'\formats.doc','','',SW_SHOW);
   end else showmessage('File formats.doc not found!. Place your compiled exe file into project source directory.');
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
EdDRS.text:=EKRTF1.DecimalRSeparator;
EdDRT.text:=EKRTF1.DecimalRTerminator;
EdFloat.text:=floattostr(100000.53);
EdInteger.text:='100000';
end;

end.
