unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, EkRtf, TeEngine, Series, ExtCtrls, TeeProcs, Chart;

type
  TForm1 = class(TForm)
    Chart1: TChart;
    Series1: TBarSeries;
    Series2: TBarSeries;
    GetBtn: TButton;
    ViewSrBtn: TButton;
    CloseBtn: TButton;
    StaticText1: TStaticText;
    EkRTF1: TEkRTF;
    procedure CloseBtnClick(Sender: TObject);
    procedure GetBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure EkRTF1ImageFormat(FormatIndex: Integer;
      var ImageFormat: TEkImageFormat);
    procedure ViewSrBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses ShellApi;
{$R *.DFM}

function RunFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
var
  zFileName, zParams, zDir: array[0..250] of Char;
begin
 Result := ShellExecute(Application.MainForm.Handle, nil,
   StrPCopy(zFileName, FileName), StrPCopy(zParams, Params),
   StrPCopy(zDir, DefaultDir), ShowCmd);
end;


function getnumber:string;
var Hour,Min,Sec,MSec:Word;
  SHour,SMin,SSec,SMSec:string;
begin
DecodeTime(Now(), Hour, Min, Sec, MSec);
SHour:=inttostr(Hour);
SMin:=inttostr(Min); sSec:=inttostr(Sec); sMsec:=inttostr(MSec);
if Hour<10 then SHour:='0'+SHour;
if Min<10 then SMin:='0'+SMin;
if Sec<10 then Ssec:='0'+Ssec;
result:=SHour+smin+ssec;
end;

procedure TForm1.CloseBtnClick(Sender: TObject);
begin
Close;
end;

procedure TForm1.GetBtnClick(Sender: TObject);
var pt:string;
begin
   pt:=ExtractFilePath(Paramstr(0));
   Chart1.SaveToMetafileEnh('chart1.emf');
   With EkRtf1.VarList do
   begin
       Clear;
       Add('MyChart='+pt+'\chart1.emf');
   end;

  if FileExists(pt+'\chart.rtf') then
    begin
    EkRtf1.OutFile:=pt+'\ch'+getnumber+'.rtf';
    EkRtf1.ExecuteOpen([],SW_SHOW);
    end else showmessage('Input file chart.rtf not found!. Place your compiled exe file into project source directory.');
   DeleteFile(pt+'\chart1.emf');

end;

procedure TForm1.FormCreate(Sender: TObject);
var f:integer;
    n1,n2:double;
begin
   Randomize;
   for f:=1 to 5 do
     begin
     n1:=random(100);
     n2:=random(80);
     Chart1.SeriesList[0].Add(n1,FloatToStr(n1),clBlue);
     Chart1.SeriesList[1].Add(n2,FloatToStr(n2),$0080FF80);
     end;
end;

procedure TForm1.EkRTF1ImageFormat(FormatIndex: Integer;
  var ImageFormat: TEkImageFormat);
begin
ImageFormat.SizeXmm:=120; //120 millimeters
//If you use Word 97 you may get rid of border using this format
//ImageFormat.SetBorderType(brNone,0,7);  //empty (white color=7) border
end;

procedure TForm1.ViewSrBtnClick(Sender: TObject);
begin
if FileExists(ExtractFilePath(Paramstr(0))+'\chart.doc') then
   begin
   RunFile(ExtractFilePath(Paramstr(0))+'\chart.doc','','',SW_SHOW);
   end else showmessage('File chart.doc not found!. Place your compiled exe file into project source directory.');
end;

end.
