unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, EkRtf, Db, Grids, DBGrids;

type
  TMainForm = class(TForm)
    CustInvRtf: TEkRtf;
    InvRtf: TEkRtf;
    OrderRtf: TEkRtf;
    OrderBtn: TButton;
    CustBtn: TButton;
    InvBtn: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Label5: TLabel;
    VenBtn: TButton;
    Button4: TButton;
    VenRtf: TEkRtf;
    procedure OrderBtnClick(Sender: TObject);
    procedure CustBtnClick(Sender: TObject);
    procedure InvBtnClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure VenBtnClick(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses Unit2, DlgInfU, ShellAPI;

{$R *.DFM}

function RunFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
var
  zFileName, zParams, zDir: array[0..79] of Char;
begin
 Result := ShellExecute(Application.MainForm.Handle, nil,
   StrPCopy(zFileName, FileName), StrPCopy(zParams, Params),
   StrPCopy(zDir, DefaultDir), ShowCmd);
end;



function getnumber:string;
var Hour,Min,Sec,MSec:Word;
  SHour,SMin,SSec,SMSec:string;
begin
DecodeTime(Now(), Hour, Min, Sec, MSec);
SHour:=inttostr(Hour);
SMin:=inttostr(Min); sSec:=inttostr(Sec); sMsec:=inttostr(MSec);
if Hour<10 then SHour:='0'+SHour;
if Min<10 then SMin:='0'+SMin;
if Sec<10 then Ssec:='0'+Ssec;
result:=SHour+smin+ssec;
end;

procedure TMainForm.CustBtnClick(Sender: TObject);
begin
  with DM do
  begin
    CustInvRtf.OutFile:=ExtractFilePath(Paramstr(0))+'\cu'+getnumber+'.rtf';
    CustByLastInvQuery.Open;
    CustInvRtf.ExecuteOpen([CustByLastInvQuery],SW_SHOW);
    CustByLastInvQuery.Close;
  end;
end;

procedure TMainForm.OrderBtnClick(Sender: TObject);
begin
    OrderRtf.OutFile:=ExtractFilePath(Paramstr(0))+'\or'+getnumber+'.rtf';
    with DM.OrdersByDateQuery do
    begin
      Close;
      Open;
         OrderRTF.ExecuteOpen([DM.OrdersByDateQuery],SW_SHOW);
      Close;
     end;
end;

function CalcExtSum:Double;
begin
 Result:=0; Dm.Items.First;
 While not Dm.Items.Eof do begin Result:=Result+Dm.Items.FieldByName('ExtPrice').AsFloat; Dm.Items.Next; end;
end;

procedure TMainForm.InvBtnClick(Sender: TObject);
var Esum:Double;
begin
if DlgInv.ShowModal=mrOk then
     begin
     InvRtf.OutFile:=ExtractFilePath(Paramstr(0))+'\in'+getnumber+'.rtf';
     //Calculate variable Esum
     Esum:=CalcExtSum();
     //Add variables to varlist
     InvRtf.VarList.Clear;
     InvRtf.VarList.Add('Esum='+FloatToStr(Esum));
     InvRtf.VarList.Add('Freight='+
            Dm.Orders.FieldByName('Freight').AsString);
     InvRtf.VarList.Add('Total='
       +FloatToStr(Esum+Dm.Orders.FieldByName('Freight').AsFloat));
     //Generate report
     InvRtf.ExecuteOpen([DM.Cust,DM.Orders,DM.Items], SW_SHOW);
     end;
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
RunFile('OrderRpt.doc','','',SW_SHOW);
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
RunFile('CustList.doc','','',SW_SHOW);
end;

procedure TMainForm.Button3Click(Sender: TObject);
begin
RunFile('InvRpt.doc','','',SW_SHOW);
end;

procedure TMainForm.VenBtnClick(Sender: TObject);
begin
    VenRtf.FalseValue:=''; //Nothing if false;
    VenRtf.TrueValue:=#252; //Symbol will be in column "preferred" if true
    VenRtf.OutFile:=ExtractFilePath(Paramstr(0))+'\vn'+getnumber+'.rtf';
    VenRTF.ExecuteOpen([DM.Vendor],SW_SHOW);
end;

procedure TMainForm.Button4Click(Sender: TObject);
begin
RunFile('Vendor.doc','','',SW_SHOW);
end;

end.
