(****************************************** *********************************************
 *  EasyChart, jednoduche sloupcove grafy * *  EasyChart, simple easy-to-use bar charts *
 *         komponenta pro Delphi 4 (32b)  * *             component for Delphi 4 (32b)  *
 *                 (c) 1999 BEALsoft      * *                    (c) 1999 BEALsoft      *
 *                       v1.25            * *                          v1.25            *
 *________________________________________* *___________________________________________*
 *    !! TATO KOMPONENTA JE ZDARMA !!     * *    !! THIS A FREEWARE COMPONENT !!        *
 ****************************************** *********************************************)
// Autor // Author :
// aberka@atlas.cz, ICQ UIN 2365308, http://bealsoft.cjb.net/ (or http://come.to/aberka)

unit EasyChart;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  PSData = ^TSData;
  TSData = record
            Up, Down : String;
            UpFontName, DownFontName : String;
            UpFSize, DownFSize       : Integer;
            UpFColor, DownFColor     : TColor;
            UpFStyle, DownFStyle     : TFontStyles;
            Value                    : Real;
            BorderColor, FillColor   : TColor;
            BorderWidth              : Integer;
            FillStyle                : TBrushStyle;
          end;

  TEasyChart = class(TScrollBox)
  private
    { Private declarations }
    Series, Drawn                                           : TList;
    FMaxValue, FBarWidth, FSpace, FTopSpace, FBottomSpace   : Integer;
    LastHeight                                              : Integer;
    Drawing                                                 : Boolean;

  protected
    { Protected declarations }

  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure ClearArea;
    procedure ClearBars;
    procedure AddBar(TopString, TopFontName : String; TopFontSize   : Integer;
                     TopFontColor           : TColor; TopFontStyles : TFontStyles;
                     BottomString, BottomFontName : String; BottomFontSize   : Integer;
                     BottomFontColor              : TColor; BottomFontStyles : TFontStyles;
                     Value : Real;
                     BorderColor, FillColor : TColor;
                     BorderWidth : Integer;
                     FillStyle : TBrushStyle);
    procedure Draw;
    procedure Resize; override;

  published
    { Published declarations }
    property MaxValue : Integer
      read FMaxValue write FMaxValue;
    property BarWidth : Integer
      read FBarWidth write FBarWidth;
    property Space : Integer
      read FSpace write FSpace;
    property TopSpace : Integer
      read FTopSpace write FTopSpace;
    property BottomSpace : Integer
      read FBottomSpace write FBottomSpace;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Additional', [TEasyChart]);
end;

constructor TEasyChart.Create(AOwner : TComponent);
begin
  inherited;
  HorzScrollBar.Smooth:=True;
  HorzScrollBar.Style:=ssHotTrack;
  HorzScrollBar.Tracking:=True;
  FMaxValue:=0;
  Series:=TList.Create;
  Drawn:=TList.Create;
  DoubleBuffered:=True;
  LastHeight:=Height;
end;

destructor TEasyChart.Destroy;
var X : Integer;
begin
  for X:=0 to Series.Count-1 do
    Dispose(Series.Items[X]);
  Drawn.Free;
  Series.Free;
  inherited;
end;

procedure TEasyChart.ClearBars;
begin
  ClearArea;
  while Series.Count<>0 do
  begin
    Dispose(Series.Items[0]);
    Series.Delete(0);
  end;
end;
procedure TEasyChart.AddBar(TopString, TopFontName : String; TopFontSize   : Integer;
                            TopFontColor           : TColor; TopFontStyles : TFontStyles;
                            BottomString, BottomFontName : String; BottomFontSize   : Integer;
                            BottomFontColor              : TColor; BottomFontStyles : TFontStyles;
                            Value : Real;
                            BorderColor, FillColor : TColor;
                            BorderWidth : Integer;
                            FillStyle : TBrushStyle);
var P : PSData;
begin
  New(P);
  P^.Up:=TopString;
  P^.Down:=BottomString;
  if Value<0 then Value:=Value*(-1);
  P^.Value:=Value;
  P^.BorderColor:=BorderColor;
  P^.FillColor:=FillColor;
  P^.BorderWidth:=BorderWidth;
  P^.FillStyle:=FillStyle;
  P^.UpFontName:=TopFontName;
  P^.UpFSize:=TopFontSize;
  P^.UpFColor:=TopFontColor;
  P^.UpFStyle:=TopFontStyles;
  P^.DownFontName:=BottomFontName;
  P^.DownFSize:=BottomFontSize;
  P^.DownFColor:=BottomFontColor;
  P^.DownFStyle:=BottomFontStyles;
  Series.Add(P);
end;

procedure TEasyChart.Draw;
var X,XX,YY               : Integer;
    Max                   : Real;
    P                     : PSData;
    TotalHeight           : Integer;
    Shp                   : TShape;
    Fin                   : TLabel;
    L                     : TLabel;

function GetHeight(Value : Real) : Integer;
var Ratio : Real;
begin
  Ratio:=Value/Max;
  Result:=Trunc(Ratio*TotalHeight);
end;
begin
  Drawing:=True;
  LastHeight:=Height;
  Max:=0;
  if FMaxValue<>0 then Max:=FMaxValue else
  for X:=0 to Series.Count-1 do
    if PSData(Series.Items[X]).Value>Max then Max:=PSData(Series.Items[X]).Value;
  TotalHeight:=Height-(FTopSpace+FBottomSpace);

  for X:=0 to Series.Count-1 do
  begin
    P:=PSData(Series.Items[X]);
    XX:=X*(FBarWidth+FSpace)+(FSpace);
    YY:=(Height-FBottomSpace)-GetHeight(P^.Value);
    Shp:=TShape.Create(Self);
    Shp.Left:=XX;                  Shp.Top:=YY;
    Shp.Width:=FBarWidth;          Shp.Height:=GetHeight(P^.Value);
    Shp.Pen.Color:=P^.BorderColor; Shp.Pen.Width:=P^.BorderWidth;
    if Shp.Pen.Width=0 then Shp.Pen.Color:=Color;
    Shp.Brush.Color:=P^.FillColor; Shp.Brush.Style:=P^.FillStyle;
    if (Shp.Height<3) and (P^.Value<>0) then begin Shp.Height:=3; Shp.Top:=Shp.Top-1; end;
    Shp.Parent:=Self;
    Drawn.Add(Shp);

    L:=TLabel.Create(Self);
    L.Left:=Shp.Left-(FSpace div 2)+10; L.Width:=FBarWidth+FSpace-20;
    L.Top:=0;                           L.Height:=Shp.Top-10;
    L.AutoSize:=False;                  L.WordWrap:=True;
    L.Alignment:=taCenter;              L.Layout:=tlBottom;
    L.Font.Name:=P^.UpFontName;         L.Font.Size:=P^.UpFSize;
    L.Font.Color:=P^.UpFColor;          L.Font.Style:=P^.UpFStyle;
    L.Caption:=P^.Up;                   L.Parent:=Self;
    Drawn.Add(L);

    L:=TLabel.Create(Self);
    L.Left:=Shp.Left-(FSpace div 2)+10; L.Width:=FBarWidth+FSpace-20;
    L.Top:=Shp.Top+Shp.Height+5;        L.Height:=Height-L.Top-5;
    L.AutoSize:=False;                  L.WordWrap:=True;
    L.Alignment:=taCenter;              L.Layout:=tlTop;
    L.Font.Name:=P^.DownFontName;       L.Font.Size:=P^.DownFSize;
    L.Font.Color:=P^.DownFColor;        L.Font.Style:=P^.DownFStyle;
    L.Caption:=P^.Down;                 L.Parent:=Self;
    Drawn.Add(L);

    Application.ProcessMessages;

  end;
  Fin:=TLabel.Create(Self); Fin.AutoSize:=False;
  Fin.Caption:='';          Fin.Left:=Series.Count*(FBarWidth+FSpace);
  Fin.Top:=0;               Fin.Width:=FSpace; Fin.Transparent:=True;
  Fin.Parent:=Self;         Drawn.Add(Fin);
  Drawing:=False;
  Resize;
end;

procedure TEasyChart.ClearArea;
begin
  Drawing:=True;
  while Drawn.Count<>0 do
  begin
    if (TObject(Drawn.Items[0]) is TComponent) then (TObject(Drawn.Items[0]) as TComponent).Free;
    Drawn.Delete(0);
  end;
  Drawing:=False;
end;

procedure TEasyChart.Resize;
type TKind = (kLabel,kShape);
var X,XX,YY               : Integer;
    Max                   : Real;
    P                     : PSData;
    TotalHeight           : Integer;
    Shp                   : TShape;
    L                     : TLabel;
    Delta                 : Integer;
function GetHeight(Value : Real) : Integer;
var Ratio : Real;
begin
  Ratio:=Value/Max;
  Result:=Trunc(Ratio*TotalHeight);
end;
function GetComponent(Index : Integer; Kind : TKind) : TComponent;
var X : Integer;
    Y : Integer;
begin
  Y:=0; Result:=nil;
  for X:=0 to Drawn.Count-1 do
  begin
    if (Kind=kLabel) and (TComponent(Drawn.Items[X]) is TLabel) then Inc(Y);
    if (Kind=kShape) and (TComponent(Drawn.Items[X]) is TShape) then Inc(Y);
    if Y = Index then
    begin
      Result:=TComponent(Drawn.Items[X]);
      Exit;
    end;
  end;
end;
begin
  if Drawing then Exit;
  inherited;
//  if HorzScrollBar.Range>Width then ShowMessage('Range>Width') else ShowMessage('Range<=Width');
  Drawing:=True;
  Delta:=Height-LastHeight;
  if Delta<>0 then
  for X:=0 to Drawn.Count-1 do
    if (TObject(Drawn.Items[X]) is TShape) then
    begin
      Shp:=(TObject(Drawn.Items[X]) as TShape);
      Shp.Height:=Shp.Height+Delta;
      if Shp.Height<0 then Shp.Visible:=False else Shp.Visible:=True;
    end;

  Max:=0;
  if FMaxValue<>0 then Max:=FMaxValue else
  for X:=0 to Series.Count-1 do
    if PSData(Series.Items[X]).Value>Max then Max:=PSData(Series.Items[X]).Value;
  TotalHeight:=Height-(FTopSpace+FBottomSpace);

  for X:=0 to Series.Count-1 do
  begin
    P:=PSData(Series.Items[X]);
    XX:=X*(FBarWidth+FSpace)+(FSpace);
    if GetHeight(P^.Value)>=0 then
      YY:=(Height-FBottomSpace)-GetHeight(P^.Value) else
      YY:=(Height-FBottomSpace);


    Shp:=(GetComponent(X+1,kShape) as TShape);
    Shp.Left:=XX;                  Shp.Top:=YY;
    {Shp.Width:=FBarWidth; }       Shp.Height:=GetHeight(P^.Value);
    if not Shp.Visible then Shp.Visible:=True;
    if (Shp.Height<3) and (P^.Value<>0) then begin Shp.Height:=3; {Shp.Top:=Shp.Top-1;} end;

    L:=(GetComponent(X*2+1,kLabel) as TLabel);
    L.Left:=Shp.Left-(FSpace div 2)+10; //L.Width:=FBarWidth+FSpace-20;
    L.Top:=0;                           L.Height:=Shp.Top-10;

    L:=(GetComponent(X*2+2,kLabel) as TLabel);
    L.Left:=Shp.Left-(FSpace div 2)+10; //L.Width:=FBarWidth+FSpace-20;
    L.Top:=Shp.Top+Shp.Height+5;        //L.Height:=Height-L.Top-20;
  end;

  LastHeight:=Height;
//  Refresh;
  Drawing:=False;
end;

end.
