
{**********************************************************************}
{                                                                      }
{    "The contents of this file are subject to the Mozilla Public      }
{    License Version 1.1 (the "License"); you may not use this         }
{    file except in compliance with the License. You may obtain        }
{    a copy of the License at                                          }
{                                                                      }
{    http://www.mozilla.org/MPL/                                       }
{                                                                      }
{    Software distributed under the License is distributed on an       }
{    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express       }
{    or implied. See the License for the specific language             }
{    governing rights and limitations under the License.               }
{                                                                      }
{    The Original Code is DelphiWebScript source code, released        }
{    February 16, 2000                                                 }
{                                                                      }
{    The Initial Developer of the Original Code is Matthias            }
{    Ackermann. Portions created by Matthias Ackermann are             }
{    Copyright (C) 2000 Matthias Ackermann, Switzerland. All           }
{    Rights Reserved. Portions created by Hannes Hernler are           }
{    Copyright (C) 2000 hannes hernler informationstechnik,            }
{    Graz - Austria. All Rights Reserved.                              }
{                                                                      }
{    Contributor(s): ______________________________________.           }
{                                                                      }
{**********************************************************************}

unit dwsDemoLib;

interface

uses
  SysUtils, Classes, dwsComp;

type
  TdwsDemoLib = class(TdwsLib)
  protected
    procedure AddFunctions; override;
  end;
{(*}
  TdmoCreateFunc = class(TFunction)function Evaluate(argpat: Integer; args: TList): Variant; override; end;
  TdmoValueFunc = class(TFunction)function Evaluate(argpat: Integer; args: TList): Variant; override; end;
  TdmoIncFunc = class(TFunction)function Evaluate(argpat: Integer; args: TList): Variant; override; end;
  TdmoIncByValueFunc = class(TFunction)function Evaluate(argpat: Integer; args: TList): Variant; override; end;
{*)}
procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('DWS', [TdwsDemoLib]);
end;

type
  TdmoObj = class(TdwsObject)
    value: Integer;
    constructor Create;
  end;

constructor TdmoObj.Create;
begin
  FAutoDestroy := True;
end;

function GetObj(script: TDelphiWebScript; expr: TExpr): TdmoObj;
begin
  result := TdmoObj(script.GetObj(TExpr(expr).Eval));
end;

{ TdwsStringsLib }

procedure TdwsDemoLib.AddFunctions;
var
  f: TFunction;
begin
  AddF(TdmoCreateFunc.CreateArg('dmoCreate', atInteger, []));
  f := AddF(TdmoValueFunc.CreateArg('dmoValue', atInteger, [atInteger]));
  f.AddArgs([atInteger, atInteger]);
  AddF(TdmoIncFunc.CreateArg('dmoInc', atVoid, [atInteger]));
  AddF(TdmoIncByValueFunc.CreateArg('dmoIncByValue', atVoid, [atInteger, atInteger]));
end;

{ TdmoCreateFunc }

function TdmoCreateFunc.Evaluate(argpat: Integer; args: TList): Variant;
begin
  result := FScript.NewObj(TdmoObj.Create);
end;

{ TdmoValueFunc }

function TdmoValueFunc.Evaluate(argpat: Integer; args: TList): Variant;
begin
  if argpat = 0 then
    result := GetObj(FScript, args[0]).value
  else if argpat = 1 then
  begin
    result := 0;
    GetObj(FScript, args[0]).value := TExpr(args[1]).Eval;
  end;
end;

{ TdmoIncFunc }

function TdmoIncFunc.Evaluate(argpat: Integer; args: TList): Variant;
begin
  Inc(GetObj(FScript, args[0]).value);
end;

{ TdmoIncByValueFunc }

function TdmoIncByValueFunc.Evaluate(argpat: Integer;
  args: TList): Variant;
begin
  Inc(GetObj(FScript, args[0]).value, Integer(TExpr(args[1]).Eval));
end;

{ TdmoObj }

end.
