unit ScriptDemoDebug;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, dwsComp;

type
  TfrmScriptDemoDebug = class(TForm)
    lbWatches: TListBox;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    edName: TEdit;
    Label1: TLabel;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure UpdateWatches;
  public
    { Public-Deklarationen }
  end;

var
  frmScriptDemoDebug: TfrmScriptDemoDebug;
  Watches: TStrings;

implementation

uses ScriptDemoWin;

{$R *.DFM}

procedure TfrmScriptDemoDebug.Button4Click(Sender: TObject);
begin
  if edName.Text <> '' then Watches.Add(edName.Text);
  UpdateWatches;
end;

procedure TfrmScriptDemoDebug.Button5Click(Sender: TObject);
begin
  if lbWatches.ItemIndex < 0 then exit;
  Watches.Delete(lbWatches.ItemIndex);
  UpdateWatches;
end;

procedure TfrmScriptDemoDebug.Button6Click(Sender: TObject);
begin
  Watches.Clear;
  UpdateWatches;
end;

procedure TfrmScriptDemoDebug.UpdateWatches;
var
  x: Integer;
  di: TDataItem;
  s: string;
begin
  lbWatches.Clear;
  for x := 0 to Watches.Count - 1 do
  begin
    di := frmScriptDemo.script.GetVar(Watches[x]);
    if Assigned(di) then
      s := VarToStr(di.FValue)
    else
      s := 'Unknown variable';
    lbWatches.Items.Add(
      format('%s: %s', [Watches[x], s])
      );
  end;
end;

procedure TfrmScriptDemoDebug.Button1Click(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TfrmScriptDemoDebug.Button2Click(Sender: TObject);
begin
  ModalResult := mrAll;
end;

procedure TfrmScriptDemoDebug.Button3Click(Sender: TObject);
begin
  ModalResult := mrAbort;
end;

procedure TfrmScriptDemoDebug.FormShow(Sender: TObject);
begin
  UpdateWatches;
end;

initialization
  Watches := TStringList.Create;
finalization
  Watches.Free;
end.
