{ ##
  @PROJECT_NAME             PJMessageDialogDemo
  @PROJECT_DESC             Message dialog demo program.
  @FILE                     FmPJMessageDialogDemo.pas
  @COMMENTS                 Main form and code for demo program.
  @LEGAL_NOTICE             This demo program is distributed under the Mozilla
                            Public License - see below.
  @AUTHOR                   Peter D Johnson, LLANARTH, Ceredigion, Wales, UK.
  @OWNER                    DelphiDabbler
  @EMAIL                    peter.johnson@openlink.org
  @WEBSITE                  http://www.delphidabbler.com/
  @COPYRIGHT                 Peter D Johnson, 2003-2005.
  @DEPENDENCIES             PJMessageDialog components v2.1 or later.
  @HISTORY(
    @REVISION(
      @VERSION              1.0
      @DATE                 05/10/2003
      @COMMENTS             Original version.
    )
    @REVISION(
      @VERSION              1.1
      @DATE                 24/12/2005
      @COMMENTS             Fixed problem accessing main form help in later
                            versions of Delphi by avoiding use of Delphi's built
                            in help management.
    )
  )
}


{
 * ***** BEGIN LICENSE BLOCK *****
 * 
 * Version: MPL 1.1
 * 
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * 
 * The Original Code is FmPJMessageDialogDemo.pas.
 * 
 * The Initial Developer of the Original Code is Peter Johnson
 * (http://www.delphidabbler.com/).
 * 
 * Portions created by the Initial Developer are Copyright (C) 2003-2005 Peter
 * Johnson. All Rights Reserved.
 * 
 * ***** END LICENSE BLOCK *****
}


unit FmPJMessageDialogDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, CheckLst, ExtCtrls,

  PJMessageDialog;

type
  TDemoForm = class(TForm)
    dlgOldStyle: TPJMessageDialog;
    dlgWinMsg: TPJWinMsgDlg;
    dlgVCLMsg: TPJVCLMsgDlg;
    tabCtrl: TTabControl;
    lblAlign: TLabel;
    cbAlign: TComboBox;
    lblOffsetLeft: TLabel;
    edOffsetLeft: TEdit;
    lblOffsetTop: TLabel;
    edOffsetTop: TEdit;
    btnExecute: TButton;
    lblButtonGroup: TLabel;
    cbButtonGroup: TComboBox;
    lblButtons: TLabel;
    lbButtons: TCheckListBox;
    dlgVCLDummy: TPJVCLMsgDlg;
    lblDefButton: TLabel;
    cbDefButton: TComboBox;
    lblHelpContext: TLabel;
    lblHelpFile: TLabel;
    btnHelpFile: TButton;
    dlgHelpFile: TOpenDialog;
    lblIconKind: TLabel;
    cbIconKind: TComboBox;
    lblIconResource: TLabel;
    cbIconResource: TComboBox;
    lblKind: TLabel;
    cbKind: TComboBox;
    chkMakeSound: TCheckBox;
    lblMakeSound: TLabel;
    lblOptions: TLabel;
    lbOptions: TCheckListBox;
    lblText: TLabel;
    edText: TMemo;
    lblTitle: TLabel;
    edTitle: TEdit;
    bvlVertical: TBevel;
    cbHelpFile: TComboBox;
    cbHelpContext: TComboBox;
    btnHelp: TButton;
    procedure edNumKeyPress(Sender: TObject; var Key: Char);
    procedure tabCtrlChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cbButtonGroupChange(Sender: TObject);
    procedure lbButtonsClickCheck(Sender: TObject);
    procedure btnHelpFileClick(Sender: TObject);
    procedure btnExecuteClick(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnHelpClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    fLastHelpKW: string;
    procedure UpdateControls;
  end;

var
  DemoForm: TDemoForm;

implementation

uses
  TypInfo;

{$R *.DFM}

const
  cPJWinMsgDlgId = 0;
  cPJVCLMsgDlgId = 2;
  cPJMessageDialogId = 1;

  cCmpNames: array[0..2] of string = (
    'TPJWinMsgDlg', 'TPJMessageDialog', 'TPJVCLMsgDlg'
  );

function SLObjToIdx(SL: TStrings; Obj: TObject): Integer;
  // Returns index of first item in given string list that has given object in
  // Objects[] property.
var
  Idx: Integer;
begin
  Result := -1;
  for Idx := 0 to Pred(SL.Count) do
    if Obj = SL.Objects[Idx] then
    begin
      Result := Idx;
      Break;
    end;
end;


procedure TDemoForm.edNumKeyPress(Sender: TObject; var Key: Char);
  // Prevents non-numeric entry into edit boxes used to enter numbers
begin
  if not (Key in ['0'..'9', #8]) then
    Key := #0;
end;

procedure TDemoForm.tabCtrlChange(Sender: TObject);
begin
  UpdateControls;
end;

procedure TDemoForm.UpdateControls;
var
  TabIdx: Integer;
  TI: PTypeInfo;
  TD: PTypeData;
  Idx: Integer;
begin
  TabIdx := tabCtrl.TabIndex;
  btnExecute.Tag := TabIdx;

  // Common property set up
  // ButtonGroup
  cbButtonGroup.Clear;
  TI := TypeInfo(TPJMsgDlgButtonGroup);
  TD := GetTypeData(TI);
  for Idx := TD.MinValue to TD.MaxValue do
    cbButtonGroup.Items.AddObject(GetEnumName(TI, Idx), Pointer(Idx));

  // IconResource
  cbIconResource.ItemIndex := 0;

  // Variable property set up and common property values
  case TabIdx of
    cPJVCLMsgDlgId:
    begin
      // Align property
      lblAlign.Enabled := True;
      cbAlign.Enabled := True;
      cbAlign.Clear;
      TI := TypeInfo(TPJMsgDlgAlign);
      TD := GetTypeData(TI);
      for Idx := TD.MinValue to TD.MaxValue do
        cbAlign.Items.AddObject(GetEnumName(TI, Idx), Pointer(Idx));
      cbAlign.ItemIndex := SLObjToIdx(
        cbAlign.Items, Pointer(dlgVCLMsg.Align)
      );

      // ButtonGroup property
      cbButtonGroup.ItemIndex := SLObjToIdx(
        cbButtonGroup.Items, Pointer(dlgVCLMsg.ButtonGroup)
      );

      // Buttons property
      lblButtons.Enabled := True;
      lbButtons.Enabled := True;
      lbButtons.Clear;
      TI := TypeInfo(TMsgDlgBtn);
      TD := GetTypeData(TI);
      for Idx := TD.MinValue to TD.MaxValue do
      begin
        lbButtons.Items.AddObject(GetEnumName(TI, Idx), Pointer(Idx));
        if (TMsgDlgBtn(Idx) in dlgVCLMsg.Buttons) then
          lbButtons.Checked[Idx] := True;
      end;

      // DefButton property
      lblDefButton.Enabled := True;
      cbDefButton.Enabled := True;
      cbDefButton.Clear;
      TI := TypeInfo(TMsgDlgBtn);
      TD := GetTypeData(TI);
      for Idx := TD.MinValue to TD.MaxValue do
        cbDefButton.Items.AddObject(GetEnumName(TI, Idx), Pointer(Idx));
      cbDefButton.ItemIndex :=
        SLObjToIdx(cbDefButton.Items, Pointer(dlgVCLMsg.DefButton));

      // HelpContext property
      cbHelpContext.Text := IntToStr(dlgVCLMsg.HelpContext);

      // HelpFile property
      lblHelpFile.Enabled := True;
      cbHelpFile.Enabled := True;
      btnHelpFile.Enabled := True;
      cbHelpFile.Text := dlgVCLMsg.HelpFile;

      // IconKind property
      lblIconKind.Enabled := False;
      cbIconKind.Enabled := False;
      cbIconKind.Clear;

      // IconResource property
      if dlgVCLMsg.IconResource <> '' then
        cbIconResource.ItemIndex :=
          cbIconResource.Items.IndexOf(dlgVCLMsg.IconResource);

      // Kind property
      lblKind.Enabled := True;
      cbKind.Enabled := True;
      cbKind.Clear;
      TI := TypeInfo(TPJMsgDlgKind);
      TD := GetTypeData(TI);
      for Idx := TD.MinValue to TD.MaxValue do
        cbKind.Items.AddObject(GetEnumName(TI, Idx), Pointer(Idx));
      cbKind.ItemIndex := SLObjToIdx(cbKind.Items, Pointer(dlgVCLMsg.Kind));

      // MakeSound property
      chkMakeSound.Checked := dlgVCLMsg.MakeSound;

      // OffsetLeft property
      lblOffsetLeft.Enabled := True;
      edOffsetLeft.Enabled := True;
      edOffsetLeft.Text := IntToStr(dlgVCLMsg.OffsetLeft);

      // OffsetTop property
      lblOffsetTop.Enabled := True;
      edOffsetTop.Enabled := True;
      edOffsetTop.Text := IntToStr(dlgVCLMsg.OffsetLeft);

      // Options property
      lblOptions.Enabled := True;
      lbOptions.Enabled := True;
      lbOptions.Clear;
      TI := TypeInfo(TPJMsgDlgOption);
      TD := GetTypeData(TI);
      for Idx := TD.MinValue to TD.MaxValue do
      begin
        lbOptions.Items.AddObject(GetEnumName(TI, Idx), Pointer(Idx));
        if (TPJMsgDlgOption(Idx) in dlgVCLMsg.Options) then
          lbOptions.Checked[Idx] := True;
      end;

      // Text property
      edText.Text := dlgVCLMsg.Text;

      // Title property
      edTitle.Text := dlgVCLMsg.Title;

    end;
    cPJWinMsgDlgId:
    begin
      // Align property not supported
      lblAlign.Enabled := False;
      cbAlign.Enabled := False;
      cbAlign.Clear;

      // ButtonGroup property
      cbButtonGroup.ItemIndex := SLObjToIdx(
        cbButtonGroup.Items, Pointer(dlgWinMsg.ButtonGroup)
      );

      // Buttons property
      lblButtons.Enabled := False;
      lbButtons.Enabled := False;
      lbButtons.Clear;

      // DefButton property
      lblDefButton.Enabled := False;
      cbDefButton.Enabled := False;
      cbDefButton.Clear;

      // HelpContext property
      cbHelpContext.Text := IntToStr(dlgWinMsg.HelpContext);

      // HelpFile property
      lblHelpFile.Enabled := True;
      cbHelpFile.Enabled := True;
      btnHelpFile.Enabled := True;
      cbHelpFile.Text := dlgWinMsg.HelpFile;

      // IconKind property
      lblIconKind.Enabled := False;
      cbIconKind.Enabled := False;
      cbIconKind.Clear;

      // IconResource property
      if dlgWinMsg.IconResource <> '' then
        cbIconResource.ItemIndex :=
          cbIconResource.Items.IndexOf(dlgWinMsg.IconResource);

      // Kind property
      lblKind.Enabled := True;
      cbKind.Enabled := True;
      cbKind.Clear;
      TI := TypeInfo(TPJMsgDlgKind);
      TD := GetTypeData(TI);
      for Idx := TD.MinValue to TD.MaxValue do
        cbKind.Items.AddObject(GetEnumName(TI, Idx), Pointer(Idx));
      cbKind.ItemIndex := SLObjToIdx(cbKind.Items, Pointer(dlgWinMsg.Kind));

      // MakeSound property
      chkMakeSound.Checked := dlgWinMsg.MakeSound;

      // OffsetLeft property not supported
      lblOffsetLeft.Enabled := False;
      edOffsetLeft.Enabled := False;
      edOffsetLeft.Text := '';

      // OffsetTop property not supported
      lblOffsetTop.Enabled := False;
      edOffsetTop.Enabled := False;
      edOffsetTop.Text := '';

      // Options property
      lblOptions.Enabled := False;
      lbOptions.Enabled := False;
      lbOptions.Clear;

      // Text property
      edText.Text := dlgWinMsg.Text;

      // Title property
      edTitle.Text := dlgWinMsg.Title;

    end;
    cPJMessageDialogId:
    begin
      // Align property not supported
      lblAlign.Enabled := False;
      cbAlign.Enabled := False;
      cbAlign.Clear;

      // ButtonGroup property
      cbButtonGroup.ItemIndex := SLObjToIdx(
        cbButtonGroup.Items, Pointer(dlgOldStyle.ButtonGroup)
      );

      // Buttons property
      lblButtons.Enabled := False;
      lbButtons.Enabled := False;
      lbButtons.Clear;

      // DefButton property
      lblDefButton.Enabled := False;
      cbDefButton.Enabled := False;
      cbDefButton.Clear;

      // HelpContext property
      cbHelpContext.Text := IntToStr(dlgOldStyle.HelpContext);

      // HelpFile property
      lblHelpFile.Enabled := False;
      cbHelpFile.Enabled := False;
      btnHelpFile.Enabled := False;
      cbHelpFile.Text := '';

      // IconKind property
      lblIconKind.Enabled := True;
      cbIconKind.Enabled := True;
      TI := TypeInfo(TPJMsgDlgIconKind);
      TD := GetTypeData(TI);
      for Idx := TD.MinValue to TD.MaxValue do
        cbIconKind.Items.AddObject(GetEnumName(TI, Idx), Pointer(Idx));
      cbIconKind.ItemIndex := SLObjToIdx(
        cbIconKind.Items, Pointer(dlgOldStyle.IconKind)
      );

      // IconResource property
      if dlgOldStyle.IconResource <> '' then
        cbIconResource.ItemIndex :=
          cbIconResource.Items.IndexOf(dlgOldStyle.IconResource);

      // Kind property
      lblKind.Enabled := False;
      cbKind.Enabled := False;
      cbKind.Clear;

      // MakeSound property
      chkMakeSound.Checked := dlgOldStyle.MakeSound;

      // OffsetLeft property not supported
      lblOffsetLeft.Enabled := False;
      edOffsetLeft.Enabled := False;
      edOffsetLeft.Text := '';

      // OffsetTop property not supported
      lblOffsetTop.Enabled := False;
      edOffsetTop.Enabled := False;
      edOffsetTop.Text := '';

      // Options property
      lblOptions.Enabled := False;
      lbOptions.Enabled := False;
      lbOptions.Clear;

      // Text property
      edText.Text := dlgOldStyle.Text;

      // Title property
      edTitle.Text := dlgOldStyle.Title;

    end;
  end;

end;

procedure TDemoForm.FormCreate(Sender: TObject);
begin
  Self.HelpFile := ExtractFilePath(ParamStr(0)) + 'MainForm.hlp';
  UpdateControls;
end;

procedure TDemoForm.cbButtonGroupChange(Sender: TObject);
var
  TI: PTypeInfo;
  TD: PTypeData;
  Idx: Integer;
begin
  if tabCtrl.TabIndex = cPJVCLMsgDlgId then
  begin
    dlgVCLDummy.ButtonGroup :=
      TPJMsgDlgButtonGroup(
        cbButtonGroup.Items.Objects[cbButtonGroup.ItemIndex]
      );
    TI := TypeInfo(TMsgDlgBtn);
    TD := GetTypeData(TI);
    for Idx := TD.MinValue to TD.MaxValue do
    begin
      if (TMsgDlgBtn(Idx) in dlgVCLDummy.Buttons) then
        lbButtons.Checked[Idx] := True
      else
        lbButtons.Checked[Idx] := False;
    end;
  end;
end;

procedure TDemoForm.lbButtonsClickCheck(Sender: TObject);
var
  Idx: Integer;
begin
  if tabCtrl.TabIndex = cPJVCLMsgDlgId then
  begin
    dlgVCLDummy.Buttons := [];
    for Idx := 0 to Pred(lbButtons.Items.Count) do
      if lbButtons.Checked[Idx] then
        dlgVCLDummy.Buttons := dlgVCLDummy.Buttons + [TMsgDlgBtn(Idx)];
    cbButtonGroup.ItemIndex := SLObjToIdx(
      cbButtonGroup.Items, Pointer(dlgVCLDummy.ButtonGroup)
    );
  end;
end;

procedure TDemoForm.btnHelpFileClick(Sender: TObject);
  // Display file open dialog and copy input into text field.
begin
  dlgHelpFile.FileName := cbHelpFile.Text;
  if dlgHelpFile.Execute then
    cbHelpFile.Text := dlgHelpFile.FileName;
end;

procedure TDemoForm.btnExecuteClick(Sender: TObject);
var
  Idx: Integer;
begin
  case btnExecute.Tag of
    cPJVCLMsgDlgId:
    begin
      dlgVCLMsg.Align := TPJMsgDlgAlign(
        cbAlign.Items.Objects[cbAlign.ItemIndex]
      );
      dlgVCLMsg.ButtonGroup := TPJMsgDlgButtonGroup(
        cbButtonGroup.Items.Objects[cbButtonGroup.ItemIndex]
      );
      for Idx := 0 to Pred(lbButtons.Items.Count) do
        if lbButtons.Checked[Idx] then
          dlgVCLMsg.Buttons := dlgVCLMsg.Buttons + [TMsgDlgBtn(Idx)]
        else
          dlgVCLMsg.Buttons := dlgVCLMsg.Buttons - [TMsgDlgBtn(Idx)];
      dlgVCLMsg.DefButton := TMsgDlgBtn(
        cbDefButton.Items.Objects[cbDefButton.ItemIndex]
      );
      dlgVCLMsg.HelpContext := StrToIntDef(cbHelpContext.Text, 0);
      if (cbHelpFile.Text <> '')
        and (ExtractFileName(cbHelpFile.Text) = cbHelpFile.Text) then
        dlgVCLMsg.HelpFile := ExtractFilePath(ParamStr(0)) + cbHelpFile.Text
      else
        dlgVCLMsg.HelpFile := cbHelpFile.Text;
      if cbIconResource.ItemIndex = 0 then
        dlgVCLMsg.IconResource := ''
      else
        dlgVCLMsg.IconResource := cbIconResource.Text;
      dlgVCLMsg.Kind := TPJMsgDlgKind(
        cbKind.Items.Objects[cbKind.ItemIndex]
      );
      dlgVCLMsg.MakeSound := chkMakeSound.Checked;
      dlgVCLMsg.OffsetLeft := StrToIntDef(edOffsetLeft.Text, 0);
      dlgVCLMsg.OffsetTop := StrToIntDef(edOffsetTop.Text, 0);
      for Idx := 0 to Pred(lbOptions.Items.Count) do
        if lbOptions.Checked[Idx] then
          dlgVCLMsg.Options := dlgVCLMsg.Options + [TPJMsgDlgOption(Idx)]
        else
          dlgVCLMsg.Options := dlgVCLMsg.Options - [TPJMsgDlgOption(Idx)];
      dlgVCLMsg.Text := edText.Text;
      dlgVCLMsg.Title := edTitle.Text;
      dlgVCLMsg.Execute;
    end;
    cPJWinMsgDlgId:
    begin
      dlgWinMsg.ButtonGroup := TPJMsgDlgButtonGroup(
        cbButtonGroup.Items.Objects[cbButtonGroup.ItemIndex]
      );
      dlgWinMsg.HelpContext := StrToIntDef(cbHelpContext.Text, 0);
      if (cbHelpFile.Text <> '')
        and (ExtractFileName(cbHelpFile.Text) = cbHelpFile.Text) then
        dlgWinMsg.HelpFile := ExtractFilePath(ParamStr(0)) + cbHelpFile.Text
      else
        dlgWinMsg.HelpFile := cbHelpFile.Text;
      if cbIconResource.ItemIndex = 0 then
        dlgWinMsg.IconResource := ''
      else
        dlgWinMsg.IconResource := cbIconResource.Text;
      dlgWinMsg.Kind := TPJMsgDlgKind(
        cbKind.Items.Objects[cbKind.ItemIndex]
      );
      dlgWinMsg.MakeSound := chkMakeSound.Checked;
      dlgWinMsg.Text := edText.Text;
      dlgWinMsg.Title := edTitle.Text;
      dlgWinMsg.Execute;
    end;
    cPJMessageDialogId:
    begin
      dlgOldStyle.ButtonGroup := TPJMsgDlgButtonGroup(
        cbButtonGroup.Items.Objects[cbButtonGroup.ItemIndex]
      );
      dlgOldStyle.HelpContext := StrToIntDef(cbHelpContext.Text, 0);
      dlgOldStyle.IconKind := TPJMsgDlgIconKind(
        cbIconKind.Items.Objects[cbIconKind.ItemIndex]
      );
      if cbIconResource.ItemIndex = 0 then
        dlgOldStyle.IconResource := ''
      else
        dlgOldStyle.IconResource := cbIconResource.Text;
      dlgOldStyle.MakeSound := chkMakeSound.Checked;
      dlgOldStyle.Text := edText.Text;
      dlgOldStyle.Title := edTitle.Text;
      dlgOldStyle.Execute;
    end;
  end;
end;

const
  cHelpMap: array[1..16] of record
    Ctrl, Prop: string;
  end =
  (
    (Ctrl: 'cbAlign'; Prop: 'Align'),
    (Ctrl: 'cbButtonGroup'; Prop: 'ButtonGroup'),
    (Ctrl: 'lbButtons'; Prop: 'Buttons'),
    (Ctrl: 'cbDefButton'; Prop: 'DefButton'),
    (Ctrl: 'cbHelpContext'; Prop: 'HelpContext'),
    (Ctrl: 'cbHelpFile'; Prop: 'HelpFile'),
    (Ctrl: 'cbIconKind'; Prop: 'IconKind'),
    (Ctrl: 'cbIconResource'; Prop: 'IconResource'),
    (Ctrl: 'cbKind'; Prop: 'Kind'),
    (Ctrl: 'chkMakeSound'; Prop: 'MakeSound'),
    (Ctrl: 'edOffsetLeft'; Prop: 'OffsetLeft'),
    (Ctrl: 'edOffsetTop'; Prop: 'OffsetTop'),
    (Ctrl: 'lbOptions'; Prop: 'Options'),
    (Ctrl: 'edText'; Prop: 'Text'),
    (Ctrl: 'edTitle'; Prop: 'Title'),
    (Ctrl: 'btnExecute'; Prop: 'Execute')
  );

function LookupCtrlProp(const Ctrl: string): string;
var
  Idx: Integer;
begin
  Result := '';
  for Idx := Low(cHelpMap) to High(cHelpMap) do
    if CompareText(Ctrl, cHelpMap[Idx].Ctrl) = 0 then
    begin
      Result := cHelpMap[Idx].Prop;
      Exit;
    end;
end;

procedure TDemoForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
type
  MULTIKEYHELP = record
    mkSize: DWORD;
    mkKeyList: AnsiChar;
    szKeyPhrase: array[0..256] of AnsiChar;
  end;
var
  Ctrl: TControl;
  Prop: string;
  Macro: string;
  KW: string;
  Cmp: string;
  MK: MULTIKEYHELP;
begin
  if Key = VK_F1 then
  begin
    Ctrl := ActiveControl;
    if Assigned(Ctrl) and (Ctrl.Enabled) then
      Prop := LookupCtrlProp(Ctrl.Name)
    else
      Prop := '';
    if Prop <> '' then
    begin
      Cmp := cCmpNames[btnExecute.Tag];
      Macro := Format('KL(%s)', [{Cmp, }Prop]);
      KW := Format('%s_%s', [Cmp, Prop]);
      if KW <> fLastHelpKW then
      begin
        fLastHelpKW := KW;
        MK.mkSize := SizeOf(MK);
        MK.mkKeylist := 'A';
        FillChar(MK.szKeyPhrase, SizeOf(MK.szKeyPhrase), 0);
        Move(PChar(KW)^, MK.szKeyPhrase, Length(KW));
        WinHelp(
          Handle,
          'PJMessageDialog.hlp',
          HELP_MULTIKEY,
          DWORD(@MK)
        );
      end
      else
        MessageDlg(
          'No further information on this topic', mtWarning, [mbOK], 0
        );
    end
    else
    begin
      btnHelp.Click;
    end;
  end;
end;

procedure TDemoForm.btnHelpClick(Sender: TObject);
begin
  fLastHelpKW := '';
  WinHelp(Handle, PChar(HelpFile), HELP_CONTENTS, 0);
end;

procedure TDemoForm.FormDestroy(Sender: TObject);
begin
  WinHelp(Handle, PChar(HelpFile), HELP_QUIT, 0);
end;

end.
