{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x
         Copyright (c) 1998-2001 Alex'EM

}
unit DCStdCtrls;

interface
{$I DCConst.inc}

uses Messages, Windows, SysUtils, Classes, Controls, Forms, Menus, Graphics,
     StdCtrls, DCEditTools, DCEditButton, ExtCtrls, DCConst, ComStrs, ImgList;

const
  SBN_BUTTONCLOSE  = $BC01;
  SBN_BUTTONCANCEL = $BC02;

  SBC_BUTTONCLOSE  = '$Close$';
  SBC_BUTTONCANCEL = '$Cancel$';

  {TButtonGroupItem Flags states}
  BG_ITEMEXPANDED  = $10;

type
  TOutBarMode = (omNormal, omMoveItem);

  TDCCustomLabel = class(TCustomLabel)
  private
    FDBObject: TDCDBObject;
    FImages: TImageList;
    FImageChangeLink: TChangeLink;
    FOnMouseEnter: TNotifyEvent;
    FOnMouseLeave: TNotifyEvent;
    function GetDBObject: TDCDBObject;
    procedure SetDBObject(const Value: TDCDBObject);
    procedure SetImages(const Value: TImageList);
    procedure ImageListChange(Sender: TObject);
    function GetCaption: string;
    procedure SetCaption(const Value: string);
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure WMEraseBkGnd(var Message: TWMEraseBkGnd); message WM_ERASEBKGND;
    property Caption: string read GetCaption write SetCaption;
    property DBObject: TDCDBObject read GetDBObject write SetDBObject;
    property Images: TImageList read FImages write SetImages;
    property OnMouseEnter: TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    property OnMouseLeave: TNotifyEvent read FOnMouseLeave write FOnMouseLeave;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
    procedure AdjustBounds; override;
  end;

  TDCLabel = class(TDCCustomLabel)
  published
    property Alignment;
    property Align;
    property Anchors;
    property AutoSize default False;
    property BiDiMode;
    property Caption;
    property Color;
    property Constraints;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property FocusControl;
    property Font;
    property ParentBiDiMode;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowAccelChar;
    property ShowHint;
    property Transparent;
    property Layout;
    property Visible;
    property WordWrap;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDock;
    property OnStartDrag;
    property OnMouseEnter;
    property OnMouseLeave;
    property Images;
  end;

  TPictureDispay = (pdCenter, pdTile, pdStretch, pdTopLeft, pdTopRight,
   pdBottomLeft, pdBottomRight);

  TBrushOptions = set of (boScrollable);

  TDCCustomBrushImage = class(TPersistent)
  private
    FAlphaBlend: boolean;
    FAlphaBlendValue: integer;
    FBitmap: TBitmap;
    FDisplay: TPictureDispay;
    FImageChangeLink: TChangeLink;
    FImageIndex: integer;
    FImages: TImageList;
    FOnChange: TNotifyEvent;
    FOptions: TBrushOptions;
    FOwner: TComponent;
    procedure ImageLinkChanged(Sender: TObject);
    procedure SetBitmap(const Value: TBitmap);
    procedure SetImages(const Value: TImageList);
    procedure SetImageIndex(const Value: integer);
    procedure SetDisplay(const Value: TPictureDispay);
    procedure SetAlphaBlend(const Value: boolean);
    procedure SetAlphaBlendValue(const Value: integer);
    procedure SetOptions(const Value: TBrushOptions);
  protected
    procedure Change; virtual;
    property AlphaBlend: boolean read FAlphaBlend write SetAlphaBlend;
    property AlphaBlendValue: integer read FAlphaBlendValue
      write SetAlphaBlendValue default 255;
    property Bitmap: TBitmap read FBitmap write SetBitmap;
    property Display: TPictureDispay read FDisplay write SetDisplay
      default pdTile;
    property Images: TImageList read FImages write SetImages;
    property ImageIndex: integer read FImageIndex write SetImageIndex;
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
    property Options: TBrushOptions read FOptions write SetOptions default [];
  public
    constructor Create(AOwner: TComponent); virtual;
    destructor Destroy; override;
    procedure Draw(ACanvas: TCanvas; ARect, FullRect: TRect); virtual;
    function Empty: boolean;
    function GetImageRgn(ARect: TRect): HRGN;
  end;

  TDCBrushImage = class(TDCCustomBrushImage)
  published
    property AlphaBlend;
    property AlphaBlendValue;
    property Bitmap;
    property Display;
    property Images;
    property ImageIndex;
    property Options;
  end;

  TDCCustomPanel = class(TCustomPanel)
  private
    FImages: TImageList;
    FImageChangeLink: TChangeLink;
    FVertCentered: boolean;
    FOnMouseEnter: TNotifyEvent;
    FOnMouseLeave: TNotifyEvent;
    FMargins: TRect;
    FBrushImage: TDCBrushImage;
    procedure ChangeBrush(Sender: TObject);
    procedure ImageListChange(Sender: TObject);
    procedure SetVertCentered(const Value: boolean);
    procedure SetImages(const Value: TImageList);
    procedure SetBrushImage(const Value: TDCBrushImage);
    function GetCaption: string;
    procedure SetCaption(const Value: string);
  protected
    function GetRectOffset: TRect; virtual;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure WMEraseBkGnd(var Message: TWMEraseBkGnd); message WM_ERASEBKGND;
    property OnMouseEnter: TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    property OnMouseLeave: TNotifyEvent read FOnMouseLeave write FOnMouseLeave;
    property VertCentered: boolean read FVertCentered write SetVertCentered;
    property Images: TImageList read FImages write SetImages;
    property Caption: string read GetCaption write SetCaption;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
    procedure SetMargins(Left, Top, Right, Bottom: integer);
  published
    property BrushImage: TDCBrushImage read FBrushImage write SetBrushImage;
  end;

  TDCPanel = class(TDCCustomPanel)
  public
    property DockManager;
  published
    property Alignment stored True;
    property Align stored True;
    property Anchors;
    property AutoSize;
    property BevelInner;
    property BevelOuter;
    property BevelWidth;
    property BiDiMode;
    property BorderWidth default 2;
    property BorderStyle;
    property Caption;
    property Color stored True;
    property Constraints;
    property Ctl3D;
    property UseDockManager default True;
    property DockSite;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property FullRepaint;
    property Font;
    property Locked;
    property ParentBiDiMode;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnCanResize;
    property OnClick;
    property OnConstrainedResize;
    property OnDockDrop;
    property OnDockOver;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnGetSiteInfo;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnResize;
    property OnStartDock;
    property OnStartDrag;
    property OnUnDock;
    property OnMouseEnter;
    property OnMouseLeave;
    property VertCentered;
    property Images;
  end;

  TDCCustomHeaderPanel = class(TDCPanel)
  private
    FButtonAllign: boolean;
    FButtons: TDCEditButtons;
    FClosed: boolean;
    FDrawingStyle: TDCDrawingStyle;
    FOnCloseButtonClick: TNotifyEvent;
    procedure CloseButtonClick(Sender: TObject);
    procedure AddCloseButton;
    procedure DelCloseButton;
    procedure SetClosed(const Value: boolean);
    procedure SetButtonAllign(const Value: boolean);
    procedure FillNCArea;
    procedure SetDrawingStyle(const Value: TDCDrawingStyle);
    procedure SetButtonStyle(Button: TDCEditButton; Value: TDCDrawingStyle);
  protected
    procedure CreateWnd; override;
    function GetRectOffset: TRect; override;
    property Closed: boolean read FClosed write SetClosed;
    procedure CMColorChanged(var Message: TMessage); message CM_COLORCHANGED;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure CMDialogChar(var Message: TCMDialogChar); message CM_DIALOGCHAR;
    procedure WMKillFocus(var Message: TWMKillFocus); message WM_KILLFOCUS;
    procedure WMNCCalcSize(var Message: TWMNCCalcSize); message WM_NCCALCSIZE;
    procedure WMNCHitTest(var Message: TWMNCHitTest); message WM_NCHITTEST;
    procedure WMNCPaint(var Message: TWMNCPaint); message WM_NCPAINT;
    property CloseButtonExist: boolean read FClosed write SetClosed;
    property OnCloseButtonClick: TNotifyEvent read FOnCloseButtonClick
      write FOnCloseButtonClick;
    property Buttons: TDCEditButtons read FButtons;
    property DrawingStyle: TDCDrawingStyle read FDrawingStyle write
      SetDrawingStyle default dtFlat;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
  published
    property BorderWidth default 2;
    property BevelOuter default bvNone;
    property ButtonAllign: boolean read FButtonAllign write SetButtonAllign;
  end;

  TDCHeaderPanel = class(TDCCustomHeaderPanel)
  public
    property Buttons;
  published
    property CloseButtonExist;
    property DrawingStyle;
    property OnCloseButtonClick;
    property Align default alTop;
    property Color default clBtnShadow;
    property BevelOuter default bvNone;
  end;

  TDCCustomCheckBox = class(TWinControl)
  private
    FAlignment: TLeftRight;
    FAllowGrayed: Boolean;
    FDrawStyle: TControlStyle;
    FState: TCheckBoxState;
    procedure SetState(const Value: TCheckBoxState);
    procedure SetAlignment(const Value: TLeftRight);
    function IsCheckedStored: Boolean;
    procedure InvalidateState;
    function GetDrawStyle: TControlStyle;
    procedure SetDrawStyle(const Value: TControlStyle);
  protected
    procedure ActionChange(Sender: TObject; CheckDefaults: Boolean); override;
    procedure CMDialogChar(var Message: TCMDialogChar); message CM_DIALOGCHAR;
    procedure CNCommand(var Message: TWMCommand); message CN_COMMAND;
    procedure CNDrawItem(var Message: TWMDrawItem); message CN_DRAWITEM;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    function GetActionLinkClass: TControlActionLinkClass; override;
    function GetChecked: Boolean; virtual;
    function GetStateRect(R: TRect): TRect;
    procedure SetChecked(const Value: Boolean); virtual;
    procedure Toggle; virtual;
    procedure WndProc(var Message: TMessage); override;
    property Alignment: TLeftRight read FAlignment write SetAlignment
      default taRightJustify;
    property AllowGrayed: Boolean read FAllowGrayed write FAllowGrayed
      default False;
    property Checked: Boolean read GetChecked write SetChecked
      stored IsCheckedStored default False;
    property DrawStyle: TControlStyle read GetDrawStyle write SetDrawStyle
      default fcsNormal;
    property State: TCheckBoxState read FState write SetState
      default cbUnchecked;
  public
    constructor Create(AOwner: TComponent); override;
    function GetControlsAlignment: TAlignment; override;
  published
    property TabStop default True;
  end;

  TDCCheckBox = class(TDCCustomCheckBox)
  published
    property Action;
    property Alignment;
    property AllowGrayed;
    property Anchors;
    property BiDiMode;
    property Caption;
    property Checked;
    property Color;
    property Constraints;
    property Ctl3D;
    property DragCursor;
    property DragKind;
    property DragMode;
    property DrawStyle;
    property Enabled;
    property Font;
    property ParentBiDiMode;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property State;
    property TabOrder;
    property Visible;
    property OnClick;
    {$IFDEF DELPHI_V5UP}
    property OnContextPopup;
    {$ENDIF}
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDock;
    property OnStartDrag;
  end;

  TDCCustomControl = class(TCustomControl)
  private
    FBrushImage: TDCBrushImage;
    procedure ChangeBrush(Sender: TObject);
    procedure SetBrushImage(const Value: TDCBrushImage);
  protected
    procedure DoBrushChanged; virtual;
    property BrushImage: TDCBrushImage read FBrushImage write SetBrushImage;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
  end;

  TDCCustomPageControl = class;

  TDrawTabEvent = procedure (Control: TDCCustomPageControl; Canvas: TCanvas; PageIndex: Integer;
    const Rect: TRect; Active: Boolean; var DefaultDraw: boolean) of object;

  TGetItemPopup = procedure (Sender: TObject; Item: TDCEditButton;
    var PopupMenu: TPopupMenu) of object;

  TDCCustomPage = class(TDCCustomControl)
  private
    FFlags: DWORD;
    FImageIndex: integer;
    FOnHide: TNotifyEvent;
    FOnShow: TNotifyEvent;
    FPageControl: TDCCustomPageControl;
    FPageVisible: boolean;
    FTabRect: TRect;
    function GetPageIndex: Integer;
    procedure SetPageControl(const Value: TDCCustomPageControl);
    procedure SetPageIndex(const Value: Integer);
    procedure SetPageVisible(const Value: boolean);
    procedure UpdatePageShowing;
    procedure SetImageIndex(const Value: integer);
    function IsPageVisible: boolean;
  protected
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
    procedure CMShowingChanged(var Message: TMessage); message CM_SHOWINGCHANGED;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure CMEnabledChanged(var Message: TMessage); message CM_ENABLEDCHANGED;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure DoHide; dynamic;
    procedure DoShow; dynamic;
    function GetFlagValue(Index: integer): boolean;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure ReadState(Reader: TReader); override;
    procedure SetFlagValue(Index: integer; const Value: boolean);
    procedure WMEraseBkGnd(var Message: TWMEraseBkGnd); message WM_ERASEBKGND;
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    property Flags[Index: integer]: boolean read GetFlagValue write SetFlagValue;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer); override;
    property PageControl: TDCCustomPageControl read FPageControl write SetPageControl;
    procedure Paint; override;
    property ImageIndex: integer read FImageIndex write SetImageIndex default -1;
  published
    property Caption;
    property Color stored True default clBtnFace;
    property Constraints;
    property BrushImage;
    property DragMode;
    property Enabled;
    property Font;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property PageIndex: Integer read GetPageIndex write SetPageIndex stored False;
    property PageVisible: boolean read FPageVisible write SetPageVisible default True;
    property OnClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnHide: TNotifyEvent read FOnHide write FOnHide;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnResize;
    property OnShow: TNotifyEvent read FOnShow write FOnShow;
    property OnStartDrag;
  end;

  TDCPage = class(TDCCustomPage)
  protected
    procedure CMBorderChanged(var Message: TMessage); message CM_BORDERCHANGED;
  published
    property BorderWidth default 2;
    property ImageIndex;
  end;

  TPageList = class(TList)
  private
    FVisibleList: TList;
    FPageControl: TDCCustomPageControl;
    function GetVisibleCount: integer;
    procedure ClearVisible;
    procedure UpdateVisible;
    procedure AddVisible(AIndex: integer);
  public
    constructor Create(AComponent: TComponent);
    destructor Destroy; override;
    function VisibleIndexOf(Index: integer): integer;
    procedure SetVisible(APage: TDCCustomPage; AVisible: boolean);
    property VisibleCount: integer read GetVisibleCount;
  end;

  TDCCustomPageControl = class(TCustomControl)
  private
    FPages: TPageList;
    FActivePage: TDCCustomPage;
    FOnChange: TNotifyEvent;
    FOnChanging: TChangingEvent;
    FOnDrawTab: TDrawTabEvent;
    FTabsRect: TRect;
    FImages: TImageList;
    FTabVisible: boolean;
    FImageChangeLink: TChangeLink;
    FFirstIndex: integer;
    FSelectedPage: TDCCustomPage;
    FBitmap: TBitmap;
    FBuffered: boolean;
    FBrushImage: TDCBrushImage;
    procedure ChangeActivePage(Page: TDCCustomPage); dynamic;
    procedure ChangeBrush(Sender: TObject);
    function GetPage(Index: Integer): TDCCustomPage;
    function GetPageCount: Integer;
    function GetPageIndex: integer;
    procedure ImageListChange(Sender: TObject); virtual;
    procedure InsertPage(Page: TDCCustomPage); virtual;
    procedure RemovePage(Page: TDCCustomPage); virtual;
    procedure SetBrushImage(const Value: TDCBrushImage);
    procedure SetImages(const Value: TImageList); virtual;
    procedure SetPageIndex(const Value: integer);
    procedure SetPageVisible(APageIndex: integer; AVisible: boolean);
    procedure SetTabVisible(const Value: boolean); virtual;
    procedure UpdateTabsRect;
  protected
    procedure AdjustClientRect(var Rect: TRect); override;
    function CanChange(Page: TDCCustomPage): Boolean; dynamic;
    function CanShowPage(PageIndex: Integer): Boolean; virtual;
    procedure Change; dynamic;
    procedure CMDesignHitTest(var Message: TCMDesignHitTest); message CM_DESIGNHITTEST;
    procedure CMDialogChar(var Message: TCMDialogChar); message CM_DIALOGCHAR;
    procedure CMDialogKey(var Message: TCMDialogKey); message CM_DIALOGKEY;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure DoDrawTab(ACanvas: TCanvas; ARect: TRect; AIndex: integer;
      APage: TDCCustomPage; AActivePage: boolean); virtual;
    procedure DrawBorder(ACanvas: TCanvas); virtual;
    procedure DrawTab(ACanvas: TCanvas; ARect: TRect; AIndex: integer;
      APage: TDCCustomPage; var ADefaultDraw: boolean; AExclude: boolean);
    procedure DrawTabsArea(ACanvas: TCanvas); virtual;
    function GetCurrentPageRect: TRect; virtual;
    function GetPageAt(X, Y: integer): TDCCustomPage;
    function GetTabRect(AIndex: integer; Page: TDCCustomPage;
      var ARect: TRect): TRect; virtual;
    function GetTabsRect: TRect; virtual;
    procedure Loaded; override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure RepaintTabs; virtual;
    procedure SetActivePage(const Value: TDCCustomPage); virtual;
    procedure ShowControl(AControl: TControl); override;
    procedure TabsChanged; virtual;
    procedure UpdateDeviceRegion(DC: HDC); virtual;
    procedure UpdateTabSize; virtual;
    procedure UpdatePage(Page: TDCCustomPage); virtual;
    procedure WMEraseBkGnd(var Message: TWMEraseBkGnd); message WM_ERASEBKGND;
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    property PageIndex: integer read GetPageIndex write SetPageIndex;
    property TabsRect: TRect read FTabsRect;
    property BrushImage: TDCBrushImage read FBrushImage write SetBrushImage;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
    function FindNextPage(APage: TDCCustomPage;
      GoForward, CheckTabVisible: Boolean): TDCCustomPage;
    function SelectNextPage(GoForward: Boolean): boolean;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    property PageCount: Integer read GetPageCount;
    property Pages[Index: Integer]: TDCCustomPage read GetPage;
  published
    property Align;
    property Color default clBtnFace;
    property Enabled;
    property Font;
    property Visible;
    property PopupMenu;
    property TabStop;
    property ActivePage: TDCCustomPage read FActivePage write SetActivePage;
    property TabVisible: boolean read FTabVisible write SetTabVisible default True;
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
    property OnChanging: TChangingEvent read FOnChanging write FOnChanging;
    property OnDrawTab: TDrawTabEvent read FOnDrawTab write FOnDrawTab;
    property Images: TImageList read FImages write SetImages;
  end;

  {TDCPageControl}

  TPageControlOptions = set of (pcShowCloseButton, pcTracksOnRightSide);

  TDCPageControl = class(TDCCustomPageControl)
  private
    FCanvasLocked: boolean;
    FChangedPage: TDCCustomPage;
    FDrawStyle: TControlStyle;
    FItemHeight: integer;
    FItemMargins: TRect;
    FMouseDown: boolean;
    FNextTrack: TDCEditButton;
    FOptions: TPageControlOptions;
    FPageSelected: boolean;
    FPrevTrack: TDCEditButton;
    FRedrawTabs: boolean;
    FTabButtons: TDCEditButtons;
    FTabColor: TColor;
    FTabHeight: integer;
    FTabMargins: TRect;
    FTabPosition: TLiteTabPosition;
    FTabSize: TPoint;
    FTabTracksStyle: TDCDrawingStyle;
    FTabWidth: integer;
    FTimer: boolean;
    procedure SetTabHeight(const Value: integer);
    procedure SetTabWidth(const Value: integer);
    function ControlRect: TRect;
    procedure CloseButtonClick(Sender: TObject);
    procedure SetDrawStyle(const Value: TControlStyle);
    procedure SetTabPosition(const Value: TLiteTabPosition); virtual;
    procedure ButtonsUp(Sender: TObject);
    procedure ButtonsDown(Sender: TObject);
    procedure PaintTracks;
    procedure UpdateTracksState(X, Y: integer; lMove: boolean);
    procedure HideTrack(Track: TDCEditButton);
    procedure UpdateTabs;
    procedure CheckToNextTrack;
    procedure CheckToPrevTrack;
    procedure ClearSelection;
    procedure UpdateFirstIndex;
    procedure ChangeActivePage(Page: TDCCustomPage); override;
    procedure RedrawTab(Page: TDCCustomPage);
    procedure SetTabColor(const Value: TColor);
    function GetItemSize(Page: TDCCustomPage): TPoint;
    procedure DrawTabDiv(ACanvas: TCanvas; ARect: TRect; AActivePage, AFirst: boolean); virtual;
    procedure SetOptions(const Value: TPageControlOptions);
    procedure SetTabTracksStyle(const Value: TDCDrawingStyle);
  protected
    procedure CreateTracks;
    procedure CreateWnd; override;
    procedure Loaded; override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure CMRedrawTab(var Message: TMessage); message CM_REDRAWTAB;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMLButtonDblClk(var Message: TWMLButtonDown); message WM_LBUTTONDBLCLK;
    procedure WMLButtonUp(var Message: TWMLButtonUp); message WM_LBUTTONUP;
    procedure WMMouseMove(var Message: TWMMouseMove); message WM_MOUSEMOVE;
    procedure WMSize(var Message: TMessage); message WM_SIZE;
    procedure WMTimer(var Message: TWMTimer); message WM_TIMER;
    procedure WMKillFocus(var Message: TWMKillFocus); message WM_KILLFOCUS;
    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SETFOCUS;
    procedure UpdateTabSize; override;
    function GetCurrentPageRect: TRect; override;
    function GetTabRect(AIndex: integer; Page: TDCCustomPage;
      var ARect: TRect): TRect; override;
    function GetTabsRect: TRect; override;
    procedure DrawBorder(ACanvas: TCanvas); override;
    procedure DoDrawTab(ACanvas: TCanvas; ARect: TRect; AIndex: integer;
      APage: TDCCustomPage; AActivePage: boolean); override;
    procedure DrawTabText(ACanvas: TCanvas; ARect: TRect; AIndex: integer;
      APage: TDCCustomPage; AActivePage: boolean);
    procedure DrawTabsArea(ACanvas: TCanvas); override;
    function CanChange(Page: TDCCustomPage): Boolean; override;
    procedure SetActivePage(const Value: TDCCustomPage); override;
    procedure TabsChanged; override;
    procedure UpdateDeviceRegion(DC: HDC); override;
    procedure UpdateTracksColor; virtual;
    procedure UpdateTracksPos; virtual;
    procedure UpdateTracksStyle; virtual;
    procedure UpdatePage(Page: TDCCustomPage); override;
  public
    constructor Create(AComponent: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
  published
    property Anchors;
    property BrushImage;
    property DragKind;
    property DragMode;
    property DrawStyle: TControlStyle read FDrawStyle write SetDrawStyle default fcsNormal;
    property TabHeight: integer read FTabSize.Y write SetTabHeight default 0;
    property TabWidth: integer read FTabSize.X write SetTabWidth default 0;
    property TabPosition: TLiteTabPosition read FTabPosition write SetTabPosition default tbBottom;
    property TabColor: TColor read FTabColor write SetTabColor default clBtnShadow;
    property TabTracksStyle: TDCDrawingStyle read FTabTracksStyle write
      SetTabTracksStyle default dtNormal;
    {$IFDEF DELPHI_V5UP}
    property OnContextPopup;
    {$ENDIF}
    property OnDockDrop;
    property OnDockOver;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnGetSiteInfo;
    property OnResize;
    property OnStartDock;
    property OnStartDrag;
    property OnUnDock;
    property Options: TPageControlOptions read FOptions write SetOptions
      default [];
  end;

  {TDCOutBar}

  TImagesStyle     = (isSmallImages, isLargeImages);
  TOutPanelOption  = (opDropDown, opItemMove, opFlatTracks);
  TOutPanelOptions = set of TOutPanelOption;

  TDCCustomOutBarPanel = class(TDCCustomPage)
  private
    FAnchorStyle: TAnchorStyle;
    FButtons: TDCEditButtons;
    FFirstIndex: integer;
    FHintObject: TObject;
    FImageChangeLink: TChangeLink;
    FLargeImages: TImageList;
    FNextTrack: TDCEditButton;
    FOnGetItemPopup: TGetItemPopup;
    FOnItemClick: TNotifyEvent;
    FOnMouseEnter: TNotifyEvent;
    FOnMouseLeave: TNotifyEvent;
    FOptions: TOutPanelOptions;
    FPrevTrack: TDCEditButton;
    FSmallImages: TImageList;
    FStyle: TImagesStyle;
    procedure SetLargeImages(const Value: TImageList);
    procedure SetSmallImages(const Value: TImageList);
    procedure SetStyle(const Value: TImagesStyle);
    procedure CheckArea(Sender: TObject; X, Y: integer; var Selected: boolean);
    procedure SetButtonState(Sender: TObject; var State: TButtonState); virtual;
    procedure UpdateTracksState(X, Y: integer; lMove: boolean);
    procedure PaintTracks(DrawContext: HDC);
    procedure GetButtonsRegion(Sender: TObject; var Rgn: HRGN);
    procedure ButtonsUp(Sender: TObject);
    procedure ButtonsDown(Sender: TObject);
    procedure HideTrack(Track: TDCEditButton);
    procedure CheckToNextTrack;
    procedure CheckToPrevTrack;
    function GetActiveButton: TDCEditButton;
    procedure SetOptions(const Value: TOutPanelOptions);
    procedure SetDropDown(const Value: boolean);
    procedure SetFirstIndex(const Value: integer);
    procedure SetActiveButton(Value: TDCEditButton);
    procedure ImageListChange(Sender: TObject);
    function GetItemIndex: integer;
    procedure SetItemIndex(const Value: integer);
    procedure UpdateTracksStyle;
  protected
    procedure CreateWnd; override;
    function GetPopupMenu: TPopupMenu; override;
    procedure Loaded; override;
    procedure DrawButtonHint(Sender: TObject; Mode: integer); virtual;
    function FormatText(const Value: string; Offset, ClientWidth: integer;
      var TextSize: TPoint): string;
    function DoMouseWheelDown(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure CMColorChanged(var Message: TMessage); message CM_COLORCHANGED;
    procedure CMHintShow(var Message: TCMHintShow); message CM_HINTSHOW;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure WMKillFocus(var Message: TWMKillFocus); message WM_KILLFOCUS;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMLButtonDblClk(var Message: TWMLButtonDown); message WM_LBUTTONDBLCLK;
    procedure WMLButtonUp(var Message: TWMLButtonUp); message WM_LBUTTONUP;
    procedure WMMouseMove(var Message: TWMMouseMove); message WM_MOUSEMOVE;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure WMTimer(var Message: TWMTimer); message WM_TIMER;
    function ButtonVisible(Button: TDCEditButton): boolean; virtual;
    function TracksCovering: boolean; virtual;
    procedure CreateTracks; virtual;
    procedure UpdateTracksPos; virtual;
    procedure SetButtonPos(Index: integer); virtual;
    procedure ItemClick(Sender: TObject); virtual;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure DoBrushChanged; override;
    property LargeImages: TImageList read FLargeImages write SetLargeImages;
    property SmallImages: TImageList read FSmallImages write SetSmallImages;
    property Style: TImagesStyle read FStyle write SetStyle;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function AddButton: TDCEditButton; virtual;
    procedure DeleteButton(Index: integer);
    procedure Paint; override;
    procedure UpdateButtonsPos;
    procedure SelectItem(Button: TDCEditButton);
    property Buttons: TDCEditButtons read FButtons write FButtons stored False;
    property ActiveButton: TDCEditButton read GetActiveButton write SetActiveButton;
  published
    property Items: TDCEditButtons read FButtons write FButtons;
    property OnMouseEnter: TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    property OnMouseLeave: TNotifyEvent read FOnMouseLeave write FOnMouseLeave;
    property OnItemClick: TNotifyEvent read FOnItemClick write FOnItemClick;
    property FirstIndex: integer read FFirstIndex write SetFirstIndex stored False;
    property ItemIndex: integer read GetItemIndex write SetItemIndex stored False;
    property Options: TOutPanelOptions read FOptions write SetOptions;
    property OnGetItemPopup: TGetItemPopup read FOnGetItemPopup write FOnGetItemPopup;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

  TDCOutBarPanel = class(TDCCustomOutBarPanel)
  published
    property ImageIndex;
    property LargeImages;
    property OnDblClick;
    property OnClick;
    {$IFDEF DELPHI_V5UP}
    property OnContextPopup;
    {$ENDIF}
    property SmallImages;
    property Style;
  end;

  TDCCustomOutBar = class(TDCCustomPageControl)
  private
    FTabHeight: integer;
    FItemHeight: integer;
    FTabSize: TPoint;
    FTabMargins: TRect;
    FMode: TOutBarMode;
    FTextAlignment: TAlignment;
    function ControlRect: TRect;
    procedure SetTabHeight(const Value: integer);
    procedure SetTextAlignment(const Value: TAlignment);
  protected
    procedure CreateWnd; override;
    procedure Loaded; override;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure WMMouseMove(var Message: TWMMouseMove); message WM_MOUSEMOVE;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure WMTimer(var Message: TWMTimer); message WM_TIMER;
    function GetCurrentPageRect: TRect; override;
    function GetTabRect(AIndex: integer; Page: TDCCustomPage;
      var ARect: TRect): TRect; override;
    procedure UpdateTabSize; override;
    function GetTabsRect: TRect; override;
    procedure DrawBorder(ACanvas: TCanvas); override;
    procedure DoDrawTab(ACanvas: TCanvas; ARect: TRect; AIndex: integer;
      APage: TDCCustomPage; AActivePage: boolean); override;
    procedure DrawTabsArea(ACanvas: TCanvas); override;
    procedure TabsChanged; override;
  public
    constructor Create(AComponent: TComponent); override;
    procedure Paint; override;
  published
    property TabHeight: integer read FTabSize.Y write SetTabHeight;
    property TextAlignment: TAlignment read FTextAlignment write SetTextAlignment default taCenter;
  end;

  TDCOutBar = class(TDCCustomOutBar)
    {}
  end;

  TDCPaleteBar = class;

  TDCPaleteBarPanel = class(TDCCustomOutBarPanel)
  private
    FDrawText: boolean;
    FIconStyle: boolean;
    procedure UpdateButtonsVisible;
    function GetImages: TImageList;
    procedure SetImages(const Value: TImageList);
    procedure SetDrawText(const Value: boolean);
    procedure SetIconStyle(const Value: boolean);
  protected
    procedure Loaded; override;
    procedure Click; override;
    procedure DblClick; override;
    procedure CreateTracks; override;
    function ButtonVisible(Button: TDCEditButton): boolean; override;
    function TracksCovering: boolean; override;
    procedure UpdateTracksPos; override;
    procedure SetButtonPos(Index: integer); override;
    procedure ItemClick(Sender: TObject); override;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure CMColorChanged(var Message: TMessage); message CM_COLORCHANGED;
    procedure CMHintShow(var Message: TCMHintShow); message CM_HINTSHOW;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    property LargeImages;
    property SmallImages;
    property Style;
  public
    constructor Create(AOwner: TComponent); override;
    function AddButton: TDCEditButton; override;
  published
    property ImageIndex;
    property Images: TImageList read GetImages write SetImages;
    property DrawText: boolean read FDrawText write SetDrawText default False;
    property IconStyle: boolean read FIconStyle write SetIconStyle default False;
  end;

  TDCPaleteBar = class(TDCPageControl)
  private
    FButtons: TDCEditButtons;
    FCancelExist: boolean;
    FCancelSize: integer;
    FOnCancel: TNotifyEvent;
    procedure AddCancelButton;
    procedure SetCancelButtonBounds(Repaint: boolean = True);
    procedure CancelButtonClick(Sender: TObject);
    procedure SetImages(const Value: TImageList); override;
    procedure SetButtonState(Sender: TObject; var State: TButtonState); virtual;
    procedure SetTabPosition(const Value: TLiteTabPosition); override;
    procedure SetTabVisible(const Value: boolean); override;
    procedure RepaintFreeArea;
    procedure ImageListChange(Sender: TObject); override;
    procedure InsertPage(Page: TDCCustomPage); override;
    procedure RemovePage(Page: TDCCustomPage); override;
    function GetSelectedItem: TDCEditButton;
    procedure SetCancelExist(const Value: boolean);
    procedure SetCancelSize(const Value: integer);
  protected
    procedure UpdateDeviceRegion(DC: HDC); override;
    procedure UpdateTabSize; override;
    function GetCurrentPageRect: TRect; override;
    procedure SetActivePage(const Value: TDCCustomPage); override;
    procedure CMColorChanged(var Message: TMessage); message CM_COLORCHANGED;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
  public
    constructor Create(AComponent: TComponent); override;
    destructor Destroy; override;
    procedure CreateWnd; override;
    procedure AdjustClientRect(var Rect: TRect); override;
    procedure Cancel;
    procedure Paint; override;
    property SelectedItem: TDCEditButton read GetSelectedItem;
  published
    property Images;
    property OnClick;
    property OnDblClick;
    property CancelExist: boolean read FCancelExist write SetCancelExist default False;
    property CancelSize: integer read FCancelSize write SetCancelSize;
    property OnCancel: TNotifyEvent read FOnCancel write FOnCancel;
  end;

  TDCCustomTaskPanel = class;
  TButtonGroups = class;
  TButtonGroupItem = class;
  TButtonGroupOptions = set of (bgExpandable, bgShowLine);
  TGroupItemDrawStyle = (dsNormal, dsAdvanced);

  TGroupItemHitTests = (giNowere, giOnButton, giOnIndent, giOnCaption,
    giOnComment, giOnItems);
  TSetGroupItemHitTests = set of TGroupItemHitTests;

  TSectionItemOptions = set of (soWrapItems, soClientAlign);

  TGroupSectionItem = class(TCollectionItem)
  private
    FButtons: TList;
    FHeight: integer;
    FHAlign: THorzAlignment;
    FHSpacing: integer;
    FMarginBottom: integer;
    FMarginLeft: integer;
    FMarginTop: integer;
    FMinHeight: integer;
    FOptions: TSectionItemOptions;
    FOrientation: TItemsOrientation;
    FVAlign: TVertAlignment;
    FVSpacing: integer;
    FWidth: integer;
    procedure SetHAlign(const Value: THorzAlignment);
    procedure SetVAlign(const Value: TVertAlignment);
    procedure SetMarginBottom(const Value: integer);
    procedure SetMarginTop(const Value: integer);
    procedure SetOptions(const Value: TSectionItemOptions);
    function GetGroup: TButtonGroupItem;
    procedure SetMinHeight(const Value: integer);
    procedure SetHSpacing(const Value: integer);
    procedure SetVSpacing(const Value: integer);
    function GetButton(Index: integer): TDCEditButton;
    procedure SetButton(Index: integer; const Value: TDCEditButton);
    function GetCount: integer;
    procedure SetOrientation(const Value: TItemsOrientation);
    procedure SetMarginLeft(const Value: integer);
  public
    constructor Create(Collection: TCollection); override;
    destructor Destroy; override;
    function AddButton(EditButtonClass: TEditButtonClass): TDCEditButton;
    property Count: integer read GetCount;
    procedure Clear; virtual;
    property Group: TButtonGroupItem read GetGroup;
    property Items[Index: integer]: TDCEditButton read GetButton
      write SetButton; default;
  published
    property HAlign: THorzAlignment read FHAlign write SetHAlign
      default haLeft;
    property HSpacing: integer read FHSpacing write SetHSpacing;
    property MarginBottom: integer read FMarginBottom write SetMarginBottom;
    property MarginLeft: integer read FMarginLeft write SetMarginLeft;
    property MarginTop: integer read FMarginTop write SetMarginTop;
    property MinHeight: integer read FMinHeight write SetMinHeight;
    property Options: TSectionItemOptions read FOptions write SetOptions
      default [];
    property Orientation: TItemsOrientation read FOrientation
      write SetOrientation;
    property VAlign: TVertAlignment read FVAlign write SetVAlign
      default vaTop;
    property VSpacing: integer read FVSpacing write SetVSpacing;
  end;

  TGroupSections = class(TCollection)
  private
    FButtonGroup: TButtonGroupItem;
    function GetItem(Index: Integer): TGroupSectionItem;
    procedure SetItem(Index: Integer; const Value: TGroupSectionItem);
    function GetButtonsCount: integer;
  protected
    procedure Update(Item: TCollectionItem); override;
  public
    constructor Create(AButtonGroup: TButtonGroupItem); virtual;
    function Add: TGroupSectionItem;
    property ButtonsCount: integer read GetButtonsCount;
    property Items[Index: Integer]: TGroupSectionItem read GetItem write SetItem;
  end;

  TButtonGroupClass = class of TButtonGroupItem;

  TButtonGroupItem = class(TCollectionItem, IDCButtonHolder)
  private
    FActiveButton: TDCEditButton;
    FAlignment: TGroupAlignment;
    FBoundsRect: TRect;
    FCacheHeight: integer;
    FCaption: TCaption;
    FCaptionHeight: integer;
    FComment: string;
    FDrawStyle: TGroupItemDrawStyle;
    FEnabled: boolean;
    FFlags: DWORD;
    FIndent: integer;
    FOptions: TButtonGroupOptions;
    FUpdateCount: integer;
    FSections: TGroupSections;
    FVisible: boolean;
    function GetActiveButton: TDCEditButton;
    procedure SetActiveButton(const Value: TDCEditButton);
    procedure SetAligment(const Value: TGroupAlignment);
    procedure SetEnabled(const Value: boolean);
    procedure SetVisible(const Value: boolean);
    procedure SetCaption(const Value: TCaption);
    procedure SetOptions(const Value: TButtonGroupOptions);
    function GetCollection: TButtonGroups;
    function GetButton(Index: integer): TDCEditButton;
    function GetCount: integer;
    procedure SetButton(Index: integer; const Value: TDCEditButton);
    procedure SetComment(const Value: string);
    procedure SetDrawStyle(const Value: TGroupItemDrawStyle);
    procedure SetIndent(const Value: integer);
    function GetCanvas: TCanvas;
    function GetFocusedButton: TDCEditButton;
    procedure SetFocusedButton(const Value: TDCEditButton);
  protected
    function _AddRef: Integer; stdcall;
    function _Release: Integer; stdcall;
    function ButtonVisible(Sender: TDCEditButton): boolean;
    function GetExpandButtonRect: TRect; virtual;
    function GetExpandButtonSize: integer; virtual;
    function GetButtonsRect: TRect;
    function GetMaxImageWidth: integer;
    function GetRegion: HRGN;
    function GetWinControl: TWinControl;
    function GetGroupHeight: integer; virtual;
    procedure Notify(Button: TDCEditButton; Action: TDCButtonAction); virtual;
    procedure OffsetButtons(Pos: TPoint); virtual;
    procedure PaintBackground(ARect: TRect; AButton: TDCEditButton;
      ACanvas: TCanvas);
    function UpdateCaptionHeight: boolean; virtual;
    procedure UpdateGroupPos(PosY: integer); virtual;
    procedure ScrollGroup(Delta: integer);
    function QueryInterface(const IID: TGUID; out Obj): HResult; virtual; stdcall;
    procedure SetCollection(const Value: TButtonGroups);
      {$IFDEF DELPHI_V6} reintroduce; virtual; {$ENDIF}
    procedure SetFlagValue(Index: Integer; const Value: boolean);
  public
    constructor Create(Collection: TCollection); override;
    destructor Destroy; override;
    function AddButtonEx(EditButtonClass: TEditButtonClass;
      Data: integer): TDCEditButton;
    procedure BeginUpdate;
    procedure Collapse(Recurse: boolean);
    procedure DrawCaption(ACanvas: TCanvas); virtual;
    procedure DrawExpandRect(ACanvas: TCanvas; ARect: TRect); virtual;
    procedure EndUpdate;
    procedure Expand(Recurse: boolean);
    function GetHitTestInfoAt(X, Y: Integer): TGroupItemHitTests;
    function GetFlagValue(const Index: Integer): boolean;
    procedure Invalidate;
    procedure MoveButton(CurIndex, NewIndex: integer);
    function UpdateCount: integer;
    property BoundsRect: TRect read FBoundsRect;
    property Count: integer read GetCount;
    property Collection: TButtonGroups read GetCollection write SetCollection;
    property Height: integer read FCacheHeight;
    property Items[Index: integer]: TDCEditButton read GetButton
      write SetButton; default;
    property Sections: TGroupSections read FSections;
  published
    property Alignment: TGroupAlignment read FAlignment write SetAligment;
    property Caption: TCaption read FCaption write SetCaption;
    property Comment: string read FComment write SetComment;
    property DrawStyle: TGroupItemDrawStyle read FDrawStyle write SetDrawStyle;
    property Enabled: boolean read FEnabled write SetEnabled;
    property Expanded: boolean index BG_ITEMEXPANDED read GetFlagValue;
    property FocusedButton: TDCEditButton read GetFocusedButton
      write SetFocusedButton;
    property Indent: integer read FIndent write SetIndent;
    property Options: TButtonGroupOptions read FOptions write SetOptions
      default [bgShowLine];
    property Visible: boolean read FVisible write SetVisible;
  end;

  TButtonGroups = class(TCollection)
  private
    FButtons: TDCEditButtons;
    FBoundsRect: TRect;
    function GetItem(Index: Integer): TButtonGroupItem;
    procedure SetItem(Index: Integer; const Value: TButtonGroupItem);
    function GetCanvas: TCanvas;
    function GetTaskPanel: TDCCustomTaskPanel;
    function GetHeight: integer;
  protected
    function GetTextHeight(Value: string; XPos: integer;
      FontStyle: TFontStyles): integer;
    function UpdateBoundsRect: integer;
    procedure UpdateGroupsPos;
    procedure UpdateImages;
    procedure Update(Item: TCollectionItem); override;
  public
    constructor Create(AButtons: TDCEditButtons); virtual;
    destructor Destroy; override;
    function Add: TButtonGroupItem;
    function AddGroup(AClass: TButtonGroupClass): TButtonGroupItem;
    function GetHitTestInfoAt(X, Y: Integer;
      var Item: TButtonGroupItem): TGroupItemHitTests;
    procedure Invalidate;
    procedure Paint(ACanvas: TCanvas; APosition: integer);
    property BoundsRect: TRect read FBoundsRect;
    property Canvas: TCanvas read GetCanvas;
    property Height: integer read GetHeight;
    property Items[Index: Integer]: TButtonGroupItem read GetItem
      write SetItem; default;
    property TaskPanel: TDCCustomTaskPanel read GetTaskPanel;
  end;

  TDCGroupButtons = class(TDCEditButtons)
  private
    FGroups: TButtonGroups;
  protected
    function GetButton(Index: integer): TDCEditButton; override;
    function GetCount: integer; override;
    procedure OffsetButtons(Pos: TPoint); override;
    function NeedSaveBackground: boolean; override;
    property Groups: TButtonGroups read FGroups;
  public
    constructor Create(AOwner: TWinControl); override;
    destructor Destroy; override;
    procedure RepaintButtons(ADrawStyle: TButtonTypeDrawStyle;
      DrawContext: HDC; AClip: HRGN = NULLREGION); override;
  end;

  TControlMargins = class(TPersistent)
  private
    FControl: TControl;
    FRect: TRect;
    FOnChange: TNotifyEvent;
    function GetMagrin(const Index: Integer): integer;
    procedure SetMargin(const Index, Value: integer);
  protected
    procedure Change; virtual;
    procedure AssignTo(Dest: TPersistent); override;
    property Control: TControl read FControl;
  public
    constructor Create(Control: TControl); virtual;
    procedure SetRectMargin(const R: TRect);
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
  published
    property Bottom: integer index 3 read GetMagrin write SetMargin default 0;
    property Left: integer index 0 read GetMagrin write SetMargin default 0;
    property Right: integer index 2 read GetMagrin write SetMargin default 0;
    property Top: integer index 1 read GetMagrin write SetMargin default 0;
  end;

  TDCCustomScroll = class(TPersistent)
  private
  {
    FControl: TCustomControl;
    FKind: TScrollBarKind;
    FPosition: integer;
    FRange: integer;
    FIncrement: TScrollBarInc;
    FPageSize: integer;
    FMax: integer;
  }
  public
    constructor Create(AControl: TCustomControl); virtual; abstract;
    procedure ScrollMessage(var Message: TWMScroll); virtual; abstract;
    procedure SetPosition(Value: integer); virtual; abstract;
    procedure SetRange(Value: integer); virtual; abstract;
    procedure Update; virtual; abstract;
  end;

  TTaskPanelScroll = class(TPersistent)
  private
    FTaskPanel: TDCCustomTaskPanel;
    FIncrement: integer;
    FInterval: integer;
    FPosition: integer;
    procedure SetPostion(const Value: integer);
  protected
    procedure ScrollDown;
    procedure ScrollUp;
    property TaskPanel: TDCCustomTaskPanel read FtaskPanel;
  public
    constructor Create(ATaskPanel: TDCCustomTaskPanel);
    procedure Assign(Source: TPersistent); override;
    property Position: integer read FPosition write SetPostion;
  published
    property Increment: integer read FIncrement write FIncrement;
    property Interval: integer read FInterval write FInterval;
  end;

  TDCCustomTaskPanel = class(TDCCustomPage)
  private
    FButtons: TDCGroupButtons;
    FHintObject: TObject;
    FImages: TImageList;
    FImageChangeLink: TChangeLink;
    FOnItemClick: TNotifyEvent;
    FOnMouseEnter: TNotifyEvent;
    FOnMouseLeave: TNotifyEvent;
    FMargins: TControlMargins;
    FNextTrack: TDCEditButton;
    FPrevTrack: TDCEditButton;
    FScrollPanel: TTaskPanelScroll;
    procedure ButtonsUp(Sender: TObject);
    procedure ButtonsDown(Sender: TObject);
    procedure GetButtonsRegion(Sender: TObject; var Rgn: HRGN);
    function GetGroups: TButtonGroups;
    procedure ImageListChange(Sender: TObject);
    procedure PaintTracks(DrawContext: HDC);
    function TrackTimerActivate(CheckTimer: boolean): boolean;
    function TrackActive(Button: TDCEditButton): boolean;
    procedure UpdateTracksState(X, Y: integer; lMove: boolean);
    procedure UpdateTracksStyle;
    procedure UpdateTracksPos;
    procedure SetScrollPanel(const Value: TTaskPanelScroll);
    procedure SetGroups(const Value: TButtonGroups);
    procedure SetImages(const Value: TImageList);
    procedure MarginsChanged(Sender: TObject);
    function GetActualWidth: integer;
    function GetActualHeight: integer;
    procedure SetMargins(const Value: TControlMargins);
    procedure CheckExpand(X, Y: integer; AHits: TSetGroupItemHitTests);
  protected
    procedure CMHintShow(var Message: TCMHintShow); message CM_HINTSHOW;
    procedure CMInvalidate(var Message: TMessage); message CM_INVALIDATE;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure CreateWnd; override;
    procedure CreateTracks;
    procedure DoScroll(const Delta: integer);
    procedure DrawButtonHint(Sender: TObject; Mode: integer); virtual;
    procedure ItemClick(Sender: TObject); virtual;
    function SetPosition(Value: integer): integer; virtual;
    procedure WMLButtonDblClk(var Message: TWMLButtonDown); message WM_LBUTTONDBLCLK;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMLButtonUp(var Message: TWMLButtonUp); message WM_LBUTTONUP;
    procedure WMMouseMove(var Message: TWMMouseMove); message WM_MOUSEMOVE;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure WMTimer(var Message: TWMTimer); message WM_TIMER;
    property ActualHeight: integer read GetActualHeight;
    property ActualWidth: integer read GetActualWidth;
    property Groups: TButtonGroups read GetGroups write SetGroups;
    property Images: TImageList read FImages write SetImages;
    property Margins: TControlMargins read FMargins write SetMargins;
    property OnItemClick: TNotifyEvent read FOnItemClick write FOnItemClick;
    property OnMouseEnter: TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    property OnMouseLeave: TNotifyEvent read FOnMouseLeave write FOnMouseLeave;
    property ScrollPanel: TTaskPanelScroll read FScrollPanel write SetScrollPanel;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure Paint; override;
    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer); override;
  end;

  TDCTaskPanel = class(TDCCustomTaskPanel)
  public
    property Groups;
  published
    property BrushImage;
    property Images;
    property Margins;
    property OnItemClick;
  end;

implementation
uses
  DCResource, DCPopupWindow, ActnList;

const
  CM_CXCLOSEBUTTON = 16;
  CM_CYCLOSEBUTTON = 16;

  OBMTIMER_IDEVENT = $B0;
  CTRTIMER_IDEVENT = $B1;
  PNLTIMER_IDEVENT = $B2;

  {Custom pages Flags}
  CP_REMOVING      = $01;
  CP_FULLVISIBLE   = $02;
  CP_MOUSEDOWN     = $03;
  CP_TRACKTIMER    = $04;
  CP_INVALIDATE    = $05;
  CP_UPDATELOCKED  = $06;

  {Outbar panel Flags}
  OP_FREEZESTATE   = $11;

  {TaskPanel Flags}
  TP_NOTIFYITEM    = $15;
  TP_WMSIZE        = $16;

type

  TInternalControl = class(TWinControl)
    {Noting}
  end;

  TInternalButtonActionLink = class(TButtonActionLink)
    {Nothing}
  end;

var
  DrawBitmap: TBitmap;
  CheckBoxWidth, CheckBoxHeight: Integer;

procedure GetCheckSize;
  var
  Bitmap: HBITMAP;
  BI: TBitmapInfoHeader;
begin
  Bitmap := LoadBitmap(0, PChar(32759));
  InitDIBBitmapHeader(Bitmap, BI, 0);
  CheckBoxWidth  := BI.biWidth div 4;
  CheckBoxHeight := BI.biHeight div 3;
end;

procedure CreateDrawBitmap;
begin
  DrawBitmap := TBitmap.Create;
end;

procedure ReleaseDrawBitmap;
begin
  DrawBitmap.Free;
end;

{$IFDEF DELPHI_V5UP}
  procedure UpdateDesigner(Sender: TComponent);
  var
    Designer: IDesignerNotify;
  begin
    Designer := FindRootDesigner(Sender);
    if Designer <> nil then Designer.Modified;
  end;
{$ELSE}
  procedure UpdateDesigner(Sender: TComponent);
  var
    NextParent: TComponent;
  begin
    if (csDesigning in Sender.ComponentState) and
      not (csUpdating in Sender.ComponentState) then
    begin
      NextParent := Sender;
      while Assigned(NextParent) and not (NextParent is TCustomForm) do
        NextParent := NextParent.Owner;
      if Assigned(NextParent) and  Assigned(TCustomForm(NextParent).Designer) then
      begin
        TCustomForm(NextParent).Designer.Modified;
      end;
    end;
  end;
{$ENDIF}

{ TDCCustomLabel }

procedure TDCCustomLabel.AdjustBounds;
 var
  P: TPoint;
begin
  if AutoSize then
  begin
    Canvas.Brush.Color := Self.Color;
    Canvas.Font.Assign(Self.Font);
    P := DrawHighLightText(Canvas, PChar(Caption), Rect(0,0,ClientWidth, ClientHeight), 0,
          DT_END_ELLIPSIS, FImages);
    SetBounds(Left, Top, P.X, P.Y);
  end;
end;

procedure TDCCustomLabel.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  if Assigned(FOnMouseEnter) then FOnMouseEnter(Self);
end;

procedure TDCCustomLabel.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  if Assigned(FOnMouseLeave) then FOnMouseLeave(Self);
end;

constructor TDCCustomLabel.Create(AOwner: TComponent);
begin
  inherited;
  AutoSize := False;
  ControlStyle := ControlStyle + [csOpaque];
  FImageChangeLink :=  TChangeLink.Create;
  FImageChangeLink.OnChange := ImageListChange;
end;

destructor TDCCustomLabel.Destroy;
begin
  FImageChangeLink.Free;
  inherited;
end;

function TDCCustomLabel.GetCaption: string;
begin
  Result := inherited Caption;
end;

function TDCCustomLabel.GetDBObject: TDCDBObject;
begin
  Result := FDBObject;
end;

procedure TDCCustomLabel.ImageListChange(Sender: TObject);
begin
  Invalidate;
end;

procedure TDCCustomLabel.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) then
  begin
    if (AComponent = FImages) then
    begin
      FImages := nil;
      Invalidate;
      Exit;
    end;
  end;
end;

procedure TDCCustomLabel.Paint;
 var
  R: TRect;
  P: TPoint;

  procedure DoDrawText(ACanvas: TCanvas; ARect: TRect; AText: string);
  begin
    if not Enabled then
    begin
      OffsetRect(ARect, 1, 1);
      ACanvas.Font.Color := clBtnHighlight;
      DrawHighLightText(ACanvas, PChar(AText), ARect, 1, DT_END_ELLIPSIS,
        FImages);
      OffsetRect(ARect, -1, -1);
      ACanvas.Font.Color := clBtnShadow;
      DrawHighLightText(ACanvas, PChar(AText), ARect, 1, DT_END_ELLIPSIS,
        FImages);
    end
    else
      DrawHighLightText(ACanvas, PChar(AText), ARect, 1, DT_END_ELLIPSIS,
        FImages);
  end;

  procedure DoDraw(ACanvas: TCanvas);
  begin
    with ACanvas do
    begin
      Font := Self.Font;
      Brush.Color := Self.Color;
      if Transparent then
        SetBkMode(Handle, Windows.TRANSPARENT)
      else begin
        SetBkMode(Handle, Windows.OPAQUE);
        Brush.Style := bsSolid;
        FillRect(R);
      end;
    end;
    case Alignment of
      taCenter      :
        begin
          P := DrawHighLightText(ACanvas, PChar(Caption), R, 0, DT_END_ELLIPSIS,
            FImages);
          R.Left  := (ClientWidth - P.X) shr 1;
          R.Right := R.Left + P.X;
          DoDrawText(ACanvas, R, Caption);
        end;
      taLeftJustify :
         DoDrawText(ACanvas, R, Caption);
      taRightJustify:
        begin
          P := DrawHighLightText(ACanvas, PChar(Caption), R, 0, DT_END_ELLIPSIS,
            FImages);
          R.Left  := ClientWidth - P.X;
          R.Right := R.Left + P.X;
          DoDrawText(ACanvas, R, Caption);
        end;
    end;
  end;

begin
  R := Rect(0, 0, ClientWidth, ClientHeight);
  DoDraw(Canvas);
end;

procedure TDCCustomLabel.SetCaption(const Value: string);
begin
  inherited Caption := Value;
end;

procedure TDCCustomLabel.SetDBObject(const Value: TDCDBObject);
begin
  FDBObject.Assign(Value);
end;

procedure TDCCustomLabel.SetImages(const Value: TImageList);
begin
  if Images <> nil then
    Images.UnRegisterChanges(FImageChangeLink);
  FImages := Value;
  if Images <> nil then
  begin
    Images.RegisterChanges(FImageChangeLink);
    Images.FreeNotification(Self);
  end;
  invalidate;
end;

procedure TDCCustomLabel.WMEraseBkGnd(var Message: TWMEraseBkGnd);
begin
  Message.Result := 0;
end;

{ TDCCustomPanel }

procedure TDCCustomPanel.ChangeBrush(Sender: TObject);
begin
  Invalidate;
end;

procedure TDCCustomPanel.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  if Assigned(FOnMouseEnter) then FOnMouseEnter(Self);
end;

procedure TDCCustomPanel.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  if Assigned(FOnMouseLeave) then FOnMouseLeave(Self);
end;

constructor TDCCustomPanel.Create(AOwner: TComponent);
begin
  inherited;
  FBrushImage := TDCBrushImage.Create(Self);
  FBrushImage.OnChange := ChangeBrush;
  FVertCentered  := True;
  FMargins:= Rect(0, 0, 0, 0);
  FImageChangeLink :=  TChangeLink.Create;
  FImageChangeLink.OnChange := ImageListChange;
end;

destructor TDCCustomPanel.Destroy;
begin
  FBrushImage.Free;
  FImageChangeLink.Free;
  inherited;
end;

function TDCCustomPanel.GetCaption: string;
begin
  Result := inherited Caption;
end;

function TDCCustomPanel.GetRectOffset: TRect;
begin
  Result := FMargins;
end;

procedure TDCCustomPanel.ImageListChange(Sender: TObject);
begin
  Invalidate;
end;

procedure TDCCustomPanel.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) then
  begin
    if (AComponent = FImages) then
    begin
      FImages := nil;
      Invalidate;
      Exit;
    end;
    if (AComponent = BrushImage.Images) then
    begin
      BrushImage.Images := nil;
      Exit;
    end;
  end;
end;

procedure TDCCustomPanel.Paint;
 var
  Offset, Rect: TRect;
  TopColor, BottomColor: TColor;
  P: TPoint;

  procedure AdjustColors(Bevel: TPanelBevel);
  begin
    if Bevel = bvLowered then TopColor := clBtnShadow
    else TopColor := clBtnHighlight;
    if Bevel = bvLowered then BottomColor := clBtnHighlight
    else BottomColor := clBtnShadow;
  end;

begin
  CreateDrawBitmap;
  Rect := GetClientRect;
  with DrawBitmap do
  begin
    Height := Rect.Bottom-Rect.Top;
    Width  := Rect.Right-Rect.Left;
    if BevelOuter <> bvNone then
    begin
      AdjustColors(BevelOuter);
      Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
    end;
    Frame3D(Canvas, Rect, Color, Color, BorderWidth);
    if BevelInner <> bvNone then
    begin
      AdjustColors(BevelInner);
      Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
    end;
    with Canvas do
    begin
      Brush.Style := bsSolid;
      Brush.Color := Color;
      if not FBrushImage.Empty then
        FBrushImage.Draw(Canvas, Rect, Rect)
      else
        FillRect(Rect);
      SetBkMode(Handle, Integer(TRANSPARENT));
      Font := Self.Font;
    end;
    Offset := GetRectOffset;
    InflateRect(Rect, -1, 0);
    Rect.Left   := Rect.Left   + Offset.Left;
    Rect.Top    := Rect.Top    + Offset.Top;
    Rect.Right  := Rect.Right  - Offset.Right;
    Rect.Bottom := Rect.Bottom - Offset.Bottom;

    P := Point(0,0);

    if FVertCentered then
    begin
      P := DrawHighLightText(Canvas, PChar(Caption), Rect, 0, DT_END_ELLIPSIS,
        FImages);
      Rect.Top := (ClientHeight - P.Y) div 2;
    end;

    case Alignment of
      taCenter      :
        begin
          if (P.X=0) and (P.Y=0) then
             P := DrawHighLightText(Canvas, PChar(Caption), Rect, 0,
               DT_END_ELLIPSIS, FImages);
          if P.X < (ClientWidth-Offset.Left-Offset.Right) then
          begin
            Rect.Left  := Offset.Left+((ClientWidth-Offset.Left-Offset.Right-P.X) div 2);
            Rect.Right := Rect.Left + P.X;
          end;
          DrawHighLightText(Canvas, PChar(Caption), Rect, 1, DT_END_ELLIPSIS,
            FImages);
        end;
      taLeftJustify :
        DrawHighLightText(Canvas, PChar(Caption), Rect, 1, DT_END_ELLIPSIS,
          FImages);
      taRightJustify:
        begin
          if (P.X=0) and (P.Y=0) then
             P := DrawHighLightText(Canvas, PChar(Caption), Rect, 0,
               DT_END_ELLIPSIS, FImages);
          Rect.Right := ClientWidth - Offset.Right;
          Rect.Left  := Offset.Left + Rect.Right - P.X;
          if Rect.Left < Offset.Left then Rect.Left := Offset.Left;
          DrawHighLightText(Canvas, PChar(Caption), Rect, 1, DT_END_ELLIPSIS,
            FImages);
        end;
    end;
  end;
  Canvas.Draw(0, 0, DrawBitmap);
  ReleaseDrawBitmap;
end;

procedure TDCCustomPanel.SetBrushImage(const Value: TDCBrushImage);
begin
  FBrushImage.Assign(Value);
end;

procedure TDCCustomPanel.SetCaption(const Value: string);
begin
  inherited Caption := Value;
end;

procedure TDCCustomPanel.SetImages(const Value: TImageList);
begin
  if Images <> nil then
    Images.UnRegisterChanges(FImageChangeLink);
  FImages := Value;
  if Images <> nil then
  begin
    Images.RegisterChanges(FImageChangeLink);
    Images.FreeNotification(Self);
  end;
  invalidate;
end;

procedure TDCCustomPanel.SetMargins(Left, Top, Right, Bottom: integer);
begin
  if Left   > 0 then FMargins.Left  := Left;
  if Top    > 0 then FMargins.Top   := Top;
  if Right  > 0 then FMargins.Right := Right;
  if Bottom > 0 then FMargins.Bottom:= Bottom;
  Invalidate;
end;

procedure TDCCustomPanel.SetVertCentered(const Value: boolean);
begin
  FVertCentered := Value;
  Invalidate;
end;

procedure TDCCustomPanel.WMEraseBkGnd(var Message: TWMEraseBkGnd);
begin
  Message.Result := 0;
end;

{ TDCCustomHeaderPanel }

procedure TDCCustomHeaderPanel.AddCloseButton;
 var
  Button: TDCEditButton;
begin
  Button := FButtons.AddButton;
  with FButtons, Button do
  begin
    Name := SBC_BUTTONCLOSE;
    Alignment := abCenter;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNCLOSE');
    Font := Self.Font;
    SetButtonStyle(Button, FDrawingStyle);
    AbsolutePos := False;
    DisableStyle := deNormal;
    BrushColor := Color;
    DrawText := False;
    Tag := SBN_BUTTONCLOSE;
    OnClick := CloseButtonClick;
    if FButtonAllign then
    begin
      SetBounds(Rect(Self.Width - (CM_CXCLOSEBUTTON + 2),
        (Self.Height - CM_CYCLOSEBUTTON) div 2, CM_CXCLOSEBUTTON,
        CM_CYCLOSEBUTTON));
      AnchorStyle  := asCnR;
    end
    else begin
      SetBounds(Rect(Self.Width - (CM_CXCLOSEBUTTON + 2), 2, CM_CXCLOSEBUTTON,
        CM_CYCLOSEBUTTON));
      AnchorStyle  := asTR;
    end;
  end;
end;

procedure TDCCustomHeaderPanel.CloseButtonClick(Sender: TObject);
begin
  if Assigned(FOnCloseButtonClick) then FOnCloseButtonClick(Self)
end;

procedure TDCCustomHeaderPanel.CMCancelMode(var Message: TCMCancelMode);
  var
   Pos: TPoint;
   Button: TDCEditButton;
begin
  if Message.Sender = Self then
  begin
    GetCursorPos(Pos);
    with FButtons do
      if not MouseInButtonArea(Pos.X, Pos.Y, Button) then ResetProperties;
  end
  else
    FButtons.ResetProperties;
  inherited;
end;

procedure TDCCustomHeaderPanel.CMColorChanged(var Message: TMessage);
begin
  inherited;
  if Assigned(FButtons) then
  begin
    FButtons.Color := Color;
    if HandleAllocated then
    begin
      FillNCArea;
      FButtons.Invalidate;
    end;
  end;
end;

procedure TDCCustomHeaderPanel.CMDialogChar(var Message: TCMDialogChar);
 var
  Button: TDCEditButton;
begin
  with Message do
  begin
    if Buttons.IsButtonAccel(Message.CharCode, Button) then
    begin
      Result := 1;
      Button.Click;
    end
    else
      inherited;
  end;    
end;

procedure TDCCustomHeaderPanel.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  FButtons.MouseDown := GetAsyncKeyState(VK_LBUTTON)<0;
end;

procedure TDCCustomHeaderPanel.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  FButtons.UpdateButtons( -1, -1, False, True);
end;

constructor TDCCustomHeaderPanel.Create(AOwner: TComponent);
begin
  inherited;
  FButtons := TDCEditButtons.Create(Self);
  FButtons.AnchorStyle := asNone;
  FClosed  := True;

  Height   := CM_CYCLOSEBUTTON + 4;
  Align    := alTop;
  Color    := clBtnShadow;
  Alignment:= taLeftJustify;

  BorderWidth:= 2;
  BevelOuter := bvNone;

  FButtons.Color := Color;
  FDrawingStyle := dtFlat;
end;

procedure TDCCustomHeaderPanel.CreateWnd;
begin
  inherited;
  if Parent <> nil then
  begin
    FButtons.ClrWndProc;
    FButtons.SetWndProc;
    if FClosed then begin
      AddCloseButton;
      MoveWindow(Handle, Left, Top, Width, Height, False);
    end;
  end;
end;

procedure TDCCustomHeaderPanel.DelCloseButton;
 var
  CloseButton: TDCEditButton;
begin
  CloseButton := FButtons.FindButton(SBC_BUTTONCLOSE);
  if Assigned(CloseButton) then FButtons.DeleteButton(CloseButton.Index);
end;

destructor TDCCustomHeaderPanel.Destroy;
begin
  FButtons.Free;
  inherited;
end;

procedure TDCCustomHeaderPanel.FillNCArea;
 var
  DC: HDC;
  R: TRect;
  ABrush: HBRUSH;
begin
  if CloseButtonExist then
  begin
    DC := GetWindowDC(Handle);
    try
      GetWindowRect (Handle, R);  OffsetRect (R, -R.Left, -R.Top);
      R.Left := R.Right - CM_CXCLOSEBUTTON - 4;
      ABrush := CreateSolidBrush(ColorToRGB(Color));
      FillRect(DC, R, ABrush);
      DeleteObject(ABrush);
    finally
      ReleaseDC(Handle, DC);
    end;
  end;
end;

function TDCCustomHeaderPanel.GetRectOffset: TRect;
begin
  Result := inherited GetRectOffset;
end;

procedure TDCCustomHeaderPanel.Paint;
begin
  FButtons.UpdateDeviceRegion(Canvas.Handle);
  inherited;
end;

procedure TDCCustomHeaderPanel.SetButtonAllign(const Value: boolean);
begin
  if FButtonAllign <> Value then
  begin
    FButtonAllign := Value;
    if FClosed then
    begin
      SetClosed(False);
      SetClosed(True);
    end;
  end;
end;

procedure TDCCustomHeaderPanel.SetButtonStyle(Button: TDCEditButton;
  Value: TDCDrawingStyle);
begin
  case Value of
    dtNormal, dtFlat:
      Button.Style := stShadowFlat;
    dtXPStyle:
      begin
        Button.Style := stSingle;
        Button.Options := Button.Options + [boSimpleStyle, boFrame];
      end;
  end;
end;

procedure TDCCustomHeaderPanel.SetClosed(const Value: boolean);
begin
  if FClosed <> Value then
  begin
    FClosed := Value;
    if not FClosed then DelCloseButton;
    RecreateWnd;
  end;
end;

procedure TDCCustomHeaderPanel.SetDrawingStyle(
  const Value: TDCDrawingStyle);
 var
  Button: TDCEditButton;
begin
  if FDrawingStyle <> Value then
  begin
    FDrawingStyle := Value;
    Button := FButtons.FindButton(SBC_BUTTONCLOSE);
    if Button <> nil then SetButtonStyle(Button, FDrawingStyle);
    if HandleAllocated then Button.Invalidate;
  end;
end;

procedure TDCCustomHeaderPanel.WMKillFocus(var Message: TWMKillFocus);
begin
  FButtons.ResetProperties;
  inherited;
end;

procedure TDCCustomHeaderPanel.WMNCCalcSize(var Message: TWMNCCalcSize);
begin
  inherited;
  if CloseButtonExist and HandleAllocated then
  begin
    Message.CalcSize_Params^.rgrc[0].Right :=
      Message.CalcSize_Params^.rgrc[0].Right - CM_CYCLOSEBUTTON - 4
  end;
end;

procedure TDCCustomHeaderPanel.WMNCHitTest(var Message: TWMNCHitTest);
 var
  Button: TDCEditButton;
begin
  inherited;
  with Message do
  begin
    if FButtons.MouseInButtonArea(XPos - Left, YPos - Top, Button) then
      Result := HTBORDER;
  end;
end;

procedure TDCCustomHeaderPanel.WMNCPaint(var Message: TWMNCPaint);
begin
  inherited;
  FillNCArea;
end;

{ TDCCustomOutBarPanel }

function TDCCustomOutBarPanel.AddButton: TDCEditButton;
 var
  ATransparent: boolean;
begin
  Result := Buttons.AddButton;
  ATransparent := not BrushImage.Empty;
  with Result do
  begin
    case FStyle of
      isSmallImages: Alignment   := abLeft;
      isLargeImages: Alignment   := abImageTop;
    end;
    Name         := Format('%s%d',['EditButton', Index]);
    ImageIndex   := Index;
    Caption      := Name;
    Style        := stOutBar;
    Font         := Self.Font;
    BrushColor   := Self.Color;
    AbsolutePos  := False;
    Grouped      := True;
    AnchorStyle  := FAnchorStyle;
    Options := Options - [boHighlight];
    DisableStyle := deNone;

    if opDropDown in FOptions then
      EventStyle := esDropDown
    else
      EventStyle := esNormal;
    OnCheckArea  := CheckArea;
    OnClick      := ItemClick;
    SetButtonPos(Index);
    ResetOnExitControl := False;
    if ATransparent then
      Options := Options + [boTransparent]
    else
      Options := Options - [boTransparent]
  end;
end;

procedure TDCCustomOutBarPanel.ButtonsDown;
begin
  if FFirstIndex = 0 then Exit;
  FFirstIndex := FFirstIndex - 1;
  UpdateButtonsPos;
end;

procedure TDCCustomOutBarPanel.ButtonsUp;
begin
  FFirstIndex := FFirstIndex + 1;
  UpdateButtonsPos;
end;

procedure TDCCustomOutBarPanel.CheckArea(Sender: TObject; X, Y: integer;
  var Selected: boolean);
 var
  TextRect, ImageRect: TRect;
  P: TPoint;
begin
  with Sender as TDCEditButton do
  begin
    if Visible and (EventStyle <> esDropDown) then
    begin
      ImageRect := GetImageRect;
      TextRect  := GetTextRect(ImageRect);
      InflateRect(ImageRect, 2, 2);
      P := Point(ImageRect.Left, ImageRect.Right);
      if TextRect.Left  < P.X then P.X := TextRect.Left;
      if TextRect.Right > P.Y then P.Y := TextRect.Right;
      Selected := PtInRect(Rect(Left+P.X,Top,Left+P.Y,Top+Height), Point(X,Y));
    end;
  end;
  if _getFlag(FFlags, CP_TRACKTIMER) then Selected := False;
  if Selected and FNextTrack.Visible then
    Selected := not PtInRect(FNextTrack.GetBounds, Point(X,Y));
  if Selected and FPrevTrack.Visible then
    Selected := not PtInRect(FPrevTrack.GetBounds, Point(X,Y));
end;

procedure TDCCustomOutBarPanel.CheckToNextTrack;
 var
  Button: TDCEditButton;
begin
  with Buttons do
    if Count > 0 then
    begin
      Button := Buttons[Count-1];
      with Button do
      begin
        if FNextTrack.Visible then
        begin
          if ButtonVisible(Button) or TracksCovering then HideTrack(FNextTrack);
        end
        else
          if not ButtonVisible(Button) and not TracksCovering then FNextTrack.Visible := True;
      end
   end
   else HideTrack(FNextTrack);
end;

procedure TDCCustomOutBarPanel.CheckToPrevTrack;
 var 
  AFirstIndex: integer; 
begin
  if FFirstIndex > 0 then
  begin
    AFirstIndex   := FFirstIndex;
    _setFlag(FFlags, CP_UPDATELOCKED, True);
    repeat
      ButtonsDown(Self);
      if FNextTrack.Visible then
      begin
        ButtonsUp(Self);
        break;
      end;
    until (FFirstIndex = 0);
    _setFlag(FFlags, CP_UPDATELOCKED, False);
    if FFirstIndex <> AFirstIndex then invalidate;
  end;
end;

procedure TDCCustomOutBarPanel.CMCancelMode(var Message: TCMCancelMode);
begin
  FButtons.ResetProperties;
  inherited;
end;

procedure TDCCustomOutBarPanel.CMColorChanged(var Message: TMessage);
begin
  inherited;
  Buttons.Color := Color;
  if (FPageControl <> nil) and (FPageControl.HandleAllocated) then
    FPageControl.Invalidate;
  Invalidate;
end;

procedure TDCCustomOutBarPanel.CMFontChanged(var Message: TMessage);
 var
  i: integer;
begin
  inherited;
  Canvas.Font := Font;
  for i := 0 to FButtons.Count-1 do
    FButtons.Buttons[i].Font := Font;
  UpdateButtonsPos;  
end;

procedure TDCCustomOutBarPanel.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  if Assigned(FOnMouseEnter) then FOnMouseEnter(Self);
  UnHookMouseHooks;
  FButtons.MouseDown := GetAsyncKeyState(VK_LBUTTON)<0;
end;

procedure TDCCustomOutBarPanel.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  if Assigned(FOnMouseLeave) then FOnMouseLeave(Self);

  FButtons.UpdateButtons( -1, -1, False, True);
  if FButtons.IsButtonsActive then HookMouseHooks(FButtons);

  UpdateTracksState(-1, -1, True);
end;

constructor TDCCustomOutBarPanel.Create(AOwner: TComponent);
begin
  inherited;
  FButtons := TDCEditButtons.Create(Self);
  FButtons.OnGetRegion := GetButtonsRegion;
  Buttons.Options := Buttons.Options - [boNCPainting, boDrawButtons];

  ControlStyle := [csCaptureMouse, csClickEvents, csDoubleClicks, 
    csReplicatable];
  Width := 80;
  Height := 150;

  _setFlag(FFlags, CP_MOUSEDOWN, False);
  _setFlag(FFlags, CP_TRACKTIMER, False);
  _setFlag(FFlags, CP_UPDATELOCKED, False);
  _setFlag(FFlags, OP_FREEZESTATE, False);

  FFirstIndex := 0;
  FStyle := isLargeImages;
  FAnchorStyle:= asTLR;

  DoubleBuffered := True;

  CreateTracks;
  FImageChangeLink :=  TChangeLink.Create;
  FImageChangeLink.OnChange := ImageListChange;

  FHintObject := nil;
  BorderWidth := 0;
end;

procedure TDCCustomOutBarPanel.CreateTracks;
begin
  FPrevTrack:= TDCEditButton.Create(Self);
  with FPrevTrack do
  begin
    Visible := False;
    Width   := 15;
    Height  := 13;
    DrawText:= False;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNUP');
    BrushColor := clBtnFace;
    Options := Options + [boSimpleStyle, boFrame, boFrameInRest];
    OnClick := ButtonsDown;
  end;

  FNextTrack:= TDCEditButton.Create(Self);
  with FNextTrack do
  begin
    Visible := False;
    Width   := 15;
    Height  := 13;
    DrawText:= False;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNDOWN');
    BrushColor := clBtnFace;
    Options := Options + [boSimpleStyle, boFrame, boFrameInRest];
    OnClick := ButtonsUp;
  end;
end;

procedure TDCCustomOutBarPanel.CreateWnd;
begin
  inherited;
  if Parent <> nil then begin
    FButtons.ClrWndProc;
    FButtons.SetWndProc;
  end;
end;

procedure TDCCustomOutBarPanel.DeleteButton(Index: integer);
begin

end;

destructor TDCCustomOutBarPanel.Destroy;
begin
  if Assigned(FPrevTrack) then
  begin
    FPrevTrack.Free;
    FPrevTrack := nil;
  end;
  if Assigned(FNextTrack) then
  begin
    FNextTrack.Free;
    FNextTrack := nil;
  end;
  FButtons.Free;
  FImageChangeLink.Free;
  inherited;
end;

procedure TDCCustomOutBarPanel.DrawButtonHint(Sender: TObject; Mode: integer);
begin
  if Application <> nil then
  begin
    Application.CancelHint;
  end;
  case Mode of
    0:{Show}
      FHintObject := Sender;
    1:{Hide}
      FHintObject := nil;
  end;
end;

function TDCCustomOutBarPanel.FormatText(const Value: string;
  Offset, ClientWidth: integer; var TextSize: TPoint): string;
 var
  SpacePos, AWidth: integer;
  ASize: TPoint;
  AText, BText, BResult: string;
  pValue: PChar;
  Size: TSize;
begin

  pValue := PChar(Value);
  Result := '';
  while pValue^ <> #0 do
  begin
    if pValue^ <> #10 then
      Result := Result + pValue^
    else begin
      if ((pValue+1)^ <> #0) and ((pValue+1)^ <> ' ') then
        Result := Result +  ' ';
    end;
    Inc(pValue);
  end;

  GetTextExtentPoint32(Canvas.Handle, PChar(Result), Length(Result), Size);
  Move(Size, TextSize, Sizeof(TextSize));

  AWidth := ClientWidth - (BT_MARGINS + Offset + 3)*2;
  if (Style = isLargeImages) and (TextSize.X > AWidth) then
  begin
    SpacePos := Pos(' ', Result);
    if SpacePos > 0 then
    begin
      ASize := Point(0, 0);
      BText := '';
      repeat
        if BText = '' then
        begin
          BText   := Copy(Result, 1, SpacePos-1);
          BResult := Copy(Result, SpacePos+1, Length(Result)-SpacePos);
          AText   := BText;
          Result  := BResult;
        end
        else begin
          BText   := AText;
          BResult := Result;
          AText   := BText + ' ' + Copy(Result, 1, SpacePos-1);
          Result  := Copy(Result, SpacePos+1, Length(Result)-SpacePos);
        end;
        GetTextExtentPoint32(Canvas.Handle, PChar(AText), Length(AText), Size);
        Move(Size, ASize, Sizeof(TextSize));
        SpacePos := Pos(' ', Result);
      until (SpacePos = 0) or (ASize.X > AWidth );

      Result := Format('%s'#10'%s', [BText, BResult]);
      GetTextExtentPoint32(Canvas.Handle, PChar(Result), Length(Result), Size);
      Move(Size, TextSize, Sizeof(TextSize));
    end;
  end;
end;

function TDCCustomOutBarPanel.GetActiveButton: TDCEditButton;
begin
  Result := FButtons.ActiveButton;
end;

procedure TDCCustomOutBarPanel.GetButtonsRegion(Sender: TObject;
  var Rgn: HRGN);
 var
  Rgn1: HRGN;
begin
  with ClientRect do
    if csDesigning in ComponentState then
      Rgn := CreateRectRgn(1, 1, ClientWidth - 1, ClientHeight - 1)
    else
      Rgn := CreateRectRgn(0, 0, ClientWidth - 1, ClientHeight);

  if FPrevTrack.Visible then
    with FPrevTrack do
    begin
      Rgn1 := CreateRectRgn(Left, Top, Left + Width, Top + Height);
      CombineRgn(Rgn, Rgn, Rgn1, RGN_DIFF);
      DeleteObject(Rgn1);
    end;

  if FNextTrack.Visible then
    with FNextTrack do
    begin
      Rgn1 := CreateRectRgn(Left, Top, Left + Width, Top + Height);
      CombineRgn(Rgn, Rgn, Rgn1, RGN_DIFF);
      DeleteObject(Rgn1);
    end;

end;

function TDCCustomOutBarPanel.GetPopupMenu: TPopupMenu;
begin
  if (ActiveButton <> nil) and Assigned(FOnGetItemPopup) then
    FOnGetItemPopup(Self, ActiveButton, Result)
  else
    Result := inherited GetPopupMenu;
end;

procedure TDCCustomOutBarPanel.HideTrack(Track: TDCEditButton);
begin
  Track.Visible := False;
  if _getFlag(FFlags, CP_TRACKTIMER) then KillTimer(Handle, PNLTIMER_IDEVENT);
end;

procedure TDCCustomOutBarPanel.ItemClick(Sender: TObject);
 var
  i: integer;
begin
  if (opDropDown in FOptions) and (ActiveButton <> nil) then
  with Items do
  begin
    for i := 0 to Count-1 do
      if (Buttons[i].ButtonState <> btRest) and
       (Buttons[i].Grouped) and (Buttons[i].Index <> ActiveButton.Index) then
      begin
        Buttons[i].ButtonState := btRest;
        Buttons[i].Invalidate;
      end;
  end;
  if Assigned(FOnItemClick) then FOnItemClick(Sender);
end;

procedure TDCCustomOutBarPanel.Loaded;
 var
  i: integer;
  ATransparent: boolean;
begin
  inherited;
  ATransparent := not BrushImage.Empty;
  for i:= 0 to Items.Count-1 do
  with Items.Buttons[i] do
  begin
    OnClick := ItemClick;
    OnCheckArea:= CheckArea;
    OnSetButtonState := SetButtonState;
    OnDrawHint := DrawButtonHint;
    DownClick := True;
    Font := Self.Font;
    Options := Options - [boHighlight];
    if ATransparent then
      Options := Options + [boTransparent]
    else
      Options := Options - [boTransparent]
  end;
end;

procedure TDCCustomOutBarPanel.Paint;
 var
  Index: integer;
  DC: HDC;

  procedure ExcludeTracks(DC: HDC);
  begin
    if FPrevTrack.Visible then
      with FPrevTrack do
         ExcludeClipRect(DC, Left, Top, Left + Width, Top + Height);
    if FNextTrack.Visible then
      with FNextTrack do
         ExcludeClipRect(DC, Left, Top, Left + Width, Top + Height);
  end;

begin
  with Canvas do
  begin
    DC := Handle;
    Index := SaveDC(DC);
    Brush.Color := ColorToRGB(Color);
    Brush.Style := bsSolid;
    PaintTracks(DC);

    FButtons.UpdateDeviceRegion(DC);
    ExcludeTracks(DC);

    if not BrushImage.Empty then
      BrushImage.Draw(Canvas, ClientRect, ClientRect)
    else
      FillRect(ClientRect);

    if csDesigning in ComponentState then
    begin
      Brush.Color := Color;
      Pen.Color   := clNavy;
      Pen.Style   := psDot;
      PolyLine([Point(0, 0), Point(0, ClientHeight - 1),
        Point(ClientWidth - 1, ClientHeight - 1), Point(ClientWidth - 1, 0),
        Point(0,0)]);
    end;

    RestoreDC(DC, Index);
    ExcludeTracks(DC);

    FButtons.SaveBackground(DC);
    FButtons.RepaintButtons(dsDrawAll, DC);
  end;
end;

procedure TDCCustomOutBarPanel.PaintTracks(DrawContext: HDC);
begin
  if FPrevTrack.Visible then FPrevTrack.Paint(DrawContext);
  if FNextTrack.Visible then FNextTrack.Paint(DrawContext);
end;

procedure TDCCustomOutBarPanel.SelectItem(Button: TDCEditButton);
  procedure ClearButtonsState;
   var
    AButton: TDCEditButton;
    P: TPoint;
    i: integer;
  begin
    if (opDropDown in FOptions) then
      for i:= 0 to FButtons.Count -1 do
      begin
        AButton :=  FButtons.Buttons[i];
        if AButton.ButtonState = btDownMouseInRect then
        begin
          GetCursorPos(P);
          P := ScreenToClient(P);
          _setFlag(FFlags, OP_FREEZESTATE, True);
          if AButton.MouseInRect(P.X, P.Y) then
            AButton.ButtonState := btRestMouseInRect
          else
            AButton.ButtonState := btRest;
          AButton.Invalidate;
          _setFlag(FFlags, OP_FREEZESTATE, False);
          Break;
        end;
      end;
  end;
begin
  if Assigned(Button) then
  begin
    ClearButtonsState;
    if (opDropDown in FOptions) then
    begin
      Button.ButtonState := btDownMouseInRect;
      if Button.DownClick then Button.DownButton := True;
      Button.Invalidate;
    end;
    Button.Click;
  end
  else
    ClearButtonsState;
end;

procedure TDCCustomOutBarPanel.SetButtonPos(Index: integer);
 var
  TextSize, Pos: TPoint;
  Button: TDCEditButton;
  AHeight: integer;
begin
  Button := Buttons.Buttons[Index];
  Pos.X  := 2;

  Button.Text := FormatText(Button.Text, Pos.X, ClientWidth, TextSize);

  case FStyle of
   isLargeImages:
     AHeight := Button.GetGlyphHeight + TextSize.Y + 6;
   isSmallImages:
     AHeight := _intMax(TextSize.Y, Button.GetGlyphHeight) + 4
   else
      AHeight := 0;
  end;

  Pos.Y := 1;
  if (opItemMove in FOptions) then Inc(Pos.Y);
  if (opDropDown in FOptions) then Inc(AHeight, 4);

  Button.Left  := Pos.X;
  Button.Height:= AHeight;
  Button.Width := Width - Pos.X*2;
  if Index < FFirstIndex then
  begin
    Button.Top := 0;
    Button.Height := 0;
    if not FPrevTrack.Visible then FPrevTrack.Visible := True;
  end
  else begin
    Button.Top := Pos.Y;
    if (Index > 0) then
      with Buttons.Buttons[Index-1] do Button.Top := Button.Top + Top + Height;
  end;
end;

procedure TDCCustomOutBarPanel.SetButtonState(Sender: TObject;
  var State: TButtonState);
begin
  if not _getFlag(FFlags, OP_FREEZESTATE) and (opDropDown in FOptions) and
    (ActiveButton <> nil) and (ActiveButton.ButtonState = btDownMouseInRect) and
    (ActiveButton.Name = TDCEditButton(Sender).Name) then
   State := btDownMouseInRect;
end;

procedure TDCCustomOutBarPanel.SetDropDown(const Value: boolean);
 var
  i: integer;
begin
  for i := 0 to FButtons.Count-1 do
  begin
    if Value then
      FButtons.Items[i].EventStyle := esDropDown
    else
      FButtons.Items[i].EventStyle := esNormal;
  end;
end;

procedure TDCCustomOutBarPanel.SetFirstIndex(const Value: integer);
 var
  AOffset: integer;
begin
  if FFirstIndex <> Value then
  begin
    AOffset := (Value - FFirstIndex) div abs(Value - FFirstIndex);
    while FFirstIndex <> Value do
    begin
      if AOffset > 0 then
         ButtonsUp(Self)
      else
         ButtonsDown(Self);
    end;
  end;
end;

procedure TDCCustomOutBarPanel.SetLargeImages(const Value: TImageList);
begin
  if FLargeImages <> nil then FLargeImages.UnRegisterChanges(FImageChangeLink);
  FLargeImages := Value;
  if FLargeImages <> nil then
  begin
    FLargeImages.RegisterChanges(FImageChangeLink);
    FLargeImages.FreeNotification(Self);
  end;
  if FStyle = isLargeImages then Buttons.Images := Value;
  UpdateButtonsPos;
  UpdateTracksPos;
end;

procedure TDCCustomOutBarPanel.SetOptions(const Value: TOutPanelOptions);
 var
  ChangedOptions: TOutPanelOptions;
begin
  if FOptions <> Value then
  begin
    ChangedOptions := (FOptions + Value) - (FOptions * Value);
    FOptions := Value;
    if opDropDown in ChangedOptions then
    begin
      SetDropDown(opDropDown in Value);
      UpdateButtonsPos;
      UpdateTracksPos;
    end;
    if opFlatTracks in ChangedOptions then
      UpdateTracksStyle;
  end;
end;

procedure TDCCustomOutBarPanel.SetSmallImages(const Value: TImageList);
begin
  if FSmallImages <> nil then FSmallImages.UnRegisterChanges(FImageChangeLink);
  FSmallImages := Value;
  if FSmallImages <> nil then
  begin
    FSmallImages.RegisterChanges(FImageChangeLink);
    FSmallImages.FreeNotification(Self);
  end;
  if FStyle = isSmallImages then Buttons.Images := Value;
  UpdateButtonsPos;
  UpdateTracksPos;
end;

procedure TDCCustomOutBarPanel.SetStyle(const Value: TImagesStyle);
 var
  i: integer;
  Button: TDCEditButton;
begin
  FStyle := Value;
  case FStyle of
    isSmallImages:
      begin
        Buttons.Images := FSmallImages;
        Buttons.Options := Buttons.Options + [boNCPainting];
        if FSmallImages <> nil then
        begin
          FSmallImages.UnRegisterChanges(FImageChangeLink);
          FSmallImages.RegisterChanges(FImageChangeLink);
        end;
      end;
    isLargeImages:
      begin
        Buttons.Images := FLargeImages;
        Buttons.Options := Buttons.Options - [boNCPainting];
        if FLargeImages <> nil then
        begin
          FLargeImages.UnRegisterChanges(FImageChangeLink);
          FLargeImages.RegisterChanges(FImageChangeLink);
        end;
      end;
  end;
  for i := 0 to FButtons.Count-1 do
  begin
    Button := Buttons.Buttons[i];
    with Button do
      case FStyle of
        isSmallImages: Alignment := abLeft;
        isLargeImages: Alignment := abImageTop;
      end;
  end;
  UpdateButtonsPos;
end;

function TDCCustomOutBarPanel.TracksCovering: boolean;
begin
  if FPrevTrack.Visible and
    (FNextTrack.Top < (FPrevTrack.Top + FPrevTrack.Height)) then
    Result := True
  else
    Result := False;
end;

procedure TDCCustomOutBarPanel.UpdateButtonsPos;
 var
  i: integer;
  Button: TDCEditButton;
begin
  if not HandleAllocated then Exit;
  if (FFirstIndex = 0) and FPrevTrack.Visible then HideTrack(FPrevTrack);
  if not _getFlag(FFlags, CP_UPDATELOCKED) then Invalidate;
  with Buttons do
    if Count > 0 then
    begin
      BeginUpdate;
      for i := 0 to Count-1 do
      begin
        Button := Buttons[i];
        SetButtonPos(Button.Index);
      end;
      EndUpdate;
      CheckToNextTrack;
    end
    else
      if FNextTrack.Visible then HideTrack(FNextTrack);
end;

procedure TDCCustomOutBarPanel.UpdateTracksPos;
 var
  lVisible: boolean;
begin
  lVisible := False;
  with FPrevTrack do
  begin
    if Visible then
    begin
      Visible := False;
      lVisible := True;
    end;
    Left := ClientRect.Right - Width - 1;
    Top  := ClientRect.Top + 1;
    if lVisible then
    begin
      Visible := True;
      lVisible := False;
    end;
  end;

  with FNextTrack do
  begin
    if Visible then
    begin
      Visible := False;
      lVisible := True;
    end;
    Left := ClientRect.Right - Width - 1;
    Top  := ClientRect.Bottom - Height - 1;
    if lVisible and not TracksCovering then Visible := True;
  end;
end;

procedure TDCCustomOutBarPanel.UpdateTracksState(X, Y: integer;
  lMove: boolean);
begin
  FPrevTrack.UpdateButtonState(X, Y, _getFlag(FFlags, CP_MOUSEDOWN), lMove);
  FNextTrack.UpdateButtonState(X, Y, _getFlag(FFlags, CP_MOUSEDOWN), lMove);
end;

procedure TDCCustomOutBarPanel.WMKillFocus(var Message: TWMKillFocus);
begin
  FButtons.ResetProperties;
  inherited;
end;

procedure TDCCustomOutBarPanel.WMLButtonDblClk(var Message: TWMLButtonDown);
begin
  inherited;
  _setFlag(FFlags, CP_MOUSEDOWN, True);
  UpdateTracksState(Message.Pos.X, Message.Pos.Y, False);

  if (FPrevTrack.ButtonState = btDownMouseInRect) or
     (FNextTrack.ButtonState = btDownMouseInRect) then
   SetTimer(Handle, PNLTIMER_IDEVENT, 200, nil);
end;

procedure TDCCustomOutBarPanel.WMLButtonDown(var Message: TWMLButtonDown);
begin
  inherited;
  _setFlag(FFlags, CP_MOUSEDOWN, True);
  UpdateTracksState(Message.Pos.X, Message.Pos.Y, False);

  if (FPrevTrack.ButtonState = btDownMouseInRect) or
     (FNextTrack.ButtonState = btDownMouseInRect) then
   SetTimer(Handle, PNLTIMER_IDEVENT, 200, nil);
end;

procedure TDCCustomOutBarPanel.WMLButtonUp(var Message: TWMLButtonUp);
begin
  inherited;
  _setFlag(FFlags, CP_MOUSEDOWN, False);
  UpdateTracksState(Message.Pos.X, Message.Pos.Y, False);

  KillTimer(Handle, PNLTIMER_IDEVENT);
  _setFlag(FFlags, CP_TRACKTIMER, False);
end;

procedure TDCCustomOutBarPanel.WMMouseMove(var Message: TWMMouseMove);
begin
  inherited;
  UpdateTracksState(Message.Pos.X, Message.Pos.Y, True);
end;

procedure TDCCustomOutBarPanel.WMSize(var Message: TWMSize);
begin
  inherited;
  if not _getFlag(FFlags, CP_REMOVING) then
  begin
    {if Style = isLargeImages then }UpdateButtonsPos;
    CheckToNextTrack;
    if not FNextTrack.Visible then CheckToPrevTrack;
    UpdateTracksPos;
  end;
end;

procedure TDCCustomOutBarPanel.WMTimer(var Message: TWMTimer);
begin
  _setFlag(FFlags, CP_TRACKTIMER, True);
  if FNextTrack.ButtonState = btDownMouseInRect then ButtonsUp(Self);
  if FPrevTrack.ButtonState = btDownMouseInRect then ButtonsDown(Self);
end;

procedure TDCCustomOutBarPanel.SetActiveButton(Value: TDCEditButton);
begin
  SelectItem(Value);
end;

function TDCCustomOutBarPanel.ButtonVisible(Button: TDCEditButton): boolean;
begin
  with Button do Result := (Top + Height) <= Self.Height;
end;

procedure TDCCustomOutBarPanel.ImageListChange(Sender: TObject);
begin
  Invalidate;
  if not _getFlag(FFlags, CP_REMOVING) then
  begin
    UpdateButtonsPos;
    CheckToNextTrack;
    if not FNextTrack.Visible then CheckToPrevTrack;
    UpdateTracksPos;
  end;
end;

procedure TDCCustomOutBarPanel.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) then
  begin
    if (AComponent = FLargeImages) then
    begin
      FLargeImages := nil;
      Invalidate;
      Exit;
    end;
    if (AComponent = FSmallImages) then
    begin
      FSmallImages := nil;
      Invalidate;
      Exit;
    end;
  end;
end;

procedure TDCCustomOutBarPanel.CMHintShow(var Message: TCMHintShow);
begin
  if FHintObject <> nil then
  begin
    with Message, TDCEditButton(FHintObject) do
    begin
      HintInfo.HintStr := GetShortHint(Hint);
      HintInfo.ReshowTimeout := $7FFFFFFF;
      Result := 0;
    end;
  end
  else
   inherited;
end;

function TDCCustomOutBarPanel.DoMouseWheelDown(Shift: TShiftState;
  MousePos: TPoint): Boolean;
begin
  Result := inherited DoMouseWheelDown(Shift, MousePos);
end;

function TDCCustomOutBarPanel.GetItemIndex: integer;
 var
  i: integer;
begin
  Result := -1;
  if ActiveButton <> nil then
  begin
    for i := 0 to FButtons.Count - 1 do
      if FButtons.Buttons[i] = ActiveButton then
      begin
        Result := i;
        Break;
      end;
  end;
end;

procedure TDCCustomOutBarPanel.SetItemIndex(const Value: integer);
begin
  if (Value < FButtons.Count) and (Value >= 0) then
    SelectItem(FButtons.Buttons[Value]);
end;

procedure TDCCustomOutBarPanel.DoBrushChanged;
 var
  i: integer;
  ATransparent: boolean;
begin
  ATransparent := not BrushImage.Empty;
  for i:= 0 to Items.Count-1 do
  begin
    if ATransparent then
      Items.Buttons[i].Options := Items.Buttons[i].Options + [boTransparent]
    else
      Items.Buttons[i].Options := Items.Buttons[i].Options - [boTransparent];
  end;
  DoubleBuffered := not BrushImage.Empty;
end;

procedure TDCCustomOutBarPanel.UpdateTracksStyle;
begin
  if opFlatTracks in Options then
  begin
    with FPrevTrack do
    begin
      BrushColor := clXPItemBackground;
      Style := stSingle;
      if Visible then Repaint;
    end;
    with FNextTrack do
    begin
      BrushColor := clXPItemBackground;
      Style := stSingle;
      if Visible then Repaint;
    end;
  end
  else begin
    with FPrevTrack do
    begin
      BrushColor := clBtnFace;
      Style := stNormal;
      if Visible then Repaint;
    end;
    with FNextTrack do
    begin
      BrushColor := clBtnFace;
      Style := stNormal;
      if Visible then Repaint;
    end;
  end;
end;

{ TDCCustomPage }

procedure TDCCustomPage.CMEnabledChanged(var Message: TMessage);
begin
  if PageControl <> nil then
  begin
    if (FPageControl.ActivePage = Self) and not Enabled and
      not (csDesigning in ComponentState)then
      FPageControl.SelectNextPage(False);
    FPageControl.UpdatePage(Self);
  end;
  inherited;
end;

procedure TDCCustomPage.CMFontChanged(var Message: TMessage);
begin
  inherited;
  if Assigned(FPageControl) and FPageVisible then FPageControl.UpdatePage(Self);
end;

procedure TDCCustomPage.CMShowingChanged(var Message: TMessage);
begin
  inherited;
  if Showing then
    DoShow
  else
    DoHide;
end;

procedure TDCCustomPage.CMTextChanged(var Message: TMessage);
begin
  inherited;
  if Assigned(FPageControl) and FPageVisible then FPageControl.UpdatePage(Self);
end;

constructor TDCCustomPage.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := [csCaptureMouse, csClickEvents, csDoubleClicks,
    csAcceptsControls];
  FPageVisible := True;

  _setFlag(FFlags, CP_REMOVING, False);
  _setFlag(FFlags, CP_FULLVISIBLE, True);

  FImageIndex  := -1;

  Align := alClient;
  BorderWidth:= 2;
end;

procedure TDCCustomPage.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  if not(csDesigning in ComponentState) then
    with Params.WindowClass do
      Style := Style and not(CS_HREDRAW or CS_VREDRAW)
end;

destructor TDCCustomPage.Destroy;
begin
  if FPageControl <> nil then  FPageControl.RemovePage(Self);
  inherited Destroy;
end;

procedure TDCCustomPage.DoHide;
begin
  if Assigned(FOnHide) then FOnHide(Self);
end;

procedure TDCCustomPage.DoShow;
begin
  if Assigned(FOnShow) then FOnShow(Self);
end;

function TDCCustomPage.GetFlagValue(Index: integer): boolean;
begin
  Result := _getFlag(FFlags, Index)
end;

function TDCCustomPage.GetPageIndex: Integer;
begin
  if FPageControl <> nil then
    Result := FPageControl.FPages.IndexOf(Self)
  else
    Result := -1;
end;

function TDCCustomPage.IsPageVisible: boolean;
begin
  Result := FPageVisible;
  if FPageControl <> nil then
    Result := Result or (csDesigning in FPageControl.ComponentState);
end;

procedure TDCCustomPage.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) then
  begin
    if (AComponent = BrushImage.Images) then
    begin
      BrushImage.Images := nil;
      Exit;
    end;
  end;
end;

procedure TDCCustomPage.Paint;
 var
  R: TRect;
begin
  with Canvas do
  begin
    R := ClientRect;
    Canvas.Brush.Color := Self.Color;
    if csDesigning in ComponentState then
    begin
      Canvas.Pen.Color   := clNavy;
      Canvas.Pen.Style   := psDot;
      Canvas.PolyLine([Point(0, 0), Point(0, ClientHeight - 1),
                       Point(ClientWidth - 1, ClientHeight - 1),
                       Point(ClientWidth - 1, 0), Point(0, 0)]);
      InflateRect(R, -1, -1);
    end;
    if not BrushImage.Empty then
      BrushImage.Draw(Canvas, R, R)
    else begin
      if not PageControl.BrushImage.Empty then
        PageControl.BrushImage.Draw(Canvas, R, R)
      else
        FillRect(R);
    end;
  end;
end;

procedure TDCCustomPage.ReadState(Reader: TReader);
begin
  inherited ReadState(Reader);
  if Reader.Parent is TDCCustomPageControl then
    PageControl := TDCCustomPageControl(Reader.Parent);
end;

procedure TDCCustomPage.SetBounds(ALeft, ATop, AWidth, AHeight: Integer);
 var
  Rgn1: HRGN;
begin
  if not(csDesigning in ComponentState) and HandleAllocated then
  begin
    Rgn1 := FBrushImage.GetImageRgn(ClientRect);
    try
      inherited;
      InvalidateRgn(Handle, Rgn1, False);
    finally
      DeleteObject(Rgn1);
    end;
  end
  else begin
    inherited;
    Invalidate;
  end;

end;

procedure TDCCustomPage.SetFlagValue(Index: integer; const Value: boolean);
begin
  _setFlag(FFlags, Index, Value);
end;

procedure TDCCustomPage.SetImageIndex(const Value: integer);
begin
  if ImageIndex <> Value then
  begin
    FImageIndex := Value;
    if FPageControl <> nil then
    begin
      FPageControl.TabsChanged;
      FPageControl.Invalidate;
    end;
  end;
end;

procedure TDCCustomPage.SetPageControl(const Value: TDCCustomPageControl);
begin
  if FPageControl <> Value then
  begin
    if FPageControl <> nil then FPageControl.RemovePage(Self);
    Parent := Value;
    if Value <> nil then Value.InsertPage(Self);
  end;
end;

procedure TDCCustomPage.SetPageIndex(const Value: Integer);
 var
  MaxPageIndex: Integer;
begin
  if FPageControl <> nil then
  begin
    MaxPageIndex := FPageControl.FPages.Count - 1;
    if Value > MaxPageIndex then
      raise EListError.CreateFmt(SPageIndexError, [Value, MaxPageIndex]);
    FPageControl.FPages.Move(PageIndex, Value);
    TabOrder := PageIndex;
    with FPageControl do
    begin
      TabsChanged;
      Invalidate;
    end;
  end;
end;

procedure TDCCustomPage.SetPageVisible(const Value: boolean);
begin
  if FPageVisible <> Value then
  begin
    FPageVisible := Value;
    if FPageControl <> nil then
      FPageControl.SetPageVisible(PageIndex, Value);
  end;
end;

procedure TDCCustomPage.UpdatePageShowing;
begin
  SetPageVisible((FPageControl <> nil) and PageVisible);
end;

procedure TDCCustomPage.WMEraseBkGnd(var Message: TWMEraseBkGnd);
begin
  Message.Result := 0;
end;

procedure TDCCustomPage.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  Message.Result := DLGC_WANTARROWS + DLGC_WANTCHARS;
end;

{ TDCCustomPageControl }

procedure TDCCustomPageControl.AdjustClientRect(var Rect: TRect);
begin
  inherited;
  if FTabVisible then
    Rect := GetCurrentPageRect
  else
  begin
    Rect := ClientRect;
    InflateRect(Rect, -2, -2);
  end;
end;

function TDCCustomPageControl.CanChange(Page: TDCCustomPage): Boolean;
begin
  Result := Page.Enabled or ([csLoading, csDesigning]*ComponentState <> []);
  if Assigned(FOnChanging) and (ComponentState = []) and (ActivePage <> nil) then
    FOnChanging(Self, Result);
end;

function TDCCustomPageControl.CanShowPage(PageIndex: Integer): Boolean;
 var
  Page: TDCCustomPage;
begin
  Page   := FPages[PageIndex];
  Result := (csDesigning in ComponentState) or
            (Page <> nil) and Page.PageVisible;
end;

procedure TDCCustomPageControl.Change;
begin
  if Assigned(FOnChange) then FOnChange(Self);
end;

procedure TDCCustomPageControl.ChangeActivePage(Page: TDCCustomPage);
var
  ParentForm: TCustomForm;
  ActivePage: TDCCustomPage;
begin
  if (FActivePage <> Page) and ((Page = nil) or CanChange(Page)) then
  begin
    ParentForm := GetParentForm(Self);
    if (ParentForm <> nil) and (FActivePage <> nil) and
      FActivePage.ContainsControl(ParentForm.ActiveControl) then
    begin
      ParentForm.ActiveControl := FActivePage;
      if ParentForm.ActiveControl <> FActivePage then
        Exit;
    end;

    ActivePage := FActivePage;

    if Page <> nil then
    begin
      Page.BringToFront;
      Page.Visible := True;
      if (ParentForm <> nil) and (FActivePage <> nil) and
        (ParentForm.ActiveControl = FActivePage) then
        if Page.CanFocus then
          ParentForm.ActiveControl := Page else
          ParentForm.ActiveControl := Self;

      FActivePage := Page;
      Realign;
    end
    else
      FActivePage := Page;
    if ActivePage <> nil then ActivePage.Visible := False;

    if (ParentForm <> nil) and (FActivePage <> nil) and
      (ParentForm.ActiveControl = FActivePage) then
      FActivePage.SelectFirst;

    TabsChanged;
    if ComponentState = [] then Change;

  end;
end;

procedure TDCCustomPageControl.CMDialogChar(var Message: TCMDialogChar);
 var
  i: Integer;
begin
  for i := 0 to FPages.Count - 1 do
    if IsAccel(Message.CharCode, TDCCustomPage(FPages[I]).Caption) and
       CanShowPage(i) and CanFocus
    then begin
      Message.Result := 1;
      if CanChange(FPages[I]) then PageIndex := i;
      Exit;
    end;
  inherited;
end;

constructor TDCCustomPageControl.Create(AOwner: TComponent);
begin
  inherited;
  ControlStyle := [csCaptureMouse, csClickEvents, csOpaque, csDoubleClicks];
  FBrushImage := TDCBrushImage.Create(Self);
  FBrushImage.OnChange := ChangeBrush;
  FPages := TPageList.Create(Self);

  Self.Align  := alNone;
  FTabVisible := True;

  Width  := 200;
  Height := 100;
  FImageChangeLink :=  TChangeLink.Create;
  FImageChangeLink.OnChange := ImageListChange;

  FFirstIndex   := 0;
  FSelectedPage := nil;
  FBitmap := TBitmap.Create;
  FBuffered := True;
end;

destructor TDCCustomPageControl.Destroy;
 var
  i: integer;
begin
  FBitmap.Free;
  FBrushImage.Free;
  for i := 0 to FPages.Count - 1 do TDCCustomPage(FPages[I]).FPageControl := nil;
  FPages.Free;
  FImageChangeLink.Free;
  inherited;
end;

function TDCCustomPageControl.FindNextPage(APage: TDCCustomPage;
  GoForward, CheckTabVisible: Boolean): TDCCustomPage;
 var
  i, StartIndex: Integer;
begin
  if FPages.Count <> 0 then
  begin
    StartIndex := FPages.IndexOf(APage);
    if StartIndex = -1 then
      if GoForward then StartIndex := FPages.Count - 1 else StartIndex := 0;
    i := StartIndex;
    repeat
      if GoForward then
      begin
        Inc(I);
        if i = FPages.Count then i := 0;
      end else
      begin
        if i = 0 then i := FPages.Count;
        Dec(i);
      end;
      Result := FPages[I];
      if not CheckTabVisible or Result.IsPageVisible and CanChange(Result) then Exit;
    until i = StartIndex;
  end;
  Result := nil;
end;

function TDCCustomPageControl.GetPage(Index: Integer): TDCCustomPage;
begin
  Result := FPages[Index];
end;

function TDCCustomPageControl.GetTabRect(AIndex: integer; Page: TDCCustomPage;
  var ARect: TRect): TRect;
begin
  {}
end;

function TDCCustomPageControl.GetPageCount: Integer;
begin
  Result := FPages.Count;
end;

function TDCCustomPageControl.GetPageIndex: integer;
begin
  if ActivePage <> nil then
    Result := ActivePage.PageIndex
  else
    Result := -1;
end;

procedure TDCCustomPageControl.InsertPage(Page: TDCCustomPage);
begin
  Page.FPageControl := Self;
  FPages.Add(Page);
  if Page.PageVisible then
  begin
    FPages.AddVisible(Page.PageIndex);
    Page.UpdatePageShowing;
    ChangeActivePage(Page);
  end
end;

procedure TDCCustomPageControl.Paint;
 var
  ARect: TRect;
begin
  if FBuffered then
  begin
    ARect := TabsRect;
    if not IsRectEmpty(ARect) then
    begin
      UpdateDeviceRegion(Canvas.Handle);
      FBitmap.Width  := ARect.Right  - ARect.Left;
      FBitmap.Height := ARect.Bottom - ARect.Top;
      DrawTabsArea(FBitmap.Canvas);
      Canvas.Draw(ARect.Left, ARect.Top, FBitmap);
    end;
    DrawBorder(Canvas);
  end
  else begin
    if (FPages.VisibleCount > 0) or (csDesigning in ComponentState) then
      DrawTabsArea(Canvas);
    DrawBorder(Canvas);
  end;
end;

procedure TDCCustomPageControl.RemovePage(Page: TDCCustomPage);
var
  NextPage: TDCCustomPage;
begin
  NextPage := FindNextPage(Page, True, not (csDesigning in ComponentState));
  if NextPage = Page then NextPage := nil;

  _setFlag(Page.FFlags, CP_REMOVING, True);

  Page.SetPageVisible(False);
  Page.FPageControl := nil;
  FPages.Remove(Page);
  FPages.UpdateVisible;
  SetActivePage(NextPage);
  UpdateTabsRect;
  Invalidate;
end;

function TDCCustomPageControl.SelectNextPage(GoForward: Boolean): boolean;
var
  Page: TDCCustomPage;
begin
  Page := FindNextPage(ActivePage, GoForward, not(csDesigning in ComponentState));
  if (Page <> nil) and (Page <> ActivePage) and CanChange(Page) then ActivePage := Page;
  Result := Page <> nil;
end;

procedure TDCCustomPageControl.SetActivePage(const Value: TDCCustomPage);
begin
  if (Value <> nil) and (Value.PageControl <> Self) then Exit;
  ChangeActivePage(Value);
  UpdateDesigner(Self);
end;

procedure TDCCustomPageControl.SetPageIndex(const Value: integer);
begin
  ActivePage := FPages[Value];
end;

procedure TDCCustomPageControl.SetPageVisible(APageIndex: integer;
  AVisible: boolean);
begin
  FPages.SetVisible(TDCCustomPage(FPages.Items[APageIndex]), AVisible);
  UpdateTabSize;
  TabsChanged;
end;

procedure TDCCustomPageControl.UpdatePage(Page: TDCCustomPage);
begin
  TabsChanged;
end;

procedure TDCCustomPageControl.WMSize(var Message: TWMSize);
begin
  inherited;
  UpdateTabsRect;
end;

procedure TDCCustomPageControl.DrawTab(ACanvas: TCanvas; ARect: TRect;
  AIndex: integer; APage: TDCCustomPage; var ADefaultDraw: boolean; AExclude: boolean);
 var
  AActivePage: boolean;
begin
  ADefaultDraw := True;
  AActivePage  := ActivePage.PageIndex = APage.PageIndex;
  if Assigned(FOnDrawTab) then
    FOnDrawTab(Self, ACanvas, AIndex, ARect, AActivePage, ADefaultDraw);

  if ADefaultDraw then
  begin
    DoDrawTab(ACanvas, ARect, AIndex, APage, AActivePage);
  end;
  with ARect do
  begin
    if AExclude then
      ExcludeClipRect(ACanvas.Handle, Left, Top, Right, Bottom);
  end;

end;

procedure TDCCustomPageControl.DrawTabsArea(ACanvas: TCanvas);
 var
  i, VisibleIndex: integer;
  Page: TDCCustomPage;
  ARect: TRect;
  ADefaultDraw: boolean;
  R: TRect;
begin
  if FTabVisible then
  begin
    for i := 0 to FPages.Count - 1 do
    begin
      Page := FPages.Items[i];
      VisibleIndex := -1;
      SetRectEmpty(ARect);
      if ARect.Left < FTabsRect.Right then
      begin
        if (csDesigning in ComponentState) then
          VisibleIndex := i
        else
         if Page.IsPageVisible then VisibleIndex := FPages.VisibleIndexOf(Page.PageIndex);
      end;
      if (VisibleIndex <> -1) and (Page.FTabRect.Right > Page.FTabRect.Left) then
      begin
        ARect := Page.FTabRect;
        IntersectRect(R, Canvas.ClipRect, ARect);
        if not IsRectEmpty(R) then
        begin
          if FBuffered then
            OffsetRect(ARect, -FTabsRect.Left, -FTabsRect.Top);
          DrawTab(ACanvas, ARect, VisibleIndex, Page, ADefaultDraw, True);
        end;
      end
    end;
  end;
end;

function TDCCustomPageControl.GetCurrentPageRect: TRect;
begin
  Result := ClientRect;
end;

function TDCCustomPageControl.GetTabsRect: TRect;
begin
  {}
end;

procedure TDCCustomPageControl.ShowControl(AControl: TControl);
begin
  if (AControl is TDCCustomPage) and
     (TDCCustomPage(AControl).PageControl = Self) and (Self.ActivePage <> TDCCustomPage(AControl)) then
    SetActivePage(TDCCustomPage(AControl));
  inherited;
end;

procedure TDCCustomPageControl.DrawBorder(ACanvas: TCanvas);
begin
  {}
end;

procedure TDCCustomPageControl.DoDrawTab(ACanvas: TCanvas; ARect: TRect;
  AIndex: integer; APage: TDCCustomPage; AActivePage: boolean);
begin
  {}
end;

procedure TDCCustomPageControl.TabsChanged;
begin
  if HandleAllocated then UpdateTabsRect;
  RepaintTabs;
end;

function ComparePage(Item1, Item2: Pointer): integer;
begin
  if TDCCustomPage(Item1).TabOrder < TDCCustomPage(Item2).TabOrder then
    Result := -1
  else
  if TDCCustomPage(Item1).TabOrder = TDCCustomPage(Item2).TabOrder then
    Result := 0
  else
    Result := 1
end;

procedure TDCCustomPageControl.Loaded;
 var
  i: integer;
  Form: TCustomForm;
begin
  inherited;
  FPages.Sort(ComparePage);
  FPages.UpdateVisible;
  TabsChanged;

  if not(csDesigning in ComponentState) then
  begin
    if (FPages.VisibleCount > 0) then
    begin
      while (ActivePage = nil) or not(ActivePage.IsPageVisible) or
        not(ActivePage.Enabled) do
        if not SelectNextPage(True) then
        begin
          for i := 0 to FPages.Count - 1 do
            if TDCCustomPage(FPages[i]).IsPageVisible then
            begin
              ActivePage := FPages[i];
              Form := GetparentForm(Self);
              if (Form <> nil) and (Form.ActiveControl = Self) then
              begin
                Form.ActiveControl := TInternalControl(Form).FindNextControl(Self,
                  True, True, False);
              end;
              Exit;
            end;
        end
    end
    else ActivePage := nil;
  end;
end;

procedure TDCCustomPageControl.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  Message.Result := DLGC_WANTARROWS + DLGC_WANTCHARS;
end;

procedure TDCCustomPageControl.CMDialogKey(var Message: TCMDialogKey);
begin
  if FTabVisible and (Focused or Windows.IsChild(Handle, Windows.GetFocus)) and
    (Message.CharCode = VK_TAB) and (GetKeyState(VK_CONTROL) < 0)
  then begin
    SelectNextPage(GetKeyState(VK_SHIFT) >= 0);
    Message.Result := 1;
  end else
    inherited;
end;

procedure TDCCustomPageControl.CMDesignHitTest(var Message: TCMDesignHitTest);
 var
  Page: TDCCustomPage;
begin
  inherited;
  with Message do
  begin
    Page := GetPageAt(Pos.X, Pos.Y);
    if (Page <> nil) and (Page <> ActivePage) then Result := 1;
  end;
end;

procedure TDCCustomPageControl.WMLButtonDown(var Message: TWMLButtonDown);
 var
  Page: TDCCustomPage;
begin
  Page := GetPageAt(Message.Pos.X, Message.Pos.Y);
  if Page <> nil then
  begin
    SendCancelMode(Self);
    SetActivePage(Page);
  end
  else
    inherited;
end;

function TDCCustomPageControl.GetPageAt(X, Y: integer): TDCCustomPage;
 var
  i: integer;
  Page: TDCCustomPage;
begin
  Result := nil;
  if FTabVisible then
    for i := 0 to FPages.Count-1 do
    begin
      Page := FPages.Items[i];
      if Page.IsPageVisible and PtInRect(Page.FTabRect, Point(X, Y)) then
      begin
        Result := Page;
        Break;
      end;
    end;
end;

procedure TDCCustomPageControl.SetImages(const Value: TImageList);
begin
  if Images <> nil then
    Images.UnRegisterChanges(FImageChangeLink);
  FImages := Value;
  if Images <> nil then
  begin
    Images.RegisterChanges(FImageChangeLink);
    Images.FreeNotification(Self);
  end;
  UpdateTabSize;
  TabsChanged;
end;

procedure TDCCustomPageControl.SetTabVisible(const Value: boolean);
begin
  if FTabVisible <> Value then
  begin
    FTabVisible := Value;
    TabsChanged;
  end;
end;

procedure TDCCustomPageControl.ImageListChange(Sender: TObject);
begin
  UpdateTabSize;
  TabsChanged;
end;

procedure TDCCustomPageControl.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) then
  begin
    if (AComponent = FImages) then
    begin
      FImages := nil;
      Invalidate;
      Exit;
    end;
    if (AComponent = BrushImage.Images) then
    begin
      BrushImage.Images := nil;
      Exit;
    end;
  end;
end;

procedure TDCCustomPageControl.UpdateTabsRect;
 var
  i, VisibleIndex: integer;
  Page: TDCCustomPage;
  ARect: TRect;
begin
  if FTabVisible{ and HandleAllocated} then
  begin
    FTabsRect := GetTabsRect;
    SetRectEmpty(ARect);
    for i := 0 to FPages.Count - 1 do
    begin
      Page := FPages.Items[i];
      VisibleIndex := -1;
      if ARect.Left < FTabsRect.Right then
      begin
        if (csDesigning in ComponentState) then
          VisibleIndex := i
        else
         if Page.IsPageVisible then VisibleIndex := FPages.VisibleIndexOf(Page.PageIndex);
      end;
      if (VisibleIndex <> -1) and (VisibleIndex >= FFirstIndex) then
      begin
        ARect := GetTabRect(VisibleIndex, Page, ARect);
        if not EqualRect(ARect, Page.FTabRect) then
        begin
          Page.FTabRect := ARect;
        end;
      end
      else begin
        SetRectEmpty(Page.FTabRect);
      end;
    end;
  end
  else
    SetRectEmpty(FTabsRect);
end;

procedure TDCCustomPageControl.WMEraseBkGnd(var Message: TWMEraseBkGnd);
begin
  Message.Result := 0;
end;

procedure TDCCustomPageControl.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params.WindowClass do
    Style := Style and not(CS_HREDRAW or CS_VREDRAW);
end;

procedure TDCCustomPageControl.UpdateTabSize;
begin
  {}
end;

procedure TDCCustomPageControl.KeyDown(var Key: Word; Shift: TShiftState);
begin
  inherited;
  if FTabVisible then
  begin
    case Key of
      VK_LEFT:
        SelectNextPage(False);
      VK_RIGHT:
        SelectNextPage(True);
    end
  end;
end;

procedure TDCCustomPageControl.RepaintTabs;
begin
  if HandleAllocated then
  begin
    Realign;
    Paint;
  end;
end;

procedure TDCCustomPageControl.ChangeBrush(Sender: TObject);
begin
  Invalidate;
end;

procedure TDCCustomPageControl.SetBrushImage(const Value: TDCBrushImage);
begin
  FBrushImage := Value;
end;

procedure TDCCustomPageControl.UpdateDeviceRegion(DC: HDC);
begin
  {}
end;

{ TPageList }

procedure TPageList.AddVisible(AIndex: integer);
 var
  pIndex: ^Integer;
begin
  GetMem(pIndex, SizeOf(Integer));
  pIndex^ := AIndex;
  FVisibleList.Add(pIndex);
end;

procedure TPageList.ClearVisible;
 var
  i: integer;
begin
  for i := 0 to FVisibleList.Count-1 do
  begin
    FreeMem(FVisibleList.Items[i], SizeOf(Integer));
  end;
  FVisibleList.Clear;
end;

constructor TPageList.Create(AComponent: TComponent);
begin
  inherited Create;
  FPageControl := TDCCustomPageControl(AComponent);
  FVisibleList := TList.Create;
end;

destructor TPageList.Destroy;
begin
  ClearVisible;
  FVisibleList.Free;
  inherited;
end;

function TPageList.GetVisibleCount: integer;
begin
  Result := FVisibleList.Count;
end;

procedure TPageList.SetVisible(APage: TDCCustomPage; AVisible: boolean);
 var
  i: integer;
  pIndex: ^Integer;
  PageFound: boolean;
begin
  PageFound := False;
  with FVisibleList do
  begin
    i := 0;
    while (i < Count) and PageFound do
    begin
      pIndex := Items[i];
      if APage.PageIndex = pIndex^ then
      begin
        if not AVisible then
        begin
          FreeMem(pIndex, SizeOf(Integer));
          Delete(i);
          PageFound := True;
          Break;
        end;
      end;
      Inc(i);
    end;
    if not PageFound and AVisible then UpdateVisible;
  end;
end;

procedure TPageList.UpdateVisible;
 var
  i, j: integer;
  pIndex: ^Integer;
  Page: TDCCustomPage;
begin
  j := 0;
  for i := 0 to Count-1 do
  begin
    Page := TDCCustomPage(Items[i]);
    if Page.IsPageVisible then
    begin
      if j < FVisibleList.Count then
        pIndex := FVisibleList.Items[j]
      else begin
        GetMem(pIndex, SizeOf(Integer));
        FVisibleList.Add(pIndex);
      end;
      pIndex^ := Page.PageIndex;
      Inc(j)
    end;
  end;
  if FVisibleList.Count > j then
  begin
    while j < FVisibleList.Count do
    begin
      FreeMem(FVisibleList.Items[j], SizeOf(Integer));
      FVisibleList.Delete(j);
    end;
  end;
end;

function TPageList.VisibleIndexOf(Index: integer): integer;
 var
  i: integer;
begin
  Result := -1;
  with FPageControl do
    if not ((csDesigning in ComponentState) or TabVisible) then Exit;
  for i := 0 to FVisibleList.Count-1 do
    if Index = Integer(FVisibleList.Items[i]^) then
    begin
      if FPageControl.FFirstIndex <= i then Result := i;
      Exit;
    end;
end;

{ TDCPageControl }

constructor TDCPageControl.Create(AComponent: TComponent);
begin
  inherited;
  FTabSize     := Point(0, 0);
  FDrawStyle   := fcsNormal;
  FTabMargins  := Rect(4, 6, 4, 3);
  FItemMargins := Rect(5, 3, 5, 3);
  FTabPosition := tbBottom;

  FTabButtons := TDCEditButtons.Create(Self);
  FTabButtons.AnchorStyle := asNone;
  FTabButtons.Options := FTabButtons.Options - [boAbsolutePos];

  FTabTracksStyle := dtNormal;
  
  CreateTracks;

  FMouseDown  := False;
  FTimer      := False;
  FRedrawTabs := False;

  FCanvasLocked := False;
  FChangedPage  := nil;
  FPageSelected := True;

  FTabColor := clBtnShadow;
  FOptions := []
end;

procedure TDCPageControl.DoDrawTab(ACanvas: TCanvas; ARect: TRect;
  AIndex: integer; APage: TDCCustomPage; AActivePage: boolean);
 var
  BRect: TRect;
begin
  inherited;
  if ARect.Left >= ARect.Right then Exit;

  with ACanvas do
  begin
    if AActivePage then
      Brush.Color := Self.Color
    else
      Brush.Color := FTabColor;

    FillRect(ARect);
    if (Screen.ActiveControl = Self) and AActivePage then
    begin
      BRect := ARect;
      InflateRect(BRect, -2, -1);
      BRect.Right  := BRect.Right  - 1;
      BRect.Bottom := BRect.Bottom - 1;

      Brush.Bitmap := AllocPatternBitmap(clBlack, Brush.Color);
      FrameRect(BRect);
    end;

    if FTabPosition in [tbTop, tbBottom] then
    begin
      if AActivePage then
      begin
        case FTabPosition of
          tbTop:
            begin
              if ColorToRGB(FTabColor) < ColorToRGB(clSilver) then
                DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_TOP)
              else
                DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_TOPLEFT);
              if _getFlag(APage.FFlags, CP_FULLVISIBLE) then
                DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_RIGHT)
              else begin
              end;
            end;
          tbBottom:
            begin
              if _getFlag(APage.FFlags, CP_FULLVISIBLE) then
                 DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT)
              else begin
                 DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_BOTTOM)
              end;
              if ColorToRGB(FTabColor) > ColorToRGB(clSilver) then
                DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_LEFT);
            end;
        end;
      end
      else begin
        case FTabPosition of
          tbTop   : DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENOUTER, BF_BOTTOM);
          tbBottom: DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENINNER, BF_TOP);
        end;
        if FTabPosition = tbTop then Dec(ARect.Bottom) else Inc(ARect.Top);
        InflateRect(ARect, 0, -3);
        if _getFlag(APage.FFlags, CP_FULLVISIBLE) and
           (((csDesigning in ComponentState) and (AIndex <> FPages.Count-1) ) or
           (not(csDesigning in ComponentState) and (AIndex <> FPages.VisibleCount-1)))
        then
          DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENINNER, BF_RIGHT or BF_FLAT);
        if FTabPosition = tbTop then Inc(ARect.Bottom) else Dec(ARect.Top);
        InflateRect(ARect, 0, 3);
      end;
    end
    else begin
      if AActivePage then
      begin
        case FTabPosition of
          tbLeft:
            begin
              if ColorToRGB(FTabColor) < ColorToRGB(clSilver) then
                DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_LEFT)
              else
                DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_BOTTOMLEFT);
              DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_TOP);
            end;
          tbRight:
            begin
              DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT);
              DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_TOP)
            end;
        end;
      end
      else begin
        case FTabPosition of
          tbLeft  : //DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_RIGHT);
            DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENOUTER, BF_RIGHT);
          tbRight : DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENINNER, BF_LEFT);
        end;
      end;
    end;
    DrawTabText(ACanvas, ARect, AIndex, APage, AActivePage);
  end;
end;

procedure TDCPageControl.DrawBorder(ACanvas: TCanvas);
 var
  ARect, BRect: TRect;
  ARgn, BRgn: HRGN;
  AResult: integer;
begin
  if (FPages.VisibleCount > 0) or
     ((csDesigning in ComponentState) and (FPages.Count > 0)) then
  begin

    if FTabVisible then
    begin
      ARect := GetCurrentPageRect;
      case FTabPosition of
        tbBottom: ARect.Bottom := ARect.Bottom - 2;
        tbTop: ARect.Top := ARect.Top + 2;
        tbLeft: ARect.Left := ARect.Left + 2;
        tbRight: ARect.Right := ARect.Right - 2;
      end;
    end
    else begin
      ARect := ClientRect;
      InflateRect(ARect, -2, -2);
    end;

    InflateRect(ARect, 2, 2);
    with Canvas do
    begin
      Canvas.Brush.Color := Self.Color;
      FrameRect(ARect);
      InflateRect(ARect, -1, -1);
      FrameRect(ARect);
      ARgn := CreateRectRgnIndirect(ARect);
      try
      if ActivePage <> nil then
      begin
        BRect := GetClientRect;
        AdjustClientRect(BRect);
        BRgn  := CreateRectRgnIndirect(BRect);
        try
          AResult := CombineRgn(ARgn, ARgn, BRgn, RGN_DIFF);
          if AResult <> NULLREGION then
            FillRgn(Canvas.Handle, ARgn, Canvas.Brush.Handle)
        finally
          DeleteObject(BRgn);
        end;
      end;
      finally
        DeleteObject(ARgn);
      end;
    end;
  end
  else begin
    ARect := ClientRect;
    Canvas.Brush.Color := Self.Color;
    Canvas.FillRect(ARect);
  end;

  ARect := ClientRect;
  case FDrawStyle of
    fcsNormal:
      begin
        DrawEdge(Canvas.Handle, ARect, BDR_SUNKENOUTER, BF_RECT);
        InflateRect(ARect, -1, -1);
        DrawEdge(Canvas.Handle, ARect, BDR_SUNKENINNER, BF_RECT);
      end;
    fsFlat:
      begin
        DrawEdge(Canvas.Handle, ARect, BDR_SUNKENOUTER, BF_RECT or BF_ADJUST);
        DrawEdge(Canvas.Handle, ARect, BDR_SUNKENINNER, BF_BOTTOMRIGHT);
      end;
    fsNone:
      ;
    fsSingle:
      with Canvas do
      begin
        Canvas.Brush.Color := clBtnShadow;
        FrameRect(ARect);
      end;
  end;

end;

procedure TDCPageControl.DrawTabsArea(ACanvas: TCanvas);
 var
  ATabRect: TRect;
  DCRegion, TabsRegion: HRGN;
  SaveIndex: integer;
begin
  if not FBuffered then
  begin
    DCRegion := CreateRectRgnIndirect(ClientRect);
    DCRegion := GetClipRgn(ACanvas.Handle, DCRegion);
    TabsRegion:= CreateRectRgnIndirect(ControlRect);
    SelectClipRgn(ACanvas.Handle, TabsRegion);
  end
  else begin
    DCRegion   := 0;
    TabsRegion := 0;
  end;

  try
    SaveIndex := SaveDC(ACanvas.Handle);
    inherited;
    ATabRect := TabsRect;
    if FBuffered then OffsetRect(ATabRect, -ATabRect.Left, -ATabRect.Top);

    with ACanvas do
    begin
      if not FBuffered then
      begin
        if FPrevTrack.Visible then
          with FPrevTrack do
             ExcludeClipRect(Handle, Left, Top, Left+Width, Top+Height);
        if FNextTrack.Visible then
          with FNextTrack do
             ExcludeClipRect(Handle, Left, Top, Left+Width, Top+Height);
        FTabButtons.UpdateDeviceRegion(Handle);
      end;

      Brush.Color := FTabColor;

      FillRect(ATabRect);
      case FTabPosition of
        tbTop:
          begin
            Pen.Color := clWindow;
            MoveTo(ATabRect.Left, ATabRect.Bottom-1);
            LineTo(ATabRect.Right, ATabRect.Bottom-1);
          end;
        tbBottom:
          begin
            Pen.Color   := cl3DDkShadow;
            MoveTo(ATabRect.Left, ATabRect.Top);
            LineTo(ATabRect.Right, ATabRect.Top);
          end;
        tbLeft:
          begin
            Pen.Color := clWindow;
            MoveTo(ATabRect.Right-1, ATabRect.Top);
            LineTo(ATabRect.Right-1, ATabRect.Bottom);
          end;
        tbRight:
          begin
            Pen.Color   := cl3DDkShadow;
            MoveTo(ATabRect.Left, ATabRect.Top);
            LineTo(ATabRect.Left, ATabRect.Bottom);
          end;
      end;
    end;
    RestoreDC(ACanvas.Handle, SaveIndex);
    if ActivePage <> nil then
    begin
      ATabRect := ActivePage.FTabRect;
      if ATabRect.Left <> ATabRect.Right then
      begin
        if FBuffered then OffsetRect(ATabRect, -FTabsRect.Left, -FTabsRect.Top);
        DrawTabDiv(ACanvas, ATabRect, True, ActivePage.PageIndex = FFirstIndex);
      end;
    end;
  finally
    if not FBuffered then
    begin
      SelectClipRgn(ACanvas.Handle, DCRegion);
      DeleteObject(TabsRegion);
      DeleteObject(DCRegion);
    end;
  end;
end;

function TDCPageControl.ControlRect: TRect;
begin
  Result := ClientRect;
  case FDrawStyle of
    fcsNormal:
      InflateRect(Result, -2, -2);
    fsFlat:
      InflateRect(Result, -1, -1);
    fsNone:
      ;
    fsSingle:
      InflateRect(Result, -1, -1);
  end;
end;

function TDCPageControl.GetCurrentPageRect: TRect;
begin
  Result := ControlRect;
  case FTabPosition of
    tbTop   :  Result.Top := Result.Top + FTabHeight;
    tbBottom:  Result.Bottom := Result.Bottom - FTabHeight;
    tbLeft  :  Result.Left := Result.Left + FTabWidth;
    tbRight :  Result.Right := Result.Right - FTabWidth;
  end;
end;

function TDCPageControl.GetTabRect(AIndex: integer; Page: TDCCustomPage;
  var ARect: TRect): TRect;
 var
  ATabsRect: TRect;
  AItemWidth: integer;

 function LeftTabOffset: integer;
 begin
   if pcTracksOnRightSide in FOptions then
     Result := 2
   else
     Result := FPrevTrack.Width + 2
 end;

 function RightTabOffset: integer;
  var
   R: TRect;
 begin
   R := FTabButtons.GetButtonsRect;
   OffsetRect(R, -R.Left, -R.Top);
   Result := FNextTrack.Width + R.Right + 2;
   if pcTracksOnRightSide in FOptions then Inc(Result, FPrevTrack.Width);
 end;

begin
  ATabsRect := TabsRect;
  AIndex    := AIndex - FFirstIndex;

  case FTabPosition of
    tbTop, tbBottom:
    begin
      if FTabSize.X = 0 then
      begin
        Canvas.Font := Self.Font;
        AItemWidth := GetItemSize(Page).X;
        if AIndex <= 0 then
          Result.Left  := FTabMargins.Left + LeftTabOffset
        else
          Result.Left  := ARect.Right;
        Result.Right := Result.Left + AItemWidth + FItemMargins.Left +
          FItemMargins.Right;
      end
      else begin
        Result.Left  := ATabsRect.Left + FTabMargins.Left + LeftTabOffset +
          AIndex * FTabSize.X;
        Result.Right := Result.Left + FTabSize.X;
      end;
      case FTabPosition of
        tbTop:
          begin
            Result.Bottom:= ATabsRect.Bottom;
            Result.Top   := ATabsRect.Bottom - (FItemHeight +
              FItemMargins.Top + FItemMargins.Bottom);
          end;
        tbBottom:
          begin
            Result.Top   := ATabsRect.Top;
            Result.Bottom:= ATabsRect.Top + (FItemHeight +
              FItemMargins.Top + FItemMargins.Bottom);
          end;
      end;
      if Result.Right > ATabsRect.Right - FTabMargins.Right - RightTabOffset then
      begin
        _setFlag(Page.FFlags, CP_FULLVISIBLE, False);
        Result.Right := ATabsRect.Right - FTabMargins.Right - RightTabOffset;
      end
      else
        _setFlag(Page.FFlags, CP_FULLVISIBLE, True);
    end;
    tbLeft, tbRight:
    begin
      Result.Top  := FTabMargins.Top +  FPrevTrack.Height + TabsRect.Top +
        AIndex*FTabHeight;
      Result.Bottom  := Result.Top + FTabHeight;
      if FTabPosition = tbLeft then
      begin
        Result.Right := TabsRect.Right;
        Result.Left := TabsRect.Left + FTabMargins.Left;
      end
      else begin
        Result.Right := TabsRect.Right - FTabMargins.Right;
        Result.Left := TabsRect.Left;
      end;
      if Result.Bottom > ATabsRect.Bottom - FTabMargins.Right then
        SetRectEmpty(Result)
      else
        _setFlag(Page.FFlags, CP_FULLVISIBLE, True);
    end;
  end;
end;

function TDCPageControl.GetTabsRect: TRect;
begin
  Result := ControlRect;
  case FTabPosition of
    tbTop   :  Result.Bottom := Result.Top + FTabHeight;
    tbBottom:  Result.Top := Result.Bottom - FTabHeight;
    tbLeft  :  Result.Right := Result.Left + FTabWidth;
    tbRight :  Result.Left := Result.Right - FTabWidth;
  end;
end;

procedure TDCPageControl.SetTabHeight(const Value: integer);
begin
  if FTabSize.Y <> Value then
  begin
    if Value >= 0 then FTabSize.Y := Value;
    UpdateTabSize;
  end;
end;

procedure TDCPageControl.SetTabWidth(const Value: integer);
begin
  if FTabSize.X <> Value then
  begin
    if Value >= 0 then FTabSize.X := Value;
    UpdateTabSize;
  end;
end;

procedure TDCPageControl.UpdateTabSize;
 var
  i: integer;
begin
  Canvas.Font := Self.Font;
  FItemHeight := GetTextHeight(Canvas.Handle, 'Wg');
  if Assigned(Images) and (Images.Height > FItemHeight) then
    FItemHeight := Images.Height;

  if FTabSize.Y > 0 then
    FTabHeight := FTabSize.Y
  else
    with FTabMargins do
      FTabHeight := FItemHeight + Top + Bottom;

  if FTabPosition in [tbLeft, tbRight] then
  begin
    if FTabSize.X > 0 then
      FTabWidth := FTabSize.X
    else begin
      FTabWidth := 0;
      for i := 0 to PageCount - 1 do
        if Pages[i].IsPageVisible then
          FTabWidth := _IntMax(GetItemSize(Pages[i]).X, FTabWidth);

      Inc(FTabWidth, FItemMargins.Left + FItemMargins.Right +
        FTabMargins.Left + FTabMargins.Right);
    end;
    if FTabSize.Y = 0 then FTabHeight := FItemHeight + 7;
  end;

  FPrevTrack.Height := FTabHeight - 4;
  FNextTrack.Height := FTabHeight - 4;

  for i := 0 to FTabButtons.Count - 1 do
    FTabButtons.Items[i].Height := FTabHeight - 4;

  if HandleAllocated then UpdateTracksPos;
  TabsChanged;
end;

procedure TDCPageControl.SetDrawStyle(const Value: TControlStyle);
begin
  if FDrawStyle <> Value then
  begin
    FDrawStyle := Value;
    TabsChanged;
    UpdateTracksPos;
    invalidate;
  end;
end;

procedure TDCPageControl.SetTabPosition(const Value: TLiteTabPosition);
begin
  if FTabPosition <> Value then
  begin
    FTabPosition := Value;
    UpdateTabSize;
    TabsChanged;
    Invalidate;
  end;
end;

procedure TDCPageControl.CreateWnd;
begin
  inherited;
  FTabButtons.ClrWndProc;
  FTabButtons.SetWndProc;
  UpdateTabSize;
end;

procedure TDCPageControl.CMFontChanged(var Message: TMessage);
begin
  inherited;
  UpdateTabSize;
  UpdateTabs;
end;

procedure TDCPageControl.Paint;
begin
  inherited;
  PaintTracks;
end;

function TDCPageControl.CanChange(Page: TDCCustomPage): Boolean;
begin
  Result := inherited CanChange(Page);
end;

destructor TDCPageControl.Destroy;
begin
  FTabButtons.Free;
  if Assigned(FPrevTrack) then FreeAndNil(FPrevTrack);
  if Assigned(FNextTrack) then FreeAndNil(FNextTrack);
  inherited;
end;

procedure TDCPageControl.CreateTracks;
begin
  FPrevTrack := TDCEditButton.Create(Self);
  with FPrevTrack do
  begin
    Visible := False;
    Width := 13;
    Height := TabHeight;
    DrawText:= False;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNLEFT');
    BrushColor := clBtnFace;
    OnClick := ButtonsDown;
  end;

  FNextTrack := TDCEditButton.Create(Self);
  with FNextTrack do
  begin
    Visible := False;
    Width   := 13;
    Height  := TabHeight;
    DrawText:= False;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNRIGHT');
    BrushColor := clBtnFace;
    OnClick := ButtonsUp;
  end;

  with FTabButtons.AddButton do
  begin
    Visible := False;
    Width := CM_CXCLOSEBUTTON;
    Height := TabHeight;
    Name := SBC_BUTTONCLOSE;
    Alignment := abCenter;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNCLOSE');
    BrushColor := Color;
    DrawText := False;
    AnchorStyle := asNone;
    Tag := SBN_BUTTONCLOSE;
    OnClick := CloseButtonClick;
  end;

end;

procedure TDCPageControl.ButtonsDown(Sender: TObject);
begin
  FFirstIndex := FFirstIndex - 1;
  UpdateTabsRect;
  UpdateTabs;
end;

procedure TDCPageControl.ButtonsUp(Sender: TObject);
begin
  FFirstIndex := FFirstIndex + 1;
  UpdateTabsRect;
  UpdateTabs;
end;

procedure TDCPageControl.WMSize(var Message: TMessage);
begin
  inherited;
  CheckToNextTrack;
  if not FNextTrack.Visible then CheckToPrevTrack;
  UpdateTracksPos;
  RepaintTabs;
end;

procedure TDCPageControl.PaintTracks;
begin
  if FPrevTrack.Visible then FPrevTrack.Paint(0);
  if FNextTrack.Visible then FNextTrack.Paint(0);
end;

procedure TDCPageControl.UpdateTracksState(X, Y: integer; lMove: boolean);
begin
  FPrevTrack.UpdateButtonState(X, Y, FMouseDown, lMove);
  FNextTrack.UpdateButtonState(X, Y, FMouseDown, lMove);
end;

procedure TDCPageControl.WMLButtonDblClk(var Message: TWMLButtonDown);
begin
  inherited;
  if not (csDesigning in ComponentState) then
  begin
    FMouseDown := True;
    UpdateTracksState(Message.Pos.X, Message.Pos.Y, False);

    if (FPrevTrack.ButtonState  = btDownMouseInRect) or
       (FNextTrack.ButtonState  = btDownMouseInRect) then
     SetTimer(Handle, CTRTIMER_IDEVENT, 200, nil);
  end;
end;

procedure TDCPageControl.WMLButtonDown(var Message: TWMLButtonDown);
begin
  inherited;
  if not (csDesigning in ComponentState) then
  begin
    FMouseDown := True;
    UpdateTracksState(Message.Pos.X, Message.Pos.Y, False);

    if (FPrevTrack.ButtonState  = btDownMouseInRect) or
       (FNextTrack.ButtonState  = btDownMouseInRect) then
     SetTimer(Handle, CTRTIMER_IDEVENT, 200, nil);
  end;
end;

procedure TDCPageControl.WMLButtonUp(var Message: TWMLButtonUp);
begin
  inherited;
  if not (csDesigning in ComponentState) then
  begin
    FMouseDown := False;
    UpdateTracksState(Message.Pos.X, Message.Pos.Y, False);

    KillTimer(Handle, CTRTIMER_IDEVENT);
    FTimer := False;
  end;
end;

procedure TDCPageControl.WMMouseMove(var Message: TWMMouseMove);
begin
  inherited;
  UpdateTracksState(Message.Pos.X, Message.Pos.Y, True);
end;

procedure TDCPageControl.UpdateTracksPos;
 var
  ARect, BRect: TRect;
  i, ALeft: integer;
begin
  ARect := GetTabsRect;
  BRect := FTabButtons.GetButtonsRect;
  OffsetRect(BRect, -BRect.Left, -BRect.Top);

  case FTabPosition of
    tbTop, tbBottom:
      begin
        if pcTracksOnRightSide in Options then
        begin
          with FPrevTrack do
          begin
            Left := ClientRect.Right - Width - 4 - FNextTrack.Width -BRect.Right;
            Top := ARect.Top  + 2;
          end;
          with FNextTrack do
          begin
            Left := FPrevTrack.Left +  FPrevTrack.Width;
            Top := ARect.Top  + 2;
          end;
        end
        else begin
          with FPrevTrack do
          begin
            Left := ARect.Left + 2;
            Top := ARect.Top  + 2;
          end;
          with FNextTrack do
          begin
            Left := ClientRect.Right - Width - 4 - BRect.Right;
            Top := ARect.Top  + 2;
          end;
        end;
        ALeft := FNextTrack.Left + FNextTrack.Width;
        for i := 0 to FTabButtons.Count - 1 do
        begin
          with FTabButtons.Items[i] do
          begin
            Left := ALeft;
            Top := ARect.Top  + 2;
            ALeft := Left + Width;
          end;
        end;
      end;
    tbLeft, tbRight:
      begin
        with FPrevTrack do
        begin
          Left := ARect.Left + 2;
          Top  := ARect.Top  + 2;
        end;
        with FNextTrack do
        begin
          Left := ARect.Right - Width - 2;
          Top  := ARect.Top  + 2;
        end;
        for i := 0 to FTabButtons.Count - 1 do
          with FTabButtons.Items[i] do
          begin
            Left := -Width;
            Top  := -Height;
          end;
      end;
  end;
end;

procedure TDCPageControl.HideTrack(Track: TDCEditButton);
begin
  Track.Visible := False;
  if FTimer then KillTimer(Handle, CTRTIMER_IDEVENT);
end;

procedure TDCPageControl.UpdateTabs;
begin
  if not HandleAllocated then Exit;
  if not FTabVisible then
  begin
    HideTrack(FPrevTrack);
    HideTrack(FNextTrack);
  end
  else begin
    if (FFirstIndex = 0) and FPrevTrack.Visible then HideTrack(FPrevTrack);
    if (FFirstIndex > 0) and not FPrevTrack.Visible then FPrevTrack.Visible := True;
    CheckToNextTrack;
  end;
  if not FCanvasLocked then Invalidate;
end;

procedure TDCPageControl.CheckToNextTrack;
 var
  i, VisibleIndex: integer;
  Page: TDCCustomPage;
  ARect: TRect;
begin
  if FTabVisible then
  begin
    FTabsRect := GetTabsRect;
    SetRectEmpty(ARect);
    for i := 0 to FPages.Count - 1 do
    begin
      Page := FPages.Items[i];
      VisibleIndex := -1;
      if (csDesigning in ComponentState) then
        VisibleIndex := i
      else
        if Page.IsPageVisible then VisibleIndex := FPages.VisibleIndexOf(Page.PageIndex);
      if (VisibleIndex <> -1) and
        ( not _getFlag(Page.FFlags, CP_FULLVISIBLE) or IsRectEmpty(Page.FTabRect)) then
      begin
        FNextTrack.Visible := True;
        Exit;
      end;
    end;
  end;
  HideTrack(FNextTrack);
end;

procedure TDCPageControl.CheckToPrevTrack; 
 var
  AFirstIndex: integer;
begin
  if FFirstIndex > 0 then
  begin
    AFirstIndex   := FFirstIndex;
    FCanvasLocked := True;
    repeat
      ButtonsDown(Self);
      if FNextTrack.Visible then
      begin
        ButtonsUp(Self);
        break;
      end;
    until (FFirstIndex = 0);
    FCanvasLocked := False;
    if FFirstIndex <> AFirstIndex then invalidate;
  end;
end;

procedure TDCPageControl.Loaded;
begin
  inherited;
  FCanvasLocked := True;
  UpdateFirstIndex;
  UpdateTabs;
  if FTabPosition in [tbLeft, tbRight] then UpdateTabSize;
  FCanvasLocked := False;
end;

procedure TDCPageControl.WMTimer(var Message: TWMTimer);
begin
  FTimer := True;
  if FNextTrack.ButtonState = btDownMouseInRect then ButtonsUp(Self);
  if FPrevTrack.ButtonState = btDownMouseInRect then ButtonsDown(Self);
end;

procedure TDCPageControl.TabsChanged;
begin
  Realign;
  if (ActivePage <> nil) and
    (not _getFlag(ActivePage.FFlags, CP_FULLVISIBLE)
      or IsRectEmpty(ActivePage.FTabRect)) then
    UpdateFirstIndex
  else
    if not FRedrawTabs then UpdateTabsRect;

  if FRedrawTabs and FTabVisible  then
  begin
    RedrawTab(FChangedPage);
    RedrawTab(ActivePage);
    FRedrawTabs := False;
  end
  else
    UpdateTabs;
end;

procedure TDCPageControl.CMMouseEnter(var Message: TMessage);
begin
  inherited;
end;

procedure TDCPageControl.CMMouseLeave(var Message: TMessage);
begin
  ClearSelection;
  inherited;
  FPrevTrack.UpdateButtonState(-1, -1, False, True);
  FNextTrack.UpdateButtonState(-1, -1, False, True);
end;

procedure TDCPageControl.DrawTabText(ACanvas: TCanvas; ARect: TRect;
  AIndex: integer; APage: TDCCustomPage; AActivePage: boolean);
 var
  Flags: Longint;
  AText: string;
begin
  inherited;
  if ARect.Left >= ARect.Right then Exit;

  with ACanvas do
  begin
    Font := Self.Font;
    if AActivePage then
    begin
      Brush.Color := clBtnFace;
      if APage.Enabled or (csDesigning in ComponentState) then
        Font.Color  := clWindowText
      else
        Font.Color := clBtnShadow;
    end
    else begin
      Brush.Color := FTabColor;
      if ColorToRGB(FTabColor) < ColorToRGB(clSilver) then
      begin
        if not(APage.Enabled or (csDesigning in ComponentState)) then
          Font.Color := clCaptionDarkText
        else begin
          if APage <> FSelectedPage then
            Font.Color := clCaptionLightText
          else
            Font.Color := clCaptionText
        end;
      end
      else begin
        if not(APage.Enabled or (csDesigning in ComponentState)) then
          Font.Color := clGrayText
        else begin
          if APage <> FSelectedPage then
            Font.Color := clMenuText
          else
            Font.Color := clSelectedBlue
        end;
      end;
    end;

    with ARect do
    begin
      Left   := Left   + FItemMargins.Left   - 1;
      Right  := Right  - FItemMargins.Right  + 1;
      Top    := Top    + FItemMargins.Top    - 1;
      Bottom := Bottom - FItemMargins.Bottom + 1;
    end;

    if _getFlag(APage.FFlags, CP_FULLVISIBLE) then
      Flags := DT_SINGLELINE or DT_CENTER or DT_END_ELLIPSIS or DT_VCENTER
    else
      Flags := DT_SINGLELINE or DT_END_ELLIPSIS or DT_VCENTER;
    SetBkMode(Handle, TRANSPARENT);

    AText := APage.Caption;
    if Assigned(Images) then Dec(ARect.Bottom);
    if Assigned(Images) and (APage.ImageIndex > -1) and
      (Images.Width < ARect.Right-ARect.Left) then
    begin
      if AActivePage then
        AText := Format('/im{%d}/ow{5}%s', [APage.ImageIndex, AText])
      else begin
        if APage.Enabled or (csDesigning in ComponentState) then
          AText := Format('/id{%d, 170}/ow{5}%s', [APage.ImageIndex, AText])
        else
          AText := Format('/id{%d, 100}/ow{5}%s', [APage.ImageIndex, AText]);
      end;
      DrawHighlightText(ACanvas, PChar(AText), ARect, 1, Flags, Images);
    end
    else
      DrawText(Handle, PChar(APage.Caption), Length(APage.Caption), ARect, Flags);
  end;
end;

procedure TDCPageControl.ClearSelection;
 var
  Page: TDCCustomPage;
begin
  if not(csDesigning in ComponentState) and (FSelectedPage <> nil) then
  begin
    Page := FSelectedPage;
    FSelectedPage := nil;
    DrawTabText(Canvas, Page.FTabRect, FPages.VisibleIndexOf(Page.PageIndex),
      Page, ActivePage.PageIndex = Page.PageIndex);
  end;
end;

procedure TDCPageControl.MouseMove(Shift: TShiftState; X, Y: Integer);
 var
  i: integer;
  Page, APage: TDCCustomPage;
begin
  if not(csDesigning in ComponentState) and TabVisible then
  begin
    for i := 0 to FPages.VisibleCount-1 do
    begin
      Page := FPages.Items[Integer(FPages.FVisibleList.Items[i]^)];
      if PtInRect(Page.FTabRect, Point(X, Y)) then
      begin
        APage := FSelectedPage;
        FSelectedPage := Page;
        if APage <> Page then
        begin
          if APage <> nil then
            DrawTabText(Canvas, APage.FTabRect, i, APage, ActivePage.PageIndex = APage.PageIndex);
          DrawTabText(Canvas, Page.FTabRect, i, Page, ActivePage.PageIndex = Page.PageIndex);
        end;
        Exit;
      end;
    end;
    ClearSelection;
  end;
  inherited;
end;

procedure TDCPageControl.UpdateFirstIndex;
 var
  Page: TDCCustomPage;
  VisibleIndex: integer;
begin
  FFirstIndex  := -1;
  VisibleIndex := -1;
  if ActivePage <> nil then
  begin
    Page := ActivePage;
    if (csDesigning in ComponentState) then
      VisibleIndex := Page.PageIndex
    else
      if Page.IsPageVisible then VisibleIndex := FPages.VisibleIndexOf(Page.PageIndex);
    repeat
      Inc(FFirstIndex);
      UpdateTabsRect;
    until not IsRectEmpty(Page.FTabRect) and
      _getFlag(Page.FFlags, CP_FULLVISIBLE) or (FFirstIndex >= VisibleIndex);
 end;
end;

procedure TDCPageControl.ChangeActivePage(Page: TDCCustomPage);
 var
  ParentForm: TCustomForm;

  function PageRedraw(APage: TDCCustomPage): boolean;
  begin
    Result := (APage <> nil) and _getFlag(APage.FFlags, CP_FULLVISIBLE) and
     not IsRectEmpty(APage.FTabRect)
  end;

begin
  FChangedPage := ActivePage;

  FRedrawTabs  := PageRedraw(FChangedPage) and PageRedraw(Page);

  if FPageSelected and (ComponentState = []) and (Page <> nil) then
  begin
    ParentForm := GetParentForm(Self);
    if (ActivePage = Page) then
    begin
      if (ParentForm <> nil) and Page.Enabled and
         (ParentForm.ActiveControl <> Self) and Self.CanFocus then
      begin
        ParentForm.ActiveControl := Self;
        RedrawTab(ActivePage);
      end;
    end
    else if CanChange(Page) then
    begin
      if not Focused and (ParentForm <> nil) and
         FActivePage.ContainsControl(ParentForm.ActiveControl) then
        ParentForm.ActiveControl := ActivePage;
      inherited;
    end;
  end
  else
    inherited;
end;

procedure TDCPageControl.RedrawTab(Page: TDCCustomPage);
 var
  VisibleIndex: integer;
  ADefaultDraw, AActivePage: boolean;
  ARect: TRect;
begin
  ADefaultDraw := True;
  VisibleIndex := -1;
  if (csDesigning in ComponentState) then
    VisibleIndex := Page.PageIndex
  else
    if Page.IsPageVisible then VisibleIndex := FPages.VisibleIndexOf(Page.PageIndex);
  if VisibleIndex >= 0 then
  begin
    ARect := Page.FTabRect;
    DrawTab(Canvas, ARect, VisibleIndex, Page, ADefaultDraw, False);
    AActivePage := ActivePage.PageIndex = Page.PageIndex;
    DrawTabDiv(Canvas, ARect, AActivePage, Page.PageIndex = FFirstIndex);
  end;
end;

procedure TDCPageControl.WMKillFocus(var Message: TWMKillFocus);
begin
  inherited;
  PostMessage(Handle, CM_REDRAWTAB, Integer(ActivePage), 0);
end;

procedure TDCPageControl.CMRedrawTab(var Message: TMessage);
begin
  if FPageSelected then RedrawTab(TDCCustomPage(Message.WParam))
end;

procedure TDCPageControl.WMSetFocus(var Message: TWMSetFocus);
begin
  inherited;
  if not FTabVisible then Message.Result := 1
  else
    PostMessage(Handle, CM_REDRAWTAB, Integer(ActivePage), 0);
end;

procedure TDCPageControl.SetTabColor(const Value: TColor);
begin
  if FTabColor <> Value then
  begin
    FTabColor := Value;
    UpdateTracksColor;
    TabsChanged;
  end;
end;

procedure TDCPageControl.UpdatePage(Page: TDCCustomPage);
begin
  inherited;
  CheckToNextTrack;
  if not FNextTrack.Visible then CheckToPrevTrack;
end;

function TDCPageControl.GetItemSize(Page: TDCCustomPage): TPoint;
 var
  AText: string;
  ARect: TRect;
begin
  ARect := TabsRect;
  OffsetRect(ARect, -ARect.Left, -ARect.Top);
  if Assigned(Images) and (Page.ImageIndex > -1) then
  begin
    AText := Format('/im{%d}/ow{5}%s', [Page.ImageIndex, Page.Caption]);
    Result := DrawHighlightText(Canvas, PChar(AText), ARect, 0, DT_SINGLELINE, Images);
  end
  else begin
    Result.X := GetTextWidth(Canvas.Handle, Page.Caption);
    Result.Y := GetTextHeight(Canvas.Handle, Page.Caption);
  end;
end;

procedure TDCPageControl.DrawTabDiv(ACanvas: TCanvas; ARect: TRect;
  AActivePage, AFirst: boolean);
begin
  if FTabPosition in [tbBottom, tbTop] then
  begin
    ARect.Right := ARect.Left;
    ARect.Left  := ARect.Left - 1;
    InflateRect(ARect, 0, -1);
    if FTabPosition = tbBottom then
      ARect.Bottom  := ARect.Bottom + 1;
    with ACanvas do
    begin
      if not AActivePage then
      begin
        Brush.Color := FTabColor;
        FillRect(ARect);
        if AFirst then Exit;
        InflateRect(ARect, 0, -2);
        ARect.Bottom  := ARect.Bottom - 1;
        DrawEdge(Handle, ARect, BDR_RAISEDINNER, BF_LEFT or BF_FLAT);
      end
      else
        DrawEdge(Handle, ARect, BDR_RAISEDINNER, BF_LEFT);
    end;
  end;
end;

procedure TDCPageControl.UpdateTracksColor;

 procedure SetButtonsColor(AColor: TColor);
  var
   i: integer;
 begin
   if Assigned(FPrevTrack) then FPrevTrack.BrushColor := AColor;
   if Assigned(FNextTrack) then FNextTrack.BrushColor := AColor;
   for i := 0 to FTabButtons.Count - 1 do
     FTabButtons.Items[i].BrushColor := AColor
 end;

begin
  case FTabTracksStyle of
    dtNormal:
      SetButtonsColor(clBtnFace);
    dtFlat:
      SetButtonsColor(FTabColor);
    dtXPStyle:
      SetButtonsColor(FTabColor);
  end;

end;

procedure TDCPageControl.UpdateTracksStyle;

 procedure UpdateButtonStyle(AButton: TDCEditButton);
 begin
   with AButton do
   begin
     case FTabTracksStyle of
       dtNormal:
         begin
           Style := stNormal;
           Options := Options - [boSimpleStyle, boFrame];
         end;
       dtFlat:
         begin
           Style := stShadowFlat;
           Options := Options - [boSimpleStyle, boFrame];
         end;
       dtXPStyle:
         begin
           Style := stSingle;
           Options := Options + [boSimpleStyle, boFrame];
         end;
     end;
   end;
 end;

 var
  i: integer;
begin
  if Assigned(FPrevTrack) then
  begin
    UpdateButtonStyle(FPrevTrack);
    if FTabTracksStyle = dtNormal then
      FPrevTrack.Glyph.LoadFromResourceName(HInstance, 'DC_BTNLEFT')
    else
      FPrevTrack.Glyph.LoadFromResourceName(HInstance, 'DC_BTNCLEFT');
  end;
  if Assigned(FNextTrack) then
  begin
    UpdateButtonStyle(FNextTrack);
    if FTabTracksStyle = dtNormal then
      FNextTrack.Glyph.LoadFromResourceName(HInstance, 'DC_BTNRIGHT')
    else
      FNextTrack.Glyph.LoadFromResourceName(HInstance, 'DC_BTNCRIGHT');
  end;
  
  for i := 0 to FTabButtons.Count - 1 do
    UpdateButtonStyle(FTabButtons.Items[i]);
  UpdateTracksColor;
  TabsChanged;
end;

procedure TDCPageControl.CloseButtonClick(Sender: TObject);
begin
  {}
end;

procedure TDCPageControl.UpdateDeviceRegion(DC: HDC);
begin
  inherited;
  FTabButtons.UpdateDeviceRegion(DC);
  if FPrevTrack.Visible then
    with FPrevTrack do
       ExcludeClipRect(DC, Left, Top, Left+Width, Top+Height);
  if FNextTrack.Visible then
    with FNextTrack do
       ExcludeClipRect(DC, Left, Top, Left+Width, Top+Height);
end;

procedure TDCPageControl.SetOptions(const Value: TPageControlOptions);
 var
  ChangedOptions: TPageControlOptions;
  Button: TDCEditButton;
begin
  if FOptions <> Value then
  begin
    ChangedOptions := (FOptions + Value) - (FOptions * Value);
    FOptions := Value;
    if pcShowCloseButton in ChangedOptions then
    begin
      Button := FTabButtons.FindButton(SBC_BUTTONCLOSE);
      if pcShowCloseButton in Value then
        Button.Visible := True
      else
        Button.Visible := False;
    end;
    if ChangedOptions  <> [] then
    begin
      UpdateTracksStyle;
      UpdateTabSize;
    end;
  end;
end;

procedure TDCPageControl.SetTabTracksStyle(const Value: TDCDrawingStyle);
begin
  if FTabTracksStyle <> Value then
  begin
    FTabTracksStyle := Value;
    UpdateTracksStyle;
  end;
end;

procedure TDCPageControl.SetActivePage(const Value: TDCCustomPage);
begin
  if (Value <> nil) and (Value.PageControl <> Self) then Exit;
  if csLoading in ComponentState then
  begin
    FFirstIndex := 0;
    UpdateTabsRect;
  end;
  ChangeActivePage(Value);
  UpdateDesigner(Self);
end;

{ TDCOutBar }

procedure TDCCustomOutBar.CMFontChanged(var Message: TMessage);
begin
  inherited;
  UpdateTabSize;
end;

function TDCCustomOutBar.ControlRect: TRect;
begin
  Result := ClientRect;
  InflateRect(Result, -1, -1);
end;

constructor TDCCustomOutBar.Create(AComponent: TComponent);
begin
  inherited;
  Width       := 80;
  FTabMargins := Rect(4, 4, 4, 4);
  Align       := alLeft;
  FMode       := omNormal;
  FBuffered   := False;
//  TabStop := False;
  FTextAlignment := taCenter;
end;

procedure TDCCustomOutBar.CreateWnd;
begin
  inherited;
  UpdateTabSize;
end;

procedure TDCCustomOutBar.DoDrawTab(ACanvas: TCanvas; ARect: TRect;
  AIndex: integer; APage: TDCCustomPage; AActivePage: boolean);
const
 Aligmnts: array[TAlignment] of WORD = (DT_LEFT, DT_RIGHT, DT_CENTER);
 var
  Flags: Longint;
  AText: string;
  APoint: TPoint;
begin
  inherited;
  with ACanvas do
  begin
    Font := Self.Font;
    if APage.Enabled or (csDesigning in ComponentState) then
    begin
      Brush.Color := clBtnFace
    end
    else begin
      Font.Color  := clBtnShadow;
      Brush.Color := clBtnFace
    end;
    FillRect(ARect);

    DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);

    with ARect do
    begin
      Left   := Left   + FTabMargins.Left   - 1;
      Right  := Right  - FTabMargins.Right  + 1;
      Top    := Top    + FTabMargins.Top    - 1;
      Bottom := Bottom - FTabMargins.Bottom + 1;
    end;

    Flags := DT_SINGLELINE or Aligmnts[FTextAlignment] or DT_END_ELLIPSIS;

    AText := APage.Caption;
    if Assigned(Images) and (APage.ImageIndex > -1) then
    begin
      if APage.Enabled or (csDesigning in ComponentState) then
        AText := Format('/im{%d}/ow{5}%s', [APage.ImageIndex, AText])
      else
        AText := Format('/id{%d}/ow{5}%s', [APage.ImageIndex, AText]);
      if FTextAlignment = taCenter then
      begin
        Flags := DT_SINGLELINE or DT_END_ELLIPSIS;
        APoint := DrawHighlightText(ACanvas, PChar(AText), ARect, 0, Flags,
          Images);
        if APoint.X < (ARect.Right - ARect.Left) then
        begin
          OffsetRect(ARect, (ARect.Right - ARect.Left - APoint.X) div 2,0)
        end;
      end;
      DrawHighlightText(ACanvas, PChar(AText), ARect, 1, Flags, Images);
    end
    else
      DrawText(Handle, PChar(APage.Caption), Length(APage.Caption), ARect, Flags)
  end;
end;

procedure TDCCustomOutBar.DrawBorder(ACanvas: TCanvas);
 var
  ARect: TRect;
begin
  if (FPages.VisibleCount > 0) or
     ((csDesigning in ComponentState) and (FPages.Count > 0)) then
  begin

    if FTabVisible then
      ARect := GetCurrentPageRect
    else begin
      ARect := ClientRect;
      InflateRect(ARect, -2, -2);
    end;

    InflateRect(ARect, 1, 1);
    with ACanvas do
    begin
      Brush.Color := Self.Color;
      FrameRect(ARect);
      if ActivePage.Color = clBtnShadow then
      begin
        DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENINNER, BF_TOPLEFT);
      end
    end;
  end
  else begin
    ARect := ClientRect;
    ACanvas.Brush.Color := Self.Color;
    ACanvas.FillRect(ARect);
  end;

  ARect := ClientRect;
  DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENOUTER, BF_RECT or BF_ADJUST);
end;

procedure TDCCustomOutBar.DrawTabsArea(ACanvas: TCanvas);
begin
  inherited;
end;

function TDCCustomOutBar.GetCurrentPageRect: TRect;
 var
  AIndex, AVisibleCount: integer;
  PageOffset: TPoint;
begin
  Result := ControlRect;

  InflateRect(Result, -1, -1);
  try
    if (ActivePage <> nil) and (ActivePage.PageControl <> nil) then
    begin
      if csDesigning in ComponentState then
      begin
        AIndex := ActivePage.PageIndex;
        AVisibleCount := FPages.Count;
      end
      else begin
        AIndex := FPages.VisibleIndexOf(ActivePage.PageIndex);
        AVisibleCount := FPages.VisibleCount;
      end;
      if (AIndex > -1) then
      begin
        PageOffset.X := (AIndex + 1) * FTabHeight;
        PageOffset.Y := (AVisibleCount - AIndex - 1) * FTabHeight;
        Result.Top   := Result.Top + PageOffset.X;
        Result.Bottom:= Result.Bottom - PageOffset.Y;
      end;
    end;
  except
    //
  end;
end;

function TDCCustomOutBar.GetTabRect(AIndex: integer; Page: TDCCustomPage;
  var ARect: TRect): TRect;
 var
  PIndex, PVisibleCount : integer;
  PageOffset: TPoint;
  PRect: TRect;
begin
  SetRectEmpty(Result);
  PRect  := ControlRect;
  if ActivePage <> nil then
  begin
    if csDesigning in ComponentState then
    begin
      PIndex := ActivePage.PageIndex;
      PVisibleCount := FPages.Count;
    end
    else begin
      PIndex := FPages.VisibleIndexOf(ActivePage.PageIndex);
      PVisibleCount := FPages.VisibleCount;
    end;
    if PIndex > -1 then
    begin
      if AIndex <= PIndex then
        PageOffset.X := AIndex * FTabHeight
      else
        PageOffset.X := PRect.Bottom - (PVisibleCount - AIndex) * FTabHeight - 1;

      Result.Left  := PRect.Left;
      Result.Top   := PRect.Top   + PageOffset.X;
      Result.Right := PRect.Right;
      Result.Bottom:= Result.Top  + FTabHeight;
    end;
  end;
end;

function TDCCustomOutBar.GetTabsRect: TRect;
begin
  Result := ControlRect;
end;

procedure TDCCustomOutBar.Loaded;
begin
  inherited;
  Realign;
end;

procedure TDCCustomOutBar.Paint;
begin
  inherited;
end;

procedure TDCCustomOutBar.SetTabHeight(const Value: integer);
begin
  if FTabSize.Y <> Value then
  begin
    if Value >= 0 then FTabSize.Y := Value;
    UpdateTabSize;
  end;
end;

procedure TDCCustomOutBar.SetTextAlignment(const Value: TAlignment);
begin
  if FTextAlignment <> Value then
  begin;
    FTextAlignment := Value;
    invalidate;
  end;
end;

procedure TDCCustomOutBar.TabsChanged;
begin
  inherited;
end;

procedure TDCCustomOutBar.UpdateTabSize;
begin
  if HandleAllocated then
  begin
    Canvas.Font := Self.Font;
    FItemHeight := GetTextHeight(Canvas.Handle, 'Wg');
    if Assigned(Images) and (Images.Height > FItemHeight) then
      FItemHeight := Images.Height;

    if FTabSize.Y > 0 then
      FTabHeight := FTabSize.Y
    else
      with FTabMargins do
        FTabHeight := FItemHeight + Top + Bottom;

    TabsChanged;
  end;
end;

procedure TDCCustomOutBar.WMMouseMove(var Message: TWMMouseMove);
 var
  Page: TDCCustomPage;
begin
  if FMode = omMoveItem then
  begin
    KillTimer(Handle, OBMTIMER_IDEVENT);
    Page := GetPageAt(Message.Pos.X, Message.Pos.Y);
    if Page <> nil then SetTimer(Handle, OBMTIMER_IDEVENT, 500, nil);
  end;
  inherited;
end;

procedure TDCCustomOutBar.WMSize(var Message: TWMSize);
begin
  inherited;
  RepaintTabs;
end;

procedure TDCCustomOutBar.WMTimer(var Message: TWMTimer);
 var
  Page: TDCCustomPage;
  Pos: TPoint;
begin
  inherited;
  if (FMode = omMoveItem) and (Message.TimerID = OBMTIMER_IDEVENT) then
  begin
    GetCursorPos(Pos);
    Pos := ScreenToClient(Pos);
    Page := GetPageAt(Pos.X, Pos.Y);
    if Page <> nil then SetActivePage(Page);
  end;
end;

{ TDCPaleteBarPanel }

function TDCPaleteBarPanel.AddButton: TDCEditButton;
begin
  Result := inherited AddButton;
  if Result <> nil then
  begin
    Result.DrawText := FDrawText;
    if FDrawText then Result.Alignment := abImageTop;
    if FIconStyle then
    begin
      Result.Style    := stIcon;
      Result.DownClick:= False;
    end
    else begin
      Result.Style    := stOutbar;
      Result.DownClick:= True;
    end;
  end;
end;

function TDCPaleteBarPanel.ButtonVisible(Button: TDCEditButton): boolean;
begin
  with Button do Result := Visible and
    ((Left + Width) <= (Self.Width - FNextTrack.Width - 2));
end;

procedure TDCPaleteBarPanel.Click;
begin
  if PageControl <> nil then PageControl.Click;
end;

procedure TDCPaleteBarPanel.CMColorChanged(var Message: TMessage);
begin
  inherited;
  FPrevTrack.BrushColor := Color;
  FNextTrack.BrushColor := Color;
end;

procedure TDCPaleteBarPanel.CMHintShow(var Message: TCMHintShow);
 var
  AHintPos: TPoint;
begin
  if FHintObject <> nil then
  begin
    with Message, TDCEditButton(FHintObject) do
    begin
      HintInfo.HintStr := Hint;
      HintInfo.ReshowTimeout := 1000;
      AHintPos := Point(Left, Top + Height + 1);
      AHintPos := ClientToScreen(AHintPos);
      HintInfo.HintPos := AHintPos;
      Result := 0;
    end;
  end
  else
   inherited;
end;

constructor TDCPaleteBarPanel.Create(AOwner: TComponent);
begin
  inherited;
  ControlStyle := ControlStyle - [csAcceptsControls];
  FStyle   := isSmallImages;
  FOptions := [opDropDown];
  FAnchorStyle := asNone;
  FIconStyle   := False;
  BorderWidth  := 0;
end;

procedure TDCPaleteBarPanel.CreateTracks;
begin
  inherited;
  with FPrevTrack do
  begin
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNLEFT');
    Style := stShadowFlat;
    Top := 2;
  end;
  with FNextTrack do
  begin
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNRIGHT');
    Style := stShadowFlat;
    Top := 2;
  end;
end;

procedure TDCPaleteBarPanel.DblClick;
begin
  if PageControl <> nil then PageControl.DblClick;
end;

function TDCPaleteBarPanel.GetImages: TImageList;
begin
  Result := SmallImages;
end;

procedure TDCPaleteBarPanel.ItemClick(Sender: TObject);
 var
  Button: TDCEditButton;
  ParentForm: TCustomForm;
begin
  if Parent is TDCPaleteBar then
    Button := TDCPaleteBar(Parent).FButtons.FindButton(SBC_BUTTONCANCEL)
  else
    Button :=  nil;

  ParentForm := GetParentForm(Self);
  if FIconStyle and Assigned(Button) and (ParentForm <> nil) then
  begin
    ParentForm.ActiveControl := Self;
  end;

  if Assigned(Button) and (Button.ButtonState = btDownMouseInRect) then
  begin
    Button.ResetProperties;
    Button.Invalidate;
  end;

  inherited;
end;

procedure TDCPaleteBarPanel.Loaded;
 var
  i: integer;
begin
  inherited;
  for i:= 0 to Items.Count-1 do
  begin
    Items.Buttons[i].DrawText := FDrawText;
    if FDrawText then Items.Buttons[i].Alignment := abImageTop else
      Items.Buttons[i].Alignment := abLeft;
    if FIconStyle then
    begin
      Items.Buttons[i].Style    := stIcon;
      Items.Buttons[i].DownClick:= False;
    end
    else begin
      Items.Buttons[i].Style    := stOutbar;
      Items.Buttons[i].DownClick:= True;
    end;
  end;
  UpdateButtonsPos;
end;

procedure TDCPaleteBarPanel.SetButtonPos(Index: integer);
 var
  TextSize, Pos: TPoint;
  Button: TDCEditButton;
  AHeight: integer;
begin
  Button := Buttons.Buttons[Index];
  Pos.X  := 2 + FPrevTrack.Left + FPrevTrack.Width;

  case FStyle of
   isLargeImages:
     begin
       AHeight := Button.GetGlyphHeight + TextSize.Y + 6;
       if FDrawText then AHeight := AHeight + Button.TextSize.Y + 2;
     end;
   isSmallImages:
     begin
       AHeight := Button.GetGlyphHeight + 8;
       if FDrawText then AHeight := AHeight + Button.TextSize.Y + 2;
     end;
   else
     AHeight := 0;
  end;

  Pos.Y := 5;
  if (PageControl <> nil) and not PageControl.TabVisible then Dec(Pos.Y, 2);

  Button.Left  := Pos.X;
  Button.Top   := Pos.Y;
  Button.Height:= AHeight;
  if FDrawText then
    Button.Width := _intMax(Button.GetGlyphHeight, Button.TextSize.X) + 8
  else
    Button.Width := Button.GetGlyphHeight + 8;

  if Index < FFirstIndex then
  begin
    Button.Left   := Pos.X;
    Button.Top    := 0;
    Button.Height := 0;
    Button.Width  := 0;
    if not FPrevTrack.Visible then FPrevTrack.Visible := True;
  end
  else begin
    if (Index > 0) then
    begin
      with Buttons.Buttons[Index-1] do
      begin
        if FDrawText then
          Button.Left := (Left + Width) + 8
        else
          Button.Left := (Left + Width);
      end;
    end;
    if Button.Left + Button.Width > FNextTrack.Left then
      Button.Visible := False
    else
      Button.Visible := True;
  end
end;

procedure TDCPaleteBarPanel.SetDrawText(const Value: boolean);
 var
  i: integer;
begin
  FDrawText := Value;
  for i:= 0 to Items.Count-1 do
  begin
    Items.Buttons[i].DrawText := FDrawText;
    if FDrawText then Items.Buttons[i].Alignment := abImageTop else
      Items.Buttons[i].Alignment := abLeft;
  end;
  UpdateButtonsPos;
  UpdateTracksPos;
end;

procedure TDCPaleteBarPanel.SetIconStyle(const Value: boolean);
 var
  i: integer;
begin
  FIconStyle := Value;
  for i:= 0 to Items.Count-1 do
  begin
    if Value then
    begin
      Items.Buttons[i].Style    := stIcon;
      Items.Buttons[i].DownClick:= False;
    end
    else begin
      Items.Buttons[i].Style    := stOutbar;
      Items.Buttons[i].DownClick:= True;
    end;
    UpdateButtonsPos;
    UpdateTracksPos;
  end;
end;

procedure TDCPaleteBarPanel.SetImages(const Value: TImageList);
begin
  SmallImages := Value;
end;

function TDCPaleteBarPanel.TracksCovering: boolean;
begin
  if FPrevTrack.Visible and
    (FNextTrack.Left < (FPrevTrack.Left + FPrevTrack.Width)) then
    Result := True
  else
    Result := False;
end;

procedure TDCPaleteBarPanel.UpdateButtonsVisible;
 var
  i: integer;
  Button: TDCEditButton;
begin
  with Buttons do
    if Count > 0 then
    begin
      for i := 0 to Count-1 do
      begin
        Button := Buttons[i];
        Button.Visible := ButtonVisible(Button);
      end;
      CheckToNextTrack;
   end;
end;

procedure TDCPaleteBarPanel.UpdateTracksPos;
 var
  lVisible: boolean;
begin
  lVisible := False;
  with FPrevTrack do
  begin
    if Visible then
    begin
      Visible := False; lVisible := True;
    end;
    Left   :=  ClientRect.Left + 1;
    Top    :=  ClientRect.Top  + 2;
    Width  :=  13;
    if Assigned(Buttons.Images) then Height := Buttons.Images.Height + 8;
    if lVisible then
    begin
      Visible := True; lVisible := False;
    end;
  end;

  with FNextTrack do
  begin
    if Visible then
    begin
      Visible := False; lVisible := True;
    end;
    Left   :=  ClientRect.Right - 15;
    Top    :=  ClientRect.Top   + 2;
    Width  :=  13;
    if Assigned(Buttons.Images) then  Height := Buttons.Images.Height + 8;
    if lVisible and not TracksCovering then Visible := True;
  end;
end;

procedure TDCPaleteBarPanel.WMLButtonDown(var Message: TWMLButtonDown);
 var
  ParentForm: TCustomForm;
begin
  inherited;
  ParentForm := GetParentForm(Self);
  if FIconStyle and (ParentForm <> nil) then
  begin
    ParentForm.ActiveControl := Self;
  end;
end;

procedure TDCPaleteBarPanel.WMSize(var Message: TWMSize);
begin
  inherited;
  UpdateButtonsVisible;
end;

{ TDCPaleteBar }

procedure TDCPaleteBar.AddCancelButton;
begin
  with FButtons, FButtons.AddButton do
  begin
    Name := SBC_BUTTONCANCEL;
    Alignment := abCenter;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNARROW');
    Font := Self.Font;
    SetCancelButtonBounds;
    Style := stOutBar;
    AbsolutePos := False;
    EventStyle := esDropDown;
    DisableStyle := deNormal;
    BrushColor := Color;
    AnchorStyle := asNone;
    OnClick := CancelButtonClick;
    OnSetButtonState := SetButtonState;
    DrawText := False;
    Tag := SBN_BUTTONCANCEL;
    Visible := FCancelExist;
  end;
end;

procedure TDCPaleteBar.AdjustClientRect(var Rect: TRect);
 var
  Button: TDCEditButton;
begin
  inherited AdjustClientRect(Rect);
  if FCancelExist then
  begin
    Button := FButtons.FindButton(SBC_BUTTONCANCEL);
    if Assigned(Button) then Rect.Left := Rect.Left + Button.Width + 5;
  end;
end;

procedure TDCPaleteBar.Cancel;
begin
  CancelButtonClick(Self)
end;

procedure TDCPaleteBar.CancelButtonClick(Sender: TObject);
 var
  Button: TDCEditButton;
begin
  if CancelExist then
  begin
    Button := FButtons.FindButton(SBC_BUTTONCANCEL);
    if Button <> nil then
    begin
      if (ActivePage <> nil) and (ActivePage is TDCCustomOutBarPanel) then
        TDCCustomOutBarPanel(ActivePage).ActiveButton := nil;
      if Button.ButtonState <> btDownMouseInRect then
      begin
        Button.UpdateButtonState(Button.Left + 1, Button.Top + 1, True, False);
        Click;
      end
      else
        if not(csLoading in ComponentState) and Assigned(FOnCancel) then
          FOnCancel(Self)
    end;
  end;
end;

procedure TDCPaleteBar.CMColorChanged(var Message: TMessage);
begin
  inherited;
  FButtons.Color := Self.Color;
end;

procedure TDCPaleteBar.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  FButtons.MouseDown := GetAsyncKeyState(VK_LBUTTON)<0;
end;

procedure TDCPaleteBar.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  FButtons.UpdateButtons( -1, -1, False, True);
end;

constructor TDCPaleteBar.Create(AComponent: TComponent);
begin
  inherited;
  ControlStyle := ControlStyle - [csAcceptsControls];
  FButtons := TDCEditButtons.Create(Self);
  FButtons.Options := FButtons.Options - [boNCPainting];

  FTabMargins  := Rect(4, 6, 4, 4);
  FItemMargins := Rect(5, 3, 5, 3);
  FCancelExist := False;

  FTabMargins.Left  := FTabMargins.Left  + FPrevTrack.Width + 2;
  FTabMargins.Right := FTabMargins.Right + FNextTrack.Width + 6;

  FCancelSize := 0;
  FPageSelected := False;
end;

procedure TDCPaleteBar.CreateWnd;
begin
  inherited;
  if Parent <> nil then
  begin
    FButtons.ClrWndProc;
    FButtons.SetWndProc;
    AddCancelButton;
  end;
end;

destructor TDCPaleteBar.Destroy;
begin
  FButtons.Free;
  inherited;
end;

function TDCPaleteBar.GetCurrentPageRect: TRect;
begin
  Result := inherited GetCurrentPageRect;
end;

function TDCPaleteBar.GetSelectedItem: TDCEditButton;
begin
  Result :=  nil;
  if (ActivePage <> nil) and (ActivePage is TDCPaleteBarPanel) then
    Result := TDCPaleteBarPanel(ActivePage).Buttons.SelectedButton;
end;

procedure TDCPaleteBar.ImageListChange(Sender: TObject);
begin
  inherited;
  SetCancelButtonBounds;
  if ActivePage <> nil then ActivePage.AdjustSize;
end;

procedure TDCPaleteBar.InsertPage(Page: TDCCustomPage);
begin
  inherited;
  if Page is TDCPaleteBarPanel then
  begin
    TDCPaleteBarPanel(Page).Images := Images;
  end;
end;

procedure TDCPaleteBar.Paint;
begin
  UpdateDeviceRegion(Canvas.Handle);
  inherited;
end;

procedure TDCPaleteBar.RemovePage(Page: TDCCustomPage);
 var
  Button: TDCEditButton;
begin
  inherited;
  if (PageCount = 0) and not(csDestroying in ComponentState) then
  begin
    Button := FButtons.FindButton(SBC_BUTTONCANCEL);
    if Assigned(Button) and (Button.ButtonState = btDownMouseInRect) then
    begin
      Button.ResetProperties;
      Button.Invalidate;
    end;
  end;
end;

procedure TDCPaleteBar.RepaintFreeArea;
 var
  ARect, BRect: TRect;
  ARgn, BRgn: HRGN;
  AResult: integer;
begin
  BRect := ClientRect;
  AdjustClientRect(ARect);
  InflateRect(ARect, -2, -2);

  ARgn := CreateRectRgn(ARect.Left, ARect.Top, ARect.Right, ARect.Bottom);
  BRgn := CreateRectRgn(BRect.Left, BRect.Top, BRect.Right, BRect.Bottom);
  try
    AResult :=  CombineRgn(ARgn, BRgn, ARgn, RGN_DIFF);
    if AResult <> NULLREGION then
    begin
      Canvas.Brush.Color := Self.Color;
      FillRgn(Canvas.Handle, ARgn, Canvas.Brush.Handle)
    end;
  finally
    DeleteObject(ARgn);
    DeleteObject(BRgn);
  end;
end;

procedure TDCPaleteBar.SetActivePage(const Value: TDCCustomPage);
begin
  inherited;
  if (ActivePage = Value) and FCancelExist then Cancel;
end;

procedure TDCPaleteBar.SetButtonState(Sender: TObject;
  var State: TButtonState);
 var
  Button: TDCEditButton;
begin
  Button := FButtons.FindButton(SBC_BUTTONCANCEL);
  if Assigned(Button) then
  begin
    if (Sender = Button) and (Button.ButtonState = btDownMouseInRect) then
      State := btDownMouseInRect;
  end;
end;

procedure TDCPaleteBar.SetCancelButtonBounds(Repaint: boolean = True);
 var
  Button: TDCEditButton;
  Rect: TRect;
begin
  Button := FButtons.FindButton(SBC_BUTTONCANCEL);
  if Assigned(Button) then
  begin
    if TabVisible then
      Rect := GetTabsRect
    else
      Rect := ClientRect;

    with Button do
    begin
      Left := Rect.Left + 4;
      if (TabPosition = tbTop) and TabVisible then
        Top := Rect.Bottom + 4
      else begin
        Top := 4;
        if TabVisible then Top := Top + 2;
      end;
      if (Self.Images <> nil) and (FCancelSize = 0) then
      begin
        Width  := Self.Images.Width  + 8;
        Height := Self.Images.Height + 8;
      end
      else begin
        if FCancelSize = 0 then
        begin
          Width  := 24;
          Height := 24;
        end
        else begin
          Width  := FCancelSize;
          Height := FCancelSize;
        end;
      end;
    end
  end;
  Realign;
  if Repaint then RepaintFreeArea;
end;

procedure TDCPaleteBar.SetCancelExist(const Value: boolean);
 var
  Button: TDCEditButton;
begin
  if FCancelExist <> Value then
  begin
    Button := FButtons.FindButton(SBC_BUTTONCANCEL);
    FCancelExist := Value;
    if Assigned(Button) then Button.Visible := FCancelExist;
    if FCancelExist then Cancel;
    if ActivePage <> nil then
    begin
      ActivePage.AdjustSize;
      ActivePage.Invalidate;
    end
    else
      Repaint;
  end;
end;

procedure TDCPaleteBar.SetCancelSize(const Value: integer);
begin
  FCancelSize := Value;
  SetCancelButtonBounds(False);
  RepaintTabs;
end;

procedure TDCPaleteBar.SetImages(const Value: TImageList);
 var
  i: integer;
  Page: TDCPaleteBarPanel;
begin
  for i := 0 to PageCount - 1 do
  begin
    if (Pages[i] is TDCPaleteBarPanel) then
    begin
      Page := TDCPaleteBarPanel(Pages[i]);
      if Page.Images = Images then Page.Images := Value;
    end;
  end;
  inherited;
  SetCancelButtonBounds;
end;

procedure TDCPaleteBar.SetTabPosition(const Value: TLiteTabPosition);
begin
  if not(Value in [tbTop, tbBottom]) then Exit;
  inherited;
  SetCancelButtonBounds;
end;

procedure TDCPaleteBar.SetTabVisible(const Value: boolean);
begin
  inherited;
  SetCancelButtonBounds;
end;

procedure TDCPaleteBar.UpdateDeviceRegion(DC: HDC);
begin
  inherited;
  FButtons.UpdateDeviceRegion(DC);
end;

procedure TDCPaleteBar.UpdateTabSize;
begin
  if HandleAllocated and not(csDestroying in ComponentState) then
  begin
    Canvas.Font := Self.Font;
    FItemHeight := GetTextHeight(Canvas.Handle, 'Wg') + 1;

    if FTabSize.Y > 0 then
      FTabHeight := FTabSize.Y
    else
      with FTabMargins do
        FTabHeight := FItemHeight + Top + Bottom;

    FPrevTrack.Height := FTabHeight - 4;
    FNextTrack.Height := FTabHeight - 4;
    UpdateTracksPos;

    TabsChanged;
  end;
end;

{ TDCPage }

procedure TDCPage.CMBorderChanged(var Message: TMessage);
begin
  if csDesigning in ComponentState then
  begin
    invalidate;
  end;
  inherited;
end;

{ TDCCustomBrushImage }

procedure TDCCustomBrushImage.Change;
begin
  if Assigned(OnChange) then FOnChange(Self);
end;

constructor TDCCustomBrushImage.Create;
begin
  inherited Create;
  FOwner := AOwner;
  FBitmap := TBitmap.Create;
  FImageChangeLink :=  TChangeLink.Create;
  FImageChangeLink.OnChange := ImageLinkChanged;
  FImageIndex := -1;
  FOptions := [];

  FDisplay := pdTile;
  FAlphaBlend := False;
  FAlphaBlendValue := 255;
end;

destructor TDCCustomBrushImage.Destroy;
begin
  FreeAndNil(FBitmap);
  FreeAndNil(FImageChangeLink);
  inherited;
end;

procedure TDCCustomBrushImage.ImageLinkChanged(Sender: TObject);
begin
  ProcessPaintMessages;
  Change;
end;

procedure TDCCustomBrushImage.Draw(ACanvas: TCanvas; ARect, FullRect: TRect);
 var
  ABitmap, BBitmap, CBitmap: TBitmap;
  R, BRect, CRect: TRect;
  Pos, D: TPoint;
begin
  ABitmap := TBitmap.Create;
  CBitmap := ACanvas.Brush.Bitmap;
  SetRectEmpty(R);
  try
    if not FBitmap.Empty then
    begin
      with ABitmap do
      begin
        Width := FBitmap.Width;
        Height := FBitmap.Height;
        R := Rect(0, 0, Width, Height);
        Canvas.Brush.Color := ACanvas.Brush.Color;
        Canvas.FillRect(R);
        DrawTransparentBitmap(Canvas.Handle, FBitmap, R, False)
      end
    end
    else
      if Assigned(FImages) and (FImageIndex <> -1) and
        (FImageIndex < FImages.Count) then
      begin
        with ABitmap do
        begin
          Width := FImages.Width;
          Height := FImages.Height;
          R := Rect(0, 0, Width, Height);
          Canvas.Brush.Color := ACanvas.Brush.Color;
          Canvas.FillRect(R);
        end;
        FImages.Draw(ABitmap.Canvas, 0, 0, FImageIndex);
      end;

    if not IsRectEmpty(R) then
    begin

      if FAlphaBlend and (FAlphaBlendValue <> 255) then
      begin
        BBitmap := TBitmap.Create;
        try
          with BBitmap do
          begin
            Width  := ABitmap.Width;
            Height := BBitmap.Width;
            Canvas.Brush.Color := ACanvas.Brush.Color;
            Canvas.FillRect(R);
          end;
          DCEDitTools.AlphaBlend(BBitmap, ABitmap, ABitmap,
            255 - FAlphaBlendValue, ACanvas.Brush.Color, ACanvas.Brush.Color);
        finally
          BBitmap.Free;
        end;
      end;

      if boScrollable in FOptions then
        BRect := FullRect
      else
        BRect := ARect;

      case FDisplay of
         pdCenter:
           begin
             with BRect do
             begin
               Pos.X := (Right  + Left - ABitmap.Width ) shr 1;
               Pos.Y := (Bottom + Top  - ABitmap.Height) shr 1;
             end;
             ACanvas.FillRect(ARect);
             ACanvas.Draw(Pos.X, Pos.Y, ABitmap);
           end;
         pdTile:
           begin
             ACanvas.Brush.Bitmap := ABitmap;
             if boScrollable in FOptions then
             begin
               D.X := (ARect.Left - FullRect.Left) mod ABitmap.Width;
               D.Y := (ARect.Top  - FullRect.Top ) mod ABitmap.Height;
               if not((D.X = 0) and (D.Y = 0)) then
               begin
                 CRect := Rect(0, 0, ABitmap.Width, ABitmap.Height);
                 BRect := CRect;
                 OffsetRect(BRect, 0, -D.Y);
                 while BRect.Top < ARect.Bottom do
                 begin
                   BRect.Left  := 0;
                   BRect.Right := ABitmap.Width;
                   OffsetRect(BRect, -D.X, 0);
                   while BRect.Left < ARect.Right do
                   begin
                     ACanvas.CopyRect(BRect, ABitmap.Canvas, CRect);
                     OffsetRect(BRect, ABitmap.Width, 0);
                   end;
                   OffsetRect(BRect, 0, ABitmap.Height);
                 end;
               end
               else
                 ACanvas.FillRect(BRect);
             end
             else
               ACanvas.FillRect(BRect);
           end;
         pdStretch:
           ACanvas.StretchDraw(BRect, ABitmap);
         pdTopLeft:
           begin
             Pos.X := BRect.Left;
             Pos.Y := BRect.Top;
             ACanvas.FillRect(ARect);
             ACanvas.Draw(Pos.X, Pos.Y, ABitmap);
           end;
         pdTopRight:
           begin
             Pos.X := BRect.Right - ABitmap.Width;
             Pos.Y := BRect.Top;
             ACanvas.FillRect(ARect);
             ACanvas.Draw(Pos.X, Pos.Y, ABitmap);
           end;
         pdBottomLeft:
           begin
             Pos.X := BRect.Left;
             Pos.Y := BRect.Bottom - ABitmap.Height;
             ACanvas.FillRect(ARect);
             ACanvas.Draw(Pos.X, Pos.Y, ABitmap);
           end;
         pdBottomRight:
           begin
             Pos.X := BRect.Right - ABitmap.Width;
             Pos.Y := BRect.Bottom - ABitmap.Height;
             ACanvas.FillRect(ARect);
             ACanvas.Draw(Pos.X, Pos.Y, ABitmap);
           end;
      end;
    end
    else
      ACanvas.FillRect(ARect);

  finally
    ACanvas.Brush.Bitmap := CBitmap;
    ABitmap.Free;
  end;

end;

function TDCCustomBrushImage.Empty: boolean;
begin
  Result := Bitmap.Empty and ((FImageIndex = -1) or not Assigned(FImages));
end;

procedure TDCCustomBrushImage.SetAlphaBlend(const Value: boolean);
begin
  if FAlphaBlend <> Value then
  begin
    FAlphaBlend := Value;
    Change;
  end;
end;

procedure TDCCustomBrushImage.SetAlphaBlendValue(const Value: integer);
begin
  if FAlphaBlendValue <> Value then
  begin
    FAlphaBlendValue := Value;
    Change;
  end;
end;

procedure TDCCustomBrushImage.SetBitmap(const Value: TBitmap);
begin
  FBitmap.Assign(Value);
  Change;
end;

procedure TDCCustomBrushImage.SetDisplay(const Value: TPictureDispay);
begin
  if FDisplay <> Value then
  begin
    FDisplay := Value;
    Change;
  end;
end;

procedure TDCCustomBrushImage.SetImageIndex(const Value: integer);
begin
  FImageIndex := Value;
  Change;
end;

procedure TDCCustomBrushImage.SetImages(const Value: TImageList);
begin
  if FImages <> nil then
    FImages.UnRegisterChanges(FImageChangeLink);
  FImages := Value;
  if FImages <> nil then
  begin
    FImages.RegisterChanges(FImageChangeLink);
    FImages.FreeNotification(FOwner);
  end;
  Change;
end;

function TDCCustomBrushImage.GetImageRgn(ARect: TRect): HRGN;
 var
  R: TRect;
  Pos: TPoint;
begin
  if not Empty then
  begin
    if not FBitmap.Empty then
      R := Rect(0, 0, FBitmap.Width, FBitmap.Height)
    else
      R := Rect(0, 0, FImages.Width, FImages.Height);

    case FDisplay of
       pdCenter:
         begin
           Pos.X := (ARect.Right + ARect.Left - R.Right) shr 1;
           Pos.Y := (ARect.Bottom + ARect.Top - R.Bottom) shr 1;
         end;
       pdTopLeft:
         begin
           Pos.X := 0;
           Pos.Y := 0;
         end;
       pdTopRight:
         begin
           Pos.X := ARect.Right - R.Right;
           Pos.Y := 0;
         end;
       pdBottomLeft:
         begin
           Pos.X := 0;
           Pos.Y := ARect.Bottom - R.Bottom;
         end;
       pdBottomRight:
         begin
           Pos.X := ARect.Right - R.Right;
           Pos.Y := ARect.Bottom - R.Bottom;
         end;
       else
         Pos.X := -1;
    end;

    if Pos.X <> -1 then
    begin
      OffsetRect(R, Pos.X, Pos.Y);
      Result := CreateRectRgnIndirect(R);
    end
    else
      Result := CreateEmptyRgn;
  end
  else
    Result := CreateEmptyRgn;
end;

procedure TDCCustomBrushImage.SetOptions(const Value: TBrushOptions);
 var
  ChangedOptions: TBrushOptions;
begin
  if FOptions <> Value then
  begin
    ChangedOptions := (FOptions + Value) - (FOptions * Value);
    FOptions := Value;
    Change;
  end;
end;

{ TDCCustomCheckBox }

procedure TDCCustomCheckBox.ActionChange(Sender: TObject;
  CheckDefaults: Boolean);
begin
  inherited ActionChange(Sender, CheckDefaults);
  if Sender is TCustomAction then
    with TCustomAction(Sender) do
    begin
      if not CheckDefaults or (Self.Checked = False) then
        Self.Checked := Checked;
    end;
end;

procedure TDCCustomCheckBox.CMDialogChar(var Message: TCMDialogChar);
begin
  with Message do
  begin
    if IsAccel(CharCode, Caption) and CanFocus then
    begin
      SetFocus;
      if Focused then Toggle;
      Result := 1;
    end
    else
      inherited;
  end;
end;

procedure TDCCustomCheckBox.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  InvalidateState;
end;

procedure TDCCustomCheckBox.CNCommand(var Message: TWMCommand);
begin
  if Message.NotifyCode = BN_CLICKED then Toggle;
end;

procedure TDCCustomCheckBox.CNDrawItem(var Message: TWMDrawItem);
 var
  DrawState, Index: Integer;
  R1, R2: TRect;
  Brush, FlatBrush, FlatPen: HBrush;
  Rgn: HRGN;
  LogBrush: TLogBrush;
begin
  with Message.DrawItemStruct^ do
  begin
    Brush := CreateSolidBrush(ColorToRGb(Color));
    try
      case FState of
        cbChecked:
          DrawState := DFCS_BUTTONCHECK or DFCS_CHECKED;
        cbUnchecked:
          DrawState := DFCS_BUTTONCHECK;
        else // cbGrayed
          DrawState := DFCS_BUTTON3STATE or DFCS_CHECKED;
      end;
      if not Enabled then DrawState := DrawState or DFCS_INACTIVE;
      if itemAction = ODA_SELECT then DrawState := DrawState or DFCS_INACTIVE;

      R1 := GetStateRect(rcItem);
      R2 := ClientRect;
      if itemAction <> ODA_SELECT then
      begin
        FillRect(hDC, rcItem, Brush);
        DrawText(hDc, PChar(Caption), Length(Caption), R2, DT_CALCRECT or
          DT_SINGLELINE);

        case FAlignment of
          taRightJustify:
            OffsetRect(R2, R1.Right + 5,
             (ClientRect.Bottom + ClientRect.Top - R2.Bottom + R2.Top) shr 1);
          taLeftJustify:
            begin
              OffsetRect(R2, 3,
                (ClientRect.Bottom + ClientRect.Top - R2.Bottom + R2.Top) shr 1);
              R2.Right := _intMin(R2.Right, ClientRect.Right - CheckBoxWidth - 1)
            end;
        end;
        DrawText(hDc, PChar(Caption), Length(Caption), R2, DT_SINGLELINE);

        if Focused and (Caption <> '') then
        begin
          InflateRect(R2, 2, 1);
          DrawFocusRect(hDC, R2);
        end;
      end;

      if DrawStyle in [fsFlat, fsSingle] then
      begin
        Index := SaveDC(hDC);
        with R1 do
          Rgn := CreateRectRgn(Left + 2, Top + 2, Right - 2, Bottom - 2);
        SelectClipRgn(hDc, Rgn);
        DrawFrameControl(hDC, R1, DFC_BUTTON, DrawState);
        RestoreDC(hDC, Index);

        if DrawStyle = fsSingle then
        begin
          FlatPen := CreatePen(PS_SOLID, 1, ColorToRgb(clBtnShadow));
          with LogBrush do
          begin
            lbColor := Color;
            lbStyle := BS_NULL;
          end;
          FlatBrush := CreateBrushIndirect(LogBrush);

          SelectObject(hDc, FlatBrush);
          SelectObject(hDc, FlatPen);
          with R1 do
            Rectangle(hDc, Left + 1, Top + 1, Right - 1, Bottom - 1);

          DeleteObject(FlatPen);
          DeleteObject(Rgn);
          DeleteObject(FlatBrush);
        end
        else begin
          DrawEdge(hDc, R1, BDR_SUNKENOUTER, BF_RECT);
          InflateRect(R1, -1, -1);
          FrameRect(hDc, R1, GetSysColorBrush(COLOR_BTNFACE));
        end;
      end
      else
        DrawFrameControl(hDC, R1, DFC_BUTTON, DrawState);

    finally
      DeleteObject(Brush);
    end;
  end;
end;

constructor TDCCustomCheckBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Width := 97;
  Height := 17;
  TabStop := True;
  ControlStyle := [csSetCaption, csDoubleClicks];
  FAlignment := taRightJustify;
end;

procedure TDCCustomCheckBox.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  CreateSubClass(Params, 'BUTTON');
  with Params do Style := Style or BS_OWNERDRAW or BS_CHECKBOX;
end;

procedure TDCCustomCheckBox.CreateWnd;
begin
  inherited;
end;

function TDCCustomCheckBox.GetActionLinkClass: TControlActionLinkClass;
begin
  Result := TButtonActionLink;
end;

function TDCCustomCheckBox.GetChecked: Boolean;
begin
  Result := State = cbChecked;
end;

function TDCCustomCheckBox.GetControlsAlignment: TAlignment;
begin
  if not UseRightToLeftAlignment then
    Result := taRightJustify
  else
    if FAlignment = taRightJustify then
      Result := taLeftJustify
    else
      Result := taRightJustify;
end;

function TDCCustomCheckBox.GetDrawStyle: TControlStyle;
begin
  Result := FDrawStyle;
end;

function TDCCustomCheckBox.GetStateRect(R: TRect): TRect;
 var
  ATop: integer;
begin
  ATop := (R.Bottom + R.Top - CheckBoxHeight) shr 1;
  case FAlignment of
    taRightJustify:
      Result := Rect(0, ATop, CheckBoxWidth, ATop + CheckBoxHeight);
    taLeftJustify:
      Result := Rect(Width - CheckBoxWidth, ATop, Width, ATop + CheckBoxHeight);
  end;
end;

procedure TDCCustomCheckBox.InvalidateState;
 var
  R: TRect;
begin
  if HandleAllocated then
  begin
    R := GetStateRect(ClientRect);
    InvalidateRect(Handle, @R, False);
  end;
end;

function TDCCustomCheckBox.IsCheckedStored: Boolean;
begin
  Result := (ActionLink = nil) or
    not TInternalButtonActionLink(ActionLink).IsCheckedLinked;
end;

procedure TDCCustomCheckBox.SetAlignment(const Value: TLeftRight);
begin
  if FAlignment <> Value then
  begin
    FAlignment := Value;
    invalidate;
  end;
end;

procedure TDCCustomCheckBox.SetChecked(const Value: Boolean);
begin
  if Value then State := cbChecked else State := cbUnchecked;
end;

procedure TDCCustomCheckBox.SetDrawStyle(const Value: TControlStyle);
begin
  if FDrawStyle <> Value then
  begin
    FDrawStyle := Value;
    InvalidateState;
  end;
end;

procedure TDCCustomCheckBox.SetState(const Value: TCheckBoxState);
begin
  if FState <> Value then
  begin
    FState := Value;
    Click;
    InvalidateState;
  end;
end;

procedure TDCCustomCheckBox.Toggle;
begin
  if Enabled and not(csDesigning in ComponentState) then
  begin
    case State of
      cbUnchecked:
        if AllowGrayed then State := cbGrayed else State := cbChecked;
      cbChecked:
        State := cbUnchecked;
      cbGrayed:
        State := cbChecked;
    end;
  end;
end;

procedure TDCCustomCheckBox.WndProc(var Message: TMessage);
begin
  case Message.Msg of
    WM_LBUTTONDOWN:
      if not (csDesigning in ComponentState) and not Focused then
      begin
        Windows.SetFocus(Handle);
        if not Focused then Exit;
      end;
    WM_LBUTTONDBLCLK:
      if not (csDesigning in ComponentState) and not Focused then
      begin
        Windows.SetFocus(Handle);
        if not Focused then Exit;
        Toggle;
      end;
  end;
  inherited WndProc(Message);
end;

{ TButtonGroupItem }

function TButtonGroupItem.AddButtonEx(
  EditButtonClass: TEditButtonClass; Data: integer): TDCEditButton;
begin
  if FSections.Items[Data] <> nil then
    Result := FSections.Items[Data].AddButton(EditButtonClass)
  else
    Result := nil
end;

procedure TButtonGroupItem.BeginUpdate;
begin
  Inc(FUpdateCount);
end;

function TButtonGroupItem.ButtonVisible(Sender: TDCEditButton): boolean;
begin
  Result := Visible and (not(bgExpandable in Options) or Expanded)
end;

procedure TButtonGroupItem.Collapse(Recurse: boolean);
begin
  if _getFlag(FFlags, BG_ITEMEXPANDED) then
  begin
    _setFlag(FFlags, BG_ITEMEXPANDED, False);
    Changed(True);
  end;
end;

constructor TButtonGroupItem.Create(Collection: TCollection);
begin
  inherited;
  FAlignment := gaTop;
  FCaptionHeight := 0;
  FDrawStyle := dsNormal;
  FEnabled := True;
  FIndent := 5;
  FOptions := [bgShowLine];
  FUpdateCount := 0;
  FVisible := True;
  FSections := TGroupSections.Create(Self);
end;

destructor TButtonGroupItem.Destroy;
begin
  FSections.Free;
  inherited;
end;

procedure TButtonGroupItem.DrawCaption(ACanvas: TCanvas);
 var
  R: TRect;
  h: integer;
begin
  R := FBoundsRect;
  if (bgExpandable in Options) and (FSections.ButtonsCount > 0) then
  begin
    DrawExpandRect(ACanvas, GetExpandButtonRect);
    Inc(R.Left, GetExpandButtonSize + 5);
  end;

  if not Enabled then
    ACanvas.Font.Color := clBtnShadow
  else
    ACanvas.Font.Color := Collection.GetTaskPanel.Font.Color;

  SetBkMode(ACanvas.Handle, Windows.TRANSPARENT);

  ACanvas.Font.Style := ACanvas.Font.Style + [fsBold];
  h := DrawText(ACanvas.Handle, PChar(FCaption), -1, R, DT_LEFT or
    DT_WORDBREAK or DT_END_ELLIPSIS);

  if (h > 0) and (bgShowLine in Options)  then
  begin
    Inc(R.Top, h);
    ACanvas.Pen.Color := clBtnShadow;
    ACanvas.MoveTo(R.Left, R.Top);
    ACanvas.LineTo(R.Right, R.Top);
  end;

  ACanvas.Font.Style := ACanvas.Font.Style - [fsBold];

  if FComment <> '' then
  begin
    Inc(R.Top, 5);
    DrawText(ACanvas.Handle, PChar(FComment), -1, R, DT_LEFT or
      DT_WORDBREAK or DT_END_ELLIPSIS);
  end;

end;

procedure TButtonGroupItem.EndUpdate;
begin
  Dec(FUpdateCount);
  if FUpdateCount = 0 then Collection.Invalidate;
end;

procedure TButtonGroupItem.Expand(Recurse: boolean);
begin
  if not _getFlag(FFlags, BG_ITEMEXPANDED) then
  begin
    _setFlag(FFlags, BG_ITEMEXPANDED, True);
    Changed(True);
  end;
end;

function TButtonGroupItem.GetActiveButton: TDCEditButton;
begin
  Result := FActiveButton;
end;

function TButtonGroupItem.GetButton(Index: integer): TDCEditButton;
 var
  i, j, iCount: integer;
begin
  Result := nil;
  iCount := FSections.Count - 1;
  j := Index;
  for i := 0 to iCount do with FSections.Items[i] do
  begin
    if Count > j then
    begin
      Result := TDCEditButton(Items[j]);
      Break;
    end
    else
      Dec(j, Count);
  end;
end;

function TButtonGroupItem.GetExpandButtonRect: TRect;
 var
  h: integer;
begin
  if (bgExpandable in Options) and (FSections.ButtonsCount > 0) then
  begin
    h :=  Collection.GetTextHeight('Wg', 0, []);
    if h > 0 then  h := _intMax(0, (h - GetExpandButtonSize)) div 2;

    Result := Rect(0, h, GetExpandButtonSize, h + GetExpandButtonSize);
    OffsetRect(Result, FBoundsRect.Left, FBoundsRect.Top);
  end;
end;

function TButtonGroupItem.GetButtonsRect: TRect;
 var
  i, c: integer;
  Button: TDCEditButton;
  R: TRect;
  lEmpty: boolean;
begin
  SetRectEmpty(Result);
  c := Count - 1;
  lEmpty := True;
  for i := 0 to c do
  begin
    Button := Items[i];
    with Button do
      if Visible then
      begin
        R := Rect(Left, Top, Left + Width, Top + Height);
        if lEmpty then
        begin
          Result := R;
          lEmpty := False;
        end
        else
          UnionRect(Result, Result, R);
      end;
  end;
end;

function TButtonGroupItem.GetCollection: TButtonGroups;
begin
  Result := TButtonGroups(inherited Collection);
end;

function TButtonGroupItem.GetCount: integer;
begin
  if Visible and (not(bgExpandable in Options) or Expanded) then
    Result := FSections.ButtonsCount
  else
    Result := 0;
end;

function TButtonGroupItem.GetFlagValue(const Index: Integer): boolean;
begin
  Result := _getFlag(FFlags, Index)
end;

function TButtonGroupItem.GetGroupHeight: integer;
 var
  i, j, h, w, w1, w2: integer;
  ATextSize: TPoint;
begin
  Result := FCaptionHeight;

  if not(bgExpandable in Options) or Expanded then
  begin
    w := Collection.TaskPanel.ActualWidth;
    for i := 0 to FSections.Count - 1 do
    begin
      with FSections.Items[i] do
      begin
        Inc(Result, FMarginTop);
        h  := 0;
        w2 := FIndent + FMarginLeft;
        w1 := w2;
        for j := 0 to Count - 1 do
        begin
          with Items[j] do if Visible then
          begin
            case FOrientation of
              itVertical:
                begin
                  if WordWrap then
                  begin
                    Width := w;
                    ATextSize := GetTextSize;
                    AdjustWidth(ATextSize.X);
                    Height := ATextSize.Y;
                  end;
                  Inc(h, Height + FVSpacing);
                end;
              itHorizontal:
                begin
                  if WordWrap then
                  begin
                    Width := w - w1;
                    ATextSize := GetTextSize;
                    AdjustWidth(ATextSize.X);
                    Height := ATextSize.Y;
                    Inc(Result, Height + FVSpacing);
                    h  := 0;
                    w1 := w2;
                  end
                  else begin
                    if soWrapItems in FOptions then
                    begin
                      if w1 + Width + FHSpacing > w then
                      begin
                        Inc(Result, h);
                        h  := Height + FVSpacing;
                        w1 := w2;
                      end;
                      Inc(w1, Width + FHSpacing);
                    end;
                    h := _intMax(h, Height + FVSpacing);
                  end;
                end;
            end;
          end;
        end;
        Inc(Result, h + FMarginBottom);
      end;

    end;
  end;
  FCacheHeight := Result;
end;

function TButtonGroupItem.GetHitTestInfoAt(X,
  Y: Integer): TGroupItemHitTests;
 var
  R, ARect: TRect;
  h: integer;
  P: TPoint;
begin
  Result := giNowere;
  P := Point(X, Y);
  R := FBoundsRect;
  R.Bottom := R.Top + FCaptionHeight;

  if PtInRect(R, P) then
  begin
    ARect := GetExpandButtonRect;
    if PtInRect(ARect, P) then
    begin
      Result := giOnButton;
      Exit;
    end;

    h := Collection.GetTextHeight(FCaption, x, [fsBold]);
    if (bgExpandable in Options) and (Count > 0) then
      Inc(R.Left, ARect.Right + 3);

    R.Bottom := R.Top + h;
    if PtInRect(R, P) then
    begin
      Result := giOnCaption;
      Exit;
    end
    else begin
      R.Top := R.Bottom;
      R.Bottom := FBoundsRect.Bottom;
      if PtInRect(R, P) then  Result := giOnComment
    end;
  end
  else begin
    if PtInRect(GetButtonsRect, P) then
      Result := giOnItems
    else
      if (X < FIndent) and PtInRect(FBoundsRect, P) then Result := giOnIndent
  end;
end;

function TButtonGroupItem.GetMaxImageWidth: integer;
begin
  Result := -1
end;

function TButtonGroupItem.GetRegion: HRGN;
begin
  Result := Collection.FButtons.GetRegion;
end;

function TButtonGroupItem.GetWinControl: TWinControl;
begin
  Result := TButtonGroups(Collection).FButtons.Owner;
end;

procedure TButtonGroupItem.Invalidate;
begin
  {}
end;

procedure TButtonGroupItem.MoveButton(CurIndex, NewIndex: integer);
begin
  {}
end;

procedure TButtonGroupItem.Notify(Button: TDCEditButton;
  Action: TDCButtonAction);
 var
  w, h: integer;
begin
  if not _getFlag(Collection.TaskPanel.FFlags, TP_NOTIFYITEM) then
  begin
    if Action in [acEnabledChanged, acStateChanged] then
    begin
      Button.Invalidate;
      Exit;
    end;
    _setFlag(Collection.TaskPanel.FFlags, TP_NOTIFYITEM, True);
    with Button do
    begin
      if Collection.TaskPanel.Images <> nil then
      begin
        w := Collection.TaskPanel.Images.Width;
        h := Collection.TaskPanel.Images.Height;
      end
      else begin
        w := 0;
        h := 0;
      end;
      if AutoSize then
      begin
        if not WordWrap then
        begin
          Height := _intMax(TextSize.Y, h) + 2;
          if ImageIndex <> -1 then
            Width := TextSize.X + w + 5
          else
            Width := TextSize.X + 2;
        end
        else begin
           Width :=  Collection.TaskPanel.ActualWidth - FIndent;
           Height := GetTextSize.Y;
        end;
      end;
    end;
    Changed(True);
     _setFlag(Collection.TaskPanel.FFlags, TP_NOTIFYITEM, False);
  end;
end;

procedure TButtonGroupItem.OffsetButtons(Pos: TPoint);
begin
  {}
end;

procedure TButtonGroupItem.PaintBackground(ARect: TRect;
  AButton: TDCEditButton; ACanvas: TCanvas);
begin
  Inc(ARect.Right, 1);
  Collection.FButtons.PaintBackground(ARect, AButton, ACanvas);
end;

function TButtonGroupItem.QueryInterface(const IID: TGUID;
  out Obj): HResult;
begin
  Pointer(Obj) := Self;
  Result := S_OK;
end;

procedure TButtonGroupItem.ScrollGroup(Delta: integer);
 var
  i, c: integer;
  lVisible: boolean;
begin
  OffsetRect(FBoundsRect, 0, Delta);
  if not(bgExpandable in Options) or Expanded then
  begin
    lVisible := Visible;
    c := Count - 1;
    for i := 0 to c do with Items[i] do
    begin
      if lVisible and Visible then Top := Top + Delta;
    end;
  end;
end;

procedure TButtonGroupItem.SetActiveButton(const Value: TDCEditButton);
begin
  FActiveButton := Value;
end;

procedure TButtonGroupItem.SetAligment(const Value: TGroupAlignment);
begin
  if FAlignment <> Value then
  begin
    FAlignment := Value;
    Changed(True);
  end;
end;

procedure TButtonGroupItem.SetButton(Index: integer;
  const Value: TDCEditButton);
begin
  Items[Index].Assign(Value);
end;

procedure TButtonGroupItem.SetCaption(const Value: TCaption);
begin
  if FCaption <> Value then
  begin
    FCaption := Value;
    Changed(UpdateCaptionHeight);
  end;
end;

procedure TButtonGroupItem.SetCollection(const Value: TButtonGroups);
begin
  {$IFDEF DELPHI_V6}
     inherited SetCollection(Value);
  {$ELSE}
     inherited Collection := Value;
  {$ENDIF}
end;

procedure TButtonGroupItem.SetComment(const Value: string);
begin
  if FComment <> Value then
  begin
    FComment := Value;
    Changed(UpdateCaptionHeight);
  end;
end;

procedure TButtonGroupItem.SetDrawStyle(const Value: TGroupItemDrawStyle);
begin
  if FDrawStyle <> Value then
  begin
    FDrawStyle := Value;
    Changed(False);
  end;
end;

procedure TButtonGroupItem.SetEnabled(const Value: boolean);
begin
  FEnabled := Value;
end;

procedure TButtonGroupItem.SetFlagValue(Index: Integer;
  const Value: boolean);
begin
  _setFlag(FFlags, Index, Value);
end;

procedure TButtonGroupItem.SetOptions(const Value: TButtonGroupOptions);
 var
  ChangedOptions: TButtonGroupOptions;
begin
  if FOptions <> Value then
  begin
    ChangedOptions := (FOptions + Value) - (FOptions * Value);
    FOptions := Value;
    Changed(False);
  end;
end;

procedure TButtonGroupItem.SetVisible(const Value: boolean);
begin
  if Visible <> Value then
  begin
    FVisible := Value;
    Changed(True);
  end;
end;

function TButtonGroupItem.UpdateCaptionHeight: boolean;
 var
  h, x: integer;
begin
  if (bgExpandable in Options) and (FSections.ButtonsCount > 0) then
  begin
    x := GetExpandButtonSize + 5;
    h := _intMax(GetExpandButtonSize, Collection.GetTextHeight(FCaption, x,
      [fsBold]));
  end
  else begin
    x := 0;
    h := Collection.GetTextHeight(FCaption, x, [fsBold]);
  end;

  if h > 0 then Inc(h, 5);

  if FComment <> '' then
    h := h + Collection.GetTextHeight(FComment, x, []) + 5;
  if h <> FCaptionHeight then
  begin
    FCaptionHeight := h;
    Result := True;
  end
  else
    Result := False
end;

function TButtonGroupItem.UpdateCount: integer;
begin
  Result := FUpdateCount + Collection.UpdateCount;
end;

procedure TButtonGroupItem.UpdateGroupPos(PosY: integer);
 var
  i, j, n, h, w, w1, w2, w3, h1: integer;
  lVisible: boolean;

  function NeedImages(Item: TDCEDitButton; var Offset: integer): boolean;
  begin
    if Collection.TaskPanel.Images <> nil then
    begin
      if Item is TDCLinkButton then
      begin
        Result := True;
        Offset := Collection.TaskPanel.Images.Width + BT_IMAGEOFFSET;
        Exit;
      end;
      if Item is TDCCheckButton then
      begin
        Result := True;
        Offset := Collection.TaskPanel.Images.Width - BT_IMAGEOFFSET -
          TDCCheckButton(Item).BoxSize + 1;
        Exit;
      end;
    end;
    Result := False;
  end;

  procedure UpdateCentered(Index, w2: integer);
   var
    l1, j1: integer;
  begin
    l1 := w2 +(w - w2) div 2;
    j1 := Index - 1;
    while w2 > 0 do
    begin
      with FSections.Items[i], Items[j1] do
      begin
        Left := l1 - Width;
        Dec(l1, Width + FHSpacing);
        Dec(w2, Width);
        if j1 <> index then Dec(w2, FHSpacing);
        Dec(j1);
      end;
    end;
  end;
begin
  h := PosY + FCaptionHeight;
  if not(bgExpandable in Options) or Expanded then
  begin
    lVisible := Visible;
    w := Collection.TaskPanel.ActualWidth;
    for i := 0 to FSections.Count - 1 do
    begin
      with FSections.Items[i] do
      begin
        Inc(h, FMarginTop);
        w3 := FIndent + FMarginLeft;
        w1 := w3;
        h1 := 0;
        w2 := 0;
        for j := 0 to Count - 1 do
        begin
          with Items[j] do if lVisible and Visible then
          begin
            case FOrientation of
              itVertical:
                begin
                  Top := h;
                  if not ((ImageIndex = -1) and NeedImages(Items[j], n)) then
                    n := 0;
                  case FHAlign of
                    haLeft:
                      Left := Self.Collection.FBoundsRect.Left + w3 + n;
                    haMiddle:
                      Left := (w + Width) shr 1;
                    haRight:
                      Left := w - Width;
                  end;
                  Inc(h, Height + FVSpacing);
                end;
              itHorizontal:
                begin
                  if WordWrap then
                  begin
                    Top := h;
                    Left := w1 + Self.Collection.FBoundsRect.Left;
                    if w1 <> w3 then
                    begin
                      Inc(h, _intMax(h1, Height + FVSpacing));
                      h1 := 0;
                    end
                    else
                      Inc(h, Height + FVSpacing);
                    w1 := w3;
                  end
                  else begin
                    if soWrapItems in FOptions then
                    begin
                      if w1 + Width + FHSpacing > w then
                      begin
                        Inc(h, h1);
                        h1 := Height + FVSpacing;
                        w1 := w3;
                      end
                    end;
                    h1 := _intMax(h1, Height + FVSpacing);
                    Top := h;
                    case FHAlign of
                      haLeft:
                        Left := Self.Collection.FBoundsRect.Left + w1 ;
                      haMiddle:
                        if (w2 <> 0) and (w1 = w3) then
                        begin
                          UpdateCentered(j, w2);
                          w2 := Width
                        end
                        else begin
                          if w2 <> 0 then Inc(w2, FHSpacing);
                          Inc(w2, Width);
                        end;
                      haRight:
                        Left := 3 * FIndent + w - (w1 + Width);
                    end;
                    Inc(w1, Width + FHSpacing);
                  end;
                end;
            end;
          end;
        end;
        if (FHAlign = haMiddle) and (w2 > 0) then UpdateCentered(Count, w2);
        Inc(h, h1 + FMarginBottom);
      end;
    end;
  end;
  FBoundsRect := Rect(Collection.BoundsRect.Left, PosY,
    Collection.BoundsRect.Right, h)
end;

function TButtonGroupItem._AddRef: Integer;
begin
  Result := -1;
end;

function TButtonGroupItem._Release: Integer;
begin
  Result := -1;
end;

function TButtonGroupItem.GetExpandButtonSize: integer;
begin
  Result := ExpandButtonSize;
end;

procedure TButtonGroupItem.DrawExpandRect(ACanvas: TCanvas; ARect: TRect);
 var
  BColor: TColor;
  RBrush: HBRUSH;
begin
  if Enabled then
    BColor := clXPLightBackground
  else
    BColor := clXPDarkBackground;

  FrameRect(ACanvas.Handle, ARect, GetSysColorBrush(COLOR_BTNSHADOW));
  RBrush := CreateSolidBrush(ColorToRGB(BColor));
  try
    InflateRect(ARect, -1, -1);
    FillRect(ACanvas.Handle, ARect, RBrush);
    InflateRect(ARect, -1, -1);
    if Expanded then
      DrawBasicShape(ACanvas.Handle, shMinus, ARect.Left, ARect.Top,
        clBlack, szSmall)
    else
      DrawBasicShape(ACanvas.Handle, shPlus, ARect.Left, ARect.Top,
        clBlack, szSmall)
  finally
    DeleteObject(RBrush);
  end;
end;

procedure TButtonGroupItem.SetIndent(const Value: integer);
begin
  if FIndent <> Value then
  begin
    FIndent := Value;
    Changed(True);
  end;
end;

function TButtonGroupItem.GetCanvas: TCanvas;
begin
  Result := Collection.GetCanvas;
end;

function TButtonGroupItem.GetFocusedButton: TDCEditButton;
begin
  Result := Collection.FButtons.FocusedButton;
end;

procedure TButtonGroupItem.SetFocusedButton(const Value: TDCEditButton);
begin
  Collection.FButtons.FocusedButton := Value;
end;

{ TDCGroupButtons }

constructor TDCGroupButtons.Create(AOwner: TWinControl);
begin
  inherited;
  FGroups := TButtonGroups.Create(Self);
end;

destructor TDCGroupButtons.Destroy;
begin
  FGroups.Free;
  inherited;
end;

function TDCGroupButtons.GetButton(Index: integer): TDCEditButton;
 var
  i, iCount: integer;
begin
  Result := nil;
  for i := 0 to FGroups.Count - 1 do
  begin
    iCount := FGroups.Items[i].Count;
    if Index < iCount then
    begin
      Result := FGroups.Items[i].Items[Index];
      Break
    end
    else
      Dec(Index, iCount);
  end;
end;

function TDCGroupButtons.GetCount: integer;
 var
  i: integer;
begin
  Result := 0;
  for i := 0 to FGroups.Count - 1 do Inc(Result, FGroups.Items[i].Count);
end;

function TDCGroupButtons.NeedSaveBackground: boolean;
begin
  Result := True;
end;

procedure TDCGroupButtons.OffsetButtons(Pos: TPoint);
begin
  {}
end;

procedure TDCGroupButtons.RepaintButtons(ADrawStyle: TButtonTypeDrawStyle;
  DrawContext: HDC; AClip: HRGN);
begin
  inherited;
end;

{ TButtonGroups }

function TButtonGroups.Add: TButtonGroupItem;
begin
  Result := TButtonGroupItem(inherited Add);
end;

constructor TButtonGroups.Create(AButtons: TDCEditButtons);
begin
  inherited Create(TButtonGroupItem);
  FButtons := AButtons;
end;

destructor TButtonGroups.Destroy;
begin
  inherited;
end;

procedure TButtonGroups.Paint(ACanvas: TCanvas; APosition: integer);
 var
  i: integer;
begin
  for i := 0 to Count - 1 do
  begin
    if Items[i].Visible then Items[i].DrawCaption(ACanvas)
  end;
end;

function TButtonGroups.GetItem(Index: Integer): TButtonGroupItem;
begin
  Result := TButtonGroupItem(inherited GetItem(Index));
end;

procedure TButtonGroups.Invalidate;
begin
  TaskPanel.Invalidate;
end;

procedure TButtonGroups.SetItem(Index: Integer;
  const Value: TButtonGroupItem);
begin
  inherited SetItem(Index, Value);
end;

procedure TButtonGroups.Update(Item: TCollectionItem);
begin
  if Item = nil then
    UpdateGroupsPos
  else
    Invalidate
end;

procedure TButtonGroups.UpdateGroupsPos;
 var
  h, i: integer;
  aHeight: array[TGroupAlignment] of integer;
  FlagValue: boolean;
begin
  FlagValue := _getFlag(TaskPanel.FFlags, TP_NOTIFYITEM);
  _setFlag(TaskPanel.FFlags, TP_NOTIFYITEM, True);
  h := UpdateBoundsRect;
  if h <= TaskPanel.ActualHeight then
  begin
    TaskPanel.FScrollPanel.FPosition := 0;
    aHeight[gaTop] := TaskPanel.FMargins.Top;
    aHeight[gaBottom] := TaskPanel.ClientHeight - TaskPanel.FMargins.Bottom;
    for i := 0 to Count - 1 do with Items[i] do
    begin
       if Visible then
       begin
         h := Height {GetGroupHeight};
         case Alignment of
          gaTop:
            begin
              UpdateGroupPos(aHeight[gaTop]);
              Inc(aHeight[gaTop], h);
            end;
          gaBottom:
            Dec(aHeight[gaBottom], h);
         end
       end
    end;
    for i := 0 to Count - 1 do with Items[i] do
    begin
       if Visible then
       begin
         h := Height {GetGroupHeight};
         case Alignment of
          gaBottom:
            begin
              UpdateGroupPos(aHeight[gaBottom]);
              Inc(aHeight[gaBottom], h);
            end;
         end
       end
    end;
  end
  else begin
    aHeight[gaTop] := TaskPanel.FMargins.Top - TaskPanel.FScrollPanel.FPosition;
    for i := 0 to Count - 1 do with Items[i] do
    begin
       if Visible and (Alignment = gaTop) then
       begin
         UpdateGroupPos(aHeight[gaTop]);
         Inc(aHeight[gaTop], Height {GetGroupHeight});
       end
    end;
    for i := 0 to Count - 1 do with Items[i] do
    begin
       if Visible and (Alignment = gaBottom )then
       begin
         UpdateGroupPos(aHeight[gaTop]);
         Inc(aHeight[gaTop], Height {GetGroupHeight});
       end
    end;
  end;
  TaskPanel.UpdateTracksPos;
  Invalidate;
   _setFlag(TaskPanel.FFlags, TP_NOTIFYITEM, FlagValue);
end;

function TButtonGroups.GetCanvas: TCanvas;
begin
  Result := TaskPanel.Canvas;
end;

function TButtonGroups.GetTaskPanel: TDCCustomTaskPanel;
begin
  Result := TDCCustomTaskPanel(FButtons.Owner);
end;

function TButtonGroups.GetTextHeight(Value: string; XPos: integer;
  FontStyle: TFontStyles): integer;
 var
  R: TRect;
begin
  Canvas.Font := TaskPanel.Font;
  Canvas.Font.Style := FontStyle;
  R := Rect(XPos, 0, TaskPanel.ActualWidth, MaxInt);
  Result := DrawText(Canvas.Handle, PChar(Value), -1, R, DT_LEFT or
    DT_WORDBREAK or DT_CALCRECT);
end;

function TButtonGroups.UpdateBoundsRect: integer;
 var
  i: integer;
begin
  Result := 0;
  for i := 0 to Count - 1 do with Items[i] do
  begin
    if Visible then
    begin
      UpdateCaptionHeight;
      Inc(Result, GetGroupHeight);
    end;
  end;
  FBoundsRect := Rect(TaskPanel.FMargins.Left, 0,
    TaskPanel.FMargins.Left + TaskPanel.ActualWidth, Result);
end;

function TButtonGroups.GetHeight: integer;
begin
  Result := FBoundsRect.Bottom - FBoundsRect.Top;
end;

procedure TButtonGroups.UpdateImages;
 var
  i, j: integer;
begin
  for i := 0 to Count - 1 do
    for j := 0 to Items[i].Count - 1 do
      TDCEditButton(Items[i].Items[j]).Images := TaskPanel.Images;
end;

function TButtonGroups.GetHitTestInfoAt(X, Y: Integer;
  var Item: TButtonGroupItem): TGroupItemHitTests;
 var
  i: integer;
begin
  Result := giNowere;
  for i := 0 to Count - 1 do
  begin
    if Items[i].Visible then
    begin
      Result := Items[i].GetHitTestInfoAt(X, Y);
      if Result <> giNowere then
      begin
        Item := Items[i];
        Break;
      end;
    end;
  end;
end;

function TButtonGroups.AddGroup(AClass: TButtonGroupClass): TButtonGroupItem;
begin
  Result := AClass.Create(Self);
end;

{ TDCCustomTaskPanel }

procedure TDCCustomTaskPanel.ButtonsDown(Sender: TObject);
begin
  TrackClipPopup(nil);
  FScrollPanel.ScrollDown;
end;

procedure TDCCustomTaskPanel.ButtonsUp(Sender: TObject);
begin
  TrackClipPopup(nil);
  FScrollPanel.ScrollUp;
end;

procedure TDCCustomTaskPanel.CheckExpand(X, Y: integer;
  AHits: TSetGroupItemHitTests);
 var
  Item: TButtonGroupItem;
  HitTest: TGroupItemHitTests;
begin
  HitTest := Groups.GetHitTestInfoAt(X, Y, Item);
  if (HitTest in AHits) and (Item <> nil) and
    (bgExpandable in Item.Options) then
  begin
    if Item.Expanded then
      Item.Collapse(False)
    else
      Item.Expand(False)
  end;
end;

procedure TDCCustomTaskPanel.CMHintShow(var Message: TCMHintShow);
begin
  if FHintObject <> nil then
  begin
    with Message, TDCEditButton(FHintObject) do
    begin
      HintInfo.HintStr := GetShortHint(Hint);
      HintInfo.ReshowTimeout := $7FFFFFFF;
      Result := 0;
    end;
  end
  else
   inherited;
end;

procedure TDCCustomTaskPanel.CMInvalidate(var Message: TMessage);
begin
  inherited;
  if _getFlag(FFlags, CP_UPDATELOCKED) then
     _setFlag(FFlags, CP_INVALIDATE, True);
end;

procedure TDCCustomTaskPanel.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  if Assigned(FOnMouseEnter) then FOnMouseEnter(Self);
  UnHookMouseHooks;
  FButtons.MouseDown := GetAsyncKeyState(VK_LBUTTON)<0;
end;

procedure TDCCustomTaskPanel.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  if Assigned(FOnMouseLeave) then FOnMouseLeave(Self);

  FButtons.UpdateButtons( -1, -1, False, True);
  if FButtons.IsButtonsActive then HookMouseHooks(FButtons);

  UpdateTracksState(-1, -1, True)
end;

constructor TDCCustomTaskPanel.Create(AOwner: TComponent);
begin
  inherited;
  FButtons := TDCGroupButtons.Create(Self);
  FButtons.OnGetRegion := GetButtonsRegion;
  FButtons.Options := FButtons.Options - [boNCPainting, boDrawButtons];

  ControlStyle := [csCaptureMouse, csClickEvents, csOpaque, csDoubleClicks,
    csReplicatable];

  FMargins := TControlMargins.Create(Self);
  FMargins.OnChange := MarginsChanged;
  FScrollPanel := TTaskPanelScroll.Create(Self);
  FHintObject := nil;
  Color := clXPLightBackground;
  FImageChangeLink :=  TChangeLink.Create;
  FImageChangeLink.OnChange := ImageListChange;

  DoubleBuffered := True;

  CreateTracks;
  UpdateTracksStyle;

  BorderWidth := 0;

  FMargins.SetRectMargin(Rect(7, 7, 7, 14));
end;

procedure TDCCustomTaskPanel.CreateParams(var Params: TCreateParams);
begin
  inherited;
  with Params do
  begin
    Style := Style and not(WS_HSCROLL or WS_VSCROLL);
  end;
end;

procedure TDCCustomTaskPanel.CreateTracks;
begin
  FPrevTrack:= TDCEditButton.Create(Self);
  with FPrevTrack do
  begin
    Visible := False;
    DrawText:= False;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNUP');
    Options := Options + [boSimpleStyle, boFrame, boFrameInRest];
    OnClick := ButtonsDown;
    Height := 10;
  end;

  FNextTrack:= TDCEditButton.Create(Self);
  with FNextTrack do
  begin
    Visible := False;
    DrawText:= False;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNDOWN');
    Options := Options + [boSimpleStyle, boFrame, boFrameInRest];
    OnClick := ButtonsUp;
    Height := 10;
  end;
end;

procedure TDCCustomTaskPanel.CreateWnd;
begin
  inherited;
  if Parent <> nil then begin
    FButtons.ClrWndProc;
    FButtons.SetWndProc;
  end;
end;

destructor TDCCustomTaskPanel.Destroy;
begin
  FImageChangeLink.Free;
  FButtons.Free;
  FScrollPanel.Free;
  FMargins.Free;
  FreeAndNil(FNextTrack);
  FreeAndNil(FPrevTrack);
  inherited;
end;

procedure TDCCustomTaskPanel.DoScroll(const Delta: integer);
 var
  i: integer;
  R: TRect;
  UpdateRgn: HRGN;

  procedure AddTrackRegion(Track : TDCEditButton; Inc, Value: integer);
   var
    Rgn: HRGN;
    R: TRect;
  begin
    R := Track.GetBoundsEx;
    InflateRect(R, Inc, Inc);
    case Value of
        1: R.Top := R.Top + 1;
       -1: R.Bottom := R.Bottom - 1;
    end;
    Rgn := CreateRectRgnIndirect(R);
    CombineRgn(UpdateRgn, UpdateRgn, Rgn, RGN_OR);
    DeleteObject(Rgn);
  end;
begin
  if not HandleAllocated then Exit;
  with FButtons.FGroups do
  begin
    _setFlag(FFlags, TP_NOTIFYITEM, True);
    for i := 0 to Count - 1 do with Items[i] do
    begin
      if Visible then ScrollGroup(Delta)
    end;
    _setFlag(FFlags, TP_NOTIFYITEM, False);

    TaskPanel.UpdateTracksPos;

    R := ClientRect;
    if not DoubleBuffered then
    begin
      if Delta < 0 then
      begin
        R.Top := R.Bottom + Delta - FNextTrack.Height -1;
        UpdateRgn := CreateRectRgnIndirect(R);
        AddTrackRegion(FPrevTrack, 1, -1);
      end
      else begin
        R.Bottom := R.Top + Delta + FPrevTrack.Height + 1;
        UpdateRgn := CreateRectRgnIndirect(R);
        AddTrackRegion(FNextTrack, 1, 1);
      end;

      R := ClientRect;
      R.Top := R.Top + FPrevTrack.Height + 1;
      R.Bottom := R.Bottom - FNextTrack.Height - 1;

      try
        ScrollWindowEx(Handle, 0, Delta, @R, @R, 0, nil, 0);
        InvalidateRgn(Handle, UpdateRgn, False);
        UpdateWindow(Handle);
      finally
        DeleteObject(UpdateRgn);
      end;
    end
    else begin
      UpdateRgn := CreateRectRgnIndirect(R);
      try
        InvalidateRgn(Handle, UpdateRgn, False);
      finally
        DeleteObject(UpdateRgn);
      end;
    end;
  end;
end;

procedure TDCCustomTaskPanel.DrawButtonHint(Sender: TObject;
  Mode: integer);
begin
  if Application <> nil then
  begin
    Application.CancelHint;
  end;
  case Mode of
    0:{Show}
      FHintObject := Sender;
    1:{Hide}
      FHintObject := nil;
  end;
end;

function TDCCustomTaskPanel.GetActualHeight: integer;
begin
  Result := ClientHeight - FMargins.Top - FMargins.Bottom;
end;

function TDCCustomTaskPanel.GetActualWidth: integer;
begin
  Result := ClientWidth - FMargins.Left - FMargins.Right;
end;

procedure TDCCustomTaskPanel.GetButtonsRegion(Sender: TObject;
  var Rgn: HRGN);
 var
  Rgn1: HRGN;
begin
  with ClientRect do
   Rgn := CreateRectRgn(1, 1, ClientWidth - 1, ClientHeight - 1);

  if FPrevTrack.Visible then
    with FPrevTrack do
    begin
      Rgn1 := CreateRectRgn(Left, Top, Left + Width, Top + Height);
      CombineRgn(Rgn, Rgn, Rgn1, RGN_DIFF);
      DeleteObject(Rgn1);
    end;

  if FNextTrack.Visible then
    with FNextTrack do
    begin
      Rgn1 := CreateRectRgn(Left, Top, Left + Width, Top + Height);
      CombineRgn(Rgn, Rgn, Rgn1, RGN_DIFF);
      DeleteObject(Rgn1);
    end;
end;

function TDCCustomTaskPanel.GetGroups: TButtonGroups;
begin
  Result := FButtons.FGroups;
end;

procedure TDCCustomTaskPanel.ImageListChange(Sender: TObject);
begin
  Groups.UpdateImages;
  Invalidate;
end;

procedure TDCCustomTaskPanel.ItemClick(Sender: TObject);
begin
  if Assigned(FOnItemClick) then FOnItemClick(Sender);
end;

procedure TDCCustomTaskPanel.MarginsChanged(Sender: TObject);
begin
  if HandleAllocated then FButtons.FGroups.UpdateGroupsPos;
end;

procedure TDCCustomTaskPanel.Paint;
 var
  Index, i, j, k, iCount, jCount, kCount: integer;
  R: TRect;

  procedure ExcludeRect(R: TRect; Inc, Value: integer);
  begin
    InflateRect(R, Inc, Inc);
    case Value of
        1:
          begin
            R.Top := R.Top + 1;
          end;
       -1:
          begin
            R.Bottom := R.Bottom - 1;
          end;
    end;
    ExcludeClipRect(Canvas.Handle, R.Left, R.Top, R.Right, R.Bottom);
  end;

begin
  Canvas.Font := Font;
  with Canvas do
  begin
    Index := SaveDC(Handle);
    PaintTracks(Handle);

    Brush.Color := ColorToRGB(Color);
    Brush.Style := bsSolid;
    Pen.Color := 0;

    if not DoubleBuffered then
      FButtons.UpdateDeviceRegion(Handle);

    if FNextTrack.Visible then ExcludeRect(FNextTrack.GetBounds, 0, 0);
    if FPrevTrack.Visible then ExcludeRect(FPrevTrack.GetBounds, 0, 0);

    if not BrushImage.Empty then
    begin
      R := ClientRect;
      R.Top := R.Top - FScrollPanel.Position;
      if FNextTrack.Visible then R.Bottom := R.Top + Groups.Height +
        FMargins.Top + FMargins.Bottom;
      BrushImage.Draw(Canvas, Canvas.ClipRect {ClientRect}, R);
    end
    else
      FillRect(ClientRect);

    if FNextTrack.Visible then ExcludeRect(FNextTrack.GetBounds, 1, 1);
    if FPrevTrack.Visible then ExcludeRect(FPrevTrack.GetBounds, 1, -1);

    {Draw Groups};
    Font := Self.Font;
    Groups.Paint(Canvas, FScrollPanel.FPosition);

    RestoreDC(Handle, Index);

    if csDesigning in ComponentState then
    begin
      Brush.Color := Color;
      Pen.Color   := clNavy;
      Pen.Style   := psDot;
      PolyLine([Point(0, 0), Point(0, ClientHeight - 1),
        Point(ClientWidth - 1, ClientHeight - 1), Point(ClientWidth - 1, 0),
        Point(0,0)]);
    end;

    FButtons.SaveBackground(Handle);

    if FNextTrack.Visible then ExcludeRect(FNextTrack.GetBounds, 1, 1);
    if FPrevTrack.Visible then ExcludeRect(FPrevTrack.GetBounds, 1, -1);

    with FButtons.FGroups do
    begin
      iCount := Count - 1;
      for i := 0 to iCount do with Items[i] do
      begin
        if Visible and (not(bgExpandable in Options) or Expanded) then
        begin
          jCount := FSections.Count - 1;
          for j := 0 to jCount do with FSections.Items[j] do
          begin
            kCount := FButtons.Count - 1;
            for k := 0 to kCount do
              with TDCEditButton(FButtons.List^[k]) do
                if RectVisible(Handle, GetBounds) then Paint(Handle, 0, True);
          end
        end;
      end;
    end;
  end;
end;

procedure TDCCustomTaskPanel.PaintTracks(DrawContext: HDC);
begin
  if FPrevTrack.Visible then FPrevTrack.Paint(DrawContext);
  if FNextTrack.Visible then FNextTrack.Paint(DrawContext);
end;

procedure TDCCustomTaskPanel.SetBounds(ALeft, ATop, AWidth,
  AHeight: Integer);
begin
  if HandleAllocated and not _getFlag(FFlags, CP_UPDATELOCKED) then
  begin
    _setFlag(FFlags, CP_UPDATELOCKED, True);
    Perform(WM_SETREDRAW, 0, 0);

    _setFlag(FFlags, CP_INVALIDATE, False);
    try
      inherited;
    finally
      Perform(WM_SETREDRAW, 1, 0);
      _setFlag(FFlags, CP_UPDATELOCKED, False);
      if _getFlag(FFlags, CP_INVALIDATE) then
      begin
        Invalidate;
        Update;
      end;
    end;
  end
  else
    inherited;
end;

procedure TDCCustomTaskPanel.SetGroups(const Value: TButtonGroups);
begin
  FButtons.FGroups.Assign(Value);
end;

procedure TDCCustomTaskPanel.SetImages(const Value: TImageList);
begin
  if Images <> nil then
    Images.UnRegisterChanges(FImageChangeLink);
  FImages := Value;
  if Images <> nil then
  begin
    Images.RegisterChanges(FImageChangeLink);
    Images.FreeNotification(FButtons.Owner);
  end;
  invalidate;
end;

procedure TDCCustomTaskPanel.SetMargins(const Value: TControlMargins);
begin
  FMargins.Assign(Value);
end;

function TDCCustomTaskPanel.SetPosition(Value: integer): integer;
begin
  Result := _intMin(Value, Groups.Height - ActualHeight);
  Result := _intMax(Result, 0);
end;

procedure TDCCustomTaskPanel.SetScrollPanel(const Value: TTaskPanelScroll);
begin
  FScrollPanel.Assign(Value);
end;

function TDCCustomTaskPanel.TrackActive(Button: TDCEditButton): boolean;
begin
  Result := Button.Visible and
   (Button.ButtonState in [btDownMouseInRect, btRestMouseInRect]);
end;

function TDCCustomTaskPanel.TrackTimerActivate(CheckTimer: boolean): boolean;
begin
  Result := not(_getFlag(FFlags, CP_TRACKTIMER) and CheckTimer) and
   (TrackActive(FPrevTrack) or TrackActive(FNextTrack));
end;

procedure TDCCustomTaskPanel.UpdateTracksPos;
begin
  FPrevTrack.Visible := FScrollPanel.FPosition <> 0;
  FNextTrack.Visible := Groups.Height - FScrollPanel.FPosition  > ActualHeight;

  if FPrevTrack.Visible then
    with FPrevTrack do
      SetBounds(Rect(1, 1, ClientWidth - 2, Height));

  if FNextTrack.Visible then
    with FNextTrack do
      SetBounds(Rect(1, ClientHeight - Height - 1, ClientWidth - 2, Height));
end;

procedure TDCCustomTaskPanel.UpdateTracksState(X, Y: integer;
  lMove: boolean);
begin
  FPrevTrack.UpdateButtonState(X, Y, _getFlag(FFlags, CP_MOUSEDOWN), lMove);
  FNextTrack.UpdateButtonState(X, Y, _getFlag(FFlags, CP_MOUSEDOWN), lMove);
end;

procedure TDCCustomTaskPanel.UpdateTracksStyle;
begin
  with FPrevTrack do
  begin
    BrushColor := clXPItemBackground;
    Style := stSingle;
    if Visible then Repaint;
  end;
  with FNextTrack do
  begin
    BrushColor := clXPItemBackground;
    Style := stSingle;
    if Visible then Repaint;
  end;
end;

procedure TDCCustomTaskPanel.WMLButtonDblClk(var Message: TWMLButtonDown);
begin
  inherited;
  _setFlag(FFlags, CP_MOUSEDOWN, True);
  UpdateTracksState(Message.Pos.X, Message.Pos.Y, False);

  if TrackTimerActivate(True) then
    SetTimer(Handle, PNLTIMER_IDEVENT, 200, nil)
  else
    CheckExpand(Message.XPos, Message.YPos, [giOnButton, giOnCaption])
end;

procedure TDCCustomTaskPanel.WMLButtonDown(var Message: TWMLButtonDown);
begin
  inherited;
  _setFlag(FFlags, CP_MOUSEDOWN, True);
  UpdateTracksState(Message.Pos.X, Message.Pos.Y, False);

  if TrackTimerActivate(True) then
    SetTimer(Handle, PNLTIMER_IDEVENT, 200, nil)
  else
    CheckExpand(Message.XPos, Message.YPos, [giOnButton])
end;

procedure TDCCustomTaskPanel.WMLButtonUp(var Message: TWMLButtonUp);
begin
  inherited;
  _setFlag(FFlags, CP_MOUSEDOWN, False);
  UpdateTracksState(Message.Pos.X, Message.Pos.Y, False);
end;

procedure TDCCustomTaskPanel.WMMouseMove(var Message: TWMMouseMove);
begin
  inherited;
  UpdateTracksState(Message.Pos.X, Message.Pos.Y, True);
  if TrackTimerActivate(True) then SetTimer(Handle, PNLTIMER_IDEVENT, 200, nil);
end;

procedure TDCCustomTaskPanel.WMSize(var Message: TWMSize);
 var
  i: integer;
begin
  inherited;
  with FScrollPanel do
  begin
    _setFlag(FFlags, TP_WMSIZE, True);
    i := Position;
    SetPostion(Position);
    if i = Position then FButtons.FGroups.UpdateGroupsPos;
    _setFlag(FFlags, TP_WMSIZE, False);
  end;
end;

procedure TDCCustomTaskPanel.WMTimer(var Message: TWMTimer);
begin
  if not TrackTimerActivate(False) then
  begin
    KillTimer(Handle, PNLTIMER_IDEVENT);
    _setFlag(FFlags, CP_TRACKTIMER, False);
    Exit;
  end;

  if TrackActive(FNextTrack) then
    ButtonsUp(Self)
  else
    if TrackActive(FPrevTrack) then ButtonsDown(Self);

  if not _getFlag(FFlags, CP_TRACKTIMER) then
  begin
    _setFlag(FFlags, CP_TRACKTIMER, True);
    KillTimer(Handle, PNLTIMER_IDEVENT);
    SetTimer(Handle, PNLTIMER_IDEVENT, FScrollPanel.FInterval, nil);
  end;
end;

{ TTaskPanelScroll }

procedure TTaskPanelScroll.Assign(Source: TPersistent);
begin
  inherited;
end;

constructor TTaskPanelScroll.Create(ATaskPanel: TDCCustomTaskPanel);
begin
  inherited Create;
  FIncrement := 10;
  FInterval := 60;
  FPosition := 0;
  FTaskPanel := ATaskPanel;
end;

procedure TTaskPanelScroll.ScrollDown;
begin
  Position := FPosition - FIncrement;
end;

procedure TTaskPanelScroll.ScrollUp;
begin
  Position := FPosition + FIncrement;
end;

procedure TTaskPanelScroll.SetPostion(const Value: integer);
 var
  i, Delta: integer;
begin
  i := FTaskPanel.SetPosition(Value);
  if i <> FPosition then
  begin
    Delta := FPosition - i;
    FPosition := i;
    FTaskPanel.DoScroll(Delta);
  end;
end;

{ TControlMargins }

procedure TControlMargins.AssignTo(Dest: TPersistent);
begin
  if Dest is TControlMargins then
    with TControlMargins(Dest) do
    begin
      FRect := Self.FRect;
      Change;
    end
  else
    inherited AssignTo(Dest);
end;

procedure TControlMargins.Change;
begin
  if Assigned(FOnChange) then FOnChange(Self);
end;

constructor TControlMargins.Create(Control: TControl);
begin
  inherited Create;
  FControl := Control;
  SetRectEmpty(FRect)
end;

function TControlMargins.GetMagrin(const Index: Integer): integer;
begin
  case Index of
    0: Result := FRect.Left;
    1: Result := FRect.Top;
    2: Result := FRect.Right;
    3: Result := FRect.Bottom;
    else
      Result := 0;
  end;
end;

procedure TControlMargins.SetMargin(const Index, Value: integer);
begin
  case Index of
    0: {Left}
      if Value <> FRect.Left then
      begin
        FRect.Left := Value;
        Change;
      end;
    1: {Top}
      if Value <> FRect.Top then
      begin
        FRect.Top := Value;
        Change;
      end;
    2: {Right}
      if Value <> FRect.Right then
      begin
        FRect.Right := Value;
        Change;
      end;
    3: {Bottom}
      if Value <> FRect.Bottom then
      begin
        FRect.Bottom := Value;
        Change;
      end;
  end;
end;

procedure TControlMargins.SetRectMargin(const R: TRect);
begin
  if not IsRectEquals(R, FRect) then
  begin
    FRect := R;
    Change;
  end;
end;

{ TGroupSectionItem }

function TGroupSectionItem.AddButton(
  EditButtonClass: TEditButtonClass): TDCEditButton;
 var
  AIndex: integer;
  AGroups: TButtonGroups;
begin
  AGroups := Group.Collection;
  Result := EditButtonClass.Create(AGroups.FButtons.Owner);
  AIndex := FButtons.Add(Result);

  with Result do
  begin
    Name := Format('Button%d_%d', [Self.Index, AIndex]);
    AbsolutePos := False;
    Grouped := True;
    Font := AGroups.TaskPanel.Font;
    Images := AGroups.TaskPanel.Images;
    Index := AIndex;
    OnClick := AGroups.TaskPanel.ItemClick;
    SetButtonHolder(IDCButtonHolder(Group));
  end;
end;

procedure TGroupSectionItem.Clear;
 var
  i: integer;
begin
  for i := 0 to FButtons.Count-1 do
    TDCEditButton(FButtons.Items[i]).Free;
  FButtons.Clear;
  Changed(True);
end;

constructor TGroupSectionItem.Create(Collection: TCollection);
begin
  inherited;
  FButtons := TList.Create;
  FHAlign := haLeft;
  FVAlign := vaTop;
  FOrientation := itVertical;
  FHSpacing := 0;
  FVSpacing := 0;
  FHeight := 0;
  FWidth := 0;
end;

destructor TGroupSectionItem.Destroy;
begin
  Clear;
  FButtons.Free;
  inherited;
end;

function TGroupSectionItem.GetButton(Index: integer): TDCEditButton;
begin
  Result := TDCEditButton(FButtons.Items[Index]);
end;

function TGroupSectionItem.GetCount: integer;
begin
  Result := FButtons.Count;
end;

function TGroupSectionItem.GetGroup: TButtonGroupItem;
begin
  Result := TGroupSections(Collection).FButtonGroup;
end;

procedure TGroupSectionItem.SetButton(Index: integer;
  const Value: TDCEditButton);
begin
  Items[Index].Assign(Value);
end;

procedure TGroupSectionItem.SetHAlign(const Value: THorzAlignment);
begin
  FHAlign := Value;
  Changed(False);
end;

procedure TGroupSectionItem.SetHSpacing(const Value: integer);
begin
  FHSpacing := Value;
  Changed(True);
end;

procedure TGroupSectionItem.SetMarginBottom(const Value: integer);
begin
  if FMarginBottom <> Value then
  begin
    FMarginBottom := Value;
    Changed(True);
  end;  
end;

procedure TGroupSectionItem.SetMarginLeft(const Value: integer);
begin
  if FMarginLeft <> Value then
  begin
    FMarginLeft := Value;
    Changed(True);
  end;
end;

procedure TGroupSectionItem.SetMarginTop(const Value: integer);
begin
  if FMarginTop <> Value then
  begin
    FMarginTop := Value;
    Changed(True);
  end;  
end;

procedure TGroupSectionItem.SetMinHeight(const Value: integer);
begin
  FMinHeight := Value;
end;

procedure TGroupSectionItem.SetOptions(const Value: TSectionItemOptions);
begin
  if FOptions <> Value then
  begin
    FOptions := Value;
    Changed(True);
  end;
end;

procedure TGroupSectionItem.SetOrientation(const Value: TItemsOrientation);
begin
  FOrientation := Value;
  Changed(True);
end;

procedure TGroupSectionItem.SetVAlign(const Value: TVertAlignment);
begin
  FVAlign := Value;
  Changed(False);
end;

procedure TGroupSectionItem.SetVSpacing(const Value: integer);
begin
  FVSpacing := Value;
  Changed(True);
end;

{ TGroupSections }

function TGroupSections.Add: TGroupSectionItem;
begin
  Result := TGroupSectionItem(inherited Add);
end;

constructor TGroupSections.Create(AButtonGroup: TButtonGroupItem);
begin
  inherited Create(TGroupSectionItem);
  FButtonGroup := AButtonGroup;
end;

function TGroupSections.GetButtonsCount: integer;
 var
  i: integer;
begin
  Result := 0;
  for i := 0 to Count - 1 do Inc(Result, Items[i].Count)
end;

function TGroupSections.GetItem(Index: Integer): TGroupSectionItem;
begin
  Result := TGroupSectionItem(inherited GetItem(Index));
end;

procedure TGroupSections.SetItem(Index: Integer;
  const Value: TGroupSectionItem);
begin
  inherited SetItem(Index, Value);
end;

procedure TGroupSections.Update(Item: TCollectionItem);
begin
  FButtonGroup.Changed(Item = nil);
end;

{ TDCCustomControl }

procedure TDCCustomControl.ChangeBrush(Sender: TObject);
begin
  DoBrushChanged;
  invalidate;
end;

constructor TDCCustomControl.Create(AOwner: TComponent);
begin
  inherited;
  FBrushImage := TDCBrushImage.Create(Self);
  FBrushImage.OnChange := ChangeBrush;
end;

destructor TDCCustomControl.Destroy;
begin
  FBrushImage.Free;
  inherited;
end;

procedure TDCCustomControl.DoBrushChanged;
begin
  {}
end;

procedure TDCCustomControl.Paint;
 var
  R: TRect;
begin
  R := ClientRect;
  if not BrushImage.Empty then
    BrushImage.Draw(Canvas, R, R)
  else
    inherited;
end;

procedure TDCCustomControl.SetBrushImage(const Value: TDCBrushImage);
begin
  FBrushImage.Assign(Value);
end;

initialization
  GetCheckSize;

end.
