{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x - 6.x
         Copyright (c) 1998-2001 Alex'EM

}
unit DCPopupWindow;

interface
{$I DCConst.inc}

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms, Graphics, StdCtrls,
  {$IFDEF DELPHI_V6}
    Variants,
  {$ENDIF}
  ImgList, ComCtrls, DCEditTools, DCEditButton, DCConst, DCPopupMenu;

const
  br_SizerWidth    = 14;
  br_FooterHeight  = 13;
  br_HeaderHeight  = 14;

type
  TAdvancedTimerMode = (atNone, atShow, atHide);
  THintShowMode = (smShow, smHide);

  PHintWindowParam_tag  = ^THintWindowParam;
  THintWindowParam = packed record
    Handle: THandle;
    ShowMode: THintShowMode;
    Active: boolean;
    x, y, cx, cy: integer;
    lpText: PChar;
    Flags: DWORD;
  end;

  TClipFormOptions = set of TClipFormValue;

  TDCAssistButton = class(TDCEditButton)
  private
    FLine: integer;
    FPos: integer;
    FDrawingStyle: TDCDrawingStyle;
    FDropDownColor: TColor;
    procedure SetLine(const Value: integer);
    procedure SetPos(const Value: integer);
    procedure SetDrawingStyle(const Value: TDCDrawingStyle);
  protected
    procedure DrawBkgnd(ACanvas: TCanvas; ARect: TRect); override;
    procedure DrawEditText(ACanvas: TCanvas; var TextRect: TRect); override;
    procedure BeginDrawText(ACanvas: TCanvas; ATextRect: TRect;
      AState: TButtonState); override;
    procedure BeginDrawBkgn(ACanvas: TCanvas; ARect: TRect; AState: TButtonState;
      var ImageRect: TRect; var TextRect: TRect); override;
    function OneClickButton: boolean; override;
  public
    constructor Create(AOwner: TComponent); override;
    procedure DrawBorder(ACanvas: TCanvas; ARect: TRect); override;
    procedure DrawBitmap(ACanvas: TCanvas; ImageRect: TRect); override;
    function GetImageOffset: TPoint; override;
    function GetTextOffset: TPoint; override;
    property Line: integer read FLine write SetLine;
    property Pos: integer read FPos write SetPos;
    property DrawingStyle: TDCDrawingStyle read FDrawingStyle write SetDrawingStyle;
    property DropDownColor: TColor read FDropDownColor write FDropDownColor;
  end;

  TDCControlShadow = class(TWinControl)
  private
    FAlphaBlendValue: DWORD;
    FAngle: integer;
    FControl: TControl;
    FDistance: DWORD;
    FRgn: HRGN;
    FSize: DWORD;
    FVisible: boolean;
    FUpdateCount: integer;
    procedure SetAngle(const Value: integer);
    procedure SetDistance(const Value: DWORD);
    procedure SetSize(const Value: DWORD);
    procedure SetVisible(const Value: boolean);
    procedure UpdateWindowRgn(Rgn: HRGN);
  protected
    procedure Changed; virtual;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure WMEraseBkgnd(var Message: TWMEraseBkgnd); message WM_ERASEBKGND;
    procedure WMNCHitTest(var Message: TWMNCHitTest); message WM_NCHITTEST;
    procedure WMMouseActivate(var Message: TWMActivate); message WM_MOUSEACTIVATE;
  public
    constructor Create(AOwner: TWinControl); reintroduce;
    destructor Destroy; override;
    procedure BeginUpdate;
    procedure EndUpdate;
    procedure Hide;
    function GetShadowPos: TPoint;
    procedure SaveBackground(Rgn: HRGN);
    procedure Show;
  published
    property Angle: integer read FAngle write SetAngle;
    property Distance: DWORD read FDistance write SetDistance;
    property Size: DWORD read FSize write SetSize;
    property Visible: boolean read FVisible write SetVisible;
  end;

  IDCPopupWindow = interface(IUnknown)
    ['{557D4AA5-41EE-4BB8-B276-FAEC196A538A}']
    procedure DrawClientRect;
    procedure DrawFooter;
    procedure DrawHeader(const DC: HDC; var R: TRect);
  end;

  TPopupWindowOption = (poSetWindowProc);
  TPopupWindowOptions = set of TPopupWindowOption;

  TDCPopupWindow = class(TCustomControl)
  private
    FAlwaysVisible: boolean;
    FOrientation: integer;
    FOwner: TControl;
    FPFDefWndProc: Pointer;
    FPFNewWndProc: Pointer;
    FPopupAlignment: TWindowAlignment;
    FPopupOptions: TPopupWindowOptions;
    FShadow: TDCControlShadow;
    FVisible: boolean;
    FWindowRect: TRect;
    procedure SetPopupAlignment(Value: TWindowAlignment);
    procedure SetVisible(const Value: boolean);
  protected
    procedure CMRelease(var Message: TMessage); message CM_RELEASE;
    procedure CMShowingChanged(var Message: TMessage); message CM_SHOWINGCHANGED;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    function GetRegion(RegionType: integer): HRGN; virtual;
    function GetShadowPos: TPoint; virtual;
    procedure PFWndProc(var Message: TMessage); virtual;
    procedure SetOrientation(const Value: integer); virtual;
    procedure UpdateShadowPos(AShow: boolean);
    procedure WMMouseActivate(var Message: TWMActivate); message WM_MOUSEACTIVATE;
    procedure WMNCPaint(var Message: TWMNCPaint); message WM_NCPAINT;
    procedure WMNCCalcSize(var Message: TWMNCCalcSize); message WM_NCCALCSIZE;
    procedure WndProcAction(Action: integer); virtual;
    property WindowRect: TRect read FWindowRect;
  public
    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer); override;
    procedure SetBoundsEx(ALeft, ATop, AWidth, AHeight: Integer); virtual;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function GetTextHeight(Value: string): integer;
    function GetTextWidth(Value: string): integer;
    procedure Show; virtual;
    procedure Hide; virtual;
    procedure Release;
    property AlwaysVisible: boolean read FAlwaysVisible write FAlwaysVisible;
    property PopupAlignment: TWindowAlignment read FPopupAlignment
             write SetPopupAlignment;
    property Owner: TControl read FOwner write FOwner;
    property PopupOptions: TPopupWindowOptions read FPopupOptions write FPopupOptions;
    property Canvas;
    property Parent;
    property Orientation: integer read FOrientation write SetOrientation;
    property Visible: boolean read FVisible write SetVisible;
    property Shadow: TDCControlShadow read FShadow;
  end;

  TDrawInfoText   = procedure (Sender: TObject; DC: HDC; Rect: TRect;
    var Text: string; var Default: boolean) of object;

  TDCMessageWindow = class(TDCPopupWindow)
  private
    FAutoHide: boolean;
    FAutoSize: boolean;
    FButtons: TDCEditButtons;
    FBitmap: TBitmap;
    FBitmapVisible: boolean;
    FDialogStyle: TDialogStyle;
    FMargins: TRect;
    FTimerHandle: Word;
    FTimeOut: integer;
    FMessageStyle: TMessageStyle;
    FImage: TBitmap;
    FRoundValue: integer;
    FTailValue: integer;
    FTimerMode: TAdvancedTimerMode;
    FBitmapOffset: integer;
    FCentered: boolean;
    FOnDrawInfoText: TDrawInfoText;
    FMaxTextWidth: integer;
    FUpdateCount: integer;
    procedure AdjustWindowSize;
    procedure SetDialogStyle(Value: TDialogStyle);
    procedure SetBitmap(Value: TBitmap);
    procedure SetBitmapVisible(Value: boolean);
    procedure SetAutoHide(const Value: boolean);
    procedure SetTimeOut(const Value: integer);
    procedure StartTimer(Value: Integer; TimerMode: TAdvancedTimerMode);
    procedure StopTimer(TimerMode: TAdvancedTimerMode);
    procedure SetMessageStyle(const Value: TMessageStyle);
    procedure SetCentered(const Value: boolean);
    procedure SetMaxTextWidth(const Value: integer);
    procedure UpdateWindowRegion;
    procedure SetAutoSize(const Value: boolean); reintroduce;
    function GetFocusedButton: TDCEditButton;
    procedure SetFocusedButton(const Value: TDCEditButton);
    procedure ShowWindow;
  protected
    procedure CreateWnd; override;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure CMShadowChanged(var Message: TMessage); message CM_SHADOWCHANGED;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
    function GetButtonSize(Button: TDCEditButton): TPoint; virtual;
    function GetRegion(RegionType: integer): HRGN; override;
    procedure Paint; override;
    procedure Resize; override;
    procedure SetOrientation(const Value: integer); override;
    procedure SetMargins;
    procedure WMNCHitTest(var Message: TWMNCHitTest); message WM_NCHITTEST;
    procedure WMEraseBkgnd(var Message: TWmEraseBkgnd); message WM_ERASEBKGND;
    procedure WMTimer(var Message: TWMTimer); message WM_TIMER;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show; override;
    procedure Hide; override;
    function AddButton(AName, AResource, ACaption: string;
      AClick: TNotifyEvent): TDCEditButton;
    procedure BeginUpdate;
    Procedure EndUpdate;
    property AutoHide: boolean read FAutoHide write SetAutoHide;
    property AutoSize: boolean read FAutoSize write SetAutoSize;
    property Bitmap: TBitmap read FBitmap write SetBitmap;
    property BitmapVisible: boolean read FBitmapVisible write SetBitmapVisible;
    property Buttons: TDCEditButtons read FButtons;
    property DialogStyle: TDialogStyle read FDialogStyle write SetDialogStyle;
    property Canvas;
    property Caption;
    property Centered: boolean read FCentered write SetCentered;
    property Color;
    property FocusedButton: TDCEditButton read GetFocusedButton
      write SetFocusedButton;
    property MessageStyle: TMessageStyle read FMessageStyle write SetMessageStyle;
    property OnDrawInfoText: TDrawInfoText read FOnDrawInfoText write FOnDrawInfoText;
    property MaxTextWidth: integer read FMaxTextWidth write SetMaxTextWidth;
    property TimeOut: integer read FTimeOut write SetTimeOut;
  end;

  TDCPopupListBox = class(TCustomListBox, IDCPopupWindow)
  private
    FVisible: boolean;
    FOwner: TControl;
    FWindowRect: TRect;
    FAlwaysVisible: boolean;
    FPopupAlignment: TWindowAlignment;
    FPopupBorderStyle: TPopupBorderStyle;
    FBorderSize: integer;
    FDropDownRows: integer;
    procedure RedrawBorder;
    procedure SetPopupAlignment(Value: TWindowAlignment);
    procedure SetPopupBorderStyle(Value: TPopupBorderStyle);
    procedure DrawClientRect;
    procedure DrawFooter;
    procedure DrawHeader(const DC: HDC; var R: TRect);
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    procedure WMMouseActivate(var Message: TWMActivate); message WM_MOUSEACTIVATE;
    procedure WMNCCalcSize(var Message: TWMNCCalcSize); message WM_NCCALCSIZE;
    procedure WMNCPaint(var Message: TWMNCPaint); message WM_NCPAINT;
    procedure CNDrawItem(var Message: TWMDrawItem); message CN_DRAWITEM;
    procedure WMMouseMove(var Message: TWMMouseMove); message WM_MOUSEMOVE;
    procedure WMFontChange(var Message: TWMFontChange); message WM_FONTCHANGE;
  public
    procedure AdjustNewHeight;
    procedure SetListHeight(Increment: integer);
    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer); override;
    procedure SetBoundsEx(ALeft, ATop, AWidth, AHeight: Integer);

    constructor Create(AOwner: TComponent); override;
    procedure Show;
    procedure Hide;
    property AlwaysVisible: boolean read FAlwaysVisible write FAlwaysVisible;
    property DropDownRows: integer read FDropDownRows write FDropDownRows;
    property ListVisible: boolean read FVisible write FVisible;
    property Owner: TControl read FOwner write FOwner;
    property PopupAlignment: TWindowAlignment read FPopupAlignment
      write SetPopupAlignment;
    property PopupBorderStyle: TPopupBorderStyle read FPopupBorderStyle
      write SetPopupBorderStyle;

    property Style;
    property Font;
    property OnDrawItem;
    property OnMeasureItem;
    property OnMouseUp;
    property ItemHeight;
    property Color;
  end;

  TDCPopupTreeView = class(TCustomTreeView, IDCPopupWindow)
  private
    FVisible: boolean;
    FOwner: TControl;
    FWindowRect: TRect;
    FAlwaysVisible: boolean;
    FDrawingStyle: TDCDrawingStyle;
    FPopupAlignment: TWindowAlignment;
    FPopupBorderStyle: TPopupBorderStyle;
    FItemHeight: integer;
    FBorderSize: integer;
    FDropDownRows: integer;
    FMargins: TRect;
    FCursorMode: TCursorMode;
    FButtons: TDCEditButtons;
    FShowHeader: boolean;
    procedure RedrawBorder;
    procedure SetPopupAlignment(Value: TWindowAlignment);
    procedure SetPopupBorderStyle(Value: TPopupBorderStyle);
    procedure DrawClientRect;
    procedure DrawFooter;
    procedure DrawHeader(const DC: HDC; var R: TRect);
    procedure SetMargins;
    procedure BeginMoving(XCursor, YCursor: integer);
    procedure InvalidateButtons;
    procedure SetShowHeader(const Value: boolean);
    procedure SetDrawingStyle(const Value: TDCDrawingStyle);
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    procedure WMMouseActivate(var Message: TWMActivate); message WM_MOUSEACTIVATE;
    procedure WMNCCalcSize(var Message: TWMNCCalcSize); message WM_NCCALCSIZE;
    procedure WMNCPaint(var Message: TWMNCPaint); message WM_NCPAINT;
    procedure WMLButtonDblClk(var Message: TWMLButtonDown); message WM_LBUTTONDBLCLK;
    procedure WMFontChange(var Message: TWMFontChange); message WM_FONTCHANGE;
    procedure WMNCHitTest(var Message: TWMNCHitTest); message WM_NCHITTEST;
    procedure WMSetCursor(var Message: TWMSetCursor); message WM_SETCURSOR;
    procedure WMNCLButtonDown(var Message: TWMNCLButtonDown); message WM_NCLBUTTONDOWN;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure CMSetAlignment(var Message: TMessage); message CM_SETALIGNMENT;
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure WMActivate (var Message: TWMActivate); message WM_ACTIVATE;
    procedure WMHScroll(var Message: TWMHScroll); message WM_HSCROLL;
    procedure WMShowWindow(var Message: TWMShowWindow); message WM_SHOWWINDOW;
  public
    procedure AdjustNewHeight;
    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer); override;
    procedure SetBoundsEx(ALeft, ATop, AWidth, AHeight: Integer);
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char);override;

    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure SetParent(AParent: TWinControl); override;
    procedure Show;
    procedure Hide;
    property AlwaysVisible: boolean read FAlwaysVisible write FAlwaysVisible;
    property DrawingStyle: TDCDrawingStyle read FDrawingStyle
      write SetDrawingStyle;
    property PopupAlignment: TWindowAlignment read FPopupAlignment
      write SetPopupAlignment;
    property Owner: TControl read FOwner write FOwner;
    property PopupBorderStyle: TPopupBorderStyle read FPopupBorderStyle
      write SetPopupBorderStyle;
    property DropDownRows: integer read FDropDownRows write FDropDownRows;
    property OnDblClick;
    property BorderStyle;
    property Buttons: TDCEditButtons read FButtons;
    property Color;
    property Items;
    property Images;
    property OnChange;
    property OnCollapsed;
    property OnExpanded;
    property OnCollapsing;
    property OnExpanding;
    property OnKeyPress;
    property Caption;
    property ShowHeader: boolean read FShowHeader write SetShowHeader;
    property OnCustomDrawItem;
  end;

  TDCClipPopup = class(TDCPopupWindow, IDCPopupWindow)
  private
    FButtons: TDCEditButtons;
    FCursorMode: TCursorMode;
    FOptions: TClipFormOptions;
    FPopupBorderStyle: TPopupBorderStyle;
    FDrawingStyle: TDCDrawingStyle;
    FBorderSize: integer;
    FMargins: TRect;
    procedure SetPopupBorderStyle(Value: TPopupBorderStyle);
    procedure BeginMoving(XCursor, YCursor, Delta: integer);
    procedure SetOptions(const Value: TClipFormOptions);
    procedure SetDrawingStyle(const Value: TDCDrawingStyle);
  protected
    procedure ButtonsChange(Sender: TObject); virtual;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure CMSetAlignment(var Message: TMessage); message CM_SETALIGNMENT;
    procedure CreateWnd; override;
    procedure DrawClientRect;
    procedure DrawFooter; virtual;
    procedure DrawHeader(const DC: HDC; var R: TRect); virtual;
    procedure InvalidateButtons; virtual;
    procedure RedrawBorder; virtual;
    procedure SetMargins; virtual;
    procedure WMNCCalcSize(var Message: TWMNCCalcSize); message WM_NCCALCSIZE;
    procedure WMNCPaint(var Message: TWMNCPaint); message WM_NCPAINT;
    procedure WMNCHitTest(var Message: TWMNCHitTest); message WM_NCHITTEST;
    procedure WMSetCursor(var Message: TWMSetCursor); message WM_SETCURSOR;
    procedure WMNCLButtonDown(var Message: TWMNCLButtonDown); message WM_NCLBUTTONDOWN;
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
    procedure WMActivate (var Message: TWMActivate); message WM_ACTIVATE;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure Show; override;
    procedure Hide; override;
    property Buttons: TDCEditButtons read FButtons;
    property Options: TClipFormOptions read FOptions write SetOptions;
    property DrawingStyle: TDCDrawingStyle read FDrawingStyle
      write SetDrawingStyle;
    property PopupBorderStyle: TPopupBorderStyle read FPopupBorderStyle
      write SetPopupBorderStyle;
    property Margins: TRect read FMargins;
    property BorderSize: integer read FBorderSize;
    property Caption;
    property Color;
    property Font;
  end;

  TCustomClipPopup = class(TDCClipPopup)
  private
    FHintHeight: integer;
    FLinesCount: integer;
    FMaxPos: integer;
    FOnButtonClick: TNotifyEvent;
    FPopupStyle: TClipPopupStyle;
    FUpdateCount: integer;
    function GetActiveButton: TDCEditButton;
    procedure SetPopupStyle(const Value: TClipPopupStyle);
  protected
    procedure AdjustClipSize; dynamic;
    procedure ButtonClick(Sender: TObject); virtual;
    procedure DrawButtonHint(Sender: TObject; Mode: integer); virtual;
    procedure RedrawBorder; override;
    procedure ButtonsChange(Sender: TObject); override;
    function GetConnectionRect(ARect: TRect): TRect; virtual;
  public
    function AddButton(AName, AResource, AHint: string; ALine,
      APos: integer): TDCEditButton;
    procedure AddButtons; virtual;
    procedure BeginUpdate;
    procedure Clear;
    constructor Create(AOwner: TComponent); override;
    procedure EndUpdate;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    property ActiveButton: TDCEditButton read GetActiveButton;
    property OnButtonClick: TNotifyEvent read FOnButtonClick write FOnButtonClick;
    property PopupStyle: TClipPopupStyle read FPopupStyle write SetPopupStyle;
    property UpdateCount: integer read FUpdateCount;
  end;

  TComboClipPopup = class;

  TComboOption = (coHidePickup, coLinkPopup);
  TComboOptions = set of TComboOption;

  IDPopupControl = interface(IUnknown)
    ['{97BD10D2-378D-4D07-9F90-172BD8680CD7}']
    function GetImages: TCustomImageList;
    procedure InsertEmptyItem(ACaption: string);
    function InsertMenuItem(Index: integer; MenuItem: TDCPopupMenuItem): boolean;
    procedure SetImages(const Value: TCustomImageList);
    property Images: TCustomImageList read GetImages write SetImages;
  end;

  IDCPopupHolder = interface(IUnknown)
    ['{A1F4D585-3AAB-4716-928F-E7220F4E6E14}']
    procedure Cancel;
    procedure DoClick(Sender: TObject);
    function GetBoundsRect: TRect;
    procedure GetConnectionPos(var X, Y: integer; var AWidth: integer;
      var Position: TPopupPosition);
    function GetControl: TWinControl;
    function GetDroppedDown: boolean;
    function InitPopupItems(PopupControl: IDPopupControl): boolean;
    procedure ResetProperties;
    procedure SetDroppedDown(const Value: boolean);
    procedure SetDroppedIndirect(const Value: boolean);
    property DroppedDown: boolean read GetDroppedDown write SetDroppedDown;
  end;

  TDCComboButton = class(TDCEditButton, IDCPopupHolder)
  private
    FComboOptions: TComboOptions;
    FDroppedDown: boolean;
    FPopupItems: TDCPopupMenu;
    FPopupPosition: TPopupPosition;
    procedure SetComboOptions(const Value: TComboOptions);
    function GetPopupRect(ARect: TRect): TRect;
    procedure SetPopupItems(const Value: TDCPopupMenu);
    procedure ItemsChange(Sender: TObject; Source: TDCPopupMenuItem;
      Rebuild: Boolean);
    procedure SetDroppedDown(const Value: boolean);
    function GetDroppedDown: boolean;
  protected
    function _AddRef: Integer; stdcall;
    function _Release: Integer; stdcall;
    procedure DoClick(Sender: TObject); virtual;
    procedure DrawEditText(ACanvas: TCanvas; var TextRect: TRect); override;
    procedure BeginDrawBkgn(ACanvas: TCanvas; ARect: TRect; AState: TButtonState;
      var ImageRect: TRect; var TextRect: TRect); override;
    procedure BeginDrawText(ACanvas: TCanvas; ATextRect: TRect;
      AState: TButtonState); override;
    function GetBoundsRect: TRect;
    procedure GetConnectionPos(var X, Y: integer; var AWidth: integer;
      var Position: TPopupPosition);
    function GetControl: TWinControl;
    function InitPopupItems(PopupControl: IDPopupControl): boolean; virtual;
    function QueryInterface(const IID: TGUID; out Obj): HResult; virtual; stdcall;
    procedure SetDroppedIndirect(const Value: boolean);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Cancel;
    procedure Click; override;
    procedure DrawBorder(ACanvas: TCanvas; ARect: TRect); override;
    function GetTextSize: TPoint; override;
    function UpdateButtonState(X, Y: integer;
      ADown, AMove: boolean): boolean; override;
    property ComboOptions: TComboOptions read FComboOptions write SetComboOptions;
    property DroppedDown: boolean read GetDroppedDown write SetDroppedDown;
    property PopupItems: TDCPopupMenu read FPopupItems write SetPopupItems;
  end;

  TComboClipPopup = class(TCustomClipPopup, IDPopupControl)
  private
    FPopupHolder: IDCPopupHolder;
    function GetImages: TCustomImageList;
  protected
    procedure CMHideClipTrack(var Message: TMessage); message CM_HIDECLIPTRACK;
    procedure ButtonClick(Sender: TObject); override;
    procedure DoHookKeyDown(var Msg: TMsg); virtual;
    function GetConnectionRect(ARect: TRect): TRect; override;
    function GetRegion(RegionType: integer): HRGN; override;
    function GetShadowPos: TPoint; override;
    procedure SetImages(const Value: TCustomImageList);
  public
    constructor Create(APopupHolder: IDCPopupHolder); reintroduce; virtual;
    procedure Hide; override;
    procedure InsertEmptyItem(ACaption: string);
    function InsertMenuItem(Index: integer; MenuItem: TDCPopupMenuItem): boolean;
  end;


procedure DrawPopupBorder(Control: TWinControl; const DC: HDC; var R: TRect;
  BorderStyle: TPopupBorderStyle; DrawingStyle: TDCDrawingStyle);
procedure DrawPopupHeader(Control: TWinControl; const DC: HDC; var R: TRect;
  BorderStyle: TPopupBorderStyle; DrawingStyle: TDCDrawingStyle);

procedure ProcessMovingWindow(Sender: TWinControl; XCursor, YCursor: integer;
  CursorMode: TCursorMode; ItemHeight: integer);

function ShowWindow(Handle: HWND; Alignment: TWindowAlignment;
   var WindowBounds: TRect; AlwaysVisible: boolean; Parent: TControl = nil): integer;
procedure HideWindow(Handle: HWND);

procedure HookPopupHooks(AHookControl: TControl; dwThreadId: DWORD);
procedure UnHookPopupHooks;

function TrackClipPopup(PopupHolder: IDCPopupHolder): DWORD;


implementation

uses
  DCResource, DCChoice, TypInfo;

type
  TWinControlCracker = class(TWinControl)
    {for implement protected properties and functions}
  end;

var
  ComboClipPopup: TComboClipPopup;
  ClipPopupHook: HHOOK;
  DropDownMoving: boolean;
  HookControl: TControl;
  HookCount: integer;
  PopupHook: HHOOK;

{ TDCPopupWindow }

function GetWindowPos(Handle: HWND; Alignment: TWindowAlignment;
  var WindowBounds: TRect; AlwaysVisible: boolean; Parent: TControl;
  var P: TPoint): integer;
 var
  AHeight, AWidth: integer;
begin
  Result := 0;
  AHeight := WindowBounds.Bottom - WindowBounds.Top;
  AWidth := WindowBounds.Right  - WindowBounds.Left;
  if Parent <> nil  then
  begin
    case Alignment of
      wpNone:
        begin
          Result  := -1;
          P := Point(WindowBounds.Left, WindowBounds.Top);
          //if AlwaysVisible then SetRectInDesktop(P, AWidth, AHeight, Point(0,0));
        end;
      wpBottomLeft:
        begin
          P := Point((Parent.ClientWidth-Parent.Width) div 2,
            Parent.ClientHeight + (Parent.Height - Parent.ClientHeight) div 2);
          P := Parent.ClientToScreen(P);
          if AlwaysVisible then
            Result := SetRectInDesktop(P, AWidth, AHeight,
              Point(0, (Screen.DesktopTop + Screen.DesktopHeight) - P.Y +
              Parent.Height));
        end;
      wpBottomRight:
        begin
          P := Point(Parent.ClientWidth  + (Parent.Width - Parent.ClientWidth) div 2,
            Parent.ClientHeight + (Parent.Height - Parent.ClientHeight) div 2);
          P := Parent.ClientToScreen(P);
          P.X := P.X - AWidth;
          if AlwaysVisible then
            Result := SetRectInDesktop(P, AWidth, AHeight,
              Point(0, (Screen.DesktopTop + Screen.DesktopHeight) - P.Y +
              Parent.Height));
        end;
      wpTopRight:
        begin
          P := Point(Parent.ClientWidth, -
            ((Parent.Height-Parent.ClientHeight) shr 1));
          P := Parent.ClientToScreen(P);
          if AlwaysVisible then
            Result := SetRectInDesktop(P, AWidth, AHeight,
              Point((Screen.DesktopLeft + Screen.DesktopWidth) - P.X +
              Parent.ClientWidth + (Parent.Width - Parent.ClientWidth) div 2, 0));
        end;
      wpOffset:
        begin
          P := Point(WindowBounds.Left, WindowBounds.Top);
          P := Parent.ClientToScreen(P);
          if AlwaysVisible then
            Result := SetRectInDesktop(P, AWidth, AHeight, Point(0, 0));
        end;
    end;
  end
  else begin
    Result  := -1;
    P := Point(WindowBounds.Left, WindowBounds.Top);
    if AlwaysVisible then
    begin
      if P.Y < 0 then P.Y := 0;
      if (P.Y + AHeight) > Screen.Height then
      begin
        P.Y := Screen.Height - AHeight;
      end;
      if P.X < 0 then P.X := 0;
      if (P.X + AWidth) > Screen.Width then
      begin
        P.X := Screen.Width - AWidth;
      end;
    end;
  end;
end;

function ShowWindow(Handle: HWND; Alignment: TWindowAlignment;
   var WindowBounds: TRect; AlwaysVisible: boolean; Parent: TControl = nil): integer;
 var
  P: TPoint;
  ZOrder: THandle;
  HintParam: THintWindowParam;
begin
  Result := GetWindowPos(Handle, Alignment, WindowBounds, AlwaysVisible,
    Parent, P);

  ZOrder := HWND_TOPMOST;

  HintParam.Handle := Handle;
  HintParam.Active := True;
  HintParam.x := P.X;
  HintParam.y := P.Y;

  Parent.Perform(CM_POPUPWINDOWSHOW, 0, Longint(@HintParam));

  WindowBounds.Left := P.X;
  WindowBounds.Top  := P.Y;

  SetWindowPos(Handle, ZOrder, P.X, P.Y, 0, 0, SWP_NOSIZE or SWP_NOZORDER or
    SWP_NOACTIVATE or SWP_SHOWWINDOW);
  BringWindowToTop(Handle);

end;

procedure HideWindow(Handle: HWND);
begin
  SetWindowPos(Handle, 0, 0, 0, 0, 0, SWP_NOZORDER or SWP_NOMOVE or
    SWP_NOSIZE or SWP_NOACTIVATE or SWP_HIDEWINDOW);
end;

function PopupGetMsgHook(nCode: Integer; wParam: Longint;
  var Msg: TMsg): Longint; stdcall;
begin
  Result := CallNextHookEx(PopupHook, nCode, wParam, Longint(@Msg));
  if (nCode >= 0) and (Application <> nil) and (HookControl <> nil) then
    HookControl.Perform(CM_HOOKMESSAGE, wParam, Integer(@Msg));
end;

procedure HookPopupHooks(AHookControl: TControl; dwThreadId: DWORD);
begin
  if PopupHook = 0 then
  begin
    PopupHook := SetWindowsHookEx(WH_GETMESSAGE, @PopupGetMsgHook, 0, dwThreadId);
    HookControl := AHookControl;
  end;
  if HookControl = AHookControl then Inc(HookCount);
end;

procedure UnHookPopupHooks;
begin
  if (HookCount > 0) then Dec(HookCount);
  if HookCount = 0 then
  begin
    if PopupHook <> 0 then UnhookWindowsHookEx(PopupHook);
    PopupHook := 0;
    HookControl := nil;
  end;
end;

procedure ProcessMovingWindow(Sender: TWinControl; XCursor, YCursor: integer;
  CursorMode: TCursorMode; ItemHeight: integer);
 var
  ScreenDC: HDC;
  Accept: boolean;
  Msg: TMsg;
  MousePoint: TPoint;
  NextRect, LastRect: TRect;
  AItemHeight,ADelta: integer;
  InfoWindow: TDCMessageWindow;
  ScreenBitmap: TBitmap;

 procedure UpdateInfoWindow;
  var
   ScreenDC: HDC;
 begin
   with InfoWindow do
   begin
     Left := LastRect.Left + 4;
     Top  := LastRect.Top  + 4;
     case CursorMode of
       cmMove:
         Caption := Format('%d, %d', [LastRect.Left, LastRect.Top]);
       cmResize:
         Caption := Format('%d x %d',
           [(LastRect.Right - LastRect.Left), (LastRect.Bottom - LastRect.Top)]);
     end;
      ScreenDC := GetDC(0);
      try
        ScreenBitmap.Width  := Width;
        ScreenBitmap.Height := Height;
        BitBlt(ScreenBitmap.Canvas.Handle, 0, 0, Width, Height, ScreenDC,
          Left + 1, Top + 1, SRCCOPY);
      finally
        ReleaseDC(0, ScreenDC);
      end;
      //Show;
   end
 end;

 procedure HideInfoWindow;
  var
   ScreenDC: HDC;
 begin
   with InfoWindow do
   begin
     //Hide;
     ScreenDC := GetDC(0);
     try
       BitBlt(ScreenDC, Left + 1, Top + 1, Width, Height,
         ScreenBitmap.Canvas.Handle, 0, 0, SRCCOPY);
     finally
       ReleaseDC(0, ScreenDC);
     end;
   end
 end;

 procedure MouseMoved;
  var
   Value,Pos: TPoint;
 begin

   GetCursorPos(Pos);
   Value := Pos;

   { }
   Pos.X := Pos.X - MousePoint.X;
   Pos.Y := Pos.Y - MousePoint.Y;
   NextRect   := LastRect;

   case CursorMode of
     cmResize: {Resize Window}
      begin
        NextRect.Right  := NextRect.Right  + Pos.X;
        if Abs(ADelta) >= (ItemHeight shr 1) then
        begin
          if Abs(ADelta) > ItemHeight then
            AItemHeight := (ADelta div ItemHeight)*ItemHeight
          else
            AItemHeight := (ADelta div Abs(ADelta))*ItemHeight;
          NextRect.Bottom := NextRect.Bottom + AItemHeight;
          Value.Y := NextRect.Bottom;
          ADelta  := 0;
          SetCursorPos(Value.X, Value.Y);
        end
        else
          ADelta := ADelta + Pos.Y;
      end;
     cmMove  : {Move Window}
      OffsetRect(NextRect, Pos.X, Pos.Y);
   end;

   if not EqualRect(NextRect, LastRect) then
   begin
     HideInfoWindow;
     DrawFocusedRect(ScreenDC, @LastRect, @NextRect, 2);
     LastRect := NextRect;
     UpdateInfoWindow;
   end;

   MousePoint := Value;

 end;

 procedure Dropped;
  var
   Value: integer;
 begin
   Sender.Perform(CM_SETALIGNMENT, Integer(wpNone), 0);
   if LastRect.Left > LastRect.Right then
   begin
     Value := LastRect.Left;
     LastRect.Left  := LastRect.Right;
     LastRect.Right := Value;
   end;
   if LastRect.Top > LastRect.Bottom then
   begin
     Value := LastRect.Top;
     LastRect.Top   := LastRect.Bottom;
     LastRect.Bottom:= Value;
   end;

   Sender.SetBounds(LastRect.Left, LastRect.Top,
      LastRect.Right-LastRect.Left, LastRect.Bottom-LastRect.Top);

 end;
begin
  Accept := False;
  ADelta := 0;
  MousePoint := Point(XCursor, YCursor);
  with Sender do
  begin
    LastRect   := Rect(Left, Top, Left+Width, Top+Height);

    ScreenDC := GetDCEx(GetDesktopWindow, 0,
      DCX_LOCKWINDOWUPDATE or DCX_CACHE or DCX_WINDOW);

    InfoWindow  := TDCMessageWindow.Create(nil);
    ScreenBitmap := TBitmap.Create;

    with InfoWindow do
    begin
      AutoHide := False;
      Parent   := Sender;
      PopupAlignment := wpOffset;
    end;

    try
      SetCapture(Handle);
      DrawFocusedRect(ScreenDC, nil, @LastRect, 2);
      UpdateInfoWindow;

      DropDownMoving := True;
      while GetCapture = Handle do begin
        case Integer(GetMessage(Msg, 0, 0, 0)) of
          -1: Break;
          0 :
           begin
             PostQuitMessage(Msg.WParam);
             Break;
           end;
        end;

        case Msg.Message of
          WM_KEYDOWN, WM_KEYUP:
            case Msg.WParam of
              VK_ESCAPE:Break;
            end;
          WM_MOUSEMOVE:
            MouseMoved;
          WM_LBUTTONDOWN, WM_LBUTTONDBLCLK:
            Break;
          WM_LBUTTONUP:
            begin
              Accept := True;
              Break;
            end;
          WM_RBUTTONDOWN..WM_MBUTTONDBLCLK:;
          else begin
            TranslateMessage(Msg);
            DispatchMessage(Msg);
          end;
        end;
      end;

    finally
      ReleaseCapture;

      { Hide dragging outline and release the DC }

      DrawFocusedRect(ScreenDC, nil, @LastRect, 2);
      ReleaseDC(GetDesktopWindow, ScreenDC);

      InfoWindow.Free;
      ScreenBitmap.Free;
      DropDownMoving := False;
    end;
  end;

  if Accept then Dropped;
end;

procedure DrawPopupBorder(Control: TWinControl; const DC: HDC; var R: TRect;
  BorderStyle: TPopupBorderStyle; DrawingStyle: TDCDrawingStyle);
 var
  PopupWindow: IDCPopupWindow;
  ControlDC: HDC;
  ABrush, BBrush: HBRUSH;
  Struct: TPolyLineStruct;
begin
  with TWinControlCracker(Control) do
  begin
    if DC = 0 then
    begin
      ControlDC := GetWindowDC(Handle);
      GetWindowRect(Handle, R);
      OffsetRect (R, -R.Left, -R.Top);
    end
    else
      ControlDC := DC;

    try
      case BorderStyle of
        brNone:
           {Nothing};
        brSingle:
          begin
            case DrawingStyle of
              dtNormal:
                begin
                  ABrush := CreateSolidBrush(clBlack);
                  FrameRect(ControlDC, R, ABrush);
                  DeleteObject(ABrush);
                end;
              dtFlat:
                begin
                  {not implement yet};
                end;
              dtXPStyle:
                begin
                  BBrush := CreateSolidBrush(clDarkShadow);
                  FrameRect(ControlDC, R, BBrush);
                  DeleteObject(BBrush);
                  InflateRect(R, -1, -1);

                  CreatePolyLineStruct(Struct, 3, clXPLightBackground);
                  with R do
                  begin
                    AddPoint2Struct(Struct, Left, Top, Right, Top);
                    AddPoint2Struct(Struct, Right - 1, Top, Right - 1, Bottom);
                    AddPoint2Struct(Struct, Left, Bottom - 1, Right, Bottom - 1);
                  end;
                  PaintPolyLine(ControlDC, Struct);
                  DestroyPolyLineStruct(Struct);

                  CreatePolyLineStruct(Struct, 1, clXPDarkBackground);
                  with R do
                  begin
                    AddPoint2Struct(Struct, Left, Top + 1, Left, Bottom - 1);
                  end;
                  PaintPolyLine(ControlDC, Struct);
                  DestroyPolyLineStruct(Struct);
                end;
            end;
          end;
        brRaised:
          begin
            case DrawingStyle of
              dtNormal:
                begin
                  DrawEdge(ControlDC, R, BDR_RAISEDOUTER, BF_RECT);
                  InflateRect(R, -1, -1);
                  DrawEdge(ControlDC, R, BDR_RAISEDINNER, BF_RECT);
                  InflateRect(R, -1, -1);
                end;
              dtFlat:
                begin
                  {not implement yet};
                end;
              dtXPStyle:
                begin
                  FrameRect(ControlDC, R, GetSysColorBrush(COLOR_BTNSHADOW));
                  InflateRect(R, -1, -1);
                  DrawEdge(ControlDC, R, BDR_RAISEDINNER, BF_RECT);
                  InflateRect(R, -1, -1);
                end;
            end;

            if QueryInterface(IDCPopupWindow, PopupWindow) = S_OK then
              with PopupWindow do
              begin
                DrawHeader(ControlDC, R);
                DrawClientRect;
                DrawFooter;
              end;
          end;
      end;
    finally
      if DC = 0 then ReleaseDC(Handle, ControlDC);
    end;
  end;
end;

procedure DrawPopupHeader(Control: TWinControl; const DC: HDC; var R: TRect;
  BorderStyle: TPopupBorderStyle; DrawingStyle: TDCDrawingStyle);
 var
  ControlDC: HDC;
  TextRect: TRect;
begin
  with TWinControlCracker(Control) do
  begin
    if DC = 0 then
    begin
      ControlDC := GetWindowDC(Handle);
      GetWindowRect(Handle, R);
      OffsetRect (R, -R.Left, -R.Top);
    end
    else
      ControlDC := DC;

    try
      case DrawingStyle of
        dtNormal:
          begin
            R.Bottom := R.Top + br_HeaderHeight;
            DrawCaption(Handle, ControlDC, R, DC_TEXT or DC_SMALLCAP or DC_ACTIVE
              or DC_GRADIENT);
          end;
        dtFlat:
          begin
            {not implement yet};
          end;
        dtXPStyle:
          begin
            R.Bottom := R.Top + br_HeaderHeight;
            Dec(R.Right);
            DrawCaption(Handle, ControlDC, R, DC_TEXT or DC_SMALLCAP);

            TextRect := R;
            TextRect.Left := TextRect.Right;
            DrawEdge(ControlDC, TextRect, BDR_RAISEDINNER, BF_LEFT);
          end;
      end;
    finally
      if DC = 0 then ReleaseDC(Handle, ControlDC);
    end;
  end;
end;

procedure TDCPopupWindow.CMRelease(var Message: TMessage);
begin
  Free;
end;

procedure TDCPopupWindow.CMShowingChanged(var Message: TMessage);
 var
  AOrientation: integer;
begin
  AOrientation := ShowWindow(Handle, FPopupAlignment, FWindowRect,
    FAlwaysVisible, Owner);
  if AOrientation <> -1 then Orientation := AOrientation;
end;

constructor TDCPopupWindow.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  FPFDefWndProc := nil;
  {$IFDEF DELPHI_V6}
    FPFNewWndProc := Classes.MakeObjectInstance(PFWndProc);
  {$ELSE}
    FPFNewWndProc := MakeObjectInstance(PFWndProc);
  {$ENDIF}

  FVisible := False;
  ControlStyle := ControlStyle + [csNoDesignVisible, csReplicatable,
    csAcceptsControls, csOpaque];

  inherited Visible := False;

  Canvas.Brush.Style := bsClear;
  SetRectEmpty(FWindowRect);

  FAlwaysVisible := True;
  FOwner := TControl(AOwner);
  FPopupOptions := [];
  FShadow := TDCControlShadow.Create(Self);
end;


procedure TDCPopupWindow.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do
  begin
    ExStyle := WS_EX_TOOLWINDOW or WS_EX_TOPMOST;
    WindowClass.Style := CS_SAVEBITS;
    AddBiDiModeExStyle(ExStyle);
  end;
end;

procedure TDCPopupWindow.CreateWnd;
begin
  inherited CreateWnd;
  if HandleAllocated then
  begin
    Windows.SetParent(Handle, 0);
    CallWindowProc(DefWndProc, Handle, WM_SETFOCUS, 0, 0);
  end;
end;

destructor TDCPopupWindow.Destroy;
begin
  if Visible then Hide;
  {$IFDEF DELPHI_V6}
    Classes.FreeObjectInstance(FPFNewWndProc);
  {$ELSE}
    FreeObjectInstance(FPFNewWndProc);
  {$ENDIF}
  FreeAndNil(FShadow);
  inherited;
end;

function TDCPopupWindow.GetRegion(RegionType: integer): HRGN;
 var
  R: TRect;
begin
  GetWindowRect(Handle, R);
  OffsetRect(R, -R.Left, -R.Top);
  Result := CreateRectRgnIndirect(R);
end;

function TDCPopupWindow.GetShadowPos: TPoint;
begin
  Result := Point(0, 0);
end;

function TDCPopupWindow.GetTextHeight(Value: string): integer;
 var
  R: TSize;
begin
  Windows.GetTextExtentPoint(Canvas.Handle, PChar(Value), Length(Value), R);
  Result := R.CY;
end;

function TDCPopupWindow.GetTextWidth(Value: string): integer;
 var
  R: TSize;
begin
  Windows.GetTextExtentPoint(Canvas.Handle, PChar(Value), Length(Value), R);
  Result := R.CX;
end;

procedure TDCPopupWindow.Hide;
begin
  WndProcAction(0);
  if Assigned(FShadow) and FShadow.FVisible then FShadow.Hide;
  HideWindow(Handle);
  FVisible := False;
end;

procedure TDCPopupWindow.PFWndProc(var Message: TMessage);
 var
  ParentForm: TCustomForm;
  WndProc: pointer;
begin
  try
    WndProc := FPFDefWndProc;
    ParentForm := GetParentForm(Self);
    with Message do
    begin
      case Msg of
        WM_NCLBUTTONDOWN:
          with TWMNCLButtonDown(Message) do
          begin
            if (HitTest = HTCAPTION) and not IsIconic(ParentForm.Handle) then
            begin
              Hide;
            end;
          end;
        WM_ACTIVATE:
          WParam := WA_INACTIVE;
      end;
      if ParentForm.HandleAllocated then
        Result := CallWindowProc(WndProc, ParentForm.Handle, Msg, WParam, LParam);
    end;
  except
    {}
  end;
end;

procedure TDCPopupWindow.Release;
begin
  Hide;
  PostMessage(Handle, CM_RELEASE, 0, 0);
end;

procedure TDCPopupWindow.SetBounds(ALeft, ATop, AWidth, AHeight: Integer);
begin
  if HandleAllocated and Visible and FShadow.Visible then FShadow.Hide;
  inherited;
  FWindowRect := Rect(Left, Top, Left + Width, Top + Height);
  UpdateShadowPos(True);
end;

procedure TDCPopupWindow.SetBoundsEx(ALeft, ATop, AWidth,
  AHeight: Integer);
begin
  FWindowRect := Rect(ALeft, ATop, ALeft + AWidth, ATop + AHeight);
  if FVisible then
    Show
  else
    inherited SetBounds(ALeft, ATop, AWidth, AHeight);
end;

procedure TDCPopupWindow.SetOrientation(const Value: integer);
begin
  FOrientation := Value;
end;

procedure TDCPopupWindow.SetPopupAlignment(Value: TWindowAlignment);
begin
  if Value <> FPopupAlignment then
  begin
    FPopupAlignment := Value;
    if Visible then Show;
  end;
end;

procedure TDCPopupWindow.SetVisible(const Value: boolean);
begin
  if FVisible <> Value then Hide;
end;

procedure TDCPopupWindow.Show;
 var
  AOrientation: integer;
begin
  HandleNeeded;
  if not Visible then
  begin
    if FShadow.FVisible then UpdateShadowPos(False);
    WndProcAction(1);
  end;

  AOrientation := ShowWindow(Handle, FPopupAlignment, FWindowRect,
    FAlwaysVisible, Owner);

  if FShadow.FVisible then FShadow.Show;

  if AOrientation <> -1 then Orientation := AOrientation;
  FVisible :=  True;
end;

procedure TDCPopupWindow.UpdateShadowPos(AShow: boolean);
 var
  Rgn: HRGN;
  R, R1: TRect;
  P, P1: TPoint;
  AOrientation: integer;
begin
  if HandleAllocated and (Width > 0) and (Height > 0) and
    (Visible or not AShow) then
  begin
    R := FWindowRect;
    R.Right  := _intMin(R.Right, Screen.Width);
    R.Bottom := _intMin(R.Bottom, Screen.Height);
    AOrientation := GetWindowPos(Handle, FPopupAlignment, R, FAlwaysVisible, Owner, P);
    if AOrientation <> -1 then Orientation := AOrientation;

    Rgn := GetRegion(0);
    GetRgnBox(Rgn, R1);

    P1 := GetShadowPos;
    R.Left := P.X + P1.X;
    R.Top  := P.Y + P1.Y;

    with FShadow do
    begin
      P := GetShadowPos;
      SetBounds(R.Left + P.X, R.Top + P.Y, R1.Right, R1.Bottom);
      SaveBackground(Rgn);
      if AShow then Show;
    end;

    DeleteObject(Rgn);
  end;
end;

procedure TDCPopupWindow.WMMouseActivate(var Message: TWMActivate);
begin
  inherited;
  Message.Result := MA_NOACTIVATE;
  SetWindowPos (Handle, HWND_TOP, 0, 0, 0, 0,
     SWP_NOACTIVATE or SWP_NOMOVE or SWP_NOSIZE);
end;

procedure TDCPopupWindow.WMNCCalcSize(var Message: TWMNCCalcSize);
begin
  inherited;
end;

procedure TDCPopupWindow.WMNCPaint(var Message: TWMNCPaint);
begin
  {}
end;

procedure TDCPopupWindow.WndProcAction(Action: integer);
 var
  ParentForm: TCustomForm;
begin
  inherited;
  if poSetWindowProc in PopupOptions then
  begin
    if not (csDesigning in ComponentState) then
    begin
      ParentForm := GetParentForm(Self);
      case Action of
        0:
          if Assigned(FPFDefWndProc) and
            (ParentForm <> nil) and ParentForm.HandleAllocated then
          begin
            SetWindowLong(ParentForm.Handle, GWL_WNDPROC, LongInt(FPFDefWndProc));
            FPFDefWndProc := nil;
          end;
        1:
          if (ParentForm <> nil) and ParentForm.HandleAllocated then
          begin
            if FPFDefWndProc = nil then
              FPFDefWndProc := Pointer(GetWindowLong(ParentForm.Handle, GWL_WNDPROC));
            SetWindowLong(ParentForm.Handle, GWL_WNDPROC, LongInt(FPFNewWndProc));
          end;
      end;
    end;
  end;
end;

{ TDCPopupListBox }

constructor TDCPopupListBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FVisible    := False;
  ControlStyle := ControlStyle + [csNoDesignVisible, csReplicatable,
                                  csAcceptsControls];

  Visible := False;
  
  Canvas.Brush.Style := bsClear;
  FAlwaysVisible := True;
  FOwner := TControl(AOwner);
  SetRectEmpty(FWindowRect);
  Style := lbOwnerDrawVariable;
  FDropDownRows := 8;
  AdjustNewHeight;
end;

procedure TDCPopupListBox.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do
  begin
    ExStyle := WS_EX_TOOLWINDOW or WS_EX_TOPMOST;
    AddBiDiModeExStyle(ExStyle);
    WindowClass.Style := CS_SAVEBITS;
  end;
end;

procedure TDCPopupListBox.CreateWnd;
begin
  inherited CreateWnd;
  if Parent <> nil then
  begin
    Windows.SetParent(Handle, 0);
    CallWindowProc(DefWndProc, Handle, WM_SETFOCUS, 0, 0);
  end;  
end;

procedure TDCPopupListBox.Hide;
begin
  HideWindow(Handle);
  FVisible := False;
end;

procedure TDCPopupListBox.SetBounds(ALeft, ATop, AWidth, AHeight: Integer);
begin
  inherited;
  FWindowRect := Rect(Left,Top,Left+Width,Top+Height);
end;

procedure TDCPopupListBox.SetBoundsEx(ALeft, ATop, AWidth,
  AHeight: Integer);
begin
  FWindowRect := Rect(ALeft,ATop,ALeft+AWidth,aTop+AHeight);
  if FVisible then Show;
end;

procedure TDCPopupListBox.SetPopupAlignment(Value: TWindowAlignment);
begin
  if Value <> FPopupAlignment then
  begin
    FPopupAlignment := Value;
    if Visible then Show;
  end;
end;

procedure TDCPopupListBox.Show;
begin
  SetListHeight(0);
  ShowWindow(Handle, FPopupAlignment, FWindowRect, FAlwaysVisible, Owner);
  FVisible :=  True;
end;

procedure TDCPopupListBox.WMMouseActivate(var Message: TWMActivate);
begin
  inherited;
  Message.Result := MA_NOACTIVATE;
  SetWindowPos (Handle, HWND_TOP, 0, 0, 0, 0,
     SWP_NOACTIVATE or SWP_NOMOVE or SWP_NOSIZE);
end;

procedure TDCPopupListBox.WMNCCalcSize(var Message: TWMNCCalcSize);
begin
  inherited;
  case FPopupBorderStyle of
    brNone  :;
    brSingle:
      begin
        InflateRect(Message.CalcSize_Params^.rgrc[0], -1, -1);
      end;
    brRaised:
      begin
        InflateRect(Message.CalcSize_Params^.rgrc[0], -2, -2);
      end;
  end;
end;

procedure TDCPopupListBox.SetPopupBorderStyle(Value: TPopupBorderStyle);
begin
  if FPopupBorderStyle <> Value then
  begin
    FPopupBorderStyle := Value;
    case FPopupBorderStyle of
      brNone:
        FBorderSize := 0;
      brSingle:
        FBorderSize := 1;
      brRaised:
        FBorderSize := 2;
    end;
    RecreateWnd;
  end;
end;

procedure TDCPopupListBox.WMNCPaint(var Message: TWMNCPaint);
begin
  inherited;
  RedrawBorder;
end;

procedure TDCPopupListBox.RedrawBorder;
 var
  R: TRect;
begin
  DrawPopupBorder(Self, 0, R, FPopupBorderStyle, dtNormal);
end;

procedure TDCPopupListBox.CNDrawItem(var Message: TWMDrawItem);
var
  State: TOwnerDrawState;
begin
  with Message.DrawItemStruct^ do
  begin
    {$IFDEF DELPHI_V5UP}
       State := TOwnerDrawState(LongRec(itemState).Lo);
    {$ELSE}
       State := TOwnerDrawState(WordRec(LongRec(itemState).Lo).Lo);
    {$ENDIF}
    Canvas.Lock;
    try
      Canvas.Handle := hDC;
      Canvas.Font := Font;
      Canvas.Brush := Brush;
      if (Integer(itemID) >= 0) and (odSelected in State) then
      begin
        Canvas.Brush.Color := clHighlight;
        Canvas.Font.Color := clHighlightText
      end;
      if Integer(itemID) >= 0 then
        DrawItem(itemID, rcItem, State) else
        Canvas.FillRect(rcItem);
    finally
      Canvas.Handle := 0;
      Canvas.Unlock;
    end;
  end;

end;

procedure TDCPopupListBox.WMMouseMove(var Message: TWMMouseMove);
 var
  ItemPos: integer;
begin
  inherited;
  with Message do
    ItemPos := ItemAtPos(Point(XPos,YPos), True);
  if ItemPos <> -1 then begin
    ItemIndex := ItemPos;
  end;
end;

procedure TDCPopupListBox.WMFontChange(var Message: TWMFontChange);
begin
  inherited;
  AdjustNewHeight;
end;

procedure TDCPopupListBox.AdjustNewHeight;
var
  DC: HDC;
  SaveFont: HFONT;
  Metrics: TTextMetric;
begin
  DC := GetDC(0);
  SaveFont := SelectObject(DC, Font.Handle);
  try
    GetTextMetrics(DC, Metrics);
    ItemHeight := Metrics.tmHeight + 3;
  finally
    SelectObject(DC, SaveFont);
    ReleaseDC(0, DC);
  end;
end;

procedure TDCPopupListBox.SetListHeight(Increment: integer);
 var
  ItemsCount: integer;
  AWindowRect: TRect;
begin
  AWindowRect := FWindowRect;
  if Items.Count < FDropDownRows then
   ItemsCount := Items.Count+Increment
  else
   ItemsCount := Items.Count;

  if ItemsCount > 0 then
  begin
    if ItemsCount > FDropDownRows then
       Height := ItemHeight*FDropDownRows + 2*FBorderSize
    else
       Height := ItemHeight*ItemsCount + 2*FBorderSize
  end
  else
    Height := ItemHeight + 2*FBorderSize;

  AWindowRect.Bottom := FWindowRect.Bottom - FWindowRect.Top + AWindowRect.Top;
  FWindowRect := AWindowRect;
end;

function TDCPopupListBox.DoMouseWheel(Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint): Boolean;
 var
  ATopIndex: integer;
begin
  Result := inherited DoMouseWheel(Shift, WheelDelta, MousePos);
  if not Result then
  begin
    ATopIndex := TopIndex - (WheelDelta div WHEEL_DELTA);
    if (ATopIndex >= 0) and (ATopIndex + DropDownRows <= Items.Count) then
      TopIndex := ATopIndex;
    Result := True
  end;
end;

procedure TDCPopupListBox.DrawClientRect;
begin
  {}
end;

procedure TDCPopupListBox.DrawFooter;
begin
  {}
end;

procedure TDCPopupListBox.DrawHeader(const DC: HDC; var R: TRect);
begin
  {}
end;

{ TDCMessageWindow }

procedure TDCMessageWindow.CreateParams(var Params: TCreateParams);
begin
  inherited;
end;

procedure TDCMessageWindow.WMNCHitTest(var Message: TWMNCHitTest);
begin
  inherited;
  if FButtons.Count = 0 then Message.Result := HTTRANSPARENT;
end;

procedure TDCMessageWindow.Paint;
 var
  R: TRect;
  OffsetX, OffsetY: integer;
  FImageRgn: HRGN;
  P: TPoint;
  ADefault: boolean;
  AText: string;
begin
  R := ClientRect;

  FImage.Width  := R.Right - R.Left;
  FImage.Height := R.Bottom - R.Top;
  FImageRgn := GetRegion(0);

  try
    with FImage do
    begin
      Canvas.Brush.Color := Color;
      Canvas.Font := Self.Font;
      case FMessageStyle of
        msNormal:
          begin
            PaintRgn(FImage.Canvas.Handle, FImageRgn);
            DrawEdge(Canvas.Handle, R, BDR_SUNKENOUTER, BF_TOPLEFT);
            DrawEdge(Canvas.Handle, R, BDR_RAISEDOUTER, BF_BOTTOMRIGHT);
          end;
        msRoundRect, msTail:
          begin
            PaintRgn(FImage.Canvas.Handle, FImageRgn);
            Canvas.Brush.Color := clBtnShadow;
            FrameRgn(FImage.Canvas.Handle, FImageRgn,
              FImage.Canvas.Brush.Handle, 1, 1);
          end;
      end;

      Canvas.Font.Color  := clInfoText;

      OffsetX := 0;
      OffsetY := 0;
      case FMessageStyle of
        msNormal:
          begin
            OffsetX := FMargins.Left;
            OffsetY := FMargins.Top;
          end;
        msRoundRect:
          begin
           OffsetX := FRoundValue - 3 + FMargins.Left div 2;
           OffsetY := FRoundValue - 3 + FMargins.Top div 2;
          end;
        msTail:
          begin
           OffsetX := FRoundValue - 3 + FMargins.Left div 2;
           OffsetY := FRoundValue - 3 + FMargins.Top div 2;
           case FOrientation of
             0: OffsetY := OffsetY + FTailValue;
             2: OffsetY := OffsetY + FTailValue;
             4: OffsetY := OffsetY + FTailValue;
           end;
          end;
      end;

      R.Left := R.Left + OffsetX;
      R.Top  := R.Top  + OffsetY;
      if FBitmapVisible and Assigned(FBitmap) then
      begin
         DrawBitmap(Canvas, FBitmap, R, False);
         OffsetX := OffsetX + FBitmap.Width + FBitmapOffset;
      end;
     ADefault := True;
     R := Rect(OffsetX, OffsetY, Width, Height);
     AText := Text;
     if Assigned(FOnDrawInfoText) then FOnDrawInfoText(Self, Canvas.Handle, R,
       AText, ADefault);

     if ADefault then
     begin
       if Centered then
        begin
          P := DrawHighLightText(Canvas, PChar(AText), R, 0, DT_WORDBREAK);
          OffsetY  := _intMax(0, Height + OffsetY - P.Y) div 2;
          R := Rect(OffsetX, OffsetY, Width, Height);
          DrawHighLightText(Canvas, PChar(AText), R, 1, DT_WORDBREAK or
            DT_END_ELLIPSIS);
        end
        else
          DrawHighLightText(Canvas, PChar(AText), R, 1, DT_WORDBREAK or
           DT_END_ELLIPSIS);
      end;
    end;
    Canvas.Draw(0, 0, FImage);
  finally
    DeleteObject(FImageRgn);
  end;
end;

procedure TDCMessageWindow.SetDialogStyle(Value: TDialogStyle);
begin
  if Value <> FDialogStyle then
  begin
    FDialogStyle   := Value;
    FBitmapVisible := True;
    if FUpdateCount = 0 then AdjustWindowSize;
  end;
end;

procedure TDCMessageWindow.AdjustWindowSize;
 var
  P: TPoint;
  R: TRect;
  i, OffsetX, AWidth, AHeight: integer;
begin
  AWidth := Width;
  AHeight := Height;
  if AutoSize then
  begin
    P := DrawHighLightText(Canvas, PChar(Text), Rect(0, 0, Width, Height), 0);
    if FButtons.Count > 0 then
    begin
      R := FButtons.GetButtonsRect;
      OffsetRect(R, -R.Left, -R.Top);
      P.Y := P.Y + R.Bottom + 5;
      if P.X < R.Right then P.X := R.Right;
    end;

    if (FMaxTextWidth > 0) and (P.X > FMaxTextWidth) then
    begin
      OffsetX := P.X - FMaxTextWidth;
      for i := 0 to FButtons.Count-1 do
        FButtons.Buttons[i].Left := FButtons.Buttons[i].Left - OffsetX;
      P := DrawHighLightText(Canvas, PChar(Text), Rect(0, 0, FMaxTextWidth, 500),
        0, DT_LEFT or DT_WORDBREAK);
      if FButtons.Count > 0 then
      begin
        R := FButtons.GetButtonsRect;
        OffsetRect(R, -R.Left, -R.Top);
        P.Y := P.Y + R.Bottom + 5;
      end;
    end;

    case FDialogStyle of
      dsSimple:
         begin
           Color := clMessageWindow;
           FBitmapVisible := False;
           AWidth  := P.X + FMargins.Left + FMargins.Right;
           AHeight := P.Y + FMargins.Top  + FMargins.Bottom;
         end;
      dsInvalidValue:
         begin
           Color := clMessageWindow;
           FBitmap.LoadFromResourceName(HInstance, 'DC_MV_INVALIDVALUE');
           if FBitmapVisible then
           begin
             AWidth  := P.X + FMargins.Left + FMargins.Right + FBitmap.Width +
               FBitmapOffset;
             AHeight := _intMax(P.Y, FBitmap.Height) + FMargins.Top +
               FMargins.Bottom;
           end
           else begin
             AWidth  := P.X + FMargins.Left + FMargins.Right;
             AHeight := P.Y + FMargins.Top  + FMargins.Bottom;
           end;
         end;
      dsCustom:
         begin
           if FBitmapVisible then
           begin
             AWidth  := P.X + FMargins.Left + FMargins.Right + FBitmap.Width +
               FBitmapOffset;
             AHeight := _intMax(P.Y, FBitmap.Height) + FMargins.Top +
               FMargins.Bottom;
           end
           else begin
             AWidth  := P.X + FMargins.Left + FMargins.Right;
             AHeight := P.Y + FMargins.Top + FMargins.Bottom;
           end;
         end;
    end;
    case FMessageStyle of
      msNormal:
        begin
          AWidth  := AWidth  + 2;
          AHeight := AHeight + 2;
        end;
      msRoundRect:
        begin
          AWidth  := AWidth  + 2*(FRoundValue - 3);
          AHeight := AHeight + 2*(FRoundValue - 3);
        end;
      msTail:
        begin
          AWidth  := AWidth  + 2*(FRoundValue - 3);
          AHeight := AHeight + 2*(FRoundValue - 3) + FTailValue;
        end;
    end;
  end;
  SetBounds(Left, Top, AWidth, AHeight);
end;

constructor TDCMessageWindow.Create(AOwner: TComponent);
begin
  inherited;
  FImage  := TBitmap.Create;
  FBitmap := TBitmap.Create;
  Canvas.Brush.Style := bsClear;
  FDialogStyle := dsSimple;
  FBitmapVisible := True;

  FButtons := TDCEditButtons.Create(Self);
  FButtons.Options :=  FButtons.Options - [boNCPainting];
  FButtons.AnchorStyle := asNone;
  FButtons.Color := clBtnFace;
  SetMargins;

  FAutoHide := False;
  FAutoSize := True;
  FTimeOut  := 2000;

  FBitmapOffset := 6;
  FRoundValue   := 11;
  FTailValue    := 11;

  FMessageStyle := msNormal;
  FMaxTextWidth := 0;
  FPopupOptions := [poSetWindowProc];

  Buttons.Active := True;
end;

destructor TDCMessageWindow.Destroy;
begin
  StopTimer(atNone);
  FreeAndNil(FImage);
  FreeAndNil(FButtons);
  FreeAndNil(FBitmap);
  inherited;
end;

procedure TDCMessageWindow.CreateWnd;
begin
  inherited;
  if Parent <> nil then FButtons.SetWndProc;
end;

procedure TDCMessageWindow.SetBitmap(Value: TBitmap);
begin
  if FBitmap <> Value then begin
     FBitmap.Assign(Value);
     BitmapVisible := True;
  end;
end;

procedure TDCMessageWindow.SetBitmapVisible(Value: boolean);
begin
  if FBitmapVisible <> Value then
  begin
    FBitmapVisible := Value;
    if FUpdateCount = 0 then AdjustWindowSize;
  end;
end;

procedure TDCMessageWindow.CMTextChanged(var Message: TMessage);
begin
  inherited;
  case FDialogStyle of
    dsSimple,
    dsInvalidValue:
      if FUpdateCount = 0 then AdjustWindowSize;
    dsCustom:
      if FUpdateCount = 0 then AdjustWindowSize;
  end;
end;

procedure TDCMessageWindow.Show;
 var
  Pause: Integer;
  HintParam: THintWindowParam;
begin
  Pause := 0;

  HintParam.Handle := Handle;
  HintParam.Active := Visible;

  FOwner.Perform(CM_HINTACTIVATE, Longint(@Pause), Longint(@HintParam));
  if Pause <> 0 then
    StartTimer(Pause, atShow)
  else
    ShowWindow;
end;

function TDCMessageWindow.AddButton(AName, AResource, ACaption: string;
  AClick: TNotifyEvent): TDCEditButton;
 var
  P: TPoint;
  Pos: integer;
  ABounds: TRect;
begin
  if ACaption = '' then ACaption := 'null';

  if FButtons.Count > 0 then
    with FButtons do Pos := Buttons[Count-1].Left - 2
  else
    Pos := Self.Width - 3;

  Result := FButtons.AddButtonEx(TDCHintButton);
  SetMargins;
  with Result do
  begin
    Name := AName;
    BrushColor   := clBtnFace;
    if AResource <> '' then
      Glyph.LoadFromResourceName(hInstance, PChar(AResource));
    BrushColor := clHintBackground;
    Alignment := abCenter;
    AnchorStyle  := asBR;
    Font := Self.Font;
    Caption := ACaption;
    OnClick := AClick;
    Self.Canvas.Font := Font;

    P := GetButtonSize(Result);

    if Assigned(Glyph) then
    begin
      P.X := P.X + Glyph.Width + BT_MARGINS + BT_IMAGEOFFSET;
    end;
    P.X := P.X + 4;
    P.Y := P.Y + 8;
    if FMessageStyle <> msNormal then
    begin
      if FButtons.Count = 1 then
        Pos := Pos - P.X - FRoundValue + 2
      else
        Pos := Pos - P.X;
      ABounds := Rect(Pos, Self.Height - P.Y - FMargins.Bottom - FRoundValue + 5,
        P.X, P.Y)
    end
    else
      ABounds := Rect(Pos-P.X, Self.Height - P.Y - FMargins.Bottom, P.X, P.Y);
    SetBounds(ABounds);
  end;
  if FUpdateCount = 0 then AdjustWindowSize;
end;

procedure TDCMessageWindow.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  if Assigned(FButtons) then
    FButtons.UpdateButtons(-1, -1, FButtons.MouseDown, True);
end;

procedure TDCMessageWindow.SetMargins;
begin
  with FMargins do
  begin
    Left  := 4;
    Top   := 2;
    Right := 2;
    Bottom:= 2
  end;
end;

procedure TDCMessageWindow.SetAutoHide(const Value: boolean);
begin
  FAutoHide := Value;
end;

procedure TDCMessageWindow.WMTimer(var Message: TWMTimer);
begin
  StopTimer(FTimerMode);
  inherited;
end;

procedure TDCMessageWindow.SetTimeOut(const Value: integer);
begin
  FTimeOut := Value;
end;

procedure TDCMessageWindow.StartTimer(Value: Integer;
  TimerMode: TAdvancedTimerMode);
begin
  StopTimer(atNone);
  if FButtons.Count = 0 then
  begin
    FTimerHandle := SetTimer(Handle, 1, Value, nil);
    FTimerMode := TimerMode;
    if FTimerHandle = 0 then StopTimer(atHide);
  end;
end;

procedure TDCMessageWindow.StopTimer(TimerMode: TAdvancedTimerMode);
begin
  if FTimerHandle <> 0 then
  begin
    KillTimer(Handle, FTimerHandle);
    FTimerHandle := 0;
    case TimerMode of
      atHide:
        if Assigned(FOwner) and (FOwner is TWinControl) then
          with TWinControl(FOwner) do
          begin
            if HandleAllocated then PostMessage(Handle, CM_ERRORMESSAGE, 0, 0)
          end
        else
          Hide;
      atShow:
        ShowWindow;
    end;
  end;
end;

procedure TDCMessageWindow.WMEraseBkgnd(var Message: TWmEraseBkgnd);
begin
  Message.Result := 0;
end;

function TDCMessageWindow.GetRegion(RegionType: integer): HRGN;
 var
  FRect: TRect;
  Tail: HRGN;

  function CreatePolyRgn(const Points: array of TPoint): HRGN;
  type
    PPoints = ^TPoints;
    TPoints = array[0..0] of TPoint;
  begin
    Result := CreatePolygonRgn(PPoints(@Points)^, High(Points) + 1, WINDING);
  end;

begin
  FRect := ClientRect;
  Result :=  NULLREGION;
  case FMessageStyle of
    msNormal:
      begin
        InflateRect(FRect, 1 , 1);
        Result := CreateRectRgnIndirect(FRect);
      end;
    msRoundRect:
      Result := CreateRoundRectRgn(FRect.Left, FRect.Top, FRect.Right,
        FRect.Bottom, FRoundValue, FRoundValue);
    msTail:
      begin
        Tail :=  0;
        case FOrientation of
          0:
            begin
              Tail := CreatePolyRgn([Point(8, FTailValue), Point(8, 0),
                Point(FTailValue + 8, FTailValue)]);
              FRect.Top := FRect.Top + FTailValue;
            end;
          1:
            begin
              Tail := 0;
              FRect.Bottom := FRect.Bottom - FTailValue;
            end;
          2:
            begin
              Tail := CreatePolyRgn([Point(FRect.Right - 8, FTailValue),
                Point(FRect.Right - 8, 0), Point(FRect.Right - 8 - FTailValue,
                FTailValue)]);
              FRect.Top := FRect.Top + FTailValue;
            end;
          3:
            begin
              Tail := 0;
              FRect.Bottom := FRect.Bottom - FTailValue;
            end;
          4:
            begin
              Tail := CreatePolyRgn([Point((FRect.Left + FRect.Right) div 2 - 4, FTailValue),
                Point((FRect.Left + FRect.Right) div 2, 0),
                Point((FRect.Left + FRect.Right) div 2 + 4, FTailValue)]);
              FRect.Top := FRect.Top + FTailValue;
            end;
        end;
        try
          Result := CreateRoundRectRgn(FRect.Left, FRect.Top, FRect.Right,
            FRect.Bottom, FRoundValue, FRoundValue);
          CombineRgn(Result, Result, Tail, RGN_OR);
        finally
          DeleteObject(Tail);
        end;
        FRect.Top :=  FRect.Top;
      end;
  end;
end;

procedure TDCMessageWindow.SetMessageStyle(const Value: TMessageStyle);
begin
  if Visible then Hide;
  if FUpdateCount = 0 then AdjustWindowSize;
  FMessageStyle := Value;
end;

procedure TDCMessageWindow.SetCentered(const Value: boolean);
begin
  FCentered := Value;
  invalidate;
end;

procedure TDCMessageWindow.SetMaxTextWidth(const Value: integer);
begin
  FMaxTextWidth := Value;
  if FUpdateCount = 0 then AdjustWindowSize;
end;

procedure TDCMessageWindow.BeginUpdate;
begin
  Inc(FUpdateCount);
end;

procedure TDCMessageWindow.EndUpdate;
begin
  Dec(FUpdateCount);
  if FUpdateCount < 0 then FUpdateCount := 0;
  if FUpdateCount = 0 then AdjustWindowSize;
end;

procedure TDCMessageWindow.SetOrientation(const Value: integer);
begin
  if Orientation <> Value then
  begin
    inherited;
    UpdateWindowRegion;
  end;
end;

procedure TDCMessageWindow.UpdateWindowRegion;
 var
  ARgn: HRgn;
begin
  if HandleAllocated then
  begin
    ARgn := GetRegion(1);
    SetWindowRgn(Handle, ARgn, True);
    DeleteObject(ARgn);
  end;
end;

procedure TDCMessageWindow.Hide;
begin
  StopTimer(atNone);
  inherited;
end;

procedure TDCMessageWindow.Resize;
begin
  inherited;
  UpdateWindowRegion;
end;

procedure TDCMessageWindow.SetAutoSize(const Value: boolean);
begin
  if FAutoSize <> Value then
  begin
    FAutoSize := Value;
    if FAutoSize then AdjustWindowSize;
  end
end;

procedure TDCMessageWindow.CMFontChanged(var Message: TMessage);
begin
  inherited;
  Canvas.Font := Font;
end;

procedure TDCMessageWindow.CMShadowChanged(var Message: TMessage);
begin
  if HandleAllocated then
  begin
    AdjustWindowSize;
    UpdateWindowRegion;
    Invalidate;
  end;
end;

function TDCMessageWindow.GetFocusedButton: TDCEditButton;
begin
  Result := FButtons.FocusedButton;
end;

procedure TDCMessageWindow.SetFocusedButton(const Value: TDCEditButton);
begin
  FButtons.FocusedButton := Value;
end;

function TDCMessageWindow.GetButtonSize(Button: TDCEditButton): TPoint;
begin
  Result := Button.GetTextSize;
end;

procedure TDCMessageWindow.ShowWindow;
begin
  inherited Show;
  if FAutoHide then StartTimer(FTimeOut, atHide);
end;

{ TDCPopupTreeView }

procedure TDCPopupTreeView.AdjustNewHeight;
var
  DC: HDC;
  SaveFont: HFONT;
  Metrics: TTextMetric;
begin
  DC := GetDC(0);
  SaveFont := SelectObject(DC, Font.Handle);
  try
    GetTextMetrics (DC, Metrics);
    FItemHeight := Metrics.tmHeight;
    FItemHeight := FItemHeight + 3;
  finally
    SelectObject(DC, SaveFont);
    ReleaseDC(0, DC);
  end;
end;

procedure TDCPopupTreeView.BeginMoving(XCursor, YCursor: integer);
begin
  ProcessMovingWindow(Self, XCursor, YCursor, FCursorMode, FItemHeight);
end;

procedure TDCPopupTreeView.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  if Assigned(FButtons) then
    FButtons.MouseDown := GetAsyncKeyState(VK_LBUTTON)<0;
end;

procedure TDCPopupTreeView.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  if Assigned(FButtons) then
    FButtons.UpdateButtons( -1, -1, False, True);
end;

procedure TDCPopupTreeView.CMSetAlignment(var Message: TMessage);
begin
  PopupAlignment := TWindowAlignment(Message.WParam);
end;

constructor TDCPopupTreeView.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FVisible    := False;

  ControlStyle := ControlStyle + [csNoDesignVisible, csReplicatable,
                                  csAcceptsControls, csOpaque];
  Visible := False;

  Canvas.Brush.Style := bsClear;
  FAlwaysVisible := True;
  FOwner := TControl(AOwner);

  SetRectEmpty(FWindowRect);
  SetRectEmpty(FMargins);
  FDropDownRows := 10;

  AdjustNewHeight;

  BorderStyle := bsNone;

  FCursorMode := cmNone;
  FButtons := TDCEditButtons.Create(Self);
  FButtons.AnchorStyle := asBL;
  FButtons.Color := clBtnFace;

  ReadOnly    := True;
  FShowHeader := True;
  FDrawingStyle := dtXPStyle; //dtNormal;
end;

procedure TDCPopupTreeView.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do
  begin
    ExStyle := WS_EX_TOOLWINDOW or WS_EX_TOPMOST or WS_EX_CONTROLPARENT;
    Style   := Style and not(WS_HSCROLL or WS_VSCROLL) or WS_CLIPCHILDREN;
  end;
end;

procedure TDCPopupTreeView.CreateWnd;
begin
  if Parent <> nil then
  begin
    inherited CreateWnd;
    Windows.SetParent(Handle, 0);
    CallWindowProc(DefWndProc, Handle, WM_SETFOCUS, 0, 0);
    SetMargins;
  end;
end;

destructor TDCPopupTreeView.Destroy;
begin
  FButtons.Free;
  FButtons := nil;
  inherited;
end;

procedure TDCPopupTreeView.DrawClientRect;
 var
  DC: HDC;
  R, R1, R2: TRect;
  Rgn: HRGN;
begin
  if not FShowHeader then Exit;
  DC  := GetWindowDC(Handle);
  Rgn := 0;
  try
    GetWindowRect(Handle, R);  OffsetRect (R, -R.Left, -R.Top);

    R2 := R;
    with FMargins do
    begin
     InflateRect(R2, -2, -2);
     R2.Top := R2.Top + br_HeaderHeight;
     R2.Bottom := R2.Bottom - br_FooterHeight;
    end;

    Rgn := CreateRectRgn(R2.Left, R2.Top, R2.Right, R2.Bottom);
    SelectClipRgn(DC, Rgn);

    R1 := Rect(FMargins.Left, FMargins.Top, R.Right-FMargins.Right,
      R.Bottom-FMargins.Bottom);
    InflateRect(R1, -1, -1);

    DrawEdge(DC, R1, BDR_SUNKENOUTER, BF_TOPLEFT);
    DrawEdge(DC, R1, BDR_SUNKENINNER, BF_BOTTOMRIGHT);

    ExcludeClipRect(DC, R1.Left, R1.Top, R1.Right, R1.Bottom);
    FillRect(DC, R,  GetSysColorBrush(clWhite));
  finally
    ReleaseDC(Handle, DC);
    if Rgn <> 0 then DeleteObject(Rgn);
  end;
end;

procedure TDCPopupTreeView.DrawFooter;
 var
  DC: HDC;
  R: TRect;
  Bitmap: TBitmap;
begin
  if not FShowHeader then Exit;
  DC := GetWindowDC(Handle);
  Bitmap := TBitmap.Create;
  try
    GetWindowRect(Handle, R); OffsetRect (R, -R.Left, -R.Top);
    InflateRect(R, -2, -2);
    Bitmap.Canvas.Brush.Color := COLOR_BTNFACE;
    Bitmap.LoadFromResourceName(HInstance, 'DC_BTNSIZE');
    R.Top := R.Bottom - br_FooterHeight - 4;
    FillRect(DC, R,  GetSysColorBrush(COLOR_BTNFACE));
    R.Left := R.Right-Bitmap.Width-2;
    R.Top  := R.Bottom-Bitmap.Height-2;
    DrawTransparentBitmap(DC, Bitmap, R, False, Bitmap.Canvas.Pixels[0,0]);
  finally
    Bitmap.Free;
    ReleaseDC(Handle, DC);
  end;
end;

procedure TDCPopupTreeView.DrawHeader(const DC: HDC; var R: TRect);
begin
  if FShowHeader then
     DrawPopupHeader(Self, DC, R, FPopupBorderStyle, FDrawingStyle);
end;

procedure TDCPopupTreeView.Hide;
begin
  FButtons.ClrWndProc;
  HideWindow(Handle);
  FVisible := False;
end;

procedure TDCPopupTreeView.InvalidateButtons;
 var
  i, RightPos: integer;
  Button: TDCEditButton;
  Changed: boolean;
begin
  RightPos := Width-br_SizerWidth-FBorderSize-FMargins.Left-3;
  Changed  := False;
  for i := 0 to FButtons.Count-1 do
  begin
    Button := FButtons.Buttons[i];
    if (Button.Left+Button.Width) > RightPos then
    begin
      if Button.Visible then
      begin
        Button.Visible := False;
        Changed := True;
      end
    end
    else
      if not Button.Visible then
      begin
        Button.Visible := True;
        Changed := True;
      end;
  end;
 if Changed then
     SendMessage(Self.Handle, WM_NCPAINT, 0, 0);
end;

procedure TDCPopupTreeView.KeyDown(var Key: Word; Shift: TShiftState);
begin
  inherited;
  case Key of
    VK_LEFT :
      begin
        if ssCtrl in Shift then
          SetBounds(Left-POPUP_MOVE_STEPX, Top, Width, Height);
      end;
    VK_RIGHT:
      begin
        if ssCtrl in Shift then
          SetBounds(Left+POPUP_MOVE_STEPX, Top, Width, Height);
      end;
    VK_UP   :
      begin
        if ssCtrl in Shift then
          SetBounds(Left, Top-POPUP_MOVE_STEPY, Width, Height);
      end;
    VK_DOWN :
      begin
        if ssCtrl in Shift then
          SetBounds(Left, Top+POPUP_MOVE_STEPY, Width, Height);
      end;
  end;
end;

procedure TDCPopupTreeView.KeyPress(var Key: Char);
begin
  case Key of
    '+':
      if Selected <> nil then
      begin
        Self.Items.BeginUpdate;
        try
          Selected.Expand(False);
        finally
          Self.Items.EndUpdate;
        end;
      end;
    '-':
      if Selected <> nil then
      begin
        Self.Items.BeginUpdate;
        try
          Selected.Collapse(False);
        finally
          Self.Items.EndUpdate;
        end;
      end;
    '*':
      begin
        Self.Items.BeginUpdate;
        try
          FullExpand;
        finally
          Self.Items.EndUpdate;
        end;
      end;
  end;
end;

procedure TDCPopupTreeView.RedrawBorder;
 var
  R: TRect;
begin
  DrawPopupBorder(Self, 0, R, FPopupBorderStyle, FDrawingStyle);
end;

procedure TDCPopupTreeView.SetBounds(ALeft, ATop, AWidth,
  AHeight: Integer);
begin
  if AHeight < FItemHeight*5 then AHeight := FItemHeight*5;
  if AWidth  < 80 then AWidth  := 80;
  inherited;
  FWindowRect := Rect(Left,Top,Left+Width,Top+Height);
end;

procedure TDCPopupTreeView.SetBoundsEx(ALeft, ATop, AWidth,
  AHeight: Integer);
begin
  FWindowRect := Rect(ALeft,ATop,ALeft+AWidth,aTop+AHeight);
  if FVisible then Show;
end;

procedure TDCPopupTreeView.SetDrawingStyle(const Value: TDCDrawingStyle);
begin
  FDrawingStyle := Value;
end;

procedure TDCPopupTreeView.SetMargins;
begin
  FMargins := Rect(4,4,4,2);
  if not FShowHeader then Exit;
  case FPopupBorderStyle of
    brNone  :;
    brSingle:;
    brRaised:
      begin
        // Margins.Properties
        FMargins.Top    := FMargins.Top + br_HeaderHeight;
        FMargins.Bottom := FMargins.Bottom + br_FooterHeight+4;
      end;
  end;
end;

procedure TDCPopupTreeView.SetParent(AParent: TWinControl);
begin
  inherited;
end;

procedure TDCPopupTreeView.SetPopupAlignment(Value: TWindowAlignment);
begin
  if Value <> FPopupAlignment then
  begin
    FPopupAlignment := Value;
    if Visible then Show;
  end;
end;

procedure TDCPopupTreeView.SetPopupBorderStyle(Value: TPopupBorderStyle);
begin
  if FPopupBorderStyle <> Value then
  begin
    FPopupBorderStyle := Value;
    case FPopupBorderStyle of
      brNone:
        FBorderSize := 0;
      brSingle:
        FBorderSize := 1;
      brRaised:
        FBorderSize := 2;
    end;
    RecreateWnd;
  end;
end;

procedure TDCPopupTreeView.SetShowHeader(const Value: boolean);
begin
  FShowHeader := Value;
  RecreateWnd;
end;

procedure TDCPopupTreeView.Show;
begin
  SetMargins;
  Height := FItemHeight*FDropDownRows + 2*FBorderSize + FMargins.Top + FMargins.Bottom;
  ShowWindow(Handle, FPopupAlignment, FWindowRect, FAlwaysVisible, Owner);
  FVisible :=  True;
end;

procedure TDCPopupTreeView.WMActivate(var Message: TWMActivate);
 var
  ParentForm: TCustomForm;
begin
  inherited;
  ParentForm := GetParentForm(Self);
  if Assigned(ParentForm) and ParentForm.HandleAllocated then
  begin
    SendMessage (ParentForm.Handle, WM_NCACTIVATE, Ord(Message.Active <> WA_INACTIVE), 0);
    if Message.ActiveWindow <> ParentForm.Handle then
      SetActiveWindow (ParentForm.Handle);
  end;
end;

procedure TDCPopupTreeView.WMFontChange(var Message: TWMFontChange);
 var
  i: integer;
begin
  inherited;
  AdjustNewHeight;
  for i := 0 to FButtons.Count-1 do
    FButtons.Buttons[i].Font := Font;
end;

procedure TDCPopupTreeView.WMHScroll(var Message: TWMHScroll);
begin
  inherited;
end;

procedure TDCPopupTreeView.WMLButtonDblClk(var Message: TWMLButtonDown);
 var
  HitTest: THitTests;
begin
  HitTest := GetHitTestInfoAt(Message.XPos, Message.YPos);
  if not(htOnButton in HitTest) then
  begin
    SendMessage(TWinControl(FOwner).Handle, Message.Msg, $AE, TMessage(Message).LParam);
    Message.Msg    := 0;
    inherited;
  end
  else
    Perform(WM_LBUTTONDOWN, TMessage(Message).WParam, TMessage(Message).LParam);
end;

procedure TDCPopupTreeView.WMMouseActivate(var Message: TWMActivate);
begin
  inherited;
  Message.Result := MA_NOACTIVATE;
  SetWindowPos (Handle, HWND_TOP, 0, 0, 0, 0,
     SWP_NOACTIVATE or SWP_NOMOVE or SWP_NOSIZE);
end;

procedure TDCPopupTreeView.WMNCCalcSize(var Message: TWMNCCalcSize);
begin
  case FPopupBorderStyle of
    brNone  :FBorderSize := 0;
    brSingle:
      begin
        FBorderSize := 2;
        InflateRect(Message.CalcSize_Params^.rgrc[0], -2, -2);
      end;
    brRaised:
      begin
        FBorderSize := 2;
        InflateRect(Message.CalcSize_Params^.rgrc[0], -2, -2);
      end;
  end;
  with Message.CalcSize_Params^.rgrc[0] do
  begin
    Top    := Top    + FMargins.Top;
    Left   := Left   + FMargins.Left;
    Bottom := Bottom - FMargins.Bottom;
    Right  := Right  - FMargins.Right;
  end;

  inherited;
end;

procedure TDCPopupTreeView.WMNCHitTest(var Message: TWMNCHitTest);
 var
  R, WindowR: TRect;
  BS: Integer;
  Button: TDCEditButton;
 function InCaptArea(XPos, YPos: integer): boolean;
 begin
   R := WindowR;
   InflateRect(R, -BS, -BS);
   R.Bottom := R.Top + FMargins.Top;
   Result := PtInRect(R, Point(XPos, YPos));
 end;
 function InSizeArea(XPos, YPos: integer): boolean;
 begin
   R := WindowR;
   InflateRect(R, -BS, -BS);
   R.Top  := R.Bottom - br_FooterHeight;
   R.Left := R.Right  - br_SizerWidth;
   Result := PtInRect(R, Point(XPos, YPos));
 end;
 function InGridArea(XPos, YPos: integer): boolean;
 begin
   R := WindowR;
   InflateRect(R, -BS, -BS);
   R.Left   := R.Left   + FMargins.Left;
   R.Top    := R.Top    + FMargins.Top;
   R.Right  := R.Right  - FMargins.Right;
   R.Bottom := R.Bottom - FMargins.Bottom;
   Result := PtInRect(R, Point(XPos, YPos));
 end;
 function InButtonsArea(XPos, YPos: integer): boolean;
  var
   P: TPoint;
 begin
   P.X := XPos - Left;
   P.Y := YPos - Top;
   Result := FButtons.MouseInButtonArea(P.X, P.Y, Button);
   R := WindowR;
   InflateRect(R, -BS, -BS);
 end;
 function InFooterArea(XPos, YPos: integer): boolean;
 begin
   R := WindowR;
   InflateRect(R, -BS, -BS);
   R.Top  := R.Bottom - br_FooterHeight;
   Result := PtInRect(R, Point(XPos, YPos));
 end;
begin
  inherited;
  if not FShowHeader then begin
    FCursorMode := cmGrid;
    Exit;
  end;
  FCursorMode := cmNone;
  BS := FBorderSize;
  GetWindowRect(Handle, WindowR);
  with Message do
  begin
    if InCaptArea(XPos, YPos) then
    begin
      FCursorMode := cmMove;
      Result := HTBORDER;
    end;

    if InFooterArea(XPos, YPos) then
    begin
      FCursorMode := cmFooter;
      Result := HTBORDER;
    end;

    if InSizeArea(XPos, YPos) then
    begin
      FCursorMode := cmResize;
      Result := HTSIZE;
    end;
    if InGridArea(XPos, YPos) then FCursorMode := cmGrid;

    if InButtonsArea(XPos, YPos) then
    begin
      FCursorMode := cmButtons;
      Result := HTBORDER;
    end;
  end;
end;

procedure TDCPopupTreeView.WMNCLButtonDown(var Message: TWMNCLButtonDown);
begin
  inherited;
  with Message do
  begin
    case FCursorMode of
      cmResize: BeginMoving(XCursor, YCursor);
      cmMove  : BeginMoving(XCursor, YCursor);
    end;
  end;
end;

procedure TDCPopupTreeView.WMNCPaint(var Message: TWMNCPaint);
begin
  ShowScrollBar(Handle, SB_HORZ, False);
  inherited;
  RedrawBorder;
end;

procedure TDCPopupTreeView.WMPaint(var Message: TWMPaint);
begin
  if Assigned(FButtons) then FButtons.UpdateDeviceRegion(Message.DC);
  inherited;
  if Assigned(FButtons) then InvalidateButtons;
end;

procedure TDCPopupTreeView.WMSetCursor(var Message: TWMSetCursor);
begin
  case FCursorMode of
    cmNone   : SetCursor(Screen.Cursors[crArrow]);
    cmResize : SetCursor(Screen.Cursors[crSizeNWSE]);
    cmMove   : SetCursor(Screen.Cursors[crArrow]);
    cmButtons: SetCursor(Screen.Cursors[crArrow]);
    cmFooter : SetCursor(Screen.Cursors[crArrow]);
    cmGrid   : inherited;
  end;
end;

procedure TDCPopupTreeView.WMShowWindow(var Message: TWMShowWindow);
begin
  inherited;
end;

procedure TDCPopupTreeView.WMSize(var Message: TWMSize);
begin
  inherited;
  if Assigned(FButtons) then InvalidateButtons;
end;

{ TDCClipPopup }

procedure TDCClipPopup.BeginMoving(XCursor, YCursor, Delta: integer);
begin
  ProcessMovingWindow(Self, XCursor, YCursor, FCursorMode, Delta);
end;

procedure TDCClipPopup.ButtonsChange(Sender: TObject);
begin
  {}
end;

procedure TDCClipPopup.CMMouseEnter(var Message: TMessage);
begin
  inherited;
end;

procedure TDCClipPopup.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  FButtons.UpdateButtons(-1, -1, False, True);
end;

procedure TDCClipPopup.CMSetAlignment(var Message: TMessage);
begin
  PopupAlignment := TWindowAlignment(Message.WParam);
end;

constructor TDCClipPopup.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  SetRectEmpty(FMargins);
  FCursorMode := cmNone;
  FButtons := TDCEditButtons.Create(Self);
  FButtons.AnchorStyle := asNone;
  FButtons.Color := clBtnFace;
  FButtons.OnChange := ButtonsChange;
  FPopupOptions := [poSetWindowProc];

  Buttons.Active := True;

  FOptions := [];
  FShadow.FAlphaBlendValue := 195;
  FShadow.FDistance := 4;
  FShadow.FVisible := True;
end;

procedure TDCClipPopup.CreateWnd;
begin
  inherited;
  if Parent <> nil then
  begin
    FButtons.ClrWndProc;
    FButtons.SetWndProc;
  end;
end;

destructor TDCClipPopup.Destroy;
begin
  FreeAndNil(FButtons);
  inherited;
end;

procedure TDCClipPopup.DrawClientRect;
begin
  {}
end;

procedure TDCClipPopup.DrawFooter;
 var
  DC: HDC;
  R: TRect;
  Bitmap: TBitmap;
begin
  if not(coFooter in FOptions) then Exit;
  DC := GetWindowDC(Handle);
  Bitmap := TBitmap.Create;
  try
    GetWindowRect(Handle, R); OffsetRect (R, -R.Left, -R.Top);
    InflateRect(R, -2, -2);
    Bitmap.LoadFromResourceName(HInstance, 'DC_BTNSIZE');
    R.Top := R.Bottom - FMargins.Bottom;
    FillRect(DC, R,  GetSysColorBrush(COLOR_BTNFACE));
    R.Left := R.Right-Bitmap.Width-2;
    R.Top  := R.Bottom-Bitmap.Height-2;
    DrawTransparentBitmap(DC, Bitmap, R, False, Bitmap.Canvas.Pixels[0,0]);
  finally
    Bitmap.Free;
    ReleaseDC(Handle, DC);
  end;
end;

procedure TDCClipPopup.DrawHeader(const DC: HDC; var R: TRect);
begin
  if coHeader in FOptions then
     DrawPopupHeader(Self, DC, R, FPopupBorderStyle, FDrawingStyle);
end;

procedure TDCClipPopup.Hide;
begin
  inherited;
end;

procedure TDCClipPopup.InvalidateButtons;
begin
  {}
end;

procedure TDCClipPopup.KeyDown(var Key: Word; Shift: TShiftState);
begin
  inherited;
  if coHeader in FOptions then
  begin
    case Key of
      VK_LEFT :
        begin
          if ssCtrl in Shift then
            SetBounds(Left-POPUP_MOVE_STEPX, Top, Width, Height);
        end;
      VK_RIGHT:
        begin
          if ssCtrl in Shift then
            SetBounds(Left+POPUP_MOVE_STEPX, Top, Width, Height);
        end;
      VK_UP   :
        begin
          if ssCtrl in Shift then
            SetBounds(Left, Top-POPUP_MOVE_STEPY, Width, Height);
        end;
      VK_DOWN :
        begin
          if ssCtrl in Shift then
            SetBounds(Left, Top+POPUP_MOVE_STEPY, Width, Height);
        end;
    end;
  end;
end;

procedure TDCClipPopup.RedrawBorder;
 var
  R: TRect;
begin
  DrawPopupBorder(Self, 0, R, FPopupBorderStyle, FDrawingStyle);
end;

procedure TDCClipPopup.SetDrawingStyle(const Value: TDCDrawingStyle);
begin
  FDrawingStyle := Value;
end;

procedure TDCClipPopup.SetMargins;
begin
  FMargins := Rect(0,0,0,0);
  case FPopupBorderStyle of
    brNone  :;
    brSingle:;
    brRaised:
      begin
        // Margins.Properties
        if coHeader in FOptions then FMargins.Top    := 14;
        if coFooter in FOptions then FMargins.Bottom := br_FooterHeight+4;
      end;
  end;
end;

procedure TDCClipPopup.SetOptions(const Value: TClipFormOptions);
begin
  FOptions := Value;
  SetMargins;
  RecreateWnd;
end;

procedure TDCClipPopup.SetPopupBorderStyle(Value: TPopupBorderStyle);
begin
  if FPopupBorderStyle <> Value then
  begin
    FPopupBorderStyle := Value;
    case FPopupBorderStyle of
      brNone:
        FBorderSize := 0;
      brSingle:
        FBorderSize := 1;
      brRaised:
        FBorderSize := 2;
    end;
    SetMargins;
    RecreateWnd;
  end;
end;

procedure TDCClipPopup.Show;
begin
  inherited;
  FButtons.ResetProperties;
end;

procedure TDCClipPopup.WMActivate(var Message: TWMActivate);
 var
  ParentForm: TCustomForm;
begin
  inherited;
  ParentForm := GetParentForm(Self);
  if Assigned(ParentForm) and ParentForm.HandleAllocated then
  begin
    SendMessage (ParentForm.Handle, WM_NCACTIVATE, Ord(Message.Active <> WA_INACTIVE), 0);
    if Message.ActiveWindow <> ParentForm.Handle then
      SetActiveWindow (ParentForm.Handle);
  end;
end;

procedure TDCClipPopup.WMNCCalcSize(var Message: TWMNCCalcSize);
begin
  case FPopupBorderStyle of
    brNone  :FBorderSize := 0;
    brSingle:
      begin
        FBorderSize := 2;
        InflateRect(Message.CalcSize_Params^.rgrc[0], -2, -2);
      end;
    brRaised:
      begin
        FBorderSize := 2;
        InflateRect(Message.CalcSize_Params^.rgrc[0], -2, -2);
      end;
  end;
  with Message.CalcSize_Params^.rgrc[0] do
  begin
    Top    := Top    + FMargins.Top;
    Left   := Left   + FMargins.Left;
    Bottom := Bottom - FMargins.Bottom;
    Right  := Right  - FMargins.Right;
  end;
  inherited;
end;

procedure TDCClipPopup.WMNCHitTest(var Message: TWMNCHitTest);
 var
  R, WindowR: TRect;
  BS: Integer;
  Button: TDCEditButton;
 function InCaptArea(XPos, YPos: integer): boolean;
 begin
   if not(coHeader in FOptions) then
   begin
     Result := False;
     Exit;
   end;
   R := WindowR;
   InflateRect(R, -BS, -BS);
   R.Bottom := R.Top + FMargins.Top;
   Result := PtInRect(R, Point(XPos, YPos));
 end;
 function InSizeArea(XPos, YPos: integer): boolean;
 begin
   if not(coFooter in FOptions) then
   begin
     Result := False;
     Exit;
   end;
   R := WindowR;
   InflateRect(R, -BS, -BS);
   R.Top  := R.Bottom - br_FooterHeight;
   R.Left := R.Right  - br_SizerWidth;
   Result := PtInRect(R, Point(XPos, YPos));
 end;
 function InGridArea(XPos, YPos: integer): boolean;
 begin
   R := WindowR;
   InflateRect(R, -BS, -BS);
   R.Left   := R.Left   + FMargins.Left;
   R.Top    := R.Top    + FMargins.Top;
   R.Right  := R.Right  - FMargins.Right;
   R.Bottom := R.Bottom - FMargins.Bottom;
   Result := PtInRect(R, Point(XPos, YPos));
 end;
 function InButtonsArea(XPos, YPos: integer): boolean;
  var
   P: TPoint;
 begin
   P.X := XPos - Left;
   P.Y := YPos - Top;
   Result := FButtons.MouseInButtonArea(P.X, P.Y, Button);
   R := WindowR;
   InflateRect(R, -BS, -BS);
 end;
 function InFooterArea(XPos, YPos: integer): boolean;
 begin
   if not(coFooter in FOptions) then
   begin
     Result := False;
     Exit;
   end;
   R := WindowR;
   InflateRect(R, -BS, -BS);
   R.Top  := R.Bottom - br_FooterHeight;
   Result := PtInRect(R, Point(XPos, YPos));
 end;
begin
  inherited;
  FCursorMode := cmNone;
  BS := FBorderSize;
  GetWindowRect(Handle, WindowR);
  with Message do
  begin
    if InCaptArea(XPos, YPos) then
    begin
      FCursorMode := cmMove;
      Result := HTBORDER;
    end;

    if InFooterArea(XPos, YPos) then
    begin
      FCursorMode := cmFooter;
      Result := HTBORDER;
    end;

    if InSizeArea(XPos, YPos) then
    begin
      FCursorMode := cmResize;
      Result := HTSIZE;
    end;
    if InGridArea(XPos, YPos) then FCursorMode := cmGrid;

    if InButtonsArea(XPos, YPos) then
    begin
      FCursorMode := cmButtons;
      Result := HTBORDER;
    end;
  end;
end;

procedure TDCClipPopup.WMNCLButtonDown(var Message: TWMNCLButtonDown);
begin
  inherited;
  with Message do
  begin
    case FCursorMode of
      cmResize: BeginMoving(XCursor, YCursor, 1);
      cmMove  : BeginMoving(XCursor, YCursor, 1);
    end;
  end;
end;

procedure TDCClipPopup.WMNCPaint(var Message: TWMNCPaint);
begin
  inherited;
  RedrawBorder;
end;

procedure TDCClipPopup.WMPaint(var Message: TWMPaint);
begin
  inherited;
  InvalidateButtons;
  RedrawBorder;
end;

procedure TDCClipPopup.WMSetCursor(var Message: TWMSetCursor);
begin
  case FCursorMode of
    cmNone   : SetCursor(Screen.Cursors[crArrow]);
    cmResize : SetCursor(Screen.Cursors[crSizeNWSE]);
    cmMove   : SetCursor(Screen.Cursors[crArrow]);
    cmButtons: SetCursor(Screen.Cursors[crArrow]);
    cmFooter : SetCursor(Screen.Cursors[crArrow]);
    cmGrid   : inherited;
  end;
end;

procedure TDCClipPopup.WMSize(var Message: TWMSize);
begin
  inherited;
  InvalidateButtons;
end;

{ TCustomClipPopup }

function TCustomClipPopup.AddButton(AName, AResource, AHint: string;
  ALine, APos: integer): TDCEditButton;
begin
  Result := Buttons.AddButtonEx(TDCAssistButton);
  with TDCAssistButton(Result) do
  begin
    Name := AName;
    Line := ALine;
    Pos  := APos;
    BrushColor := clBtnFace;
    Enabled := Enabled;
    Images := Buttons.Images;
    if AResource <> '' then
      try
        Glyph.LoadFromResourceName(HInstance, PChar(AResource));
      except
        Glyph.FreeImage;
      end
    else
      Glyph.FreeImage;

    BrushColor := clWhite;
    Font := Self.Font;
    case PopupStyle of
      cpPopupMenu:
        begin
          Caption := AHint;
          Alignment := abLeft;
          DrawingStyle := dtXPStyle;
          SelectColor := clXPSelected;
          BrushColor := clXPLightBackground;
        end;
      cpToolBar:
        begin
          Hint := AHint;
          Alignment := abCenter;
          OnDrawHint := DrawButtonHint;
        end;
    end;
    OnClick := ButtonClick;
    if Line > FLinesCount then FLinesCount := Line;
    if Pos  > FMaxPos then FMaxPos := Pos;
  end;
  if FUpdateCount = 0 then AdjustClipSize;
end;

procedure TCustomClipPopup.AddButtons;
begin
  BeginUpdate;
  Clear;
  PopupStyle := cpPopupMenu;
  AddButton('#Query'   , 'DC_DBQUERY'   , LoadStr(RES_STRN_VAL_QUERY), 0, 0);
  AddButton('#Property', 'DC_DBPROPERTY', LoadStr(RES_STRN_VAL_PROP) , 0, 1);
  AddButton('#Find'    , 'DC_DBFIND'    , LoadStr(RES_STRN_VAL_FIND) , 0, 2);
  AddButton('#Print'   , 'DC_PRINT'     , LoadStr(RES_STRN_VAL_PRINT), 0, 3);
  EndUpdate;
end;

procedure TCustomClipPopup.AdjustClipSize;

  procedure AdjustClipMenuSize;
   var
    i, j, k, Y, MaxWidth, wl, wr, mInc: integer;
    Button: TDCAssistButton;
  begin
    MaxWidth := 0;
    k := 30;

    case PopupBorderStyle of
     brSingle:
      begin
        wl := 2;
        wr := 2;
        mInc := 1;
      end;
     brRaised:
      begin
        wl := 2;
        wr := 2;
        mInc := 0;
      end;
     else begin
        wl := 1;
        wr := 1;
        mInc := 1;
     end;
    end;

    for i := 0 to Buttons.Count-1 do
    begin
      Button := TDCAssistButton(Buttons.Buttons[i]);
      with Button do
      begin
        if Caption <> MenuLineCaption then
          MaxWidth := _intMax(Button.GetTextSize.X + k + Buttons.MaxImageWidth, MaxWidth);
      end;
    end;
    Y := 0;
    for i := 0 to Buttons.Count-1 do
    begin
      Button := TDCAssistButton(Buttons.Buttons[i]);
      with Button do
      begin
        if Caption = MenuLineCaption then
        begin
          j := 3;
          SetBounds( Rect( wl, Margins.Top + wl + Y, MaxWidth + mInc, j));
        end
        else begin
          if (Button.GetGlyphHeight = 0) and Assigned(Buttons.Images) then
            j := _intMax(GetTextSize.Y, Buttons.Images.Height) + 6
          else
            j := _intMax(GetTextSize.Y, Button.GetGlyphHeight) + 6;
          SetBounds(Rect(wl, Margins.Top + wl + Y, MaxWidth, j));
        end;
        Inc(Y, j);
      end;
    end;
    SetBounds(FWindowRect.Left, FWindowRect.Top, wl + wr + MaxWidth,
      Margins.Top + wl + wr + Y);
  end;

  procedure AdjustToolBarMenuSize;
   var
    i, aSize: integer;
    Button: TDCAssistButton;

  begin
    aSize := Buttons.MaxImageWidth + 6;
    for i := 0 to Buttons.Count - 1 do
    begin
      Button := TDCAssistButton(Buttons.Buttons[i]);
      with Button do
      begin
        SetBounds( Rect( 3 + Pos * aSize, Margins.Top + 3 + Line * aSize,
         aSize, aSize));
      end;
    end;

    SetBounds(FWindowRect.Left, FWindowRect.Top, 3*2 + (FMaxPos+1) * aSize,
      Margins.Top + 3*2 + (FLinesCount+1) * aSize + 2 + FHintHeight);
  end;

begin
  Buttons.UpdateMaxImageWidth;
  case PopupStyle of
    cpPopupMenu: AdjustClipMenuSize;
    cpToolBar: AdjustToolBarMenuSize;
  end;
end;

procedure TCustomClipPopup.BeginUpdate;
begin
  Inc(FUpdateCount);
end;

procedure TCustomClipPopup.ButtonClick(Sender: TObject);
begin
  inherited;
  if Assigned(FOnButtonClick) then FOnButtonClick(Sender);
end;

procedure TCustomClipPopup.ButtonsChange(Sender: TObject);
begin
  if (FUpdateCount = 0) and (FOwner <> nil) and FOwner.HasParent then
    AdjustClipSize;
end;

procedure TCustomClipPopup.Clear;
begin
  FButtons.Clear;
  FLinesCount := 0;
  FMaxPos := 0;
end;

constructor TCustomClipPopup.Create(AOwner: TComponent);
begin
  inherited;
  if Assigned(AOwner) then Parent := TWinControl(AOwner);

  FPopupAlignment := wpOffset;
  FHintHeight  := 18;
  FLinesCount  := 0;
  FMaxPos      := 0;

  Color := clBtnFace;

  FPopupBorderStyle := brSingle;
  FDrawingStyle := dtXPStyle;

  FUpdateCount := 0;
  FPopupStyle := cpToolBar;
end;

procedure TCustomClipPopup.DrawButtonHint(Sender: TObject; Mode: integer);
 var
  sHint: string;
  R: TRect;
  DC: HDC;
  aSize: integer;
begin
  if PopupStyle = cpPopupMenu then Exit;

  if Mode = 0 then
    sHint := (Sender as TDCEditButton).Hint
  else
    sHint := '';

  aSize := Buttons.MaxImageWidth + 6;
  R := Rect(2, 2 + (FLinesCount+1) * aSize + 3,
         Self.Width - 6, 2 + (FLinesCount+1) * aSize + FHintHeight);

  Canvas.Brush.Color := Color;
  Canvas.Brush.Style := bsSolid;
  Canvas.FillRect(R);
  R.Left:= R.Left+ 2;

  if sHint <> '' then
  begin
    DC := GetWindowDC(Handle);
    SelectObject(DC, Font.Handle);
    OffsetRect(R, 0, Margins.Top);
    if TDCEditButton(Sender).Enabled then
      SetTextColor(DC, ColorToRGB(Font.Color))
    else
      SetTextColor(DC, clShadowed);

    SetBkMode(DC, TRANSPARENT);

    DrawText( DC, PChar(sHint), Length(sHint), R,
              DT_CENTER or DT_VCENTER or DT_SINGLELINE or DT_END_ELLIPSIS);

    ReleaseDC(Handle, DC);
  end;
end;

procedure TCustomClipPopup.EndUpdate;
begin
  Dec(FUpdateCount);
  if FUpdateCount = 0 then
  begin
    AdjustClipSize;
  end;
end;

function TCustomClipPopup.GetActiveButton: TDCEditButton;
begin
  Result := Buttons.ActiveButton;
end;

function TCustomClipPopup.GetConnectionRect(ARect: TRect): TRect;
begin
  SetRectEmpty(Result);
end;

procedure TCustomClipPopup.KeyDown(var Key: Word; Shift: TShiftState);
begin
  case Key of
    VK_LEFT :;
    VK_RIGHT:;
  end
end;

procedure TCustomClipPopup.RedrawBorder;
 var
  DC: HDC;
  R, CR: TRect;
  BBrush: HBRUSH;
begin
  DC := GetWindowDC(Handle);
  try
    GetWindowRect(Handle, R);  OffsetRect (R, -R.Left, -R.Top);
    CR := GetConnectionRect(R);
    if not IsRectEmpty(CR) then
    begin
      BBrush := CreateSolidBrush(clXPDarkBackground);
      FrameRect(DC, CR, BBrush);
      DeleteObject(BBrush);
      with CR do
        ExcludeClipRect(DC, Left, Top, Right, Bottom);
    end;
    DrawPopupBorder(Self, DC, R, FPopupBorderStyle, FDrawingStyle);

    if PopupStyle <> cpPopupMenu then
    begin
      InflateRect(R, -2, -2);
      R.Top    := R.Bottom - FHintHeight;
      DrawEdge(DC, R, BDR_SUNKENOUTER, BF_RECT);
    end;
  finally
    ReleaseDC(Handle, DC);
  end;
end;

procedure TCustomClipPopup.SetPopupStyle(const Value: TClipPopupStyle);
begin
  if FPopupStyle <> Value then
  begin
    FPopupStyle := Value;
    AdjustClipSize;
  end;
end;

{ TDCAssistButton }

procedure TDCAssistButton.BeginDrawBkgn(ACanvas: TCanvas; ARect: TRect;
  AState: TButtonState; var ImageRect, TextRect: TRect);
begin
  ImageRect := GetImageRect;
  TextRect  := GetTextRect(ImageRect);
  OffsetRect(ImageRect, ARect.Left, ARect.Top);
  OffsetRect(TextRect, ARect.Left, ARect.Top);

  if not Enabled then
     case DisableStyle of
       deLite:
         case DrawingStyle of
           dtFlat: ACanvas.Brush.Bitmap := AllocPatternBitmap(clLite, clBtnFace);
           dtXPStyle: ACanvas.Brush.Color := BrushColor;
         end;
       deNormal:
         ACanvas.Brush.Color := BrushColor;
       deNone:
         ACanvas.Brush.Color := BrushColor;
     end
  else
    case AState of
      btRest:
        ACanvas.Brush.Color := BrushColor;
      btDownMouseInRect:
        ACanvas.Brush.Color := DropDownColor;
      btRestMouseInRect:
        ACanvas.Brush.Color := SelectColor;
    end;
end;

procedure TDCAssistButton.BeginDrawText(ACanvas: TCanvas; ATextRect: TRect;
  AState: TButtonState);

 function LightColor(i: integer): boolean;
  var
   j: integer;
 begin
   j := ColorToRGB(clLightBarrier);
   Result := (GetRValue(i) >= GetRValue(j)) and (GetGValue(i) >= GetGValue(j)) and
     (GetBValue(i) >= GetBValue(j));
 end;

begin
  with ACanvas do
  begin
    case AState of
      btRest:;
      btDownMouseInRect:
        if LightColor(DropDownColor) then
          Font.Color := clWindowText
        else
          Font.Color := clHighlightText;
      btRestMouseInRect:
        if LightColor(SelectColor) then
          Font.Color := clWindowText
        else
          Font.Color := clHighlightText;
    end;
  end;
end;

constructor TDCAssistButton.Create(AOwner: TComponent);
begin
  inherited;
  Style := stFlat;
  FDrawingStyle := dtFlat;
  SelectColor := clHighlight;
  FDropDownColor := clXPDropDown;
end;

procedure TDCAssistButton.DrawBitmap(ACanvas: TCanvas; ImageRect: TRect);
 var
  Offs: TPoint;
  R, AImageRect: TRect;
  ABitmap: TBitmap;

  function CopyImage(Canvas: TCanvas; Rect: TRect): boolean;
  begin
    Result := True;
    if AssignedImages and (ImageIndex <> -1) then
      Images.Draw(Canvas, Rect.Left, Rect.Top, ImageIndex, True)
    else
      if not Glyph.Empty then
        Canvas.StretchDraw(Rect, Glyph)
      else
        Result := False
  end;

begin
  AImageRect := ImageRect;
  Offs := GetImageOffset;
  OffsetRect(AImageRect, Offs.X, Offs.Y);
  if Enabled or (DisableStyle = deNone) then
  begin
    if (DrawingStyle = dtXPStyle) and
      (ButtonState in [btRestMouseInRect, btRest]) then
    begin
      ABitmap := TBitmap.Create;
      try
        Inc(AImageRect.Right,1);
        R := AImageRect;

        ABitmap.Width := AImageRect.Right - AImageRect.Left;
        ABitmap.Height := AImageRect.Bottom - AImageRect.Top;
        OffsetRect(R, -R.Left, -R.Top);

        ABitmap.Canvas.Brush.Color := clFuchsia;
        ABitmap.Canvas.FillRect(R);


        if CopyImage(ABitmap.Canvas, R) then
        begin
          if ButtonState = btRestMouseInRect then
            TransformBitmap(ABitmap, ABitmap, tsXPStyle)
          else
            AlphaBlend(ABitmap, nil, ABitmap, 175, clFuchsia, clXPDarkBackground);
          DrawTransparentBitmap(ACanvas.Handle, ABitmap, AImageRect, False);
        end;

      finally
        ABitmap.Free;
      end;
    end
    else
      CopyImage(ACanvas, AImageRect);
  end
  else begin
    case DisableStyle of
      deLite  : DrawLiteDisableBitmap(ACanvas, ImageRect);
      deNormal: DrawNormDisableBitmap(ACanvas, ImageRect);
      deTrans : DrawTranDisableBitmap(ACanvas, ImageRect);
    end
  end;
end;

procedure TDCAssistButton.DrawBkgnd(ACanvas: TCanvas; ARect: TRect);
 var
  R, IR: TRect;
  Brush: HBRUSH;
  AButtonState: TButtonState;
begin
  AButtonState := ButtonState;
  if Assigned(ButtonHolder) then
    if not ButtonHolder.GetFlagValue(BS_KEYMOVING) and not Enabled then
      AButtonState := btRest
    else
  else
    if not Enabled then AButtonState := btRest;

  case DrawingStyle of
    dtFlat: inherited DrawBkgnd(ACanvas, ARect);
    dtXPStyle:
      begin
        if (AButtonState = btRest) and (ButtonHolder.MaxImageWidth <> 0) then
        begin
          IR := GetImageRect;
          if ButtonHolder <> nil then
             IR.Right := IR.Left + ButtonHolder.MaxImageWidth;
          R := ARect;
          R.Right := R.Left + IR.Right + 4;
          Brush := CreateSolidBrush(clXPDarkBackground);
          try
            FillRect(ACanvas.Handle, R, Brush);
            ARect.Left := R.Right;
          finally
            DeleteObject(Brush);
          end;
        end;
        inherited DrawBkgnd(ACanvas, ARect);
        if Caption = MenuLineCaption then
        begin
          ACanvas.Brush.Color := clXPDisabled;
          Inc(ARect.Left, GetTextOffset.X);
          InflateRect(ARect, 0, -1);
          FillRect(ACanvas.Handle, ARect, ACanvas.Brush.Handle);
        end;
      end;
  end;
end;

procedure TDCAssistButton.DrawBorder(ACanvas: TCanvas; ARect: TRect);
 var
  AButtonState: TButtonState;
  Brush: HBRUSH;
begin
  AButtonState := ButtonState;
  if not ButtonHolder.GetFlagValue(BS_KEYMOVING) and not Enabled then
    AButtonState := btRest;

  case DrawingStyle of
    dtFlat:
      begin
        FrameRect(ACanvas.Handle, ARect, GetSysColorBrush(COLOR_BTNFACE));
        InflateRect(ARect, -1, -1);
        FrameRect(ACanvas.Handle, ARect, GetSysColorBrush(COLOR_BTNSHADOW));
      end;
    dtXPStyle:
      case AButtonState of
        btDownMouseInRect, btRestMouseInRect:
          begin
            Brush := CreateSolidBrush(clXPBorder);
            FrameRect(ACanvas.Handle, ARect, Brush);
            DeleteObject(Brush);
          end;
      end;
  end;
end;

procedure TDCAssistButton.DrawEditText(ACanvas: TCanvas;
  var TextRect: TRect);
 var
  R: TRect;
  w: integer;
begin
  if Caption <> MenuLineCaption then
  begin
    R := GetImageRect;
    if (R.Left = R.Right) and (ButtonHolder.MaxImageWidth <> 0) then
    begin
      w := TextRect.Right - TextRect.Left;
      case Alignment of
        abRight:
          TextRect.Left := _intMax(R.Left + ButtonHolder.MaxImageWidth + 4,
            TextRect.Left - 4);
        else
          TextRect.Left := R.Left + ButtonHolder.MaxImageWidth + 4;
      end;
      TextRect.Right := TextRect.Left + w;
    end;
  end;
  inherited;
end;

function TDCAssistButton.GetImageOffset: TPoint;
begin
  case DrawingStyle of
    dtFlat: Result := Point(0, 0);
    dtXPStyle: Result := Point(0, 0);
  end;
end;

function TDCAssistButton.GetTextOffset: TPoint;
begin
  case DrawingStyle of
    dtFlat: Result := Point(0, 0);
    dtXPStyle:
      if ButtonHolder.MaxImageWidth <> 0 then
        Result := Point(7, 0)
      else
        Result := Point(0, 0);
  end;
end;

function TDCAssistButton.OneClickButton: boolean;
begin
  Result := True;
end;

procedure TDCAssistButton.SetDrawingStyle(const Value: TDCDrawingStyle);
begin
  FDrawingStyle := Value;
end;

procedure TDCAssistButton.SetLine(const Value: integer);
begin
  if FLine <> Value then
  begin
    FLine := Value;
  end;
end;

procedure TDCAssistButton.SetPos(const Value: integer);
begin
  if FPos <> Value then
  begin
    FPos := Value;
  end;
end;

{ TDCControlShadow }

procedure TDCControlShadow.BeginUpdate;
begin
  inc(FUpdateCount);
end;

procedure TDCControlShadow.Changed;
begin
  if FUpdateCount = 0 then
    FControl.Perform(CM_SHADOWCHANGED, Integer(Self), 0);
end;

constructor TDCControlShadow.Create(AOwner: TWinControl);
begin
  inherited Create(AOwner);
  inherited Visible := False;
  Parent := AOwner;

  FControl := AOwner;
  FAlphaBlendValue := 180;
  FAngle := 135;
  FDistance := 4;
  FSize := 5;
  FVisible := False;
  FRgn := NULLREGION;
end;

procedure TDCControlShadow.CreateParams(var Params: TCreateParams);
begin
  inherited;
  with Params do
  begin
   Style := Style or WS_POPUP;
//   ExStyle := ExStyle or WS_EX_TRANSPARENT;
   with Params.WindowClass do
     Style := Style and not(CS_HREDRAW or CS_VREDRAW);
  end;
end;

destructor TDCControlShadow.Destroy;
begin
  if not IsRegionEmpty(FRgn) then DeleteObject(FRgn);
  inherited;
end;

procedure TDCControlShadow.EndUpdate;
begin
  Dec(FUpdateCount);
  Changed;
end;

function TDCControlShadow.GetShadowPos: TPoint;
begin
  if Visible then
  begin
    Result.X := - Round(Distance * Cos(Angle * Pi/180));
    Result.Y := Round(Distance * Sin(Angle * Pi/180));
  end
  else
    FillChar(Result, SizeOf(TPoint), #0);
end;

procedure TDCControlShadow.Hide;
begin
  UnHookPopupHooks;
  SetWindowPos(Handle, 0, 0, 0, 0, 0,
    SWP_NOZORDER or SWP_NOMOVE or SWP_NOSIZE or SWP_NOACTIVATE or
    SWP_HIDEWINDOW);
end;

procedure TDCControlShadow.SaveBackground(Rgn: HRGN);
begin
  if (Width > 0) and (Height > 0) then
  begin
    if IsRegionEmpty(FRgn) then FRgn := CreateEmptyRgn;

    CombineRgn(FRgn, Rgn, Rgn, RGN_COPY);
    UpdateWindowRgn(FRgn);
  end;
end;

procedure TDCControlShadow.SetAngle(const Value: integer);
begin
  if FAngle <> Value then
  begin
    FAngle := Value;
    Changed;
  end;
end;

procedure TDCControlShadow.SetDistance(const Value: DWORD);
begin
  if FDistance <> Value then
  begin
    FDistance := Value;
    Changed;
  end;
end;

procedure TDCControlShadow.SetSize(const Value: DWORD);
begin
  if FSize <> Value then
  begin
    FSize := Value;
    Changed;
  end
end;

procedure TDCControlShadow.SetVisible(const Value: boolean);
begin
  if FVisible <> Value then
  begin
    FVisible := Value;
    Changed;
  end;
end;

procedure TDCControlShadow.Show;
begin
  SetWindowPos(Handle, Parent.Handle, Left, Top, 0, 0, SWP_NOSIZE or
    SWP_NOACTIVATE or SWP_SHOWWINDOW);
  HookPopupHooks(Self, GetCurrentThreadID);
end;

procedure TDCControlShadow.UpdateWindowRgn(Rgn: HRGN);
 var
  ARgn: HRGN;
  P: TPoint;
begin
  ARgn := CreateEmptyRgn;
  try
    CombineRgn(ARgn, Rgn, Rgn, RGN_COPY);
    P := GetShadowPos;
    OffsetRgn(ARgn, -P.X, -P.Y);
    CombineRgn(ARgn, Rgn, ARgn, RGN_DIFF);
    SetWindowRgn(Handle, ARgn, False);
  finally
    DeleteObject(ARgn);
  end;
end;

procedure TDCControlShadow.WMEraseBkgnd(var Message: TWMEraseBkgnd);
 var
  DrawBitmap: TBitmap;
  P: TPoint;
  ScreenDC: HDC;
  x, y: integer;
begin
  if (Width > 0) and (Height > 0) then
  begin
    DrawBitmap := TBitmap.Create;
    ProcessPaintMessages;
    P := ClientToScreen(Point(0, 0));
    ScreenDC := GetDCEx(0, 0, DCX_WINDOW or DCX_CACHE or DCX_LOCKWINDOWUPDATE);
    try
      x := _intMin(P.X + Width + 2, Screen.Width) - P.X + 1;
      y := _intMin(P.Y + Height + 2, Screen.Height) - P.Y + 1;
      DrawBitmap.Width  := x;
      DrawBitmap.Height := y;
      BitBlt(DrawBitmap.Canvas.Handle, 0, 0, DrawBitmap.Width,
        DrawBitmap.Height, ScreenDC, P.X - 1, P.Y - 1, SRCCOPY);
      DrawShadow(DrawBitmap, FRgn, clWhite,
        clBlack, FSize, FAlphaBlendValue, Point(1, 1), False);

      BitBlt(Message.DC, 0, 0, Width, Height, DrawBitmap.Canvas.Handle, 1, 1,
        SRCCOPY);
    finally
      ReleaseDC(0, ScreenDC);
      DrawBitmap.Free;
    end;
  end;

  Message.Result := 0;
end;

procedure TDCControlShadow.WMMouseActivate(var Message: TWMActivate);
begin
  Message.Result := MA_NOACTIVATE;
  SetWindowPos (Handle, 0, 0, 0, 0, 0, SWP_NOACTIVATE or SWP_NOMOVE or
    SWP_NOSIZE);
end;

{ TDCComboButton }

procedure TDCComboButton.BeginDrawBkgn(ACanvas: TCanvas; ARect: TRect;
  AState: TButtonState; var ImageRect, TextRect: TRect);
begin
  if (coLinkPopup in FComboOptions) and (ButtonState = btDownMouseInRect) then
  begin
    AState :=  btRest;
    inherited BeginDrawBkgn(ACanvas, ARect, AState, ImageRect, TextRect);
    if Style in [stSingle, stXPStyle] then
      ACanvas.Brush.Color := clXPDarkBackground;
  end
  else
    inherited BeginDrawBkgn(ACanvas, ARect, AState, ImageRect, TextRect);
end;

procedure TDCComboButton.BeginDrawText(ACanvas: TCanvas; ATextRect: TRect;
  AState: TButtonState);
begin
  if (coLinkPopup in FComboOptions) and (ButtonState = btDownMouseInRect) then
    AState :=  btRest;
  inherited BeginDrawText(ACanvas, ATextRect, AState);
end;

procedure TDCComboButton.Cancel;
begin
  if DroppedDown then TrackClipPopup(nil);
end;

procedure TDCComboButton.Click;
begin
  inherited;
  if not FDroppedDown then TrackClipPopup(Self) else Cancel;
end;

constructor TDCComboButton.Create(AOwner: TComponent);
begin
  inherited;
  EventStyle := esDropDown;
  FComboOptions := [coLinkPopup, coHidePickup];
  FPopupPosition := ppBottomLeft;
  FDroppedDown := False;

  BrushColor := clXPDarkBackground;
end;

destructor TDCComboButton.Destroy;
begin
  Cancel;
  inherited;
end;

procedure TDCComboButton.DoClick(Sender: TObject);
begin
  Caption := TDCPopupMenuItem(Sender).Caption;
end;

procedure TDCComboButton.DrawBorder(ACanvas: TCanvas; ARect: TRect);
 var
  R: TRect;
  BBrush: HBRUSH;
begin
  if (coLinkPopup in FComboOptions) and (ButtonState = btDownMouseInRect) then
  begin
    R := GetPopupRect(ARect);
    if not IsRectEmpty(R) then
      with R do
        ExcludeClipRect(ACanvas.Handle, Left, Top, Right, Bottom);
    if Style in [stXPStyle, stSingle] then
    begin
      BBrush := CreateSolidBrush(clDarkShadow);
      FrameRect(ACanvas.Handle, ARect, BBrush);
      DeleteObject(BBrush);
      Exit;
    end;
  end;
  inherited DrawBorder(ACanvas, ARect);
end;

procedure TDCComboButton.DrawEditText(ACanvas: TCanvas;
  var TextRect: TRect);
begin
  Dec(TextRect.Right, 8);
  inherited DrawEditText(ACanvas, TextRect);
  if not(coHidePickup in FComboOptions) or (ButtonState <> btRest) then
  begin
    DrawBasicShape(ACanvas.Handle, shDown, TextRect.Right,
      (TextRect.Top + TextRect.Bottom - 4) div 2, ColorToRGB(ACanvas.Font.Color),
      szSmall);
  end;
end;

function TDCComboButton.GetBoundsRect: TRect;
 var
  P: TPoint;
begin
  Result := GetBoundsEx;
  if AbsolutePos then
    P := Point(Owner.Left, Owner.Top)
  else
    P := Owner.ClientToScreen(Point(0, 0));

  OffsetRect(Result, P.X, P.Y);
end;

procedure TDCComboButton.GetConnectionPos(var X, Y, AWidth: integer;
  var Position: TPopupPosition);
 var
  P: TPoint;
begin
  AWidth := Width;
  Position := FPopupPosition;
  if AbsolutePos then
  begin
    P := Point(Owner.Left + Left, Owner.Top + Top + Height);
    P := Owner.ScreenToClient(P);
    X := P.X;
    Y := P.Y;
  end
  else begin
    X := Left;
    Y := Top + Height;
  end;
end;

function TDCComboButton.GetControl: TWinControl;
begin
  Result := Owner;
end;

function TDCComboButton.GetDroppedDown: boolean;
begin
  Result := FDroppedDown;
end;

function TDCComboButton.GetPopupRect(ARect: TRect): TRect;
begin
  if FPopupPosition = ppNone then
  begin
    SetRectEmpty(Result);
    Exit;
  end;
  Result := ARect;
  Inc(Result.Left);
  Dec(Result.Right);
  case FPopupPosition of
    ppBottomLeft:
      Result.Top := Result.Bottom - 1;
    ppBottomRight:
      Result.Top := Result.Bottom - 1;
    ppTopRight:
      Result.Bottom := Result.Top + 1;
  end
end;

function TDCComboButton.GetTextSize: TPoint;
begin
  Result := inherited GetTextSize;
  Inc(Result.X, 8);
end;

function TDCComboButton.InitPopupItems(PopupControl: IDPopupControl): boolean;
 var
  i: integer;
begin
  if Assigned(FPopupItems) and (FPopupItems.Items.Count > 0) then
  begin
    with FPopupItems do
    begin
      PopupControl.Images := Images;
      for i := 0 to Items.Count - 1 do
        if Items[i].Visible then PopupControl.InsertMenuItem(i, Items[i]);
    end;
    Result := True;
  end
  else
    Result := False;
end;

procedure TDCComboButton.ItemsChange(Sender: TObject; Source: TDCPopupMenuItem;
  Rebuild: Boolean);
begin
  {}
end;

function TDCComboButton.QueryInterface(const IID: TGUID; out Obj): HResult;
begin
  Pointer(Obj) := Self;
  Result := S_OK;
end;  

procedure TDCComboButton.SetComboOptions(const Value: TComboOptions);
begin
  FComboOptions := Value;
  if Assigned(ButtonHolder) then ButtonHolder.Invalidate;
end;

procedure TDCComboButton.SetDroppedDown(const Value: boolean);
begin
  if Value <> FDroppedDown then
  begin
    if Value then
    begin
      if EventStyle = esDropDown then
        UpdateButtonState(Left + 1, Top + 1, True, False);
    end
    else
      Cancel;
  end;
end;

procedure TDCComboButton.SetDroppedIndirect(const Value: boolean);
begin
  FDroppedDown := Value;
end;

procedure TDCComboButton.SetPopupItems(const Value: TDCPopupMenu);
begin
  FPopupItems := Value;
  FPopupItems.OnChange := ItemsChange;
end;

function TDCComboButton.UpdateButtonState(X, Y: integer; ADown,
  AMove: boolean): boolean;
begin
  if EventStyle = esDropDown then
    Result := inherited UpdateButtonState(X, Y, ADown, AMove)
  else begin
    {not implemented yet}
    Result := inherited UpdateButtonState(X, Y, ADown, AMove)
  end;
end;

procedure TDCControlShadow.WMNCHitTest(var Message: TWMNCHitTest);
begin
  Message.Result := HTTRANSPARENT;
end;

function TDCComboButton._AddRef: Integer;
begin
  Result := -1;
end;

function TDCComboButton._Release: Integer;
begin
  Result := -1;
end;

{ TComboClipPopup }

procedure TComboClipPopup.ButtonClick(Sender: TObject);
 var
  Button: TDCEditButton;
begin
  Button := TDCEditButton(Sender);
  if Assigned(FPopupHolder) then
    if Button.Tag <> 0 then
      FPopupHolder.DoClick(TObject(Button.Tag))
    else
      FPopupHolder.DoClick(Button);
  PostMessage(Handle, CM_HIDECLIPTRACK, 0, 0);
end;

procedure TComboClipPopup.CMHideClipTrack(var Message: TMessage);
begin
  TrackClipPopup(nil);
end;

constructor TComboClipPopup.Create(APopupHolder: IDCPopupHolder);
begin
  if Assigned(APopupHolder) then
    inherited Create(APopupHolder.GetControl)
  else
    inherited Create(nil);
  FPopupHolder := APopupHolder;
end;

procedure TComboClipPopup.DoHookKeyDown(var Msg: TMsg);
begin
  if Msg.wParam = VK_ESCAPE then
    TrackClipPopup(nil)
  else begin
    SendMessage(Handle, WM_KEYDOWN, Msg.wParam, Msg.lParam)
  end;

  Msg.message := 0;
end;

function TComboClipPopup.GetConnectionRect(ARect: TRect): TRect;
 var
   P: TPoint;
   w: integer;
   Position: TPopupPosition;
begin
  if Assigned(FPopupHolder) then
  begin
    FPopupHolder.GetConnectionPos(P.X, P.Y, w, Position);
    case Position of
      ppBottomLeft:
        with Result do
        begin
          Left   := ARect.Left + 1;
          Top    := ARect.Top;
          Right  := Left + w - 2;
          Bottom := Top + 1;
        end;
      ppBottomRight:
        with Result do
        begin
          Left   := ARect.Right - w;
          Top    := ARect.Top;
          Right  := Left + w - 1;
          Bottom := Top + 1;
        end;
      else
        Result := ARect;
    end;
  end
  else
    SetRectEmpty(Result);
end;

function TComboClipPopup.GetImages: TCustomImageList;
begin
  Result := Buttons.Images;
end;

function TComboClipPopup.GetRegion(RegionType: integer): HRGN;
 var
  Rgn: HRGN;
  R, R1: TRect;
  P: TPoint;
  w: integer;
  Position: TPopupPosition;
begin
  if FPopupHolder <> nil then
  begin
    FPopupHolder.GetConnectionPos(P.X, P.Y, w, Position);
    R1 := FPopupHolder.GetBoundsRect;
    OffsetRect(R1, -R1.Left, -R1.Top);
    Rgn := CreateRectRgnIndirect(R1);

    GetWindowRect(Handle, R);
    case Position of
      ppBottomLeft:
        OffsetRect(R, -R.Left, -R.Top + R1.Bottom);
      else
        OffsetRect(R, -R.Left, -R.Top);
    end;
    Result := CreateRectRgnIndirect(R);

    CombineRgn(Result, Result, Rgn, RGN_OR);
    DeleteObject(Rgn);
  end
  else
    Result := inherited GetRegion(RegionType);
end;

function TComboClipPopup.GetShadowPos: TPoint;
 var
  R: TRect;
  P: TPoint;
  w: integer;
  Position: TPopupPosition;
begin
  if FPopupHolder <> nil then
  begin
    FPopupHolder.GetConnectionPos(P.X, P.Y, w, Position);
    R := FPopupHolder.GetBoundsRect;
    OffsetRect(R, -R.Left, -R.Top);
    case Position of
      ppBottomLeft:
        Result := Point(0, - R.Bottom);
      ppBottomRight:
        Result := Point(-R.Right, - R.Bottom);
    end;
  end
  else
    Result := inherited GetShadowPos;
end;

procedure TComboClipPopup.Hide;
begin
  inherited;
  FPopupHolder.GetControl.Update;
end;

function GetClipPopupHook(nCode: Integer; wParam: Longint;
  var Msg: TMsg): Longint; stdcall;
 var
  ShiftState: TShiftState;
begin
  if (nCode >= 0) and (Application <> nil) and (ComboClipPopup <> nil)then
  begin
    with Msg do
    begin
      case message of
        CM_DEACTIVATE, WM_KILLFOCUS, WM_CLOSE:
          TrackClipPopup(nil);
        WM_SYSKEYDOWN:
          begin
            ShiftState := KeyDataToShiftState(Msg.lParam);
            if ssAlt in ShiftState then
              TrackClipPopup(nil);
          end;
        WM_KEYDOWN:
          ComboClipPopup.DoHookKeyDown(Msg);
        WM_LBUTTONDOWN, WM_NCLBUTTONDOWN:
          with ComboClipPopup do
          begin
            if not(PtInRect(BoundsRect, Msg.pt) or
              PtInRect(FPopupHolder.GetBoundsRect, Msg.pt))
            then
              TrackClipPopup(nil);
          end;
      end;
    end;
  end;
  Result := CallNextHookEx(ClipPopupHook, nCode, wParam, Longint(@Msg));
end;

function TrackClipPopup(PopupHolder: IDCPopupHolder): DWORD;
 var
   P: TPoint;
   w: integer;
   Position: TPopupPosition;
begin
  Result := 0;
  if (ComboClipPopup <> nil) and ComboClipPopup.FPopupHolder.DroppedDown then
  begin
    UnhookWindowsHookEx(ClipPopupHook);
    with ComboClipPopup do
    begin
      Hide;
      FPopupHolder.SetDroppedIndirect(False);
      FPopupHolder.ResetProperties;
    end;
    FreeAndNil(ComboClipPopup);
  end;

  if PopupHolder <> nil then
  begin
    ComboClipPopup := TComboClipPopup.Create(PopupHolder);
    with ComboClipPopup do
    begin
      BeginUpdate;
      PopupStyle := cpPopupMenu;
      PopupHolder.InitPopupItems(ComboClipPopup);
      PopupHolder.GetConnectionPos(P.X, P.Y, w, Position);
      Left := P.X;
      Top  := P.Y;
      EndUpdate;
      Show;
      PopupHolder.SetDroppedIndirect(True);
    end;

    ClipPopupHook := SetWindowsHookEx(WH_GETMESSAGE, @GetClipPopupHook, 0,
      GetCurrentThreadID)

  end;
end;

procedure TComboClipPopup.InsertEmptyItem(ACaption: string);
begin
  with AddButton('#Empty', '', ACaption, 0, 0) do
  begin
    Enabled := False;
  end;
end;

function TComboClipPopup.InsertMenuItem(Index: integer;
  MenuItem: TDCPopupMenuItem): boolean;
begin
  with AddButton(MenuItem.Name, '', MenuItem.Caption, 0, Index) do
  begin
    Images := Buttons.Images;
    ImageIndex := MenuItem.ImageIndex;
    Enabled := MenuItem.Enabled;
    Tag := Integer(MenuItem);
  end;
  Result := True;
end;

procedure TComboClipPopup.SetImages(const Value: TCustomImageList);
begin
  Buttons.Images := Value;
end;

initialization
  HookCount := 0;

end.

