{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x
         Copyright (c) 1998-2000 Alex'EM

}
unit DCPageColEdit;

interface
{$I DCConst.inc}

uses
  Classes, Sysutils, 
  {$IFDEF DELPHI_V6} 
    DesignIntf, DesignEditors, DesignWindows, 
  {$ELSE} 
    Dsgnintf, DsgnWnds, 
  {$ENDIF} 
  DCStdCtrls, Dialogs, TypInfo;

type

  TPageControlEditor = class(TComponentEditor)
  public
    function GetVerbCount: integer; override;
    function GetVerb(Index: integer): string; override;
    procedure ExecuteVerb(Index: integer); override;
    procedure Edit; override;
  end;

  TOutBarEditor = class(TComponentEditor)
  public
    function GetVerbCount: integer; override;
    function GetVerb(Index: integer): string; override;
    procedure ExecuteVerb(Index: integer); override;
    procedure Edit; override;
  end;

  TPaleteBarEditor = class(TComponentEditor)
  public
    function GetVerbCount: integer; override;
    function GetVerb(Index: integer): string; override;
    procedure ExecuteVerb(Index: integer); override;
    procedure Edit; override;
  end;

  TActivePageField = class(TClassProperty)
  private
    procedure GetValueList(List: TStrings);
  public
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure SetValue(const Value: string); override;
  end;

implementation

{ TPageControlEditor }

procedure TPageControlEditor.Edit;
begin
  inherited;
end;

procedure TPageControlEditor.ExecuteVerb(Index: integer);
 var
  APage: TDCCustomPage;
  APageControl: TDCCustomPageControl;
begin
  if (Component is TDCCustomPageControl) then
    APageControl := TDCCustomPageControl(Component)
  else
    APageControl := TDCCustomPage(Component).PageControl;

  case Index of
    0:
      begin
        APage := TDCPage.Create(Designer.GetRoot);
        with APage do
        begin
          Name    := Designer.UniqueName(ClassName);
          Caption := Name;
          PageControl := APageControl;
          if Assigned(APageControl.Images) then ImageIndex := PageIndex;
      end;
      end;
    1:;
    2: APageControl.SelectNextPage(True);
    3: APageControl.SelectNextPage(False);
  end;
  APage := APageControl.ActivePage;
  Designer.SelectComponent(APage);
  Designer.Modified;
end;

function TPageControlEditor.GetVerb(Index: integer): string;
begin
  case Index of
   0: Result := 'Ne&w Page';
   1: Result := '-';
   2: Result := '&Next Page';
   3: Result := '&Previous Page';
  end;
end;

function TPageControlEditor.GetVerbCount: integer;
begin
  Result :=  4;
end;

{ TOutBarEditor }

procedure TOutBarEditor.Edit;
begin
  inherited;
end;

procedure TOutBarEditor.ExecuteVerb(Index: integer);
 var
  APage: TDCCustomPage;
  APageControl: TDCCustomPageControl;
begin
  if (Component is TDCCustomPageControl) then
    APageControl := TDCCustomPageControl(Component)
  else
    APageControl := TDCCustomPage(Component).PageControl;

  case Index of
    0:
      begin
        APage := TDCOutBarPanel.Create(Designer.GetRoot);
        with APage do
        begin
          Name    := Designer.UniqueName(ClassName);
          Caption := Name;
          PageControl := APageControl;
          if Assigned(APageControl.Images) then ImageIndex := PageIndex;
        end;
      end;
    1:;
    2: APageControl.SelectNextPage(True);
    3: APageControl.SelectNextPage(False);
    5:
      begin
        APage := TDCPage.Create(Designer.GetRoot);
        with APage do
        begin
          Name    := Designer.UniqueName(ClassName);
          Caption := Name;
          PageControl := APageControl;
          if Assigned(APageControl.Images) then ImageIndex := PageIndex;
        end;
      end;
  end;
  APage := APageControl.ActivePage;
  Designer.SelectComponent(APage);
  Designer.Modified;
end;

function TOutBarEditor.GetVerb(Index: integer): string;
begin
  case Index of
   0: Result := 'Ne&w Page';
   1: Result := '-';
   2: Result := '&Next Page';
   3: Result := '&Previous Page';
   4: Result := '-';
   5: Result := 'Ne&w Standard Page';
  end;
end;

function TOutBarEditor.GetVerbCount: integer;
begin
  Result :=  6;
end;

{ TGetCustomPageField }

function TActivePageField.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList];
end;

function TActivePageField.GetValue: string;
 var
  APageControl: TDCCustomPageControl;
begin
  APageControl := GetComponent(0) as TDCCustomPageControl;
  if (APageControl <> nil) and (APageControl.ActivePage <> nil) then
    Result := APageControl.ActivePage.Name
  else
    Result := '';
end;

procedure TActivePageField.GetValueList(List: TStrings);
 var
  I: Integer;
  APageControl: TDCCustomPageControl;
  APage: TDCCustomPage;
begin
  APageControl := GetComponent(0) as TDCCustomPageControl;
  try
    for I := 0 to Designer.GetRoot.ComponentCount - 1 do
    begin
      if Designer.GetRoot.Components[I] is TDCCustomPage then
      begin
        APage := Designer.GetRoot.Components[I] as TDCCustomPage;
        if (APage.PageControl = nil) or (APage.PageControl = APageControl) then
          List.Add(APage.Name);
      end;
    end;
  finally
  end;
end;

procedure TActivePageField.GetValues(Proc: TGetStrProc);
 var
  Values: TStringList;
  I: integer;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

procedure TActivePageField.SetValue(const Value: string);
 var
  APageControl: TDCCustomPageControl;
  i: integer;
begin
  APageControl := GetComponent(0) as TDCCustomPageControl;
  if (APageControl <> nil) then
  with APageControl do
  begin
    for i := 0 to PageCount-1 do
      if AnsiCompareText(Pages[i].Name, Value) = 0 then
      begin
        ActivePage := Pages[i];
        Exit;
      end;
  end;
end;

{ TPaleteBarEditor }

procedure TPaleteBarEditor.Edit;
begin
  inherited;
end;

procedure TPaleteBarEditor.ExecuteVerb(Index: integer);
 var
  APage: TDCCustomPage;
  APageControl: TDCCustomPageControl;
begin
  if (Component is TDCCustomPageControl) then
    APageControl := TDCCustomPageControl(Component)
  else
    APageControl := TDCCustomPage(Component).PageControl;

  case Index of
    0:
      begin
        APage := TDCPaleteBarPanel.Create(Designer.GetRoot);
        with APage do
        begin
          Name    := Designer.UniqueName(ClassName);
          Caption := Name;
          PageControl := APageControl;
          if Assigned(APageControl.Images) then ImageIndex := PageIndex;
        end;
      end;
    1:;
    2: APageControl.SelectNextPage(True);
    3: APageControl.SelectNextPage(False);
  end;
  APage := APageControl.ActivePage;
  Designer.SelectComponent(APage);
  Designer.Modified;
end;

function TPaleteBarEditor.GetVerb(Index: integer): string;
begin
  case Index of
   0: Result := 'Ne&w Page';
   1: Result := '-';
   2: Result := '&Next Page';
   3: Result := '&Previous Page';
  end;
end;

function TPaleteBarEditor.GetVerbCount: integer;
begin
  Result :=  4;
end;

end.
