{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x - 6.x
         Copyright (c) 1998-2001 Alex'EM

}
unit DCKnots;

interface
{$I DCConst.inc}

uses
  Windows, SysUtils, Messages, Classes, Graphics, Menus, Controls, Dialogs,
  Forms, StdCtrls, Buttons, ImgList, ComCtrls, DCGrids, grids, DCChoice,
  DCPopupWindow, DCEditTools, DCConst
  {$IFDEF ADO_EXPRESS}, DCADOCtrl {$ENDIF};

type
  TKnotsColumnValue  = (cvColor, cvWidth, cvFont, cvAlignment, cvReadOnly,
    cvTitleColor, cvTitleCaption, cvTitleAlignment, cvTitleFont, cvComment,
    cvDisplayFormat);
  TKnotsColumnValues = set of TKnotsColumnValue;

const
  ColumnTitleValues = [cvTitleColor..cvTitleFont];

type
  TDCCustomTreeGrid = class;
  TKnotColumn = class;
  TKnotBookmark = pointer;

  TInplaceEditType = (etSimpleEdit, etMaskEdit, etChoiceEdit, etDateEdit,
    etFloatEdit, etComboBox, etGridEdit, etADOGridEdit, etBDEGridEdit,
    etTreeEdit, etFormEdit);

  IDCInplaceEditor = interface(IDCChoiceEdit)
    ['{E1BBDAA5-6BE6-442A-8588-35591B15F102}']
    function GetEditType: TInplaceEditType;
    function GetGrid: TDCCustomTreeGrid;
    procedure SetGrid(Value: TDCCustomTreeGrid);
    property EditType: TInplaceEditType read GetEditType;
    property Grid: TDCCustomTreeGrid read GetGrid;
  end;

  TKnotColumnTitle = class(TPersistent)
  private
    FColumn: TKnotColumn;
    FCaption: string;
    FFont: TFont;
    FColor: TColor;
    FAlignment: TAlignment;
    procedure FontChanged(Sender: TObject);
    function GetAlignment: TAlignment;
    function GetColor: TColor;
    function GetCaption: string;
    function GetFont: TFont;
    function IsAlignmentStored: Boolean;
    function IsColorStored: Boolean;
    function IsFontStored: Boolean;
    function IsCaptionStored: Boolean;
    procedure SetAlignment(Value: TAlignment);
    procedure SetColor(Value: TColor);
    procedure SetFont(Value: TFont);
    procedure SetCaption(const Value: string); virtual;
  protected
    procedure RefreshDefaultFont;
  public
    constructor Create(Column: TKnotColumn);
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
    function DefaultAlignment: TAlignment;
    function DefaultColor: TColor;
    function DefaultFont: TFont;
    function DefaultCaption: string;
    procedure RestoreDefaults; virtual;
    property Column: TKnotColumn read FColumn;
  published
    property Alignment: TAlignment read GetAlignment write SetAlignment stored
      IsAlignmentStored;
    property Caption: string read GetCaption write SetCaption stored
      IsCaptionStored;
    property Color: TColor read GetColor write SetColor stored IsColorStored;
    property Font: TFont read GetFont write SetFont stored IsFontStored;
  end;

  TKnotColumnFooter = class(TDCFooter)
  public
    property Index;
  published
    property AutoSize;
    property Style;
    property Height;
    property Visible;
  end;

  TKnotColumnFooterPanel = class(TDCFooterTextPanel)
  private
    FColumn: TKnotColumn;
    procedure SetColumn(const Value: TKnotColumn);
  protected
    function GetColIndex: integer; override;
    procedure SetColIndex(const Value: integer); override;
  public
    function DefaultFont: TFont; override;
    property Column: TKnotColumn read FColumn write SetColumn;
  published
    property Visible default False;
    property Style default beLowered;
  end;

  TKnotOption  = (kcIndexed, kcReadOnly, kcShowEdit, kcSizing, kcVisible,
    kcDrawTreeCell, kcPopupMenu, kcWordBreak, kcEllipsis);

  TKnotOptions = set of TKnotOption;
  TKnotColumnClass = class of TKnotColumn;
  TKnotOperation = (kpInsert, kpRemove);

  TKnotColumn  = class(TCollectionItem)
  private
    FAlignment: TAlignment;
    FAssignedValues: TKnotsColumnValues;
    FColor: TColor;
    FComment: string;
    FDisplayFormat: string;
    FFont: TFont;
    FFooterPanel: TKnotColumnFooterPanel;
    FItemIndex: integer;
    FIndexStyle: TColumnIndexStyle;
    FName: string;
    FOptions: TKnotOptions;
    FSize: TPoint;
    FTitle: TKnotColumnTitle;
    FVertAlignment: TVertAlignment;
    FWidth: TWidth;
    procedure SetColor(const Value: TColor);
    procedure SetFont(const Value: TFont);
    procedure SetTitle(const Value: TKnotColumnTitle);
    function GetAlignment: TAlignment;
    function GetColor: TColor;
    function GetFont: TFont;
    procedure FontChanged(Sender: TObject);
    procedure SetItemIndex(const Value: integer);
    procedure SetIndexStyle(const Value: TColumnIndexStyle);
    function GetWidth: TWidth;
    procedure SetAlignment(const Value: TAlignment);
    procedure SetName(const Value: string);
    procedure SetWidth(const Value: TWidth);
    procedure SetDisplayFormat(const Value: string);
    function IsAlignmentStored: Boolean;
    function IsColorStored: Boolean;
    function IsFontStored: Boolean;
    function IsWidthStored: Boolean;
    function IsCommentStored: Boolean;
    procedure SetOptions(const Value: TKnotOptions);
    procedure SetComment(const Value: string);
    function GetComment: string;
    function GetActualWidth: TWidth;
    procedure SetFooterPanel(const Value: TKnotColumnFooterPanel);
    procedure SetVertAlignment(const Value: TVertAlignment);
  protected
    procedure Changed(AllItems: Boolean);
    function GetDisplayName: string; override;
    procedure RefreshDefaultFont;
    procedure SetIndex(Value: Integer); override;
  public
    constructor Create(Collection: TCollection); override;
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
    function GetGrid: TDCCustomTreeGrid;
    function GetStoredWidth: integer;
    function DefaultAlignment: TAlignment;
    function DefaultColor: TColor;
    function DefaultFont: TFont;
    function DefaultWidth: Integer;
    function DefaultComment: string;
    procedure RestoreDefaults; virtual;
    property AssignedValues: TKnotsColumnValues read FAssignedValues;
    property Grid: TDCCustomTreeGrid read GetGrid;
    property Size: TPoint read FSize;
  published
    property ActualWidth:TWidth read GetActualWidth stored False;
    property Alignment: TAlignment read GetAlignment write SetAlignment stored
      IsAlignmentStored;
    property Color: TColor read GetColor write SetColor stored  IsColorStored;
    property Comment: string read GetComment write SetComment stored IsCommentStored;
    property DisplayFormat: string read FDisplayFormat write SetDisplayFormat;
    property Font: TFont read GetFont write SetFont stored IsFontStored;
    property FooterPanel: TKnotColumnFooterPanel read FFooterPanel write SetFooterPanel;
    property ItemIndex: integer read FItemIndex write SetItemIndex default -1;
    property IndexStyle: TColumnIndexStyle read FIndexStyle write SetIndexStyle default idxNone;
    property Name: string read FName write SetName;
    property Options: TKnotOptions read FOptions write SetOptions default
      [kcShowEdit, kcSizing, kcVisible, kcEllipsis];
    property Title: TKnotColumnTitle read FTitle write SetTitle;
    property VertAlignment: TVertAlignment read FVertAlignment
      write SetVertAlignment default vaCenter;
    property Width: TWidth read GetWidth write SetWidth stored IsWidthStored;
  end;

  TKnotColumns = class(TCollection)
  private
    FGrid: TDCCustomTreeGrid;
  protected
    function GetItem(Index: Integer): TKnotColumn;
    function GetOwner: TPersistent; override;
    procedure SetItem(Index: Integer; Value: TKnotColumn);
    procedure Update(Item: TCollectionItem); override;
  public
    constructor Create(AGrid: TDCCustomTreeGrid; AKnotColumnClass: TKnotColumnClass);
    function Add: TKnotColumn;
    property Grid: TDCCustomTreeGrid read FGrid;
    property Items[Index: Integer]: TKnotColumn read GetItem write SetItem; default;
  end;

{
  < 0 if Item1 is less and Item2
    0 if they are equal
  > 0 if Item1 is greater than Item2
}
  TGridSortCompare = function (Sender: TObject; Item1, Item2: Pointer;
    Data: integer): Integer;
  TKnotState = (ksBrowse, ksInsert, ksEdit, ksUpdate, ksCreate);

  TKnotItems = class;
  TKnotItem = class;
  TKnotItemClass = class of TKnotItem;

  TKnotItemUpdateAction = (kaNone, kaNormal, kaCollapse, kaExpand, kaInsert,
    kaDelete);

  TKnotItem  = class(TObject)
  private
    FFlags: WORD;
    FOwner: TKnotItems;
    FParent: TKnotItem;
    FName: string;
    FData: Pointer;
    FKnotID: integer;
    FChildKnots: TList;
    FIndex: integer;
    FNormalImage: shortint;
    FSelectImage: shortint;
    FLastIndex: integer;
    function GetChildCount: integer;
    procedure SetData(const Value: Pointer);
    procedure SetName(const Value: string);
    function GetFlagValue(const Index: Integer): boolean;
    procedure SetFlagValue(const Index: Integer; const Value: boolean);
    procedure SetValueEx(const Index: Integer; const Value: boolean);
    function GetVisibleChildCount: integer;
    function GetVisibleKnotCount: integer;
    procedure SetNormalImage(const Value: shortint);
    procedure SetSelectImage(const Value: shortint);
    function GetLevel: integer;
    procedure SetVisible(const Value: boolean);
    function GetVisible: boolean;
    function GetCapacity: integer;
    procedure SetCapacity(const Value: integer);
    function GetState: TKnotState;
  protected
    function GetChild(Index: integer): TKnotItem;
    function GetGrid: TDCCustomTreeGrid;
    function GetOwner: TKnotItems;
    function GetParent: TKnotItem;
    procedure SetChild(Index: integer; const Value: TKnotItem);
    property ChildKnots: TList read FChildKnots;
  public
    constructor Create(AOwner: TKnotItems; AParent: TKnotItem;
      AName: string); virtual;
    procedure Clear;
    procedure Collapse(Recurse: boolean);
    destructor Destroy; override;
    function DisplayRect(TextOnly: boolean): TRect;
    procedure Expand(Recurse: boolean);
    procedure EditText;
    procedure EndEdit(Cancel: boolean);
    function GetNext: TKnotItem;
    function GetNextSibling: TKnotItem;
    function GetNextVisible: TKnotItem;
    function GetNextSiblingVisible: TKnotItem;
    function GetPrev: TKnotItem;
    function GetPrevSibling: TKnotItem;
    function GetPrevVisible: TKnotItem;
    function GetPrevSiblingVisible: TKnotItem;
    property Capacity: integer read GetCapacity write SetCapacity;
    property Changed: boolean index 5 read GetFlagValue write SetFlagValue;
    property ChildCount: integer read GetChildCount;
    property Childs[Index: integer]: TKnotItem read GetChild write SetChild; default;
    property Data: Pointer read FData write SetData;
    property Enabled: boolean index 2 read GetFlagValue write SetValueEx;
    property Expanded: boolean index 0 read GetFlagValue write SetValueEx;
    property Grid: TDCCustomTreeGrid read GetGrid;
    property Owner: TKnotItems read GetOwner;
    property Index: integer read FIndex;
    property HasChildren: boolean index 3 read GetFlagValue write SetValueEx;
    property KnotID: integer read FKnotID;
    property Level: integer read GetLevel;
    property LockItems: boolean index 4 read GetFlagValue write SetFlagValue;
    property Name: string read FName write SetName;
    property NormalImage: shortint read FNormalImage write SetNormalImage;
    property Parent: TKnotItem read GetParent;
    property SelectImage: shortint read FSelectImage write SetSelectImage;
    property State: TKnotState read GetState;
    property Visible: boolean read GetVisible write SetVisible;
    property VisibleChilds: integer read GetVisibleChildCount;
    property VisibleKnotCount: integer read GetVisibleKnotCount;
  end;

  TUpdatedItem = record
    KnotAction: TKnotItemUpdateAction;
    Item: TKnotItem;
    CountItems: integer;
  end;

  TKnotItems = class(TPersistent)
  private
    FKnotItemClass: TKnotItemClass;
    FLastKnotID: integer;
    FOwner: TDCCustomTreeGrid;
    FState: TKnotState;
    FRootKnot: TKnotItem;
    FUpdateCount: integer;
    FUpdatedItem: TUpdatedItem;
    function GetCount: integer;
    function GetVisibleKnotCount: integer;
    procedure UpdateTreeGrid;
    function GetUpdatingState: boolean;
    procedure SetUpdateState(Updating: Boolean);
    procedure DeleteChildKnot(KnotItem: TKnotItem; KnotIndex: integer);
    function GetRootKnot: TKnotItem;
  protected
    function ComparePos(KnotItem1, KnotItem2: TKnotItem): integer;
    function GetItem(Index: integer): TKnotItem;
    function GetGrid: TDCCustomTreeGrid;
    procedure SetItem(Index: integer; const Value: TKnotItem);
    function AddInternalChild(ParentKnot: TKnotItem; Name: string;
      CheckChilds: boolean; Position: integer): TKnotItem;
  public
    constructor Create(AOwner: TDCCustomTreeGrid; AKnotItemClass: TKnotItemClass);
    destructor Destroy; override;
    function Add(Name: string; Position: integer = KN_ITEMONBOTTOM): TKnotItem;
    function AddChild(ParentKnot: TKnotItem; Name: string;
      Position: integer = KN_ITEMONBOTTOM): TKnotItem; virtual;
    function Delete(Knot: TKnotItem): boolean; virtual;
    procedure Move(KnotItem, DestKnot: TKnotItem;
      Position: integer = KN_ITEMONBOTTOM);
    procedure Exchange(KnotItem1, KnotItem2: TKnotItem);
    procedure Clear;
    function SelectKnot(KnotItem: TKnotItem; Offset: integer): TKnotItem;
    function GetFirstNode: TKnotItem;
    function GetFirstVisibleNode: TKnotItem;
    function GetKnot(KnotID: integer; var KnotItem: TKnotItem): boolean;
    function GetLastVisibleNode: TKnotItem;
    procedure BeginUpdate(LockScreen: boolean = False; KnotItem: TKnotItem = nil;
      UpdateAction: TKnotItemUpdateAction = kaNormal);
    procedure EndUpdate(CancelUpdate: boolean = False);
    function SetState(Value: TKnotState): boolean; virtual;
    procedure RebuildIndexes(ParentKnot: TKnotItem; FirstIndex: integer);
    procedure LockRebuilds(KnotItem: TKnotItem; Lock: boolean);
    property Owner: TDCCustomTreeGrid read FOwner;
    property Grid: TDCCustomTreeGrid read GetGrid;
    property Items[Index: integer]: TKnotItem read GetItem write SetItem;
    property Count:integer read GetCount;
    property LastKnotID: integer read FLastKnotID;
    property VisibleKnotCount: integer read GetVisibleKnotCount;
    property State: TKnotState read FState;
    property Updating: boolean read GetUpdatingState;
    property Root: TKnotItem read GetRootKnot;
    property First: TKnotItem read GetFirstNode;
  end;

  TKnotCompareProc = function (Item1, Item2: Pointer): integer of object;

  TKnotBookmarkList = class(TObject)
  private
    FList: TList;
    FGrid: TDCCustomTreeGrid;
    FCache: TKnotBookmark;
    FCacheIndex: Integer;
    FCacheFind: boolean;
    FSortItems: boolean;
    function GetCount: integer;
    procedure ListChanged;
    function GetItem(Index: Integer): TKnotBookmark;
    function Compare(const Bookmark1, Bookmark2: TKnotBookmark): Integer;
    procedure QuickSort(SortList: PPointerList; L, R: Integer;
      CompareProc: TKnotCompareProc);
    procedure AssignList(Dest, Source: TList);
  public
    constructor Create(AGrid: TDCCustomTreeGrid);
    destructor Destroy; override;
    procedure Clear;
    procedure Delete;
    procedure Save(List: TList);
    procedure Sort;
    procedure Select(Bookmark: TKnotBookmark; Value: boolean);
    procedure SelectAll;
    function Find(const Bookmark: TKnotBookmark; var Index: Integer): Boolean;
    function IndexOf(const Bookmark: TKnotBookmark): Integer;
    procedure InvalidateMarker(ARow: integer);
    function Selected(const Bookmark: TKnotBookmark): Boolean;
    procedure Load(List: TList);
    property Count: Integer read GetCount;
    property Items[Index: Integer]: TKnotBookmark read GetItem; default;
    property SortItems: boolean read FSortItems write FSortItems;
  end;

  TTreeGridOption = (tgEditing, tgAlwaysShowEditor, tgTitles, tgIndicator,
    tgColumnResize, tgColLines, tgRowLines, tgColMoving, tgRowMoving, tgTabs,
    tgRowSelect, tgAlwaysShowSelection, tgMultiSelect, tgMarker, tgTreePath,
    tgTitleClicked, tgUserRowHeight, tgRowSizing, tgHighlightRow, tgFlatButtons,
    tgTreePathResize, tgFixedLines, tgCompleteLines, tgColumnSizing, tgGrouping,
    tgTreePathCompletion, tgDoubleBuffered, tgDrawFixedLine, tgAutoSize,
    tgAdvancedSelect, tgFlatLines);

  TTreeGridOptionEx =(tgeInsertSelect, tgeIndicatorMenu, tgeMarkerMenu,
    tgeShadowSelection, tgeRightClickSelect, tgeTreeSelect, tgeShowLines,
    tgeShowButtons, tgeDrawBuffered, tgeShowTreeEdit, tgeKeepEditing,
    tgeCancelOnExit, tgeConfirmDelete);

  TTreeGridMessageType = (mtLoadData, mtEmptyColumns);

  TTreeGridOptions   = set of TTreeGridOption;
  TTreeGridOptionsEx = set of TTreeGridOptionEx;

  TTreeGridColumnEvent = procedure (Sender: TObject;
    Column: TKnotColumn) of object;
  TTreeDrawCollumnCellEvent = procedure (Sender: TObject; const Rect: TRect;
    Canvas: TCanvas; DataCol: Integer; Column: TKnotColumn; KnotItem: TKnotItem;
    State: TGridCellState) of object;
  TTreeCellTextEvent = procedure (Sender: TObject; KnotItem: TKnotItem; var
    Text: string; var DefaultDraw: boolean) of object;
  TTreeGridClickEvent = procedure (Sender: TObject; Column: TKnotColumn;
    KnotItem: TKnotItem) of object;
  TTreeGridClipEvent = procedure (Sender: TObject; X, Y : LongInt;
    var Show: boolean) of object;
  TTreeGridKnotEvent = procedure (Sender: TObject; KnotItem: TKnotItem;
    var Apply: boolean) of object;
  TTreeGridEditEvent = procedure (Sender: TObject; KnotItem: TKnotItem;
    var Edit: IDCInplaceEditor; Column: TKnotColumn; var CanCreate: boolean) of object;
  TTreeGridUpdateEvent  = procedure (Sender: TObject; KnotItem: TKnotItem;
    var Edit: IDCInplaceEditor; Column: TKnotColumn) of object;
  TTreeGridKnotDeleteEvent = procedure (KnotItem: TKnotItem;
    var Apply: boolean; ComponentState: TComponentState) of object;
  TTreeGridCommentEvent = procedure(Sender: TObject; Mode: integer;
    Column: TKnotColumn) of object;
  TTreeGridSelectKnot = procedure(Sender: TObject; KnotItem: TKnotItem) of object;
  TPaintMessageEvent = procedure(Sender: TObject; Canvas: TCanvas; ARect: TRect;
    MessageType: TTreeGridMessageType; UpdateMessage: string) of object;
  TTreeGridExpanded = procedure(Sender: TObject; KnotItem: TKnotItem) of object;
  TTreeDrawCellCanvas = procedure(Sender: TObject; Canvas: TCanvas;
    DataCol, Row: Integer; Column: TKnotColumn; KnotItem: TKnotItem;
    State: TGridCellState; var FillDrawingRect: boolean) of object;

  TTreeGridHitTest = (htNowere, htOnButton, htOnIcon, htOnStateIcon, htOnLabel);
  TTreePathOptions = set of (tpFixed, tpSolidLines, tpColLines, tpRowLines);

  TTreePathValue = (tpColor, tpFont);
  TTreePathValues = set of TTreePathValue;

  TTreePath = class(TPersistent)
  private
    FColor: TColor;
    FPosition: integer;
    FAssignedValues: TTreePathValues;
    FGrid: TDCCustomTreeGrid;
    FFont: TFont;
    FOptions: TTreePathOptions;
    function DefaultColor: TColor;
    function DefaultFont: TFont;
    function GetColor: TColor;
    function IsColorStored: Boolean;
    function IsFontStored: Boolean;
    procedure FontChanged(Sender: TObject);
    procedure SetColor(const Value: TColor);
    function GetFont: TFont;
    procedure SetFont(const Value: TFont);
    procedure SetOptions(const Value: TTreePathOptions);
  protected
    procedure Update;
    property Position: integer read FPosition;
  public
    procedure Assign(Source: TPersistent); override;
    constructor Create(AGrid: TDCCustomTreeGrid);
    destructor Destroy; override;
    procedure Invalidate;
    property AssignedValues: TTreePathValues read FAssignedValues;
    property Grid: TDCCustomTreeGrid read FGrid;
  published
    property Color: TColor read GetColor write SetColor stored
      IsColorStored;
    property Font: TFont read GetFont write SetFont stored IsFontStored;
    property Options: TTreePathOptions read FOptions write SetOptions default
      [tpFixed, tpRowLines];
  end;

  TTreeSelectedArea = class;
  TTreeSelectedItem = class(TSelectedItem)
  private
    FKnotItems: TList;
    FStartCol: integer;
    FColCount: integer;
    function GetSelectedArea: TTreeSelectedArea;
    function GetCount: integer;
    function GetKnotItem(Index: Integer): TKnotItem;
  protected
    function GetSelectRgn: HRGN; override;
    procedure Select(IncX, incY: integer; var Cell: TGridCoord); override;
    property SelectedArea: TTreeSelectedArea read GetSelectedArea;
  public
    function CellSelected(ACol: integer; KnotItem: TKnotItem): boolean;
    constructor Create(Collection: TCollection; Cell: TGridCoord); override;
    destructor Destroy; override;
    property Bookmarks[Index: Integer]: TKnotItem read GetKnotItem;
    property ColCount: integer read FColCount;
    property Count: integer read GetCount;
    property StartCol: integer read FStartCol;
  end;

  TTreeSelectedArea = class(TSelectedArea)
  private
    function GetGrid: TDCCustomTreeGrid;
    function GetItem(Index: Integer): TTreeSelectedItem;
    procedure SetItem(Index: Integer; const Value: TTreeSelectedItem);
  public
    function CellSelected(ACol: integer; KnotItem: TKnotItem): boolean;
    property Grid: TDCCustomTreeGrid read GetGrid;
    property Items[Index: Integer]: TTreeSelectedItem read GetItem write SetItem;
  end;

  TKnotClipPopup = class(TComboClipPopup)
  private
    FColType: TFixedCol;
    FColumnIndex: integer;
    function GetGrid: TDCCustomTreeGrid;
  protected
    procedure ButtonClick(Sender: TObject); override;
  public
    procedure AddButtons; override;
    procedure Hide; override;
    property ColType: TFixedCol read FColType write FColType;
    property ColumnIndex: integer read FColumnIndex write FColumnIndex;
    property Grid: TDCCustomTreeGrid read GetGrid;
  end;

  TBookmarkInfo = record
    Row: integer;
    Bookmark: TKnotBookmark;
    ActiveRecord: integer;
  end;

  TKnotColumnsClass = class of TKnotColumns;
  TKnotItemsClass = class of TKnotItems;

  TDCTreeGridInitialize = packed record
    ColumnsClass: TKnotColumnsClass;
    ColumnClass: TKnotColumnClass;
    ItemsClass: TKnotItemsClass;
    ItemClass: TKnotItemClass
  end;

  TDCGridMessageWindow = class(TDCMessageWindow)
  private
    FCell: TGridCoord;
  end;

  TDCCustomTreeGrid = class(TDCCustomGrid)
  private
    FBOF: boolean;
    FBookmarks: TKnotBookmarkList;
    FColumnFooter: TKnotColumnFooter;
    FClipDown: boolean;
    FClipPopup: TKnotClipPopup;
    FColumnCell: integer;
    FColumns: TKnotColumns;
    FCurrentCol: Integer;
    FDefaultDrawing: boolean;
    FEditorMode: boolean;
    FEditTimerID: integer;
    FEOF: boolean;
    FFirstGridCell: integer;
    FFrozenCols: integer;
    FFirstIndex: integer;
    FFirstVisible: TKnotItem;
    FGridStruct: TPolyLineStruct;
    FLineColor: TColor;
    FHintRow: integer;
    FHintWindow: TDCGridMessageWindow;
    FImageChangeLink: TChangeLink;
    FImages: TImageList;
    FIndent: integer;
    FInplaceCol: longint;
    FIInplaceEditor: IDCInplaceEditor;
    FInplaceRow: longint;
    FFixedColor: TColor;
    FFlags: DWORD;
    FKnots: TKnotItems;
    FLayoutLock: Byte;
    FMouseDownRow: integer;
    FMousePoint: TPoint;
    FOnCellClick: TTreeGridClickEvent;
    FOnCellDblClick: TTreeGridClickEvent;
    FOnClipButtonClick: TNotifyEvent;
    FOnClipClick: TTreeGridClipEvent;
    FOnCollapsed: TTreeGridExpanded;
    FOnColumnComment: TTreeGridCommentEvent;
    FOnColumnMoved: TMovedEvent;
    FOnCreateCellEdit: TTreeGridEditEvent;
    FOnDataChanged: TNotifyEvent;
    FOnDelete: TTreeGridKnotDeleteEvent;
    FOnDestroyCellEdit: TNotifyEvent;
    FOnDrawColumnCell: TTreeDrawCollumnCellEvent;
    FOnExpanded: TTreeGridExpanded;
    FOnGetDrawCellCanvas: TTreeDrawCellCanvas;
    FOnInsert: TTreeGridKnotEvent;
    FOnPaintMessage: TPaintMessageEvent;
    FOnRowMoved: TMovedEvent;
    FOnPopupMenu: TGridPopupEvent;
    FOnSelectCell: TSelectCellEvent;
    FOnSelectKnot: TTreeGridSelectKnot;
    FOnTitleClick:TTreeGridColumnEvent;
    FOnTopLeftChanged: TNotifyEvent;
    FOnTreeCellText: TTreeCellTextEvent;
    FOnUpdate: TTreeGridUpdateEvent;
    FOptions: TTreeGridOptions;
    FOptionsEx: TTreeGridOptionsEx;
    FPopupTitle: TPopupMenu;
    FReadOnly: Boolean;
    FSelectedKnot: TKnotItem;
    FSelecting: boolean;
    FSelectionAnchor: TKnotBookmark;
    FSelfChangingTitleFont: Boolean;
    FSizingIndex: integer;
    FSizingOff: integer;
    FTitleFont: TFont;
    FTitleOffset, FIndicatorOffset: Byte;
    FTreeImages: TImageList;
    FTreePathWidth: integer;
    FTreePathSizing: boolean;
    FTreePath: TTreePath;
    FUpdateLock: Byte;
    function AlwaysShowSelection: boolean;
    procedure InternalLayout;
    procedure MoveCol(RawCol, Direction: Integer);
    procedure SetOptions(Value: TTreeGridOptions);
    procedure TitleFontChanged(Sender: TObject);
    procedure DataChanged;
    function DoCancelOnMoving(AEof: boolean): boolean; virtual;
    procedure SetTitleFont(const Value: TFont);
    procedure SetTreePathWidth(const Value: integer);
    procedure SetTitleHeight;
    procedure SetClipDown(const Value: boolean);
    function GetSelectedIndex: Integer;
    procedure SetSelectedIndex(Value: Integer);
    function GetTreePathWidth: integer;
    function HideEditor: boolean;
    function Modified: boolean;
    procedure SetImages(const Value: TImageList);
    function GetHintTreeOffset(KnotItem: TKnotItem; Hint: TTreeGridHitTest): integer;
    procedure SetPopupTitle(const Value: TPopupMenu);
    procedure MarkKnot;
    procedure NextRow(Select: Boolean; Insert: boolean; Shift: TShiftState;
      AOffset: integer = 1);
    procedure PrevRow(Select: Boolean; Shift: TShiftState; AOffset: integer = 1);
    procedure ClearSelection;
    procedure ImageListChange(Sender: TObject);
    procedure SetSelectedKnot(KnotItem: TKnotItem);
    procedure SetSelected(const Value: TKnotItem);
    function GetPosition: TKnotBookmark;
    procedure SetPosition(const Value: TKnotBookmark);
    function GetTreeLableOffset(KnotItem: TKnotItem): integer;
    procedure FreeEditTimer;
    function CalcMaxTopLeft(const Coord: TGridCoord;
      const DrawInfo: TGridDrawInfo): TGridCoord;
    function CanModifyHScrollBar(ScrollBar, ScrollCode, Pos: Cardinal;
      UseRightToLeft: Boolean; var NewLeft: integer): boolean;
    procedure SetOptionsEx(const Value: TTreeGridOptionsEx);
    procedure SetIndent(const Value: integer);
    procedure SetColumnFooter(const Value: TKnotColumnFooter);
    procedure SetTreePath(const Value: TTreePath);
    function GetSelectedArea: TTreeSelectedArea;
    function GetFrozenCols: Integer;
    procedure SetFrozenCols(const Value: Integer);
    procedure SetFixedColor(const Value: TColor);
    function GetKnotsUpdating: boolean;
    function DrawBuffered: boolean;
    function GetTitleMenuRect(ARect: TRect; var MenuRect: TRect): boolean;
    procedure SetLineColor(const Value: TColor);
  protected
    FCurrentPos: array[1..2] of TBookmarkInfo;
    procedure ActivateBuffers; virtual;
    function  AcquireLayoutLock: Boolean;
    procedure BeginLayout; override;
    procedure BeginUpdate;
    function BOF: boolean; virtual;
    function BoxRectEx(ALeft, ATop, ARight, ABottom: Longint): TRect; override;
    procedure CalcSizingState(X, Y: Integer; var State: TGridState;
      var Index: Longint; var SizingPos, SizingOfs: Integer;
      var FixedInfo: TGridDrawInfo); override;
    procedure CancelLayout;
    function CanColResize(ACol: integer): boolean; override;
    function CanEditModify: Boolean; override;
    function CanInplaceEditShow: Boolean; virtual;
    function CanEditShow: Boolean; override;
    procedure CellClick(Column: TKnotColumn); dynamic;
    procedure CellDblClick(ColType: TFixedCol; Column: TKnotColumn); dynamic;
    procedure ClearBookmarkData(Bookmark: TKnotBookmark); virtual;
    procedure ClearBuffers; virtual;
    procedure ClipClick(AColType: TFixedCol; ACol: integer); dynamic;
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure CMExit(var Message: TMessage); message CM_EXIT;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure CMColorChanged(var Message: TMessage); message CM_COLORCHANGED;
    procedure CMHintActivate(var Message: TMessage); message CM_HINTACTIVATE;
    procedure CMHookMessage(var Message: TMessage); message CM_HOOKMESSAGE;
    procedure CMInvalidValue(var Message: TMessage); message CM_INVALIDVALUE;
    procedure CMKnotChanged(var Message: TMessage); message CM_KNOTCHANGED;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure CMParentFontChanged(var Message: TMessage); message CM_PARENTFONTCHANGED;
    procedure CMPopupHintInfo(var Message: TMessage); message CM_POPUPHINTINFO;
    procedure CMPopupWindowShow(var Message: TMessage); message CM_POPUPWINDOWSHOW;
    procedure CMWantSpecialKey(var Msg: TCMWantSpecialKey); message CM_WANTSPECIALKEY;
    procedure ColumnMoved(FromIndex, ToIndex: Longint); override;
    procedure ColWidthsChanged; override;
    function CompareBookmarks(Item1, Item2: Pointer): integer; virtual;
    procedure CreateParams(var Params: TCreateParams); override;
    function CreateSelectedArea: TSelectedArea; override;
    procedure CreateWnd; override;
    function CurrentBookmark: TKnotBookmark;
    function  DataToRawColumn(ACol: Integer): Integer; override;
    function DataVisible: boolean; override;
    procedure DblClick; override;
    procedure DeferLayout;
    function DeletePrompt: boolean; virtual;
    procedure DeleteSelectedRecords; virtual;
    procedure DeleteRecords(AtOnce: boolean);
    procedure DoClick(Sender: TObject); override;
    procedure DoEndDrawCell(Data: Pointer); virtual;
    procedure DoEndInternalLayout(Data: Pointer); virtual;
    function DoBeginDrawCell: Pointer; virtual;
    function DoBeginInternalLayout: Pointer; virtual;
    procedure DoCollapse(KnotItem: TKnotItem); dynamic;
    procedure DoColumnClick(Shift: TShiftState; ColIndex: integer); override;
    procedure DoColumnComment(Mode: integer; Column: TKnotColumn); virtual;
    procedure DoCreateCellEdit(Column: TKnotColumn;
      var Edit: IDCInplaceEditor; var CanCreate: boolean); virtual;
    procedure DoDataChanged; virtual;
    procedure DoDelete(KnotItem: TKnotItem; var Apply: boolean;
      ComponentState: TComponentState); virtual;
    procedure DoDestroyCellEdit; virtual;
    procedure DoDrawColumnCell(Canvas: TCanvas; ARect: TRect; ACol: integer;
      AColumn: TKnotColumn; AKnot: TKnotItem; AState: TGridCellState); virtual;
    procedure DoExpand(KnotItem: TKnotItem); dynamic;
    procedure DoInsert(KnotItem: TKnotItem; var Apply: boolean); virtual;
    function DoMouseWheelDown(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    function DoMouseWheelUp(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    procedure DoSelectCell(Sender: TObject; ACol, ARow: Longint;
      var CanSelect: Boolean); virtual;
    procedure DoSelection(Select: Boolean; Shift: TShiftState;
      Direction, Offset: Integer);
    procedure DoUpdate(KnotItem: TKnotItem; var Edit: IDCInplaceEditor;
      Column: TKnotColumn); virtual;
    procedure DrawCell(ACol, ARow: Longint; ARect: TRect;
      AState: TGridDrawState); override;
    procedure DrawSizingLineEx(const DrawInfo: TGridDrawInfo;
      AGridState : TGridState; X, Y: integer);
    function DrawTitleCell(ACanvas: TCanvas; ACol, ARow: Integer; ARect: TRect;
      BorderState: TDrawBorerState; AFillRect, ADraw: boolean): TPoint; override;
    procedure DrawTitlePopup(ACanvas: TCanvas; ARect: TRect;
      BorderState: TDrawBorerState; DrawColumn: TKnotColumn);
    procedure EndLayout; override;
    function EOF: boolean; virtual;
    procedure EndUpdate;
    procedure First; virtual;
    function FirstSelectCol: integer;
    function FlatButtons: boolean; override;
    function GetAllFrozenCols: integer;
    function GetBookmark(KnotItem: TKnotItem): TKnotBookmark; virtual;
    function GetBorderStyle: TEdgeBorderStyle; override;
    function GetClientRect: TRect; override;
    function GetCellByType(AColType: TFixedCol): integer;
    function GetColumns: TKnotColumns;
    procedure GetConnectionPos(var X, Y: integer; var AWidth: integer;
      var Position: TPopupPosition); override;
    function GetKnots: TKnotItems;
    function GetPopupMenu: TPopupMenu; override;
    function GetRealColWidth(ColIndex: integer): integer; override;
    function GetRowCount: integer; virtual;
    function GetRowUpdateRgn(ARow: integer): HRGN; virtual;
    function GetRecordCount: integer; virtual;
    function GetSelectedKnot: TKnotItem;
    function GetTopLeft: TGridCoord;
    function GetTreePathCaption(KnotItem: TKnotItem; var Text: string): boolean; virtual;
    procedure GetVertScrollInfo(var ScrollInfo: TScrollInfo); virtual;
    procedure GotoBookmark(BookmarkInfo: TBookmarkInfo); virtual;
    procedure GroupBoxChanged; override;
    procedure HideHintWindow;
    function HideVertScrollBar: boolean; virtual;
    function  HighlightCell(DataCol, DataRow: Integer;
      AState: TGridDrawState; KnotItem: TKnotItem; Focused: boolean): Boolean; virtual;
    procedure HookMessage(wParam: Longint; var Msg: TMsg); virtual;
    function Initialize: TDCTreeGridInitialize; virtual;
    procedure InsertKnot(lChild: boolean; Shift: TShiftState); virtual;
    procedure InvalidateTitles(AtOnce: boolean = False);
    procedure InvalidateSelected;
    function IsActiveControl: Boolean; override;
    procedure KnotNotification(KnotItem: TKnotItem;
      Operation: TKnotOperation); virtual;
    procedure Last; virtual;
    procedure LayoutChanged; virtual;
    procedure Loaded; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MoveBy(Offset: integer); virtual;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    function ResizeColWidth(ACol, AWidth: integer): boolean; override;
    procedure RowMoved(FromIndex, ToIndex: Longint); override;
    procedure SelectAll; virtual;
    function SelectCell(ACol, ARow: Longint): Boolean; override;
    procedure SetColumnAttributes; virtual;
    procedure SetColumns(const Value: TKnotColumns);
    procedure SetKnots(const Value: TKnotItems);
    procedure SetInternalCol(Value: integer; Lock: boolean); override;
    procedure SetInternalRow(Value: integer);
    procedure SetInternalRowCount(Value: integer);
    procedure ShowHintWindow(CellX, CellY, PosX, PosY: integer; Text: string);
    function ShowEditorChar(Ch: Char): boolean;
    procedure SizeChanged(OldColCount, OldRowCount: Longint); override;
    procedure TitleClick(Column: TKnotColumn); dynamic;
    procedure TopLeftChanged; override;
    function VertScrollBarVisible: boolean; virtual;
    function ValidBookmark(Bookmark: TKnotBookmark): boolean; virtual;
    procedure UpdateActive; virtual;
    procedure UpdateData; virtual;
    procedure UpdateFrozenCols(const Value: integer);
    procedure UpdateInplaceEditor;
    procedure UpdateVertScrollBar;
    procedure UpdateHorzScrollPos;
    function UpdateRowCount: boolean; override;
    procedure WMChar(var Msg: TWMChar); message WM_CHAR;
    procedure WMEraseBkgnd(var Message: TWmEraseBkgnd); message WM_ERASEBKGND;
    procedure WMKeyDown(var Message: TWMKeyDown); message WM_KEYDOWN;
    procedure WMKillFocus(var Message: TMessage); message WM_KillFocus;
    procedure WMHScroll(var Message: TWMHScroll); message WM_HSCROLL;
    procedure WMNCCalcSize(var Message: TWMNCCalcSize); message WM_NCCALCSIZE;
    procedure WMNCLButtonDown(var Message: TWMNCLButtonDown); message WM_NCLBUTTONDOWN;
    procedure WMNCPaint(var Message: TMessage); message WM_NCPAINT;
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
    procedure WMSetCursor(var Msg: TWMSetCursor); message WM_SETCURSOR;
    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SetFOCUS;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure WMVScroll(var Message: TWMVScroll); message WM_VSCROLL;
    procedure WMTimer(var Msg: TWMTimer); message WM_TIMER;
    property DefaultDrawing: Boolean read FDefaultDrawing write FDefaultDrawing default True;
    property IndicatorOffset: Byte read FIndicatorOffset;
    property Indent: integer read FIndent write SetIndent;
    property FrozenCols: Integer read GetFrozenCols write SetFrozenCols default 0;
    property FixedColor: TColor read FFixedColor write SetFixedColor default clBtnFace;
    property Footer: TKnotColumnFooter read FColumnFooter write SetColumnFooter;
    property Knots: TKnotItems read GetKnots write SetKnots;
    property KnotsUpdating: boolean read GetKnotsUpdating;
    property LayoutLock: Byte read FLayoutLock;
    property LineColor: TColor read FLineColor write SetLineColor;
    property OnColumnMoved: TMovedEvent read FOnColumnMoved write FOnColumnMoved;
    property OnCellClick: TTreeGridClickEvent read FOnCellClick write FOnCellClick;
    property OnCellDblClick: TTreeGridClickEvent read FOnCellDblClick
      write FOnCellDblClick;
    property OnClipButtonClick: TNotifyEvent read FOnClipButtonClick
      write FOnClipButtonClick;
    property OnClipClick: TTreeGridClipEvent read FOnClipClick write FOnClipClick;
    property OnCollapsed: TTreeGridExpanded read FOnCollapsed write FOnCollapsed;
    property OnColumnComment: TTreeGridCommentEvent read FOnColumnComment
      write FOnColumnComment;
    property OnCreateCellEdit: TTreeGridEditEvent read FOnCreateCellEdit
      write FOnCreateCellEdit;
    property OnDataChanged: TNotifyEvent read FOnDataChanged write FOnDataChanged;
    property OnDelete: TTreeGridKnotDeleteEvent read FOnDelete write FOnDelete;
    property OnDestroyCellEdit: TNotifyEvent read FOnDestroyCellEdit
      write FOnDestroyCellEdit;
    property OnDrawColumnCell: TTreeDrawCollumnCellEvent read FOnDrawColumnCell
      write FOnDrawColumnCell;
    property OnGetDrawCellCanvas: TTreeDrawCellCanvas read FOnGetDrawCellCanvas
      write FOnGetDrawCellCanvas;
    property OnExpanded: TTreeGridExpanded read FOnExpanded write FOnExpanded;
    property OnInsert: TTreeGridKnotEvent read FOnInsert write FOnInsert;
    property OnPaintMessage: TPaintMessageEvent read FOnPaintMessage
      write FOnPaintMessage;
    property OnPopupMenu: TGridPopupEvent read FOnPopupMenu write FOnPopupMenu;
    property OnRowMoved: TMovedEvent read FOnRowMoved write FOnRowMoved;
    property OnSelectCell: TSelectCellEvent read FOnSelectCell write FOnSelectCell;
    property OnSelectKnot: TTreeGridSelectKnot read FOnSelectKnot write FOnSelectKnot;
    property OnTopLeftChanged: TNotifyEvent read FOnTopLeftChanged
      write FOnTopLeftChanged;
    property OnTitleClick: TTreeGridColumnEvent read FOnTitleClick
      write FOnTitleClick;
    property OnTreeCellText: TTreeCellTextEvent read FOnTreeCellText
      write FOnTreeCellText;
    property OnUpdate: TTreeGridUpdateEvent read FOnUpdate write FOnUpdate;
    property Options: TTreeGridOptions read FOptions write SetOptions
      default [tgEditing, tgTitles, tgIndicator, tgColumnResize, tgColLines,
      tgRowLines, tgTabs, tgTreePathResize, tgFixedLines, tgColMoving];
    property OptionsEx: TTreeGridOptionsEx read FOptionsEx write SetOptionsEx
      default [tgeInsertSelect, tgeMarkerMenu, tgeIndicatorMenu,
        tgeShadowSelection, tgeShowButtons, tgeDrawBuffered, tgeConfirmDelete,
        tgeCancelOnExit];
    property PopupTitle: TPopupMenu read FPopupTitle write SetPopupTitle;
    property ReadOnly: Boolean read FReadOnly write FReadOnly default False;
    property RowModified: boolean read Modified;
    property SelectedArea: TTreeSelectedArea read GetSelectedArea;
    property SelectedRows: TKnotBookmarkList read FBookmarks;
    property SelectedKnot: TKnotItem read GetSelectedKnot write SetSelected;
    property SelectedIndex: Integer read GetSelectedIndex write SetSelectedIndex;
    property TitleFont: TFont read FTitleFont write SetTitleFont;
    property TreePath: TTreePath read FTreePath write SetTreePath;
    property TreePathWidth: integer read GetTreePathWidth write SetTreepathWidth;
    property UpdateLock: Byte read FUpdateLock;
  public
    {$IFDEF DELPHI_V5UP}
      function CanFocus: boolean; override;
    {$ENDIF}
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure RowHeightsChanged; override;
    function GetFixedColType(ACol, AOffset: integer): TFixedCol; override;
    function GetFixedRowType(ARow, AOffset: integer): TFixedRow; override;
    function GetHitTestInfoAt(KnotItem: TKnotItem; X,Y: integer): TTreeGridHitTest;
    function GetGridHitTest(X, Y: integer): TGridHitTest; override;
    function GetKnotByCell(ARow: integer): TKnotItem; virtual;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure ShowClipPopup(AColType: TFixedCol; ACol: integer;
      AClipPopup: TObject); virtual;
    procedure HideClipPopup; override;
    procedure Paint; override;
    procedure SetFocus; override;
    procedure SetModified(Value: boolean);
    procedure ShowEditor;
    procedure ShowTreePathEditor;
    procedure SavePosition; virtual;
    function RawToDataColumn(ACol: Integer): Integer; override;
    function RawToDataRow(ARow: integer): integer; override;
    procedure RestPosition;
    procedure SelectItems(Mode: TSelectMode);
    procedure Sort(Level: integer; Compare: TGridSortCompare; Data: integer);
    function GroupingEnabled: boolean; override;
    property ColumnFooter: TKnotColumnFooter read FColumnFooter;
    property Columns: TKnotColumns read GetColumns write SetColumns;
    property ClipDown: boolean read FClipDown write SetClipDown;
    property Font;
    property Images: TImageList read FImages write SetImages;
    property EditorMode: boolean read FEditorMode;
    property Position: TKnotBookmark read GetPosition write SetPosition;
  end;

  TDCTreeGrid = class(TDCCustomTreeGrid)
  public
    property Canvas;
    property Knots;
    property ScrollBars;
    property SelectedArea;
    property SelectedRows;
    property SelectedKnot;
    property SelectedIndex;
    property Col;
    property Row;
    property RowCount;
    property ColCount;
    property RowModified;
    property GroupBox;
  published
    property Align;
    property Anchors;
    property BiDiMode;
    property BorderStyle;
    property Color;
    property Columns;
    property Constraints;
    property Ctl3D;
    property DefaultDrawing;
    property DefaultRowHeight;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property FixedColor;
    property FrozenCols;
    property Font;
    property Footer;
    property GridDrawing;
    property Indent;
    property Images;
    property OnColumnMoved;
    property OnBookmarksChanged;
    property OnDataChanged;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnCellClick;
    property OnCellDblClick;
    property OnTitleClick;
    property OnClipClick;
    property OnDelete;
    property OnInsert;
    property OnUpdate;
    property OnDrawColumnCell;
    property OnTreeCellText;
    property OnRowMoved;
    property OnSelectCell;
    property OnTopLeftChanged;
    property OnCreateCellEdit;
    property OnDestroyCellEdit;
    property OnClipButtonClick;
    property OnColumnComment;
    property OnGetDrawCellCanvas;
    property OnSelectKnot;
    property OnStartDock;
    property OnStartDrag;
    property OnPaintMessage;
    property OnPopupMenu;
    property OnExpanded;
    property OnCollapsed;
    property OnGroupBoxInsert;
    property OnGroupBoxRemove;
    property OnGroupBoxMove;
    property Options;
    property OptionsEx;
    property ParentBiDiMode;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property PopupTitle;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property TreePath;
    property TreePathWidth;
    property Visible;
  end;

  {Inplace Editors}
  TSelection = record
    StartPos, EndPos: Integer;
  end;

  TDCInplaceChoiceEdit = class(TDCChoiceEdit, IDCInplaceEditor)
  private
    FGrid: TDCCustomTreeGrid;
  protected
    procedure CMWantSpecialKey(var Msg: TCMWantSpecialKey); message CM_WANTSPECIALKEY;
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    function GetEditType: TInplaceEditType;
    function GetGrid: TDCCustomTreeGrid;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
    procedure SetGrid(Value: TDCCustomTreeGrid);
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure WMKillFocus(var Message: TMessage); message WM_KillFocus;
    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SetFOCUS;
  public
    constructor Create(AOwner: TComponent); override;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure KillFocus(var Value: boolean); override;
    procedure ChoiceClick(Sender:TObject); override;
    property EditType: TInplaceEditType read GetEditType;
    property Grid: TDCCustomTreeGrid read GetGrid write SetGrid;
  end;

  TDCInplaceDateEdit = class(TDCDateEdit, IDCInplaceEditor)
  private
    FGrid: TDCCustomTreeGrid;
  protected
    procedure CMWantSpecialKey(var Msg: TCMWantSpecialKey); message CM_WANTSPECIALKEY;
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    function GetEditType: TInplaceEditType;
    function GetGrid: TDCCustomTreeGrid;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
    procedure SetGrid(Value: TDCCustomTreeGrid);
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure WMKillFocus(var Message: TMessage); message WM_KillFocus;
    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SetFOCUS;
  public
    constructor Create(AOwner: TComponent); override;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure KillFocus(var Value: boolean); override;
    procedure ChoiceClick(Sender:TObject); override;
    property EditType: TInplaceEditType read GetEditType;
    property Grid: TDCCustomTreeGrid read GetGrid write SetGrid;
  end;

  TDCInplaceFloatEdit = class(TDCFloatEdit, IDCInplaceEditor)
  private
    FGrid: TDCCustomTreeGrid;
  protected
    procedure CMWantSpecialKey(var Msg: TCMWantSpecialKey); message CM_WANTSPECIALKEY;
    function GetGrid: TDCCustomTreeGrid;
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
    function GetEditType: TInplaceEditType;
    procedure SetGrid(Value: TDCCustomTreeGrid);
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure WMKillFocus(var Message: TMessage); message WM_KillFocus;
    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SetFOCUS;
  public
    constructor Create(AOwner: TComponent); override;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure KillFocus(var Value: boolean); override;
    procedure ChoiceClick(Sender:TObject); override;
    property EditType: TInplaceEditType read GetEditType;
    property Grid: TDCCustomTreeGrid read GetGrid write SetGrid;
  end;

  TDCInplaceGridEdit = class(TDCGridEdit, IDCInplaceEditor)
  private
    FGrid: TDCCustomTreeGrid;
  protected
    procedure CMWantSpecialKey(var Msg: TCMWantSpecialKey); message CM_WANTSPECIALKEY;
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    function GetEditType: TInplaceEditType;
    function GetGrid: TDCCustomTreeGrid;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
    procedure SetGrid(Value: TDCCustomTreeGrid);
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure WMKillFocus(var Message: TMessage); message WM_KillFocus;
    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SetFOCUS;
  public
    constructor Create(AOwner: TComponent); override;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure KillFocus(var Value: boolean); override;
    procedure ChoiceClick(Sender:TObject); override;
    property EditType: TInplaceEditType read GetEditType;
    property Grid: TDCCustomTreeGrid read GetGrid write SetGrid;
  end;

  TDCInplaceTreeEdit = class(TDCTreeEdit, IDCInplaceEditor)
  private
    FGrid: TDCCustomTreeGrid;
  protected
    procedure CMWantSpecialKey(var Msg: TCMWantSpecialKey); message CM_WANTSPECIALKEY;
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    function GetGrid: TDCCustomTreeGrid;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
    function GetEditType: TInplaceEditType;
    procedure SetGrid(Value: TDCCustomTreeGrid);
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure WMKillFocus(var Message: TMessage); message WM_KillFocus;
    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SetFOCUS;
  public
    constructor Create(AOwner: TComponent); override;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure KillFocus(var Value: boolean); override;
    procedure ChoiceClick(Sender:TObject); override;
    property EditType: TInplaceEditType read GetEditType;
    property Grid: TDCCustomTreeGrid read GetGrid write SetGrid;
  end;

  TDCInplaceComboBox = class(TDCComboBox, IDCInplaceEditor)
  private
    FGrid: TDCCustomTreeGrid;
  protected
    procedure CMWantSpecialKey(var Msg: TCMWantSpecialKey); message CM_WANTSPECIALKEY;
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    function GetEditType: TInplaceEditType;
    function GetGrid: TDCCustomTreeGrid;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
    procedure SetGrid(Value: TDCCustomTreeGrid);
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure WMKillFocus(var Message: TMessage); message WM_KillFocus;
    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SetFOCUS;
  public
    constructor Create(AOwner: TComponent); override;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure KillFocus(var Value: boolean); override;
    procedure ChoiceClick(Sender:TObject); override;
    property EditType: TInplaceEditType read GetEditType;
    property Grid: TDCCustomTreeGrid read GetGrid write SetGrid;
  end;

{$IFDEF ADO_EXPRESS}
  TDCInplaceADOGridEdit = class(TDCADOGridEdit, IDCInplaceEditor)
  private
    FGrid: TDCCustomTreeGrid;
  protected
    procedure CMWantSpecialKey(var Msg: TCMWantSpecialKey); message CM_WANTSPECIALKEY;
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    function GetEditType: TInplaceEditType;
    function GetGrid: TDCCustomTreeGrid;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
    procedure SetGrid(Value: TDCCustomTreeGrid);
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure WMKillFocus(var Message: TMessage); message WM_KillFocus;
    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SetFOCUS;
  public
    constructor Create(AOwner: TComponent); override;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure KillFocus(var Value: boolean); override;
    procedure ChoiceClick(Sender:TObject); override;
    property EditType: TInplaceEditType read GetEditType;
    property Grid: TDCCustomTreeGrid read GetGrid write SetGrid;
  end;
{$ENDIF}

implementation
uses
  DCEditButton;
{$R *.RES}

const
  NE_EMPTY_KNOT = '$Empty Knot';
  NE_ROOT_KNOT  = '$DC.sp_ROOT';
  TreeIconWidth = 20;

const
  bmExpand     = 'DC_TGEXPAND'    ; nbmExpand     = 0;
  bmCollapse   = 'DC_TGCOLLAPSE'  ; nbmCollapse   = 1;
  bmExpandR    = 'DC_TGEXPANDR'   ; nbmExpandR    = 2;
  bmCollapseR  = 'DC_TGCOLLAPSER' ; nbmCollapseR  = 3;

  pmSelectAll   = 0;
  pmDeselectAll = 1;

  TGF_ISDATAMODIFIED   = $1;
  TGF_ISESCKEYPRESS    = $2;
  TGF_ROWHEIGHTCHANGED = $3;
  TGF_LOCKSCROLL       = $4;
  TGF_LOCKSCREEN       = $5;
  TGF_ROWUPDATED       = $6;

var
  DrawBitmap, TempBitmap: TBitmap;
  UserCount: Integer;

function LongMulDiv(Mult1, Mult2, Div1: Longint): Longint; stdcall;
  external 'kernel32.dll' name 'MulDiv';

procedure UsesBitmap;
begin
  if UserCount = 0 then
  begin
    DrawBitmap := TBitmap.Create;
    TempBitmap := TBitmap.Create;
  end;
  Inc(UserCount);
end;

procedure ReleaseBitmap;
begin
  Dec(UserCount);
  if UserCount = 0 then
  begin
    FreeAndNil(DrawBitmap);
    FreeAndNil(TempBitmap);
  end;
end;

procedure KillMessage(Wnd: HWnd; Msg: Integer);
// Delete the requested message from the queue, but throw back
// any WM_QUIT msgs that PeekMessage may also return
var
  M: TMsg;
begin
  M.Message := 0;
  if PeekMessage(M, Wnd, Msg, Msg, pm_Remove) and (M.Message = WM_QUIT) then
    PostQuitMessage(M.wparam);
end;

procedure InplaceUpdateLoc(Sender: IDCInplaceEditor; R: TRect; ACanvas: TCanvas);
begin
  with Sender do
  begin
    if DrawStyle <> fsNone then InflateRect(R, 1, 1);
    SetBounds(R.Left, R.Top, R.Right-R.Left, R.Bottom-R.Top);
    Show;
    Invalidate;
    Windows.SetFocus(Handle);
  end;
end;

procedure InplaceKeyDown(Sender:  IDCInplaceEditor; Grid: TDCCustomTreeGrid;
  var Key: Word; Shift: TShiftState);

  procedure SendToParent(Clear: boolean);
  begin
    Grid.KeyDown(Key, Shift);
    if Clear then Key := 0;
  end;

  procedure ParentEvent;
  var
    GridKeyDown: TKeyEvent;
  begin
    if Assigned(Grid) then
    begin
      GridKeyDown := Grid.OnKeyDown;
      if Assigned(GridKeyDown) then GridKeyDown(Grid, Key, Shift);
    end;
  end;

  function ForwardMoveCtrl(Value: boolean): Boolean;
  begin
    Result := (tgAlwaysShowEditor in Grid.Options) and
      ((ssCtrl in Shift) or Value);
  end;

  function Selection: TSelection;
  begin
    SendMessage(Sender.Handle, EM_GETSEL, Longint(@Result.StartPos),
      Longint(@Result.EndPos));
  end;

  function RightSide: Boolean;
  begin
    with Selection do
      Result := ((StartPos = 0) or (EndPos = StartPos)) and
        (EndPos = Sender.GetTextLen);
  end;

  function LeftSide: Boolean;
  begin
    with Selection do
      Result := (StartPos = 0) and ((EndPos = 0) or (EndPos = Sender.GetTextLen));
  end;

begin
  case Key of
    VK_UP, VK_DOWN, VK_PRIOR, VK_NEXT:
      if not(ssAlt in Shift) then SendToParent(True);
    VK_ESCAPE: SendToParent(True);
    VK_INSERT:
      if Shift = [] then
        SendToParent(False)
      else
        if (Shift = [ssShift]) and not Grid.CanEditModify then Key := 0;
    VK_LEFT:
      if ForwardMoveCtrl(LeftSide) then SendToParent(False);
    VK_RIGHT:
      if ForwardMoveCtrl(RightSide) then SendToParent(False);
    VK_HOME:
      if ForwardMoveCtrl(LeftSide) then SendToParent(False);
    VK_END:
      if ForwardMoveCtrl(RightSide) then SendToParent(False);
    VK_F2:
      begin
        ParentEvent;
        if Key = VK_F2 then
        begin
          Sender.Deselect;
          Exit;
        end;
      end;
    VK_TAB:
      if not(ssAlt in Shift) then SendToParent(True);
  end;
  if (Key = VK_DELETE) and not Grid.CanEditModify then Key := 0;
  if Key <> 0 then ParentEvent;
end;

{ TKnotColumn }
procedure TKnotColumn.Assign(Source: TPersistent);
begin
  if Source is TKnotColumn then
  begin
    if Assigned(Collection) then Collection.BeginUpdate;
    try
      RestoreDefaults;
      Name := TKnotColumn(Source).Name;
      if cvColor in TKnotColumn(Source).AssignedValues then
        Color := TKnotColumn(Source).Color;
      if cvWidth in TKnotColumn(Source).AssignedValues then
      begin
        FWidth := TKnotColumn(Source).FWidth;
        FAssignedValues := FAssignedValues + [cvWidth];
      end;
      if cvFont in TKnotColumn(Source).AssignedValues then
        FFont := TKnotColumn(Source).Font;
      if cvAlignment in TKnotColumn(Source).AssignedValues then
        FAlignment := TKnotColumn(Source).Alignment;
      FTitle := TKnotColumn(Source).Title;
      FOptions := TKnotColumn(Source).Options;
      FItemIndex:= TKnotColumn(Source).ItemIndex;
      FDisplayFormat := TKnotColumn(Source).DisplayFormat;
      FooterPanel.Visible := TKnotColumn(Source).FooterPanel.Visible;
      FooterPanel.Text := TKnotColumn(Source).FooterPanel.Text;
      FVertAlignment := TKnotColumn(Source).FVertAlignment;
    finally
      if Assigned(Collection) then Collection.EndUpdate;
    end;
  end
  else
    inherited Assign(Source);
end;

constructor TKnotColumn.Create(Collection: TCollection);
var
  Grid: TDCCustomTreeGrid;
begin
  Grid := nil;
  if Assigned(Collection) and (Collection is TKnotColumns) then
    Grid := TKnotColumns(Collection).Grid;
  if Assigned(Grid) then Grid.BeginLayout;
  try
    inherited Create(Collection);
    FWidth := 50;
    FAlignment := taLeftJustify;
    FItemIndex := -1;
    FFont := TFont.Create;
    FFont.Assign(DefaultFont);
    FFont.OnChange := FontChanged;
    FTitle   := TKnotColumnTitle.Create(Self);
    FOptions := [kcVisible, kcShowEdit, kcSizing, kcEllipsis];
    FVertAlignment := vaCenter;
    if Assigned(Grid) and Assigned(Grid.ColumnFooter) then
      FFooterPanel := TKnotColumnFooterPanel.Create(Grid.ColumnFooter.Panels)
    else
      FFooterPanel := TKnotColumnFooterPanel.Create(nil);
    FFooterPanel.FColumn := Self;
  finally
    if Assigned(Grid) then
    begin
      Grid.EndLayout;
      if tgAutoSize in Grid.Options then Grid.Perform(CM_SHOWINGCHANGED, 0, 0);
    end
  end;
end;

function TKnotColumn.DefaultAlignment: TAlignment;
begin
  Result := taLeftJustify;
end;

function TKnotColumn.DefaultColor: TColor;
begin
  if Assigned(Grid) then
    Result := Grid.Color
  else
    Result := clWindow;
end;

function TKnotColumn.DefaultFont: TFont;
begin
  if Assigned(Grid) then
    Result := Grid.Font
  else
    Result := FFont;
end;

function TKnotColumn.DefaultWidth: Integer;
 var
  RestoreCanvas: Boolean;
  R: TRect;
  P: TPoint;
  W: integer;
  TM: TTextMetric;
begin
  if Assigned(Grid) then with Grid do
  begin
    Result := Grid.DefaultColWidth;
    RestoreCanvas := not(HandleAllocated and GetTextMetrics(Canvas.Handle, TM));
    if RestoreCanvas then Canvas.Handle := GetDC(0);
    try
      if tgTitles in Options then
      begin
        Canvas.Font := Title.Font;
        R := Rect(0, 0, ClientWidth, ClientHeight);
        P := DrawTitleCell(Canvas, Index, 0, R, dsUp, False, False);
        W := P.X;
        if Result < W then  Result := W;
      end;
    finally
      if RestoreCanvas then with Canvas do
      begin
        ReleaseDC(0, Handle);
        Handle := 0;
      end;
    end;
  end
  else
    Result := 64;
end;

destructor TKnotColumn.Destroy;
begin
  FreeAndNil(FFooterPanel);
  FreeAndNil(FTitle);
  FreeAndNil(FFont);
  inherited Destroy;
end;

procedure TKnotColumn.FontChanged(Sender: TObject);
begin
  Include(FAssignedValues, cvFont);
  Title.RefreshDefaultFont;
  Changed(False);
end;

function TKnotColumn.GetAlignment: TAlignment;
begin
  if cvAlignment in FAssignedValues then
    Result := FAlignment
  else
    Result := DefaultAlignment;
end;

function TKnotColumn.GetColor: TColor;
begin
  if cvColor in FAssignedValues then
    Result := FColor
  else
    Result := DefaultColor;
end;

function TKnotColumn.GetDisplayName: string;
begin
  Result := FTitle.Caption;
  if Result = '' then Result := ClassName;
end;

function TKnotColumn.GetFont: TFont;
var
  SavedNotify: TNotifyEvent;
begin
  if not (cvFont in FAssignedValues) and (FFont.Handle <> DefaultFont.Handle) then
  begin
    SavedNotify := FFont.OnChange;
    FFont.OnChange := nil;
    FFont.Assign(DefaultFont);
    FFont.OnChange := SavedNotify;
  end;
  Result := FFont;
end;

function TKnotColumn.GetGrid: TDCCustomTreeGrid;
begin
  if Assigned(Collection) and (Collection is TKnotColumns) then
    Result := TKnotColumns(Collection).Grid
  else
    Result := nil;
end;

function TKnotColumn.GetWidth: TWidth;
begin
  if not((kcVisible in Options) or
    (Grid <> nil) and (csWriting in Grid.ComponentState)) then
  begin
    if (Grid <> nil) and
      (not(tgColLines in Grid.Options) or (tgFlatLines in Grid.Options)) then
      Result := 0
    else
      Result := -1
  end
  else
   Result := GetStoredWidth;
end;

function TKnotColumn.IsAlignmentStored: Boolean;
begin
  Result := (cvAlignment in FAssignedValues) and (FAlignment <> DefaultAlignment);
end;

function TKnotColumn.IsColorStored: Boolean;
begin
  Result := (cvColor in FAssignedValues) and (FColor <> DefaultColor);
end;

function TKnotColumn.IsFontStored: Boolean;
begin
  Result := (cvFont in FAssignedValues) and (Font <> DefaultFont);
end;

function TKnotColumn.IsWidthStored: Boolean;
begin
  Result := (cvWidth in FAssignedValues) and (FWidth <> DefaultWidth);
end;

procedure TKnotColumn.RefreshDefaultFont;
var
  Save: TNotifyEvent;
begin
  if cvFont in FAssignedValues then Exit;
  Save := FFont.OnChange;
  FFont.OnChange := nil;
  try
    FFont.Assign(DefaultFont);
  finally
    FFont.OnChange := Save;
  end;
end;

procedure TKnotColumn.RestoreDefaults;
var
  FontAssigned: Boolean;
begin
  FontAssigned := cvFont in FAssignedValues;
  FTitle.RestoreDefaults;
  FAssignedValues := [];
  RefreshDefaultFont;
  Changed(FontAssigned);
end;

procedure TKnotColumn.SetAlignment(const Value: TAlignment);
begin
  if (cvAlignment in FAssignedValues) and (Value = FAlignment) then Exit;
  FAlignment := Value;
  Include(FAssignedValues, cvAlignment);
  Changed(False);
end;

procedure TKnotColumn.SetColor(const Value: TColor);
begin
  if (cvColor in FAssignedValues) and (Value = FColor) then Exit;
  FColor := Value;
  Include(FAssignedValues, cvColor);
  Changed(False);
end;

procedure TKnotColumn.SetName(const Value: string);
begin
  FName := Value;
  Changed(False);
end;

procedure TKnotColumn.SetFont(const Value: TFont);
begin
  FFont.Assign(Value);
  Include(FAssignedValues, cvFont);
  Changed(False);
end;

procedure TKnotColumn.SetIndexStyle(const Value: TColumnIndexStyle);
begin
  if Value <> FIndexStyle then
  begin
    FIndexStyle := Value;
    Changed(False);
  end;
end;

procedure TKnotColumn.SetItemIndex(const Value: integer);
begin
  if Value <> FItemIndex then
  begin
    FItemIndex := Value;
    Changed(False);
  end;
end;

procedure TKnotColumn.SetOptions(const Value: TKnotOptions);
 var
  ChangedOptions: TKnotOptions;
  Grid: TDCCustomTreeGrid;
begin
  ChangedOptions := (FOptions + Value) - (FOptions * Value);
  if FOptions <> Value then
  begin
    FOptions := Value;
    Grid := GetGrid;
    if kcVisible in ChangedOptions then
    begin
      if Grid <> nil then
        Grid.UpdateFrozenCols(Grid.FFrozenCols);
      Width := Width
    end
    else
      Changed(True);
    if kcPopupMenu in ChangedOptions then Grid.InvalidateTitles(True);
  end;
end;

procedure TKnotColumn.SetTitle(const Value: TKnotColumnTitle);
begin
  FTitle.Assign(Value);
end;

procedure TKnotColumn.SetWidth(const Value: TWidth);
begin
  if ((cvWidth in FAssignedValues) or (Value <> DefaultWidth))
    and (Value <> -1) and (Value <> 0)then
  begin
    FWidth := Value;
    Include(FAssignedValues, cvWidth);
  end;
  Changed(False);
end;

procedure TKnotColumn.SetComment(const Value: string);
begin
  FComment := Value;
  Include(FAssignedValues, cvComment);
end;

function TKnotColumn.IsCommentStored: Boolean;
begin
  Result := (cvComment in FAssignedValues);
end;

function TKnotColumn.DefaultComment: string;
begin
  Result := FName;
end;

function TKnotColumn.GetComment: string;
begin
  if cvComment in FAssignedValues then
    Result := FComment
  else
    Result := DefaultComment;
end;

procedure TKnotColumn.SetDisplayFormat(const Value: string);
begin
  if Value <> FDisplayFormat then
  begin
    FDisplayFormat := Value;
    Changed(False);
  end;
end;

procedure TKnotColumn.Changed(AllItems: Boolean);
begin
  inherited;
end;

function TKnotColumn.GetActualWidth: TWidth;
begin
  if cvWidth in FAssignedValues then
    Result := FWidth
  else
    Result := DefaultWidth;
end;

procedure TKnotColumn.SetIndex(Value: Integer);
begin
  inherited;
end;

procedure TKnotColumn.SetFooterPanel(const Value: TKnotColumnFooterPanel);
begin
  FFooterPanel.Assign(Value);
end;

function TKnotColumn.GetStoredWidth: integer;
begin
  if cvWidth in FAssignedValues then
    Result := FWidth
  else
    Result := DefaultWidth;
end;

procedure TKnotColumn.SetVertAlignment(const Value: TVertAlignment);
begin
  if FVertAlignment <> Value then
  begin
    FVertAlignment := Value;
    Changed(False);
  end;
end;

{ TKnotColumns }

function TKnotColumns.Add: TKnotColumn;
begin
  Result := TKnotColumn(inherited Add);
end;

constructor TKnotColumns.Create(AGrid: TDCCustomTreeGrid;
  AKnotColumnClass: TKnotColumnClass);
begin
  inherited Create(AKnotColumnClass);
  FGrid := AGrid;
end;

function TKnotColumns.GetItem(Index: Integer): TKnotColumn;
begin
  Result := TKnotColumn(inherited GetItem(Index));
end;

function TKnotColumns.GetOwner: TPersistent;
begin
  Result := TPersistent(FGrid);
end;

procedure TKnotColumns.SetItem(Index: Integer; Value: TKnotColumn);
begin
  inherited SetItem(Index, Value);
end;

procedure TKnotColumns.Update(Item: TCollectionItem);
var
  Raw: Integer;
begin
  if (Grid = nil) or (csLoading in Grid.ComponentState) then Exit;
  if (Item = nil) then with Grid do
  begin
    if FLayoutLock = 0 then LayoutChanged;
  end
  else begin
    Raw := Grid.DataToRawColumn(Item.Index);
    Grid.InvalidateCol(Raw);
    if kcSizing in TKnotColumn(Item).Options then
      Grid.FSizingIndex := Raw
    else
      Grid.FSizingIndex := -1;
    Grid.ColWidths[Raw] := TKnotColumn(Item).Width;
  end;
  with Grid do if (GroupBox.Count > 0) then GroupBox.Invalidate;
end;

{ TKnotItem }

procedure TKnotItem.Clear;
 var
  i, iCount: integer;
begin
  {  }
  iCount := ChildCount;
  if iCount > 0 then
  begin
    Owner.BeginUpdate;
    LockItems := True;
    for i := iCount-1 downto 0 do TKnotItem(FChildKnots.Items[i]).Free;
    LockItems := False;
    Owner.EndUpdate;
  end;
end;

procedure TKnotItem.Collapse(Recurse: boolean);
 var
  i: integer;
begin
  if Expanded and HasChildren then
  begin
    Owner.BeginUpdate(False, Self, kaCollapse);
    Expanded := False;
    if Recurse then
    begin
      for i := 0 to ChildCount-1 do
         TKnotItem(FChildKnots.Items[i]).Collapse(Recurse);
    end;

    if Grid <> nil then Grid.DoCollapse(Self);

    Owner.EndUpdate;
  end;
end;

constructor TKnotItem.Create(AOwner: TKnotItems; AParent: TKnotItem; AName: string);
begin
  inherited Create;
  FOwner  := AOwner;
  FParent := AParent;
  FName   := AName;

  FNormalImage := -1;
  FSelectImage := -1;
  FIndex := -1;

  {
  Expanded     := False;
  Visible      := True;
  Enabled      := True;
  HasChildren  := False;
  LockItems    := False;
  Changed      := False;
  }
  FFlags := 6;
end;

destructor TKnotItem.Destroy;
 var
  Apply: boolean;
begin
  if (Grid <> nil) and (KnotID <> 0) and (FIndex <> -1)
  then begin
    Apply := True;
    Grid.DoDelete(Self, Apply, [csDestroying]);
    Grid.KnotNotification(Self, kpRemove);
  end;

  Owner.BeginUpdate;

  Data := nil;
  Clear;

  if (FIndex <> -1) and Assigned(FParent) then
    Owner.DeleteChildKnot(FParent, FIndex);

  if FChildKnots <> nil then FChildKnots.Free;
  FChildKnots := nil;

  Owner.EndUpdate;

  inherited Destroy;
end;

procedure TKnotItem.Expand(Recurse: boolean);
 var
  i: integer;
begin
  if not Expanded and HasChildren then
  begin
    Owner.BeginUpdate(False, Self, kaExpand);
    Expanded := True;
    if Recurse then
      for i := 0 to ChildCount-1 do
         TKnotItem(FChildKnots.Items[i]).Expand(Recurse);

    if Grid <> nil then Grid.DoExpand(Self);
    Owner.EndUpdate;
  end;
end;

function TKnotItem.GetChild(Index: integer): TKnotItem;
begin
  Result := TKnotItem(FChildKnots.Items[Index])
end;

function TKnotItem.GetChildCount: integer;
begin
  if FChildKnots <> nil then
    Result := FChildKnots.Count
  else
    Result := 0;
end;

procedure TKnotItem.SetChild(Index: integer; const Value: TKnotItem);
begin
  if Index < ChildCount then FChildKnots.Items[Index] := Value;
end;

procedure TKnotItem.SetData(const Value: Pointer);
begin
  FData := Value;
end;

function TKnotItem.GetNext: TKnotItem;
 var
  ParentKnot: TKnotItem;
begin
  if (ChildCount > 0) then
    Result := Childs[0]
  else begin
    Result := GetNextSibling;
    if Result = nil then
    begin
      ParentKnot := Parent;
      Result     := ParentKnot.GetNextSibling;
      while (Result = nil) and (ParentKnot.Level > 0) do
      begin
        ParentKnot := ParentKnot.Parent;
        Result     := ParentKnot.GetNextSibling
      end;
    end;
  end;
end;

function TKnotItem.GetNextVisible: TKnotItem;
 var
  i, iCount: integer;
  ParentKnot: TKnotItem;
begin
  if Expanded and (ChildCount > 0) then
  begin
    i := 0;
    iCount := ChildCount;
    repeat
      Result := Childs[i];
      inc(i);
    until (i = iCount) or Result.Visible;
    if Result.Visible then Exit;
  end;

  Result := Self;
  repeat
    ParentKnot := Result.Parent;
    repeat
      if Result = nil then
      begin
        Result := ParentKnot;
        ParentKnot := Result.Parent;
      end;
      if Result = Owner.Root then
      begin
        Result := nil;
        Exit;
      end;
      Result := Result.GetNextSiblingVisible;
    until (Result <> nil) and Result.Visible;

  until Result.Visible;
end;

function TKnotItem.GetNextSibling: TKnotItem; assembler;
{
begin
  if (FIndex >= 0) and (FParent <> nil) and (FIndex < (FParent.ChildCount-1)) then
  begin
    Result := FParent.Childs[FIndex + 1];
  end
  else
    Result := nil;
  end;
end;
}
asm
  push esi
  push edi
  push ebp
  push ebx

  mov  edi, eax
  mov  eax, [edi].FIndex
  mov  ebx, eax

  cmp  eax, $00
  jl   @@1

  mov  eax, [edi].FParent
  cmp  eax, $00
  jz   @@1

  call TKnotItem.GetChildCount
  dec  eax
  cmp  eax, ebx
  jle  @@1

  add  ebx, 1
  mov  eax, dword([edi].FParent)
  mov  eax, dword([eax].FChildKnots)
  mov  eax, [eax + $04]              // FList

  mov  eax, [eax + ebx*4]
  jmp  @@2

@@1:
  mov  eax, $00

@@2:
  pop  ebx
  pop  ebp
  pop  edi
  pop  esi
end;

function TKnotItem.GetPrev: TKnotItem;
begin
  Result := GetPrevSibling;
  if Result = nil then
    Result := Parent
  else begin
    if Result <> nil then
      while Result.ChildCount > 0 do
        Result := Result.Childs[Result.ChildCount-1]
  end;
end;

function TKnotItem.GetPrevSibling: TKnotItem; assembler;
{
begin
  if (FIndex > 0) and (FIndex < FParent.ChildCount) then
    Result := FParent.Childs[FIndex-1]
  else
    Result := nil
end;
}
asm
  push esi
  push edi
  push ebp
  push ebx

  mov  edi, eax
  mov  eax, [edi].FIndex
  mov  ebx, eax

  cmp  eax, $00
  jle  @@1

  mov  eax, [edi].FParent
  cmp  eax, $00
  jz   @@1

  call TKnotItem.GetChildCount
  cmp  eax, ebx
  jle  @@1

  dec  ebx
  mov  eax, dword([edi].FParent)
  mov  eax, dword([eax].FChildKnots)
  mov  eax, [eax + $04]              // FList

  mov  eax, [eax + ebx*4]
  jmp  @@2

@@1:
  mov  eax, $00

@@2:
  pop  ebx
  pop  ebp
  pop  edi
  pop  esi
end;

function TKnotItem.GetPrevVisible: TKnotItem;
 var
  ParentKnot: TKnotItem;
begin
  Result := Self;
  repeat
    ParentKnot := Result.FParent;
    Result := Result.GetPrevSiblingVisible;

    if Result = nil then
      Result := ParentKnot
    else
      while Result.Expanded and (Result.ChildCount > 0) do
        Result := Result.Childs[Result.ChildCount-1];

    if Result = Owner.Root then
    begin
      Result := nil;
      Exit;
    end;

  until Result.Visible;
end;

procedure TKnotItem.SetName(const Value: string);
begin
  if FName <> Value then
  begin
    FName := Value;
    FOwner.UpdateTreeGrid;
  end;
end;

function TKnotItem.GetGrid: TDCCustomTreeGrid;
begin
  Result := FOwner.Grid;
end;

function TKnotItem.GetFlagValue(const Index: Integer): boolean; assembler;
asm
  mov  eax, dword([eax].FFlags)
  bt   eax, Index
  sbb  eax, eax
  and  eax, 1
end;

procedure TKnotItem.SetFlagValue(const Index: Integer;
  const Value: boolean); assembler;
asm
  or   Value, Value
  jz   @@1
  bts  [eax].FFlags, Index
  ret
@@1:
  btr  [eax].FFlags, Index
end;

procedure TKnotItem.SetValueEx(const Index: Integer;
  const Value: boolean);
begin
  if GetFlagValue(Index) <> Value then
  begin
    SetFlagValue(Index, Value);
    Owner.UpdateTreeGrid;
  end;
end;

function TKnotItem.GetVisibleChildCount: integer;
 var
  i, iCount: integer;
begin
  Result := 0;
  iCount := ChildCount;
  for i := 0 to iCount-1 do
    if Childs[i].Visible then Inc(Result);
end;

type
  TCustomList = class(TList)
    {}
  end;

function TKnotItem.GetVisibleKnotCount: integer; assembler;
{
 var
  i, iCount: integer;
begin
  if Visible then
  begin
    Result := 1;
    iCount := ChildCount - 1;
    if (iCount >= 0) and Expanded then
    begin
      for i := 0 to iCount do Result := Result + Childs[i].GetVisibleKnotCount;
    end
  end
  else
    Result := 0;
end;
}
asm
  push esi
  push edi
  push ebp

  mov  edi, eax

  xor  eax, eax
  mov  ebp, eax

  mov  eax, edi
  mov eax, dword([eax].FFlags)
  bt  eax, $01
  sbb eax, eax
  and eax, 1

  test al, al
  jz   @@2

  mov ebp, $01

  mov  eax, edi
  call TKnotItems.GetChildCount
  dec  eax
  jl   @@2

  mov  ecx, eax

  push ecx
  mov  eax, edi
  mov eax, dword([eax].FFlags)
  bt  eax, $00
  sbb eax, eax
  and eax, 1

  test al, al
  pop  ecx
  jz   @@2

@@1:
  mov  eax, ecx
  test eax, eax
  jl   @@2

  mov  edx, ecx
  mov  eax, edi

  push ecx
  push ebp

  mov  eax, dword([eax].FChildKnots)
  mov  eax, [eax + $04]              // FList
  mov  eax, [eax + ecx*4]

  call TKnotItem.GetVisibleKnotCount
  pop  ebp
  pop  ecx

  add  ebp, eax
  dec  ecx

  jmp  @@1

@@2:
  mov  eax, ebp

  pop  ebp
  pop  edi
  pop  esi
end;

procedure TKnotItem.SetNormalImage(const Value: shortint);
begin
  if FNormalImage <> Value then
  begin
    FNormalImage := Value;
    FOwner.UpdateTreeGrid;
  end;
end;

procedure TKnotItem.SetSelectImage(const Value: shortint);
begin
  if FSelectImage <> Value then
  begin
    FSelectImage := Value;
    FOwner.UpdateTreeGrid;
  end;
end;

function TKnotItem.GetLevel: integer;
 var
  KnotItem: TKnotItem;
begin
  Result   := -1;
  KnotItem := Self;
  if Owner <> nil then
  begin
    while (KnotItem <> Owner.Root) and (KnotItem <> nil) do
    begin
      KnotItem  := KnotItem.Parent;
      Inc(Result);
    end;
  end;
end;

procedure TKnotItem.SetVisible(const Value: boolean);
 var
  lHasChildren: boolean;
begin
  if GetFlagvalue(1) <> Value then
  begin
    SetFlagValue(1, Value);
    lHasChildren := (Parent.VisibleChilds <> 0);

    if lHasChildren <> Parent.HasChildren then
      Parent.HasChildren := lHasChildren
    else
      Owner.UpdateTreeGrid;
  end;
end;

function TKnotItem.GetVisible: boolean;
begin
  Result := GetFlagValue(1);
end;

function TKnotItem.DisplayRect(TextOnly: boolean): TRect;
 var
  KnotItem1, KnotItem2: TKnotItem;
  ItemVisible: boolean;
  Grid: TDCCustomTreeGrid;
  i: integer;
begin
  {Chack Item Visible}
  SetRectEmpty(Result);
  Grid := GetGrid;
  if Grid <> nil then
  begin
    {Check Item Visible}
    KnotItem1 := Self;
    ItemVisible := KnotItem1.Visible;
    while ItemVisible and (KnotItem1 <> Owner.Root)  do
    begin
      KnotItem1 := KnotItem1.Parent;
      ItemVisible := KnotItem1.Visible and KnotItem1.Enabled;
    end;

    KnotItem1 := Self;
    KnotItem2 := Grid.FFirstVisible;
    with Grid do Result := CellRect(FIndicatorOffset - 1, TopRow + FTitleOffset);
    i := Owner.ComparePos(KnotItem1, KnotItem2);
    if i > 0 then
    begin
      while KnotItem1 <> KnotItem2 do
      begin
        KnotItem1 := KnotItem1.GetNextVisible;
        OffsetRect(Result, 0, -Grid.DefaultRowHeight)
      end;
    end
    else begin
      while KnotItem1 <> KnotItem2 do
      begin
        KnotItem1 := KnotItem1.GetPrevVisible;
        OffsetRect(Result, 0, Grid.DefaultRowHeight)
      end;
    end;
    if TextOnly then Result.Left := Result.Left + Grid.GetTreeLableOffset(Self)
  end;
end;

procedure TKnotItem.EditText;
begin
  {}
end;

procedure TKnotItem.EndEdit(Cancel: boolean);
begin
  {}
end;

function TKnotItem.GetNextSiblingVisible: TKnotItem;
begin
  Result := Self;
  repeat
    Result := Result.GetNextSibling;
  until (Result = nil) or Result.Visible;
end;

function TKnotItem.GetPrevSiblingVisible: TKnotItem;
begin
  Result := Self;
  repeat
    Result := Result.GetPrevSibling;
  until (Result = nil) or Result.Visible;
end;

function TKnotItem.GetOwner: TKnotItems;
begin
  Result := FOwner;
end;

function TKnotItem.GetParent: TKnotItem;
begin
  Result := FParent;
end;

function TKnotItem.GetCapacity: integer;
begin
  if FChildKnots <> nil then
    Result := FChildKnots.Capacity
  else
    Result := 0;
end;

procedure TKnotItem.SetCapacity(const Value: integer);
begin
  if FChildKnots <> nil then
    if Value > FChildKnots.Capacity then
      FChildKnots.Capacity := Value
    else
  else begin
    FChildKnots := TList.Create;
    FChildKnots.Capacity := Value;
  end;
end;

function TKnotItem.GetState: TKnotState;
begin
  Result := FOwner.FState; 
end;

{ TKnotItems }

function TKnotItems.Add(Name: string; Position: integer): TKnotItem;
begin
  Result := AddChild(FRootKnot, Name, Position)
end;

function TKnotItems.AddChild(ParentKnot: TKnotItem; Name: string;
  Position: integer): TKnotItem;
 var
  KnotItem: TKnotItem;
  Apply: boolean;
begin
  KnotItem := FKnotItemClass.Create(Self, ParentKnot, Name);
  Inc(FLastKnotID);
  KnotItem.FKnotID := FLastKnotID;

  Apply := True;
  if (Grid <> nil) then Grid.DoInsert(KnotItem, Apply);

  if Apply then
  begin
    BeginUpdate;
    if ParentKnot.FChildKnots = nil then ParentKnot.FChildKnots := TList.Create;
    case Position of
      KN_ITEMONTOP:
        begin
          ParentKnot.FChildKnots.Insert(0, KnotItem);
          RebuildIndexes(ParentKnot, 0);
        end;
      KN_ITEMONBOTTOM:
        KnotItem.FIndex := ParentKnot.FChildKnots.Add(KnotItem);
      else begin
        ParentKnot.FChildKnots.Insert(Position, KnotItem);
        RebuildIndexes(ParentKnot, Position);
      end;
    end;
    Result := KnotItem;
    ParentKnot.HasChildren := True;
    if (Grid <> nil) then Grid.KnotNotification(KnotItem, kpInsert);
    EndUpdate;
  end
  else begin
    Result := nil;
    KnotItem.Free;
  end;
end;

procedure TKnotItems.Clear;
begin
  if (Grid <> nil) and not(csDestroying in Grid.ComponentState) then
  begin
    with Grid do
    begin
      SetState(ksUpdate);

      SelectedRows.Clear;
      FRootKnot.Clear;
      ActivateBuffers;
      TopRow := FTitleOffset;
      SetInternalRow(FTitleOffset);

      SetState(ksBrowse);
      UpdateTreeGrid;
    end;
  end
  else begin
    FState := ksUpdate;
    FRootKnot.Clear;
    FState := ksBrowse;
  end;
end;

constructor TKnotItems.Create(AOwner: TDCCustomTreeGrid;
  AKnotItemClass: TKnotItemClass);
begin
  inherited Create;
  FState := ksCreate;
  FOwner := AOwner;

  FKnotItemClass := AKnotItemClass;
  FRootKnot := FKnotItemClass.Create(Self, nil, NE_ROOT_KNOT);
  FRootKnot.Expanded := True;

  FLastKnotID  := 0;
  FUpdateCount := 0;

  SetState(ksBrowse);
end;

function TKnotItems.Delete(Knot: TKnotItem): boolean;
 var
  Apply: boolean;
begin
  if Knot <> nil then
  begin
    Apply := True;
    if (Grid <> nil) then Grid.DoDelete(Knot, Apply, []);
    if Apply and SetState(ksBrowse) then
    begin
      BeginUpdate(False, nil, kaDelete);
      if Knot = Owner.FFirstVisible then
      begin
        Knot.Free;
        FOwner.ActivateBuffers;
      end
      else
        Knot.Free;
      EndUpdate;
    end;
    Result := Apply;
  end
  else
    Result := False;
end;

destructor TKnotItems.Destroy;
begin
  FState := ksUpdate;
  FRootKnot.Free;
  inherited;
end;

function TKnotItems.GetCount: integer;
begin
  Result := FRootKnot.ChildCount;
end;

function TKnotItems.GetItem(Index: integer): TKnotItem;
begin
  Result := FRootKnot.Childs[Index];
end;

procedure TKnotItems.SetItem(Index: integer; const Value: TKnotItem);
begin
  FRootKnot.Childs[Index] := Value;
end;

procedure TKnotItems.Move(KnotItem, DestKnot: TKnotItem;
  Position: integer);
 var
  ParentKnot: TKnotItem;
begin
  if DestKnot  = nil then DestKnot := FRootKnot;
  ParentKnot := KnotItem.Parent;

  if ParentKnot.LockItems then Exit;

  DeleteChildKnot(ParentKnot, KnotItem.FIndex);

  if DestKnot.FChildKnots = nil then DestKnot.FChildKnots := TList.Create;
  case Position of
    KN_ITEMONTOP:
     begin
       DestKnot.FChildKnots.Insert(0, KnotItem);
       RebuildIndexes(DestKnot, 0);
     end;
    KN_ITEMONBOTTOM:
      KnotItem.FIndex := DestKnot.FChildKnots.Add(KnotItem);
    else begin
      DestKnot.FChildKnots.Insert(Position, KnotItem);
      if Position > 0 then
        RebuildIndexes(DestKnot, Position-1)
      else
        RebuildIndexes(DestKnot, 0);
    end;
  end;
  KnotItem.FParent := DestKnot;
  UpdateTreeGrid;
end;

function TKnotItems.GetVisibleKnotCount: integer; assembler;
{
 var
   i, iCount: integer;
begin
  Result := 0;
  iCount := Count - 1;
  for i := 0 to iCount do
  begin
    Result := Result + Items[i].VisibleKnotCount;
  end;
end;
}
asm
  push esi
  push edi
  push ebp

  mov  edi, eax

  xor  eax, eax
  mov  ebp, eax

  mov  eax, edi
  call TKnotItems.GetCount
  dec  eax

  mov  ecx, eax

@@1:
  mov  eax, ecx
  test eax, eax
  jl   @@2

  mov  eax, edi
  mov  eax, dword([eax].FRootKnot)
  mov  eax, dword(TKnotItem([eax]).FChildKnots)

  mov  eax, [eax + $04]              // FList
  mov  eax, [eax + ecx*4]

  push ecx
  call TKnotItem.GetVisibleKnotCount
  pop  ecx

  add  ebp, eax
  dec  ecx

  jmp  @@1

@@2:
  mov  eax, ebp

  pop  ebp
  pop  edi
  pop  esi
end;

procedure TKnotItems.BeginUpdate(LockScreen: boolean = False;
  KnotItem: TKnotItem = nil; UpdateAction: TKnotItemUpdateAction = kaNormal);
begin
  if FUpdateCount = 0 then
  begin
    SetUpdateState(True);
    with FUpdatedItem do
    begin
      KnotAction := UpdateAction;
      Item := KnotItem;
      case KnotAction of
        kaCollapse:
          CountItems := Item.GetVisibleKnotCount - 1;
        kaInsert, kaDelete:
          CountItems := 0;
      end
    end;
  end;
  Inc(FUpdateCount);
  if LockScreen then
  begin
    _setFlag(FOwner.FFlags, TGF_LOCKSCREEN, LockScreen);
    FOwner.Refresh;
    ShowScrollBar(FOwner.Handle, SB_BOTH, False);
    ProcessPaintMessages;
  end;
end;

procedure TKnotItems.EndUpdate(CancelUpdate: boolean = False);
 var
  ScrollInfo: TScrollInfo;

 procedure UpdateTreeRowCount(ACount: integer);
  var
   R: TRect;
 begin
   with FOwner do
   begin
     BeginUpdate;
     SetInternalRowCount(ACount);
     UpdateVertScrollBar;
     UpdateColWidths(-1, True);
     R := BoxRectEx(0, Row , ColCount - 1, RowCount);
     InvalidateRect(Handle, @R, False);
     EndUpdate;
   end;
 end;

begin
  if FUpdateCount > 0 then begin
    Dec(FUpdateCount);
    if FUpdateCount = 0 then
    begin
      SetUpdateState(False);
      if _getFlag(FOwner.FFlags, TGF_LOCKSCREEN) then
      begin
        with FOwner do
        begin
          _setFlag(FFlags, TGF_LOCKSCREEN, False);
          with ScrollInfo do
          begin
            cbSize := SizeOf(ScrollInfo);
            fMask  := SIF_ALL;
            nMin   := 0;
            nMax   := 0;
            nPage  := 0;
            nPos      := 0;
            nTrackPos := 0;
          end;
          SetScrollInfo(Handle, SB_HORZ, ScrollInfo, True);
          SetScrollInfo(Handle, SB_VERT, ScrollInfo, True);
          ColWidthsChanged;
          RowHeightsChanged;
          Refresh;
        end;
        ProcessPaintMessages;
      end;
      if not CancelUpdate and (Grid <> nil) then
        with FUpdatedItem, Grid do
        begin
          case KnotAction of
            kaCollapse:
              UpdateTreeRowCount(RowCount - CountItems);
            kaExpand:
              UpdateTreeRowCount(Grid.RowCount + Item.GetVisibleKnotCount - 1);
            kaInsert:
              UpdateTreeRowCount(FTitleOffset + GetVisibleKnotCount);
            kaDelete:
               begin
                 UpdateTreeRowCount(FTitleOffset + GetVisibleKnotCount);
                 UpdateActive;
               end
            else
              UpdateTreeGrid;
          end;
        end;
    end;
  end;
end;

procedure TKnotItems.UpdateTreeGrid;
begin
  if (FUpdateCount = 0) and (FOwner <> nil) and (FState <> ksCreate) then
    FOwner.Perform(CM_KNOTCHANGED, 0, 0);
end;

function TKnotItems.SelectKnot(KnotItem: TKnotItem; Offset: integer): TKnotItem;
 var
  AKnotItem: TKnotItem;
  AIndex: integer;
begin
  Result := KnotItem;
  AIndex := Offset;
  AKnotItem := GetFirstVisibleNode;
  if AIndex >= 0 then
  begin
    while (Result <> nil) and (AIndex > 0) do
    begin
      AKnotItem := Result;
      Result := Result.GetNextVisible;
      Dec(AIndex);
    end;
    if (Result = nil) and (Grid <> nil) then Grid.FEOF := True
  end
  else begin
    while (Result <> nil) and (AIndex < 0) do
    begin
      AKnotItem := Result;
      Result := Result.GetPrevVisible;
      Inc(AIndex);
    end;
    if (Result = nil) and (Grid <> nil) then Grid.FBOF := True
  end;
  if Result = nil then Result := AKnotItem;
end;

procedure TKnotItems.RebuildIndexes(ParentKnot: TKnotItem; FirstIndex: integer);
 var
  i: integer;
begin
  with ParentKnot do
  begin
    if LockItems then
    begin
      Changed := True;
      FLastIndex := _intMin(FLastIndex, FirstIndex);
    end
    else
      for i := FirstIndex to ChildCount-1 do Childs[i].FIndex := i;
  end;
end;

function TKnotItems.SetState(Value: TKnotState): boolean;
begin
  Result := True;
  if Value <> FState then
  begin
    if Assigned(Grid) then
    begin
      with Grid do
      begin
        if EditorMode and (Value = ksBrowse) then
          Result := HideEditor
        else begin
          if not self.Updating and (tgIndicator in Options) then
            InvalidateCell(0,Row);
          FState := Value;
        end;
      end;
    end
    else
      FState := Value;
  end
  else
    if Assigned(Grid) and Grid.EditorMode and (Value = ksBrowse) then
      Result := Grid.HideEditor;
end;

function TKnotItems.GetFirstNode: TKnotItem;
begin
  if FRootKnot.ChildCount > 0 then
    Result := FRootKnot.GetNext
  else
    Result := nil;
end;

procedure TKnotItems.Exchange(KnotItem1, KnotItem2: TKnotItem);
 var
  ParentKnot1, ParentKnot2: TKnotItem;
begin
  ParentKnot1 := KnotItem1.Parent;
  ParentKnot2 := KnotItem2.Parent;

  if ParentKnot1.LockItems or ParentKnot2.LockItems then Exit;

  ParentKnot1.Childs[KnotItem1.Index] := KnotItem2;
  ParentKnot2.Childs[KnotItem2.Index] := KnotItem1;

  if ParentKnot1 = ParentKnot2 then
    RebuildIndexes(ParentKnot1, _intMin(KnotItem1.Index, KnotItem2.Index))
  else begin
    RebuildIndexes(ParentKnot1, KnotItem1.Index);
    RebuildIndexes(ParentKnot2, KnotItem2.Index);
  end;

  UpdateTreeGrid;
end;

function TKnotItems.GetUpdatingState: boolean;
begin
  Result := FUpdateCount <> 0;
end;

procedure TKnotItems.SetUpdateState(Updating: Boolean);
begin
  {}
end;

procedure TKnotItems.LockRebuilds(KnotItem: TKnotItem; Lock: boolean);
begin
  with KnotItem do
  begin
    LockItems := Lock;
    if Lock then
    begin
      Changed := False;
      FLastIndex := MaxInt;
    end
    else begin
      if Changed then Owner.RebuildIndexes(KnotItem, FLastIndex)
    end;
  end;
end;

procedure TKnotItems.DeleteChildKnot(KnotItem: TKnotItem; KnotIndex: integer);
begin
  {   child}
  with KnotItem do
  begin
    if KnotIndex < (ChildCount - 1) then
    begin
      FChildKnots.Delete(KnotIndex);
      FOwner.RebuildIndexes(KnotItem, KnotIndex);
      if ChildCount = 0 then HasChildren := False;
    end
    else
      FChildKnots.Delete(KnotIndex);
  end;
end;

function TKnotItems.GetKnot(KnotID: integer; var KnotItem: TKnotItem): boolean;
begin
  KnotItem := GetFirstNode;
  while (KnotItem <> nil) and (KnotItem.KnotID <> KnotID) do
    KnotItem := KnotItem.GetNext;
  Result := KnotItem <> nil;
end;

function TKnotItems.ComparePos(KnotItem1, KnotItem2: TKnotItem): integer;
 var
  KnotItemA, KnotItemB: TKnotItem;

begin
  if (KnotItem1 = KnotItem2) or (KnotItem2 = nil) or (KnotItem1 = nil) then
  begin
    Result := 0;
    Exit;
  end;

  KnotItemA := KnotItem1;
  KnotItemB := KnotItem2;
  while KnotItemA.Level <> KnotItemB.Level do
  begin
    if KnotItemA.Level > KnotItemB.Level then
      KnotItemA := KnotItemA.Parent
    else
      KnotItemB := KnotItemB.Parent
  end;
  while KnotItemA.Parent <> KnotItemB.Parent do
  begin
    KnotItemA := KnotItemA.Parent;
    KnotItemB := KnotItemB.Parent;
 end;

 if (KnotItemA.Index > KnotItemB.Index) or
    ((KnotItemA.Index = KnotItemB.Index) and (KnotItem1.Level > KnotItem2.Level))then
   Result := -1
 else
   Result := 1
end;

function TKnotItems.GetFirstVisibleNode: TKnotItem;
begin
  if FRootKnot.ChildCount > 0 then
    Result := FRootKnot.GetNextVisible
  else
    Result := nil;
end;

function TKnotItems.GetRootKnot: TKnotItem;
begin
  Result := FRootKnot;
end;

function TKnotItems.GetGrid: TDCCustomTreeGrid;
begin
  Result := FOwner;
end;

function TKnotItems.GetLastVisibleNode: TKnotItem;
 var
  KnotItem: TKnotItem;
begin
  Result := nil;
  KnotItem := GetFirstVisibleNode;
  while KnotItem <> nil do
  begin
    Result := KnotItem;
    KnotItem := KnotItem.GetNextVisible;
  end;
end;

function TKnotItems.AddInternalChild(ParentKnot: TKnotItem; Name: string;
  CheckChilds: boolean; Position: integer): TKnotItem;
 var
  KnotItem: TKnotItem;
begin
  KnotItem := FKnotItemClass.Create(Self, ParentKnot, Name);
  Inc(FLastKnotID);
  KnotItem.FKnotID := FLastKnotID;

  if CheckChilds and (ParentKnot.FChildKnots = nil) then
    ParentKnot.FChildKnots := TList.Create;

  case Position of
    KN_ITEMONTOP:
      begin
        ParentKnot.FChildKnots.Insert(0, KnotItem);
        RebuildIndexes(ParentKnot, 0);
      end;
    KN_ITEMONBOTTOM:
      KnotItem.FIndex := ParentKnot.FChildKnots.Add(KnotItem);
    else begin
      ParentKnot.FChildKnots.Insert(Position, KnotItem);
      RebuildIndexes(ParentKnot, Position);
    end;
  end;
  Result := KnotItem;
  if CheckChilds then ParentKnot.HasChildren := True;
end;

{ TKnotColumnTitle }

procedure TKnotColumnTitle.Assign(Source: TPersistent);
begin
  if Source is TKnotColumnTitle then
  begin
    if cvTitleAlignment in TKnotColumnTitle(Source).FColumn.FAssignedValues then
      Alignment := TKnotColumnTitle(Source).Alignment;
    if cvTitleColor in TKnotColumnTitle(Source).FColumn.FAssignedValues then
      Color := TKnotColumnTitle(Source).Color;
    if cvTitleCaption in TKnotColumnTitle(Source).FColumn.FAssignedValues then
      Caption := TKnotColumnTitle(Source).Caption;
    if cvTitleFont in TKnotColumnTitle(Source).FColumn.FAssignedValues then
      Font := TKnotColumnTitle(Source).Font;
  end
  else
    inherited Assign(Source);
end;

constructor TKnotColumnTitle.Create(Column: TKnotColumn);
begin
  inherited Create;

  FColumn  := Column;
  FCaption := 'DefaultCaption';
  FFont    := TFont.Create;
  FFont.Assign(DefaultFont);
  FFont.OnChange := FontChanged;
end;

function TKnotColumnTitle.DefaultAlignment: TAlignment;
begin
  Result := taLeftJustify;
end;

function TKnotColumnTitle.DefaultCaption: string;
begin
  Result  := FColumn.FName;
end;

function TKnotColumnTitle.DefaultColor: TColor;
 var
  TreeGrid: TDCCustomTreeGrid;
begin
  TreeGrid := FColumn.GetGrid;
  if Assigned(TreeGrid) then
    Result := TreeGrid.FixedColor
  else
    Result := clBtnFace;
end;

function TKnotColumnTitle.DefaultFont: TFont;
 var
  TreeGrid: TDCCustomTreeGrid;
begin
  TreeGrid := FColumn.GetGrid;
  if Assigned(TreeGrid) then
    Result := TreeGrid.Font
  else
    Result := FColumn.Font;
end;

destructor TKnotColumnTitle.Destroy;
begin
  FFont.Free;
  inherited Destroy;
end;

procedure TKnotColumnTitle.FontChanged(Sender: TObject);
begin
  Include(FColumn.FAssignedValues, cvTitleFont);
  FColumn.Changed(True);
end;

function TKnotColumnTitle.GetAlignment: TAlignment;
begin
  if cvTitleAlignment in FColumn.FAssignedValues then
    Result := FAlignment
  else
    Result := DefaultAlignment;
end;

function TKnotColumnTitle.GetCaption: string;
begin
  if cvTitleCaption in FColumn.FAssignedValues then
    Result := FCaption
  else
    Result := DefaultCaption;
end;

function TKnotColumnTitle.GetColor: TColor;
begin
  if cvTitleColor in FColumn.FAssignedValues then
    Result := FColor
  else
    Result := DefaultColor;
end;

function TKnotColumnTitle.GetFont: TFont;
var
  Save: TNotifyEvent;
  Def: TFont;
begin
  if not (cvTitleFont in FColumn.FAssignedValues) then
  begin
    Def := DefaultFont;
    if (FFont.Handle <> Def.Handle) or (FFont.Color <> Def.Color) then
    begin
      Save := FFont.OnChange;
      FFont.OnChange := nil;
      FFont.Assign(DefaultFont);
      FFont.OnChange := Save;
    end;
  end;
  Result := FFont;
end;

function TKnotColumnTitle.IsAlignmentStored: Boolean;
begin
  Result := (cvTitleAlignment in FColumn.FAssignedValues) and
    (FAlignment <> DefaultAlignment);
end;

function TKnotColumnTitle.IsCaptionStored: Boolean;
begin
  Result := (cvTitleCaption in FColumn.FAssignedValues) and
    (FCaption <> DefaultCaption);
end;

function TKnotColumnTitle.IsColorStored: Boolean;
begin
  Result := (cvTitleColor in FColumn.FAssignedValues) and (FColor <> DefaultColor);
end;

function TKnotColumnTitle.IsFontStored: Boolean;
begin
  Result := (cvTitleFont in FColumn.FAssignedValues);
end;

procedure TKnotColumnTitle.RefreshDefaultFont;
var
  Save: TNotifyEvent;
begin
  if (cvTitleFont in FColumn.FAssignedValues) then Exit;
  Save := FFont.OnChange;
  FFont.OnChange := nil;
  try
    FFont.Assign(DefaultFont);
  finally
    FFont.OnChange := Save;
  end;
end;

procedure TKnotColumnTitle.RestoreDefaults;
var
  FontAssigned: Boolean;
begin
  FontAssigned := cvTitleFont in FColumn.FAssignedValues;
  FColumn.FAssignedValues := FColumn.FAssignedValues - ColumnTitleValues;
  FCaption := '';
  RefreshDefaultFont;
  FColumn.Changed(FontAssigned);
end;

procedure TKnotColumnTitle.SetAlignment(Value: TAlignment);
begin
  if (cvTitleAlignment in FColumn.FAssignedValues) and (Value = FAlignment) then Exit;
  FAlignment := Value;
  Include(FColumn.FAssignedValues, cvTitleAlignment);
  FColumn.Changed(False);
end;

procedure TKnotColumnTitle.SetCaption(const Value: string);
var
  Grid: TDCCustomTreeGrid;
begin
  if not(cvTitleCaption in FColumn.FAssignedValues) or (Value <> FCaption) then
  begin
    Grid := Column.GetGrid;
    FCaption := Value;
    Include(Column.FAssignedValues, cvTitleCaption);
    Column.Changed(False);
    if Assigned(Grid) then with Grid do
    begin
      if LayoutLock = 0 then Grid.InternalLayout;
      if GroupingEnabled then GroupBox.UpdateItemSize(GroupBox.Find(DataToRawColumn(FColumn.Index)));
    end;
  end;
end;

procedure TKnotColumnTitle.SetColor(Value: TColor);
begin
  if (cvTitleColor in FColumn.FAssignedValues) and (Value = FColor) then Exit;
  FColor := Value;
  Include(FColumn.FAssignedValues, cvTitleColor);
  FColumn.Changed(False);
end;

procedure TKnotColumnTitle.SetFont(Value: TFont);
begin
  FFont.Assign(Value);
  Include(FColumn.FAssignedValues, cvTitleFont);
  FColumn.Changed(False);
end;

{ TDCCustomTreeGrid }

function TDCCustomTreeGrid.AcquireLayoutLock: Boolean;
begin
  Result := (FUpdateLock = 0) and (FLayoutLock = 0);
  if Result then BeginLayout;
end;

procedure TDCCustomTreeGrid.BeginLayout;
begin
  BeginUpdate;
  if FLayoutLock = 0 then Columns.BeginUpdate;
  Inc(FLayoutLock);
end;

procedure TDCCustomTreeGrid.BeginUpdate;
begin
  LockUpdate;
  Inc(FUpdateLock);
end;

procedure TDCCustomTreeGrid.CellClick(Column: TKnotColumn);
begin
  if Assigned(FOnCellClick) then FOnCellClick(Self, Column, SelectedKnot);
end;

procedure TDCCustomTreeGrid.CellDblClick(ColType: TFixedCol; Column: TKnotColumn);
begin
  if Assigned(FOnCellDblClick) then FOnCellDblClick(Self, Column, SelectedKnot);
end;

procedure TDCCustomTreeGrid.ClipClick(AColType: TFixedCol; ACol: integer);
 var
  ColType: TFixedCol;
begin
  ColType := FClipPopup.ColType;
  HideClipPopup;
  if ColType <> AColType then ShowClipPopup(AColType, ACol, FClipPopup);
end;

procedure TDCCustomTreeGrid.CMCancelMode(var Message: TCMCancelMode);
begin
  inherited;
  with Message do
    if (Sender <> Self) and (Sender <> FClipPopup) then HideClipPopup;
end;

procedure TDCCustomTreeGrid.CMExit(var Message: TMessage);
begin
  try
    if (tgeCancelOnExit in OptionsEx) and (FKnots.State = ksInsert) then
      DoCancelOnMoving(False)
    else
      UpdateData;

    HideHintWindow;
    DoColumnComment(MODE_HIDEWINDOW, nil);
    InvalidateSelected;

    ProcessPaintMessages;
  except
    SetFocus;
    raise;
  end;
  inherited;
end;

procedure TDCCustomTreeGrid.CMKnotChanged(var Message: TMessage);
begin
  if not(csDestroying in ComponentState) then DataChanged;
end;

procedure TDCCustomTreeGrid.CMParentFontChanged(var Message: TMessage);
begin
  inherited;
  if ParentFont then
  begin
    FSelfChangingTitleFont := True;
    try
      TitleFont := Font;
    finally
      FSelfChangingTitleFont := False;
    end;
    LayoutChanged;
  end;
end;

procedure TDCCustomTreeGrid.ColumnMoved(FromIndex, ToIndex: Integer);
begin
  inherited;
  FromIndex := RawToDataColumn(FromIndex);
  ToIndex   := RawToDataColumn(ToIndex);
  Columns[FromIndex].Index := ToIndex;
  if Assigned(FOnColumnMoved) then FOnColumnMoved(Self, FromIndex, ToIndex);
end;

procedure TDCCustomTreeGrid.ColWidthsChanged;
var
  I: Integer;
begin
  if not UpdateLocked and AcquireLayoutLock then
  try
    if not(tgAutoSize in Options) then inherited ColWidthsChanged;
    if FColumns.Count  > 0 then
      for I := FIndicatorOffset to ColCount - 1 do
        FColumns[RawToDataColumn(I)].Width := ColWidths[I];
    if FEditorMode and (FUpdateLock = 0) then
      InplaceUpdateLoc(FIInplaceEditor, CellRect(FInplaceCol, FInplaceRow), Canvas);
  finally
    EndLayout;
  end;
end;

constructor TDCCustomTreeGrid.Create(AOwner: TComponent);
 var
  Bmp: TBitmap;
  GridCreateItems: TDCTreeGridInitialize;
begin
  inherited Create(AOwner);
  inherited DefaultDrawing := False;

  GridCreateItems := Initialize;

  Bmp := TBitmap.Create;
  try
    Bmp.LoadFromResourceName(HInstance, bmExpand);
    FTreeImages := TImageList.CreateSize(Bmp.Width, Bmp.Height);
    FTreeImages.AddMasked(Bmp, Bmp.Canvas.Pixels[0,0]);
    Bmp.LoadFromResourceName(HInstance, bmCollapse);
    FTreeImages.AddMasked(Bmp, Bmp.Canvas.Pixels[0,0]);
    Bmp.LoadFromResourceName(HInstance, bmExpandR);
    FTreeImages.AddMasked(Bmp, Bmp.Canvas.Pixels[0,0]);
    Bmp.LoadFromResourceName(HInstance, bmCollapseR);
    FTreeImages.AddMasked(Bmp, Bmp.Canvas.Pixels[0,0]);

    FTreeImages.DrawingStyle := dsTransparent;
  finally
    Bmp.Free;
  end;

  FDefaultDrawing := True;
  FTitleOffset := 1;
  FIndicatorOffset := 1;
  FOptions := [tgEditing, tgTitles, tgIndicator, tgColumnResize,
    tgColLines, tgRowLines, tgTabs, tgTreePathResize, tgFixedLines, tgColMoving];

  FOptionsEx := [tgeInsertSelect, tgeMarkerMenu, tgeIndicatorMenu,
    tgeShadowSelection, tgeShowButtons, tgeDrawBuffered, tgeConfirmDelete,
    tgeCancelOnExit];

  DesignOptionsBoost := [goColSizing];

  VirtualView := False;

  UsesBitmap;

  inherited Options := [goFixedHorzLine, goFixedVertLine, goHorzLine,
    goVertLine, goColSizing, goTabs];


  FKnots   := GridCreateItems.ItemsClass.Create(Self,
    GridCreateItems.ItemClass);
  FColumns := GridCreateItems.ColumnsClass.Create(Self,
    GridCreateItems.ColumnClass);

  FFixedColor := clBtnFace;

  inherited FixedColor := clSilver;
  inherited RowCount := 2;
  inherited ColCount := 2;

  Color := clWindow;
  ParentColor := False;
  FTitleFont := TFont.Create;
  FTitleFont.OnChange := TitleFontChanged;
  FSaveCellExtents := False;

  FBookmarks := TKnotBookmarkList.Create(Self);

  FCurrentCol := -1;
  FMousePoint := Point(-1,-1);
  FClipDown   := False;
  FFirstGridCell := 0;
  FTreepathWidth := 0;

  FIInplaceEditor := nil;
  FEditorMode := False;
  FInplaceCol := -1;
  FInplaceRow := -1;

  _setFlag(FFlags, TGF_ISESCKEYPRESS, False);
  _setFlag(FFlags, TGF_ISDATAMODIFIED, False);
  _setFlag(FFlags, TGF_LOCKSCROLL, False);
  _setFlag(FFlags, TGF_ROWUPDATED, False);

  FHintRow := -1;

  FImageChangeLink :=  TChangeLink.Create;
  FImageChangeLink.OnChange := ImageListChange;
  FMouseDownRow := -1;
  FEditTimerID := -1;
  FColumnCell := -1;

  FSizingIndex := -1;
  FIndent := FTreeImages.Width + 2;
  FColumnFooter := TKnotColumnFooter.Create(Footers);
  FTreePath := TTreePath.Create(Self);
  FFrozenCols := 0;
  FLineColor := clSilver;

  ClearBuffers;
end;

procedure TDCCustomTreeGrid.CreateWnd;
begin
  BeginUpdate;   { prevent updates in WMSize message that follows WMCreate }
  try
    inherited CreateWnd;
  finally
    EndUpdate;
  end;
  UpdateRowCount;

  FClipPopup := TKnotClipPopup.Create(Self);
  FClipPopup.ColType := dcNone;
end;

procedure TDCCustomTreeGrid.DataChanged;
begin
  if not HandleAllocated then Exit;
  DoDataChanged;
  UpdateRowCount;
  SelectedRows.ListChanged;
end;

function TDCCustomTreeGrid.DataToRawColumn(ACol: Integer): Integer;
begin
  Result := ACol + FIndicatorOffset;
end;

procedure TDCCustomTreeGrid.DblClick;
 var
  Cell: TGridCoord;
  P: TPoint;
  R: TRect;
  ARow: integer;
  ColType: TFixedCol;
begin
  if not AcquireFocus or FKnots.Updating then Exit;

  GetCursorPos(P);
  P := ScreenToClient(P);
  Cell := MouseCoord(P.X, P.Y);
  ColType := GetFixedColType(Cell.X, 0);
  R := CellRect(Cell.X, Cell.Y);

  if (FKnots.Count > 0) and (Cell.Y >= FTitleOffset) then
    with Cell do
    begin
      BeginUpdate;
      try
        if (Y >= FTitleOffset) and (Y - Row <> 0) and
          (GetKeyState(VK_SHIFT) = 0) then
        begin
          ARow := Row;
          MoveBy(Row - Cell.Y);
          if (ARow <> Cell.Y) and ( Row <> Cell.Y) and (ARow = Row) then Exit;
        end;
        if ColType = dcTreePath then
          with FSelectedKnot do
          begin
            if (tgEditing in Options) and
              not (tgTreePathCompletion in Options) then
            begin
              case GetHitTestInfoAt(FSelectedKnot, P.X - R.Left, P.Y - R.Top) of
                htOnButton,
                htOnIcon  ,
                htOnLabel :
                  if HasChildren then
                    if Expanded then Collapse(False) else Expand(False);
              end
            end
            else
              if HasChildren then
              begin
                if Expanded then Collapse(False) else Expand(False);
              end;
          end
        else with FSelectedKnot do
        begin
          if (tgTreePathCompletion in Options) and HasChildren then
          begin
            if Expanded then Collapse(False) else Expand(False);
          end
          else
            ShowEditor;
        end;
      finally
        EndUpdate;
      end;
    end
    else
      if (Cell.X >= FIndicatorOffset) and (FKnots.Count = 0) and
       (Cell.Y >= FTitleOffset)then
      begin
        ShowEditor;
      end;

  inherited;
end;

destructor TDCCustomTreeGrid.Destroy;
begin
  if FEditorMode then
  begin
    FEditorMode  := False;
    FIInplaceEditor.Parent := nil;
    FIInplaceEditor := nil;
  end;

  FBookmarks.Clear;

  ClearBookmarkData(FCurrentPos[1].Bookmark);
  ClearBookmarkData(FCurrentPos[2].Bookmark);
  ClearBookmarkData(FSelectionAnchor);

  if Assigned(FClipPopup) then FClipPopup.Free;

  FreeAndNil(FColumns);
  FreeAndNil(FTreeImages);
  FreeAndNil(FTitleFont);
  FreeAndNil(FKnots);
  FreeAndNil(FBookmarks);
  FreeAndNil(FImageChangeLink);
  FreeAndNil(FTreePath);
  FreeAndNil(FColumnFooter);

  ReleaseBitmap;
  inherited;
end;

function TDCCustomTreeGrid.DrawTitleCell(ACanvas: TCanvas; ACol,
  ARow: Integer; ARect: TRect; BorderState: TDrawBorerState; AFillRect, ADraw: boolean): TPoint;
const
  ColumnIndexStyle : array [TColumnIndexStyle] of Integer =
   (nbmIndexNone,nbmIndexAsc,nbmIndexDesc);
  AlignFlags : array [TAlignment] of Integer =
    ( DT_LEFT   or DT_NOPREFIX or DT_END_ELLIPSIS,
      DT_RIGHT  or DT_NOPREFIX or DT_END_ELLIPSIS,
      DT_CENTER or DT_NOPREFIX or DT_END_ELLIPSIS);

 var
  TitleRect, TextRect, DrawRect: TRect;
  Column: TKnotColumn;
  Indicators: TImageList;
  Flags: DWORD;

  function DoPaint(Canvas: TCanvas; DrawRect: TRect): TPoint;
   var
    P: TPoint;
    W: integer;
    BorderStyle: TEdgeBorderStyle;
    R: TRect;
  begin
    TextRect := DrawRect;

    BorderStyle := GetBorderStyle;

    if not((BorderState = dsDown) and (GetBorderStyle = ebsNone)) then
    begin
      Canvas.Font := Column.Title.Font;
      Canvas.Brush.Color := Column.Title.Color;
    end
    else begin
      Canvas.Font := Column.Title.Font;
      Canvas.Font.Color := ColorToRGB(clHighlightText);
      Canvas.Brush.Color := clXPDropDown;
    end;

    if AFillRect then FillRect(Canvas.Handle, TextRect, Canvas.Brush.Handle);

    W := 0;
    case Column.VertAlignment of
      vaTop:
        ;
      vaCenter:
        TextRect.Top := _intMax(0,
          (TextRect.Top + TextRect.Bottom - Column.Size.Y) div 2 - 1);
      vaBottom:
        TextRect.Top := _intMax(0, TextRect.Bottom - Column.Size.Y - 2);
    end;

    if (BorderState = dsDown) and (BorderStyle <> ebsNone) then
    begin
      TextRect.Top := TextRect.Top  + 1;
      OffsetRect(TextRect, 3, 0);
    end
    else
      OffsetRect(TextRect, 2, 0);

    if (Column.Grid.Images <> nil) and (Column.ItemIndex <> -1) and
       ((TextRect.Right - TextRect.Left) > 0)
    then begin
      if ADraw then Column.Grid.Images.Draw(Canvas, TextRect.Left, TextRect.Top, Column.ItemIndex);
      TextRect.Left := TextRect.Left + Column.Grid.Images.Width + 2;
      W := Column.Grid.Images.Height - 1;
    end;

    if TextRect.Left < TextRect.Right then
    begin
      SetTextColor(Canvas.Handle, Canvas.Font.Color);
      if not(kcWordBreak in Column.Options) then
      begin
        Flags := 0;
        case Column.Title.Alignment of
          taLeftJustify:
            if ADraw then
              P := DrawHighLightText(Canvas, PChar(Column.Title.Caption),
                TextRect, 1, DT_NOPREFIX or Flags)
            else
              P := DrawHighLightText(Canvas, PChar(Column.Title.Caption),
                TextRect, 0, DT_NOPREFIX or Flags);
          taCenter, taRightJustify:
            begin
              if (kcIndexed in Column.Options) and (Column.IndexStyle <> idxNone) then
                Dec(TextRect.Right, IndexTitleWidth + 2);
              P := DrawTitleRect(Canvas, TextRect, Column.Title.Caption,
                Column.Title.Alignment, ADraw, Flags)
            end;
        end;
      end
      else begin
        Flags := AlignFlags[Column.Title.Alignment] or DT_WORDBREAK;
        R := Rect(0, 0, MaxInt, maxInt);

        DrawText(Canvas.Handle, PChar(Column.Title.Caption), -1,
          R, Flags or DT_CALCRECT);
        P.X := R.Right;
        P.Y := R.Bottom;

        if AFillRect then
          DrawText(Canvas.Handle, PChar(Column.Title.Caption), -1,
            TextRect, Flags);
      end;
      Result.Y := _intMax(P.Y, W);
      Result.X := P.X + 2;
      if (kcIndexed in Column.Options) and ((Column.IndexStyle <> idxNone) and
        ((IndexTitleWidth + 4) <= (TextRect.Right - TextRect.Left)) or not ADraw)
      then begin
        if ADraw then
        begin
          if Column.Title.Alignment = taCenter then
            P.X := (TextRect.Right + TextRect.Left - P.X) div 2 + P.X - 1;
          Indicators.Draw(Canvas, P.X + 2, TextRect.Top, ColumnIndexStyle[Column.IndexStyle]);
        end;
        Inc(Result.X, IndexTitleWidth + 4);
      end
      else
        Inc(Result.X, 2);
    end;

  end;

begin
  if (ACol < 0) or (Columns.Count = 0) or (ACol > Columns.Count) then Exit;

  Column     := Columns[ACol];
  TitleRect  := ARect;
  Indicators := GDGetImages;

  with TitleRect do if Right - Left <= 0 then Exit;

  if AFillRect then
  begin
    DrawBitmap.Width  := TitleRect.Right  - TitleRect.Left;
    DrawBitmap.Height := TitleRect.Bottom - TitleRect.Top;

    with DrawBitmap do
    begin
      DrawRect := Rect(0,0, Width, Height);
      Result := DoPaint(Canvas, DrawRect);
    end;
    if ADraw then ACanvas.Draw(ARect.Left, ARect.Top, DrawBitmap);
  end
  else
    Result := DoPaint(ACanvas, ARect);
end;

procedure TDCCustomTreeGrid.DrawCell(ACol, ARow: Integer; ARect: TRect;
  AState: TGridDrawState);
var
  FrameOffs: Byte;
  BorderState, MenuState: TDrawBorerState;
  BorderStyle: TEdgeBorderStyle;
  DrawKnot: TKnotItem;
  DrawColumn: TKnotColumn;
  Highlight, KnotFound, CellBorder: boolean;
  ALeft, ATop, Indicator, ALineColor: integer;
  ColType: TFixedCol;
  RowType: TFixedRow;
  DrawRect, PopupRect: TRect;
  Indicators: TImageList;
  FrozenCol, ActiveControl: boolean;
  CellData: pointer;
  ACellState: TGridCellState;
  PSize: TPoint;

  function Draw2CellState(AState: TGridDrawState): TGridCellState;
  begin
    Result := [];
    if gdSelected in AState then Include(Result, gsSelected);
    if gdFocused in AState then Include(Result, gsFocused);
    if gdFixed in AState then Include(Result, gsFixed);
  end;

  procedure GetDrawState(Canvas: TCanvas; AColumn: TKnotColumn);
  begin
    if FrozenCol and (ARow = RawToDataRow(Row)) and (tgRowSelect in Options) then
      Include(AState, gdSelected);
    Highlight := HighlightCell(ACol, ARow, AState, DrawKnot, ActiveControl);
    with Canvas do
    begin
      if (gdFixed in AState) and CellBorder then
      begin
         if AColumn <> nil then
         begin
           Font := AColumn.Title.Font;
           Brush.Color := AColumn.Title.Color;
         end
         else begin
           Font := TreePath.Font;
           if KnotFound or not (tgeTreeSelect in OptionsEx) then
             Brush.Color := TreePath.Color
           else
             Brush.Color := Self.Color
         end;
      end
      else begin
        if AColumn <> nil then
        begin
          Font := AColumn.Font;
          Brush.Color := AColumn.Color;
        end
        else begin
          Font := TreePath.Font;

          if CellBorder or (KnotFound and (tgTreePathCompletion in Options) and
            DrawKnot.HasChildren) then
            Brush.Color := TreePath.Color
          else
            Brush.Color := Self.Color
        end;
      end;

      if (tgHighlightRow in Options) and (AlwaysShowSelection or
        ActiveControl or (Row = FInplaceRow)) then
      begin
        if ARow = RawToDataRow(Row) then
        begin
          if not ActiveControl and (tgeShadowSelection in OptionsEx) then
            Brush.Color := clShadowed
          else begin
            if Highlight or not (tgMultiSelect in Options) then
            begin
              Brush.Color := clHighlight;
              Font.Color := clHighlightText;
            end;
          end;
          Include(AState, gdFocused);
        end;
        if Highlight then
        begin
          if not ActiveControl and (tgeShadowSelection in OptionsEx) then
            Brush.Color := clShadowed
          else begin
            if not (tgMultiSelect in Options) and
              not(Assigned(DrawKnot) and DrawKnot.HasChildren) then
            begin
              Brush.Color := clRowHighlight;
              Font.Color  := clTextHighlight;
            end
            else begin
              Brush.Color := clHighlight;
              Font.Color := clHighlightText;
            end;
          end;
          Include(AState, gdSelected);
        end;
      end
      else
      if Highlight or (not (tgMultiSelect in Options) or (Knots.Count = 0)) and
       (ARow = RawToDataRow(Row)) and
       ((tgRowSelect in Options) or
         (tgTreePathCompletion in Options) and (DrawKnot <> nil) and DrawKnot.HasChildren)
      then begin
        if AlwaysShowSelection or ActiveControl then
        begin
          if not ActiveControl and (tgeShadowSelection in OptionsEx) then
            Brush.Color := clShadowed
          else begin
            Brush.Color := clHighlight;
            Font.Color  := clHighlightText;
          end;
        end;
        Include(AState, gdFocused);
      end;

      ACellState := Draw2CellState(AState);

      if not Highlight and (tgAdvancedSelect in Options) and
         SelectedArea.CellSelected(ACol, DrawKnot) then
      begin
        Brush.Color := clXPSelectedLight;
        Include(ACellState, gsSelectArea);
      end;
    end;
  end;

  procedure DrawTreePathCell(ARect, PieRect: TRect; var AState: TGridCellState;
    KnotFound: boolean; DrawKnot: TKnotItem);
   var
    DrawRect, TextRect: TRect;
    ATop, ITop, nVisible: integer;
    Text: string;
    P: TPoint;
    PrevKnot, NextKnot: TKnotItem;

    {   protected   Event CustomDrawItem}
    procedure DoDraw(Canvas: TCanvas);
     var
      j, ButtonSize, cx, cy, wx, hy, l: integer;
      FastDraw, ActiveItem: boolean;
      LRect: TRect;
      KnotItem: TKnotItem;
      StructFixed, StructPath: TPolyLineStruct;

     procedure DrawLineX(Canvas: TCanvas; AColor: TColor; APos: TPoint;
       ALength: integer);
      var
       i: integer;
     begin
       if tpSolidLines in FTreePath.Options then
         AddPoint2Struct(StructPath, APos.X, APos.Y, APos.X + ALength, APos.Y)
       else
         for i := 0 to ALength do
           if i mod 2 = 1 then Canvas.Pixels[APos.X + i, APos.Y] := AColor;
     end;

     procedure DrawLineY(Canvas: TCanvas; AColor: TColor; APos: TPoint;
       ALength: integer);
      var
       i: integer;
     begin
       if tpSolidLines in FTreePath.Options then
         AddPoint2Struct(StructPath, APos.X, APos.Y, APos.X, APos.Y + ALength + 1)
       else
         for i := 0 to ALength do
           if i mod 2 = 1 then Canvas.Pixels[APos.X, APos.Y + i] := AColor;
     end;

     procedure IndentLevelOffset;
     begin
       Inc(TextRect.Left, DrawKnot.Level * Indent);
     end;

    begin
      GetDrawState(Canvas, nil);

      if [tgColLines, tgRowLines] * Options = [tgRowLines] then
      begin
        if tgTreePathCompletion in Options then InflateRect(TextRect, 0, -1)
      end;

      if tgFlatLines in Options then
      begin
        with PieRect do
        begin
          if (tgRowLines in Options) and (tpRowLines in FTreePath.Options) then
          begin
            Dec(Bottom);
            Dec(TextRect.Bottom);
            AddPoint2Struct(FGridStruct, Left, Bottom, Right, Bottom);
          end;
          if (tgColLines in Options) or (tpColLines in FTreePath.Options) then
          begin
            Dec(Right);
            Dec(TextRect.Right);
            AddPoint2Struct(FGridStruct, Right, Top, Right, Bottom);
          end
        end;
      end;

      FillRect(Canvas.Handle, TextRect, Canvas.Brush.Handle);

      if not KnotFound then Exit;

      ButtonSize := 5;
      ATop := (DrawRect.Top + DrawRect.Bottom) shr 1 - ButtonSize - 1;

      { }

      if (tgTreePathCompletion in Options) then
      begin
        ActiveItem := (gsFocused in AState) and ActiveControl;
        CreatePolyLineStruct(StructPath, PolySize_x16, TreePath.Color);
        CreatePolyLineStruct(StructFixed, PolySize_x16, inherited FixedColor);
        try
          if tgFlatButtons in Options then
          begin
            if tgRowLines in Options then
            begin
              if DrawKnot.Level > 0 then
              begin
                for j := 0 to DrawKnot.Level - 1 do with TextRect do
                begin
                  AddPoint2Struct(StructPath, Left, Top - 1, Left + Indent - 1,
                    Top - 1);
                  Inc(Left, Indent - 1);
                  if not ActiveItem then
                    AddPoint2Struct(StructFixed, Left, Top - 1, Left, Bottom + 1);
                  Inc(Left);
                end;
              end
            end
            else begin
              StructFixed.Color := Color;
              if DrawKnot.Level > 0 then
              begin
                for j := 0 to DrawKnot.Level - 1 do with TextRect do
                begin
                  Inc(Left, Indent - 1);
                  if not ActiveItem then
                    AddPoint2Struct(StructFixed, Left, Top, Left, Bottom);
                  Inc(Left);
                end;
              end;
              if not(gsFocused in AState) then
                with TextRect do
                  AddPoint2Struct(StructFixed, Left, Top, Right, Top);
            end;
          end
          else
            IndentLevelOffset;
          PaintPolyLine(Canvas.Handle, StructFixed);
          PaintPolyLine(Canvas.Handle, StructPath);
        finally
          DestroyPolyLineStruct(StructPath);
          DestroyPolyLineStruct(StructFixed);
        end;
      end
      else
        IndentLevelOffset;

      with DrawKnot do
      begin
        Inc(TextRect.Left, 2);
        nVisible := VisibleChilds;
        if ((nVisible > 0) or HasChildren) and (tgeShowButtons in OptionsEx) then
        begin
          if DrawKnot.Expanded then
          begin
            if tgTreePathCompletion in Options then
              FTreeImages.Draw(Canvas, TextRect.Left, ATop, nbmExpandR)
            else
              FTreeImages.Draw(Canvas, TextRect.Left, ATop, nbmExpand)
          end
          else
          begin
            if tgTreePathCompletion in Options then
              FTreeImages.Draw(Canvas, TextRect.Left, ATop, nbmCollapseR)
            else
              FTreeImages.Draw(Canvas, TextRect.Left, ATop, nbmCollapse);
          end;
        end;

        if [tgeShowLines, tgeShowButtons] * OptionsEx <> [] then
          TextRect.Left := TextRect.Left + Indent + 1
        else
          Inc(TextRect.Left, 1);

        if (tgeShowLines in OptionsEx) and
          not(tgTreePathCompletion in Options) then
        begin
          if tpSolidLines in FTreePath.Options then
            CreatePolyLineStruct(StructPath, PolySize_x16, clAppWorkSpace);

          LRect := TextRect;
          wx := LRect.Left - 2;
          hy := LRect.Bottom;
          cx := LRect.Left - Indent - 1 + ButtonSize;
          cy := (LRect.Top + LRect.Bottom) div 2;

          if not(tgColLines in Options) then Inc(cy);

          PrevKnot := DrawKnot.GetPrevVisible;
          NextKnot := DrawKnot.GetNextSiblingVisible;

          Canvas.Pen.Style := psSolid;

          if DrawKnot.HasChildren and (tgeShowButtons in OptionsEx) then
            DrawLineX(Canvas, clAppWorkSpace,
              Point(cx + ButtonSize, cy), wx - (cx + ButtonSize))
          else
            if tpSolidLines in FTreePath.Options then
              DrawLineX(Canvas, clAppWorkSpace, Point(cx, cy), wx - cx)
            else
              DrawLineX(Canvas, clAppWorkSpace, Point(cx - 1, cy), wx - cx + 1);

          if tgeShowButtons in OptionsEx then
          begin
            if PrevKnot <> nil then
            begin
              l := cy - LRect.Top - ButtonSize;
              if tpSolidLines in FTreePath.Options then inc(l);
              if l mod 2 <> 0 then
                DrawLineY(Canvas, clAppWorkSpace, Point(cx, LRect.Top - 1), l)
              else
                DrawLineY(Canvas, clAppWorkSpace, Point(cx, LRect.Top), l)
            end;

            if NextKnot <> nil then
              DrawLineY(Canvas, clAppWorkSpace, Point(cx, cy + ButtonSize),
                hy - cy - ButtonSize);

            if not HasChildren then
            begin
              if PrevKnot <> nil then
                DrawLineY(Canvas, clAppWorkSpace, Point(cx, cy - ButtonSize),
                  ButtonSize div 2 + 2);
              if NextKnot <> nil then
                DrawLineY(Canvas, clAppWorkSpace, Point(cx, cy + 1),
                  ButtonSize div 2 + 1)
            end;
          end
          else begin
            if PrevKnot <> nil then
              DrawLineY(Canvas, clAppWorkSpace, Point(cx, LRect.Top), hy - cy);

            if NextKnot <> nil then
              DrawLineY(Canvas, clAppWorkSpace, Point(cx, cy - 1), hy - cy);
          end;

          KnotItem := DrawKnot.Parent;
          while KnotItem.Level <> -1 do
          begin
            cx := cx - Indent;
            if KnotItem.GetNextSiblingVisible <> nil then
              DrawLineY(Canvas, clAppWorkSpace, Point(cx, LRect.Top), hy - LRect.Top);
            KnotItem := KnotItem.Parent;
          end;

          if tpSolidLines in FTreePath.Options then
          begin
            PaintPolyLine(Canvas.Handle, StructPath);
            DestroyPolyLineStruct(StructPath);
          end;

        end;

        if (Images <> nil) then
        begin
          if FImages.Height < TextRect.Bottom - TextRect.Top then
            ITop := (TextRect.Top + TextRect.Bottom - FImages.Height) shr 1
          else
            ITop := TextRect.Top;
          if (ARow = (Row-FTitleOffset)) then
          begin
             if(SelectImage <> -1) then
             begin
               FImages.Draw(Canvas, TextRect.Left, ITop, SelectImage);
               TextRect.Left := TextRect.Left + FImages.Width + 5
             end
          end
          else begin
             if(NormalImage <> -1) then
             begin
               FImages.Draw(Canvas, TextRect.Left, ITop, NormalImage);
               TextRect.Left := TextRect.Left + FImages.Width + 5
             end;
          end;
        end;
        FastDraw := GetTreePathCaption(DrawKnot, Text);

        if not(tgTreePathCompletion in Options) and not FastDraw then
        begin
          P := DrawHighLightText(Canvas, PChar(Text), TextRect, 0, 0, FImages);
          if P.Y < TextRect.Bottom - TextRect.Top then
            TextRect.Top  := (TextRect.Top + TextRect.Bottom - P.Y) shr 1;
          DrawHighLightText(Canvas, PChar(Text), TextRect, 1, 0, FImages);
        end
        else
          DrawText(Canvas.Handle, PChar(Text), Length(Text), TextRect,
            DT_LEFT or DT_VCENTER or DT_SINGLELINE);
      end;
    end;

  begin
    if DrawBuffered then with DrawBitmap do
    begin
      Width  := ARect.Right  - ARect.Left;
      Height := ARect.Bottom - ARect.Top;
      DrawRect := Rect(0,0, Width, Height);
    end
    else
      DrawRect := ARect;
    TextRect := DrawRect;

    if DrawBuffered  then
    begin
      DoDraw(DrawBitmap.Canvas);
      with PieRect do
        BitBlt(Self.Canvas.Handle, Left, Top, Right- Left, Bottom - Top,
          DrawBitmap.Canvas.Handle, Left - ARect.Left, Top - ARect.Top, SRCCOPY);
    end
    else
      DoDraw(Canvas);
  end;

  function GetTreePathRect(ARow: integer; ARect: TRect; HasChildren: boolean): TRect;
   var
    R1, R2: TRect;
    TreeCol: integer;

  begin
    TreeCol := 0;

    if tgIndicator in Options then Inc(TreeCol);
    if tgMarker in Options then Inc(TreeCol);

    Inc(ARow, FTitleOffset);
    R1 := CellRect(TreeCol, ARow);
    if HasChildren then
      R2 := CellRect(LeftCol + VisibleColCount, ARow)
    else
      R2 := R1;
    Result := Rect(R1.Left, ARect.Top, R2.Right, ARect.Bottom);
  end;

  function DoDrawCell(Canvas: TCanvas; GridRect: TRect): boolean;
   var
    FillDrawingRect: boolean;
  begin
    Result := False;
    with Canvas do
    begin
      GetDrawState(Canvas, DrawColumn);
      if not Enabled or
        ((DrawKnot <> nil) and not DrawKnot.Enabled) then Font.Color := clGrayText;

      FillDrawingRect := True;
      if Assigned(FOnGetDrawCellCanvas) then
        FOnGetDrawCellCanvas(Self, Canvas, ACol, ARow, DrawColumn, DrawKnot,
          ACellState, FillDrawingRect);

      if tgFlatLines in Options then
      begin
        with GridRect do
        begin
          if tgRowLines in Options then
          begin
            Dec(Bottom);
            AddPoint2Struct(FGridStruct, Left, Bottom, Right + 1, Bottom);
          end;
          if tgColLines in Options then
          begin
            Dec(Right);
            AddPoint2Struct(FGridStruct, Right, Top, Right, Bottom);
          end
        end;
      end;

      if not (tgTreePathCompletion in Options) then
      begin
        if FillDrawingRect then FillRect(DrawRect);
        if KnotFound then
          DoDrawColumnCell(Canvas, DrawRect, ACol, DrawColumn, DrawKnot, ACellState);
      end
      else begin
        if KnotFound then
        begin
          if DrawKnot.HasChildren and not(kcDrawTreeCell in DrawColumn.Options) then
          begin
            if DrawBuffered then
              DrawTreePathCell(GetTreePathRect(ARow, ARect, True),
                ARect, ACellState, KnotFound, DrawKnot)
            else begin
              if TreePathWidth = 0 then
              begin
                if FillDrawingRect then FillRect(DrawRect);
                DoDrawColumnCell(Canvas, DrawRect, ACol, DrawColumn, DrawKnot,
                  ACellState);
              end;
            end;
            Exit;
          end
          else begin
            if FillDrawingRect  then FillRect(DrawRect);
            DoDrawColumnCell(Canvas, DrawRect, ACol, DrawColumn, DrawKnot,
              ACellState);
          end;
        end
        else begin
          FillRect(DrawRect);
        end;
      end
    end;
    Result := True;
  end;

  procedure DrawFixedBorder(ARect: TRect; Frame: boolean);
  begin
    if Frame then FrameRect(Canvas.Handle, ARect, Canvas.Brush.Handle);
    if tgDrawFixedLine in Options then
    begin
      ALineColor := clSilver;
      if ColorToRGB(Color) = clSilver then ALineColor := clGray;
      with Canvas do
      begin
        Pen.Color := Pen.Color -1;
        Pen.Color := ALineColor;
        PenPos := Point(ARect.Right, ARect.Top);
        LineTo(ARect.Right, ARect.Bottom);

        PenPos := Point(ARect.Left, ARect.Bottom);
        LineTo(ARect.Right + 1, ARect.Bottom);
      end;
    end;
  end;

  procedure DrawBorderEx(ARect: TRect; ABorderState: TDrawBorerState);
  begin
    if (tgRowLines in Options) or (BorderStyle <> ebsNone) then
    begin
      if (BorderStyle = ebsNone) then
      begin
        if [tgColLines, tgRowLines, tgTreePathCompletion] * Options <> [tgRowLines] then
          InflateRect(ARect, 1, 1);
        DrawFixedBorder(ARect, True)
      end
      else begin
        InflateRect(ARect, 1, 1);
        DrawGridFrameBorder(Canvas, ARect, BorderStyle, ABorderState, FixedColor);
      end;
    end
    else
      if (BorderStyle = ebsNone) and (tgDrawFixedLine in Options) then
         DrawFixedBorder(ARect, False)
  end;

  procedure DrawFixedCellFrame(AColType: TFixedCol; ImageIndex: integer);
   var
    B: TBitmap;
    BRect, CRect: TRect;
    BBrush: HBRUSH;
  begin
    if FClipDown and (FClipPopup.ColType = AColType) then
    begin
      case GridDrawing.ClipStyle of
        csSingleBorder:
          begin
            B := TBitmap.Create;
            try
              B.Width := Indicators.Width + 2;
              B.Height := Indicators.Height + 2;
              BRect := Rect(0, 0, B.Width, B.Height);

              FillRect(B.Canvas.Handle, BRect, Canvas.Brush.Handle);
              Indicators.Draw(B.Canvas, 1, 1, ImageIndex);
              AlphaBlend(B, nil, B, 170, B.Canvas.Pixels[0, 0],
                B.Canvas.Pixels[0, 0]);

              InflateRect(BRect, -1, -1);
              CRect := BRect;
              OffsetRect(CRect, ALeft - 1, ATop);

              Canvas.CopyRect(CRect, B.Canvas, BRect);
            finally
              B.Free;
            end;
            DrawBorderEx(ARect, dsDown);
         end;
       csFlatBorder:
         begin
           BRect := ARect;
           InflateRect(BRect, 1, 1);
           Dec(BRect.Right);
           with BRect do
             ExcludeClipRect(Canvas.Handle, Left, Bottom - 1, Right, Bottom);
           FrameRect(Canvas.Handle, BRect, Canvas.Brush.Handle);
           InflateRect(BRect, 1, 1);
           BBrush := CreateSolidBrush(clDarkShadow);
           FrameRect(Canvas.Handle, BRect, BBrush);
           DeleteObject(BBrush);
           Indicators.Draw(Canvas, ALeft - 1, ATop, ImageIndex);
         end;
      end;
    end
    else begin
      Indicators.Draw(Canvas, ALeft-1, ATop, ImageIndex);
      DrawBorderEx(ARect, dsUp);
    end;
  end;

  function FrozenTreeBorder: boolean;
  begin
    Result := (ColType = dcTreePath) and (tgeTreeSelect in OptionsEx) and
      not(tgTreePathCompletion in Options);
  end;

  function CellTreeBorder: boolean;
  begin
    Result := not(ColType in [dcMarker, dcIndicator, dcTreePath])
      and (tgeTreeSelect in OptionsEx) and not(tgTreePathCompletion in Options);
  end;

begin
  if (csLoading in ComponentState) then
  begin
    Canvas.Brush.Color := Color;
    Canvas.FillRect(ARect);
    Exit;
  end;
  BorderStyle := GetBorderStyle;
  Indicators := GDGetImages;
  ActiveControl := IsActiveControl;

  if (ClickedCol <> -1) and (ACol = ClickedCol) then
  begin
    if (ClickedType = ctTitleClick) then
    begin
      BorderState := dsDown;
      MenuState   := dsUp;
    end
    else begin
      BorderState := dsUp;
      MenuState   := dsDown;
    end
  end
  else begin
    BorderState := dsUp;
    MenuState   := dsUp;
  end;

  ColType := GetFixedColType(ACol, 0);
  RowType := GetFixedRowType(ARow, 0);

  Dec(ARow, FTitleOffset);
  Dec(ACol, FIndicatorOffset);

  if (gdFixed in AState) and (RowType = drGrid) and
    ((ColType = dcColumn) or FrozenTreeBorder) then
    FrozenCol := True
  else
    FrozenCol := False;

  if CellTreeBorder and not(RowType = drTitle) or FrozenCol then
    CellBorder := False
  else
    CellBorder := True;

  if CellBorder and (gdFixed in AState) and
     ([tgRowLines, tgColLines] * Options = [tgRowLines, tgColLines]) then
  begin
    InflateRect(ARect, -1, -1);
    FrameOffs := 1;
  end
  else
    FrameOffs := 2;

  CellData := DoBeginDrawCell;
  try
    if ARow >= 0 then
    begin
      DrawKnot := GetKnotByCell(ARow);
      if (DrawKnot <> nil) and (DrawKnot <> FKnots.Root) then
        KnotFound   := True
      else
        KnotFound := False;
    end
    else
      KnotFound := False;

    if (gdFixed in AState) and (ACol < 0)
    then begin
      if CellBorder then
        Canvas.Brush.Color := FixedColor
      else
        Canvas.Brush.Color := Self.Color;
      if (ColType <> dcTreePath) or (ARow < 0) or not KnotFound then
        Canvas.FillRect(ARect);
      case ColType of
        dcIndicator:
          begin
            ALeft := (ARect.Right + ARect.Left - Indicators.Width -
              FrameOffs) shr 1 + 1;
            ATop  := (ARect.Top + ARect.Bottom - Indicators.Height) shr 1;
            if ARow = RawToDataRow(Row) then
            begin
              case FKnots.State of
                ksInsert: Indicator := nbmInsert;
                ksEdit  : Indicator := nbmEdit;
                ksBrowse: Indicator := nbmArrow;
                else
                  Indicator := nbmArrow;
              end;
              Indicators.Draw(Canvas, ALeft, ATop, Indicator, True);
            end;
            if RowType = drTitle then
            begin
              if (tgeIndicatorMenu in OptionsEx) then
                DrawFixedCellFrame(dcIndicator, nbmMain)
              else begin
                if not( not(tgRowLines in Options) and (BorderStyle = ebsNone) ) then
                begin
                  InflateRect(ARect, 1, 1);
                  if BorderStyle <> ebsNone then
                    DrawGridFrameBorder(Canvas, ARect, BorderStyle, dsUp, FixedColor)
                  else
                    DrawFixedBorder(ARect, True);
                end;
              end;
              Exit;
            end;
          end;
        dcMarker:
          begin
            ALeft := (ARect.Right + ARect.Left - Indicators.Width -
              FrameOffs) shr 1 + 2;
            ATop  := (ARect.Top + ARect.Bottom - Indicators.Height) shr 1 - 1;
            if (ARow >= 0) and KnotFound and
              FBookmarks.Selected(GetBookmark(DrawKnot)) then
            begin
              Inc(ALeft, 2);
              Indicators.Draw(Canvas, ALeft-1, ATop, nbmCheck);
            end;
            if RowType = drTitle then
            begin
              DrawFixedCellFrame(dcMarker, nbmCheckHrd);
              Exit;
            end;
          end;
        dcTreePath :
          if ARow >= 0 then
          begin
            if tgTreePathCompletion in Options then
            begin
              if (tgRowLines in Options) then InflateRect(ARect, 0, 1);
              if (tgColLines in Options) then InflateRect(ARect, 1, 0);
              if DrawKnot <> nil then
                DrawTreePathCell(GetTreePathRect(ARow, ARect,
                  DrawKnot.HasChildren), ARect, ACellState, KnotFound, DrawKnot)
              else
                DrawTreePathCell(GetTreePathRect(ARow, ARect, False),
                  ARect,ACellState, KnotFound, DrawKnot);
              Exit;
            end
            else
              DrawTreePathCell(ARect, ARect, ACellState, KnotFound, DrawKnot);
          end;
      end;
    end
    else with Canvas do
    begin
      if (ACol >-1) and (ACol < FColumns.Count) then
      begin
        DrawColumn := Columns[ACol];
        if (ARow < 0) then
        begin
          case RowType of
            drTitle:
              begin
                if not(kcVisible in DrawColumn.Options) then Exit;
                if kcPopupMenu in DrawColumn.Options then
                begin
                  if GetTitleMenuRect(ARect, PopupRect) then
                  begin
                    ARect.Right := PopupRect.Left - 1;
                    InflateRect(PopupRect, 1, 1);
                    DrawTitlePopup(Canvas, PopupRect, MenuState, DrawColumn);
                  end;
                end;
                DrawTitleCell(Canvas, ACol, ARow, ARect, BorderState, True, True);
              end;
            else begin
              Canvas.Brush.Color := FixedColor;
              if (goHorzLine in inherited Options) then
                InflateRect(ARect, 1, 1);
              Canvas.FillRect(ARect);
              Exit;
            end;
          end;
        end
        else begin
          if not(kcVisible in DrawColumn.Options) or
             ((ARow = RawToDataRow(FInplaceRow)) and
              (ACol = RawToDataColumn(FInplaceCol)))
          then
            Exit;

          if DrawBuffered then
          begin
            PSize.X := ARect.Right  - ARect.Left;
            PSize.Y := ARect.Bottom - ARect.Top;
            if tgFlatLines in Options then
            begin
              if tgColLines in Options then Dec(PSize.X);
              if tgRowLines in Options then Dec(PSize.Y);
            end;
            DrawBitmap.Width  := PSize.X;
            DrawBitmap.Height := PSize.Y;

            with DrawBitmap, DrawBitmap.Canvas do
            begin
              DrawRect := Rect(0,0, Width, Height);
              if DoDrawCell(Canvas, ARect) then
                Self.Canvas.Draw(ARect.Left, ARect.Top, DrawBitmap);
            end;
          end
          else begin
            DrawRect := ARect;
            DoDrawCell(Canvas, ARect);
          end;
        end;
      end
      else begin
        if not(gdFixed in AState) then
          Brush.Color := Color
        else
          Brush.Color := FixedColor;
        Canvas.FillRect(ARect);
      end;
    end;
  finally
    DoEndDrawCell(CellData);
  end;
  if CellBorder and (gdFixed in AState) then DrawBorderEx(ARect, BorderState);
  PaintPolyLine(Canvas.Handle, FGridStruct);
  FGridStruct.Index := 0;
end;

procedure TDCCustomTreeGrid.EndLayout;
begin
  if FLayoutLock > 0 then
  begin
    try
      try
        if FLayoutLock = 1 then
        begin
          InternalLayout;
        end;
      finally
        if FLayoutLock = 1 then
          FColumns.EndUpdate;
      end;
    finally
      Dec(FLayoutLock);
      EndUpdate;
      if FUpdateLock = 0 then inherited ColWidthsChanged;
    end;
  end;
end;

procedure TDCCustomTreeGrid.EndUpdate;
begin
  if FUpdateLock > 0 then
    Dec(FUpdateLock);
  UnlockUpdate;
  if not UpdateLocked and FEditorMode and (FUpdateLock = 0) then
    InplaceUpdateLoc(FIInplaceEditor, CellRect(FInplaceCol, FInplaceRow), Canvas);
end;

function TDCCustomTreeGrid.GetFixedColType(ACol, AOffset: integer): TFixedCol;
 var
  i: integer;
begin
  ACol := ACol + AOffset;
  if ACol < 0 then
  begin
    Result := dcNone;
    Exit;
  end;
  Result := dcColumn;

  if (ACol >= FIndicatorOffset) then
  begin
    Exit;
  end;

  i := 0;
  if tgIndicator in Options then Inc(i,4);
  if tgMarker in Options then Inc(i,2);
  if tgTreePath in Options then Inc(i,1);

  if i shr (2+ACol) > 0 then
    Result := dcIndicator
  else
  if i and 6 = (2 + ACol*4) then
    Result := dcMarker
  else
  if ((i and 1 = 1) and (TreePathWidth > 0)) or (GridHitTest = gtTreePath) then
    Result := dcTreePath
end;

function TDCCustomTreeGrid.GetHitTestInfoAt(KnotItem: TKnotItem;
  X, Y: integer): TTreeGridHitTest;
 var
  BP: TPoint;
  ALevel: integer;
begin
  Result := htNowere;

  with KnotItem do
  begin
    if [tgeShowLines, tgeShowButtons] * OptionsEx <> [] then
      ALevel := Level
    else
      ALevel := Level - 1;

    if HasChildren then
    begin
      BP.X := ALevel * Indent;
      BP.Y := (ALevel+1) * Indent + 1;

      if (X >= BP.X) and (X <= BP.Y) and (tgeShowButtons in OptionsEx) then
      begin
        Result := htOnButton;
        Exit;
      end;

    end
    else begin
      BP.X := (ALevel+1) * Indent;
      BP.Y := BP.X;
    end;

    if (X < BP.X) then
       Exit;

    if (Images<>nil) and
       ((KnotItem.KnotID =  SelectedKnot.KnotID) and (SelectImage>-1) or
       (KnotItem.KnotID <> SelectedKnot.KnotID) and (NormalImage>-1))
    then begin
      BP.X := BP.Y + 1;
      BP.Y := BP.Y + Images.Width + 5;

      if (X >= BP.X) and (X <= BP.Y) then begin
        Result := htOnIcon;
        Exit;
      end;

    end;

    Result := htOnLabel;
  end;
end;

function TDCCustomTreeGrid.GetSelectedIndex: Integer;
begin
  Result := RawToDataColumn(Col);
end;

function TDCCustomTreeGrid.GetTreePathWidth: integer;
begin
  if not(tgTreePath in Options) then
    Result := 0
  else begin
    if GroupingEnabled and (GroupBox.Count > 0) then
    begin
      if tgTreePathCompletion in Options then
        Result := GroupBox.Count * Indent - 1
      else
        Result := GroupBox.Count * Indent + 3
    end
    else
      if FTreePathWidth <> 0
      then
        Result := FTreePathWidth
      else
        Result := TreeIconWidth;
  end;
end;

procedure TDCCustomTreeGrid.HideClipPopup;
begin
  if FClipDown then FClipPopup.Hide;
end;

function TDCCustomTreeGrid.HighlightCell(DataCol, DataRow: Integer;
  AState: TGridDrawState; KnotItem: TKnotItem; Focused: boolean): Boolean;
begin
  Result := False;
  if (tgMultiSelect in Options) and (FKnots.Count>0) then
    Result := FBookmarks.Selected(GetBookmark(KnotItem));
  if Options * [tgMultiSelect, tgRowSelect] <> [tgMultiSelect, tgRowSelect] then
  begin
    if not Result then
      Result := (gdSelected in AState)
        and ((tgAlwaysShowSelection in Options) or Focused)
        and ((UpdateLock = 0) or (tgRowSelect in Options));
  end;
end;

procedure TDCCustomTreeGrid.InternalLayout;
 var
  AColCount, I, ATitleOffset: integer;
  LayoutData: Pointer;

  procedure MeasureTitleHeights;
  var
    K: Integer;
    RestoreCanvas: Boolean;
  begin
    RestoreCanvas := not HandleAllocated;
    if RestoreCanvas then Canvas.Handle := GetDC(0);
    try
      Canvas.Font := Font;
      K := Canvas.TextHeight('Wg') + 3;
      if tgRowLines in Options then
        Inc(K, GridLineWidth);
      if not(tgUserRowHeight in Options) and (DefaultRowHeight <> K) then
        DefaultRowHeight := K;
      SetTitleHeight;
    finally
      if RestoreCanvas then
      begin
        ReleaseDC(0, Canvas.Handle);
        Canvas.Handle := 0;
      end;
    end;
  end;

begin
  FIndicatorOffset := 0;
  if tgIndicator in Options then Inc(FIndicatorOffset);
  if tgMarker    in Options then Inc(FIndicatorOffset);
  if tgTreePath  in Options then Inc(FIndicatorOffset);
  if (csLoading in ComponentState) then Exit;

  if HandleAllocated then KillMessage(Handle, CM_DEFERLAYOUT);

  DoubleBuffered := [tgTreePathCompletion, tgDrawFixedLine, tgCompleteLines,
    tgDoubleBuffered] * Options <>[];

  DoubleBuffered := False;

  if GroupingEnabled then GroupBox.FixedCols := FIndicatorOffset;

  AColCount := FIndicatorOffset;
  if FColumns.Count = 0 then Inc(AColCount) else Inc(AColCount, FColumns.Count);
  ColCount := AColCount;

  if inherited FixedCols <> (FIndicatorOffset + FFrozenCols) then
  begin
    inherited FixedCols := FIndicatorOffset + FFrozenCols;
    MoveColRow(FirstSelectCol, Row, True, False);
    ActivateBuffers;
  end;

  ATitleOffset := FTitleOffset;
  if tgTitles in Options then
    FTitleOffset := 1
  else
    FTitleOffset := 0;

  LayoutData := DoBeginInternalLayout;

  try
    MeasureTitleHeights;
    SetColumnAttributes;
    if ATitleOffset <> FTitleOffset then UpdateRowCount;
  finally
    DoEndInternalLayout(LayoutData);
  end;

  if tgAutoSize in Options then
  begin
    if (FSizingIndex > -1) or FTreePathSizing then
    begin
      if FTreePathSizing then FSizingIndex := FIndicatorOffset - 1;
      I := FSizingIndex;
      FSizingIndex := -1;
      UpdateColWidths(I, i <> ColCount - 1);
    end
    else
      UpdateColWidths(-1, True);

    if FColumns.Count  > 0 then
      for I := FIndicatorOffset to ColCount - 1 do
        FColumns[RawToDataColumn(I)].Width := ColWidths[I];
  end;
end;

procedure TDCCustomTreeGrid.InvalidateTitles(AtOnce: boolean = False);
var
  R, R1: TRect;
  DrawInfo: TGridDrawInfo;
begin
  if HandleAllocated and (tgTitles in Options) then
  begin
    if AtOnce then
    begin
      R := BoxRectEx(0, 0, ColCount - 1, 0);
      InvalidateRect(Handle, @R, False);
    end
    else begin
      CalcDrawInfo(DrawInfo);
      with DrawInfo.Horz do
      begin
        R1 := CellRect(LeftCol + VisibleColCount, 0);
        if AtOnce or (not IsRectEmpty(R1) and
          (FFirstGridCell > FirstGridCell)) then
        begin
          R  := Rect(R1.Left, 0, R1.Right, DrawInfo.Vert.FixedBoundary);
          InvalidateRect(Handle, @R, False);
        end;
        FFirstGridCell := FirstGridCell;
      end;
    end;
  end;
end;

procedure TDCCustomTreeGrid.KeyDown(var Key: Word; Shift: TShiftState);
 var
  KeyDownEvent: TKeyEvent;
  DrawInfo: TGridDrawInfo;
  PageWidth, PageHeight: Integer;

  procedure CalcPageExtents;
  begin
    CalcDrawInfo(DrawInfo);
    PageWidth := DrawInfo.Horz.LastFullVisibleCell - LeftCol;
    if PageWidth < 1 then PageWidth := 1;
    PageHeight := DrawInfo.Vert.LastFullVisibleCell - TopRow;
    if PageHeight < 1 then PageHeight := 1;
  end;

  procedure Tab(GoForward: Boolean);
  var
    ACol, Original: Integer;
  begin
    ACol     := Col;
    Original := ACol;
    BeginUpdate;
    try
      while True do
      begin
        if GoForward then
          Inc(ACol) else
          Dec(ACol);
        if ACol >= ColCount then
        begin
          NextRow(False, True, Shift);
          ACol := FIndicatorOffset;
        end
        else if ACol < FIndicatorOffset then
        begin
          PrevRow(False, Shift);
          ACol := RawToDataColumn(ColCount);
        end;
        if (ACol = Original) or
           Assigned(FIInplaceEditor) and FIInplaceEditor.ShowError then Exit;
        if TabStops[ACol] then
        begin
          MoveCol(ACol, 0);
          Exit;
        end;
      end;
    finally
      EndUpdate;
    end;
  end;

 const
  RowMovementKeys = [VK_UP, VK_PRIOR, VK_DOWN, VK_NEXT, VK_HOME, VK_END];
begin
  if not DataVisible then Exit;
  if (DragState <> dsNone) then
  begin
    inherited;
    Exit;
  end;

  if FClipDown then
  begin
    if Key = VK_ESCAPE then
      HideClipPopup
    else
      FClipPopup.KeyDown(Key, Shift);
    Key := 0;
    Exit;
  end;

  KeyDownEvent := OnKeyDown;
  if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
  if not CanGridAcceptKey(Key, Shift) or FKnots.Updating then Exit;

  with FKnots do
    if ssCtrl in Shift then
    begin
      if (Key in RowMovementKeys) then ClearSelection;
      case Key of
        VK_DELETE:
          DeleteRecords(not(tgeConfirmDelete in OptionsEx) or False);
        VK_INSERT:
          begin
            if tgEditing in Options then
            begin
              ClearSelection;
              InsertKnot(True, Shift);
            end;
          end;
        VK_LEFT: MoveCol(FIndicatorOffset, 1);
        VK_RIGHT: MoveCol(ColCount - 1, -1);
        VK_HOME:
          begin
            LockUpdate(True);
            Self.First;
            try
              LeftCol := FixedCols;
              MoveCol(FirstSelectCol, 1);
            finally
              UnlockUpdate(True);
            end;
            ClearSelection;
          end;
        VK_END:
          begin
            LockUpdate(True);
            try
              ClearSelection;
              MoveCol(ColCount - 1, -1);
              Self.Last;
            finally
              UnlockUpdate(True);
            end;
          end;
        VK_NEXT, VK_PRIOR:
          begin
            ClearSelection;
            MoveBy(VisibleRowCount);
          end;
        VK_UP, VK_DOWN:
          begin
            if (GetAllFrozenCols = 0) or (Col >= FixedCols) then
              inherited
            else begin
              LockUpdate;
              try
                SetInternalCol(Col + 1, True);
                inherited;
                SetInternalCol(Col - 1, True);
              finally
                UnlockUpdate;
              end;
            end;
          end;
        VK_ADD:
          SelectItems(smSelect);
        VK_SUBTRACT:
          SelectItems(smDeselect);
      end
    end
    else
    if not(ssAlt in Shift) then
    begin
      if (tgAdvancedSelect in Options) and not (ssShift in Shift) then
        SelectedArea.Clear;
      case Key of
        VK_DOWN:
          begin
            if (ssShift in Shift) and not (tgMultiSelect in Options) then
            begin
              MarkKnot;
              NextRow(False, False, Shift);
            end
            else
              NextRow(True, True, Shift);
            Key := 0;
          end;
        VK_UP:
          begin
            PrevRow(True, Shift);
            if ssShift in Shift then MarkKnot;
            Key := 0;
          end;
        VK_LEFT:
          begin
            if tgRowSelect in Options then
              PrevRow(False, Shift)
            else
              MoveCol(Col - 1, -1);
          end;
        VK_RIGHT:
          begin
            if tgRowSelect in Options then
              NextRow(False, False, Shift)
            else
              MoveCol(Col + 1, 1);
          end;
        VK_INSERT:
          begin
            if (tgeInsertSelect in OptionsEx) then
            begin
              ClearSelection;
              MarkKnot;
              NextRow(True, True, Shift);
            end
            else
              if tgEditing in Options then
              begin
                ClearSelection;
                InsertKnot(False, Shift)
              end;
          end;
        VK_TAB:
          begin
            if not (ssAlt in Shift) then Tab(not (ssShift in Shift));
            Key := 0;
          end;
        VK_ESCAPE:
          begin
            inherited;
            if Key = VK_ESCAPE then
            begin
              _setFlag(FFlags, TGF_ISESCKEYPRESS, True);
              ClearSelection;
              if EditorMode then
              begin
                _setFlag(FFlags, TGF_ISDATAMODIFIED, False);
                HideEditor;
              end
              else
                if (State = ksInsert) then
                begin
                  _setFlag(FFlags, TGF_ROWUPDATED, False);
                  PrevRow(True, Shift);
                end;
            end;
          end;
        VK_HOME:
          if (ColCount = FIndicatorOffset+1) or (tgRowSelect in Options) then
          begin
            SetInternalRow(FTitleOffset);
            MoveCol(FIndicatorOffset, 1);
          end
          else
            MoveCol(FIndicatorOffset, 1);
        VK_END:
          if (ColCount = FIndicatorOffset+1) or (tgRowSelect in Options) then
          begin
            SetInternalRow(RowCount-1);
            MoveCol(ColCount - 1, -1);
          end
          else
            MoveCol(ColCount - 1, -1);
        VK_NEXT:
          begin
            CalcPageExtents;
            NextRow(False, False, Shift, PageHeight);
          end;
        VK_PRIOR:
          begin
            CalcPageExtents;
            PrevRow(False, Shift, PageHeight);
          end;
        VK_F2: ShowEditor;
        VK_DELETE:
          DeleteRecords(True);
      end;
    end;
end;

procedure TDCCustomTreeGrid.KeyPress(var Key: Char);
 var
   KeyPressEvent: TKeyPressEvent;
begin
  if not DataVisible then Exit;
  KeyPressEvent := OnKeyPress;
  _setFlag(FFlags, TGF_ISESCKEYPRESS, False);
  if (FKnots.Count > 0) and
    not(FEditorMode or FKnots.Updating) and (DragState = dsNone) then
    with FSelectedKnot do
    begin
      if HasChildren then
      begin
        case Key of
          '-':
            begin
              Collapse(False);
              Key := #0;
            end;
          '+':
            begin
              Expand(False);
              Key := #0;
            end;
          '*':
            begin
              Expand(True);
              Key := #0;
            end;
        end;
      end;
    end;
  case Key of
    Chr(VK_TAB):
      Key := #0;
    Chr(VK_RETURN):
      begin
        if FEditorMode then
        begin
          FIInplaceEditor.CloseUp(1, True);
          HideEditor;
        end
        else
          ShowEditor;
        Key := #0;
      end;
  end;
  if (Key <> #0) and Assigned(KeyPressEvent) then KeyPressEvent(Self, Key);
end;

procedure TDCCustomTreeGrid.LayoutChanged;
begin
  if AcquireLayoutLock then
    EndLayout;
end;

procedure TDCCustomTreeGrid.Loaded;
begin
  inherited Loaded;
  if FColumns.Count > 0 then
    ColCount := FColumns.Count;
  GroupBoxChanged;
  LayoutChanged;
end;

procedure TDCCustomTreeGrid.MouseDown(Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
 var
  Cell, ACell: TGridCoord;
  GridOptions: TGridOptions;
  R, MenuRect: TRect;
  ARow: integer;
  ColType: TFixedCol;
  ASelected: boolean;
  AX, AY, AClickedCol: integer;
  AOnMouseDown: TMouseEvent;
begin
  FMouseDownRow := -1;
  FreeEditTimer;
  if not AcquireFocus or FKnots.Updating or not DataVisible then Exit;

  AX := X; AY := Y;

  if Y > 0 then
  begin
    Cell := MouseCoord(X, Y);
    R := CellRect(Cell.X, Cell.Y);
    ColType := GetFixedColType(Cell.X, 0);

    if GridHitTest = gtTreePath then
    begin
      ColType := dcTreePath;
      R := CellRect(GetCellByType(ColType), Cell.Y);
    end;

    if IsRectEmpty(R) then Exit;

    if (ssDouble in Shift) and (Button = mbLeft) then
    begin
      if (Cell.Y  >=  FTitleOffset) and
         ((Cell.X >= FIndicatorOffset) or (ColType = dcTreePath))
      then begin
        DblClick;
        if ColType = dcTreePath then
          CellDblClick(ColType, nil)
        else
          if (Cell.Y >= FTitleOffset) and (SelectedIndex < Columns.Count) then
            CellDblClick(ColType, Columns[SelectedIndex]);
        Exit;
      end;
      Shift := Shift - [ssDouble];
    end;

    FMousePoint := Point(X,Y);

    if (Button = mbLeft) and (Cell.Y = 0) then
    begin
      if (ColType = dcIndicator) and (tgeIndicatorMenu in OptionsEx) or
         (ColType = dcMarker) and (tgeMarkerMenu in OptionsEx) then
        ClipClick(ColType, -1)
      else
        if ClickedType = ctTitleClick then HideClipPopup;
    end
    else
      HideClipPopup;

    if (tgTitleClicked in Options) and (tgTitles in Options) and
       (Button = mbLeft) and not Sizing(X, Y) and (Cell.Y=0) and
       (ColType = dcColumn) then
    begin
      AClickedCol := ClickedCol;
      HideClipPopup;
      if (kcPopupMenu in Columns[RawToDataColumn(Cell.X)].Options) and
        GetTitleMenuRect(R, MenuRect) and PtInRect(MenuRect, Point(AX, AY)) then
      begin
        if (ClickedType = ctMenuClick) and (AClickedCol = Cell.X) then
          ClickedType := ctTitleClick
        else begin
          ClickedCol := Cell.X;
          ClickedType := ctMenuClick;
          ClipClick(ColType, Cell.X);
        end;
      end
      else begin
        ClickedCol := Cell.X;
        ClickedType := ctTitleClick;
      end;
      if not(tgColMoving in Options) then InvalidateCell(Cell.X, 0);
    end;

    if ColType = dcTreePath then
    begin
      FMouseDownRow := Row;
    end;

    if Sizing(X, Y) then
    begin
      HideClipPopup;
      Update;
      inherited MouseDown(Button, Shift, X, Y);
      Exit;
    end
    else
      FSizingIndex := -1;

    if (DragKind = dkDock) and (Cell.X < FIndicatorOffset) and
      (Cell.Y < FTitleOffset) and (not (csDesigning in ComponentState)) then
    begin
      BeginDrag(false);
      Exit;
    end;

    if ((csDesigning in ComponentState) or (tgColumnResize in Options)) and
      (Cell.Y < FTitleOffset) then
    begin
      if (tgTitleClicked in Options) and (Button = mbLeft) and (ColType = dcColumn) then
      begin
        if tgColMoving in Options then
        begin
          GridOptions := inherited Options;
          SetInternalOptions(inherited Options - [goColMoving]);
          inherited MouseDown(Button, Shift, X, Y);
          SetInternalOptions(GridOptions);
          InvalidateCell(Cell.X, 0);
        end
        else
         inherited MouseDown(Button, Shift, X, Y);
      end
      else begin
        inherited MouseDown(Button, Shift, X, Y);
      end;
      Exit;
    end;

    with Cell do
    begin
      BeginUpdate;
      try
        if (GridHitTest in [gtGridArea, gtTreePath, gtMarker, gtIndicator]) and
           (not((tgAdvancedSelect in Options) and
                 ([ssShift, ssLeft] * Shift = [ssShift, ssLeft])) or
              (tgMultiSelect in Options)) then
        begin
          ARow := 0;
          ACell.X := 0;
          ACell.Y := 0;
          if ((Y >= FTitleOffset) and ((Y - Row <> 0)) or
            not (tgTitles in Options)) then
          begin
            ARow := Row;
            with FKnots do
              if (State = ksInsert) and not Modified then Delete(FSelectedKnot);
            ACell.Y := Y;
          end;
          if (X >= FixedCols - GetAllFrozenCols) then ACell.X := X;

          if (ACell.Y <> Row) and
            ((ACell.Y <> 0) or not (tgTitles in Options)) then
            MoveBy(ACell.Y - Row);
          if (RawToDataColumn(ACell.X) >= 0) and
            (ACell.X >= FixedCols - GetAllFrozenCols) then
            MoveCol(ACell.X, 0);
          if (ColType = dcTreePath) and (tgeTreeSelect in OptionsEx) then
            MoveCol(GetCellByType(dcTreePath), 0);

          if (ACell.Y <> 0) and (ARow <> Y) and (Row <> Y) and (ARow = Row) then Exit;
        end;

        if FKnots.Count > 0 then
        with FSelectedKnot do
        begin
          if HideEditor then
          begin
            case ColType of
              dcMarker:
                if GridHitTest = gtMarker then with FBookmarks do
                begin
                  Select(CurrentBookmark, not Selected(CurrentBookmark));
                  InvalidateCell(Cell.X, Cell.Y);
                end;
              dcTreePath:
                if HasChildren and (GetHitTestInfoAt(FSelectedKnot,
                  FMousePoint.X - R.Left, FMousePoint.Y-R.Top) = htOnButton) then
                begin
                   if Expanded then
                     Collapse(False)
                   else
                     Expand(False);
                end;
              dcColumn:
                if GridHitTest = gtGridArea then
                begin
                  if (tgTreePathCompletion in Options) and HasChildren and
                    (GetHitTestInfoAt(FSelectedKnot, FMousePoint.X - R.Left,
                    FMousePoint.Y - R.Top) = htOnButton) then
                  begin
                   if Expanded then
                     Collapse(False)
                   else
                     Expand(False);
                  end;

                  if tgMultiSelect in Options then
                  with FBookmarks do
                  begin
                    FSelecting := False;
                    ASelected := Selected(CurrentBookmark);
                    if ASelected then
                    begin
                      {Check Drag&Drop !!}
                      if ssCtrl in Shift then
                        Select(CurrentBookmark, not ASelected)
                      else
                      begin
                        Clear;
                        Select(CurrentBookmark, True);
                      end;
                    end
                    else begin
                      if ssCtrl in Shift then
                        Select(CurrentBookmark, not ASelected)
                      else
                      begin
                        Clear;
                        Select(CurrentBookmark, True);
                      end;
                    end;
                  end
                  else
                    if tgAdvancedSelect in Options then
                      SelectedArea.MouseDown(FMousePoint.X, FMousePoint.Y, Cell, Shift);
                end;
            end;
          end;
        end;
      finally
        EndUpdate;
        AOnMouseDown := OnMouseDown;
        if Assigned(AOnMouseDown) then AOnMouseDown(Self, Button, Shift, AX, AY);
      end;
    end;
  end
  else
    inherited;
end;

procedure TDCCustomTreeGrid.MouseMove(Shift: TShiftState; X, Y: Integer);
var
  Cell: TGridCoord;
  OldCurrentCol, LabelOffset: integer;
  R: TRect;
  KnotItem: TKnotItem;
  P: TPoint;
  Text: string;
  CellX, CellY: integer;
begin
  if FKnots.Updating or not DataVisible then Exit;
  Cell := MouseCoord(X,Y);

  OldCurrentCol := FCurrentCol;
  if ClickedCol <> -1 then FCurrentCol := Cell.X else FCurrentCol := -1;

  if (DragState = dsNone) and (Cell.X >= FixedCols) and
     (ClickedCol <> -1) and (ClickedType = ctTitleClick) and
     (FGridState <> gsColMoving) and (tgColMoving in Options) and
     ((Abs(FMousePoint.X - X) > 5) or (Abs(FMousePoint.Y - Y) > 5) ) then
  begin
     FGridState := gsColMoving;
     inherited MouseDown(mbLeft, Shift, FMousePoint.X, FMousePoint.Y);
     if (FGridState = gsColMoving) or (DragState = dsColMoving) then Exit;
  end;

  inherited MouseMove(Shift, X, Y);

  if (ClickedCol <> -1) and (FCurrentCol <> OldCurrentCol) and
     (FGridState <> gsColMoving) and (DragState = dsNone) then
  begin
    InvalidateCell(ClickedCol, 0);
  end;

  if not FKnots.Updating then
  begin
    R := CellRect(Cell.X, Cell.Y);
    KnotItem := GetKnotByCell(RawToDataRow(Cell.Y));
    if (GridHitTest = gtTreePath) and (Cell.Y >= FTitleOffset)
    then begin
      if Assigned(KnotItem) and (KnotItem.Level > -1) then
        case GetHitTestInfoAt(KnotItem, X - R.Left, Y - R.Top) of
          htOnIcon ,
          htOnLabel :
            if not(tgTreePathCompletion in Options) then
            begin
              LabelOffset := GetHintTreeOffset(KnotItem, htOnLabel);
              GetTreePathCaption(KnotItem, Text);
              P := DrawHighLightText(Canvas, PChar(Text), Rect(0, 0, 0, 0), 0);
              Canvas.Font := Self.Font;
              if ((R.Left + LabelOffset + P.X + 2) > R.Right) and (X < R.Right)
              then begin
                if (FHintRow <> -1) and (FHintRow = Cell.Y) then Exit;
                CellX := Cell.X;
                CellY := Cell.Y;
                if (tgeTreeSelect in OptionsEx) and
                  (tgRowLines in Options) then R.Left := R.Left - 1;
                ShowHintWindow(CellX, CellY, R.Left - 1 + LabelOffset, R.Top + 1,
                  Text);
              end
              else
                HideHintWindow;
            end;
          else
            HideHintWindow;
        end;
    end
    else begin
      HideHintWindow;
      if (Cell.Y < FTitleOffset) and (RawToDataColumn(Cell.X)>=0) and (Columns.Count > 0) then
      begin
        if RawToDataColumn(Cell.X) <> FColumnCell then
        begin
          FColumnCell := RawToDataColumn(Cell.X);
          DoColumnComment(MODE_SHOWWINDOW, Columns[FColumnCell]);
        end;
      end
      else begin
        DoColumnComment(MODE_HIDEWINDOW, nil);
        {    hinta      }
      end;
    end;
  end;

end;

procedure TDCCustomTreeGrid.MouseUp(Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  Cell: TGridCoord;
  SaveState: TGridState;
  SaveDragState: TDragGridState;
  MouseClick: boolean;
  OldClickedCol, NewSize, ASizingIndex, nColumn: integer;
  R: TRect;
  ColType: TFixedCol;
  MouseUpEvent: TMouseEvent;
  DrawInfo: TGridDrawInfo;
begin
  SaveState := FGridState;
  SaveDragState := DragState;
  ASizingIndex := FSizingIndex;

  MouseClick := (ClickedCol <> -1) and
    ((FCurrentCol = -1) or (ClickedCol = FCurrentCol)) and
    (ClickedType <> ctMenuClick);

  if (SaveState = gsColSizing) and (ASizingIndex < FixedCols) then
  begin
    try
      MouseUpEvent := OnMouseUp;
      if Assigned(MouseUpEvent) then MouseUpEvent(Self, Button, Shift, X, Y);
    finally
      CalcDrawInfo(DrawInfo);
      DrawSizingLineEx(DrawInfo, FGridState, X + FSizingOff, Y);
      FGridState := gsNormal;
    end;
  end
  else
    inherited MouseUp(Button, Shift, X, Y);

  Cell := MouseCoord(X,Y);

  ColType := GetFixedColType(Cell.X, 0);

  if (SaveState = gsColSizing) and (FSizingIndex < FixedCols) then
  begin
    if FTreePathSizing then
    begin
      R := CellRect(FIndicatorOffset-1, Cell.Y);
      if (X- R.Left + FSizingOff) < TreeIconWidth then
        TreePathWidth := TreeIconWidth
      else
        TreePathWidth := X - R.Left + FSizingOff;

    end
    else
      if ASizingIndex < FixedCols then
      begin
        R := CellRect(ASizingIndex, Cell.Y);
        NewSize := _intMax(5, X - R.Left + FSizingOff);
        nColumn := RawToDataColumn(ASizingIndex);
        if (nColumn < Columns.Count) and (nColumn >= 0) and
          (kcPopupMenu in Columns[nColumn].FOptions) then
          NewSize := _intMax(12, NewSize);
        ColWidths[ASizingIndex] := NewSize;
        UpdateDesigner;
      end;
  end;

  if (Button = mbLeft) and (ClickedCol <> -1) and
    (ClickedType <> ctMenuClick) then
  begin
    OldClickedCol := ClickedCol;
    ClickedCol := -1;
    InvalidateCell(OldClickedCol, 0);
  end;

  if (SaveState = gsRowSizing) or (SaveState = gsColSizing) or
    ((InplaceEditor <> nil) and (InplaceEditor.Visible) and
     (PtInRect(InplaceEditor.BoundsRect, Point(X,Y))))
  then
    Exit;

  if (SaveState in [gsColMoving,  gsRowMoving]) or
    (SaveDragState = dsHeaderMoving) then
  begin
    UpdateInplaceEditor;
  end;

  if (Button = mbLeft) and (ColType = dcColumn) and
     (GridHitTest in [gtColumn, gtGridArea]) and (SaveState <> gsColMoving) and
     not(SaveDragState in [dsColMoving, dsHeaderMoving])
  then begin
    if (GridHitTest = gtColumn) and MouseClick then
      DoColumnClick(Shift, Cell.X)
    else
      if RawToDataColumn(Cell.X) < Columns.Count then
        CellClick(Columns[RawToDataColumn(Cell.X)]);
  end;

  if (GridHitTest = gtTreePath) and (FKnots.Count > 0) and
     (FMouseDownRow <> -1) and (FMouseDownRow = Cell.Y)
  then begin
    R := CellRect(Cell.X, Cell.Y);
    if (GetHitTestInfoAt(FSelectedKnot, X-R.Left, Y-R.Top) = htOnLabel) and
      (tgeShowTreeEdit in OptionsEx) then
    begin
      if FEditTimerID = -1 then
        FEditTimerID := SetTimer(Handle, 101, GetDoubleClickTime, nil);
    end;
    FMouseDownRow := 1;
  end;
end;

procedure TDCCustomTreeGrid.MoveCol(RawCol, Direction: Integer);
var
  OldCol: Integer;
  NewRaw: integer;

  function IsColValid(ACol: integer): boolean;
  begin
    Result := (ACol < ColCount) and ((ACol >= FIndicatorOffset) or
      (tgeTreeSelect in OptionsEx) and (GetFixedColType(ACol, 0) = dcTreePath));
  end;
begin
  if RawCol >= ColCount then RawCol := ColCount - 1;
  NewRaw := FixedCols - GetAllFrozenCols;
  if RawCol < NewRaw then RawCol := NewRaw;
  if Direction <> 0 then
  begin
    while (RawCol < ColCount) and (RawCol >= FIndicatorOffset) and
      (ColWidths[RawCol] <= 0) do
      Inc(RawCol, Direction);
    if not IsColValid(RawCol) then Exit;
  end;
  OldCol := Col;
  if RawCol <> OldCol then
  begin
    if HideEditor then
    begin
      if RawCol < FixedCols then
        SetInternalCol(RawCol, GetAllFrozenCols > 0)
      else
        SetInternalCol(RawCol, False)
    end;
  end;
end;

function TDCCustomTreeGrid.RawToDataColumn(ACol: Integer): Integer;
begin
  Result := ACol - FIndicatorOffset;
end;

procedure TDCCustomTreeGrid.RowHeightsChanged;
var
  i, Changed, DefaultHeight: Integer;
begin
  if not _getFlag(FFlags, TGF_ROWHEIGHTCHANGED) then
  begin
    _setFlag(FFlags, TGF_ROWHEIGHTCHANGED, True);
    Changed := -1;
    DefaultHeight := DefaultRowHeight;

    if tgeShowLines in OptionsEx then
    begin
      if (tgRowLines in Options) and not(tgFlatLines in Options) then
        if DefaultHeight mod 2 = 0 then
        begin
          Changed := -2;
          Inc(DefaultHeight)
        end
        else
      else
        if DefaultHeight mod 2 <> 0 then
        begin
          Changed := -2;
          Inc(DefaultHeight)
        end;
      if Changed = -2 then
      begin
        DefaultRowHeight := DefaultHeight;
        Exit;
      end;
    end;

    for i := Ord(tgTitles in Options) to RowCount do
      if RowHeights[i] <> DefaultHeight then
      begin
        Changed := i;
        Break;
      end;
    if Changed <> -1 then
    begin
      if Changed = -2 then
        DefaultRowHeight := DefaultHeight
      else
        DefaultRowHeight := RowHeights[i];
      if FLayoutLock = 0 then InternalLayout;
    end
    else
      UpdateRowCount;
    if not(tgAutoSize in Options) then
      inherited
    else
      UpdateVertScrollBar;
    SetTitleHeight;
    _setFlag(FFlags, TGF_ROWHEIGHTCHANGED, False);
  end;
end;

function TDCCustomTreeGrid.SelectCell(ACol, ARow: Integer): Boolean;
 var
  DrawInfo: TGridDrawInfo;
  Rgn1, Rgn2: HRGN;
begin
  Result := inherited SelectCell(ACol, ARow);
  DoSelectCell(Self, ACol, ARow, Result);
  if FEditorMode and Result  then
  begin
    SendMessage(FIInplaceEditor.Handle, CM_EXIT, 0, 0);
    if FIInplaceEditor.ShowError then Result := False;
  end;

  if Result and ((ARow <> Row) or (ACol <> Col)) and EditorMode then
    HideEditor;

  if Result and (ARow <> Row) then
  begin
    CalcDrawInfo(DrawInfo);
    _setFlag(FFlags, TGF_ROWUPDATED, False);

    Rgn1 := GetRowUpdateRgn(Row);
    if ARow <= DrawInfo.Vert.LastFullVisibleCell then
      Rgn2 := GetRowUpdateRgn(ARow)
    else begin
      with DrawInfo.Vert do
        Rgn2 := GetRowUpdateRgn(LastFullVisibleCell+1)
    end;

    CombineRgn(Rgn1, Rgn1, Rgn2, RGN_OR);

    InvalidateRgn(Handle, Rgn1, False);
    DeleteObject(Rgn1);
    DeleteObject(Rgn2);

    FKnots.SetState(ksBrowse);
  end;
end;

procedure TDCCustomTreeGrid.SetClipDown(const Value: boolean);
 var
   R: TRect;
begin
  if FClipDown <> Value then
  begin
    FClipDown := Value;
    if FClipPopup.ColType <> dcColumn then
    begin
      R := CellRect(GetCellByType(FClipPopup.ColType), 0);
      if GridDrawing.ClipStyle = csFlatBorder then InflateRect(R, 1, 1);
      InvalidateRect(Handle, @R, False);
    end
    else
      InvalidateCell(FClipPopup.ColumnIndex, 0);
    Update;
  end;
end;

procedure TDCCustomTreeGrid.SetColumnAttributes;
var
  I, J: Integer;

begin
  for I := 0 to FColumns.Count-1 do
  with FColumns[I] do
  begin
    TabStops[I + FIndicatorOffset]  := ([kcVisible,kcReadOnly]*Options=[kcVisible]);
    ColWidths[I + FIndicatorOffset] := Width;
  end;

  J := 0;
  if (tgIndicator in Options) then
  begin
    ColWidths[J] := IndicatorWidth;
    Inc(J);
  end;
  if (tgMarker in Options) then
  begin
    ColWidths[J] := MarkerWidth;
    Inc(J);
  end;
  if (tgTreePath  in Options) then
    ColWidths[J] := TreePathWidth;

  if FColumns.Count = 0 then ColWidths[FIndicatorOffset] := DefaultColWidth;
  UpdateFrozenCols(FFrozenCols)
end;

procedure TDCCustomTreeGrid.SetColumns(const Value: TKnotColumns);
begin
  Columns.Assign(Value);
end;

procedure TDCCustomTreeGrid.SetKnots(const Value: TKnotItems);
begin
  FKnots.Assign(Value);
  DataChanged;
end;

procedure TDCCustomTreeGrid.SetOptions(Value: TTreeGridOptions);
const
  LayoutOptions = [tgEditing, tgAlwaysShowEditor, tgTitles, tgIndicator,
    tgColLines, tgRowLines, tgRowSelect, tgAlwaysShowSelection, tgMarker,
    tgTitleClicked, tgHighlightRow, tgTreePath, tgCompleteLines,
    tgTreePathCompletion, tgDrawFixedLine, tgFixedLines, tgDoubleBuffered,
    tgFlatLines];
  LayoutInvalidateOptions = [tgDrawFixedLine, tgTreePathCompletion];
var
  NewGridOptions: TGridOptions;
  ChangedOptions: TTreeGridOptions;
begin
  if FOptions <> Value then
  begin
    NewGridOptions := [];
    if tgColLines in Value then
      NewGridOptions := NewGridOptions + [goFixedVertLine, goVertLine];
    if tgRowLines in Value then
      NewGridOptions := NewGridOptions + [goFixedHorzLine, goHorzLine];
    if tgColumnResize in Value then
      NewGridOptions := NewGridOptions + [goColSizing];
    if tgColMoving in Value then
      NewGridOptions := NewGridOptions + [goColMoving];
    if tgRowMoving in Value then
      NewGridOptions := NewGridOptions + [goRowMoving];
    if tgTabs in Value then Include(NewGridOptions, goTabs);
    if tgRowSelect in Value then
    begin
      Include(NewGridOptions, goRowSelect);
      Exclude(Value, tgAlwaysShowEditor);
      Exclude(Value, tgEditing);
    end;

    if tgHighlightRow in Value then
    begin
      Exclude(Value, tgRowSelect);
    end;

    if tgMultiSelect in (FOptions - Value) then ;

    if tgMultiSelect in Value then Value := Value - [tgMarker];

    if tgRowSizing in Value  then
    begin
       NewGridOptions := NewGridOptions + [goRowSizing];
       Value := Value +[tgUserRowHeight];
    end;

    if tgFlatButtons in Value then
      NewGridOptions := NewGridOptions - [goFixedHorzLine, goFixedVertLine];

    if tgFlatLines in Value then
      NewGridOptions := NewGridOptions - [goVertLine, goHorzLine,
        goFixedHorzLine, goFixedVertLine];

    inherited Options := NewGridOptions;

    ChangedOptions := (FOptions + Value) - (FOptions * Value);
    FOptions := Value;

    GridOptions := [];

    LockUpdate(True);
    try
      if tgAutoSize in Value then
        GridOptions := GridOptions + [goAutoSize];
      if tgAdvancedSelect in Value then
        GridOptions := GridOptions + [goAdvancedSelect];
      if not(tgTitles in Value) and (tgTitles in  ChangedOptions) then
        DefaultRowHeight := DefaultRowHeight;
      if tgFlatButtons in ChangedOptions then
      begin
        RecreateWnd;
      end
      else begin
        if ChangedOptions * LayoutOptions <> [] then LayoutChanged;
        if tgAutoSize in Value then
        begin
          UpdateColWidths(-1, True)
        end;
      end;
    finally
      inherited ColWidthsChanged;
      UnlockUpdate(True);
    end;

    if LayoutInvalidateOptions * ChangedOptions <> [] then invalidate;
  end;
end;

procedure TDCCustomTreeGrid.SetSelectedIndex(Value: Integer);
begin
  MoveCol(DataToRawColumn(Value), 0);
end;

procedure TDCCustomTreeGrid.SetTitleFont(const Value: TFont);
begin
  FTitleFont.Assign(Value);
  if tgTitles in Options then LayoutChanged;
end;

procedure TDCCustomTreeGrid.SetTitleHeight;
 var
  I: Integer;
  Heights: array of Integer;
  P: TPoint;
  PopupRect: TRect;
  FixedWidths: array[boolean] of integer;
begin
  FixedWidths[False] := -1;
  Canvas.Font := Font;
  if tgTitles in Options then
  begin
    SetLength(Heights, FTitleOffset);
    for I := 0 to FColumns.Count-1 do
    begin
      with FColumns[I] do
      begin
        FixedWidths[True] := Width - 1;
        if (kcPopupMenu in Options) and
          GetTitleMenuRect(Rect(0, 0, Width, 0), PopupRect) then
        begin
          Dec(FixedWidths[True], PopupRect.Right - PopupRect.Left + 2);
        end;

        Canvas.Font := Title.Font;
        P.Y := GetTextHeightEx(Canvas, Title.Caption,
          FixedWidths[kcWordBreak in FOptions], kcWordBreak in FOptions);
        FColumns[I].FSize := P;
        if P.Y > 0 then Inc(P.Y, 4);
        if (Images <> nil) and (FColumns[I].ItemIndex <> -1) then
           if P.Y < (Images.Height + 3) then P.Y := Images.Height+3;
        Heights[0] := _intMax(P.Y, Heights[0]);
      end;
    end;
    if Heights[0] = 0 then
    begin
      Canvas.Font := FTitleFont;
      Heights[0] := Canvas.TextHeight('Wg') + 4;
    end;
    RowHeights[0] := Heights[0];
  end;
end;

procedure TDCCustomTreeGrid.SetTreePathWidth(const Value: integer);
 var
  J: integer;
begin
  if Value > 0 then
  begin
    FTreePathWidth := Value;
    J := 0;
    if (tgIndicator in Options) then Inc(J);
    if (tgMarker    in Options) then Inc(J);
    if (tgTreePath  in Options) and (J < ColCount) then
    begin
      FSizingIndex := J;
      ColWidths[J] := TreePathWidth;
    end;
    if csDesigning in ComponentState then UpdateDesigner;
  end;
end;

procedure TDCCustomTreeGrid.ShowClipPopup(AColType: TFixedCol; ACol: integer;
  AClipPopup: TObject);
 var
  lShow: boolean;
  R: TRect;
  P: TPoint;
begin
  lShow := True;
  if ACol <> -1 then
    R := CellRect(ACol, 0)
  else
    R := CellRect(GetCellByType(AColType), 0);

  with TKnotClipPopup(AClipPopup) do
  begin
    case GridDrawing.ClipStyle of
      csSingleBorder:
        begin
          PopupBorderStyle := brRaised;
          Shadow.Visible := False;
          P := Point(0, 1);
        end;
      csFlatBorder:
        begin
          PopupBorderStyle := brSingle;
          Shadow.Visible := True;
          P := Point(1, 1);
        end;
    end;
    Hide;
    Color := clWhite;
    ColType := AColType;
    ColumnIndex := ACol;
    AddButtons;

    if ColType = dcColumn then
    begin
      if Assigned(FOnClipClick) then FOnClipClick(AClipPopup, Left, Top, lShow);
      SetBoundsEx(R.Right - Width, R.Bottom - P.Y, Width, Height)
    end
    else begin
      SetBoundsEx(R.Left - P.X, R.Bottom - P.Y, Width, Height);
      if Assigned(FOnClipClick) then FOnClipClick(AClipPopup, Left, Top, lShow);
    end;

    if lShow then
    begin
      ClipDown := not ClipDown;
      if Buttons.Count > 0 then
      begin
        Show;
        if ColumnIndex <> -1 then
          ClickedCol := ColumnIndex
        else
          ClickedType := ctTitleClick;
      end
      else
        HideClipPopup;
    end
    else
      HideClipPopup;
  end;
end;

procedure TDCCustomTreeGrid.TitleClick(Column: TKnotColumn);
begin
  if Assigned(FOnTitleClick) then FOnTitleClick(Self, Column);
end;

procedure TDCCustomTreeGrid.TitleFontChanged(Sender: TObject);
begin
  if (not FSelfChangingTitleFont) and not (csLoading in ComponentState) then
    ParentFont := False;
  if tgTitles in Options then LayoutChanged;
end;

procedure TDCCustomTreeGrid.TopLeftChanged;
 var
  ATopRow: integer;
begin
  if LeftCol < FixedCols then LeftCol := FixedCols;
  if tgTreePathCompletion in Options then InvalidateRect(Handle, nil, False);
  if not FKnots.Updating then
  begin
    ATopRow := RawToDataRow(TopRow);
    FFirstVisible := FKnots.SelectKnot(FFirstVisible, ATopRow - FFirstIndex);
    FFirstIndex   := ATopRow;
    if FEditorMode and (FIInplaceEditor <> nil) then
      InplaceUpdateLoc(FIInplaceEditor, CellRect(FInplaceCol, FInplaceRow), Canvas);
  end;
  HideHintWindow;
  inherited;
  if Assigned(FOnTopLeftChanged) then FOnTopLeftChanged(Self);
end;

procedure TDCCustomTreeGrid.UpdateActive;
 var
  ATopRow: integer;
begin
  if FKnots.Count > 0 then
  begin
    ATopRow := RawToDataRow(TopRow);
    if FFirstIndex <> ATopRow then
    begin
      FFirstVisible := FKnots.SelectKnot(FFirstVisible, ATopRow - FFirstIndex);
      FFirstIndex   := ATopRow;
    end;
    SetSelectedKnot(FKnots.SelectKnot(FFirstVisible, Row - TopRow));
  end
  else
    ActivateBuffers;
end;

function TDCCustomTreeGrid.UpdateRowCount: boolean;
var
  NewFixedRows, i, OldRowCount: integer;
begin
  OldRowCount := RowCount;
  NewFixedRows := FTitleOffset;

  if RowCount <= NewFixedRows then RowCount := NewFixedRows + 1;

  if FixedRows <> NewFixedRows then
  begin
    FixedRows := NewFixedRows;
    ActivateBuffers;
 end;

  i := GetRowCount + NewFixedRows;

  SetInternalRowCount(i);
  FFirstVisible := FKnots.SelectKnot(FKnots.GetFirstVisibleNode, FFirstIndex);
  UpdateActive;

  if OldRowCount <> RowCount then
  begin
    Result := True;
    UpdateVertScrollBar;
    UpdateColWidths(-1, True);
  end
  else
    result := False;
  Invalidate;
end;

procedure TDCCustomTreeGrid.WMKillFocus(var Message: TMessage);
begin
  inherited;
  HideClipPopup;
end;

procedure TDCCustomTreeGrid.WMSetFocus(var Message: TWMSetFocus);
 var
  KeyState: TKeyboardState;
  P: TPoint;
  Cell: TGridCoord;
  lSelected: boolean;
begin
  inherited;
  HideClipPopup;
  MoveCol(Col, 1);
  if not EditorMode or (Message.FocusedWnd <> FIInplaceEditor.Handle) then
    UpdateInplaceEditor;

  GetKeyboardState(KeyState);
  if KeyState[VK_LBUTTON] and $80 <> 0 then
  begin
    GetCursorPos(P);
    P := ScreenToClient(P);
    Cell := MouseCoord(P.X, P.Y);
    lSelected := (RawToDataRow(Cell.Y) < 0) or (Cell.Y = Row)
  end
  else
    lSelected := True;

  if not FEditorMode and lSelected then InvalidateSelected;
end;

procedure TDCCustomTreeGrid.WMSize(var Message: TWMSize);
 var
  R: TRect;
begin
  UpdateColWidths(-1, True);
  if Footers.Height > 0 then
  begin
    R := Footers.BoundsRect;
  end;
  inherited;
  InvalidateTitles;
  if _getFlag(FFlags, TGF_LOCKSCREEN) or not DataVisible then Invalidate
end;

function TDCCustomTreeGrid.HideEditor: boolean;
 var
  UpdateRect: TRect;
begin
  if Assigned(FIInplaceEditor) and FEditorMode then
  begin
    FInplaceCol  := -1;
    FInplaceRow  := -1;

    if _getFlag(FFlags, TGF_ISDATAMODIFIED) then
    begin
      Result := FIInplaceEditor.IsValueValid;
      if not Result then
      begin
          if Col < FixedCols then
            SetInternalCol(Col, GetAllFrozenCols > 0)
          else
            SetInternalCol(Col, False);
         UpdateInplaceEditor;
         FIInplaceEditor.ShowErrorMessage;
         Exit;
      end;

      FEditorMode  := False;
      if FIInplaceEditor.ErrorCode = ERR_EDIT_NONE then UpdateData;
    end
    else
      FEditorMode  := False;

    if GetFocus = FIInplaceEditor.Handle then Windows.SetFocus(Handle);

    FIInplaceEditor.Release;
    FIInplaceEditor := nil;

    UpdateRect := BoxRectEx(0, FInplaceRow , ColCount - 1, FInplaceRow );
    ValidateRect(Handle, @UpdateRect);
    InvalidateRect(Handle, @UpdateRect, False);
    _setFlag(FFlags, TGF_ISESCKEYPRESS, False);
    _setFlag(FFlags, TGF_ROWUPDATED, Modified);

    DoDestroyCellEdit;
  end
  else begin
    if Assigned(FIInplaceEditor) then Windows.SetFocus(Handle);
  end;

  _setFlag(FFlags, TGF_ISDATAMODIFIED, False);
  Result      := True;
end;

procedure TDCCustomTreeGrid.ShowEditor;
begin
  FEditorMode := True;
  UpdateInplaceEditor;
end;

procedure TDCCustomTreeGrid.DoCreateCellEdit(Column: TKnotColumn;
  var Edit: IDCInplaceEditor; var CanCreate: boolean);
begin
  CanCreate := True;
  if Assigned(FOnCreateCellEdit) then
    FOnCreateCellEdit(Self, SelectedKnot, Edit, Column, CanCreate)
  else
    Edit := nil;
end;

procedure TDCCustomTreeGrid.CMInvalidValue(var Message: TMessage);
begin
  if _getFlag(FFlags, TGF_ISESCKEYPRESS) then
    Message.Result := Integer(True)
  else
    Message.Result := Integer(False);
end;

function TDCCustomTreeGrid.Modified: boolean;
begin
  Result := _getFlag(FFlags, TGF_ISDATAMODIFIED) or
    _getFlag(FFlags, TGF_ROWUPDATED);
end;

procedure TDCCustomTreeGrid.SetModified(Value: boolean);
begin
  if _getFlag(FFlags, TGF_ISDATAMODIFIED) <> Value then
  begin
    _setFlag(FFlags, TGF_ISDATAMODIFIED, Value);
    if FKnots.State <> ksInsert then FKnots.SetState(ksEdit);
  end;
end;

procedure TDCCustomTreeGrid.UpdateData;
begin
  if Modified and (SelectedKnot <> nil) then
  begin
    if (FInplaceCol >= FIndicatorOffset) then
      DoUpdate(SelectedKnot, FIInplaceEditor, Columns[RawToDataColumn(FInplaceCol)])
    else
      DoUpdate(SelectedKnot, FIInplaceEditor, nil);
  end;
  if not EditorMode then Knots.SetState(ksBrowse);
end;

procedure TDCCustomTreeGrid.WMChar(var Msg: TWMChar);
begin
  if not DataVisible then Exit;
  if FClipDown then
    SendMessage(FClipPopup.Handle, WM_CHAR, Msg.CharCode, Msg.KeyData);
  if (tgEditing in Options) and (Char(Msg.CharCode) in [^H, #32..#255]) then
    if not FEditorMode and (Char(Msg.CharCode) in ['+', '-', '*']) then
      inherited
    else begin
      if not ShowEditorChar(Char(Msg.CharCode)) then inherited
    end
  else
    inherited;
end;

function TDCCustomTreeGrid.ShowEditorChar(Ch: Char): boolean;
begin
  Result := True;
  if not FEditorMode then
  begin
    ShowEditor;
    if FIInplaceEditor <> nil then
      PostMessage(FIInplaceEditor.Handle, WM_CHAR, Word(Ch), 0)
    else
      Result := False;
  end;
end;

procedure TDCCustomTreeGrid.CalcSizingState(X, Y: Integer;
  var State: TGridState; var Index, SizingPos, SizingOfs: Integer;
  var FixedInfo: TGridDrawInfo);
var
  EffectiveOptions: TGridOptions;
  ACol, AWidth, j, i: integer;

  function GetRange(const AxisInfo: TGridAxisDrawInfo): integer;
  begin
    Result := _IntMax(AxisInfo.EffectiveLineWidth, 7);
  end;

  procedure CalcAxisState(const AxisInfo: TGridAxisDrawInfo; Pos: Integer;
    NewState: TGridState; Width, Frozen: integer; IsCol: boolean);
  var
    I, Line, Back, Range, J, K: Integer;
    lChecked: boolean;

    function CellVisible(I: integer): boolean;
    begin
      if IsCol then
        Result := (GetFixedColType(I, 0) <> dcColumn) or
          (RawToDataColumn(I) < Columns.Count) and
          (kcVisible in Columns[RawToDataColumn(I)].Options)
      else
        Result := True
    end;

  begin
    if UseRightToLeftAlignment then
      Pos := ClientWidth - Pos;
    with AxisInfo do
    begin
      Range := GetRange(AxisInfo);
      Back := (Range - EffectiveLineWidth) shr 1;

      Line := FixedBoundary - Width;
      J := FixedCellCount - Frozen;
      K := FirstGridCell;
      for I := J to GridCellCount - 1 do
      begin
        if CellVisible(I) then
        begin
          lChecked := (IsCol and (I < FixedCols)) or (I >= K);
          if lChecked then
          begin
            Inc(Line, GetExtent(I));
            if (Pos >= Line - Back) and (Pos <= Line - Back + Range) then
            begin
              State := NewState;
              SizingPos := Line;
              SizingOfs := Line - Pos;
              Index := I;
              Exit;
            end;
            Inc(Line, EffectiveLineWidth);
          end;
          if Line > (GridBoundary - Back + Range) then Break;
        end
        else
          Dec(Line, EffectiveLineWidth);
      end;
      if (GridBoundary = GridExtent) and (Pos >= GridExtent - Back)
        and (Pos <= GridExtent) then
      begin
        State := NewState;
        SizingPos := GridExtent;
        SizingOfs := GridExtent - Pos;
        Index := I;
      end;
    end;
  end;

  function XOutsideHorzFixedBoundary: Boolean;
  begin
    with FixedInfo do
      if not UseRightToLeftAlignment then
        Result := X > (Horz.FixedBoundary-AWidth)
      else
        Result := X < ClientWidth - (Horz.FixedBoundary-AWidth);
  end;

  function XOutsideOrEqualHorzFixedBoundary: Boolean;
  begin
    with FixedInfo do
      if not UseRightToLeftAlignment then
        Result := X >= (Horz.FixedBoundary-AWidth)
      else
        Result := X <= ClientWidth - (Horz.FixedBoundary-AWidth);
  end;

begin
  if not(tgTitles in Options) and not(tgColumnSizing in Options)then Y := -1;

  ACol := 0;

  State := gsNormal;
  Index := -1;
  EffectiveOptions := inherited Options;
  if csDesigning in ComponentState then
    EffectiveOptions := EffectiveOptions + DesignOptionsBoost;
  if [goColSizing, goRowSizing] * EffectiveOptions <> [] then
    with FixedInfo do
    begin
      Vert.GridExtent := ClientHeight;
      Horz.GridExtent := ClientWidth;
      if tgTreePath in Options then
        AWidth := FixedInfo.Horz.GetExtent(GetCellByType(dcTreePath)) +
          GetRange(Horz) shr 2
      else
        AWidth :=  0;
      with Horz do
      begin
        j := FixedCols - FrozenCols;
        for i := j to FixedCols - 1 do Inc(AWidth, GetExtent(i));
      end;

      if (Y > 0) and (XOutsideHorzFixedBoundary) and (goColSizing in EffectiveOptions) then
      begin
        if (Y >= Vert.FixedBoundary) and not(tgColumnSizing in Options) then Exit;
        j := FrozenCols;
        if tgTreePath in Options then inc(j);
        for i := 0 to Columns.Count - 1 do
        begin
          if not(kcVisible in Columns[i].Options) and (j > FrozenCols) then
            Inc(j)
          else
            Break
        end;
        CalcAxisState(Horz, X, gsColSizing, AWidth, j, True);
      end
      else if (Y > Vert.FixedBoundary) and (goRowSizing in EffectiveOptions) then
      begin
        if XOutsideOrEqualHorzFixedBoundary then Exit;
        CalcAxisState(Vert, Y, gsRowSizing, 0, 0, False);
      end;
    end;

  FTreePathSizing := GetFixedColType(Index, 0) = dcTreePath;

  if (State = gsColSizing)then
  begin
    ACol := RawToDataColumn(Index);
    if (ACol >= 0) and (ACol < Columns.Count) and
     not( (Columns[ACol].Options * [kcSizing, kcVisible] = [kcSizing, kcVisible]) or
          (csDesigning in ComponentState) ) or (ACol < 0) and not FTreePathSizing
    then
      State := gsNormal
    else
      FSizingIndex := Index;
  end;

  if (tgTreePath in Options) and (State = gsColSizing) and FTreePathSizing
  then
    if SizingPos < FixedInfo.Horz.FixedBoundary then
      FTreePathSizing := GetFixedColType(ACol, FIndicatorOffset) = dcTreePath
    else
      FTreePathSizing := ((ACol+FIndicatorOffset)= -1);
  FSizingOff := SizingOfs;

  if (State = gsRowSizing) then
  begin
    if (GridHitTest <> gtIndicator) or
      ((MouseCoord(X, Y).Y - TopRow) >= FTitleOffset) then
      State := gsNormal
  end;
end;

procedure TDCCustomTreeGrid.SetImages(const Value: TImageList);
begin
  if Images <> nil then
    Images.UnRegisterChanges(FImageChangeLink);
  FImages := Value;
  if Images <> nil then
  begin
    Images.RegisterChanges(FImageChangeLink);
    Images.FreeNotification(Self);
  end;
  LayoutChanged;
end;

function TDCCustomTreeGrid.GetHintTreeOffset(KnotItem: TKnotItem;
  Hint: TTreeGridHitTest): integer;
 var
  ALevel: integer;
begin
  with KnotItem do
    case Hint of
      htNowere  :
        Result := 1;
      htOnButton:
        begin
          if [tgeShowLines, tgeShowButtons] * OptionsEx <> [] then
            ALevel := Level
          else
            ALevel := Level - 1;
          Result := GetHintTreeOffset(KnotItem, htNowere);
          Result := Result + ALevel* Indent + 1;
        end;
      htOnIcon  :
        begin
          Result := GetHintTreeOffset(KnotItem, htOnButton);
          Result := Result + Indent;
        end;
      htOnLabel :
        begin
          Result := GetHintTreeOffset(KnotItem, htOnIcon);
          if (Images<>nil) and
             ((KnotID =  SelectedKnot.KnotID)and(SelectImage>-1) or
              (KnotID <> SelectedKnot.KnotID)and(NormalImage>-1))
          then
            Result := Result+Images.Width + 5;
        end;
      else
        Result := 0;
    end;
end;

procedure TDCCustomTreeGrid.HideHintWindow;
 var
  pHintWindow: PHintWindowParam_tag;
begin
  if (FHintRow <> -1) and HandleAllocated then
  begin
    GetMem(pHintWindow, SizeOf(THintWindowParam));
    with pHintWindow^ do
    begin
      ShowMode := smHide;
      lpText := nil;
    end;
    SendMessage(Handle, CM_POPUPHINTINFO, 0, Integer(pHintWindow) );
  end;
end;

procedure TDCCustomTreeGrid.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  DoColumnComment(MODE_HIDEWINDOW, nil);
  HideHintWindow;
end;

procedure TDCCustomTreeGrid.ShowHintWindow(CellX, CellY, PosX, PosY: integer;
  Text: string);
 var
  pHintWindow: PHintWindowParam_tag;
begin
  if not ShowHint and (DragState = dsNone) then
  begin

    if ([goHorzLine, goVertLine] * inherited Options <> [goHorzLine, goVertLine]) and
      not (tgFlatLines in Options) then PosX := PosX - GridLineWidth;

    if tgFlatLines in Options then PosY := PosY - GridLineWidth;

    GetMem(pHintWindow, SizeOf(THintWindowParam));
    with pHintWindow^ do
    begin
      ShowMode := smShow;
      x := PosX;
      y  := PosY;
      cx := CellX;
      cy := CellY;
      GetMem(lpText, (Length(Text)+1) * SizeOf(Char));
      StrPCopy(lpText, Text);
    end;
    SendMessage(Handle, CM_POPUPHINTINFO, 1, Integer(pHintWindow));
  end;
end;

procedure TDCCustomTreeGrid.InvalidateSelected;
 var
  Rect: TRect;
begin
  if not HandleAllocated then Exit;
  if (tgMultiSelect in Options) and (FBookmarks.Count > 0) then
    InvalidateRect(Handle, nil, False)
  else begin
    Rect := BoxRectEx(0, Row , ColCount-1, Row );
    InvalidateRect(Handle, @Rect, False);
  end;  
end;

function TDCCustomTreeGrid.GetTreePathCaption(KnotItem: TKnotItem;
  var Text: string): boolean;
begin
  Result := True;
  Text   := KnotItem.Name;
  if Assigned(FOnTreeCellText) then FOnTreeCellText(Self, KnotItem, Text, Result);
end;

procedure TDCCustomTreeGrid.RowMoved(FromIndex, ToIndex: Integer);
begin
  inherited;
  if Assigned(FOnRowMoved) then FOnRowMoved(Self, FromIndex, ToIndex);
end;

procedure TDCCustomTreeGrid.ShowTreePathEditor;
 var
  R: TRect;
  CanCreate: boolean;

  procedure UpdateEditor;
  begin
    FInplaceCol := FIndicatorOffset-1;
    FInplaceRow := Row;
    FIInplaceEditor.SelectAll;
  end;

begin
  if not(tgEditing in Options) or (Columns.Count=0) or (FKnots.Count=0) then Exit;

  if FEditorMode then HideEditor;

  DoCreateCellEdit(nil, FIInplaceEditor, CanCreate);

  if Assigned(FIInplaceEditor) then
  begin
    FEditorMode  := True;
    _setFlag(FFlags, TGF_ISDATAMODIFIED, False);
    with FIInplaceEditor do
    begin
      Text      := FSelectedKnot.Name;
      Visible   := False;
      Parent    := Self;
      DrawStyle := fsSingle;
    end;

    UpdateEditor;

    R := CellRect(FIndicatorOffset-1, Row);
    R.Left := R.Left + GetTreeLableOffset(FSelectedKnot);
    if CanInplaceEditShow then InplaceUpdateLoc(FIInplaceEditor, R, Canvas);
  end;
end;

procedure TDCCustomTreeGrid.DoClick(Sender: TObject);
 var
  AColType: TFixedCol;
begin
  AColType := FClipPopup.ColType;
  HideClipPopup;
  if Assigned(FOnClipButtonClick) then FOnClipButtonClick(Sender);
  if AColType = dcMarker then
  begin
    case TDCAssistButton(Sender).Pos of
      pmSelectAll:
        SelectItems(smSelect);
      pmDeselectAll:
        SelectItems(smDeselect);
    end;
  end;
end;

procedure TDCCustomTreeGrid.WMNCLButtonDown(var Message: TWMNCLButtonDown);
begin
  inherited;
  HideClipPopup;
end;

procedure TDCCustomTreeGrid.WMHScroll(var Message: TWMHScroll);
 var
  NewLeft: integer;
begin
  if (DragState = dsColMoving) or
    not(FKnots.Updating or _getFlag(FFlags, TGF_LOCKSCREEN)) and DataVisible then
  begin
    if CanModifyHScrollBar(SB_HORZ, Message.ScrollCode, Message.Pos, True, NewLeft) then
    begin
      if tgTreePathCompletion in Options then
      begin
        _setFlag(FFlags, TGF_LOCKSCROLL, True);
        try
          if NewLeft <> -1  then
            LeftCol := NewLeft
          else
            inherited;
        finally
          _setFlag(FFlags, TGF_LOCKSCROLL, False);
          UpdateHorzScrollPos;
        end;
      end
      else
        inherited;
    end;
  end;
end;

procedure TDCCustomTreeGrid.WMVScroll(var Message: TWMVScroll);
begin
  if (DragState = dsColMoving) or DataVisible and AcquireFocus and
     not(FEditorMode or FKnots.Updating or _getFlag(FFlags, TGF_LOCKSCREEN)) then
  begin
    inherited;
  end;
end;

procedure TDCCustomTreeGrid.SetPopupTitle(const Value: TPopupMenu);
begin
  FPopupTitle := Value;
end;

function TDCCustomTreeGrid.GetPopupMenu: TPopupMenu;
 var
  P: TPoint;
  Cell: TGridCoord;
begin
  case GridHitTest of
    gtTreeColumn, gtTreePath:
      if Assigned(FPopupTitle) then
        Result := FPopupTitle
      else
        Result := inherited GetPopupMenu;
    else
      Result := inherited GetPopupMenu;
  end;
  if Assigned(FOnPopupMenu) then
  begin
    GetCursorPos(P);
    P := ScreenToClient(P);
    Cell := MouseCoord(P.X, P.Y);
    FonPopupMenu(Self, GridHitTest, Cell, Result)
  end;
end;

procedure TDCCustomTreeGrid.DoDelete(KnotItem: TKnotItem; var Apply: boolean;
  ComponentState: TComponentState);
begin
  if KnotItem.Owner.State <> ksInsert then
  begin
    if Assigned(FOnDelete) then FOnDelete(KnotItem, Apply, ComponentState);
  end
  else
    Apply := True;  
end;

procedure TDCCustomTreeGrid.DoInsert(KnotItem: TKnotItem; var Apply: boolean);
begin
  if Assigned(FOnInsert) then FOnInsert(Self, KnotItem, Apply);
end;

procedure TDCCustomTreeGrid.DoUpdate(KnotItem: TKnotItem; var Edit: IDCInplaceEditor;
  Column: TKnotColumn);
begin
  if Assigned(FOnUpdate) then FOnUpdate(Self, KnotItem, Edit, Column);
end;

function TDCCustomTreeGrid.DeletePrompt: boolean;
 var
  Msg: string;
  nCount: integer;
begin
  nCount := FBookmarks.Count;
  if (nCount > 1) then
    Msg := Format(LoadStr(RES_GRID_STR_MSEL),[nCount, RecordCount2Str(nCount)])
  else
    Msg := LoadStr(RES_GRID_STR_SSEL);
  Result := (MessageDlg(Msg, mtConfirmation, mbOKCancel, 0) <> idCancel);
end;

procedure TDCCustomTreeGrid.DeleteRecords(AtOnce: boolean);
begin
  if (tgEditing in FOptions) and (AtOnce or DeletePrompt) and
     Assigned(FSelectedKnot)
  then begin
    if FBookmarks.Count = 0 then SelectedRows.Select(CurrentBookmark, True);
    BeginUpdate;
    SavePosition;
    try
      FBookmarks.Delete;
    finally
      RestPosition;
      EndUpdate;
    end;
  end;
end;

procedure TDCCustomTreeGrid.DoSelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
  if Assigned(FOnSelectCell) then FOnSelectCell(Sender, ACol, ARow+1, CanSelect);
end;

procedure TDCCustomTreeGrid.DoDrawColumnCell(Canvas: TCanvas; ARect: TRect;
  ACol: integer; AColumn: TKnotColumn; AKnot: TKnotItem; AState: TGridCellState);
begin
  if Assigned(FOnDrawColumnCell) then
    FOnDrawColumnCell(Self, ARect, Canvas, ACol, AColumn, AKnot, AState);
end;

procedure TDCCustomTreeGrid.DoDestroyCellEdit;
begin
  if Assigned(FOnDestroyCellEdit) then FOnDestroyCellEdit(Self);
end;

procedure TDCCustomTreeGrid.DoColumnComment(Mode: integer; Column: TKnotColumn);
begin
  if (FColumnCell <> -1) and (Mode = MODE_HIDEWINDOW) then
  begin
    if Assigned(FOnColumnComment) then FOnColumnComment(Self, Mode, Column);
    FColumnCell := -1;
  end
  else
    if Assigned(FOnColumnComment) then FOnColumnComment(Self, Mode, Column);
end;

procedure TDCCustomTreeGrid.CMPopupHintInfo(var Message: TMessage);
 var
  pHintWindow: PHintWindowParam_tag;
begin
  pHintWindow := PHintWindowParam_tag(Message.LParam);
  with pHintWindow^ do
  begin
    case ShowMode of
      smHide:
       if (FHintRow <> - 1) and (FHintWindow <> nil) then
       begin
         FHintRow := -1;
         FreeAndNil(FHintWindow);
         UnHookPopupHooks;
       end;
      smShow:
       begin
         if not Assigned(FHintWindow) then
         begin
           FHintWindow := TDCGridMessageWindow.Create(Self);
           with FHintWindow do
           begin
             Parent := Self;
             DialogStyle := dsSimple;
             PopupAlignment := wpOffset;
             Centered := True;
           end;
         end
         else begin
           FHintWindow.Hide;
           UnHookPopupHooks;
         end;

         with FHintWindow do
         begin
           FCell.X := cx;
           FCell.Y := cy;
           Font   := Self.Font;
           Caption := Format('/oh{-1}/ow{-2}%s',[lpText]);
           Left := x + 1;
           Top := y - 2;
           Height := RowHeights[cy] + 2;
           Show;
           HookPopupHooks(Self, GetCurrentThreadID);
        end;
       end;
    end;
  end;
  if Assigned(pHintWindow^.lpText) then FreeMem(pHintWindow^.lpText);
  FreeMem(pHintWindow);
end;

function TDCCustomTreeGrid.DoMouseWheelDown(Shift: TShiftState;
  MousePos: TPoint): Boolean;
 var
  MouseWheelDownEvent: TMouseWheelUpDownEvent;
begin
  Result := False;
  MouseWheelDownEvent := OnMouseWheelDown;
  if Assigned(MouseWheelDownEvent) then
    MouseWheelDownEvent(Self, Shift, MousePos, Result);

  if not Result and (DragState = dsNone) and
    PtInRect(ClientRect, ScreenToClient(MousePos)) and not FKnots.Updating then
  begin
    if not FEditorMode then
    begin
      if ssShift in Shift then
        NextRow(True, False, Shift)
      else begin
        if TopRow < RowCount - VisibleRowCount then TopRow := TopRow + 1;
      end;
    end;
    Result := True;
  end;
end;

function TDCCustomTreeGrid.DoMouseWheelUp(Shift: TShiftState;
  MousePos: TPoint): Boolean;
 var
  MouseWheelUpEvent: TMouseWheelUpDownEvent;

begin
  Result := False;
  MouseWheelUpEvent := OnMouseWheelDown;
  if Assigned(MouseWheelUpEvent) then
    MouseWheelUpEvent(Self, Shift, MousePos, Result);

  if not Result and (DragState =dsNone) and
    PtInRect(ClientRect, ScreenToClient(MousePos)) and not FKnots.Updating then
  begin
    if not FEditorMode then
    begin
      if ssShift in Shift then
        PrevRow(True, Shift)
      else
        if (TopRow > FixedRows) and (RowCount > VisibleRowCount) then
          TopRow := TopRow - 1;
    end;
    Result := True;
  end;
end;

procedure TDCCustomTreeGrid.InsertKnot(lChild: boolean; Shift: TShiftState);
 var
  NewKnot, NextKnot: TKnotItem;
  Delta: integer;
  CanSelect: boolean;
  ParentKnot: TKnotItem;
begin

  ParentKnot := FSelectedKnot;

  LockUpdate(DoubleBuffered);
  try
    with FKnots do
    begin
      if State = ksInsert then begin
        CanSelect := True and Modified;
        DoSelectCell(Self, Col, Row+1, CanSelect);
        if CanSelect then
          SetState(ksBrowse)
        else
          Exit;
      end;
      BeginUpdate(False, nil, kaInsert);
      if ParentKnot = nil then
      begin
        NewKnot := FKnots.Add(NE_EMPTY_KNOT);
        if Assigned(NewKnot) then SetSelectedKnot(NewKnot);
      end
      else begin
        if lChild then
        begin
          NewKnot := FKnots.AddChild(ParentKnot, NE_EMPTY_KNOT);
          ParentKnot.Expand(False);
        end
        else
          if ssShift in Shift then
          begin
            NewKnot := FKnots.AddChild(ParentKnot.Parent, NE_EMPTY_KNOT,
              ParentKnot.FIndex);
            if NewKnot <> nil then SetSelectedKnot(NewKnot);
          end
          else
            NewKnot := FKnots.AddChild(ParentKnot.Parent, NE_EMPTY_KNOT,
              ParentKnot.FIndex + 1)
      end;
      EndUpdate(not Assigned(NewKnot));
      if Assigned(NewKnot) then
      begin
        Delta := 0;
        NextKnot := FSelectedKnot;
        while (NewKnot.KnotID <> NextKnot.KnotID) and (NextKnot <> nil) do
        begin
          Inc(Delta);
          NextKnot := NextKnot.GetNextVisible;
        end;
        SetInternalRow(Row + Delta);
        SetSelectedKnot(NextKnot);
        FKnots.SetState(ksInsert);
      end;
    end;
  finally
    UnlockUpdate(DoubleBuffered);
  end;
end;

procedure TDCCustomTreeGrid.MarkKnot;
begin
  if (tgMarker in Options) and (FKnots.Count>0) then
  begin
    try
      BeginUpdate;
      with FBookmarks do
        Select(CurrentBookmark, not Selected(CurrentBookmark));
    finally
      EndUpdate;
    end;
  end;
end;

procedure TDCCustomTreeGrid.NextRow(Select, Insert: boolean; Shift: TShiftState;
   AOffset: integer = 1);
begin
  with FKnots do
  begin
    if not DoCancelOnMoving(Eof or (FSelectedKnot.GetNextVisible = nil)) then Exit;
    if not Assigned(FIInplaceEditor) then
    begin
      DoSelection(Select, Shift, 1, AOffset);
      if Eof and IsActiveControl and Insert and (tgEditing in Options) then
        InsertKnot(False, Shift)
    end;
  end;
end;

procedure TDCCustomTreeGrid.PrevRow(Select: Boolean; Shift: TShiftState;
  AOffset: integer = 1);
 var
  AEof: boolean;
begin
  if (FKnots.State = ksInsert) then
    AEof := Eof or (FSelectedKnot.GetNextVisible = nil) and not Modified
  else
    AEof := False;

  if not DoCancelOnMoving(False) then Exit;
  if (FIInplaceEditor = nil) and (Row >= FTitleOffset) and not AEof then
    DoSelection(Select, Shift, -1, - AOffset);
end;

procedure TDCCustomTreeGrid.ClearSelection;
begin
  if (tgMultiSelect in Options) then
  begin
    FBookmarks.Clear;
    FSelecting := False;
  end;
end;

function TDCCustomTreeGrid.EOF: boolean;
begin
  Result := FEOF;
end;

function TDCCustomTreeGrid.BoxRectEx(ALeft, ATop, ARight,
  ABottom: Integer): TRect;
begin
  Result := BoxRect(ALeft, ATop, ARight, ABottom);
  Inc(Result.Right);
  if tgCompleteLines in Options then Result.Right := Width;
end;

procedure TDCCustomTreeGrid.Paint;
 var
  DrawInfo: TGridDrawInfo;
  CurRow: integer;
  ARect, BRect: TRect;
  BorderStyle: TEdgeBorderStyle;
  ALineColor, AColor: TColor;
  UpdateRect, FooterRect : TRect;
  SaveIndex: integer;
  StructLine, StructFixed: TPolyLineStruct;
  DrawKnot: TKnotItem;
  RowSelected: boolean;

  procedure DrawGridArea;
  begin
    if tgFlatLines in Options then
    begin
      CreatePolyLineStruct(FGridStruct, PolySize_x15, LineColor);
      inherited Paint;
      if not IsRectEmpty(FooterRect) then
      begin
        with FooterRect do
          ExcludeClipRect(Canvas.Handle, Left, Top, Right, Bottom);
      end;
      PaintPolyLine(Canvas.Handle, FGridStruct);
      DestroyPolyLineStruct(FGridStruct);
    end
    else
      inherited Paint;
  end;

begin
  FooterRect := Footers.BoundsRect;
  if (tgCompleteLines in Options) and not(tgAutoSize in Options) then
  begin
    CalcDrawInfo(DrawInfo);
    SaveIndex := SaveDC(Canvas.Handle);

    UpdateRect := Canvas.ClipRect;
    FooterRect := Footers.BoundsRect;
    with UpdateRect do
    begin
      Bottom := FooterRect.Top;
      Left  := DrawInfo.Horz.GridBoundary;
      Right := DrawInfo.Horz.GridExtent;
    end;

    if not IsRectEmpty(FooterRect) then
      with FooterRect do
        ExcludeClipRect(Canvas.Handle, Left, Top, Right, Bottom);

    with DrawInfo do
    begin
      if Horz.GridBoundary < Horz.GridExtent then
      begin
        CurRow := 0;

        BorderStyle := GetBorderStyle;

        if tgFlatLines in Options then
          ALineColor := LineColor
        else begin

          if ColorToRGB(Color) = clSilver then
            ALineColor := clGray
          else
            ALineColor := clSilver;
        end;

        if tgRowLines in FOptions  then
        begin
          case BorderStyle of
            ebsNone, ebsFlat:
              AColor := ALineColor;
            else
              if not (tgColLines in FOptions) then
                AColor := FixedColor
              else
                AColor := clBlack;
          end;
        end
        else
          AColor := ALineColor;

        CreatePolyLineStruct(StructLine, PolySize_x16, ALineColor);
        CreatePolyLineStruct(StructFixed, PolySize_x16, AColor);

        if not(BorderStyle = ebsShadowFlat) and
          (ColorToRGB(Color) = ColorToRGB(FixedColor)) then BorderStyle := ebsNone;

        ARect := Rect(Horz.GridBoundary, 0, Horz.GridExtent, 0);
        if FTitleOffset > 0 then
        begin
          Canvas.Brush.Color := FixedColor;
          while CurRow < FTitleOffset do
          begin
            ARect.Bottom := ARect.Bottom + RowHeights[CurRow];
            BRect := ARect;
            InflateRect(BRect, 1, 1);
            if RectVisible(Canvas.Handle, BRect) then
            begin
              if RectVisible(Canvas.Handle, ARect) then
              begin
                Canvas.FillRect(ARect);
                if (tgFixedLines in Options) then
                begin
                  if BorderStyle <> ebsNone then
                  begin
                    if BorderStyle = ebsShadowFlat then
                    begin
                      InflateRect(ARect, 1, 1);
                      ARect.Right := ARect.Right + 1;
                      DrawGridFrameBorder(Canvas, ARect, BorderStyle, dsUp,
                        FixedColor);
                      InflateRect(ARect, -1, -1);
                    end
                    else begin
                      ARect.Right := ARect.Right + 1;
                      DrawGridFrameBorder(Canvas, ARect, BorderStyle, dsUp,
                        FixedColor);
                    end;
                  end;
                end;
              end;
              if (tgRowLines in FOptions) and not(tgFlatLines in Options) then
              begin
                with ARect do
                  AddPoint2Struct(StructFixed, Left, Bottom, Right, Bottom);
              end
            end;
            Inc(CurRow);
            if (tgRowLines in FOptions) and not(tgFlatLines in Options) then
               OffsetRect(ARect, 0, 1);
            ARect.Top := ARect.Bottom;
          end;
        end;

        if (tgRowLines in FOptions) and (tgFlatLines in Options) then
           Dec(ARect.Bottom);

        while (CurRow < Vert.GridCellCount) and
              (ARect.Top < UpdateRect.Bottom) do
        begin
          ARect.Bottom := ARect.Bottom + RowHeights[CurRow];

          RowSelected := False;
          if RectVisible(Canvas.Handle, ARect) and
             ((tgRowSelect in Options) or (tgHighlightRow in Options)) and
             (AlwaysShowSelection or IsActiveControl)
          then begin
            if Row = (RawToDataRow(CurRow) + Vert.FirstGridCell) then
            begin
              RowSelected := True;
              if FColumns.Count = 0 then
                 Canvas.Brush.Color := Self.Color
              else begin
                if IsActiveControl or not (tgeShadowSelection in OptionsEx) then
                  Canvas.Brush.Color := clHighlight
                else
                  if AlwaysShowSelection then
                    Canvas.Brush.Color := clShadowed;
               end;
            end
            else
              Canvas.Brush.Color := Self.Color;
          end
          else
            Canvas.Brush.Color := Self.Color;

          if (tgTreePathCompletion in Options) and not RowSelected then
          begin
            DrawKnot := GetKnotByCell(RawToDataRow(TopRow) + RawToDataRow(CurRow));
            if (DrawKnot <> nil) and DrawKnot.HasChildren then
              Canvas.Brush.Color := TreePath.Color;
            if tgRowLines in FOptions then Dec(ARect.Top);
            Canvas.FillRect(ARect);
          end
          else
            Canvas.FillRect(ARect);

          BRect := ARect;
          InflateRect(BRect, 1, 1);
          if (tgRowLines in FOptions) and RectVisible(Canvas.Handle, BRect) then
          begin
            with ARect do
              AddPoint2Struct(StructLine, Left, Bottom, Right, Bottom);
          end;

          Inc(CurRow);
          if (tgRowLines in FOptions) and not(tgFlatLines in Options) then
            OffsetRect(ARect, 0, 1);
          ARect.Top := ARect.Bottom;
        end;
        if ARect.Top < UpdateRect.Bottom then
        begin
          BRect := ClientRect;
          if Vert.GridBoundary < Vert.GridExtent   then
          begin
            ARect.Top    := Vert.GridBoundary;
            ARect.Bottom := Vert.GridExtent;
            Canvas.Brush.Color := Self.Color;
            Canvas.FillRect(ARect);
          end;
        end;
        PaintPolyLine(Canvas.Handle, StructFixed);
        PaintPolyLine(Canvas.Handle, StructLine);

        DestroyPolyLineStruct(StructFixed);
        DestroyPolyLineStruct(StructLine);
      end;
    end;
    RestoreDC(Canvas.Handle, SaveIndex);
    with UpdateRect do
      ExcludeClipRect(Canvas.Handle, Left, Top, Right, Bottom);

    DrawGridArea;
  end
  else
    DrawGridArea
end;

procedure TDCCustomTreeGrid.WMEraseBkgnd(var Message: TWmEraseBkgnd);
begin
{  inherited;  }
end;

procedure TDCCustomTreeGrid.ImageListChange(Sender: TObject);
begin
  LayoutChanged;
end;

procedure TDCCustomTreeGrid.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) then
  begin
    if (AComponent = FImages) then
    begin
      FImages := nil;
      if not(csDestroying in ComponentState) then LayoutChanged;
      Exit;
    end;
  end;
end;

procedure TDCCustomTreeGrid.CMFontChanged(var Message: TMessage);
begin
  inherited;
  LayoutChanged;
end;

procedure TDCCustomTreeGrid.SetSelectedKnot(KnotItem: TKnotItem);
begin
  if (FSelectedKnot <> KnotItem) and (KnotItem <> nil)then
  begin
    FSelectedKnot := KnotItem;
    if Assigned(FOnSelectKnot) then FOnSelectKnot(Self, FSelectedKnot);
    FBOF := FSelectedKnot = nil;
    FEOF := FSelectedKnot = nil;
  end;
end;

procedure TDCCustomTreeGrid.SetSelected(const Value: TKnotItem);
 var
  KnotItem1, KnotItem2: TKnotItem;
  i, ARow: integer;
begin
  if Value = nil then
  begin
    SetInternalRow(FTitleOffset);
    Exit;
  end;
  KnotItem1 := Value;
  {check Visible}
  BeginUpdate;
  if not KnotItem1.Visible then KnotItem1.Visible := True;
  while KnotItem1 <> Knots.Root  do
  begin
    KnotItem1 := KnotItem1.Parent;
    if not KnotItem1.Visible  then KnotItem1.Visible := True;
    if not KnotItem1.Expanded then KnotItem1.Expand(False);
  end;
  EndUpdate;
  KnotItem1 := Value;
  KnotItem2 := FFirstVisible;
  ARow := _intMax(FFirstIndex + FTitleOffset, FTitleOffset);
  if KnotItem2 <> nil then
  begin
    i := Knots.ComparePos(KnotItem1, KnotItem2);
    while (KnotItem1 <> nil) and (KnotItem1 <> KnotItem2) do
    begin
      if i > 0 then
        KnotItem1 := KnotItem1.GetNextVisible
      else
        KnotItem1 := KnotItem1.GetPrevVisible;
      Inc(ARow, -i);
    end;
  end
  else begin
    KnotItem2 := Knots.GetFirstVisibleNode;
    while (KnotItem2 <> nil) and (KnotItem2 <> KnotItem1) do
    begin
      KnotItem2 := KnotItem2.GetNextVisible;
      Inc(ARow);
    end;
  end;

  if Row = ARow then
  begin
    if Row < TopRow then
      TopRow := Row
    else if Row > (TopRow + VisibleRowCount) then
      TopRow := Row - VisibleRowCount + 1;
  end
  else
    if (KnotItem1 <> nil) and (ARow <= RowCount) then  SetInternalRow(ARow);
  SetSelectedKnot(Value);
end;

function TDCCustomTreeGrid.GetPosition: TKnotBookmark;
begin
  Result := FCurrentPos[2].Bookmark;
end;

procedure TDCCustomTreeGrid.RestPosition;
begin
  if FCurrentPos[2].Bookmark = nil then
  begin
    if Assigned(FCurrentPos[1].Bookmark) and ValidBookmark(FCurrentPos[1].Bookmark) then
       GotoBookmark(FCurrentPos[1])
    else
       First;
  end
  else GotoBookmark(FCurrentPos[2])
end;

procedure TDCCustomTreeGrid.SavePosition;
 var
  KnotItem: TKnotItem;

  function KnotSelected(KnotItem: TKnotItem): boolean;
  begin
    if (KnotItem = nil) or (KnotItem.Level = -1) then
    begin
      Result := False;
      Exit;
    end;

    Result := SelectedRows.Selected(GetBookmark(KnotItem));

    if not Result and (KnotItem.Parent.Level > -1) then
      Result := Result or KnotSelected(KnotItem.Parent)
  end;

begin
  if FKnots.Count > 0 then
  begin
    with FKnots do
    begin

      ClearBookmarkData(FCurrentPos[1].Bookmark);
      ClearBookmarkData(FCurrentPos[2].Bookmark);

      KnotItem := SelectedKnot;

      if KnotItem <> nil then
        FCurrentPos[2].Bookmark := GetBookmark(KnotItem)
      else begin
        FCurrentPos[2].Bookmark := nil;
        FCurrentPos[1].Bookmark := nil;
        Exit;
      end;

      while KnotSelected(KnotItem) do KnotItem := KnotItem.GetNextVisible;

      if (KnotItem <> nil) and (KnotItem <> FKnots.Root) then
        FCurrentPos[1].Bookmark := GetBookmark(KnotItem)
      else
        FCurrentPos[1].Bookmark := nil;

    end;
  end;
end;

procedure TDCCustomTreeGrid.SetPosition(const Value: TKnotBookmark);
begin
  FCurrentPos[2].Bookmark := Value;
end;

function TDCCustomTreeGrid.GetBookmark(KnotItem: TKnotItem): TKnotBookmark;
begin
  Result := KnotItem;
end;

procedure TDCCustomTreeGrid.GotoBookMark(BookmarkInfo: TBookmarkInfo);
begin
  SelectedKnot := TKnotItem(BookmarkInfo.Bookmark);
end;

function TDCCustomTreeGrid.DataVisible: boolean;
begin
  Result := (csDesigning in ComponentState) or (((FColumns.Count <> 0) or
    (TreePathWidth > 0)));
end;

procedure TDCCustomTreeGrid.WMSetCursor(var Msg: TWMSetCursor);
begin
  if not DataVisible then
    Windows.SetCursor(LoadCursor(0, IDC_ARROW))
  else
    inherited;
end;

procedure TDCCustomTreeGrid.WMPaint(var Message: TWMPaint);
 var
  PS: TPaintStruct;
  UpdateMessage: string;
  R, R1: TRect;
  MessageType: TTreeGridMessageType;
  Flags: integer;
  MBitmap, OBitmap: HBITMAP;
  MDC, DC: HDC;
begin
  if _getFlag(FFlags, TGF_LOCKSCREEN) or not DataVisible then
  begin
    ShowScrollBar(Handle, SB_HORZ, False);
    ShowScrollBar(Handle, SB_VERT, False);
    GetWindowRect(Handle, R);  OffsetRect(R, -R.Left, -R.Top); R1 := R;
    DC := GetDC(0);
    MBitmap := CreateCompatibleBitmap(DC, R.Right, R.Bottom);
    ReleaseDC(0, DC);
    MDC := CreateCompatibleDC(0);
    OBitmap := SelectObject(MDC, MBitmap);

    try
      DC := BeginPaint(Handle, PS);
      Canvas.Handle := MDC;
      Canvas.Brush.Color := Self.Color;
      Canvas.Font := Self.Font;

      UpdateMessage := '';
      Flags         := DT_END_ELLIPSIS or DT_CENTER;
      MessageType   := mtEmptyColumns;

      if _getFlag(FFlags, TGF_LOCKSCREEN) then
      begin
        UpdateMessage := LoadStr(RES_STRN_MSG_ONLOAD);
        MessageType   := mtLoadData;
      end
      else begin
        if not DataVisible then
        begin
          UpdateMessage := LoadStr(RES_STRN_MSG_DBGCEM);
          MessageType   := mtEmptyColumns;
        end;
      end;

      if Assigned(FOnPaintMessage) then
        FOnPaintMessage(Self, Canvas, R, MessageType, UpdateMessage)
      else begin
        Canvas.FillRect(R);
        InflateRect(R, -5, -5);
        DrawHighLightText(Canvas, PChar(UpdateMessage), R, 1, Flags or DT_WORDBREAK);
        BitBlt(DC, 0, 0, R1.Right, R1.Bottom, MDC, 0, 0, SRCCOPY);
      end;
      EndPaint(Handle, PS);
    finally
      SelectObject(MDC, OBitmap);
      DeleteDC(MDC);
      DeleteObject(MBitmap);
      Canvas.Handle := 0;
    end;
  end
  else
    if not UpdateLocked then
    begin
      if EditorMode then
      begin
        R := FIInplaceEditor.GetBoundsRect;
        ExcludeClipRect(Canvas.Handle, R.Left, R.Top, R.Right, R.Bottom);
      end;
      inherited;
    end
    else begin
      BeginPaint(Handle, PS);
      {Nothing}
      EndPaint(Handle, PS);
    end;
end;

function TDCCustomTreeGrid.CanEditModify: Boolean;
begin
  Result := False;
  if not ReadOnly then
  begin
    with Columns[SelectedIndex] do
    begin
      if not(kcReadOnly in Options) then
      begin
        if Knots.State = ksBrowse then
        begin
          Result := True;
          if Result then SetModified(True);
        end
        else
          Result := True;
      end;
    end;
  end;
end;

function TDCCustomTreeGrid.GetTreeLableOffset(
  KnotItem: TKnotItem): integer;
 var
  X: integer;
begin
  with KnotItem do
  begin
    if Indent > 0 then
      X := (Level+1)*Indent + 4
    else
      X := 0;

    if (Images<>nil) and
       ((KnotID =  SelectedKnot.KnotID) and (SelectImage > -1) or
       (KnotID <> SelectedKnot.KnotID) and (NormalImage > -1))
    then
      X := X + Images.Width+2;

    Result := X;

  end;
end;

procedure TDCCustomTreeGrid.WMTimer(var Msg: TWMTimer);
begin
  inherited;
  if (Msg.TimerId = FEditTimerID) then
  begin
    FreeEditTimer;
    if not FEditorMode then ShowTreePathEditor;
  end
end;

procedure TDCCustomTreeGrid.FreeEditTimer;
begin
  if FEditTimerID <> -1 then
  begin
    KillTimer(Handle, 101);
    FEditTimerID := -1;
  end;
end;

procedure TDCCustomTreeGrid.CMWantSpecialKey(var Msg: TCMWantSpecialKey);
begin
  inherited;
  if (tgEditing in Options) and (Msg.CharCode = VK_RETURN) then Msg.Result := 1;
end;

procedure TDCCustomTreeGrid.WMNCCalcSize(var Message: TWMNCCalcSize);
begin
  inherited;
  if (BorderStyle = bsSingle) and (tgFlatButtons in Options) then
   InflateRect(Message.CalcSize_Params^.rgrc[0], -1, -1);
end;

procedure TDCCustomTreeGrid.WMNCPaint(var Message: TMessage);
 var
  R, R1: TRect;
  DC: HDC;
  ScrollW, ScrollH: integer;
  Brush: HBRUSH;
  ScrollInfo: TScrollInfo;
  IScroll, VScroll, HScroll: boolean;
begin
  inherited;
  if (BorderStyle = bsSingle) and (tgFlatButtons in Options) then
  begin
    DC := GetWindowDC(Handle);
    Brush := CreateSolidBrush(ColorToRGB(clBtnFace));
    try
      GetWindowRect(Handle, R);  OffsetRect(R, -R.Left, -R.Top);

      ScrollInfo.cbSize := SizeOf(ScrollInfo);
      ScrollInfo.fMask := SIF_ALL;
      IScroll := GetScrollInfo(Self.Handle, SB_HORZ, ScrollInfo);
      HScroll := IScroll and (ScrollInfo.nMin <> ScrollInfo.nMax);
      IScroll := GetScrollInfo(Self.Handle, SB_VERT, ScrollInfo);
      VScroll := IScroll and (ScrollInfo.nMin <> ScrollInfo.nMax);

      if DataVisible and HScroll and VScroll then
      begin
        ScrollW := GetSystemMetrics(SM_CXVSCROLL);
        ScrollH := GetSystemMetrics(SM_CYVSCROLL);
        R1 := Rect(R.Right - ScrollW-1, R.Bottom - ScrollH-1, R.Right-1, R.Bottom-1);
        FrameRect(DC, R1, Brush);
      end;

      DrawEdge(DC, R, BDR_SUNKENOUTER, BF_TOPLEFT);
      DrawEdge(DC, R, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
    finally
      DeleteObject(Brush);
      ReleaseDC(Handle, DC);
    end;
  end;
end;

procedure TDCCustomTreeGrid.CreateParams(var Params: TCreateParams);
begin
  inherited;
  if (BorderStyle = bsSingle) and (tgFlatButtons in Options) then
  with Params do
  begin
    if NewStyleControls and Ctl3D then
      ExStyle := ExStyle and not WS_EX_CLIENTEDGE
    else
      Style := Style and not WS_BORDER;
  end;
end;

procedure TDCCustomTreeGrid.DoCollapse(KnotItem: TKnotItem);
begin
  if Assigned(FOnCollapsed) then FOnCollapsed(Self, KnotItem);
end;

procedure TDCCustomTreeGrid.DoExpand(KnotItem: TKnotItem);
begin
  if Assigned(FOnExpanded) then FOnExpanded(Self, KnotItem);
end;

function TDCCustomTreeGrid.GetBorderStyle: TEdgeBorderStyle;
begin
  if not((tgColLines in Options) and (tgRowLines in Options)) or
     not(tgFixedLines in Options) then
    if (tgFlatButtons in Options) and (tgFixedLines in Options) then
      Result := ebsShadowFlat
    else
      Result := ebsNone
  else begin
    if (ColorToRGB(Color) = ColorToRGB(FixedColor)) then
      Result := ebsNone
    else
    begin
      if tgFlatButtons in Options then
        Result := ebsFlat
      else
        Result := ebsNormal;
    end;
  end;
end;

function TDCCustomTreeGrid.FlatButtons: boolean;
begin
  Result := tgFlatButtons in Options;
end;

procedure TDCCustomTreeGrid.DoColumnClick(Shift: TShiftState;
  ColIndex: integer);
 var
  i: integer;
begin
  inherited;
  if (RawToDataColumn(ColIndex) < Columns.Count) then
  begin
    if (kcIndexed in Columns[RawToDataColumn(ColIndex)].Options) then
    for i := 0 to Columns.Count-1 do
    begin
      if i = RawToDataColumn(ColIndex) then
      begin
        if Columns[i].IndexStyle < High(TColumnIndexStyle)
          then Columns[i].IndexStyle := Succ(Columns[i].IndexStyle)
          else Columns[i].IndexStyle := Pred(Columns[i].IndexStyle);
        InvalidateCell(DataToRawColumn(i),0);
      end
      else
        if not(ssShift in Shift) then
        begin
          if (kcIndexed in Columns[i].Options) and
             (Columns[i].IndexStyle <> Low(TColumnIndexStyle))
          then begin
            Columns[i].IndexStyle := Low(TColumnIndexStyle);
            InvalidateCell(DataToRawColumn(i),0);
          end;
        end;
    end;
    TitleClick(Columns[RawToDataColumn(ColIndex)])
  end;
end;

function TDCCustomTreeGrid.GroupingEnabled: boolean;
begin
  Result := tgGrouping in Options; 
end;

function TDCCustomTreeGrid.GetClientRect: TRect;
begin
  if _getFlag(FFlags, TGF_LOCKSCROLL) and (ColCount > 1) then
  begin
    if not DoubleBuffered then
      SetRectEmpty(Result)
    else
      Result := GetGridBounds;
  end
  else begin
     Result := inherited GetClientRect;
  end;
end;

procedure TDCCustomTreeGrid.GroupBoxChanged;
begin
  inherited;
  if GroupingEnabled then
  begin
    if GroupBox.Count = 0 then
      Options := Options - [tgTreePath]
    else begin
      Options := Options + [tgTreePath];
      TreePathWidth := 1;
    end;
  end;
end;

function TDCCustomTreeGrid.GetRealColWidth(ColIndex: integer): integer;
 var
  ACol: integer;
begin
  ACol := RawToDataColumn(ColIndex);
  if (Columns.Count > 0) and (ACol < Columns.Count) then
    Result := Columns[RawToDataColumn(ColIndex)].ActualWidth
  else
    Result :=  0;
end;

function TDCCustomTreeGrid.CalcMaxTopLeft(const Coord: TGridCoord;
  const DrawInfo: TGridDrawInfo): TGridCoord;

  function CalcMaxCell(const Axis: TGridAxisDrawInfo; Start: Integer): Integer;
  var
    Line: Integer;
    I, Extent: Longint;
  begin
    Result := Start;
    with Axis do
    begin
      Line := GridExtent + EffectiveLineWidth;
      for I := Start downto FixedCellCount do
      begin
        Extent := GetExtent(I);
        if Extent > 0 then
        begin
          Dec(Line, Extent);
          Dec(Line, EffectiveLineWidth);
          if Line < FixedBoundary then
          begin
            if (Result = Start) and (GetExtent(Start) <= 0) then
              Result := I;
            Break;
          end;
          Result := I;
        end;
      end;
    end;
  end;

begin
  Result.X := CalcMaxCell(DrawInfo.Horz, Coord.X);
  Result.Y := CalcMaxCell(DrawInfo.Vert, Coord.Y);
end;

function TDCCustomTreeGrid.CanModifyHScrollBar(ScrollBar, ScrollCode,
  Pos: Cardinal; UseRightToLeft: Boolean; var NewLeft: integer): boolean;
var
  NewTopLeft, MaxTopLeft: TGridCoord;
  DrawInfo: TGridDrawInfo;
  RTLFactor: Integer;

  function Min: Longint;
  begin
    if ScrollBar = SB_HORZ then Result := FixedCols
    else Result := FixedRows;
  end;

  function Max: Longint;
  begin
    if ScrollBar = SB_HORZ then Result := MaxTopLeft.X
    else Result := MaxTopLeft.Y;
  end;

  function PageUp: Longint;
  var
    MaxTopLeft: TGridCoord;
  begin
    MaxTopLeft := CalcMaxTopLeft(GetTopLeft, DrawInfo);
    if ScrollBar = SB_HORZ then
      Result := LeftCol - MaxTopLeft.X else
      Result := TopRow - MaxTopLeft.Y;
    if Result < 1 then Result := 1;
  end;

  function PageDown: Longint;
  var
    DrawInfo: TGridDrawInfo;
  begin
    CalcDrawInfo(DrawInfo);
    with DrawInfo do
      if ScrollBar = SB_HORZ then
        Result := Horz.LastFullVisibleCell - LeftCol else
        Result := Vert.LastFullVisibleCell - TopRow;
    if Result < 1 then Result := 1;
  end;

  function CalcScrollBar(Value, ARTLFactor: Longint): Longint;
  begin
    Result := Value;
    case ScrollCode of
      SB_LINEUP:
        Dec(Result, ARTLFactor);
      SB_LINEDOWN:
        Inc(Result, ARTLFactor);
      SB_PAGEUP:
        Dec(Result, PageUp * ARTLFactor);
      SB_PAGEDOWN:
        Inc(Result, PageDown * ARTLFactor);
      SB_THUMBPOSITION, SB_THUMBTRACK:
        if (goThumbTracking in  inherited Options) or (ScrollCode = SB_THUMBPOSITION) then
        begin
          if (not UseRightToLeftAlignment) or (ARTLFactor = 1) then
            Result := Min + LongMulDiv(Pos, Max - Min, MaxShortInt)
          else
            Result := Max - LongMulDiv(Pos, Max - Min, MaxShortInt);
        end;
      SB_BOTTOM:
        Result := Max;
      SB_TOP:
        Result := Min;
    end;
  end;

var
  Temp: Longint;
begin
  Result := False;
  if (not UseRightToLeftAlignment) or (not UseRightToLeft) then
    RTLFactor := 1
  else
    RTLFactor := -1;

  CalcDrawInfo(DrawInfo);
  if ColCount = 1 then
  begin
    Result  := True;
    NewLeft := -1;
    Exit;
  end;

  MaxTopLeft.X := ColCount - 1;
  MaxTopLeft.Y := RowCount - 1;
  MaxTopLeft := CalcMaxTopLeft(MaxTopLeft, DrawInfo);
  NewTopLeft := GetTopLeft;

  repeat
    Temp := NewTopLeft.X;
    NewTopLeft.X := CalcScrollBar(NewTopLeft.X, RTLFactor);
  until (NewTopLeft.X <= FixedCols) or (NewTopLeft.X >= MaxTopLeft.X)
     or (ColWidths[NewTopLeft.X] > 0) or (Temp = NewTopLeft.X);

  NewTopLeft.X := _intMax(FixedCols, _intMin(MaxTopLeft.X, NewTopLeft.X));
  NewTopLeft.Y := _intMax(FixedRows, _intMin(MaxTopLeft.Y, NewTopLeft.Y));

  if (NewTopLeft.X <> LeftCol) or (NewTopLeft.Y <> TopRow) then
  begin
    Result  := True;
    NewLeft := NewTopLeft.X;
  end;

end;

function TDCCustomTreeGrid.GetTopLeft: TGridCoord;
begin
  Result.X := LeftCol;
  Result.Y := TopRow;
end;

procedure SortKnots(Sender: TObject; Knots: TKnotItems; KnotItem: TKnotItem; L, R: Integer;
  SortCompare: TGridSortCompare; Data: integer);
var
  I, J, K: Integer;
  P: Pointer;
  AKnotItem: TKnotItem;
begin
  repeat
    I := L;
    J := R;
    K := (L + R) shr 1;
    P := KnotItem.Childs[K];
    repeat
      while SortCompare(Sender, KnotItem.Childs[I], P, Data) < 0 do Inc(I);
      while SortCompare(Sender, KnotItem.Childs[J], P, Data) > 0 do Dec(J);
      if I <= J then
      begin
        if (I <> J) and
           (SortCompare(Sender, KnotItem.Childs[I], KnotItem.Childs[J], Data) <> 0) then
        begin
          AKnotItem := KnotItem.Childs[I];
          KnotItem.Childs[I] := KnotItem.Childs[J];
          KnotItem.Childs[J] := AKnotItem;
          Knots.RebuildIndexes(KnotItem, i);
        end;
        Inc(I);
        Dec(J);
      end;
    until I > J;
    if L < J then SortKnots(Sender, Knots, KnotItem, L, J, SortCompare, Data);
    L := I;
  until I >= R;
end;

procedure TDCCustomTreeGrid.Sort(Level: integer; Compare: TGridSortCompare; Data: integer);
 var
  KnotItem: TKnotItem;

  procedure SortLevel(Parent: TKnotItem; Level: integer; Compare: TGridSortCompare);
   var
    KnotItem: TKnotItem;
    iCount: integer;
  begin
    if (Parent = nil) or (Parent.ChildCount = 0) then Exit;
    if Parent.Level = Level -1 then
    begin
      iCount := Parent.ChildCount - 1;
      if iCount > 0 then with Knots do
      begin
        LockRebuilds(Parent, True);
        SortKnots(Self, Knots, Parent, 0, iCount, Compare, Data);
        LockRebuilds(Parent, False);
      end;
    end
    else begin
      KnotItem := Parent.Childs[0];
      iCount   := Parent.ChildCount;
      while KnotItem <> nil do
      begin
        SortLevel(KnotItem, Level, Compare);
        if KnotItem.Index < iCount - 1 then
          KnotItem := Parent.Childs[KnotItem.Index + 1]
        else
          KnotItem := nil;
      end;
    end;
  end;

begin
  if (Knots <> nil) then
  begin
    KnotItem := SelectedKnot;
    Knots.BeginUpdate;
    SortLevel(Knots.Root, Level, Compare);
    ActivateBuffers;
    Knots.EndUpdate;
    SelectedKnot := KnotItem;
  end;
end;

function TDCCustomTreeGrid.CanColResize(ACol: integer): boolean;
 var
  i: integer;
  ColType: TFixedCol;
begin
  ColType := GetFixedColType(ACol, 0);
  case ColType of
    dcColumn:
      begin
        i := RawToDataColumn(ACol);
        if (i < Columns.Count) and (i > -1) then
          Result := (kcVisible in Columns[i].Options) and
            ((csDesigning in ComponentState) or (kcSizing in Columns[i].Options))
        else
          Result := True;
      end;
    dcTreePath:
      Result := ([tgTreePath, tgTreePathResize] * Options = [tgTreePath, tgTreePathResize]) and
        not(GroupingEnabled and (GroupBox.Count > 0));
    else
      Result := inherited CanColResize(ACol);     
  end;
end;

function TDCCustomTreeGrid.ResizeColWidth(ACol, AWidth: integer): boolean;
 var
  ColType: TFixedCol;
begin
  ColType := GetFixedColType(ACol, 0);
  case ColType of
    dcColumn:
      Result := inherited resizeColWidth(ACol, AWidth);
    dcTreePath:
      if TreepathWidth <> AWidth then
      begin
        TreepathWidth := AWidth;
        Result := True
      end
      else
        Result := False;
    else
      Result := False;
  end;
end;

procedure TDCCustomTreeGrid.SelectItems(Mode: TSelectMode);
begin
  case Mode of
    smSelect: FBookmarks.SelectAll;
    smDeselect: FBookmarks.Clear;
  end;
end;

procedure TDCCustomTreeGrid.SetOptionsEx(const Value: TTreeGridOptionsEx);
 var
  ChangedOptions: TTreeGridOptionsEx;
begin
  if FOptionsEx <> Value then
  begin
    ChangedOptions := (FOptionsEx + Value) - (FOptionsEx * Value);
    FOptionsEx := Value;
    if tgeShowLines in ChangedOptions then
      LayoutChanged
    else
      if [tgeMarkerMenu, tgeShadowSelection, tgeShowButtons,
          tgeTreeSelect, tgeIndicatorMenu] *  ChangedOptions  <> [] then
      begin
        invalidate;
      end;
  end;
end;

procedure TDCCustomTreeGrid.SetIndent(const Value: integer);
begin
  if FIndent <> Value then
  begin
    FIndent := _intMax(FTreeImages.Width + 2, Value);
    invalidate;
  end;
end;

procedure TDCCustomTreeGrid.SetColumnFooter(
  const Value: TKnotColumnFooter);
begin
  FColumnFooter.Assign(Value);
end;

function TDCCustomTreeGrid.GetCellByType(AColType: TFixedCol): integer;
 type
   AFixedCells = dcIndicator..dcTreePath;
 const
  ATypes: array[AFixedCells] of TTreeGridOption = (tgIndicator, tgMarker,
    tgTreePath);
 var
  j: TFixedCol;
begin
  Result := -1;
  for j := Low(ATypes) to High(ATypes) do
  begin
    if ATypes[j] in Options then Inc(Result);
    if AColType = j then Break;
  end;
end;

procedure TDCCustomTreeGrid.DoSelection(Select: Boolean; Shift: TShiftState;
  Direction, Offset: Integer);
 var
  AddAfter: Boolean;
begin
  AddAfter := False;
  BeginUpdate;
  try
    if (tgMultiSelect in Options) and (FKnots.Count > 0) then
      if Select and (ssShift in Shift) then
      begin
        if not FSelecting then
        begin
          FSelectionAnchor := CurrentBookmark;
          FBookmarks.Select(CurrentBookmark, True);
          FSelecting := True;
          AddAfter := True;
        end
        else
        with FBookmarks do
        begin
          AddAfter := Compare(CurrentBookmark, FSelectionAnchor) <> -Direction;
          if not AddAfter then Select(CurrentBookmark, False);
        end
      end
      else
        ClearSelection;
    MoveBy(Offset);
    if AddAfter then FBookmarks.Select(CurrentBookmark, True);
  finally
    EndUpdate;
  end;
end;

function TDCCustomTreeGrid.AlwaysShowSelection: boolean;
begin
  Result := (tgAlwaysShowSelection in Options) or
    ((tgMultiSelect in Options) and (FBookmarks.Count > 0));
end;

function TDCCustomTreeGrid.GetKnots: TKnotItems;
begin
  Result := FKnots;
end;

procedure TDCCustomTreeGrid.SetTreePath(const Value: TTreePath);
begin
  FTreePath.Assign(Value);
end;

function TDCCustomTreeGrid.GetGridHitTest(X, Y: integer): TGridHitTest;
 var
  Cell: TGridCoord;
  KnotItem: TKnotItem;

 const
  AHits: array[TFixedCol] of TGridHitTest = (gtFreeArea, gtIndicator, gtMarker,
    gtTreepath, gtGridArea);
begin
  Result := inherited GetGridHitTest(X, Y);
  if Result in [gtFreeArea] then
  begin
    Cell := MouseCoord(X, Y);
    if (Cell.Y > FTitleOffset) and (Cell.X > FIndicatorOffset) then
    begin
      Result := gtGridArea;
      if tgTreePathCompletion in Options then
      begin
        case Result of
          gtGridArea:
            begin
              KnotItem := GetKnotByCell(RawToDataRow(Cell.Y));
              if (KnotItem <> nil) and KnotItem.HasChildren then
                Result := gtTreePath
            end;
        end;
      end;
      Exit;
    end;
    Result := AHits[GetFixedColType(Cell.X, 0)];
    if Cell.Y < FTitleOffset then
    begin
      case Result of
        gtIndicator: Result := gtMainMenu;
        gtMarker: Result := gtMarkerMenu;
        gtTreePath: Result := gtTreeColumn;
        gtGridArea: Result := gtColumn;
      end;
    end
  end;
end;

function TDCCustomTreeGrid.CreateSelectedArea: TSelectedArea;
begin
  Result := TTreeSelectedArea.Create(Self, TTreeSelectedItem);
end;

function TDCCustomTreeGrid.GetSelectedArea: TTreeSelectedArea;
begin
  Result := TTreeSelectedArea(inherited GetSelectedArea);
end;

function TDCCustomTreeGrid.GetKnotByCell(ARow: integer): TKnotItem;
begin
  Result := FKnots.SelectKnot(FFirstVisible, ARow - FFirstIndex);
end;

function TDCCustomTreeGrid.GetFixedRowType(ARow,
  AOffset: integer): TFixedRow;
 var
  i: integer;
begin
  ARow := ARow + AOffset;
  if ARow < 0 then
  begin
    Result := drNone;
    Exit;
  end;
  Result := drGrid;

  if (ARow >= FTitleOffset) then Exit;

  i := 0;
  if tgTitles in Options then Inc(i, 2);

  if i shr (1 + ARow) > 0 then Result := drTitle;
end;

function TDCCustomTreeGrid.GetFrozenCols: Integer;
begin
  Result := FFrozenCols;
end;

procedure TDCCustomTreeGrid.SetFrozenCols(const Value: Integer);
begin
  UpdateFrozenCols(Value);
  if not(tgAutoSize in Options) then Perform(CM_SHOWINGCHANGED, 0 , 0);
end;

procedure TDCCustomTreeGrid.SetInternalRow(Value: integer);
 var
  ACol: integer;
begin
  LockUpdate;
  ACol := Col;
  SetInternalCol(_intMax(FixedCols, LeftCol), True);
  Row := Value;
  SetInternalCol(ACol, True);
  UnlockUpdate;
end;

procedure TDCCustomTreeGrid.WMKeyDown(var Message: TWMKeyDown);
begin
  if FClipDown then
    SendMessage(FClipPopup.Handle, WM_KEYDOWN, Message.CharCode,
      Message.KeyData);
  inherited
end;

procedure TDCCustomTreeGrid.SetInternalRowCount(Value: integer);
 var
  i, j: integer;
begin
  if Value <> RowCount then
  begin
    LockUpdate;
    try
      i := Col;
      j := LeftCol;
      SetInternalCol(_intMax(FixedCols, LeftCol), True);
      RowCount := Value;
      SetInternalCol(i, True);
      LeftCol := j;
    finally
      UnlockUpdate;
    end;
  end;
end;

procedure TDCCustomTreeGrid.UpdateVertScrollBar;
 var
  SIOld, SINew: TScrollInfo;

  procedure HideScrollBar;
  begin
    SetScrollRange(Self.Handle, SB_VERT, 0, 1, False);
    if not HideVertScrollBar and DataVisible then
    begin
      ShowScrollBar(Self.Handle, SB_VERT, True);
      EnableScrollBar(Self.Handle, SB_VERT, ESB_DISABLE_BOTH)
    end
    else
      ShowScrollBar(Self.Handle, SB_VERT, False);
  end;

begin
  if not HandleAllocated then Exit;

  if VertScrollBarVisible and DataVisible then
  begin
    SIOld.cbSize := SizeOf(SIOld);
    SIOld.fMask := SIF_ALL;
    GetScrollInfo(Self.Handle, SB_VERT, SIOld);
    SINew := SIOld;
    GetVertScrollInfo(SINew);
    if not CompareMem(@SIOld, @SINew, SizeOf(TScrollInfo)) then
    begin
      if SINew.nPage < ULONG(GetRecordCount) then
      begin
        ShowScrollBar(Self.Handle, SB_VERT, True);
        EnableScrollBar(Self.Handle, SB_VERT, ESB_ENABLE_BOTH);
        SetScrollInfo(Self.Handle, SB_VERT, SINew, True);
      end
      else
        HideScrollBar;
    end
  end
  else
    HideScrollBar;
end;

function TDCCustomTreeGrid.VertScrollBarVisible: boolean;
begin
  Result := True;
end;

procedure TDCCustomTreeGrid.GetVertScrollInfo(var ScrollInfo: TScrollInfo);
begin
  {}
end;

function TDCCustomTreeGrid.GetRowCount: integer;
begin
  Result := FKnots.VisibleKnotCount;
  if Result = 0 then Result := 1
end;

procedure TDCCustomTreeGrid.DeleteSelectedRecords;
 var
  I: integer;
begin
  with FKnots do
  begin
    BeginUpdate;
    try
      I := SelectedRows.Count - 1;
      while (I >= 0) and (SelectedRows.Count > 0) do
      begin
        Delete(TKnotItem(SelectedRows.Items[I]));
        Dec(I);
      end;
    finally
      EndUpdate;
    end;
  end;
end;

function TDCCustomTreeGrid.CompareBookmarks(Item1, Item2: Pointer): integer;
 var
  KnotID1, KnotID2: integer;
begin
  KnotID1 := TKnotItem(Item1).KnotID;
  KnotID2 := TKnotItem(Item2).KnotID;

  if KnotID1 = KnotID2 then
    Result := 0
  else if KnotID1 > KnotID2 then
    Result := 1
  else
    Result := -1;
end;

procedure TDCCustomTreeGrid.KnotNotification(KnotItem: TKnotItem;
  Operation: TKnotOperation);
 var
  i: integer;
  Bookmark: TKnotBookmark;
begin
 if Operation = kpRemove then
 begin
   if not(csDestroying in ComponentState) then
   begin
     Bookmark := GetBookmark(KnotItem);
     if (SelectedRows.Count > 0) and SelectedRows.Find(Bookmark, i) then
     begin
       ClearBookmarkData(SelectedRows.FList.Items[i]);
       SelectedRows.FList.Delete(i);
       SelectedRows.ListChanged;
     end;

     if Assigned(FCurrentPos[1].Bookmark) and
       (FCurrentPos[1].Bookmark = Bookmark) then
     begin
        ClearBookmarkData(FCurrentPos[1].Bookmark);
        FCurrentPos[1].Bookmark := nil;
     end;

     if Assigned(FCurrentPos[2].Bookmark) and
       (FCurrentPos[2].Bookmark = Bookmark) then
     begin
        ClearBookmarkData(FCurrentPos[2].Bookmark);
        FCurrentPos[2].Bookmark := nil;
     end;

     ClearBookmarkData(Bookmark);
   end;
 end;
end;

procedure TDCCustomTreeGrid.ClearBookmarkData(Bookmark: TKnotBookmark);
begin
  {}
end;

function TDCCustomTreeGrid.CurrentBookmark: TKnotBookmark;
begin
  Result := GetBookmark(FSelectedKnot);
end;

function TDCCustomTreeGrid.DoCancelOnMoving(AEof: boolean): boolean;
begin
  with FKnots do
  begin
    Result := True;
    if FEditorMode and not HideEditor then
    begin
      Result := False;
      Exit;
    end;
    if (State = ksInsert) and not Modified then
    begin
      if not AEof then
      begin
        LockUpdate(DoubleBuffered);
        try
          Delete(FSelectedKnot);
          SetState(ksBrowse);
        finally
          UnlockUpdate(DoubleBuffered);
        end;
      end
      else
        Result := False;
    end
  end;
end;

function TDCCustomTreeGrid.GetSelectedKnot: TKnotItem;
begin
  Result := FSelectedKnot;
end;

procedure TDCCustomTreeGrid.DoEndDrawCell(Data: pointer);
begin
  {}
end;

function TDCCustomTreeGrid.DoBeginDrawCell: pointer;
begin
  Result := nil
end;

function TDCCustomTreeGrid.GetColumns: TKnotColumns;
begin
  Result := FColumns;
end;

function TDCCustomTreeGrid.RawToDataRow(ARow: integer): integer;
begin
  Result := ARow - FTitleOffset;
end;

procedure TDCCustomTreeGrid.MoveBy(Offset: integer);
 var
  NewRow: integer;
begin
  if HideEditor then
  begin
    LockUpdate;
    try
      NewRow := _intMin(Row + Offset, RowCount - 1);
      NewRow := _intMax(NewRow, FTitleOffset);
      SetInternalRow(NewRow);
      SetSelectedKnot(FKnots.SelectKnot(FSelectedKnot, Offset));
    finally
      UnlockUpdate;
    end
  end;
end;

procedure TDCCustomTreeGrid.DeferLayout;
 var
  M: TMsg;
begin
  if HandleAllocated and
    not PeekMessage(M, Handle, CM_DEFERLAYOUT, CM_DEFERLAYOUT, pm_NoRemove) then
    PostMessage(Handle, CM_DEFERLAYOUT, 0, 0);
  CancelLayout;
end;

procedure TDCCustomTreeGrid.CancelLayout;
begin
  if FLayoutLock > 0 then
  begin
    if FLayoutLock = 1 then Columns.EndUpdate;
    Dec(FLayoutLock);
    EndUpdate;
  end;
end;

function TDCCustomTreeGrid.DoBeginInternalLayout: Pointer;
begin
  Result := nil;
end;

procedure TDCCustomTreeGrid.DoEndInternalLayout(Data: Pointer);
begin
  {}
end;

procedure TDCCustomTreeGrid.First;
begin
  if not DoCancelOnMoving(False) then Exit;
  SetInternalRow(FTitleOffset);
  SetSelectedKnot(FKnots.GetFirstVisibleNode);
  FBOF := True;
  FEOF := FSelectedKnot = nil;
end;

procedure TDCCustomTreeGrid.Last;
begin
  if not DoCancelOnMoving(Eof) then Exit;
  SetInternalRow(RowCount - 1);

  if Assigned(FFirstVisible) then
    SetSelectedKnot(FKnots.SelectKnot(FFirstVisible, RowCount - RawToDataRow(TopRow)))
  else
    SetSelectedKnot(FKnots.GetLastVisibleNode);
  FBOF := FSelectedKnot = nil;
  FEOF := True;
end;

procedure TDCCustomTreeGrid.UpdateHorzScrollPos;
var
  DrawInfo: TGridDrawInfo;
  MaxTopLeft: TGridCoord;
  GridSpace, ColWidth: Integer;

  procedure SetScroll(Code: Word; Value: Integer);
  begin
    if UseRightToLeftAlignment and (Code = SB_HORZ) then
      if ColCount <> 1 then
        Value := MaxShortInt - Value
      else
        Value := (ColWidth - GridSpace) - Value;
    if GetScrollPos(Handle, Code) <> Value then
      SetScrollPos(Handle, Code, Value, True);
  end;

begin
  if (not HandleAllocated) or (ScrollBars = ssNone) or (ColCount = 1) then Exit;
  CalcDrawInfo(DrawInfo);
  MaxTopLeft.X := ColCount - 1;
  MaxTopLeft.Y := RowCount - 1;
  MaxTopLeft := CalcMaxTopLeft(MaxTopLeft, DrawInfo);
  if ScrollBars in [ssHorizontal, ssBoth] then
     SetScroll(SB_HORZ, LongMulDiv(LeftCol - FixedCols, MaxShortInt,
       MaxTopLeft.X - FixedCols));
end;

procedure TDCCustomTreeGrid.SetInternalCol(Value: integer; Lock: boolean);
 var
  R: TRect;
begin
  if (Col <> Value) and
    ((Value < LeftCol) or (Value >= (LeftCol + VisibleColCount))) then
  begin
    LockUpdate;
    R := BoxRect(Col, Row, Col, Row);
    InvalidateRect(Handle, @R, False);
    inherited SetInternalCol(Value, Lock);
    UnlockUpdate;
  end
  else
    inherited SetInternalCol(Value, Lock);
end;

procedure TDCCustomTreeGrid.SetFixedColor(const Value: TColor);
begin
  if FFixedColor <> Value then
  begin
    FFixedColor := Value;
    Invalidate;
  end;
end;

procedure TDCCustomTreeGrid.CMColorChanged(var Message: TMessage);
begin
  inherited;
  if ColorToRGB(Color) = clSilver then
    inherited FixedColor := clGray
  else
    inherited FixedColor := clSilver
end;

function TDCCustomTreeGrid.GetAllFrozenCols: integer;
begin
  Result := FrozenCols;
  if (tgTreePath in Options) and (tgeTreeSelect in OptionsEx) then Inc(Result);
end;

function TDCCustomTreeGrid.FirstSelectCol: integer;
begin
  if (tgeTreeSelect in OptionsEx) and (TreePathWidth > 0) then
    Result := FIndicatorOffset - 1
  else
    Result := FIndicatorOffset
end;

function TDCCustomTreeGrid.HideVertScrollBar: boolean;
begin
  Result := True;
end;

function TDCCustomTreeGrid.GetRecordCount: integer;
begin
  Result := FKnots.VisibleKnotCount;
  if Result = 0 then Result := 1
end;

procedure TDCCustomTreeGrid.SelectAll;
 var
  KnotItem: TKnotItem;
  AList: TList;
begin
  KnotItem := Knots.GetFirstVisibleNode;
  AList := TList.Create;
  while KnotItem <> nil do
  begin
    AList.Add(GetBookmark(KnotItem));
    KnotItem := KnotItem.GetNextVisible;
  end;
  SelectedRows.Load(AList);
  AList.Free;
end;

function TDCCustomTreeGrid.ValidBookmark(Bookmark: TKnotBookmark): boolean;
begin
  Result := True;
end;

procedure TDCCustomTreeGrid.ClearBuffers;
begin
  FSelectedKnot := nil;
  FFirstIndex := -1;
  FEOF := True;
  FBOF := True;
end;

procedure TDCCustomTreeGrid.ActivateBuffers;
begin
  FFirstIndex   := 0;
  FFirstVisible := Knots.GetFirstVisibleNode;
  FSelectedKnot := FFirstVisible;
  FEOF := FSelectedKnot = nil;
  FBOF := FSelectedKnot = nil;
end;

function TDCCustomTreeGrid.BOF: boolean;
begin
  Result := FBOF;
end;

function TDCCustomTreeGrid.GetRowUpdateRgn(ARow: integer): HRGN;
 var
  R: TRect;
  Rgn1: HRGN;
  ACol: integer;
begin
  if [tgRowSelect, tgHighlightRow, tgTreePathCompletion] * Options <> [] then
  begin
    R := BoxRectEx(0, ARow, ColCount-1, ARow);
    Result := CreateRectRgnIndirect(R);
  end
  else begin
    if not(tgTreePath in Options) then
    begin
      R := BoxRect(Col, ARow, Col, ARow);
      Result := CreateRectRgnIndirect(R);
    end
    else begin
      R := BoxRect(Col, ARow, Col, ARow);
      Result := CreateRectRgnIndirect(R);
      ACol := GetCellByType(dcTreePath);
      R := BoxRect(ACol, ARow, ACol, ARow);
      Rgn1 := CreateRectRgnIndirect(R);
      CombineRgn(Result, Result, Rgn1, RGN_OR);
      DeleteObject(Rgn1);
    end;
    if tgIndicator in Options then
    begin
      ACol := GetCellByType(dcIndicator);
      R := BoxRect(ACol, ARow, ACol, ARow);
      Rgn1 := CreateRectRgnIndirect(R);
      CombineRgn(Result, Result, Rgn1, RGN_OR);
      DeleteObject(Rgn1);
    end;
  end;

end;

function TDCCustomTreeGrid.IsActiveControl: Boolean;
begin
  Result := inherited IsActiveControl or (EditorMode and FIInplaceEditor.Focused);
end;

procedure TDCCustomTreeGrid.UpdateInplaceEditor;

  procedure SetEditorParams;
  begin
    FInplaceCol := Col;
    FInplaceRow := Row;
    FIInplaceEditor.SelectAll;
    InvalidateSelected;
  end;

var
  Column: TKnotColumn;
  CanCreate: boolean;
  FixedCol: TFixedCol;
  Rgn: HRGN;
begin
  if CanInplaceEditShow then
  begin
    if FIInplaceEditor  = nil then
    begin
      FEditorMode := False;
      FixedCol := GetFixedColType(Col, 0);
      if (FixedCol = dcColumn) and (RawToDataColumn(Col) < Columns.Count) then
        Column := Columns[RawToDataColumn(Col)]
      else
        Column := nil;

      if (FSelectedKnot <> nil) and not FSelectedKnot.Enabled then Exit;
      if Column <> nil then
        if not(kcShowEdit in Column.Options) then Exit else
      else
        if not(tgeShowTreeEdit in OptionsEx) then Exit else;

      if FKnots.Count = 0 then
      begin
        InsertKnot(False, []);
        if (FSelectedKnot = nil) or not FSelectedKnot.Enabled then Exit;
      end;

      DoCreateCellEdit(Column, FIInplaceEditor, CanCreate);

      if CanCreate and Assigned(FIInplaceEditor) then
      begin
        FEditorMode := True;
        _setFlag(FFlags, TGF_ISDATAMODIFIED, False);
        with FIInplaceEditor do
        begin
          Visible   := False;
          ReadOnly  := kcReadOnly in Column.Options;
          if Options * [tgColLines, tgRowLines] = [tgColLines, tgRowLines] then
            DrawStyle := fsNone
          else
            DrawStyle := fsSingle;
        end;
        SetEditorParams;
      end
      else
        if CanCreate then
        begin
          Rgn := GetRowUpdateRgn(Row);
          InvalidateRgn(Handle, Rgn, False);
          DeleteObject(Rgn);
        end
    end
    else
      if (Col <> FInplaceCol) or (Row <> FInplaceRow) then SetEditorParams;

    if CanInplaceEditShow and FEditorMode then
      InplaceUpdateLoc(FIInplaceEditor, CellRect(Col, Row), Canvas);
  end
  else
    FEditorMode := False;
end;

function TDCCustomTreeGrid.CanEditShow: Boolean;
begin
  Result := False;
end;

function TDCCustomTreeGrid.CanInplaceEditShow: Boolean;
begin
  Result := ([tgRowSelect, tgEditing] * Options = [tgEditing]) and
    FEditorMode and not(csDesigning in ComponentState) and HandleAllocated and
    ((tgAlwaysShowEditor in Options) or IsActiveControl);
end;

procedure TDCCustomTreeGrid.DrawSizingLineEx(const DrawInfo: TGridDrawInfo;
  AGridState : TGridState; X, Y: integer);
 var
  DrawingPen: TPen;
begin
  DrawingPen := TPen.Create;
  try
    with Canvas, DrawInfo do
    begin
      DrawingPen.Assign(Pen);
      Pen.Style := psDot;
      Pen.Mode  := pmXor;
      Pen.Width := 1;
      try
        case AGridState of
          gsColSizing:
            begin
              MoveTo(X, 0);
              LineTo(X, Vert.GridBoundary);
            end;
        end;
      finally
        Pen := DrawingPen;
      end;
    end;
  finally
    DrawingPen.Free;
  end;
end;

procedure TDCCustomTreeGrid.SetFocus;
begin
  if not FEditorMode then inherited;
end;

{$IFDEF DELPHI_V5UP}
  function TDCCustomTreeGrid.CanFocus: Boolean;
  begin
    if not FEditorMode then
      Result := inherited CanFocus
    else
      Result := False;
  end;
{$ENDIF}

function TDCCustomTreeGrid.GetKnotsUpdating: boolean;
begin
  Result := Knots.Updating;
end;

procedure TDCCustomTreeGrid.UpdateFrozenCols(const Value: integer);
var
  FixCount, I, ACol, j, n: Integer;
  Changed: boolean;
begin
  Changed := False;
  FixCount := _intMax(Value, 0) + IndicatorOffset;
  n := 0;
  if not (csLoading in ComponentState) and (ColCount > IndicatorOffset + 1) then
  begin
    for j := 0 to Columns.Count - 1 do
    begin
      if not(kcVisible in Columns[j].Options) and (j >= Value) then
        Inc(n)
      else
        Break
    end;
    FixCount := _intMin(FixCount + n, ColCount - 1);
    if (FFrozenCols <> Value) or (FixCount <> FixedCols) then
    begin
      ACol := Col;
      LockUpdate(True);
      try
        FixedCols := FixCount;
        Col := ACol;
      finally
        UnlockUpdate(True);
      end;
      for I := 1 to FixCount do TabStops[I] := False;
      Changed := True;
    end
  end;
  if not Changed then  FixedCols := _intMin(ColCount -1, FixCount);
  FFrozenCols := FixCount - IndicatorOffset - n;
end;

function TDCCustomTreeGrid.DrawBuffered: boolean;
begin
  Result := not DoubleBuffered and (DefaultDrawing or
    (tgeDrawBuffered in OptionsEx));
end;

procedure TDCCustomTreeGrid.DoDataChanged;
begin
  if Assigned(FOnDataChanged) then FOnDataChanged(Self);
end;

procedure TDCCustomTreeGrid.DrawTitlePopup(ACanvas: TCanvas; ARect: TRect;
  BorderState: TDrawBorerState; DrawColumn: TKnotColumn);
 var
  X, Y: integer;
  BorderStyle: TEdgeBorderStyle;
  AColor: TColor;
  ABrush: HBRUSH;

  procedure DrawFlatBorder;
  begin
    if BorderStyle = ebsShadowFlat then
    begin
      Dec(ARect.Left);
      DrawGridFrameBorder(ACanvas, ARect, BorderStyle, BorderState,
        FixedColor);
      InflateRect(ARect, -2, -2);
    end
    else begin
      if BorderStyle = ebsNone then
      begin
        Dec(ARect.Left);
        Dec(ARect.Right);
      end
      else
        Inc(ARect.Left);
      DrawGridFrameBorder(ACanvas, ARect, BorderStyle, BorderState,
        FixedColor);
      InflateRect(ARect, -1, -1);
    end;
  end;

begin
  BorderStyle := GetBorderStyle;
  case GridDrawing.ClipStyle of
    csSingleBorder:
      DrawFlatBorder;
    csFlatBorder:
      if BorderState = dsDown then
      begin
        ABrush := CreateSolidBrush(clDarkShadow);
        InflateRect(ARect, 1, 1);
        Dec(ARect.Right);
        FrameRect(Canvas.Handle, ARect, ABrush);
        DeleteObject(ABrush);
      end
      else
        DrawFlatBorder;
  end;

  AColor := clBlack;
  X := ARect.Left + 1;
  Y := ARect.Top + 3;
  if BorderStyle = ebsNone then Inc(X);
  if BorderState = dsDown then
  begin
    if BorderStyle <> ebsNone then
    begin
      Inc(Y);
      ABrush := CreateSolidBrush(ColorToRGB(DrawColumn.Title.Color));
    end
    else begin
      AColor := clWhite;
      ABrush := CreateSolidBrush(clXPDropDown);
      Inc(ARect.Right);
    end;
    if GridDrawing.ClipStyle = csFlatBorder then
    begin
      Inc(X, 3);
      Inc(Y, 1);
      InflateRect(ARect, -1, -1);
    end;
  end
  else
    ABrush := CreateSolidBrush(ColorToRGB(DrawColumn.Title.Color));
  FillRect(ACanvas.Handle, ARect, ABrush);
  DeleteObject(ABrush);
  DrawBasicShape(ACanvas.Handle, shDown, X, Y, AColor, szSmall);
end;

function TDCCustomTreeGrid.GetTitleMenuRect(ARect: TRect;
  var MenuRect: TRect): boolean;
begin
  MenuRect := ARect;
  if GetBorderStyle <> ebsNone then
    MenuRect.Left := _intMax(ARect.Left, ARect.Right - 8)
  else
    MenuRect.Left := _intMax(ARect.Left, ARect.Right - 7);

  if not(MenuRect.Left < MenuRect.Right) then
  begin
    SetRectEmpty(MenuRect);
    Result := False;
  end
  else
    Result := True
end;

procedure TDCCustomTreeGrid.SetLineColor(const Value: TColor);
begin
  if FLineColor <> Value then
  begin
    FLineColor := Value;
    invalidate;
  end;
end;

procedure TDCCustomTreeGrid.GetConnectionPos(var X, Y, AWidth: integer;
  var Position: TPopupPosition);
 var
  R: TRect;
begin
  case FClipPopup.ColType of
    dcNone, dcIndicator, dcMarker, dcTreePath:
      begin
        Position := ppBottomLeft;
        R := CellRect(GetCellByType(FClipPopup.ColType), 0);
      end;
    dcColumn:
      begin
        Position := ppBottomRight;
        R := CellRect(FClipPopup.ColumnIndex, 0);
        GetTitleMenuRect(R, R);
      end;
  end;
  InflateRect(R, 1, 0);
  Dec(R.Right);
  AWidth := R.Right - R.Left;
  X := R.Left;
  Y := R.Bottom;
end;



procedure TDCCustomTreeGrid.SizeChanged(OldColCount, OldRowCount: Integer);
begin
  inherited;
  {}
end;

function TDCCustomTreeGrid.Initialize: TDCTreeGridInitialize;
begin
  Result.ColumnsClass := TKnotColumns;
  Result.ColumnClass := TKnotColumn;
  Result.ItemsClass := TKnotItems;
  Result.ItemClass := TKnotItem;
end;

procedure TDCCustomTreeGrid.CMHookMessage(var Message: TMessage);
 var
  Msg: TMsg;
begin
  Msg := PMsg(Message.LParam)^;
  HookMessage(Message.wParam, Msg);
end;

procedure TDCCustomTreeGrid.HookMessage(wParam: Integer; var Msg: TMsg);
begin
  with Msg do
  begin
    case message of
      CM_DEACTIVATE, CM_RELEASE, WM_KILLFOCUS, WM_CLOSE:
        HideHintWindow;
    end;
  end;
end;

procedure TDCCustomTreeGrid.CMHintActivate(var Message: TMessage);
 var
  pPause: ^Integer;
  pHintWindow: PHintWindowParam_tag;
begin
  pHintWindow := PHintWindowParam_tag(Message.LParam);
  if not pHintWindow^.Active and (FHintRow = -1) then
  begin
    pPause  := Pointer(Message.WParam);
    pPause^ := 300;
  end;
end;

procedure TDCCustomTreeGrid.CMPopupWindowShow(var Message: TMessage);
 var
  pHintWindow: PHintWindowParam_tag;
begin
  pHintWindow := PHintWindowParam_tag(Message.LParam);
  if pHintWindow^.Active and (pHintWindow^.Handle = FHintWindow.Handle) then
  begin
    FHintRow := FHintWindow.FCell.Y;
  end;
end;

{ TKnotBookmarkList }

procedure TKnotBookmarkList.Clear;
 var
  i, j: integer;
begin
  i := FList.Count;
  if i <> 0 then
  begin
    for j := 0 to i - 1 do FGrid.ClearBookmarkData(Flist.Items[j]);
    FList.Clear;
    InvalidateMarker(-1);
  end;
end;

function TKnotBookmarkList.Compare(const Bookmark1,
  Bookmark2: TKnotBookmark): Integer;
begin
  Result := FGrid.CompareBookmarks(Bookmark1, Bookmark2)
end;

constructor TKnotBookmarkList.Create(AGrid: TDCCustomTreeGrid);
begin
  inherited Create;
  FList := TList.Create;
  FGrid := AGrid;
  FSortItems := True;
  ListChanged;
end;

procedure TKnotBookmarkList.Delete;
begin
  FGrid.DeleteSelectedRecords;
end;

destructor TKnotBookmarkList.Destroy;
begin
  Clear;
  FList.Free;
  inherited Destroy;
end;

function TKnotBookmarkList.Find(const Bookmark: TKnotBookmark;
  var Index: Integer): Boolean;
var
  L, H, I, C: Integer;
begin
  if (Bookmark = FCache) and (FCacheIndex >= 0) then
  begin
    Index  := FCacheIndex;
    Result := FCacheFind;
    Exit;
  end;
  Result := False;
  L := 0;
  H := FList.Count - 1;
  while L <= H do
  begin
    I := (L + H) shr 1;
    C := Compare(FList[I], Bookmark);
    if C < 0 then L := I + 1 else
    begin
      H := I - 1;
      if C = 0 then
      begin
        Result := True;
        L := I;
      end;
    end;
  end;
  Index       := L;
  FCache      := Bookmark;
  FCacheIndex := Index;
  FCacheFind  := Result;
end;

function TKnotBookmarkList.GetCount: integer;
begin
  Result := FList.Count;
end;

function TKnotBookmarkList.GetItem(Index: Integer): TKnotBookmark;
begin
  Result := FList[Index];
end;

function TKnotBookmarkList.IndexOf(const Bookmark: TKnotBookmark): Integer;
begin
  if not Find(Bookmark, Result) then Result := -1;
end;

procedure TKnotBookmarkList.InvalidateMarker(ARow: integer);
 var
  R: TRect;
  ACell: integer;
begin
  with FGrid do
  begin
    if not FGrid.Knots.Updating and not (csDestroying in ComponentState) then
    begin
      if tgMultiSelect in Options then
        R := BoxRectEx(0, ARow, ColCount - 1, ARow)
      else if(tgMarker in Options) then
      begin
        ACell := GetCellByType(dcMarker);
        R := BoxRect(ACell, 0, ACell, RowCount - 1);
      end;
      InvalidateRect(FGrid.Handle, @R, False);
    end;
  end;
end;

function TKnotBookmarkList.Selected(const Bookmark: TKnotBookmark): Boolean;
 var
  Index: integer;
begin
  Result := Find(Bookmark, Index);
end;

procedure TKnotBookmarkList.ListChanged;
begin
  FCache      := nil;
  FCacheIndex := -1;
  FGrid.BookmarksChanged;
end;

procedure TKnotBookmarkList.AssignList(Dest, Source: TList);
{$IFDEF DELPHI_V6}
begin
  Dest.Assign(Source);
{$ELSE}
 var
  i: integer;
begin
  Dest.Clear;
  Dest.Capacity := Source.Capacity;
  for i := 0 to Source.Count - 1 do Dest.Add(Source.List[I]);
{$ENDIF}
end;

procedure TKnotBookmarkList.Load(List: TList);
begin
  Clear;
  AssignList(FList, List);
  ListChanged;
end;

procedure TKnotBookmarkList.Save(List: TList);
begin
  AssignList(List, FList);
end;

procedure TKnotBookmarkList.Select(Bookmark: TKnotBookmark; Value: boolean);
 var
  Index: integer;
begin
  if not Find(Bookmark, Index) = Value then
  begin;
    if Value then
    begin
      FList.Add(Bookmark);
      if FSortItems then Sort;
    end
    else begin
      FGrid.ClearBookmarkData(FList.Items[Index]);
      FList.Delete(Index);
    end;
    ListChanged;
    InvalidateMarker(FGrid.Row);
  end;
end;

procedure TKnotBookmarkList.SelectAll;
begin
  try
    FGrid.SelectAll;
    Sort;
  finally
    InvalidateMarker(-1);
  end;
end;

procedure TKnotBookmarkList.Sort;
begin
  if (FList.List <> nil) and (Count > 0) then
    QuickSort(FList.List, 0, Count - 1, FGrid.CompareBookmarks);
end;

procedure TKnotBookmarkList.QuickSort(SortList: PPointerList; L,
  R: Integer; CompareProc: TKnotCompareProc);
var
  I, J: Integer;
  P, T: Pointer;
begin
  repeat
    I := L;
    J := R;
    P := SortList^[(L + R) shr 1];
    repeat
      while CompareProc(SortList^[I], P) < 0 do
        Inc(I);
      while CompareProc(SortList^[J], P) > 0 do
        Dec(J);
      if I <= J then
      begin
        T := SortList^[I];
        SortList^[I] := SortList^[J];
        SortList^[J] := T;
        Inc(I);
        Dec(J);
      end;
    until I > J;
    if L < J then
      QuickSort(SortList, L, J, CompareProc);
    L := I;
  until I >= R;
end;

{ TDCInplaceEdit }

procedure TDCInplaceChoiceEdit.ChoiceClick(Sender: TObject);
begin
  Grid.SetModified(True);
  inherited;
end;

procedure TDCInplaceChoiceEdit.CMWantSpecialKey(var Msg: TCMWantSpecialKey);
begin
  inherited;
  if Msg.CharCode = VK_RETURN then Msg.Result := 1;
end;

constructor TDCInplaceChoiceEdit.Create(AOwner: TComponent);
begin
  inherited;
  Visible := False;
end;

procedure TDCInplaceChoiceEdit.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.Style := Params.Style or ES_MULTILINE;
end;

function TDCInplaceChoiceEdit.DoMouseWheel(Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint): Boolean;
begin
  Result := Grid.DoMouseWheel(Shift, WheelDelta, MousePos);
end;

function TDCInplaceChoiceEdit.GetEditType: TInplaceEditType;
begin
  Result := etChoiceEdit;
end;

function TDCInplaceChoiceEdit.GetGrid: TDCCustomTreeGrid;
begin
  Result := FGrid;
end;

procedure TDCInplaceChoiceEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  if Key > $20 then HideErrorMessage;
  if not DroppedDown then InplaceKeyDown(Self, Grid, Key, Shift);
  if Key <> 0 then
  begin
    if not ReadOnly then Grid.SetModified(True);
    inherited KeyDown(Key, Shift);
  end;
end;

procedure TDCInplaceChoiceEdit.KeyPress(var Key: Char);
begin
  if not(Key in [#27, #8]) and not ReadOnly then Grid.SetModified(True);
  Grid.KeyPress(Key);
  if Key <> #0 then inherited KeyPress(Key);
end;

procedure TDCInplaceChoiceEdit.KeyUp(var Key: Word; Shift: TShiftState);
begin
  if not DroppedDown then Grid.KeyUp(Key, Shift);
  if Key <> 0 then
    inherited KeyUp(Key, Shift);
end;

procedure TDCInplaceChoiceEdit.KillFocus(var Value: boolean);
begin
  with Grid do
  begin
    if not EditorMode or (FInplaceCol <> -1) or (FInplaceRow <> -1) then
      Value := False
    else
      inherited KillFocus(Value);
  end;
end;

procedure TDCInplaceChoiceEdit.SetGrid(Value: TDCCustomTreeGrid);
begin
  FGrid := Value;
end;

procedure TDCInplaceChoiceEdit.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  inherited;
  if tgTabs in Grid.Options then
    Message.Result := Message.Result or DLGC_WANTTAB;
end;

procedure TDCInplaceChoiceEdit.WMKillFocus(var Message: TMessage);
begin
  inherited;
  if not Grid.IsActiveControl then with Grid do
  begin
    if not(tgeKeepEditing in OptionsEx) then
      if HideEditor then InvalidateSelected
    else
      InvalidateSelected;
  end;
end;

procedure TDCInplaceChoiceEdit.WMSetFocus(var Message: TWMSetFocus);
begin
  inherited;
  Grid.InvalidateSelected;
end;

{ TDCInplaceDateEdit }

procedure TDCInplaceDateEdit.ChoiceClick(Sender: TObject);
begin
  Grid.SetModified(True);
  inherited;
end;

procedure TDCInplaceDateEdit.CMWantSpecialKey(var Msg: TCMWantSpecialKey);
begin
  inherited;
  if Msg.CharCode = VK_RETURN then Msg.Result := 1;
end;

constructor TDCInplaceDateEdit.Create(AOwner: TComponent);
begin
  inherited;
  Visible := False;
end;

procedure TDCInplaceDateEdit.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.Style := Params.Style or ES_MULTILINE;
end;

function TDCInplaceDateEdit.DoMouseWheel(Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint): Boolean;
begin
  Result := Grid.DoMouseWheel(Shift, WheelDelta, MousePos);
end;

function TDCInplaceDateEdit.GetEditType: TInplaceEditType;
begin
  Result := etDateEdit;
end;

function TDCInplaceDateEdit.GetGrid: TDCCustomTreeGrid;
begin
  Result := FGrid;
end;

procedure TDCInplaceDateEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  if Key > $20 then HideErrorMessage;
  if not DroppedDown then InplaceKeyDown(Self, Grid, Key, Shift);
  if Key <> 0 then
  begin
    if not ReadOnly then Grid.SetModified(True);
    inherited KeyDown(Key, Shift);
  end;
end;

procedure TDCInplaceDateEdit.KeyPress(var Key: Char);
begin
  if not(Key in [#27, #8]) and not ReadOnly then Grid.SetModified(True);
  Grid.KeyPress(Key);
  if Key <> #0 then inherited KeyPress(Key);
end;

procedure TDCInplaceDateEdit.KeyUp(var Key: Word; Shift: TShiftState);
begin
  if not DroppedDown then Grid.KeyUp(Key, Shift);
  if Key <> 0 then
    inherited KeyUp(Key, Shift);
end;

procedure TDCInplaceDateEdit.KillFocus(var Value: boolean);
begin
  with Grid do
  begin
    if not EditorMode or (FInplaceCol <> -1) or (FInplaceRow <> -1) then
      Value := False
    else
      inherited KillFocus(Value);
  end;
end;

procedure TDCInplaceDateEdit.SetGrid(Value: TDCCustomTreeGrid);
begin
  FGrid := Value;
end;

procedure TDCInplaceDateEdit.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  inherited;
  if tgTabs in Grid.Options then
    Message.Result := Message.Result or DLGC_WANTTAB;
end;

procedure TDCInplaceDateEdit.WMKillFocus(var Message: TMessage);
begin
  inherited;
  if not Grid.IsActiveControl then with Grid do
  begin
    if not(tgeKeepEditing in OptionsEx) then
      if HideEditor then InvalidateSelected
    else
      InvalidateSelected;
  end;
end;

procedure TDCInplaceDateEdit.WMSetFocus(var Message: TWMSetFocus);
begin
  inherited;
  Grid.InvalidateSelected;
end;

{ TDCInplaceGridEdit }

procedure TDCInplaceGridEdit.ChoiceClick(Sender: TObject);
begin
  Grid.SetModified(True);
  inherited;
end;

procedure TDCInplaceGridEdit.CMWantSpecialKey(var Msg: TCMWantSpecialKey);
begin
  inherited;
  if Msg.CharCode = VK_RETURN then Msg.Result := 1;
end;

constructor TDCInplaceGridEdit.Create(AOwner: TComponent);
begin
  inherited;
  Visible := False; 
end;

procedure TDCInplaceGridEdit.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.Style := Params.Style or ES_MULTILINE;
end;

function TDCInplaceGridEdit.DoMouseWheel(Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint): Boolean;
begin
  Result := Grid.DoMouseWheel(Shift, WheelDelta, MousePos);
end;

function TDCInplaceGridEdit.GetEditType: TInplaceEditType;
begin
  Result := etGridEdit;
end;

function TDCInplaceGridEdit.GetGrid: TDCCustomTreeGrid;
begin
  Result := FGrid;
end;

procedure TDCInplaceGridEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  if Key > $20 then HideErrorMessage;
  if not DroppedDown then InplaceKeyDown(Self, Grid, Key, Shift);
  if Key <> 0 then
  begin
    if not ReadOnly then Grid.SetModified(True);
    inherited KeyDown(Key, Shift);
  end;
end;

procedure TDCInplaceGridEdit.KeyPress(var Key: Char);
begin
  if not(Key in [#27, #8]) and not ReadOnly then Grid.SetModified(True);
  Grid.KeyPress(Key);
  if Key <> #0 then inherited KeyPress(Key);
end;

procedure TDCInplaceGridEdit.KeyUp(var Key: Word; Shift: TShiftState);
begin
  if not DroppedDown then Grid.KeyUp(Key, Shift);
  if Key <> 0 then
    inherited KeyUp(Key, Shift);
end;

procedure TDCInplaceGridEdit.KillFocus(var Value: boolean);
begin
  with Grid do
  begin
    if not EditorMode or (FInplaceCol <> -1) or (FInplaceRow <> -1) then
      Value := False
    else
      inherited KillFocus(Value);
  end;
end;

procedure TDCInplaceGridEdit.SetGrid(Value: TDCCustomTreeGrid);
begin
  FGrid := Value;
end;

procedure TDCInplaceGridEdit.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  inherited;
  if tgTabs in Grid.Options then
    Message.Result := Message.Result or DLGC_WANTTAB;
end;

procedure TDCInplaceGridEdit.WMKillFocus(var Message: TMessage);
begin
  inherited;
  if not Grid.IsActiveControl then with Grid do
  begin
    if not(tgeKeepEditing in OptionsEx) then
      if HideEditor then InvalidateSelected
    else
      InvalidateSelected;
  end;
end;

procedure TDCInplaceGridEdit.WMSetFocus(var Message: TWMSetFocus);
begin
  inherited;
  Grid.InvalidateSelected;
end;

{ TDCInplaceTreeEdit }

procedure TDCInplaceTreeEdit.ChoiceClick(Sender: TObject);
begin
  Grid.SetModified(True);
  inherited;
end;

procedure TDCInplaceTreeEdit.CMWantSpecialKey(var Msg: TCMWantSpecialKey);
begin
  inherited;
  if Msg.CharCode = VK_RETURN then Msg.Result := 1;
end;

constructor TDCInplaceTreeEdit.Create(AOwner: TComponent);
begin
  inherited;
  Visible := False;
end;

procedure TDCInplaceTreeEdit.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.Style := Params.Style or ES_MULTILINE;
end;

function TDCInplaceTreeEdit.DoMouseWheel(Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint): Boolean;
begin
  Result := Grid.DoMouseWheel(Shift, WheelDelta, MousePos);
end;

function TDCInplaceTreeEdit.GetEditType: TInplaceEditType;
begin
  Result := etTreeEdit;
end;

function TDCInplaceTreeEdit.GetGrid: TDCCustomTreeGrid;
begin
  Result := FGrid;
end;

procedure TDCInplaceTreeEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  if Key > $20 then HideErrorMessage;
  if not DroppedDown then InplaceKeyDown(Self, Grid, Key, Shift);
  if Key <> 0 then
  begin
    if not ReadOnly then Grid.SetModified(True);
    inherited KeyDown(Key, Shift);
  end;
end;

procedure TDCInplaceTreeEdit.KeyPress(var Key: Char);
begin
  if not(Key in [#27, #8]) and not ReadOnly then Grid.SetModified(True);
  Grid.KeyPress(Key);
  if Key <> #0 then inherited KeyPress(Key);
end;

procedure TDCInplaceTreeEdit.KeyUp(var Key: Word; Shift: TShiftState);
begin
  if not DroppedDown then Grid.KeyUp(Key, Shift);
  if Key <> 0 then
    inherited KeyUp(Key, Shift);
end;

procedure TDCInplaceTreeEdit.KillFocus(var Value: boolean);
begin
  with Grid do
  begin
    if not EditorMode or (FInplaceCol <> -1) or (FInplaceRow <> -1) then
      Value := False
    else
      inherited KillFocus(Value);
  end;
end;

procedure TDCInplaceTreeEdit.SetGrid(Value: TDCCustomTreeGrid);
begin
  FGrid := Value;
end;

procedure TDCInplaceTreeEdit.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  inherited;
  if tgTabs in Grid.Options then
    Message.Result := Message.Result or DLGC_WANTTAB;
end;

procedure TDCInplaceTreeEdit.WMKillFocus(var Message: TMessage);
begin
  inherited;
  if not Grid.IsActiveControl then with Grid do
  begin
    if not(tgeKeepEditing in OptionsEx) then
      if HideEditor then InvalidateSelected
    else
      InvalidateSelected;
  end;
end;

procedure TDCInplaceTreeEdit.WMSetFocus(var Message: TWMSetFocus);
begin
  inherited;
  Grid.InvalidateSelected;
end;

{ TDCInplaceComboBox }

procedure TDCInplaceComboBox.ChoiceClick(Sender: TObject);
begin
  Grid.SetModified(True);
  inherited;
end;

procedure TDCInplaceComboBox.CMWantSpecialKey(var Msg: TCMWantSpecialKey);
begin
  inherited;
  if Msg.CharCode = VK_RETURN then Msg.Result := 1;
end;

constructor TDCInplaceComboBox.Create(AOwner: TComponent);
begin
  inherited;
  Visible := False;
end;

procedure TDCInplaceComboBox.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.Style := Params.Style or ES_MULTILINE;
end;

function TDCInplaceComboBox.DoMouseWheel(Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint): Boolean;
begin
  Result := Grid.DoMouseWheel(Shift, WheelDelta, MousePos);
end;

function TDCInplaceComboBox.GetEditType: TInplaceEditType;
begin
  Result := etComboBox;
end;

function TDCInplaceComboBox.GetGrid: TDCCustomTreeGrid;
begin
  Result := FGrid;
end;

procedure TDCInplaceComboBox.KeyDown(var Key: Word; Shift: TShiftState);
begin
  if Key > $20 then HideErrorMessage;
  if not DroppedDown then InplaceKeyDown(Self, Grid, Key, Shift);
  if Key <> 0 then
  begin
    if not ReadOnly then Grid.SetModified(True);
    inherited KeyDown(Key, Shift);
  end;
end;

procedure TDCInplaceComboBox.KeyPress(var Key: Char);
begin
  if not(Key in [#27, #8]) and not ReadOnly then Grid.SetModified(True);
  Grid.KeyPress(Key);
  if Key <> #0 then inherited KeyPress(Key);
end;

procedure TDCInplaceComboBox.KeyUp(var Key: Word; Shift: TShiftState);
begin
  if not DroppedDown then Grid.KeyUp(Key, Shift);
  if Key <> 0 then
    inherited KeyUp(Key, Shift);
end;

procedure TDCInplaceComboBox.KillFocus(var Value: boolean);
begin
  with Grid do
  begin
    if not EditorMode or (FInplaceCol <> -1) or (FInplaceRow <> -1) then
      Value := False
    else
      inherited KillFocus(Value);
  end;
end;

procedure TDCInplaceComboBox.SetGrid(Value: TDCCustomTreeGrid);
begin
  FGrid := Value;
end;

procedure TDCInplaceComboBox.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  inherited;
  if tgTabs in Grid.Options then
    Message.Result := Message.Result or DLGC_WANTTAB;
end;

procedure TDCInplaceComboBox.WMKillFocus(var Message: TMessage);
begin
  inherited;
  if not Grid.IsActiveControl then with Grid do
  begin
    if not(tgeKeepEditing in OptionsEx) then
      if HideEditor then InvalidateSelected
    else
      InvalidateSelected;
  end;
end;

procedure TDCInplaceComboBox.WMSetFocus(var Message: TWMSetFocus);
begin
  inherited;
  Grid.InvalidateSelected;
end;

{ TDCInplaceFloatEdit }

procedure TDCInplaceFloatEdit.ChoiceClick(Sender: TObject);
begin
  Grid.SetModified(True);
  inherited;
end;

procedure TDCInplaceFloatEdit.CMWantSpecialKey(var Msg: TCMWantSpecialKey);
begin
  inherited;
  if Msg.CharCode = VK_RETURN then Msg.Result := 1;
end;

constructor TDCInplaceFloatEdit.Create(AOwner: TComponent);
begin
  inherited;
  Visible := False;
end;

procedure TDCInplaceFloatEdit.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.Style := Params.Style or ES_MULTILINE;
end;

function TDCInplaceFloatEdit.DoMouseWheel(Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint): Boolean;
begin
  Result := Grid.DoMouseWheel(Shift, WheelDelta, MousePos);
end;

function TDCInplaceFloatEdit.GetEditType: TInplaceEditType;
begin
  Result := etFloatEdit;
end;

function TDCInplaceFloatEdit.GetGrid: TDCCustomTreeGrid;
begin
  Result := FGrid;
end;

procedure TDCInplaceFloatEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  if Key > $20 then HideErrorMessage;
  if not DroppedDown then InplaceKeyDown(Self, Grid, Key, Shift);
  if Key <> 0 then
  begin
    if not ReadOnly then Grid.SetModified(True);
    inherited KeyDown(Key, Shift);
  end;
end;

procedure TDCInplaceFloatEdit.KeyPress(var Key: Char);
begin
  if not(Key in [#27, #8]) and not ReadOnly then Grid.SetModified(True);
  Grid.KeyPress(Key);
  if Key <> #0 then inherited KeyPress(Key);
end;

procedure TDCInplaceFloatEdit.KeyUp(var Key: Word; Shift: TShiftState);
begin
  if not DroppedDown then Grid.KeyUp(Key, Shift);
  if Key <> 0 then
    inherited KeyUp(Key, Shift);
end;

procedure TDCInplaceFloatEdit.KillFocus(var Value: boolean);
begin
  with Grid do
  begin
    if not EditorMode or (FInplaceCol <> -1) or (FInplaceRow <> -1) then
      Value := False
    else
      inherited KillFocus(Value);
  end;
end;

procedure TDCInplaceFloatEdit.SetGrid(Value: TDCCustomTreeGrid);
begin
  FGrid := Value;
end;

procedure TDCInplaceFloatEdit.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  inherited;
  if tgTabs in Grid.Options then
    Message.Result := Message.Result or DLGC_WANTTAB;
end;

{ TDCInplaceADOGridEdit }

{$IFDEF ADO_EXPRESS}

procedure TDCInplaceADOGridEdit.ChoiceClick(Sender: TObject);
begin
  Grid.SetModified(True);
  inherited;
end;

procedure TDCInplaceADOGridEdit.CMWantSpecialKey(
  var Msg: TCMWantSpecialKey);
begin
  inherited;
  if Msg.CharCode = VK_RETURN then Msg.Result := 1;
end;

constructor TDCInplaceADOGridEdit.Create(AOwner: TComponent);
begin
  inherited;
  Visible := False;
end;

procedure TDCInplaceADOGridEdit.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.Style := Params.Style or ES_MULTILINE;
end;

function TDCInplaceADOGridEdit.DoMouseWheel(Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint): Boolean;
begin
  Result := Grid.DoMouseWheel(Shift, WheelDelta, MousePos);
end;

function TDCInplaceADOGridEdit.GetEditType: TInplaceEditType;
begin
  Result := etADOGridEdit;
end;

function TDCInplaceADOGridEdit.GetGrid: TDCCustomTreeGrid;
begin
  Result := FGrid;
end;

procedure TDCInplaceADOGridEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  if Key > $20 then HideErrorMessage;
  if not DroppedDown then InplaceKeyDown(Self, Grid, Key, Shift);
  if Key <> 0 then
  begin
    if not ReadOnly then Grid.SetModified(True);
    inherited KeyDown(Key, Shift);
  end;
end;

procedure TDCInplaceADOGridEdit.KeyPress(var Key: Char);
begin
  if not(Key in [#27, #8]) and not ReadOnly then Grid.SetModified(True);
  Grid.KeyPress(Key);
  if Key <> #0 then inherited KeyPress(Key);
end;

procedure TDCInplaceADOGridEdit.KeyUp(var Key: Word; Shift: TShiftState);
begin
  if not DroppedDown then Grid.KeyUp(Key, Shift);
  if Key <> 0 then
    inherited KeyUp(Key, Shift);
end;

procedure TDCInplaceADOGridEdit.KillFocus(var Value: boolean);
begin
  with Grid do
  begin
    if (tgeKeepEditing in OptionsEx) and
      (not EditorMode or (FInplaceCol <> -1) or (FInplaceRow <> -1)) then
      Value := False
    else
      inherited KillFocus(Value);
  end;
end;

procedure TDCInplaceADOGridEdit.SetGrid(Value: TDCCustomTreeGrid);
begin
  FGrid := Value;
end;

procedure TDCInplaceADOGridEdit.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  inherited;
  if tgTabs in Grid.Options then
    Message.Result := Message.Result or DLGC_WANTTAB;
end;

procedure TDCInplaceADOGridEdit.WMKillFocus(var Message: TMessage);
begin
  inherited;
  if not Grid.IsActiveControl then with Grid do
  begin
    if not(tgeKeepEditing in OptionsEx) then
      if HideEditor then InvalidateSelected
    else
      InvalidateSelected;
  end;
end;

procedure TDCInplaceADOGridEdit.WMSetFocus(var Message: TWMSetFocus);
begin
  inherited;
  Grid.InvalidateSelected;
end;

{$ENDIF}

procedure TDCInplaceFloatEdit.WMKillFocus(var Message: TMessage);
begin
  inherited;
  if not Grid.IsActiveControl then with Grid do
  begin
    if not(tgeKeepEditing in OptionsEx) then
      if HideEditor then InvalidateSelected
    else
      InvalidateSelected;
  end;
end;

procedure TDCInplaceFloatEdit.WMSetFocus(var Message: TWMSetFocus);
begin
  inherited;
  Grid.InvalidateSelected;
end;

{ TKnotColumnFooterPanel }

function TKnotColumnFooterPanel.DefaultFont: TFont;
begin
  if Assigned(FColumn) then
    Result := FColumn.Font
  else
    Result := inherited DefaultFont;
end;

function TKnotColumnFooterPanel.GetColIndex: integer;
begin
  if Assigned(FColumn) then
    Result := FColumn.Index
  else
    Result := inherited GetColIndex;
  if Result >= 0 then
    Result := TDCCustomTreeGrid(Footer.Grid).DataToRawColumn(Result);
end;

procedure TKnotColumnFooterPanel.SetColIndex(const Value: integer);
begin
  inherited SetColIndex(TDCCustomTreeGrid(Footer.Grid).RawToDataColumn(Value));
end;

procedure TKnotColumnFooterPanel.SetColumn(const Value: TKnotColumn);
begin
  if FColumn <> Value then
  begin
    FColumn := Value;
    Changed(False);
  end;
end;

{ TKnotClipPopup }

procedure TKnotClipPopup.AddButtons;
 var
  iCount: integer;
begin
  BeginUpdate;
  Clear;
  case ColType of
    dcIndicator:
      begin
        PopupStyle := cpPopupMenu;
        AddButton('#Property', 'DC_DBPROPERTY', LoadStr(RES_STRN_VAL_PROP) , 0, 0);
        AddButton('#Find'    , 'DC_DBFIND'    , LoadStr(RES_STRN_VAL_FIND) , 0, 1);
        AddButton('#Print'   , 'DC_PRINT'     , LoadStr(RES_STRN_VAL_PRINT), 0, 2);
        if (Parent is TDCCustomGrid) and TDCCustomGrid(Parent).GroupingEnabled then
          AddButton('#GroupBox'   , 'DC_GROUPBOX', LoadStr(RES_STRN_VAL_GRPBOX), 0, 3)
      end;
    dcMarker:
      begin
        PopupStyle := cpPopupMenu;
        AddButton('#SelectAll', 'DC_PM_SELALL', LoadStr(RES_STRN_HNT_SELALL),
          0, pmSelectAll);
        AddButton('#DeselectAll', 'DC_PM_DESALL', LoadStr(RES_STRN_HNT_DESALL),
          0, pmDeselectAll);
        AddButton('#SepLine', '', MenuLineCaption, 0, -1);
        with AddButton('#BookmarsInfo', '', '', 0, pmDeselectAll) do
        begin
          Alignment := abRight;
          iCount := Grid.Knots.VisibleKnotCount;
          Caption := Format('%d/%d %s ', [Grid.SelectedRows.Count, iCount, 
            RecordCount2Str(iCount)]);
          Enabled := False;
          Images  := nil;
        end;
      end;
    dcColumn:
      begin
        PopupStyle := cpPopupMenu;
      end;
  end;
  EndUpdate;
end;

procedure TKnotClipPopup.ButtonClick(Sender: TObject);
begin
  inherited;
  if (Sender <> nil) and (Parent is TDCCustomGrid) then
    if TDCEditButton(Sender).Name = '#GroupBox' then
       TDCCustomGrid(Parent).Grouping := not TDCCustomGrid(Parent).Grouping;
end;

function TKnotClipPopup.GetGrid: TDCCustomTreeGrid;
begin
  Result := TDCCustomTreeGrid(Owner)
end;

procedure TKnotClipPopup.Hide;
begin
  with Grid do
  begin
    ClickedCol := -1;
    SetClipDown(False);
  end;
  ColType := dcNone;
  inherited;
end;

{ TTreePath }

procedure TTreePath.Assign(Source: TPersistent);
begin
  if Source is TTreePath then
  begin
    FColor := TTreePath(Source).Color;
    Include(FAssignedValues, tpColor);
  end
  else
    inherited Assign(Source);
end;

constructor TTreePath.Create(AGrid: TDCCustomTreeGrid);
begin
  inherited Create;
  FGrid := AGrid;
  FFont := TFont.Create;
  FFont.Assign(DefaultFont);
  FFont.OnChange := FontChanged;
  FOptions := [tpFixed, tpRowLines];
  FPosition := -1;
end;

function TTreePath.DefaultFont: TFont;
begin
  Result := FGrid.Font
end;

function TTreePath.DefaultColor: TColor;
begin
  Result := FGrid.FixedColor
end;

procedure TTreePath.FontChanged(Sender: TObject);
begin
  Include(FAssignedValues, tpFont);
  Update;
end;

function TTreePath.GetColor: TColor;
begin
  if tpColor in FAssignedValues then
    Result := FColor
  else
    Result := DefaultColor;
end;

function TTreePath.GetFont: TFont;
var
  Save: TNotifyEvent;
begin
  if not (tpFont in FAssignedValues) and (FFont.Handle <> DefaultFont.Handle) then
  begin
    Save := FFont.OnChange;
    FFont.OnChange := nil;
    FFont.Assign(DefaultFont);
    FFont.OnChange := Save;
  end;
  Result := FFont;
end;

function TTreePath.IsColorStored: Boolean;
begin
  Result := (tpColor in FAssignedValues) and (FColor <> DefaultColor);
end;

function TTreePath.IsFontStored: Boolean;
begin
  Result := (tpFont in FAssignedValues) and (Font <> DefaultFont);
end;

procedure TTreePath.SetColor(const Value: TColor);
begin
  if FColor <> Value then
  begin
    FColor := Value;
    Include(FAssignedValues, tpColor);
    Update;
  end;
end;

procedure TTreePath.SetFont(const Value: TFont);
begin
  FFont.Assign(Value);
  Include(FAssignedValues, tpFont);
  Update;
end;

procedure TTreePath.Update;
begin
  FGrid.Invalidate;
end;

procedure TTreePath.SetOptions(const Value: TTreePathOptions);
 const
  InvalidateOptions = [tpSolidLines, tpRowLines];
 var
  NewValue, ChangedOptions: TTreePathOptions;
begin
  NewValue := Value + [tpFixed];
  ChangedOptions := (FOptions + NewValue) - (FOptions * NewValue);
  if FOptions <> NewValue then
  begin
    FOptions := NewValue;
    if InvalidateOptions * ChangedOptions <> [] then Invalidate;
  end;
end;

procedure TTreePath.Invalidate;
begin
  with FGrid do
    InvalidateRow(GetCellByType(dcTreePath));
end;

destructor TTreePath.Destroy;
begin
  FreeAndNil(FFont);
  inherited;
end;

{ TTreeSelectedArea }

function TTreeSelectedArea.CellSelected(ACol: integer;
  KnotItem: TKnotItem): boolean;
 var
  i: integer;
begin
  i := 0;
  Result := False;
  while not Result and (i < Count) do
  begin
    Result := Items[i].CellSelected(ACol, KnotItem);
    Inc(i)
  end;
end;

function TTreeSelectedArea.GetGrid: TDCCustomTreeGrid;
begin
  Result := TDCCustomTreeGrid(inherited GetGrid);
end;

function TTreeSelectedArea.GetItem(Index: Integer): TTreeSelectedItem;
begin
  Result := TTreeSelectedItem(inherited GetItem(Index));
end;

procedure TTreeSelectedArea.SetItem(Index: Integer;
  const Value: TTreeSelectedItem);
begin
  inherited SetItem(Index, Value);
end;

{ TTreeSelectedItem }

function TTreeSelectedItem.CellSelected(ACol: integer;
  KnotItem: TKnotItem): boolean;

  function CheckXRange: boolean;
  begin
    Result := (ACol >= FStartCol) and (ACol <= (FStartCol + FColCount - 1));
  end;

  function CheckYRange: boolean;
   var
    i: integer;
  begin
    i := 0;
    Result := False;
    while not Result and (i < Count) do
    begin
      Result := KnotItem = Bookmarks[i];
      Inc(i)
    end;
  end;

begin
  Result := False;
  case Style of
    csSelectCols:
      Result := CheckXRange;
    scSelectRows:
      Result := CheckYRange;
    scSelectRect:
      Result := CheckXRange and CheckYRange;
  end;
end;

constructor TTreeSelectedItem.Create(Collection: TCollection;
  Cell: TGridCoord);
begin
  inherited;
  FKnotItems := TList.Create;
  with SelectedArea.Grid do
  begin
    FKnotItems.Add(GetKnotByCell(RawToDataRow(Cell.Y)));
    FStartCol := RawToDataColumn(Cell.X);
  end;  
  FColCount := 1;
  Style := scSelectRect;
end;

destructor TTreeSelectedItem.Destroy;
begin
  inherited;
  FKnotItems.Free;
end;

function TTreeSelectedItem.GetCount: integer;
begin
  Result := FKnotItems.Count;
end;

function TTreeSelectedItem.GetKnotItem(Index: Integer): TKnotItem;
begin
  Result := TKnotItem(FKnotItems.Items[Index]);
end;

function TTreeSelectedItem.GetSelectedArea: TTreeSelectedArea;
begin
  Result := TTreeSelectedArea(Collection)
end;

function TTreeSelectedItem.GetSelectRgn: HRGN;
 var
  KnotItem: TKnotItem;
  i, c, c1, Row1, Row2: integer;
  R: TRect;
begin
  with SelectedArea.Grid do
  begin
    KnotItem := FFirstVisible;
    i := TopRow;
    c := i + VisibleRowCount + 1;
    Row1 := -1;
    Row2 := -1;
    while (i < c) and (KnotItem <> nil) do
    begin
      if Row1 = -1 then
        if FKnotItems.IndexOf(KnotItem) <> -1 then
        begin
          Row1 := i;
          Row2 := i;
        end
        else
      else
        if FKnotItems.IndexOf(KnotItem) <> -1 then
          Row2 := i
        else
          Break;
      KnotItem := KnotItem.GetNextVisible;     
      Inc(i);    
    end;
    if (Row1 <> -1) and (Row2 <> -1) then
    begin
      c1 := FStartCol + FindicatorOffset;
      R := BoxRect(c1, Row1, c1 + FColCount -1, Row2);
      Result := CreateRectRgnIndirect(R)
    end
    else
      Result := CreateEmptyRgn;
  end;
end;

procedure TTreeSelectedItem.Select(IncX, incY: integer; var Cell: TGridCoord);
 var
  Rgn1, Rgn2: HRGN;

  function GetInc(var IncValue: integer): integer;
  begin
    if IncValue <> 0 then
    begin
      if IncValue > 0 then Result := 1 else Result := -1;
      Dec(IncValue, Result);
    end
    else
      Result := 0;
  end;

  procedure DoSelect(IncX, incY: integer);
   var
    KnotItem: TKnotItem;
    UpdateCell: boolean;
  begin
    with SelectedArea.Grid do
    begin
      UpdateCell := True;
      if IncX > 0 then
      begin
        if FStartCol < RawToDataColumn(Col) then
        begin
          Inc(FStartCol);
          Dec(FColCount);
          if FColCount = 0 then FColCount := 1;
        end
        else
          Inc(FColCount);
        if UpdateCell then Inc(Cell.X);
      end
      else if IncX < 0 then
      begin
        if (FStartCol = RawToDataColumn(Col)) and (FColCount > 1) then
          Dec(FColCount)
        else begin
          Inc(FColCount);
          Dec(FStartCol);
        end;
        if UpdateCell then Dec(Cell.X);
      end;

      UpdateCell := True;
      if IncY > 0 then
      begin
        if Count > 0 then
        begin
          if Bookmarks[0] = SelectedKnot then
          begin
            KnotItem := Bookmarks[Count-1].GetNextVisible;
            if KnotItem <> nil then
              FKnotItems.Add(KnotItem)
            else
              UpdateCell := False;
          end
          else
            FKnotItems.Delete(0);
        end
        else
          FKnotItems.Add(SelectedKnot);
        if UpdateCell then Inc(Cell.Y);
      end
      else if IncY < 0 then
      begin
        if Count > 0 then
        begin
          if Bookmarks[Count-1] = SelectedKnot then
          begin
            KnotItem := Bookmarks[0].GetPrevVisible;
            if KnotItem <> nil then
              FKnotItems.Insert(0, KnotItem)
            else
              UpdateCell := False;
          end
          else
            FKnotItems.Delete(Count-1);
        end
        else
          FKnotItems.Add(SelectedKnot);
        if UpdateCell then Dec(Cell.Y);
      end;
    end;
  end;
begin
  if SelectedArea.UpdateCount = 0 then
    Rgn1 := GetSelectRgn
  else
    Rgn1 := CreateEmptyRgn;

  while (IncX <> 0) or (IncY <> 0) do DoSelect(GetInc(IncX), GetInc(IncY));

  if SelectedArea.UpdateCount = 0 then
  begin
    Rgn2 := GetSelectRgn;
    CombineRgn(Rgn1, Rgn1, Rgn2, RGN_XOR);
    try
      InvalidateRgn(SelectedArea.Grid.Handle, Rgn1, False);
    finally
      DeleteObject(Rgn1);
      DeleteObject(Rgn2);
    end;
  end;
end;

end.
