{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x, 6.x
         Copyright (c) 1998-2001 Alex'EM

}
unit DCKnotColEdit;

interface
{$I DCConst.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ImgList, ComCtrls, ToolWin,
  {$IFDEF DELPHI_V6}
    DesignIntf, DesignEditors, DesignWindows,
  {$ELSE}
    Dsgnintf, DsgnWnds,
  {$ENDIF}
  ActnList, Menus, StdActns, DCGrids, DCChoice, DCKnots;

type
  TKCDesigner = class;

  TKnotColEditForm = class(TDesignWindow)
    ToolBar: TToolBar;
    tbNew: TToolButton;
    tbDelete: TToolButton;
    tbSeparator: TToolButton;
    imToolBar: TImageList;
    tbDefault: TToolButton;
    ColumnsActionList: TActionList;
    aNew: TAction;
    aDelete: TAction;
    aDefault: TAction;
    PopupMenu: TPopupMenu;
    aToolBar: TAction;
    AddField1: TMenuItem;
    Delete1: TMenuItem;
    aSelectAll: TAction;
    SelectAll1: TMenuItem;
    N1: TMenuItem;
    RestoreDefault1: TMenuItem;
    lvColumns: TListView;
    ToolBar1: TMenuItem;
    aDeleteAll: TAction;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure aNewExecute(Sender: TObject);
    procedure aDeleteExecute(Sender: TObject);
    procedure aDeleteAllExecute(Sender: TObject);
    procedure aToolBarExecute(Sender: TObject);
    procedure aDefaultExecute(Sender: TObject);
    procedure UpdateColumns;
    procedure lvColumnsChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure aSelectAllExecute(Sender: TObject);
    function CheckCollection: Boolean;
    procedure FormResize(Sender: TObject);
    procedure lvColumnsDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure lvColumnsDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure FormDestroy(Sender: TObject);
  protected
    function UniqueName(Component: TComponent): string; override;
    procedure Activated; override;
  private
    { Private declarations }
    FClosing: boolean;
    FDCTreeGrid: TDCCustomTreeGrid;
    FKCDesigner: TKCDesigner;
    procedure SetDCTreeGrid(const Value: TDCCustomTreeGrid);
  public
    destructor Destroy; override;
    property DCTreeGrid: TDCCustomTreeGrid read FDCTreeGrid  write SetDCTreeGrid;
    {$IFDEF DELPHI_V6}
      procedure ItemDeleted(const ADesigner: IDesigner; AItem: TPersistent); override;
      procedure DesignerClosed(const ADesigner: IDesigner; AGoingDormant: Boolean); override;
      procedure ItemsModified(const ADesigner: IDesigner); override;
    {$ELSE}
      procedure FormModified; override;
      procedure FormClosed(Form: TCustomForm); override;
      procedure ComponentDeleted(Component: IPersistent); override;
    {$ENDIF}
    property KCDesigner: TKCDesigner read FKCDesigner;
  end;

  TKCDesigner = class(TDataGridDesigner)
  private
    FKnotColEditor: TKnotColEditForm;
  public
    destructor Destroy; override;
    property KnotColEditor: TKnotColEditForm read FKnotColEditor;
  end;

  TKnotColProperty = class(TClassProperty)
  public
    procedure Edit; override;
    function GetValue: string; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  TKnotColEditor = class(TDefaultEditor)
  protected
   {$IFDEF DELPHI_V6}
      procedure EditProperty(const Prop: IProperty;
        var Continue: Boolean); override;
   {$ELSE}
      procedure EditProperty(PropertyEditor: TPropertyEditor;
        var Continue, FreeEditor: Boolean); override;
   {$ENDIF}
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;


implementation

{$R *.DFM}

const
 bmNew    = 'DBC_NEW';
 bmDelete = 'DBC_DELETE';
 bmAll    = 'DBC_ALL';
 bmDefault= 'DBC_DEFAULT';

 fmtKnotViewItem = '%2.2d - TColumn: %s';

procedure TKnotColProperty.Edit;
var
  ColumnsEditor: TKnotColEditForm;
  ADCTreeGrid: TDCCustomTreeGrid;
  I: integer;
begin
  ColumnsEditor := nil;
  ADCTreeGrid :=  TDCCustomTreeGrid(GetComponent(0));

  if ADCTreeGrid = nil then Exit;

  {  If ColumnsEditor fo ADCGridEdit not found create it
    esle SetFocus }

  {Attempt to Find it}
  for I := 0 to Screen.FormCount - 1 do begin
    if Screen.Forms[I] is TKnotColEditForm then
      if (TKnotColEditForm(Screen.Forms[I]).DCTreeGrid = ADCTreeGrid) and
         (TKnotColEditForm(Screen.Forms[I]).Name = ADCTreeGrid.Name+'_'+GetName)
      then begin
        { Great!. Find }
        ColumnsEditor := TKnotColEditForm(Screen.Forms[I]);
        Break;
      end;
  end;

  if ColumnsEditor = nil then
  begin
    ColumnsEditor := TKnotColEditForm.Create(Application);
    try
      {$IFDEF DELPHI_V6}
        ColumnsEditor.Designer := IDesigner(Designer);
      {$ELSE}
        ColumnsEditor.Designer := IFormDesigner(Designer);
      {$ENDIF}
      ColumnsEditor.DCTreeGrid := ADCTreeGrid;
      ColumnsEditor.Name := ADCTreeGrid.Name + '_' + GetName;
      with ColumnsEditor do
        Caption := 'Editing ' + DCTreeGrid.Name + '.' + GetName;
      ColumnsEditor.Show;
    except
      ColumnsEditor.Free;
      raise;
    end;
  end
  else begin
    ColumnsEditor.Show;
    if ColumnsEditor.WindowState = wsMinimized then
      ColumnsEditor.WindowState := wsNormal;
  end;
end;

function TKnotColProperty.GetValue: string;
begin
  Result := Format('(%s)', [GetPropType^.Name]);
end;

function TKnotColProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog] - [paSubProperties];
end;

function TKnotColEditForm.CheckCollection: Boolean;
begin
  Result := (DCTreeGrid <> nil) and (DCTreeGrid.Columns <> nil)
  {$IFDEF DELPHI_V6}
    and (Designer.Root <> nil);
  {$ELSE}
    and (Designer.Form <> nil);
  {$ENDIF}
end;

procedure TKnotColEditForm.SetDCTreeGrid(const Value: TDCCustomTreeGrid);
begin
  if FDCTreeGrid <> Value then
  begin
    FDCTreeGrid := Value;
    if FDCTreeGrid <> nil then
    begin
      UpdateColumns;
      FKCDesigner := TKCDesigner.Create(Value);
      FKCDesigner.FKnotColEditor := Self;
    end
    else
      Release;  
  end;
end;

procedure TKnotColEditForm.FormCreate(Sender: TObject);
 var
  Bmp: TBitmap;
begin
  {Initialize Images}
  inherited;

  Bmp := TBitmap.Create;

  imToolBar.Clear;

  Bmp.LoadFromResourceName(HInstance, bmNew);    // 0
  imToolBar.AddMasked(Bmp, clBtnFace);
  Bmp.LoadFromResourceName(HInstance, bmDelete); // 1
  imToolBar.AddMasked(Bmp, clBtnFace);
  Bmp.LoadFromResourceName(HInstance, bmAll);    // 2
  imToolBar.AddMasked(Bmp, clBtnFace);
  Bmp.LoadFromResourceName(HInstance, bmDefault);// 3
  imToolBar.AddMasked(Bmp, clBtnFace);

  aNew.ImageIndex     := 0;
  aDelete.ImageIndex  := 1;
  aDefault.ImageIndex := 3;

  Bmp.Free;
end;

procedure TKnotColEditForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TKnotColEditForm.aNewExecute(Sender: TObject);
 var
  Column: TKnotColumn;
begin
  {Add New Field}
  Column := DCTreeGrid.Columns.Add;
  Column.Font := DCTreeGrid.Font;
  UpdateColumns;
  Designer.Modified;
  lvColumns.Items[lvColumns.Items.Count-1].Selected := True;
  lvColumnsChange(nil,nil,ctState);
end;

procedure TKnotColEditForm.aDeleteAllExecute(Sender: TObject);
 var
  I:Integer;
  {$IFDEF DELPHI_V5UP}
    FComponents: IDesignerSelections;
  {$ELSE}
    FComponents: TComponentList;
  {$ENDIF}
begin
  {Delete All Fiedls}
  {$IFNDEF DELPHI_V5UP}
     FComponents := TComponentList.Create;
  {$ELSE}
     FComponents := CreateSelectionList;
  {$ENDIF}
  try
    DCTreeGrid.Columns.BeginUpdate;
    lvColumns.Items.BeginUpdate;

    for I := lvColumns.Items.Count - 1 downto 0 do
     if Assigned(lvColumns.Items[i].Data)
     then begin
       {$IFDEF DELPHI_V5}
         FComponents.Add(MakeIPersistent(TKnotColumn(lvColumns.Items[i].Data)));
       {$ELSE}
         FComponents.Add(TKnotColumn(lvColumns.Items[i].Data));
       {$ENDIF}
     end;
    lvColumns.Items.Clear;

    for I := 0 to FComponents.Count - 1 do
      {$IFDEF DELPHI_V5}
        ExtractPersistent(FComponents[i]).Free;
      {$ELSE}
         FComponents[i].Free;
      {$ENDIF}
  finally
    lvColumns.Items.EndUpdate;
    DCTreeGrid.Columns.EndUpdate;
    {$IFNDEF DELPHI_V5UP}
      FComponents.Free;
    {$ENDIF}
    Designer.Modified;
  end;
end;

procedure TKnotColEditForm.aDeleteExecute(Sender: TObject);
 var
  I, SelectedItem:Integer;
  {$IFDEF DELPHI_V5UP}
    FComponents: IDesignerSelections;
  {$ELSE}
    FComponents: TComponentList;
  {$ENDIF}
begin
  {Delete Selected Fiedls}
  SelectedItem := -1;
  if (lvColumns.SelCount > 0) then begin
    {$IFNDEF DELPHI_V5UP}
       FComponents := TComponentList.Create;
    {$ELSE}
       FComponents := CreateSelectionList;
    {$ENDIF}
    try
      DCTreeGrid.Columns.BeginUpdate;
      lvColumns.Items.BeginUpdate;
      SelectedItem := lvColumns.Items.IndexOf(lvColumns.Selected);

      for I := lvColumns.Items.Count - 1 downto 0 do
       if (lvColumns.Items[i].Selected = True) and
           Assigned(lvColumns.Items[i].Data)
       then begin
         {$IFDEF DELPHI_V5}
            FComponents.Add(MakeIPersistent(TKnotColumn(lvColumns.Items[i].Data)));
         {$ELSE}
            FComponents.Add(TKnotColumn(lvColumns.Items[i].Data));
         {$ENDIF}
       end;

      lvColumns.Items.Clear;

      for I := 0 to FComponents.Count - 1 do
        {$IFDEF DELPHI_V5}
           ExtractPersistent(FComponents[i]).Free;
        {$ELSE}
           FComponents[i].Free;
        {$ENDIF}
    finally
      lvColumns.Items.EndUpdate;
      DCTreeGrid.Columns.EndUpdate;
      {$IFNDEF DELPHI_V5UP}
        FComponents.Free;
      {$ENDIF}
      Designer.Modified;
      if (lvColumns.Items.Count > 0) then
        if (SelectedItem > lvColumns.Items.Count - 1) then
           lvColumns.Items[lvColumns.Items.Count-1].Selected := True
        else
           lvColumns.Items[SelectedItem].Selected := True;
        lvColumnsChange(nil,nil,ctState);
    end;
   end;
end;

procedure TKnotColEditForm.aToolBarExecute(Sender: TObject);
begin
  aToolBar.Checked := not aToolBar.Checked;
  ToolBar.Visible  := aToolBar.Checked
end;

procedure TKnotColEditForm.aDefaultExecute(Sender: TObject);
 var
  I:Integer;
  ListItem: TListItem;
begin
  {Restore Default}
  if (lvColumns.SelCount > 0) then begin
    ListItem := lvColumns.Selected;
    for i := 0 to lvColumns.SelCount - 1 do begin
      TKnotColumn(ListItem.Data).RestoreDefaults;
      ListItem := lvColumns.GetNextItem(ListItem,sdBelow,[isSelected]);
    end;
    lvColumnsChange(nil,nil,ctState);
    Designer.Modified;
  end;
end;

procedure TKnotColEditForm.UpdateColumns;
 var
  I: longint;
  UpdateColumns: boolean;
  ListItem: TListItem;
begin
  if not CheckCollection then
  begin
    lvColumns.Items.Clear;
    lvColumnsChange(nil,nil,ctState);
    Exit;
  end;

  lvColumns.StateImages := DCTreeGrid.Images;

  UpdateColumns := (lvColumns.Items.Count <> DCTreeGrid.Columns.Count );
  I := 0;
  while not(UpdateColumns) and (I <= DCTreeGrid.Columns.Count - 1) do
  begin
    UpdateColumns := (lvColumns.Items[I].Data <> DCTreeGrid.Columns[I]);
    Inc(I);
  end;

  if UpdateColumns then
  begin
    lvColumns.Items.BeginUpdate;
    lvColumns.Items.Clear;
      try
        for I := 0 to DCTreeGrid.Columns.Count - 1 do
        begin
          ListItem := lvColumns.Items.Add;
          ListItem.Caption := Format(fmtKnotViewItem,[I,DCTreeGrid.Columns[i].DisplayName]);
          ListItem.Data := DCTreeGrid.Columns[i];
          ListItem.StateIndex := DCTreeGrid.Columns[i].ItemIndex;
        end;
      finally
        lvColumns.Items.EndUpdate;
      end;
  end else
    for I := 0 to DCTreeGrid.Columns.Count - 1 do
    begin
        lvColumns.Items[i].Caption    := Format(fmtKnotViewItem,[I,DCTreeGrid.Columns[i].DisplayName]);
        lvColumns.Items[i].StateIndex := DCTreeGrid.Columns[i].ItemIndex;
    end;
  lvColumnsChange(nil,nil,ctState);
end;


procedure TKnotColEditForm.lvColumnsChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
 var
  {$IFDEF DELPHI_V5UP}
    {$IFDEF DELPHI_V6}
       ComponentList: IDesignerSelections;
    {$ELSE}
       ComponentList: TDesignerSelectionList;
    {$ENDIF}
  {$ELSE}
    ComponentList: TComponentList;
  {$ENDIF}
  I: Integer;
begin
  if (csDestroying in ComponentState) then Exit;

  {Check Caption Staus}
  aDelete.Enabled    := lvColumns.SelCount > 0;
  aDefault.Enabled   := (lvColumns.SelCount > 0);
  aSelectAll.Enabled := (lvColumns.Items.Count > 0);

  if CheckCollection and Active then
  begin
    {$IFNDEF DELPHI_V5UP}
      ComponentList := TComponentList.Create;
    {$ELSE}
      {$IFDEF DELPHI_V6}
         ComponentList := CreateSelectionList;
      {$ELSE}
         ComponentList := TDesignerSelectionList.Create;
      {$ENDIF}
    {$ENDIF}
    if (lvColumns.SelCount > 0) then
    begin
      with lvColumns do
      begin
        for i := Items.Count - 1 downto 0 do
          if (Items[i].Selected = True) and Assigned(Items[i].Data) then
            ComponentList.Add(TKnotColumn(Items[i].Data));
      end;
    end
    else
      ComponentList.Add(DCTreeGrid.Columns);
    SetSelection(ComponentList);
  end;

end;

procedure TKnotColEditForm.Activated;
begin
  if (csDestroying in ComponentState) then Exit;
  lvColumnsChange(nil,nil,ctState);
end;

function TKnotColEditForm.UniqueName(Component: TComponent): string;
var
  Temp: string;
begin
  if (Component <> nil) then
    Temp := Component.ClassName
  else
    Temp := TKnotColumn.ClassName;
  if (UpCase(Temp[1]) = 'T') and (Length(Temp) > 1) then System.Delete(Temp, 1, 1);
  Result := Designer.UniqueName(Temp);
end;

{$IFDEF DELPHI_V6}

  procedure TKnotColEditForm.DesignerClosed(const ADesigner: IDesigner;
    AGoingDormant: Boolean);
  begin
    if Designer = ADesigner then
    begin
      FClosing := True;
      Close;
    end;
  end;

  procedure TKnotColEditForm.ItemDeleted(const ADesigner: IDesigner;
    AItem: TPersistent);
  begin
    if (AItem = nil) or FClosing then Exit;
    if AItem = DCTreeGrid then
    begin
      FDCTreeGrid := nil;
      Close;
    end;
  end;

  procedure TKnotColEditForm.ItemsModified(const ADesigner: IDesigner);
  begin
    if FClosing then exit;
    if not (csDestroying in ComponentState) then UpdateColumns;
  end;

{$ELSE}

  procedure TKnotColEditForm.FormModified;
  begin
    if FClosing then exit;
    if not (csDestroying in ComponentState) then UpdateColumns;
  end;

  procedure TKnotColEditForm.FormClosed(Form: TCustomForm);
  begin
    if (Form = Designer.Form) then
    begin
      aDeleteAllExecute(Self);
      Close;
    end;
    inherited;
  end;

  procedure TKnotColEditForm.ComponentDeleted(Component: IPersistent);
  begin
    if (Component = nil) or FClosing then Exit;
    if ExtractPersistent(Component) = DCTreeGrid then
    begin
      FDCTreeGrid := nil;
      Close;
    end;
  end;

{$ENDIF}

procedure TKnotColEditForm.aSelectAllExecute(Sender: TObject);
 var
  I: integer;
begin
  for I := 0 to lvColumns.Items.Count - 1 do
      lvColumns.Items[i].Selected := True;
end;

procedure TKnotColEditForm.FormResize(Sender: TObject);
begin
  if (csDestroying in ComponentState) then Exit;
  lvColumns.Columns[0].Width := lvColumns.ClientWidth;
end;

procedure TKnotColEditForm.lvColumnsDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := True;
end;

procedure TKnotColEditForm.lvColumnsDragDrop(Sender, Source: TObject; X,
  Y: Integer);
 var
  Column, ColumnTarget: TKnotColumn;
  i, j, k: integer;
begin
  { Move Column                           }
  { lvColumns.Selected   - Dragged Column }
  { lvColumns.DropTarget                  }

  if not Assigned(Sender) or not Assigned(Source) or
     not Assigned(lvColumns.DropTarget) or
     not Assigned(lvColumns.Selected) or
    (lvColumns.Selected.Index =  lvColumns.DropTarget.Index) then Exit;

  Column := TKnotColumn.Create(nil);
  j := lvColumns.Selected.Index;
  k := lvColumns.DropTarget.Index;

  ColumnTarget:= DCTreeGrid.Columns[k];
  Column.Assign(DCTreeGrid.Columns[j]);
   try
    if j > k then
    begin
      for i := j - 1 downto k do
        DCTreeGrid.Columns[i+1].Assign(DCTreeGrid.Columns[i]);
    end
    else begin
      for i := j + 1 to k do
        DCTreeGrid.Columns[i-1].Assign(DCTreeGrid.Columns[i]);
    end;
    ColumnTarget.Assign(Column);
  finally
    Column.Free;
  end;
  UpdateColumns;
  Designer.Modified;
  lvColumnsChange(nil,nil,ctState);
end;

destructor TKnotColEditForm.Destroy;
begin
  inherited;
end;

{ TKnotColEditor }

{$IFDEF DELPHI_V6}
  procedure TKnotColEditor.EditProperty(const Prop: IProperty;
    var Continue: Boolean);
   var
    PropName: string;
  begin
    PropName := Prop.GetName;
    if (CompareText(PropName, 'COLUMNS') = 0) then
    begin
      Prop.Edit;
      Continue := False;
    end;
  end;
{$ELSE}
  procedure TKnotColEditor.EditProperty(PropertyEditor: TPropertyEditor;
    var Continue, FreeEditor: Boolean);
  var
    PropName: string;
  begin
    PropName := PropertyEditor.GetName;
    if (CompareText(PropName, 'COLUMNS') = 0) then
    begin
      PropertyEditor.Edit;
      Continue := False;
    end;
  end;
{$ENDIF}

procedure TKnotColEditor.ExecuteVerb(Index: Integer);
begin
  if Index = 0 then Edit;
end;

function TKnotColEditor.GetVerb(Index: Integer): string;
begin
  if Index = 0 then
    Result := 'Co&lumns Editor ...'
  else Result := '';
end;

function TKnotColEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

procedure TKnotColEditForm.FormDestroy(Sender: TObject);
begin
  if FKCDesigner <> nil then
  begin
    { Destroy the designer if the editor is destroyed }
    FKCDesigner.FKnotColEditor := nil;
    FKCDesigner.Free;
  end;
end;

{ TKCDesigner }

destructor TKCDesigner.Destroy;
begin
  if FKnotColEditor <> nil then
  begin
    FKnotColEditor.FKCDesigner := nil;
    FKnotColEditor.Release;
  end;
  inherited;
end;

end.
