{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x - 6.x
         Copyright (c) 1998-2001 Alex'EM

}
unit DCFileCtrl;

interface

uses
  Windows, Classes, SysUtils, Controls, Forms, ShellAPI, ShlObj, CommCtrl,
  ComCtrls, ActiveX, ComObj, Graphics, DCConst, DCChoice, DCPopupWindow, Messages;

const
  BIF_USENEWUI  = $0040;
  PathSeparator = '\';

type
  PFolderItem_tag = ^TFolderItem;
  TFolderItem = record
     SPIDL: PItemIDList;
     FPIDL: PItemIDList;
     DisplayName: string;
     DisplayPath: string;
     Attrs: ULONG;
  end;

  TBrowseOption = (boNetwork);
  TBrowseOptions = set of TBrowseOption;

  TDCBrowseFolder = class(TDCCustomTreeEdit)
  private
    FIDesktopFolder: IShellFolder;
    FImages: TImageList;
    FBitmap: TBitmap;
    FIShellFolder: IShellFolder;
    FOptions: TBrowseOptions;
    FDriversPIDL: PItemIdList;
    FNetworkPIDL: PItemIdList;
    procedure LoadIDList(Node: TTreeNode);
    function GetTreeView: TTreeView;
    procedure DoCreate(Sender: TObject);
    procedure DoCancel(Sender: TObject);
    procedure DrawButton(Sender: TCustomTreeView; ARect: TRect; Node: TTreeNode);
    procedure DrawImage(Sender: TCustomTreeView;  NodeRect: TRect; ImageIndex: Integer;
      Attrs: ULONG);
    function ClearNode(Node: TTreeNode; FreeNodeData: boolean): TTreeNode;
    procedure SetOptions(const Value: TBrowseOptions);
  protected
    procedure DefineBtnChoiceStyle; override;
    procedure SetText(Value: string); override;
    procedure SetParent(AParent: TWinControl); override;
    procedure Expanding(Sender: TObject; Node: TTreeNode; var AllowExpansion: Boolean); override;
    procedure GetHintOnError; override;
    procedure DoShowError(AErrorWindow: TDCErrorMessageWindow); override;
    procedure CMSetSelection(var Message: TMessage); message CM_SETSELECTION;
    procedure CustomDrawItem(Sender: TCustomTreeView; Node: TTreeNode;
       State: TCustomDrawState; var DefaultDraw: Boolean);  override;
    procedure ClearTreeItems; override;
    function ComparePIDLs(PIDL1, PIDL2: PItemIdList): boolean;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function GetNode(Value: string; var Node: TTreeNode; var ErrorCode: integer): boolean; override;
    function GetPathPIDL(Value: string; var ItemIDList: PItemIDList): boolean;
    function GetPath(ItemIDList: PItemIdList): string;
    function SelectFolder(Name: string): boolean;
    procedure InitTree; override;
    property TreeView: TTreeView read GetTreeView;
    property Images;
  published
    property DrawStyle;
    property Options: TBrowseOptions read FOptions write SetOptions default [boNetwork];
  end;

function CreateDirectoryEx(FilePath: string; SecurityAttributes: PSECURITYATTRIBUTES = nil): boolean;
function SelectDirectoryEx(const Caption: string; const Root: WideString;
  var Directory: string): Boolean;
procedure FreePIDL(PIDL: PItemIDList);

implementation

uses
  DCEditTools, DCEditButton;

var
 AIShellFolder: IShellFolder;

{ TDCDirectoryEdit }
function NextPIDL(IDList: PItemIDList): PItemIDList;
begin
  Result := IDList;
  Inc(PChar(Result), IDList^.mkid.cb);
end;

function GetPIDLSize(IDList: PItemIDList): Integer;
begin
  Result := 0;
  if Assigned(IDList) then
  begin
    Result := SizeOf(IDList^.mkid.cb);
    while IDList^.mkid.cb <> 0 do
    begin
      Result := Result + IDList^.mkid.cb;
      IDList := NextPIDL(IDList);
    end;
  end;
end;

function CreatePIDL(Size: Integer): PItemIDList;
var
  Malloc: IMalloc;
  HR: HResult;
begin
  Result := nil;

  HR := SHGetMalloc(Malloc);
  if Failed(HR) then Exit;

  try
    Result := Malloc.Alloc(Size);
    if Assigned(Result) then
      FillChar(Result^, Size, 0);
  finally
  end;
end;

procedure FreePIDL(PIDL: PItemIDList);
var
  Malloc: IMalloc;
  HR: HResult;
begin
  HR := SHGetMalloc(Malloc);
  if Failed(HR) then Exit;
  try
    Malloc.Free(PIDL);
  finally
  end;
end;

function ConcatPIDL(IDList1, IDList2: PItemIDList): PItemIDList;
var
  cb1, cb2: Integer;
begin
  if Assigned(IDList1) then
    cb1 := GetPIDLSize(IDList1) - SizeOf(IDList1^.mkid.cb)
  else
    cb1 := 0;

  cb2 := GetPIDLSize(IDList2);

  Result := CreatePIDL(cb1 + cb2);
  if Assigned(Result) then
  begin
    if Assigned(IDList1) then
      CopyMemory(Result, IDList1, cb1);
    CopyMemory(PChar(Result) + cb1, IDList2, cb2);
  end;
end;

function DirectoryExists(const Name: string): Boolean;
 var
  AIDesktopFolder: IShellFolder;
  pWideValue: PWideChar;
  Eaten, Flags: LongWord;
  ItemIDList: PItemIDList;
begin
  OLECheck(SHGetDesktopFolder(AIDesktopFolder));
  if Name <> '' then
  begin
    GetMem(pWideValue, MAX_PATH);
    try
      MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, PChar(Name), -1, pWideValue, MAX_PATH);
      Result := (AIDesktopFolder.ParseDisplayName(Application.Handle, nil, pWideValue,
        Eaten, ItemIDList, Flags) = NOERROR);
      if Result then
      begin
        Flags := $FFFFFFFF;
        AIDesktopFolder.GetAttributesOf(1, ItemIDList, Flags);
        Result := (Flags and SFGAO_FOLDER) = SFGAO_FOLDER;
        FreePIDL(ItemIDList);
      end;
    finally
      FreeMem(pWideValue, MAX_PATH);
    end;
  end
  else
    Result := False;
end;

function CreateDirectoryEx(FilePath: string; SecurityAttributes: PSECURITYATTRIBUTES = nil): boolean;
begin
  if Length(FilePath) = 0 then
  begin
    Result := False;
    Exit;
  end;

  if (AnsiLastChar(FilePath) <> nil) and (AnsiLastChar(FilePath)^ = '\') then
    Delete(FilePath, Length(FilePath), 1);

  if (Length(FilePath) < 3) or DirectoryExists(FilePath) or
     (ExtractFilePath(FilePath) = FilePath) then
  begin
    Result := True;
    Exit;
  end;

  Result := CreateDirectoryEx(ExtractFilePath(FilePath), SecurityAttributes);
  if Result and not CreateDirectory(PChar(FilePath), SecurityAttributes) then
    Result:= False;
end;

function GetDisplayName(ShellFolder: IShellFolder; PIDL: PItemIDList;
  lType: integer = SHGDN_NORMAL): string;
 var
  StrRet: TStrRet;
  P: PChar;
begin
  Result := '';
  ShellFolder.GetDisplayNameOf(PIDL, lType, StrRet);
  case StrRet.uType of
    STRRET_CSTR:
      SetString(Result, StrRet.cStr, lStrLen(StrRet.cStr));
    STRRET_OFFSET:
      begin
        P := @PIDL.mkid.abID[StrRet.uOffset - SizeOf(PIDL.mkid.cb)];
        Result := P;
        //SetString(Result, P, PIDL.mkid.cb - StrRet.uOffset);
      end;
    STRRET_WSTR:
      SetString(Result, StrRet.pOleStr, lStrLenW(StrRet.pOleStr));
  end;
end;

function GetImageIndex(PIDL: PItemIDList): integer;
 var
  FileInfo: TShFileInfo;
begin
  SHGetFileInfo(PChar(PIDL), 0, FileInfo, SizeOf(TSHFileInfo),
    SHGFI_PIDL or SHGFI_SYSICONINDEX or SHGFI_SMALLICON);
  Result := FileInfo.iIcon;
end;

function GetSelectedIndex(PIDL: PItemIDList): integer;
 var
  FileInfo: TShFileInfo;
begin
  SHGetFileInfo(PChar(PIDL), 0, FileInfo, SizeOf(TSHFileInfo),
    SHGFI_PIDL or SHGFI_SYSICONINDEX or SHGFI_SMALLICON or SHGFI_OPENICON);
  Result := FileInfo.iIcon;
end;

function CustomSortProc(Node1, Node2: TTreeNode; Data: Longint): integer; stdcall;
begin
  Result := SmallInt(AIShellFolder.CompareIDs(
                  0,
                  PFolderItem_tag(Node1.Data).SPIDL,
                  PFolderItem_tag(Node2.Data).SPIDL));
end;

procedure TDCBrowseFolder.ClearTreeItems;
 var
  Node: TTreeNode;
begin
  with TreeView do
  begin
    if Items.Count > 0 then
    begin
      Node := Items.GetFirstNode;
      while Node <> nil do Node := ClearNode(Node, True);
    end;
  end;
  inherited;
end;

procedure TDCBrowseFolder.CMSetSelection(var Message: TMessage);

  function ParentLevel(PIDList, SIDList: PItemIDList): integer;
   var
    Path: string;
    ID: PItemIdList;
    Found: boolean;
    nLength: integer;
  begin
    Result := 0;
    if ComparePIDLs(PIDList, SIDList) then Exit;

    if (FIDesktopFolder.CompareIDs(0, PIDList, FDriversPIDL) = 0) or
       (FIDesktopFolder.CompareIDs(0, PIDList, FNetworkPIDL) = 0) then
    begin
      Result := MaxInt;
      Exit;
    end;

    Path   := GetPath(SIDList);
    Found  := False;
    while (Path <> '') and not Found do
    begin
      Inc(Result);
      Path := ExtractFilePath(Path);
      if GetPathPIDL(Path, ID) then
      begin
        if ComparePIDLs(PIDList, ID) then
          Found := True
        else begin
          Path := GetPath(ID);
          nLength := Length(Path);
          if (nLength > 0) and (Path[nLength] = PathSeparator) then
            Path := Copy(Path, 1, nLength-1);
        end;
        FreePIDL(ID);
      end
      else
        Break;
    end;
    if not Found then Result := -1;
  end;

  function LocatePIDL(SIDList: PItemIDList; PNode: TTreeNode; CheckParent: boolean): boolean;
   var
    Node: TTreeNode;
    FolderItem: PFolderItem_tag;
    nLevel: integer;
  begin
    Result := False;
    if PNode = nil then Exit;
    if PNode.HasChildren and (PNode.GetFirstChild = nil) then
    begin
      LoadIDList(PNode);
    end;
    Node := PNode.GetFirstChild;
    while (Node <> nil) do
    begin
      FolderItem := Node.Data;
      if ComparePIDLs(FolderItem.FPIDL, SIDList) then
      begin
        TreeView.Selected := Node;
        Result := True;
        Break;
      end
      else
        if CheckParent then
        begin
          nLevel := ParentLevel(FolderItem.FPIDL, SIDList);
          if nLevel > -1 then
          begin
            if Node.HasChildren and (Node.GetFirstChild = nil) then LoadIDList(Node);
            Result := LocatePIDL(SIDList, Node, nLevel > 1);
            Exit;
          end;
        end;
      Node := Node.GetNextSibling;
    end;
    if not(Result or CheckParent) then
    begin
      {     }
      LoadIDList(PNode);
      Result := LocatePIDL(SIDList, PNode, False);
    end;
  end;

begin
  if not TreeInitialized then InitTree;
  LocatePIDL(PItemIDList(Message.LParam), TreeView.Items.GetFirstNode, True);
end;

constructor TDCBrowseFolder.Create(AOwner: TComponent);
begin
  inherited;
  Style := teDropDown;
  OLECheck(SHGetDesktopFolder(FIDesktopFolder));
  if FIShellFolder = nil then FIShellFolder := FIDesktopFolder;
  FImages := TImageList.Create(nil);
  TreeView.ShowRoot := False;
  DBObject.Caption := LoadStr(RES_BFLD_DBOCAPTION);
  FBitmap := TBitmap.Create;
  FOptions := [boNetwork];
end;

procedure TDCBrowseFolder.CustomDrawItem(Sender: TCustomTreeView; Node: TTreeNode;
       State: TCustomDrawState; var DefaultDraw: Boolean);
 var
  PFolderItem: PFolderItem_tag;
  NodeRect: TRect;
begin
  inherited;
  if DefaultDraw then begin
    DefaultDraw := False;
    PFolderItem := Node.Data;
    with PFolderItem^,  Sender.Canvas do
    begin
      Brush.Color := TreeView.Color;

      Font.Assign(TreeView.Font);
      if Attrs and SFGAO_COMPRESSED <> 0 then
      begin
        Font.Color := clBlue;
      end;
      if cdsSelected in State then Font.Color := clCaptionText;

      if cdsSelected in State then
        Brush.Color := clHighlight
      else
        Brush.Color := TreeView.Color;
      NodeRect := Node.DisplayRect(True);

      if Node.Level = 0 then
        OffsetRect(NodeRect, 6, 0)
      else
        OffsetRect(NodeRect, 4, 0);
      FillRect(NodeRect);

      InflateRect(NodeRect, -2, -1);
      TextOut(NodeRect.Left, NodeRect.Top, Node.Text);
      InflateRect(NodeRect, 2, 1);

      if cdsFocused in State then DrawFocusRect(NodeRect);

      NodeRect := Node.DisplayRect(False);

      if Node.Level > 0 then
      begin
        NodeRect.Left := NodeRect.Left + ((Node.Level -1) * TreeView.Indent + 5);
        DrawButton(Sender, NodeRect, Node);
        NodeRect.Left := NodeRect.Left + TreeView.Indent;
      end
      else
        NodeRect.Left := NodeRect.Left + 7;

      if cdsSelected in State then
        DrawImage(Sender, NodeRect, Node.SelectedIndex, Attrs)
      else
        DrawImage(Sender, NodeRect, Node.ImageIndex, Attrs);
    end;
  end;
end;

procedure TDCBrowseFolder.DefineBtnChoiceStyle;
begin
  if BtnChoiceAssigned then
  begin
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNCOMBO');
    ButtonStyle := esDropDown;
    ButtonChoiceStyle := btsCustom;
  end;
end;

destructor TDCBrowseFolder.Destroy;
begin
  FImages.Handle := 0;
  FImages.Free;
  FBitmap.Free;
  inherited;
end;

procedure TDCBrowseFolder.DoCancel(Sender: TObject);
begin
  HideErrorMessage;
end;

procedure TDCBrowseFolder.DoCreate(Sender: TObject);
begin
  if not CreateDirectoryEx(PChar(Text), nil) then
  begin
    HideErrorMessage;
    ErrorCode := ERR_BFLD_NOTFOLDER;
    ShowErrorMessage;
  end
  else begin
    HideErrorMessage;
    SelectFolder(Text);
  end;
end;

procedure TDCBrowseFolder.DoShowError(AErrorWindow: TDCErrorMessageWindow);
 var
  AButton: TDCEditButton;
begin
  if ErrorCode = ERR_TREE_ILLIGALVALUE then
  begin
    with AErrorWindow do
    begin
      AddButton('#Create', '', LoadStr(RES_STRN_VAL_CREATE), DoCreate);
      AButton := AddButton('#Cancel', '', LoadStr(RES_STRN_VAL_CANCEL), DoCancel);
      FocusedButton := AButton;
    end;
  end;
  inherited;
end;

procedure TDCBrowseFolder.DrawButton(Sender: TCustomTreeView; ARect: TRect; Node: TTreeNode);
 var
  ButtonSize, cx, cy, wx, hy: Integer;

  procedure DrawDotedLine(Canvas: TCanvas; AColor: TColor; ABegin: TPoint;
    ALength, Direction: integer);
   var
    i: integer;
  begin
    case Direction of
      0:
        for i := 0 to ALength do
          if i mod 2 = 0 then
            Canvas.Pixels[ABegin.X + i, ABegin.Y] := AColor;
      1:
        for i := 0 to ALength do
          if i mod 2 = 0 then
            Canvas.Pixels[ABegin.X, ABegin.Y + i] := AColor;
    end;
  end;
begin
  ButtonSize := 5;

  wx := ARect.Left + TreeView.Indent + ButtonSize;
  hy := ARect.Bottom;
  cx := ARect.Left + TreeView.Indent div 2;
  cy := ARect.Top + (ARect.Bottom - ARect.Top) div 2;

  with Sender.Canvas do
  begin
    Pen.Style := psSolid;

    if Node.HasChildren then
      DrawDotedLine(Sender.Canvas, clAppWorkSpace, Point(cx + 5, cy), wx - (cx + 5), 0)
    else
      DrawDotedLine(Sender.Canvas, clAppWorkSpace, Point(cx, cy), wx - cx, 0);

    DrawDotedLine(Sender.Canvas, clAppWorkSpace, Point(cx, ARect.Top), hy - cy - ButtonSize, 1);

    if Node.GetNextSibling <> nil then
      DrawDotedLine(Sender.Canvas, clAppWorkSpace, Point(cx, cy + ButtonSize-1), hy - cy - ButtonSize, 1);

    if Node.HasChildren then
    begin
      Pen.Color := clAppWorkSpace;

      MoveTo(cx-ButtonSize+1, cy-ButtonSize+1);

      LineTo(cx-ButtonSize+1, cy+ButtonSize-1);
      LineTo(cx+ButtonSize-1, cy+ButtonSize-1);
      LineTo(cx+ButtonSize-1, cy-ButtonSize+1);
      LineTo(cx-ButtonSize+1, cy-ButtonSize+1);

      Pen.Color := clBlack;
      PenPos := Point(cx-ButtonSize+3, cy);
      LineTo(cx+ButtonSize-2, cy);
      if not Node.Expanded then
      begin
        PenPos := Point(cx, cy-ButtonSize+3);
        LineTo(cx, cy+ButtonSize-2);
      end
      else begin
        Pen.Color := TreeView.Color;
        PenPos := Point(cx, cy-ButtonSize+3);
        LineTo(cx, cy);
        PenPos := Point(cx, cy + 1);
        LineTo(cx, cy+ButtonSize-2);
      end;
    end
    else begin
      if Node.GetNextSibling <> nil then
        DrawDotedLine(Sender.Canvas, clAppWorkSpace, Point(cx, cy-ButtonSize+1), ButtonSize+2, 1)
      else
        DrawDotedLine(Sender.Canvas, clAppWorkSpace, Point(cx, cy-ButtonSize+1), (ButtonSize+2) div 2, 1);
    end;

    Node := Node.Parent;
    while Node <> nil do
    begin
      cx := cx - TreeView.Indent;
      if Node.GetNextSibling <> nil then
        DrawDotedLine(Sender.Canvas, clAppWorkSpace, Point(cx, ARect.Top), hy - ARect.Top, 1);
      Node := Node.Parent;
    end;

  end;
end;

procedure TDCBrowseFolder.DrawImage(Sender: TCustomTreeView; NodeRect: TRect;
  ImageIndex: Integer; Attrs: ULONG);
var
  cy: Integer;
begin
  cy := NodeRect.Top + (NodeRect.Bottom - NodeRect.Top) div 2;

  FBitmap.Width  := Images.Width;
  FBitmap.Height := Images.Height;

  try
    if Attrs and SFGAO_SHARE <> 0 then
      Images.DrawOverlay(FBitmap.Canvas, 0, 0, ImageIndex, 0)
    else
      Images.Draw(FBitmap.Canvas, 0, 0, ImageIndex, True);

    if Attrs and SFGAO_HIDDEN <> 0 then
      AlphaBlend(FBitmap, nil, FBitmap, 170,
        FBitmap.Canvas.Pixels[0, 0], FBitmap.Canvas.Pixels[0, 0]);

    Sender.Canvas.Draw(NodeRect.Left, cy - Images.Height div 2, FBitmap);
  finally
    {}
  end;
end;

procedure TDCBrowseFolder.Expanding(Sender: TObject; Node: TTreeNode;
  var AllowExpansion: Boolean);
begin
  with TreeView do
  begin
    Items.BeginUpdate;
    try
      if Node.HasChildren and (Node.GetFirstChild = nil) then
      begin
        Node.HasChildren := False;
        LoadIDList(Node);
      end;
    finally
      Items.EndUpdate;
    end;
  end;
  inherited;
end;

function TDCBrowseFolder.ClearNode(Node: TTreeNode; FreeNodeData: boolean): TTreeNode;
 var
  FolderItem: PFolderItem_tag;
  ChildNode: TTreeNode;
begin
  if Node <> nil then
  begin
    {   Child}
    if Node.HasChildren then
    begin
      ChildNode := Node.GetFirstChild;
      while ChildNode <> nil do ChildNode := ClearNode(ChildNode, True);
    end;
    {   }
    Result := Node.GetNextSibling;
    if FreeNodeData then
    begin
      FolderItem := Node.Data;
      FreePIDL(FolderItem.SPIDL);
      FreePIDL(FolderItem.FPIDL);
      FreeMem(FolderItem);
      Node.Data := nil;
      Node.Destroy;
    end;
  end
  else
    Result := nil;
end;

procedure TDCBrowseFolder.GetHintOnError;
begin
  case ErrorCode of
    ERR_TREE_ILLIGALVALUE:
      begin
        ErrorHint := Format(LoadStr(RES_FOLD_ERR_WRONG), [Text]);
        Exit;
      end;
    ERR_BFLD_NOTFOLDER:
      begin
        ErrorHint := Format(LoadStr(RES_FOLD_ERR_NOTFLD), [Text]);
        Exit;
      end;
  else
    ErrorHint := '';
  end;
  inherited;
end;

function TDCBrowseFolder.GetNode(Value: string;
  var Node: TTreeNode; var ErrorCode: integer): boolean;
 var
  Flags: LongWord;
  ItemIDList: PItemIDList;
begin
  Node   := nil;
  Result := True;

  if Value <> '' then
  begin
    Result := GetPathPIDL(Value, ItemIDList);
    if Result then
    begin
      Flags := $FFFFFFFF;
      FIDesktopFolder.GetAttributesOf(1, ItemIDList, Flags);
      Result := (Flags and SFGAO_FOLDER) = SFGAO_FOLDER;
      if not Result then ErrorCode := ERR_BFLD_NOTFOLDER;
      FreePIDL(ItemIDList);
    end;
  end;
end;

function TDCBrowseFolder.GetTreeView: TTreeView;
begin
  Result := inherited GetTreeView;
end;

procedure TDCBrowseFolder.InitTree;
 var
  RootPIDL: PItemIDList;
  DesktopNode, FolderNode, NetworkNode: TTreenode;
  PFolderItem: PFolderItem_tag;
  Attrs: ULONG;
begin
  with TreeView do
  begin
    Items.BeginUpdate;

    {Desktop}
    OLECheck(SHGetSpecialFolderLocation(Application.Handle, CSIDL_DESKTOP, RootPIDL));
    PFolderItem := New(PFolderItem_tag);
    PFolderItem.SPIDL := RootPIDL;
    PFolderItem.FPIDL := ConcatPIDL(nil, RootPIDL);
    PFolderItem.DisplayName := GetDisplayName(FIShellFolder, RootPIDL);
    PFolderItem.DisplayPath := '';
    FIShellFolder.GetAttributesOf(1, RootPIDL, Attrs);
    PFolderItem.Attrs := Attrs;

    DesktopNode := Items.AddFirst(nil, PFolderItem.DisplayName);
    DesktopNode.ImageIndex    := GetImageIndex(RootPIDL);
    DesktopNode.SelectedIndex := DesktopNode.ImageIndex;
    DesktopNode.Data := PFolderItem;

    {Drivers}
    OLECheck(SHGetSpecialFolderLocation(Application.Handle, CSIDL_DRIVES, FDriversPIDL));
    PFolderItem := New(PFolderItem_tag);
    PFolderItem.SPIDL := FDriversPIDL;
    PFolderItem.FPIDL := ConcatPIDL(nil, FDriversPIDL);
    PFolderItem.DisplayName := GetDisplayName(FIShellFolder, FDriversPIDL);
    PFolderItem.DisplayPath := '';
    FIShellFolder.GetAttributesOf(1, FDriversPIDL, Attrs);
    PFolderItem.Attrs := Attrs;

    FolderNode := Items.AddChild(DesktopNode, PFolderItem.DisplayName);
    FolderNode.ImageIndex    := GetImageIndex(FDriversPIDL);
    FolderNode.SelectedIndex := FolderNode.ImageIndex;
    FolderNode.HasChildren   := True;
    FolderNode.Data := PFolderItem;

    {Network}
    if boNetwork in Options then
    begin
      OLECheck(SHGetSpecialFolderLocation(Application.Handle, CSIDL_NETWORK, FNetworkPIDL));
      PFolderItem := New(PFolderItem_tag);
      PFolderItem.SPIDL := FNetworkPIDL;
      PFolderItem.FPIDL := ConcatPIDL(nil, FNetworkPIDL);
      PFolderItem.DisplayName := GetDisplayName(FIShellFolder, FNetworkPIDL);
      PFolderItem.DisplayPath := '';
      FIShellFolder.GetAttributesOf(1, FNetworkPIDL, Attrs);
      PFolderItem.Attrs := Attrs;

      NetworkNode := Items.AddChild(DesktopNode, PFolderItem.DisplayName);
      NetworkNode.ImageIndex    := GetImageIndex(FNetworkPIDL);
      NetworkNode.SelectedIndex := NetworkNode.ImageIndex;
      NetworkNode.Data := PFolderItem;
      NetworkNode.HasChildren   := True;
    end;

    DesktopNode.Expand(False);
    FolderNode.Expand(False);

    TreeView.Selected := FolderNode;
    TreeView.TopItem  := DesktopNode;
    Items.EndUpdate;
  end;
  inherited;
end;

procedure TDCBrowseFolder.LoadIDList(Node: TTreeNode);
 var
  SaveCursor: TCursor;
  EnumList: IEnumIDList;
  PIDL: PItemIDList;
  PFolderItem: PFolderItem_tag;
  NumIDCount: DWORD;
  ChildNode: TTreeNode;
  Attrs: Ulong;
begin
  TreeView.Items.BeginUpdate;
  SaveCursor := Screen.Cursor;
  try
    if Node.HasChildren then ClearNode(Node, False);
    Screen.Cursor := crHourglass;

    PIDL := PFolderItem_tag(Node.Data).FPIDL;

    if FIDesktopFolder.BindToObject(PIDL, nil, IID_IShellFolder, Pointer(FIShellFolder)) <> S_OK then
    begin
      Screen.Cursor := SaveCursor;
      Exit;
    end;
    try
      OLECheck(FIShellFolder.EnumObjects(Application.Handle,
        SHCONTF_FOLDERS + SHCONTF_INCLUDEHIDDEN, EnumList));
    except
      Exit;
    end;
    with TreeView do
    begin
      while EnumList.Next(1, PIDL, NumIDCount) = S_OK do
      begin
        Attrs := $FFFFFFFF;
        FIShellFolder.GetAttributesOf(1, PIDL, Attrs);
        if Attrs and SFGAO_HASPROPSHEET <> 0 then
        begin
          PFolderItem := New(PFolderItem_tag);
          PFolderItem.SPIDL := PIDL;
          PFolderItem.FPIDL := ConcatPIDL(PFolderItem_tag(Node.Data).FPIDL, PIDL);
          PFolderItem.DisplayName := GetDisplayName(FIShellFolder, PIDL);
          PFolderItem.DisplayPath := GetDisplayName(FIShellFolder, PIDL, SHGDN_FORPARSING);
          PFolderItem.Attrs       := Attrs;

          ChildNode := Items.AddChild(Node, PFolderItem.DisplayName);
          ChildNode.Data := PFolderItem;
          ChildNode.ImageIndex := GetImageIndex(PFolderItem.FPIDL);
          ChildNode.SelectedIndex := GetSelectedIndex(PFolderItem.FPIDL);
          ChildNode.HasChildren := Attrs and SFGAO_HASSUBFOLDER <> 0;
        end;
      end;
    end;
  finally
    AIShellFolder := FIShellFolder;
    Node.CustomSort(@CustomSortProc, 0);
    Screen.Cursor := SaveCursor;
    TreeView.Items.EndUpdate;
  end;
end;

function TDCBrowseFolder.SelectFolder(Name: string): boolean;
 var
  Flags: LongWord;
  ItemIDList: PItemIDList;
begin
  {sorry. Not supported yet}
  Result := GetPathPIDL(Name, ItemIDList);
  if Result then
  begin
    Flags := $FFFFFFFF;
    FIDesktopFolder.GetAttributesOf(1, ItemIDList, Flags);
    Result := (Flags and SFGAO_FOLDER) = SFGAO_FOLDER;
    if Result then SendMessage(Handle, CM_SETSELECTION, 0, LPARAM(ItemIDList));
    FreePIDL(ItemIDList);
  end;
end;

procedure TDCBrowseFolder.SetParent(AParent: TWinControl);
 var
  FileInfo: TShFileInfo;
begin
  inherited;
  if AParent <> nil then
  begin
    FImages.Handle := SHGetFileInfo('C:\', 0, FileInfo, SizeOf(FileInfo),
      SHGFI_SYSICONINDEX or SHGFI_SMALLICON);

    FImages.ShareImages := True;
    FImages.BlendColor := clHighLight;

    Images := FImages;
  end;
end;

procedure TDCBrowseFolder.SetText(Value: string);
begin
  if TreeView.Selected <> nil then
    Value := PFolderItem_tag(TreeView.Selected.Data).DisplayPath;
  inherited SetText(Value);
end;

procedure BFFMInitialized(Wnd: HWnd; lData: LPARAM);
 var
  Rect: TRect;
  IDesktopFolder: IShellFolder;
  Eaten, Flags: LongWord;
  SelectionPIDL: PItemIDList;
begin
  GetWindowRect(Wnd, Rect);
  SetWindowPos(Wnd, 0,
    (GetSystemMetrics(SM_CXSCREEN) - Rect.Right + Rect.Left) div 2,
    (GetSystemMetrics(SM_CYSCREEN) - Rect.Bottom + Rect.Top) div 2,
    0, 0, SWP_NOACTIVATE or SWP_NOSIZE or SWP_NOZORDER);

  if POleStr(lData) <> '' then
  begin
    SHGetDesktopFolder(IDesktopFolder);
    if IDesktopFolder.ParseDisplayName(Wnd, nil, POleStr(lData), Eaten,
      SelectionPIDL, Flags) = NO_ERROR then
    begin
      SendMessage(Wnd, BFFM_SETSELECTION, 0, LPARAM(SelectionPIDL));
      FreePIDL(SelectionPIDL);
    end;
  end;
end;

function BrowseCallback(Wnd: HWnd; Msg: UINT; lParam: LPARAM; lData: LPARAM): integer; stdcall;
begin
  Result := 0;
  case Msg of
    BFFM_INITIALIZED: BFFMInitialized(Wnd, lData);
  end;
end;

function SelectDirectoryEx(const Caption: string; const Root: WideString;
  var Directory: string): Boolean;
var
  WindowList: Pointer;
  BrowseInfo: TBrowseInfo;
  Buffer: PChar;
  IDesktopFolder: IShellFolder;
  Eaten, Flags: LongWord;
  RootItemIDList, ItemIDList: PItemIDList;
  ShellMalloc: IMalloc;
  pBrowseDirectory: PWideChar;
begin
  Result := False;
  FillChar(BrowseInfo, SizeOf(BrowseInfo), 0);
  if (ShGetMalloc(ShellMalloc) = S_OK) and (ShellMalloc <> nil) then
  begin
    Buffer := ShellMalloc.Alloc(MAX_PATH);
    try
      RootItemIDList := nil;
      if Root <> '' then
      begin
        SHGetDesktopFolder(IDesktopFolder);
        IDesktopFolder.ParseDisplayName(Application.Handle, nil,
          POleStr(Root), Eaten, RootItemIDList, Flags);
      end;
      GetMem(pBrowseDirectory, MAX_PATH);
      MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, PChar(Directory), -1, pBrowseDirectory, MAX_PATH);
      with BrowseInfo do
      begin
        hwndOwner := Application.Handle;
        pidlRoot := RootItemIDList;
        pszDisplayName := Buffer;
        lpszTitle := PChar(Caption);
        ulFlags := BIF_RETURNONLYFSDIRS or BIF_EDITBOX or BIF_USENEWUI;
        lpfn := BrowseCallback;
        lParam := Integer(pBrowseDirectory);
      end;
      WindowList := DisableTaskWindows(0);
      try
        OleCheck(CoInitialize(nil));
        ItemIDList := ShBrowseForFolder(BrowseInfo);
      finally
        EnableTaskWindows(WindowList);
      end;
      Result :=  ItemIDList <> nil;
      if Result then
      begin
        ShGetPathFromIDList(ItemIDList, Buffer);
        ShellMalloc.Free(ItemIDList);
        Directory := Buffer;
      end;
      FreePIDL(RootItemIDList);
      FreeMem(pBrowseDirectory, MAX_PATH);
    finally
      ShellMalloc.Free(Buffer);
    end;
  end;
end;

procedure TDCBrowseFolder.SetOptions(const Value: TBrowseOptions);
 var
  ChangedOptions: TBrowseOptions;
begin
  if FOptions <> Value then
  begin
    ChangedOptions := (FOptions + Value) - (FOptions * Value);
    FOptions := Value;
    if (boNetwork in ChangedOptions) and TreeInitialized then
    begin
      ClearTreeItems;
      InitTree;
    end;
  end;
end;

function TDCBrowseFolder.GetPathPIDL(Value: string; var ItemIDList: PItemIDList): boolean;
 var
  pWideValue: PWideChar;
  Eaten, Flags: LongWord;
begin
  if Value <> '' then
  begin
    GetMem(pWideValue, MAX_PATH);
    try
      MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, PChar(Value), -1, pWideValue, MAX_PATH);
      Result := FIDesktopFolder.ParseDisplayName(Application.Handle, nil, pWideValue,
        Eaten, ItemIDList, Flags) = NOERROR;
    finally
      FreeMem(pWideValue, MAX_PATH);
    end;
  end
  else
   Result := False;
end;

function TDCBrowseFolder.GetPath(ItemIDList: PItemIdList): string;
 var
  pValue: PChar;
begin
  GetMem(pValue, MAX_PATH);
  try
    if SHGetPathFromIdList(ItemIDList, pValue) then
      SetString(Result, pValue, StrLen(pValue))
    else
      Result := '';
  finally
    FreeMem(pValue, MAX_PATH);
  end;
end;

function TDCBrowseFolder.ComparePIDLs(PIDL1, PIDL2: PItemIdList): boolean;
 var
  L: integer;
begin
  L := GetPIDLSize(PIDL1);
  if L = GetPIDLSize(PIDL2) then
    Result := CompareMem(PIDL1, PIDL2, L)
  else
    Result := False;
end;

end.
