{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x - 6.x
         Copyright (c) 1998-2001 Alex'EM

}
unit DCEditTools;

interface
{$I DCConst.inc}

uses Windows, Controls, Forms, SysUtils, CommCtrl, Messages, Graphics, ImgList,
     Classes, DCConst, DCCpuInfo;

type
  TBasicShape = (shCheck, shUp, shDown, shLeft, shRight, shArrowUp,
    shArrowDown, shArrowLeft, shArrowRight, shPlus, shMinus);
  TObjectSize = (szNormal, szSmall, szLarge);

  TChars = set of Char;

  TDCDBObject = class(TPersistent)
  private
    FNode: string;
    FCode: string;
    FCaption: string;
  published
    property Node: string read FNode write FNode;
    property Code: string read FCode write FCode;
    property Caption: string read FCaption write FCaption;
  end;

  PIntegerValues = ^TIntegerValues;
  TIntegerValues = packed array[0..0] of Integer;

  TPolyLineStruct = record
    Index: DWORD;
    Capacity: DWORD;
    Color: TColor;
    Points: PIntegerValues;
    Strokes: PIntegerValues;
  end;

  // 32 bit
  PColorValue = ^TColorValue;
  TColorValue = packed record
    case integer of
     0: (Value: DWORD);
     1: (B, G, R, Z: Byte);
  end;

  TScanArray = array[0..PolySize_x03] of TColorValue;
  PScanArray_tag = ^TScanArray;

  TDIBBitmap = packed record
    DC: HDC;
    Bitmap: HBITMAP;
    InfoSize: DWORD;
    BitsSize: DWORD;
    BitmapInfo: PBitmapInfo;
    Bits: PScanArray_tag;
  end;

  TDateFormatParts = (dpDay, dpMonth, dpYear);
  TDateFormatItem = packed record
    Pos, Count: byte;
  end;
  TSimpleDateFormat = packed array[TDateFormatParts] of TDateFormatItem;
  TDateInfo = packed record
    BalanceCount, SectionCount: byte;
    Sections: array[1..6] of WORD;
  end;

function _intMin(A, B: integer): integer;
function _intMax(A, B: integer): integer;
procedure _intSwap(var A, B: integer);
function _getFlag(const Flag: DWORD; const Index: Integer): boolean;
procedure _setFlag(var Flag: DWORD; const Index: Integer; const Value: boolean);
procedure _xorFlag(var Flag: DWORD; const Index: Integer);

function _iif(Value: boolean; A, B: integer): integer;

procedure _extSwap(var A, B: extended);

function _chkFlag(const Flag: DWORD; const Index: Integer;
  const Value: boolean): boolean;
procedure _FillDWord(var Dest; Count, Value: Integer);


procedure StrPCat(var Dest: string; Source: PChar; Len: integer);

function IsExistDragging: boolean;

{$IFNDEF DELPHI_V5UP}
function IsLeapYear(Year: Integer): Boolean;
{$ENDIF}
function DaysPerMonth(Y, M: Integer): Integer;

procedure DecodeDateFormat(var Format: TSimpleDateFormat);
function GetDateTimeInfo(pDate: PChar; var SimpleFormat: TSimpleDateFormat;
  var DateInfo: TDateInfo): boolean;

function DateToStrY2K(Date: TDateTime; var Stroke: string;
  Kind: TDateEditKind = dkDate): boolean; overload;
function DateToStrY2K(Date: string; var Stroke: string;
  Kind: TDateEditKind = dkDate): boolean; overload;

function GetNumericFormat(Value: PChar; var Precision: integer;
  var Digits: integer): TNumericFormat;

function IsValidInteger(Value: string): boolean;
function IsValidFloat(Value: string): boolean;
function IsValidCurrency(Value: string; APrecision: integer): boolean;

function CheckInteger(var Value: string; ADigits: integer): boolean;
function CheckFloat(var Value: string; APrecision, ADigits: integer): boolean;
function CheckCurrency(var Value: string; APrecision, ADigits: integer): boolean;

function GetCharWidth(Handle: HWND; Font: TFont): integer;
function GetCharHeight(Handle: HWND; Font: TFont;
  DrawContext: HDC = 0): integer;

procedure DrawFocusedRect(DC: HDC; pOldRect, pNewRect: PRect; BorderSize: integer);
function SetRectInDesktop( var Pos: TPoint; AWidth, AHeight: Integer;
  Offset: TPoint): integer;

function GetDCTextWidth(Font: TFont; Value: string;
  ACanvas: TCanvas = nil): Longint;
function GetDCTextHeight(Font: TFont; Value: string;
  ACanvas: TCanvas = nil): Longint;
function GetTextWidth(DC: HDC; Value: string): integer;
function GetTextHeight(DC: HDC; Value: string): integer;

function GetTransparentColor(RGB: integer): integer;

procedure TransformBitmap(Source, Dest: TBitmap; Style: TTransformStyle;
  AColor: TColor = $FFFFFF);
procedure AlphaBlend(BkgImage, SrcImage: TBitmap; DstImage: TBitmap;
  Opacity: integer; AColor, BColor: TColor);

function GetBitmapRegion(Bitmap: TBitmap; XForm: PXFORM; Color: integer): HRGN;
function PtInRegionData(RgnData: PRGNDATA; X, Y: integer): boolean;
function IsRegionEmpty(Rgn: HRGN): boolean;

procedure DrawShadow(Source, Dest: TBitmap; AColor, BColor: TColor;
  Size, Opacity: integer; Offset: TPoint; ExcludeSource: boolean = False); overload;
procedure DrawShadow(Dest: TBitmap; const Rgn: HRGN; AColor, BColor: TColor;
  Size, Opacity: integer; Offset: TPoint; ExcludeSource: boolean = False); overload;

procedure DrawBitmap(ACanvas: TCanvas; ABitmap: TBitmap; ARect: TRect;
  AStretch: boolean; ATransparent: boolean = True);
procedure DrawTransparentBitmap(DC: HDC; Bitmap: TBitmap; R: TRect;
  StretchBitmap: boolean; AColor: TColor = $FFFFFF);
procedure DrawStyledBitmap(Canvas: TCanvas; ARect: TRect; X, Y: integer;
 Bitmap: TBitmap; Style: TTransformStyle);

procedure DrawBasicShape(DC: HDC; AObject: TBasicShape; X, Y: integer;
 Color: TColor; Size: TObjectSize = szNormal);

function DrawHighLightText(Canvas: TCanvas; Text: PChar; ARect: TRect;
  Mode: byte; DrawFlag: DWORD = DT_END_ELLIPSIS;
  ImageList: TCustomImageList = nil): TPoint;

procedure DrawGridFrameBorder(Canvas: TCanvas; ARect: TRect;
  AStyle: TEdgeBorderStyle; AState: TDrawBorerState; FixedColor: TColor);

function RecordCount2Str(Count: integer): string;

function CreateEmptyRgn: HRGN;
procedure IncludeRectRgn(R: TRect; var Rgn: HRGN);
procedure ProcessPaintMessages;

function ETGetSystemImages(Mode: integer): TImageList;
procedure ETGetBitmap(Mode, Index: integer; ABitmap: TBitmap);

function IsRectEquals(R1, R2: TRect): boolean;

procedure CreatePolyLineStruct(var Struct: TPolyLineStruct; MaxCount: integer;
  AColor: TColor);
procedure ClearPolyLineStruct(var Struct: TPolyLineStruct; AColor: TColor);
procedure DestroyPolyLineStruct(var Struct: TPolyLineStruct);
procedure AddPoint2Struct(var Struct: TPolyLineStruct; X1, Y1, X2, Y2: integer);
procedure PaintPolyLine(DC: HDC; Struct: TPolyLineStruct;
  DrawMode: integer = R2_COPYPEN);

{$IFNDEF DELPHI_V5UP}
procedure FreeAndNil(var AObject);
function BytesPerScanline(PixelsPerScanline, BitsPerPixel, Alignment: Longint): Longint;
{$ENDIF}

{DIB functions}
procedure InitDIBBitmapHeader(Bitmap: HBITMAP; var BI: TBitmapInfoHeader;
  Colors: Integer);
procedure InitDIBBitmap(ADC: HDC; ABitmap: HBitmap; var DIBBitmap: TDIBBitmap);
procedure GetDIBBitmap(var DIBBitmap: TDIBBitmap);
procedure FreeDIBBitmap(DIBBitmap: TDIBBitmap);

function ColorToBGR(Color: integer): integer;

{DIBBitmap function}
procedure BITMAP_AlphaBlendB(var ADIBBitmap, BDIBBitmap: TDIBBitmap;
  Opacity: integer; Color: integer);
procedure BITMAP_AlphaBlendC(var ADIBBitmap: TDIBBitmap; AColor: TColor;
 Opacity: integer; Color: integer);

function BITMAP_GetRegion(DIBBitmap: TDIBBitmap; XForm: PXFORM;
  Color: integer): HRGN;

implementation

{$R DCSystem.RES}

const
  MaxBasicPointCount = 12;
  MaxRgnDataRects = $7D0;
  RgnDataSize = SizeOf(TRgnDataHeader) + SizeOf(TRect) * MaxRgnDataRects;

type
  TBasicShapePoints = array[0..MaxBasicPointCount] of TPoint;
  PRectArray = ^TRectArray;
  TRectArray = array[0..MaxRgnDataRects - 1] of TRect;

  TGetBlendAttr = function (A, B: TColorValue): DWORD;
  TGetAvergAttr = function (A, B0, B1, B2, B3, B5, B6, B7,
    B8: TColorValue): DWORD;

var
 SystemSmallImages: TImageList;       // Size: 15x15
 ABitmap: TBitmap;

var
 GetBlendAttr: TGetBlendAttr;
 GetAvergAttr: TGetAvergAttr;

function _intMin(A, B: integer): integer;
{
   -> eax   A
   -> edx   B
   <- eax   A if A < B
            A if A = B
            B if A < B
}
asm
  cmp  eax, edx  //    
  jg   @@1       //  eax > edx   @@1
  jmp  @@2       //  
@@1:
  mov  eax, edx  //     Result
@@2:
end;

function _intMax(A, B: integer): integer;
{
   -> eax   A
   -> edx   B
   <- eax   A if A > B
            B if A = B
            B if A < B
}
asm
  cmp  eax, edx  //    
  jg   @@2       //  eax > edx   @@2
  jmp  @@1       //  
@@1:
  mov  eax, edx  //     Result
@@2:
end;

procedure _intSwap(var A, B: integer);
asm
  mov  ebx, [eax]
  mov  ecx, [edx]
  mov  [eax], ecx
  mov  [edx], ebx
end;

function _getFlag(const Flag: dword; const Index: Integer): boolean; assembler;
asm
  bt   eax, edx
  sbb  eax, eax
  and  eax, 1
end;

procedure _setFlag(var Flag: dword; const Index: Integer;
  const Value: boolean); assembler;
asm
  push esi
  mov  esi, [eax]
  or   Value, Value
  jz   @@1
  bts  esi, edx
  jmp  @@2
@@1:
  btr  esi, edx
@@2:
  mov  [eax], esi
  pop  esi
end;

function _chkFlag(const Flag: DWORD; const Index: Integer;
 const Value: boolean): boolean; assembler;
asm
  push ebx
  xor  ebx, ebx
  mov  bl, Value
  bt   eax, edx
  sbb  eax, eax
  and  eax, ebx
  pop  ebx
end;

procedure _xorFlag(var Flag: dword; const Index: Integer); assembler
asm
  push esi
  push ebx
  mov  ebx, eax
  mov  esi, [eax]
  bt   esi, edx
  sbb  eax, eax
  jz   @@1
  btr  esi, edx
  jmp  @@2
@@1:
  bts  esi, edx
@@2:
  mov  [ebx], esi
  pop  ebx
  pop  esi
end;

function _iif(Value: boolean; A, B: integer): integer; assembler;
{
   -> eax   Value;
   -> edx   A
   -> ecx   B
   <- if Value then Result := A else Result := B
}
asm
  xor  al, True
  jnz  @@1
  mov  eax, edx
  jmp  @@2
@@1:
  mov  eax, ecx
@@2:
end;

procedure _extSwap(var A, B: extended); assembler;
asm
  fld  qword ptr [eax]
  fld  qword ptr [eax + 8]
  fld  qword ptr [edx]
  fld  qword ptr [edx + 8]

  fstp qword ptr [eax + 8]
  fstp qword ptr [eax]
  fstp qword ptr [edx + 8]
  fstp qword ptr [edx]

  fwait
end;

procedure _FillDWord(var Dest; Count, Value: Integer);
asm
  xchg  edx, ecx
  push  edi
  mov   edi, eax
  mov   eax, edx
  rep   stosd
  pop   edi
end;

{
  note
  ebx - Opacity

  using
  asm
    push ebx
    mov  ebx, Opacity
  end;
  xxx_GetBlendAttr ()
  asm
    pop  ebx
  end
  ....
  asm
    emms
  end
}
function mmx_GetBlendAttr(A, B: TColorValue): DWORD; assembler;
  // eax - Color A
  // edx - Color B
  // Result := (A * (255 - Opacity) + B*Opacity) div 255;
asm
  db $0F, $EF, $DB                   //   pxor mm3, mm3
  db $0F, $EF, $E4                   //   pxor mm4, mm4

  db $0F, $6E, $C8                   //   movd mm1, eax
  db $0F, $6E, $D2                   //   movd mm2, edx

  mov  edx, $00FF
  sub  edx, ebx

  push ebx
  mov  ebx, edx
  shl  edx, $08
  add  edx, ebx
  shl  edx, $08
  add  edx, ebx
  pop ebx

  db $0F, $6E, $C2                   //   movd      mm0, edx
  db $0F, $ED, $D8                   //   paddsw    mm3, mm0

  mov  edx, ebx
  shl  edx, $08
  add  edx, ebx
  shl  edx, $08
  add  edx, ebx

  db $0F, $6E, $C2                   //   movd      mm0, edx
  db $0F, $ED, $E0                   //   paddsw    mm4, mm0
  db $0F, $EF, $C0                   //   pxor      mm0, mm0
  db $0F, $60, $C8                   //   punpcklbw mm1, mm0
  db $0F, $60, $D0                   //   punpcklbw mm2, mm0
  db $0F, $60, $D8                   //   punpcklbw mm3, mm0
  db $0F, $60, $E0                   //   punpcklbw mm4, mm0
  db $0F, $D5, $CB                   //   pmullw    mm1, mm3
  db $0F, $D5, $D4                   //   pmullw    mm2, mm4
  db $0F, $ED, $CA                   //   paddw     mm1, mm2
  db $0F, $71, $D1, $08              //   psrlw     mm1, $08
  db $0F, $67, $C8                   //   packuswb  mm1, mm0

  db $0F, $7E, $C8                   //   movd eax, mm1
end;

function nox_GetBlendAttr(A, B: TColorValue): DWORD;
 var
  rv, gv, bv: WORD;

  function Blend(A, B: DWORD): DWORD;
  //  begin
  //    Result := (A * (255 - Opacity) + B*Opacity) div 255;
  //  end;
  asm
    and  eax, $00FF;
    and  edx, $00FF;
    push edx

    mov  edx, $000FF
    sub  edx, ebx
    imul edx

    pop  edx
    imul edx, ebx
    add  eax, edx
    shr  eax, $08
    // 
    {
    cdq
    idiv ecx
    }
  end;
begin
  rv := Blend(A.R, B.R);
  gv := Blend(A.G, B.G);
  bv := Blend(A.B, B.B);
  Result := RGB(rv, gv, bv);
end;

function mmx_GetAvergAttr(A, B0, B1, B2, B3, B5, B6, B7,
  B8: TColorValue): DWORD; assembler;
asm
   db $0F, $EF, $C0                  //   pxor      mm0, mm0
   db $0F, $EF, $D2                  //   pxor      mm2, mm2
   db $0F, $6E, $CA                  //   movd      mm1, B0
   db $0F, $60, $C8                  //   punpcklbw mm1, mm0
   db $0F, $FD, $D1                  //   paddw     mm2, mm1
   db $0F, $6E, $C9                  //   movd      mm1, B1
   db $0F, $60, $C8                  //   punpcklbw mm1, mm0
   db $0F, $FD, $D1                  //   paddw     mm2, mm1
   db $0F, $6E, $4D, $1C             //   movd      mm1, B2
   db $0F, $60, $C8                  //   punpcklbw mm1, mm0
   db $0F, $FD, $D1                  //   paddw     mm2, mm1
   db $0F, $6E, $4D, $18             //   movd      mm1, B3
   db $0F, $60, $C8                  //   punpcklbw mm1, mm0
   db $0F, $FD, $D1                  //   paddw     mm2, mm1
   db $0F, $6E, $4D, $14             //   movd      mm1, B5
   db $0F, $60, $C8                  //   punpcklbw mm1, mm0
   db $0F, $FD, $D1                  //   paddw     mm2, mm1
   db $0F, $6E, $4D, $10             //   movd      mm1, B6
   db $0F, $60, $C8                  //   punpcklbw mm1, mm0
   db $0F, $FD, $D1                  //   paddw     mm2, mm1
   db $0F, $6E, $4D, $0C             //   movd      mm1, B7
   db $0F, $60, $C8                  //   punpcklbw mm1, mm0
   db $0F, $FD, $D1                  //   paddw     mm2, mm1
   db $0F, $6E, $4D, $08             //   movd      mm1, B8
   db $0F, $60, $C8                  //   punpcklbw mm1, mm0
   db $0F, $FD, $D1                  //   paddw     mm2, mm1

   db $0F, $71, $D2, $03             //   psrlw     mm2, $03
   db $0F, $67, $D0                  //   packuswb  mm2, mm0

   db $0F, $7E, $D0                  //   movd eax, mm2
end;

function nox_GetAvergAttr(A, B0, B1, B2, B3, B5, B6, B7,
  B8: TColorValue): DWORD;
 var
  rv, gv, bv: WORD;
begin
  rv := (B0.R + B1.R + B2.R + B3.R + B5.R + B6.R + B7.R + B8.R) div 8;
  gv := (B0.G + B1.G + B2.G + B3.G + B5.G + B6.G + B7.G + B8.G) div 8;
  bv := (B0.B + B1.B + B2.B + B3.B + B5.B + B6.B + B7.B + B8.B) div 8;
  Result := RGB(rv, gv, bv);
end;

procedure StrPCat(var Dest: string; Source: PChar; Len: integer);
 var
  i, Size: Integer;
  pValue: PChar;
begin
  if Len <> 0 then
  begin
    i := Length(Dest);
    Size := (i + Len + 1)*SizeOf(Char);
    pValue := AllocMem(Size);
    try
      if i > 0 then Move(Pointer(Dest)^, pValue^, i);
      Move(Source^, pValue[i], Len);
      Dest := pValue;
    finally
      FreeMem(pValue, Size);
    end;
  end;
end;

function IsExistDragging: boolean;
 var
  i: integer;
  Control: TControl;

 function IsDragging(AControl: TControl): boolean;
  var
   i: integer;
   Control: TControl;
 begin
   Result := False;
   if (csAcceptsControls in AControl.ControlStyle) then
     for i := 0 to AControl.ComponentCount-1 do
     begin
        Control := TControl(AControl.Components[i]);
        if Control.Dragging then
          Result := True
        else
          Result := IsDragging(Control);

        if Result then Exit;
     end;
 end;
begin
  Result := False;
  for i := 0 to Application.ComponentCount-1 do
  begin
     Control := TControl(Application.Components[i]);
      if Control.Dragging then
        Result := True
      else
        Result := IsDragging(Control);

      if Result then Exit;
  end;
end;

procedure ProcessPaintMessages;
 var
  Msg: TMsg;
begin
  SleepEx(20, True);
  while PeekMessage(Msg, 0, WM_PAINT, WM_PAINT, PM_NOREMOVE) do begin
    case Integer(GetMessage(Msg, 0, WM_PAINT, WM_PAINT)) of
      -1: Break;
      0 :
        begin
          PostQuitMessage(Msg.WParam);
          Break;
        end;
    end;
    DispatchMessage(Msg);
  end;
end;

{$IFNDEF DELPHI_V5UP}
procedure FreeAndNil(var AObject);
 var
  Temp: TObject;
begin
  Temp := TObject(AObject);
  Pointer(AObject) := nil;
  Temp.Free;
end;

function BytesPerScanline(PixelsPerScanline, BitsPerPixel, Alignment: Longint): Longint;
begin
  Dec(Alignment);
  Result := ((PixelsPerScanline * BitsPerPixel) + Alignment) and not Alignment;
  Result := Result div 8;
end;
{$ENDIF}


{$IFNDEF DELPHI_V5UP}
function IsLeapYear(Year: Integer): Boolean;
begin
  Result := (Year mod 4 = 0) and ((Year mod 100 <> 0) or (Year mod 400 = 0));
end;
{$ENDIF}

function DaysPerMonth(Y, M: Integer): Integer;
{$IFNDEF DELPHI_V5UP}
   const
    MonthDays: array[1..12] of Integer =
     (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
  begin
    Result := MonthDays[M];
    if (M = 2) and IsLeapYear(Y) then Inc(Result);
{$ELSE}
  begin
    Result := MonthDays[IsLeapYear(Y), M];
{$ENDIF}
end;

procedure DecodeDateFormat(var Format: TSimpleDateFormat);
 const
  DateFormatChars: array[TDateFormatParts] of TChars =
     (['d', 'D'], ['m', 'M'], ['y', 'Y']);
 var
  CurPos: byte;
  pValue: PChar;
  DatePart: TDateFormatParts;

  function IsCharDatePart(c: Char; var DatePart: TDateFormatParts): boolean;
   var
    i: TDateFormatParts;
  begin
    Result := False;
    for i := Low(TDateFormatParts) to High(TDateFormatParts) do
    begin
      if c in DateFormatChars[i] then
      begin
        Result := True;
        DatePart := i;
        Break;
      end;
    end;
  end;

  function GetPartCount(DatePart: TDateFormatParts): byte;
   var
    pStart: PChar;
  begin
    pStart := pValue;
    while (pValue^ <> #0) and (pValue^ in DateFormatChars[DatePart]) do
      Inc(pValue);
    Result := _intMax(2, pValue - pStart);
  end;

begin
  pValue := PChar(ShortDateFormat);
  CurPos := 1;
  while (pValue^ <> #0) and (CurPos <= 3) do
  begin
    if IsCharDatePart(pValue^, DatePart) then
    begin
      Format[DatePart].Pos := CurPos;
      Format[DatePart].Count := GetPartCount(DatePart);
      Inc(CurPos);
    end;
    if pValue^ <> #0  then Inc(pValue);
  end;
end;

function GetDateTimeInfo(pDate: PChar; var SimpleFormat: TSimpleDateFormat;
  var DateInfo: TDateInfo): boolean;
 var
  i: integer;
  xDate: PChar;
begin
  DecodeDateFormat(SimpleFormat);
  with DateInfo do
  begin
    for i := Low(Sections) to High(Sections) do Sections[i] := 0;

    xDate  := pDate;
    BalanceCount := 0;
    SectionCount := Low(Sections);

    while pDate^ <> #0 do
    begin
      if not(pDate^ in ['0'..'9']) then
      begin
        if BalanceCount > 0 then
        begin
          if SectionCount <= High(Sections) then
          begin
            Sections[SectionCount] := StrToIntDef(Copy(xDate, 0, BalanceCount), 0);
            Inc(SectionCount)
          end
          else begin
            Result := False;
            Exit;
          end;
        end;
        xDate  := pDate + 1;
        BalanceCount  := 0;
      end
      else
        Inc(BalanceCount);
      Inc(pDate);
    end;
    if (BalanceCount > 0) and (SectionCount <= High(Sections)) then
      Sections[SectionCount] := StrToIntDef(Copy(xDate, 0, BalanceCount), 0);
  end;
  Result := True;
end;

function DateToStrY2K(Date: TDateTime; var Stroke: string;
  Kind: TDateEditKind): boolean; overload;
 var
  DateFormat: string;
begin
  Result := True;
  if Date = 0 then
    Stroke := ''
  else begin
    case Kind of
      dkDate:
        DateFormat := ShortDateFormat;
      dkDateTime:
        DateFormat := Format('%s hh%1:snn%1:sss', [ShortDateFormat, TimeSeparator]);
      else
        DateFormat := ShortDateFormat;
    end;
    DateTimeToString(Stroke, DateFormat, Date);
  end;
end;

function GetDateMaskFormat: string;
 var
  k: TDateFormatParts;
  SimpleFormat: TSimpleDateFormat;
  si, sd: string;
begin
  DecodeDateFormat(SimpleFormat);
  for k := Low(TDateFormatParts) to High(TDateFormatParts) do
  begin
    si := IntToStr(SimpleFormat[k].Pos);
    sd := IntToStr(SimpleFormat[k].Count);
    Result := Result + '%' + si + ':' + sd + '.' + sd + 'd';
    if k <> dpYear then Result := Result + '%0:s';
  end;
end;

function DateToStrY2K(Date: string; var Stroke: string;
  Kind: TDateEditKind): boolean; overload;
 var
  DateInfo: TDateInfo;
  SimpleFormat: TSimpleDateFormat;
  nYear, nMonth, nDay: Byte;
  sFormat: string;

 function DecodeDateStr(pDate: PChar; var DateInfo: TDateInfo): boolean;
 begin
   if GetDateTimeInfo(pDate, SimpleFormat, DateInfo) then
   begin
     nYear  := SimpleFormat[dpYear].Pos;
     nMonth := SimpleFormat[dpMonth].Pos;
     nDay   := SimpleFormat[dpDay].Pos;
     with DateInfo do
     Result := not(((Sections[nYear] = 00) and
       ((SectionCount = 3) and (BalanceCount = 0) ) or (SectionCount < 3)) or
       (Sections[nMonth] = 0) or (Sections[nMonth] > 12) or
       (Sections[nDay] = 0) or
       (Sections[nDay] > DaysPerMonth(Sections[nYear], Sections[nMonth])) or
       (Sections[4] > 23) or (Sections[5] > 59));
   end
   else
     Result := False;
 end;

begin
  Result := DecodeDateStr(PChar(Date), DateInfo);
  if Result then with DateInfo do
  begin
    if SimpleFormat[dpYear].Count > 2 then
    begin
      case DateInfo.Sections[nYear] of
        000..049: Sections[nYear] := 2000 + Sections[nYear];
        050..099: Sections[nYear] := 1900 + Sections[nYear];
        100..999: Sections[nYear] := 2000 + Sections[nYear];
      end;
    end;
    sFormat := GetDateMaskFormat;
    case Kind of
      dkDateTime:
        Stroke := Format(sFormat + ' %5:2.2d%4:s%6:2.2d%4:s%7:2.2d',
          [DateSeparator, Sections[nDay], Sections[nMonth], Sections[nYear],
           TimeSeparator, Sections[4], Sections[5], Sections[6]]);
      else
        Stroke := Format(sFormat,
          [DateSeparator, Sections[nDay], Sections[nMonth], Sections[nYear]]);
    end;
  end;
end;

procedure DrawFocusedRect(DC: HDC; pOldRect, pNewRect: PRect; BorderSize: integer);
 var
  Brush: HBRUSH;
  RgnOuterRect, RgnInnerRect, RgnOldBorder, RgnNewBorder: HRGN;
  R: TRect;
  nSavedDC: integer;

 procedure SetBoundsRgn(Rgn: HRGN; R: TRect);
 begin
   with R do SetRectRgn(Rgn, Left, Top, Right, Bottom);
 end;

begin
  RgnOuterRect := CreateEmptyRgn;
  RgnInnerRect := CreateEmptyRgn;
  RgnOldBorder := CreateEmptyRgn;
  RgnNewBorder := CreateEmptyRgn;

  { Brush}
  Brush:= CreateSolidBrush($00999999);

  if pOldRect <> nil then
  begin
    R := pOldRect^;
    SetBoundsRgn(RgnOuterRect, R);
    InflateRect(R, -BorderSize, -BorderSize);
    SetBoundsRgn(RgnInnerRect, R);
    CombineRgn(RgnOldBorder, RgnOuterRect, RgnInnerRect, RGN_XOR);

  end;

  if pNewRect <> nil then
  begin
    R := pNewRect^;
    SetBoundsRgn(RgnOuterRect, R);
    InflateRect(R, -BorderSize, -BorderSize);
    SetBoundsRgn(RgnInnerRect, R);
    CombineRgn(RgnNewBorder, RgnOuterRect, RgnInnerRect, RGN_XOR);

    if pOldRect <> nil then
      CombineRgn(RgnNewBorder, RgnOldBorder, RgnNewBorder, RGN_XOR);

  end;

  if pNewRect = nil then RgnNewBorder := RgnOldBorder;

  nSavedDC := SaveDC(DC);
  try
    SelectClipRgn(DC, RgnNewBorder);
    GetClipBox(DC, R);
    SelectObject(DC, Brush);
    PatBlt(DC, R.Left, R.Top, R.Right-R.Left, R.Bottom-R.Top, PATINVERT);
  finally
    RestoreDC(DC, nSavedDC);
  end;

  DeleteObject(RgnOuterRect);
  DeleteObject(RgnInnerRect);
  DeleteObject(RgnOldBorder);
  DeleteObject(RgnNewBorder);
  DeleteObject(Brush)

end;

function SetRectInDesktop(var Pos: TPoint; AWidth, AHeight: Integer; Offset: TPoint): integer;
begin
  Result := 0;
  with Screen do
  begin
    if Pos.Y < DesktopTop  then Pos.Y := DesktopTop;
    if (Pos.Y + AHeight) > (DesktopTop + DesktopHeight) then
    begin
      Pos.Y  := (DesktopTop + DesktopHeight) - AHeight - Offset.Y;
      Result := $1;
    end;
    if Pos.X < DesktopLeft then Pos.X := DesktopLeft;
    if (Pos.X + AWidth)  > (DesktopLeft + DesktopWidth) then
    begin
      Pos.X := (DesktopLeft + DesktopWidth) - AWidth- Offset.X;
      Result := Result + $2;
    end;
  end;
end;

function GetCharWidth(Handle: HWND; Font: TFont): integer;
 var
  TextMetric: TTextMetric;
  DC: HDC;
begin
  Result := 0;
  DC := GetWindowDC(Handle);
  SelectObject(DC, Font.Handle);
  try
    if GetTextMetrics(DC, TextMetric) then Result := TextMetric.tmMaxCharWidth;
  finally
    ReleaseDC(Handle, DC);
  end;
end;

function GetCharHeight(Handle: HWND; Font: TFont;
  DrawContext: HDC = 0): integer;
 var
  TextMetric: TTextMetric;
  DC: HDC;
  AFont: HFONT;
begin
  Result := 0;
  if DrawContext = 0 then
  begin
    DC := GetWindowDC(Handle);
    SelectObject(DC, Font.Handle);
    try
      if GetTextMetrics(DC, TextMetric) then Result := TextMetric.tmHeight;
    finally
      ReleaseDC(Handle, DC);
    end;
  end
  else begin
    DC := DrawContext;
    if Font <> nil then
    begin
      AFont := SelectObject(DC, Font.Handle);
      if GetTextMetrics(DC, TextMetric) then Result := TextMetric.tmHeight;
      SelectObject(DC, AFont);
    end
    else
      if GetTextMetrics(DC, TextMetric) then Result := TextMetric.tmHeight;
  end;
end;

function GetDCTextHeight(Font: TFont; Value: string; ACanvas: TCanvas = nil): Longint;
var
 Canvas: TCanvas;
begin
  if ACanvas = nil then
  begin
    Canvas := nil;
    try
      Canvas := TCanvas.Create;
      Canvas.Handle := GetDC(0);
      Canvas.Font := Font;
      Result := GetTextHeight(Canvas.Handle, Value);
    finally
      ReleaseDC(0, Canvas.Handle);
      Canvas.Free;
    end
  end
  else
    Result := GetTextHeight(ACanvas.Handle, Value);
end;

function GetDCTextWidth(Font: TFont; Value: string;  ACanvas: TCanvas = nil): Longint;
var
 Canvas: TCanvas;
begin
  if ACanvas = nil then
  begin
    Canvas := nil;
    try
      Canvas := TCanvas.Create;
      Canvas.Handle := GetDC(0);
      Canvas.Font := Font;
      Result := GetTextWidth(Canvas.Handle, Value);
    finally
      ReleaseDC(0, Canvas.Handle);
      Canvas.Handle := 0;
      Canvas.Free;
    end
  end
  else begin
    Result := GetTextWidth(ACanvas.Handle, Value);
  end;
end;

function GetTextHeight(DC: HDC; Value: string): integer;
 var
  R: TSize;
begin
  Windows.GetTextExtentPoint(DC, PChar(Value), Length(Value), R);
  Result := R.CY;
end;

function GetTextWidth(DC: HDC; Value: string): integer;
 var
  R: TSize;
begin
  Windows.GetTextExtentPoint(DC, PChar(Value), Length(Value), R);
  Result := R.CX;
end;

function GetSysColorsNumber(DC: HDC): LongInt;
begin
  Result := (LongInt(1) shl GetDeviceCaps(DC, BitsPixel)) *
    LongInt(GetDeviceCaps(DC, Planes));
end;

function ConvertedColor(RGBPart: integer): integer;
 var
  HiByte: integer;
begin
  HiByte := (RGBPart and $8F0) shr 4;
  Result := 0;
  case HiByte of
    00    : Result := 7;
    01, 02: Result := 8;
    03, 05: Result := 9;
    06    : Result := 10;
    07, 08: Result := 11;
    09, 10: Result := 12;
    11, 12: Result := 13;
    13, 14: Result := 14;
    15    : Result := 15;
  end;
  Result := Result shl 4;
  case RGBPart of
   000..019: Result := Result + 11;
   020..039: Result := Result + 04;
   040..069: Result := Result + 05;
   070..089: Result := Result + 14;
   090..099: Result := Result + 13;
   100..109: Result := Result + 06;
   110..129: Result := Result + 05;
   130..149: Result := Result + 13;
   150..189: Result := Result + 06;
   190..209: Result := Result + 14;
   210..255: Result := Result + 07;
  end;
end;

function GetTransparentColor(RGB: integer): integer;
begin
  Result  := ConvertedColor(RGB and $FF0000 shr 16) ;
  Result  := Result shl 8 or ConvertedColor(RGB and $00FF00 shr 8);
  Result  := Result shl 8 or ConvertedColor(RGB and $0000FF);
end;


procedure DrawBitmap(ACanvas: TCanvas; ABitmap: TBitmap; ARect: TRect;
  AStretch: boolean; ATransparent: boolean = True);
 var
  SrcR, DstR: TRect;
  DstH, DstW: integer;
begin
  if Assigned(ABitmap) then
  begin
    DstW := ABitmap.Width;
    DstH := ABitmap.Height;
    SrcR := Rect(0,0,DstW,DstH);
    if AStretch then
      DstR := ARect
    else begin
      DstR := Rect(0, 0, ABitmap.Width, ABitmap.Height);
      OffsetRect(DstR, ARect.Left, ARect.Top);
    end;
    ABitmap.Transparent := ATransparent;
    ACanvas.StretchDraw(DstR, ABitmap);
  end;
end;

procedure DrawTransparentBitmap(DC: HDC; Bitmap: TBitmap; R: TRect;
  StretchBitmap: boolean; AColor: TColor);
const
  ROP_DSPDxax = $00E20746;
var
  DstW, DstH: Integer;
  MaskDC: HDC;
  Mask: TBitmap;
  MaskHandle: HBITMAP;
  Color: TColor;
begin
  if Assigned(Bitmap) then
  begin
    if AColor = $FFFFFF then
      Color := Bitmap.Canvas.Pixels[0, Bitmap.Height - 1]
    else
      Color := AColor;
    if Bitmap.TransparentColor = Color then
    begin
      Mask := nil;
      MaskHandle := Bitmap.MaskHandle;
      MaskDC := CreateCompatibleDC(0);
      MaskHandle := SelectObject(MaskDC, MaskHandle);
    end
    else
    begin
      Mask := TBitmap.Create;
      Mask.Assign(Bitmap);
      Mask.Mask(Color);
      MaskDC := Mask.Canvas.Handle;
      MaskHandle := 0;
    end;

    if StretchBitmap then
    begin
      DstW := R.Right  - R.Left;
      DstH := R.Bottom - R.Top;
    end
    else begin
      DstW := Bitmap.Width;
      DstH := Bitmap.Height;
    end;

    try
      TransparentStretchBlt(DC, R.Left, R.Top, DstW, DstH, Bitmap.Canvas.Handle,
        0, 0, Bitmap.Width, Bitmap.Height, MaskDC, 0, 0);
    finally
      if Assigned(Mask) then
        Mask.Free
      else begin
        if MaskHandle <> 0 then SelectObject(MaskDC, MaskHandle);
        DeleteDC(MaskDC);
      end;
    end;
 end;
end;

procedure DrawStyledBitmap(Canvas: TCanvas; ARect: TRect; X, Y: integer;
 Bitmap: TBitmap; Style: TTransformStyle);
 var
  DestRect, SourceRect: TRect;
  ABitmap: TBitmap;
begin
  ABitmap := TBitmap.Create;
  try
    TransformBitmap(Bitmap, ABitmap, Style);
    SourceRect := Rect(0, 0, Bitmap.Width, Bitmap.Height);
    DestRect   := SourceRect;
    OffsetRect(DestRect, ARect.Left+X, ARect.Top+Y);
    Canvas.BrushCopy(DestRect, ABitmap, SourceRect,
      ABitmap.Canvas.Pixels[0, Bitmap.Height-1]);
  finally
    ABitmap.Free;
  end;
end;

procedure TransformBitmap(Source, Dest: TBitmap; Style: TTransformStyle;
  AColor: TColor = $FFFFFF);
 var
  i, j, ScanLineWidth, dHeight: integer;
  R: TRect;
  LDScan, LSScan: PByteArray;
  LSScan0, LSScan1, LSScan2: PByteArray;
  AColorRGB: ULong;
  BValue, GValue, RValue: integer;
  ABitmap: TBitmap;
  Rgn: HRGN;

  procedure CopyLScanLine(i: integer);
  begin
    LDScan[i]   := LSScan[i];
    LDScan[i+1] := LSScan[i+1];
    LDScan[i+2] := LSScan[i+2];
  end;

  function GetBSelectedBit(i: integer): integer;
  begin
    case i of
      0  :  Result := $42;
      255:  Result := $BD;
      else  Result := i;
    end;
  end;

  function GetBluredBit(i: integer): integer;
   var
    j0, j1: integer;
  begin
    if i - 3 < 0 then j0 := i else j0 := i - 3;
    if i + 3 > ScanLineWidth then j1 := i else j1 := i + 3;
    Result := (LSScan0[i] + LSScan1[i] + LSScan2[i] + LSScan1[j0] +
      LSScan1[j1]) div 5;
  end;

begin
  try
    Dest.PixelFormat := pf24Bit;
    if Dest.Handle <> Source.Handle then
    begin
      with Dest do
      begin
        Width  := Source.Width;
        Height := Source.Height;
      end;
    end;
    R := Rect(0, 0, Dest.Width, Dest.Height);
    ScanLineWidth := Integer(Dest.ScanLine[0]) - Integer(Dest.ScanLine[1]) - 1;
  except
    if Dest.Handle <> Source.Handle then
    begin
      with Dest do
      begin
        Width  := Source.Width;
        Height := Source.Height;
      end;
    end;
    R := Rect(0, 0, Dest.Width, Dest.Height);
    if not IsRectEmpty(R) then
    begin
      Dest.Canvas.CopyMode := cmSrcCopy;
      Dest.Canvas.CopyRect(R, Source.Canvas, R);
    end;
    Exit;
  end;
  if AColor <> $FFFFFF then
    AColorRGB := ColorToRGB(AColor)
  else
    AColorRGB := Source.Canvas.Pixels[0, 0];
  {24 bit}

  dHeight := Dest.Height-1;
  case Style of
    tsDisable:
      begin
        Source.PixelFormat := pf24Bit;
        for j := 0 to dHeight do
        begin
          LDScan := Dest.ScanLine[j];
          LSScan := Source.ScanLine[j];
          i := 0;
          while (i+2) <= ScanLineWidth do
          begin
            if LSScan[i+2] < $AF then
            begin
              LDScan[i]   := 120;
              LDScan[i+1] := 120;
              LDScan[i+2] := 120;
            end
            else
              if Dest.Canvas.Handle <> Source.Canvas.Handle then CopyLScanLine(i);
            Inc(i, 3);
          end;
        end;
      end;
    tsSelect:
      begin
        Source.PixelFormat := pf24Bit;
        for j := 0 to dHeight do
        begin
          LDScan := Dest.ScanLine[j];
          LSScan := Source.ScanLine[j];
          i := 0;
          while (i+2) <= ScanLineWidth do
          begin
            LDScan[i+2] := LSScan[i+2] div 2;
            LDScan[i+1] := LSScan[i+1] div 2;
            LDScan[i]   := GetBSelectedBit(LSScan[i]);
            Inc(i, 3);
          end;
        end;
      end;
    tsTransparent:
      begin
        Source.PixelFormat := pf24Bit;
        for j := 0 to Dest.Height-1 do
        begin
          LDScan := Dest.ScanLine[j];
          LSScan := Source.ScanLine[j];
          i := 0;
          while (i+3) <= ScanLineWidth do
          begin
            LDScan[i+2] := ConvertedColor(LSScan[i+2]);
            LDScan[i+1] := ConvertedColor(LSScan[i+1]);
            LDScan[i]   := ConvertedColor(LSScan[i]);
            Inc(i, 3);
          end;
        end;
      end;
    tsShadow:
      begin
        Source.PixelFormat := pf24Bit;
        BValue := GetBValue(AColorRGB);
        GValue := GetGValue(AColorRGB);
        RValue := GetRValue(AColorRGB);
        for j := 0 to dHeight do
        begin
          LDScan := Dest.ScanLine[j];
          LSScan := Source.ScanLine[j];
          i := 0;
          while (i+2) <= ScanLineWidth do
          begin
            if (LSScan[i] <> BValue) and (LSScan[i+1] <> GValue) and (LSScan[i+2] <> RValue) and
               (((i div 3) + j) mod 2 = 0) then
            begin
              LDScan[i+2] := 8;
              LDScan[i+1] := 36;
              LDScan[i]   := 107;
            end
            else
              if Dest.Canvas.Handle <> Source.Canvas.Handle then CopyLScanLine(i);
            Inc(i, 3);
          end;
        end;
      end;
    tsBlur:
      begin
        Source.PixelFormat := pf24Bit;
        for j := 0 to dHeight do
        begin
          LDScan  := Dest.ScanLine[j];

          LSScan0 := Source.ScanLine[_intMax(0, j - 1)];
          LSScan1 := Source.ScanLine[j];
          LSScan2 := Source.ScanLine[_intMin(j + 1, dHeight)];

          i := 0;
          while i <= ScanLineWidth do
          begin
            LDScan[i] := GetBluredBit(i);
            Inc(i);
          end;
        end;
      end;
    tsNormal:
      begin
        Dest.Canvas.CopyMode := cmSrcCopy;
        Dest.Canvas.CopyRect(R, Source.Canvas, R);
      end;
    tsInvert:
      begin
        Dest.Canvas.CopyMode := cmNotSrcCopy;
        Dest.Canvas.CopyRect(R, Source.Canvas, R);
      end;
    tsXPStyle:
      begin
        Source.PixelFormat := pf24Bit;
        if Source.Handle = Dest.Handle then
        begin
          ABitmap := TBitmap.Create;
          ABitmap.Assign(Source);
        end
        else
          ABitmap := Source;

        Rgn := GetBitmapRegion(Source, nil, AColorRGB);
        Dest.Canvas.Lock;
        try
          Dest.Canvas.Brush.Color := AColorRGB;
          Dest.Canvas.FillRect(R);
          OffsetRgn(Rgn, 1, 1);
          Dest.Canvas.Brush.Color := clXPShadow;
          FillRgn(Dest.Canvas.Handle, Rgn, Dest.Canvas.Brush.Handle);
          OffsetRect(R, -1, -1);
          DrawTransparentBitmap(Dest.Canvas.Handle, ABitmap, R, False);
        finally
          if Rgn <> NULLREGION then DeleteObject(Rgn);
          if ABitmap.Handle <> Source.Handle then ABitmap.Free;
          Dest.Canvas.UnLock;
        end;
      end;
  end;
end;

procedure AlphaBlend(BkgImage, SrcImage: TBitmap; DstImage: TBitmap;
  Opacity: integer; AColor, BColor: TColor);
 var
  LSrcScan, LBkgScan, LDstScan: PByteArray;
  i, j, ScanLineWidth: integer;
  R: TRect;
  AColorRGB, BColorRGB: ULong;
  ps, pd, pb: PColorValue;

  procedure SetDstImageBounds;
  begin
    with DstImage do
    begin
      if SrcImage <> nil then
      begin
        Width := _intMin(BkgImage.Width, SrcImage.Width);
        Height:= _intMin(BkgImage.Height, SrcImage.Height);
      end
      else begin
        Width := BkgImage.Width;
        Height:= BkgImage.Height;
      end;
      R := Rect(0, 0, Width, Height);
    end;
  end;

begin
  if SrcImage <> nil then SrcImage.PixelFormat := pf32Bit;
  BkgImage.PixelFormat := pf32Bit;

  try
    with DstImage do
    begin
      PixelFormat := pf32Bit;
      SetDstImageBounds;
      ScanLineWidth := Integer(ScanLine[0]) - Integer(ScanLine[1]);
    end;
  except
    SetDstImageBounds;
    DstImage.Canvas.CopyMode := cmSrcCopy;
    if SrcImage <> nil then
      DstImage.Canvas.CopyRect(R, SrcImage.Canvas, R)
    else
      if DstImage.Handle <> BkgImage.Handle then
         DstImage.Canvas.CopyRect(R, BkgImage.Canvas, R);
    Exit;
  end;

  AColorRGB := ColorToRGB(AColor);
  BColorRGB := ColorToRGB(BColor);

  LSrcScan := nil;
  for j := 0 to DstImage.Height-1 do
  begin
    if SrcImage <> nil then LSrcScan := SrcImage.ScanLine[j];
    LBkgScan := BkgImage.ScanLine[j];
    LDstScan := DstImage.ScanLine[j];
    i := 0;
    if SrcImage <> nil then
    begin
      while i < ScanLineWidth do
      begin
        ps := @LSrcScan[i];
        pd := @LDstScan[i];
        pb := @LBkgScan[i];
        if AColorRGB <> ps.Value then
        begin
          asm
            push ebx
            mov  ebx, Opacity
          end;
          pd^.Value := GetBlendAttr(ps^, pb^);
          asm
            pop  ebx
          end
        end
        else
          pd.Value := pb.Value;
        inc(i, 4);
      end;
    end
    else begin
      while i < ScanLineWidth do
      begin
        pd := @LDstScan[i];
        pb := @LBkgScan[i];
        if AColorRGB <> pb.Value then
        begin
          asm
            push ebx
            mov  ebx, Opacity
          end;
          pd.Value := GetBlendAttr(TColorValue(BColorRGB), pb^);
          asm
            pop  ebx
          end
        end;
        inc(i, 4);
      end;
    end;
  end;
  asm
    db  $0F, $77                     //   emms
  end
end;

function GetBitmapRegion(Bitmap: TBitmap; XForm: PXFORM; Color: integer): HRGN;
 var
  RgnData: PRGNDATA;
  p: PRectArray;
  h, w, x, x0, y, y1, bCount: integer;
  rv, gv, bv: Byte;
  Scan: PByteArray;

  procedure CreateDataRgn(var DataRgn: HRGN);
   var
    Rgn: HRGN;
  begin
    Rgn := ExtCreateRegion(XForm,
       SizeOf(TRgnDataHeader) + SizeOf(TRect) * RgnData^.rdh.nCount, RgnData^);
    if DataRgn <> NULLREGION then
    begin
      CombineRgn(DataRgn, DataRgn, Rgn, RGN_OR);
      DeleteObject(Rgn);
    end
    else
      DataRgn := Rgn;
  end;

  procedure ClearRgnData;
  begin
    with RgnData^.rdh do
    begin
      dwSize := SizeOf(TRgnDataHeader);
      iType := RDH_RECTANGLES;
      nCount := 0;
      nRgnSize := 0;
      SetRect(rcBound, maxInt, maxInt, 0, 0);
    end;
  end;

begin
  Result := NULLREGION;
  RgnData := AllocMem(RgnDataSize);
  p := @RgnData^.Buffer;

  Color := ColorToBGR(Color);
  rv := GetRValue(Color);
  gv := GetGValue(Color);
  bv := GetBValue(Color);

  try
    ClearRgnData;
    h := Bitmap.Height;
    w := Integer(Bitmap.ScanLine[0]) - Integer(Bitmap.ScanLine[1]) - 1;
    bCount := (w + 1) div Bitmap.Width;

    if bCount < 3 then
    begin
      Bitmap.PixelFormat := pf24bit;
      w := Integer(Bitmap.ScanLine[0]) - Integer(Bitmap.ScanLine[1]) - 1;
      bCount := (w + 1) div Bitmap.Width;
    end;

    for y := 0 to h - 1 do
    begin
      Scan := Bitmap.ScanLine[y];
      x := 0;
      while x < w do
      begin
        while (x < w) and (Scan[x] = bv) and (Scan[x+1] = gv) and
          (Scan[x+2] = rv) do Inc(x, bCount);

        x0 := x;
        while (x < w) and  not((Scan[x] = bv) and (Scan[x+1] = gv) and
          (Scan[x+2] = rv)) do Inc(x, bCount);

        if x <> x0 then with RgnData^.rdh do
        begin
          y1 := y;
          SetRect(p[nCount], x0 div bCount, y1, x div bCount, y1 + 1);
          with rcBound do
          begin
            Left   := _intMin(Left, x0);
            Top    := _intMin(Top, y1);
            Right  := _intMax(Right, x);
            Bottom := _intMax(Bottom, y1 + 1);
          end;

          inc(nCount);
          if nCount >= MaxRgnDataRects then
          begin
            CreateDataRgn(Result);
            ClearRgnData;
          end;
        end;
      end;
    end;
    if RgnData^.rdh.nCount > 0 then CreateDataRgn(Result);
  finally
    FreeMem(RgnData);
  end;
end;

function PtInRegionData(RgnData: PRGNDATA; X, Y: integer): boolean;
 var
  i: DWORD;
  p: PRectArray;
  pt: TPoint;
begin
  Result := False;
  p := @RgnData^.Buffer;
  i := 0;
  pt := Point(X, Y);
  if PtInRect(RgnData.rdh.rcBound, pt) then
  begin
    while not Result and (i < RgnData.rdh.nCount) do
    begin
      if PtInRect(p^[i], pt) then
        Result := True
      else
        Inc(i);
    end;
  end;
end;

function IsRegionEmpty(Rgn: HRGN): boolean;
begin
  Result := (Rgn = 0) or (Rgn = NULLREGION);
end;

procedure DrawShadow(Dest: TBitmap; const Rgn: HRGN; AColor, BColor: TColor;
  Size, Opacity: integer; Offset: TPoint; ExcludeSource: boolean = False); overload;
 var
  R: TRect;
  Bitmap: TBitmap;
  x, x0, y, y0, w, h, i, k0, k1, k2, RgnSize: integer;
  s: PByteArray;
  pv: PColorValue;
  DIBBitmap: TDIBBitmap;
  ARgn, BRgn: HRGN;
  RgnData: PRGNDATA;
  v: DWORD;
  pcv0, pcv1, pcv2: PColorValue;
begin
  AColor := ColorToRGB(AColor);
  BColor := ColorToRGB(BColor);
  RgnData := nil;

  BRgn := CreateEmptyRgn;
  CombineRgn(BRgn, Rgn, Rgn, RGN_COPY);

  ARgn := CreateEmptyRgn;
  CombineRgn(ARgn, Rgn, Rgn, RGN_COPY);

  Bitmap := TBitmap.Create;
  try
    OffsetRgn(BRgn, Offset.X, Offset.Y);
    GetRgnBox(BRgn, R);
    InflateRect(R, 1, 1);

    with Bitmap do
    begin
      PixelFormat := pf32Bit;
      Width := _intMin(Screen.Width - 1, R.Right);
      Height :=_intMin(Screen.Height - 1, R.Bottom);
      with Canvas do
      begin
        Draw(0, 0, Dest);
        Brush.Color := BColor;
        FillRgn(Handle, BRgn, Brush.Handle);
      end;
      InitDIBBitmap(Canvas.Handle, Handle, DIBBitmap);
    end;

    h := Bitmap.Height;
    w := Integer(Bitmap.ScanLine[0]) - Integer(Bitmap.ScanLine[1]) - 1;

    RgnSize := GetRegionData (BRgn, 0, nil);
    GetMem(RgnData, RgnSize);
    GetRegionData (BRgn, RgnSize, RgnData);

    for i := 0 to Size do
    begin
      GetDIBBitmap(DIBBitmap);
      for y := 0 to h - 1 do with Bitmap do
      begin
        s  := ScanLine[y];
        x  := 0;
        x0 := 0;
        while x < w do
        begin
          if PtInRegionData(RgnData, x0, y) and
            not(ExcludeSource and PtInRegion(ARgn, x0, y)) then
          begin
            pv := @s[x];
            y0 := h - y - 1;
            with DIBBitmap, BitmapInfo^.bmiHeader do
            begin
              k0 := y0 * biWidth + x0;
              k1 := _intMax(0, y0 - 1) * biWidth + x0;
              k2 := _intMin(y0 + 1, h) * biWidth + x0;

              pcv0 := @Bits[k0];
              pcv1 := @Bits[k1];
              pcv2 := @Bits[k2];

              pv^.Value := GetAvergAttr(pcv0^,
                PColorValue(Integer(pcv1) - Sizeof(TColorValue))^,
                pcv1^,
                PColorValue(Integer(pcv1) + Sizeof(TColorValue))^,
                PColorValue(Integer(pcv0) - Sizeof(TColorValue))^,
                PColorValue(Integer(pcv0) + Sizeof(TColorValue))^,
                PColorValue(Integer(pcv2) - Sizeof(TColorValue))^,
                pcv2^,
                PColorValue(Integer(pcv2) + Sizeof(TColorValue))^);
            end;
          end;
          Inc(x, 4);
          Inc(x0);
        end;
      end;
    end;
    AlphaBlend(Dest, Bitmap, Bitmap, Opacity, AColor, BColor);
    Dest.Canvas.Draw(0, 0, Bitmap);
  finally
    Bitmap.Free;
    if ARgn <> NULLREGION then DeleteObject(ARgn);
    if BRgn <> NULLREGION then DeleteObject(BRgn);
    if RgnData <> nil then FreeMem(RgnData);
    asm
      db  $0F, $77                     //   emms
    end
  end;
end;

procedure DrawShadow(Source, Dest: TBitmap; AColor, BColor: TColor;
  Size, Opacity: integer; Offset: TPoint; ExcludeSource: boolean = False);
 var
  Rgn: HRGN;
begin
  Rgn := GetBitmapRegion(Source, nil, AColor);
  try
    DrawShadow(Dest, Rgn, AColor, BColor, Size, Opacity, Offset, ExcludeSource);
  finally
    if Rgn <> NULLREGION then DeleteObject(Rgn);
  end;
end;

{Drawing basic shapes}

function getShape_Check(X, Y: integer; Size: TObjectSize;
  var Points: TBasicShapePoints): integer;
begin
  Result := 6;
  case Size of
    szNormal:
      begin
        Points[0] := Point(X, Y + 2);
        Points[1] := Point(X, Y + 4);
        Points[2] := Point(X + 2, Y + 6);
        Points[3] := Point(X + 6, Y + 2);
        Points[4] := Point(X + 6, Y);
        Points[5] := Point(X + 2, Y + 4);
      end;
    szSmall:
      begin
        Points[0] := Point(X, Y + 1);
        Points[1] := Point(X, Y + 3);
        Points[2] := Point(X + 2, Y + 5);
        Points[3] := Point(X + 5, Y + 2);
        Points[4] := Point(X + 5, Y);
        Points[5] := Point(X + 2, Y + 3);
      end;
    szLarge:
      begin
        {}
      end;
  end;
end;

function getShape_Up(X, Y: integer; Size: TObjectSize;
  var Points: TBasicShapePoints): integer;
 var
  j: integer;
begin
  Result := 3;
  case Size of
    szNormal: j := 3;
    szSmall : j := 2;
    szLarge : j := 4;
    else
     j := 3;
  end;
  Points[0] := Point(X, Y + j);
  Points[1] := Point(X + j shl 1, Y + j);
  Points[2] := Point(X + j, Y);
end;

function getShape_Down(X, Y: integer; Size: TObjectSize;
  var Points: TBasicShapePoints): integer;
 var
  j: integer;
begin
  Result := 3;
  case Size of
    szNormal: j := 3;
    szSmall : j := 2;
    szLarge : j := 4;
    else
     j := 3;
  end;
  Points[0] := Point(X, Y);
  Points[1] := Point(X + j, Y + j);
  Points[2] := Point(X + j shl 1, Y);
end;

function getShape_Left(X, Y: integer; Size: TObjectSize;
  var Points: TBasicShapePoints): integer;
 var
  j: integer;
begin
  Result := 3;
  case Size of
    szNormal: j := 3;
    szSmall : j := 2;
    szLarge : j := 4;
    else
     j := 3;
  end;
  Points[0] := Point(X, Y + j);
  Points[1] := Point(X + j, Y + j shl 1);
  Points[2] := Point(X + j, Y);
end;

function getShape_Right(X, Y: integer; Size: TObjectSize;
  var Points: TBasicShapePoints): integer;
 var
  j: integer;
begin
  Result := 3;
  case Size of
    szNormal: j := 3;
    szSmall : j := 2;
    szLarge : j := 4;
    else
     j := 3;
  end;
  Points[0] := Point(X, Y);
  Points[1] := Point(X, Y + j shl 1);
  Points[2] := Point(X + j, Y + j);
end;

function getShape_ArrowUp(X, Y: integer; Size: TObjectSize;
  var Points: TBasicShapePoints): integer;
begin
  Result := 7;
  case Size of
    szNormal, szSmall, szLarge:
      begin
        Points[0] := Point(X, Y + 4);
        Points[1] := Point(X + 3, Y + 4);
        Points[2] := Point(X + 3, Y);
        Points[3] := Point(X + 5, Y);
        Points[4] := Point(X + 5, Y + 4);
        Points[5] := Point(X + 8, Y + 4);
        Points[6] := Point(X + 4, Y + 8);
      end;
  end;
end;

function getShape_ArrowDown(X, Y: integer; Size: TObjectSize;
  var Points: TBasicShapePoints): integer;
begin
  Result := 7;
  case Size of
    szNormal, szSmall, szLarge:
      begin
          Points[0] := Point(X, Y + 4);
          Points[1] := Point(X + 3, Y + 4);
          Points[2] := Point(X + 3, Y + 8);
          Points[3] := Point(X + 5, Y + 8);
          Points[4] := Point(X + 5, Y + 4);
          Points[5] := Point(X + 8, Y + 4);
          Points[6] := Point(X + 4 , Y);
      end;
  end;
end;

function getShape_ArrowLeft(X, Y: integer; Size: TObjectSize;
  var Points: TBasicShapePoints): integer;
begin
  Result := 7;
  case Size of
    szNormal, szSmall, szLarge:
      begin
        Points[0] := Point(X, Y + 4);
        Points[1] := Point(X + 4, Y + 8);
        Points[2] := Point(X + 4, Y + 5);
        Points[3] := Point(X + 8, Y + 5);
        Points[4] := Point(X + 8, Y + 3);
        Points[5] := Point(X + 4, Y + 3);
        Points[6] := Point(X + 4, Y);
      end;
  end;
end;

function getShape_ArrowRight(X, Y: integer; Size: TObjectSize;
  var Points: TBasicShapePoints): integer;
begin
  Result := 7;
  case Size of
    szNormal, szSmall, szLarge:
      begin
        Points[0] := Point(X, Y + 3);
        Points[1] := Point(X, Y + 5);
        Points[2] := Point(X + 4, Y + 5);
        Points[3] := Point(X + 4, Y + 8);
        Points[4] := Point(X + 8, Y + 4);
        Points[5] := Point(X + 4, Y);
        Points[6] := Point(X + 4, Y + 3);
      end;
  end;
end;

function getShape_Plus(X, Y: integer; Size: TObjectSize;
  var Points: TBasicShapePoints): integer;
begin
  Result := 8;
  case Size of
    szNormal, szSmall, szLarge:
      begin
        Points[0] := Point(X, Y + 2);
        Points[1] := Point(X + 2, Y + 2);
        Points[2] := Point(X + 2, Y + 4);
        Points[3] := Point(X + 2, Y + 2);
        Points[4] := Point(X + 4, Y + 2);
        Points[5] := Point(X + 2, Y + 2);
        Points[6] := Point(X + 2, Y);
        Points[7] := Point(X + 2, Y + 2);
      end;
  end;
end;

function getShape_Minus(X, Y: integer; Size: TObjectSize;
  var Points: TBasicShapePoints): integer;
begin
  Result := 2;
  case Size of
    szNormal, szSmall, szLarge:
      begin
        Points[0] := Point(X, Y + 2);
        Points[1] := Point(X + 4, Y + 2);
      end;
  end;
end;

procedure DrawBasicShape(DC: HDC; AObject: TBasicShape; X, Y: integer;
  Color: TColor; Size: TObjectSize = szNormal);
 var
  AColor, i: integer;
  ABrush: HBRUSH;
  APen: HPEN;
  Points: TBasicShapePoints;
begin
  AColor := ColorToRGB(GetNearestColor(DC, Color));
  APen   := SelectObject(DC, CreatePen(PS_SOLID, 1, AColor));
  ABrush := SelectObject(DC, CreateSolidBrush(AColor));
  try
    case AObject of
      shCheck:
        i := getShape_Check(X, Y, Size, Points);
      shUp:
        i := getShape_Up(X, Y, Size, Points);
      shDown:
        i := getShape_Down(X, Y, Size, Points);
      shLeft:
        i := getShape_Left(X, Y, Size, Points);
      shRight:
        i := getShape_Right(X, Y, Size, Points);
      shArrowUp:
        i := getShape_ArrowUp(X, Y, Size, Points);
      shArrowDown:
        i := getShape_ArrowDown(X, Y, Size, Points);
      shArrowLeft:
        i := getShape_ArrowLeft(X, Y, Size, Points);
      shArrowRight:
        i := getShape_ArrowRight(X, Y, Size, Points);
      shPlus:
        i := getShape_Plus(X, Y, Size, Points);
      shMinus:
        i := getShape_Minus(X, Y, Size, Points);
      else
        i := 0;
    end;
    if i <> 0 then Polygon(DC, Points, i);
  finally
    DeleteObject(SelectObject(DC, APen));
    DeleteObject(SelectObject(DC, ABrush));
  end;
end;

function DrawHighLightText(Canvas: TCanvas; Text: PChar; ARect: TRect;
  Mode: byte; DrawFlag: DWORD = DT_END_ELLIPSIS; 
  ImageList: TCustomImageList = nil): TPoint;

 const
   pValueSize = 1000 * SizeOf(Char);

 var
  nHeight, nWidth, nLineWidth, nLineHeight: Integer;
  DrawRect: TRect;
  pValue, pDrawText: PChar;
  nDrawCount, nValueCount: integer;
  lFirstChar: boolean;
  lTranslateSlash: boolean;
  LogFont: TLogFont;
  pFont0, pFont1: HFONT;

 procedure IncDrawCount(nCount: integer = 1);
   var
    nTextHeight: integer;
 begin
   Inc(nDrawCount, nCount);
   if lFirstChar then
   begin
     nTextHeight := GetDCTextHeight(Canvas.Font, 'Wg', Canvas);
     Inc(nLineHeight, nTextHeight);
     lFirstChar  := False;
   end
 end;

 procedure ClearDrawText;
 begin
   pDrawText  := Text;
   nDrawCount := 0;
 end;

 procedure PaintString;
  var
   R: TRect;
   Size: TSize;
 begin
   R := DrawRect;

   if (pDrawText^ = #0) or (nDrawCount=0) then
   begin
     ClearDrawText;
     Exit;
   end;

   case Mode of
     0:
       begin
         {  }
         if DT_WORDBREAK and DrawFlag = 0 then
         begin
           GetTextExtentPoint32(Canvas.Handle, pDrawText, nDrawCount, Size);
           Inc(Size.cx);
         end
         else begin
           DrawText(Canvas.Handle, pDrawText, nDrawCount, R,
             DT_CALCRECT or DT_WORDBREAK);
           Size.cx := R.Right - R.Left;
           Size.cy := R.Bottom - R.Top;
           nLineHeight := Size.cy;
         end;
         Inc(nLineWidth, Size.cx);
         DrawRect.Left := DrawRect.Left + Size.cx;
       end;
     1:
       if DrawRect.Left < ARect.Right then
       begin
         DrawText(Canvas.Handle, pDrawText, nDrawCount, R,
           DT_CALCRECT or DrawFlag);
         DrawText(Canvas.Handle, pDrawText, nDrawCount, DrawRect, DrawFlag);
         Inc(nLineWidth, R.Right - R.Left);
         DrawRect.Left := DrawRect.Left + R.Right - R.Left;
       end;
   end;

   ClearDrawText;
 end;

 procedure NewLine;
 begin
   Inc(Text);
   PaintString;
   lFirstChar := True;
   nHeight  := nHeight + nLineHeight;
   nWidth   := _intMax(nWidth, nLineWidth);
   DrawRect := Rect(ARect.Left, ARect.Top+nHeight, ARect.Right,
     ARect.Bottom);

   nLineHeight := 0;
   nLineWidth  := 0;
 end;

 procedure TranslateSpecial;
  var
   cFlag: Char;
   nValue: integer;
   Size: TSize;

  function ReadParam: boolean;
   var
    pParam: PChar;
  begin
    nValueCount := 0;
    Inc(Text);                        // {
    Result := False;
    if Text^ in ['{', ','] then
    begin
      repeat
        Inc(Text)
      until not(Text^ in [#0, '}', ',', ' ']);
      pParam := Text;
      while not(Text^ in [#0, '}', ',']) do
      begin
        Inc(Text);
        Inc(nValueCount);
      end;

      if Text^ = ',' then
        Result := True
      else
        if Text^ <> #0 then Inc(Text);

      StrLCopy(pValue, pParam, nValueCount);
    end;
  end;

  procedure ReadBitmapTag(AStyle: TTransformStyle; AdjustHeight: boolean);
   var
    ANext: boolean;
    nParam1, nParam2: integer;

  begin
    Inc(Text);
    ANext := ReadParam;
    if (nValueCount > 0) then
    begin
      try
        case AStyle of
          tsNormal:
            begin
              if Assigned(ImageList) and (pValue^ in ['0'..'9']) then
              begin
                {}
                if ANext then
                begin
                  nValue := StrToIntDef(pValue, 0);
                  Dec(Text);
                  ReadParam;
                  if Mode > 0 then with DrawRect do
                  begin
                    Canvas.FillRect(Rect(Left, Top, Left + ImageList.Width, 
                      Bottom));
                    ImageList.DrawOverlay(Canvas, DrawRect.Left, DrawRect.Top,
                      nValue, StrToIntDef(pValue, 0));
                  end;
                end
                else
                  if Mode > 0 then with DrawRect do
                  begin
                    Canvas.FillRect(Rect(Left, Top, Left + ImageList.Width,
                      Bottom));
                    ImageList.Draw(Canvas, Left, Top, StrToIntDef(pValue, 0), 
                      True);
                  end;

                if AdjustHeight then
                begin
                  if nLineHeight < ImageList.Height then
                  begin
                    nLineHeight := ImageList.Height;
                    lFirstChar  := False;
                  end;
                end;

                DrawRect.Left := DrawRect.Left + ImageList.Width;
                Inc(nLineWidth, ImageList.Width);
              end
              else
                try
                  ABitmap.Canvas.Brush.Color := Canvas.Brush.Color;
                  with ABitmap do
                  begin
                    if Mode > 0 then
                      Canvas.FillRect(Rect(0, 0, Width, Height));
                    LoadFromResourceName(HInstance, pValue);
                  end;
                  if (Mode > 0) and (DrawRect.Left < DrawRect.Right) then
                    DrawBitmap(Canvas, ABitmap, DrawRect, False);
                  DrawRect.Left := DrawRect.Left + ABitmap.Width;
                  if AdjustHeight then
                  begin
                    if nLineHeight < ABitmap.Height then
                    begin
                      nLineHeight := ABitmap.Height;
                      lFirstChar  := False;
                    end
                  end;
                  Inc(nLineWidth, ABitmap.Width);
                except
                  {}
                end;
            end;
          tsTransparent:
            begin
              ABitmap.Canvas.Brush.Color := Canvas.Brush.Color;

              nParam1 := StrToIntDef(pValue, 0);
              if ANext then
              begin
                Dec(Text);
                ANext := ReadParam;
                nParam2 := StrToIntDef(pValue, 0)
              end
              else
                nParam2 := 125;

              if Assigned(ImageList) and (pValue^ in ['0'..'9']) then
              begin
                if ANext then with ABitmap do
                begin
                  Width  := ImageList.Width;
                  Height := ImageList.Height;
                  Dec(Text);
                  ReadParam;
                  if Mode > 0 then
                  begin
                    Canvas.FillRect(Rect(0, 0, Width, Height));
                    ImageList.DrawOverlay(Canvas, 0, 0, nParam1, 
                      StrToIntDef(pValue, 0));
                  end;
                end
                else begin
                  with ABitmap do
                  begin
                    if Mode > 0 then
                    begin
                      Canvas.FillRect(Rect(0, 0, Width, Height));
                      ImageList.GetBitmap(nParam1, ABitmap)
                    end
                  end
                end
              end
              else begin
                try
                  ABitmap.LoadFromResourceName(HInstance, pValue);
                except
                  {}
                end;
              end;

              if (Mode > 0) and (DrawRect.Left < DrawRect.Right) then
              begin
                AlphaBlend(ABitmap, nil, ABitmap, nParam2,
                  ABitmap.Canvas.Pixels[0, 0], ABitmap.Canvas.Pixels[0, 0]);
                DrawBitmap(Canvas, ABitmap, DrawRect, False);
              end;

              DrawRect.Left := DrawRect.Left + ABitmap.Width;
              Inc(nLineWidth, ABitmap.Width);
            end;
          tsSelect, tsShadow, tsInvert, tsXPStyle:
            begin
              ABitmap.Canvas.Brush.Color := Canvas.Brush.Color;
              nParam1 := StrToIntDef(pValue, 0);

              if Assigned(ImageList) and (pValue^ in ['0'..'9']) then
              begin
                if ANext then with ABitmap do
                begin
                  Width  := ImageList.Width;
                  Height := ImageList.Height;
                  Dec(Text);
                  ReadParam;
                  if Mode > 0 then
                  begin
                    Canvas.FillRect(Rect(0, 0, Width, Height));
                    ImageList.DrawOverlay(Canvas, 0, 0, nParam1, 
                      StrToIntDef(pValue, 0));
                  end;
                end
                else begin
                  with ABitmap do
                  begin
                    if Mode > 0 then
                      Canvas.FillRect(Rect(0, 0, Width, Height));
                    ImageList.GetBitmap(nParam1, ABitmap)
                  end
                end
              end
              else begin
                try
                  ABitmap.LoadFromResourceName(HInstance, pValue);
                except
                  {}
                end;
              end;  

              if (Mode > 0) and (DrawRect.Left < DrawRect.Right) then
              begin
                TransformBitmap(ABitmap, ABitmap, AStyle);
                DrawBitmap(Canvas, ABitmap, DrawRect, False);
              end;

              DrawRect.Left := DrawRect.Left + ABitmap.Width;
              Inc(nLineWidth, ABitmap.Width);
            end;
        end;

        Dec(Text);
      finally
        {}
      end;
    end
    else begin
      Canvas.Font.Style := Canvas.Font.Style  + [fsItalic];
      Dec(Text, 2);
    end
  end;

 begin
   Inc(Text);
   if Text^<>#0 then
   begin
     case Text^ of
       'b':
          begin
            if ((Text+1)^<>#0) and ((Text+1)^ = '0') then
            begin
              Canvas.Font.Style := Canvas.Font.Style  - [fsBold];
              Inc(Text);
            end
            else
              Canvas.Font.Style := Canvas.Font.Style  + [fsBold];
            Inc(Text);
            ClearDrawText;
          end;
       'i':
          begin
            if ((Text+1)^<>#0) then
            begin
              case (Text+1)^ of
               '0':
                 begin
                  Canvas.Font.Style := Canvas.Font.Style  - [fsItalic];
                  Inc(Text);
                 end;
               'd': ReadBitmapTag(tsTransparent, False);
               'n': ReadBitmapTag(tsInvert, False);
               'h': ReadBitmapTag(tsShadow, False);
               'm': ReadBitmapTag(tsNormal, False);
               'p': ReadBitmapTag(tsNormal, True);
               's': ReadBitmapTag(tsSelect, False);
               'x': ReadBitmapTag(tsXPStyle, False);
               else
                 Canvas.Font.Style := Canvas.Font.Style  + [fsItalic];
              end;
            end
            else
              Canvas.Font.Style := Canvas.Font.Style  + [fsItalic];
            Inc(Text);
            ClearDrawText;
          end;
       'u':
          begin
            if ((Text+1)^<>#0) and ((Text+1)^ = '0') then
            begin
              Canvas.Font.Style := Canvas.Font.Style  - [fsUnderline];
              Inc(Text);
            end
            else
              Canvas.Font.Style := Canvas.Font.Style  + [fsUnderline];
            Inc(Text);
            ClearDrawText;
           end;
       'f':
          begin
            if ((Text+1)^<>#0) and ((Text+1)^ = '0') then
            begin
              Canvas.Font.Name := LogFont.lfFaceName;
              Inc(Text, 2);
            end
            else begin
              ReadParam;
              Canvas.Font.Name := Strpas(pValue);
            end;
            ClearDrawText;
          end;
       's':
          begin
            if ((Text+1)^<>#0) then
            begin
              case (Text+1)^ of
               '0':
                 begin
                   Canvas.Font.Style := Canvas.Font.Style  - [fsStrikeOut];
                   Inc(Text);
                 end;
               '{':
                 begin
                   ReadParam;
                   nValue := StrToIntDef(pValue, 0);
                   if (pValue^ = '+') or  (pValue^ = '-')then
                     Canvas.Font.Size := Canvas.Font.Size + nValue
                   else
                   if pValue^ = '0' then
                     Canvas.Font.Height := LogFont.lfHeight
                   else
                     Canvas.Font.Size := nValue;
                   Dec(Text);
                 end;
               else
                 Canvas.Font.Style := Canvas.Font.Style  + [fsStrikeOut];
              end;
            end
            else
              Canvas.Font.Style := Canvas.Font.Style  + [fsStrikeOut];
            Inc(Text);
            ClearDrawText;
          end;
       'o':
          begin
            if ((Text+1)^<>#0) then
            begin
              case (Text+1)^ of
                'w','h', 'W', 'H':
                  begin
                    Inc(Text);
                    cFlag := Text^;
                    ReadParam;
                    if IsValidInteger(pValue) then
                    begin
                      nValue := StrToIntDef(pValue, 0);
                      case cFlag of
                        'w':
                          begin
                            DrawRect.Left := DrawRect.Left + nValue;
                            Inc(nLineWidth, nValue);
                          end;
                        'h':
                          begin
                            DrawRect.Top := DrawRect.Top + nValue;
                            Inc(nLineHeight, nValue);
                          end;
                        'W':
                          begin
                            DrawRect.Left := DrawRect.Left - nValue;
                            Dec(nLineWidth, nValue);
                          end;
                        'H':
                          begin
                            DrawRect.Top := DrawRect.Top - nValue;
                            Dec(nLineHeight, nValue);
                          end;
                      end;
                    end
                    else begin
                      GetTextExtentPoint32(Canvas.Handle, pDrawText, nDrawCount,
                        Size);
                      Inc(Size.cx);
                      case cFlag of
                        'w':
                          begin
                            DrawRect.Left := DrawRect.Left + Size.cx;
                            Inc(nLineWidth, Size.cx);
                          end;
                        'h':
                          begin
                            DrawRect.Top := DrawRect.Top + Size.cy;
                            Inc(nLineHeight, Size.cy);
                          end;
                        'W':
                          begin
                            DrawRect.Left := DrawRect.Left - Size.cx;
                            Inc(nLineWidth, - Size.cx);
                          end;
                        'H':
                          begin
                            DrawRect.Top := DrawRect.Top - Size.cy;
                            Inc(nLineHeight, - Size.cy);
                          end;
                      end;
                    end;
                    ClearDrawText;
                  end;
              end;
            end;
          end;
       'c':
          begin
            ReadParam;
            ClearDrawText;
            try
              nValue := StringToColor(pValue);
              Canvas.Font.Color := nValue;
            except
            end;
          end;
       'l':
          begin
            ReadParam;
            ClearDrawText;
            try
              nValue := StringToColor(pValue);
              Canvas.Pen.Color := nValue;
              with DrawRect do
              begin
                Canvas.MoveTo(Left , Top);
                Canvas.LineTo(Right, Top);
              end;
            except
            end;
          end;
       '#':
         NewLine;
       else
         IncDrawCount;
     end;
   end
   else
     IncDrawCount;
 end;

begin
(*
   :
  /b  -  Bold
  /b0 -  Bold
  /i  -  Italic
  /i0 -  Italic
  /u  -  Underline
  /u0 -  Underline
  /s  - StrikeOut
  /s0 - StrikeOut
  /f{font name} -             **    
  /s{font size} -            **    
  /ow{length}    -      
  /oh{length}    -      
  /c{color}     -  
  /im{resource name} -  
  /ip{resource name} -  
  /is{resource name} -  
  /l{color}          -  
  /#                 -  
  /{.../}            -     .
*)

  if Text = '' then begin
    Result := Point(0,0);
    Exit;
  end;

  GetMem(pValue, pValueSize);

  GetObject(Canvas.Font.Handle, SizeOf(TLogFont), @LogFont);
  pFont0 := CreateFontIndirect(LogFont);
  pFont1 := SelectObject(Canvas.Handle, pFont0);

  SetBkMode(Canvas.Handle, TRANSPARENT);

  nHeight := 0;
  nWidth  := 0;

  lFirstChar := True;
  DrawRect   := ARect;

  nLineHeight := 0;
  nLineWidth  := 0;

  ClearDrawText;

  if Mode = 0 then ARect := Rect(ARect.Left, ARect.Top, MaxInt, MaxInt);

  lTranslateSlash := True;

  try
    while Text^<>#0 do
    begin
      case Text^ of
        '/': begin
              if ((Text+1)^<>#0) then
              begin
                case (Text+1)^ of
                  '{':
                    begin
                      PaintString;
                      lTranslateSlash := False;
                      Inc(Text, 2);
                      ClearDrawText;
                    end;
                  '}':
                    begin
                      PaintString;
                      lTranslateSlash := True;
                      Inc(Text, 2);
                      ClearDrawText;
                    end;
                  else begin
                    if lTranslateSlash then
                    begin
                      PaintString;
                      TranslateSpecial;
                    end
                    else begin
                      IncDrawCount;
                      Inc(Text);
                    end;
                  end
                end;
              end
              else begin
                IncDrawCount;
                Inc(Text);
              end;
             end;
        #10: begin
               NewLine;
             end;
        #13:begin
              if not lFirstChar then
                NewLine
              else
                Inc(Text);
              ClearDrawText;
           end;
        else begin
          IncDrawCount;
          Inc(Text);
        end;
      end
    end;
    PaintString;
    nHeight := nHeight + nLineHeight;
    nWidth  := _intMax(nWidth, nLineWidth) + ARect.Left;
    Result  := Point(nWidth, nHeight);
  finally
    SelectObject(Canvas.Handle, pFont1);
    DeleteObject(pFont0);
    FreeMem(pValue, pValueSize);
  end;
end;

procedure DrawGridFrameBorder(Canvas: TCanvas; ARect: TRect;
  AStyle: TEdgeBorderStyle; AState: TDrawBorerState; FixedColor: TColor);
 var
  APoints: array of TPoint;
  Brush: HBRUSH;
begin
  case AStyle of
    ebsNormal:
     case AState of
       dsUp:
         begin
           DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
         end;
       dsDown:
         begin
           DrawEdge(Canvas.Handle, ARect, BDR_SUNKENINNER, BF_BOTTOMRIGHT);
           DrawEdge(Canvas.Handle, ARect, BDR_SUNKENOUTER, BF_TOPLEFT);
         end;
     end;
    ebsFlat:
     begin
       case AState of
         dsUp:
           begin
             DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
           end;
         dsDown:
           begin
             DrawEdge(Canvas.Handle, ARect, BDR_SUNKENOUTER, BF_RECT);
           end;
       end;
     end;
   ebsNone:
     begin
       Brush := CreateSolidBrush(ColorToRGB(FixedColor));
       FrameRect(Canvas.Handle, ARect, Brush);
       DeleteObject(Brush);
       SetLength(APoints, 4);
       APoints[0].X := ARect.Left ; APoints[0].Y := ARect.Bottom;
       APoints[1].X := ARect.Right; APoints[1].Y := ARect.Bottom;
       APoints[2].X := ARect.Right; APoints[2].Y := ARect.Top-1;
       APoints[3].X := ARect.Left ; APoints[3].Y := ARect.Top-1;
       if ColorToRGB(FixedColor) = clSilver then
         Canvas.Pen.Color := clGray
       else
         Canvas.Pen.Color := clSilver;
       Canvas.Polyline(APoints);
     end;
   ebsShadowFlat:
      begin
       InflateRect(ARect, -1, -1);
       case AState of
         dsUp:
           begin
             DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
           end;
         dsDown:
           begin
             DrawEdge(Canvas.Handle, ARect, BDR_SUNKENOUTER, BF_RECT);
           end;
       end;
      end;
  end;
end;

{$HINTS OFF}
function GetNumericFormat(Value: PChar; var Precision: integer;
  var Digits: integer): TNumericFormat;
type
 TNumericPart = (npIntegral, npDecimal, npExponent);

 var
  NumericPart:  TNumericPart;
  Values: array[TNumericPart] of string[30];
  ESigns: array[TNumericPart] of ShortInt;
  ESChar: array[TNumericPart] of Char;
  E, eCount: Integer;
 {$IFDEF DELPHI_V5UP}
    V: Int64;
  {$ELSE}
    V: Extended;
  {$ENDIF}
begin
  ESigns[npIntegral] := 0;
  ESigns[npDecimal ] := -1;
  ESigns[npExponent] := 0;

  Precision := 0;
  Digits    := 0;

  for NumericPart := npIntegral to npExponent do
  begin
    Values[NumericPart] := '';
    ESChar[NumericPart] := '+';
  end;

  Result      := nmInteger;
  NumericPart := npIntegral;

  while (Value^ <> #0) and (Result <> nmNone) do
  begin
    case Value^ of
      '+', '-':
        if (ESigns[NumericPart] = 0) and (Values[NumericPart] = '') then
        begin
          ESigns[NumericPart] := ESigns[NumericPart] + 1;
          ESChar[NumericPart] := Value^;
        end
        else begin
          Result := nmNone;
          continue;
        end;
      'E', 'e':
        if (NumericPart <> npExponent) and
           ((NumericPart = npIntegral) and (Values[NumericPart] <> '') or
            (NumericPart = npDecimal ) and (Values[NumericPart] <> '')) then
        begin
          NumericPart := npExponent;
          Result      := nmExponent;
        end
        else begin
          Result := nmNone;
          continue;
        end;
      '0'..'9':
        Values[NumericPart] := Values[NumericPart] + Value^;
      else
        if (Value^ = DecimalSeparator) and
           (Result = nmInteger)
        then begin
          NumericPart := npDecimal;
          Result      := nmDecimal
        end
        else begin
          Result := nmNone;
          continue;
        end;
    end;
    Inc(Value);
  end;
  case Result of
    nmInteger:
      begin
        Val(Values[npIntegral], V, E);
        if E <> 0 then Result := nmNone;
        Digits := Length(Values[npIntegral]);
      end;
    nmDecimal:
      begin
        if Length(Values[npDecimal])<= CurrencyDecimals then
          Result := nmCurrency;
        Digits    := Length(Values[npIntegral]) + Length(Values[npDecimal]);
        Precision := Length(Values[npDecimal]);
      end;
    nmExponent:
      begin
        if Length(Values[npExponent]) = 0 then
        begin
          Result := nmNone;
          Exit;
        end;
        eCount := StrToIntDef(Values[npExponent], 0);
        case ESChar[npExponent] of
          '+':
            begin
              Digits := Length(Values[npIntegral]);
              if Length(Values[npDecimal]) < eCount then
                Inc(Digits, eCount)
              else
                Inc(Digits, Length(Values[npDecimal]));
              Precision := _intMax(0, Length(Values[npDecimal]) - eCount);
            end;
          '-':
            begin
              Digits := Length(Values[npDecimal]);
              if Length(Values[npIntegral]) < eCount then
                Inc(Digits, eCount)
              else
                Inc(Digits, Length(Values[npIntegral]));
              Precision := Length(Values[npDecimal]) + eCount;
            end;
        end;
      end;
  end;
end;
{$HINTS ON}

function IsValidInteger(Value: string): boolean;
 var
  NumericFormat: TNumericFormat;
  Precision, Digits: integer;
begin
  NumericFormat := GetNumericFormat(PChar(Value), Precision, Digits);
  Result := (NumericFormat = nmInteger);
end;

function IsValidFloat(Value: string): boolean;
 var
  NumericFormat: TNumericFormat;
  Precision, Digits: integer;
begin
  NumericFormat := GetNumericFormat(PChar(Value), Precision, Digits);
  Result := (NumericFormat = nmInteger)  or (NumericFormat = nmDecimal)  or
    (NumericFormat = nmCurrency) or (NumericFormat = nmExponent);
end;

function IsValidCurrency(Value: string; APrecision: integer): boolean;
 var
  NumericFormat: TNumericFormat;
  Precision, Digits: integer;
begin
  NumericFormat := GetNumericFormat(PChar(Value), Precision, Digits);
  Result := (NumericFormat = nmCurrency) or (NumericFormat = nmInteger) or
    ((NumericFormat = nmDecimal) and ((APrecision = -1) or (Precision <= APrecision)));
end;

function CheckInteger(var Value: string; ADigits: integer): boolean;
 var
  NumericFormat: TNumericFormat;
  Precision, Digits: integer;
begin
  NumericFormat := GetNumericFormat(PChar(Value), Precision, Digits);
  Result := (NumericFormat = nmInteger) and 
   ((ADigits = -1) or (Digits <= ADigits));
end;

function CheckFloat(var Value: string; APrecision, ADigits: integer): boolean;
 var
  NumericFormat: TNumericFormat;
  Precision, Digits, i, LastDigit: integer;
begin
  NumericFormat := GetNumericFormat(PChar(Value), Precision, Digits);
  Result := ((NumericFormat = nmInteger)  or
             (NumericFormat = nmDecimal)  or
             (NumericFormat = nmCurrency) or
             (NumericFormat = nmExponent)) and
            ((ADigits = -1) or (Digits <= ADigits)) and
            ((APrecision = -1) or (Precision <= APrecision));
  if Result then
  begin
    case NumericFormat of
      nmInteger :
        begin
          if APrecision > 0 then
          begin
            Value := Value + DecimalSeparator;
            for i := 0 to APrecision - 1 do Value := Value + '0';
          end;
        end;
      nmCurrency, nmDecimal:
        for i := Precision to APrecision - 1 do Value := Value + '0';
    end;
  end
  else begin
    if (NumericFormat = nmDecimal) and (Precision > APrecision) then
    begin
      Result    := True;
      LastDigit := Digits - Precision + APrecision;
      Value  := Copy(Value, 1, LastDigit);
    end;
  end
end;

function CheckCurrency(var Value: string; APrecision, ADigits: integer): boolean;
 var
  NumericFormat: TNumericFormat;
  Precision, Digits, i: integer;
begin
  NumericFormat := GetNumericFormat(PChar(Value), Precision, Digits);
  Result := ((NumericFormat = nmCurrency) or (NumericFormat = nmInteger) or
    ((NumericFormat = nmDecimal) and 
    ((APrecision = -1) or (Precision <= APrecision)))) and
    ((ADigits = -1) or (Digits <= ADigits));
  if Result then
  begin
    case NumericFormat of
      nmInteger :
        begin
          Value := Value + DecimalSeparator;
          for i := 0 to CurrencyDecimals - 1 do Value := Value + '0';
        end;
      nmCurrency:
        for i := Precision to CurrencyDecimals - 1 do Value := Value + '0';
    end;
  end;
end;

function RecordCount2Str(Count: integer): string;
begin
  Result := LoadStr(RES_GRID_REC_ROOT);
  case (Count mod 10) of
    1..4:
      begin
        if (Count > 10) and (Count < 20) then
          Result := Result + LoadStr(RES_GRID_REC_VAL0)
        else begin
          if (Count mod 10) = 1 then
            Result := Result + LoadStr(RES_GRID_REC_VAL1)
          else
            Result := Result + LoadStr(RES_GRID_REC_VAL2);
        end;
      end;
    0,5..9: Result := Result + LoadStr(RES_GRID_REC_VAL0);
  end;
end;

function CreateEmptyRgn: HRGN;
 var
  R: TRect;
begin
  SetRectEmpty(R);
  Result := CreateRectrgnIndirect(R);
end;

procedure IncludeRectRgn(R: TRect; var Rgn: HRGN);
 var
  RectRgn: HRGN;
begin
  if (Rgn = RGN_ERROR) or (Rgn = NULLREGION) then
    Rgn := CreateEmptyRgn;
  RectRgn := CreateRectRgnIndirect(R);
  CombineRgn(Rgn, Rgn, RectRgn, RGN_OR);
  DeleteObject(RectRgn);
end;

procedure CreateSystemImages;
 var
  Bitmap: TBitmap;
  i: integer;

 const
  SMALL_IMAGE_PREFIX = 'DC_SMALL_IMAGE';
  LARGE_IMAGE_PREFIX = 'DC_LARGE_IMAGE';

  SMALL_IMAGE_COUNT  = 13;
  LARGE_IMAGE_COUNT  = 0;

begin
  Bitmap := TBitmap.Create;
  try
    i := 0;
    repeat
      Bitmap.LoadFromResourceName(HInstance, Format('%s%2.2d',
        [SMALL_IMAGE_PREFIX, i]));
      if i = 0 then
        SystemSmallImages := TImageList.CreateSize(Bitmap.Width, Bitmap.Height);
      SystemSmallImages.AddMasked(Bitmap, Bitmap.Canvas.Pixels[0,0]);
      inc(i);
    until i = SMALL_IMAGE_COUNT;
  finally
    FreeAndNil(Bitmap);
    SystemSmallImages.Overlay(0, 0);
    SystemSmallImages.Overlay(1, 1);
    SystemSmallImages.Overlay(2, 2);
    SystemSmallImages.Overlay(3, 3);
  end;
end;

procedure DestroySystemImages;
begin
  SystemSmallImages.Clear;
  FreeAndNil(SystemSmallImages);
end;

function ETGetSystemImages(Mode: integer): TImageList;
begin
  if Mode and DCGIM_SMALLICON <> 0 then
    Result := SystemSmallImages
  else
    Result := nil;
end;

procedure ETGetBitmap(Mode, Index: integer; ABitmap: TBitmap);
begin
  if Mode and DCGIM_SMALLICON <> 0 then
  begin
    SystemSmallImages.GetBitmap(Index, ABitmap);
  end;
end;

function IsRectEquals(R1, R2: TRect): boolean;
 var
  R: TRect;
begin
  if IntersectRect(R, R1, R2) then
    Result := not SubtractRect(R, R1, R2) and not SubtractRect(R, R2, R1)
  else
    Result := False;
end;

procedure CreatePolyLineStruct(var Struct: TPolyLineStruct; MaxCount: integer;
  AColor: TColor);
begin
  with Struct do
  begin
    Points  := AllocMem(MaxCount * SizeOf(TPoint) * 2);
    Strokes := AllocMem(MaxCount * SizeOf(Integer));
    _FillDWord(Strokes^, MaxCount, 2);
    Index := 0;
    Color := AColor;
    Capacity := MaxCount;
  end;
end;

procedure ClearPolyLineStruct(var Struct: TPolyLineStruct; AColor: TColor);
begin
  with Struct do
  begin
    _FillDWord(Strokes^, Index, 2);
    Index := 0;
    Color := AColor;
  end;
end;

procedure DestroyPolyLineStruct(var Struct: TPolyLineStruct);
begin
  with Struct do
  begin
    FreeMem(Points);
    FreeMem(Strokes);
    Capacity := 0;
    Index := 0;
  end;
end;

procedure AddPoint2Struct(var Struct: TPolyLineStruct; X1, Y1, X2, Y2: integer);
begin
  with Struct do
  begin
    Points^[Index] := X1;         { MoveTo }
    Points^[Index + 1] := Y1;
    Inc(Index, 2);

    Points^[Index] := X2;         { MoveTo }
    Points^[Index + 1] := Y2;
    Inc(Index, 2);
  end;
end;

procedure PaintPolyLine(DC: HDC; Struct: TPolyLineStruct;
  DrawMode: integer = R2_COPYPEN);
 var
  SavedPen, Pen: HPEN;
begin
  with Struct do
  begin
    Pen := CreatePen(PS_SOLID, 1, ColorToRGB(Color));
    SavedPen := SelectObject(DC, Pen);
    SetROP2(DC, DrawMode);
    try
      PolyPolyLine(DC, Points^, Strokes^, Index shr 2);
    finally
      SelectObject(DC, SavedPen);
      DeleteObject(Pen);
    end;
  end;
end;

{DIB Functions}

procedure InitDIBBitmapHeader(Bitmap: HBITMAP; var BI: TBitmapInfoHeader;
  Colors: Integer);
 var
  DS: TDIBSection;
begin
  DS.dsbmih.biSize := 0;
  GetObject(Bitmap, SizeOf(DS), @DS);
  FillChar(BI, sizeof(BI), 0);
  with BI, DS.dsbm do
  begin
    biSize := SizeOf(BI);
    biWidth := bmWidth;
    biHeight := bmHeight;
  end;
  BI.biBitCount := DS.dsbm.bmBitsPixel * DS.dsbm.bmPlanes;
  BI.biPlanes := 1;
  if BI.biClrImportant > BI.biClrUsed then BI.biClrImportant := BI.biClrUsed;
  if BI.biSizeImage = 0 then
    BI.biSizeImage := BytesPerScanLine(BI.biWidth, BI.biBitCount, 32) * Abs(BI.biHeight);
end;

procedure InitDIBBitmap(ADC: HDC; ABitmap: HBitmap; var DIBBitmap: TDIBBitmap);
begin
  with DIBBitmap do
  begin
    DC := ADC;
    Bitmap := ABitmap;
  end;
end;

procedure GetDIBBitmap(var DIBBitmap: TDIBBitmap);
begin
  with DIBBitmap do
  begin
    GetDIBSizes(Bitmap, InfoSize, BitsSize);
    GetMem(BitmapInfo, InfoSize);
    GetMem(Bits, BitsSize);
    InitDIBBitmapHeader(Bitmap, TBitmapInfoHeader(BitmapInfo.bmiHeader), 0);
    if DC <> 0 then
      GetDIBits(DC, Bitmap, 0, BitmapInfo.bmiHeader.biHeight, Bits, BitmapInfo^,
        DIB_RGB_COLORS);
  end;
end;

procedure FreeDIBBitmap(DIBBitmap: TDIBBitmap);
begin
  with DIBBitmap do
  begin
    FreeMem(Bits, BitsSize);
    FreeMem(BitmapInfo, InfoSize);
    if Bitmap <> 0 then DeleteObject(Bitmap);
    if DC <> 0 then DeleteDC(DC);
  end;
end;

function ColorToBGR(Color: integer): integer;
begin
  Result := (Color and $FF) shl 16 + Color and $FF00 + Color shr 16;
end;

procedure BITMAP_AlphaBlendB(var ADIBBitmap, BDIBBitmap: TDIBBitmap;
  Opacity: integer; Color: integer);
 var
  i, j, ha, wa, ka, hb, wb, kb: integer;
begin
  with ADIBBitmap.BitmapInfo^.bmiHeader do
  begin
    ha := biHeight;
    wa := biWidth;
  end;
  with BDIBBitmap.BitmapInfo^.bmiHeader do
  begin
    hb := biHeight;
    wb := biWidth;
  end;

  asm
    mov  ebx, Opacity
  end;
  Color := ColorToBGR(Color);
  for i := 0 to wb - 1 do
  begin
    for j := 0 to hb - 1 do
    begin
      kb := j * wb + i;
      if (j < ha) and (i < wa) then
      begin
        ka := j * wa + i;
        with BDIBBitmap.Bits[kb] do
        begin
          if ADIBBitmap.Bits[ka].Value <> DWORD(Color) then
            Value := GetBlendAttr(TColorValue(Value), ADIBBitmap.Bits[ka]);
        end;
      end;
    end;
  end;
  asm
    db  $0F, $77                     //   emms
  end
end;

procedure BITMAP_AlphaBlendC(var ADIBBitmap: TDIBBitmap; AColor: TColor;
  Opacity: integer; Color: integer);
 var
  i, j, ha, wa, ka, rgb: integer;
begin
  Color := ColorToBGR(Color);
  with ADIBBitmap.BitmapInfo^.bmiHeader do
  begin
    ha := biHeight;
    wa := biWidth;
  end;

  rgb := ColorToRGB(AColor);
  asm
    mov  ebx, Opacity
  end;
  for i := 0 to wa - 1 do
  begin
    for j := 0 to ha - 1 do
    begin
      ka := j * wa + i;
      with ADIBBitmap.Bits[ka] do if Value <> DWORD(Color) then
        Value := GetBlendAttr(ADIBBitmap.Bits[ka], TColorValue(rgb));
    end;
  end;
  asm
    db  $0F, $77                     //   emms
  end
end;

function BITMAP_GetRegion(DIBBitmap: TDIBBitmap; XForm: PXFORM;
  Color: integer): HRGN;
 var
  RgnData: PRGNDATA;
  p: PRectArray;
  h, w, x, x0, y, y1: integer;

  procedure CreateDataRgn(var DataRgn: HRGN);
   var
    Rgn: HRGN;
  begin
    Rgn := ExtCreateRegion(XForm,
       SizeOf(TRgnDataHeader) + SizeOf(TRect) * RgnData^.rdh.nCount, RgnData^);
    if DataRgn <> NULLREGION then
    begin
      CombineRgn(DataRgn, DataRgn, Rgn, RGN_OR);
      DeleteObject(Rgn);
    end
    else
      DataRgn := Rgn;
  end;

  procedure ClearRgnData;
  begin
    with RgnData^.rdh do
    begin
      dwSize := SizeOf(TRgnDataHeader);
      iType := RDH_RECTANGLES;
      nCount := 0;
      nRgnSize := 0;
      SetRect(rcBound, maxInt, maxInt, 0, 0);
    end;
  end;

begin
  Result := NULLREGION;
  RgnData := AllocMem(RgnDataSize);
  p := @RgnData^.Buffer;
  Color := ColorToBGR(Color);
  try
    ClearRgnData;
    h := DIBBitmap.BitmapInfo^.bmiHeader.biHeight;
    w := DIBBitmap.BitmapInfo^.bmiHeader.biWidth;
    for y := 0 to h - 1 do
    begin
      x := 0;
      while x < w do
      begin
        while (x < w) and
          (DIBBitmap.Bits[y * w + x].Value = DWORD(Color)) do Inc(x);

        x0 := x;
        while (x < w) and
          (DIBBitmap.Bits[y * w + x].Value <> DWORD(Color)) do Inc(x);

        if x <> x0 then with RgnData^.rdh do
        begin
          y1 := h - y - 1;
          SetRect(p[nCount], x0, y1, x, y1 + 1);
          with rcBound do
          begin
            Left   := _intMin(Left, x0);
            Top    := _intMin(Top, y1);
            Right  := _intMax(Right, x);
            Bottom := _intMax(Bottom, y1 + 1);
          end;

          inc(nCount);
          if nCount >= MaxRgnDataRects then
          begin
            CreateDataRgn(Result);
            ClearRgnData;
          end;
        end;
      end;
    end;
    if RgnData^.rdh.nCount > 0 then CreateDataRgn(Result);
  finally
    FreeMem(RgnData);
  end;
end;

initialization
  CreateSystemImages;
  ABitmap := TBitmap.Create;

  if CpuInfo.MMX then
  begin
    GetBlendAttr := mmx_GetBlendAttr;
    GetAvergAttr := mmx_GetAvergAttr;
  end
  else begin
    GetBlendAttr := nox_GetBlendAttr;
    GetAvergAttr := nox_GetAvergAttr;
  end;


finalization
  FreeAndNil(ABitmap);
  DestroySystemImages;

end.
