{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x
         Copyright (c) 1998-2000 Alex'EM

}
unit DCEditButton;
{$I DCConst.inc}

interface

uses
  Windows, SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  ImgList, Dialogs, StdCtrls, DCEditTools, Forms, ComCtrls, DCConst;

const
  // EditButton flags
  EB_AUTOSIZE      = $01;
  EB_DOWNSTATE     = $02;
  EB_BUTTONDOWN    = $03;
  EB_DRAWTEXT      = $04;
  EB_ENABLED       = $05;
  EB_DOWNCLICK     = $06;
  EB_GROUPED       = $07;
  EB_MOUSEINCTRL   = $08;
  EB_RESETONEXIT   = $09;
  EB_ABSOLUTEPOS   = $0A;
  EB_VISIBLE       = $0B;
  EB_WORDWRAP      = $0C;
  EB_GLYPHEXIST    = $0D;

  // ComboButton flags

  // EditButtons flags
  BS_ACTIVE        = $01;
  BS_BUTTONDOWN    = $02;
  BS_MOUSEINCTRL   = $03;
  BS_PROCCLEAR     = $04;
  BS_KEYMOVING     = $05;

type
  PButtonInfo = ^TButtonInfo;
  TButtonInfo = packed record
    Alignment  : WORD;
    Tag        : integer;
    Style      : WORD;
    EvtStyle   : WORD;
    Top        : smallint;
    Left       : smallint;
    Height     : smallint;
    Width      : smallint;
    ImageIndex : integer;
    Enabled    : boolean;
    Grouped    : boolean;
    AncStyle   : WORD;
    DisStyle   : WORD;
    AbsolutePos: boolean;
    ResetOnExit: boolean;
  end;

  TEBHintEvent  = procedure (Sender: TObject; Mode:integer) of object;
  TEBCheckArea  = procedure (Sender: TObject; X, Y: integer;
    var Selected: boolean) of object;
  TEBGetRegion  = procedure (Sender: TObject; var Rgn: HRGN) of object;
  TEBSetState  =  procedure (Sender: TObject; var State: TButtonState) of object;

  TDCEditButtons = class;
  TEditButtonClass = class of TDCEditButton;

  TButtonOption = (boDrawText, boHighlight, boFlatPattern, boFocusSensitive,
    boTransparent, boSimpleStyle, boFrame, boDoubleBuffered, boSelectable,
    boFrameInRest, boStateRegardless);
  TButtonOptions = set of TButtonOption;
  TButtonTypeDrawStyle = (dsDrawAll, dsDrawTRN, dsDrawNotTRN);

  TDCButtonAction = (acChanged, acVisibleChanged, acBoundsChanged, acAdd,
    acRemove, acImageChanged, acEnabledChanged, acStateChanged, acFontChanged,
    acDestroy);
  TDCEditButton = class;

  IDCButtonHolder = interface(IUnknown)
    ['{6154AE41-A7D4-42A1-AE80-8BA4628757CB}']
    function AddButtonEx(EditButtonClass: TEditButtonClass;
      Data: integer): TDCEditButton;
    procedure BeginUpdate;
    function ButtonVisible(Sender: TDCEditButton): boolean;
    procedure EndUpdate;
    function GetActiveButton: TDCEditButton;
    function GetButton(Index: integer): TDCEditButton;
    function GetButtonsRect: TRect;
    function GetCanvas: TCanvas;
    function GetCount: integer;
    function GetFlagValue(const Index: Integer): boolean;
    function GetFocusedButton: TDCEditButton;
    function GetMaxImageWidth: integer;
    function GetWinControl: TWinControl;
    function GetRegion: HRGN;
    procedure Invalidate;
    procedure MoveButton(CurIndex, NewIndex: integer);
    procedure Notify(Button: TDCEditButton; Action: TDCButtonAction);
    procedure OffsetButtons(Pos: TPoint);
    procedure PaintBackground(ARect: TRect; AButton: TDCEditButton;
      ACanvas: TCanvas);
    procedure SetActiveButton(const Value: TDCEditButton);
    procedure SetButton(Index: integer; const Value: TDCEditButton);
    procedure SetFocusedButton(const Value: TDCEditButton);
    function UpdateCount: integer;
    property ActiveButton: TDCEditButton read GetActiveButton
      write SetActiveButton;
    property Canvas: TCanvas read GetCanvas;
    property Count: integer read GetCount;
    property Items[Index: integer]: TDCEditButton read GetButton write SetButton;
    property MaxImageWidth: integer read GetMaxImageWidth;
    property Owner: TWinControl read GetWinControl;
    property FocusedButton: TDCEditButton read GetFocusedButton
      write SetFocusedButton;
  end;

  TDCCoordValue = (cvLeft, cvTop, cvWidth, cvHeight);
  TDCCoordValues = packed array[TDCCoordValue] of smallint;

  TDCEditButton = class(TPersistent)
  private
    FAlignment: TButtonAlignment;
    FAnchorStyle: TAnchorStyle;
    FBrushColor: TColor;
    FButtonState: TButtonState;
    FButtonHolder: IDCButtonHolder;
    FComment: string;
    FCoordValues: TDCCoordValues;
    FDisableStyle: TDisableStyle;
    FEventStyle: TEventStyle;
    FFlags: DWORD;
    FFont: TFont;
    FGlyph: TBitmap;
    FHint: string;
    FImageIndex: integer;
    FImages: TCustomImageList;
    FIndex: integer;
    FName: string;
    FOnCheckArea: TEBCheckArea;
    FOnClick: TNotifyEvent;
    FOnDrawHint: TEBHintEvent;
    FOnSetButtonState: TEBSetState;
    FOptions: TButtonOptions;
    FOwner: TWinControl;
    FSelectColor: TColor;
    FStyle: TButtonStyle;
    FTag: integer;
    FText: string;
    FTextSize: TPoint;
    FVisibleWidth: WORD;
    function GetGlyph: TBitmap;
    procedure SetGlyph(Value: TBitmap);
    procedure DrawHint(Mode: integer);
    procedure DrawTransformBitmap(ACanvas: TCanvas; ImageRect: TRect;
      Style: TTransformStyle);
    procedure SetText(Value:string);
    procedure SetAlignment(Value:TButtonAlignment);
    procedure SetButtonState(Value:TButtonState);
    procedure SetMouseInControl(const Index: Integer; const Value: boolean);
    procedure SetEnabled(const Index: Integer; const Value: boolean);
    procedure SetVisible(const Value: boolean);
    function GetWidth: integer;
    procedure SetImages(const Value: TCustomImageList);
    procedure SetImageIndex(const Value: integer);
    procedure SetFont(const Value: TFont);
    function IsEqual(Button: TDCEditButton): Boolean;
    procedure SetWidth(const Value: integer);
    procedure SetDownClick(const Index: Integer; const Value: boolean);
    procedure SetStyle(const Value: TButtonStyle);
    procedure SetSelectColor(const Value: TColor);
    procedure SetOptions(const Value: TButtonOptions);
    procedure SetIndex(const Value: integer);
    procedure FontChanged(AFont: TObject);
    procedure SetWordWrap(const Index: Integer; const Value: boolean);
    procedure SetFlagValue(const Index: Integer; const Value: boolean);
    function GetFlagValue(const Index: Integer): boolean;
    function GetCoordValue(const Index: Integer): integer;
    procedure SetCoordValue(const Index, Value: integer);
  protected
    function AssignedImages: boolean;
    procedure BeginDrawText(ACanvas: TCanvas; ATextRect: TRect;
      AState: TButtonState); virtual;
    procedure BeginDrawBkgn(ACanvas: TCanvas; ARect: TRect; AState: TButtonState;
      var ImageRect: TRect; var TextRect: TRect); virtual;
    procedure Changed; virtual;
    procedure DrawBkgnd(ACanvas: TCanvas; Rect: TRect); virtual;
    procedure DrawBitmap(ACanvas: TCanvas; ImageRect: TRect); virtual;
    procedure DrawEditText(ACanvas: TCanvas; var TextRect: TRect); virtual;
    procedure DrawLiteDisableBitmap(ACanvas: TCanvas; ImageRect: TRect);
    procedure DrawNormDisableBitmap(ACanvas: TCanvas; ImageRect: TRect);
    procedure DrawTranDisableBitmap(ACanvas: TCanvas; ImageRect: TRect);
    function GetEditButtons: IDCButtonHolder;
    function GetVisible: boolean; virtual;
    function OneClickButton: boolean; virtual;
    procedure ResetFlags; virtual;
    function WMSetCursor(var Message: TWMSetCursor;
      X, Y: integer): boolean; virtual;
    function StateChanged(OldState: TButtonState;
      var NewState: TButtonState): boolean; virtual;
  public
    constructor Create(AOwner: TComponent); virtual;
    destructor Destroy; override;
    procedure AdjustWidth(AWidth: integer);
    procedure Paint(DrawContext: HDC; Clip: HRGN = NULLREGION;
      SkipClipping: boolean = False); virtual;
    procedure DoPaint(ACanvas: TCanvas; ARect: TRect;
     SkipClipping: boolean = False); virtual;
    procedure DrawBorder(ACanvas: TCanvas; ARect: TRect); virtual;
    procedure SetBounds(ARect: TRect);
    function UpdateButtonState(X, Y: integer;
      ADown, AMove: boolean): boolean; virtual;
    function  MouseInRect(X, Y: integer): boolean;
    procedure ResetProperties;
    function GetImageRect: TRect;
    function GetTextRect(IRect: TRect): TRect;
    function GetImageOffset: TPoint; virtual;
    function GetTextOffset: TPoint; virtual;
    procedure Invalidate;
    procedure Click; virtual;
    function GetGlyphHeight: integer;
    function GetGlyphWidth: integer;
    function GetBounds: TRect;
    function GetBoundsEx: TRect;
    function GetTextSize: TPoint; virtual;
    procedure Notify(Action: TDCButtonAction);
    procedure ReadData(Stream: TStream; Info: PButtonInfo); virtual;
    procedure WriteData(Stream: TStream; Info: PButtonInfo); virtual;
    procedure SetButtonHolder(Value: IDCButtonHolder); virtual;
    property AbsolutePos: boolean index EB_ABSOLUTEPOS read GetFlagValue
      write SetFlagValue;
    property Alignment: TButtonAlignment read FAlignment write SetAlignment;
    property AnchorStyle: TAnchorStyle read FAnchorStyle write FAnchorStyle;
    property AutoSize: boolean index EB_AUTOSIZE read GetFlagvalue write
      SetFlagValue;
    property BrushColor: TColor read FBrushColor write FBrushColor;
    property ButtonState: TButtonState read FButtonState write SetButtonState;
    property Caption: string read FText write SetText;
    property Comment: string read FComment write FComment;
    property DisableStyle: TDisableStyle read FDisableStyle write FDisableStyle;
    property DownClick: boolean index EB_DOWNCLICK read GetFlagValue write
      SetDownClick;
    property DownButton: boolean index EB_BUTTONDOWN read GetFlagValue write
      SetFlagValue;
    property DrawText: boolean index EB_DRAWTEXT read GetFlagValue write SetFlagValue;
    property Enabled: boolean index EB_ENABLED read GetFlagValue write
      SetEnabled;
    property EventStyle: TEventStyle read FEventStyle write FEventStyle;
    property Font: TFont read FFont write SetFont;
    property Glyph: TBitmap read GetGlyph write SetGlyph;
    property Grouped: boolean index EB_GROUPED read GetFlagValue write SetFlagValue;
    property Height: integer index cvHeight read GetCoordValue write SetCoordValue;
    property Hint: string read FHint write FHint;
    property ImageIndex: integer read FImageIndex write SetImageIndex;
    property Images: TCustomImageList read FImages write SetImages;
    property Index: integer read FIndex write SetIndex;
    property Left: integer index cvLeft read GetCoordValue write SetCoordValue;
    property MouseInControl: boolean index EB_MOUSEINCTRL read GetFlagValue write
      SetMouseInControl;
    property Name: string read FName write FName;
    property OnCheckArea: TEBCheckArea read FOnCheckArea write FOnCheckArea;
    property OnClick: TNotifyEvent read FOnClick write FOnClick;
    property OnDrawHint: TEBHintEvent read FOnDrawHint write FOnDrawHint;
    property OnSetButtonState: TEBSetState read FOnSetButtonState write
      FOnSetButtonState;
    property Options: TButtonOptions read FOptions write SetOptions;
    property Owner: TWinControl read FOwner;
    property ButtonHolder: IDCButtonHolder read FButtonHolder;
    property ResetOnExitControl: boolean index EB_RESETONEXIT read
      GetFlagValue write SetFlagValue;
    property SelectColor: TColor read FSelectColor write SetSelectColor;
    property Style: TButtonStyle read FStyle write SetStyle;
    property Tag: integer read Ftag write FTag;
    property TextSize: TPoint read FTextSize;
    property Text: string read FText write SetText;
    property Top: integer index cvTop read GetCoordValue write SetCoordValue;
    property Visible: boolean read GetVisible write SetVisible;
    property Width: integer read GetWidth write SetWidth;
    property WordWrap: boolean index EB_WORDWRAP read GetFlagValue write
      SetWordWrap;
  end;

  TDCHintButton = class(TDCEditButton)
  public
    constructor Create(AOwner: TComponent); override;
    procedure DrawBorder(ACanvas: TCanvas; ARect: TRect); override;
    function GetTextSize: TPoint; override;
  end;

  TCheckDrawInfo = record
    PenColor: TColor;
    BrushColor: TColor;
    FrameColor: TColor;
  end;

  TDCCheckButton = class(TDCEditButton)
  private
    FAlignment: TLeftRight;
    FAllowGrayed: Boolean;
    FCheckBoxSize: integer;
    FState: TCheckBoxState;
    procedure SetAlignment(const Value: TLeftRight);
    procedure SetState(const Value: TCheckBoxState);
  protected
    procedure Changed; override;
    procedure GetCheckDrawInfo(var DrawInfo: TCheckDrawInfo);
    procedure DrawCheckBox(ACanvas: TCanvas; ARect: TRect); virtual;
    procedure DrawEditText(ACanvas: TCanvas; var TextRect: TRect); override;
    function GetChecked: Boolean; virtual;
    function GetStateRect(R: TRect): TRect; virtual;
    procedure InvalidateState; virtual;
    procedure SetChecked(const Value: Boolean); virtual;
    function Toggle: boolean; virtual;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Click; override;
    procedure DrawBorder(ACanvas: TCanvas; ARect: TRect); override;
    function GetTextSize: TPoint; override;
    property Alignment: TLeftRight read FAlignment write SetAlignment;
    property AllowGrayed: Boolean read FAllowGrayed write FAllowGrayed;
    property BoxSize: integer read FCheckBoxSize;
    property Checked: Boolean read GetChecked write SetChecked;
    property State: TCheckBoxState read FState write SetState
      default cbUnchecked;
  end;

  TDCRadioButton = class(TDCCheckButton)
  protected
    function GetStateRect(R: TRect): TRect; override;
    procedure DrawCheckBox(ACanvas: TCanvas; ARect: TRect); override;
    procedure Changed; override;
    function Toggle: boolean; override;
  public
    constructor Create(AOwner: TComponent); override;
  end;

  TDCTextButton = class(TDCEditButton)
  public
    constructor Create(AOwner: TComponent); override;
    procedure DrawBorder(ACanvas: TCanvas; ARect: TRect); override;
    function GetTextSize: TPoint; override;
  end;

  TDCLinkButton = class(TDCTextButton)
  protected
    procedure BeginDrawText(ACanvas: TCanvas; ATextRect: TRect;
      AState: TButtonState); override;
    function WMSetCursor(var Message: TWMSetCursor;
      X, Y: integer): boolean; override;
  public
    constructor Create(AOwner: TComponent); override;
  end;

  TButtonHolderOptions = set of (boAbsolutePos, boNCPainting,
    boDrawButtons);

  TEditButtonsState = set of (esDestroying);

  TDCEditButtons = class(TPersistent, IDCButtonHolder)
  private
    FActiveButton: TDCEditButton;
    FAnchorStyle: TAnchorStyle;
    FBkgImage: TBitmap;
    FButtons: TList;
    FCanvas: TCanvas;
    FColor: TColor;
    FControlState: TEditButtonsState;
    FDefWndProc: Pointer;
    FFlags: DWORD;
    FFocusedButton: TDCEditButton;
    FImages: TCustomImageList;
    FMaxImageWidth: integer;
    FNewWndProc: Pointer;
    FOnChange: TNotifyEvent;
    FOnGetRegion: TEBGetRegion;
    FOptions: TButtonHolderOptions;
    FOwner: TWinControl;
    FUpdateCount: integer;
    procedure EditWndProc(var Message: TMessage);
    procedure SetButton(Index: integer; const Value: TDCEditButton);
    function GetEnabled: boolean;
    procedure SetEnabled(const Value: boolean);
    procedure SetImages(const Value: TCustomImageList);
    procedure UpdateIndex;
    procedure SetColor(const Value: TColor);
    function GetSelectedButton: TDCEditButton;
    procedure SetActiveButton(const Value: TDCEditButton);
    procedure DoChangeFocus;
    function GetButtonsActive: boolean;
    procedure SetButtonState(Button: TDCEditButton; Select: boolean);
    function UpdateButtonsOnClick(X, Y: integer; AMove: boolean): boolean; virtual;
    function GetActiveButton: TDCEditButton;
    function GetWinControl: TWinControl;
    function GetMaxImageWidth: integer;
    procedure SetFlagValue(const Index: Integer; const Value: boolean);
    function GetCanvas: TCanvas;
    procedure SetFocusedButton(const Value: TDCEditButton);
    function GetFocusedButton: TDCEditButton;
  private
    procedure ReadData(Stream: TStream); virtual;
    procedure WriteData(Stream: TStream); virtual;
  protected
    function _AddRef: Integer; stdcall;
    function _Release: Integer; stdcall;
    function ButtonVisible(Sender: TDCEditButton): boolean;
    procedure DefineProperties(Filer: TFiler); override;
    procedure Destroying; virtual;
    procedure DoChange; virtual;
    function DoKeyDown(var Message: TMessage): boolean;
    function GetButton(Index: integer): TDCEditButton; virtual;
    function GetCount: integer; virtual;
    function GetValidButton(Index: integer; MovingDown: boolean): TDCEditButton;
    procedure Notify(Button: TDCEditButton; Action: TDCButtonAction); virtual;
    function NeedSaveBackground: boolean; virtual;
    procedure OffsetButtons(Pos: TPoint); virtual;
    function QueryInterface(const IID: TGUID; out Obj): HResult; virtual; stdcall;
    procedure SetActiveIndex(Index: integer; MovingDown: boolean);
    procedure SetFocusedIndex(Index: integer; MovingDown: boolean);
  public
    function AddButton: TDCEditButton;
    function AddButtonEx(EditButtonClass: TEditButtonClass;
      Data: integer = 0): TDCEditButton;
    procedure BeginUpdate;
    procedure Clear;
    procedure ClrWndProc;
    constructor Create(AOwner: TWinControl); virtual;
    destructor Destroy; override;
    procedure DeleteButton(Index: integer);
    procedure EndUpdate;
    function FindButton(AName: string): TDCEditButton;
    function GetButtonsRect: TRect;
    function GetFlagValue(const Index: Integer): boolean;
    function GetRegion: HRGN;
    procedure Invalidate;
    function IsButtonAccel(VK: Word; var Button: TDCEditButton): Boolean;
    procedure KeyDown(var Key: Word; Shift: TShiftState); dynamic;
    procedure MoveButton(CurIndex, NewIndex: integer);
    function MouseInButtonArea(XPos, YPos: integer;
      var Button: TDCEditButton): boolean;
    procedure PaintBackground(ARect: TRect; AButton: TDCEditButton;
      ACanvas: TCanvas);
    procedure RepaintButtons(ADrawStyle: TButtonTypeDrawStyle;
      DrawContext: HDC; AClip: HRGN = NULLREGION); virtual;
    procedure ResetProperties;
    procedure SaveBackground(DrawContext: HDC);
    procedure SelectMoveBy(AButton: TDCEditButton; Delta: integer; Focused: boolean);
    procedure SetWndProc;
    function UpdateButtons(XPos, YPos: integer; ADown, AMove: boolean): boolean;
    function UpdateCount: integer;
    procedure UpdateDeviceRegion(DC: HDC); virtual;
    procedure UpdateMouseInControl(Value: boolean);
    procedure UpdateMaxImageWidth;
    property Active: boolean index BS_ACTIVE read GetFlagValue write
      SetFlagValue;
    property ActiveButton: TDCEditButton read GetActiveButton
      write SetActiveButton;
    property AnchorStyle: TAnchorStyle read FAnchorStyle write FAnchorStyle;
    property Buttons[Index: integer]: TDCEditButton read GetButton write SetButton;
    property Canvas: TCanvas read GetCanvas;
    property Color: TColor read FColor write SetColor;
    property Count: integer read GetCount;
    property Enabled: boolean read GetEnabled write SetEnabled;
    property FocusedButton: TDCEditButton read GetFocusedButton
      write SetFocusedButton;
    property KeyMoving: boolean index BS_KEYMOVING read GetFlagValue;
    property IsButtonsActive: boolean read GetButtonsActive;
    property Images: TCustomImageList read FImages write SetImages;
    property Items[Index: integer]: TDCEditButton read GetButton write SetButton;
    property MaxImageWidth: integer read GetMaxImageWidth;
    property MouseDown: boolean index BS_BUTTONDOWN read GetFlagValue write
      SetFlagValue;
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
    property OnGetRegion: TEBGetRegion read FOnGetRegion write FOnGetRegion;
    property Options: TButtonHolderOptions read FOptions write FOptions;
    property Owner: TWinControl read GetWinControl;
    property SelectedButton: TDCEditButton read GetSelectedButton;
  end;

const
  BT_MARGINS      = 3;   //       
  BT_IMAGEOFFSET  = 3;   //      

procedure HookMouseHooks(AButtons: TDCEditButtons);
procedure UnhookMouseHooks;

implementation
uses
  DCResource, DCPopupWindow;

type
  TWinControlCracker = class(TWinControl)
    {for implement protected properties and functions}
  end;

var
  UserBitmap, GlyphBitmap: TBitmap;
  MouseHook: HHOOK;
  HookButtons: TDCEditButtons;
  HookCount: integer;

function GetMouseHook(nCode: Integer; wParam: Longint;
  var Msg: TMsg): Longint; stdcall;
begin
  Result := CallNextHookEx(MouseHook, nCode, wParam, Longint(@Msg));
  if (nCode >= 0) and (Application <> nil) and (HookButtons <> nil)then
  with Msg do
  begin
    if Message = WM_LBUTTONUP then
    begin
      HookButtons.UpdateButtons(-1, -1, False, False);
    end
  end;
end;

procedure HookMouseHooks(AButtons: TDCEditButtons);
begin
  if MouseHook = 0 then
  begin
    MouseHook := SetWindowsHookEx(WH_GETMESSAGE, @GetMouseHook, 0,
      GetCurrentThreadID);
    HookButtons := AButtons;
  end;
  Inc(HookCount);
end;

procedure UnhookMouseHooks;
begin
  if HookCount > 0 then Dec(HookCount);
  if HookCount = 0 then
  begin
    if MouseHook <> 0 then UnhookWindowsHookEx(MouseHook);
    MouseHook := 0;
  end;
end;

constructor TDCEditButton.Create(AOwner: TComponent);
begin
  inherited Create;
  FName := 'Button';

  FOwner := AOwner as TWinControl;

  FFont := TFont.Create;
  FFont.OnChange := FontChanged;

  FButtonState   := btRest;

  FEventStyle := esNormal;
  FAlignment := abCenter;
  FDisableStyle := deLite;
  FImageIndex := -1;

  FButtonHolder := nil;

  FOptions := [boHighlight, boDoubleBuffered, boSelectable];

  FSelectColor := clXPSelected;

{
  _setFlag(FFlags, EB_AUTOSIZE, False);
  _setFlag(FFlags, EB_DOWNSTATE, False);
  _setFlag(FFlags, EB_BUTTONDOWN, False);
  _setFlag(FFlags, EB_DRAWTEXT, True);
  _setFlag(FFlags, EB_ENABLED, True);
  _setFlag(FFlags, EB_DOWNCLICK, False);
  _setFlag(FFlags, EB_GROUPED, False);
  _setFlag(FFlags, EB_MOUSEINCTRL, False);
  _setFlag(FFlags, EB_RESETONEXIT, True);
  _setFlag(FFlags, EB_VISIBLE, True);
  _setFlag(FFlags, EB_GLYPHEXIST, False);
}
  FFlags := $A30;
end;

destructor TDCEditButton.Destroy;
begin
  Notify(acDestroy);
  FreeAndNil(FFont);
  if _getFlag(FFlags, EB_GLYPHEXIST) then FreeAndNil(FGlyph);
  inherited;
end;

procedure TDCEditButton.SetBounds(ARect: TRect);
begin
  with ARect do
  begin
    FCoordValues[cvLeft] := Left;
    FCoordValues[cvTop] := Top;
    FCoordValues[cvWidth] := Right;
    FCoordValues[cvHeight] := Bottom;
  end;
  Notify(acBoundsChanged);
end;

function TDCEditButton.MouseInRect(X, Y: integer): boolean;
begin
  if Visible then
    Result := PtInRect(Rect(FCoordValues[cvLeft], FCoordValues[cvTop],
      FCoordValues[cvLeft] + FCoordValues[cvWidth],
      FCoordValues[cvTop] + FCoordValues[cvHeight]),
      Point(X,Y))
  else
    Result := False;
  if Assigned(FOnCheckArea) then FOnCheckArea(Self, X, Y, Result)
end;

function TDCEditButton.UpdateButtonState( X, Y: integer;
  ADown, AMove: boolean): boolean;
 var
  OButtonState: TButtonState;
  ClickButton: boolean;
begin
  OButtonState := FButtonState;
  ClickButton  := False;

  if (Caption = MenuLineCaption) or not Visible then
  begin
    ButtonState := btRest;
    Result := False;
    Exit;
  end;

  if not Enabled then
  begin
    if MouseInRect(X, Y) then
      ButtonState := btRestMouseInRect
    else
      ButtonState := btRest;
  end
  else begin
    case FEventStyle of
      esNormal  :
        begin
          if MouseInRect(X, Y)
          then
            if not AMove then
            begin
              if ADown then
              begin
                 ButtonState := btDownMouseInRect;
                 _setFlag(FFlags, EB_DOWNSTATE, True);
              end
              else begin
                ButtonState := btRestMouseInRect;
                if _getFlag(FFlags, EB_DOWNSTATE) or OneClickButton then
                  if ButtonState <> OButtonState then ClickButton := True;
              end
            end
            else begin
              if ADown and _getFlag(FFlags, EB_DOWNSTATE) then
                 ButtonState := btDownMouseInRect
              else begin
                ButtonState := btRestMouseInRect;
                _setFlag(FFlags, EB_DOWNSTATE, False);
              end;
            end
          else begin
            ButtonState := btRest;
          end;
          if not ADown and not AMove then _setFlag(FFlags, EB_DOWNSTATE, False);
        end;
      esDropDown:
        begin
          if _getFlag(FFlags, EB_DOWNCLICK) then
          begin
            if MouseInRect(X, Y) then
              if not AMove then
              begin
                if ADown then
                begin
                   ButtonState := btDownMouseInRect;
                   _setFlag(FFlags, EB_DOWNSTATE, True);
                end
                else begin
                  if _getFlag(FFlags, EB_DOWNSTATE) or OneClickButton then
                  begin
                    _xorFlag(FFlags, EB_BUTTONDOWN);
                    if _getFlag(FFlags, EB_BUTTONDOWN) then
                    begin
                      ButtonState := btDownMouseInRect;
                      if ButtonState = btDownMouseInRect then 
                        Click
                      else
                        _xorFlag(FFlags, EB_BUTTONDOWN);
                    end
                    else begin
                      ButtonState := btRestMouseInRect;
                      if ButtonState = btRestMouseInRect then 
                        Click
                      else
                        _xorFlag(FFlags, EB_BUTTONDOWN);
                    end;
                  end;
                end
              end
              else begin
                if (ADown and _getFlag(FFlags, EB_DOWNSTATE)) or
                  _getFlag(FFlags, EB_BUTTONDOWN) then
                  ButtonState := btDownMouseInRect
                else begin
                  if not ADown then
                    ButtonState := btRestMouseInRect
                  else
                    ButtonState := btRest;
                  _setFlag(FFlags, EB_DOWNSTATE, False);
                end;
              end
            else begin
              if _getFlag(FFlags, EB_BUTTONDOWN) then
                ButtonState := btDownMouseInRect
              else begin
                if _getFlag(FFlags, EB_DOWNSTATE) then
                begin
                  if _getFlag(FFlags, EB_BUTTONDOWN) then
                    ButtonState := btDownMouseInRect
                  else
                    if not AMove then
                      ButtonState := btRest
                    else
                      ButtonState := btRestMouseInRect;
                end
                else
                  ButtonState := btRest;
              end;
            end;
            if not ADown and not AMove then
              _setFlag(FFlags, EB_DOWNSTATE, False);
          end
          else begin
            if MouseInRect(X,Y) then
            begin
              if ADown then
              begin
                if not AMove then
                begin
                  case FButtonState of
                    btDownMouseInRect :
                      begin
                        ButtonState := btRestMouseInRect;
                        if Buttonstate = btRestMouseInRect then ClickButton := True;
                      end;
                    btRestMouseInRect,
                    btRest :
                      begin
                        ButtonState := btDownMouseInRect;
                        if Buttonstate = btDownMouseInRect then ClickButton := True;
                      end;
                  end;
                end
              end
              else if FButtonState <> btDownMouseInRect then
              begin
                ButtonState := btRestMouseInRect;
              end
            end
            else
              if FButtonState <> btDownMouseInRect then
              begin
                ButtonState := btRest;
              end
          end;
        end;
    end;
  end;
  if OButtonState <> FButtonState then
  begin
    if not( (OButtonState in [btRestMouseInRect, btRest]) and
            (FButtonState in [btRestMouseInRect, btRest]) and
            ((FStyle = stNormal) or _getFlag(FFlags, EB_MOUSEINCTRL))
          ) then
    begin
      Result := StateChanged(OButtonState, FButtonState);
    end
    else
      Result := False;

  end else
    Result := False;

  if ClickButton then Click;

end;

procedure TDCEditButton.SetGlyph(Value: TBitmap);
begin
  Glyph.Assign(Value);
  invalidate;
end;

function TDCEditButton.GetGlyph: TBitmap;
begin
  if not _getFlag(FFlags, EB_GLYPHEXIST) then
  begin
    FGlyph := TBitmap.Create;
    FGlyph.Transparent := True;
    _setFlag(FFlags, EB_GLYPHEXIST, True)
  end;
  Result := FGlyph;
end;

procedure TDCEditButton.Paint(DrawContext: HDC; Clip: HRGN = NULLREGION;
  SkipClipping: boolean = False);
 var
  Clip1: HRGN;
  LogFont: TLogFont;
  pFont0: HFONT;
  ABitmap: TBitmap;
  Index: integer;
  ACanvas: TCanvas;

  procedure PaintFinalize;
  begin
    if not SkipClipping then
    begin
      if DrawContext = 0 then
      begin
        ReleaseDC(FOwner.Handle, ACanvas.Handle);
        ACanvas.Handle := 0;
      end
      else begin
        ACanvas.Handle := 0;
        RestoreDC(DrawContext, Index);
      end
    end
    else begin
      if DrawContext = 0 then ACanvas.Handle := 0;
    end;
    if not IsRegionEmpty(Clip1) then DeleteObject(Clip1);
    if not Assigned(FButtonHolder) then FreeAndNil(ACanvas);
  end;

  function DoubleBuffered: boolean;
  begin
    Result := boDoubleBuffered in Options;
    if (Result and SkipClipping) and Assigned(FButtonHolder) then
      Result := not FButtonHolder.Owner.DoubleBuffered;
  end;

begin
  if not Visible or not FOwner.HandleAllocated or (FCoordValues[cvWidth] < 0) or
    (FCoordValues[cvHeight] < 0) then Exit;

  if Assigned(FButtonHolder) then
    ACanvas := FButtonHolder.Canvas
  else begin
    ACanvas := TCanvas.Create;
  end;

  if not SkipClipping then
  begin
    Index := 0;
    if DrawContext = 0 then
      ACanvas.Handle := GetWindowDC(Owner.Handle)
    else begin
      ACanvas.Handle := DrawContext;
      Index := SaveDC(DrawContext);
    end;

    if Assigned(FButtonHolder) then
      Clip1 := FButtonHolder.GetRegion
    else
      Clip1 := NULLREGION;

    if not IsRegionEmpty(Clip1) then
    begin;
      if not IsRegionEmpty(Clip) then
        CombineRgn(Clip, Clip1, Clip, RGN_AND)
      else
        Clip := Clip1;
    end;

    if not IsRegionEmpty(Clip) then SelectClipRgn(ACanvas.Handle, Clip);

  end
  else begin
    if DrawContext = 0 then
      ACanvas.Handle := GetWindowDC(Owner.Handle)
    else begin
      ACanvas.Handle := DrawContext;
    end;
  end;

  if not RectVisible(ACanvas.Handle, GetBounds) then
  begin
    PaintFinalize;
    Exit;
  end;

  try
    if not SkipClipping and DoubleBuffered then
    begin
      ABitmap := TBitmap.Create;
      ABitmap.Width  := FCoordValues[cvWidth];
      ABitmap.Height := FCoordValues[cvHeight];
      try
        DoPaint(ABitmap.Canvas, Rect(0, 0, FCoordValues[cvWidth],
          FCoordValues[cvHeight]), SkipClipping);
        ACanvas.Draw(FCoordValues[cvLeft], FCoordValues[cvTop], ABitmap);
      finally
        ABitmap.Free;
      end;
    end
    else begin
      GetObject(FFont.Handle, SizeOf(TLogFont), @LogFont);
      pFont0 := CreateFontIndirect(LogFont);
      SelectObject(ACanvas.Handle, pFont0);
      DoPaint(ACanvas, GetBounds, SkipClipping);
      DeleteObject(pFont0);
    end;
  finally
    PaintFinalize;
  end;
end;

procedure TDCEditButton.DrawEditText(ACanvas: TCanvas; var TextRect: TRect);
 const
  DTWordBreak: array[boolean] of integer = (0, DT_WORDBREAK);
 var
  AText: string;
  ATextRect: TRect;
  Offs: TPoint;
  DrawFlag: WORD;
begin
  if FText = '' then Exit;
  if Caption <> MenuLineCaption then inherited;
  Offs := GetTextOffset;
  ATextRect := TextRect;
  OffsetRect(ATextRect, Offs.X, Offs.Y);

  if ATextRect.Right - ATextRect.Left > Width then
    ATextRect.Right := ATextRect.Left + Width;

  DrawFlag := DT_END_ELLIPSIS or DTWordBreak[_getFlag(FFlags, EB_WORDWRAP)];

  if (FAlignment = abCenter) or (FAlignment = abImageTop) or
   (FAlignment = abImageBottom) then DrawFlag := DrawFlag or DT_CENTER;

  with ACanvas do
  begin
    Font.Assign(FFont);
    BeginDrawText(ACanvas, ATextRect, FButtonState);
    AText := FText;
    SetBkMode(Handle, Windows.TRANSPARENT);
    if not Enabled and (FDisableStyle <> deNone) then begin
      if FDisableStyle = deNormal then
      begin
        OffsetRect(ATextRect, 1, 1);
        Font.Color := clWindow;

        if AText <> '' then
          if not _getFlag(FFlags, EB_WORDWRAP) and (boHighlight in Options) then
            DrawHighLightText(ACanvas, PChar(AText), ATextRect, 1,
              DrawFlag, FImages)
          else
            Windows.DrawText(ACanvas.Handle, PChar(AText), Length(AText),
              ATextRect, DrawFlag);
        OffsetRect(ATextRect, -1, -1);
      end;
      Font.Color := clBtnShadow;
      if AText <> '' then
        if not _getFlag(FFlags, EB_WORDWRAP) and (boHighlight in Options) then
          DrawHighLightText(ACanvas, PChar(AText), ATextRect, 1,
            DrawFlag, FImages)
        else
          Windows.DrawText(ACanvas.Handle, PChar(AText), Length(AText),
            ATextRect, DrawFlag);
    end
    else
      if AText <> '' then
      begin
        if not _getFlag(FFlags, EB_WORDWRAP) and (boHighlight in Options) then
          DrawHighLightText(ACanvas, PChar(AText), ATextRect, 1,
            DrawFlag, FImages)
        else
          Windows.DrawText(ACanvas.Handle, PChar(AText), Length(AText),
            ATextRect, DrawFlag);
      end;
  end;
end;

procedure TDCEditButton.DrawBitmap(ACanvas: TCanvas; ImageRect: TRect);
 var
  Offs: TPoint;
  R, R1, AImageRect: TRect;
  ABitmap: TBitmap;

  procedure CopyImage(Canvas: TCanvas; Rect: TRect);
  begin
    if AssignedImages then
      Images.Draw(Canvas, Rect.Left, Rect.Top, ImageIndex, True)
    else
      if Assigned(Glyph) and (FGlyph.Canvas <> nil) then
        Canvas.StretchDraw(Rect, FGlyph)
      else
        Canvas.FillRect(Rect);  
  end;
begin
  AImageRect := ImageRect;
  Offs := GetImageOffset;
  OffsetRect(AImageRect, Offs.X, Offs.Y);
  if (Enabled or (FDisableStyle = deNone)) and
     not ((FStyle = stIcon) and (FButtonState = btDownMouseInRect)) then
  begin
    if (FStyle = stSingle) or (FStyle = stXPStyle) then
    begin
      ABitmap := TBitmap.Create;
      try
        R1 := AImageRect;
        OffsetRect(R1, -R1.Left + 1, -R1.Top + 1);

        InflateRect(AImageRect, 1, 1);
        R := AImageRect;

        ABitmap.Width := AImageRect.Right - AImageRect.Left;
        ABitmap.Height := AImageRect.Bottom - AImageRect.Top;
        OffsetRect(R, -R.Left, -R.Top);

        ABitmap.Canvas.Brush.Color := clFuchsia;
        ABitmap.Canvas.FillRect(R);
        CopyImage(ABitmap.Canvas, R1);

        if FStyle = stXPStyle then
          case FButtonState of
            btRest:
              AlphaBlend(ABitmap, nil, ABitmap, 170, BrushColor, clFuchsia);
            btRestMouseInRect:
              TransformBitmap(ABitmap, ABitmap, tsXPStyle);
          end
        else
          if (FButtonState = btDownMouseInRect) and (boSimpleStyle in Options) then
            TransformBitmap(ABitmap, ABitmap, tsInvert);

        DrawTransparentBitmap(ACanvas.Handle, ABitmap, AImageRect, False);
      finally
        ABitmap.Free;
      end;
    end
    else
      CopyImage(ACanvas, AImageRect);
  end
  else begin
     case FDisableStyle of
       deLite  : DrawLiteDisableBitmap(ACanvas, ImageRect);
       deNormal: DrawNormDisableBitmap(ACanvas, ImageRect);
       deTrans : DrawTranDisableBitmap(ACanvas, ImageRect);
     end
  end;

  case FStyle of
    stOutbar:
      if (EventStyle <> esDropDown) and (GetGlyphWidth > 0) and (GetGlyphHeight > 0) then
      with ACanvas do
      begin
        InflateRect(ImageRect, 2, 2);
        if (csDesigning in (FOwner as TComponent).ComponentState) then
        begin
          if ColorToRGB(FBrushColor) <> clSilver then
          begin
            DrawEdge(Handle, ImageRect, BDR_RAISEDINNER, BF_TOPLEFT);
            DrawEdge(Handle, ImageRect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT);
          end
          else
            DrawEdge(Handle, ImageRect, BDR_RAISEDINNER, BF_RECT);
        end
        else
          if Enabled then
          begin
            case FButtonState of
              btRest:
                ;
              btDownMouseInRect:
                if ColorToRGB(FBrushColor) <> clSilver then
                begin
                  DrawEdge(Handle, ImageRect, BDR_SUNKENINNER, BF_TOPLEFT);
                  DrawEdge(Handle, ImageRect, BDR_SUNKENOUTER, BF_BOTTOMRIGHT);
                end
                else
                  DrawEdge(Handle, ImageRect, BDR_SUNKENOUTER, BF_RECT);
              btRestMouseInRect:
                if ColorToRGB(FBrushColor) <> clSilver then
                begin
                  DrawEdge(Handle, ImageRect, BDR_RAISEDINNER, BF_TOPLEFT);
                  DrawEdge(Handle, ImageRect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT);
                end
                else
                  DrawEdge(Handle, ImageRect, BDR_RAISEDINNER, BF_RECT);
            end
          end
      end;
    stIcon:
      if (GetGlyphWidth > 0) and (GetGlyphHeight > 0) and Enabled then
      begin
        case FButtonState of
          btRest:
            {DrawTransformBitmap(ImageRect, tsTransparent)};
          btDownMouseInRect:
            DrawTransformBitmap(ACanvas, ImageRect, tsShadow);
          btRestMouseInRect:
            ;
        end
      end;
  end;
end;

procedure TDCEditButton.DrawLiteDisableBitmap(ACanvas: TCanvas; ImageRect: TRect);
 var
  ARect: TRect;
begin
  try
    ARect := Rect(0,0,GetGlyphWidth, GetGlyphHeight);
    if (GetGlyphHeight > 0) and (GetGlyphWidth > 0) then
    begin
      if AssignedImages then
      begin
        with GlyphBitmap.Canvas do
        begin
          Brush.Color := clWhite;
          FillRect(ARect);
        end;
        FImages.GetBitmap(FImageIndex, GlyphBitmap);
        if not GlyphBitmap.Empty then
          TransformBitmap(GlyphBitmap, GlyphBitmap, tsDisable);
      end
      else begin
        GlyphBitmap.Assign(FGlyph);
        TransformBitmap(Glyph, GlyphBitmap, tsDisable);
      end;

      ACanvas.StretchDraw(ImageRect, GlyphBitmap);
    end;
  finally
    {};
  end;
end;

procedure TDCEditButton.DrawTransformBitmap(ACanvas: TCanvas; ImageRect: TRect;
  Style: TTransformStyle);
 var
  ARect: TRect;
begin
  try
    ARect := Rect(0, 0, GetGlyphWidth, GetGlyphHeight);
    if (GetGlyphHeight > 0) and (GetGlyphWidth > 0) then
    begin
      if AssignedImages then
      begin
        with GlyphBitmap.Canvas do
        begin
          Brush.Color := clFuchsia;
          FillRect(ARect);
        end;
        FImages.GetBitmap(FImageIndex, GlyphBitmap);
        TransformBitmap(GlyphBitmap, GlyphBitmap, Style);
      end
      else begin
        GlyphBitmap.Assign(FGlyph);
        TransformBitmap(Glyph, GlyphBitmap, Style);
      end;

      ACanvas.StretchDraw(ImageRect, GlyphBitmap);
    end;
  finally
    {};
  end;

end;


procedure TDCEditButton.DrawNormDisableBitmap(ACanvas: TCanvas; ImageRect: TRect);
 const
  ROP_DSPDxax = $00E20746;
begin
  try
    with GlyphBitmap do
    begin
      if AssignedImages then
      begin
        Canvas.Brush.Color := clWhite;
        Canvas.FillRect(Rect(0,0,GetGlyphWidth, GetGlyphHeight));
        FImages.GetBitmap(FImageIndex, GlyphBitmap);
      end
      else
        Assign(Glyph);
      HandleType := bmDDB;
      Canvas.Brush.Color := clBlack;
      Width := GetGlyphWidth;
      if Monochrome then
      begin
        Canvas.Font.Color := clWhite;
        Monochrome := False;
        Canvas.Brush.Color := clWhite;
      end;
      Monochrome := True;
    end;
    with ACanvas do
    begin
      Brush.Color := clBtnShadow;
      SetTextColor(Handle, clBlack);
      SetBkColor(Handle, clWhite);
      BitBlt(Handle, ImageRect.Left,ImageRect.Top, GetGlyphWidth, GetGlyphHeight,
             GlyphBitmap.Canvas.Handle, 0, 0, ROP_DSPDxax);

    end;
  finally
    {}
  end;
end;

procedure TDCEditButton.DrawBorder(ACanvas: TCanvas; ARect: TRect);
 var
  AButtonState: TButtonState;
  BBrush: HBRUSH;
  ARGB: integer;
begin
  AButtonState := FButtonState;
  if not Enabled then AButtonState := btRest;

  case AButtonState of
    btRest:
      begin
        if (csDesigning in (FOwner as TComponent).ComponentState) then
        begin
          case FStyle of
            stNormal    :
              begin
                DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_RECT);
                InflateRect(ARect, -1, -1);
                DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
              end;
            stFlat :
              DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
            stControlFlat :
              if Enabled then
                DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT)
              else
                FrameRect(ACanvas.Handle, ARect, GetSysColorBrush(COLOR_WINDOW));
            stShadowFlat:
              begin
                DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_TOPLEFT);
                ARGB := ColorToRGB(BrushColor);
                case ARGB of
                  $808080: {clGray}
                    DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT);
                  $C0C0C0: {clSilver}
                    DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
                  else
                    DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
                end;
              end;
            stNone:;
            stIcon:;
            stSingle:
              if boFrameInRest in Options then
              begin
                BBrush := CreateSolidBrush(ColorToRGB(clBtnShadow));
                FrameRect(ACanvas.Handle, ARect, BBrush);
                DeleteObject(BBrush);
              end;
          end;
        end
        else
          case FStyle of
            stNormal :
              begin
                if Enabled then
                begin
                  DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_RECT);
                  InflateRect(ARect, -1, -1);
                  DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
                end
                else begin
                  DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_TOPLEFT);
                  DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
                  InflateRect(ARect, -1, -1);
                  DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_TOPLEFT);
                  DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENINNER, BF_BOTTOMRIGHT);
                end;
              end;
            stFlat   :
              if _getFlag(FFlags, EB_MOUSEINCTRL) then
                DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
            stControlFlat :
              if _getFlag(FFlags, EB_MOUSEINCTRL) then
                DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT)
              else begin
                if Assigned(FOwner) and (FOwner is TWinControl) then
                begin
                  BBrush := CreateSolidBrush(ColorToRGB(TWinControlCracker(FOwner).Color));
//                  FrameRect(ACanvas.Handle, ARect, BBrush);
                  DeleteObject(BBrush);
                end
                else
                  FrameRect(ACanvas.Handle, ARect, GetSysColorBrush(COLOR_WINDOW));
              end;
            stShadowFlat:
              if _getFlag(FFlags, EB_MOUSEINCTRL) then
              begin
                DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_TOPLEFT);
                ARGB := ColorToRGB(BrushColor);
                case ARGB of
                  $808080: {clGray}
                    DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT);
                  $C0C0C0: {clSilver}
                    DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
                  else
                    DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
                end;
              end;
            stNone:;
            stIcon:;
            stSingle:
               if boFrameInRest in Options then
               begin
                 BBrush := CreateSolidBrush(ColorToRgb(clBtnShadow));
                 FrameRect(ACanvas.Handle, ARect, BBrush);
                 DeleteObject(BBrush);
               end;
            stXPStyle:
              if not _getFlag(FFlags, EB_MOUSEINCTRL) and
                not(boFrame in Options) then
              begin
                if Assigned(FOwner) and (FOwner is TWinControl) then
                begin
                  BBrush := CreateSolidBrush(ColorToRGB(TWinControlCracker(FOwner).Color));
                  FrameRect(ACanvas.Handle, ARect, BBrush);
                  DeleteObject(BBrush);
                end
                else
                  FrameRect(ACanvas.Handle, ARect, GetSysColorBrush(COLOR_WINDOW));
              end
              else
                 if boFrameInRest in Options then
                 begin
                   BBrush := CreateSolidBrush(ColorToRgb(clBtnShadow));
                   FrameRect(ACanvas.Handle, ARect, BBrush);
                   DeleteObject(BBrush);
                 end;
          end;
      end;
    btDownMouseInRect:
      begin
        case FStyle of
          stNormal:
            begin
              FrameRect(ACanvas.Handle, ARect, GetSysColorBrush(COLOR_BTNSHADOW));
            end;
          stFlat,
          stControlFlat   :
            DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENOUTER, BF_RECT);
          stShadowFlat:
            begin
              DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENOUTER, BF_BOTTOMRIGHT);
              ARGB := ColorToRGB(BrushColor);
              case ARGB of
                $808080: {clGray}
                  DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENINNER, BF_TOPLEFT);
                $C0C0C0: {clSilver}
                  DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENOUTER, BF_TOPLEFT);
                else
                  DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENOUTER, BF_TOPLEFT);
              end;
            end;
          stOutBar:
            if (GetGlyphHeight=0) or (GetGlyphWidth=0) or
               (EventStyle=esDropDown)
            then
              if ColorToRGB(FBrushColor) <> clSilver then
              begin
                DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENINNER, BF_TOPLEFT);
                DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENOUTER, BF_BOTTOMRIGHT);
              end
              else
                DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENOUTER, BF_RECT);
          stNone:;
          stIcon:;
          stSingle, stXPStyle:
           if boFrame in Options then
           begin
             BBrush := CreateSolidBrush(clXPBorder);
             FrameRect(ACanvas.Handle, ARect, BBrush);
             DeleteObject(BBrush);
           end;
        end;
      end;
    btRestMouseInRect:
      begin
        case FStyle of
          stNormal        :
            begin
              DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_RECT);
              InflateRect(ARect, -1, -1);
              DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
            end;
          stFlat,
          stControlFlat   :
            DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
          stShadowFlat:
            begin
              DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_TOPLEFT);
              ARGB := ColorToRGB(BrushColor);
              case ARGB of
                $808080: {clGray}
                  DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT);
                $C0C0C0: {clSilver}
                  DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
                else
                  DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
              end;
            end;
          stOutBar:
            if (GetGlyphHeight=0) or (GetGlyphWidth=0) or
               (EventStyle=esDropDown)
            then
              if ColorToRGB(FBrushColor) <> clSilver then
              begin
                DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_TOPLEFT);
                DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT);
              end
              else
                DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
          stNone:;
          stIcon:;
          stSingle, stXPStyle:
           if boFrame in Options then
           begin
             BBrush := CreateSolidBrush(clXPBorder);
             FrameRect(ACanvas.Handle, ARect, BBrush);
             DeleteObject(BBrush);
           end;
       end;
      end;
  end;
end;

procedure TDCEditButton.ResetProperties;
var
  P: TPoint;
begin
  GetCursorPos(P);
  if AbsolutePos then
  begin
    P.X := P.X - FOwner.Left;
    P.Y := P.Y - FOwner.Top;
  end
  else
    P := Owner.ScreenToClient(P);

  if ResetOnExitControl or (FEventStyle <> esDropDown) then
  begin
    if MouseInRect(P.X, P.Y) then
      FButtonState := btRestMouseInRect
    else
      FButtonState := btRest;

    ResetFlags;
    Notify(acStateChanged)
  end;
end;

procedure TDCEditButton.SetText(Value:string);
begin
  FText     := Value;
  FTextSize := GetTextSize;
  Changed;
end;

procedure TDCEditButton.SetAlignment(Value:TButtonAlignment);
begin
  if Value <>  FAlignment then
  begin
    FAlignment := Value;
    Changed;
  end;
end;

procedure TDCEditButton.SetButtonState(Value:TButtonState);
begin
  if Assigned(FOnSetButtonState) then FOnSetButtonState(Self, Value);
  if Value <> FButtonState then
  begin
    FButtonState := Value;
    if _getFlag(FFlags, EB_DOWNCLICK) and
      (FButtonState <> btDownMouseInRect) then
      _setFlag(FFlags, EB_BUTTONDOWN, False);
  end;
end;

procedure TDCEditButton.SetMouseInControl(const Index: Integer;
  const Value: boolean);
begin
  if not _chkFlag(FFlags, EB_MOUSEINCTRL, Value) then
  begin
    if not Value then FButtonState := btRest;
    _setFlag(FFlags, EB_MOUSEINCTRL, Value);
  end;
end;

procedure TDCEditButton.SetEnabled(const Index: Integer; const Value: boolean);
begin
  if not _chkFlag(FFlags, EB_ENABLED, Value) then
  begin
    _setFlag(FFlags, EB_ENABLED, Value);
    Notify(acEnabledChanged);
  end;
end;

procedure TDCEditButton.SetStyle(const Value: TButtonStyle);
begin
  FStyle := Value;
  if FStyle = stIcon then
    Options := Options + [boFocusSensitive]
  else
    Options := Options - [boFocusSensitive]
end;

procedure TDCEditButton.DoPaint(ACanvas: TCanvas;
  ARect: TRect; SkipClipping: boolean = False);
 var
  ImageRect, TextRect: TRect;
begin
  ImageRect := GetImageRect;
  TextRect  := GetTextRect(ImageRect);
  OffsetRect(ImageRect, ARect.Left, ARect.Top);
  OffsetRect(TextRect, ARect.Left, ARect.Top);
  
  BeginDrawBkgn(ACanvas, ARect, FButtonState, ImageRect, TextRect);
  if not((boTransparent in Options) and SkipClipping) then DrawBkgnd(ACanvas, ARect);
  DrawBorder(ACanvas, ARect);
  if Caption <> MenuLineCaption then DrawBitmap(ACanvas, ImageRect);
  if _getFlag(FFlags, EB_DRAWTEXT) then DrawEditText(ACanvas, TextRect);
end;

function TDCHintButton.GetTextSize: TPoint;
begin
  Result := inherited GetTextSize;
  Inc(Result.Y, 2);
end;

procedure TDCEditButton.DrawTranDisableBitmap(ACanvas: TCanvas;
  ImageRect: TRect);
 var
  ARect: TRect;
  ABitmap: TBitmap;
begin
  try
    ARect := Rect(0, 0, GetGlyphWidth, GetGlyphHeight);
    if (GetGlyphHeight > 0) and (GetGlyphWidth > 0) then
    begin
      ABitmap := TBitmap.Create;
      try
        ABitmap.Transparent := True;
        if AssignedImages then
        begin
          FImages.GetBitmap(FImageIndex, ABitmap);
          AlphaBlend(ABitmap, nil, ABitmap, 100, BrushColor, BrushColor);
        end
        else begin
          ABitmap.Assign(FGlyph);
          AlphaBlend(Glyph, nil, ABitmap, 100, BrushColor, BrushColor);
        end;
        ACanvas.StretchDraw(ImageRect, ABitmap);
      finally
        ABitmap.Free;
      end;
    end;
  finally
    {};
  end;
end;

procedure TDCEditButton.DrawBkgnd(ACanvas: TCanvas; Rect: TRect);
begin
  if (boTransparent in Options) and Assigned(ButtonHolder) then
    ButtonHolder.PaintBackground(Rect, Self, ACanvas)
  else
    FillRect(ACanvas.Handle, Rect, ACanvas.Brush.Handle);
end;

procedure TDCEditButton.BeginDrawBkgn(ACanvas: TCanvas; ARect: TRect;
  AState: TButtonState; var ImageRect: TRect; var TextRect: TRect);
begin
  if not Enabled then
     case FDisableStyle of
       deLite  :
         if (FStyle = stNone) or (not MouseInControl and (AState = btRest)) then
           ACanvas.Brush.Color := FBrushColor
         else
           ACanvas.Brush.Bitmap := AllocPatternBitmap(clLite, clBtnFace);
       deNormal:
         ACanvas.Brush.Color  := FBrushColor;
       deNone  :
         ACanvas.Brush.Color  := FBrushColor;
       deTrans :
         ACanvas.Brush.Color  := FBrushColor;
     end
  else
    case FStyle of
      stOutBar:
        begin
          if FEventStyle = esDropDown then
          begin
            case AState of
              btRest, btRestMouseInRect:
                ACanvas.Brush.Color := FBrushColor;
              btDownMouseInRect:
                 if ColorToRGB(FBrushColor) = ColorToRGB(clBtnFace) then
                   ACanvas.Brush.Bitmap := AllocPatternBitmap(clWhite, clBtnFace)
                 else
                   ACanvas.Brush.Color := FBrushColor;
            end;
          end
          else
            ACanvas.Brush.Color := FBrushColor;
        end;
      stShadowFlat:
        case AState of
          btRest:
            if (csDesigning in (FOwner as TComponent).ComponentState) and
               (ColorToRGB(FBrushColor) = clWhite) then
              ACanvas.Brush.Bitmap := AllocPatternBitmap(clWhite, clBtnFace)
            else
              ACanvas.Brush.Color := FBrushColor;
          btDownMouseInRect, btRestMouseInRect:
            if (ColorToRGB(FBrushColor) = clWhite)  or
               ((ColorToRGB(FBrushColor) = clSilver) or (FBrushColor = clBtnFace)) and
               (boFlatPattern in Options) then
              ACanvas.Brush.Bitmap := AllocPatternBitmap(clWhite, clBtnFace)
            else
              ACanvas.Brush.Color := FBrushColor;
        end;
      stSingle, stXPStyle:
        case AState of
          btRest:
            ACanvas.Brush.Color := FBrushColor;
          btRestMouseInRect:
            ACanvas.Brush.Color := FSelectColor;
          btDownMouseInRect:
            ACanvas.Brush.Color := clXPDropDown;
        end;
      else
        ACanvas.Brush.Color := FBrushColor;

    end;
end;

procedure TDCEditButton.SetSelectColor(const Value: TColor);
begin
  FSelectColor := Value;
end;

procedure TDCEditButton.SetOptions(const Value: TButtonOptions);
 var
  ChangedOptions: TButtonOptions;
begin
  ChangedOptions := (FOptions + Value) - (FOptions * Value);

  if boHighlight in ChangedOptions then
  begin
    FTextSize := GetTextSize;
    Changed;
  end;

  if (boTransparent in ChangedOptions) then Changed;
  FOptions := Value;
end;

procedure TDCEditButton.SetIndex(const Value: integer);
begin
  if ButtonHolder <> nil then ButtonHolder.MoveButton(FIndex, Value);
end;

function TDCEditButton.WMSetCursor(var Message: TWMSetCursor;
  X, Y: integer): boolean;
begin
  Result := False;
end;

function TDCLinkButton.WMSetCursor(var Message: TWMSetCursor;
  X, Y: integer): boolean;
begin
  Result := True;
  SetCursor(Screen.Cursors[crLinkSelect]);
end;

procedure TDCEditButton.SetButtonHolder(Value: IDCButtonHolder);
begin
  FButtonHolder := Value;
  ButtonHolder.Notify(Self, acAdd);
end;

procedure TDCEditButton.FontChanged(AFont: TObject);
begin
  FTextSize := GetTextSize;
  Notify(acFontChanged);
end;

function TDCEditButton.GetVisible: boolean;
begin
  Result := _getFlag(FFlags, EB_VISIBLE);
end;

procedure TDCEditButton.SetWordWrap(const Index: Integer; const Value: boolean);
begin
  if not _chkFlag(FFlags, EB_WORDWRAP, False) then
  begin
    _setFlag(FFlags, EB_WORDWRAP, Value);
    Notify(acChanged);
  end;
end;

function TDCEditButton.GetBoundsEx: TRect;
begin
  if Visible then
    Result := GetBounds
  else begin
    Result := Rect(0, 0, FVisibleWidth, Height);
    OffsetRect(Result, Left, Top);
  end;
end;

function TDCEditButton.GetFlagvalue(const Index: Integer): boolean;
begin
  Result := _getFlag(FFlags, Index)
end;

procedure TDCEditButton.SetFlagValue(const Index: Integer;
  const Value: boolean);
begin
  _setFlag(FFlags, Index, Value);
end;

procedure TDCEditButton.ResetFlags;
begin
  _setFlag(FFlags, EB_DOWNSTATE, False);
  _setFlag(FFlags, EB_BUTTONDOWN, False);
end;

procedure TDCEditButton.Changed;
begin
  Notify(acChanged);
end;

procedure TDCEditButton.SetVisible(const Value: boolean);
 var
  R: TRect;
begin
  if not _chkFlag(FFlags, EB_VISIBLE, Value) then
  begin
    _setFlag(FFlags, EB_VISIBLE, Value);
    if Value then
    begin
      FCoordValues[cvWidth] := FVisibleWidth;
      R := GetBounds;
    end
    else begin
      R := GetBounds;
      FVisibleWidth := FCoordValues[cvWidth];
      FCoordValues[cvWidth] := 0;
    end;
    if FOwner.HandleAllocated then
      InvalidateRect(FOwner.Handle, @R, not Visible);
    Notify(acVisibleChanged);
  end;
end;

function TDCEditButton.GetWidth: integer;
begin
  if Visible then
    Result := FCoordValues[cvWidth]
  else
    Result := FVisibleWidth;
end;

procedure TDCEditButton.DrawHint(Mode: integer);
begin
  if Assigned(FOnDrawHint) then FOnDrawHint(Self, Mode);
end;

procedure TDCEditButton.SetImages(const Value: TCustomImageList);
begin
  FImages   := Value;
  FTextSize := GetTextSize;
  Notify(acImageChanged);
end;

procedure TDCEditButton.SetImageIndex(const Value: integer);
begin
  FImageIndex := Value;
  Changed;
end;

function TDCEditButton.GetGlyphHeight: integer;
begin
  if (AssignedImages) and (FImageIndex <> -1) then
    Result := FImages.Height
  else begin
    if Assigned(FGlyph) then
      Result := FGlyph.Height
    else
      Result := 0;
  end
end;

function TDCEditButton.GetGlyphWidth: integer;
begin
  if AssignedImages then
    if ImageIndex <> -1 then
      Result := FImages.Width
    else
      Result := 0
  else
    if Assigned(FGlyph) then
      Result := FGlyph.Width
    else
      Result := 0
end;

function TDCEditButton.AssignedImages: boolean;
begin
  Result := Assigned(Images) and (not Assigned(Glyph) or Glyph.Empty);
end;

function TDCEditButton.GetImageRect: TRect;
 var
  Pos, ATextSize: TPoint;
  DrawRectX: integer;
  TextOffs: integer;
begin
  if (GetGlyphWidth = 0) or (GetGlyphHeight = 0) then
  begin
    Result := Rect(BT_MARGINS, BT_MARGINS, BT_MARGINS, BT_MARGINS);
    Exit;
  end;

  if not DrawText or (Caption = '') then
    ATextSize := Point(0, 0)
  else
    ATextSize := FTextSize;

  if (ATextSize.X = 0) or (GetGlyphWidth = 0) then
    TextOffs := 0
  else
    TextOffs := BT_IMAGEOFFSET;

  case FAlignment of
     abLeft :
       begin
         Pos.X := BT_MARGINS;
         Pos.Y := (FCoordValues[cvHeight] - GetGlyphHeight) div 2;
       end;
     abRight:
       begin
         Pos.X := FCoordValues[cvWidth] - GetGlyphWidth - BT_MARGINS;
         Pos.Y := (FCoordValues[cvHeight] - GetGlyphHeight) div 2;
       end;
     abCenter:
       begin
         DrawRectX := GetGlyphWidth + ATextSize.X + (2*BT_MARGINS + TextOffs);
         if DrawRectX >= FCoordValues[cvWidth] then
           Pos.X := BT_MARGINS
         else
           Pos.X := BT_MARGINS + (FCoordValues[cvWidth] - GetGlyphWidth -
             ATextSize.X - (2*BT_MARGINS + TextOffs)) div 2;
         Pos.Y := (FCoordValues[cvHeight] - GetGlyphHeight) div 2;
       end;
     abImageTop:
       begin
         Pos.X := BT_MARGINS + (FCoordValues[cvWidth] - GetGlyphWidth -
           2*BT_MARGINS) div 2;
         Pos.Y := BT_MARGINS + (FCoordValues[cvHeight] - GetGlyphHeight -
           ATextSize.Y - (2*BT_MARGINS + TextOffs)) div 2;
       end;
     abImageBottom:
       begin
         Pos.X := BT_MARGINS + (FCoordValues[cvWidth] - GetGlyphWidth -
           2*BT_MARGINS) div 2;
         Pos.Y := BT_MARGINS + ATextSize.Y + TextOffs +
           (FCoordValues[cvHeight] - GetGlyphHeight - ATextSize.Y-
           (2*BT_MARGINS + TextOffs)) div 2;
       end;
  end;
  Result := Rect(0, 0, GetGlyphWidth, GetGlyphHeight);
  OffsetRect(Result, Pos.X, Pos.Y);
end;

function TDCEditButton.GetTextRect(IRect: TRect): TRect;
 var
  TextOffs: integer;
  w: integer;
begin
  if (FTextSize.X = 0) or (GetGlyphWidth = 0) then
    TextOffs := 0
  else
    TextOffs := BT_IMAGEOFFSET;

  case FAlignment of
    abLeft, abRight, abCenter:
      begin
        case FAlignment of
          abLeft:
            Result := Rect(IRect.Right + TextOffs, 0, IRect.Right + TextOffs +
              FTextSize.X, Height);
          abRight:
            begin
              w := _intMax(IRect.Right + TextOffs, FCoordValues[cvWidth] -
                BT_MARGINS - FTextSize.X);
              Result := Rect(w, 0, FCoordValues[cvWidth] - BT_MARGINS, Height);
            end;
          abCenter:
            Result := Rect(IRect.Right + TextOffs, 0, FCoordValues[cvWidth] -
              BT_MARGINS, Height);
        end;
        if (Result.Bottom - Result.Top) > FTextSize.Y then
        begin
          Result.Top := (Result.Bottom + Result.Top - FTextSize.Y) shr 1;
          Result.Bottom := Result.Top + FTextSize.Y;
        end;
      end;
    abImageTop:
      begin
        Result := Rect(BT_MARGINS, IRect.Bottom + TextOffs,
          FCoordValues[cvWidth] - BT_MARGINS, FCoordValues[cvHeight]);
        if (Result.Right - Result.Left) > FTextSize.X then
        begin
          Result.Left := (Result.Right+Result.Left-FTextSize.X)shr 1;
          Result.Right := Result.Left + FTextSize.X;
        end;
      end;
    abImageBottom:
      begin
        Result := Rect(BT_MARGINS, 0, FCoordValues[cvWidth] - BT_MARGINS,
          IRect.Left-TextOffs);
        if (Result.Right-Result.Left) > FTextSize.X then
        begin
          Result.Left    := (Result.Right+Result.Left-FTextSize.X)shr 1;
          Result.Right   := Result.Left + FTextSize.X;
        end;
      end;
  end;
  OffsetRect(Result, 1, 1);
  InflateRect(Result, 1, 1);
end;

function TDCEditButton.GetTextSize: TPoint;
 const
  DTWordBreak: array[boolean] of integer = (0, DT_WORDBREAK);
 var
  ARect: TRect;
begin
  UserBitmap.Canvas.Font := FFont;
  if _getFlag(FFlags, EB_WORDWRAP) then
  begin
    ARect := Rect(0, 0, Width - 2*BT_MARGINS, MaxInt);
    if (Images <> nil) and (ImageIndex <> -1) then
      Dec(ARect.Right, Images.Width)
  end
  else
    ARect := Rect(0, 0, MaxInt, MaxInt);
  if not _getFlag(FFlags, EB_WORDWRAP) and (boHighlight in Options) then
    Result := DrawHighLightText(UserBitmap.Canvas, PChar(FText),
      ARect, 0, DT_END_ELLIPSIS or DTWordBreak[_getFlag(FFlags, EB_WORDWRAP)],
        FImages)
  else begin
    Windows.DrawText(UserBitmap.Canvas.Handle, PChar(FText), Length(FText),
      ARect, DT_CALCRECT or DTWordBreak[_getFlag(FFlags, EB_WORDWRAP)]);
    Result :=  Point(ARect.Right - ARect.Left, ARect.Bottom - ARect.Top);
  end;
  FTextSize := Result;
end;

procedure TDCEditButton.SetFont(const Value: TFont);
begin
  FFont.Assign(Value);
  FTextSize := GetTextSize;
  Changed;
end;

function TDCEditButton.GetImageOffset: TPoint;
begin
  if (FButtonState = btDownMouseInRect) and
     not((FStyle = stShadowFlat) or (FStyle = stNone) or (FStyle = stIcon) or
      (FStyle = stSingle) or (FStyle = stXPStyle))
  then
    Result := Point(1, 1)
  else
    Result := Point(0, 0);
end;

function TDCEditButton.GetTextOffset: TPoint;
begin
  if (FButtonState = btDownMouseInRect) and
     not((FStyle = stShadowFlat) or (FStyle = stNone) or
         (FStyle = stOutBar) and (FEventStyle <> esDropDown) or
         (FStyle = stIcon) or (FStyle = stSingle) or (FStyle = stXPStyle))
  then
    Result := Point(1, 1)
  else
    Result := Point(0, 0);
end;

procedure TDCEditButton.Invalidate;
begin
  if (FButtonHolder = nil) or (FButtonHolder.UpdateCount = 0) and
    FButtonHolder.ButtonVisible(Self) then
    Paint(0);
end;

function TDCEditButton.IsEqual(Button: TDCEditButton): Boolean;
begin
  Result := (Text = Button.Text) and (ImageIndex = Button.ImageIndex);
end;

procedure TDCEditButton.ReadData(Stream: TStream; Info: PButtonInfo);
 var
  Size, ALen: LongWord;
  AText: PChar;
  ACLen, AHLen: LongWord;
begin

  Stream.ReadBuffer(Size, SizeOf(Size));
  Stream.ReadBuffer(ALen, SizeOf(Integer));
  Stream.ReadBuffer(Info^, Size);

  ACLen := ALen and $0000FFFF;
  AHLen := (ALen shr 16) and $0000FFFF;

  Tag          := Info^.Tag;
  ImageIndex   := Info^.ImageIndex;
  Enabled      := Info^.Enabled;
  Top          := Info^.Top;
  Left         := Info^.Left;
  Width        := Info^.Width;
  Height       := Info^.Height;
  Alignment   := TButtonAlignment(Info^.Alignment);
  if Info^.Style <= integer(stNone) then
    Style      := TButtonStyle(Info^.Style)
  else
    Style      := stFlat;
  EventStyle   := TEventStyle(Info^.EvtStyle);
  Grouped      := Info^.Grouped;
  AnchorStyle  := TAnchorStyle(Info^.AncStyle);
  DisableStyle := TDisableStyle(Info^.DisStyle);
  AbsolutePos  := Info^.AbsolutePos;
  ResetOnExitControl  := Info^.ResetOnExit;

  GetMem(AText, ACLen);
  try
    Stream.ReadBuffer(AText^, ACLen);
    Text := AText;
  finally
    FreeMem(AText);
  end;

  if AHLen > 0 then
  begin
    GetMem(AText, AHLen);
    try
      Stream.ReadBuffer(AText^, AHLen);
      Hint := AText;
    finally
      FreeMem(AText);
    end;
  end
  else
    Hint := ''
end;

procedure TDCEditButton.WriteData(Stream: TStream; Info: PButtonInfo);
 var
   Size, ALen: LongWord;
   AText: PChar;
   ACLen, AHLen: LongWord;
begin
  Size := SizeOf(TButtonInfo);

  ACLen := (Length(Text) + 1) and $0000FFFF;

  if Hint <> '' then
    AHLen := (Length(Hint) + 1) and $0000FFFF
  else
    AHLen :=  0;
  ALen  := AHLen shl 16 + ACLen;

  Info^.Tag        := Tag;
  Info^.ImageIndex := ImageIndex;
  Info^.Enabled    := Enabled;
  Info^.Top        := Top;
  Info^.Left       := Left;
  Info^.Width      := Width;
  Info^.Height     := Height;
  Info^.Alignment := integer(Alignment);
  Info^.Style      := integer(Style);
  Info^.EvtStyle   := integer(EventStyle);
  Info^.Grouped    := Grouped;
  Info^.AncStyle   := integer(AnchorStyle);
  Info^.DisStyle   := integer(DisableStyle);
  Info^.AbsolutePos:= AbsolutePos;
  Info^.ResetOnExit:= ResetOnExitControl;

  Stream.WriteBuffer(Size , SizeOf(Size));
  Stream.WriteBuffer(ALen , SizeOf(Integer));
  Stream.WriteBuffer(Info^, Size);

  GetMem(AText, ACLen);
  try
    StrPCopy(AText, Text);
    Stream.WriteBuffer(AText^ , ACLen);
  finally
    FreeMem(AText);
  end;

  if AHLen > 0 then
  begin
    GetMem(AText, AHLen);
    try
      StrPCopy(AText, Hint);
      Stream.WriteBuffer(AText^ , AHLen);
    finally
      FreeMem(AText);
    end;
  end;
end;

function TDCEditButtons.GetRegion: HRGN;
begin
  if Assigned(FOnGetRegion) then
    FOnGetRegion(Self, Result)
  else
    Result := NULLREGION;
end;

function TDCEditButton.GetBounds: TRect;
begin
  Result := Rect(0, 0, Width, Height);
  OffsetRect(Result, Left, Top);
end;

procedure TDCEditButton.Click;
begin
  if Assigned(FButtonHolder) and
    (FButtonHolder.ActiveButton <> TDCEditButton(Self)) then
    FButtonHolder.ActiveButton := TDCEditButton(Self);
  if Assigned(FOnClick) then FOnClick(Self);
end;

procedure TDCEditButton.SetWidth(const Value: integer);
begin
  if _getFlag(FFlags, EB_VISIBLE) then FCoordValues[cvWidth] := Value;
  FVisibleWidth := Value;
  Notify(acBoundsChanged);
end;

function TDCEditButton.GetEditButtons: IDCButtonHolder;
begin
  Result := FButtonHolder;
end;

function TDCEditButton.OneClickButton: boolean;
begin
  Result := False;
end;

procedure TDCEditButton.BeginDrawText(ACanvas: TCanvas; ATextRect: TRect;
  AState: TButtonState);
 var
  ParentForm: TCustomForm;

 function LightColor(i: integer): boolean;
  var
   j: integer;
 begin
   j := ColorToRGB(clLightBarrier);
   Result := (GetRValue(i) >= GetRValue(j)) and (GetGValue(i) >= GetGValue(j)) and
     (GetBValue(i) >= GetBValue(j));
 end;
begin
  with ACanvas do
  begin
    case FStyle of
      stIcon:
        case AState of
          btRest:;
          btDownMouseInRect:
            begin
              ParentForm := GetParentForm(FButtonHolder.Owner);
              if (ParentForm <> nil) and
                (ParentForm.ActiveControl = FButtonHolder.Owner) then
              begin
                Brush.Color := clHighlight;
                Font.Color  := clHighlightText;
              end
              else begin
                Brush.Color := clBtnFace;
              end;
              FillRect(ATextRect);
              Dec(ATextRect.Bottom, 2);
              Windows.DrawFocusRect(ACanvas.Handle, ATextRect);
            end;
          btRestMouseInRect:
        end;
      stSingle, stXPStyle:
        case AState of
          btRest:;
          btDownMouseInRect:
            if LightColor(clXPDropDown) then
              Font.Color := clWindowText
            else
              Font.Color := clHighlightText;
          btRestMouseInRect:
            if LightColor(SelectColor) then
              Font.Color := clWindowText
            else
              Font.Color := clHighlightText;
        end;
    end;
  end;
end;

{ TDCEditButtons }

function TDCEditButtons.AddButton: TDCEditButton;
begin
  Result := AddButtonEx(TDCEditButton);
end;

procedure TDCEditButtons.Clear;
 var
  i: integer;
begin
  for i := 0 to FButtons.Count-1 do
    TDCEditButton(FButtons.Items[i]).Free;
  FButtons.Clear;
  DoChange;
end;

procedure TDCEditButtons.ClrWndProc;
begin
  if not _getFlag(FFlags, BS_PROCCLEAR) and Assigned(FDefWndProc) then
  begin
    _setFlag(FFlags, BS_PROCCLEAR, True);
    if (FOwner <> nil) then
      SetWindowLong(FOwner.Handle, GWL_WNDPROC, LongInt(FDefWndProc));
  end;
end;

constructor TDCEditButtons.Create(AOwner: TWinControl);
begin
  inherited Create;
  FBkgImage := TBitmap.Create;
  FOwner := AOwner;
  FButtons := TList.Create;
  FCanvas := TCanvas.Create;

  Options := [boNCPainting, boAbsolutePos, boDrawButtons];

  FActiveButton:= nil;


  {$IFDEF DELPHI_V6}
    FNewWndProc := Classes.MakeObjectInstance(EditWndProc);
  {$ELSE}
    FNewWndProc := MakeObjectInstance(EditWndProc);
  {$ENDIF}
  FUpdateCount:= 0;

  Active := False;
  FControlState := [];

  _setFlag(FFlags, BS_BUTTONDOWN, False);
  _setFlag(FFlags, BS_MOUSEINCTRL, False);
  _setFlag(FFlags, BS_PROCCLEAR, True);
  _setFlag(FFlags, BS_KEYMOVING, False);
end;

procedure TDCEditButtons.DefineProperties(Filer: TFiler);
  function WriteButtons: Boolean;
  var
    I: Integer;
    Items: TDCEditButtons;
  begin
    Items := TDCEditButtons(Filer.Ancestor);
    if Items = nil then
      Result := Count > 0
    else if Items.Count <> Count then
      Result := True
    else
    begin
      Result := False;
      for I := 0 to Count - 1 do
      begin
        Result := not Buttons[I].IsEqual(Items.Buttons[I]);
        if Result then Break;
      end
    end;
  end;

begin
  inherited DefineProperties(Filer);
  Filer.DefineBinaryProperty('Data', ReadData, WriteData, WriteButtons);
end;

procedure TDCEditButtons.DeleteButton(Index: integer);
begin
  TDCEditButton(FButtons.Items[Index]).Free;
  FButtons.Delete(Index);
  UpdateIndex;
end;

destructor TDCEditButtons.Destroy;
begin
  Destroying;
  ClrWndProc;
  {$IFDEF DELPHI_V6}
    Classes.FreeObjectInstance(FNewWndProc);
  {$ELSE}
    FreeObjectInstance(FNewWndProc);
  {$ENDIF}
  Clear;
  FOwner := nil;
  FreeAndNil(FCanvas);
  FreeAndNil(FButtons);
  FreeAndNil(FBkgImage);
  inherited;
end;

procedure TDCEditButtons.EditWndProc(var Message: TMessage);
 var
  lInherited: boolean;
  Pos: TPoint;
  WndPos: TWindowPos;
  Offset: TPoint;
  Button: TDCEditButton;
begin
  if (esDestroying in FControlState) or not Assigned(FOwner) or
    _getFlag(FFlags, BS_PROCCLEAR) then Exit;

  lInherited := True;
  with Message do
  begin
    case Msg of
      WM_NCHITTEST:
        begin
         if not(csDesigning in FOwner.ComponentState) then
         begin
           GetCursorPos(Pos);
           if MouseInButtonArea(Pos.X, Pos.Y, Button) then
           begin
             lInherited := False;
             Message.Result := HTCLIENT;
           end;
         end;
        end;
      WM_CHAR:
        ;
      WM_KEYDOWN:
        DoKeyDown(Message);
      WM_DESTROY:
       ClrWndProc;
      WM_WINDOWPOSCHANGED:
       begin
         WndPos := PWindowPos(Message.LParam)^;
         if WndPos.Flags = SWP_SHOWWINDOW then RepaintButtons(dsDrawAll, 0);
       end;
      WM_WINDOWPOSCHANGING:
        with TWMWindowPosChanging(Message).WindowPos^ do
        begin
         if (X <> 0) or (Y <> 0) or
           (FOwner.Width <> CX) or (FOwner.Height <> CY) then
         begin
           GetCursorPos(Pos);
           WndPos := PWindowPos(Message.LParam)^;
           if (WndPos.CX <> 0) or (WndPos.CY <> 0)  then
           begin
             Offset := Point(WndPos.CX - FOwner.Width, WndPos.CY - FOwner.Height);
             if (Offset.X <> 0) or (Offset.Y <> 0) then
                OffsetButtons(Offset);
           end;
           //UpdateButtonsOnClick(Pos.X, Pos.Y, True);
         end;
       end;
      WM_NCPAINT:
       begin
         lInherited :=  False;
         Result := CallWindowProc(FDefWndProc, FOwner.Handle, Msg, WParam, LParam);
         if boNCPainting in Options then RepaintButtons(dsDrawAll, 0);
       end;
      WM_PAINT:
       begin
         if boDrawButtons in Options then
         begin
           lInherited :=  False;
           if WParam <> 0 then
           begin
             RepaintButtons(dsDrawNotTRN, WParam);
             UpdateDeviceRegion(WParam);
             Result := CallWindowProc(FDefWndProc, Owner.Handle, Msg, WParam, LParam);
             SaveBackground(WParam);
             RepaintButtons(dsDrawTRN, WParam);
           end
           else begin
             Result := CallWindowProc(FDefWndProc, Owner.Handle, Msg, WParam, LParam);
             SaveBackground(WParam);
             RepaintButtons(dsDrawALL, WParam);
           end;
         end
       end;
      WM_ERASEBKGND:
       begin
         if boNCPainting in Options then UpdateDeviceRegion(WParam);
       end;
      WM_MOUSEMOVE, WM_NCMOUSEMOVE:
       begin
         if _getFlag(FFlags, BS_KEYMOVING) then
         begin
          _setFlag(FFlags, BS_KEYMOVING, False);
           if FActiveButton <> nil then FActiveButton.invalidate;
         end;
         GetCursorPos(Pos);
         UpdateButtonsOnClick(Pos.X, Pos.Y, True);
       end;
      WM_LBUTTONDOWN, WM_LBUTTONDBLCLK,
      WM_NCLBUTTONDOWN, WM_NCLBUTTONDBLCLK:
       begin
         if not(csDesigning in FOwner.ComponentState) then
         begin
           GetCursorPos(Pos);
           if MouseInButtonArea(Pos.X, Pos.Y, Button) then
           begin
             _setFlag(FFlags, BS_BUTTONDOWN, True);
             lInherited := False;
             Result := CallWindowProc(FDefWndProc, FOwner.Handle, Msg, WParam, LParam);
           end;
           UpdateButtonsOnClick(Pos.X, Pos.Y, False);
         end;
       end;
      WM_LBUTTONUP, WM_NCLBUTTONUP:
       begin
         _setFlag(FFlags, BS_BUTTONDOWN, False);
         GetCursorPos(Pos);
         if MouseInButtonArea(Pos.X, Pos.Y, Button) then
         begin
           Result := CallWindowProc(FDefWndProc, FOwner.Handle, Msg, WParam, LParam);
           lInherited := False;
         end;
         UpdateButtonsOnClick(Pos.X, Pos.Y, False);
       end;
      WM_SETFOCUS, WM_KILLFOCUS:
      begin
        DoChangeFocus;
      end;
      WM_SETCURSOR:
       if not(csDesigning in FOwner.ComponentState) then
       begin
         GetCursorPos(Pos);
         if MouseInButtonArea(Pos.X, Pos.Y, Button) and
           Button.Enabled then
         begin
           lInherited := not Button.WMSetCursor(TWMSetCursor(Message),
             Pos.X, Pos.Y);
         end;
       end;
    end;
    if lInherited then
      Result := CallWindowProc(FDefWndProc, FOwner.Handle, Msg, WParam, LParam);
  end;
end;

function TDCEditButtons.FindButton(AName: string): TDCEditButton;
 var
  i: integer;
begin
  Result := nil;
  for i := 0 to FButtons.Count-1 do
  begin
    if AnsiCompareText(AName, TDCEditButton(FButtons.Items[i]).Name) = 0 then
    begin
      Result := TDCEditButton(FButtons.Items[i]);
      Break;
    end;
  end;
end;

function TDCEditButtons.GetButton(Index: integer): TDCEditButton;
begin
  Result := TDCEditButton(FButtons.Items[Index]);
end;

function TDCEditButtons.GetButtonsRect: TRect;
 var
  i, c: integer;
  Button: TDCEditButton;
  R: TRect;
begin
  SetRectEmpty(Result);
  c := Count - 1;
  for i := 0 to c do
  begin
    Button := Buttons[i];
    with Button do
      if Visible then
      begin
        R := Rect(Left, Top, Left + Width, Top + Height);
        UnionRect(Result,Result,R);
      end;
  end;
end;

function TDCEditButtons.GetCount: integer;
begin
  Result := FButtons.Count;
end;

function TDCEditButtons.GetEnabled: boolean;
 var
  i: integer;
begin
  Result := False;
  for i := 0 to Count-1 do
  begin
    if Result then Break;
    Result := Buttons[i].Enabled;
  end;
end;

procedure TDCEditButtons.Invalidate;
begin
  RepaintButtons(dsDrawAll, 0);
end;

function TDCEditButtons.MouseInButtonArea(XPos, YPos: integer;
  var Button: TDCEditButton): boolean;
 var
  i, X, Y: integer;
  P: TPoint;
  Rgn: HRGN;
begin
  Result := False;
  Rgn := GetRegion;
  if not IsRegionEmpty(Rgn) then
  begin
    P := FOwner.ScreenToClient(Point(XPos, YPos));
    try
      if not PtInRegion(Rgn, P.X, P.Y) then
        Exit;
    finally
      DeleteObject(Rgn);
    end;
  end;
  for i := 0 to Count-1 do
  begin
    if Buttons[i].AbsolutePos then
    begin
      P := Point(FOwner.Left,FOwner.Top);
      X := XPos - P.X;
      Y := YPos - P.Y;
    end
    else begin
      P := FOwner.ScreenToClient(Point(XPos, YPos));
      X := P.X;
      Y := P.Y;
    end;
    Result := Buttons[i].MouseInRect(X, Y);
    if Result then begin
      Button := Buttons[i];
      Break;
    end;
  end;
end;

procedure TDCEditButtons.MoveButton(CurIndex, NewIndex: integer);
begin
  FButtons.Move(CurIndex, NewIndex);
  UpdateIndex;
  DoChange;
end;

procedure TDCEditButtons.OffsetButtons(Pos: TPoint);
 var
  i: integer;
  Button: TDCEditButton;
begin
  for i := 0 to Count-1 do
  begin
     Button := Buttons[i];
     with Button do
       case AnchorStyle of
         asNone:;
         asTR  :
           SetBounds(Rect(Left+Pos.X, Top, Width, Height));
         asBL  :
           SetBounds(Rect(Left, Top+Pos.Y, Width, Height));
         asBR  :
           SetBounds(Rect(Left+Pos.X, Top+Pos.Y, Width, Height));
         asTBL :
           SetBounds(Rect(Left, Top, Width, Height+Pos.Y));
         asTBR :
           SetBounds(Rect(Left+Pos.X, Top, Width, Height+Pos.Y));
         asTBLR:
           SetBounds(Rect(Left, Top, Width+Pos.X, Height+Pos.Y));
         asTLR :
           SetBounds(Rect(Left, Top, Width+Pos.X, Height));
         asBLR :
           SetBounds(Rect(Left, Top+Pos.Y, Width+Pos.X, Height));
         asTCn:
           SetBounds(Rect(Left+Pos.X div 2, Top, Width, Height));
         asCnR:
           SetBounds(Rect(Left+Pos.X, Top + Pos.Y div 2, Width, Height));
       end;
     if boNCPainting in Options then Button.invalidate;
  end;
end;

procedure TDCEditButtons.ReadData(Stream: TStream);
var
  I, Count: Integer;
  ButtonInfo: TButtonInfo;
  Button: TDCEditButton;
begin
  Stream.ReadBuffer(Count, SizeOf(Count));
  for I := 0 to Count - 1 do
  begin
    Button := AddButton;
    Button.ReadData(Stream, @ButtonInfo);
  end;
end;

procedure TDCEditButtons.WriteData(Stream: TStream);
var
  i: Integer;
  ButtonInfo: TButtonInfo;
begin
  i := Count;
  Stream.WriteBuffer(i, SizeOf(Integer));
  for i :=0 to Count-1 do
    Buttons[i].WriteData(Stream, @ButtonInfo);
end;

procedure TDCEditButtons.RepaintButtons(ADrawStyle: TButtonTypeDrawStyle;
  DrawContext: HDC; AClip: HRGN = NULLREGION);
 var
  i: integer;
  Button: TDCEditButton;
  DC: HDC;

begin
  if FOwner.HandleAllocated then
  begin
    if FUpdateCount = 0 then
    begin
      if DrawContext = 0 then
        DC := GetDCEx(FOwner.Handle, _iif(AClip = NULLREGION, 0, AClip), 
          DCX_WINDOW or DCX_CACHE or DCX_CLIPSIBLINGS)
      else
        DC := DrawContext;
      try
        for i := 0 to Count-1 do
        begin
          Button := Buttons[i];
          if Button.Visible then
          begin
          case ADrawStyle of
            dsDrawAll:
              Button.Paint(DC, AClip);
            dsDrawTRN:
              if boTransparent in Button.Options then Button.Paint(DC, AClip);
            dsDrawNotTRN:
              if not(boTransparent in Button.Options) then Button.Paint(DC, AClip);
          end;
          end;
        end;
      finally
        if DrawContext = 0 then ReleaseDC(FOwner.Handle, DC);
      end;
    end;
  end;
end;

procedure TDCEditButtons.ResetProperties;
 var
  i: integer;
begin
  for i := 0 to Count-1 do Buttons[i].ResetProperties;
  ActiveButton := nil;
end;

procedure TDCEditButtons.SetButton(Index: integer;
  const Value: TDCEditButton);
begin
  FButtons.Items[Index] := Value;
end;

procedure TDCEditButtons.SetEnabled(const Value: boolean);
 var
  i: integer;
begin
  for i := 0 to Count-1 do Buttons[i].Enabled := Value;
end;

procedure TDCEditButtons.SetImages(const Value: TCustomImageList);
 var
  i: integer;
begin
  FImages := Value;
  for i := 0 to Count-1 do
    Buttons[i].Images := Value;
  RepaintButtons(dsDrawAll, 0);
end;

procedure TDCEditButtons.SetWndProc;
begin
  if not Assigned(FDefWndProc) then
     FDefWndProc := Pointer(GetWindowLong(FOwner.Handle, GWL_WNDPROC));
  SetWindowLong(FOwner.Handle, GWL_WNDPROC, LongInt(FNewWndProc));
  _setFlag(FFlags, BS_PROCCLEAR, False);
end;

function TDCEditButtons.UpdateButtons(XPos, YPos: integer; ADown, AMove: boolean): boolean;
 var
  X, Y, i, c: integer;
  AActiveButton, Button: TDCEditButton;
  P: TPoint;
  DownState: boolean;
begin
  Result := False;
  c := Count;

  if (csDesigning in FOwner.ComponentState) or (Count = 0) then  Exit;
  AActiveButton := FActiveButton;
  FActiveButton := nil;

  DownState := False;
  Dec(c);

  for i := 0 to c do
  begin
    DownState := _getFlag(Buttons[i].FFlags, EB_DOWNSTATE);
    if DownState then Break;
  end;

  for i := 0 to c do
  begin
    Button := Buttons[i];
    if Button.AbsolutePos then
    begin
      P := Point(FOwner.Left, FOwner.Top);
      X := XPos - P.X;
      Y := YPos - P.Y;
    end
    else begin
      P := FOwner.ScreenToClient(Point(XPos, YPos));
      X := P.X;
      Y := P.Y;
    end;
    if not DownState or _getFlag(Button.FFlags, EB_DOWNSTATE) then
    begin
      if Button.MouseInRect(X, Y) then
      begin
        FActiveButton := Button;
        if ADown and not AMove then FocusedButton := Button;
      end;
      Result := Button.UpdateButtonState(X, Y, ADown, AMove);
    end;
  end;

  if (FActiveButton <> nil) and ((AActiveButton <> nil) and
    (FActiveButton.Index <> AActiveButton.Index) or (AActiveButton = nil)) then
    FActiveButton.DrawHint(0);

  if (FActiveButton = nil) and (AActiveButton <> nil) then
    AActiveButton.DrawHint(1);
end;

function TDCEditButtons.UpdateButtonsOnClick(X, Y: integer; AMove: boolean): boolean;
 var
  ButtonUpdate: boolean;
  Button: TDCEditButton;
begin
  Result := False;
  if FOwner = nil then Exit;
  if Count > 0 then
  begin
    ButtonUpdate := UpdateButtons(X, Y, _getFlag(FFlags, BS_BUTTONDOWN), AMove);
    if ButtonUpdate and MouseInButtonArea(X, Y, Button) then Result := True
  end;
end;

procedure TDCEditButtons.UpdateDeviceRegion(DC: HDC);
 var
  i: integer;
  Button: TDCEditButton;
  HP: TPoint;
  HC: TRect;
begin
  HP := Point(0,0);
  with FOwner do
  begin
    HP := ClientToScreen(Point(0,0));
    GetWindowRect(Handle, HC);
    HP.X := HP.X - HC.Left;
    HP.Y := HP.Y - HC.Top;
  end;

  for i := 0 to Count-1 do
  begin
    Button := Buttons[i];
    with Button do
      if Visible and not(boTransparent in Options) then
        if AbsolutePos then
          ExcludeClipRect(DC, Left, Top, Left + Width, Top + Height)
        else
          ExcludeClipRect(DC, Left - HP.X, Top - HP.Y, Left + Width - HP.X,
            Top + Height - HP.Y);
  end;

end;

procedure TDCEditButtons.UpdateIndex;
 var
  i: integer;
begin
  for i:=0 to FButtons.Count-1 do
    TDCEditButton(FButtons[i]).FIndex := i;
end;

procedure TDCEditButtons.UpdateMouseInControl(Value: boolean);
 var
  i: integer;
begin
  if not _chkFlag(FFlags, BS_MOUSEINCTRL, Value) then
  begin
    _setFlag(FFlags, BS_MOUSEINCTRL, Value);
    for i := 0 to FButtons.Count-1 do Buttons[i].MouseInControl := Value;
  end;
end;

procedure TDCEditButtons.SetColor(const Value: TColor);
 var
  i: integer;
  Button: TDCEditButton;
begin
  for i := 0 to FButtons.Count-1 do
  begin
    Button := TDCEditButton(Items[i]);
    if Button.BrushColor = FColor then Button.BrushColor := Value;
  end;
  FColor := Value;
end;

function TDCEditButtons.IsButtonAccel(VK: Word;
  var Button: TDCEditButton): Boolean;
 var
  i: integer;
  eButton: TDCEditButton;
begin
  Result := False;
  Button := nil;
  for i := 0 to FButtons.Count - 1 do
  begin
    eButton := TDCEditButton(FButtons[i]);
    if eButton.Enabled and eButton.Visible and
       IsAccel(Ord(AnsiUpperCase(Chr(VK))[1]), AnsiUpperCase(eButton.Caption)) then
    begin
      Button := TDCEditButton(FButtons[i]);
      Result := True;
      Break;
    end;
  end;
end;

function TDCEditButtons.GetSelectedButton: TDCEditButton;
 var
  Button: TDCEditButton;
  i: integer;
begin
  Result := ActiveButton;
  if (Result <> nil) and (Result.ButtonState <> btDownMouseInRect) then
  begin
    Result := nil;
    for i := 0 to Count - 1 do
    begin
      Button := Buttons[i];
      if Button.ButtonState = btDownMouseInRect then
      begin
        Result := Button;
        Break;
      end;
    end;
  end;
end;

procedure TDCEditButton.SetDownClick(const Index: Integer; const Value: boolean);
begin
  if not _getFlag(FFlags, EB_DOWNCLICK) and
    (ButtonState <> btDownMouseInRect) then _setFlag(FFlags, EB_BUTTONDOWN, False);

  if Value and (FEventStyle = esDropDown) and
    (ButtonState = btDownMouseInRect) then  _setFlag(FFlags, EB_BUTTONDOWN, True);

  _setFlag(FFlags, EB_DOWNCLICK, Value);
end;

procedure TDCEditButtons.SetActiveButton(const Value: TDCEditButton);
begin
  FActiveButton := Value;
end;

procedure TDCEditButtons.BeginUpdate;
begin
  Inc(FUpdateCount);
end;

procedure TDCEditButtons.EndUpdate;
begin
  Dec(FUpdateCount);
  if (FUpdateCount = 0) and FOwner.Visible then RepaintButtons(dsDrawAll, 0);
end;

function TDCEditButtons.AddButtonEx(
  EditButtonClass: TEditButtonClass; Data: integer = 0): TDCEditButton;
 var
  AIndex: integer;
begin
  Result := EditButtonClass.Create(FOwner);
  AIndex := FButtons.Add(Result);

  Result.FButtonHolder := IDCButtonHolder(Self);
  Result.Name := Format('%s%d', [Result.Name, AIndex]);
  Result.Grouped := True;
  Result.AnchorStyle := AnchorStyle;
  Result.AbsolutePos := boAbsolutePos in Options;
  Result.Images := FImages;
  Result.FIndex := AIndex;
  Result.BrushColor := FColor;
end;

procedure TDCEditButtons.DoChangeFocus;
 var
  i: integer;
begin
  for i := 0 to Count-1 do
  begin
    if boFocusSensitive in Buttons[i].Options then Buttons[i].invalidate;
  end;
end;

function TDCEditButtons.GetButtonsActive: boolean;
 var
  Button: TDCEditButton;
  i: integer;
begin
  Result := False;
  for i := 0 to Count - 1 do
  begin
    Button := Buttons[i];
    if Button.ButtonState <> btRest then
    begin
      Result := True;
      Break;
    end;
  end;
end;

procedure TDCEditButtons.SaveBackground(DrawContext: HDC);
 var
  DC: HDC;
  R: TRect;
begin
  if NeedSaveBackground then
  begin
    if DrawContext = 0 then
      DC := GetWindowDC(Owner.Handle)
    else
      DC := DrawContext;

    GetWindowRect(Owner.Handle, R); OffsetRect(R,  -R.Left, -R.Top);
    try
      with FBkgImage do
      begin
        Width  := R.Right;
        Height := R.Bottom;
        BitBlt(Canvas.Handle, 0, 0, Width, Height, DC, 0, 0, SRCCOPY);
      end;
    finally
      if DrawContext = 0 then ReleaseDC(Owner.Handle, DC)
    end;
  end;
end;

procedure TDCEditButtons.PaintBackground(ARect: TRect; AButton: TDCEditButton;
 ACanvas: TCanvas);
begin
  BitBlt(ACanvas.Handle, ARect.Left, ARect.Top, ARect.Right - ARect.Left,
   ARect.Bottom - ARect.Top, FBkgImage.Canvas.Handle, AButton.Left, AButton.Top,
   SRCCOPY);
end;

procedure TDCEditButtons.UpdateMaxImageWidth;
 var
  i, MaxWidth: integer;
  Button: TDCEditButton;
begin
  MaxWidth := 0;
  for i := 0 to Count-1 do
  begin
    Button := Buttons[i];
    with Button do
    begin
      if (Caption <> MenuLineCaption) then
        MaxWidth := _intMax(Button.GetGlyphWidth, MaxWidth);
    end;
    FMaxImageWidth := MaxWidth;
  end;
end;

procedure TDCEditButtons.DoChange;
begin
  if not(esDestroying in FControlState) then
  begin
    if Assigned(FOnChange) then FOnChange(Self);
  end;  
end;

function TDCEditButtons.DoKeyDown(var Message: TMessage): boolean;
 var
  ShiftState: TShiftState;
begin
  Result := True;
  with Message do
  begin
    ShiftState := KeyDataToShiftState(Message.LParam);
    KeyDown(TWMKeyDown(Message).CharCode, ShiftState);
  end;
end;

procedure TDCEditButtons.KeyDown(var Key: Word; Shift: TShiftState);
begin
  if Active then
  begin
    _setFlag(FFlags, BS_KEYMOVING, True);
    case Key of
      VK_TAB:
        if ssShift in Shift then
          SelectMoveBy(FActiveButton, -1, False)
        else
          SelectMoveBy(FActiveButton, 1, False);
      VK_RETURN:
        if (FActiveButton <> nil) and FActiveButton.Enabled then
          FActiveButton.Click;
      VK_UP, VK_PRIOR:
        SelectMoveBy(FActiveButton, -1, False);
      VK_DOWN, VK_NEXT:
        SelectMoveBy(FActiveButton, 1, False);
      VK_HOME:
        SetActiveIndex(0, True);
    end;
  end;
end;

procedure TDCEditButtons.SelectMoveBy(AButton: TDCEditButton;
  Delta: integer; Focused: boolean);
 var
  i: integer;
begin
  if AButton <> nil then
  begin
    i := AButton.Index;
    if Delta > 0 then
      if i < Count - Delta then Inc(i, Delta) else i := Delta + i - Count
    else
      if (i + Delta) >= 0 then Inc(i, Delta) else i := Count + Delta + i;
  end
  else
    i := 0;

  if Focused then
    SetFocusedIndex(i, Delta > 0)
  else
    SetActiveIndex(i, Delta > 0)
end;

procedure TDCEditButtons.SetButtonState(Button: TDCEditButton; Select: boolean);
 const
   AStates: array[boolean] of TButtonState = (btRest, btRestMouseInRect);
begin
  with Button do
  begin
    ButtonState := AStates[Select];
    Invalidate;
  end;
end;

procedure TDCEditButtons.SetActiveIndex(Index: integer; MovingDown: boolean);
begin
  if (FActiveButton <> nil) and (FActiveButton.Index = Index) then Exit;
  if FActiveButton <> nil then SetButtonState(FActiveButton, False);

  FActiveButton := GetValidButton(Index, MovingDown);
  if FActiveButton = nil then FActiveButton := GetValidButton(0, MovingDown);

  SetButtonState(FActiveButton, True);
end;

function TDCEditButtons.NeedSaveBackground: boolean;
 var
  i: integer;
begin
  Result := False;
  i := 0;
  while not Result and (i < Count) do
  begin
    with Items[i] do
      Result := Visible and (boTransparent in Options);
    Inc(i)
  end;
end;

procedure TDCEditButtons.Notify(Button: TDCEditButton;
  Action: TDCButtonAction);
begin
  if Action = acDestroy then
  begin
    if FFocusedButton = Button then FFocusedButton := nil;
  end
  else
    if FUpdateCount = 0 then Button.invalidate;
end;

function TDCEditButtons._AddRef: Integer;
begin
  Result := -1;
end;

function TDCEditButtons._Release: Integer;
begin
  Result := -1;
end;

function TDCEditButtons.QueryInterface(const IID: TGUID; out Obj): HResult;
begin
  Pointer(Obj) := Self;
  Result := S_OK;
end;

function TDCEditButtons.GetActiveButton: TDCEditButton;
begin
  Result := FActiveButton;
end;

function TDCEditButtons.GetWinControl: TWinControl;
begin
  Result := FOwner;
end;

function TDCEditButtons.GetMaxImageWidth: integer;
begin
  Result := FMaxImageWidth
end;

function TDCEditButtons.UpdateCount: integer;
begin
  Result := FUpdateCount;
end;

function TDCEditButtons.ButtonVisible(Sender: TDCEditButton): boolean;
begin
  Result := _getFlag(Sender.FFlags, EB_VISIBLE);
end;

procedure TDCEditButtons.Destroying;
begin
  Include(FControlState, esDestroying);
end;

function TDCEditButtons.GetFlagvalue(const Index: Integer): boolean;
begin
  Result := _getFlag(FFlags, Index)
end;

procedure TDCEditButtons.SetFlagValue(const Index: Integer;
  const Value: boolean);
begin
  _setFlag(FFlags, Index, Value);
end;

function TDCEditButtons.GetCanvas: TCanvas;
begin
  Result := FCanvas;
end;

function TDCEditButtons.GetValidButton(Index: integer; MovingDown: boolean): TDCEditButton;
begin
  repeat
    Result := Buttons[Index];
    if MovingDown then Inc(Index) else Dec(Index)
  until (Index < 0) and (Index > Count) or
    ((boSelectable in Result.Options) and Result.Visible and
    (Result.Caption <> MenuLineCaption));
  if Index > Count then Result := nil;
end;

procedure TDCEditButtons.SetFocusedIndex(Index: integer; MovingDown: boolean);
 var
  OFocusedButton: TDCEditButton;
begin
  if (FFocusedButton <> nil) and (FFocusedButton.Index = Index) then Exit;
  OFocusedButton := FFocusedButton;

  FFocusedButton := GetValidButton(Index, MovingDown);
  if FFocusedButton = nil then FFocusedButton := GetValidButton(0, MovingDown);

  if Assigned(OFocusedButton) then OFocusedButton.Invalidate;
  if Assigned(FFocusedButton) then FFocusedButton.Invalidate;
end;

procedure TDCEditButtons.SetFocusedButton(const Value: TDCEditButton);
begin
  SetFocusedIndex(Value.Index, True);
end;

function TDCEditButtons.GetFocusedButton: TDCEditButton;
begin
  Result := FFocusedButton;
end;

{ TDCHintButton }

constructor TDCHintButton.Create(AOwner: TComponent);
begin
  inherited;
  Style := stNone;
end;

procedure TDCHintButton.DrawBorder(ACanvas: TCanvas; ARect: TRect);
 const
  HintEllipseRadius = 3;

 var
  AButtonState: TButtonState;
  Rgn: HRgn;
  nEllipse: integer;

  procedure DrawNormalHintButton(ACanvas: TCanvas; ARect: TRect);
   begin
    InflateRect(ARect, -1,-1);
    with ARect do
      Rgn := CreateRoundRectRgn(Left, Top, Right, Bottom, nEllipse, nEllipse);

    ACanvas.Pen.Style := psSolid;
    ACanvas.Brush.Color := clHintBackground;
    PaintRgn(ACanvas.Handle, Rgn);

    ACanvas.Brush.Color := clHintNormal;
    FrameRgn(ACanvas.Handle, Rgn, ACanvas.Brush.Handle, 1, 1);
    DeleteObject(Rgn)
  end;

  procedure DrawUpHintButton(ACanvas: TCanvas; ARect: TRect);
   var
    i: integer;
    AColor: TColor;
  begin
    with ARect do
      Rgn := CreateRoundRectRgn(Left, Top, Right, Bottom, nEllipse, nEllipse);

    ACanvas.Pen.Style := psSolid;
    ACanvas.Brush.Color := clHintBackground;
    PaintRgn(ACanvas.Handle, Rgn);

    ACanvas.Brush.Color := clHintLight;
    FrameRgn(ACanvas.Handle, Rgn, ACanvas.Brush.Handle, 1, 1);
    DeleteObject(Rgn);

    ACanvas.Pen.Color   := clHintDark;
    with ARect do
    begin
      ACanvas.PolyLine([Point(Right-3, Top+3), Point(Right-3, Bottom-5),
                        Point(Right-4, Bottom-4), Point(Right-5, Bottom-3),
                        Point(Left+2, Bottom-3)]);
      ACanvas.Pixels[Right-3, Top+2]    := clHintNormal;
      ACanvas.Pixels[Left+2 , Bottom-4] := clHintNormal;
    end;

    ACanvas.Pen.Color   := clHintBackground;
    InflateRect(ARect, -5, -5);
    for i := 1 to 4 do
    begin
      InflateRect(ARect, 1, 1);
      AColor := ACanvas.Pen.Color;
      ACanvas.Pen.Color   := RGB(GetRValue(AColor)-5, GetGValue(AColor)-5, GetBValue(AColor)-5);
      with ARect do
      begin
        ACanvas.PolyLine([Point(Right-3, Top+3), Point(Right-3, Bottom-5),
                          Point(Right-4, Bottom-4), Point(Right-5, Bottom-3),
                          Point(Left+2, Bottom-3)]);
        ACanvas.Pixels[Right-3, Top+2]    := AColor;
        ACanvas.Pixels[Left+2 , Bottom-4] := AColor;
      end;
    end;
  end;

  procedure DrawDownHintButton(ACanvas: TCanvas; ARect: TRect);
  var
    i: integer;
    AColor: TColor;
  begin
    with ARect do
      Rgn := CreateRoundRectRgn(Left, Top, Right, Bottom, nEllipse, nEllipse);

    ACanvas.Pen.Style := psSolid;
    ACanvas.Brush.Color := clHintBackground;
    PaintRgn(ACanvas.Handle, Rgn);

    ACanvas.Brush.Color := clHintLight;
    FrameRgn(ACanvas.Handle, Rgn, ACanvas.Brush.Handle, 1, 1);
    DeleteObject(Rgn);

    ACanvas.Pen.Color   := clHintDark;
    with ARect do
    begin
      ACanvas.PolyLine([Point(Left+1, Bottom-5),
                        Point(Left+1, Top+3), Point(Left+2, Top+2),
                        Point(Left+3, Top+1), Point(Right-4,Top+1)]);
      ACanvas.Pixels[Right-4, Top+2]    := clHintNormal;
      ACanvas.Pixels[Left+1 , Bottom-4] := clHintNormal;
    end;

    ACanvas.Pen.Color   := clHintBackground;
    InflateRect(ARect, -5, -5);
    for i := 1 to 4 do
    begin
      InflateRect(ARect, 1, 1);
      AColor := ACanvas.Pen.Color;
      ACanvas.Pen.Color   := RGB(GetRValue(AColor)-5, GetGValue(AColor)-5, GetBValue(AColor)-5);
      with ARect do
      begin
        ACanvas.PolyLine([Point(Left+1, Bottom-5),
                          Point(Left+1, Top+3), Point(Left+2, Top+2),
                          Point(Left+3, Top+1), Point(Right-4,Top+1)]);
        ACanvas.Pixels[Right-4, Top+2]    := AColor;
        ACanvas.Pixels[Left+1 , Bottom-4] := AColor;
      end;
    end;
  end;

begin
  AButtonState := FButtonState;
  if not Enabled then AButtonState := btRest;

  nEllipse := HintEllipseRadius;

  case AButtonState of
    btRest:
      begin
        if (csDesigning in (FOwner as TComponent).ComponentState) then
        begin
          DrawNormalHintButton(ACanvas, ARect);
        end
        else
          DrawNormalHintButton(ACanvas, ARect);
      end;
    btDownMouseInRect:
      begin
        DrawDownHintButton(ACanvas, ARect);
      end;
    btRestMouseInRect:
      begin
        DrawUpHintButton(ACanvas, ARect);
      end;
  end;
  if FButtonHolder.FocusedButton = Self then
  begin
    InflateRect(ARect, -HintEllipseRadius, -HintEllipseRadius);
    if AButtonState = btDownMouseInRect then OffsetRect(ARect, 1, 1);
    with ARect do
      Rgn := CreateRoundRectRgn(Left, Top, Right, Bottom, nEllipse, nEllipse);

    ACanvas.Brush.Color := clXPSelected;
    FrameRgn(ACanvas.Handle, Rgn, ACanvas.Brush.Handle, 1, 1);
    DeleteObject(Rgn);
  end;
end;

{ TDCCheckButton }

procedure TDCCheckButton.Changed;
begin
  {}
end;

procedure TDCCheckButton.Click;
begin
  if Toggle then inherited;
end;

constructor TDCCheckButton.Create(AOwner: TComponent);
begin
  inherited;
  FCheckBoxSize := 10;
  DisableStyle := deTrans;
  Style := stNone;
  Options := Options + [boTransparent];

  _setFlag(FFlags, EB_AUTOSIZE, True);

  inherited Alignment := abLeft;
end;

procedure TDCCheckButton.DrawBorder(ACanvas: TCanvas; ARect: TRect);
begin
  {Nothing}
end;

procedure TDCCheckButton.DrawCheckBox(ACanvas: TCanvas; ARect: TRect);
 var
  RBrush: HBRUSH;
  DrawInfo: TCheckDrawInfo;
begin
  GetCheckDrawInfo(DrawInfo);
  
  RBrush := CreateSolidBrush(ColorToRGB(DrawInfo.FrameColor));
  try
    FrameRect(ACanvas.Handle, ARect, RBrush);
  finally
    DeleteObject(RBrush);
  end;

  RBrush := CreateSolidBrush(ColorToRGB(DrawInfo.BrushColor));
  try
    InflateRect(ARect, -1, -1);
    FillRect(ACanvas.Handle, ARect, RBrush);
    InflateRect(ARect, -1, -1);
    if Checked then
      DrawBasicShape(ACanvas.Handle, shCheck, ARect.Left, ARect.Top,
        DrawInfo.PenColor, szSmall);
  finally
    DeleteObject(RBrush);
  end;
end;

procedure TDCCheckButton.DrawEditText(ACanvas: TCanvas;
  var TextRect: TRect);
 var
  R: TRect;
begin
  R := GetStateRect(TextRect);
  if not IsRectEmpty(R) then
  begin
    DrawCheckBox(ACanvas, R);
    case FAlignment of
      taRightJustify: TextRect.Left  := R.Right + 5;
      taLeftJustify : TextRect.Right := R.Left - 4;
    end;
  end;
  inherited DrawEditText(ACanvas, TextRect);
end;

procedure TDCCheckButton.GetCheckDrawInfo(var DrawInfo: TCheckDrawInfo);
begin
  with DrawInfo do
  begin
    if Enabled then
    begin
      case FButtonState of
        btDownMouseInRect:
          begin
            BrushColor := clXPDropDown;
            PenColor := clWhite;
            FrameColor := clHighlight;
          end;
        btRestMouseInRect:
          begin
            BrushColor := clXPSelected;
            PenColor := clNavy;
            FrameColor := clHighlight;
          end;
        btRest:
          begin
            BrushColor := clXPLightBackground;
            PenColor := clBlack;
            FrameColor := clBtnShadow;
          end;
        else begin
          BrushColor := clXPLightBackground;
          PenColor := clBlack;
          FrameColor := clBtnShadow;
        end;
      end;
    end
    else begin
      BrushColor := clXPDarkBackground;
      PenColor := clBlack;
      FrameColor := clBtnShadow;
    end;
  end;
end;

function TDCCheckButton.GetChecked: Boolean;
begin
  Result := State = cbChecked;
end;

function TDCCheckButton.GetStateRect(R: TRect): TRect;
 var
  ATop: integer;
begin
  if R.Bottom + R.Top < FCheckBoxSize then
  begin
    SetRectEmpty(Result);
    Exit;
  end
  else begin
    ATop := (R.Bottom + R.Top - FCheckBoxSize) shr 1;
    case FAlignment of
      taRightJustify:
        Result := Rect(R.Left, ATop, R.Left + FCheckBoxSize, ATop + FCheckBoxSize);
      taLeftJustify:
        Result := Rect(R.Left + Width - FCheckBoxSize - BT_MARGINS, ATop,
          R.Left + Width - BT_MARGINS, ATop + FCheckBoxSize);
    end;
  end;
end;

function TDCCheckButton.GetTextSize: TPoint;
begin
  Result := inherited GetTextSize;
  Inc(Result.X, FCheckBoxSize + 5 + BT_MARGINS shr 1 - 1);
end;

procedure TDCCheckButton.InvalidateState;
begin
  Invalidate;
end;

procedure TDCCheckButton.SetAlignment(const Value: TLeftRight);
begin
  if FAlignment <> Value then
  begin
    FAlignment := Value;
    invalidate;
  end;
end;

procedure TDCCheckButton.SetChecked(const Value: Boolean);
begin
  if Value then State := cbChecked else State := cbUnchecked;
end;

procedure TDCCheckButton.SetState(const Value: TCheckBoxState);
begin
  if FState <> Value then
  begin
    FState := Value;
    Changed;
    InvalidateState;
  end;
end;

function TDCCheckButton.Toggle: boolean;
begin
  if Enabled then
  begin
    case State of
      cbUnchecked:
        if AllowGrayed then State := cbGrayed else State := cbChecked;
      cbChecked:
        State := cbUnchecked;
      cbGrayed:
        State := cbChecked;
    end;
    Result := True;
  end
  else
    Result := False;
end;

{ TDCLinkButton }

procedure TDCLinkButton.BeginDrawText(ACanvas: TCanvas; ATextRect: TRect;
  AState: TButtonState);
begin
  if Enabled then with ACanvas do
  begin
    case FButtonState of
      btDownMouseInRect, btRestMouseInRect:
        Font.Style := Font.Style + [fsUnderline];
      else
        Font.Style := Font.Style - [fsUnderline];
    end;
  end
  else
    Font.Style := Font.Style - [fsUnderline];
end;

constructor TDCLinkButton.Create(AOwner: TComponent);
begin
  inherited;
  Options := Options - [boStateRegardless];
end;

{ TDCTextButton }

constructor TDCTextButton.Create(AOwner: TComponent);
begin
  inherited;
  DisableStyle := deTrans;
  Style := stNone;
  Options := Options + [boTransparent, boDoubleBuffered, boStateRegardless];
  Alignment := abLeft;
  _setFlag(FFlags, EB_WORDWRAP, False);
  _setFlag(FFlags, EB_AUTOSIZE, True);
end;

procedure TDCTextButton.DrawBorder(ACanvas: TCanvas; ARect: TRect);
begin
  {Nothing}
end;

function TDCTextButton.GetTextSize: TPoint;
begin
  Result := inherited GetTextSize;
  Inc(Result.Y, 3);
end;

{ TDCRadioButton }

procedure TDCRadioButton.Changed;
 var
  i: integer;
  Button: TDCEditButton;
begin
  inherited;
  if Checked and (FButtonHolder <> nil) then
  begin
    for i := 0 to FButtonHolder.Count - 1 do
    begin
      Button := FButtonHolder.Items[i];
      if (Button is TDCRadioButton) and (Button <> Self) then
        with TDCRadioButton(Button) do
          if (Button <> Self) and Checked then Checked := False;
    end;
  end;
end;

constructor TDCRadioButton.Create(AOwner: TComponent);
begin
  inherited;
  Inc(FCheckBoxSize); 
end;

procedure TDCRadioButton.DrawCheckBox(ACanvas: TCanvas; ARect: TRect);
 var
  DrawInfo: TCheckDrawInfo;
begin
  GetCheckDrawInfo(DrawInfo);

  with ACanvas do
  begin
    Brush.Color := DrawInfo.BrushColor;
    Pen.Color := DrawInfo.FrameColor;
    {$IFDEF DELPHI_V5UP}
      Ellipse(ARect)
    {$ELSE}
      Ellipse(ARect.Left, ARect.Top, ARect.Right, ARect.Bottom);
    {$ENDIF}
  end;

  if Checked then
  begin
    InflateRect(ARect, -3, -3);
    with ACanvas do
    begin
      Brush.Color := DrawInfo.PenColor;
      Pen.Color := DrawInfo.PenColor;
      {$IFDEF DELPHI_V5UP}
        Ellipse(ARect)
      {$ELSE}
        Ellipse(ARect.Left, ARect.Top, ARect.Right, ARect.Bottom);
      {$ENDIF}
    end;
  end;
end;

function TDCRadioButton.GetStateRect(R: TRect): TRect;
begin
  Result := inherited GetStateRect(R);
  OffsetRect(Result, 0, -1);
end;

function TDCRadioButton.Toggle: boolean;
begin
  if Enabled and (State = cbChecked) then
    Result := False
  else
    Result := inherited Toggle;
end;

procedure CreateSystemBitmap(var ABitmap: TBitmap);
begin
 ABitmap  := TBitmap.Create;
end;

procedure TDCEditButton.Notify(Action: TDCButtonAction);
begin
  if FButtonHolder <> nil then
    FButtonHolder.Notify(Self, Action)
  else
    invalidate
end;

procedure TDCEditButton.AdjustWidth(AWidth: integer);
 var
  R: TRect;
begin
  R := GetImageRect;
  if not IsRectEmpty(R) then
    Inc(R.Right, 5)
  else
    Inc(R.Right, 3);
  Width  := _intMin(Width, AWidth + R.Right - R.Left);
end;

function TDCEditButton.StateChanged(OldState: TButtonState;
  var NewState: TButtonState): boolean;
begin
  Result := True;
  if not(boStateRegardless in Options) then invalidate;
end;

function TDCEditButton.GetCoordValue(const Index: Integer): integer;
begin
  Result := FCoordValues[TDCCoordValue(Index)];
end;

procedure TDCEditButton.SetCoordValue(const Index, Value: integer);
begin
  if FCoordValues[TDCCoordValue(Index)] <> Value then
  begin
    FCoordValues[TDCCoordValue(Index)] := Value;
    Notify(acBoundsChanged);
  end;
end;

initialization
 CreateSystemBitmap(UserBitmap);
 CreateSystemBitmap(GlyphBitmap);

 GlyphBitmap.Transparent := True;
 Screen.Cursors[crLinkSelect] := LoadCursor(hInstance, 'DC_LINKSELECT');

 HookCount := 0;

finalization
 FreeAndNil(UserBitmap);
 FreeAndNil(GlyphBitmap);

end.

