{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x
         Copyright (c) 1998-2001 Alex'EM

}
unit DCDataGridEdit;

{$R-}
{$G+}

interface
{$I DCConst.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  {$IFDEF DELPHI_V6} 
    DesignIntf, DesignEditors, DesignWindows,
  {$ELSE} 
    Dsgnintf, DsgnWnds, 
  {$ENDIF} 
  StdCtrls, Menus, ActnList, ImgList, ComCtrls, ToolWin, ExtCtrls, 
  DCKnotColEdit, DCGrids, DCDataGrid, DCChoice;

type
  TDGDesigner = class;

  TDataFieldsEditor = class(TDesignWindow)
    ToolBar: TToolBar;
    tbNew: TToolButton;
    tbDelete: TToolButton;
    imToolBar: TImageList;
    ColumnsActionList: TActionList;
    aNew: TAction;
    aDelete: TAction;
    aToolBar: TAction;
    aSelectAll: TAction;
    aClear: TAction;
    PopupMenu: TPopupMenu;
    AddField1: TMenuItem;
    Delete1: TMenuItem;
    SelectAll1: TMenuItem;
    N1: TMenuItem;
    ToolBar1: TMenuItem;
    lvFields: TListBox;
    procedure aNewExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lvFieldsClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure aDeleteExecute(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    FDataGrid: TDCCustomDataGrid;
    FDGDesigner: TDGDesigner;
    procedure SaveSelection(List: TListBox; var Selection: TStringList;
      var ItemIndex, TopIndex: Integer; Updated: Boolean);
    procedure SetDataGrid(const Value: TDCCustomDataGrid);
    function CreateDataField: TDataField;
    procedure RemoveFields;
    procedure RestoreSelection(List: TListBox; var Selection: TStringList;
      ItemIndex, TopIndex: Integer; Updated: Boolean);
    procedure UpdateDisplay;
    procedure UpdateFieldList;
    procedure UpdateSelection;
  protected
    function UniqueName(Component: TComponent): string; override;
  public
    destructor Destroy; override;
    {$IFDEF DELPHI_V6}
      procedure ItemDeleted(const ADesigner: IDesigner; AItem: TPersistent); override;
    {$ELSE}
      procedure ComponentDeleted(Component: IPersistent); override;
    {$ENDIF}
    property DataGrid: TDCCustomDataGrid read FDataGrid  write SetDataGrid;
    property DGDesigner: TDGDesigner read FDGDesigner;
  end;

  TDGDesigner = class(TDataGridDesigner)
  private
    FFieldsEditor: TDataFieldsEditor;
  public
    destructor Destroy; override;
    property FieldsEditor: TDataFieldsEditor read FFieldsEditor;
  end;

  TDataFieldsProperty = class(TClassProperty)
  public
    procedure Edit; override;
    function GetValue: string; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  TDataGridEditor = class(TKnotColEditor)
  protected
   {$IFDEF DELPHI_V6}
      procedure EditProperty(const Prop: IProperty;
        var Continue: Boolean); override;
   {$ELSE}
      procedure EditProperty(PropertyEditor: TPropertyEditor;
        var Continue, FreeEditor: Boolean); override;
   {$ENDIF}
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

  TDataGridDataField = class(TStringProperty)
  public
    function  GetAttributes: TPropertyAttributes; override;
    procedure GetValueList(List: TStrings);
    procedure GetValues(Proc: TGetStrProc); override;
  end;

  TDataFieldCreate = class(TCustomForm)
  private
    btCancel: TButton;
    btOk: TButton;
    bvProp: TBevel;
    cbDataType: TDCComboBox;
    edComponent: TDCChoiceEdit;
    edName: TDCChoiceEdit;
    gbProp: TGroupBox;
    lbComponent: TLabel;
    lbDataType: TLabel;
    lbName: TLabel;
  private
    FDataField: TDataField;
    FDataGrid: TDCCustomDataGrid;
    {$IFDEF DELPHI_V6}
      FDesigner: IDesigner;
    {$ELSE}
      FDesigner: IFormDesigner;
    {$ENDIF}
    procedure edNameChange(Sender: TObject);
    procedure btOkClick(Sender: TObject);
    procedure FillDataTypes;
    function GetFieldClass: TDataFieldClass;
    function GetFieldName: string;
    procedure SetDataGrid(const Value: TDCCustomDataGrid);
    procedure SetFieldClass(const Value: TDataFieldClass);
    procedure SetFieldName(const Value: string);
    function GetComponentName: string;
    procedure SetComponentName(const Value: string);
  public
    constructor CreateNew(AOwner: TComponent; Dummy: Integer = 0); override;
    property ComponentName: string read GetComponentName
      write SetComponentName;
    property FieldClass: TDataFieldClass read GetFieldClass write SetFieldClass;
    property FieldName: string read GetFieldName write SetFieldName;
    property Field: TDataField read FDataField;
    property DataGrid: TDCCustomDataGrid read FDataGrid write SetDataGrid;
    {$IFDEF DELPHI_V6}
      property Designer: IDesigner read FDesigner write FDesigner;
    {$ELSE}
      property Designer: IFormDesigner read FDesigner write FDesigner;
    {$ENDIF}
  end;

procedure RegisterDataFields;

{$IFDEF DELPHI_V6}
  procedure CreateDataFieldsEditor(Designer: IDesigner;
    ADataGrid: TDCCustomDataGrid; AName: string);
{$ELSE}
  procedure CreateDataFieldsEditor(Designer: IFormDesigner;
    ADataGrid: TDCCustomDataGrid; AName: string);
{$ENDIF}

function CreateUniqueName(DataGrid: TDCCustomDataGrid; const FieldName: string;
  FieldClass: TDataFieldClass; Component: TComponent): string;

implementation

uses
  DCEditTools;

{$IFDEF DELPHI_V5UP}
  {$R *.DFM}
{$ELSE}
  {$R *.D4F}
{$ENDIF}

const
 bmNew    = 'DBC_NEW';
 bmDelete = 'DBC_DELETE';
 bmAll    = 'DBC_ALL';
 bmDefault= 'DBC_DEFAULT';

procedure RegisterDataFields;
 var
  i: TDataFieldType;
begin
  for i :=  dtString to dtAutoInc do RegisterClass(DataFieldClasses[i]);
end;

{$IFDEF DELPHI_V6}
  procedure CreateDataFieldsEditor(Designer: IDesigner;
    ADataGrid: TDCCustomDataGrid; AName: string);
{$ELSE}
  procedure CreateDataFieldsEditor(Designer: IFormDesigner;
    ADataGrid: TDCCustomDataGrid; AName: string);
{$ENDIF}
var
  FiledsEditor: TDataFieldsEditor;
  i: integer;
begin
  FiledsEditor := nil;

  if ADataGrid = nil then Exit;

  {  If ColumnsEditor fo ADataGrid not found create it esle SetFocus }

  {Attempt to Find it}
  for I := 0 to Screen.FormCount - 1 do
  begin
    if Screen.Forms[I] is TDataFieldsEditor then
    begin
      if (TDataFieldsEditor(Screen.Forms[I]).DataGrid = ADataGrid) and
         (TDataFieldsEditor(Screen.Forms[I]).Name = ADataGrid.Name + '_'+ AName)
      then begin
        { Great!. Find }
        FiledsEditor := TDataFieldsEditor(Screen.Forms[I]);
        Break;
      end;
   end;
  end;

  if FiledsEditor = nil then
  begin
    FiledsEditor := TDataFieldsEditor.Create(Application);
    try
      {$IFDEF DELPHI_V6}
        FiledsEditor.Designer := IDesigner(Designer);
      {$ELSE}
        FiledsEditor.Designer := IFormDesigner(Designer);
      {$ENDIF}
      FiledsEditor.DataGrid := ADataGrid;
      FiledsEditor.Name := ADataGrid.Name + '_' + AName;
      with FiledsEditor do
        Caption := 'Editing ' + DataGrid.Name + '.' + AName;
      FiledsEditor.Show;
    except
      FiledsEditor.Free;
      raise;
    end;
  end
  else begin
    FiledsEditor.Show;
    if FiledsEditor.WindowState = wsMinimized then
      FiledsEditor.WindowState := wsNormal;
  end;
end;

function GenerateName(DataGrid: TDCCustomDataGrid; FieldName: string;
  FieldClass: TDataFieldClass; Number: Integer): string;
var
  Fmt: string;

  procedure CrunchFieldName;
  var
    I: Integer;
  begin
    I := 1;
    while I <= Length(FieldName) do
    begin
      if FieldName[I] in ['A'..'Z','a'..'z','_','0'..'9'] then
        Inc(I)
      else if FieldName[I] in LeadBytes then
        Delete(FieldName, I, 2)
      else
        Delete(FieldName, I, 1);
    end;
  end;

begin
  CrunchFieldName;
  if (FieldName = '') or (FieldName[1] in ['0'..'9']) then
  begin
    if FieldClass <> nil then
      FieldName := FieldClass.ClassName + FieldName
    else
      FieldName := 'Field' + FieldName;
    if FieldName[1] = 'T' then Delete(FieldName, 1, 1);
    CrunchFieldName;
  end;
  Fmt := '%s%s%d';
  if Number < 2 then Fmt := '%s%s';
  Result := Format(Fmt, [DataGrid.Name, FieldName, Number]);
end;

function CreateUniqueName(DataGrid: TDCCustomDataGrid; const FieldName: string;
  FieldClass: TDataFieldClass; Component: TComponent): string;
var
  i: Integer;

  function IsUnique(const AName: string): Boolean;
  var
    i: Integer;
  begin
    Result := False;
    with DataGrid.Owner do
      for i := 0 to ComponentCount - 1 do
        if (Component <> Components[i]) and (CompareText(AName, Components[i].Name) = 0) then Exit;
    Result := True;
  end;

begin
  for i := 1 to MaxInt do
  begin
    Result := GenerateName(DataGrid, FieldName, FieldClass, I);
    if IsUnique(Result) then Exit;
  end;
end;

{ TDataGridEditor }

{$IFDEF DELPHI_V6}
  procedure TDataGridEditor.EditProperty(const Prop: IProperty;
    var Continue: Boolean);
 var
    PropName: string;
  begin
    inherited EditProperty(Prop, Continue);
    if Continue then
    begin
      PropName := Prop.GetName;
      if (CompareText(PropName, 'DATAFIELDS') = 0) then
      begin
        Prop.Edit;
        Continue := False;
      end;
    end;
  end;
{$ELSE}
  procedure TDataGridEditor.EditProperty(PropertyEditor: TPropertyEditor;
    var Continue, FreeEditor: Boolean);
  var
    PropName: string;
  begin
    inherited EditProperty(PropertyEditor, Continue, FreeEditor);
    if Continue then
    begin
      PropName := PropertyEditor.GetName;
      if (CompareText(PropName, 'DATAFIELDS') = 0) then
      begin
        PropertyEditor.Edit;
        Continue := False;
      end;
    end;
  end;
{$ENDIF}

procedure TDataGridEditor.ExecuteVerb(Index: Integer);
begin
  if Index = 1 then
    CreateDataFieldsEditor(Designer, TDCCustomDataGrid(Component), 'Fields')
  else
    inherited;
end;

function TDataGridEditor.GetVerb(Index: Integer): string;
begin
  case Index of
    1: Result := '&DataFields Editor ...';
    else
      Result := inherited GetVerb(Index);
  end;
end;

function TDataGridEditor.GetVerbCount: Integer;
begin
  Result := 2;
end;

{ TDataFieldsProperty }

procedure TDataFieldsProperty.Edit;
begin
  CreateDataFieldsEditor(Designer, TDCCustomDataGrid(GetComponent(0)), GetName);
end;

function TDataFieldsProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog] - [paSubProperties];
end;

function TDataFieldsProperty.GetValue: string;
begin
  Result := Format('(%s)', [GetPropType^.Name]);
end;

{ TDataFieldsEditor }

procedure TDataFieldsEditor.SetDataGrid(const Value: TDCCustomDataGrid);
begin
  if FDataGrid <> Value then
  begin
    FDataGrid := Value;
    if FDataGrid <> nil then
    begin
      FDGDesigner := TDGDesigner.Create(Value);
      FDGDesigner.FFieldsEditor := Self;
      UpdateDisplay;
    end
    else
      Release;  
  end;
end;

function TDataFieldsEditor.UniqueName(Component: TComponent): string;
var
  Temp: string;
begin
  if (Component <> nil) then
    Temp := Component.ClassName
  else
    Temp := 'TDataFieldsEditor';
  if (UpCase(Temp[1]) = 'T') and (Length(Temp) > 1) then System.Delete(Temp, 1, 1);
  Result := Designer.UniqueName(Temp);
end;

function TDataFieldsEditor.CreateDataField: TDataField;
 var
  DataFieldCreate: TDataFieldCreate;
begin
  Result := nil;
  DataFieldCreate := TDataFieldCreate.CreateNew(Application);
  with DataFieldCreate do
  begin
    BorderStyle := bsDialog;
    Position    := poScreenCenter;
    Designer    := Self.Designer;
    DataGrid    := Self.DataGrid;
    if ShowModal = mrOk then
    begin
      Designer.Modified;
      UpdateDisplay;
    end;
    Release;
  end;
end;

{$IFDEF DELPHI_V6}
  procedure TDataFieldsEditor.ItemDeleted(const ADesigner: IDesigner;
    AItem: TPersistent);
  begin
    if AItem = FDataGrid then DataGrid := nil
  end;
{$ELSE}
  procedure TDataFieldsEditor.ComponentDeleted(Component: IPersistent);
  var
    vItem: TPersistent;
  begin
    vItem := ExtractPersistent(Component);
    if vItem = FDataGrid then DataGrid := nil
  end;
{$ENDIF}

procedure TDataFieldsEditor.UpdateDisplay;
begin
  UpdateFieldList;
  UpdateSelection;
end;

procedure TDataFieldsEditor.UpdateFieldList;
var
  i: Integer;
  ItemIndex, TopIndex: Integer;
  Field: TDataField;
  FieldName: string;
  Selection: TStringList;
begin
  SaveSelection(lvFields, Selection, ItemIndex, TopIndex, True);
  try
    lvFields.Items.Clear;
    try
      if DataGrid = nil then Exit;
      for i := 0 to DataGrid.DataFields.Count - 1 do
      begin
        Field := DataGrid.DataFields[i];
        if not (csDestroying in Field.ComponentState) then
        begin
          FieldName := Field.FieldName;
          lvFields.Items.AddObject(FieldName, Field);
        end;
      end;
    finally
      {}
    end;
  finally
    RestoreSelection(lvFields, Selection, ItemIndex, TopIndex, True);
  end;
end;

procedure TDataFieldsEditor.UpdateSelection;
var
  I: Integer;
  Field: TDataField;
  {$IFDEF DELPHI_V5UP}
    {$IFDEF DELPHI_V6}
       ComponentList: IDesignerSelections;
    {$ELSE}
       ComponentList: TDesignerSelectionList;
    {$ENDIF}
  {$ELSE}
     ComponentList: TComponentList;
  {$ENDIF}
begin
  if Active then
  begin
    {$IFNDEF DELPHI_V5UP}
       ComponentList := TComponentList.Create;
    {$ELSE}
      {$IFDEF DELPHI_V6}
         ComponentList := CreateSelectionList;
      {$ELSE}
         ComponentList := TDesignerSelectionList.Create;
      {$ENDIF}
    {$ENDIF}
    try
      if lvFields.SelCount > 0 then
      begin
        with lvFields do
          for i := 0 to Items.Count - 1 do
            if Selected[i] then
            begin
              Field := TDataField(Items.Objects[i]);
              if Field <> nil then ComponentList.Add(Field);
            end;
        end
      else
        ComponentList.Add(DataGrid);
    except
      {$IFNDEF DELPHI_V5UP}
         ComponentList.Free;
      {$ENDIF}
      raise;
    end;
    SetSelection(ComponentList);
  end;
end;

destructor TDataFieldsEditor.Destroy;
begin
  inherited;
end;

procedure TDataFieldsEditor.RemoveFields;
 var
  i, Focused: Integer;
begin
  try
    Focused := lvFields.ItemIndex;
    with lvFields do
      for i := Items.Count - 1 downto 0 do
        if Selected[I] then
          TDataField(Items.Objects[I]).Free;
    Designer.Modified;
  finally
    UpdateDisplay;
  end;
  if Focused <> -1 then
  begin
    Focused := _intMin(Focused, lvFields.Items.Count - 1);
    lvFields.ItemIndex := Focused;
    lvFields.Selected[Focused] := True;
    UpdateSelection;
  end;
end;

procedure TDataFieldsEditor.RestoreSelection(List: TListBox;
  var Selection: TStringList; ItemIndex, TopIndex: Integer;
  Updated: Boolean);
 var
  i, j: Integer;
begin
  try
    with List do
      for i := 0 to Items.Count - 1 do
      begin
        j := Selection.IndexOf(Items[i]);
        Selected[i] := j <> -1;
      end;
    if TopIndex  <> -1 then List.TopIndex  := TopIndex;
    if ItemIndex <> -1 then List.ItemIndex := ItemIndex;
  finally
    if Updated then List.Items.EndUpdate;
    List.Invalidate;
    Selection.Free;
    Selection := nil;
    UpdateSelection;
  end;
end;

procedure TDataFieldsEditor.SaveSelection(List: TListBox;
  var Selection: TStringList; var ItemIndex, TopIndex: Integer;
  Updated: Boolean);
 var
  i: Integer;
begin
  Selection := TStringList.Create;
  try
    ItemIndex := List.ItemIndex;
    TopIndex := List.TopIndex;
    with List do
      for I := 0 to Items.Count - 1 do
        if Selected[I] then Selection.Add(Items[I]);
    if Updated then List.Items.BeginUpdate;
  except
    Selection.Free;
    Selection := nil;
  end;
end;

{ TDataGridDataField }

function TDataGridDataField.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TDataGridDataField.GetValueList(List: TStrings);
 var
  gs: TDataColumn;
begin
  gs := GetComponent(0) as TDataColumn;
  TDCCustomDataGrid(gs.Grid).GetFieldNames(List);
end;

procedure TDataGridDataField.GetValues(Proc: TGetStrProc);
 var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

{ TDataFieldCreate }

procedure TDataFieldCreate.btOkClick(Sender: TObject);
begin
  ModalResult := mrNone;
  FDataField := FieldClass.Create(DataGrid.Owner);
  try
    Field.Name      := ComponentName;
    Field.FieldName := FieldName;
    Field.DataContainer := DataGrid.DataContainer;
  except
    Field.Free;
  end;
  ModalResult := mrOK;
end;

constructor TDataFieldCreate.CreateNew(AOwner: TComponent; Dummy: Integer);
begin
  inherited;
  Width  := 405;
  Height := 157;
  Caption := 'New DataField';
  Font.Name := 'Tahoma';

  gbProp := TGroupBox.Create(Self);
  with gbProp do
  begin
    Parent := Self;
    Left := 5;
    Width := Self.Width - 15;
    Height := 80;
    Top := 10;
    Name := 'gbProp';
    Caption := ' Field properties ';
  end;

  edName := TDCChoiceEdit.Create(Self);
  with edName do
  begin
    Parent := gbProp;
    Left := 65;
    Width := 120;
    Top := 17;
    Name := 'edName';
    Text := '';
    ButtonExist := False;
    OnChange := edNameChange;
  end;

  edComponent := TDCChoiceEdit.Create(Self);
  with edComponent do
  begin
    Parent := gbProp;
    Left := 260;
    Width := 120;
    Top := 17;
    Name := 'edComponent';
    Text := '';
    ButtonExist := False;
  end;

  cbDataType := TDCComboBox.Create(Self);
  with cbDataType do
  begin
    Parent := gbProp;
    Left := 65;
    Width := 120;
    Top := 43;
    Name := 'cbDataType';
    Style := csDropDown;
    Text := '';
    FillDataTypes;
  end;

  lbName := TLabel.Create(Self);
  with lbName do
  begin
    Parent := gbProp;
    Left := 8;
    Top  := 20;
    Name := 'lbName';
    Caption := '&Name';
  end;

  lbComponent := TLabel.Create(Self);
  with lbComponent do
  begin
    Parent := gbProp;
    Left := 200;
    Top  := 20;
    Name := 'lbComponent';
    Caption := '&Component';
  end;

  lbDataType := TLabel.Create(Self);
  with lbDataType do
  begin
    Parent := gbProp;
    Left := 8;
    Top  := 45;
    Name := 'lbDataType';
    Caption := '&Data Type';
  end;

  bvProp := TBevel.Create(Self);
  with bvProp do
  begin
    Parent := Self;
    Left   := 3;
    Top    := Self.Height - 67;
    Width  := Self.Width - 5*2;
    Height := 2;
    Shape  := bsBottomLine;
    Visible := False;
  end;

  btCancel := TButton.Create(Self);
  with btCancel do
  begin
    Parent := Self;
    Name := 'btCancel';
    Top:= Self.Height - 59;
    Left := Self.Width  - 95;
    Width := 85;
    Caption := '&Cancel';
    Cancel  := True; 
    ModalResult := mrCancel;
  end;

  btOk := TButton.Create(Self);
  with btOk do
  begin
    Parent := Self;
    Name := 'btOk';
    Top := Self.Height - 59;
    Left := btCancel.Left - 90;
    Width := 85;
    Caption := 'OK';
    ModalResult := mrOk;
    Default := True;
    OnClick := btOkClick;
  end;

end;

procedure TDataFieldsEditor.aNewExecute(Sender: TObject);
 var
  DataField: TDataField;
  Selection: TStringList;
begin
  DataField := CreateDataField;
  if DataField <> nil then
  begin
    Selection := TStringList.Create;
    try
      Selection.Add(DataField.FieldName);
    finally
      RestoreSelection(lvFields, Selection, -1, -1, False);
    end;
  end;
  lvFields.SetFocus;
end;

procedure TDataFieldsEditor.FormCreate(Sender: TObject);
 var
  Bmp: TBitmap;
begin
  {Initialize Images}
  inherited;

  Bmp := TBitmap.Create;

  imToolBar.Clear;

  Bmp.LoadFromResourceName(HInstance, bmNew);    // 0
  imToolBar.AddMasked(Bmp, clBtnFace);
  Bmp.LoadFromResourceName(HInstance, bmDelete); // 1
  imToolBar.AddMasked(Bmp, clBtnFace);
  Bmp.LoadFromResourceName(HInstance, bmAll);    // 2
  imToolBar.AddMasked(Bmp, clBtnFace);
  Bmp.LoadFromResourceName(HInstance, bmDefault);// 3
  imToolBar.AddMasked(Bmp, clBtnFace);

  aNew.ImageIndex     := 0;
  aDelete.ImageIndex  := 1;
end;

procedure TDataFieldCreate.edNameChange(Sender: TObject);
begin
  if FieldName <> '' then
    ComponentName := CreateUniqueName(DataGrid, FieldName, FieldClass, nil)
  else
    ComponentName := '';
end;

procedure TDataFieldCreate.FillDataTypes;
 var
  i: TDataFieldType;
begin
  with cbDataType do
  begin
    Clear;
    for i := Low(DataFieldTypeNames) to High(DataFieldTypeNames) do
      if i <> dtUnknown then Items.Add(DataFieldTypeNames[i]);
  end;
end;

function TDataFieldCreate.GetComponentName: string;
begin
  Result := edComponent.Text;
end;

function TDataFieldCreate.GetFieldClass: TDataFieldClass;
begin
  if cbDataType.ItemIndex <> -1 then
    Result := DataFieldClasses[TDataFieldType(cbDataType.ItemIndex + 1)]
  else
    Result := nil
end;

function TDataFieldCreate.GetFieldName: string;
begin
  Result := edName.Text;
end;

procedure TDataFieldCreate.SetComponentName(const Value: string);
begin
  edComponent.Text := Value;
end;

procedure TDataFieldCreate.SetDataGrid(const Value: TDCCustomDataGrid);
begin
  FDataGrid := Value;
end;

procedure TDataFieldCreate.SetFieldClass(const Value: TDataFieldClass);
 var
  i: TDataFieldType;
begin
  for i := Low(DataFieldClasses) to High(DataFieldClasses) do
    if DataFieldClasses[i] = Value then
    begin
      cbDataType.ItemIndex := Integer(Value) - 1;
      Break;
    end;
end;

procedure TDataFieldCreate.SetFieldName(const Value: string);
begin
  edName.Text := Value;
end;

procedure TDataFieldsEditor.lvFieldsClick(Sender: TObject);
begin
  aDelete.Enabled := lvFields.SelCount > 0;
  UpdateSelection;
end;

procedure TDataFieldsEditor.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

{ TDGDesigner }

destructor TDGDesigner.Destroy;
begin
  if FFieldsEditor <> nil then
  begin
    FFieldsEditor.FDGDesigner := nil;
    FFieldsEditor.Release;
  end;
  inherited;
end;

procedure TDataFieldsEditor.aDeleteExecute(Sender: TObject);
begin
  RemoveFields;
end;

procedure TDataFieldsEditor.FormDestroy(Sender: TObject);
begin
  if FDGDesigner <> nil then
  begin
    { Destroy the designer if the editor is destroyed }
    FDGDesigner.FFieldsEditor := nil;
    FDGDesigner.Free;
    FDGDesigner := nil;
  end;
end;

end.
  
