{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x - 6.x
         Copyright (c) 1998-2001 Alex'EM

}
unit DCDBGrids;

{$R-}
{$G+}

interface
{$I DCConst.inc}

uses
  Windows, SysUtils, Messages, Classes, Controls, Forms, StdCtrls,
  {$IFDEF DELPHI_V6}
    Variants,
  {$ENDIF}
  Graphics, DCGrids, grids, DBCtrls, Db, Menus, ImgList, DCConst,
  DCEditTools, DCEditButton, DCPopupWindow;

type
  TColumnValue = (cvColor, cvWidth, cvFont, cvAlignment, cvReadOnly, cvTitleColor,
    cvTitleCaption, cvTitleAlignment, cvTitleFont, cvImeMode, cvImeName,
    cvDisplayFormat);
  TColumnValues = set of TColumnValue;

const
  ColumnTitleValues = [cvTitleColor..cvTitleFont];
  SRCTIMER_IDEVENT  = BASESCROLL_IDEVENT + $AE;

  db_TitleGridDelimiter = #13#10;
  db_LinesGridDelimiter = #10;

{ TColumn defines internal storage for column attributes.  If IsStored is
  True, values assigned to properties are stored in this object, the grid-
  or field-based default sources are not modified.  Values read from
  properties are the previously assigned value, if any, or the grid- or
  field-based default values if nothing has been assigned to that property.
  This class also publishes the column attribute properties for persistent
  storage.

  If IsStored is True, the column does not maintain local storage of
  property values.  Assignments to column properties are passed through to
  the underlying grid- or field-based default sources.  }
type
  TColumn = class;
  TDCCustomDBGrid = class;

  TColumnTitle = class(TPersistent)
  private
    FColumn: TColumn;
    FCaption: string;
    FFont: TFont;
    FColor: TColor;
    FAlignment: TAlignment;
    procedure FontChanged(Sender: TObject);
    function GetAlignment: TAlignment;
    function GetColor: TColor;
    function GetCaption: string;
    function GetFont: TFont;
    function IsAlignmentStored: Boolean;
    function IsColorStored: Boolean;
    function IsFontStored: Boolean;
    function IsCaptionStored: Boolean;
    procedure SetAlignment(Value: TAlignment);
    procedure SetColor(Value: TColor);
    procedure SetFont(Value: TFont);
    procedure SetCaption(const Value: string); virtual;
  protected
    procedure RefreshDefaultFont;
  public
    constructor Create(Column: TColumn);
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
    function DefaultAlignment: TAlignment;
    function DefaultColor: TColor;
    function DefaultFont: TFont;
    function DefaultCaption: string;
    procedure RestoreDefaults; virtual;
    property Column: TColumn read FColumn;
  published
    property Alignment: TAlignment read GetAlignment write SetAlignment
      stored IsAlignmentStored;
    property Caption: string read GetCaption write SetCaption stored IsCaptionStored;
    property Color: TColor read GetColor write SetColor stored IsColorStored;
    property Font: TFont read GetFont write SetFont stored IsFontStored;
  end;

  TColumnFooter = class(TDCFooter)
  public
    property Index;
  published
    property AutoSize;
    property Style;
    property Height;
    property Visible;
  end;

  TColumnFooterPanel = class(TDCFooterTextPanel)
  private
    FColumn: TColumn;
    procedure SetColumn(const Value: TColumn);
  protected
    function GetColIndex: integer; override;
    procedure SetColIndex(const Value: integer); override;
  public
    function DefaultFont: TFont; override;
    property Column: TColumn read FColumn write SetColumn;
  published
    property Visible default False;
    property Style default beLowered;
  end;

  TColumnOption  = (gcPopupMenu, gcWordBreak);
  TColumnOptions = set of TColumnOption;
  TColumnTitleClass = class of TColumnTitle;

  TDCColumnInitialize = packed record
    ColumnTitleClass: TColumnTitleClass;
  end;

  TColumn = class(TCollectionItem)
  private
    FAlignment: TAlignment;
    FAssignedValues: TColumnValues;
    FButtonStyle: TColumnButtonStyle;
    FColor: TColor;
    FComment: string;
    FDisplayFormat: string;
    FDropDownRows: Cardinal;
    FExpanded: Boolean;
    FField: TField;
    FFieldName: string;
    FFont: TFont;
    FFooterPanel: TColumnFooterPanel;
    FImeMode: TImeMode;
    FImeName: TImeName;
    FIndexed: Boolean;
    FIndexStyle: TColumnIndexStyle;
    FItemIndex: Integer;
    FOptions: TColumnOptions;
    FPickList: TStrings;
    FPopupMenu: TPopupMenu;
    FReadonly: Boolean;
    FResize: boolean;
    FStored: Boolean;
    FSize: TPoint;
    FTag: integer;
    FTitle: TColumnTitle;
    FVertAlignment: TVertAlignment;
    FVisible: Boolean;
    FWidth: Integer;
    FWordBreak: boolean;
    procedure FontChanged(Sender: TObject);
    function GetAlignment: TAlignment;
    function GetColor: TColor;
    function GetExpanded: Boolean;
    function GetField: TField;
    function GetFont: TFont;
    function GetImeMode: TImeMode;
    function GetImeName: TImeName;
    function GetParentColumn: TColumn;
    function GetPickList: TStrings;
    function GetReadOnly: Boolean;
    function GetShowing: Boolean;
    function GetWidth: Integer;
    function GetVisible: Boolean;
    function IsAlignmentStored: Boolean;
    function IsColorStored: Boolean;
    function IsFontStored: Boolean;
    function IsImeModeStored: Boolean;
    function IsImeNameStored: Boolean;
    function IsReadOnlyStored: Boolean;
    function IsWidthStored: Boolean;
    procedure SetAlignment(Value: TAlignment); virtual;
    procedure SetButtonStyle(Value: TColumnButtonStyle);
    procedure SetColor(Value: TColor);
    procedure SetExpanded(Value: Boolean);
    procedure SetField(Value: TField); virtual;
    procedure SetFieldName(const Value: String);
    procedure SetFont(Value: TFont);
    procedure SetImeMode(Value: TImeMode); virtual;
    procedure SetImeName(Value: TImeName); virtual;
    procedure SetPickList(Value: TStrings);
    procedure SetPopupMenu(Value: TPopupMenu);
    procedure SetReadOnly(Value: Boolean); virtual;
    procedure SetTitle(Value: TColumnTitle);
    procedure SetWidth(Value: Integer); virtual;
    procedure SetVisible(Value: Boolean);
    function GetExpandable: Boolean;
    procedure SetIndexed(Value: Boolean);
    procedure SetItemIndex(Value: Integer);
    procedure SetIndexStyle(const Value: TColumnIndexStyle);
    procedure SetDisplayFormat(const Value: string);
    procedure SetComment(const Value: string);
    procedure SetWordBreak(const Value: boolean);
    procedure SetFooterPanel(const Value: TColumnFooterPanel);
    procedure SetOptions(const Value: TColumnOptions);
    procedure SetVertAlignment(const Value: TVertAlignment);
  protected
    function Initialize: TDCColumnInitialize; virtual;
    function GetGrid: TDCCustomDBGrid;
    function GetDisplayName: string; override;
    procedure RefreshDefaultFont;
    procedure SetIndex(Value: Integer); override;
    procedure UpdateTitleSize(Canvas: TCanvas);
    property IsStored: Boolean read FStored write FStored default True;
  public
    constructor Create(Collection: TCollection); override;
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
    function DefaultAlignment: TAlignment;
    function DefaultColor: TColor;
    function DefaultFont: TFont;
    function DefaultImeMode: TImeMode;
    function DefaultImeName: TImeName;
    function DefaultReadOnly: Boolean;
    function DefaultWidth: Integer;
    function Depth: Integer;
    procedure RestoreDefaults; virtual;
    function GetStoredWidth: integer;
    property Grid: TDCCustomDBGrid read GetGrid;
    property AssignedValues: TColumnValues read FAssignedValues;
    property Expandable: Boolean read GetExpandable;
    property Field: TField read GetField write SetField;
    property ParentColumn: TColumn read GetParentColumn;
    property Showing: Boolean read GetShowing;
    property Size: TPoint read FSize;
  published
    property Alignment: TAlignment read GetAlignment write SetAlignment
      stored IsAlignmentStored;
    property ButtonStyle: TColumnButtonStyle read FButtonStyle
      write SetButtonStyle default cbsAuto;
    property Color: TColor read GetColor write SetColor stored IsColorStored;
    property DropDownRows: Cardinal read FDropDownRows write FDropDownRows
      default 7;
    property Expanded: Boolean read GetExpanded write SetExpanded default False;
    property FieldName: String read FFieldName write SetFieldName;
    property Font: TFont read GetFont write SetFont stored IsFontStored;
    property FooterPanel: TColumnFooterPanel read FFooterPanel
      write SetFooterPanel;
    property ImeMode: TImeMode read GetImeMode write SetImeMode
      stored IsImeModeStored;
    property ImeName: TImeName read GetImeName write SetImeName
      stored IsImeNameStored;
    property Options: TColumnOptions read FOptions write SetOptions
      default [];
    property PickList: TStrings read GetPickList write SetPickList;
    property PopupMenu: TPopupMenu read FPopupMenu write SetPopupMenu;
    property ReadOnly: Boolean read GetReadOnly write SetReadOnly
      stored IsReadOnlyStored;
    property Title: TColumnTitle read FTitle write SetTitle;
    property Width: Integer read GetWidth write SetWidth stored IsWidthStored;
    property VertAlignment: TVertAlignment read FVertAlignment
      write SetVertAlignment default vaCenter;
    property Visible: Boolean read GetVisible write SetVisible default True;
    property IndexStyle: TColumnIndexStyle read FIndexStyle write SetIndexStyle
      default idxNone;
    property Indexed: Boolean read FIndexed  write SetIndexed default False;
    property ItemIndex: Integer read FItemIndex  write SetItemIndex default -1;
    property DisplayFormat: string read FDisplayFormat write SetDisplayFormat;
    property Tag: integer read FTag write FTag default 0;
    property Resize: boolean read FResize write FResize default True;
    property Comment: string read FComment write SetComment;
    property WordBreak: boolean read FWordBreak write SetWordBreak default False;
  end;

  TColumnClass = class of TColumn;

  TDBGridColumnsState = (csDefault, csCustomized);

  TDBGridColumns = class(TCollection)
  private
    FGrid: TDCCustomDBGrid;
    function GetColumn(Index: Integer): TColumn;
    function InternalAdd: TColumn;
    procedure SetColumn(Index: Integer; Value: TColumn);
    procedure SetState(NewState: TDBGridColumnsState);
    function GetState: TDBGridColumnsState;
  protected
    function GetOwner: TPersistent; override;
    procedure Update(Item: TCollectionItem); override;
  public
    constructor Create(Grid: TDCCustomDBGrid; ColumnClass: TColumnClass);
    function  Add: TColumn;
    procedure LoadFromFile(const Filename: string);
    procedure LoadFromStream(S: TStream);
    procedure RestoreDefaults;
    procedure RebuildColumns;
    procedure SaveToFile(const Filename: string);
    procedure SaveToStream(S: TStream);
    property State: TDBGridColumnsState read GetState write SetState;
    property Grid: TDCCustomDBGrid read FGrid;
    property Items[Index: Integer]: TColumn read GetColumn write SetColumn; default;
  end;

  TGridDataLink = class(TDataLink)
  private
    FGrid: TDCCustomDBGrid;
    FFieldCount: Integer;
    FFieldMap: array of Integer;
    FModified: Boolean;
    FSparseMap: Boolean;
    function GetDefaultFields: Boolean;
    function GetFields(I: Integer): TField;
  protected
    procedure ActiveChanged; override;
    procedure DataSetChanged; override;
    procedure DataSetScrolled(Distance: Integer); override;
    procedure FocusControl(Field: TFieldRef); override;
    procedure EditingChanged; override;
    procedure LayoutChanged; override;
    function MoveBy(Distance: Integer): Integer; override;
    procedure RecordChanged(Field: TField); override;
    procedure UpdateData; override;
    function  GetMappedIndex(ColIndex: Integer): Integer;
  public
    constructor Create(AGrid: TDCCustomDBGrid);
    destructor Destroy; override;
    function AddMapping(const FieldName: string): Boolean;
    procedure ClearMapping;
    procedure Modified;
    procedure Reset;
    property DefaultFields: Boolean read GetDefaultFields;
    property FieldCount: Integer read FFieldCount;
    property Fields[I: Integer]: TField read GetFields;
    property SparseMap: Boolean read FSparseMap write FSparseMap;
  end;

  TBookmarkList = class(TObject)
  private
    FList: TStringList;
    FGrid: TDCCustomDBGrid;
    FCache: TBookmarkStr;
    FCacheIndex: Integer;
    FCacheFind: Boolean;
    FLinkActive: Boolean;
    function GetCount: Integer;
    function GetCurrentRowSelected: Boolean;
    function GetItem(Index: Integer): TBookmarkStr;
    procedure SetCurrentRowSelected(Value: Boolean);
  protected
    function CurrentRow: TBookmarkStr;
    function Compare(const Item1, Item2: TBookmarkStr): Integer;
    procedure LinkActive(Value: Boolean);
    procedure StringsChanged(Sender: TObject);
  public
    constructor Create(AGrid: TDCCustomDBGrid);
    destructor Destroy; override;
    procedure Clear;           // free all bookmarks
    procedure Delete;          // delete all selected rows from dataset
    function  Find(const Item: TBookmarkStr; var Index: Integer): Boolean;
    function  IndexOf(const Item: TBookmarkStr): Integer;
    function  Refresh: Boolean;// drop orphaned bookmarks; True = orphans found
    procedure Save(List: TStringList);
    procedure SelectAll;
    procedure Load(List: TStringList);
    property Count: Integer read GetCount;
    property CurrentRowSelected: Boolean read GetCurrentRowSelected
      write SetCurrentRowSelected;
    property Items[Index: Integer]: TBookmarkStr read GetItem; default;
  end;

  TDBGridOption = (dgEditing, dgAlwaysShowEditor, dgTitles, dgIndicator,
    dgColumnResize, dgColLines, dgRowLines, dgTabs, dgRowSelect,
    dgAlwaysShowSelection, dgMultiSelect, dgMarker, dgTitleClicked,
    dgUserRowHeight, dgRowSizing, dgHighlightRow, dgFlatButtons,
    dgCompleteLines, dgAutoSize, dgAdvancedSelect, dgFlatLines,
    dgConfirmDelete, dgCancelOnExit);

  TDBGridOptionEx =(dgeInsertSelect, dgeMarkerMenu, dgeShadowSelection,
    dgeDrawMemoAsText, dgeIndicatorMenu, dgeShowDragImage,
    dgeShowPartiallyVisibleData, dgeCompleteRows);

  TDBGridOptions   = set of TDBGridOption;
  TDBGridOptionsEx = set of TDBGridOptionEx;

  { The DBGrid's DrawDataCell virtual method and OnDrawDataCell event are only
    called when the grid's Columns.State is csDefault.  This is for compatibility
    with existing code. These routines don't provide sufficient information to
    determine which column is being drawn, so the column attributes aren't
    easily accessible in these routines.  Column attributes also introduce the
    possibility that a column's field may be nil, which would break existing
    DrawDataCell code.   DrawDataCell, OnDrawDataCell, and DefaultDrawDataCell
    are obsolete, retained for compatibility purposes. }
  TDrawDataCellEvent = procedure (Sender: TObject; const Rect: TRect; Field: TField;
    State: TGridDrawState) of object;

  { The DBGrid's DrawColumnCell virtual method and OnDrawColumnCell event are
    always called, when the grid has defined column attributes as well as when
    it is in default mode.  These new routines provide the additional
    information needed to access the column attributes for the cell being
    drawn, and must support nil fields.  }

  TDBGridDrawCellEvent = procedure (Sender: TObject; const Rect: TRect;
    DataCol: Integer; Column: TColumn; State: TGridDrawState) of object;
  TDBGridClickEvent = procedure (Column: TColumn) of object;
  TDBGridClipEvent = procedure (Sender: TObject; X, Y : LongInt;
    var Show: boolean) of object;
  TDBGridCommentEvent = procedure(Sender: TObject; Mode: integer;
    Column: TColumn) of object;
  TDBGridUpdMessageEvent = procedure(Sender: TObject; Canvas: TCanvas; ARect: TRect;
    UpdateMessage: string) of object;
  TDBGridDrawCompleteEvent = procedure(Sender: TObject; Canvas: TCanvas; ARect: TRect;
    Selected: boolean; ARow: integer; var DefaultDrawing: boolean) of object;

  TBookmarkInfo = record
    Row: integer;
    Bookmark: TBookmark;
    ActiveRecord: integer;
  end;

  TDBSelectedArea = class;

  TDBSelectedItem = class(TSelectedItem)
  private
    FSelected: TBookmarkList;
    FStartCol: integer;
    FColCount: integer;
    function GetSelectedArea: TDBSelectedArea;
    function GetCount: integer;
    function GetItem(Index: Integer): TBookmarkStr;
    function RowToData(ARow: integer): integer;
  protected
    function GetSelectRgn: HRGN; override;
    procedure Select(IncX, incY: integer; var Cell: TGridCoord); override;
    property SelectedArea: TDBSelectedArea read GetSelectedArea;
  public
    function CellSelected(ACol: integer; ARow: integer): boolean;
    constructor Create(Collection: TCollection; Cell: TGridCoord); override;
    destructor Destroy; override;
    property Bookmarks[Index: Integer]: TBookmarkStr read GetItem;
    property ColCount: integer read FColCount;
    property Count: integer read GetCount;
    property StartCol: integer read FStartCol;
  end;

  TDBSelectedArea = class(TSelectedArea)
  private
    function GetGrid: TDCCustomDBGrid;
    function GetItem(Index: Integer): TDBSelectedItem;
    procedure SetItem(Index: Integer; const Value: TDBSelectedItem);
  public
    function DataLinkActive: boolean;
    function CellSelected(ACol: integer; ARow: integer): boolean;
    property Grid: TDCCustomDBGrid read GetGrid;
    property Items[Index: Integer]: TDBSelectedItem read GetItem write SetItem;
  end;

  TDBClipPopup = class(TComboClipPopup)
  private
    FColType: TFixedCol;
    FColumnIndex: integer;
    function GetGrid: TDCCustomDBGrid;
  public
    procedure AddButtons; override;
    procedure Hide; override;
    property ColType: TFixedCol read FColType write FColType;
    property ColumnIndex: integer read FColumnIndex write FColumnIndex;
    property Grid: TDCCustomDBGrid read GetGrid;
  end;

  TDCCustomDBGrid = class(TDCCustomGrid)
  private
    FBookmarks: TBookmarkList;
    FColumnCell: integer;
    FColumns: TDBGridColumns;
    FClipDown: boolean;
    FClipPopup: TDBClipPopup;
    FColumnFooter: TColumnFooter;
    FCurrentCol: Integer;
    FCurrentPos: array[1..2] of TBookmarkInfo;
    FDataLink: TGridDataLink;
    FDataVisible: boolean;
    FDBObject: TDCDBObject;
    FDefaultDrawing: Boolean;
    FDragCol: TColumn;
    FDrawColumn: TColumn;
    FEditText: string;
    FFirstGridCell: integer;
    FFlags: DWORD;
    FFrozenCols: integer;
    FGridStruct: TPolyLineStruct;
    FImageChangeLink: TChangeLink;
    FImages: TImageList;
    FLayoutLock: Byte;
    FLineColor: TColor;
    FMousePoint: TPoint;
    FOnCellClick: TDBGridClickEvent;
    FOnCellDblClick: TDBGridClickEvent;
    FOnClipButtonClick: TNotifyEvent;
    FOnClipClick: TDBGridClipEvent;
    FOnColumnComment: TDBGridCommentEvent;
    FOnColumnMoved: TMovedEvent;
    FOnColEnter: TNotifyEvent;
    FOnColExit: TNotifyEvent;
    FOnDrawColumnCell: TDBGridDrawCellEvent;
    FOnDrawCompleteLine: TDBGridDrawCompleteEvent;
    FOnDrawDataCell: TDrawDataCellEvent;
    FOnEditButtonClick: TNotifyEvent;
    FOnPaintEmptyMessage: TDBGridUpdMessageEvent;
    FOnPopupMenu: TGridPopupEvent;
    FOnTitleClick:TDBGridClickEvent;
    FOptions: TDBGridOptions;
    FOptionsEx: TDBGridOptionsEx;
    FOriginalImeMode: TImeMode;
    FOriginalImeName: TImeName;
    FPopupTitle: TPopupMenu;
    FReadOnly: Boolean;
    FSelecting: Boolean;
    FSelectionAnchor: TBookmarkStr;
    FSizingIndex: integer;
    FSizingOff: integer;
    FViewDataLink: TDataLink;
    FTitleFont: TFont;
    FTitleOffset, FIndicatorOffset: Byte;
    FUpdateLock: Byte;
    procedure ClearSelection;
    procedure DataChanged;
    procedure DoSelection(Select: Boolean; Direction: Integer; Shift: TShiftState);
    procedure EditingChanged;
    function GetDataSource: TDataSource;
    function GetDBObject: TDCDBObject;
    function GetFieldCount: Integer;
    function GetFields(FieldIndex: Integer): TField;
    function GetFrozenCols: integer;
    function GetPosition: TBookMark;
    function GetSelectedField: TField;
    function GetSelectedIndex: Integer;
    procedure ImageListChange(Sender: TObject);
    procedure InternalLayout;
    procedure MoveCol(RawCol, Direction: Integer);
    procedure NextRow(Select: Boolean; Shift: TShiftState);
    procedure PriorRow(Select: Boolean; Shift: TShiftState);
    function PtInExpandButton(X,Y: Integer; var MasterCol: TColumn): Boolean;
    procedure ReadColumns(Reader: TReader);
    procedure RecordChanged(Field: TField);
    procedure SetIme;
    procedure SetClipDown(const Value: boolean);
    procedure SetColumns(Value: TDBGridColumns);
    procedure SetDataSource(Value: TDataSource);
    procedure SetDataVisible(const Value: boolean);
    procedure SetDBObject(const Value: TDCDBObject);
    procedure SetFrozenCols(Value: integer);
    procedure SetImages(const Value: TImageList);
    procedure SetOptions(Value: TDBGridOptions);
    procedure SetOptionsEx(const Value: TDBGridOptionsEx);
    procedure SetPopupTitle(const Value: TPopupMenu);
    procedure SetPosition(const Value: TBookMark);
    procedure SetSelectedField(Value: TField);
    procedure SetSelectedIndex(Value: Integer);
    procedure SetTitleFont(Value: TFont);
    procedure SetTitleHeight;
    procedure TitleFontChanged(Sender: TObject);
    procedure UpdateData;
    procedure UpdateActive;
    procedure UpdateIme;
    procedure UpdateScrollBar;
    procedure WriteColumns(Writer: TWriter);
    function GetSelectedArea: TDBSelectedArea;
    procedure SetColumnFooter(const Value: TColumnFooter);
    function GetTitleMenuRect(ARect: TRect; var MenuRect: TRect): boolean;
    procedure SetLineColor(const Value: TColor);
    procedure DrawFlatLines(var R: TRect);
    function SyncDataLinks(BufferCount: integer): boolean;
  protected
    FUpdateFields: Boolean;
    function AcquireLayoutLock: Boolean;
    function BeginColumnDrag(var Origin, Destination: Integer;
      const MousePt: TPoint): Boolean; override;
    procedure BeginLayout; override;
    procedure BeginUpdate;
    function BoxRectEx(ALeft, ATop, ARight, ABottom: Longint): TRect; override;
    procedure CalcSizingState(X, Y: Integer; var State: TGridState;
      var Index: Longint; var SizingPos, SizingOfs: Integer;
      var FixedInfo: TGridDrawInfo); override;
    procedure CancelLayout;
    function CanColResize(ACol: integer): boolean; override;
    function CanEditAcceptKey(Key: Char): Boolean; override;
    function CanEditModify: Boolean; override;
    function CanEditShow: Boolean; override;
    function CheckColumnDrag(var Origin, Destination: Integer;
      const MousePt: TPoint): Boolean; override;
    procedure CellClick(Column: TColumn); dynamic;
    procedure CellDblClick(Column: TColumn); dynamic;
    procedure ColumnMoved(FromIndex, ToIndex: Longint); override;
    function CalcTitleRect(Col: TColumn; ARow: Integer;
      var MasterCol: TColumn): TRect;
    function ColumnAtDepth(Col: TColumn; ADepth: Integer): TColumn;
    procedure ColEnter; dynamic;
    procedure ColExit; dynamic;
    procedure ColWidthsChanged; override;
    procedure ClipClick(AColType: TFixedCol; ACol: integer); dynamic;
    procedure CreateCellDragImage(ACol, ARow: integer;
      var DragImages: TImageList); override;
    function  CreateColumns: TDBGridColumns; dynamic;
    function  CreateEditor: TInplaceEdit; override;
    procedure CreateParams(var Params: TCreateParams); override;
    function CreateSelectedArea: TSelectedArea; override;
    procedure CreateWnd; override;
    procedure CMBiDiModeChanged(var Message: TMessage); message CM_BIDIMODECHANGED;
    procedure CMExit(var Message: TMessage); message CM_EXIT;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure CMParentFontChanged(var Message: TMessage); message CM_PARENTFONTCHANGED;
    procedure CMDeferLayout(var Message); message CM_DEFERLAYOUT;
    procedure CMDesignHitTest(var Msg: TCMDesignHitTest); message CM_DESIGNHITTEST;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    function  DataToRawColumn(ACol: Integer): Integer; override;
    function DataVisible: boolean; override;
    procedure DeferLayout;
    procedure DefineFieldMap; virtual;
    procedure DefineProperties(Filer: TFiler); override;
    procedure DoClick(Sender: TObject); override;
    procedure DoColumnClick(Shift: TShiftState; ColIndex: integer); override;
    procedure DoColumnComment(Mode: integer; Column: TColumn); virtual;
    function DoMouseWheelDown(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    function DoMouseWheelUp(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    procedure DrawCell(ACol, ARow: Longint; ARect: TRect; AState: TGridDrawState); override;
    procedure DrawDataCell(const Rect: TRect; Field: TField;
      State: TGridDrawState); dynamic; { obsolete }
    procedure DrawColumnCell(const Rect: TRect; DataCol: Integer;
      Column: TColumn; State: TGridDrawState); dynamic;
    function DrawTitleCell(ACanvas: TCanvas; ACol, ARow: Integer; ARect: TRect;
      BorderState: TDrawBorerState; AFillRect, ADraw: boolean): TPoint; override;
    procedure DrawTitlePopup(ACanvas: TCanvas; ARect: TRect;
      BorderState: TDrawBorerState; DrawColumn: TColumn);
    function EndColumnDrag(var Origin, Destination: Integer;
      const MousePt: TPoint): Boolean; override;
    procedure EditButtonClick; dynamic;
    procedure EndLayout; override;
    procedure EndUpdate;
    function FlatButtons: boolean; override;
    function GetBorderStyle: TEdgeBorderStyle; override;
    function GetCellByType(AColType: TFixedCol): integer;
    function GetColField(DataCol: Integer): TField;
    procedure GetConnectionPos(var X, Y: integer; var AWidth: integer;
      var Position: TPopupPosition); override;
    function GetEditLimit: Integer; override;
    function GetEditMask(ACol, ARow: Longint): string; override;
    function GetEditText(ACol, ARow: Longint): string; override;
    function GetFieldValue(ACol: Integer): string;
    function GetPopupMenu: TPopupMenu; override;
    function HighlightCell(DataCol, DataRow: Integer; const Value: string;
      AState: TGridDrawState): Boolean; virtual;
    procedure KeyPress(var Key: Char); override;
    procedure InvalidateTitles(AtOnce: boolean = False);
    procedure InvalidateSelected;
    function IsActiveControl: Boolean; override;
    procedure LayoutChanged; virtual;
    property LineColor: TColor read FLineColor write SetLineColor;
    procedure LinkActive(Value: Boolean); virtual;
    procedure Loaded; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    function  MouseUpBeforeDblClk: boolean; dynamic;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure Scroll(Distance: Integer); virtual;
    procedure SetColumnAttributes; virtual;
    procedure SetEditText(ACol, ARow: Longint; const Value: string); override;
    procedure SetInternalRowCount(Value: integer);
    function SelectCell(ACol, ARow: Longint): Boolean; override;
    procedure StartScrollTimer(XInc, YInc: integer; Elapse: UINT); override;
    function  StoreColumns: Boolean;
    procedure TimedScroll(Direction: TGridScrollDirection); override;
    procedure TitleClick(Column: TColumn); dynamic;
    procedure TopLeftChanged; override;
    procedure UpdateFrozenCols(const Value: integer);
    function UpdateRowCount: boolean; override;
    function UseRightToLeftAlignmentForField(const AField: TField;
      Alignment: TAlignment): Boolean;
    procedure WMKeyDown(var Message: TWMKeyDown); message WM_KEYDOWN;
    procedure WMSetCursor(var Message: TWMSetCursor); message WM_SETCURSOR;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure WMVScroll(var Message: TWMVScroll); message WM_VSCROLL;
    procedure WMHScroll(var Message: TWMHScroll); message WM_HSCROLL;
    procedure WMIMEStartComp(var Message: TMessage); message WM_IME_STARTCOMPOSITION;
    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SETFOCUS;
    procedure WMKillFocus(var Message: TMessage); message WM_KILLFOCUS;
    procedure WMNCLButtonDown(var Message: TWMNCLButtonDown); message WM_NCLBUTTONDOWN;
    procedure WMEraseBkgnd(var Message: TWmEraseBkgnd); message WM_ERASEBKGND;
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure WMChar(var Msg: TWMChar); message WM_CHAR;
    procedure WMNCCalcSize(var Message: TWMNCCalcSize); message WM_NCCALCSIZE;
    procedure WMNCPaint(var Message: TMessage); message WM_NCPAINT;
    property Columns: TDBGridColumns read FColumns write SetColumns;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property DataLink: TGridDataLink read FDataLink;
    property DBObject: TDCDBObject read GetDBObject write SetDBObject;
    property DefaultDrawing: Boolean read FDefaultDrawing write FDefaultDrawing default True;
    property Footer: TColumnFooter read FColumnFooter write SetColumnFooter;
    property FrozenCols: Integer read GetFrozenCols write SetFrozenCols default 0;
    property IndicatorOffset: Byte read FIndicatorOffset;
    property LayoutLock: Byte read FLayoutLock;
    property OnColEnter: TNotifyEvent read FOnColEnter write FOnColEnter;
    property OnColExit: TNotifyEvent read FOnColExit write FOnColExit;
    property OnColumnMoved: TMovedEvent read FOnColumnMoved write FOnColumnMoved;
    property OnCellClick: TDBGridClickEvent read FOnCellClick write FOnCellClick;
    property OnCellDblClick: TDBGridClickEvent read FOnCellDblClick write FOnCellDblClick;
    property OnClipClick: TDBGridClipEvent read FOnClipClick write FOnClipClick;
    property OnClipButtonClick: TNotifyEvent read FOnClipButtonClick write FOnClipButtonClick;
    property OnColumnComment: TDBGridCommentEvent read FOnColumnComment
      write FOnColumnComment;
    property OnDrawCompleteLine: TDBGridDrawCompleteEvent read FOnDrawCompleteLine
      write FOnDrawCompleteLine;
    property OnDrawColumnCell: TDBGridDrawCellEvent read FOnDrawColumnCell
      write FOnDrawColumnCell;
    property OnDrawDataCell: TDrawDataCellEvent read FOnDrawDataCell
      write FOnDrawDataCell; { obsolete }
    property OnEditButtonClick: TNotifyEvent read FOnEditButtonClick
      write FOnEditButtonClick;
    property OnPaintEmptyMessage: TDBGridUpdMessageEvent read FOnPaintEmptyMessage
      write FOnPaintEmptyMessage;
    property OnPopupMenu: TGridPopupEvent read FOnPopupMenu write FOnPopupMenu;
    property OnTitleClick: TDBGridClickEvent read FOnTitleClick write FOnTitleClick;
    property Options: TDBGridOptions read FOptions write SetOptions
      default [dgEditing, dgTitles, dgIndicator, dgColumnResize, dgColLines,
      dgRowLines, dgTabs, dgConfirmDelete, dgCancelOnExit];
    property OptionsEx: TDBGridOptionsEx read FOptionsEx write SetOptionsEx
      default [dgeMarkerMenu, dgeShadowSelection, dgeDrawMemoAsText,
       dgeIndicatorMenu {$IFNDEF DELPHI_V5UP}, dgeInsertSelect {$ENDIF},
       dgeShowDragImage];
    property ParentColor default False;
    property PopupTitle: TPopupMenu read FPopupTitle write SetPopupTitle;
    property Position: TBookMark read GetPosition write SetPosition;
    property ReadOnly: Boolean read FReadOnly write FReadOnly default False;
    property SelectedRows: TBookmarkList read FBookmarks;
    property SelectedArea: TDBSelectedArea read GetSelectedArea;
    property TitleFont: TFont read FTitleFont write SetTitleFont;
    property UpdateLock: Byte read FUpdateLock;
  public
    {$IFDEF DELPHI_V5UP}
      function CanFocus: boolean; override;
    {$ENDIF}
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure DefaultDrawDataCell(const Rect: TRect; Field: TField;
      State: TGridDrawState); { obsolete }
    procedure DefaultDrawColumnCell(const Rect: TRect; DataCol: Integer;
      Column: TColumn; State: TGridDrawState);
    procedure DefaultHandler(var Msg); override;
    function ExecuteAction(Action: TBasicAction): Boolean; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    function GetDataValue(Column: TColumn): string; virtual;
    function GetFixedColType(ACol, AOffset: integer): TFixedCol; override;
    function GetFixedRowType(ARow, AOffset: integer): TFixedRow; override;
    function GetGridHitTest(X, Y: integer): TGridHitTest; override;
    function GroupingEnabled: boolean; override;
    procedure Paint; override;
    function RawToDataColumn(ACol: Integer): Integer; override;
    function RawToDataRow(ARow: integer): integer; override;
    procedure RestPosition;
    procedure RowHeightsChanged; override;
    procedure SavePosition(SkipSelected: boolean = False);
    procedure ShowPopupEditor(Column: TColumn; X: Integer = Low(Integer);
      Y: Integer = Low(Integer)); dynamic;
    function UpdateAction(Action: TBasicAction): Boolean; override;
    function ValidBookmark(Bookmark: TBookmark): boolean;
    function ValidFieldIndex(FieldIndex: Integer): Boolean;
    property ColumnFooter: TColumnFooter read FColumnFooter;
    property EditorMode;
    property FieldCount: Integer read GetFieldCount;
    property Fields[FieldIndex: Integer]: TField read GetFields;
    property SelectedField: TField read GetSelectedField write SetSelectedField;
    property SelectedIndex: Integer read GetSelectedIndex write SetSelectedIndex;
    property Images: TImageList read FImages write SetImages;
    property ClipDown: boolean read FClipDown write SetClipDown;
    property Col;
    property Row;
    procedure ShowClipPopup(AColType: TFixedCol; ACol: integer;
      AClipPopup: TObject); virtual;
    procedure HideClipPopup; override;
    procedure SelectItems(Mode: TSelectMode);
    function CellRect(ACol, ARow: Longint): TRect;
    function MouseCoord(X, Y: Longint): TGridCoord;
    property DataSetVisible: boolean read FDataVisible write SetDataVisible;
  end;

  TPopupGridOptions = set of (pgCanAppend, pgShowHeader);

  TDCCustomPopupDBGrid = class(TDCCustomDBGrid, IDCPopupWindow)
  private
    FAlwaysVisible: boolean;
    FBorderSize: integer;
    FButtons: TDCEditButtons;
    FCursorMode: TCursorMode;
    FDataSet: TDataSet;
    FDataSource: TDataSource;
    FDrawingStyle: TDCDrawingStyle;
    FDropDownRows: integer;
    FFindButton: TDCEditButton;
    FItemHeight: integer;
    FMargins: TRect;
    FOnButtonClick: TNotifyEvent;
    FPopupOptions: TPopupGridOptions;
    FOwner: TControl;
    FPopupAlignment: TWindowAlignment;
    FPopupBorderStyle: TPopupBorderStyle;
    FVisible: boolean;
    FScrollLeft: TDCEditButton;
    FScrollRight: TDCEditButton;
    FScrollTimer: THandle;
    FWindowRect: TRect;
    procedure RedrawBorder;
    procedure SetPopupAlignment(Value: TWindowAlignment);
    procedure SetPopupBorderStyle(Value: TPopupBorderStyle);
    procedure SetDataSet(const Value: TDataSet);
    procedure DrawClientRect;
    procedure DrawFooter;
    procedure DrawHeader(const DC: HDC; var R: TRect);
    procedure SetMargins;
    procedure BeginMoving(XCursor, YCursor: integer);
    procedure DoButtonClick(Sender: TObject);
    procedure InvalidateButtons;
    procedure DoDrawHint(Sender: TObject; Mode: Integer);
    procedure CheckRefreshButton;
    procedure PaintEmptyMessage(Sender: TObject; Canvas: TCanvas; ARect: TRect;
      UpdateMessage: string);
    procedure DoScroll(Sender: TObject);
    procedure UpdateHScrolls;
    procedure SetPopupOptions(const Value: TPopupGridOptions);
    procedure SetDrawingStyle(const Value: TDCDrawingStyle);
  protected
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure CMHintShow(var Message: TCMHintShow); message CM_HINTSHOW;
    procedure CMSetAlignment(var Message: TMessage); message CM_SETALIGNMENT;
    procedure ColWidthsChanged; override;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    function GetDroppedDown: boolean; override;
    function LocateRecord(var KeyValue: string): boolean; virtual;
    procedure SetDroppedDown(const Value: boolean); override;
    procedure SetDroppedIndirect(const Value: boolean); override;
    procedure WMMouseActivate(var Message: TWMActivate); message WM_MOUSEACTIVATE;
    procedure WMNCCalcSize(var Message: TWMNCCalcSize); message WM_NCCALCSIZE;
    procedure WMNCPaint(var Message: TWMNCPaint); message WM_NCPAINT;
    function  HighlightCell(DataCol, DataRow: Integer; const Value: string;
      AState: TGridDrawState): Boolean; override;
    procedure WMFontChange(var Message: TWMFontChange); message WM_FONTCHANGE;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMLButtonUp(var Message: TWMLButtonUp); message WM_LBUTTONUP;
    procedure WMNCHitTest(var Message: TWMNCHitTest); message WM_NCHITTEST;
    procedure WMSetCursor(var Message: TWMSetCursor); message WM_SETCURSOR;
    procedure WMNCLButtonDown(var Message: TWMNCLButtonDown); message WM_NCLBUTTONDOWN;
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure WMTimer(var Message: TWMTimer); message WM_TIMER;
    function  MouseUpBeforeDblClk: boolean; override;
    procedure TopLeftChanged; override;
  public
    procedure AdjustNewHeight;
    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer); override;
    procedure SetBoundsEx(ALeft, ATop, AWidth, AHeight: Integer);
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char);override;

    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure SetParent(AParent: TWinControl); override;
    procedure Show;
    procedure Hide;
    procedure StartSearch(Key: Char; AValue: string = '');
    procedure StopSearch;
    function ValidPosition: boolean;
    property AlwaysVisible: boolean read FAlwaysVisible write FAlwaysVisible;
    property Buttons: TDCEditButtons read FButtons;
    property DataSet: TDataSet read FDataSet write SetDataSet;
    property DrawingStyle: TDCDrawingStyle read FDrawingStyle
      write SetDrawingStyle;
    property DropDownRows: integer read FDropDownRows write FDropDownRows;
    property Owner: TControl read FOwner write FOwner;
    property PopupAlignment: TWindowAlignment read FPopupAlignment
      write SetPopupAlignment;
    property PopupOptions: TPopupGridOptions read FPopupOptions
      write SetPopupOptions;
    property PopupBorderStyle: TPopupBorderStyle read FPopupBorderStyle
      write SetPopupBorderStyle;
    property OnButtonClick: TNotifyEvent read FOnButtonClick write FOnButtonClick;
    property Columns;
    property OnCellClick;
    property OnDblClick;
    property BorderStyle;
    property DataSource;
    property OnTitleClick;
    property OptionsEx;
    property Options;
  end;

  TDCDBGrid = class(TDCCustomDBGrid)
  public
    property Canvas;
    property Position;
    property SelectedArea;
    property SelectedRows;
  published
    property Align;
    property Anchors;
    property BiDiMode;
    property BorderStyle;
    property Color;
    property Columns stored False; //StoreColumns;
    property Constraints;
    property Ctl3D;
    property DataSource;
    property DefaultDrawing;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property FixedColor;
    property Font;
    property Footer;
    property GridDrawing;
    property ImeMode;
    property ImeName;
    property Options;
    property OptionsEx;
    property ParentBiDiMode;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ReadOnly;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property TitleFont;
    property Visible;
    property OnCellClick;
    property OnCellDblClick;
    property OnColEnter;
    property OnColExit;
    property OnColumnMoved;
    property OnBookmarksChanged;
    property OnDrawDataCell;  { obsolete }
    property OnDrawColumnCell;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEditButtonClick;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnStartDock;
    property OnStartDrag;
    property OnTitleClick;
    property Images;
    property DefaultRowHeight;
    property OnClipClick;
    property FrozenCols;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnClipButtonClick;
    property PopupTitle;
    property DBObject;
    property OnColumnComment;
    property OnPaintEmptyMessage;
    property OnDrawCompleteLine;
    property OnPopupMenu;
  end;

implementation

uses DBConsts, Dialogs, DCChoice, TypInfo;

{$R *.RES}

const
  MaxMapSize = (MaxInt div 2) div SizeOf(Integer);  { 250 million }
  SLLTIMER_IDEVENT = SRCTIMER_IDEVENT + $1;

  pmSelectAll   = 0;
  pmDeselectAll = 1;

  DGF_COLEXITSTATE      = $1;
  DGF_ISESCKEYPRESS     = $2;
  DGF_ROWHEIGHTCHANGED  = $3;
  DGF_LAYOUTFROMDATASET = $4;
  DGF_SELFCHANGINGFONT  = $5;

type
  TPrivateControl = class(TCustomControl)
    {}
  end;

  TPrivateDataSet = class(TDataSet)
    {}
  end;

  TSelection = record
    StartPos, EndPos: Integer;
  end;

var
  DrawBitmap, TempBitmap: TBitmap;
  UserCount: Integer;

{ Error reporting }

procedure RaiseGridError(const S: string);
begin
  raise EInvalidGridOperation.Create(S);
end;

procedure KillMessage(Wnd: HWnd; Msg: Integer);
// Delete the requested message from the queue, but throw back
// any WM_QUIT msgs that PeekMessage may also return
var
  M: TMsg;
begin
  M.Message := 0;
  if PeekMessage(M, Wnd, Msg, Msg, pm_Remove) and (M.Message = WM_QUIT) then
    PostQuitMessage(M.wparam);
end;

function GetMultiLineHeight(Font: TFont; Value: string;
                            ACanvas: TCanvas = nil) : Longint;
var
 Canvas: TCanvas;
begin
  if ACanvas = nil then
  begin
    Canvas := nil;
    try
      Canvas := TCanvas.Create;
      Canvas.Handle := GetDC(0);
      Canvas.Font := Font;
      Result := _intMax(GetTextHeightEx(Canvas, Value, -1, False),
         GetTextHeightEx(Canvas, 'Wg', -1, False)) + 4;
    finally
      ReleaseDC(0, Canvas.Handle);
      Canvas.Handle := 0;
      Canvas.Free;
    end
  end
  else
    Result := _intMax(GetTextHeightEx(ACanvas, Value, -1, False),
      GetTextHeightEx(ACanvas, 'Wg', -1, False)) + 4;
end;

{ TDBGridInplaceEdit }

{ TDBGridInplaceEdit adds support for a button on the in-place editor,
  which can be used to drop down a table-based lookup list, a stringlist-based
  pick list, or (if button style is esEllipsis) fire the grid event
  OnEditButtonClick.  }

type
  TEditStyle = (esSimple, esEllipsis, esPickList, esDataList);
  TPopupListbox = class;

  TDBGridInplaceEdit = class(TInplaceEdit)
  private
    FButtonWidth: Integer;
    FDataList: TDBLookupListBox;
    FPickList: TPopupListbox;
    FActiveList: TWinControl;
    FLookupSource: TDatasource;
    FEditStyle: TEditStyle;
    FListVisible: Boolean;
    FTracking: Boolean;
    FPressed: Boolean;
    procedure ListMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SetEditStyle(Value: TEditStyle);
    procedure StopTracking;
    procedure TrackButton(X,Y: Integer);
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure WMCancelMode(var Message: TMessage); message WM_CANCELMODE;
    procedure WMKillFocus(var Message: TMessage); message WM_KILLFOCUS;
    procedure WMLButtonDblClk(var Message: TWMLButtonDblClk); message WM_LBUTTONDBLCLK;
    procedure WMPaint(var Message: TWMPaint); message wm_Paint;
    procedure WMSetCursor(var Message: TWMSetCursor); message WM_SETCURSOR;
    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SETFOCUS;
    function OverButton(const P: TPoint): Boolean;
    function ButtonRect: TRect;
  protected
    procedure BoundsChanged; override;
    procedure CloseUp(Accept: Boolean);
    procedure DoDropDownKeys(var Key: Word; Shift: TShiftState);
    procedure DropDown;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure PaintWindow(DC: HDC); override;
    procedure UpdateContents; override;
    procedure WndProc(var Message: TMessage); override;
    property  EditStyle: TEditStyle read FEditStyle write SetEditStyle;
    property  ActiveList: TWinControl read FActiveList write FActiveList;
    property  DataList: TDBLookupListBox read FDataList;
    property  PickList: TPopupListbox read FPickList;
  public
    constructor Create(Owner: TComponent); override;
  end;

{ TPopupListbox }

  TPopupListbox = class(TCustomListbox)
  private
    FSearchText: String;
    FSearchTickCount: Longint;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    procedure KeyPress(var Key: Char); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
  end;

procedure TPopupListBox.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do
  begin
    Style := Style or WS_BORDER;
    ExStyle := WS_EX_TOOLWINDOW or WS_EX_TOPMOST;
    AddBiDiModeExStyle(ExStyle);
    WindowClass.Style := CS_SAVEBITS;
  end;
end;

procedure TPopupListbox.CreateWnd;
begin
  inherited CreateWnd;
  Windows.SetParent(Handle, 0);
  CallWindowProc(DefWndProc, Handle, WM_SETFOCUS, 0, 0);
end;

procedure TPopupListbox.Keypress(var Key: Char);
var
  TickCount: Integer;
begin
  case Key of
    #8, #27: FSearchText := '';
    #32..#255:
      begin
        TickCount := GetTickCount;
        if TickCount - FSearchTickCount > 2000 then FSearchText := '';
        FSearchTickCount := TickCount;
        if Length(FSearchText) < 32 then FSearchText := FSearchText + Key;
        SendMessage(Handle, LB_SelectString, WORD(-1), Longint(PChar(FSearchText)));
        Key := #0;
      end;
  end;
  inherited Keypress(Key);
end;

procedure TPopupListbox.MouseUp(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin
  inherited MouseUp(Button, Shift, X, Y);
  TDBGridInPlaceEdit(Owner).CloseUp((X >= 0) and (Y >= 0) and
      (X < Width) and (Y < Height));
end;


constructor TDBGridInplaceEdit.Create(Owner: TComponent);
begin
  inherited Create(Owner);
  FLookupSource := TDataSource.Create(Self);
  FButtonWidth := GetSystemMetrics(SM_CXVSCROLL);
  FEditStyle := esSimple;
end;

procedure TDBGridInplaceEdit.BoundsChanged;
var
  R: TRect;
begin
  if dgFlatLines in TDCCustomDBGrid(Owner).Options then
    SetBounds(Left, Top, Width - 1, Height - 1);
  SetRect(R, 2, 2, Width - 2, Height);
  if FEditStyle <> esSimple then
    if not TDCCustomDBGrid(Owner).UseRightToLeftAlignment then
      Dec(R.Right, FButtonWidth)
    else
      Inc(R.Left, FButtonWidth - 2);
  SendMessage(Handle, EM_SETRECTNP, 0, LongInt(@R));
  SendMessage(Handle, EM_SCROLLCARET, 0, 0);
  if SysLocale.FarEast then
    SetImeCompositionWindow(Font, R.Left, R.Top);
end;

procedure TDBGridInplaceEdit.CloseUp(Accept: Boolean);
var
  MasterField: TField;
  ListValue: Variant;
begin
  if FListVisible then
  begin
    if GetCapture <> 0 then SendMessage(GetCapture, WM_CANCELMODE, 0, 0);
    if FActiveList = FDataList then
      ListValue := FDataList.KeyValue
    else
      if FPickList.ItemIndex <> -1 then
        ListValue := FPickList.Items[FPicklist.ItemIndex];
    SetWindowPos(FActiveList.Handle, 0, 0, 0, 0, 0, SWP_NOZORDER or
      SWP_NOMOVE or SWP_NOSIZE or SWP_NOACTIVATE or SWP_HIDEWINDOW);
    FListVisible := False;
    if Assigned(FDataList) then
      FDataList.ListSource := nil;
    FLookupSource.Dataset := nil;
    Invalidate;
    if Accept then
      if FActiveList = FDataList then
        with TDCCustomDBGrid(Grid), Columns[SelectedIndex].Field do
        begin
          MasterField := DataSet.FieldByName(KeyFields);
          if MasterField.CanModify then
          begin
            DataSet.Edit;
            MasterField.Value := ListValue;
          end;
        end
      else
        if (not VarIsNull(ListValue)) and EditCanModify then
          with TDCCustomDBGrid(Grid), Columns[SelectedIndex].Field do
            Text := ListValue;
  end;
end;

procedure TDBGridInplaceEdit.DoDropDownKeys(var Key: Word; Shift: TShiftState);
begin
  case Key of
    VK_UP, VK_DOWN:
      if ssAlt in Shift then
      begin
        if FListVisible then CloseUp(True) else DropDown;
        Key := 0;
      end;
    VK_RETURN, VK_ESCAPE:
      if FListVisible and not (ssAlt in Shift) then
      begin
        CloseUp(Key = VK_RETURN);
        Key := 0;
      end;
  end;
end;

procedure TDBGridInplaceEdit.DropDown;
var
  P: TPoint;
  I,J,Y: Integer;
  Column: TColumn;
begin
  if not FListVisible and Assigned(FActiveList) then
  begin
    FActiveList.Width := Width;
    with TDCCustomDBGrid(Grid) do
      Column := Columns[SelectedIndex];
    if FActiveList = FDataList then
    with Column.Field do
    begin
      FDataList.Color := Color;
      FDataList.Font := Font;
      FDataList.RowCount := Column.DropDownRows;
      FLookupSource.DataSet := LookupDataSet;
      FDataList.KeyField := LookupKeyFields;
      FDataList.ListField := LookupResultField;
      FDataList.ListSource := FLookupSource;
      FDataList.KeyValue := DataSet.FieldByName(KeyFields).Value;
{      J := Column.DefaultWidth;
      if J > FDataList.ClientWidth then
        FDataList.ClientWidth := J;
}    end
    else
    begin
      FPickList.Color := Color;
      FPickList.Font := Font;
      FPickList.Items := Column.Picklist;
      if FPickList.Items.Count >= Integer(Column.DropDownRows) then
        FPickList.Height := Integer(Column.DropDownRows) * FPickList.ItemHeight + 4
      else
        FPickList.Height := FPickList.Items.Count * FPickList.ItemHeight + 4;
      if Column.Field.IsNull then
        FPickList.ItemIndex := -1
      else
        FPickList.ItemIndex := FPickList.Items.IndexOf(Column.Field.Text);
      J := FPickList.ClientWidth;
      for I := 0 to FPickList.Items.Count - 1 do
      begin
        Y := FPickList.Canvas.TextWidth(FPickList.Items[I]);
        if Y > J then J := Y;
      end;
      FPickList.ClientWidth := J;
    end;
    P := Parent.ClientToScreen(Point(Left, Top));
    Y := P.Y + Height;
    if Y + FActiveList.Height > Screen.Height then Y := P.Y - FActiveList.Height;
    SetWindowPos(FActiveList.Handle, HWND_TOP, P.X, Y, 0, 0,
      SWP_NOSIZE or SWP_NOACTIVATE or SWP_SHOWWINDOW);
    FListVisible := True;
    Invalidate;
    Windows.SetFocus(Handle);
  end;
end;

type
  TWinControlCracker = class(TWinControl)
    {for implement protected properties and functions}
  end;

procedure TDBGridInplaceEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  if (EditStyle = esEllipsis) and (Key = VK_RETURN) and (Shift = [ssCtrl]) then
  begin
    TDCCustomDBGrid(Grid).EditButtonClick;
    KillMessage(Handle, WM_CHAR);
  end
  else
    inherited KeyDown(Key, Shift);
end;

procedure TDBGridInplaceEdit.ListMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then
    CloseUp(PtInRect(FActiveList.ClientRect, Point(X, Y)));
end;

procedure TDBGridInplaceEdit.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin
  if (Button = mbLeft) and (FEditStyle <> esSimple) and
    OverButton(Point(X,Y)) then
  begin
    if FListVisible then
      CloseUp(False)
    else
    begin
      MouseCapture := True;
      FTracking := True;
      TrackButton(X, Y);
      if Assigned(FActiveList) then
        DropDown;
    end;
  end;
  inherited MouseDown(Button, Shift, X, Y);
end;

procedure TDBGridInplaceEdit.MouseMove(Shift: TShiftState; X, Y: Integer);
var
  ListPos: TPoint;
  MousePos: TSmallPoint;
begin
  if FTracking then
  begin
    TrackButton(X, Y);
    if FListVisible then
    begin
      ListPos := FActiveList.ScreenToClient(ClientToScreen(Point(X, Y)));
      if PtInRect(FActiveList.ClientRect, ListPos) then
      begin
        StopTracking;
        MousePos := PointToSmallPoint(ListPos);
        SendMessage(FActiveList.Handle, WM_LBUTTONDOWN, 0, Integer(MousePos));
        Exit;
      end;
    end;
  end;
  inherited MouseMove(Shift, X, Y);
end;

procedure TDBGridInplaceEdit.MouseUp(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
var
  WasPressed: Boolean;
begin
  WasPressed := FPressed;
  StopTracking;
  if (Button = mbLeft) and (FEditStyle = esEllipsis) and WasPressed then
    TDCCustomDBGrid(Grid).EditButtonClick;
  inherited MouseUp(Button, Shift, X, Y);
end;

procedure TDBGridInplaceEdit.PaintWindow(DC: HDC);
var
  R: TRect;
  Flags: Integer;
  W, X, Y: Integer;
begin
  if FEditStyle <> esSimple then
  begin
    R := ButtonRect;
    Flags := 0;
    if FEditStyle in [esDataList, esPickList] then
    begin
      if FActiveList = nil then
        Flags := DFCS_INACTIVE
      else if FPressed then
        Flags := DFCS_FLAT or DFCS_PUSHED;
      DrawFrameControl(DC, R, DFC_SCROLL, Flags or DFCS_SCROLLCOMBOBOX);
    end
    else   { esEllipsis }
    begin
      if FPressed then Flags := BF_FLAT;
      DrawEdge(DC, R, EDGE_RAISED, BF_RECT or BF_MIDDLE or Flags);
      X := R.Left + ((R.Right - R.Left) shr 1) - 1 + Ord(FPressed);
      Y := R.Top + ((R.Bottom - R.Top) shr 1) - 1 + Ord(FPressed);
      W := FButtonWidth shr 3;
      if W = 0 then W := 1;
      PatBlt(DC, X, Y, W, W, BLACKNESS);
      PatBlt(DC, X - (W * 2), Y, W, W, BLACKNESS);
      PatBlt(DC, X + (W * 2), Y, W, W, BLACKNESS);
    end;
    ExcludeClipRect(DC, R.Left, R.Top, R.Right, R.Bottom);
  end;
  inherited PaintWindow(DC);
end;

procedure TDBGridInplaceEdit.SetEditStyle(Value: TEditStyle);
begin
  if Value = FEditStyle then Exit;
  FEditStyle := Value;
  case Value of
    esPickList:
      begin
        if FPickList = nil then
        begin
          FPickList := TPopupListbox.Create(Self);
          FPickList.Visible := False;
          FPickList.Parent := Self;
          FPickList.OnMouseUp := ListMouseUp;
          FPickList.IntegralHeight := True;
          FPickList.ItemHeight := 11;
        end;
        FActiveList := FPickList;
      end;
    esDataList:
      begin
        if FDataList = nil then
        begin
          FDataList := TPopupDataList.Create(Self);
          FDataList.Visible := False;
          FDataList.Parent := Self;
          FDataList.OnMouseUp := ListMouseUp;
        end;
        FActiveList := FDataList;
      end;
  else  { cbsNone, cbsEllipsis, or read only field }
    FActiveList := nil;
  end;
  with TDCCustomDBGrid(Grid) do
    Self.ReadOnly := Columns[SelectedIndex].ReadOnly;
  Repaint;
end;

procedure TDBGridInplaceEdit.StopTracking;
begin
  if FTracking then
  begin
    TrackButton(-1, -1);
    FTracking := False;
    MouseCapture := False;
  end;
end;

procedure TDBGridInplaceEdit.TrackButton(X,Y: Integer);
var
  NewState: Boolean;
  R: TRect;
begin
  R := ButtonRect;
  NewState := PtInRect(R, Point(X, Y));
  if FPressed <> NewState then
  begin
    FPressed := NewState;
    InvalidateRect(Handle, @R, False);
  end;
end;

procedure TDBGridInplaceEdit.UpdateContents;
var
  Column: TColumn;
  NewStyle: TEditStyle;
  MasterField: TField;
begin
  with TDCCustomDBGrid(Grid) do
  begin
    if Columns.Count <= SelectedIndex then Exit;
    Column := Columns[SelectedIndex];
  end;
  NewStyle := esSimple;
  case Column.ButtonStyle of
   cbsEllipsis: NewStyle := esEllipsis;
   cbsAuto:
     if Assigned(Column.Field) then
     with Column.Field do
     begin
       { Show the dropdown button only if the field is editable }
       if FieldKind = fkLookup then
       begin
         MasterField := Dataset.FieldByName(KeyFields);
         { Column.DefaultReadonly will always be True for a lookup field.
           Test if Column.ReadOnly has been assigned a value of True }
         if Assigned(MasterField) and MasterField.CanModify and
           not ((cvReadOnly in Column.AssignedValues) and Column.ReadOnly) then
           with TDCCustomDBGrid(Grid) do
             if not ReadOnly and DataLink.Active and not Datalink.ReadOnly then
               NewStyle := esDataList
       end
       else
       if Assigned(Column.Picklist) and (Column.PickList.Count > 0) and
         not Column.Readonly then
         NewStyle := esPickList
       else if DataType in [ftDataset, ftReference] then
         NewStyle := esEllipsis;
     end;
  end;
  EditStyle := NewStyle;
  inherited UpdateContents;
  Font.Assign(Column.Font);
end;

procedure TDBGridInplaceEdit.CMCancelMode(var Message: TCMCancelMode);
begin
  if (Message.Sender <> Self) and (Message.Sender <> FActiveList) then
    CloseUp(False);
end;

procedure TDBGridInplaceEdit.WMCancelMode(var Message: TMessage);
begin
  StopTracking;
  inherited;
end;

procedure TDBGridInplaceEdit.WMKillFocus(var Message: TMessage);
 var
  ARect: TRect;
begin
  if not SysLocale.FarEast then inherited
  else
  begin
    ImeName := Screen.DefaultIme;
    ImeMode := imDontCare;
    inherited;
    if HWND(Message.WParam) <> TDCCustomDBGrid(Grid).Handle then
      ActivateKeyboardLayout(Screen.DefaultKbLayout, KLF_ACTIVATE);
  end;
  CloseUp(False);
  with TDCCustomDBGrid(Grid) do
  begin
    if dgHighlightRow in Options then
    begin
      ARect := BoxRectEx(0 , Row , ColCount-1, Row );
      ValidateRect(Handle, @ARect);
      InvalidateRect(Handle, @ARect, False);
    end;
  end;
end;

function TDBGridInplaceEdit.ButtonRect: TRect;
begin
  if not TDCCustomDBGrid(Owner).UseRightToLeftAlignment then
    Result := Rect(Width - FButtonWidth, 0, Width, Height)
  else
    Result := Rect(0, 0, FButtonWidth, Height);
end;

function TDBGridInplaceEdit.OverButton(const P: TPoint): Boolean;
begin
  Result := PtInRect(ButtonRect, P);
end;

procedure TDBGridInplaceEdit.WMLButtonDblClk(var Message: TWMLButtonDblClk);
begin
  with Message do
  if (FEditStyle <> esSimple) and OverButton(Point(XPos, YPos)) then
    Exit;
  inherited;
end;

procedure TDBGridInplaceEdit.WMPaint(var Message: TWMPaint);
begin
  PaintHandler(Message);
end;

procedure TDBGridInplaceEdit.WMSetCursor(var Message: TWMSetCursor);
var
  P: TPoint;
begin
  GetCursorPos(P);
  P := ScreenToClient(P);
  if (FEditStyle <> esSimple) and OverButton(P) then
    Windows.SetCursor(LoadCursor(0, IDC_ARROW))
  else
    inherited;
end;

procedure TDBGridInplaceEdit.WndProc(var Message: TMessage);
begin
  case Message.Msg of
    WM_KEYDOWN, WM_SYSKEYDOWN, WM_CHAR:
      if EditStyle in [esPickList, esDataList] then
      with TWMKey(Message) do
      begin
        DoDropDownKeys(CharCode, KeyDataToShiftState(KeyData));
        if (CharCode <> 0) and FListVisible then
        begin
          with TMessage(Message) do
            SendMessage(FActiveList.Handle, Msg, WParam, LParam);
          Exit;
        end;
      end
  end;
  inherited;
end;

{ TGridDataLink }

constructor TGridDataLink.Create(AGrid: TDCCustomDBGrid);
begin
  inherited Create;
  FGrid := AGrid;
  VisualControl := True;
end;

destructor TGridDataLink.Destroy;
begin
  ClearMapping;
  inherited Destroy;
end;

function TGridDataLink.GetDefaultFields: Boolean;
var
  I: Integer;
begin
  Result := True;
  if DataSet <> nil then Result := DataSet.DefaultFields;
  if Result and SparseMap then
  for I := 0 to FFieldCount-1 do
    if FFieldMap[I] < 0 then
    begin
      Result := False;
      Exit;
    end;
end;

function TGridDataLink.GetFields(I: Integer): TField;
begin
  if (0 <= I) and (I < FFieldCount) and (FFieldMap[I] >= 0) and
    (FFieldMap[I] < DataSet.FieldList.Count) then
    Result := DataSet.FieldList[FFieldMap[I]]
  else
    Result := nil;
end;

function TGridDataLink.AddMapping(const FieldName: string): Boolean;
var
  Field: TField;
  NewSize: Integer;
begin
  Result := True;
  if FFieldCount >= MaxMapSize then RaiseGridError(STooManyColumns);
  if SparseMap then
    Field := DataSet.FindField(FieldName)
  else
    Field := DataSet.FieldByName(FieldName);

  if FFieldCount = Length(FFieldMap) then
  begin
    NewSize := Length(FFieldMap);
    if NewSize = 0 then
      NewSize := 8
    else
      Inc(NewSize, NewSize);
    if (NewSize < FFieldCount) then
      NewSize := FFieldCount + 1;
    if (NewSize > MaxMapSize) then
      NewSize := MaxMapSize;
    SetLength(FFieldMap, NewSize);
  end;
  if Assigned(Field) then
  begin
    FFieldMap[FFieldCount] := Dataset.FieldList.IndexOfObject(Field);
    Field.FreeNotification(FGrid);
  end
  else
    FFieldMap[FFieldCount] := -1;
  Inc(FFieldCount);
end;

procedure TGridDataLink.ActiveChanged;
begin
  FGrid.LinkActive(Active);
  FModified := False;
end;

procedure TGridDataLink.ClearMapping;
begin
  FFieldMap := nil;
  FFieldCount := 0;
end;

procedure TGridDataLink.Modified;
begin
  FModified := True;
end;

procedure TGridDataLink.DataSetChanged;
begin
  FGrid.DataChanged;
  FModified := False;
end;

procedure TGridDataLink.DataSetScrolled(Distance: Integer);
begin
  FGrid.Scroll(Distance);
end;

procedure TGridDataLink.LayoutChanged;
var
  SaveState: Boolean;
begin
  { FLayoutFromDataset determines whether default column width is forced to
    be at least wide enough for the column title.  }
  SaveState := _getFlag(FGrid.FFlags, DGF_LAYOUTFROMDATASET);
  try
    FGrid.LayoutChanged;
  finally
    _setFlag(FGrid.FFlags, DGF_LAYOUTFROMDATASET, SaveState);
  end;
  inherited LayoutChanged;
end;

procedure TGridDataLink.FocusControl(Field: TFieldRef);
begin
  if Assigned(Field) and Assigned(Field^) then
  begin
    FGrid.SelectedField := Field^;
    if (FGrid.SelectedField = Field^) and FGrid.AcquireFocus then
    begin
      Field^ := nil;
      FGrid.ShowEditor;
    end;
  end;
end;

procedure TGridDataLink.EditingChanged;
begin
  FGrid.EditingChanged;
end;

procedure TGridDataLink.RecordChanged(Field: TField);
begin
  FGrid.RecordChanged(Field);
  FModified := False;
end;

procedure TGridDataLink.UpdateData;
begin
  if FModified then FGrid.UpdateData;
  FModified := False;
end;

function TGridDataLink.GetMappedIndex(ColIndex: Integer): Integer;
begin
  if (0 <= ColIndex) and (ColIndex < FFieldCount) then
    Result := FFieldMap[ColIndex]
  else
    Result := -1;
end;

procedure TGridDataLink.Reset;
begin
  if FModified then RecordChanged(nil) else Dataset.Cancel;
end;

function TGridDataLink.MoveBy(Distance: Integer): Integer;
begin
  Result := inherited MoveBy(Distance);
end;

{ TColumnTitle }
constructor TColumnTitle.Create(Column: TColumn);
begin
  inherited Create;
  FColumn := Column;
  FFont := TFont.Create;
  FFont.Assign(DefaultFont);
  FFont.OnChange := FontChanged;
end;

destructor TColumnTitle.Destroy;
begin
  FFont.Free;
  inherited Destroy;
end;

procedure TColumnTitle.Assign(Source: TPersistent);
begin
  if Source is TColumnTitle then
  begin
    if cvTitleAlignment in TColumnTitle(Source).FColumn.FAssignedValues then
      Alignment := TColumnTitle(Source).Alignment;
    if cvTitleColor in TColumnTitle(Source).FColumn.FAssignedValues then
      Color := TColumnTitle(Source).Color;
    if cvTitleCaption in TColumnTitle(Source).FColumn.FAssignedValues then
      Caption := TColumnTitle(Source).Caption;
    if cvTitleFont in TColumnTitle(Source).FColumn.FAssignedValues then
      Font := TColumnTitle(Source).Font;
  end
  else
    inherited Assign(Source);
end;

function TColumnTitle.DefaultAlignment: TAlignment;
begin
  Result := taLeftJustify;
end;

function TColumnTitle.DefaultColor: TColor;
var
  Grid: TDCCustomDBGrid;
begin
  Grid := FColumn.GetGrid;
  if Assigned(Grid) then
    Result := Grid.FixedColor
  else
    Result := clBtnFace;
end;

function TColumnTitle.DefaultFont: TFont;
var
  Grid: TDCCustomDBGrid;
begin
  Grid := FColumn.GetGrid;
  if Assigned(Grid) then
    Result := Grid.TitleFont
  else
    Result := FColumn.Font;
end;

function TColumnTitle.DefaultCaption: string;
var
  Field: TField;
begin
  Field := FColumn.Field;
  if Assigned(Field) then
    Result := Field.DisplayName
  else
    Result := FColumn.FieldName;
end;

procedure TColumnTitle.FontChanged(Sender: TObject);
begin
  Include(FColumn.FAssignedValues, cvTitleFont);
  FColumn.Changed(True);
end;

function TColumnTitle.GetAlignment: TAlignment;
begin
  if cvTitleAlignment in FColumn.FAssignedValues then
    Result := FAlignment
  else
    Result := DefaultAlignment;
end;

function TColumnTitle.GetColor: TColor;
begin
  if cvTitleColor in FColumn.FAssignedValues then
    Result := FColor
  else
    Result := DefaultColor;
end;

function TColumnTitle.GetCaption: string;
begin
  if cvTitleCaption in FColumn.FAssignedValues then
    Result := FCaption
  else
    Result := DefaultCaption;
end;

function TColumnTitle.GetFont: TFont;
var
  Save: TNotifyEvent;
  Def: TFont;
begin
  if not (cvTitleFont in FColumn.FAssignedValues) then
  begin
    Def := DefaultFont;
    if (FFont.Handle <> Def.Handle) or (FFont.Color <> Def.Color) then
    begin
      Save := FFont.OnChange;
      FFont.OnChange := nil;
      FFont.Assign(DefaultFont);
      FFont.OnChange := Save;
    end;
  end;
  Result := FFont;
end;

function TColumnTitle.IsAlignmentStored: Boolean;
begin
  Result := (cvTitleAlignment in FColumn.FAssignedValues) and
    (FAlignment <> DefaultAlignment);
end;

function TColumnTitle.IsColorStored: Boolean;
begin
  Result := (cvTitleColor in FColumn.FAssignedValues) and
    (FColor <> DefaultColor);
end;

function TColumnTitle.IsFontStored: Boolean;
begin
  Result := (cvTitleFont in FColumn.FAssignedValues);
end;

function TColumnTitle.IsCaptionStored: Boolean;
begin
  Result := (cvTitleCaption in FColumn.FAssignedValues) and
    (FCaption <> DefaultCaption);
end;

procedure TColumnTitle.RefreshDefaultFont;
var
  Save: TNotifyEvent;
begin
  if (cvTitleFont in FColumn.FAssignedValues) then Exit;
  Save := FFont.OnChange;
  FFont.OnChange := nil;
  try
    FFont.Assign(DefaultFont);
  finally
    FFont.OnChange := Save;
  end;
end;

procedure TColumnTitle.RestoreDefaults;
var
  FontAssigned: Boolean;
begin
  FontAssigned := cvTitleFont in FColumn.FAssignedValues;
  FColumn.FAssignedValues := FColumn.FAssignedValues - ColumnTitleValues;
  FCaption := '';
  RefreshDefaultFont;
  { If font was assigned, changing it back to default may affect grid title
    height, and title height changes require layout and redraw of the grid. }
  FColumn.Changed(FontAssigned);
end;

procedure TColumnTitle.SetAlignment(Value: TAlignment);
begin
  if (cvTitleAlignment in FColumn.FAssignedValues) and (Value = FAlignment) then Exit;
  FAlignment := Value;
  Include(FColumn.FAssignedValues, cvTitleAlignment);
  FColumn.Changed(False);
end;

procedure TColumnTitle.SetColor(Value: TColor);
begin
  if (cvTitleColor in FColumn.FAssignedValues) and (Value = FColor) then Exit;
  FColor := Value;
  Include(FColumn.FAssignedValues, cvTitleColor);
  FColumn.Changed(False);
end;

procedure TColumnTitle.SetFont(Value: TFont);
begin
  FFont.Assign(Value);
end;

procedure TColumnTitle.SetCaption(const Value: string);
var
  Grid: TDCCustomDBGrid;
begin
  Grid := Column.GetGrid;
  if Column.IsStored then
  begin
    if (cvTitleCaption in FColumn.FAssignedValues) and (Value = FCaption) then Exit;
    FCaption := Value;
    Include(Column.FAssignedValues, cvTitleCaption);
    Column.Changed(False);
  end
  else
  begin
    if Assigned(Grid) and (Grid.Datalink.Active) and Assigned(Column.Field) then
      Column.Field.DisplayLabel := Value;
  end;
  if Assigned(Grid) and (Grid.LayoutLock = 0) then Grid.InternalLayout;
end;

{ TColumn }

constructor TColumn.Create(Collection: TCollection);
 var
  Grid: TDCCustomDBGrid;
  ColumnCreateItems: TDCColumnInitialize;
begin
  Grid := nil;
  if Assigned(Collection) and (Collection is TDBGridColumns) then
    Grid := TDBGridColumns(Collection).Grid;
  if Assigned(Grid) then Grid.BeginLayout;
  try
    inherited Create(Collection);
    ColumnCreateItems := Initialize;
    FDropDownRows := 7;
    FButtonStyle := cbsAuto;
    FFont := TFont.Create;
    FFont.Assign(DefaultFont);
    FFont.OnChange := FontChanged;
    FImeMode := imDontCare;
    FImeName := Screen.DefaultIme;
    FTitle := ColumnCreateItems.ColumnTitleClass.Create(Self);
    FVisible := True;
    FExpanded := True;
    FStored := True;
    FItemIndex := -1;
    FTag := 0;
    FResize  := True;
    FComment := '';
    FWordBreak := False;
    FVertAlignment := vaCenter;
    if Assigned(Grid) and Assigned(Grid.ColumnFooter) then
      FFooterPanel := TColumnFooterPanel.Create(Grid.ColumnFooter.Panels)
    else
      FFooterPanel := TColumnFooterPanel.Create(nil);
    FFooterPanel.FColumn := Self;
  finally
    if Assigned(Grid) then
    begin
      Grid.EndLayout;
      if dgAutoSize in Grid.Options then Grid.Perform(CM_SHOWINGCHANGED, 0, 0);
    end
  end;
end;

destructor TColumn.Destroy;
begin
  FFooterPanel.Free;
  FTitle.Free;
  FFont.Free;
  FPickList.Free;
  inherited Destroy;
end;

procedure TColumn.Assign(Source: TPersistent);
begin
  if Source is TColumn then
  begin
    if Assigned(Collection) then Collection.BeginUpdate;
    try
      RestoreDefaults;
      FieldName := TColumn(Source).FieldName;
      if cvColor in TColumn(Source).AssignedValues then
        Color := TColumn(Source).Color;
      if cvWidth in TColumn(Source).AssignedValues then
      begin
        FWidth := TColumn(Source).FWidth;
        FAssignedValues := FAssignedValues + [cvWidth];
      end;
      if cvFont in TColumn(Source).AssignedValues then
        Font := TColumn(Source).Font;
      if cvImeMode in TColumn(Source).AssignedValues then
        ImeMode := TColumn(Source).ImeMode;
      if cvImeName in TColumn(Source).AssignedValues then
        ImeName := TColumn(Source).ImeName;
      if cvAlignment in TColumn(Source).AssignedValues then
        Alignment := TColumn(Source).Alignment;
      if cvReadOnly in TColumn(Source).AssignedValues then
        ReadOnly := TColumn(Source).ReadOnly;
      Title := TColumn(Source).Title;
      DropDownRows := TColumn(Source).DropDownRows;
      ButtonStyle := TColumn(Source).ButtonStyle;
      PickList := TColumn(Source).PickList;
      PopupMenu := TColumn(Source).PopupMenu;
      FVisible := TColumn(Source).FVisible;
      FExpanded := TColumn(Source).FExpanded;
      FItemIndex := TColumn(Source).FItemIndex;
      FIndexed := TColumn(Source).FIndexed;
      FIndexStyle := TColumn(Source).FIndexStyle;
      FDisplayFormat := TColumn(Source).FDisplayFormat;
      FTag := TColumn(Source).FTag;
      FResize := TColumn(Source).FResize;
      FComment := TColumn(Source).FComment;
      FWordBreak := TColumn(Source).FWordBreak;
      FVertAlignment := TColumn(Source).FVertAlignment;
      FooterPanel.Visible := TColumn(Source).FooterPanel.Visible;
      FooterPanel.Text := TColumn(Source).FooterPanel.Text;
    finally
      if Assigned(Collection) then Collection.EndUpdate;
    end;
  end
  else
    inherited Assign(Source);
end;

function TColumn.DefaultAlignment: TAlignment;
begin
  if Assigned(Field) then
    Result := FField.Alignment
  else
    Result := taLeftJustify;
end;

function TColumn.DefaultColor: TColor;
var
  Grid: TDCCustomDBGrid;
begin
  Grid := GetGrid;
  if Assigned(Grid) then
    Result := Grid.Color
  else
    Result := clWindow;
end;

function TColumn.DefaultFont: TFont;
var
  Grid: TDCCustomDBGrid;
begin
  Grid := GetGrid;
  if Assigned(Grid) then
    Result := Grid.Font
  else
    Result := FFont;
end;

function TColumn.DefaultImeMode: TImeMode;
var
  Grid: TDCCustomDBGrid;
begin
  Grid := GetGrid;
  if Assigned(Grid) then
    Result := Grid.ImeMode
  else
    Result := FImeMode;
end;

function TColumn.DefaultImeName: TImeName;
var
  Grid: TDCCustomDBGrid;
begin
  Grid := GetGrid;
  if Assigned(Grid) then
    Result := Grid.ImeName
  else
    Result := FImeName;
end;

function TColumn.DefaultReadOnly: Boolean;
 var
  Grid: TDCCustomDBGrid;
begin
  Grid := GetGrid;
  Result := (Assigned(Grid) and Grid.ReadOnly) or
    (Assigned(Field) and FField.ReadOnly);
end;

function TColumn.DefaultWidth: Integer;
 var
  W: Integer;
  RestoreCanvas: Boolean;
  TM: TTextMetric;
  BitmapsOffset, x: Integer;
begin
  if GetGrid = nil then
  begin
    Result := 64;
    Exit;
  end;
  with GetGrid do
  begin
    if Assigned(Field) then
    begin
      RestoreCanvas := not(HandleAllocated and GetTextMetrics(Canvas.Handle, TM));
      if RestoreCanvas then Canvas.Handle := GetDC(0);
      try
        Canvas.Font := Self.Font;
        GetTextMetrics(Canvas.Handle, TM);
        x := Canvas.TextWidth('0');
        Result := Field.DisplayWidth * x{TM.tmAveCharWidth} + TM.tmOverhang +
          6 - TM.tmAveCharWidth div 2;
        if dgTitles in Options then
        begin
          Canvas.Font := Title.Font;
          if (Grid <> nil) and (dgTitleClicked in Grid.Options) and FIndexed
          then BitmapsOffset := IndexTitleWidth  else BitmapsOffset := 0;

          if (Grid.Images <> nil) and (FItemIndex <> -1)
          then Inc(BitmapsOffset,Grid.Images.Width+2);

          W := GetTextWidthEx(Canvas, Title.Caption) +
               4 + BitmapsOffset+ TM.tmOverhang + 4;
          if Result < W then
            Result := W;
        end;
      finally
        if RestoreCanvas then
        begin
          ReleaseDC(0, Canvas.Handle);
          Canvas.Handle := 0;
        end;
      end;
    end
    else
      Result := DefaultColWidth;
  end;
end;

procedure TColumn.FontChanged;
begin
  Include(FAssignedValues, cvFont);
  Title.RefreshDefaultFont;
  Changed(False);
end;

function TColumn.GetAlignment: TAlignment;
begin
  if cvAlignment in FAssignedValues then
    Result := FAlignment
  else
    Result := DefaultAlignment;
end;

function TColumn.GetColor: TColor;
begin
  if cvColor in FAssignedValues then
    Result := FColor
  else
    Result := DefaultColor;
end;

function TColumn.GetExpanded: Boolean;
begin
  Result := FExpanded and Expandable;
end;

function TColumn.GetField: TField;
var
  Grid: TDCCustomDBGrid;
begin    { Returns Nil if FieldName can't be found in dataset }
  Grid := GetGrid;
  if (FField = nil) and (Length(FFieldName) > 0) and Assigned(Grid) and
    Assigned(Grid.DataLink.DataSet) then
  with Grid.Datalink.Dataset do
    if Active or (not DefaultFields) then
      SetField(FindField(FieldName));
  Result := FField;
end;

function TColumn.GetFont: TFont;
var
  Save: TNotifyEvent;
begin
  if not (cvFont in FAssignedValues) and (FFont.Handle <> DefaultFont.Handle) then
  begin
    Save := FFont.OnChange;
    FFont.OnChange := nil;
    FFont.Assign(DefaultFont);
    FFont.OnChange := Save;
  end;
  Result := FFont;
end;

function TColumn.GetGrid: TDCCustomDBGrid;
begin
  if Assigned(Collection) and (Collection is TDBGridColumns) then
    Result := TDBGridColumns(Collection).FGrid
  else
    Result := nil;
end;

function TColumn.GetDisplayName: string;
begin
  Result := FFieldName;
  if Result = '' then Result := inherited GetDisplayName;
end;

function TColumn.GetImeMode: TImeMode;
begin
  if cvImeMode in FAssignedValues then
    Result := FImeMode
  else
    Result := DefaultImeMode;
end;

function TColumn.GetImeName: TImeName;
begin
  if cvImeName in FAssignedValues then
    Result := FImeName
  else
    Result := DefaultImeName;
end;

function TColumn.GetParentColumn: TColumn;
var
  Col: TColumn;
  Fld: TField;
  I: Integer;
begin
  Result := nil;
  Fld := Field;
  if (Fld <> nil) and (Fld.ParentField <> nil) and (Collection <> nil) then
    for I := Index - 1 downto 0 do
    begin
      Col := TColumn(Collection.Items[I]);
      if Fld.ParentField = Col.Field then
      begin
        Result := Col;
        Exit;
      end;
    end;
end;

function TColumn.GetPickList: TStrings;
begin
  if FPickList = nil then
    FPickList := TStringList.Create;
  Result := FPickList;
end;

function TColumn.GetReadOnly: Boolean;
begin
  if cvReadOnly in FAssignedValues then
    Result := FReadOnly
  else
    Result := DefaultReadOnly;
end;

function TColumn.GetShowing: Boolean;
var
  Col: TColumn;
begin
  Result := not Expanded and Visible;
  if Result then
  begin
    Col := Self;
    repeat
      Col := Col.ParentColumn;
    until (Col = nil) or not Col.Expanded;
    Result := Col = nil;
  end;
end;

function TColumn.GetVisible: Boolean;
var
  Col: TColumn;
begin
  Result := FVisible;
  if Result then
  begin
    Col := ParentColumn;
    Result := Result and ((Col = nil) or Col.Visible);
  end;
end;

function TColumn.GetWidth: Integer;
begin
  if not(Showing or (Grid <> nil) and(csWriting in Grid.ComponentState)) then
  begin
    if (Grid <> nil) and
      (not(dgColLines in Grid.Options) or (dgFlatLines in Grid.Options)) then
      Result := 0
    else
      Result := -1
  end
  else
   Result := GetStoredWidth;
end;

function TColumn.IsAlignmentStored: Boolean;
begin
  Result := (cvAlignment in FAssignedValues) and (FAlignment <> DefaultAlignment);
end;

function TColumn.IsColorStored: Boolean;
begin
  Result := (cvColor in FAssignedValues) and (FColor <> DefaultColor);
end;

function TColumn.IsFontStored: Boolean;
begin
  Result := (cvFont in FAssignedValues);
end;

function TColumn.IsImeModeStored: Boolean;
begin
  Result := (cvImeMode in FAssignedValues) and (FImeMode <> DefaultImeMode);
end;

function TColumn.IsImeNameStored: Boolean;
begin
  Result := (cvImeName in FAssignedValues) and (FImeName <> DefaultImeName);
end;

function TColumn.IsReadOnlyStored: Boolean;
begin
  Result := (cvReadOnly in FAssignedValues) and (FReadOnly <> DefaultReadOnly);
end;

function TColumn.IsWidthStored: Boolean;
begin
  Result := (cvWidth in FAssignedValues) and (FWidth <> DefaultWidth);
end;

procedure TColumn.RefreshDefaultFont;
var
  Save: TNotifyEvent;
begin
  if cvFont in FAssignedValues then Exit;
  Save := FFont.OnChange;
  FFont.OnChange := nil;
  try
    FFont.Assign(DefaultFont);
  finally
    FFont.OnChange := Save;
  end;
end;

procedure TColumn.RestoreDefaults;
var
  FontAssigned: Boolean;
begin
  FontAssigned := cvFont in FAssignedValues;
  FTitle.RestoreDefaults;
  FAssignedValues := [];
  RefreshDefaultFont;
  FreeAndNil(FPickList);
  ButtonStyle := cbsAuto;
  Changed(FontAssigned);
end;

procedure TColumn.SetAlignment(Value: TAlignment);
var
  Grid: TDCCustomDBGrid;
begin
  if IsStored then
  begin
    if (cvAlignment in FAssignedValues) and (Value = FAlignment) then Exit;
    FAlignment := Value;
    Include(FAssignedValues, cvAlignment);
    Changed(False);
  end
  else
  begin
    Grid := GetGrid;
    if Assigned(Grid) and (Grid.Datalink.Active) and Assigned(Field) then
      Field.Alignment := Value;
  end;
end;

procedure TColumn.SetButtonStyle(Value: TColumnButtonStyle);
begin
  if Value = FButtonStyle then Exit;
  FButtonStyle := Value;
  Changed(False);
end;

procedure TColumn.SetColor(Value: TColor);
begin
  if (cvColor in FAssignedValues) and (Value = FColor) then Exit;
  FColor := Value;
  Include(FAssignedValues, cvColor);
  Changed(False);
end;

procedure TColumn.SetField(Value: TField);
begin
  if FField = Value then Exit;
  FField := Value;
  if Assigned(Value) then
    FFieldName := Value.FullName;
  if not IsStored then
  begin
    if Value = nil then
      FFieldName := '';
    RestoreDefaults;
  end;
  Changed(False);
end;

procedure TColumn.SetFieldName(const Value: String);
var
  AField: TField;
  Grid: TDCCustomDBGrid;
begin
  AField := nil;
  Grid := GetGrid;
  if Assigned(Grid) and Assigned(Grid.DataLink.DataSet) and
    not (csLoading in Grid.ComponentState) and (Length(Value) > 0) then
      AField := Grid.DataLink.DataSet.FindField(Value); { no exceptions }
  FFieldName := Value;
  SetField(AField);
  Changed(False);
  if not (cvTitleCaption in FAssignedValues) and Assigned(Grid) and
    (Grid.LayoutLock = 0) then Grid.InternalLayout;
end;

procedure TColumn.SetFont(Value: TFont);
begin
  FFont.Assign(Value);
  Include(FAssignedValues, cvFont);
  Changed(False);
end;

procedure TColumn.SetImeMode(Value: TImeMode);
begin
  if (cvImeMode in FAssignedValues) or (Value <> DefaultImeMode) then
  begin
    FImeMode := Value;
    Include(FAssignedValues, cvImeMode);
  end;
  Changed(False);
end;

procedure TColumn.SetImeName(Value: TImeName);
begin
  if (cvImeName in FAssignedValues) or (Value <> DefaultImeName) then
  begin
    FImeName := Value;
    Include(FAssignedValues, cvImeName);
  end;
  Changed(False);
end;

procedure TColumn.SetIndex(Value: Integer);
var
  Grid: TDCCustomDBGrid;
  Fld: TField;
  I, OldIndex: Integer;
  Col: TColumn;
begin
  OldIndex := Index;
  Grid := GetGrid;

  if IsStored then
  begin
    Grid.BeginLayout;
    try
      I := OldIndex + 1;  // move child columns along with parent
      while (I < Collection.Count) and (TColumn(Collection.Items[I]).ParentColumn = Self) do
        Inc(I);
      Dec(I);
      if OldIndex > Value then   // column moving left
      begin
        while I > OldIndex do
        begin
          Collection.Items[I].Index := Value;
          Inc(OldIndex);
        end;
        inherited SetIndex(Value);
      end
      else
      begin
        inherited SetIndex(Value);
        while I > OldIndex do
        begin
          Collection.Items[OldIndex].Index := Value;
          Dec(I);
        end;
      end;
    finally
      Grid.EndLayout;
    end;
  end
  else
  begin
    if (Grid <> nil) and Grid.Datalink.Active then
    begin
      if Grid.AcquireLayoutLock then
      try
        Col := Grid.ColumnAtDepth(Grid.Columns[Value], Depth);
        if (Col <> nil) then
        begin
          Fld := Col.Field;
          if Assigned(Fld) then
            Field.Index := Fld.Index;
        end;
      finally
        Grid.EndLayout;
      end;
    end;
    inherited SetIndex(Value);
  end;
end;

procedure TColumn.SetPickList(Value: TStrings);
begin
  if Value = nil then
  begin
    FPickList.Free;
    FPickList := nil;
    Exit;
  end;
  PickList.Assign(Value);
end;

procedure TColumn.SetPopupMenu(Value: TPopupMenu);
begin
  FPopupMenu := Value;
  if Value <> nil then Value.FreeNotification(GetGrid);
end;

procedure TColumn.SetReadOnly(Value: Boolean);
var
  Grid: TDCCustomDBGrid;
begin
  Grid := GetGrid;
  if not IsStored and Assigned(Grid) and Grid.Datalink.Active and Assigned(Field) then
    Field.ReadOnly := Value
  else
  begin
    if (cvReadOnly in FAssignedValues) and (Value = FReadOnly) then Exit;
    FReadOnly := Value;
    Include(FAssignedValues, cvReadOnly);
    Changed(False);
  end;
end;

procedure TColumn.SetTitle(Value: TColumnTitle);
begin
  FTitle.Assign(Value);
end;

procedure TColumn.SetWidth(Value: Integer);
var
  Grid: TDCCustomDBGrid;
  TM: TTextMetric;
  DoSetWidth: Boolean;
  x: integer;
begin
  DoSetWidth := IsStored;
  Grid := GetGrid;
  if not DoSetWidth then
  begin
    if Assigned(Grid) then
    begin
      if Grid.HandleAllocated and Assigned(Field) and Grid.FUpdateFields then
      with Grid do
      begin
        Canvas.Font := Self.Font;
        GetTextMetrics(Canvas.Handle, TM);
        x := Canvas.TextWidth('0');
        Field.DisplayWidth := (Value + (TM.tmAveCharWidth div 2) -
          TM.tmOverhang - 6) div x{TM.tmAveCharWidth};
      end;
      if not _getFlag(Grid.FFlags, DGF_LAYOUTFROMDATASET) or
        (cvWidth in FAssignedValues) then DoSetWidth := True;
    end
    else
      DoSetWidth := True;
  end;
  if DoSetWidth then
  begin
    if ((cvWidth in FAssignedValues) or (Value <> DefaultWidth))
      and Visible then
    begin
      FWidth := Value;
      Include(FAssignedValues, cvWidth);
    end;
    Changed(False)
  end;
end;

procedure TColumn.SetVisible(Value: Boolean);
 var
  Grid: TDCCustomDBGrid;
begin
  if Value <> FVisible then
  begin
    Grid := GetGrid;
    FVisible := Value;
    if Grid <> nil then
      Grid.UpdateFrozenCols(Grid.FFrozenCols);
    Width := Width;
  end;
end;

procedure TColumn.SetExpanded(Value: Boolean);
 const
  Direction: array [Boolean] of ShortInt = (-1,1);
 var
  Grid: TDCCustomDBGrid;
  WasShowing: Boolean;
begin
  if Value <> FExpanded then
  begin
    Grid := GetGrid;
    WasShowing := (Grid <> nil) and Grid.Columns[Grid.SelectedIndex].Showing;
    FExpanded := Value;
    Changed(True);
    if (Grid <> nil) and WasShowing then
    begin
      if not Grid.Columns[Grid.SelectedIndex].Showing then
        // The selected cell was hidden by this expand operation
        // Select 1st child (next col = 1) when parent is expanded
        // Select child's parent (prev col = -1) when parent is collapsed
        Grid.MoveCol(Grid.Col, Direction[FExpanded]);
    end;
  end;
end;

function TColumn.Depth: Integer;
var
  Col: TColumn;
begin
  Result := 0;
  Col := ParentColumn;
  if Col <> nil then Result := Col.Depth + 1;
end;

function TColumn.GetExpandable: Boolean;
var
  Fld: TField;
begin
  Fld := Field;
  Result := (Fld <> nil) and (Fld.DataType in [ftADT, ftArray]);
end;

procedure TColumn.SetIndexed(Value: Boolean);
begin
  if Value = FIndexed then Exit;
  FIndexed := Value;
  Changed(False);
end;

procedure TColumn.SetItemIndex(Value: Integer);
begin
  if Value <> FItemIndex then
  begin
    FItemIndex := Value;
    Changed(False);
  end;
end;


procedure TColumn.SetIndexStyle(const Value: TColumnIndexStyle);
begin
  if Value <> FIndexStyle then
  begin
    FIndexStyle := Value;
    Changed(False);
  end;
end;

procedure TColumn.SetDisplayFormat(const Value: string);
begin
  if Value <> FDisplayFormat then
  begin
    FDisplayFormat := Value;
    Changed(False);
  end;
end;

procedure TColumn.SetComment(const Value: string);
begin
  FComment := Value;
end;

procedure TColumn.SetWordBreak(const Value: boolean);
begin
  if Value <> FWordBreak then
  begin
    FWordBreak := Value;
    Changed(False);
  end;
end;

function TColumn.GetStoredWidth: integer;
begin
  if cvWidth in FAssignedValues then
    Result := FWidth
  else
    Result := DefaultWidth;
end;

procedure TColumn.SetFooterPanel(const Value: TColumnFooterPanel);
begin
  FFooterPanel.Assign(Value);
end;

procedure TColumn.SetOptions(const Value: TColumnOptions);
 var
  ChangedOptions: TColumnOptions;
  Grid: TDCCustomDBGrid;
begin
  ChangedOptions := (FOptions + Value) - (FOptions * Value);
  if FOptions <> Value then
  begin
    Grid := GetGrid;
    FOptions := Value;
    Changed(True);
    if gcPopupMenu in ChangedOptions then Grid.InvalidateTitles(True);
  end;
end;

procedure TColumn.SetVertAlignment(const Value: TVertAlignment);
begin
  if FVertAlignment <> Value then
  begin
    FVertAlignment := Value;
    Changed(False);
  end;
end;

procedure TColumn.UpdateTitleSize(Canvas: TCanvas);
 var
  PopupRect: TRect;
  FixedWidths: array[boolean] of integer;
begin
  FixedWidths[False] := -1;
  FixedWidths[True]  := Width - 1;
  if (gcPopupMenu in FOptions) and Assigned(Grid) and
    Grid.GetTitleMenuRect(Rect(0, 0, Width, 0), PopupRect) then
  begin
    Dec(FixedWidths[True], PopupRect.Right - PopupRect.Left + 2);
  end;
  FSize.Y:= GetTextHeightEx(Canvas, Title.Caption,
    FixedWidths[gcWordBreak in FOptions], gcWordBreak in FOptions);
end;

function TColumn.Initialize: TDCColumnInitialize;
begin
  Result.ColumnTitleClass := TColumnTitle;
end;

{ TDBGridColumns }

constructor TDBGridColumns.Create(Grid: TDCCustomDBGrid; ColumnClass: TColumnClass);
begin
  inherited Create(ColumnClass);
  FGrid := Grid;
end;

function TDBGridColumns.Add: TColumn;
begin
  Result := TColumn(inherited Add);
end;

function TDBGridColumns.GetColumn(Index: Integer): TColumn;
begin
  Result := TColumn(inherited Items[Index]);
end;

function TDBGridColumns.GetOwner: TPersistent;
begin
  Result := FGrid;
end;

procedure TDBGridColumns.LoadFromFile(const Filename: string);
var
  S: TFileStream;
begin
  S := TFileStream.Create(Filename, fmOpenRead);
  try
    LoadFromStream(S);
  finally
    S.Free;
  end;
end;

type
  TColumnsWrapper = class(TComponent)
  private
    FColumns: TDBGridColumns;
  published
    property Columns: TDBGridColumns read FColumns write FColumns;
  end;

procedure TDBGridColumns.LoadFromStream(S: TStream);
var
  Wrapper: TColumnsWrapper;
begin
  Wrapper := TColumnsWrapper.Create(nil);
  try
    Wrapper.Columns := FGrid.CreateColumns;
    S.ReadComponent(Wrapper);
    Assign(Wrapper.Columns);
  finally
    Wrapper.Columns.Free;
    Wrapper.Free;
  end;
end;

procedure TDBGridColumns.RestoreDefaults;
var
  I: Integer;
begin
  BeginUpdate;
  try
    for I := 0 to Count-1 do
      Items[I].RestoreDefaults;
  finally
    EndUpdate;
  end;
end;

procedure TDBGridColumns.RebuildColumns;

  procedure AddFields(Fields: TFields; Depth: Integer);
  var
    I: Integer;
  begin
    Inc(Depth);
    for I := 0 to Fields.Count-1 do
    begin
      Add.FieldName := Fields[I].FullName;
      if Fields[I].DataType in [ftADT, ftArray] then
        AddFields((Fields[I] as TObjectField).Fields, Depth);
    end;
  end;

begin
  if Assigned(FGrid) and Assigned(FGrid.DataSource) and
    Assigned(FGrid.Datasource.Dataset) then
  begin
    FGrid.BeginLayout;
    try
      Clear;
      AddFields(FGrid.Datasource.Dataset.Fields, 0);
    finally
      FGrid.EndLayout;
    end
  end
  else
    Clear;
end;

procedure TDBGridColumns.SaveToFile(const Filename: string);
var
  S: TStream;
begin
  S := TFileStream.Create(Filename, fmCreate);
  try
    SaveToStream(S);
  finally
    S.Free;
  end;
end;

procedure TDBGridColumns.SaveToStream(S: TStream);
var
  Wrapper: TColumnsWrapper;
begin
  Wrapper := TColumnsWrapper.Create(nil);
  try
    Wrapper.Columns := Self;
    S.WriteComponent(Wrapper);
  finally
    Wrapper.Free;
  end;
end;

procedure TDBGridColumns.SetColumn(Index: Integer; Value: TColumn);
begin
  Items[Index].Assign(Value);
end;

procedure TDBGridColumns.SetState(NewState: TDBGridColumnsState);
begin
  if NewState = State then Exit;
  if NewState = csDefault then
    Clear
  else
    RebuildColumns;
end;

procedure TDBGridColumns.Update(Item: TCollectionItem);
var
  Raw: Integer;
begin
  if (Grid = nil) or (csLoading in Grid.ComponentState) then Exit;
  if (Item = nil) then with Grid do
  begin
    if FLayoutLock = 0 then
    begin
      LayoutChanged;
      ColWidthsChanged;
      UpdateColWidths(-1, True)
    end;
  end
  else begin
    Raw := FGrid.DataToRawColumn(Item.Index);
    Grid.InvalidateCol(Raw);
    if TColumn(Item).Resize then
      Grid.FSizingIndex := Raw
    else
      Grid.FSizingIndex := -1;
    Grid.ColWidths[Raw] := TColumn(Item).Width;
  end;
end;

function TDBGridColumns.InternalAdd: TColumn;
begin
  Result := Add;
  Result.IsStored := False;
end;

function TDBGridColumns.GetState: TDBGridColumnsState;
begin
  Result := TDBGridColumnsState((Count > 0) and Items[0].IsStored);
end;

{ TBookmarkList }

constructor TBookmarkList.Create(AGrid: TDCCustomDBGrid);
begin
  inherited Create;
  FList := TStringList.Create;
  FList.OnChange := StringsChanged;
  FGrid := AGrid;
end;

destructor TBookmarkList.Destroy;
begin
  Clear;
  FreeAndNil(FList);
  inherited Destroy;
end;

procedure TBookmarkList.Clear;
begin
  if FList.Count = 0 then Exit;
  FList.Clear;
  FGrid.FSelecting := False;
  FGrid.Invalidate;
end;

function TBookmarkList.Compare(const Item1, Item2: TBookmarkStr): Integer;
begin
  with FGrid.Datalink.Datasource.Dataset do
    Result := CompareBookmarks(TBookmark(Item1), TBookmark(Item2));
end;

function TBookmarkList.CurrentRow: TBookmarkStr;
begin
  if not FLinkActive then RaiseGridError(sDataSetClosed);
  Result := FGrid.Datalink.Datasource.Dataset.Bookmark;
end;

function TBookmarkList.GetCurrentRowSelected: Boolean;
var
  Index: Integer;
begin
  Result := Find(CurrentRow, Index);
end;

function TBookmarkList.Find(const Item: TBookmarkStr; var Index: Integer): Boolean;
var
  L, H, I, C: Integer;
begin
  if (Item = FCache) and (FCacheIndex >= 0) then
  begin
    Index := FCacheIndex;
    Result := FCacheFind;
    Exit;
  end;
  Result := False;
  L := 0;
  H := FList.Count - 1;
{
  while L <= H do
  begin
    I := (L + H) shr 1;
    C := Compare(FList[I], Item);
    if C < 0 then L := I + 1 else
    begin
      H := I - 1;
      if C = 0 then
      begin
        Result := True;
        L := I;
      end;
    end;
  end;
}
  for I := 0 to H do
  begin
    C := Compare(FList[I], Item);
    if C = 0 then
    begin
      Result := True;
      L := I;
      Break;
    end;
  end;
  Index := L;
  FCache := Item;
  FCacheIndex := Index;
  FCacheFind := Result;
end;

function TBookmarkList.GetCount: Integer;
begin
  Result := FList.Count;
end;

function TBookmarkList.GetItem(Index: Integer): TBookmarkStr;
begin
  Result := FList[Index];
end;

function TBookmarkList.IndexOf(const Item: TBookmarkStr): Integer;
begin
  if not Find(Item, Result) then
    Result := -1;
end;

procedure TBookmarkList.LinkActive(Value: Boolean);
begin
  Clear;
  FLinkActive := Value;
end;

procedure TBookmarkList.Delete;
var
  I: Integer;
begin
  with FGrid.Datalink.Datasource.Dataset do
  begin
    DisableControls;
    try
      for I := FList.Count-1 downto 0 do
      begin
        Bookmark := FList[I];
        Delete;
        FList.Delete(I);
      end;
    finally
      EnableControls;
    end;
  end;
end;

function TBookmarkList.Refresh: Boolean;
var
  I: Integer;
  Valid: boolean;
begin
  Result := False;
  if FGrid.DataLink.Dataset = nil then Exit;

  with FGrid.DataLink.Dataset do
  try
    CheckBrowseMode;
    for I := FList.Count - 1 downto 0 do
    begin
      try
        Valid := BookmarkValid(TBookmark(FList[I]));
      except
        Valid := False;
      end;
      if not Valid then
      begin
        Result := True;
        FList.Delete(I);
      end;
    end;  
  finally
    UpdateCursorPos;
    if Result then FGrid.Invalidate;
  end;
end;

procedure TBookmarkList.SetCurrentRowSelected(Value: Boolean);
var
  Index: Integer;
  Current: TBookmarkStr;
  R: TRect;
begin
  Current := CurrentRow;
  if (Length(Current) = 0) or (Find(Current, Index) = Value) then Exit;
  if Value then
  begin
    FList.Insert(Index, Current);
  end
  else
    FList.Delete(Index);
  with FGrid, FDatalink do
  begin
    if (DataSet <> nil) and DataSet.ControlsDisabled then Exit;
    R := BoxRectEx(0 , Row , ColCount-1, Row );
    ValidateRect(Handle, @R);
    InvalidateRect(Handle, @R, False);
  end;
end;

procedure TBookmarkList.StringsChanged(Sender: TObject);
begin
  FCache := '';
  FCacheIndex := -1;
  FGrid.BookmarksChanged;
end;

procedure TBookmarkList.Load(List: TStringList);
begin
  FList.Assign(List);
  InvalidateRect(FGrid.Handle, nil, False);
end;

procedure TBookmarkList.Save(List: TStringList);
 var
  I: Integer;
begin
  List.BeginUpdate;
  try
    List.Clear;
    for I := 0 to FList.Count - 1 do
      List.Add(FList.Strings[I])
  finally
    List.EndUpdate;
  end;
end;

procedure TBookmarkList.SelectAll;
 var
  AList: TStringList;
begin
  if (FGrid.DataLink.DataSet <> nil) and FGrid.DataLink.Active then
    with FGrid.DataLink.DataSet do
    begin
      FGrid.SavePosition;
      AList := TStringList.Create;
      DisableControls;
      try
        First;
        while not Eof do
        begin
          AList.Add(CurrentRow);
          Next;
        end;
        Load(AList);
      finally
        AList.Free;
        FGrid.RestPosition;
        EnableControls;
      end;
    end;
end;

{ TDCCustomDBGrid }

procedure UsesBitmap;
begin
  if UserCount = 0 then
  begin
    DrawBitmap := TBitmap.Create;
    TempBitmap := TBitmap.Create;
  end;
  Inc(UserCount);
end;

procedure ReleaseBitmap;
begin
  Dec(UserCount);
  if UserCount = 0 then
  begin
    DrawBitmap.Free;
    TempBitmap.Free;
  end;
end;

procedure WriteText(ACanvas: TCanvas; ARect: TRect; DX, DY: Integer;
  const Text: string; Alignment: TAlignment; ARightToLeft: Boolean; AWordBreak: boolean);
const
  AlignFlags : array [TAlignment] of Integer =
    ( DT_LEFT or DT_EXPANDTABS or DT_NOPREFIX,
      DT_RIGHT or DT_EXPANDTABS or DT_NOPREFIX,
      DT_CENTER or DT_EXPANDTABS or DT_NOPREFIX );
  RTL: array [Boolean] of Integer = (0, DT_RTLREADING);
var
  B, R: TRect;
  Hold, Left: Integer;
  I: TColorRef;
begin
  I := ColorToRGB(ACanvas.Brush.Color);
  if (GetNearestColor(ACanvas.Handle, I) = I) and not AWordBreak then
  begin                       { Use ExtTextOut for solid colors }
    { In BiDi, because we changed the window origin, the text that does not
      change alignment, actually gets its alignment changed. }
    if (ACanvas.CanvasOrientation = coRightToLeft) and (not ARightToLeft) then
      ChangeBiDiModeAlignment(Alignment);
    case Alignment of
      taLeftJustify:
        Left := ARect.Left + DX;
      taRightJustify:
        Left := ARect.Right - ACanvas.TextWidth(Text) - 3;
    else { taCenter }
      Left := ARect.Left + (ARect.Right - ARect.Left) shr 1
        - (ACanvas.TextWidth(Text) shr 1);
    end;
    ACanvas.TextRect(ARect, Left, ARect.Top + DY, Text);
  end
  else
  begin                  { Use FillRect and Drawtext for dithered colors }
    DrawBitmap.Canvas.Lock;
    try
      with DrawBitmap, ARect do { Use offscreen bitmap to eliminate flicker and }
      begin                     { brush origin tics in painting / scrolling.    }
        Width  := _intMax(Width, Right - Left);
        Height := _intMax(Height, Bottom - Top);
        R := Rect(DX, DY, Right - Left - 1, Bottom - Top - 1);
        B := Rect(0, 0, Right - Left, Bottom - Top);
      end;
      with DrawBitmap.Canvas do
      begin
        Font := ACanvas.Font;
        Font.Color := ACanvas.Font.Color;
        Brush := ACanvas.Brush;
        Brush.Style := bsSolid;
        FillRect(B);
        SetBkMode(Handle, TRANSPARENT);
        if (ACanvas.CanvasOrientation = coRightToLeft) then
          ChangeBiDiModeAlignment(Alignment);
        if AWordBreak then
          DrawText(Handle, PChar(Text), Length(Text), R,
            AlignFlags[Alignment] or RTL[ARightToLeft] or DT_WORDBREAK)
        else
          DrawText(Handle, PChar(Text), Length(Text), R,
            AlignFlags[Alignment] or RTL[ARightToLeft])
      end;
      if (ACanvas.CanvasOrientation = coRightToLeft) then
      begin
        Hold := ARect.Left;
        ARect.Left := ARect.Right;
        ARect.Right := Hold;
      end;
      ACanvas.CopyRect(ARect, DrawBitmap.Canvas, B);
    finally
      DrawBitmap.Canvas.Unlock;
    end;
  end;
end;

constructor TDCCustomDBGrid.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  inherited DefaultDrawing := False;

  FTitleOffset := 1;
  FIndicatorOffset := 1;
  FUpdateFields := True;
  FOptions := [dgEditing, dgTitles, dgIndicator, dgColumnResize,
    dgColLines, dgRowLines, dgTabs, dgConfirmDelete, dgCancelOnExit];
  FOptionsEx := [dgeMarkerMenu, dgeShadowSelection, dgeDrawMemoAsText,
    dgeIndicatorMenu {$IFNDEF DELPHI_V5UP}, dgeInsertSelect {$ENDIF},
    dgeShowDragImage];
  if SysLocale.PriLangID = LANG_KOREAN then Include(FOptions, dgAlwaysShowEditor);
  DesignOptionsBoost := [goColSizing];
  VirtualView := True;
  UsesBitmap;
  ScrollBars := ssHorizontal;
  inherited Options := [goFixedHorzLine, goFixedVertLine, goHorzLine,
    goVertLine, goColSizing, goColMoving, goTabs, goEditing];
  FColumns := CreateColumns;
  inherited RowCount := 2;
  inherited ColCount := 2;
  FDataLink := TGridDataLink.Create(Self);
  Color := clWindow;
  ParentColor := False;
  FTitleFont := TFont.Create;
  FTitleFont.OnChange := TitleFontChanged;
  FSaveCellExtents := False;
  FDefaultDrawing := True;
  FBookmarks := TBookmarkList.Create(Self);
  ClickedCol := -1;
  FCurrentCol := -1;
  FMousePoint := Point(-1,-1);
  FFrozenCols := 0;
  FClipDown   := False;
  FFirstGridCell := 0;
  FDBObject := TDCDBObject.Create;
  FColumnFooter := TColumnFooter.Create(Footers);

  FImageChangeLink :=  TChangeLink.Create;
  FImageChangeLink.OnChange := ImageListChange;

  HideEditor;
  FDataVisible := True;
  FColumnCell  := -1;
  FSizingIndex := -1;

  FFlags := 0;
  FLineColor := clSilver;

  FViewDataLink := TDataLink.Create;
end;

destructor TDCCustomDBGrid.Destroy;
begin
  Destroying;
  if Assigned(FClipPopup) then FClipPopup.Free;

  if Assigned(FCurrentPos[1].Bookmark) then FreeMem(FCurrentPos[1].Bookmark);
  if Assigned(FCurrentPos[2].Bookmark) then FreeMem(FCurrentPos[2].Bookmark);

  FImageChangeLink.Free;

  FreeAndNil(FColumns);
  FreeAndNil(FDataLink);
  FreeAndNil(FTitleFont);
  FreeAndNil(FBookmarks);
  FreeAndNil(FDBObject);
  FreeAndNil(FColumnFooter);

  ReleaseBitmap;
  inherited Destroy;
end;

function TDCCustomDBGrid.RawToDataColumn(ACol: Integer): Integer;
begin
  Result := ACol - FIndicatorOffset;
end;

function TDCCustomDBGrid.DataToRawColumn(ACol: Integer): Integer;
begin
  Result := ACol + FIndicatorOffset;
end;

function TDCCustomDBGrid.AcquireLayoutLock: Boolean;
begin
  Result := (FUpdateLock = 0) and (FLayoutLock = 0);
  if Result then BeginLayout;
end;

procedure TDCCustomDBGrid.BeginLayout;
begin
  BeginUpdate;
  if (FLayoutLock = 0) and Assigned(Columns) then Columns.BeginUpdate;
  Inc(FLayoutLock);
end;

procedure TDCCustomDBGrid.BeginUpdate;
begin
  Inc(FUpdateLock);
end;

procedure TDCCustomDBGrid.CancelLayout;
begin
  if FLayoutLock > 0 then
  begin
    if FLayoutLock = 1 then Columns.EndUpdate;
    Dec(FLayoutLock);
    EndUpdate;
  end;
end;

function TDCCustomDBGrid.CanEditAcceptKey(Key: Char): Boolean;
begin
  with Columns[SelectedIndex] do
    Result := FDatalink.Active and Assigned(Field) and Field.IsValidChar(Key);
end;

function TDCCustomDBGrid.CanEditModify: Boolean;
begin
  Result := False;
  if not ReadOnly and FDatalink.Active and not FDatalink.Readonly then
  with Columns[SelectedIndex] do
    if not ReadOnly and Assigned(Field) and Field.CanModify
      and (not (Field.DataType in ftNonTextTypes) or Assigned(Field.OnSetText)) then
    begin
      with FDatalink do
      begin
//        if Eof and Bof then DataSet.Append;
        Edit;
        Result := Editing;
        if Result then FDatalink.Modified;
      end;
    end;
end;

function TDCCustomDBGrid.CanEditShow: Boolean;
begin
  Result := inherited CanEditShow;
end;

procedure TDCCustomDBGrid.CellClick(Column: TColumn);
begin
  if Assigned(FOnCellClick) then FOnCellClick(Column);
end;

procedure TDCCustomDBGrid.ColEnter;
begin
  UpdateIme;
  if Assigned(FOnColEnter) then FOnColEnter(Self);
end;

procedure TDCCustomDBGrid.ColExit;
begin
  if Assigned(FOnColExit) then FOnColExit(Self);
end;

procedure TDCCustomDBGrid.ColumnMoved(FromIndex, ToIndex: Longint);
begin
  inherited;
  FromIndex := RawToDataColumn(FromIndex);
  ToIndex := RawToDataColumn(ToIndex);
  Columns[FromIndex].Index := ToIndex;
  if Assigned(FOnColumnMoved) then FOnColumnMoved(Self, FromIndex, ToIndex);
end;

procedure TDCCustomDBGrid.ColWidthsChanged;
 var
  I: Integer;
begin
  if (FColumns.UpdateCount = 0) and not UpdateLocked and
    (FDatalink.Active or (FColumns.State = csCustomized)) and
    AcquireLayoutLock then
  try
    if not(dgAutoSize in Options) then inherited ColWidthsChanged;
    for I := FIndicatorOffset to ColCount - 1 do
      FColumns[I - FIndicatorOffset].Width := ColWidths[I];
  finally
    EndLayout;
  end;
end;

function TDCCustomDBGrid.CreateColumns: TDBGridColumns;
begin
  Result := TDBGridColumns.Create(Self, TColumn);
end;

function TDCCustomDBGrid.CreateEditor: TInplaceEdit;
begin
  Result := TDBGridInplaceEdit.Create(Self);
end;

procedure TDCCustomDBGrid.CreateWnd;
begin
  begin
    BeginUpdate;   { prevent updates in WMSize message that follows WMCreate }
    try
      inherited CreateWnd;
    finally
      EndUpdate;
    end;
    if HandleAllocated then
    begin
      UpdateRowCount;
      UpdateActive;
      UpdateScrollBar;
    end;
    FOriginalImeName := ImeName;
    FOriginalImeMode := ImeMode;

    if not Assigned(FClipPopup) then FClipPopup := TDBClipPopup.Create(Self);
  end;
end;

procedure TDCCustomDBGrid.DataChanged;
begin
  if not HandleAllocated then Exit;
  UpdateRowCount;
  UpdateScrollBar;
  UpdateActive;
  InvalidateEditor;
  invalidate;
  SelectedRows.StringsChanged(nil);
end;

procedure TDCCustomDBGrid.DefaultHandler(var Msg);
var
  P: TPopupMenu;
  Cell: TGridCoord;
begin
  inherited DefaultHandler(Msg);
  if TMessage(Msg).Msg = wm_RButtonUp then
    with TWMRButtonUp(Msg) do
    begin
      Cell := MouseCoord(XPos, YPos);
      if (Cell.X < FIndicatorOffset) or (Cell.Y < 0) then Exit;
      P := Columns[RawToDataColumn(Cell.X)].PopupMenu;
      if (P <> nil) and P.AutoPopup then
      begin
        SendCancelMode(nil);
        P.PopupComponent := Self;
        with ClientToScreen(SmallPointToPoint(Pos)) do
          P.Popup(X, Y);
        Result := 1;
      end;
    end;
end;

procedure TDCCustomDBGrid.DeferLayout;
var
  M: TMsg;
begin
  if HandleAllocated and
    not PeekMessage(M, Handle, CM_DEFERLAYOUT, CM_DEFERLAYOUT, pm_NoRemove) then
    PostMessage(Handle, CM_DEFERLAYOUT, 0, 0);
  CancelLayout;
end;

procedure TDCCustomDBGrid.DefineFieldMap;
var
  I: Integer;
begin
  if FColumns.State = csCustomized then
  begin   { Build the column/field map from the column attributes }
    DataLink.SparseMap := True;
    for I := 0 to FColumns.Count-1 do
      FDataLink.AddMapping(FColumns[I].FieldName);
  end
  else   { Build the column/field map from the field list order }
  begin
    FDataLink.SparseMap := False;
    with Datalink.Dataset do
      for I := 0 to FieldList.Count - 1 do
        with FieldList[I] do if Visible then Datalink.AddMapping(FullName);
  end;
end;

function TDCCustomDBGrid.UseRightToLeftAlignmentForField(const AField: TField;
  Alignment: TAlignment): Boolean;
begin
  Result := False;
  if IsRightToLeft then
    Result := OkToChangeFieldAlignment(AField, Alignment);
end;

procedure TDCCustomDBGrid.DefaultDrawDataCell(const Rect: TRect; Field: TField;
  State: TGridDrawState);
var
  Alignment: TAlignment;
  Value: string;
  AWordBreak: boolean;
begin
  Alignment := taLeftJustify;
  Value := '';
  AWordBreak := False;
  if Assigned(Field) then
  begin
    Alignment := Field.Alignment;
    if Assigned(FDrawColumn) then
    begin
      Value := GetDataValue(FDrawColumn);
      AWordBreak := FDrawColumn.WordBreak;
    end
    else
      Value := Field.DisplayText;
  end;
  WriteText(Canvas, Rect, 2, 2, Value, Alignment,
    UseRightToLeftAlignmentForField(Field, Alignment), AWordBreak);
end;

procedure TDCCustomDBGrid.DefaultDrawColumnCell(const Rect: TRect;
  DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
  Value: string;
begin
  Value := GetDataValue(Column);
  with Column do
    WriteText(Canvas, Rect, 2, 2, Value, Alignment,
      UseRightToLeftAlignmentForField(Field, Alignment), WordBreak);
end;

procedure TDCCustomDBGrid.ReadColumns(Reader: TReader);
begin
  Columns.Clear;
  Reader.ReadValue;
  Reader.ReadCollection(Columns);
end;

procedure TDCCustomDBGrid.WriteColumns(Writer: TWriter);
begin
  Writer.WriteCollection(Columns);
end;

procedure TDCCustomDBGrid.DefineProperties(Filer: TFiler);
begin
  Filer.DefineProperty('Columns', ReadColumns, WriteColumns,
    ((Columns.State = csCustomized) and (Filer.Ancestor = nil)) or
    ((Filer.Ancestor <> nil) and
     ((Columns.State <> TDCCustomDBGrid(Filer.Ancestor).Columns.State) or
  {$IFDEF DELPHI_V6}
    (not CollectionsEqual(Columns, TDCCustomDBGrid(Filer.Ancestor).Columns,
      Self, TDCCustomDBGrid(Filer.Ancestor)))
  {$ELSE}
    (not CollectionsEqual(Columns, TDCCustomDBGrid(Filer.Ancestor).Columns))
  {$ENDIF}
     )));
end;

function TDCCustomDBGrid.ColumnAtDepth(Col: TColumn; ADepth: Integer): TColumn;
begin
  Result := Col;
  while (Result <> nil) and (Result.Depth > ADepth) do
    Result := Result.ParentColumn;
end;

function TDCCustomDBGrid.CalcTitleRect(Col: TColumn; ARow: Integer;
  var MasterCol: TColumn): TRect;
var
  I,J: Integer;
  InBiDiMode: Boolean;
  DrawInfo: TGridDrawInfo;
begin
  MasterCol := ColumnAtDepth(Col, ARow);
  if MasterCol = nil then Exit;

  I := DataToRawColumn(MasterCol.Index);
  if (I >= LeftCol) or (I < FixedCols) then
    J := MasterCol.Depth
  else
  begin
    I := LeftCol;
    if Col.Depth > ARow then
      J := ARow
    else
      J := Col.Depth;
  end;

  Result := CellRect(I, J);

  InBiDiMode := UseRightToLeftAlignment and
                (Canvas.CanvasOrientation = coLeftToRight);

  for I := Col.Index to Columns.Count-1 do
  begin
    if ColumnAtDepth(Columns[I], ARow) <> MasterCol then Break;
    if not InBiDiMode then
    begin
      J := CellRect(DataToRawColumn(I), ARow).Right;
      if J = 0 then Break;
      Result.Right := _intMax(Result.Right, J);
    end
    else
    begin
      J := CellRect(DataToRawColumn(I), ARow).Left;
      if J >= ClientWidth then Break;
      Result.Left := J;
    end;
  end;
  J := Col.Depth;
  if (J <= ARow) and (J < FixedRows-1) then
  begin
    CalcFixedInfo(DrawInfo);
    Result.Bottom := DrawInfo.Vert.FixedBoundary - DrawInfo.Vert.EffectiveLineWidth;
  end;
end;

function TDCCustomDBGrid.DrawTitleCell(ACanvas: TCanvas; ACol,
  ARow: Integer; ARect: TRect; BorderState: TDrawBorerState;
  AFillRect, ADraw: boolean): TPoint;
  const
    ScrollArrows: array [Boolean, Boolean] of Integer =
      ((DFCS_SCROLLRIGHT, DFCS_SCROLLLEFT), (DFCS_SCROLLLEFT, DFCS_SCROLLRIGHT));
    ColumnIndexStyle : array [TColumnIndexStyle] of Integer =
     (nbmIndexNone,nbmIndexAsc,nbmIndexDesc);
    AlignFlags : array [TAlignment] of Integer =
      ( DT_LEFT   or DT_NOPREFIX,
        DT_RIGHT  or DT_NOPREFIX,
        DT_CENTER or DT_NOPREFIX );

  var
    Column, MasterCol: TColumn;
    TextRect, ButtonRect, DrawRect: TRect;
    I: Integer;
    InBiDiMode: Boolean;
    Flags: DWORD;

  function DoPaint(Canvas: TCanvas; DrawRect: TRect): TPoint;
    var
     P: TPoint;
     R: TRect;
  begin
    TextRect := DrawRect;

    if not((BorderState = dsDown) and (GetBorderStyle = ebsNone)) then
    begin
      Canvas.Font := MasterCol.Title.Font;
      Canvas.Font.Color := ColorToRGB(MasterCol.Title.Font.Color);
      Canvas.Brush.Color := MasterCol.Title.Color;
    end
    else begin
      Canvas.Font := Column.Title.Font;
      Canvas.Font.Color := ColorToRGB(clHighlightText);
      Canvas.Brush.Color := clXPDropDown;
    end;

    I := GetSystemMetrics(SM_CXHSCROLL);
    if ((DrawRect.Right - DrawRect.Left) > I) and MasterCol.Expandable and ADraw then
    begin
      Dec(TextRect.Right, I);
      ButtonRect := DrawRect;
      ButtonRect.Left := TextRect.Right;
      I := SaveDC(Canvas.Handle);
      try
        if AFillRect then Canvas.FillRect(ButtonRect);
        InflateRect(ButtonRect, -1, -1);
        IntersectClipRect(Canvas.Handle, ButtonRect.Left,
          ButtonRect.Top, ButtonRect.Right, ButtonRect.Bottom);
        InflateRect(ButtonRect, 1, 1);
        { DrawFrameControl doesn't draw properly when orienatation has changed.
          It draws as ExtTextOut does. }
        InBiDiMode := Canvas.CanvasOrientation = coRightToLeft;
        if InBiDiMode then { stretch the arrows box }
          Inc(ButtonRect.Right, GetSystemMetrics(SM_CXHSCROLL) + 4);
        DrawFrameControl(Canvas.Handle, ButtonRect, DFC_SCROLL,
          ScrollArrows[InBiDiMode, MasterCol.Expanded] or DFCS_FLAT);
      finally
        RestoreDC(Canvas.Handle, I);
      end;
    end;

    if AFillRect then FillRect(Canvas.Handle, TextRect, Canvas.Brush.Handle);

    case MasterCol.VertAlignment of
      vaTop:
        ;
      vaCenter:
        TextRect.Top := _intMax(0,
          (TextRect.Top + TextRect.Bottom - MasterCol.Size.Y) div 2 - 1);
      vaBottom:
        TextRect.Top := _intMax(0, TextRect.Bottom - MasterCol.Size.Y - 2);
    end;

    if BorderState = dsDown then
    begin
      OffsetRect(TextRect, 3, 0);
      TextRect.Top    := TextRect.Top  + 1;
    end
    else
      OffsetRect(TextRect, 2, 0);

    if (MasterCol.Grid.Images <> nil) and (MasterCol.ItemIndex <> -1) and
       ((TextRect.Right - TextRect.Left) > 0)
    then begin
      Column.Grid.Images.Draw(Canvas, TextRect.Left, TextRect.Top, Column.ItemIndex);
      TextRect.Left := TextRect.Left + Column.Grid.Images.Width+2;
    end;

    if TextRect.Left < TextRect.Right then
    begin
      SetTextColor(Canvas.Handle, Canvas.Font.Color);
      if not(gcWordBreak in Column.Options) then
      begin
        Flags := 0;
        case MasterCol.Title.Alignment of
          taLeftJustify:
            if ADraw then
              P := DrawHighLightText(Canvas, PChar(MasterCol.Title.Caption),
                TextRect, 1, DT_NOPREFIX or Flags)
            else
              P := DrawHighLightText(Canvas, PChar(MasterCol.Title.Caption),
                TextRect, 0, DT_NOPREFIX or Flags);
          taCenter, taRightJustify:
            begin
              if MasterCol.Indexed and (MasterCol.IndexStyle <> idxNone) then
                Dec(TextRect.Right, IndexTitleWidth + 2);
              P := DrawTitleRect(Canvas, TextRect, MasterCol.Title.Caption,
                MasterCol.Title.Alignment, ADraw, Flags);
            end;
        end;
      end
      else begin
        Flags := AlignFlags[MasterCol.Title.Alignment] or DT_WORDBREAK;
        R := Rect(0, 0, MaxInt, maxInt);

        DrawText(Canvas.Handle, PChar(MasterCol.Title.Caption), -1,
          R, Flags or DT_CALCRECT);
        P.X := R.Right;
        P.Y := R.Bottom;

        if AFillRect then
          DrawText(Canvas.Handle, PChar(MasterCol.Title.Caption), -1,
             TextRect, Flags);
      end;
      Result.Y := P.Y;
      Result.X := TextRect.Left - DrawRect.Left + P.X + 2;
      if MasterCol.Indexed and ((MasterCol.IndexStyle <> idxNone) and
        ((P.X + IndexTitleWidth) < (TextRect.Right - TextRect.Left)) or not ADraw)
      then begin
        if ADraw then begin
          if MasterCol.Title.Alignment = taCenter then
            P.X := (TextRect.Right + TextRect.Left - P.X) div 2 + P.X - 1;
          GDGetImages.Draw(Canvas, TextRect.Left + P.X, TextRect.Top,
            ColumnIndexStyle[Column.IndexStyle]);
        end;
        Inc(Result.X, IndexTitleWidth);
      end
      else
        Inc(Result.X, 2);
    end;
  end;

begin
  Column := Columns[ACol];
  MasterCol := ColumnAtDepth(Column, ARow);

  with ARect do
    if Right-Left = 0 then Exit;

  if MasterCol = nil then
  begin
    if AFillRect and ADraw then Canvas.FillRect(ARect);
    with ARect do Result := Point(Right-Left, Bottom-Top);
    Exit;
  end;

  if AFillRect and (ARect.Right  - ARect.Left > 0) and
    (ARect.Bottom - ARect.Top >0) then
  begin
    DrawBitmap.Width  := ARect.Right  - ARect.Left;
    DrawBitmap.Height := ARect.Bottom - ARect.Top;

    with DrawBitmap do
    begin
      DrawRect := Rect(0,0, Width, Height);
      Result := DoPaint(Canvas, DrawRect);
    end;
    if ADraw then ACanvas.Draw(ARect.Left, ARect.Top, DrawBitmap);
  end
  else
    Result := DoPaint(ACanvas, ARect);
end;

procedure TDCCustomDBGrid.DrawCell(ACol, ARow: Longint; ARect: TRect; AState: TGridDrawState);

var
  FrameOffs: Byte;
  BorderState, MenuState: TDrawBorerState;
  BorderStyle: TEdgeBorderStyle;
  TitleRect, PopupRect: TRect;
  MasterCol: TColumn;
  Indicators: TImageList;
  ColType: TFixedCol;
  RowType: TFixedRow;

  function RowIsMultiSelected: Boolean;
  var
    Index: Integer;
  begin
    Result := (dgMultiSelect in Options) and Datalink.Active and
      FBookmarks.Find(Datalink.Datasource.Dataset.Bookmark, Index);
  end;

var
  OldActive: Integer;
  Indicator: Integer;
  Highlight: Boolean;
  Value: string;
  MultiSelected, FrozenCol: Boolean;
  ALeft, ATop, BCol, BRow: Integer;
  BRect: TRect;

  function ColumnVisible(ACol: integer): boolean;
  begin
    Result := Columns[ACol].Visible and RectVisible(Canvas.Handle,
      CellRect(DataToRawColumn(ACol), ARow + FTitleOffset)) and
      not(EditorMode and (SelectedField <> nil) and (SelectedField.Index = ACol));
  end;

  function IsColFirstVisible(ACol: integer): boolean;
   var
    AFirst, l: Integer;
  begin
    AFirst := 0;
    while (AFirst < Columns.Count-1) and not ColumnVisible(AFirst) do
      Inc(AFirst);

    if Assigned(DataLink) and DataLink.Active and (dgMarker in Options) then
    begin
      if DataToRawColumn(ACol) < FixedCols then
        Result := ACol = AFirst
      else begin
        l := LeftCol;
        while (l < ColCount) and not ColumnVisible(RawToDataColumn(l)) do Inc(l);
        Result := DataToRawColumn(ACol) = l;
      end;
    end
    else
      Result := False
  end;

  procedure DrawMarker(BRect: TRect);
  begin
    Canvas.Brush.Color := FixedColor;
    Canvas.FillRect(BRect);
    if FBookMarks.CurrentRowSelected then
    begin
      Indicators.Draw(Canvas, BRect.Right - (MarkerWidth div 2)-4,
          (BRect.Top + BRect.Bottom - Indicators.Height) shr 1, nbmCheck);
    end;
    if BorderStyle <> ebsNone then
    begin
      if BorderStyle = ebsShadowFlat then
      begin
        InflateRect(BRect, 1, 1);
      end;
      DrawGridFrameBorder(Canvas, BRect, BorderStyle, dsUp, FixedColor);
    end;
  end;

  procedure DrawFixedBorder(ARect: TRect; Frame: boolean);
  begin
    if Frame then FrameRect(Canvas.Handle, ARect, Canvas.Brush.Handle);
  end;

  procedure DrawBorderEx(ARect: TRect; ABorderState: TDrawBorerState);
  begin
    if (dgRowLines in Options) or (BorderStyle <> ebsNone) then
    begin
      if (BorderStyle = ebsNone) then
      begin
        if [dgColLines, dgRowLines] * Options <> [dgRowLines] then
          InflateRect(ARect, 1, 1);
        DrawFixedBorder(ARect, True)
      end
      else begin
        InflateRect(ARect, 1, 1);
        DrawGridFrameBorder(Canvas, ARect, BorderStyle, ABorderState, FixedColor);
      end;
    end
  end;

  procedure DrawFixedCellFrame(AColType: TFixedCol; ImageIndex: integer);
   var
    B: TBitmap;
    BRect, CRect: TRect;
    BBrush: HBRUSH;
  begin
    if FClipDown and (FClipPopup.ColType = AColType) then
    begin
      case GridDrawing.ClipStyle of
        csSingleBorder:
          begin
            B := TBitmap.Create;
            try
              B.Width := Indicators.Width + 2;
              B.Height := Indicators.Height + 2;
              BRect := Rect(0, 0, B.Width, B.Height);

              FillRect(B.Canvas.Handle, BRect, Canvas.Brush.Handle);
              Indicators.Draw(B.Canvas, 1, 1, ImageIndex);
              AlphaBlend(B, nil, B, 170, B.Canvas.Pixels[0, 0],
                B.Canvas.Pixels[0, 0]);

              InflateRect(BRect, -1, -1);
              CRect := BRect;
              OffsetRect(CRect, ALeft - 1, ATop);

              Canvas.CopyRect(CRect, B.Canvas, BRect);
            finally
              B.Free;
            end;
            DrawBorderEx(ARect, dsDown);
         end;
       csFlatBorder:
         begin
           BRect := ARect;
           InflateRect(BRect, 1, 1);
           Dec(BRect.Right);
           with BRect do
             ExcludeClipRect(Canvas.Handle, Left, Bottom - 1, Right, Bottom);
           FrameRect(Canvas.Handle, BRect, Canvas.Brush.Handle);
           if not(dgRowLines in FOptions) then Dec(BRect.Right);
           InflateRect(BRect, 1, 1);
           BBrush := CreateSolidBrush(clDarkShadow);
           FrameRect(Canvas.Handle, BRect, BBrush);
           DeleteObject(BBrush);
           Indicators.Draw(Canvas, ALeft-1, ATop, ImageIndex);
         end;
      end;
    end
    else begin
      Indicators.Draw(Canvas, ALeft - 1, ATop, ImageIndex);
      DrawBorderEx(ARect, dsUp);
    end;
  end;

  function ExistVisibleColumns: boolean;
   var
    i: integer;
  begin
    Result := False;
    for i := 0 to Columns.Count - 1 do
    begin
      if ColumnVisible(i) then
      begin
        Result := True;
        Break;
      end;
    end;
  end;

begin
  if [csDestroying, csLoading] * ComponentState  <> [] then
  begin
    Canvas.Brush.Color := Color;
    Canvas.FillRect(ARect);
    Exit;
  end;
  Indicators := GDGetImages;

  BorderStyle := GetBorderStyle;

  if (ClickedCol <> -1) and (ACol = ClickedCol) then
  begin
    if (ClickedType = ctTitleClick) then
    begin
      BorderState := dsDown;
      MenuState   := dsUp;
    end
    else begin
      BorderState := dsUp;
      MenuState   := dsDown;
    end
  end
  else begin
    BorderState := dsUp;
    MenuState   := dsUp;
  end;

  ColType := GetFixedColType(ACol, 0);
  RowType := GetFixedRowType(ARow, 0);

  Dec(ARow, FTitleOffset);
  Dec(ACol, FIndicatorOffset);

  if (gdFixed in AState) and (RowType = drGrid) and (ColType = dcColumn) then
    FrozenCol := True
  else
    FrozenCol := False;

  if (gdFixed in AState) and ([dgRowLines, dgColLines] * Options =
    [dgRowLines, dgColLines]) and not FrozenCol
  then begin
    InflateRect(ARect, -1, -1);
    FrameOffs := 1;
  end
  else
    FrameOffs := 2;

  if (gdFixed in AState) and (ACol < 0) then
  begin
    if (dgMarker in Options) and (ColType = dcMarker) and (RowType = drGrid) and
      Assigned(DataLink) and DataLink.Active then
    begin
      if not ExistVisibleColumns then
      begin
        OldActive := FDataLink.ActiveRecord;
        try
          FDataLink.ActiveRecord := ARow;
          InflateRect(ARect, 1, 1);
          DrawMarker(ARect);
        finally
          FDataLink.ActiveRecord := OldActive;
        end;
      end;
      Exit;
    end;
    if RowType <> drHeader then
    begin
      Canvas.Brush.Color := FixedColor;
      Canvas.FillRect(ARect);
      if ColType = dcIndicator then
      begin
        if Assigned(DataLink) and DataLink.Active  then
        begin
          MultiSelected := False;
          if ARow >= 0 then
          begin
            OldActive := FDataLink.ActiveRecord;
            try
              FDataLink.ActiveRecord := ARow;
              MultiSelected := RowIsMultiselected;
            finally
              FDatalink.ActiveRecord := OldActive;
            end;
          end;
          if (ARow = FDataLink.ActiveRecord) or MultiSelected
          then begin
            Indicator := nbmArrow;
            if FDataLink.DataSet <> nil then
              case FDataLink.DataSet.State of
                dsEdit  : Indicator := nbmEdit;
                dsInsert: Indicator := nbmInsert;
                dsBrowse:
                  if MultiSelected then
                    if (ARow <> FDatalink.ActiveRecord) then
                      Indicator := nbmMultiDot
                    else
                      Indicator := nbmMultiArrow;  // multiselected and current row
              end;
            ALeft := ARect.Right - Indicators.Width - FrameOffs;
            if Canvas.CanvasOrientation = coRightToLeft then Inc(ALeft);
            Indicators.Draw(Canvas, ALeft,
              (ARect.Top + ARect.Bottom - Indicators.Height) shr 1, Indicator,
                True);
          end;
        end;
      end;
      if (ARow < 0) and (dgeIndicatorMenu in OptionsEx) and
        (ColType = dcIndicator) then
      begin
         ALeft := (ARect.Right + ARect.Left - Indicators.Width -
           FrameOffs) shr 1 + 1;
         ATop  := (ARect.Top + ARect.Bottom - Indicators.Height) shr 1;
         DrawFixedCellFrame(dcIndicator, nbmMain);
         Exit;
      end;
      if (ARow < 0) and (dgeMarkerMenu in OptionsEx) and
        (ColType = dcMarker) then
      begin
         ALeft := (ARect.Right + ARect.Left - Indicators.Width -
           FrameOffs) shr 1 + 1;
         ATop  := (ARect.Top + ARect.Bottom - Indicators.Height) shr 1 - 1;
         DrawFixedCellFrame(dcMarker, nbmCheckHrd);
         Exit;
      end;
    end
    else begin
      {Draw header}
      InflateRect(ARect, 1, 1);
      Canvas.FillRect(ARect);
      Exit;
    end;
  end
  else with Canvas do
  begin
    FDrawColumn := Columns[ACol];
    if not (gdFixed in AState) or FrozenCol then
    begin
      Font := FDrawColumn.Font;
      Brush.Color := FDrawColumn.Color;
    end;
    if (ARow < 0) then
    begin
      if RowType = drTitle then
      begin
        if not FDrawColumn.Showing then Exit;
        if gcPopupMenu in FDrawColumn.Options then
        begin
          if GetTitleMenuRect(ARect, PopupRect) then
          begin
            ARect.Right := PopupRect.Left - 1;
            InflateRect(PopupRect, 1, 1);
            DrawTitlePopup(Canvas, PopupRect, MenuState, FDrawColumn);
          end;
        end;
        TitleRect := CalcTitleRect(FDrawColumn, ARow + FTitleOffset, MasterCol);
        TitleRect.Right := ARect.Right;
        DrawTitleCell(Canvas, ACol, ARow + FTitleOffset, TitleRect,
          BorderState, True, True);
      end;
      if RowType = drHeader then
      begin
        {Draw Header}
        InflateRect(ARect, 1, 1);
        Brush.Color := FixedColor;
        Canvas.FillRect(ARect);
        Exit;
      end;
    end
    else if (FDataLink = nil) or not FDataLink.Active then
    begin
      if not FDrawColumn.Showing then Exit;
      DrawFlatLines(ARect);
      FillRect(ARect);
    end
    else
    begin
      OldActive := FDataLink.ActiveRecord;
      try
        FDataLink.ActiveRecord := ARow;
        if IsColFirstVisible(ACol) then
        begin
          BCol := GetCellByType(dcMarker);
          BRow := ARow + FTitleOffset;
          BRect := BoxRect(BCol, BRow, BCol, BRow);
          BRect.Bottom := BRect.Top + RowHeights[BRow]; 
          DrawMarker(BRect);
        end;

        if not FDrawColumn.Showing then Exit;

        if (gdFixed in AState) and not FrozenCol then
        begin
           Font := FDrawColumn.Title.Font;
           Brush.Color := FDrawColumn.Title.Color;
        end
        else
        begin
          Font := FDrawColumn.Font;
          Brush.Color := FDrawColumn.Color;
        end;

        if ARow < FDataLink.RecordCount then
          Value := GetDataValue(FDrawColumn)
        else
          Value := '';

        if FrozenCol and
          (ARow = RawToDataRow(Row)) and (dgRowSelect in Options) then
          AState := AState + [gdSelected];

        Highlight := HighlightCell(ACol, ARow, Value, AState);

        if (dgHighlightRow in Options) and
          ((dgAlwaysShowSelection in Options) or IsActiveControl) then
        begin
          if OldActive = ARow then
          begin
            if ACol >= 0 then
            begin
              if not IsActiveControl and (dgeShadowSelection in OptionsEx) then
                Brush.Color := clShadowed
              else begin
                Brush.Color := clHighlight;
                Font.Color := clHighlightText;
              end;
            end;
            AState := AState + [gdSelected];
          end;
          if Highlight then
          begin
            if not IsActiveControl and (dgeShadowSelection in OptionsEx) then
              Brush.Color := clShadowed
            else begin
              Brush.Color := clRowHighlight;
              Font.Color  := clTextHighlight;
            end;
            AState := AState + [gdFocused];
          end;
        end
        else if Highlight then
        begin
          if IsActiveControl then
          begin
            Brush.Color := clHighlight;
            Font.Color := clHighlightText;
          end
          else begin
            if dgAlwaysShowSelection in Options then
            begin
              if dgeShadowSelection in OptionsEx then
                Brush.Color := clShadowed
              else begin
                Brush.Color := clHighlight;
                Font.Color := clHighlightText;
              end;
           end
          end;
          if not(dgMultiSelect in Options) then AState := AState + [gdSelected];
        end;

        if not Enabled then Font.Color := clGrayText;

        if not Highlight and (dgAdvancedSelect in Options) and
           SelectedArea.CellSelected(ACol, ARow) then
        begin
          Brush.Color := clXPSelectedLight;
        end;

        DrawFlatLines(ARect);
        if FDefaultDrawing and (ARect.Right - ARect.Left > 0) then
        begin
           WriteText(Canvas, ARect, 2, 2, Value, FDrawColumn.Alignment,
             UseRightToLeftAlignmentForField(FDrawColumn.Field,
               FDrawColumn.Alignment), FDrawColumn.WordBreak);
        end;

        if ARow < FDataLink.RecordCount then
        begin
          if Columns.State = csDefault then
            DrawDataCell(ARect, FDrawColumn.Field, AState);
          DrawColumnCell(ARect, ACol, FDrawColumn, AState);
        end
        else
          Canvas.FillRect(ARect);

      finally
        FDataLink.ActiveRecord := OldActive;
      end;
      if FDefaultDrawing and (gdSelected in AState)
        and ((dgAlwaysShowSelection in Options) or IsActiveControl)
        and not (csDesigning in ComponentState)
        and not (dgRowSelect in Options)
        and (UpdateLock = 0)
        and (ValidParentForm(Self).ActiveControl = Self)
        and not (dgHighlightRow in Options) then
        Windows.DrawFocusRect(Handle, ARect);
    end;
  end;
  if (gdFixed in AState) and (([dgRowLines, dgColLines] * Options =
    [dgRowLines, dgColLines]) or (dgFlatButtons in Options)) and
    not FrozenCol then
  begin
    InflateRect(ARect, 1, 1);
    DrawGridFrameBorder(Canvas, ARect, BorderStyle, BorderState, FixedColor);
  end;

end;

procedure TDCCustomDBGrid.DrawDataCell(const Rect: TRect; Field: TField;
  State: TGridDrawState);
begin
  if Assigned(FOnDrawDataCell) then FOnDrawDataCell(Self, Rect, Field, State);
end;

procedure TDCCustomDBGrid.DrawColumnCell(const Rect: TRect; DataCol: Integer;
  Column: TColumn; State: TGridDrawState);
begin
  if Assigned(OnDrawColumnCell) then
    OnDrawColumnCell(Self, Rect, DataCol, Column, State);
end;

procedure TDCCustomDBGrid.EditButtonClick;
begin
  if Assigned(FOnEditButtonClick) then
    FOnEditButtonClick(Self)
  else
    ShowPopupEditor(Columns[SelectedIndex]);
end;

procedure TDCCustomDBGrid.EditingChanged;
begin
  if dgIndicator in Options then InvalidateCell(0, Row);
end;

procedure TDCCustomDBGrid.EndLayout;
begin
  if FLayoutLock > 0 then
  begin
    try
      try
        if FLayoutLock = 1 then
          InternalLayout;
      finally
        if FLayoutLock = 1 then FColumns.EndUpdate;
      end;
    finally
      Dec(FLayoutLock);
      EndUpdate;
      if FUpdateLock = 0 then inherited ColWidthsChanged;
    end;
  end;
end;

procedure TDCCustomDBGrid.EndUpdate;
begin
  if FUpdateLock > 0 then Dec(FUpdateLock);
end;

function TDCCustomDBGrid.GetColField(DataCol: Integer): TField;
begin
  Result := nil;
  if (DataCol >= 0) and FDatalink.Active and (DataCol < Columns.Count) then
    Result := Columns[DataCol].Field;
end;

function TDCCustomDBGrid.GetDataSource: TDataSource;
begin
  Result := FDataLink.DataSource;
end;

function TDCCustomDBGrid.GetEditLimit: Integer;
begin
  Result := 0;
  if Assigned(SelectedField) and (SelectedField.DataType = ftString) then
    Result := SelectedField.Size;
end;

function TDCCustomDBGrid.GetEditMask(ACol, ARow: Longint): string;
begin
  Result := '';
  if FDatalink.Active then
  with Columns[RawToDataColumn(ACol)] do
    if Assigned(Field) then
      Result := Field.EditMask;
end;

function TDCCustomDBGrid.GetEditText(ACol, ARow: Longint): string;
begin
  Result := '';
  if FDatalink.Active then
  with Columns[RawToDataColumn(ACol)] do
    if Assigned(Field) then
      Result := Field.Text;
  FEditText := Result;
end;

function TDCCustomDBGrid.GetFieldCount: Integer;
begin
  Result := FDatalink.FieldCount;
end;

function TDCCustomDBGrid.GetFields(FieldIndex: Integer): TField;
begin
  Result := FDatalink.Fields[FieldIndex];
end;

function TDCCustomDBGrid.GetFieldValue(ACol: Integer): string;
var
  Field: TField;
begin
  Result := '';
  Field := GetColField(ACol);
  if Field <> nil then Result := Field.DisplayText;
end;

function TDCCustomDBGrid.GetSelectedField: TField;
var
  Index: Integer;
begin
  Index := SelectedIndex;
  if (Index <> -1) and (Columns.Count > Index) then
    Result := Columns[Index].Field
  else
    Result := nil;
end;

function TDCCustomDBGrid.GetSelectedIndex: Integer;
begin
  Result := RawToDataColumn(Col);
end;

function TDCCustomDBGrid.HighlightCell(DataCol, DataRow: Integer;
  const Value: string; AState: TGridDrawState): Boolean;
var
  Index: Integer;
begin
  Result := False;
  if (dgMultiSelect in Options) and Datalink.Active then
    Result := FBookmarks.Find(Datalink.Datasource.Dataset.Bookmark, Index);
  if not Result then
    Result := (gdSelected in AState)
      and ((dgAlwaysShowSelection in Options) or Focused)
        { updatelock eliminates flicker when tabbing between rows }
      and ((UpdateLock = 0) or (dgRowSelect in Options));
end;

procedure TDCCustomDBGrid.KeyDown(var Key: Word; Shift: TShiftState);
var
  KeyDownEvent: TKeyEvent;

  procedure Tab(GoForward: Boolean);
  var
    ACol, Original: Integer;
  begin
    ACol := Col;
    Original := ACol;
    BeginUpdate;    { Prevent highlight flicker on tab to next/prior row }
    try
      while True do
      begin
        if GoForward then
          Inc(ACol) else
          Dec(ACol);
        if ACol >= ColCount then
        begin
          NextRow(False, Shift);
          ACol := FIndicatorOffset;
        end
        else if ACol < FIndicatorOffset then
        begin
          PriorRow(False, Shift);
          ACol := ColCount - FIndicatorOffset;
        end;
        if ACol = Original then Exit;
        if TabStops[ACol] then
        begin
          MoveCol(ACol, 0);
          Exit;
        end;
      end;
    finally
      EndUpdate;
    end;
  end;

  function DeletePrompt: Boolean;
  var
    Msg: string;
  begin
    if (FBookmarks.Count > 1) then
      Msg := SDeleteMultipleRecordsQuestion
    else
      Msg := SDeleteRecordQuestion;
    Result := not (dgConfirmDelete in Options) or
      (MessageDlg(Msg, mtConfirmation, mbOKCancel, 0) <> idCancel);
  end;

const
  RowMovementKeys = [VK_UP, VK_PRIOR, VK_DOWN, VK_NEXT, VK_HOME, VK_END];

begin
  if not DataVisible then Exit;

  if ClipDown then
  begin
    if Key = VK_ESCAPE then
      HideClipPopup
    else
      FClipPopup.KeyDown(Key, Shift);
    Key := 0;
    Exit;
  end;

  KeyDownEvent := OnKeyDown;
  if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
  if not FDatalink.Active or not CanGridAcceptKey(Key, Shift) then Exit;
  if UseRightToLeftAlignment then
    if Key = VK_LEFT then
      Key := VK_RIGHT
    else if Key = VK_RIGHT then
      Key := VK_LEFT;
  with FDatalink.DataSet do
    if ssCtrl in Shift then
    begin
      if (Key in RowMovementKeys) then ClearSelection;
      case Key of
        VK_UP, VK_PRIOR:
          FDataLink.MoveBy(-FDatalink.ActiveRecord);
        VK_DOWN, VK_NEXT:
          FDataLink.MoveBy(FDatalink.BufferCount - FDatalink.ActiveRecord - 1);
        VK_LEFT:
          MoveCol(FIndicatorOffset, 1);
        VK_RIGHT:
          MoveCol(ColCount - 1, -1);
        VK_HOME:
          First;
        VK_END:
          Last;
        VK_DELETE:
          if not ReadOnly and not IsEmpty and CanModify and DeletePrompt then
            if FBookmarks.Count > 0 then
              FBookmarks.Delete
            else
              Delete;
        VK_ADD:
          SelectItems(smSelect);
        VK_SUBTRACT:
          SelectItems(smDeselect);
      end
    end
    else
      case Key of
        VK_UP: PriorRow(True, Shift);
        VK_DOWN: NextRow(True, Shift);
        VK_LEFT:
          if (dgRowSelect in Options) then
            PriorRow(False, Shift)
          else
            MoveCol(Col - 1, -1);
        VK_RIGHT:
          if (dgRowSelect in Options) then
            NextRow(False, Shift)
          else
            MoveCol(Col + 1, 1);
        VK_HOME:
          if (ColCount = FIndicatorOffset+1)
             or (dgRowSelect in Options) then
          begin
            ClearSelection;
            First;
          end
          else
            MoveCol(FIndicatorOffset, 1);
        VK_END:
          if (ColCount = FIndicatorOffset+1)
             or (dgRowSelect in Options) then
          begin
            ClearSelection;
            Last;
          end
          else
            MoveCol(ColCount - 1, -1);
        VK_NEXT:
          begin
            ClearSelection;
            FDataLink.MoveBy(VisibleRowCount);
          end;
        VK_PRIOR:
          begin
            ClearSelection;
            FDataLink.MoveBy(-VisibleRowCount);
          end;
        VK_INSERT:
          if (dgeInsertSelect in OptionsEx) and
             (dgMarker in Options) and FDatalink.Active then
          begin
            try
              BeginUpdate;
              FSelectionAnchor := FBookmarks.CurrentRow;
              FBookmarks.CurrentRowSelected := not FBookmarks.CurrentRowSelected;
              FSelecting := True;
              NextRow(True, Shift);
            finally
              EndUpdate;
            end
          end
          else
            if CanModify and not ReadOnly and (dgEditing in Options) then
            begin
              ClearSelection;
              Insert;
            end;
        VK_TAB: if not (ssAlt in Shift) then Tab(not (ssShift in Shift));
        VK_ESCAPE:
          begin
            inherited;
            if Key = VK_ESCAPE then
            begin
              if SysLocale.PriLangID = LANG_KOREAN then
                _setFlag(FFlags, DGF_ISESCKEYPRESS, True);
              FDatalink.Reset;
              ClearSelection;
              if not (dgAlwaysShowEditor in Options) then HideEditor;
            end;
          end;
        VK_F2: EditorMode := True;
      end;
end;

procedure TDCCustomDBGrid.KeyPress(var Key: Char);
begin
  if not DataVisible then Exit;
  if (DragState <> dsNone) then
  begin
    inherited;
    Exit;
  end;

  _setFlag(FFlags, DGF_ISESCKEYPRESS, False);
  if not (dgAlwaysShowEditor in Options) and (Key = Char(VK_RETURN)) then
    FDatalink.UpdateData;
  inherited KeyPress(Key);
end;

procedure TDCCustomDBGrid.SetTitleHeight;
 var
  I, D, B: Integer;
  Heights: array of Integer;
  P: TPoint;
 var
  PopupRect: TRect;
  FixedWidths: array[boolean] of integer;
begin
  FixedWidths[False] := -1;
  Canvas.Font := Font;
  B := GetSystemMetrics(SM_CYHSCROLL);
  if dgTitles in Options then
  begin
    SetLength(Heights, FTitleOffset);
    for I := 0 to FColumns.Count-1 do
    begin
      with FColumns[I] do
      begin
        Canvas.Font := Title.Font;
        D := Depth;
        FixedWidths[True] := Width - 1;
        if (gcPopupMenu in Options) and
          GetTitleMenuRect(Rect(0, 0, Width, 0), PopupRect) then
        begin
          Dec(FixedWidths[True], PopupRect.Right - PopupRect.Left + 2);
        end;

        if D <= High(Heights) then
        begin
          P.Y := GetTextHeightEx(Canvas, Title.Caption,
            FixedWidths[gcWordBreak in FOptions], gcWordBreak in FOptions);
          FColumns[I].FSize.Y := P.Y;
          if P.Y > 0 then Inc(P.Y, 4);
          if (Images <> nil) and (ItemIndex <> -1) then
             if P.Y < (Images.Height + 3) then P.Y := Images.Height + 3;

          if FColumns[I].Expandable and (B > P.Y) then  P.Y := B;
          Heights[D] := _intMax(P.Y, Heights[D]);
        end;
      end;
    end;
    if Heights[0] = 0 then
    begin
      Canvas.Font := FTitleFont;
      Heights[0] := Canvas.TextHeight('Wg') + 4;
    end;
    RowHeights[0] := Heights[0];
  end;
end;

{ InternalLayout is called with layout locks and column locks in effect }
procedure TDCCustomDBGrid.InternalLayout;

  function FieldIsMapped(F: TField): Boolean;
  var
    X: Integer;
  begin
    Result := False;
    if F = nil then Exit;
    for X := 0 to FDatalink.FieldCount-1 do
      if FDatalink.Fields[X] = F then
      begin
        Result := True;
        Exit;
      end;
  end;

  procedure CheckForPassthroughs;  // check for Columns.State flip-flop
  var
    SeenPassthrough: Boolean;
    I, J: Integer;
    Column: TColumn;
  begin
    SeenPassthrough := False;
    for I := 0 to FColumns.Count-1 do
      if not FColumns[I].IsStored then
        SeenPassthrough := True
      else if SeenPassthrough then
      begin  // we have both persistent and non-persistent columns.  Kill the latter
        for J := FColumns.Count-1 downto 0 do
        begin
          Column := FColumns[J];
          if not Column.IsStored then
            Column.Free;
        end;
        Exit;
      end;
  end;

  procedure ResetColumnFieldBindings;
  var
    I, J, K: Integer;
    Fld: TField;
    Column: TColumn;
  begin
    if FColumns.State = csDefault then
    begin
       { Destroy columns whose fields have been destroyed or are no longer
         in field map }
      if (not FDataLink.Active) and (FDatalink.DefaultFields) then
        FColumns.Clear
      else
        for J := FColumns.Count-1 downto 0 do
          with FColumns[J] do
          if not Assigned(Field)
            or not FieldIsMapped(Field) then Free;
      I := FDataLink.FieldCount;
      if (I = 0) and (FColumns.Count = 0) then Inc(I);
      for J := 0 to I-1 do
      begin
        Fld := FDatalink.Fields[J];
        if Assigned(Fld) then
        begin
          K := J;
           { Pointer compare is valid here because the grid sets matching
             column.field properties to nil in response to field object
             free notifications.  Closing a dataset that has only default
             field objects will destroy all the fields and set associated
             column.field props to nil. }
          while (K < FColumns.Count) and (FColumns[K].Field <> Fld) do
            Inc(K);
          if K < FColumns.Count then
            Column := FColumns[K]
          else
          begin
            Column := FColumns.InternalAdd;
            Column.Field := Fld;
            if Column.Field.Tag = -1 then Column.Visible := False;
          end;
        end
        else
          Column := FColumns.InternalAdd;
        Column.Index := J;
      end;
    end
    else
    begin
      { Force columns to reaquire fields (in case dataset has changed) }
      for I := 0 to FColumns.Count-1 do
        FColumns[I].Field := nil;
    end;
  end;

  procedure MeasureTitleHeights;
  var
    K: Integer;
    RestoreCanvas: Boolean;
  begin
    RestoreCanvas := not HandleAllocated;
    if RestoreCanvas then Canvas.Handle := GetDC(0);
    try
      Canvas.Font := Font;
      K := Canvas.TextHeight('Wg') + 3;
      if dgRowLines in Options then
        Inc(K, GridLineWidth);

      // DefaultRowHeight := K;
      // New 29/09/1998
      if not (dgUserRowHeight in Options) and (DefaultRowHeight <> K) then
        DefaultRowHeight := K;
      SetTitleHeight;
    finally
      if RestoreCanvas then
      begin
        ReleaseDC(0, Canvas.Handle);
        Canvas.Handle := 0;
      end;
    end;
  end;

var
  I, J: Integer;
begin
  if ([csLoading, csDestroying] * ComponentState) <> [] then Exit;

  if HandleAllocated then KillMessage(Handle, CM_DEFERLAYOUT);

  CheckForPassthroughs;
  FIndicatorOffset := 0;

  if dgIndicator in Options then Inc(FIndicatorOffset);
  if dgMarker in Options then Inc(FIndicatorOffset);

  FDatalink.ClearMapping;
  if FDatalink.Active then DefineFieldMap;

  DoubleBuffered := {(dgCompleteLines in Options) or} 
    (FDatalink.Dataset <> nil) and FDatalink.Dataset.ObjectView;

  ResetColumnFieldBindings;
  ColCount := FColumns.Count + FIndicatorOffset;
  FTitleOffset := 0;
  if dgTitles in Options then
  begin
    FTitleOffset := 1;
    if (FDatalink <> nil) and (FDatalink.Dataset <> nil)
      and FDatalink.Dataset.ObjectView then
    begin
      for I := 0 to FColumns.Count-1 do
      begin
        if FColumns[I].Showing then
        begin
          J := FColumns[I].Depth;
          if J >= FTitleOffset then FTitleOffset := J+1;
        end;
      end;
    end;
  end;

  MeasureTitleHeights;
  SetColumnAttributes;
  UpdateRowCount;
  UpdateActive;

  if dgAutoSize in Options then
    I := RawToDataColumn(_intMin(FixedCols, LeftCol))
  else
    I := RawToDataColumn(LeftCol);

  while (I < Columns.Count) and not Columns[I].Visible do Inc(I);
  LeftCol := DataToRawColumn(I);

  if dgAutoSize in Options then
  begin
    if FSizingIndex > -1 then
    begin
      I := FSizingIndex;
      FSizingIndex := -1;
      UpdateColWidths(I, i <> ColCount - 1);
    end
    else
      UpdateColWidths(-1, True);

    if FColumns.Count  > 0 then
      for I := FIndicatorOffset to ColCount - 1 do
        FColumns[I - FIndicatorOffset].Width := ColWidths[I];

    if EditorMode then ShowEditor;
  end
  else
    invalidate;
end;

procedure TDCCustomDBGrid.LayoutChanged;
begin
  if AcquireLayoutLock then
    EndLayout;
end;

procedure TDCCustomDBGrid.LinkActive(Value: Boolean);
var
  Comp: TComponent;
  I: Integer;
begin
  if not Value then HideEditor;
  FBookmarks.LinkActive(Value);
  try
    LayoutChanged;
  finally
    for I := ComponentCount-1 downto 0 do
    begin
      Comp := Components[I];   // Free all the popped-up subgrids
      if (Comp is TDCCustomDBGrid)
        and (TDCCustomDBGrid(Comp).DragKind = dkDock) then
        Comp.Free;
    end;
    UpdateScrollBar;
    if Value and (dgAlwaysShowEditor in Options) then ShowEditor;
  end;
end;

procedure TDCCustomDBGrid.Loaded;
begin
  inherited Loaded;
  if FColumns.Count > 0 then
    ColCount := FColumns.Count;
  LayoutChanged;
end;

function TDCCustomDBGrid.PtInExpandButton(X,Y: Integer; var MasterCol: TColumn): Boolean;
var
  Cell: TGridCoord;
  R: TRect;
begin
  MasterCol := nil;
  Result := False;
  Cell := MouseCoord(X,Y);
  if (Cell.Y < FTitleOffset) and FDatalink.Active
    and (Cell.X >= FIndicatorOffset)
    and (RawToDataColumn(Cell.X) < Columns.Count) then
  begin
    R := CalcTitleRect(Columns[RawToDataColumn(Cell.X)], Cell.Y, MasterCol);
    if not UseRightToLeftAlignment then
      R.Left := R.Right - GetSystemMetrics(SM_CXHSCROLL)
    else
      R.Right := R.Left + GetSystemMetrics(SM_CXHSCROLL);
    Result := MasterCol.Expandable and PtInRect(R, Point(X,Y));
  end;
end;

procedure TDCCustomDBGrid.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
var
  Cell: TGridCoord;
  OldCol,OldRow: Integer;
  MasterCol: TColumn;
  GridOptions: TGridOptions;
  AX, AY, AClickedCol: integer;
  AOnMouseDown: TMouseEvent;
  Msg: TMsg;
  R, MenuRect: TRect;
  ColType: TFixedCol;
begin
  if not AcquireFocus or not DataVisible then Exit;

  AX := X; AY := Y;

  if (X > 0) and (Y > 0) then
    Cell := MouseCoord(X, Y)
  else begin
    Cell.X := 0;
    Cell.Y := -1;
  end;

  R := CellRect(Cell.X, Cell.Y);
  ColType := GetFixedColType(Cell.X, 0);
  if IsRectEmpty(R) then Exit;

  if (ssDouble in Shift) and (Button = mbLeft) then
  begin
    if (Cell.X >= FIndicatorOffset) and (Cell.Y >= FTitleOffset) then
    begin
      if MouseUpBeforeDblClk then
      begin
        {WM_LBUTTONUP}
        case Integer(GetMessage(Msg, 0, WM_MOUSEFIRST, WM_MOUSELAST)) of
          -1:;
          0 :
            begin
              PostQuitMessage(Msg.WParam);
            end;
          else
            DispatchMessage(Msg);
        end;
      end;
      DblClick;
      if (ColType = dcColumn) and
        (Cell.Y >= FTitleOffset) and (Columns.Count > 0) then
        CellDblClick(Columns[RawtoDataColumn(Cell.X)]);
      Exit;
    end;
    Shift := Shift - [ssDouble];
  end;

  FMousePoint := Point(X,Y);

  if (Button = mbLeft) and (Cell.Y = 0) then
  begin
    if (ColType = dcIndicator) and (dgeIndicatorMenu in OptionsEx) or
       (ColType = dcMarker) and (dgeMarkerMenu in OptionsEx) then
      ClipClick(ColType, -1)
    else
      if ClickedType = ctTitleClick then HideClipPopup;
  end
  else
    HideClipPopup;

  if (dgTitleClicked in Options) and (Button = mbLeft) and not Sizing(X, Y)
      and (Cell.Y = 0) and FDatalink.Active and (ColType = dcColumn) then
  begin
    AClickedCol := ClickedCol;
    HideClipPopup;
    if (gcPopupMenu in Columns[RawToDataColumn(Cell.X)].Options) and
      GetTitleMenuRect(R, MenuRect) and PtInRect(MenuRect, Point(AX, AY)) then
    begin
      if (ClickedType = ctMenuClick) and (AClickedCol = Cell.X) then
        ClickedType := ctTitleClick
      else begin
        ClickedCol := Cell.X;
        ClickedType := ctMenuClick;
        ClipClick(ColType, Cell.X);
      end;
    end
    else begin
      ClickedCol := Cell.X;
      ClickedType := ctTitleClick;
    end;
  end;

  if Sizing(X, Y) then
  begin
    HideClipPopup;
    FDatalink.UpdateData;
    inherited MouseDown(Button, Shift, X, Y);
    if EditorMode then ShowEditor;
    Exit;
  end
  else
   FSizingIndex := -1;

  if (Cell.X < 0) and (Cell.Y < 0) then
  begin
    inherited MouseDown(Button, Shift, X, Y);
    Exit;
  end;

  if (DragKind = dkDock) and (Cell.X < FIndicatorOffset) and
    (Cell.Y < FTitleOffset) and (not (csDesigning in ComponentState)) then
  begin
    BeginDrag(False);
    Exit;
  end;

  if PtInExpandButton(X,Y, MasterCol) then
  begin
    MasterCol.Expanded := not MasterCol.Expanded;
    ReleaseCapture;
    UpdateDesigner;
    Exit;
  end;

  if ((csDesigning in ComponentState) or (dgColumnResize in Options)) and
    (Cell.Y < FTitleOffset) then
  begin
    FDataLink.UpdateData;
    if (dgTitleClicked in Options) and FDatalink.Active and (Button = mbLeft) and
       (ColType = dcColumn) then
    begin
      GridOptions := inherited Options;
      SetInternalOptions(inherited Options - [goColMoving]);
      inherited MouseDown(Button, Shift, X, Y);
      SetInternalOptions(GridOptions);
    end
    else
      inherited MouseDown(Button, Shift, X, Y);
    if EditorMode then ShowEditor else InvalidateCell(Cell.X, 0);
    Exit;
  end;

  if FDatalink.Active then
    with Cell do
    begin
      BeginUpdate;   { eliminates highlight flicker when selection moves }
      try
        FDatalink.UpdateData; // validate before moving
        HideEditor;
        OldCol := Col;
        OldRow := Row;
        if not((dgAdvancedSelect in Options) and
           ([ssShift, ssLeft] * Shift = [ssShift, ssLeft])) then
        begin
          if (Y >= FTitleOffset) and (Y - Row <> 0) then
            FDatalink.MoveBy(Y - Row);
          if (X >= FixedCols - FrozenCols) then
            MoveCol(X, 0);
        end;
        if (dgMultiSelect in Options) and FDatalink.Active then
        begin
          if Button = mbLeft then
          begin
            with FBookmarks do
            begin
              FSelecting := False;
              if ssCtrl in Shift then
                CurrentRowSelected := not CurrentRowSelected
              else
              begin
                Clear;
                CurrentRowSelected := True;
              end;
            end;
            end
          else begin
            {}
          end;
        end;

        if (dgMarker in Options)  and FDatalink.Active and
           (X < FIndicatorOffset) and
           ( ((dgIndicator in Options)   and  (X=1))   or
             (not(dgIndicator in Options) and (X=0)) ) and (Button = mbLeft)
        then begin
          with FBookmarks do
          begin
            FSelecting := False;
            CurrentRowSelected := not CurrentRowSelected;
            InvalidateCell(Cell.X, Cell.Y);
          end
        end
        else begin
          if dgAdvancedSelect in Options then
          begin
            SelectedArea.MouseDown(FMousePoint.X, FMousePoint.Y, Cell, Shift);
          end;
        end;

        if (Button = mbLeft) and
          (((X = OldCol) and (Y = OldRow)) or (dgAlwaysShowEditor in Options)) then
          ShowEditor         { put grid in edit mode }
        else
          InvalidateEditor;  { draw editor, if needed }
      finally
        EndUpdate;
        AOnMouseDown := OnMouseDown;
        if Assigned(AOnMouseDown) then AOnMouseDown(Self, Button, Shift, AX, AY);
      end;
    end;
end;

procedure TDCCustomDBGrid.MouseMove(Shift: TShiftState; X, Y: Integer);
var
  Cell: TGridCoord;
  OldCurrentCol: integer;
begin
  if not DataVisible then Exit;
  Cell := MouseCoord(X,Y);
  OldCurrentCol := FCurrentCol;
  if ClickedCol <> -1 then FCurrentCol := Cell.X else FCurrentCol := -1;

  if (DragState = dsNone) and
     (Cell.X >= FixedCols) and (ClickedCol = FCurrentCol) and
     (ClickedCol <> -1) and (ClickedType = ctTitleClick) and
     (FGridState <> gsColMoving) and
     ((Abs(FMousePoint.X - X) > 5) or (Abs(FMousePoint.Y - Y) > 5) ) then
  begin
     FGridState := gsColMoving;
     inherited MouseDown(mbLeft, Shift, FMousePoint.X, FMousePoint.Y);
     if (FGridState = gsColMoving) or (DragState = dsColMoving) then Exit;
  end;

  inherited MouseMove(Shift, X, Y);

  if (ClickedCol <> -1) and (FCurrentCol <> OldCurrentCol) and
     (FGridState <> gsColMoving) and (DragState = dsNone)
     and not
      ((ClickedCol = 0) and  not(dgIndicator in Options) and (dgMarker in Options)) or
      ((ClickedCol = 1) and     (dgIndicator in Options) and (dgMarker in Options))
  then begin
    InvalidateCell(ClickedCol, 0);
  end;

  if (Cell.Y < FTitleOffset) and (RawToDataColumn(Cell.X)>=0) and
    (Columns.Count > 0) then
  begin
    FColumnCell := RawToDataColumn(Cell.X);
    DoColumnComment(MODE_SHOWWINDOW, Columns[FColumnCell]);
  end
  else begin
    DoColumnComment(MODE_HIDEWINDOW, nil);
    {    hinta      }
  end;

end;

procedure TDCCustomDBGrid.MouseUp(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
var
  Cell  : TGridCoord;
  SaveState: TGridState;
  SaveDragState: TDragGridState;
  MouseClick: boolean;
  OldClickedCol, NewSize, ASizingIndex, nColumn: integer;
  R: TRect;
  MouseUpEvent: TMouseEvent;
begin
  SaveState := FGridState;
  SaveDragState := DragState;
  ASizingIndex := FSizingIndex;

  MouseClick := (ClickedCol <> -1) and
    ((FCurrentCol = -1) or (ClickedCol = FCurrentCol)) and
    (ClickedType <> ctMenuClick);
  Cell := MouseCoord(X,Y);

  if (SaveState = gsColSizing) and (ASizingIndex < FixedCols) then
  begin
    try
      MouseUpEvent := OnMouseUp;
      if Assigned(MouseUpEvent) then MouseUpEvent(Self, Button, Shift, X, Y);
    finally
      FGridState := gsNormal;
    end;
  end
  else
    inherited MouseUp(Button, Shift, X, Y);

  if (SaveState = gsColSizing) and (ASizingIndex < FixedCols) then
  begin
    R := CellRect(FSizingIndex, Cell.Y);
    NewSize := _intMax(5, X - R.Left + FSizingOff);
    nColumn := RawToDataColumn(ASizingIndex);
    if (nColumn < Columns.Count) and (nColumn >= 0) and
      (gcPopupMenu in Columns[nColumn].FOptions) then
      NewSize := _intMax(12, NewSize);
    ColWidths[ASizingIndex] := NewSize;
    UpdateDesigner;
  end;

  if (Button = mbLeft) and (ClickedCol <> -1) and
    (ClickedType <> ctMenuClick) then
  begin
    OldClickedCol := ClickedCol;
    ClickedCol := -1;
    InvalidateCell(OldClickedCol, 0);
  end;

  if (SaveState = gsRowSizing) or (SaveState = gsColSizing) or
    ((InplaceEditor <> nil) and (InplaceEditor.Visible) and
     (PtInRect(InplaceEditor.BoundsRect, Point(X,Y)))) then Exit;

  if (Button = mbLeft) and (Cell.X >= FIndicatorOffset) and(Cell.Y >= 0) and
     (SaveState <> gsColMoving) and (RawToDataColumn(Cell.X) < Columns.Count) and
     (SaveDragState <> dsColMoving) and (SaveDragState <>dsHeaderMoving)
  then begin
    if (Cell.Y <  FTitleOffset) and MouseClick then
      DoColumnClick(Shift, Cell.X)
    else
      CellClick(Columns[SelectedIndex]);
  end;

end;

procedure TDCCustomDBGrid.MoveCol(RawCol, Direction: Integer);
var
  OldCol: Integer;
begin
  FDatalink.UpdateData;
  if RawCol >= ColCount then RawCol := ColCount - 1;
  if RawCol < FixedCols - FrozenCols then RawCol := FixedCols- FrozenCols;
  if Direction <> 0 then
  begin
    while (RawCol < ColCount) and (RawCol >= FIndicatorOffset) and
      (ColWidths[RawCol] <= 0) do
      Inc(RawCol, Direction);
    if (RawCol >= ColCount) or (RawCol < FIndicatorOffset) then Exit;
  end;
  OldCol := Col;
  if RawCol <> OldCol then
  begin
    if not _getFlag(FFlags, DGF_COLEXITSTATE) then
    begin
      _setFlag(FFlags, DGF_COLEXITSTATE, True);
      try
        ColExit;
      finally
        _setFlag(FFlags, DGF_COLEXITSTATE, False);
      end;
      if Col <> OldCol then Exit;
    end;
    HideEditor;
    if RawCol < FixedCols then
      SetInternalCol(RawCol, FrozenCols > 0)
    else
      SetInternalCol(RawCol, False);
    ColEnter;
    if dgAlwaysShowEditor in Options then ShowEditor;
  end;
end;

procedure TDCCustomDBGrid.Notification(AComponent: TComponent;
  Operation: TOperation);
var
  I: Integer;
  NeedLayout: Boolean;
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) then
  begin
    if (AComponent is TPopupMenu) then
    begin
      for I := 0 to Columns.Count-1 do
        if Columns[I].PopupMenu = AComponent then
          Columns[I].PopupMenu := nil;
    end
    else if (FDataLink <> nil) then
      if (AComponent = DataSource)  then
        DataSource := nil
      else if (AComponent is TField) then
      begin
        NeedLayout := False;
        BeginLayout;
        try
          for I := 0 to Columns.Count-1 do
            with Columns[I] do
              if Field = AComponent then
              begin
                Field := nil;
                NeedLayout := True;
              end;
        finally
          if NeedLayout and Assigned(FDatalink.Dataset)
            and not FDatalink.Dataset.ControlsDisabled then
            EndLayout
          else
            DeferLayout;
        end;
      end;
  end;
  if (Operation = opRemove) and (AComponent = FImages) then FImages := nil;
end;

procedure TDCCustomDBGrid.RecordChanged(Field: TField);
var
  I: Integer;
  CField: TField;
begin
  if not HandleAllocated then Exit;
  if Field = nil then
    Invalidate
  else
  begin
    for I := 0 to Columns.Count - 1 do
      if Columns[I].Field = Field then
        InvalidateCol(DataToRawColumn(I));
  end;
  CField := SelectedField;
  if ((Field = nil) or (CField = Field)) and
    (Assigned(CField) and (CField.Text <> FEditText) and
    ((SysLocale.PriLangID <> LANG_KOREAN) or _getFlag(FFlags, DGF_ISESCKEYPRESS))) then
  begin
    InvalidateEditor;
    if InplaceEditor <> nil then InplaceEditor.Deselect;
  end;
end;

procedure TDCCustomDBGrid.Scroll(Distance: Integer);
var
  OldRect, NewRect: TRect;
  RowHeight: Integer;
begin
  if not HandleAllocated then Exit;
  if (FDataLink.ActiveRecord >= RawToDataRow(VisibleRowCount)) or
    ((dgeShowPartiallyVisibleData in FOptionsEx) and
    (FDataLink.ActiveRecord = 0)) then
    if UpdateRowCount then Exit;

  OldRect := BoxRectEx(0, Row, ColCount - 1, Row);
  UpdateScrollBar;
  UpdateActive;
  NewRect := BoxRectEx(0, Row, ColCount - 1, Row);
  ValidateRect(Handle, @OldRect);
  InvalidateRect(Handle, @OldRect, False);
  InvalidateRect(Handle, @NewRect, False);
  if Distance <> 0 then
  begin
    HideEditor;
    try
      if Abs(Distance) > VisibleRowCount then
      begin
        Invalidate;
        Exit;
      end
      else
      begin
        RowHeight := DefaultRowHeight;
        if (dgRowLines in Options) and not (dgFlatLines in Options) then
          Inc(RowHeight, GridLineWidth);
        NewRect := BoxRectEx(0, FixedRows, ColCount - 1, RowCount);
        ScrollWindowEx(Handle, 0, -RowHeight * Distance, @NewRect, @NewRect,
          0, nil, SW_INVALIDATE);
        NewRect := BoxRectEx(0, Row, ColCount - 1, Row);
        OffsetRect(NewRect, 0, -RowHeight * Distance);
        InvalidateRect(Handle, @NewRect, False);
      end;
    finally
      if dgAlwaysShowEditor in Options then ShowEditor;
    end;
  end;

  if UpdateLock = 0 then Update;
end;

procedure TDCCustomDBGrid.SetColumns(Value: TDBGridColumns);
begin
  Columns.Assign(Value);
end;

function ReadOnlyField(Field: TField): Boolean;
var
  MasterField: TField;
begin
  Result := Field.ReadOnly;
  if not Result and (Field.FieldKind = fkLookup) then
  begin
    Result := True;
    if Field.DataSet = nil then Exit;
    MasterField := Field.Dataset.FindField(Field.KeyFields);
    if MasterField = nil then Exit;
    Result := MasterField.ReadOnly;
  end;
end;

procedure TDCCustomDBGrid.SetColumnAttributes;
var
  I: Integer;
begin
  for I := 0 to FColumns.Count-1 do
  with FColumns[I] do
  begin
    TabStops[I + FIndicatorOffset] := Showing and not ReadOnly and
      DataLink.Active and  Assigned(Field) and
      not ((Field.FieldKind = fkCalculated) or ReadOnlyField(Field));
    ColWidths[I + FIndicatorOffset] := Width;
  end;
  if (dgIndicator in Options) then
    ColWidths[0] := IndicatorWidth;
  if (dgMarker in Options) then
     if (dgIndicator in Options) then
        ColWidths[1] := MarkerWidth
      else
        ColWidths[0] := MarkerWidth;
  UpdateFrozenCols(FFrozenCols)
end;

procedure TDCCustomDBGrid.SetDataSource(Value: TDataSource);
begin
  FBookmarks.Clear;
  if Value = FDatalink.DataSource then Exit;
  FViewDataLink.DataSource := Value;
  FDataLink.DataSource := Value;
  if Value <> nil then Value.FreeNotification(Self);
  LinkActive(FDataLink.Active);
end;

procedure TDCCustomDBGrid.SetEditText(ACol, ARow: Longint; const Value: string);
begin
  FEditText := Value;
end;

procedure TDCCustomDBGrid.SetOptions(Value: TDBGridOptions);
 const
  LayoutOptions = [dgEditing, dgAlwaysShowEditor, dgTitles, dgIndicator,
    dgColLines, dgRowLines, dgRowSelect, dgAlwaysShowSelection, dgMarker,
    dgTitleClicked, dgHighlightRow, dgFlatLines];
  RepaintOptions = [dgColLines, dgRowLines, dgCompleteLines];
 var
  NewGridOptions: TGridOptions;
  ChangedOptions: TDBGridOptions;
begin
  if FOptions <> Value then
  begin
    NewGridOptions := [];
    if dgColLines in Value then
      NewGridOptions := NewGridOptions + [goFixedVertLine, goVertLine];
    if dgRowLines in Value then
      NewGridOptions := NewGridOptions + [goFixedHorzLine, goHorzLine];
    if dgColumnResize in Value then
      NewGridOptions := NewGridOptions + [goColSizing, goColMoving];
    if dgTabs in Value then Include(NewGridOptions, goTabs);
    if dgRowSelect in Value then
    begin
      Include(NewGridOptions, goRowSelect);
      Exclude(Value, dgAlwaysShowEditor);
      Exclude(Value, dgEditing);
    end;

    if dgHighlightRow in Value then
    begin
      Exclude(Value, dgRowSelect);
    end;

    if dgEditing in Value then Include(NewGridOptions, goEditing);
    if dgAlwaysShowEditor in Value then Include(NewGridOptions, goAlwaysShowEditor);
    if dgMultiSelect in (FOptions - Value) then FBookmarks.Clear;

    if dgMultiSelect in Value then Value := Value - [dgMarker];

    if dgRowSizing in Value  then
    begin
      NewGridOptions := NewGridOptions + [goRowSizing];
      Value := Value +[dgUserRowHeight];
    end;

    if dgFlatButtons in Value then
      NewGridOptions := NewGridOptions - [goFixedHorzLine, goFixedVertLine];

    if dgFlatLines in Value then
      NewGridOptions := NewGridOptions - [goVertLine, goHorzLine,
        goFixedHorzLine, goFixedVertLine];

    inherited Options := NewGridOptions;

    ChangedOptions := (FOptions + Value) - (FOptions * Value);
    FOptions := Value;

    GridOptions := [];
    if dgAutoSize in Value then GridOptions := GridOptions + [goAutoSize];
    if dgAdvancedSelect in Value then
      GridOptions := GridOptions + [goAdvancedSelect];

    LockUpdate(True);
    try
      if not(dgTitles in Value) and (dgTitles in  ChangedOptions) then
        DefaultRowHeight := DefaultRowHeight;
      if dgFlatButtons in ChangedOptions then
         RecreateWnd
      else begin
        if ChangedOptions * LayoutOptions <> [] then LayoutChanged;
        if dgAutoSize in Value then UpdateColWidths(-1, True);
      end
    finally
      UnlockUpdate(True);
      if RepaintOptions * ChangedOptions <> [] then invalidate;
    end;
  end;
end;

procedure TDCCustomDBGrid.SetSelectedField(Value: TField);
var
  I: Integer;
begin
  if Value = nil then Exit;
  for I := 0 to Columns.Count - 1 do
    if Columns[I].Field = Value then MoveCol(DataToRawColumn(I), 0);
end;

procedure TDCCustomDBGrid.SetSelectedIndex(Value: Integer);
begin
  MoveCol(DataToRawColumn(Value), 0);
end;

procedure TDCCustomDBGrid.SetTitleFont(Value: TFont);
begin
  FTitleFont.Assign(Value);
  if (dgTitles in Options) and HandleAllocated then LayoutChanged;
end;

function TDCCustomDBGrid.StoreColumns: Boolean;
begin
  Result := Columns.State = csCustomized;
end;

procedure TDCCustomDBGrid.TimedScroll(Direction: TGridScrollDirection);
begin
  if FDatalink.Active then
  begin
    with FDatalink do
    begin
      if sdUp in Direction then
      begin
        FDataLink.MoveBy(-ActiveRecord - 1);
        Exclude(Direction, sdUp);
      end;
      if sdDown in Direction then
      begin
        FDataLink.MoveBy(RecordCount - ActiveRecord);
        Exclude(Direction, sdDown);
      end;
    end;
    if Direction <> [] then inherited TimedScroll(Direction);
  end;
end;

procedure TDCCustomDBGrid.TitleClick(Column: TColumn);
begin
  if Assigned(FOnTitleClick) then FOnTitleClick(Column);
end;

procedure TDCCustomDBGrid.ClipClick(AColType: TFixedCol; ACol: integer);
 var
  ColType: TFixedCol;
begin
  ColType := FClipPopup.ColType;
  HideClipPopup;
  if ColType <> AColType then ShowClipPopup(AColType, ACol, FClipPopup);
end;

procedure TDCCustomDBGrid.TitleFontChanged(Sender: TObject);
begin
  if not _getFlag(FFlags, DGF_SELFCHANGINGFONT) and
    not (csLoading in ComponentState) then
    ParentFont := False;
  if dgTitles in Options then LayoutChanged;
end;

procedure TDCCustomDBGrid.UpdateActive;
var
  NewRow: Integer;
  Field: TField;
begin
  if FDatalink.Active and HandleAllocated and not (csLoading in ComponentState) then
  begin
    if FDatalink.DataSet.Active and (FDatalink.ActiveRecord = FDatalink.RecordCount)
    then begin
      FDatalink.DataSet.Prior;
      FDatalink.DataSet.Next;
    end;
    NewRow := FDatalink.ActiveRecord + FTitleOffset;
    if Row <> NewRow then
    begin
      if not (dgAlwaysShowEditor in Options) then HideEditor;
      MoveColRow(Col, NewRow, False, False);
      InvalidateEditor;
    end;
    Field := SelectedField;
    if Assigned(Field) and (Field.Text <> FEditText) then
      InvalidateEditor;
  end;
end;

procedure TDCCustomDBGrid.UpdateData;
var
  Field: TField;
begin
  Field := SelectedField;
  if Assigned(Field) then
    Field.Text := FEditText;
end;

function TDCCustomDBGrid.UpdateRowCount: boolean;
 var
  OldRowCount: Integer;
  DrawInfo: TGridDrawInfo;
begin
  OldRowCount := RowCount;
  if RowCount <= FTitleOffset then RowCount := FTitleOffset + 1;
  FixedRows := FTitleOffset;
  with FDataLink do
    if not Active or (RecordCount = 0) or not HandleAllocated then
    begin
      if dgeCompleteRows in OptionsEx then
      begin
        CalcDrawInfoEx(DrawInfo, ColCount, 250);
        SetInternalRowCount(DrawInfo.Vert.LastFullVisibleCell + 1 + FTitleOffset)
      end
      else
        RowCount := 1 + FTitleOffset
    end
    else begin
      CalcDrawInfoEx(DrawInfo, ColCount, 250);
      FDataLink.BufferCount := DrawInfo.Vert.LastFullVisibleCell - TopRow + 1;
      if not SyncDataLinks(FDataLink.BufferCount) then
      begin
        FViewDataLink.BufferCount := 0;
        FViewDataLink.BufferCount := FDataLink.BufferCount;
      end;
      if dgeCompleteRows in OptionsEx then
        SetInternalRowCount(DrawInfo.Vert.LastFullVisibleCell + 1 + FTitleOffset)
      else
        SetInternalRowCount(FViewDataLink.RecordCount + FTitleOffset);
      if (dgRowSelect in Options) then TopRow := FixedRows;
      UpdateActive;
    end;
  if OldRowCount <> RowCount then
  begin
    Result := True;
    UpdateScrollBar;
  end
  else
    Result := False;
end;

procedure TDCCustomDBGrid.UpdateScrollBar;
var
  SIOld, SINew: TScrollInfo;
  nRowCount: integer;

  procedure HideScrollBar;
  begin
    SetScrollRange(Self.Handle, SB_VERT, 0, 1, False);
    if (True or (goAutoSize in GridOptions)) and DataVisible then
    begin
      ShowScrollBar(Self.Handle, SB_VERT, True);
      EnableScrollBar(Self.Handle, SB_VERT, ESB_DISABLE_BOTH)
    end
    else
      ShowScrollBar(Self.Handle, SB_VERT, False);
  end;

begin
  if not HandleAllocated then Exit;
  if FDatalink.Active and DataVisible then
  begin
    with FDatalink.DataSet do
    begin
      nRowCount := VisibleRowCount;
      SIOld.cbSize := sizeof(SIOld);
      SIOld.fMask := SIF_ALL;
      GetScrollInfo(Self.Handle, SB_VERT, SIOld);
      SINew := SIOld;
      if IsSequenced then
      begin
        SINew.nMin := 1;
        SINew.nPage := nRowCount;
        SINew.nMax := Integer(DWORD(RecordCount) + SINew.nPage - 1);
        if State in [dsInactive, dsBrowse, dsEdit] then
          SINew.nPos := RecNo;  // else keep old pos
      end
      else
      begin
        SINew.nMin := 0;
        if nRowCount < FDataLink.BufferCount   then
          SINew.nPage := nRowCount
        else
          SINew.nPage := 0;
        SINew.nMax := 4;
        if FDataLink.BOF then
           SINew.nPos := 0
        else
           if FDataLink.EOF then SINew.nPos := 4 else SINew.nPos := 2;
      end;
      if (SINew.nMin <> SIOld.nMin) or (SINew.nMax <> SIOld.nMax) or
        (SINew.nPage <> SIOld.nPage) or (SINew.nPos <> SIOld.nPos) then
      begin
        if SINew.nPage < ULONG(RecordCount) then
        begin
          ShowScrollBar(Self.Handle, SB_VERT, True);
          EnableScrollBar(Self.Handle, SB_VERT, ESB_ENABLE_BOTH);
          SetScrollInfo(Self.Handle, SB_VERT, SINew, True);
        end
        else
          HideScrollBar
      end;
    end;
  end
  else
    HideScrollBar
end;

function TDCCustomDBGrid.ValidFieldIndex(FieldIndex: Integer): Boolean;
begin
  Result := DataLink.GetMappedIndex(FieldIndex) >= 0;
end;

procedure TDCCustomDBGrid.CMParentFontChanged(var Message: TMessage);
begin
  inherited;
  if ParentFont then
  begin
    _setFlag(FFlags, DGF_SELFCHANGINGFONT, True);
    try
      TitleFont := Font;
    finally
      _setFlag(FFlags, DGF_SELFCHANGINGFONT, False);
    end;
    LayoutChanged;
  end;
end;

procedure TDCCustomDBGrid.CMBiDiModeChanged(var Message: TMessage);
var
  Loop: Integer;
begin
  inherited;
  for Loop := 0 to ComponentCount - 1 do
    if Components[Loop] is TDCCustomDBGrid then
      with Components[Loop] as TDCCustomDBGrid do
        { Changing the window, echos down to the subgrid }
        if Parent <> nil then
          Parent.BiDiMode := Self.BiDiMode;
end;

procedure TDCCustomDBGrid.CMExit(var Message: TMessage);
  function InplaceEditorFocused: boolean;
  begin
    Result := (InplaceEditor <> nil) and InplaceEditor.Focused;
  end;
begin
  try
    if FDatalink.Active then
      with FDatalink.Dataset do
        if (dgCancelOnExit in Options) and (State = dsInsert) and
          not Modified and not FDatalink.FModified then
          Cancel
        else
          FDataLink.UpdateData;
    HideClipPopup;
    DoColumnComment(MODE_HIDEWINDOW, nil);
  except
    SetFocus;
    raise;
  end;
  inherited;
  if not(Focused or InplaceEditorFocused) then InvalidateSelected;
end;

procedure TDCCustomDBGrid.CMFontChanged(var Message: TMessage);
var
  I: Integer;
begin
  inherited;
  BeginLayout;
  try
    for I := 0 to Columns.Count-1 do
      Columns[I].RefreshDefaultFont;
  finally
    EndLayout;
  end;
end;

procedure TDCCustomDBGrid.CMDeferLayout(var Message);
begin
  if AcquireLayoutLock then
    EndLayout
  else
    DeferLayout;
end;

procedure TDCCustomDBGrid.CMDesignHitTest(var Msg: TCMDesignHitTest);
var
  MasterCol: TColumn;
begin
  inherited;
  if (Msg.Result = 1) and ((FDataLink = nil) or
    ((Columns.State = csDefault) and
     (FDataLink.DefaultFields or (not FDataLink.Active)))) then
    Msg.Result := 0
  else if (Msg.Result = 0) and (FDataLink <> nil) and (FDataLink.Active)
    and (Columns.State = csCustomized)
    and PtInExpandButton(Msg.XPos, Msg.YPos, MasterCol) then
    Msg.Result := 1;
end;

procedure TDCCustomDBGrid.WMSetCursor(var Message: TWMSetCursor);
begin
  if (csDesigning in ComponentState) and
      ((FDataLink = nil) or
       ((Columns.State = csDefault) and
        (FDataLink.DefaultFields or not FDataLink.Active)))
  then
    Windows.SetCursor(LoadCursor(0, IDC_ARROW))
  else begin
    if not DataVisible then
      Windows.SetCursor(LoadCursor(0, IDC_ARROW))
    else
      inherited;
  end;
end;

procedure TDCCustomDBGrid.WMSize(var Message: TWMSize);
begin
  UpdateColWidths(-1, True);
  inherited;
  if UpdateLock = 0 then UpdateRowCount;
  InvalidateTitles;
  if not DataVisible then Invalidate;
end;

procedure TDCCustomDBGrid.WMVScroll(var Message: TWMVScroll);
var
  SI: TScrollInfo;
begin
  if not AcquireFocus and not DataVisible then Exit;
  if FDatalink.Active then
    with Message, FDataLink.DataSet do
      case ScrollCode of
        SB_LINEUP: FDataLink.MoveBy(-FDatalink.ActiveRecord - 1);
        SB_LINEDOWN: FDataLink.MoveBy(FDatalink.RecordCount - FDatalink.ActiveRecord);
        SB_PAGEUP: FDataLink.MoveBy(-VisibleRowCount);
        SB_PAGEDOWN: FDataLink.MoveBy(VisibleRowCount);
        SB_THUMBPOSITION:
          begin
            if IsSequenced then
            begin
              SI.cbSize := sizeof(SI);
              SI.fMask := SIF_ALL;
              GetScrollInfo(Self.Handle, SB_VERT, SI);
              if SI.nTrackPos <= 1 then First
              else if SI.nTrackPos >= RecordCount then Last
              else RecNo := SI.nTrackPos;
            end
            else
              case Pos of
                0: First;
                1: FDataLink.MoveBy(-VisibleRowCount);
                2: Exit;
                3: FDataLink.MoveBy(VisibleRowCount);
                4: Last;
              end;
          end;
        SB_BOTTOM: Last;
        SB_TOP: First;
      end;
end;

procedure TDCCustomDBGrid.SetIme;
var
  Column: TColumn;
begin
  if not SysLocale.FarEast then Exit;

  ImeName := FOriginalImeName;
  ImeMode := FOriginalImeMode;
  Column := Columns[SelectedIndex];
  if Column.IsImeNameStored then ImeName := Column.ImeName;
  if Column.IsImeModeStored then ImeMode := Column.ImeMode;

  if InplaceEditor <> nil then
  begin
    TDBGridInplaceEdit(Self).ImeName := ImeName;
    TDBGridInplaceEdit(Self).ImeMode := ImeMode;
  end;
end;

procedure TDCCustomDBGrid.UpdateIme;
begin
  if not SysLocale.FarEast then Exit;
  SetIme;
  SetImeName(ImeName);
  SetImeMode(Handle, ImeMode);
end;

procedure TDCCustomDBGrid.WMIMEStartComp(var Message: TMessage);
begin
  inherited;
  ShowEditor;
end;

procedure TDCCustomDBGrid.WMSetFocus(var Message: TWMSetFocus);
 var
  KeyState: TKeyboardState;
  P: TPoint;
  Cell: TGridCoord;
  lSelected: boolean;

  function InplaceEditorFocused: boolean;
  begin
    Result := (InplaceEditor <> nil) and
      (HWND(Message.FocusedWnd) = InplaceEditor.Handle);
  end;

begin
  if not InplaceEditorFocused then SetIme;
  inherited;
  if InplaceEditor = nil then MoveCol(Col, 1);

  GetKeyboardState(KeyState);
  if KeyState[VK_LBUTTON] and $80 <> 0 then
  begin
    GetCursorPos(P);
    P := ScreenToClient(P);
    Cell := MouseCoord(P.X, P.Y);
    lSelected := (RawToDataRow(Cell.Y) < 0) or (Cell.Y = Row)
  end
  else
    lSelected := True;

  if not InplaceEditorFocused and lSelected then InvalidateSelected;
end;

procedure TDCCustomDBGrid.WMKillFocus(var Message: TMessage);

  function InplaceEditorFocused: boolean;
  begin
    Result := (InplaceEditor <> nil) and
      (HWND(Message.WParam) = InplaceEditor.Handle);
  end;

begin
  if not SysLocale.FarEast then
    inherited
  else begin
    ImeName := Screen.DefaultIme;
    ImeMode := imDontCare;
    inherited;
    if not InplaceEditorFocused then
      ActivateKeyboardLayout(Screen.DefaultKbLayout, KLF_ACTIVATE);
  end;
  if ClipDown and not InplaceEditorFocused then HideClipPopup;
  if not(Focused or InplaceEditorFocused) then InvalidateSelected;
end;

{ Defer action processing to datalink }

function TDCCustomDBGrid.ExecuteAction(Action: TBasicAction): Boolean;
begin
  Result := (DataLink <> nil) and DataLink.ExecuteAction(Action);
end;

function TDCCustomDBGrid.UpdateAction(Action: TBasicAction): Boolean;
begin
  Result := (DataLink <> nil) and DataLink.UpdateAction(Action);
end;

procedure TDCCustomDBGrid.ShowPopupEditor(Column: TColumn; X, Y: Integer);
var
  SubGrid: TDCCustomDBGrid;
  DS: TDataSource;
  I: Integer;
  FloatRect: TRect;
  Cmp: TControl;
begin
  if not ((Column.Field <> nil) and (Column.Field is TDataSetField)) then  Exit;

  // find existing popup for this column field, if any, and show it
  for I := 0 to ComponentCount-1 do
    if Components[I] is TDCCustomDBGrid then
    begin
      SubGrid := TDCCustomDBGrid(Components[I]);
      if (SubGrid.DataSource <> nil) and
        (SubGrid.DataSource.DataSet = (Column.Field as TDatasetField).NestedDataset) then
      begin
        SubGrid.Parent.Show;
        SubGrid.SetFocus;
        Exit;
      end;
    end;

  // create another instance of this kind of grid
  SubGrid := TDCCustomDBGrid(TComponentClass(Self.ClassType).Create(Self));
  try
    DS := TDataSource.Create(SubGrid); // incestuous, but easy cleanup
    DS.Dataset := (Column.Field as TDatasetField).NestedDataset;
    SubGrid.DataSource := DS;
    SubGrid.Columns.State := Columns.State;
    SubGrid.Columns[0].Expanded := True;
    SubGrid.Visible := False;
    SubGrid.FloatingDockSiteClass := TCustomDockForm;
    FloatRect.TopLeft := ClientToScreen(CellRect(Col, Row).BottomRight);
    if X > Low(Integer) then FloatRect.Left := X;
    if Y > Low(Integer) then FloatRect.Top := Y;
    FloatRect.Right := FloatRect.Left + Width;
    FloatRect.Bottom := FloatRect.Top + Height;
    SubGrid.ManualFloat(FloatRect);
//    SubGrid.ManualDock(nil,nil,alClient);
    SubGrid.Parent.BiDiMode := Self.BiDiMode; { This carries the BiDi setting }
    I := SubGrid.CellRect(SubGrid.ColCount-1, 0).Right;
    if (I > 0) and (I < Screen.Width div 2) then
      SubGrid.Parent.ClientWidth := I
    else
      SubGrid.Parent.Width := Screen.Width div 4;
    SubGrid.Parent.Height := Screen.Height div 4;
    SubGrid.Align := alClient;
    SubGrid.DragKind := dkDock;
    SubGrid.Color := Color;
    SubGrid.Ctl3D := Ctl3D;
    SubGrid.Cursor := Cursor;
    SubGrid.Enabled := Enabled;
    SubGrid.FixedColor := FixedColor;
    SubGrid.Font := Font;
    SubGrid.HelpContext := HelpContext;
    SubGrid.IMEMode := IMEMode;
    SubGrid.IMEName := IMEName;
    SubGrid.Options := Options;
    Cmp := Self;
    while (Cmp <> nil) and (TDCCustomDBGrid(Cmp).PopupMenu = nil) do
      Cmp := Cmp.Parent;
    if Cmp <> nil then
      SubGrid.PopupMenu := TDCCustomDBGrid(Cmp).PopupMenu;
    SubGrid.TitleFont := TitleFont;
    SubGrid.Visible := True;
    SubGrid.Parent.Show;
  except
    SubGrid.Free;
    raise;
  end;
end;

procedure TDCCustomDBGrid.CalcSizingState(X, Y: Integer;
  var State: TGridState; var Index, SizingPos, SizingOfs: Integer;
  var FixedInfo: TGridDrawInfo);
 var
  R: TGridCoord;
  EffectiveOptions: TGridOptions;
  AWidth, i, j: integer;

  procedure CalcAxisState(const AxisInfo: TGridAxisDrawInfo; Pos: Integer;
    NewState: TGridState; Width, Frozen: integer; IsCol: boolean);
  var
    I, Line, Back, Range, J, K: Integer;
    lChecked: boolean;

    function CellVisible(I: integer; IsCol: boolean): boolean;
    begin
      if IsCol then
        Result := (GetFixedColType(I, 0) <> dcColumn) or
          (RawToDataColumn(I) < Columns.Count) and
          Columns[RawToDataColumn(I)].Visible
      else
        Result := True
    end;

  begin
    if UseRightToLeftAlignment then
      Pos := ClientWidth - Pos;
    with AxisInfo do
    begin
      Range := EffectiveLineWidth;
      Back := 0;
      if Range < 7 then
      begin
        Range := 7;
        Back := (Range - EffectiveLineWidth) shr 1;
      end;

      Line := FixedBoundary - Width;
      J := FixedCellCount - Frozen;
      K := FirstGridCell;
      for I := J to GridCellCount - 1 do
      begin
        if CellVisible(I, IsCol) then
        begin
          lChecked := (IsCol and (I < FixedCols)) or (I >= K);

          if lChecked then
          begin
            Inc(Line, GetExtent(I));
            if (Pos >= Line - Back) and (Pos <= Line - Back + Range) then
            begin
              State := NewState;
              SizingPos := Line;
              SizingOfs := Line - Pos;
              Index := I;
              Exit;
            end;
            Inc(Line, EffectiveLineWidth);
          end;
          if Line > (GridBoundary  - Back + Range)  then Break;
        end
        else
          Dec(Line, EffectiveLineWidth);
      end;
      if (GridBoundary = GridExtent) and (Pos >= GridExtent - Back)
        and (Pos <= GridExtent) then
      begin
        State := NewState;
        SizingPos := GridExtent;
        SizingOfs := GridExtent - Pos;
        Index := I;
      end;
    end;
  end;

  function XOutsideHorzFixedBoundary: Boolean;
  begin
    with FixedInfo do
      if not UseRightToLeftAlignment then
        Result := X > (Horz.FixedBoundary-AWidth)
      else
        Result := X < ClientWidth - (Horz.FixedBoundary-AWidth);
  end;

  function XOutsideOrEqualHorzFixedBoundary: Boolean;
  begin
    with FixedInfo do
      if not UseRightToLeftAlignment then
        Result := X >= (Horz.FixedBoundary-AWidth)
      else
        Result := X <= ClientWidth - (Horz.FixedBoundary-AWidth);
  end;

begin
  if FrozenCols = 0 then
    inherited CalcSizingState(X, Y, State, Index, SizingPos, SizingOfs, FixedInfo)
  else begin
    AWidth := 0;
    State := gsNormal;
    Index := -1;
    EffectiveOptions := inherited Options;
    if csDesigning in ComponentState then
      EffectiveOptions := EffectiveOptions + DesignOptionsBoost;
    if [goColSizing, goRowSizing] * EffectiveOptions <> [] then
      with FixedInfo do
      begin
        Vert.GridExtent := ClientHeight;
        Horz.GridExtent := ClientWidth;
        with Horz do
        begin
          j := FixedCols - FrozenCols;
          for i := j to FixedCols - 1 do Inc(AWidth, GetExtent(i));
        end;
        if (XOutsideHorzFixedBoundary) and (goColSizing in EffectiveOptions) then
        begin
          if Y >= Vert.FixedBoundary then Exit;
          j := FrozenCols;
          for i := 0 to Columns.Count - 1 do
          begin
            if not Columns[i].Visible and (j > FrozenCols) then
              Inc(j)
            else
              Break
          end;
          CalcAxisState(Horz, X, gsColSizing, AWidth, j, True);
        end
        else if (Y > Vert.FixedBoundary) and (goRowSizing in EffectiveOptions) then
        begin
          if XOutsideOrEqualHorzFixedBoundary then Exit;
          CalcAxisState(Vert, Y, gsRowSizing, 0, 0, False);
        end;
      end;
  end;

  with FixedInfo.Horz do
  begin
    if (State = gsColSizing) and ((FixedCols - FrozenCols) < Index) and
       (Index = LastFullVisibleCell+1) and (LeftCol >= FindicatorOffset) and
       ((Columns[LeftCol - FIndicatorOffset].Width + FixedBoundary) > GridBoundary) then
    Index := LeftCol;
  end;

  R := MouseCoord(X, Y);
  R.X := RawToDataColumn(R.X);

  if (State = gsColSizing) and (FDataLink <> nil)
    and (FDatalink.Dataset <> nil) and FDataLink.Dataset.ObjectView then
  begin
    if (R.X >= 0) and (R.X < Columns.Count) and (Columns[R.X].Depth > R.Y) then
      State := gsNormal;
  end;

  if (State = gsColSizing) and not(csDesigning in ComponentState) then
  begin
    R.X := RawToDataColumn(Index);
    if (R.X >= 0) and (R.X < Columns.Count) and not Columns[R.X].Resize then
      State := gsNormal;
  end;
  if State <> gsNormal then
  begin
    FSizingIndex := Index;
    FSizingOff := SizingOfs;
  end;

  if (State = gsRowSizing) then
  begin
    if (GridHitTest <> gtIndicator) or
      ((MouseCoord(X, Y).Y - TopRow) >= FTitleOffset) then
      State := gsNormal
  end;
end;

function TDCCustomDBGrid.CheckColumnDrag(var Origin, Destination: Integer;
  const MousePt: TPoint): Boolean;
var
  I, ARow: Integer;
  DestCol: TColumn;
begin
  Result := inherited CheckColumnDrag(Origin, Destination, MousePt);
  if Result and (FDatalink.Dataset <> nil) and FDatalink.Dataset.ObjectView then
  begin
    assert(FDragCol <> nil);
    ARow := FDragCol.Depth;
    if Destination <> Origin then
    begin
      DestCol := ColumnAtDepth(Columns[RawToDataColumn(Destination)], ARow);
      if DestCol.ParentColumn <> FDragCol.ParentColumn then
        if Destination < Origin then
          DestCol := Columns[FDragCol.ParentColumn.Index+1]
        else
        begin
          I := DestCol.Index;
          while DestCol.ParentColumn <> FDragCol.ParentColumn do
          begin
            Dec(I);
            DestCol := Columns[I];
          end;
        end;
      if (DestCol.Index > FDragCol.Index) then
      begin
        I := DestCol.Index + 1;
        while (I < Columns.Count) and (ColumnAtDepth(Columns[I],ARow) = DestCol) do
          Inc(I);
        DestCol := Columns[I-1];
      end;
      Destination := DataToRawColumn(DestCol.Index);
    end;
  end;
end;

function TDCCustomDBGrid.BeginColumnDrag(var Origin, Destination: Integer;
  const MousePt: TPoint): Boolean;
var
  I, ARow: Integer;
begin
  Result := inherited BeginColumnDrag(Origin, Destination, MousePt);
  if Result and (FDatalink.Dataset <> nil) and FDatalink.Dataset.ObjectView then
  begin
    ARow := MouseCoord(MousePt.X, MousePt.Y).Y;
    FDragCol := ColumnAtDepth(Columns[RawToDataColumn(Origin)], ARow);
    if FDragCol = nil then Exit;
    I := DataToRawColumn(FDragCol.Index);
    if Origin <> I then Origin := I;
    Destination := Origin;
  end;
end;

function TDCCustomDBGrid.EndColumnDrag(var Origin, Destination: Integer;
  const MousePt: TPoint): Boolean;
begin
  Result := inherited EndColumnDrag(Origin, Destination, MousePt);
  FDragCol := nil;
end;

procedure TDCCustomDBGrid.InvalidateTitles(AtOnce: boolean = False);
var
  R, R1: TRect;
  DrawInfo: TGridDrawInfo;
begin
  if HandleAllocated and (dgTitles in Options) and (FDatalink <> nil) and
    (FDatalink.Dataset <> nil) then
  begin
    if AtOnce then
    begin
      R := BoxRectEx(0, 0, ColCount - 1, 0);
      InvalidateRect(Handle, @R, False);
    end
    else begin
      CalcDrawInfo(DrawInfo);
      with DrawInfo.Horz do
      begin
        R1 := CellRect(LeftCol + VisibleColCount, 0);
        if AtOnce or (not IsRectEmpty(R1) and
          (FFirstGridCell > FirstGridCell)) then
        begin
          R  := Rect(R1.Left, 0, R1.Right, DrawInfo.Vert.FixedBoundary);
          InvalidateRect(Handle, @R, False);
        end;
        FFirstGridCell := FirstGridCell;
      end;
    end;
  end;
end;

procedure TDCCustomDBGrid.TopLeftChanged;
begin
  if LeftCol < FixedCols then LeftCol := FixedCols;
  InvalidateTitles;
  inherited TopLeftChanged;
end;

procedure TDCCustomDBGrid.RowHeightsChanged;
var
  i, Changed, DefaultHeight: Integer;
begin
  if not _getFlag(FFlags, DGF_ROWHEIGHTCHANGED) then
  begin
    _setFlag(FFlags, DGF_ROWHEIGHTCHANGED, True);
    Changed := -1;
    DefaultHeight := DefaultRowHeight;
    for i := Ord(dgTitles in Options) to RowCount do
      if RowHeights[i] <> DefaultHeight then
      begin
        Changed := i;
        Break;
      end;
    if Changed <> -1 then
    begin
      DefaultRowHeight := RowHeights[i];
      if FLayoutLock = 0 then InternalLayout;
      SetTitleHeight;
    end
    else begin
      SetTitleHeight;
      UpdateRowCount;
    end;
    if not(dgAutoSize in Options) then
      inherited
    else
      UpdateScrollBar;
    _setFlag(FFlags, DGF_ROWHEIGHTCHANGED, False);
  end;
end;

procedure TDCCustomDBGrid.SetFrozenCols(Value: integer);
begin
  UpdateFrozenCols(Value);
  if not(dgAutoSize in Options) then Perform(CM_SHOWINGCHANGED, 0 , 0);
end;

function  TDCCustomDBGrid.GetFrozenCols: integer;
begin
  Result := FFrozenCols;
end;

procedure TDCCustomDBGrid.SavePosition(SkipSelected: boolean = False);
 var
  lSelected: boolean;
begin
  if Assigned(DataSource) and Assigned(DataSource.DataSet) and
     Datasource.DataSet.Active and (TPrivateDataSet(DataSource.DataSet).BookmarkSize > 0)
  then begin
    with Datasource.DataSet do
    begin
      if Assigned(FCurrentPos[1].Bookmark) then
        FreeBookmark(FCurrentPos[1].Bookmark);
      if Assigned(FCurrentPos[2].Bookmark) then
        FreeBookmark(FCurrentPos[2].Bookmark);

      DisableControls;
      Prior;

      if SkipSelected then
      begin
        while not Bof and FBookmarks.CurrentRowSelected do Prior;
      end;
      if not Bof then
      begin
        FCurrentPos[1].Row := Row;
        FCurrentPos[1].Bookmark := GetBookmark;
        FCurrentPos[1].ActiveRecord := DataLink.ActiveRecord;
        Next;
      end
      else
        FCurrentPos[1].Bookmark := nil;

      lSelected := FBookmarks.Count = 0;

      if SkipSelected then
      begin
        while not Eof and (FBookmarks.CurrentRowSelected or lSelected) do
        begin
          Next;
          lSelected := False;
        end;
      end;
      if not Eof then
      begin
        FCurrentPos[2].Row := Row;
        FCurrentPos[2].Bookmark := GetBookmark;
        FCurrentPos[2].ActiveRecord := DataLink.ActiveRecord;
      end
      else
        FCurrentPos[2].Bookmark := nil;
      EnableControls;
    end;
  end;
end;

function TDCCustomDBGrid.GetPosition: TBookmark;
begin
  Result := FCurrentPos[2].Bookmark;
end;

procedure TDCCustomDBGrid.RestPosition;

 procedure LocateBookmark(BookmarkInfo: TBookmarkInfo);
  var
   ARow, BRow, i, j: integer;
 begin

   with TPrivateDataSet(DataSource.DataSet) do
   begin
     CheckBrowseMode;
     DoBeforeScroll;
     InternalGotoBookmark(BookmarkInfo.Bookmark);
     DataLink.ActiveRecord := BookmarkInfo.ActiveRecord;
     Resync([rmExact]);

     ARow := Row;
     BRow := BookmarkInfo.Row;

     if BRow > ARow then
     begin
       i := RawToDataRow(BRow); j := 0;
       while (i>0) and not FDatalink.DataSet.Bof do
       begin
         FDatalink.MoveBy(-1); inc(j); dec(i);
       end;
       if FDatalink.DataSet.Bof then Dec(j);
       FDatalink.MoveBy(j);
     end
     else begin
       if BRow < ARow then
       begin
         i := RowCount - BRow - 1; j := 0;
         while (i>0) and not FDatalink.DataSet.Eof do
         begin
           FDatalink.MoveBy(1); inc(j); dec(i);
         end;
         if FDatalink.DataSet.Eof then Dec(j);
         FDatalink.MoveBy(-j);
       end
       else begin
         FDatalink.MoveBy(-ARow + FTitleOffset);
         FDatalink.MoveBy(ARow - FTitleOffset);
       end;
     end;
     DoAfterScroll;
     if CompareBookmarks(BookmarkInfo.Bookmark, GetBookmark) <> 0 then
       GotoBookmark(BookmarkInfo.Bookmark);
   end;
 end;
begin
  if Assigned(DataSource) and Assigned(DataSource.DataSet) and
     Datasource.DataSet.Active and (TPrivateDataSet(DataSource.DataSet).BookmarkSize > 0)
  then begin
    DataSource.DataSet.DisableControls;
    if not(Assigned(FCurrentPos[2].Bookmark) and
      ValidBookmark(FCurrentPos[2].Bookmark)) then
    begin
      if Assigned(FCurrentPos[1].Bookmark) and
        ValidBookmark(FCurrentPos[1].Bookmark) then
        LocateBookmark(FCurrentPos[1])
      else
        DataSource.DataSet.First;
    end
    else
      LocateBookmark(FCurrentPos[2]);
    DataSource.DataSet.EnableControls;
  end;
end;

procedure TDCCustomDBGrid.SetPosition(const Value: TBookmark);
begin
  FCurrentPos[2].Bookmark := Value;
end;

procedure TDCCustomDBGrid.SetClipDown(const Value: boolean);
 var
   R: TRect;
begin
  if FClipDown <> Value then
  begin
    FClipDown := Value;
    if FClipPopup.ColType <> dcColumn then
    begin
      R := CellRect(GetCellByType(FClipPopup.ColType), 0);
      if GridDrawing.ClipStyle = csFlatBorder then InflateRect(R, 1, 1);
      InvalidateRect(Handle, @R, False);
    end
    else
      InvalidateCell(FClipPopup.ColumnIndex, 0);
    Update;
  end;
end;

procedure TDCCustomDBGrid.HideClipPopup;
begin
  FClipPopup.Hide;
end;

procedure TDCCustomDBGrid.ShowClipPopup(AColType: TFixedCol; ACol: integer;
  AClipPopup: TObject);
 var
  lShow: boolean;
  R: TRect;
  P: TPoint;
begin
  lShow := True;
  if ACol <> -1 then
    R := CellRect(ACol, 0)
  else
    R := CellRect(GetCellByType(AColType), 0);

  with TDBClipPopup(AClipPopup) do
  begin
    case GridDrawing.ClipStyle of
      csSingleBorder:
        begin
          PopupBorderStyle := brRaised;
          Shadow.Visible := False;
          P := Point(0, 1);
        end;
      csFlatBorder:
        begin
          PopupBorderStyle := brSingle;
          Shadow.Visible := True;
          P := Point(1, 1)
        end;
    end;
    Hide;
    ColType := AColType;
    ColType := AColType;
    ColumnIndex := ACol;
    AddButtons;

    if ColType = dcColumn then
    begin
      if Assigned(FOnClipClick) then FOnClipClick(AClipPopup, Left, Top, lShow);
      SetBoundsEx(R.Right - Width, R.Bottom - P.Y, Width, Height)
    end
    else begin
      SetBoundsEx(R.Left - P.X, R.Bottom - P.Y, Width, Height);
      if Assigned(FOnClipClick) then FOnClipClick(AClipPopup, Left, Top, lShow);
    end;

    if lShow then
    begin
      ClipDown := not ClipDown;
      if Buttons.Count > 0 then
      begin
        Show;
        if ColumnIndex <> -1 then
          ClickedCol := ColumnIndex
        else
          ClickedType := ctTitleClick;
      end
      else
        HideClipPopup;
    end
    else
      HideClipPopup;
  end;
end;

procedure TDCCustomDBGrid.CMCancelMode(var Message: TCMCancelMode);
begin
  inherited;
  if (Message.Sender <> Self) and ClipDown and
     (Message.Sender <> FClipPopup)
  then HideClipPopup;
end;

procedure TDCCustomDBGrid.WMNCLButtonDown(var Message: TWMNCLButtonDown);
begin
  inherited;
  if ClipDown then HideClipPopup;
end;

procedure TDCCustomDBGrid.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  if (BorderStyle = bsSingle) and (dgFlatButtons in Options) then
  with Params do
  begin
    if NewStyleControls and Ctl3D then
      ExStyle := ExStyle and not WS_EX_CLIENTEDGE
    else
      Style := Style and not WS_BORDER;
  end;
end;

procedure TDCCustomDBGrid.InvalidateSelected;
 var
  Rect: TRect;
begin
  if not HandleAllocated then Exit;
  if dgMultiSelect in Options then
    Invalidate
  else begin
    Rect := BoxRectEx(0, Row , ColCount-1, Row );
    InvalidateRect(Handle, @Rect, False);
  end;
  ProcessPaintMessages;
end;

procedure TDCCustomDBGrid.SetImages(const Value: TImageList);
begin
  FImages := Value;
  Invalidate;
end;

procedure TDCCustomDBGrid.DoClick(Sender: TObject);
 var
  AColType: TFixedCol;
begin
  AColType := FClipPopup.ColType;
  HideClipPopup;
  if Assigned(FOnClipButtonClick) then FOnClipButtonClick(Sender);
  if AColType = dcMarker then
  begin
    case TDCAssistButton(Sender).Pos of
      pmSelectAll:
        SelectItems(smSelect);
      pmDeselectAll:
        SelectItems(smDeselect);
    end;
  end;
end;

function TDCCustomDBGrid.SelectCell(ACol, ARow: Integer): Boolean;
 var
  OldRect, NewRect: TRect;
begin
  Result := inherited SelectCell(ACol, ARow);
  if Result and (ARow <> Row) then
  begin
    OldRect := BoxRectEx(0 , Row , ColCount-1, Row );
    NewRect := BoxRectEx(0 , ARow, ColCount-1, ARow);
    ValidateRect(Handle, @OldRect);
    InvalidateRect(Handle, @OldRect, False);
    InvalidateRect(Handle, @NewRect, False);
  end;
end;

function TDCCustomDBGrid.GetPopupMenu: TPopupMenu;
 var
  P: TPoint;
  Cell: TGridCoord;
begin
  case GridHitTest of
    gtTreeColumn, gtTreePath:
      if Assigned(FPopupTitle) then
        Result := FPopupTitle
      else
        Result := inherited GetPopupMenu;
    else
      Result := inherited GetPopupMenu;
  end;
  if Assigned(FOnPopupMenu) then
  begin
    GetCursorPos(P);
    P := ScreenToClient(P);
    Cell := MouseCoord(P.X, P.Y);
    FonPopupMenu(Self, GridHitTest, Cell, Result)
  end;
end;

procedure TDCCustomDBGrid.SetPopupTitle(const Value: TPopupMenu);
begin
  FPopupTitle := Value;
end;

function TDCCustomDBGrid.DoMouseWheelDown(Shift: TShiftState;
  MousePos: TPoint): Boolean;
 var
  MouseWheelDownEvent: TMouseWheelUpDownEvent;
begin
  Result := False;
  MouseWheelDownEvent := OnMouseWheelDown;
  if Assigned(MouseWheelDownEvent) then
    MouseWheelDownEvent(Self, Shift, MousePos, Result);

  if not Result and (DragState = dsNone) and (DataSource <> nil) and
     (DataSource.DataSet <> nil) and PtInRect(ClientRect, ScreenToClient(MousePos)) then
  begin
    NextRow(True, Shift);
    Result := True;
  end;
end;

function TDCCustomDBGrid.DoMouseWheelUp(Shift: TShiftState;
  MousePos: TPoint): Boolean;
 var
  MouseWheelUpEvent: TMouseWheelUpDownEvent;
begin
  Result := False;
  MouseWheelUpEvent := OnMouseWheelDown;
  if Assigned(MouseWheelUpEvent) then
    MouseWheelUpEvent(Self, Shift, MousePos, Result);

  if not Result and (DragState = dsNone) and (DataSource <> nil) and
     (DataSource.DataSet <> nil) and PtInRect(ClientRect, ScreenToClient(MousePos)) then
  begin
    PriorRow(True, Shift);
    Result := True;
  end;
end;

procedure TDCCustomDBGrid.DoSelection(Select: Boolean; Direction: Integer;
 Shift: TShiftState);
 var
  AddAfter: Boolean;
begin
  AddAfter := False;
  BeginUpdate;
  try
    if (dgMultiSelect in Options) and FDatalink.Active then
    begin
      if Select and (ssShift in Shift) then
      begin
        if not FSelecting then
        begin
          FSelectionAnchor := FBookmarks.CurrentRow;
          FBookmarks.CurrentRowSelected := True;
          FSelecting := True;
          AddAfter := True;
        end
        else
        with FBookmarks do
        begin
          AddAfter := Compare(CurrentRow, FSelectionAnchor) <> -Direction;
          if not AddAfter then
            CurrentRowSelected := False;
        end
      end
      else
        ClearSelection;
    end
    else if (dgMarker in Options) and FDatalink.Active then
    begin
      if Select and (ssShift in Shift) then
      begin
         FSelectionAnchor := FBookmarks.CurrentRow;
         FBookmarks.CurrentRowSelected := not FBookmarks.CurrentRowSelected;
         FSelecting := True;
         AddAfter   := False;
      end;
    end;
    FDatalink.MoveBy(Direction);
    if AddAfter then FBookmarks.CurrentRowSelected := True;
  finally
    EndUpdate;
  end;
end;

procedure TDCCustomDBGrid.NextRow(Select: Boolean; Shift: TShiftState);
begin
  if FDataLink.Active then
  begin
    with FDatalink.Dataset do
    begin
      if (State = dsInsert) and not Modified and not FDatalink.FModified then
        if FDataLink.Eof then Exit else Cancel
      else
        DoSelection(Select, 1, Shift);
      if FDataLink.Eof and CanModify and not ReadOnly and
        (dgEditing in Options) then Append;
    end;
  end;
end;

procedure TDCCustomDBGrid.PriorRow(Select: Boolean; Shift: TShiftState);
begin
  if FDatalink.Active then
  begin
    with FDatalink.Dataset do
      if (State = dsInsert) and not Modified and FDataLink.EOF and
        not FDatalink.FModified then
        Cancel
      else
        DoSelection(Select, -1, Shift);
  end;
end;

procedure TDCCustomDBGrid.ClearSelection;
begin
  if (dgMultiSelect in Options) then
  begin
    FBookmarks.Clear;
    FSelecting := False;
  end;
end;

function TDCCustomDBGrid.GetDBObject: TDCDBObject;
begin
  Result := FDBObject;
end;

procedure TDCCustomDBGrid.SetDBObject(const Value: TDCDBObject);
begin
  FDBObject.Assign(Value);
end;

function TDCCustomDBGrid.GetDataValue(Column: TColumn): string;
begin
  if Assigned(Column.Field) and
     not(DataLink.Eof and DataLink.Bof and not DataLink.Editing) then
    with Column do
    begin
      if DisplayFormat = '' then
      begin
        case Field.DataType of
          ftMemo:
            if dgeDrawMemoAsText in OptionsEx then
              Result := Field.AsString
            else
              Result := Field.DisplayText
          else
            Result := Field.DisplayText
        end
      end
      else
        try
          case Field.DataType of
            ftFloat:
              Result := Format(DisplayFormat, [Field.AsFloat]);
            ftCurrency:
              Result := Format(DisplayFormat, [Field.AsCurrency]);
            ftBCD:
              Result := Format(DisplayFormat, [Field.AsFloat]);
            ftMemo:
              if dgeDrawMemoAsText in OptionsEx then
                Result := Field.AsString
              else
                Result := Field.DisplayText;
            ftDate, ftTime, ftDateTime:
              if Field.AsDateTime <> 0 then
                DateTimeToString(Result, DisplayFormat, Field.AsDateTime)
              else
                Result := Format(DisplayFormat, [Field.DisplayText])
            else
              Result := Format(DisplayFormat, [Field.DisplayText]);
          end;
        except
          Result := Field.DisplayText
        end;
    end
  else
    Result := '';
end;

procedure TDCCustomDBGrid.DoColumnComment(Mode: integer; Column: TColumn);
begin
  if (FColumnCell <> -1) and (Mode = MODE_HIDEWINDOW) then
  begin
    if Assigned(FOnColumnComment) then FOnColumnComment(Self, Mode, Column);
    FColumnCell := -1;
  end
  else
    if Assigned(FOnColumnComment) then FOnColumnComment(Self, Mode, Column);
end;

procedure TDCCustomDBGrid.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  DoColumnComment(MODE_HIDEWINDOW, nil);
end;

procedure TDCCustomDBGrid.Paint;
 var
  DrawInfo: TGridDrawInfo;
  ARow, CurRow: integer;
  ARect, BRect: TRect;
  BorderStyle: TEdgeBorderStyle;
  ALineColor, AColor: TColor;
  UpdateRect, FooterRect: TRect;
  DefaultDrawing: boolean;
  SaveIndex: integer;
  StructLine, StructFixed: TPolyLineStruct;

  procedure DrawGridArea;
   var
    R: TRect;
  begin
    if dgFlatLines in Options then
    begin
      CreatePolyLineStruct(FGridStruct, PolySize_x15, LineColor);
      inherited Paint;
      if not IsRectEmpty(FooterRect) then
      begin
        with FooterRect do
          ExcludeClipRect(Canvas.Handle, Left, Top, Right, Bottom);
      end;
      if (dgFlatLines in Options) and EditorMode then
      begin
        R := CellRect(Col, Row);
        DrawFlatLines(R);
      end;
      PaintPolyLine(Canvas.Handle, FGridStruct);
      DestroyPolyLineStruct(FGridStruct);
    end
    else
      inherited Paint;
  end;

begin
  FooterRect := Footers.BoundsRect;
  if (dgCompleteLines in Options) and not(dgAutoSize in Options) then
  begin
    CalcDrawInfo(DrawInfo);
    SaveIndex := SaveDC(Canvas.Handle);

    UpdateRect := Canvas.ClipRect;
    with UpdateRect do
    begin
      Bottom := FooterRect.Top;
      Left  := DrawInfo.Horz.GridBoundary;
      Right := DrawInfo.Horz.GridExtent;
    end;

    if not IsRectEmpty(FooterRect) then
      with FooterRect do
        ExcludeClipRect(Canvas.Handle, Left, Top, Right, Bottom);

    with DrawInfo do
    begin
      if Horz.GridBoundary < Horz.GridExtent then
      begin
        CurRow := 0;

        BorderStyle := GetBorderStyle;

        if dgFlatLines in Options then
          ALineColor := LineColor
        else begin

          if ColorToRGB(Color) = clSilver then
            ALineColor := clGray
          else
            ALineColor := clSilver;
        end;

        if (dgRowLines in FOptions) then
        begin
          case BorderStyle of
            ebsNone, ebsFlat:
              AColor := ALineColor;
            else
              if not (dgColLines in FOptions) then
                AColor := FixedColor
              else
                AColor := clBlack;
          end;
        end
        else
          AColor := ALineColor;

        CreatePolyLineStruct(StructLine, PolySize_x16, ALineColor);
        CreatePolyLineStruct(StructFixed, PolySize_x16, AColor);

        if FTitleOffset > 0 then
        begin
          if Columns.Count > 0 then
            Canvas.Brush.Color := Columns[Columns.Count-1].Title.Color
          else
            Canvas.Brush.Color := FixedColor;
          ARect := Rect(Horz.GridBoundary, 0, Horz.GridExtent, 0);
          while CurRow < FTitleOffset do
          begin
            ARect.Bottom := ARect.Bottom + RowHeights[CurRow];
            BRect := ARect;
            InflateRect(BRect, 1, 1);
            if RectVisible(Canvas.Handle, BRect) then
            begin
              if RectVisible(Canvas.Handle, ARect) then
              begin
                Canvas.FillRect(ARect);
                if BorderStyle <> ebsNone then
                begin
                  ARect.Right := ARect.Right + 1;
                  if BorderStyle = ebsShadowFlat then
                  begin
                    InflateRect(ARect, 1, 1);
                    DrawGridFrameBorder(Canvas, ARect, BorderStyle, dsUp, FixedColor);
                    InflateRect(ARect, -1, -1);
                  end
                  else
                    DrawGridFrameBorder(Canvas, ARect, BorderStyle, dsUp, FixedColor);
                  ARect.Right := ARect.Right - 1;
                end;
              end;

              if (dgRowLines in FOptions) and not(dgFlatLines in Options) then
              begin
                with ARect do
                  AddPoint2Struct(StructFixed, Left, Bottom, Right, Bottom);
              end
            end;
            Inc(CurRow);
            if (dgRowLines in FOptions) and not(dgFlatLines in Options) then
              OffsetRect(ARect, 0, 1);
            ARect.Top := ARect.Bottom;
          end;
        end;

        if (dgRowLines in FOptions) and (dgFlatLines in Options) then
           Dec(ARect.Bottom);

        while (CurRow < Vert.GridCellCount) and
              (ARect.Top < UpdateRect.Bottom) do
        begin
          ARect.Bottom := ARect.Bottom + RowHeights[CurRow];

          if RectVisible(Canvas.Handle, ARect) and
             ((dgRowSelect in Options) or (dgHighlightRow in Options)) and
             ((dgAlwaysShowSelection in Options) or IsActiveControl) and
             FDataLink.Active then
          begin
            if (FDataLink.ActiveRecord = (CurRow-FTitleOffset)) then
            begin
              if IsActiveControl or not(dgeShadowSelection in OptionsEx) then
              begin
                Canvas.Brush.Color := clHighlight
              end
              else begin
                if dgAlwaysShowSelection in Options then
                  Canvas.Brush.Color := clShadowed;
              end;
            end
            else
              Canvas.Brush.Color := Self.Color;
          end
          else
            Canvas.Brush.Color := Self.Color;

          if Assigned(FOnDrawCompleteLine) then
          begin
            Canvas.Pen.Color := FixedColor;
            DefaultDrawing := True;
            ARow := CurRow - FTitleOffset;
            FOnDrawCompleteLine(Self, Canvas, ARect, Focused, ARow,
              DefaultDrawing);
            if DefaultDrawing then Canvas.FillRect(ARect);
            Canvas.Pen.Color := clBlack;
          end
          else
            Canvas.FillRect(ARect);

          ARect.Top    := ARect.Top - 1;
          ARect.Bottom := ARect.Bottom;

          if (dgRowLines in FOptions) and RectVisible(Canvas.Handle, ARect) then
          begin
            with ARect do
              AddPoint2Struct(StructLine, Left, Bottom, Right, Bottom);
          end;

          Inc(CurRow);
          if (dgRowLines in FOptions) and not(dgFlatLines in Options) then
            OffsetRect(ARect, 0, 1);
          ARect.Top := ARect.Bottom;
        end;
        if ARect.Top < UpdateRect.Bottom then
        begin
          BRect := ClientRect;
          if Vert.GridBoundary < Vert.GridExtent then
          begin
            ARect.Top    := Vert.GridBoundary;
            ARect.Bottom := Vert.GridExtent;
            Canvas.Brush.Color := Self.Color;
            Canvas.FillRect(ARect);
          end;
        end;

        PaintPolyLine(Canvas.Handle, StructFixed);
        PaintPolyLine(Canvas.Handle, StructLine);

        DestroyPolyLineStruct(StructFixed);
        DestroyPolyLineStruct(StructLine);
      end;
    end;
    RestoreDC(Canvas.Handle, SaveIndex);
    with UpdateRect do
      ExcludeClipRect(Canvas.Handle, Left, Top, Right, Bottom);

    DrawGridArea
  end
  else
    DrawGridArea
end;

function TDCCustomDBGrid.BoxRectEx(ALeft, ATop, ARight,
  ABottom: Integer): TRect;
begin
  Result := BoxRect(ALeft, ATop, ARight, ABottom);
  if ([dgCompleteLines, dgHighlightRow] * Options <> []) and
    (ARight = ColCount- 1) then Result.Right := Width;
end;

function TDCCustomDBGrid.CellRect(ACol, ARow: Integer): TRect;
begin
  Result := inherited CellRect(ACol, ARow);
end;

function TDCCustomDBGrid.MouseCoord(X, Y: Integer): TGridCoord;
begin
  Result := inherited MouseCoord(X, Y); 
end;

function TDCCustomDBGrid.DataVisible: boolean;
begin
  Result := (csDesigning in ComponentState) or (FDataVisible and
    (FColumns.Count <> 0) and (((DataSource <> nil) and
    (DataSource.DataSet <> nil) and (FDatalink.Fields[0] <> nil)) or
    (FColumns[0].FFieldName <> '')));
end;

procedure TDCCustomDBGrid.WMEraseBkgnd(var Message: TWmEraseBkgnd);
begin
{  inherited;  }
end;

procedure TDCCustomDBGrid.WMPaint(var Message: TWMPaint);
 var
  PS: TPaintStruct;
  EmptyMessage: string;
  R, R1: TRect;
  MBitmap, OBitmap: HBITMAP;
  MDC, DC: HDC;
  Flags: integer;
begin
  if not DataVisible then
  begin
    if Message.DC <> 0 then
    begin
      if not (csCustomPaint in ControlState) and (ControlCount = 0) then
        inherited
      else
        PaintHandler(Message);
    end
    else
    begin
      ShowScrollBar(Handle, SB_HORZ, False);
      ShowScrollBar(Handle, SB_VERT, False);
      GetWindowRect(Handle, R);  OffsetRect(R, -R.Left, -R.Top); R1 := R;
      DC := GetDC(0);
      MBitmap := CreateCompatibleBitmap(DC, R.Right, R.Bottom);
      ReleaseDC(0, DC);
      MDC := CreateCompatibleDC(0);
      OBitmap := SelectObject(MDC, MBitmap);

      try
        DC := BeginPaint(Handle, PS);
        Canvas.Handle := MDC;
        Canvas.Brush.Color := Self.Color;
        Canvas.Font := Self.Font;

        EmptyMessage := LoadStr(RES_STRN_MSG_DBGCEM);
        Flags        := DT_END_ELLIPSIS or DT_CENTER;

        if Assigned(FOnPaintEmptyMessage) then
          FOnPaintEmptyMessage(Self, Canvas, R, EmptyMessage)
        else begin
          Canvas.Lock;
          Canvas.FillRect(R);
          InflateRect(R, -5, -5);
          DrawHighLightText(Canvas, PChar(EmptyMessage), R, 1, Flags or DT_WORDBREAK);
          Canvas.UnLock;
        end;
        BitBlt(DC, 0, 0, R1.Right, R1.Bottom, MDC, 0, 0, SRCCOPY);
        EndPaint(Handle, PS);
      finally
        SelectObject(MDC, OBitmap);
        DeleteDC(MDC);
        DeleteObject(MBitmap);
        Canvas.Handle := 0;
      end;
    end;
  end
  else
    inherited;
end;

function TDCCustomDBGrid.MouseUpBeforeDblClk: boolean;
begin
  Result := True;
end;

procedure TDCCustomDBGrid.WMChar(var Msg: TWMChar);
begin
  if not DataVisible then
    Exit
  else begin
    if FClipDown then
      SendMessage(FClipPopup.Handle, WM_CHAR, Msg.CharCode,
        Msg.KeyData);
    inherited;
  end;
end;

procedure TDCCustomDBGrid.ImageListChange(Sender: TObject);
begin
  invalidate;
end;

procedure TDCCustomDBGrid.SetDataVisible(const Value: boolean);
begin
  if FDataVisible <> Value then
  begin
    FDataVisible := Value;
    invalidate;
  end;
end;

procedure TDCCustomDBGrid.WMNCCalcSize(var Message: TWMNCCalcSize);
begin
  inherited;
  if (BorderStyle = bsSingle) and (dgFlatButtons in Options) then
   InflateRect(Message.CalcSize_Params^.rgrc[0], -1, -1);
end;

procedure TDCCustomDBGrid.WMNCPaint(var Message: TMessage);
 var
  R, R1: TRect;
  DC: HDC;
  ScrollW, ScrollH: integer;
  Brush: HBRUSH;
  ScrollInfo: TScrollInfo;
  IScroll, VScroll, HScroll: boolean;
begin
  inherited;
  if (BorderStyle = bsSingle) and (dgFlatButtons in Options) then
  begin
    DC := GetWindowDC(Handle);
    Brush := CreateSolidBrush(ColorToRGB(clBtnFace));
    try
      GetWindowRect(Handle, R);  OffsetRect(R, -R.Left, -R.Top);

      ScrollInfo.cbSize := SizeOf(ScrollInfo);
      ScrollInfo.fMask := SIF_ALL;
      IScroll := GetScrollInfo(Self.Handle, SB_HORZ, ScrollInfo);
      HScroll := IScroll and (ScrollInfo.nMin <> ScrollInfo.nMax);
      IScroll := GetScrollInfo(Self.Handle, SB_VERT, ScrollInfo);
      VScroll := IScroll and (ScrollInfo.nMin <> ScrollInfo.nMax);

      if DataVisible and HScroll and VScroll then
      begin
        ScrollW := GetSystemMetrics(SM_CXVSCROLL);
        ScrollH := GetSystemMetrics(SM_CYVSCROLL);
        R1 := Rect(R.Right - ScrollW-1, R.Bottom - ScrollH-1, R.Right-1, R.Bottom-1);
        FrameRect(DC, R1, Brush);
      end;

      DrawEdge(DC, R, BDR_SUNKENOUTER, BF_TOPLEFT);
      DrawEdge(DC, R, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
    finally
      DeleteObject(Brush);
      ReleaseDC(Handle, DC);
    end;
  end;
end;

procedure TDCCustomDBGrid.WMHScroll(var Message: TWMHScroll);
begin
  if not DataVisible then Exit;
  inherited;
end;

function TDCCustomDBGrid.ValidBookmark(Bookmark: TBookmark): boolean;
begin
 try
   with TPrivateDataSet(DataSource.DataSet) do
     Result := not(Eof and Bof) and (BookmarkSize > 0);
   Result := Result and DataSource.Dataset.BookmarkValid(Bookmark)
 except
   Result := False;
 end;
end;

function TDCCustomDBGrid.GetBorderStyle: TEdgeBorderStyle;
begin
  if not((dgColLines in Options) and (dgRowLines in Options)) then
  begin
    if dgFlatButtons in Options then
      Result := ebsShadowFlat
    else
      Result := ebsNone
  end
  else begin
    if ColorToRGB(Color) = ColorToRGB(FixedColor) then
      Result := ebsNone
    else
    begin
      if dgFlatButtons in Options then
        Result := ebsFlat
      else
        Result := ebsNormal;
    end;
  end;
end;

function TDCCustomDBGrid.GroupingEnabled: boolean;
begin
  Result := False;
end;

function TDCCustomDBGrid.FlatButtons: boolean;
begin
  Result := dgFlatButtons in Options;
end;

procedure TDCCustomDBGrid.DoColumnClick(Shift: TShiftState;
  ColIndex: integer);
 var
  i: integer;
begin
  inherited;
  if (RawToDataColumn(ColIndex) < Columns.Count) then
  begin
    if Columns[RawToDataColumn(ColIndex)].Indexed then
    for i := 0 to Columns.Count-1 do
    begin
      if i = RawToDataColumn(ColIndex) then
      begin
        if Columns[i].IndexStyle < High(TColumnIndexStyle)
          then Columns[i].IndexStyle := Succ(Columns[i].IndexStyle)
          else Columns[i].IndexStyle := Pred(Columns[i].IndexStyle);
        InvalidateCell(DataToRawColumn(i),0);
      end
      else
        if not(ssShift in Shift) then
        begin
          if Columns[i].Indexed and
             (Columns[i].IndexStyle <> Low(TColumnIndexStyle))
          then begin
            Columns[i].IndexStyle := Low(TColumnIndexStyle);
            InvalidateCell(DataToRawColumn(i),0);
          end;
        end;
    end;
    TitleClick(Columns[RawToDataColumn(ColIndex)])
  end;
end;

procedure TDCCustomDBGrid.CreateCellDragImage(ACol, ARow: integer;
  var DragImages: TImageList);
 const
   DragTextOffset = 5;
 var
  ABitmap: TBitmap;
  AText: string;
  P: TPoint;
  R, ARect: TRect;
  Brush: HBRUSH;
  Struct: TPolyLineStruct;
begin
  inherited;
  if (Columns.Count > 0) and (dgeShowDragImage in FOptionsEx) then
  begin
    AText := GetDataValue(Columns[RawToDataColumn(LeftCol)]);
    if AText = '' then AText := 'Dragging Value';
    ABitmap := TBitmap.Create;

    R := Rect(0, 0, 500, 0);
    P := DrawHighLightText(Canvas, PChar(AText), R, 0, DT_LEFT);

    P.X := Columns[RawToDataColumn(LeftCol)].Width;
    Inc(P.X, DragTextOffset + DragTextOffset div 2);

    Brush := CreateSolidBrush(clDarkShadow);
    with ABitmap do
    begin
      Width  := _intMin(P.X, 200);
      if SelectedRows.Count < 1 then
        Height := _intMax(P.Y, DefaultRowHeight)
      else
        Height := _intMax(P.Y, 2 * DefaultRowHeight);

      ARect  := Rect(0, 0, Width, Height);
      Canvas.Brush.Color := clXPSelectedLight;
      Canvas.Font.Assign(Font);
      Canvas.FillRect(ARect);
      FrameRect(Canvas.Handle, ARect, Brush);

      if SelectedRows.Count < 1 then
      begin
        ARect.Top   := (ARect.Top + ARect.Bottom - P.Y) div 2;
        ARect.Left  := DragTextOffset;
        ARect.Right := ARect.Right - DragTextOffset;
        DrawHighLightText(Canvas, PChar(AText), ARect, 1,
          DT_LEFT or DT_END_ELLIPSIS);
      end
      else begin
        CreatePolyLineStruct(Struct, 10, clDarkShadow);

        ARect.Top   := (ARect.Top * 2 + DefaultRowHeight - P.Y) div 2;
        ARect.Left  := DragTextOffset;
        ARect.Right := ARect.Right - DragTextOffset;
        DrawHighLightText(Canvas, PChar(AText), ARect, 1,
          DT_LEFT or DT_END_ELLIPSIS);

        Inc(ARect.Top, DefaultRowHeight);
        Inc(R.Top, DefaultRowHeight);
        AddPoint2Struct(Struct, R.Left, R.Top, R.Right, R.Top);

        DrawBasicShape(Canvas.Handle, shArrowLeft, ARect.Right - 10,
          ARect.Bottom - 13, clBlack);

        R := Rect(0, 0, 500, 0);
        AText := Format('%d %s', [SelectedRows.Count,
          RecordCount2Str(SelectedRows.Count)]);
        P := DrawHighLightText(Canvas, PChar(AText), R, 0, DT_LEFT);

        ARect.Top   := ARect.Bottom - P.Y - 3;
        ARect.Left  := ARect.Right - P.X - 2 - 15;
        DrawHighLightText(Canvas, PChar(AText), ARect, 1,
          DT_LEFT or DT_END_ELLIPSIS);

        PaintPolyLine(Canvas.Handle, Struct);
        DestroyPolyLineStruct(Struct);
      end;
    end;
    DeleteObject(Brush);

    if DragImages = nil then
    begin
      DragImages := TImageList.CreateSize(ABitmap.Width, ABitmap.Height);
      DragImages.AddMasked(ABitmap, clFuchsia);
    end;
  end;
end;

procedure TDCCustomDBGrid.SelectItems(Mode: TSelectMode);
begin
  Update;
  case Mode of
    smSelect: FBookmarks.SelectAll;
    smDeselect: FBookmarks.Clear;
  end;
end;

function TDCCustomDBGrid.CanColResize(ACol: integer): boolean;
 var
  i: integer;
begin
  Result := inherited CanColResize(ACol);
  i := RawToDataColumn(ACol);
  if Result and (i >= 0)  and (i < Columns.Count) then
    with Columns[i] do Result := Visible and (Resize or (csDesigning in ComponentState));
end;

procedure TDCCustomDBGrid.SetOptionsEx(const Value: TDBGridOptionsEx);
 var
  ChangedOptions: TDBGridOptionsEx;
begin
  if FOptionsEx <> Value then
  begin
    ChangedOptions := (FOptionsEx + Value) - (FOptionsEx * Value);
    FOptionsEx := Value;
    if HandleAllocated then
    begin
      if [dgeMarkerMenu, dgeShadowSelection, dgeDrawMemoAsText,
        dgeIndicatorMenu] * ChangedOptions  <> [] then
      begin
        invalidate;
      end;
      if [dgeShowPartiallyVisibleData, dgeCompleteRows] * ChangedOptions  <> [] then
      begin
        UpdateRowCount;
      end;
    end;
  end;
end;

procedure TDCCustomDBGrid.CellDblClick(Column: TColumn);
begin
  if Assigned(FOnCellDblClick) then FOnCellDblClick(Column);
end;

function TDCCustomDBGrid.CreateSelectedArea: TSelectedArea;
begin
  Result := TDBSelectedArea.Create(Self, TDBSelectedItem);
end;

function TDCCustomDBGrid.GetSelectedArea: TDBSelectedArea;
begin
  Result := TDBSelectedArea(inherited GetSelectedArea);
end;

function TDCCustomDBGrid.GetGridHitTest(X, Y: integer): TGridHitTest;
 var
  Cell: TGridCoord;
 const
  AHits: array[TFixedCol] of TGridHitTest = (gtFreeArea, gtIndicator, gtMarker,
    gtTreePath, gtGridArea);
begin
  Result := inherited GetGridHitTest(X, Y);
  if Result in [gtFreeArea] then
  begin
    Cell := MouseCoord(X, Y);
    if (Cell.Y > FTitleOffset) and (Cell.X > FIndicatorOffset - FFrozenCols) then
    begin
      Result := gtGridArea;
      Exit;
    end;
    Result := AHits[GetFixedColType(Cell.X, 0)];
    if Cell.Y < FTitleOffset then
    begin
      case Result of
        gtIndicator: Result := gtMainMenu;
        gtMarker: Result := gtMarkerMenu;
        gtGridArea: Result := gtColumn;
      end;
    end;
  end;
end;

procedure TDCCustomDBGrid.StartScrollTimer(XInc, YInc: integer;
  Elapse: UINT);
begin
  YInc := 0;
  inherited;
end;

function TDCCustomDBGrid.GetFixedColType(ACol,
  AOffset: integer): TFixedCol;
 var
  i: integer;
begin
  ACol := ACol + AOffset;
  if ACol < 0 then
  begin
    Result := dcNone;
    Exit;
  end;
  Result := dcColumn;

  if (ACol >= FIndicatorOffset) then Exit;

  i := 0;
  if dgIndicator in Options then Inc(i, 2);
  if dgMarker in Options then Inc(i, 1);

  if i shr (1+ACol) > 0 then
    Result := dcIndicator
  else
    Result := dcMarker
end;

procedure TDCCustomDBGrid.WMKeyDown(var Message: TWMKeyDown);
begin
  if FClipDown then
    SendMessage(FClipPopup.Handle, WM_KEYDOWN, Message.CharCode,
      Message.KeyData);
  inherited
end;

function TDCCustomDBGrid.GetCellByType(AColType: TFixedCol): integer;
 type
   AFixedCells = dcIndicator..dcMarker;
 const
  ATypes: array[AFixedCells] of TDBGridOption = (dgIndicator, dgMarker);
 var
  j: TFixedCol;
begin
  Result := -1;
  for j := Low(ATypes) to High(ATypes) do
  begin
    if ATypes[j] in Options then Inc(Result);
    if AColType = j then Break;
  end;
end;

function TDCCustomDBGrid.RawToDataRow(ARow: integer): integer;
begin
  Result := ARow - FTitleOffset;
end;

{$IFDEF DELPHI_V5UP}
  function TDCCustomDBGrid.CanFocus: boolean;
  begin
    Result := inherited CanFocus and DataVisible;
  end;
{$ENDIF}

function TDCCustomDBGrid.GetFixedRowType(ARow,
  AOffset: integer): TFixedRow;
 var
  i: integer;
begin
  ARow := ARow + AOffset;
  if ARow < 0 then
  begin
    Result := drNone;
    Exit;
  end;
  Result := drGrid;

  if (ARow >= FTitleOffset) then Exit;

  i := 0;
  if dgTitles in Options then Inc(i, 2);

  if i shr (1 + ARow) > 0 then
    Result := drTitle
  else
    Result := drHeader;
end;

function TDCCustomDBGrid.IsActiveControl: Boolean;
begin
  Result := inherited IsActiveControl or
    ((InplaceEditor <> nil) and InplaceEditor.Focused);
end;

procedure TDCCustomDBGrid.UpdateFrozenCols(const Value: integer);
var
  FixCount, I, ACol, j, n: Integer;
  Changed: boolean;
begin
  Changed := False;
  FixCount := _intMax(Value, 0) + IndicatorOffset;
  n := 0;
  if not(csLoading in ComponentState) and (ColCount > IndicatorOffset + 1) then
  begin
    for j := 0 to Columns.Count - 1 do
    begin
      if not Columns[j].Visible and (j >= Value) then
        Inc(n)
      else
        Break
    end;
    FixCount := _intMin(FixCount + n, ColCount - 1);
    if (FFrozenCols <> Value) or (FixCount <> FixedCols) then
    begin
      ACol := Col;
      LockUpdate(True);
      try
        FixedCols := FixCount;
        Col := ACol;
      finally
        UnlockUpdate(True);
      end;
      for I := 1 to FixCount do TabStops[I] := False;
      Changed := True;
    end
  end;
  if not Changed then  FixedCols := _intMin(ColCount -1, FixCount);
  FFrozenCols := FixCount - IndicatorOffset - n;
end;

procedure TDCCustomDBGrid.SetColumnFooter(const Value: TColumnFooter);
begin
  FColumnFooter.Assign(Value);
end;

procedure TDCCustomDBGrid.SetInternalRowCount(Value: integer);
 var
  i, j: integer;
begin
  if Value <> RowCount then
  begin
    LockUpdate;
    try
      i := Col;
      j := LeftCol;
      SetInternalCol(_intMax(FixedCols, LeftCol), True);
      RowCount := Value;
      SetInternalCol(i, True);
      LeftCol := j;
    finally
      UnlockUpdate;
    end;
  end;
end;

function TDCCustomDBGrid.GetTitleMenuRect(ARect: TRect;
  var MenuRect: TRect): boolean;
begin
  MenuRect := ARect;
  if GetBorderStyle <> ebsNone then
    MenuRect.Left := _intMax(ARect.Left, ARect.Right - 8)
  else
    MenuRect.Left := _intMax(ARect.Left, ARect.Right - 7);

  if not(MenuRect.Left < MenuRect.Right) then
  begin
    SetRectEmpty(MenuRect);
    Result := False;
  end
  else
    Result := True
end;

procedure TDCCustomDBGrid.DrawTitlePopup(ACanvas: TCanvas; ARect: TRect;
  BorderState: TDrawBorerState; DrawColumn: TColumn);
 var
  X, Y: integer;
  BorderStyle: TEdgeBorderStyle;
  AColor: TColor;
  ABrush: HBRUSH;

  procedure DrawFlatBorder;
  begin
    if BorderStyle = ebsShadowFlat then
    begin
      Dec(ARect.Left);
      DrawGridFrameBorder(ACanvas, ARect, BorderStyle, BorderState,
        FixedColor);
      InflateRect(ARect, -2, -2);
    end
    else begin
      if BorderStyle = ebsNone then
      begin
        Dec(ARect.Left);
        Dec(ARect.Right);
      end
      else
        Inc(ARect.Left);
      DrawGridFrameBorder(ACanvas, ARect, BorderStyle, BorderState,
        FixedColor);
      InflateRect(ARect, -1, -1);
    end;
  end;

begin
  BorderStyle := GetBorderStyle;
  case GridDrawing.ClipStyle of
    csSingleBorder:
      DrawFlatBorder;
    csFlatBorder:
      if BorderState = dsDown then
      begin
        ABrush := CreateSolidBrush(clDarkShadow);
        InflateRect(ARect, 1, 1);
        Dec(ARect.Right);
        if not(dgRowLines in FOptions) then Dec(ARect.Right);
        FrameRect(Canvas.Handle, ARect, ABrush);
        DeleteObject(ABrush);
      end
      else
        DrawFlatBorder;
  end;

  AColor := clBlack;
  X := ARect.Left + 1;
  Y := ARect.Top + 3;
  if BorderStyle = ebsNone then Inc(X);
  if BorderState = dsDown then
  begin
    if BorderStyle <> ebsNone then
    begin
      Inc(Y);
      ABrush := CreateSolidBrush(ColorToRGB(DrawColumn.Title.Color));
    end
    else begin
      AColor := clWhite;
      ABrush := CreateSolidBrush(clXPDropDown);
      Inc(ARect.Right);
    end;
    if GridDrawing.ClipStyle = csFlatBorder then
    begin
      Inc(X, 2);
      Inc(Y, 2);
      if dgColLines in FOptions then Inc(X, 1);
      if dgRowLines in FOptions then Dec(Y, 1);
      InflateRect(ARect, -1, -1);
    end;
  end
  else
    ABrush := CreateSolidBrush(ColorToRGB(DrawColumn.Title.Color));
  FillRect(ACanvas.Handle, ARect, ABrush);
  DeleteObject(ABrush);
  DrawBasicShape(ACanvas.Handle, shDown, X, Y, AColor, szSmall);
end;

procedure TDCCustomDBGrid.SetLineColor(const Value: TColor);
begin
  if FLineColor <> Value then
  begin
    FLineColor := Value;
    invalidate;
  end;
end;

procedure TDCCustomDBGrid.GetConnectionPos(var X, Y, AWidth: integer;
  var Position: TPopupPosition);
 var
  R: TRect;
begin
  case FClipPopup.ColType of
    dcNone, dcIndicator, dcMarker, dcTreePath:
      begin
        Position := ppBottomLeft;
        R := CellRect(GetCellByType(FClipPopup.ColType), 0);
      end;
    dcColumn:
      begin
        Position := ppBottomRight;
        R := CellRect(FClipPopup.ColumnIndex, 0);
        GetTitleMenuRect(R, R);
      end;
  end;
  InflateRect(R, 1, 0);
  Dec(R.Right);
  AWidth := R.Right - R.Left;
  X := R.Left;
  Y := R.Bottom;
end;

procedure TDCCustomDBGrid.DrawFlatLines(var R: TRect);
begin
  if dgFlatLines in Options then
  begin
    with R do
    begin
      if dgRowLines in Options then
      begin
        Dec(Bottom);
        AddPoint2Struct(FGridStruct, Left, Bottom, Right, Bottom);
      end;
      if dgColLines in Options then
      begin
        Dec(Right);
        AddPoint2Struct(FGridStruct, Right, Top, Right, Bottom);
      end
    end;
    PaintPolyLine(Canvas.Handle, FGridStruct);
    FGridStruct.Index := 0;
  end;
end;

function TDCCustomDBGrid.SyncDataLinks(BufferCount: integer): boolean;
begin
  if dgeShowPartiallyVisibleData in FOptionsEx then
  begin
    Inc(BufferCount);
    FViewDataLink.BufferCount := 0;
    FViewDataLink.BufferCount := BufferCount;
    Result := FDataLink.ActiveRecord = FViewDataLink.ActiveRecord
  end
  else begin
    FViewDataLink.BufferCount := BufferCount;
    Result := True;
  end;
end;

{ TDBClipPopup }

procedure TDBClipPopup.AddButtons;
 var
  iCount: integer;
begin
  BeginUpdate;
  Clear;
  case ColType of
    dcIndicator:
      begin
        PopupStyle := cpPopupMenu;
        AddButton('#Query'   , 'DC_DBQUERY'   , LoadStr(RES_STRN_VAL_QUERY), 0, 0);
        AddButton('#Property', 'DC_DBPROPERTY', LoadStr(RES_STRN_VAL_PROP) , 0, 1);
        AddButton('#Find'    , 'DC_DBFIND'    , LoadStr(RES_STRN_VAL_FIND) , 0, 2);
        AddButton('#Print'   , 'DC_PRINT'     , LoadStr(RES_STRN_VAL_PRINT), 0, 3);
      end;
    dcMarker:
      begin
        PopupStyle := cpPopupMenu;
        AddButton('#SelectAll', 'DC_PM_SELALL', LoadStr(RES_STRN_HNT_SELALL) ,
          0, pmSelectAll);
        AddButton('#DeselectAll', 'DC_PM_DESALL', LoadStr(RES_STRN_HNT_DESALL) ,
          0, pmDeselectAll);
        AddButton('#SepLine', '', MenuLineCaption, 0, -1);
        with AddButton('#BookmarsInfo', '', '', 0, pmDeselectAll) do
        begin
          Alignment := abRight;
          if Grid.DataLink.Active then
            iCount := Grid.DataLink.DataSet.RecordCount
          else
            iCount := 0;
          Caption := Format('%d/%d %s ', [Grid.SelectedRows.Count, iCount,
            RecordCount2Str(iCount)]);
          Enabled := False;
          Images  := nil;
        end;
      end;
    dcColumn:
      begin
        PopupStyle := cpPopupMenu;
      end;
  end;
  EndUpdate;
end;

function TDBClipPopup.GetGrid: TDCCustomDBGrid;
begin
  Result := TDCCustomDBGrid(Owner);
end;

procedure TDBClipPopup.Hide;
begin
  if ColType <> dcNone then
  begin
    with Grid do
    begin
      ClickedCol := -1;
      SetClipDown(False);
    end;
    inherited;
    ColType := dcNone;
  end;
end;

{ TDBSelectedItem }

function TDBSelectedItem.CellSelected(ACol: integer; ARow: integer): boolean;

  function CheckXRange: boolean;
  begin
    Result := (ACol >= FStartCol) and (ACol <= (FStartCol + FColCount - 1));
  end;

  function CheckYRange: boolean;
   var
    OldActive: integer;
  begin
    with SelectedArea.Grid do
    begin
      OldActive := FDatalink.ActiveRecord;
      try
        FDataLink.ActiveRecord := ARow;
        Result := FSelected.CurrentRowSelected;
      finally
        FDataLink.ActiveRecord := OldActive;
      end;
    end;
  end;

begin
  Result := False;
  if not SelectedArea.DataLinkActive then Exit;
  case Style of
    csSelectCols:
      Result := CheckXRange;
    scSelectRows:
      Result := CheckYRange;
    scSelectRect:
      Result := CheckXRange and CheckYRange;
  end;
end;

constructor TDBSelectedItem.Create(Collection: TCollection;
  Cell: TGridCoord);
begin
  inherited;
  FSelected := TBookmarkList.Create(SelectedArea.Grid);
  FSelected.LinkActive(True);
  with SelectedArea.Grid do
  begin
    FSelected.SetCurrentRowSelected(True);
    FStartCol := RawToDataColumn(Cell.X);
  end;
  FColCount := 1;
  Style := scSelectRect;
end;

destructor TDBSelectedItem.Destroy;
begin
  inherited;
  FSelected.Free;
end;

function TDBSelectedItem.GetCount: integer;
begin
  Result := FSelected.Count;
end;

function TDBSelectedItem.GetItem(Index: Integer): TBookmarkStr;
begin
  Result := FSelected[Index];
end;

function TDBSelectedItem.GetSelectedArea: TDBSelectedArea;
begin
  Result := TDBSelectedArea(Collection)
end;

function TDBSelectedItem.GetSelectRgn: HRGN;
 var
  i, c, c1, Row1, Row2: integer;
  OldActive: Integer;
  R: TRect;
begin
  if SelectedArea.DataLinkActive then
  begin
    with SelectedArea.Grid do
    begin
      OldActive := FDataLink.ActiveRecord;
      try
        i := TopRow;
        c := i + VisibleRowCount + 1;
        Row1 := -1;
        Row2 := -1;
        while (i < c) and not FDataLink.Eof do
        begin
          FDataLink.ActiveRecord := RowToData(i);
          if Row1 = -1 then
            if FSelected.CurrentRowSelected then
            begin
              Row1 := i;
              Row2 := i;
            end
            else
          else
            if FSelected.CurrentRowSelected then
              Row2 := i
            else
              Break;
          Inc(i);
        end;
      finally
        FSelected.StringsChanged(nil);
        FDataLink.ActiveRecord := OldActive;
      end;
      if (Row1 <> -1) and (Row2 <> -1) then
      begin
        c1 := FStartCol + FindicatorOffset;
        R := BoxRect(c1, Row1, c1 + FColCount -1, Row2);
        Result := CreateRectRgnIndirect(R)
      end
      else
        Result := CreateEmptyRgn;
    end;
  end
  else
    Result := CreateEmptyRgn;
end;

function TDBSelectedItem.RowToData(ARow: integer): integer;
begin
  Result := ARow - SelectedArea.Grid.FTitleOffset;
end;

procedure TDBSelectedItem.Select(IncX, incY: integer;
  var Cell: TGridCoord);
 var
  Rgn1, Rgn2: HRGN;
  OldActive, i: Integer;

  function GetInc(var IncValue: integer): integer;
  begin
    if IncValue <> 0 then
    begin
      if IncValue > 0 then Result := 1 else Result := -1;
      Dec(IncValue, Result);
    end
    else
      Result := 0;
  end;

  procedure DoSelect(IncX, incY: integer);
   var
    UpdateCell: boolean;
  begin
    with SelectedArea.Grid, FSelected do
    begin
      UpdateCell := True;
      if IncX > 0 then
      begin
        if FStartCol < RawToDataColumn(Col) then
        begin
          Inc(FStartCol);
          Dec(FColCount);
          if FColCount = 0 then FColCount := 1;
        end
        else
          Inc(FColCount);
        if UpdateCell then Inc(Cell.X);
      end
      else if IncX < 0 then
      begin
        if (FStartCol = RawToDataColumn(Col)) and (FColCount > 1) then
          Dec(FColCount)
        else begin
          Inc(FColCount);
          Dec(FStartCol);
        end;
        if UpdateCell then Dec(Cell.X);
      end;

      FDataLink.ActiveRecord := RowToData(Row);
      if IncY > 0 then
      begin
        if Count > 0 then
        begin
          if Row <= Cell.Y then
          begin
            FDataLink.ActiveRecord := RowToData(Cell.Y + 1);
            FSelected.SetCurrentRowSelected(True);
          end
          else begin
            FDataLink.ActiveRecord := RowToData(Cell.Y);
            FSelected.SetCurrentRowSelected(False);
          end;
        end
        else
          FSelected.SetCurrentRowSelected(True);
        if UpdateCell then Inc(Cell.Y);
      end
      else if (IncY < 0) and (RowToData(Cell.Y) > 0) then
      begin
        if Count > 0 then
        begin
          if Row >= Cell.Y then
          begin
            FDataLink.ActiveRecord := RowToData(Cell.Y - 1);
            FSelected.SetCurrentRowSelected(True);
          end
          else begin
            FDataLink.ActiveRecord := RowToData(Cell.Y);
            FSelected.SetCurrentRowSelected(False);
          end
        end
        else
          FSelected.SetCurrentRowSelected(True);
        if UpdateCell then Dec(Cell.Y);
      end;

    end;
  end;
begin
  if not SelectedArea.DataLinkActive then Exit;

  if SelectedArea.UpdateCount = 0 then
    Rgn1 := GetSelectRgn
  else
    Rgn1 := NULLREGION;

  with SelectedArea.Grid do
  begin
    OldActive := FDataLink.ActiveRecord;
    try
      while (IncX <> 0) or (IncY <> 0) do DoSelect(GetInc(IncX), GetInc(IncY));
    finally
      FDataLink.ActiveRecord := OldActive;
    end;
  end;

  if SelectedArea.UpdateCount = 0 then
  begin
    Rgn2 := GetSelectRgn;
    i := CombineRgn(Rgn1, Rgn1, Rgn2, RGN_XOR);
    try
      if i <> NULLREGION then
      begin
        InvalidateRgn(SelectedArea.Grid.Handle, Rgn1, False);
      end;
    finally
      DeleteObject(Rgn1);
      DeleteObject(Rgn2);
    end;
  end;

end;

{ TDBSelectedArea }

function TDBSelectedArea.CellSelected(ACol: integer; ARow: integer): boolean;
 var
  i: integer;
begin
  i := 0;
  Result := False;
  while not Result and (i < Count) do
  begin
    Result := Items[i].CellSelected(ACol, ARow);
    Inc(i)
  end;
end;

function TDBSelectedArea.DataLinkActive: boolean;
begin
  Result := Assigned(Grid.DataLink) and Grid.DataLink.Active;
end;

function TDBSelectedArea.GetGrid: TDCCustomDBGrid;
begin
  Result := TDCCustomDBGrid(inherited GetGrid);
end;

function TDBSelectedArea.GetItem(Index: Integer): TDBSelectedItem;
begin
  Result := TDBSelectedItem(inherited GetItem(Index));
end;

procedure TDBSelectedArea.SetItem(Index: Integer;
  const Value: TDBSelectedItem);
begin
  inherited SetItem(Index, Value);
end;

{ TDCPopupDBGrid }

procedure TDCCustomPopupDBGrid.AdjustNewHeight;
var
  DC: HDC;
  SaveFont: HFONT;
  Metrics: TTextMetric;
begin
  DC := GetDC(0);
  SaveFont := SelectObject(DC, Font.Handle);
  try
    GetTextMetrics (DC, Metrics);
    FItemHeight := Metrics.tmHeight;
    if dgRowLines in Options then
      FItemHeight := FItemHeight + 5
    else
      FItemHeight := FItemHeight + 3;
  finally
    SelectObject(DC, SaveFont);
    ReleaseDC(0, DC);
  end;
end;

constructor TDCCustomPopupDBGrid.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FVisible    := False;
  ControlStyle := ControlStyle + [csNoDesignVisible, csReplicatable,
                                  csAcceptsControls];

  Visible := False;

  Canvas.Brush.Style := bsClear;
  FAlwaysVisible := True;
  FOwner := TControl(AOwner);
  Font   := TPrivateControl(AOwner).Font;
  TitleFont := Self.Font;

  SetRectEmpty(FWindowRect);
  SetRectEmpty(FMargins);
  FDropDownRows := 8;

  FDataSource := TDataSource.Create(Self);
  FDataSource.DataSet := FDataSet;
  DataSource  := FDataSource;
  AdjustNewHeight;

  {Special Grid properies}

  BorderStyle := bsNone;
  Options := Options + [dgRowSelect, dgAlwaysShowSelection, dgHighlightRow,
    dgTitleClicked, dgCompleteLines, dgFlatButtons, dgFlatLines];
  Options := Options - [dgIndicator, dgRowLines];
  OptionsEx := OptionsEx + [dgeShowPartiallyVisibleData, dgeCompleteRows];
  ScrollBars  := ssNone;
  FCursorMode := cmNone;

  FButtons := TDCEditButtons.Create(Self);
  FButtons.AnchorStyle := asBL;
  FButtons.Color := clBtnFace;
  FButtons.Options := FButtons.Options - [boNCPainting];

  FPopupOptions := [pgShowHeader];
  FDrawingStyle := dtXPStyle; //dtNormal;

  OnPaintEmptyMessage := PaintEmptyMessage;
end;

procedure TDCCustomPopupDBGrid.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do
  begin
    ExStyle := WS_EX_TOOLWINDOW or WS_EX_TOPMOST;
    AddBiDiModeExStyle(ExStyle);
  end;
end;

procedure TDCCustomPopupDBGrid.CreateWnd;
 var
  LeftPos: integer;
  AButton: TDCEditButton;
begin
  inherited CreateWnd;

  if Parent <> nil then
  begin
    Windows.SetParent(Handle, 0);
    CallWindowProc(DefWndProc, Handle, WM_SETFOCUS, 0, 0);
    SetMargins;

    FButtons.SetWndProc;

    if pgShowHeader in FPopupOptions then
    begin
      LeftPos := 4;
      FButtons.Clear;

      if pgCanAppend in FPopupOptions then
      begin
        AButton := FButtons.AddButton;
        with AButton do
        begin
          Name := '#Append';
          Alignment  := abLeft;
          AnchorStyle := asBL;
          Font     := Self.Font;
          Color   := Self.Color;
          DrawText := False;
          Glyph.LoadFromResourceName(HInstance, 'DC_SBTNNEW');
          Caption := 'Append';

          SetBounds(Rect(LeftPos, Self.Height-br_FooterHeight-5,
            Glyph.Width + 5, br_FooterHeight+3));

          DisableStyle := deNormal;
          Style   := stSingle;
          Options := Options + [boFrame];
          Enabled := True;
          Visible := False;
          Tag     := BTAG_EV_APPEND;
          OnClick := DoButtonClick;
          OnDrawHint := DoDrawHint;
        end;
        LeftPos := LeftPos + AButton.Width;
      end;

      AButton := FButtons.AddButton;
      with AButton do
      begin
        Name := '#Refresh';
        Alignment  := abLeft;
        AnchorStyle := asBL;
        Font     := Self.Font;
        Color   := Self.Color;
        DrawText := False;
        Glyph.LoadFromResourceName(HInstance, 'DC_SBTNREFRESH');
        Caption := 'Refresh';

        SetBounds(Rect(LeftPos, Self.Height-br_FooterHeight-5,
          Glyph.Width + 5, br_FooterHeight+3));

        DisableStyle := deNormal;
        Style   := stSingle;
        Options := Options + [boFrame];
        Enabled := True;
        Visible := False;
        Tag     := BTAG_EV_REFRESH;
        OnClick := DoButtonClick;
        OnDrawHint := DoDrawHint;
      end;
      LeftPos := LeftPos + AButton.Width;

      AButton := FButtons.AddButton;
      with AButton do
      begin
        Name := '#Sep_1';
        Alignment  := abImageTop;
        AnchorStyle := asBL;
        Font     := Self.Font;
        Glyph.LoadFromResourceName(HInstance, 'DC_DELIMITER');

        SetBounds(Rect(LeftPos, Self.Height-br_FooterHeight-5,
          8, br_FooterHeight+3));

        DisableStyle := deNone;
        Style := stNone;
        Enabled := False;
        Visible := False;
        Options :=  Options - [boSelectable];
        DrawText:= False;
        Tag := -1;
        OnDrawHint := DoDrawHint;
      end;
      LeftPos := LeftPos + AButton.Width;

      FFindButton := FButtons.AddButton;
      with FFindButton do
      begin
        Name := '#SearchText';
        Alignment := abLeft;
        AnchorStyle := asBLR;
        Font := Self.Font;
        Color := Self.Color;
        Options :=  Options - [boSelectable];
        Glyph.LoadFromResourceName(HInstance, 'DC_SBTNFILTER');
        Caption := '';

        SetBounds(Rect(LeftPos, Self.Height-br_FooterHeight-5,
          Self.Width - LeftPos - 2*FBorderSize - 45,
          br_FooterHeight+3));

        DisableStyle := deNormal;
        Style   := stNone;
        Enabled := False;
        Visible := False;
        Tag     := BTAG_EV_FILTER;
        OnClick := DoButtonClick;
      end;
      LeftPos := LeftPos + FFindButton.Width;

      FScrollLeft := FButtons.AddButton;
      with FScrollLeft do
      begin
        Name := '#ScrollLeft';
        Alignment  := abCenter;
        AnchorStyle := asBR;
        Font     := Self.Font;
        Color   := Self.Color;
        DrawText := False;
        Glyph.LoadFromResourceName(HInstance, 'DC_BTNLEFT');
        Caption := 'ScrollLeft';

        SetBounds(Rect(LeftPos, Self.Height-br_FooterHeight-5, 14, br_FooterHeight+3));

        DisableStyle := deNormal;
        Style   := stSingle;
        Options := Options + [boSimpleStyle, boFrame];
        Enabled := False;
        Visible := False;
        Tag     := BTAG_EV_LSCROLL;
        OnClick := DoScroll;
        OnDrawHint := DoDrawHint;
      end;
      LeftPos := LeftPos + FScrollLeft.Width;

      FScrollRight := FButtons.AddButton;
      with FScrollRight do
      begin
        Name := '#ScrollRight';
        Alignment  := abCenter;
        AnchorStyle := asBR;
        Font     := Self.Font;
        Color   := Self.Color;
        DrawText := False;
        Glyph.LoadFromResourceName(HInstance, 'DC_BTNRIGHT');
        Caption := 'ScrollRight';

        SetBounds(Rect(LeftPos, Self.Height-br_FooterHeight-5, 14, br_FooterHeight+3));

        DisableStyle := deNormal;
        Style   := stSingle;
        Options := Options + [boSimpleStyle, boFrame];
        Enabled := False;
        Visible := False;
        Tag     := BTAG_EV_RSCROLL;
        OnClick := DoScroll;
        OnDrawHint := DoDrawHint;
      end;

      AButton := FButtons.AddButton;
      with AButton do
      begin
        Name := '#Close';
        Alignment := abCenter;
        AnchorStyle := asTR;
        BrushColor := clBtnShadow;
        DrawText := False;
        Glyph.LoadFromResourceName(HInstance, 'DC_BTNCLOSE');

        SetBounds(Rect(Self.Width - 18, 2, 15, br_HeaderHeight));

        DisableStyle := deNormal;
        Style := stSingle;
        Options := Options + [boFrame];
        Enabled := True;
        Visible := False;
        Tag     := BTAG_EV_CLOSE;
        OnClick := DoButtonClick;
      end;

      AButton := FButtons.AddButtonEx(TDCComboButton);
      with AButton do
      begin
        Name := '#Popupmenu';
        Alignment := abCenter;
        AnchorStyle := asTR;
        Font := Self.Font;
        BrushColor := clBtnShadow;
        EventStyle := esDropDown;
        DrawText := False;
        Glyph.LoadFromResourceName(HInstance, 'DC_BTNDOWN');

        SetBounds(Rect(Self.Width - 33, 2, 15, br_HeaderHeight));

        DisableStyle := deNormal;
        Style := stSingle;
        Options := Options + [boFrame];
        Enabled := True;
        Visible := False;
        Tag     := BTAG_EV_POPUP;
        OnClick := DoButtonClick;
      end;

    end;
  end;
end;

procedure TDCCustomPopupDBGrid.Hide;
begin
  HideWindow(Handle);
  FVisible := False;
end;

procedure TDCCustomPopupDBGrid.RedrawBorder;
 var
  R: TRect;
begin
  DrawPopupBorder(Self, 0, R, FPopupBorderStyle, FDrawingStyle);
end;

procedure TDCCustomPopupDBGrid.SetPopupBorderStyle(Value: TPopupBorderStyle);
begin
  if FPopupBorderStyle <> Value then
  begin
    FPopupBorderStyle := Value;
    case FPopupBorderStyle of
      brNone  :FBorderSize := 0;
      brSingle:FBorderSize := 1;
      brRaised:FBorderSize := 2;
    end;
    RecreateWnd;
  end;
end;

procedure TDCCustomPopupDBGrid.SetBounds(ALeft, ATop, AWidth, AHeight: Integer);
begin
  if AHeight < FItemHeight * 5 then AHeight := FItemHeight * 5;
  if AWidth  < 80 then AWidth  := 80;
  inherited;
  FWindowRect := Rect(Left,Top,Left+Width,Top+Height);
end;

procedure TDCCustomPopupDBGrid.SetBoundsEx(ALeft, ATop, AWidth,
  AHeight: Integer);
begin
  FWindowRect := Rect(ALeft,ATop,ALeft+AWidth,aTop+AHeight);
  if FVisible then Show;
end;

procedure TDCCustomPopupDBGrid.SetPopupAlignment(Value: TWindowAlignment);
begin
  if Value <> FPopupAlignment then
  begin
    FPopupAlignment := Value;
    if Visible then Show;
  end;
end;

procedure TDCCustomPopupDBGrid.Show;
begin
  SetMargins;
  Height := FItemHeight*FDropDownRows + RowHeights[0] + 2*FBorderSize +
    FMargins.Top + FMargins.Bottom;
  ShowWindow(Handle, FPopupAlignment, FWindowRect, FAlwaysVisible, Owner);
  FVisible  := True;
  CheckRefreshButton;
  UpdateHScrolls;
end;

procedure TDCCustomPopupDBGrid.WMMouseActivate(var Message: TWMActivate);
begin
  inherited;
  Message.Result := MA_NOACTIVATE;
  SetWindowPos (Handle, HWND_TOP, 0, 0, 0, 0,
    SWP_NOACTIVATE or SWP_NOMOVE or SWP_NOSIZE);
end;

procedure TDCCustomPopupDBGrid.WMNCCalcSize(var Message: TWMNCCalcSize);
begin
  case FPopupBorderStyle of
    brNone  :FBorderSize := 0;
    brSingle:
      begin
        FBorderSize := 2;
        InflateRect(Message.CalcSize_Params^.rgrc[0], -2, -2);
      end;
    brRaised:
      begin
        FBorderSize := 2;
        InflateRect(Message.CalcSize_Params^.rgrc[0], -2, -2);
      end;
  end;
  with Message.CalcSize_Params^.rgrc[0] do
  begin
    Top    := Top    + FMargins.Top;
    Left   := Left   + FMargins.Left;
    Bottom := Bottom - FMargins.Bottom;
    Right  := Right  - FMargins.Right;
  end;
  inherited;
end;

procedure TDCCustomPopupDBGrid.WMNCPaint(var Message: TWMNCPaint);
begin
  inherited;
  RedrawBorder;
end;

procedure TDCCustomPopupDBGrid.SetDataSet(const Value: TDataSet);
begin
  FDataSet := Value;
  FDataSource.DataSet := FDataSet;
  CheckRefreshButton;
end;

function TDCCustomPopupDBGrid.HighlightCell(DataCol, DataRow: Integer;
  const Value: string; AState: TGridDrawState): Boolean;
begin
  Result :=  inherited HighlightCell(DataCol, DataRow, Value, AState);
end;

procedure TDCCustomPopupDBGrid.WMFontChange(var Message: TWMFontChange);
 var
  i: integer;
begin
  inherited;
  AdjustNewHeight;
  for i := 0 to FButtons.Count-1 do
    FButtons.Buttons[i].Font := Font;
end;

procedure TDCCustomPopupDBGrid.WMNCHitTest(var Message: TWMNCHitTest);
 var
  R, WindowR: TRect;
  BS: Integer;
  Button: TDCEditButton;
 function InCaptArea(XPos, YPos: integer): boolean;
 begin
   R := WindowR;
   InflateRect(R, -BS, -BS);
   R.Bottom := R.Top + br_HeaderHeight;
   Result := PtInRect(R, Point(XPos, YPos));
 end;
 function InSizeArea(XPos, YPos: integer): boolean;
 begin
   R := WindowR;
   InflateRect(R, -BS, -BS);
   R.Top  := R.Bottom - br_FooterHeight;
   R.Left := R.Right  - br_SizerWidth;
   Result := PtInRect(R, Point(XPos, YPos));
 end;
 function InGridArea(XPos, YPos: integer): boolean;
 begin
   R := WindowR;
   InflateRect(R, -BS, -BS);
   R.Left   := R.Left   + FMargins.Left;
   R.Top    := R.Top    + FMargins.Top;
   R.Right  := R.Right  - FMargins.Right;
   R.Bottom := R.Bottom - FMargins.Bottom;
   Result := PtInRect(R, Point(XPos, YPos));
 end;
 function InButtonsArea(XPos, YPos: integer): boolean;
  var
   P: TPoint;
 begin
   P.X := XPos - Left;
   P.Y := YPos - Top;
   Result := FButtons.MouseInButtonArea(P.X, P.Y, Button);
   R := WindowR;
   InflateRect(R, -BS, -BS);
 end;
 function InFooterArea(XPos, YPos: integer): boolean;
 begin
   R := WindowR;
   InflateRect(R, -BS, -BS);
   R.Top  := R.Bottom - br_FooterHeight;
   Result := PtInRect(R, Point(XPos, YPos));
 end;
begin
  inherited;
  if not(pgShowHeader in FPopupOptions) then
  begin
    FCursorMode := cmGrid;
    Exit;
  end;

  FCursorMode := cmNone;
  BS := FBorderSize;
  GetWindowRect(Handle, WindowR);
  with Message do
  begin
    if InCaptArea(XPos, YPos) then
    begin
      FCursorMode := cmMove;
      Result := HTBORDER;
    end;

    if InFooterArea(XPos, YPos) then
    begin
      FCursorMode := cmFooter;
      Result := HTBORDER;
    end;

    if InSizeArea(XPos, YPos) then
    begin
      FCursorMode := cmResize;
      Result := HTSIZE;
    end;

    if InGridArea(XPos, YPos) then FCursorMode := cmGrid;

    if InButtonsArea(XPos, YPos) then
    begin
      FCursorMode := cmButtons;
      Result := HTBORDER;
    end;
  end;
end;

procedure TDCCustomPopupDBGrid.SetParent(AParent: TWinControl);
begin
  inherited;
  if (AParent <> nil) and (AParent.Parent <> nil) and
     (AParent is TDCCustomChoiceEdit)
  then begin
    Caption := TDCCustomChoiceEdit(AParent).DBObject.Caption;
  end;
end;

procedure TDCCustomPopupDBGrid.DrawFooter;
 var
  DC: HDC;
  R: TRect;
  Bitmap: TBitmap;
begin
  if not(pgShowHeader in FPopupOptions) then Exit;
  DC := GetWindowDC(Handle);
  Bitmap := TBitmap.Create;
  try
    FButtons.UpdateDeviceRegion(DC);
    GetWindowRect (Handle, R); OffsetRect (R, -R.Left, -R.Top);
    InflateRect(R, -2, -2);
    Bitmap.LoadFromResourceName(HInstance, 'DC_BTNSIZE');
    R.Top := R.Bottom - br_FooterHeight - 4;
    FillRect(DC, R,  GetSysColorBrush(COLOR_BTNFACE));

    R.Left := R.Right-Bitmap.Width-2;
    R.Top  := R.Bottom-Bitmap.Height-2;
    DrawTransparentBitmap(DC, Bitmap, R, False, Bitmap.Canvas.Pixels[0,0]);
  finally
    Bitmap.Free;
    ReleaseDC(Handle, DC);
  end;
end;

procedure TDCCustomPopupDBGrid.DrawHeader(const DC: HDC; var R: TRect);
begin
  FButtons.UpdateDeviceRegion(DC);
  if pgShowHeader in FPopupOptions then
     DrawPopupHeader(Self, DC, R, FPopupBorderStyle, FDrawingStyle);
end;

procedure TDCCustomPopupDBGrid.WMSetCursor(var Message: TWMSetCursor);
begin
  case FCursorMode of
    cmNone   : SetCursor(Screen.Cursors[crArrow]);
    cmResize : SetCursor(Screen.Cursors[crSizeNWSE]);
    cmMove   : SetCursor(Screen.Cursors[crArrow]);
    cmButtons: SetCursor(Screen.Cursors[crArrow]);
    cmFooter : SetCursor(Screen.Cursors[crArrow]);
    cmGrid   : inherited;
  end;
end;

procedure TDCCustomPopupDBGrid.WMNCLButtonDown(var Message: TWMNCLButtonDown);
begin
  inherited;
  with Message do
  begin
    case FCursorMode of
      cmResize, cmMove: BeginMoving(XCursor, YCursor);
    end;
  end;
end;

procedure TDCCustomPopupDBGrid.BeginMoving(XCursor, YCursor: integer);
begin
  ProcessMovingWindow(Self, XCursor, YCursor, FCursorMode, FItemHeight);
end;

procedure TDCCustomPopupDBGrid.SetMargins;
begin
  FMargins := Rect(4,4,4,2);
  if not(pgShowHeader in FPopupOptions) then Exit;

  case FPopupBorderStyle of
    brNone  :;
    brSingle:;
    brRaised:
      begin
        // Margins.Properties
        FMargins.Top  := FMargins.Top + br_HeaderHeight;
        FMargins.Bottom := FMargins.Bottom + br_FooterHeight + 4;
      end;
  end;
end;

destructor TDCCustomPopupDBGrid.Destroy;
begin
  Destroying;
  FreeAndNil(FDataSource);
  FreeAndNil(FButtons);
  inherited;
end;

procedure TDCCustomPopupDBGrid.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  if Assigned(FButtons) then
    FButtons.MouseDown := GetAsyncKeyState(VK_LBUTTON) < 0;
end;

procedure TDCCustomPopupDBGrid.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  if Assigned(FButtons) then
    FButtons.UpdateButtons( -1, -1, False, True);
end;

procedure TDCCustomPopupDBGrid.WMPaint(var Message: TWMPaint);
begin
//  FButtons.UpdateDeviceRegion(Message.DC);
  inherited;
  if Assigned(FButtons) then InvalidateButtons;
end;

procedure TDCCustomPopupDBGrid.KeyDown(var Key: Word; Shift: TShiftState);
begin
  inherited;
  case Key of
    VK_LEFT :
      begin
        if ssCtrl in Shift then
          SetBounds(Left-POPUP_MOVE_STEPX, Top, Width, Height);
      end;
    VK_RIGHT:
      begin
        if ssCtrl in Shift then
          SetBounds(Left+POPUP_MOVE_STEPX, Top, Width, Height);
      end;
    VK_UP   :
      begin
        if ssCtrl in Shift then
          SetBounds(Left, Top-POPUP_MOVE_STEPY, Width, Height);
      end;
    VK_DOWN :
      begin
        if ssCtrl in Shift then
          SetBounds(Left, Top+POPUP_MOVE_STEPY, Width, Height);
      end;
  end;
end;

procedure TDCCustomPopupDBGrid.DoButtonClick(Sender: TObject);
 var
  ACursor: TCursor;
begin
  if Assigned(FOnButtonClick) then FOnButtonClick(Sender);
  case TDCEditButton(Sender).Tag of
    BTAG_EV_REFRESH{Refresh}:
      if FDataSet <> nil  then
      begin
        ACursor := Screen.Cursor;
        Screen.Cursor := crHourGlass;
        try
          SavePosition;
          FDataSet.DisableControls;
          try
            {$IFDEF DELPHI_V5UP}
            if GetPropValue(FDataSet, 'TableName', False) <> null then
            {$ELSE}
            if False then
            {$ENDIF}
              FDataSet.Refresh
            else begin
              FDataSet.Close;
              FDataSet.Open;
            end;
          except
            on E: Exception do
            begin
              if Assigned(FOwner) and (FOwner is TDCCustomEdit) then
              begin
                TDCCustomEdit(FOwner).ErrorCode := ERR_GRID_EXCEPTONREFRESH;
                TDCCustomEdit(FOwner).ErrorHint := E.Message;
                TDCCustomEdit(FOwner).ShowErrorMessage;
              end;
            end;
          end;
        finally
          FDataSet.EnableControls;
          RestPosition;
          Screen.Cursor := ACursor;
        end;
      end;
    BTAG_EV_APPEND{New}:
      if Assigned(FOwner) and (FOwner is TDCCustomGridEdit) then
        PostMessage(TWinControl(FOwner).Handle, CM_APPENDRECORD, 0, 0);
    BTAG_EV_CLOSE{Close}:
      if Assigned(FOwner) and (FOwner is TDCCustomGridEdit) then
        PostMessage(TWinControl(FOwner).Handle, CM_POPUPBUTTONCLK,
          Integer(Sender), 0);
  end;
end;

procedure TDCCustomPopupDBGrid.WMSize(var Message: TWMSize);
begin
  inherited;
  if dgAutoSize in Options then
    invalidate
  else
    if Assigned(FButtons) then InvalidateButtons;
  UpdateHScrolls;
end;

procedure TDCCustomPopupDBGrid.InvalidateButtons;
 var
  i, RightPos, r: integer;
  Button: TDCEditButton;
  Changed: boolean;
begin
  if csDestroying in ComponentState then Exit;
  RightPos := Width - FBorderSize;
  Changed  := False;
  for i := 0 to FButtons.Count-1 do
  begin
    Button := FButtons.Buttons[i];
    if Button.AnchorStyle in [asBL, asBR, asBLR] then
      r := RightPos - br_SizerWidth -3
    else
      r := RightPos;
    if (Button.Left + Button.Width) > r then
    begin
      if Button.Visible then
      begin
        Button.Visible := False;
        Changed := True;
      end
    end
    else
      if not Button.Visible then
      begin
        Button.Visible := True;
        Changed := True;
      end;
  end;

  if Changed then SendMessage(Self.Handle, WM_NCPAINT, 0, 0);
end;

procedure TDCCustomPopupDBGrid.StartSearch(Key: Char; AValue: string = '');
 var
  ASearch: string;
  ACursor:TCursor;
begin
  KillTimer(Handle, SRCTIMER_IDEVENT);
  FFindButton.Enabled := True;

  ACursor := Screen.Cursor;
  Screen.Cursor := crHourGlass;
  if AValue = '' then
  begin
    case Key of
      #8:
        begin
          ASearch := FFindButton.Caption;
          ASearch := Copy(ASearch, 1, Length(ASearch)-1);
        end;
      else
        ASearch := FFindButton.Caption + Key;
    end;
  end
  else
    ASearch := AValue;
    
  try
    LocateRecord(ASearch);
  except
    ASearch := FFindButton.Caption;
  end;

  FFindButton.Caption := ASearch;
  FFindButton.Invalidate;
  Screen.Cursor := ACursor;
  SetTimer(Handle, SRCTIMER_IDEVENT, 2000, nil);
end;

procedure TDCCustomPopupDBGrid.StopSearch;
begin
  FFindButton.Enabled := False;
  FFindButton.Caption := '';
  FFindButton.Invalidate;
  KillTimer(Handle, SRCTIMER_IDEVENT)
end;

procedure TDCCustomPopupDBGrid.KeyPress(var Key: Char);
begin
  inherited;
  StartSearch(Key);
end;

procedure TDCCustomPopupDBGrid.WMTimer(var Message: TWMTimer);
begin
  inherited;
  case Message.TimerID of
    SRCTIMER_IDEVENT: StopSearch;
    SLLTIMER_IDEVENT:
      begin
        if FScrollLeft.ButtonState  = btDownMouseInRect then DoScroll(FScrollLeft);
        if FScrollRight.ButtonState = btDownMouseInRect then DoScroll(FScrollRight);
        if FScrollTimer <> 0 then
        begin
          KillTimer(Handle, FScrollTimer);
          FScrollTimer := SetTimer(Handle, SLLTIMER_IDEVENT, 200, nil);
        end;
      end;
  end;
end;

procedure TDCCustomPopupDBGrid.DoDrawHint(Sender: TObject; Mode: Integer);
begin
  {}
end;

procedure TDCCustomPopupDBGrid.CheckRefreshButton;
 var
  Button: TDCEditButton;
begin
  Button := FButtons.FindButton('#Refresh');
  if Button <> nil then
  begin
    Button.Visible := FDataSet <> nil;
  end;
end;

procedure TDCCustomPopupDBGrid.CMSetAlignment(var Message: TMessage);
begin
  PopupAlignment := TWindowAlignment(Message.WParam);
end;

procedure TDCCustomPopupDBGrid.CMHintShow(var Message: TCMHintShow);
begin
  inherited;
end;

function TDCCustomPopupDBGrid.MouseUpBeforeDblClk: boolean;
begin
  Result := True;
end;

procedure TDCCustomPopupDBGrid.PaintEmptyMessage(Sender: TObject;
  Canvas: TCanvas; ARect: TRect; UpdateMessage: string);
begin
  Canvas.FillRect(ARect);
  ARect.Left  := ARect.Left + FBorderSize;
  ARect.Right := ARect.Right - FMargins.Right - FMargins.Left - 2*FBorderSize;
  DrawHighLightText(Canvas, PChar(UpdateMessage), ARect, 1,
    DT_END_ELLIPSIS or DT_CENTER or DT_WORDBREAK);
end;

procedure TDCCustomPopupDBGrid.DoScroll(Sender: TObject);
begin
  if Sender is TDCEditButton then
  begin
    case TDCEditButton(Sender).Tag of
      3: {Left}
        begin
          if LeftCol > 0 then
            LeftCol := LeftCol - 1
          else if FScrollTimer <> 0 then
          begin
            KillTimer(Handle, FScrollTimer);
            FScrollTimer := 0;
          end;
        end;
      4: {Right}
        begin
          if LeftCol + VisibleColCount < ColCount then
            LeftCol := LeftCol + 1
          else if FScrollTimer <> 0 then
          begin
            KillTimer(Handle, FScrollTimer);
            FScrollTimer := 0;
          end;
        end;
    end;
  end;
end;

procedure TDCCustomPopupDBGrid.TopLeftChanged;
begin
  inherited;
  UpdateHScrolls;
end;

procedure TDCCustomPopupDBGrid.UpdateHScrolls;
begin
  if Assigned(FScrollLeft) then FScrollLeft.Enabled := LeftCol > 0;
  if Assigned(FScrollRight) then
    FScrollRight.Enabled := LeftCol + VisibleColCount < ColCount;
end;

procedure TDCCustomPopupDBGrid.WMLButtonDown(var Message: TWMLButtonDown);
 var
  Button: TDCEditButton;
  Pos: TPoint;
begin
  inherited;
  GetCursorPos(Pos);
  if FButtons.MouseInButtonArea(Pos.X, Pos.Y, Button) then
  begin
    if (Button = FScrollLeft) or (Button = FScrollRight) then
      FScrollTimer := SetTimer(Handle, SLLTIMER_IDEVENT, 500, nil);
  end;
end;

procedure TDCCustomPopupDBGrid.WMLButtonUp(var Message: TWMLButtonUp);
begin
  inherited;
  if FScrollTimer <> 0 then
  begin
    KillTimer(Handle, FScrollTimer);
    FScrollTimer := 0;
  end;
end;

procedure TDCCustomPopupDBGrid.DrawClientRect;
 var
  DC: HDC;
  R, R1, R2: TRect;
  Rgn: HRGN;
begin
  if not(pgShowHeader in FPopupOptions) then Exit;
  DC  := GetWindowDC(Handle);
  Rgn := 0;
  try
    GetWindowRect (Handle, R);  OffsetRect (R, -R.Left, -R.Top);

    R2 := R;
    with FMargins do
    begin
     InflateRect(R2, -2, -2);
     R2.Top := R2.Top + br_HeaderHeight;
     R2.Bottom := R2.Bottom - br_FooterHeight;
    end;

    Rgn := CreateRectRgn(R2.Left, R2.Top, R2.Right, R2.Bottom);
    SelectClipRgn(DC, Rgn);

    R1 := Rect(FMargins.Left, FMargins.Top, R.Right - FMargins.Right,
       R.Bottom - FMargins.Bottom);
    InflateRect(R1, -1, -1);

    DrawEdge(DC, R1, BDR_SUNKENOUTER, BF_TOPLEFT);
    DrawEdge(DC, R1, BDR_SUNKENINNER, BF_BOTTOMRIGHT);

    ExcludeClipRect(DC, R1.Left, R1.Top, R1.Right, R1.Bottom);
    Dec(R2.Bottom, 4);
    FillRect(DC, R2,  GetSysColorBrush(clWhite));

  finally
    ReleaseDC(Handle, DC);
    if Rgn <> 0 then DeleteObject(Rgn);
  end;
end;

function TDCCustomPopupDBGrid.ValidPosition: boolean;
begin
 try
   Result := (TPrivateDataSet(DataSource.DataSet).BookmarkSize > 0) and
     DataSource.DataSet.BookmarkValid(Position)
 except
   Result := False;
 end;
end;

procedure TDCCustomPopupDBGrid.ColWidthsChanged;
begin
  inherited;
  UpdateHScrolls;
end;

procedure TDCCustomPopupDBGrid.SetPopupOptions(const Value: TPopupGridOptions);
 var
  ChangedOptions: TPopupGridOptions;
begin
  ChangedOptions := (FPopupOptions + Value) - (FPopupOptions * Value);
  if FPopupOptions <> Value then
  begin
    if [pgCanAppend, pgShowHeader] * ChangedOptions  <> [] then RecreateWnd;
  end;
end;

procedure TDCCustomPopupDBGrid.SetDrawingStyle(const Value: TDCDrawingStyle);
begin
  FDrawingStyle := Value;
end;

function TDCCustomPopupDBGrid.GetDroppedDown: boolean;
begin
  Result := FVisible;
end;

procedure TDCCustomPopupDBGrid.SetDroppedDown(const Value: boolean);
begin
  if FVisible then
    Hide
  else
    Show;
end;

procedure TDCCustomPopupDBGrid.SetDroppedIndirect(const Value: boolean);
begin
  FVisible := Value;
end;

{ TColumnFooterPanel }

function TColumnFooterPanel.DefaultFont: TFont;
begin
  if Assigned(FColumn) then
    Result := FColumn.Font
  else
    Result := inherited DefaultFont;
end;

function TColumnFooterPanel.GetColIndex: integer;
begin
  if Assigned(FColumn) then
    Result := FColumn.Index
  else
    Result := inherited GetColIndex;
  if Result >= 0 then
    Result := TDCCustomDBGrid(Footer.Grid).DataToRawColumn(Result);
end;

procedure TColumnFooterPanel.SetColIndex(const Value: integer);
begin
  inherited SetColIndex(TDCCustomDBGrid(Footer.Grid).RawToDataColumn(Value));
end;

procedure TColumnFooterPanel.SetColumn(const Value: TColumn);
begin
  if FColumn <> Value then
  begin
    FColumn := Value;
    Changed(False);
  end;
end;

procedure TDBGridInplaceEdit.WMSetFocus(var Message: TWMSetFocus);
begin
  if Assigned(Grid) then
    if not(Grid.Handle = Message.FocusedWnd) then
      TDCCustomDBGrid(Grid).InvalidateSelected;
  inherited;    
end;

function TDCCustomPopupDBGrid.LocateRecord(var KeyValue: string): boolean;
begin
  Result := False;
end;

end.
