{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x - 6.x
         Copyright (c) 1998-2001 Alex'EM

}
unit DCCpuInfo;

interface

uses Windows, dialogs;

const
  CPUID_IDBIT = $00200000;

  CPU_MMX     = $17;                 // 23
  CPU_SSE     = $19;                 // 25
  CPU_SSE2    = $1A;                 // 26

type
  TCpuInfo_tag = packed record
    Vendor: array[0..11] of Char;
    Signature: DWORD;
    Features: DWORD;
  end;

  TDCCpuInfo = class(TObject)
  private
    FInfo: TCpuInfo_tag;
    function GetValue(const Index: Integer): boolean;
    function GetVendor: string;
    function GetSignature(const Index: Integer): WORD;
  public
    constructor Create; virtual;
    property Family: WORD index 0 read GetSignature;
    property MMX: boolean index CPU_MMX read GetValue;
    property Model: WORD index 1 read GetSignature;
    property Vendor: string read GetVendor;
    property SSE: boolean index CPU_SSE read GetValue;
    property SSE2: boolean index CPU_SSE2 read GetValue;
    property Stepping: WORD index 2 read GetSignature;
  end;

var
 CpuInfo: TDCCpuInfo;

implementation

function _getFlag(const Flag: dword; const Index: dword): boolean; assembler;
asm
  bt   eax, edx
  sbb  eax, eax
  and  eax, 1
end;

function _cpuidExist: boolean; assembler;
asm
  pushfd
  pop  eax
  mov  ecx, eax
  xor  eax, CPUID_IDBIT
  push eax
  popfd
  pushfd
  pop  eax
  cmp  eax, ecx
  jz   @@1
  mov  eax, 1
@@1:
end;

procedure GetCPUINFO(var Info: TCpuInfo_tag);
begin
  if _cpuidExist then
  begin
    asm
      push  ebx
      push  edi
      mov   edi, Info
      // get vendor name
      mov   eax, 0
      dw    $A20F
      mov   [edi + 0], ebx
      mov   [edi + 4], edx
      mov   [edi + 8], ecx

      // get signature and features
      mov   eax, 1
      dw    $A20F                    // cpuid
      mov   [edi + 12], eax
      mov   [edi + 16], edx
      pop   edi
      pop   ebx
    end;
  end
end;


{ TCpuInfo }

constructor TDCCpuInfo.Create;
begin
  inherited;
  GetCPUINFO(FInfo);
end;

function TDCCpuInfo.GetSignature(const Index: Integer): WORD;
begin
  case Index of
    0: {Family}
      Result := Hi(FInfo.Signature);
    1: {Model}
      Result := Lo(FInfo.Signature) shr 4;
    2: {Stepping}
      Result := Lo(FInfo.Signature) and $F;
    else
      Result := 0;  
  end;
end;

function TDCCpuInfo.GetValue(const Index: Integer): boolean;
begin
  Result := _getFlag(FInfo.Features, Index);
end;

function TDCCpuInfo.GetVendor: string;
begin
  Result := FInfo.Vendor
end;

initialization
  CpuInfo := TDCCpuInfo.Create;

finalization
  CpuInfo.Free;

end.


