{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x - 6.x
         Copyright (c) 1998-2001 Alex'EM

}
unit DCChoice;

interface
{$I DCConst.inc}

uses
  Windows, SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, ImgList,
  {$IFDEF DELPHI_V6}
    Variants,
  {$ENDIF}
  Controls, Dialogs, Forms, StdCtrls, Buttons, ExtCtrls, ComCtrls, DB,
  DBTables, DCEditButton, DCEditTools, DCPopupWindow, DCCalendar, DCDBGrids,
  DCConst, DCCalculator, DCMaskTools;

type
  TDCErrorMessageWindow = class;

  TKillFocusEvent = procedure (Sender: TObject; var StayOnControl: boolean) of object;
  TGetErrorHint = procedure (Sender: TObject; ErrorCode: integer;
    var ErrorHint: string) of object;
  TThreadEvent = procedure (Sender: TObject) of object;
  TTEInitTreeEvent = procedure (Sender: TObject; TreeView: TTreeView) of object;
  TGridAppendEvent = procedure (Sender: TObject; var KeyValue: variant;
    var Apply: boolean) of object;
  TCharCheckEvent = procedure (Sender: TObject; var C: Char;
    MaskItem: TMaskItem; ItemPos: integer; var CharValid: boolean) of object;
  TDCShowErrorEvent = procedure (Sender: TObject;
    ErrorWindow: TDCErrorMessageWindow) of object;

  TDCCustomMaskEdit = class;

  TFloatDataType = class(TPersistent)
  private
    FEdit: TDCCustomMaskEdit;
    FKind: TEditDataType;
    FPrecision: integer;
    FDigits: integer;
    procedure SetDigits(const Value: integer);
    procedure SetKind(const Value: TEditDataType);
    procedure SetPrecision(const Value: integer);
    procedure UpdateMask;
  public
    constructor Create(AEdit: TDCCustomMaskEdit);
    procedure Assign(Source: TPersistent); override;
  published
    property Kind: TEditDataType read FKind write SetKind;
    property Precision: integer read FPrecision write SetPrecision;
    property Digits: integer read FDigits write SetDigits;
  end;

  TGridValue  = class(TCollectionItem)
  private
     FFieldName: string;
     FValue: variant;
     FFieldType: TFieldType;
     function GetAsString: string;
     procedure SetAsString(Value: string);
  public
    constructor Create(AOwner: TCollection); override;
    property FieldName: string read FFieldName write FFieldName;
    property Value: variant read FValue write FValue;
    property FieldType: TFieldType read FFieldType write FFieldType;
    property AsString: string read GetAsString write SetAsString;
  end;

  TGridValues = class(TCollection)
  private
    FFieldsLoaded: boolean;
    FValuesLoaded: boolean;
    FIndex: integer;
    function GetItem(Field: string): TGridValue;
    procedure SetItem(Field: string; Value: TGridValue);
  public
    constructor Create(AOwner: TComponent);
    function Add: TGridValue;
    property Fields[Field: string]: TGridValue read GetItem write SetItem;
    property ValuesLoaded: boolean read FValuesLoaded write FValuesLoaded;
  end;

  IDCCustomEdit = interface(IUnknown)
    ['{09F4D519-B0AE-42C8-AAF7-34DCE93C8EFC}']
    procedure Deselect;
    function Focused: boolean;
    procedure Free;
    function GetCanEmpty: boolean;
    function GetErrorCode: integer;
    function GetHandle: HWnd;
    function GetInstance: TObject;
    function GetParentControl: TWinControl;
    function GetOnGetErrorHint: TGetErrorHint;
    function GetOnKillFocus: TKillFocusEvent;
    function GetReadOnly: boolean;
    function GetShowError: boolean;
    function GetVisible: boolean;
    function GetCaptionText: TCaption;
    function GetTextLen: Integer;
    procedure Invalidate;
    function IsValueValid: boolean;
    procedure Release;
    procedure SelectAll;
    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer);
    procedure SetCanEmpty(const Value: boolean);
    procedure SetErrorCode(const Value: integer);
    procedure SetMaxLength(const Value: integer);
    procedure SetOnGetErrorHint(const Value: TGetErrorHint);
    procedure SetOnKillFocus(const Value: TKillFocusEvent);
    procedure SetParent(AParent: TWinControl);
    procedure SetReadOnly(const Value: boolean);
    procedure SetShowError(const Value: boolean);
    procedure SetCaptionText(const Value: TCaption);
    procedure SetVisible(const Value: boolean);
    procedure Show;
    procedure ShowErrorMessage;
    property CanEmpty: boolean read GetCanEmpty write SetCanEmpty;
    property ErrorCode: integer read GetErrorCode write SetErrorCode;
    property Handle: HWnd read GetHandle;
    property OnGetErrorHint: TGetErrorHint read GetOnGetErrorHint
      write SetOnGetErrorHint;
    property OnKillFocus: TKillFocusEvent read GetOnKillFocus write SetOnKillFocus;
    property Parent: TWinControl read GetParentControl write SetParent;
    property ReadOnly: boolean read GetReadOnly write SetReadOnly;
    property ShowError: boolean read GetShowError write SetShowError;
    property Text: TCaption read GetCaptionText write SetCaptionText;
    property Visible: boolean read GetVisible write SetVisible;
  end;

  IDCCustomMaskEdit = interface(IDCCustomEdit)
    ['{6D4005FB-BDB9-4DAE-BA09-AC0D58545879}']
  end;

  IDCChoiceEdit = interface(IDCCustomMaskEdit)
    ['{DC0CF67D-B76B-47A0-8292-1EDA6AA2077A}']
    procedure CloseUp(State: Byte; bPerform: boolean);
    function GetButtonExist: boolean;
    function GetBoundsRect: TRect;
    function GetDrawStyle: TControlStyle;
    function GetDroppedDown: boolean;
    procedure SetButtonExist(const Value: boolean);
    procedure SetDroppedDown(const Value: boolean);
    procedure SetDrawStyle(const Value: TControlStyle);
    procedure SetEditRect;
    property ButtonExist: boolean read GetButtonExist write SetButtonExist;
    property DrawStyle: TControlStyle read GetDrawStyle write SetDrawStyle;
    property DroppedDown: boolean read GetDroppedDown write SetDroppedDown;
  end;

  IDCFloatEdit = interface(IDCChoiceEdit)
    ['{C813CF61-0AD8-42D0-AA5E-8FB4ED4935B6}']
    function GetDataType: TFloatDataType;
    procedure SetDataType(const Value: TFloatDataType);
    property DataType: TFloatDataType read GetDataType write SetDataType;
  end;

  IDCDateEdit = interface(IDCChoiceEdit)
    ['{888ED131-A672-4103-8A71-172CADCAEB0C}']
  end;

  IDCComboBox = interface(IDCChoiceEdit)
    ['{3D281EF6-680C-4BBF-94B4-9F94461987C7}']
    function GetComboBoxStyle: TComboBoxStyle;
    function GetItemIndex: Integer;
    function GetItems: TStrings;
    procedure SetComboBoxStyle(const Value: TComboBoxStyle);
    procedure SetItemIndex(const  Value: Integer);
    procedure SetItems(const Value: TStrings);
    property ItemIndex: integer read GetItemIndex write SetItemIndex;
    property Items: TStrings read GetItems write SetItems;
    property Style: TComboBoxStyle read GetComboBoxStyle write SetComboBoxStyle;
  end;

  IDCGridEdit = interface(IDCChoiceEdit)
    ['{C51EC783-856A-48BA-8E43-A88E3FDD6C96}']
    function GetInfoField: string;
    function GetKeyValue: Variant;
    function GetValues: TGridValues;
    procedure SetInfoField(const Value: string);
    procedure SetKeyValue(const Value: Variant);
    procedure SetValues(const Value: TGridValues);
    property InfoField: string read GetInfoField write SetInfoField;
    property KeyValue: Variant read GetKeyValue write SetKeyValue;
    property Values: TGridValues read GetValues write SetValues;
  end;

  IDCTreeEdit = interface(IDCChoiceEdit)
    ['{4367C38E-633C-46CC-A546-B03F87ED12E4}']
    function GetSelected: TTreeNode;
    procedure SetSelected(const Value: TTreeNode);
    property Selected: TTreeNode read GetSelected write SetSelected;
  end;

  TDCEditOpton = (eoSkipValidate, eoUndoEscapeBlocking);
  TDCEditOptons = set of TDCEditOpton;

  TDCCustomEdit = class(TCustomEdit, IDCCustomEdit)
  private
    FAlignment: TAlignment;
    FData: Pointer;
    FDBObject: TDCDBObject;
    FErrorCode: integer;
    FErrorHint: string;
    FFlags: DWORD;
    FOnCloseUp: TNotifyEvent;
    FOnCreateData: TNotifyEvent;
    FOnDestroyData: TNotifyEvent;
    FOnGetErrorHint: TGetErrorHint;
    FOnKillFocus: TKillFocusEvent;
    FOnShowError: TDCShowErrorEvent;
    FOptions: TDCEditOptons;
    FUpdateCount: integer;
    procedure SetAlignment(Value: TAlignment);
    function GetDBObject: TDCDBObject;
    procedure SetDBObject(const Value: TDCDBObject);
    function CanModified: boolean; virtual;
    procedure SetData(const Value: Pointer);
    procedure CreateData;
    procedure DestroyData;
    function GetValueChanged: boolean;
    procedure SetOptions(const Value: TDCEditOptons);
  protected
    procedure Change; override;
    procedure CloseUp(State: Byte; bPerform: boolean = False); virtual;
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure CMDialogChar(var Message: TCMDialogChar); message CM_DIALOGCHAR;
    procedure CMEnter(var Message: TCMEnter); message CM_ENTER;
    procedure CMErrorMessage(var Message: TMessage); message CM_ERRORMESSAGE;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
    procedure CMHookMessage(var Message: TMessage); message CM_HOOKMESSAGE;
    procedure CMPopupWindow(var Message: TMessage); message CM_POPUPWINDOW;
    procedure CMRelease(var Message: TMessage); message CM_RELEASE;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    procedure DoErrorHint(Sender: TObject); virtual;
    procedure DoCloseUp; virtual;
    procedure DoShowError(AErrorWindow: TDCErrorMessageWindow); virtual;
    function GetCanEmpty: boolean;
    function GetDroppedDown: boolean; virtual;
    function GetDropDownControl: TWinControl; virtual;
    function GetErrorCode: integer;
    function GetFlagValue(Index: Integer): boolean;
    function GetHandle: HWnd;
    function GetInstance: TObject;
    procedure GetHintOnError; virtual;
    function GetHintTimeOut: integer; virtual;
    function GetOnGetErrorHint: TGetErrorHint;
    function GetOnKillFocus: TKillFocusEvent;
    function GetParentControl: TWinControl;
    function GetReadOnly: boolean;
    function GetShowError: boolean;
    function GetCaptionText: TCaption;
    function GetVisible: boolean;
    procedure HookMessage(wParam: Longint; var Msg: TMsg); virtual;
    function PtInDropDownControl(X, Y: integer): boolean;
    procedure SetCanEmpty(const Value: boolean);
    procedure SetCaptionText(const Value: TCaption);
    procedure SetDroppedDown(const Value: boolean); virtual;
    procedure SetEditRect; virtual;
    procedure SetErrorCode(const Value: integer);
    procedure SetFlagValue(Index: Integer; const Value: boolean);
    procedure SetMaxLength(const Value: integer);
    procedure SetOnGetErrorHint(const Value: TGetErrorHint);
    procedure SetOnKillFocus(const Value: TKillFocusEvent);
    procedure SetReadOnly(const Value: boolean);
    procedure SetShowError(const Value: boolean);
    procedure SetValueChanged(Value: boolean); virtual;
    procedure SetVisible(const Value: boolean);
    procedure WMMouseActivate(var Message: TWMActivate); message WM_MOUSEACTIVATE;
    property Alignment: TAlignment read FAlignment write SetAlignment
      default taLeftJustify;
    property CanEmpty: boolean read GetCanEmpty write SetCanEmpty default True;
    property DBObject: TDCDBObject read GetDBObject write SetDBObject;
    property Flags[Index: integer]: boolean read GetFlagValue write SetFlagValue;
    property OnKillFocus: TKillFocusEvent read GetOnKillFocus write SetOnKillFocus;
    property OnShowError: TDCShowErrorEvent read FOnShowError write FOnShowError;
    property OnGetErrorHint: TGetErrorHint read GetOnGetErrorHint
      write SetOnGetErrorHint;
    property OnCloseUp: TNotifyEvent read FonCloseUp write FOnCloseUp;
    property Options: TDCEditOptons read FOptions write SetOptions;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    function IsValueValid: boolean;
    procedure Deselect;
    procedure KillFocus(var Value: boolean); dynamic;
    procedure ShowErrorMessage;
    procedure HideErrorMessage;
    procedure BeginUpdate(HookChanges: boolean = True); virtual;
    procedure EndUpdate; virtual;
    procedure Release;
    property Data: Pointer read FData write SetData;
    property DroppedDown: boolean read GetDroppedDown write SetDroppedDown;
    property ErrorCode: integer read GetErrorCode write SetErrorCode;
    property ErrorHint: string read FErrorHint write FErrorHint;
    property OnCreateData: TNotifyEvent read FOnCreateData write FOnCreateData;
    property OnDestroyData: TNotifyEvent read FOnDestroyData write FOnDestroyData;
    property ValueChanged: boolean read GetValueChanged;
    property ShowError: boolean read GetShowError write SetShowError;
    property UpdateCount: integer read FUpdateCount;
  end;

  TDCErrorMessageWindow = class(TDCMessageWindow)
  private
    FDefaultItemWidth: integer;
    FErrorCode: integer;
    function GetEdit: TDCCustomEdit;
  protected
    function GetButtonSize(Button: TDCEditButton): TPoint; override;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Hide; override;
    property DefaultItemWidth: integer read FDefaultItemWidth
      write FDefaultItemWidth;
    property Edit: TDCCustomEdit read GetEdit;
    property ErrorCode: integer read FErrorCode write FErrorCode;
  end;

  TDCCustomMaskEdit = class(TDCCustomEdit)
  private
    FEditMask: string;
    FMaskStruct: TEditMask;
    FOnCharCheck: TCharCheckEvent;
    procedure SetEditMask(const Value: string);
    procedure SetSel(SelStart: Integer; SelEnd: Integer);
    procedure DeleteKey(Key: Word);
    procedure InsertString(Insert: string);
    procedure CompleteChars;
  protected
    function IsMasked: boolean; virtual;
    property EditMask: string read FEditMask write SetEditMask;
    procedure DoCharCheck(var C: Char; MaskItem: TMaskItem; ItemPos: integer;
      var CharValid: boolean); virtual;
    procedure WMCut(var Message: TMessage); message WM_CUT;
    procedure WMPaste(var Message: TMessage); message WM_PASTE;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
    function MaskMatched: boolean;
    procedure GetHintOnError; override;
    function GetHintTimeOut: integer; override;
    procedure EditMaskChanged; virtual;
    property OnCharCheck: TCharCheckEvent read FOnCharCheck write FOnCharCheck;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure KillFocus(var Value: boolean); override;
  end;

  TDCEdit = class(TDCCustomMaskEdit)
  published
    property PasswordChar;
    property Anchors;
    property AutoSelect;
    property AutoSize;
    property BiDiMode;
    property CharCase;
    property Color;
    property Constraints;
    property Ctl3D;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property Font;
    property HideSelection;
    property ImeMode;
    property ImeName;
    property MaxLength;
    property OEMConvert;
    property ParentBiDiMode;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ReadOnly;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Text;
    property Visible;
    property OnChange;
    property OnCharCheck;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDock;
    property OnStartDrag;
    property Alignment;
    property CanEmpty;
    property OnKillFocus;
    property OnShowError;
    property OnGetErrorHint;
    property DBObject;
    property EditMask;
  end;

  TDCParentEdit = class(TDCCustomMaskEdit)
  published
    property Anchors;
    property AutoSelect;
    property AutoSize;
    property BiDiMode;
    property CharCase;
    property Color;
    property Constraints;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property Font;
    property HideSelection;
    property ImeMode;
    property ImeName;
    property MaxLength;
    property OEMConvert;
    property ParentBiDiMode;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Text;
    property Visible;
    property OnChange;
    property OnCharCheck;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDock;
    property OnStartDrag;
    property Alignment;
    property CanEmpty;
    property OnKillFocus;
    property OnShowError;
    property OnGetErrorHint;
    property DBObject;
  end;

  TDCCustomChoiceEdit = class(TDCParentEdit, IDCChoiceEdit)
  private
    FBtnChoice: TDCEditButton;
    FBtnChoiceStyle: TChoiceBtnStyle;
    FButtonStyle: TEventStyle;
    FOnButtonClick: TNotifyEvent;
    FCheckWidth: integer;
    FChoiceButtonWidth: integer;
    FCheckGlyph: TBitmap;
    FCheckTag: integer;
    FGlyph: TBitmap;
    FDrawStyle: TControlStyle;
    FOnCheckClick: TNotifyEvent;
    FImage: TBitmap;
    FLinkControl: TWinControl;
    FMargins: TRect;
    procedure SetBtnChoiceStyle(Value: TChoiceBtnStyle);
    procedure SetGlyph(Value: TBitmap);
    procedure UpdateMouseInControl(Value: boolean);
    procedure SetChoiceButtonWidth(Value: integer);
    function GetButtonStyle: TEventStyle;
    procedure SetButtonStyle(Value: TEventStyle);
    function GetButtonState: TButtonState;
    procedure SetButtonState(Value: TButtonState);
    procedure SetCheckGlyph(Value: TBitmap);
    procedure SetButtonEnabled(Value: boolean);
    function GetButtonEnabled: boolean;
    function UpdateButtonsOnClick(X, Y: integer): boolean;
    procedure SetDisableButtons(const Value: boolean);
    procedure SetCaret;
    procedure SetLinkControl(const Value: TWinControl);
    function GetButtonWidth: integer;
    function IsGlyphStored: boolean;
    function IsButtonWidthStored: boolean;
    function CanModified: boolean; override;
    procedure SetWordWrap(const Value: Boolean);
    function GetDisableButtons: boolean;
    function GetWordWrap: Boolean;
    function GetMultiLine: boolean;
    procedure SetMultiLine(const Value: boolean);
    procedure GlyphChange(Sender: TObject);
  protected
    procedure AdjustClientRect(var Rect: TRect); override;
    function BtnChoiceAssigned: boolean;
    procedure CheckClick(Sender:TObject); virtual;
    procedure ChoiceButtonDown;
    procedure CloseUp(State: Byte; bPerform: boolean = False); override;
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure CMColorChanged(var Message: TMessage); message CM_COLORCHANGED;
    procedure CMEnabledChanged(var Message: TMessage); message CM_ENABLEDCHANGED;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
    procedure CMEnter(var Message: TCMEnter); message CM_ENTER;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure CMPopupWindow(var Message: TMessage); message CM_POPUPWINDOW;
    procedure CreateWnd; override;
    procedure DefineBtnChoice(BtnStyle: TChoiceBtnStyle);
    procedure DefineBtnChoiceStyle; virtual;
    procedure DoDrawButtons(DC: HDC); virtual;
    procedure DoDrawMargins(DC: HDC); virtual;
    procedure EMSetPasswordChar(var Message: TMessage); message EM_SETPASSWORDCHAR;
    procedure EMSetReadOnly(var Message: TMessage); message EM_SETREADONLY;
    function GetButtonExist: Boolean;
    function GetBoundsRect: TRect;
    function GetDrawStyle: TControlStyle;
    function GetGlyph: TBitmap;
    procedure GetMargins(var LeftMargin: integer; var RightMargin: integer); virtual;
    function GetShowCheckBox: boolean;
    procedure Loaded; override;
    function MinControlWidthBitmap: integer; virtual;
    procedure MouseUp(Button: TMouseButton; ShiftState: TShiftState; X, Y: Integer); override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    function PaintCheckGlyph: boolean; virtual;
    procedure PaintWindow(DC: HDC); override;
    procedure RedrawBorder(DrawBorder: boolean; Clip: HRGN); virtual;
    procedure SetButtonExist(const Value: Boolean); virtual;
    procedure SetDrawStyle(const Value: TControlStyle);
    procedure SetDroppedDown(const Value: boolean); override;
    procedure SetEditRect; override;
    procedure SetParent(AParent: TWinControl); override;
    procedure SetShowCheckBox(Value: boolean);
    procedure ShowDropDown; virtual;
    procedure WMCancelMode(var Message: TMessage); message WM_CANCELMODE;
    procedure WMEraseBkGnd(var Message: TWMEraseBkGnd); message WM_ERASEBKGND;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMLButtonDblClk(var Message: TWMLButtonDown); message WM_LBUTTONDBLCLK;
    procedure WMLButtonUp(var Message: TWMLButtonUp); message WM_LBUTTONUP;
    procedure WMMouseMove(var Message: TWMMouseMove); message WM_MOUSEMOVE;
    procedure WMNCHitTest(var Message: TWMNCHitTest); message WM_NCHITTEST;
    procedure WMNCPaint(var Message: TMessage); message WM_NCPAINT;
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
    procedure WMSize(var message: TWMSize); message WM_SIZE;
    procedure WMSetCursor(var Message: TWMSetCursor); message WM_SETCURSOR;
    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SETFOCUS;
    procedure WMSysCommand(var Message: TWMSysCommand); message WM_SYSCOMMAND;
    procedure WndProcAction(Action: integer); virtual;
    property ButtonChoiceStyle: TChoiceBtnStyle  read FBtnChoiceStyle
       write SetBtnChoiceStyle  default btsForm;
    property ButtonEnabled: boolean read GetButtonEnabled write SetButtonEnabled;
    property ButtonExist: Boolean read GetButtonExist write SetButtonExist
      default True;
    property ButtonStyle: TEventStyle read GetButtonStyle write SetButtonStyle
      default esNormal;
    property ButtonState: TButtonState read GetButtonState write SetButtonState;
    property ButtonChoice: TDCEditButton read FBtnChoice write FBtnChoice;
    property CheckGlyph: TBitmap read FCheckGlyph write SetCheckGlyph;
    property CheckTag: integer read FCheckTag write FCheckTag default 0;
    property Glyph: TBitmap read GetGlyph write SetGlyph stored IsGlyphStored;
    property MultiLine: boolean read GetMultiLine write SetMultiLine default False;
    property OnButtonClick: TNotifyEvent read FOnButtonClick write FOnButtonClick;
    property ShowCheckBox: boolean read GetShowCheckBox write SetShowCheckBox;
    property WordWrap: Boolean read GetWordWrap write SetWordWrap default False;
  public
    procedure ChoiceClick(Sender:TObject); virtual;
    constructor Create(AOwner: TComponent); override;
    procedure CreateParams(var Params: TCreateParams); override;
    destructor Destroy; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure KillFocus(var Value: boolean); override;
    property ButtonWidth: integer read GetButtonWidth;
    property DisableButtons: boolean read GetDisableButtons write SetDisableButtons;
  published
    property LinkControl: TWinControl read FLinkControl write SetLinkControl;
    property DrawStyle: TControlStyle read GetDrawStyle write SetDrawStyle
      default fcsNormal;
    property ChoiceButtonWidth: integer read FChoiceButtonWidth write SetChoiceButtonWidth
      stored IsButtonWidthStored default DEFAULT_BTN_WIDTH;
    property OnCheckClick: TNotifyEvent read FOnCheckClick write FOnCheckClick;
    property ReadOnly;
  end;

  TDCChoiceEdit = class(TDCCustomChoiceEdit)
  public
    property CheckTag;
    property ButtonEnabled;
  published
    property MultiLine;
    property ButtonChoiceStyle;
    property Glyph;
    property ButtonExist;
    property DrawStyle;
    property ButtonStyle;
    property CheckGlyph;
    property OnButtonClick;
    property OnCharCheck;
    property EditMask;
    property WordWrap;
   end;

  TDCCustomDateEdit = class(TDCCustomChoiceEdit, IDCDateEdit)
  private
    FCalendar: TDCCustomCalendar;
    FChecked: boolean;
    FFontColor: integer;
    FDateText: string;
    FUndoDate: TDateTime;
    FStartPos: integer;
    FEndPos: integer;
    FOnChecked: TNotifyEvent;
    FKind: TDateEditKind;
    procedure GetDateText;
    procedure SetDateText;
    procedure SetText(var Key: char);
    procedure DeleteChar(DeleteType: TDeleteType);
    procedure SetChecked(Value: boolean);
    procedure SetShowCheckBox(Value: boolean);
    function GetDate: TDateTime;
    procedure SetDate(const Value: TDateTime);
    procedure SetKind(const Value: TDateEditKind);
    procedure SetFontColor(Value: TColor);
    procedure SetUndoDate(const Value: TDateTime);
    procedure SetShowWeekDay(const Value: boolean);
    function GetEmpty: boolean;
    procedure SetCheckGlyph;
    function GetShowWeekDay: boolean;
    procedure CalendarCloseUp(Sender: TObject; State: Byte; bPerform: boolean);
  protected
    procedure GetMargins(var LeftMargin: integer; var RightMargin: integer); override;
    procedure CloseUp(State: Byte; bPerform: boolean = False); override;
    procedure GetHintOnError; override;
    procedure Loaded; override;
    function GetDropDownControl: TWinControl; override;
    procedure DefineBtnChoiceStyle; override;
    procedure DoDrawMargins(DC: HDC); override;
    procedure EMSetReadOnly(var Message: TMessage); message EM_SETREADONLY;
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
    procedure CMEnter(var Message: TCMEnter); message CM_ENTER;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure CMPopupWindow(var Message: TMessage); message CM_POPUPWINDOW;
    function IsMasked: boolean; override;
    procedure ShowDropDown; override;
    property ShowCheckBox: boolean read GetShowCheckBox write SetShowCheckBox
      default False;
    property Checked: boolean read FChecked write SetChecked;
    property Date: TDateTime read GetDate write SetDate;
    property OnChecked: TNotifyevent read FOnChecked write FOnChecked;
    property Kind: TDateEditKind read FKind write SetKind;
    property UndoDate: TDateTime read FUndoDate write SetUndoDate;
    property ShowWeekDay: boolean read GetShowWeekDay write SetShowWeekDay
      default True;
  public
    constructor Create(AOwner: TComponent); override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char);override;
    procedure KillFocus(var Value: boolean); override;
    procedure CheckClick(Sender:TObject); override;
    property Empty: boolean read GetEmpty;
  end;

  TDCDateEdit = class(TDCCustomDateEdit)
  public
    property ButtonEnabled;
    property UndoDate;
  published
    property DrawStyle;
    property ReadOnly;
    property ShowCheckBox;
    property Checked;
    property ButtonExist;
    property Date;
    property Kind;
    property ShowWeekDay;
    property OnCharCheck;
    property OnChecked;
  end;

  TDCCustomFloatEdit = class(TDCCustomChoiceEdit, IDCFloatEdit)
  private
    FCalculator: TDCCustomCalculator;
    FDataType: TFloatDataType;
    FMasked: boolean;
    function GetValue: Extended;
    function GetEditValue(EditText: string): string;
    procedure SetValue(const Value: Extended);
    procedure CalculatorCloseUp(Sender: TObject; State: Byte; bPerform: boolean);
  protected
    procedure CloseUp(State: Byte; bPerform: boolean = False); override;
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure CMPopupWindow(var Message: TMessage); message CM_POPUPWINDOW;
    procedure DefineBtnChoiceStyle; override;
    procedure EditMaskChanged; override;
    function GetDataType: TFloatDataType;
    function GetDropDownControl: TWinControl; override;
    procedure GetHintOnError; override;
    function IsMasked: boolean; override;
    procedure SetDataType(const Value: TFloatDataType);
    procedure ShowDropDown; override;
    property DataType: TFloatDataType read GetDataType write SetDataType;
    property Value: Extended read GetValue write SetValue;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KillFocus(var Value: boolean); override;
  published
    property Masked: boolean read FMasked write FMasked;
    property Alignment default taRightJustify;
  end;

  TDCFloatEdit = class(TDCCustomFloatEdit)
  public
    property ButtonEnabled;
  published
    property DrawStyle;
    property ReadOnly;
    property ButtonExist;
    property DataType;
    property OnCharCheck;
    property Value;
  end;

  TDrawBitmapEvent = procedure(Control: TWinControl; R: TRect; Index: Integer;
     Bitmap: TBitmap) of object;
  TDCDrawItemEvent = procedure(ACanvas: TCanvas; Control: TWinControl; Index: Integer;
     Rect: TRect;  State: TOwnerDrawState) of object;

  TDCCustomComboBox = class(TDCCustomChoiceEdit, IDCComboBox)
  private
    FListBox: TDCPopupListBox;
    FStyle: TComboBoxStyle;
    FItems: TStrings;
    FOnDrawItem: TDrawItemEvent;
    FOnDrawText: TDCDrawItemEvent;
    FOnMeasureItem:TMeasureItemEvent;
    FItemHeight: integer;
    FLastText: string;
    FLastIndex: integer;
    FOnDrawBitmap: TDrawBitmapEvent;
    FItemIndex: integer;
    FOnIndexChange: TNotifyEvent;
    FDropDownWidth: integer;
    FEditing: boolean;
    FOnDropDown: TNotifyEvent;
    FDropDownCount: integer;
    FCachedIndex: integer;
    FCachedText: string;
    procedure GetEntryText;
    function GetItemIndex: integer;
    function GetItems: TStrings;
    procedure SetComboBoxStyle(const Value: TComboBoxStyle);
    procedure SetItems(const Value: TStrings);
    function GetFirstEntry(PartWord: boolean ): integer;
    procedure SetText(Value: string; ItemIndex: integer; ASelStart, ASelLen: integer);
    procedure SetItemIndex(const Value: integer);
    procedure PaintListItem(bFocused: boolean);
    function NotEditControl: boolean;
    procedure FindNextItem(cFirstChar: char);
    procedure SetEditing(const Value: boolean);
    function GetComboBoxStyle: TComboBoxStyle;
  protected
    procedure CheckClick(Sender:TObject); override;
    procedure CloseUp(State: Byte; bPerform: boolean = False); override;
    procedure GetHintOnError; override;
    function MinControlWidthBitmap: integer; override;
    procedure DrawBitmap(Index: integer); virtual;
    function GetDropDownControl: TWinControl; override;
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    procedure EMGetSel(var Message: TMessage); message EM_GETSEL;
    procedure WMChar(var Message: TWMChar); message WM_CHAR;
    procedure WMEraseBkGnd(var Message: TWMEraseBkGnd); message WM_ERASEBKGND;
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure WMKillFocus(var Message: TWMKillFocus); message WM_KILLFOCUS;
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
    procedure WMSetCursor(var Message: TWMSetCursor); message WM_SETCURSOR;
    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SETFOCUS;
    procedure WMLButtonDblClk(var Message: TWMLButtonDown); message WM_LBUTTONDBLCLK;
    procedure CMEnter(var Message: TCMEnter); message CM_ENTER;
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure CMPopupWindow(var Message: TMessage); message CM_POPUPWINDOW;
    procedure ListMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    function GetCanvas: TCanvas;
    procedure WndProc(var Message: TMessage); override;
    procedure DropDown; dynamic;
    procedure DefineBtnChoiceStyle; override;
    procedure ShowDropDown; override;
    property Style: TComboBoxStyle read GetComboBoxStyle write SetComboBoxStyle;
    property Items: TStrings read GetItems write SetItems;
    property ItemHeight: integer read FItemHeight write FItemHeight;
    property OnDrawBitmap: TDrawBitmapEvent read FOnDrawBitmap write FOnDrawBitmap;
    property OnIndexChange: TNotifyEvent read FOnIndexChange write FOnIndexChange;
    property OnDrawItem: TDrawItemEvent read  FOnDrawItem write FOnDrawItem;
    property OnDrawText: TDCDrawItemEvent read  FOnDrawText write FOnDrawText;
    property OnMeasureItem: TMeasureItemEvent read FOnMeasureItem write FOnMeasureItem;
    property DropDownWidth: integer read FDropDownWidth write FDropDownWidth default 0;
    property OnDropDown: TNotifyEvent read FOnDropDown write FOnDropDown;
    property DropDownCount: Integer read FDropDownCount write FDropDownCount default 8;
    procedure CreateWnd; override;
  public
    procedure CreateParams(var Params: TCreateParams); override;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KillFocus(var Value: boolean); override;
    procedure Clear; override;
    property ItemIndex: integer read GetItemIndex write SetItemIndex;
    property Canvas: TCanvas read GetCanvas;
    property Editing: boolean read FEditing write SetEditing;
  end;

  TDCComboBox = class(TDCCustomComboBox)
  public
    property ButtonEnabled;
  published
    property Alignment;
    property DrawStyle;
    property CheckGlyph;
    property CheckTag;
    property Items;
    property ItemHeight;
    property OnDrawBitmap;
    property OnIndexChange;
    property DropDownWidth default 0;
    property OnDrawItem;
    property OnDrawText;
    property OnMeasureItem;
    property Style;
    property ShowCheckBox;
    property ReadOnly;
    property OnDropDown;
    property DropDownCount;
    property EditMask;
    property OnCharCheck;
    property OnCloseUp;
  end;

  TThreadMode =(tmFind, tmStop, tmIdle, tmSearching);
  TGridEditThread = class;
  TDCCustomGridEdit = class;

  TCheckGridEvent  = procedure (Sender: TObject; DataValue: string;
    DataType: TFieldType; var Exist: boolean; var KeyValue: variant;
    GridValues: TGridValues) of object;
  TGetGridEvent   = procedure (Sender: TObject; KeyValue: string;
    DataType: TFieldType; var Exist: boolean; GridValues: TGridValues) of object;

  TDCGridEditOption = (geSkipValidate, geCanAppend, geSelectOnSingleClick,
    geSearchOnSubstring, geUndoEscapeBlocking);
  TDCGridEditOptions = set of TDCGridEditOption;

  TDCCustomGridEdit = class(TDCCustomChoiceEdit, IDCGridEdit)
  private
    FColumns: TDBGridColumns;
    FColumnsOrder: TStringList;
    FDataField: string;
    FDataSet: TDataSet;
    FDropDownWidth: integer;
    FGrid: TDCCustomPopupDBGrid;
    FGridEditThread: TGridEditThread;
    FImageChangeLink: TChangeLink;
    FImages: TImageList;
    FInfoField: string;
    FInfoFieldWidth: integer;
    FInfoHintWindow: TDCMessageWindow;
    FKeyField: string;
    FKeyValue: variant;
    FListBox: TDCPopupListBox;
    FListBoxColumns: TDBGridColumns;
    FListBoxEnabled: boolean;
    FListBoxWidth: integer;
    FOnAppendRecord: TGridAppendEvent;
    FOnCheckDataValue: TCheckGridEvent;
    FOnDrawInfoText: TDrawInfoText;
    FOnGetDataValue: TGetGridEvent;
    FOnGridTitleClick: TDBGridClickEvent;
    FOnThreadStart: TThreadEvent;
    FOnThreadStop : TThreadEvent;
    FOnValueChange: TNotifyEvent;
    FGridOptions: TDCGridEditOptions;
    FQuery: TDataSet;
    FQueryDataSet: boolean;
    FPaintBox: integer;
    FStates: DWORD;
    FThreadMode: TThreadMode;
    FSQLText: string;
    FSQLDataField: string;
    FSQLKeyField: string;
    FSQLOrderBy: string;
    FValues: TGridValues;
    procedure ListBoxDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure ListBoxMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SetKeyValue(const Value: variant);
    procedure SetKeyValueEx(Value: variant; NeedLocate: boolean = True);
    procedure SetDataSet(const Value: TDataSet);
    procedure LocateDataSet;
    function FieldExists(Value: string): boolean;
    procedure GridDblClick(Sender: TObject);
    procedure GridCellClick(Columns: TColumn);
    procedure GetEntryText;
    procedure ClearValue(ClearText: boolean);
    procedure BeginPaintListBox;
    procedure EndPaintListBox;
    procedure GridTitleClick(Column: TColumn); virtual;
    function GetSQLText: string;
    procedure SetSQLText(const Value: string);
    procedure SetDataValues(ADataSet: TDataSet);
    procedure SetDataField(const Value: string);
    procedure SetKeyField(const Value: string);
    procedure SetSQLDataField(const Value: string);
    procedure SetSQLKeyField(const Value: string);
    procedure SetInfoField(const Value: string);
    procedure SetInfoFieldWidth(const Value: integer);
    function ExistInfo: boolean;
    function ActivateDataSet: boolean;
    procedure CloseDataSet;
    function GetGridOrderBy: string;
    procedure InitColumnsOrder;
    procedure ImageListChange(Sender: TObject);
    function GetInfoRect: TRect;
    procedure ShowInfoHint;
    procedure HideInfoHint;
    procedure SendControlMessage(Message, WParam, LParam: integer;
      bPerform: boolean);
    procedure SetImages(const Value: TImageList);
    function PtInHintInfoArea(X, Y: integer; Convert: boolean): boolean;
    function GetKeyValue: Variant;
    function GetInfoField: string;
    function GetValues: TGridValues;
    procedure SetValues(const Value: TGridValues);
    procedure SetGridOptions(const Value: TDCGridEditOptions);
  protected
    function CheckDataValue: boolean;
    function DoCreatePopupGrid: TDCCustomPopupDBGrid; virtual;
    procedure SetSQLTextPermanet(const Value: string);
    procedure SetInternalDataSet(const Value: TDataSet;
      var DataSet: TDataSet); virtual; abstract;
    procedure SetInternalSQLText(const Value: string;
      var SQLText: string); virtual; abstract;
    function SetGridValues: boolean;
    procedure CloseUp(State: Byte; bPerform: boolean = False); override;
    procedure GetHintOnError; override;
    procedure Loaded; override;
    function GetDroppedDown: boolean; override;
    function GetDropDownControl: TWinControl; override;
    function GetGridOptions: TDCGridEditOptions;
    function CreateQuery: TDataSet; virtual; abstract;
    procedure DoInitQuery(Mode: integer); virtual; abstract;
    procedure OpenQuery(Mode: integer);
    function GetPreparedQueryText(Mode: integer; SQLText: string): string;
    function GetQueryText: string ; virtual; abstract;
    procedure HookMessage(wParam: Longint; var Msg: TMsg); override;
    procedure PrepareDataSet; virtual; abstract;
    procedure KeyValueChanged; virtual;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    function DoMouseWheelDown(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    function DoMouseWheelUp(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    procedure WMChar(var Message: TWMChar); message WM_CHAR;
    procedure WMNCHitTest(var Message: TWMNCHitTest); message WM_NCHITTEST;
    procedure WMPaste(var Message: TWMPaste); message WM_PASTE;
    procedure WMSetCursor(var Message: TWMSetCursor); message WM_SETCURSOR;
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
    procedure CMHintActivate(var Message: TMessage); message CM_HINTACTIVATE;
    procedure CMThreadStart(var Message: TMessage); message CM_THREAD_START;
    procedure CMThreadTerminate(var Message: TMessage); message CM_THREAD_TERMINATE;
    procedure CMThreadItemClr(var Message: TMessage); message CM_THREAD_ITEMCLR;
    procedure CMThreadItemAdd(var Message: TMessage); message CM_THREAD_ITEMADD;
    procedure CMThreadShowBox(var Message: TMessage); message CM_THREAD_SHOWBOX;
    procedure CMThreadHideBox(var Message: TMessage); message CM_THREAD_HIDEBOX;
    procedure CMThreadLocated(var Message: TMessage); message CM_THREAD_LOCATED;
    procedure CMThreadFindCmplt(var Message: TMessage); message CM_THREAD_FINDCMPLT;
    procedure CMThreadFreeBox(var Message: TMessage); message CM_THREAD_FREEBOX;
    procedure CMThreadError(var Message: TMessage); message CM_THREAD_ERROR;
    procedure CMThreadSetMode(var Message: TMessage); message CM_THREAD_SETMODE;
    procedure CMThreadStop(var Message: TMessage); message CM_THREAD_STOP;
    procedure CMPopupButtonClk(var Message: TMessage); message CM_POPUPBUTTONCLK;
    procedure CMPopupHintInfo(var Message: TMessage); message CM_POPUPHINTINFO;
    procedure CMPopupWindow(var Message: TMessage); message CM_POPUPWINDOW;
    procedure CMAppendrecord(var Message: TMessage); message CM_APPENDRECORD;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure WaitForThreadTerminate(Count: DWORD = 10);
    procedure DoGridTitleClick(IndexChanged: boolean; Column: TColumn); virtual;
    procedure DefineBtnChoiceStyle; override;
    procedure GetMargins(var LeftMargin: integer; var RightMargin: integer); override;
    function FullQuery: boolean;
    procedure ShowDropDown; override;
    property Query: TDataSet read FQuery;
    function AutoCompleteActive(CheckVisible: boolean): boolean;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    property Values: TGridValues read GetValues write SetValues;
    property KeyValue: Variant read GetKeyValue write SetKeyValue;
    procedure KillFocus(var Value: boolean); override;
    procedure DoDrawMargins(DC: HDC); override;
    procedure AppendRecord;
    procedure BeginUpdate(HookChanges: boolean = True); override;
    procedure EndUpdate; override;
    procedure ValidateValue;
    procedure LocateFirstValue;
    property ColumnsOrder: TStringList read FColumnsOrder;
  published
    property Columns: TDBGridColumns read FColumns write FColumns;
    property DataSet: TDataSet read FDataSet write SetDataSet;
    property Images: TImageList read FImages write SetImages;
    property DropDownWidth: integer read FDropDownWidth write FDropDownWidth default 0;
    property KeyField: string read FKeyField write SetKeyField;
    property DataField: string read FDataField write SetDataField;
    property OnValueChange: TNotifyEvent read FOnValueChange write FOnValueChange;
    property OnCheckDataValue: TCheckGridEvent read FOnCheckDataValue
      write FOnCheckDataValue;
    property OnGetDataValue: TGetGridEvent read FOnGetDataValue write FOnGetDataValue;
    property ListBoxEnabled: boolean read FListBoxEnabled
      write FListBoxEnabled default False;
    property ListBoxColumns: TDBGridColumns read FListBoxColumns
      write FListBoxColumns;
    property OnDrawInfoText: TDrawInfoText read FOnDrawInfoText write FOnDrawInfoText;
    property OnThreadStart: TThreadEvent read FOnThreadStart write FOnThreadStart;
    property OnThreadStop : TThreadEvent read FOnThreadStop write FOnThreadStop;
    property OnGridTitleClick: TDBGridClickEvent read FOnGridTitleClick
      write FOnGridTitleClick;
    property ListBoxWidth: integer read FListBoxWidth write FListBoxWidth default 0;
    property SQLText: string read GetSQLText write SetSQLText;
    property SQLDataField: string read FSQLDataField write SetSQLDataField;
    property SQLKeyField: string read FSQLKeyField write SetSQLKeyField;
    property SQLOrderBy:string read FSQLOrderBy write FSQLOrderBy;
    property InfoField: string read GetInfoField write SetInfoField;
    property InfoFieldWidth: integer read FInfoFieldWidth write SetInfoFieldWidth;
    property QueryDataSet: boolean read FQueryDataSet write FQueryDataSet;
    property OnAppendRecord: TGridAppendEvent read FOnAppendRecord write FOnAppendRecord;
    property Options: TDCGridEditOptions read GetGridOptions write SetGridOptions;
  end;

  TDCBDEPopupDBGrid = class(TDCCustomPopupDBGrid)
  protected
    function LocateRecord(var KeyValue: string): boolean; override;
  end;

  TDCBDEGridEdit = class(TDCCustomGridEdit)
  private
    function GetDatabaseName: string;
    function GetParams: TParams;
    procedure SetDatabaseName(const Value: string);
    procedure SetParams(const Value: TParams);
  protected
    function CreateQuery: TDataSet; override;
    function GetQueryText: string; override;
    function DoCreatePopupGrid: TDCCustomPopupDBGrid; override;
    procedure DoInitQuery(Mode: integer); override;
    procedure PrepareDataSet; override;
    procedure SetInternalDataSet(const Value: TDataSet;
      var DataSet: TDataSet); override;
    procedure SetInternalSQLText(const Value: string; var SQLText: string); override;
  public
    constructor Create(AOwner: TComponent); override;
    property ButtonEnabled;
  published
    property DrawStyle;
    property CheckGlyph;
    property CheckTag;
    property ReadOnly;
    property DatabaseName: string read GetDatabaseName write SetDatabaseName;
    property Params: TParams read GetParams write SetParams;
    property EditMask;
    property OnCharCheck;
  end;

  TDCGridEdit = class(TDCBDEGridEdit)
  end;

  TGridEditThread = class(TThread)
    FGridEdit: TDCCustomGridEdit;
    FMode: TThreadMode;
    FFindValue: string;
    FStoped: boolean;
  private
    procedure SetFindValue(const Value: string);
    procedure FindDataSet;
    procedure AddValue;
  protected
    procedure Execute; override;
    procedure SendGridMessage(Msg: UINT; wParam: WPARAM; lParam: LPARAM;
      lPostMessage: boolean = False);
  public
    property FindValue: string read FFindValue write SetFindValue;
    property Mode: TThreadMode read FMode;
    constructor Create(GridEdit: TDCCustomGridEdit; Mode: TThreadMode);
  end;

  TTreeGetTextEvent   = procedure (Sender: TObject; Node: TTreeNode;
    var AText: string) of object;
  TTreeClearIteamEvent = procedure (Sender: TObject; TreeView: TTreeView) of object;
  TTreeSelectNodeEvent = procedure (Sender: TObject; Node: TTreeNode;
    var AllowSelect: boolean) of object;

  TDCCustomTreeEdit = class(TDCCustomChoiceEdit, IDCTreeEdit)
  private
    FTreeView: TDCPopupTreeView;
    FDropDownWidth: integer;
    FImages: TImageList;
    FImageChangeLink: TChangeLink;
    FOnChange: TTVChangedEvent;
    FOnInitTree: TTEInitTreeEvent;
    FOnCollapsed: TTVExpandedEvent;
    FOnExpanded: TTVExpandedEvent;
    FOnCollapsing: TTVExpandingEvent;
    FOnExpanding: TTVExpandingEvent;
    FOnSetText: TNotifyEvent;
    FOnGetText: TTreeGetTextEvent;
    FOnDrawText: TDCDrawItemEvent;
    FStyle: TTreeEditStyle;
    FOnCustomDrawItem: TTVCustomDrawItemEvent;
    FOnClearItems: TTreeClearIteamEvent;
    FOnSelectNode: TTreeSelectNodeEvent;
    function GetSelected: TTreeNode;
    procedure SetSelected(const Value: TTreeNode);
    procedure SetTreeView(const Value: TTreeView);
    procedure PaintListItem(bFocused: boolean);
    procedure SetStyle(const Value: TTreeEditStyle);
    procedure ImageListChange(Sender: TObject);
    procedure SetImages(const Value: TImageList);
    function GetTreeInitialized: boolean;
  protected
    procedure Loaded; override;
    procedure GetHintOnError; override;
    procedure Change; override;
    function GetDropDownControl: TWinControl; override;
    procedure Expanded(Sender: TObject; Node: TTreeNode); virtual;
    procedure Expanding(Sender: TObject; Node: TTreeNode;
      var AllowExpansion: Boolean); virtual;
    procedure Collapsed(Sender: TObject; Node: TTreeNode); virtual;
    procedure Collapsing(Sender: TObject; Node: TTreeNode;
      var AllowExpansion: Boolean); virtual;
    procedure CustomDrawItem(Sender: TCustomTreeView; Node: TTreeNode;
      State: TCustomDrawState; var DefaultDraw: Boolean); virtual;
    procedure WndProc(var Message: TMessage); override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure EMGetSel(var Message: TMessage); message EM_GETSEL;
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure WMLButtonDblClk(var Message: TWMLButtonDown); message WM_LBUTTONDBLCLK;
    procedure WMPaint (var Message: TWMPaint); message WM_PAINT;
    procedure WMSetCursor(var Message: TWMSetCursor); message WM_SETCURSOR;
    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SETFOCUS;
    procedure WMPaste(var Message: TWMPaste); message WM_PASTE;
    procedure WMChar(var Message: TWMChar); message WM_CHAR;
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure CMEnter(var Message: TCMEnter); message CM_ENTER;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
    procedure CMPopupWindow(var Message: TMessage); message CM_POPUPWINDOW;
    function DoMouseWheelDown(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    function DoMouseWheelUp(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    function CanSelectNode(Node: TTreeNode): boolean; virtual;
    procedure TreeViewDblClick(Sender: TObject); virtual;
    procedure TreeViewKeyPress(Sender: TObject; var Key: Char); virtual;
    procedure DefineBtnChoiceStyle; override;
    function GetTreeView: TTreeView;
    procedure SetText(Value: string); virtual;
    procedure ClearTreeItems; virtual;
    procedure CloseUp(State: Byte; bPerform: boolean = False); override;
    procedure ShowDropDown; override;
    property OnDrawText: TDCDrawItemEvent read  FOnDrawText write FOnDrawText;
    property Images: TImageList read FImages write SetImages;
    property Style: TTreeEditStyle read FStyle write SetStyle default teDropDownList;
    property OnClearItems: TTreeClearIteamEvent read FOnClearItems write FOnClearItems;
  public
    procedure CreateParams(var Params: TCreateParams); override;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure InitTree; virtual;
    procedure ChangeSelected(Sender: TObject; Node: TTreeNode); virtual;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KillFocus(var Value: boolean); override;
    function GetNode(Value: string; var Node: TTreeNode;
      var ErrorCode: integer): boolean; virtual;
    property TreeView: TTreeView read GetTreeView write SetTreeView;
    property Selected: TTreeNode read GetSelected write SetSelected;
    property TreeInitialized: boolean read GetTreeInitialized;
  published
    property DropDownWidth: integer read FDropDownWidth write FDropDownWidth
      default 0;
    property OnChange: TTVChangedEvent read FOnChange write FOnChange;
    property OnInitTree: TTEInitTreeEvent read FOnInitTree write FOnInitTree;
    property OnCollapsed: TTVExpandedEvent read FOnCollapsed write FOnCollapsed;
    property OnExpanded: TTVExpandedEvent read FOnExpanded write FOnExpanded;
    property OnCollapsing: TTVExpandingEvent read FOnCollapsing write FOnCollapsing;
    property OnExpanding: TTVExpandingEvent read FOnExpanding write FOnExpanding;
    property OnSetText: TNotifyEvent read FOnSetText write FOnSetText;
    property OnGetText: TTreeGetTextEvent read FOnGetText write FOnGetText;
    property OnCustomDrawItem: TTVCustomDrawItemEvent read FOnCustomDrawItem
      write FOnCustomDrawItem;
    property OnSelectNode: TTreeSelectNodeEvent read FOnSelectNode write FOnSelectNode;
  end;

  TDCTreeEdit = class(TDCCustomTreeEdit)
  public
    property ButtonEnabled;
  published
    property DrawStyle;
    property CheckGlyph;
    property OnDrawText;
    property ReadOnly;
    property Images;
    property Style;
    property OnClearItems;
    property EditMask;
    property OnCharCheck;
  end;

  TCustomEditForm = class(TCustomForm)
    {}
  end;

  TCreateEditFormEvent = procedure (Sender:TObject; var EditForm: TCustomForm) of object;

  TDCCustomFormEdit = class(TDCCustomChoiceEdit)
  private
    FEditForm: TCustomForm;
    FOnCreateEditForm: TCreateEditFormEvent;
    FEFNewWndProc: Pointer;
    FEFDefWndProc: Pointer;
    FInfoFieldWidth: integer;
    FOnDrawInfoText: TDrawInfoText;
    procedure EFWndProc(var Message: TMessage);
    procedure SetInfoFieldWidth(const Value: integer);
    function ExistInfo: boolean;
  protected
    function CreateEditForm(var EditForm: TCustomForm): boolean; virtual;
    procedure CloseUp(State: Byte; bPerform: boolean = False); override;
    procedure DoDrawMargins(DC: HDC); override;
    function GetDroppedDown: boolean; override;
    function GetDropDownControl: TWinControl; override;
    procedure GetFormResult(AEditForm: TCustomForm); virtual;
    procedure InitEditFromParams(AEditForm: TCustomForm); virtual;
    procedure DefineBtnChoiceStyle; override;
    procedure GetMargins(var LeftMargin: integer; var RightMargin: integer); override;
    procedure CMPopupWindow(var Message: TMessage); message CM_POPUPWINDOW;
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure ShowDropDown; override;
    procedure WndProcAction(Action: integer); override;
 public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
  published
    property OnCreateEditForm: TCreateEditFormEvent read FOnCreateEditForm
      write FOnCreateEditForm;
    property InfoFieldWidth: integer read FInfoFieldWidth write SetInfoFieldWidth;
    property OnDrawInfoText: TDrawInfoText read FOnDrawInfoText write FOnDrawInfoText;
  end;

implementation
uses DCResource, Clipbrd;

const
// Edits flag states
  EM_MOUSEACTIVATE   = $01;
  EM_CHANGED         = $02;
  EM_HOOKCHANGED     = $03;
  EM_VALUECHANGED    = $04;          // Edit Text Changed
  EM_SHOWERROR       = $05;
  EM_REQUIRED        = $06;          // required Edit.Text
  EM_DROPDOWNEXIST   = $07;          // Choice Button Exist
  EM_MOUSEDOWN       = $08;
  EM_MOUSEINCTRL     = $09;
  EM_HITCHECKAREA    = $0A;          // WMNCHitTest Mouse in CheckArea
  EM_HITBUTTONAREA   = $0B;          // WMNCHitTest Mouse in ButtonArea
  EM_SHOWCHECKBOX    = $0C;          // Check Box on left edit side
  EM_SAVEDSHOWHINT   = $0D;
  EM_BUTTONSDISABLED = $0E;          // Choice Button Disabled
  EM_WORDWRAP        = $0F;          // Word Warp in Edit area
  EM_MULTILINE       = $10;          // Multi line enabled
  EM_SHOWWEEK        = $11;          // DateEdit Week showing in Edit area
  EM_CTRLCHECKPROC   = $12;
  EM_SAVEDREADONLY   = $13;
  EM_DROPDOWNVISIBLE = $14;          // DropDown Control Visible
  EM_LOCKSETTINGS    = $15;          // Setting passwordchar
  EM_SKIPVALIDATE    = $16;          // Setting passwordchar

// TreeEdit flags
  TE_NODESELECTED    = $1A;          // DropDown TreeView Item selected
  TE_TREEINITIALIZE  = $1B;          // TreeView.Items initialized

// GridEdit flags
  GS_CLOSEDATASET    = $01;          // Need close DataSet after choose data
  GS_THREADINUSE     = $02;
  GS_VALUESELECTED   = $03;          // DropDown DBGrid Item selected
  GS_LISTBOXVISIBLE  = $04;
  GS_FULLQUERY       = $05;
  GS_SHOWINFOHINT    = $06;
  GS_NEEDLOCATE      = $07;
  GS_FASTSEARCH      = $08;

type
  TInternalControl = class(TWinControl)
    {}
  end;

const
  MIN_CMPSTR_LENGTH = 3;

  Digits: TCharSet  = ['0'..'9'];
  SetDateEdit: TCharSet = ['0'..'9', #8, #13, #9];

var
  ErrorHook: HHOOK;
  ErrorWindow: TDCErrorMessageWindow;
  HookControl: TDCCustomEdit;
  FocusedControl: TWinControl;

function ErrorGetMsgHook(nCode: Integer; wParam: Longint;
  var Msg: TMsg): Longint; stdcall;
begin
  Result := CallNextHookEx(ErrorHook, nCode, wParam, Longint(@Msg));
  if (nCode >= 0) and (Application <> nil) and (ErrorWindow <> nil) then
    with Msg do
    begin
      if (Message <> CM_CANCELMODE) and ((Message = CM_ACTIVATE) or
        (Message = CM_DEACTIVATE) or (Message = CM_APPKEYDOWN) or
        (Message = CM_APPSYSCOMMAND) or (Message = WM_COMMAND)) then
        PostMessage(HookControl.Handle, CM_ERRORMESSAGE, 0, 0);
    end;
end;

procedure HookErrorHooks;
begin
  if ErrorHook = 0 then
    ErrorHook := SetWindowsHookEx(WH_GETMESSAGE, @ErrorGetMsgHook, 0,
      GetCurrentThreadID);
end;

procedure UnHookErrorHooks;
begin
  if ErrorHook <> 0 then UnhookWindowsHookEx(ErrorHook);
  ErrorHook := 0;
end;

function GetDateMaskFormat: string;
 var
  i, j: integer;
  k: TDateFormatParts;
  SimpleFormat: TSimpleDateFormat;
  s: string;
  pValue: PChar;
begin
  DecodeDateFormat(SimpleFormat);
  for i := 1 to 3 do
  begin
    for k := Low(TDateFormatParts) to High(TDateFormatParts) do
    begin
      if SimpleFormat[k].Pos = i then
      begin
        SimpleFormat[k].Pos := 0;

        j := _intMax(2, SimpleFormat[k].Count);
        SetLength(s, j);
        pValue := PChar(s);
        FillChar(pValue^, j, Byte('0'));

        if i <> 3 then
          Result := Result + s + '|%0:s'
        else
          Result := Result + s;
          
        Break;
      end;
    end;
  end;
end;

constructor TDCCustomChoiceEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle:= ControlStyle + [csSetCaption, csClickEvents] + [csCaptureMouse];
  Ctl3D := False;
  FBtnChoiceStyle:= btsForm;
  FButtonStyle := esNormal;

  FGlyph := TBitmap.Create;
  FGlyph.Transparent := True;
  FGlyph.OnChange := GlyphChange;

  _setFlag(FFlags, EM_DROPDOWNEXIST, True);
  _setFlag(FFlags, EM_REQUIRED, False);
  _setFlag(FFlags, EM_MOUSEDOWN, False);
  _setFlag(FFlags, EM_SHOWCHECKBOX, False);
  _setFlag(FFlags, EM_BUTTONSDISABLED, False);
  _setFlag(FFlags, EM_MULTILINE, False);

  FChoiceButtonWidth := DEFAULT_BTN_WIDTH;
  FCheckGlyph := TBitmap.Create;

  FImage :=  TBitmap.Create;
  FImage.Transparent := True;

  SetRectEmpty(FMargins);
  FCheckGlyph.Transparent := True;
end;

procedure TDCCustomChoiceEdit.CreateParams(var Params: TCreateParams);
 const
   ESWordWraps: array[Boolean] of DWORD = (0, ES_AUTOHSCROLL);
   ESMultiLine: array[Boolean] of DWORD = (0, ES_MULTILINE);
 var
  LM, RM: integer;
begin
  inherited CreateParams(Params);
  with Params do
  begin
   GetMargins(LM, RM);
   Style := Style or WS_CLIPCHILDREN or
     ESMultiLine[(ButtonExist or MultiLine or not((LM = 0) and (RM = 0))) and
       (PasswordChar = #0)];
    Style := Style and not ESWordWraps[Flags[EM_WORDWRAP]];
    if FDrawStyle = fsNone then
      ExStyle := ExStyle and not WS_EX_CLIENTEDGE;
    if FDrawStyle = fsSingle then
      Style := Style or WS_BORDER;
  end;
end;

procedure TDCCustomChoiceEdit.CreateWnd;
begin
  inherited CreateWnd;
  DefineBtnChoice(FBtnChoiceStyle);
  SetEditRect;
end;

destructor TDCCustomChoiceEdit.Destroy;
begin
  Hide;
  if Assigned(FBtnChoice)
  then begin
    FBtnChoice.Free;
    FBtnChoice := nil;
  end;
  FCheckGlyph.Free;
  FImage.Free;
  FGlyph.Free;
  inherited Destroy;
end;

procedure TDCCustomChoiceEdit.CloseUp(State: Byte; bPerform: boolean);
 var
  ParentForm: TCustomForm;
  lDropDown: boolean;
begin
  if not DroppedDown then Exit;
  lDropDown := DroppedDown;

  if bPerform then
    Perform(CM_POPUPWINDOW, 0, 0)
  else
    PostMessage(Handle, CM_POPUPWINDOW, 0, 0);

  if lDropDown then WndProcAction(0);

  if lDropDown <> DroppedDown then
  begin
    ParentForm := GetParentForm(Self);
    if (ParentForm <> nil) and ParentForm.HandleAllocated then
      UpdateWindow(ParentForm.Handle);
  end;
end;

procedure TDCCustomChoiceEdit.CMEnabledChanged(var Message: TMessage);
begin
  if BtnChoiceAssigned then
  begin
    FBtnChoice.Enabled := Enabled;
    FBtnChoice.Paint(0);
  end;
  Invalidate;
  inherited;
end;

procedure TDCCustomChoiceEdit.WMSize(var Message: TWMSize);
begin
  inherited;
  if ButtonExist then DefineBtnChoice(FBtnChoiceStyle);
  SetEditRect;
end;

procedure TDCCustomChoiceEdit.DefineBtnChoice(BtnStyle: TChoiceBtnStyle);
 var
  R: TRect;
  lChanged: boolean;
begin
  if not (HandleAllocated and ButtonExist) then Exit;
  if not Assigned(FBtnChoice) then
  begin
    _setFlag(FFlags, EM_DROPDOWNEXIST, True);
    FBtnChoice := TDCEditButton.Create(Self);
    with FBtnChoice do
    begin
      SetBounds(Rect(0, 2, Self.ClientHeight, Self.ClientHeight+2));
      BrushColor := clBtnFace;
      Alignment := abCenter;
      OnClick    := ChoiceClick;
    end;
  end;
  FGlyph.OnChange := nil;
  lChanged := False;
  with FBtnChoice do
  begin
    EventStyle := FButtonStyle;
    Enabled := Self.Enabled and ButtonEnabled;
    Height := Self.ClientHeight;
    Top := 2;
    case BtnStyle of
      btsForm:
       begin
         lChanged := True;
         Glyph.LoadFromResourceName(HInstance, 'DC_FLATCHOICE');
         Width := DEFAULT_BTN_WIDTH;
         Options := Options - [boSimpleStyle];
       end;
      btsCombo :
       begin
         lChanged := True;
         Glyph.LoadFromResourceName(HInstance, 'DC_BTNCOMBO');
         Width := DEFAULT_BTN_WIDTH - 1;
         Options := Options + [boSimpleStyle];
       end;
      btsEllipsis:
       begin
         lChanged := True;
         Glyph.LoadFromResourceName(HInstance, 'DC_BTNELLIPSIS');
         Width := DEFAULT_BTN_WIDTH;
         Options := Options + [boSimpleStyle];
       end;
      btsCustom:
       begin
         if not Self.Glyph.Empty then Glyph.Assign(Self.Glyph);
         Width := FChoiceButtonWidth;
         Left  := Width - FBtnChoice.Width - 2;
       end;
    end;
    Left  := Self.Width - Width - 2;
    case FDrawStyle of
      fcsNormal: Style := stNormal;
      fsFlat:
        begin
          Style := stControlFlat;
        end;
      fsNone:
        begin
          Style := stNormal;
          Top := Top - 2;
          Left := Left + 2;
        end;
      fsSingle:
        begin
          Style := stSingle;
          Width := Width - 2;
          Height := Height + 2;
          Left := Left + 2;
          R := GetBounds;
          InflateRect(R, 1, 1);
          R.Right := R.Right - R.Left;
          R.Bottom := R.Bottom - R.Top;
          SetBounds(R);
        end;
    end;
    if HandleAllocated and (ButtonWidth > 0) then Paint(0);
    if Assigned(Glyph) and not Glyph.Empty and lChanged then
      Self.Glyph.Assign(Glyph);
  end;
  FGlyph.OnChange := GlyphChange;
  Invalidate;
end;

procedure TDCCustomChoiceEdit.SetGlyph(Value: TBitmap);
begin
  Glyph.Assign(Value);
end;

function TDCCustomChoiceEdit.GetGlyph: TBitmap;
begin
  Result := FGlyph;
end;

procedure TDCCustomChoiceEdit.SetEditRect;
 var
  TextMargin, TopMargin, RM, LM, h: integer;
  R: TRect;
  dwMargins: DWORD;
begin
 if HandleAllocated then
 begin
   TextMargin   := 0;
   TopMargin    := 0;

   case FDrawStyle of
     fsNone  :
      begin
        TopMargin    := 1;
        TextMargin   := 2;
      end;
     fsSingle  :
      begin
        TopMargin    := -1;
        TextMargin   := -1;
      end;
     fcsNormal,
     fsFlat:
      begin
        TopMargin    := 0;
        TextMargin   := 0;
     end;
   end;

   GetMargins(LM, RM);

   if PaintCheckGlyph then TextMargin := 0;
   if _getFlag(FFlags, EM_WORDWRAP) then Inc(RM);

   R := Rect(LM + TextMargin, TopMargin, Width - RM, Height + 1);

   dwMargins := SendMessage(Handle, EM_GETMARGINS, 0, 0);

   h := GetDCTextHeight(Font, 'W');
   R.Bottom := R.Top + _intMax(10, ((R.Bottom - R.Top) div h) * h + 2);

   SendMessage(Handle, EM_SETRECTNP, 0, LongInt(@R));

   SendMessage(Handle, EM_SETMARGINS, EC_LEFTMARGIN , MakeLong(dwMargins and $0000FFFF, 0));
   SendMessage(Handle, EM_SETMARGINS, EC_RIGHTMARGIN, MakeLong(0, dwMargins shr 16));
   SendMessage(Handle, EM_SCROLLCARET, 0, 0);

   FMargins   := R;
   FCheckWidth:= LM;
   DefineBtnChoiceStyle;

 end;
end;

procedure TDCCustomChoiceEdit.SetBtnChoiceStyle(Value : TChoiceBtnStyle);
begin
  if Value<>FBtnChoiceStyle
  then begin
    FBtnChoiceStyle := value;
    if Parent <> nil then
    begin
      DefineBtnChoice(value);
    end;
    SetEditRect;
  end;
end;

procedure TDCCustomChoiceEdit.KeyDown(var Key: Word; Shift: TShiftState);
 var
  KeyDownEvent: TKeyEvent;
  Msg: TMsg;

  procedure WantSpecialKey(var Key: Word);
  begin
    inherited KeyDown(Key, Shift);
    if (Key <> 0) and not _getFlag(FFlags, EM_MULTILINE) then
    begin
      if Perform(CM_WANTSPECIALKEY, Key, 0) = 0 then
        GetParentForm(Self).Perform(CM_DIALOGKEY, Key, 0);
    end;
    Key := 0;
  end;

begin
  KeyDownEvent := OnKeyDown;
  if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
  case Key of
    VK_F2:
      if Shift=[] then ChoiceButtonDown;
    VK_LEFT, VK_RIGHT:
      if (ErrorWindow <> nil) then
        with ErrorWindow.Buttons do
        begin
          if Count > 0 then
          begin
            case Key of
              VK_LEFT:
                SelectMoveBy(FocusedButton, -1, True);
              VK_RIGHT:
                SelectMoveBy(FocusedButton,  1, True);
            end;
          end;
          Key := 0;
        end;
    VK_RETURN:
      begin
        if (Key <> 0) and (ErrorWindow <> nil) and
          (ErrorWindow.Buttons.Count > 0) and (ErrorWindow.FocusedButton <> nil) then
        begin
          PeekMessage(Msg, 0, WM_CHAR, WM_CHAR, PM_REMOVE);
          ErrorWindow.FocusedButton.Click;
          Key := 0;
        end
        else
          WantSpecialKey(Key);
      end;
    VK_ESCAPE:
      begin
        if (Key <> 0) and (ErrorWindow <> nil) then
        begin
          HideErrorMessage;
          Key := 0;
        end
        else
          WantSpecialKey(Key);
      end;
    VK_SPACE:
        if (Key <> 0) and (ErrorWindow <> nil) then
        begin
          with ErrorWindow do
            if (Buttons.Count > 0) and (FocusedButton <> nil) then
            begin
              PeekMessage(Msg, 0, WM_CHAR, WM_CHAR, PM_REMOVE);
              FocusedButton.Click;
            end;
          Key := 0;
        end;
  end;
  if Key <> 0 then
  begin
    OnKeyDown := nil;
    inherited KeyDown(Key, Shift);
    OnKeyDown := KeyDownEvent;
  end;
end;

procedure TDCCustomChoiceEdit.KeyPress(var Key: Char);
  var
   DropDownControl: TInternalControl;
begin
  if DroppedDown then
  begin
    case Key of
      Char(VK_RETURN):
        begin
          CloseUp(1, True);
          if not _getFlag(FFlags, EM_MULTILINE) then Key := #0;
        end;
      else begin
        DropDownControl := TInternalControl(GetDropDownControl);
        if DropDownControl <> nil then
        begin
          DropDownControl.KeyPress(Key);
          Key := #0;
        end;
      end;
    end;
  end;
  inherited KeyPress(Key);
end;

procedure TDCCustomChoiceEdit.MouseUp(Button: TMouseButton;
  ShiftState: TShiftState; X, Y: Integer);
begin
  inherited MouseUp(Button, ShiftState, X, Y);
end;

procedure TDCCustomChoiceEdit.SetButtonExist(const Value: boolean);
begin
  if ButtonExist <> Value then
  begin
    _setFlag(FFlags, EM_DROPDOWNEXIST, Value);
    if ButtonExist then DefineBtnChoice(FBtnChoiceStyle)
    else begin
      if Assigned(FBtnChoice)
      then begin
        FBtnChoice.Free;
        FBtnChoice:= nil;
      end;
    end;
    SetEditRect;
    RecreateWnd;
  end;
end;

procedure TDCCustomChoiceEdit.ChoiceClick(Sender:TObject);
begin
  HideErrorMessage;
  if DroppedDown then
    CloseUp(0, True)
  else begin
    if Assigned(FOnButtonClick) then FOnButtonClick(Self);
    Perform(CM_POPUPWINDOW, 1, 0);
  end;
end;

procedure TDCCustomChoiceEdit.CMFontChanged(var Message: TMessage);
begin
  inherited;
  SetEditRect;
end;

procedure TDCCustomChoiceEdit.WMPaint(var Message: TWMPaint);
begin
  inherited;
  RedrawBorder(True, 0)
end;

procedure TDCCustomChoiceEdit.WMEraseBkGnd(var Message: TWMEraseBkGnd);
 var
  ARect: TRect;
begin
  ARect := ClientRect;
  if BtnChoiceAssigned then
  begin
    ARect.Right := FBtnChoice.Left;
    if FDrawStyle in [fsFlat, fsSingle] then Dec(ARect.Right, 3);
  end;
  if PaintCheckGlyph then ARect.Left  := ARect.Left+FCheckGlyph.Width;
  
  FillRect(TWMEraseBkGnd(Message).DC, ARect, Brush.Handle);
  Message.Result := 0;
end;

procedure TDCCustomChoiceEdit.WMNCPaint (var Message: TMessage);
begin
  RedrawBorder(True, 0);
end;

procedure TDCCustomChoiceEdit.WMMouseMove(var Message: TWMMouseMove);
 var
  lInherited: boolean;
begin
  Inherited;
  lInherited := True;
  if not(csDesigning in ComponentState) and (FDrawStyle = fsFlat) then
    UpdateMouseInControl(True);
  if BtnChoiceAssigned then
  begin
    with Message do FBtnChoice.UpdateButtonState( XPos, YPos,
      Flags[EM_MOUSEDOWN], True);
    if Flags[EM_HITBUTTONAREA] then lInherited := False;
  end;
  if lInherited then inherited;
end;

procedure TDCCustomChoiceEdit.WMSetCursor(var Message: TWMSetCursor);
begin
  if Flags[EM_HITBUTTONAREA]
  then
    SetCursor(LoadCursor(0, IDC_ARROW))
  else
    if Flags[EM_HITCHECKAREA] then
       SetCursor(LoadCursor(0, IDC_ARROW))
    else
       inherited;
end;

procedure TDCCustomChoiceEdit.WMSetFocus(var Message: TWMSetFocus);
begin
  inherited;
  SetCaret;
  if not(csDesigning in ComponentState) and (FDrawStyle = fsFlat) then
    UpdateMouseInControl(True);
end;

procedure TDCCustomChoiceEdit.CMCancelMode(var Message: TCMCancelMode);
begin
  inherited;
  if (Message.Sender <> Self) then
  begin
    CloseUp(0, True);
    _setFlag(FFlags, EM_MOUSEDOWN, False);
  end;
end;

procedure TDCCustomChoiceEdit.CMMouseEnter(var Message: TMessage);
 var
  APoint: TPoint;
  XPos, YPos: LongInt;
  lMouseDown: boolean;
begin
  inherited;
  if IsExistDragging then Exit;
  GetCursorPos(APoint);
  APoint := Self.ScreenToClient(APoint);
  XPos := APoint.X;
  YPos := APoint.Y;
  lMouseDown := Flags[EM_MOUSEDOWN];
  if lMouseDown then
  begin
    lMouseDown := lMouseDown and (GetAsyncKeyState(VK_LBUTTON) < 0);
    if not lMouseDown and BtnChoiceAssigned then
        FBtnChoice.UpdateButtonState( XPos, YPos, lMouseDown, False);
    _setFlag(FFlags, EM_MOUSEDOWN, lMouseDown);
  end;
  inherited;
  if not Flags[EM_MOUSEINCTRL] and (FDrawStyle = fsFlat) then
    UpdateMouseInControl(True);
end;

procedure TDCCustomChoiceEdit.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  if IsExistDragging then Exit;
  if BtnChoiceAssigned then FBtnChoice.UpdateButtonState(-1, -1, False, True);
  if not(Focused or DroppedDown) then UpdateMouseInControl(False);
end;

procedure TDCCustomComboBox.WMEraseBkGnd(var Message: TWMEraseBkGnd);
begin
  if FStyle = csDropDownList then
    Message.Result := 0
  else
   inherited;
end;

procedure TDCCustomChoiceEdit.WMLButtonDown(var Message: TWMLButtonDown);
begin
  _setFlag(FFlags, EM_MOUSEDOWN, True);
  if Flags[EM_HITCHECKAREA] then
  begin
     SetFocus;
     if Focused then CheckClick(Self);
     inherited;
     Exit;
  end;
  if not UpdateButtonsOnClick(Message.Pos.X, Message.Pos.Y) then
    inherited;
end;

procedure TDCCustomChoiceEdit.WMLButtonDblClk(var Message: TWMLButtonDown);
begin
  _setFlag(FFlags, EM_MOUSEDOWN, True);
  if Flags[EM_HITCHECKAREA] then
  begin
    SetFocus;
    if not DisableButtons and Focused then CheckClick(Self);
    Exit;
  end;
  if not UpdateButtonsOnClick(Message.Pos.X, Message.Pos.Y) then
  begin
    if Focused and BtnChoiceAssigned and not Flags[EM_HITBUTTONAREA] then
      if ButtonEnabled and (ButtonStyle=esDropDown) then
      begin
        if Message.Result = $AE then
          Message.Result := 0
        else begin
          with FBtnChoice do UpdateButtonState(Left+1, Top+1, True, False);
          Exit;
        end;
      end;
  end;
  if not Flags[EM_HITBUTTONAREA] then inherited;
end;

procedure TDCCustomChoiceEdit.WMLButtonUp(var Message: TWMLButtonUp);
begin
  _setFlag(FFlags, EM_MOUSEDOWN, False);
  if Focused then UpdateButtonsOnClick(Message.Pos.X, Message.Pos.Y);
  inherited;
end;

procedure TDCCustomChoiceEdit.RedrawBorder(DrawBorder: boolean; Clip: HRGN);
 var
  DC: HDC;
  R: TRect;
  BtnFaceBrush, WindowBrush: HBRUSH;
  TopLeft, Offset: TPoint;
begin
  DC := GetWindowDC(Handle);
  WindowBrush := 0;
  if (Clip <> 0) then SelectClipRgn(DC, Clip);

  try
    GetWindowRect(Handle, R);  OffsetRect(R, -R.Left, -R.Top);
    BtnFaceBrush:= GetSysColorBrush(COLOR_BTNFACE);
    WindowBrush := CreateSolidBrush(ColorToRGB(Color)); //GetSysColorBrush(COLOR_WINDOW);

    if PaintCheckGlyph then
    begin
      if FCheckWidth = 0 then SetEditRect;
      Offset.X := (Width  - ClientWidth)  div 2;
      Offset.Y := (Height - ClientHeight) div 2;

      FImage.Width  := FCheckGlyph.Width+2;
      FImage.Height := ClientHeight;
      with FImage, FImage.Canvas do
      begin
        Brush.Color := Self.Color;
        FillRect(Rect(0, 0, Width, Height));
        TopLeft.X := 1;
        if ClientHeight > FCheckGlyph.Height then
          TopLeft.Y := (ClientHeight-FCheckGlyph.Height) shr 1
        else
          TopLeft.Y := 0;
        StretchDraw(Rect(TopLeft.X, TopLeft.Y, Width-1,
                         TopLeft.Y+FCheckGlyph.Height),
                    FCheckGlyph);
      end;
      if not Enabled then  TransformBitmap(FImage, FImage, tsDisable);
      BitBlt(DC, Offset.X, Offset.Y, FImage.Width,
        _intMin(FImage.Height, Height - Offset.Y), FImage.Canvas.Handle, 0, 0, SRCCOPY);
    end;

    DoDrawMargins(DC);

    if DrawBorder then
    begin
      DoDrawButtons(DC);
      case FDrawStyle of
       fsFlat:
         begin
           if ((csDesigning in ComponentState) and Enabled) or
               (not(csDesigning in ComponentState) and
               (Focused or Flags[EM_MOUSEINCTRL]))
           then begin
             DrawEdge(DC, R, BDR_SUNKENOUTER, BF_RECT or BF_ADJUST);
             with R do begin
               FillRect(DC, Rect(Left, Top, Left+1, Bottom-1), BtnFaceBrush);
               FillRect(DC, Rect(Left, Top, Right-1, Top+1), BtnFaceBrush);
             end;
             DrawEdge(DC, R, BDR_SUNKENINNER, BF_BOTTOMRIGHT);
             InflateRect(R, -1, -1);
             if BtnChoiceAssigned then
               with R do
                 FillRect(DC, Rect(FBtnChoice.Left - 1, Top - 1,
                   FBtnChoice.Left, Bottom+1), BtnFaceBrush);
           end
           else begin
             if BtnChoiceAssigned then
               with R do
                FillRect(DC, Rect(FBtnChoice.Left-1, Top-1, FBtnChoice.Left,
                  Bottom+1), WindowBrush);
             DrawEdge(DC, R, BDR_SUNKENOUTER, BF_TOPLEFT);
             DrawEdge(DC, R, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
             InflateRect(R,-1,-1);
             FrameRect(DC, R, WindowBrush);
             InflateRect(R,-1,-1);
             FrameRect(DC, R, WindowBrush);
           end;
         end;
       fcsNormal:
         begin
           DrawEdge(DC, R, BDR_SUNKENOUTER, BF_RECT);
           InflateRect(R,-1,-1);
           DrawEdge(DC, R, BDR_SUNKENINNER, BF_RECT);
         end;
       fsNone:
         begin
           {}
         end;
       fsSingle:
         begin
           DrawEdge(DC, R, BDR_SUNKENOUTER, BF_TOPLEFT);
           DrawEdge(DC, R, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
           InflateRect(R,-1,-1);
           FrameRect(DC, R, WindowBrush);
           InflateRect(R,-1,-1);
           FrameRect(DC, R, WindowBrush);
           if FBtnChoice <> nil then
           begin
             R := FBtnChoice.GetBounds;
             InflateRect(R, 1, 0);
             DrawEdge(DC, R, BDR_SUNKENOUTER, BF_LEFT);
           end;
         end;
      end;
    end;

  finally
    ReleaseDC(Handle, DC);
    DeleteObject(WindowBrush);
  end;
end;

procedure TDCCustomChoiceEdit.UpdateMouseInControl(Value: boolean);
begin
  if (Flags[EM_MOUSEINCTRL] <> Value) then
  begin
    _setFlag(FFlags, EM_MOUSEINCTRL, Value);
    if BtnChoiceAssigned then FBtnChoice.MouseInControl := Value;
    if FDrawStyle = fsFlat then RedrawBorder(True, 0);
  end;
end;

procedure TDCCustomChoiceEdit.SetChoiceButtonWidth(Value: integer);
begin
  if FChoiceButtonWidth <> Value then
  begin
    ButtonChoiceStyle  := btsCustom;
    FChoiceButtonWidth := Value;
    RedrawBorder(True, 0);
    DefineBtnChoice(FBtnChoiceStyle);
    SetEditRect;
    if BtnChoiceAssigned then FBtnChoice.Paint(0);
  end;
end;

function TDCCustomChoiceEdit.GetButtonStyle: TEventStyle;
begin
  if Assigned(FBtnChoice) then
    Result := FBtnChoice.EventStyle
  else
    Result := FButtonStyle
end;

procedure TDCCustomChoiceEdit.SetButtonStyle(Value: TEventStyle);
begin
  if Value <> GetButtonStyle then
  begin
    FButtonStyle := Value;
    if Assigned(FBtnChoice) then
    begin
       FBtnChoice.EventStyle := Value;
       if ButtonWidth > 0 then FBtnChoice.Paint(0);
    end
  end;
end;

function TDCCustomChoiceEdit.GetButtonState: TButtonState;
begin
  if Assigned(FBtnChoice) then
    Result := FBtnChoice.ButtonState
  else 
    Result := btRest
end;

procedure TDCCustomChoiceEdit.SetButtonState(Value: TButtonState);
begin
  if Value <> GetButtonState then
  begin
    if Assigned(FBtnChoice) then FBtnChoice.ButtonState := Value;
  end;
end;

procedure TDCCustomChoiceEdit.SetCheckGlyph(Value: TBitmap);
begin
  if Value <> FCheckGlyph then
  begin
    FCheckGlyph.Assign(Value);
    SetEditRect;
    Invalidate;
  end;
end;

procedure TDCCustomChoiceEdit.Loaded;
begin
  inherited;
  SetEditRect;
end;

procedure TDCCustomChoiceEdit.WMNCHitTest(var Message: TWMNCHitTest);
 var
  P: TPoint;
begin
  P := Self.ScreenToClient(Point(Message.XPos, Message.YPos));

  if ShowCheckBox and Assigned(FCheckGlyph) and (P.X < FCheckGlyph.Width) and
     ((Width - FCheckGlyph.Width) >= MinControlWidthBitmap) then
    _setFlag(FFlags, EM_HITCHECKAREA, True)
  else
    _setFlag(FFlags, EM_HITCHECKAREA, False);

  if BtnChoiceAssigned and (P.X >= (Width - ButtonWidth - 2)) then
    _setFlag(FFlags, EM_HITBUTTONAREA, True)
  else
    _setFlag(FFlags, EM_HITBUTTONAREA, False);

  inherited;
end;

procedure TDCCustomChoiceEdit.CheckClick(Sender: TObject);
begin
   HideCaret(Handle);
   HideErrorMessage;
   if DisableButtons then Exit;
   if not Focused then SetFocus;
   if Focused and Assigned(FOnCheckClick) then FOnCheckClick(Self);
end;

function TDCCustomChoiceEdit.UpdateButtonsOnClick(X, Y: integer): boolean;
 var
  ButtonUpdate: boolean;
begin
  Result := False;
  if BtnChoiceAssigned and Flags[EM_HITBUTTONAREA] then
  begin
    if not Focused then SetFocus;
    if Focused then
      ButtonUpdate :=FBtnChoice.UpdateButtonState(X, Y, Flags[EM_MOUSEDOWN],
        False)
    else begin
      ButtonUpdate := False;
      Result := True;
    end;
    if ButtonUpdate and FBtnChoice.MouseInRect(X, Y) then Result := True;
  end;
end;

procedure TDCCustomChoiceEdit.SetParent(AParent: TWinControl);
 var
  lAllocate: boolean;
begin
  lAllocate := not HandleAllocated;
  inherited;
  if lAllocate and (AParent <> nil) then
  begin
     DefineBtnChoice(FBtnChoiceStyle);
     SetEditRect;
     if BtnChoiceAssigned then
     begin
       if not FGlyph.Empty then SetGlyph(FGlyph);
       FBtnChoice.Paint(0);
     end;
  end;
end;

function TDCCustomChoiceEdit.GetButtonEnabled: boolean;
begin
  if Assigned(FBtnChoice) then Result := FBtnChoice.Enabled
  else Result := True
end;

procedure TDCCustomChoiceEdit.SetButtonEnabled(Value: boolean);
begin
  if Assigned(FBtnChoice) and (Value <> FBtnChoice.Enabled) then
    FBtnChoice.Enabled := Value;
end;

procedure TDCCustomChoiceEdit.SetShowCheckBox(Value: boolean);
begin
  if ShowCheckBox <> Value then
  begin
    _setFlag(FFlags, EM_SHOWCHECKBOX, Value);
    SetEditRect;
    Invalidate;
  end;
end;

procedure TDCCustomChoiceEdit.CMExit(var Message: TCMExit);
begin
  CloseUp(0, True);
  inherited;
  if not(csDesigning in ComponentState) and (FDrawStyle = fsFlat)  and
     not ShowError then UpdateMouseInControl(False);
end;

procedure TDCCustomChoiceEdit.CMEnter(var Message: TCMEnter);
begin
  inherited;
end;

procedure TDCCustomChoiceEdit.KillFocus(var Value: boolean);
begin
  if not Value and CanModified and Flags[EM_REQUIRED] and (Trim(Text) = '') then
  begin
    Value := True;
    ErrorCode := ERR_EDIT_EMPTYVALUE;
  end;
  inherited;
end;

procedure TDCCustomChoiceEdit.PaintWindow(DC: HDC);
begin
  inherited PaintWindow(DC);
end;

function TDCCustomChoiceEdit.MinControlWidthBitmap: integer;
 var
  CharWidth: integer;
begin
  if HandleAllocated then
    CharWidth := GetCharWidth(Handle, Font) + 2
  else
    CharWidth := 12;

  if Assigned(FBtnChoice) then
    Result := FBtnChoice.Width + 5 + CharWidth
  else
    Result :=  5 + CharWidth;
end;

function TDCCustomChoiceEdit.BtnChoiceAssigned: boolean;
begin
  Result := Assigned(FBtnChoice);
end;

procedure TDCCustomChoiceEdit.EMSetReadOnly(var Message: TMessage);
begin
  inherited;
  //DisableButtons := boolean(Message.wParam);
end;

procedure TDCCustomChoiceEdit.SetDisableButtons(const Value: boolean);
begin
  if DisableButtons <> Value then
  begin
    _setFlag(FFlags, EM_BUTTONSDISABLED, Value);
    SetButtonEnabled(not DisableButtons);
    RedrawBorder(False, 0);
  end;
end;

procedure TDCCustomChoiceEdit.SetDrawStyle(const Value: TControlStyle);
begin
  if FDrawStyle <> Value then
  begin
    FDrawStyle := Value;
    DefineBtnChoice(FBtnChoiceStyle);
    SetEditRect;
    RecreateWnd;
  end;
end;

function TDCCustomChoiceEdit.GetDrawStyle: TControlStyle;
begin
  Result := FDrawStyle;
end;

function TDCCustomChoiceEdit.GetButtonExist: Boolean;
begin
  Result := _getFlag(FFlags, EM_DROPDOWNEXIST) and (PasswordChar = #0);
end;

function TDCCustomChoiceEdit.GetBoundsRect: TRect;
begin
  Result := Rect(Left, Top, Left + Width, Top + Height);
end;

function TDCCustomChoiceEdit.GetShowCheckBox: boolean;
begin
  Result := _getFlag(FFlags, EM_SHOWCHECKBOX);
end;

function TDCCustomChoiceEdit.GetDisableButtons: boolean;
begin
  Result := _getFlag(FFlags, EM_BUTTONSDISABLED);
end;

function TDCCustomChoiceEdit.GetWordWrap: Boolean;
begin
  Result := _getFlag(FFlags, EM_WORDWRAP);
end;

function TDCCustomChoiceEdit.GetMultiLine: boolean;
begin
  Result := _getFlag(FFlags, EM_MULTILINE);
end;

procedure TDCCustomChoiceEdit.SetMultiLine(const Value: boolean);
begin
  if Value <> _getFlag(FFlags, EM_MULTILINE) then
  begin
    _setFlag(FFlags, EM_MULTILINE, Value);
    RecreateWnd;
  end;
end;

procedure TDCCustomChoiceEdit.ShowDropDown;
begin
  WndProcAction(1);
end;

procedure TDCCustomChoiceEdit.CMColorChanged(var Message: TMessage);
begin
  inherited;
  InvalidateRect(Handle, nil, True);
end;

procedure TDCCustomChoiceEdit.SetWordWrap(const Value: Boolean);
begin
  if Value <> Flags[EM_WORDWRAP] then
  begin
    _setFlag(FFlags, EM_WORDWRAP, Value);
    RecreateWnd;
  end;
end;

procedure TDCCustomChoiceEdit.WMCancelMode(var Message: TMessage);
begin
  inherited;
  CloseUp(0, True);
  _setFlag(FFlags, EM_MOUSEDOWN, False);
end;

procedure TDCCustomChoiceEdit.WndProcAction(Action: integer);
begin
  inherited;
  if not (csDesigning in ComponentState) then
  begin
    case Action of
      0: UnHookPopupHooks;
      1: HookPopupHooks(Self, GetCurrentThreadID);
    end;
  end;
end;

procedure TDCCustomChoiceEdit.DoDrawButtons(DC: HDC);
begin
  if BtnChoiceAssigned then
    with FBtnChoice do
    begin
      Paint(0);
      ExcludeClipRect(DC, Left, Top, Left + Width, Top + Height);
    end;
end;

procedure TDCCustomChoiceEdit.GlyphChange(Sender: TObject);
begin
  if HandleAllocated and Assigned(FBtnChoice) then
  begin
    FGlyph.Transparent := True;
    FBtnChoiceStyle  := btsCustom;
    FBtnChoice.Glyph.Assign(FGlyph);
    if not Assigned(FGlyph) then
      SetChoiceButtonWidth(DEFAULT_BTN_WIDTH)
    else
      SetChoiceButtonWidth(FGlyph.Width + 6);

    FBtnChoice.Width := FChoiceButtonWidth;
  end;
end;

function TDCCustomChoiceEdit.PaintCheckGlyph: boolean;
begin
  Result := ShowCheckBox and Assigned(FCheckGlyph) and not FCheckGlyph.Empty and
     ((Width-FCheckGlyph.Width) >= MinControlWidthBitmap);
end;

procedure TDCCustomChoiceEdit.WMSysCommand(var Message: TWMSysCommand);
begin
  inherited;
end;

procedure TDCCustomChoiceEdit.ChoiceButtonDown;
begin
  if BtnChoiceAssigned and (ButtonStyle = esDropDown) then
  begin
    with FBtnChoice do UpdateButtonState(Left + 1, Top + 1, True, False);
  end;
end;

procedure TDCCustomChoiceEdit.SetDroppedDown(const Value: boolean);
begin
  if Value then
    ChoiceButtonDown
  else
    CloseUp(0, True);
  _setFlag(FFlags, EM_DROPDOWNVISIBLE, Value);
end;

procedure TDCCustomChoiceEdit.EMSetPasswordChar(var Message: TMessage);
begin
  if not _getFlag(FFLags, EM_LOCKSETTINGS) then
  begin
    _setFlag(FFLags, EM_LOCKSETTINGS, True);
    if Char(Perform(EM_GETPASSWORDCHAR, 0, 0)) <> PasswordChar then
    begin
      RecreateWnd;
      ButtonExist := _getFlag(FFlags, EM_DROPDOWNEXIST);
    end
    else
      inherited;
    _setFlag(FFLags, EM_LOCKSETTINGS, False);
  end;
end;

procedure TDCCustomChoiceEdit.CMPopupWindow(var Message: TMessage);
begin
  case Message.WParam of
    0: if BtnChoiceAssigned then FBtnChoice.ResetProperties;
    1: _setFlag(FFlags, EM_DROPDOWNVISIBLE, True);
  end;
end;

{ TDCComboBox }

procedure TDCCustomComboBox.CloseUp(State: Byte; bPerform: boolean = False);
 var
  AText: string;
  AItemIndex: integer;
begin
  case State of
     0:
       begin
         SelLength := 0;
         inherited;
       end;
     1:
       begin
         AText := Text;
         AItemIndex := -1;
         if DroppedDown then with FListBox do
         begin
           if ItemIndex >= 0 then
           begin
             AText := Items[ItemIndex];
             AItemIndex := ItemIndex;
           end;
         end;
         SetText(AText, AItemIndex, 0, -1);
         FLastText := Text;
         FLastIndex := FItemIndex;
         inherited;
       end;
  end;
end;

procedure TDCCustomComboBox.CMCancelMode(var Message: TCMCancelMode);
begin
  if (Message.Sender <> Self) and
     (Message.Sender <> FListBox) and
     not FListBox.ContainsControl(Message.Sender) then
  begin
    inherited;
  end;
end;

constructor TDCCustomComboBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FItems := TStringList.Create;
  _setFlag(FFlags, EM_DROPDOWNVISIBLE, False);
  FItemIndex := -1;
  FEditing   := False;
  FDropDownCount := 8;
end;

procedure TDCCustomComboBox.CreateParams(var Params: TCreateParams);
begin
  inherited;
  if NotEditControl then
  begin
    with Params do
    begin
      Text  := Name;
      Style := WS_CHILD or WS_CLIPSIBLINGS;
      AddBiDiModeExStyle(ExStyle);
      if csAcceptsControls in ControlStyle then
      begin
        Style := Style or WS_CLIPCHILDREN;
        ExStyle := ExStyle or WS_EX_CONTROLPARENT;
      end;
      if FDrawStyle = fsNone then
        ExStyle := ExStyle and not WS_EX_CLIENTEDGE;
      if FDrawStyle = fsSingle then
        Style := Style or WS_BORDER;
      if not (csDesigning in ComponentState) and not Enabled then
        Style := Style or WS_DISABLED;
      if TabStop then Style := Style or WS_TABSTOP;
      if Parent <> nil then 
        WndParent := Parent.Handle 
      else
        WndParent := ParentWindow;
      with WindowClass do
      begin 
        Style := CS_VREDRAW or CS_HREDRAW or CS_DBLCLKS;
        lpfnWndProc := @DefWindowProc;
        hCursor := LoadCursor(0, IDC_ARROW);
        hbrBackground := 0;
      end;
      WindowClass.hInstance := HInstance;
      StrPCopy(WinClassName, ClassName);
    end;
  end
end;

destructor TDCCustomComboBox.Destroy;
begin
  FItems.Free;
  FItems := nil;
  inherited;
end;

procedure TDCCustomComboBox.DrawBitmap(Index: integer);
 var
  R: TRect;
  AWidth, AHeight: integer;
begin
  if Assigned(FOnDrawBitmap) and Assigned(FCheckGlyph) then
  begin
    with FCheckGlyph, FCheckGlyph.Canvas do
    begin
      R := Rect(0,0, Width, Height);
      FillRect(R);
    end;
    AWidth  := FCheckGlyph.Width;
    AHeight := FCheckGlyph.Height;
    FOnDrawBitmap(Self, R, Index, FCheckGlyph);
    if (AWidth  <> FCheckGlyph.Width)  or
       (AHeight <> FCheckGlyph.Height)
    then
      SetEditRect;
  end;
end;

function TDCCustomComboBox.GetCanvas: TCanvas;
begin
  if _getFlag(FFlags, EM_DROPDOWNVISIBLE) then
     Result := FListBox.Canvas
  else
     Result := nil;
end;

procedure TDCCustomComboBox.GetEntryText;
 var
   TextLen, Index: integer;
begin
  if (Length(Text) >= MIN_CMPSTR_LENGTH) and not ReadOnly then
  begin
    TextLen := Length(Text);
    Index   := GetFirstEntry(True);
    if Index <> -1 then
    begin
      SetText(Items[Index], Index, Length(Items[Index]), TextLen );
      Invalidate;
    end;
  end;
end;

function TDCCustomComboBox.GetFirstEntry(PartWord: boolean): integer;
 var
  i, j: integer;
  Value, ItemString: string;
  Found: boolean;
begin
    Value := Text;
    i := 0;
    Found := False;
    while (i <= Items.Count-1) and not Found do
    begin
      ItemString := Items[i];
      j := 1;
      if Length(Value) > Length(ItemString) then
      begin
        Inc(i);
        continue;
      end;
      while (j <= Length(Value)) and (j <= Length(ItemString)) and
            (AnsiUpperCase(Value[j]) = AnsiUpperCase(ItemString[j]) ) do
      begin
        Inc(j);
      end;

      if (j > Length(Value)) and
         (PartWord or (Length(Value) = Length(ItemString)))
      then
        Found := True
      else
        Inc(i);
    end;
    if Found then Result := i else Result := -1;
end;

procedure TDCCustomComboBox.KeyDown(var Key: Word; Shift: TShiftState);
 var
  Index: integer;
  KeyDownEvent: TKeyEvent;
begin
  KeyDownEvent := OnKeyDown;
  if DroppedDown then
    case Key of
      VK_PRIOR,
      VK_NEXT ,
      VK_UP   ,
      VK_DOWN   :
        begin
          if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
          if FListBox.ItemIndex = -1 then
            FListBox.ItemIndex := 0
          else
            SendMessage(FListBox.Handle, WM_KEYDOWN, Key, 0);
          if (FListBox.Items.Count > FListBox.ItemIndex) and
            (FListBox.ItemIndex <> -1) then
            SetText(FListBox.Items[FListBox.ItemIndex], FListBox.ItemIndex, 0, -1);
          Key := 0;
        end;
      VK_ESCAPE:
        begin
          SetText(FCachedText, FCachedIndex, 0, -1);
          CloseUp(0, True);
          Key := 0;
        end;
    end
  else begin
    if [ssAlt]*Shift = [ssAlt] then
      case Key of
        VK_DOWN:
          if FStyle <> csSimple then
          begin
            if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
            if Key <> 0 then ChoiceButtonDown;
            Key := 0;
          end;
      end
    else begin
      case Key of
         VK_UP, VK_DOWN:
           begin
             if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
             if (not ReadOnly) and (Key <>0) then
             begin
               if FItemIndex = -1 then
                  Index := GetFirstEntry(False)
               else
                  Index := FItemIndex;
               if Key = VK_UP then Dec(Index) else Inc(Index);
               if Index < 0 then Index := 0;
               if (Index + 1) <= FItems.Count then SetText(Items[Index], Index, 0, -1);
               Key := 0;
             end;
           end;
         VK_DELETE:
           begin
             if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
             if Key <> 0 then
             begin
               if not ReadOnly then  FItemIndex := -1;
               OnKeyDown := nil;
               inherited KeyDown(Key, Shift);
               OnKeyDown := KeyDownEvent;
               Key := 0;
             end;
           end;
         VK_ESCAPE:
           SetText(FLastText, FLastIndex, -1, 0);
      end;
    end;
  end;
  if Key <> 0 then inherited;
end;

procedure TDCCustomComboBox.KillFocus(var Value: boolean);
begin
 if CanModified then
 begin
   if not Value and Flags[EM_REQUIRED] and (Trim(Text) = '') then
   begin
     Value := True;
     ErrorCode := ERR_EDIT_EMPTYVALUE;
   end;
   if not Value and (FStyle = csDropDownList) and (FItemIndex = -1) and
     (Trim(Text) <> '') then
   begin
     Value := True;
     ErrorCode := ERR_COMBO_ILLIGALVALUE;
   end;
 end;
 inherited KillFocus(Value);
end;

procedure TDCCustomComboBox.ListMouseUp(Sender: TObject;
   Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  inherited;
  if Button = mbLeft then CloseUp(1, True);
end;

procedure TDCCustomComboBox.SetItemIndex(const Value: integer);
 var
  sText: string;
begin
  if (FItems.Count > 0) and (Value > -1) and (Value < FItems.Count)
    then
      sText := FItems.Strings[Value]
    else
      sText := '';

  if (FItemIndex <> Value) or (Text <> sText) then
  begin
    FItemIndex := Value;
    Text := sText;
    if Assigned(FOnIndexChange) then FOnIndexChange(Self);
    Invalidate;
  end;
end;

procedure TDCCustomComboBox.SetItems(const Value: TStrings);
begin
  FItems.Assign(Value);
end;

procedure TDCCustomComboBox.SetComboBoxStyle(const Value: TComboBoxStyle);
begin
  if FStyle <> Value then
  begin
    FStyle := Value;
    case FStyle of
       csDropDown:
         ButtonExist := True;
       csSimple:
         ButtonExist := False;
       csDropDownList:
         begin
           ButtonExist := True;
           Text := ''
         end;
       csOwnerDrawFixed:
         ButtonExist := True;
       csOwnerDrawVariable:
         ButtonExist := True;
    end;
    RecreateWnd;
  end;
end;

procedure TDCCustomComboBox.SetText(Value: string; ItemIndex: integer;
  ASelStart, ASelLen: integer);
begin
  if (Text <> Value) or (Self.ItemIndex <> ItemIndex) then
  begin
    Self.ItemIndex := ItemIndex;
    Text := Value;
    SendMessage(Handle, EM_SETSEL, ASelLen, ASelStart);
    if (FStyle = csDropDownList) then Change;
  end;
end;

procedure TDCCustomComboBox.FindNextItem(cFirstChar: char);
 var
  ItemPos, i: integer;
  Found: boolean;
begin
  if ReadOnly then Exit;
  ItemPos := FItemIndex;
  i := ItemPos+1;
  Found := False;
  while i<=(FItems.Count-1) do
  begin
    if i < 0 then
    begin
      Inc(i);
      continue;
    end;
    if FItems.Strings[i][1] = cFirstChar then
    begin
      Found := True;
      break;
    end;
    Inc(i);
  end;

  if Found then
    SetText(Items[i], i, 0, 0 )
  else begin
    i := 0;
    Found := False;
    while i<=(ItemPos-1) do
    begin
      if FItems.Strings[i][1] = cFirstChar then
      begin
        Found := True;
        break;
      end;
      Inc(i);
    end;
  end;

  if Found then
  begin
    SetText(Items[i], i, 0, 0 );
    if _getFlag(FFlags, EM_DROPDOWNVISIBLE) then FListBox.ItemIndex := i;
  end;
end;

procedure TDCCustomComboBox.WMChar(var Message: TWMChar);
 function ProcessChar_0: boolean;
 begin
   Result := not((Message.CharCode in [0, 13, 27]) or ReadOnly)
 end;

 function ProcessChar_1: boolean;
 begin
   Result := not((Message.CharCode in [0, 8, 13, 27]) or ReadOnly)
 end;
begin
  if not NotEditControl then
  begin
    if ProcessChar_0 then FItemIndex := -1;
    inherited;
    if ProcessChar_1 then GetEntryText;
    if _getFlag(FFlags, EM_DROPDOWNVISIBLE) then FListBox.ItemIndex := ItemIndex;
  end
  else begin
    FindNextItem(Char(Message.CharCode));
    inherited;
  end;
end;

procedure TDCCustomComboBox.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  Message.Result := DLGC_WANTARROWS or DLGC_WANTCHARS or DLGC_WANTALLKEYS;
end;

procedure TDCCustomComboBox.WMKillFocus(var Message: TWMKillFocus);
begin
  if Assigned(FItems) and (FItemIndex =-1) then FItemIndex := GetFirstEntry(False);
  inherited;
  if Assigned(FItems) then PaintListItem(False);
end;

procedure TDCCustomComboBox.PaintListItem(bFocused: boolean);
const
  Alignments: array[Boolean, TAlignment] of DWORD =
    ((DT_LEFT, DT_RIGHT, DT_CENTER),(DT_RIGHT, DT_LEFT, DT_CENTER));
 var
  DC: HDC;
  R: TRect;
  ACanvas: TCanvas;
begin
  if not NotEditControl then Exit;

  ACanvas := TControlCanvas.Create;

  DC := GetWindowDC(Handle);

  GetWindowRect (Handle, R);  OffsetRect (R, -R.Left, -R.Top);
  if PaintCheckGlyph  then R.Left := R.Left + FCheckGlyph.Width + 2;
  if ButtonWidth > 0 then
  begin
    R.Right := R.Right - ButtonWidth;
    if FDrawStyle = fsFlat then R.Right := R.Right - 1
  end;
  case FDrawStyle of
    fsNone  :
     begin
       InflateRect(R, -1, -1);
       R.Left := R.Left -1;
     end;
    fsSingle  :
     begin
       InflateRect(R, -2, -2);
       R.Right := R.Right -1;
     end;
    fcsNormal,
    fsFlat  :
     InflateRect(R, -3, -3);
  end;

  ACanvas.Handle := DC;
  ACanvas.Font         := Font;
  ACanvas.Brush.Color  := Color;
  InflateRect(R, 1, 1);
  FillRect(ACanvas.Handle, R, ACanvas.Brush.Handle);
  InflateRect(R, -1, -1);

  if bFocused then
  begin
    ACanvas.Brush.Color := clHighlight;
    ACanvas.Font.Color  := clHighlightText;
  end;

  try
    if FDrawStyle = fsNone then
      R.Left  := R.Left  +1;
    FillRect(ACanvas.Handle, R, ACanvas.Brush.Handle);
    if bFocused then DrawFocusRect(ACanvas.Handle, R);
    InflateRect(R, -1, -1);
    SetBkMode(ACanvas.Handle, TRANSPARENT);
    case FDrawStyle of
      fcsNormal,
      fsFlat  ,
      fsNone  : R.Top  := R.Top  -1;
    end;
    if (FItems.Count > 0) and (FItemIndex > -1) and (FItemIndex < FItems.Count)
      then
        Text := FItems.Strings[FItemIndex]
      else
        Text := '';

    if Assigned(FOnDrawText) then
      FOnDrawText(ACanvas, Self, FItemIndex, R, [])
    else
      DrawText(ACanvas.Handle, PChar(Text), Length(Text), R,
        Alignments[UseRightToLeftAlignment, FAlignment]);
  finally
    ReleaseDC(Handle, DC);
    ACanvas.Handle := 0;
    ACanvas.Free;
  end;
end;

procedure TDCCustomComboBox.WMPaint(var Message: TWMPaint);
 var
  PS: TPaintStruct;
begin
  DrawBitmap(FItemIndex);
  if not NotEditControl then
    inherited
  else begin
   BeginPaint(Handle, PS);
   RedrawBorder(True, 0);
   PaintListItem(Focused and not _getFlag(FFlags, EM_DROPDOWNVISIBLE));
   EndPaint(Handle, PS);
 end;
end;

procedure TDCCustomComboBox.WMSetFocus(var Message: TWMSetFocus);
begin
  FLastText := Text;
  FLastIndex:= FItemIndex;
  inherited;
  if NotEditControl then HideCaret(Handle);
end;

procedure TDCCustomComboBox.WndProc(var Message: TMessage);
 var
   lFocused: boolean;
begin
  lFocused := Focused;
  inherited WndProc(Message);
  if csDesigning in ComponentState then Exit;
  case Message.Msg of
    WM_LBUTTONDOWN, WM_LBUTTONDBLCLK:
      begin
        if NotEditControl and
          not(Flags[EM_HITBUTTONAREA] or Flags[EM_HITCHECKAREA]) then
        begin
          if not Focused then SetFocus;
          if Focused then
            with FBtnChoice do UpdateButtonState(Left+1, Top+1, True, False);
        end;
        if not NotEditControl and not lFocused then SelectAll;
      end;
  end;
end;

procedure TDCCustomComboBox.CMEnter(var Message: TCMEnter);
begin
  inherited;
  PaintListItem(Focused);
end;

function TDCCustomComboBox.NotEditControl: boolean;
begin
  Result := (FStyle = csDropDownList) and not FEditing;
end;

function TDCCustomComboBox.GetDropDownControl: TWinControl;
begin
  if DroppedDown then Result := FListBox else Result := nil;
end;

function TDCCustomComboBox.GetItems: TStrings;
begin
  Result := FItems;
end;

function TDCCustomComboBox.GetItemIndex: integer;
begin
  Result := FItemIndex;
end;

function TDCCustomComboBox.GetComboBoxStyle: TComboBoxStyle;
begin
  Result := FStyle;
end;

procedure TDCCustomComboBox.ShowDropDown;
begin
  WndProcAction(1);
  FListBox.Show;
end;

{ TDCCustomEdit }

procedure TDCCustomEdit.BeginUpdate(HookChanges: boolean = True);
begin
  if FUpdateCount = 0 then _setFlag(FFlags, EM_CHANGED, False);
  Inc(FUpdateCount);
  _setFlag(FFlags, EM_HOOKCHANGED, HookChanges);
end;

function TDCCustomEdit.CanModified: boolean;
begin
  Result := not ReadOnly;;
end;

procedure TDCCustomEdit.Change;
begin
  if not(csLoading in ComponentState) then
  begin
    if FUpdateCount = 0 then inherited;
    _setFlag(FFlags, EM_CHANGED, True);
  end;
end;

procedure TDCCustomEdit.CloseUp(State: Byte; bPerform: boolean);
begin
  if bPerform then
    Perform(CM_POPUPWINDOW, 0, 0)
  else
    PostMessage(Handle, CM_POPUPWINDOW, 0, 0);
end;

procedure TDCCustomEdit.CMCancelMode(var Message: TCMCancelMode);
begin
  inherited;
  if ErrorWindow <> nil then
  begin
    if not((Message.Sender = ErrorWindow) and (ErrorWindow.Buttons.Count > 0)) then
    begin
      if Message.Sender = ErrorWindow then
        HideErrorMessage
      else
        Perform(CM_ERRORMESSAGE, 0, 0);
    end;
  end;
end;

procedure TDCCustomEdit.CMDialogChar(var Message: TCMDialogChar);
 var
  Button: TDCEditButton;
begin
  if (ErrorWindow <> nil) and (HookControl = Self) and
     ErrorWindow.Buttons.IsButtonAccel(Message.CharCode, Button) then
  begin
    Message.Result := 1;
    Button.Click;
  end
  else
    inherited;
end;

procedure TDCCustomEdit.CMEnter(var Message: TCMEnter);
begin
  inherited;
  if not Focused then SetValueChanged(False);
  if not Flags[EM_MOUSEACTIVATE] then SendMessage(Handle, EM_SETSEL, 0, -1);
  _setFlag(FFlags, EM_MOUSEACTIVATE, False);
end;

procedure TDCCustomEdit.CMErrorMessage(var Message: TMessage);
begin
  case Message.WParam of
    0: {Hide}
     if ErrorWindow <> nil then
     begin
       ErrorWindow.Release;
       ErrorWindow := nil;
       HookControl := nil;
     end;
    1: {Show}
     begin
       CloseUp(0, True);
       if Message.LParam <> 0 then ErrorCode := Message.LParam;
       GetHintOnError;
       if Trim(FErrorHint) <> '' then
       begin
          if ErrorWindow <> nil then
          begin
            if ErrorWindow.ErrorCode = ErrorCode then Exit;
            ErrorWindow.Hide;
            ErrorWindow.Buttons.Clear;
          end
          else begin
            HookControl := Self;
            ErrorWindow  := TDCErrorMessageWindow.Create(Self);
          end;
          with ErrorWindow do
          begin
            Parent := Self;
            BeginUpdate;
            AutoHide := True;
            TimeOut  := GetHintTimeOut;
            DialogStyle := dsInvalidValue;
            PopupAlignment := wpOffset;
            MessageStyle   := msTail;
            Left := 5;
            Top  := Self.Height - 9;
            EndUpdate;
          end;
          DoShowError(ErrorWindow);
          ErrorWindow.ErrorCode := ErrorCode;
          with ErrorWindow do
          begin
            if DialogStyle = dsInvalidValue then
              FErrorHint := LoadStr(RES_EDIT_ERR_COMMON) + FErrorHint;
            Caption := FErrorHint;
            ShowError := True;
            Show;
            HookErrorHooks;
          end;
       end;
     end;
  end;
end;

procedure TDCCustomEdit.CMExit(var Message: TCMExit);
 var
  Value: boolean;
begin
  Value := False;
  if Visible and not _getFlag(FFlags, EM_SKIPVALIDATE) then
  begin
    ErrorCode := ERR_EDIT_NONE;
    FocusedControl := Screen.ActiveControl;
    KillFocus(Value);
    ShowError := Value;
    if ShowError then
    begin
      SetFocus;
      ShowErrorMessage;
    end
    else begin
      SelStart  := 1;
      SelLength := 0;
      inherited;
    end;
  end
  else
    inherited;
end;

procedure TDCCustomEdit.CMTextChanged(var Message: TMessage);
begin
  if Focused and (ComponentState * [csLoading, csDesigning, csReading] = []) then
    SetValueChanged(True);
  inherited;
end;

constructor TDCCustomEdit.Create(AOwner: TComponent);
begin
  inherited;
  ControlStyle:= ControlStyle - [csFixedHeight];
  FErrorHint := '';
  FDBObject := TDCDBObject.Create;
  FUpdateCount := 0;

  _setFlag(FFlags, EM_MOUSEACTIVATE, False);
  _setFlag(FFlags, EM_VALUECHANGED, False);
  _setFlag(FFlags, EM_REQUIRED, False);
  _setFlag(FFLags, EM_LOCKSETTINGS, False);
  _setFlag(FFlags, EM_SKIPVALIDATE, False);

  CreateData;
end;

procedure TDCCustomEdit.CreateData;
begin
  if Assigned(FOnCreateData) then FOnCreateData(Self);
end;

procedure TDCCustomEdit.CreateParams(var Params: TCreateParams);
const
  aAlignments: array[Boolean, TAlignment] of DWORD =
    ((ES_LEFT, ES_RIGHT, ES_CENTER),(ES_RIGHT, ES_LEFT, ES_CENTER));
begin
  inherited CreateParams(Params);
  with Params do
  begin
    Style := Style or aAlignments[UseRightToLeftAlignment, FAlignment];
    ControlStyle := ControlStyle + [csOpaque];
  end;
end;

procedure TDCCustomEdit.CreateWnd;
begin
  inherited CreateWnd;
end;

procedure TDCCustomEdit.DeSelect;
begin
  SendMessage(Handle, EM_SETSEL, $7FFFFFFF, Longint($FFFFFFFF));
end;

destructor TDCCustomEdit.Destroy;
begin
  Perform(CM_ERRORMESSAGE, 0, 0);
  FDBObject.Free;
  FDBObject := nil;
  DestroyData;
  inherited;
end;

procedure TDCCustomEdit.DestroyData;
begin
  if Assigned(FOnDestroyData) then FOnDestroyData(Self);
end;

procedure TDCCustomEdit.DoCloseUp;
begin
  if Assigned(FOnCloseUp) then FOnCloseUp(Self);
end;

procedure TDCCustomEdit.DoShowError(AErrorWindow: TDCErrorMessageWindow);
 var
  AButton: TDCEditButton;
begin
  if (ErrorCode <> ERR_EDIT_NONE) and (eoSkipValidate in FOptions)then
  begin
    with AErrorWindow.AddButton('#Ignore', '', LoadStr(RES_STRN_VAL_IGNORE),
      DoErrorHint) do
    begin
      Tag := BTAG_EV_IGNORE;
    end;

    AButton := AErrorWindow.AddButton('#Cancel', '', LoadStr(RES_STRN_VAL_CANCEL),
      DoErrorHint);
    with AButton do
    begin
      Tag := BTAG_EV_CANCEL;
    end;
    AErrorWindow.FocusedButton := AButton;

  end;
  if Assigned(FOnShowError) then FOnShowError(Self, AErrorWindow);
end;

procedure TDCCustomEdit.EndUpdate;
begin
  if FUpdateCount > 0 then
  begin
    Dec(FUpdateCount);
    if (FUpdateCount = 0) and Flags[EM_CHANGED] then
    begin
      if Flags[EM_HOOKCHANGED] then Change;
      _setFlag(FFlags, EM_CHANGED, False);
    end;
  end;
end;

function TDCCustomEdit.GetCanEmpty: boolean;
begin
  Result := not Flags[EM_REQUIRED]
end;

function TDCCustomEdit.GetDBObject: TDCDBObject;
begin
  Result := FDBObject;
end;

function TDCCustomEdit.GetDropDownControl: TWinControl;
begin
  Result := nil;
end;

function TDCCustomEdit.GetDroppedDown: boolean;
begin
  Result := _getFlag(FFlags, EM_DROPDOWNVISIBLE);
end;

function TDCCustomEdit.GetErrorCode: integer;
begin
  Result := FErrorCode;
end;

function TDCCustomEdit.GetHandle: HWnd;
begin
  Result := inherited Handle;
end;

procedure TDCCustomEdit.GetHintOnError;
begin
  case FErrorCode of
    ERR_EDIT_EMPTYVALUE: FErrorHint := LoadStr(RES_EDIT_ERR_EMPTY);
  end;
  if Assigned(FOnGetErrorHint) then FOnGetErrorHint(Self, FErrorCode, FErrorHint);
end;

function TDCCustomEdit.GetHintTimeOut: integer;
begin
  Result := 2500;
end;

function TDCCustomEdit.GetOnGetErrorHint: TGetErrorHint;
begin
  Result := FOnGetErrorHint;
end;

function TDCCustomEdit.GetOnKillFocus: TKillFocusEvent;
begin
  Result := FOnKillFocus;
end;

function TDCCustomEdit.GetParentControl: TWinControl;
begin
  Result := inherited Parent;
end;

function TDCCustomEdit.GetShowError: boolean;
begin
  Result := Flags[EM_SHOWERROR]
end;

function TDCCustomEdit.GetCaptionText: TCaption;
begin
  Result := inherited Text;
end;

function TDCCustomEdit.GetVisible: boolean;
begin
  Result := inherited Visible;
end;

procedure TDCCustomEdit.HideErrorMessage;
begin
  if Assigned(ErrorWindow) then SendMessage(Handle, CM_ERRORMESSAGE, 0, 0);
end;

procedure TDCCustomEdit.HookMessage(wParam: Integer; var Msg: TMsg);
begin
  with Msg do
  begin
    case message of
      WM_NCLBUTTONDOWN:
        if not(DroppedDown and
          PtInDropDownControl(LOWORD(lParam), HIWORD(lParam))) then CloseUp(0, True);
      CM_DEACTIVATE, WM_CLOSE, WM_QUIT:
        if DroppedDown then CloseUp(0, True);
    end;
  end;
end;

procedure TDCCustomEdit.KillFocus(var Value: boolean);
 var
  Form: TCustomForm;
begin
  if CanModified and not Value then
  begin
    if Flags[EM_REQUIRED] and (Trim(Text) = '') then
    begin
      Value := True;
      ErrorCode := ERR_EDIT_EMPTYVALUE;
    end
    else
      ErrorCode := ERR_EDIT_NONE;
  end;

  if Assigned(FOnKillFocus) then FOnKillFocus(Self, Value);
  if Value then
  begin
    if (Parent <> nil) then
    begin
       Form  := GetParentForm(Parent);
       Value := not (Boolean(SendMessage(Form.Handle, CM_INVALIDVALUE,
         Integer(Self), 0)) or
         Boolean(SendMessage(Parent.Handle, CM_INVALIDVALUE, Integer(Self), 0)));
    end
  end;
  if not Value then Perform(CM_ERRORMESSAGE, 0, 0);
end;

function TDCCustomEdit.PtInDropDownControl(X, Y: integer): boolean;
 var
  DropDownControl: TControl;
  P: TPoint;
begin
  DropDownControl := GetDropDownControl;
  if DropDownControl <> nil then
  begin
    P := Point(X, Y);
    Result := PtInRect(DropDownControl.BoundsRect, P);
  end
  else
    Result := False;
end;

procedure TDCCustomEdit.SetAlignment(Value: TAlignment);
 var
  sText: string;
begin
  if FAlignment <> Value then
  begin
    sText := Text;
    FAlignment := Value;
    RecreateWnd;
    SetEditRect;
    Text := sText;
  end;
end;

procedure TDCCustomEdit.SetCanEmpty(const Value: boolean);
begin
  _setFlag(FFlags, EM_REQUIRED, not Value);
end;

procedure TDCCustomEdit.SetData(const Value: Pointer);
begin
  FData := Value;
end;

procedure TDCCustomEdit.SetDBObject(const Value: TDCDBObject);
begin
  FDBObject.Assign(Value);
end;

procedure TDCCustomEdit.SetEditRect;
begin
  {}
end;

procedure TDCCustomEdit.SetErrorCode(const Value: integer);
begin
  FErrorCode := Value;
  FErrorHint := '';
end;

procedure TDCCustomEdit.SetMaxLength(const Value: integer);
begin
  inherited MaxLength := Value;
end;

procedure TDCCustomEdit.SetOnGetErrorHint(const Value: TGetErrorHint);
begin
  FOnGetErrorHint := Value;
end;

procedure TDCCustomEdit.SetOnKillFocus(const Value: TKillFocusEvent);
begin
  FOnKillFocus := Value;
end;

procedure TDCCustomEdit.SetShowError(const Value: boolean);
begin
  _setFlag(FFlags, EM_SHOWERROR, Value);
end;

procedure TDCCustomEdit.SetCaptionText(const Value: TCaption);
begin
  inherited Text := Value;
end;

procedure TDCCustomEdit.SetValueChanged(Value: boolean);
begin
  if (Flags[EM_VALUECHANGED] <> Value) and not ReadOnly then
  begin
    _setFlag(FFlags, EM_VALUECHANGED, Value);
  end;
end;

procedure TDCCustomEdit.SetVisible(const Value: boolean);
begin
  inherited Visible := Value;
end;

procedure TDCCustomEdit.ShowErrorMessage;
begin
  PostMessage(Handle, CM_ERRORMESSAGE, 1, 0);
end;

function TDCCustomEdit.IsValueValid: boolean;
 var
  ErrorValue: boolean;
begin
  ErrorValue := False;
  ErrorCode := ERR_EDIT_NONE;
  if Visible then KillFocus(ErrorValue);
  Result := not ErrorValue;
end;

procedure TDCCustomEdit.WMMouseActivate(var Message: TWMActivate);
begin
  inherited;
  _setFlag(FFlags, EM_MOUSEACTIVATE, True);
end;

function TDCCustomEdit.GetReadOnly: boolean;
begin
  Result := inherited ReadOnly;
end;

procedure TDCCustomEdit.SetReadOnly(const Value: boolean);
begin
  inherited ReadOnly := Value;
end;

procedure TDCCustomEdit.Release;
begin
  Hide;
  PostMessage(Handle, CM_RELEASE, 0, 0);
end;

procedure TDCCustomEdit.CMRelease(var Message: TMessage);
begin
  Free;
end;

function TDCCustomEdit.GetFlagValue(Index: Integer): boolean;
begin
  Result := _getFlag(FFlags, Index)
end;

procedure TDCCustomEdit.SetFlagValue(Index: Integer;
  const Value: boolean);
begin
  _setFlag(FFlags, Index, Value);
end;

function TDCCustomEdit.GetInstance: TObject;
asm
  push ebp
  mov  eax, eax                      // Result := self;
  pop  ebp
end;

function TDCCustomEdit.GetValueChanged: boolean;
begin
  Result := Flags[EM_VALUECHANGED];
end;

procedure TDCCustomEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  case Key of
    VK_ESCAPE:
       if Boolean(SendMessage(Handle, EM_UNDO, 0, 0)) and
         (eoUndoEscapeBlocking in FOptions) then Key := 0;
    VK_RETURN:
      if (Key <> 0) and (ErrorWindow <> nil) and (ErrorWindow.Buttons.Count > 0) then
      begin
        HideErrorMessage;
        Key := 0;
      end;
    else
      HideErrorMessage;
  end;
  SetValueChanged(True);
  inherited;
end;

procedure TDCCustomEdit.SetDroppedDown(const Value: boolean);
begin
  SendMessage(Handle, CM_POPUPWINDOW, Longint(Value), 0)
end;

procedure TDCCustomEdit.SetOptions(const Value: TDCEditOptons);
 var
  ChangedOptions: TDCEditOptons;
begin
  if FOptions <> Value then
  begin
    ChangedOptions := (FOptions + Value) - (FOptions * Value);
    FOptions := Value;
  end;
end;

procedure TDCCustomEdit.DoErrorHint(Sender: TObject);
begin
  with TDCEditButton(Sender) do
  begin
    HideErrorMessage;
    case Tag of
      BTAG_EV_IGNORE:
        begin
          _setFlag(FFlags, EM_SKIPVALIDATE, True);
          try
            if Assigned(FocusedControl) and Assigned(Screen.ActiveForm) then
              Screen.ActiveForm.ActiveControl := FocusedControl;
          finally
            _setFlag(FFlags, EM_SKIPVALIDATE, False);
          end
        end;
    end;
  end;
end;

procedure TDCCustomEdit.CMHookMessage(var Message: TMessage);
 var
  Msg: TMsg;
begin
  Msg := PMsg(Message.LParam)^;
  HookMessage(Message.wParam, Msg);
end;

procedure TDCCustomEdit.CMPopupWindow(var Message: TMessage);
begin
  case Message.WParam of
    0: DoCloseUp;
    1: ;
  end;
end;

{ TDCCustomDateEdit }

procedure TDCCustomDateEdit.CMFontChanged(var Message: TMessage);
begin
  inherited;
  if ShowCheckBox and FChecked then FFontColor := Font.Color;
end;

procedure TDCCustomDateEdit.Loaded;
begin
  inherited;
  FFontColor := Font.Color;
end;

procedure TDCCustomDateEdit.SetChecked(Value: boolean);
begin
  if csDesigning in ComponentState then Value := True;

  if ShowCheckBox and
    (FChecked <> Value) and  not _getFlag(FFlags, EM_SAVEDREADONLY) then
  begin
    FChecked := Value;
    Flags[EM_CTRLCHECKPROC] := True;
    ReadOnly := not FChecked;
    Flags[EM_CTRLCHECKPROC] := False;
    SetCheckGlyph;
    if Assigned(FOnChecked) then FOnChecked(Self);
    Invalidate;
  end;
end;

procedure TDCCustomDateEdit.SetShowCheckBox(Value: boolean);
begin
  if ShowCheckBox <> Value then
  begin
    _setFlag(FFlags, EM_SHOWCHECKBOX, Value);
    if ShowCheckBox then
      SetCheckGlyph
    else begin
      FChecked := True;
      SetCheckGlyph;
      SetFontColor(FFontColor);
    end;
    SetEditRect;
    Invalidate;
  end;
end;

procedure TDCCustomDateEdit.CloseUp(State: Byte; bPerform: boolean = False);
 var
  xDate: string;
begin
  case State of
     0:;
     1:
      if not _getFlag(FFlags, EM_SAVEDREADONLY) and
        DateToStrY2K(FCalendar.Date, xDate, Kind) then
      begin
        UndoDate := FCalendar.Date;
        Text     := xDate;
        if FChecked then SendMessage(Handle, EM_SETSEL, 0, -1);
      end;
  end;
  inherited;
end;

procedure TDCCustomDateEdit.GetDateText;
 var
  i, j: integer;
  pText: PChar;
  nSelStart, nSelEnd: integer;
  DateFormatStr: string;
begin
  {   DateSeparator}
  nSelStart := SelStart;
  nSelEnd   := nSelStart + SelLength;
  if nSelEnd = nSelStart then inc(nSelEnd, 1);

  FStartPos := nSelStart;
  FEndPos   := nSelEnd;
  FDateText := '';
  pText     := PChar(Text);

  case FKind of
    dkDate:
      DateFormatStr := Format(GetDateMaskFormat, [DateSeparator]);
    dkDateTime:
      DateFormatStr := Format(GetDateMaskFormat + EDITFMT_TIMEPART,
         [DateSeparator, TimeSeparator]);
  end;

  j := 1; i := 0;
  while pText^ <> #0 do
  begin
    if (j <= Length(DateFormatStr)) and (DateFormatStr[j] = '|') then
    begin
      inc(j);
      if pText^ = DateFormatStr[j] then
      begin
        if i < nSelStart then Dec(FStartPos);
        if i < nSelEnd then Dec(FEndPos);
      end
      else
        case DateFormatStr[j] of
         'a':
           begin
             inc(j);
             continue;
           end;
        else
          begin
            FDateText := FDateText + pText^;
            Dec(j);
          end;
        end;
    end
    else
      if pText^ in Digits then FDateText := FDateText + pText^;
    inc(i);
    inc(j);
    inc(pText);
  end;
end;

procedure TDCCustomDateEdit.SetDateText;
 var
  i, j: integer;
  nSelStart: integer;
  sText, DateFormatStr: string;
  pText: PChar;
  AutoComplete: boolean;

  procedure AddToText(cText: Char; Mode: Byte);
  begin
    sText := sText + cText;
    if (Mode = 1) and (FStartPos > i) then Inc(nSelStart,1);
  end;

begin
  sText := '';
  pText := PChar(FDateText);

  case FKind of
    dkDate:
      DateFormatStr := Format(GetDateMaskFormat, [DateSeparator]);
    dkDateTime:
      DateFormatStr := Format(GetDateMaskFormat + EDITFMT_TIMEPART,
         [DateSeparator, TimeSeparator]);
  end;

  nSelStart    := FStartPos;
  AutoComplete := False;

  i := 0; j := 1;
  if (j <= Length(DateFormatStr)) and (DateFormatStr[j] = '|') then
  begin
    inc(j);
    if DateFormatStr[j] in [DateSeparator, TimeSeparator] then
      AddToText(DateFormatStr[j], 1)
    else
      case DateFormatStr[j] of
       'a':
         begin
           AutoComplete := True;
           inc(j);
         end;
      else
        AddToText(DateFormatStr[j], 1)
      end;
  end;

  while pText^ <> #0 do
  begin
    if DateFormatStr[j] <> '|' then inc(j);
    if (j <= Length(DateFormatStr)) and (DateFormatStr[j] = '|') then
    begin
      inc(j);
      if DateFormatStr[j] in [DateSeparator, TimeSeparator] then
      begin
        AddToText(pText^, 0);
        AddToText(DateFormatStr[j], 1)
      end
      else
        case DateFormatStr[j] of
         'a':
          begin
           AutoComplete := True;
           inc(j);
           continue;
          end;
        else begin
          AddToText(pText^, 0);
          AddToText(DateFormatStr[j], 1)
        end;  
        end;
      if DateFormatStr[j] <> '|' then inc(j);
    end
    else
      AddToText(pText^, 0);
    inc(i);
    inc(pText);
  end;

  if AutoComplete  then
  begin
    while j <= Length(DateFormatStr) do
    begin
      if DateFormatStr[j] <> '|' then
        AddToText(DateFormatStr[j], 1)
      else begin
        inc(j);
        AddToText(DateFormatStr[j], 1)
      end;
      inc(j);
      inc(i);
    end;
  end;

  Text     := sText;
  SelStart := nSelStart;
end;

procedure TDCCustomDateEdit.SetText(var Key: char);
 var
  MaxTextLength: integer;
  SimpleFormat: TSimpleDateFormat;
  k: TDateFormatParts;
begin
  GetDateText;
  case Key of
    Char(VK_BACK): {BACKSPACE}
      begin
        DeleteChar(dtBackSpace);
        Key := #0;
      end;
  end;

  DecodeDateFormat(SimpleFormat);
  MaxTextLength := 0;
  for k := Low(TDateFormatParts) to High(TDateFormatParts) do
   Inc(MaxTextLength, SimpleFormat[k].Count);

  if FKind = dkDateTime then Inc(MaxTextLength, 6);

  if Key in SetDateEdit then
  begin
    if (FStartPos + 1 <> FEndPos) or (SelLength > 0) then DeleteChar(dtDelete);
    if Length(FDateText) < MaxTextLength then
       FDateText := Copy(FDateText, 1, FStartPos) + Key +
         Copy(FDateText, FStartPos + 1, Length(FDateText) - FStartPos)
    else begin
     if FStartPos >= MaxTextLength then FStartPos := MaxTextLength - 1;
      if Key in Digits then
        FDateText := Copy(FDateText, 1, FStartPos) + Key +
          Copy(FDateText, FStartPos + 2, Length(FDateText) - FStartPos - 1);
    end;
    Inc(FStartPos,1);
  end;
  SetDateText;

  Key := #0;
end;

procedure TDCCustomDateEdit.DeleteChar(DeleteType: TDeleteType);
 var
  sSub1, sSub2, sValue: string;
  n1, n2, i, len: integer;
  SimpleFormat: TSimpleDateFormat;
  pValue: PChar;
begin
  n1 := FStartPos;
  n2 := FEndPos;
  case DeleteType of
    dtBackSpace:
      begin
        if FStartPos + 1 = FEndPos then
        begin
          sSub1 := Copy(FDateText, 1, FStartPos - 1);
          sSub2 := Copy(FDateText, FEndPos, Length(FDateText) - FEndPos + 1);
        end
        else begin
          sSub1 := Copy(FDateText, 1, FStartPos);
          sSub2 := Copy(FDateText, FEndPos + 1, Length(FDateText) - FEndPos + 2);
          Dec(FStartPos, 1);
        end;
      end;
    dtDelete:
      begin
        sSub1 := Copy(FDateText, 1, FStartPos);
        sSub2 := Copy(FDateText, FEndPos + 1, Length(FDateText)-FEndPos + 2);
      end;
  end;
  if FKind = dkDateTime then
  begin
    DecodeDateFormat(SimpleFormat);
    i := SimpleFormat[dpDay].Count + SimpleFormat[dpMonth].Count +
      SimpleFormat[dpYear].Count;
    len := Length(FDateText);
    if (len > i) and (n2 > n1) then
    begin
      i := n2 - n1;
      if not((i = len) or (n1 <= i) and (n2 = len)) then
      begin
        SetLength(sValue, i);
        pValue := PChar(sValue);
        FillChar(pValue^, i, Byte('0'));
      end;
    end;
  end;
  FDateText := sSub1 + sValue + sSub2;
end;

procedure TDCCustomDateEdit.KeyPress(var Key: Char);
begin
  if not(Key in SetDateEdit) or ReadOnly then
    Key := #0
  else
    if Key in Digits then SetText(Key);
  inherited KeyPress(Key);
end;

procedure TDCCustomDateEdit.KeyDown(var Key: Word; Shift: TShiftState);
 var
  KeyDownEvent: TKeyEvent;
begin
  KeyDownEvent := OnKeyDown;
  if _getFlag(FFlags, EM_DROPDOWNVISIBLE) and (FCalendar <> nil) then
  begin
    case Key of
      VK_HOME ,
      VK_END  ,
      VK_PRIOR,
      VK_NEXT ,
      VK_LEFT ,
      VK_UP   ,
      VK_RIGHT,
      VK_DOWN :
        if Shift = [] then
        begin
          if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
          FCalendar.KeyDown(Key, Shift);
          Key := 0;
        end;
      VK_ESCAPE:
        begin
          CloseUp(0, True);
          Key := 0;
        end;
      else
        CloseUp(0);
    end;
  end
  else begin
    case Key of
      VK_DOWN   :
        if [ssAlt]*Shift = [ssAlt] then
        begin
          if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
          if Key <> 0 then ChoiceButtonDown;
          Key := 0;
        end;
      VK_DELETE :
        if not ReadOnly then
        begin
          if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
          if Key <> 0 then
          begin
            GetDateText;
            DeleteChar(dtDelete);
            SetDateText;
            Key := 0;
          end;
        end;
      VK_ESCAPE:
        Date := UndoDate;
      VK_SPACE:
        Key := 0;
    end;
  end;
  if Key <> 0 then inherited;
end;

procedure TDCCustomDateEdit.CheckClick(Sender: TObject);
begin
  HideCaret(Handle);
  HideErrorMessage;
  if DisableButtons then Exit;
  if not Focused then SetFocus;
  if Focused then
  begin
    if DroppedDown then CloseUp(0, True);
    Checked := not Checked;
    if Assigned(FOnCheckClick) then FOnCheckClick(Self);
  end;
end;

procedure TDCCustomDateEdit.CMCancelMode(var Message: TCMCancelMode);
begin
  if (Message.Sender <> Self) and
     (Message.Sender <> FCalendar) and
     not FCalendar.ContainsControl(Message.Sender) then
  begin
    inherited;
  end;
end;

procedure TDCCustomDateEdit.KillFocus(var Value: boolean);
 var
  xDate: string;
begin
  if CanModified then
  begin
    if not Value and not DateToStrY2K(Text, xDate, Kind) and
      not(Trim(Text) = '') then
    begin
      Value := True;
      xDate := Text;
      ErrorCode := ERR_DATE_INCORRECTDATE;
    end;
    if not Value and Flags[EM_REQUIRED] and Empty then
    begin
      Value := True;
      ErrorCode := ERR_EDIT_EMPTYVALUE;
    end;
    if not Value then
    begin
      Text := xDate;
      if _getFlag(FFlags, EM_SHOWWEEK) then invalidate;
    end;
  end;
  inherited KillFocus(Value);
end;

constructor TDCCustomDateEdit.Create(AOwner: TComponent);
begin
  inherited;
  _setFlag(FFlags, EM_SHOWCHECKBOX, False);
  _setFlag(FFlags, EM_SHOWWEEK, True);
  _setFlag(FFlags, EM_CTRLCHECKPROC, False);
  _setFlag(FFlags, EM_SAVEDREADONLY, ReadOnly);
  FChecked      := True;
  FKind         := dkDate;
end;

procedure TDCCustomDateEdit.EMSetReadOnly(var Message: TMessage);
begin
  inherited;
  if not _getFlag(FFlags, EM_CTRLCHECKPROC) then
    _setFlag(FFlags, EM_SAVEDREADONLY, ReadOnly);
end;

procedure TDCCustomDateEdit.GetHintOnError;
begin
  case FErrorCode of
    ERR_DATE_INCORRECTDATE: FErrorHint := LoadStr(RES_DATE_ERR_WRONG);
   else
    FErrorHint := '';
  end;
  inherited;
end;

function TDCCustomDateEdit.GetDate: TDateTime;
 var
  xDate: string;
begin
  if DateToStrY2K(Text, xDate, Kind) then
    Result := StrToDateTime(xDate)
  else
    Result := 0;
end;

procedure TDCCustomDateEdit.SetDate(const Value: TDateTime);
 var
  xDate: string;
begin
  if DateToStrY2K(Value, xDate, Kind) then
  begin
    Text     := xDate;
    UndoDate := Value;
  end;
end;

procedure TDCCustomDateEdit.DefineBtnChoiceStyle;
begin
  if BtnChoiceAssigned then
  begin
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNPOPUP');
    ButtonStyle := esDropDown;
    ButtonChoiceStyle := btsCustom;
    ButtonChoice.Options := ButtonChoice.Options + [boSimpleStyle];
  end;
end;

procedure TDCCustomDateEdit.CMPopupWindow(var Message: TMessage);
 var
  xDate: string;
begin
  case Message.WParam of
    0:
      if _getFlag(FFlags, EM_DROPDOWNVISIBLE) then
      begin
        if BtnChoiceAssigned then FBtnChoice.ResetProperties;
        _setFlag(FFlags, EM_DROPDOWNVISIBLE, False);
        FCalendar.Free;
        FCalendar := nil;
        ShowHint  := Flags[EM_SAVEDSHOWHINT];
        DoCloseUp;
      end;
    1:
      begin
        SetChecked(True);
        _setFlag(FFlags, EM_SAVEDSHOWHINT, ShowHint);
        ShowHint  := False;
        FCalendar := TDCCustomCalendar.Create(Self);
        with FCalendar do
        begin
          OnCloseUp := CalendarCloseUp;
        end;
        try
         if Trim(Text) = ''
         then FCalendar.Date := SysUtils.Date
         else begin
           if DateToStrY2K(Text, xDate, Kind)
             then FCalendar.Date := StrToDateTime(xDate)
             else FCalendar.Date := SysUtils.Date;
         end;
        except
         FCalendar.Date := SysUtils.Date;
        end;
        ShowDropDown;
        _setFlag(FFlags, EM_DROPDOWNVISIBLE, True);
      end;
  end;
end;

procedure TDCCustomDateEdit.GetMargins(var LeftMargin: integer;
  var RightMargin: integer);
begin
  inherited GetMargins(LeftMargin, RightMargin);
  if ShowWeekDay then
  begin
    if PaintCheckGlyph then
      LeftMargin := FCheckGlyph.Width + 2
    else
      LeftMargin := 0;
    LeftMargin := LeftMargin +
      Length(ShortDayNames[1]) * GetDCTextWidth(Font, 'W');
  end;
end;

procedure TDCCustomDateEdit.SetKind(const Value: TDateEditKind);
begin
  FKind := Value;
  Date  := Date;
end;

procedure TDCCustomDateEdit.DoDrawMargins(DC: HDC);
 var
  R: TRect;
  Brush: HBRUSH;
  LeftMargin, RightMargin: integer;
begin
  inherited;
  if _getFlag(FFlags, EM_SHOWWEEK) then
  begin
    SelectObject(DC, Font.Handle);
    if not Enabled and not(csDesigning in ComponentState) then
      SetTextColor(DC, ColorToRGB(clInactiveCaption))
    else
      SetTextColor(DC, ColorToRGB(Font.Color));
    SetBkColor(DC, ColorToRGB(Color));

    GetWindowRect (Handle, R);  OffsetRect (R, -R.Left, -R.Top);

    if PaintCheckGlyph then R.Left := R.Left + FCheckGlyph.Width + 2;
    case FDrawStyle of
      fsNone  :
       begin
         InflateRect(R, -1, -1);
         R.Left := R.Left -1;
       end;
      fsSingle  :
       InflateRect(R, -3, -3);
      fcsNormal,
      fsFlat  :
       InflateRect(R, -3, -3);
    end;

    GetMargins(LeftMargin, RightMargin);
    R.Right := R.Left + LeftMargin;
    Brush := CreateSolidBrush(ColorToRGB(Color));
    FillRect(DC, R, Brush);
    DeleteObject(Brush);

    if FUndoDate <> 0 then
    begin
      DrawText(DC, PChar(ShortDayNames[DayOfWeek(FUndoDate)]),
        Length(ShortDayNames[DayOfWeek(FUndoDate)]), R, DT_LEFT);
    end;
  end;
end;

procedure TDCCustomDateEdit.SetFontColor(Value: TColor);
begin
  if [csDesigning, csLoading]*ComponentState = [] then Font.Color := Value;
end;

procedure TDCCustomDateEdit.CMEnter(var Message: TCMEnter);
begin
  inherited;
  UndoDate := GetDate;
end;

procedure TDCCustomDateEdit.CMExit(var Message: TCMExit);
begin
  inherited;
  if not Focused then UndoDate := GetDate;
end;

procedure TDCCustomDateEdit.SetUndoDate(const Value: TDateTime);
begin
  if Value <> FUndoDate then FUndoDate := Value;
end;

procedure TDCCustomDateEdit.SetShowWeekDay(const Value: boolean);
begin
  _setFlag(FFlags, EM_SHOWWEEK, Value);
  SetEditRect;
end;

function TDCCustomDateEdit.IsMasked: boolean;
begin
  Result := False;
end;

procedure TDCCustomDateEdit.ShowDropDown;
begin
  WndProcAction(1);
  FCalendar.Show;
end;

function TDCCustomDateEdit.GetEmpty: boolean;
begin
  Result := (ShowCheckBox and not Checked) or (Date = 0); 
end;

procedure TDCCustomDateEdit.SetCheckGlyph;
begin
  if FChecked then
  begin
    if not _getFlag(FFlags, EM_SAVEDREADONLY) then
      ETGetBitmap(DCGIM_SMALLICON, nsiNormalCheck1, FCheckGlyph)
    else
      ETGetBitmap(DCGIM_SMALLICON, nsiShadowCheck1, FCheckGlyph);
    SetFontColor(FFontColor);
  end
  else begin
    if not _getFlag(FFlags, EM_SAVEDREADONLY) then
      ETGetBitmap(DCGIM_SMALLICON, nsiNormalCheck0, FCheckGlyph)
    else
      ETGetBitmap(DCGIM_SMALLICON, nsiShadowCheck0, FCheckGlyph);
    SetFontColor(clInactiveCaption);
  end;
end;

function TDCCustomDateEdit.GetDropDownControl: TWinControl;
begin
  if DroppedDown then Result := FCalendar else Result := nil;
end;

function TDCCustomDateEdit.GetShowWeekDay: boolean;
begin
  Result := _getFlag(FFlags, EM_SHOWWEEK);
end;

procedure TDCCustomDateEdit.CalendarCloseUp(Sender: TObject; State: Byte;
  bPerform: boolean);
begin
  CloseUp(State, bPerform);
end;

{ TDCCustomGridEdit }
procedure TDCCustomGridEdit.BeginPaintListBox;
begin
  inc(FPaintBox);
end;

function TDCCustomGridEdit.CheckDataValue: boolean;
 var
  Found: boolean;
  AKeyValue: variant;
  ACursor: TCursor;
begin
  if not FQueryDataSet and (DataSet = nil) then
  begin
    Result := True;
    Exit;
  end;

  SetGridValues;

  if FErrorCode <> ERR_EDIT_NONE then
  begin
    Result := False;
    Exit;
  end;

  if not _getFlag(FStates, GS_VALUESELECTED) then
  begin
    if not FQueryDataSet then FDataSet.DisableControls;

    ACursor := Screen.Cursor;
    Screen.Cursor := crHourGlass;
    Result := False;

    try
      try
        Found := False;
        Values.FValuesLoaded := False;
        if Assigned(FOnCheckDataValue) then
        begin
          FOnCheckDataValue(Self, Text, FValues.Fields[FDataField].FieldType,
            Found, AKeyValue, Values);
          if not Values.FValuesLoaded and Found then SetKeyValue(AKeyValue);
          Result := Found;
        end;
        if not(Found or Values.FValuesLoaded) then
        begin
          if FQueryDataSet then
          begin
            try
              OpenQuery(0);
              if FQuery.RecordCount > 0 then
              begin
                Text := FQuery.FieldByName(FDataField).AsString;
                AKeyValue := FQuery.FieldByName(FKeyField).AsVariant;
                SetKeyValueEx(AKeyValue, _getFlag(FStates, GS_NEEDLOCATE));
                Result := True;
              end
              else begin
                ClearValue(False);
                Result := False;
              end;
              FQuery.Close;
            except
              Result := False;
            end;
          end
          else begin
            if ActivateDataSet and DataSet.Locate(FDataField, Text,
              [loCaseInsensitive]) then
            begin
              AKeyValue := DataSet.FieldByName(FKeyField).AsVariant;
              SetKeyValueEx(AKeyValue, _getFlag(FStates, GS_NEEDLOCATE));
              Result := True;
            end
            else begin
              ClearValue(False);
              Result := False;
            end;
          end;
        end;
      except
        Result := False;
      end
    finally
      if not FQueryDataSet then
        while FDataSet.ControlsDisabled do FDataSet.EnableControls;
      Screen.Cursor :=  ACursor;
    end;
  end
  else
    Result := True;
end;

procedure TDCCustomGridEdit.ClearValue(ClearText: boolean);
 var
  i: integer;
begin
  if ClearText then Text := '';
  FKeyValue  := null;
  SetGridValues;
  for i := 0 to Values.Count-1 do TGridValue(Values.Items[i]).AsString := '';
  invalidate;
end;

procedure TDCCustomGridEdit.CloseUp(State: Byte; bPerform: boolean = False);
 var
  i: integer;

  procedure CloseListBox;
  begin
    if _getFlag(FStates, GS_THREADINUSE) then
      PostMessage(Handle, CM_THREAD_STOP, 0, 0)
    else
      PostMessage(Handle, CM_THREAD_FREEBOX, 0, 0);
    ShowHint := Flags[EM_SAVEDSHOWHINT];
  end;

begin
  _setFlag(FStates, GS_NEEDLOCATE, True);
  case State of
     0:
       begin
         if _getFlag(FStates, GS_LISTBOXVISIBLE) then
         begin
           _setFlag(FStates, GS_LISTBOXVISIBLE, False);
           CloseListBox;
         end;
     end;
     1:
       begin
         if _getFlag(FFlags, EM_DROPDOWNVISIBLE) and FieldExists(KeyField) then
         begin
           _setFlag(FStates, GS_VALUESELECTED, True);
           if FQueryDataSet then
           begin
             FKeyValue := FQuery.FieldByName(KeyField).AsVariant;
             SetDataValues(FQuery);
           end
           else begin
             FKeyValue := FDataSet.FieldByName(KeyField).AsVariant;
             SetDataValues(FDataSet);
           end;
           SendControlMessage(CM_THREAD_LOCATED, 0, 0, bPerform);
           _setFlag(FStates, GS_NEEDLOCATE, False);
         end;

         if _getFlag(FStates, GS_LISTBOXVISIBLE) then
         begin
           _setFlag(FStates, GS_LISTBOXVISIBLE, False);
           with FListBox do
           begin
             if ItemIndex >= 0 then
             begin
               _setFlag(FStates, GS_VALUESELECTED, True);
               FKeyValue := TGridValues(Items.Objects[ItemIndex]).Fields[FKeyField].Value;
               Text := TGridValues(Items.Objects[ItemIndex]).Fields[FDataField].AsString;

               with TGridValues(Items.Objects[ItemIndex]) do
                 for i := 0 to Count-1 do
                   TGridValue(FValues.Items[i]).AsString := TGridValue(Items[i]).AsString;

               SendControlMessage(CM_THREAD_LOCATED, 0, 0, bPerform);
               _setFlag(FStates, GS_NEEDLOCATE, False);
             end;
           end;
           CloseListBox;
         end;
      end;
  end;
  inherited;
  _setFlag(FStates, GS_FULLQUERY, True);
end;

procedure TDCCustomGridEdit.CMCancelMode(var Message: TCMCancelMode);
begin
  if (Message.Sender <> Self) and
     (Message.Sender <> FGrid) and
     not FGrid.ContainsControl(Message.Sender) and
     (Message.Sender <> FListBox) and
     not FListBox.ContainsControl(Message.Sender)
     then
  begin
    inherited;
  end;
end;

procedure TDCCustomGridEdit.CMExit(var Message: TCMExit);
begin
  if (Text = '') and CanEmpty then ClearValue(True);
  inherited;
end;

procedure TDCCustomGridEdit.CMPopupWindow(var Message: TMessage);
 var
  i: integer;
  ACursor: TCursor;
begin
  case Message.WParam of
    0:
     begin
       if _getFlag(FFlags, EM_DROPDOWNVISIBLE) then
       begin
         if BtnChoiceAssigned then FBtnChoice.ResetProperties;
         _setFlag(FFlags, EM_DROPDOWNVISIBLE, False);
         if Assigned(FGrid) then
         begin
           FGrid.Buttons.ClrWndProc;
           FGrid.Hide;
           FreeAndNil(FGrid);
         end;
         ShowHint := Flags[EM_SAVEDSHOWHINT];
       end;
       if FQueryDataSet then
       begin
         if FQuery.Active then FQuery.Close
       end;
       DoCloseUp;
     end;
    1:
     begin
       if _getFlag(FStates, GS_THREADINUSE) then
       begin
         PostMessage(Handle, CM_THREAD_STOP, 0, 0);
       end
       else
         if _getFlag(FStates, GS_LISTBOXVISIBLE) then
           PostMessage(Handle, CM_THREAD_FREEBOX, 0, 0);

       _setFlag(FFlags, EM_SAVEDSHOWHINT, ShowHint);
       ShowHint  := False;
       if not _getFlag(FFlags, EM_DROPDOWNVISIBLE) then
       begin
         HideInfoHint;
         FColumnsOrder.Clear;
         FGrid := DoCreatePopupGrid;
         with FGrid do
         begin
           Font  := Self.Font;
           Color := Self.Color;
           OptionsEx := OptionsEx - [dgeShadowSelection];
           if geCanAppend in FGridOptions then
             PopupOptions := PopupOptions + [pgCanAppend];
           Parent:= Self;
           PopupAlignment := wpBottomLeft;
           case DrawStyle of
             fcsNormal,
             fsNone:
               FGrid.PopupBorderStyle := brRaised;
             fsSingle:
               FGrid.PopupBorderStyle := brRaised;
             fsFlat:
               FGrid.PopupBorderStyle := brRaised;
           end;
           if FDropDownWidth = 0 then Width := Self.Width
             else Width :=FDropDownWidth;
           DropDownRows := 6;
           Images  := FImages;
           Columns := FColumns;
           for i := 0 to FColumns.Count-1 do
             Columns[i].ItemIndex := FColumns[i].ItemIndex;
           if Columns.Count <= 2 then
             Options := Options + [dgAutoSize];
           InitColumnsOrder;
         end;
       end;

       ACursor := Screen.Cursor;
       try
         with FGrid do
         begin
           if FQueryDataSet then
           begin
             Screen.Cursor := crHourGlass;
             OpenQuery(1);
             DataSet := FQuery;
           end
           else begin
             DataSet := FDataSet;
             ActivateDataSet;
           end;
           AdjustNewHeight;
           if geSelectOnSingleClick in FGridOptions then
             OnCellClick  := GridCellClick
           else
             OnDblClick   := GridDblClick;
           OnTitleClick := GridTitleClick;
           Screen.Cursor := ACursor;
           FGrid.FreeNotification(Self);
           if not _getFlag(FFlags, EM_DROPDOWNVISIBLE) then ShowDropDown;
         end;
       except
         on E: Exception do
         begin
           Screen.Cursor := ACursor;
           ErrorCode := ERR_GRID_EXCEPTONOPEN;
           FErrorHint := E.Message;
           CloseUp(0, True);
           ShowErrorMessage;
           Exit;
         end;
       end;
       _setFlag(FFlags, EM_DROPDOWNVISIBLE, True);
     end;
  end;
end;

procedure TDCCustomGridEdit.CMThreadError(var Message: TMessage);
begin
  ShowErrorMessage;
end;

procedure TDCCustomGridEdit.CMThreadFindCmplt(var Message: TMessage);
begin
  {}
end;

procedure TDCCustomGridEdit.CMThreadFreeBox(var Message: TMessage);
 var
  i: Integer;
begin
  while FPaintBox > 0 do Sleep(10);
  _setFlag(FStates, GS_LISTBOXVISIBLE, False);
  if FListBox <> nil then
  begin
    for i:= 0 to FListBox.Items.Count-1 do
       FListBox.Items.Objects[i].Free;
    FListBox.Free;
    FListBox := nil;
  end;
end;

procedure TDCCustomGridEdit.CMThreadHideBox(var Message: TMessage);
begin
  if AutoCompleteActive(False) then FListBox.Hide;
end;

procedure TDCCustomGridEdit.CMThreadItemAdd(var Message: TMessage);
 var
  GridValues: TGridValues;
begin
  GridValues := TGridValues(Message.LParam);
  if (FListBox <> nil) and (GridValues.Count>0) then
  begin
    FListBox.SetListHeight(1);
    FListBox.Items.AddObject(GridValues.Fields[FDataField].AsString, GridValues);
  end;
end;

procedure TDCCustomGridEdit.CMThreadItemClr(var Message: TMessage);
 var
  i: integer;
begin
  if AutoCompleteActive(False) then
  begin
    for i:= 0 to FListBox.Items.Count-1 do
       FListBox.Items.Objects[i].Free;
    FListBox.Items.Clear;
  end;
end;

procedure TDCCustomGridEdit.CMThreadLocated(var Message: TMessage);
begin
  if (FUpdateCount = 0) and Assigned(FOnValueChange) then FOnValueChange(Self);
  SetValueChanged(True);
end;

procedure TDCCustomGridEdit.CMThreadSetMode(var Message: TMessage);
begin
  FThreadMode := TThreadMode(Message.WParam);
  PostThreadMessage(FGridEditThread.ThreadID, Message.Msg, Message.WParam,
    Message.LParam);
end;

procedure TDCCustomGridEdit.CMThreadShowBox(var Message: TMessage);
begin
  FListBox.Show;
end;

procedure TDCCustomGridEdit.CMThreadStart(var Message: TMessage);
begin
  _setFlag(FStates, GS_THREADINUSE, True);
  if Assigned(FOnThreadStart) then FOnThreadStart(Self);
end;

procedure TDCCustomGridEdit.CMThreadStop(var Message: TMessage);
begin
  FThreadMode := tmStop;
  PostThreadMessage(FGridEditThread.ThreadID, Message.Msg, Message.WParam,
    Message.LParam)
end;

procedure TDCCustomGridEdit.CMThreadTerminate(var Message: TMessage);
begin
  try
    FGridEditThread.Free;
    FGridEditThread := nil;
    _setFlag(FStates, GS_THREADINUSE, False);
  finally
    if Assigned(FOnThreadStop) then FOnThreadStop(Self);
  end;
end;

constructor TDCCustomGridEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FColumns        := TDBGridColumns.Create(nil, TColumn);
  FListBoxColumns := TDBGridColumns.Create(nil, TColumn);
  FValues  := TGridValues.Create(Self);
  FKeyValue:= null;

  _setFlag(FStates, GS_CLOSEDATASET, False);
  _setFlag(FStates, GS_THREADINUSE, False);
  _setFlag(FStates, GS_VALUESELECTED, False);
  _setFlag(FStates, GS_LISTBOXVISIBLE, False);
  _setFlag(FStates, GS_FULLQUERY, True);
  _setFlag(FStates, GS_SHOWINFOHINT, False);
  _setFlag(FStates, GS_FASTSEARCH, True);

  FThreadMode        := tmIdle;
  FListBoxEnabled    := False;
  FQueryDataSet      := False;

  FPaintBox := 0;
  FQuery := CreateQuery;

  FColumnsOrder := TStringList.Create;

  FImageChangeLink :=  TChangeLink.Create;
  FImageChangeLink.OnChange := ImageListChange;
end;

procedure TDCCustomGridEdit.DefineBtnChoiceStyle;
begin
  if BtnChoiceAssigned then
  begin
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNGRID');
    ButtonStyle := esDropDown;
    ButtonChoiceStyle := btsCustom;
    ButtonChoice.Options := ButtonChoice.Options - [boSimpleStyle];
  end;
end;

destructor TDCCustomGridEdit.Destroy;
begin
  if _getFlag(FStates, GS_THREADINUSE) then
  begin
    PostMessage(Handle, CM_THREAD_TERMINATE, 0, 0);
    WaitForThreadTerminate(50);
  end;

  FImageChangeLink.Free;
  FColumnsOrder.Free;
  FValues.Free;
  FColumns.Free;
  FListBoxColumns.Free;
  FQuery.Free;

  CloseDataSet;
  inherited;
end;

procedure TDCCustomGridEdit.GridTitleClick(Column: TColumn);
 var
  i, AIndex: integer;
  IndexChanged: boolean;
begin
  IndexChanged := False;
  if _getFlag(FFlags, EM_DROPDOWNVISIBLE) then with FGrid.Columns do
  begin
    for i := 0 to Count - 1 do
    begin
      AIndex := FColumnsOrder.IndexOf(Items[i].FieldName);
      if (Column.FieldName <> Items[i].FieldName) and (AIndex > -1) and
         (Items[i].IndexStyle = idxNone) then
        FColumnsOrder.Delete(AIndex)
    end;
  end;
  AIndex := FColumnsOrder.IndexOf(Column.FieldName);
  if (AIndex >=0) then
  begin
    if Column.IndexStyle = idxNone then
      FColumnsOrder.Delete(AIndex)
    else
      FColumnsOrder.Objects[AIndex] := TObject(Column.IndexStyle);
    IndexChanged := True;
  end
  else if Column.IndexStyle <> idxNone then
  begin
    AIndex := FColumnsOrder.Add(Column.FieldName);
    FColumnsOrder.Objects[AIndex] := TObject(Column.IndexStyle);
    IndexChanged := True;
  end;
  DoGridTitleClick(IndexChanged, Column);
end;

procedure TDCCustomGridEdit.EndPaintListBox;
begin
  dec(FPaintBox);
end;

function TDCCustomGridEdit.FieldExists(Value: string): boolean;
begin
  if FQueryDataSet then
    Result := (FQuery.FindField(Value) <> nil)
  else
    Result := (FDataSet <> nil) and (FDataSet.FindField(Value) <> nil);
end;

procedure TDCCustomGridEdit.GetEntryText;
begin
  {   }
  if FListBoxEnabled and not ReadOnly and not FQueryDataSet and
    _getFlag(FStates, GS_FASTSEARCH) and
    Assigned(FDataSet) and not _getFlag(FFlags, EM_DROPDOWNVISIBLE) then
  begin
    if (Length(Text) >= MIN_CMPSTR_LENGTH) then
    begin
      if not AutoCompleteActive(False) then
      begin
        _setFlag(FFlags, EM_SAVEDSHOWHINT, ShowHint);
        ShowHint  := False;
        FListBox := TDCPopupListBox.Create(Self);
        with FListBox do
        begin
          Font  := Self.Font;
          Color := Self.Color;
          Parent := Self;
          Top  := Self.Height-2;
          if FListBoxWidth = 0 then
            Width := Self.Width
          else
            Width := FListBoxWidth;

          PopupAlignment := wpOffset;
          if PaintCheckGlyph then
          begin
            Left := FCheckGlyph.Width;
            Width := Width - FCheckWidth;
          end
          else Left := -2;

          PopupBorderStyle := brSingle;
          DropDownRows := 5;
          OnDrawItem := ListBoxDrawItem;
          OnMouseUp  := ListBoxMouseUp;
          _setFlag(FStates, GS_LISTBOXVISIBLE, True);
        end
      end;
      SetGridValues;
      if _getFlag(FStates, GS_THREADINUSE) then
        SendMessage(Handle, CM_THREAD_SETMODE, Integer(tmFind), 0)
      else
        FGridEditThread := TGridEditThread.Create(Self, tmFind);
    end
    else begin
      if _getFlag(FStates, GS_THREADINUSE) then
         PostMessage(Handle, CM_THREAD_STOP, 0, 0);
      PostMessage(Handle, CM_THREAD_FREEBOX, 0, 0);
    end;
  end;
end;

procedure TDCCustomGridEdit.GetHintOnError;
 const
   ErrorHintFormat = '/b%s/b0'#10#13'/oh{3}/{%s/}';
begin
  case FErrorCode of
    ERR_GRID_ILLIGALVALUE   : FErrorHint := LoadStr(RES_GRID_ERR_WRONG);
    ERR_GRID_EXCEPTONLOCATE :
      if FErrorHint <> '' then
        FErrorHint := Format(ErrorHintFormat,
          [LoadStr(RES_GRID_ERR_OPEN), FErrorHint])
      else
        FErrorHint := LoadStr(RES_GRID_ERR_LOCATE);
    ERR_GRID_EXCEPTONFIND   : FErrorHint := LoadStr(RES_GRID_ERR_FIND);
    ERR_GRID_EXCEPTONOPEN   :
      if FErrorHint <> '' then
        FErrorHint := Format(ErrorHintFormat,
          [LoadStr(RES_GRID_ERR_OPEN), FErrorHint])
      else
        FErrorHint := LoadStr(RES_GRID_ERR_OPEN);
   else
    FErrorHint := '';
  end;
  inherited;
end;

procedure TDCCustomGridEdit.GridDblClick(Sender: TObject);
begin
  CloseUp(1);
end;

procedure TDCCustomGridEdit.KeyDown(var Key: Word; Shift: TShiftState);
 var
  KeyDownEvent: TKeyEvent;
begin
  KeyDownEvent := OnKeyDown;
  if _getFlag(FFlags, EM_DROPDOWNVISIBLE) and (FGrid<>nil) then
    case Key of
      VK_PRIOR,
      VK_NEXT ,
      VK_UP   ,
      VK_DOWN ,
      VK_LEFT ,
      VK_RIGHT,
      VK_HOME ,
      VK_END  :
        begin
          if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
          SendMessage(FGrid.Handle, WM_KEYDOWN, Key, 0);
          Key := 0;
        end;
      VK_DELETE  : _setFlag(FStates, GS_VALUESELECTED, False);
      VK_F2:
        if (Shift=[]) and FQueryDataSet then
        begin
          if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
          if Key <> 0 then
          begin
            _setFlag(FStates, GS_FULLQUERY, False);
            Perform(CM_POPUPWINDOW, 1, 0);
            Key := 0;
          end;
        end;
      VK_ESCAPE:
        begin
          CloseUp(0, True);
          Key := 0;
        end;
    end
  else begin
    if [ssAlt]*Shift = [ssAlt] then
    begin
      case Key of
        VK_DOWN:
          begin
            if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
            if Key <> 0 then
            begin
              ChoiceButtonDown;
              Key := 0;
            end;
          end;
      end;
      Exit;
    end;
    if AutoCompleteActive(True) then
      case Key of
        VK_PRIOR,
        VK_NEXT ,
        VK_UP   ,
        VK_DOWN   :
          begin
            if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
            SendMessage(FListBox.Handle, WM_KEYDOWN, Key, 0);
            Key := 0;
          end;
        VK_DELETE  : GetEntryText;
      end
    else
      case Key of
        VK_UP, VK_DOWN:
          begin
            if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
            if (Key <> 0) and not ReadOnly then
            begin
              if not FQueryDataSet then
              begin
                if FDataSet <> nil then
                begin
                  if ActivateDataSet then
                  begin
                    if VarType(KeyValue) <> varNull then
                    begin
                      if Key = VK_UP then FDataSet.Prior else FDataSet.Next;
                    end
                    else
                      FDataSet.First;
                    if FieldExists(KeyField) then
                      SetKeyValue(FDataSet.FieldByName(KeyField).AsVariant);
                  end;
                end;
              end
              else begin
                _setFlag(FStates, GS_FULLQUERY, False);
                ChoiceButtonDown;
              end;
            end;
            Key := 0;
          end;
        VK_DELETE:
          if not ReadOnly then _setFlag(FStates, GS_VALUESELECTED, False);
      end;
  end;
  if Key <> 0 then inherited;
end;

procedure TDCCustomGridEdit.KeyValueChanged;
 var
  i: integer;
begin
  if FKeyValue <> null then
    LocateDataSet
  else begin
    SetGridValues;
    Text := '';
    for i := 0 to Values.Count-1 do TGridValue(Values.Items[i]).AsString := '';
    SendControlMessage(CM_THREAD_LOCATED, 0, 0, True);
  end;
end;

procedure TDCCustomGridEdit.KillFocus(var Value: boolean);
begin
  if CanModified then
  begin
    if not Value and Flags[EM_REQUIRED] and (Trim(Text) = '')
    then begin
      Value := True;
      ErrorCode := ERR_EDIT_EMPTYVALUE;
    end;
    if not Value and (Flags[EM_REQUIRED] or (Trim(Text) <> '')) then
    begin
      if not CheckDataValue then
      begin
        Value := True;
        if FErrorCode = ERR_EDIT_NONE then ErrorCode := ERR_GRID_ILLIGALVALUE;
      end;
    end;
  end;
  if (FErrorCode = ERR_EDIT_NONE) and (Text = '') and
    not _getFlag(FStates, GS_VALUESELECTED) then KeyValue := null;
  inherited KillFocus(Value);
  if not Value and not FQueryDataSet then CloseDataSet;
end;

procedure TDCCustomGridEdit.ListBoxDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
 const
  Alignments: array[Boolean, TAlignment] of DWORD =
    ((ES_LEFT, ES_RIGHT, ES_CENTER),(ES_RIGHT, ES_LEFT, ES_CENTER));
 var
  i: integer;
  sFieldValue: string;
  CurrRect: TRect;
  Column: TColumn;
  GridValue: TGridValue;
begin
  try
    BeginPaintListBox;
    if FListBoxColumns.Count > 0 then
    begin
      if FListBox <> nil then
        with FListBox do
        begin
          Canvas.FillRect(Rect);
          CurrRect := Rect;
          CurrRect.Right := CurrRect.Left;
          {Draw Info line}
          for i := 0 to FListBoxColumns.Count-1 do
          begin
            Column := FListBoxColumns.Items[i];
            if i = FListBoxColumns.Count-1 then
              CurrRect.Right := Rect.Right
            else
              CurrRect.Right := CurrRect.Right + Column.Width;
            Canvas.Font := Column.Font;
            if odSelected in State then
            begin
              Canvas.Brush.Color := clHighLight;
              Canvas.Font.Color := clHighLightText;
            end
            else begin
              Canvas.Brush.Color := Column.Color;
              Canvas.FillRect(CurrRect);
            end;
            CurrRect.Left := CurrRect.Left + 2;
            GridValue := TGridValues(Items.Objects[Index]).Fields[Column.FieldName];
            if GridValue <> nil then
            begin
              sFieldValue := GridValue.AsString;
              DrawText(Canvas.Handle, PChar(sFieldValue), -1,
                  CurrRect, Alignments[UseRightToLeftAlignment, Column.Alignment]);
              CurrRect.Left := CurrRect.Right;
              Canvas.Pen.Color := clBtnShadow;
              if i < FListBoxColumns.Count-1 then begin
                Canvas.MoveTo(CurrRect.Left, CurrRect.Top-1);
                Canvas.LineTo(CurrRect.Left, CurrRect.Bottom);
              end;
              CurrRect.Left := CurrRect.Left + 2;
              if Rect.Left > Width then break;
            end
            else break;
          end;
        end;
    end
    else
      if (FListBox <> nil) and (FListBox.Items.Count>Index)then
        with FListBox do
        begin
          Canvas.FillRect(Rect);
          Rect.Left := Rect.Left + 2;
          DrawText(Canvas.Handle, PChar(Items[Index]), Length(Items[Index]), Rect, 0);
        end;
  finally
    EndPaintListBox;
  end;
end;

procedure TDCCustomGridEdit.ListBoxMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  CloseUp(1);
end;

procedure TDCCustomGridEdit.Loaded;
begin
  inherited;
end;

procedure TDCCustomGridEdit.LocateDataSet;
 var
  Found: boolean;
begin
  if Assigned(FOnGetDataValue) then
  begin
     FOnGetDataValue(Self, FKeyValue, FValues.Fields[FKeyField].FieldType, Found, FValues);
     if FErrorCode <> ERR_EDIT_NONE then SendMessage(Handle, CM_THREAD_ERROR, 0, 0);
  end
  else begin
    if FQueryDataSet then
    begin
      try
        OpenQuery(2);
        if FQuery.RecordCount > 0 then
        begin
          Found := True;
          SetDataValues(FQuery);
        end
        else
          Found := False;
        FQuery.Close;
      except
        ErrorCode := ERR_GRID_EXCEPTONLOCATE;
        FErrorHint := GetQueryText;
        SendMessage(Handle, CM_THREAD_ERROR, 0, 0);
      end;
    end
    else if FDataSet <> nil then
    begin
      try
        if ActivateDataSet then
        begin
          DataSet.DisableControls;
          SetGridValues;

          if FieldExists(FDataField) and
             (DataSet.FieldByName(FKeyField).AsString = VarToStr(FKeyValue)) or
             (DataSet.Locate(FKeyField,FKeyValue,[])) then
          begin
            Found := True;
            SetDataValues(FDataSet);
          end
          else
            Found := False;
          while DataSet.ControlsDisabled do DataSet.EnableControls;
        end;
      except
        ErrorCode := ERR_GRID_EXCEPTONLOCATE;
        SendMessage(Handle, CM_THREAD_ERROR, 0, 0);
      end;
    end;
  end;
  if not Found then ClearValue(True);
  SendControlMessage(CM_THREAD_LOCATED, 0, 0, True);
end;

procedure TDCCustomGridEdit.SetDataSet(const Value: TDataSet);
begin
  SetInternalDataSet(Value, FDataSet);
  if (Value <> nil) then Value.FreeNotification(Self);
end;

procedure TDCCustomGridEdit.SetKeyValue(const Value: variant);
begin
  try
    FKeyValue := Value;
    _setFlag(FStates, GS_VALUESELECTED, True);
    KeyValueChanged;
  except
    ErrorCode := ERR_GRID_ILLIGALVALUE;
    ShowErrorMessage;
  end;
end;

procedure TDCCustomGridEdit.SetKeyValueEx(Value: variant; NeedLocate: boolean);
begin
  try
    FKeyValue := Value;
    _setFlag(FStates, GS_VALUESELECTED, True);
    if NeedLocate or (FQueryDataSet and not FQuery.Active) or
     (not FQueryDataSet and ((FDataSet = nil) or not FDataSet.Active)) then
      KeyValueChanged
    else begin
      if FQueryDataSet then SetDataValues(FQuery) else SetDataValues(FDataSet)
    end;
  except
    ErrorCode := ERR_GRID_ILLIGALVALUE;
    ShowErrorMessage;
  end;
end;

procedure TDCCustomGridEdit.WaitForThreadTerminate(Count: DWORD);
begin
  while _getFlag(FStates, GS_THREADINUSE) do
  begin
    Sleep(Count);
    Application.ProcessMessages;
  end;
end;

procedure TDCCustomGridEdit.WMChar(var Message: TWMChar);
 function ProcessChar_0: boolean;
 begin
   Result := not((Message.CharCode in [0, 13, 27]) or ReadOnly)
 end;

 function ProcessChar_1: boolean;
 begin
   Result := not((Message.CharCode in [0, 8, 13, 27]) or ReadOnly)
 end;

begin
  if ProcessChar_0 then _setFlag(FStates, GS_VALUESELECTED, False);
  inherited;
  if ProcessChar_1 then GetEntryText;
end;

procedure TDCCustomGridEdit.WMPaste(var Message: TWMPaste);
begin
  inherited;
  _setFlag(FStates, GS_VALUESELECTED, False);
end;

function TDCCustomGridEdit.GetSQLText: string;
begin
  Result := FSQLText;
end;

procedure TDCCustomGridEdit.SetSQLText(const Value: string);
 var
  i: integer;
  SOrderBy: string;
begin
  SOrderBy := 'ORDER BY ';
  i := Pos(SOrderBy, AnsiUpperCase(Value));
  if i = 0 then
    FSQLText := Value
  else begin
    FSQLText    := Copy(Value, 1, i-1);
    FSQLOrderBy := Copy(Value, i + Length(SOrderBy), Length(Value));
  end;
  FValues.Clear;
  FValues.FFieldsLoaded := False;
  SetInternalSQLText(Value, FSQLTExt);
end;

function TDCCustomGridEdit.SetGridValues: boolean;
 var
  i: integer;
  GridValue: TGridValue;
begin
  Result := True;
  if not FValues.FFieldsLoaded then
  begin
    FValues.Clear;
    if FQueryDataSet then
      for i := 0 to FQuery.FieldCount-1 do
      begin
        GridValue := TGridValue.Create(nil);
        try
          with GridValue do
          begin
            FieldName := FQuery.Fields[i].FieldName;
            FieldType := FQuery.Fields[i].DataType;
          end;
          FValues.Fields[GridValue.FieldName] := GridValue;
        finally
          GridValue.Free;
        end;
        FValues.FFieldsLoaded := True;
      end
    else begin
      if ActivateDataSet then
      begin
        for i := 0 to DataSet.FieldCount-1 do
        begin
          GridValue := TGridValue.Create(nil);
          try
            with GridValue do
            begin
              FieldName := DataSet.Fields[i].FieldName;
              FieldType := DataSet.Fields[i].DataType;
            end;
            FValues.Fields[GridValue.FieldName] := GridValue;
          finally
            GridValue.Free;
          end;
        end;
        FValues.FFieldsLoaded := True;
      end
      else
        Result := False;
    end;
  end;
end;

procedure TDCCustomGridEdit.SetDataField(const Value: string);
begin
  FDataField := Value;
  if FSQLDataField = '' then FSQLDataField := FDataField;
end;

procedure TDCCustomGridEdit.SetKeyField(const Value: string);
begin
  FKeyField := Value;
  if FSQLKeyField = '' then FSQLKeyField := FKeyField;
end;

procedure TDCCustomGridEdit.SetSQLDataField(const Value: string);
begin
  FSQLDataField := Value;
end;

procedure TDCCustomGridEdit.SetSQLKeyField(const Value: string);
begin
  FSQLKeyField := Value;
end;

procedure TDCCustomGridEdit.SetDataValues(ADataSet: TDataSet);
 var
  i: integer;
begin
  SetGridValues;
  Text := ADataSet.FieldByName(FDataField).AsString;

  for i := 0 to Values.Count-1 do
    TGridValue(Values.Items[i]).AsString :=
      ADataSet.FieldByName(TGridValue(Values.Items[i]).FieldName).AsString;

  if ExistInfo and HandleAllocated then
  begin
    Invalidate;
    HideInfoHint;
  end;
  
end;

procedure TDCCustomGridEdit.GetMargins(var LeftMargin, RightMargin: integer);
 var
  CharWidth: integer;
begin
  inherited;
  if ExistInfo and (RightMargin > 0) and HandleAllocated then
  begin
    RightMargin := RightMargin + FInfoFieldWidth;
    CharWidth := GetCharWidth(Handle, Font);
    if (ClientWidth - RightMargin - LeftMargin - CharWidth) < 0 then
      RightMargin := ClientWidth - LeftMargin - CharWidth;
  end;
end;

procedure TDCCustomGridEdit.SetInfoField(const Value: string);
begin
  if AnsiCompareText(FInfoField, Value) <> 0 then
  begin
    FInfoField := Value;
    SetEditRect;
  end;
end;

procedure TDCCustomGridEdit.SetInfoFieldWidth(const Value: integer);
begin
  if (Value >= 0) and (FInfoFieldWidth <> Value) then
  begin
    FInfoFieldWidth := Value;
    SetEditRect;
  end;
end;

function TDCCustomGridEdit.ExistInfo: boolean;
begin
  Result := (FInfoField <> '') and (FInfoFieldWidth > 0)
end;

procedure TDCCustomGridEdit.DoDrawMargins(DC: HDC);
 var
  RightMargin: integer;
  R: TRect;
  OldPos: TPoint;
  Value: string;
  GridValue: TGridValue;
  Pen: HPEN;
  Brush: HBRUSH;
  ADefault: boolean;
  Size: TSize;
begin
  inherited;
  RightMargin := Width - FMargins.Right;
  if ExistInfo and (RightMargin > 0) then
  begin
    GridValue := FValues.Fields[FInfoField];
    if GridValue <> nil then
      Value := GridValue.AsString
    else
      Value := '';

    SelectObject(DC, Font.Handle);
    if not Enabled and not(csDesigning in ComponentState) then
      SetTextColor(DC, ColorToRGB(clInactiveCaption))
    else
      SetTextColor(DC, ColorToRGB(Font.Color));
    SetBkColor(DC, ColorToRGB(Color));

    R := GetInfoRect;

    ADefault := True;
    if Assigned(FOnDrawInfoText) then FOnDrawInfoText(Self, DC, R, Value, ADefault);

    if ADefault then
    begin
      if ColorToRGB(Color) = ColorToRGB(clBtnFace) then
        Pen := CreatePen(PS_SOLID, 1, ColorToRGB(clBtnShadow))
      else
        Pen := CreatePen(PS_SOLID, 1, ColorToRGB(clBtnFace));
      Brush := CreateSolidBrush(ColorToRGB(Color));
     try
        SelectObject(DC, Pen);
        MoveToEx(DC, R.Left, R.Top, @OldPos);
        LineTo(DC, R.Left, R.Bottom);
        R.Left  := R.Left + 4;
        R.Right := R.Right + 1;
        FillRect(DC, R, Brush);
        R.Right := R.Right - 1;
        GetTextExtentPoint32(DC, PChar(Value), Length(Value), Size);
        if Size.cx > R.Right - R.Left then
        begin
          DrawText(DC, PChar(Value), Length(Value), R, DT_LEFT or DT_NOCLIP);
          _setFlag(FStates, GS_SHOWINFOHINT, True);
        end
        else begin
          DrawText(DC, PChar(Value), Length(Value), R, DT_LEFT);
          _setFlag(FStates, GS_SHOWINFOHINT, False);
        end;
      finally
        DeleteObject(Pen);
        DeleteObject(Brush);
      end
    end;
  end;
end;

procedure TDCCustomGridEdit.AppendRecord;
 var
  AKeyValue: variant;
  AApply: boolean;
begin
  {Append New Record}
  CloseUp(0, True);
  if Assigned(FOnAppendRecord) then
  begin
    AKeyValue := KeyValue;
    AApply    := True;
    FOnAppendRecord(Self, AKeyValue, AApply);
    if AApply and (AKeyValue <> KeyValue) then KeyValue := AKeyValue;
  end;
end;

procedure TDCCustomGridEdit.BeginUpdate(HookChanges: boolean = True);
begin
  if FUpdateCount = 0 then SetValueChanged(False);
  inherited;
end;

procedure TDCCustomGridEdit.EndUpdate;
 var
  ValueChangeEvent: TNotifyEvent;
begin
  if FUpdateCount > 0 then
  begin
    Dec(FUpdateCount);
    ValueChangeEvent := OnValueChange;
    if (FUpdateCount = 0) and Flags[EM_CHANGED] then
    begin
      if Flags[EM_HOOKCHANGED] then Change;
      _setFlag(FFlags, EM_CHANGED, False);
    end;
    if (FUpdateCount = 0) and Flags[EM_VALUECHANGED] then
    begin
      if Assigned(ValueChangeEvent) and Flags[EM_HOOKCHANGED] then
        ValueChangeEvent(Self);
      _setFlag(FFlags, EM_CHANGED, False);
    end;
  end;
end;

function TDCCustomGridEdit.FullQuery: boolean;
begin
  Result := _getFlag(FStates, GS_FULLQUERY);
end;

procedure TDCCustomGridEdit.SetSQLTextPermanet(const Value: string);
begin
  FSQLText := Value;
end;

function TDCCustomGridEdit.ActivateDataSet: boolean;
begin
  if (FDataSet <> nil) and (not FDataSet.Active) then
  begin
    try
      FDataSet.Open;
      SetGridValues;
      _setFlag(FStates, GS_CLOSEDATASET, True);
    except
      on E: Exception do
      begin
        ErrorCode := ERR_GRID_EXCEPTONOPEN;
        FErrorHint := E.Message;
      end;
    end;
  end;
  Result := (FDataSet <> nil) and (FDataSet.Active);
end;

function TDCCustomGridEdit.DoMouseWheelDown(Shift: TShiftState;
  MousePos: TPoint): Boolean;
 var
  Key: Word;
begin
  Result := inherited DoMouseWheelDown(Shift, MousePos);
  if not Result then
  begin
    Key := VK_DOWN;
    KeyDown(Key,  Shift);
    Result := True;
  end;
end;

function TDCCustomGridEdit.DoMouseWheelUp(Shift: TShiftState;
  MousePos: TPoint): Boolean;
 var
  Key: Word;
begin
  Result := inherited DoMouseWheelUp(Shift, MousePos);
  if not Result then
  begin
    Key := VK_UP;
    KeyDown(Key,  Shift);
    Result := True;
  end;
end;

procedure TDCCustomGridEdit.GridCellClick(Columns: TColumn);
begin
  CloseUp(1);
end;

procedure TDCCustomGridEdit.ValidateValue;
begin
  _setFlag(FStates, GS_VALUESELECTED, False);
end;

function TDCCustomGridEdit.GetGridOrderBy: string;
 var
  i: integer;
begin
  if FQueryDataSet then
  begin
    Result := FSQLOrderBy;
    for i := 0 to FColumnsOrder.Count - 1 do begin
      case TColumnIndexStyle(FColumnsOrder.Objects[i]) of
        idxNone:
          ;
        idxAscending:
          begin
            if Result <> '' then
            begin
              if Pos(AnsiUpperCase(FColumnsOrder.Strings[i]), AnsiUpperCase(Result)) = 0 then
                 Result := Format('%s, %s', [Result, FColumnsOrder.Strings[i]])
            end
            else
              Result := Format(' %s', [FColumnsOrder.Strings[i]])
          end;
        idxDescending:
          begin
            if Result <> '' then
            begin
              if Pos(AnsiUpperCase(FColumnsOrder.Strings[i]), AnsiUpperCase(Result)) = 0 then
                Result := Format('%s, %s DESC', [Result, FColumnsOrder.Strings[i]])
            end
            else
              Result := Format(' %s DESC', [FColumnsOrder.Strings[i]])
          end;
      end;
    end
  end;
end;

procedure TDCCustomGridEdit.CMAppendrecord(var Message: TMessage);
begin
  AppendRecord;
end;

procedure TDCCustomGridEdit.LocateFirstValue;
 var
  ACursor: TCursor;
begin
  ACursor := Screen.Cursor;
  Screen.Cursor := crHourGlass;
  try
    try
      if FQueryDataSet then
      begin
        OpenQuery(1);
        if (FQuery <> nil) and FQuery.Active then
        begin
          FQuery.First;
          FKeyValue := FQuery.FieldByName(FKeyField).AsVariant;
          SetDataValues(FQuery);
          FQuery.Close;
          _setFlag(FStates, GS_VALUESELECTED, True);
        end
        else
          KeyValue := null;
      end
      else begin
        if ActivateDataSet then
        begin
          DataSet.DisableControls;
          DataSet.First;
          FKeyValue := DataSet.FieldByName(FKeyField).AsVariant;
          SetDataValues(DataSet);
          while DataSet.ControlsDisabled do DataSet.EnableControls;
          _setFlag(FStates, GS_VALUESELECTED, True);
        end
        else
          KeyValue := null;
      end;
    except
      KeyValue := null;
    end;
  finally
    Screen.Cursor := ACursor;
  end;
end;

procedure TDCCustomGridEdit.InitColumnsOrder;
 var
  i, AIndex: integer;
begin
  if FGrid = nil then Exit;
  with FGrid.Columns do
  begin
    for i := 0 to Count - 1 do
    begin
      AIndex := FColumnsOrder.IndexOf(Items[i].FieldName);
      if (AIndex > -1) and (Items[i].IndexStyle = idxNone) then
        FColumnsOrder.Delete(AIndex)
    end;
    for i := 0 to Count - 1 do
    begin
      if Items[i].Indexed and (Items[i].IndexStyle <> idxNone)then
      begin
        AIndex := FColumnsOrder.Add(Items[i].FieldName);
        FColumnsOrder.Objects[AIndex] := TObject(Items[i].IndexStyle);
      end;
    end;
  end;
end;

procedure TDCCustomGridEdit.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if Operation = opRemove then
  begin
    if AComponent = FDataSet then FDataSet := nil;
    if AComponent = FImages then FImages := nil;
    if AComponent = FGrid then FGrid := nil;
  end;
end;

procedure TDCCustomGridEdit.ImageListChange(Sender: TObject);
begin
  Invalidate;
end;

function TDCCustomGridEdit.GetInfoRect: TRect;
 var
  R: TRect;
begin
  GetWindowRect(Handle, R);  OffsetRect (R, -R.Left, -R.Top);
  R.Left := FMargins.Right + 2;
  R.Right := R.Right - GetButtonWidth - 2;

  case FDrawStyle of
    fsNone  :
     begin
       InflateRect(R, -1, -1);
       R.Left := R.Left -1;
     end;
    fsSingle  :
      InflateRect(R, -3, -3);
    fcsNormal, fsFlat:
      InflateRect(R, -3, -3);
  end;
  Result := R;
end;

procedure TDCCustomGridEdit.WMSetCursor(var Message: TWMSetCursor);
 var
  P: TPoint;
begin
  GetCursorPos(P);
  if PtInHintInfoArea(P.X, P.Y, True) then
    SetCursor(LoadCursor(0, IDC_ARROW))
  else
    inherited;
end;

procedure TDCCustomGridEdit.HideInfoHint;
 var
  pHintWindow: PHintWindowParam_tag;
begin
  if (FInfoHintWindow <> nil) and HandleAllocated then
  begin
    GetMem(pHintWindow, SizeOf(THintWindowParam));
    with pHintWindow^ do
    begin
      Handle := FInfoHintWindow.Handle;
      ShowMode := smHide;
      lpText := nil;
    end;
    SendMessage(Handle, CM_POPUPHINTINFO, 0, Integer(pHintWindow));
  end;
end;

procedure TDCCustomGridEdit.ShowInfoHint;
 var
  pHintWindow: PHintWindowParam_tag;
  R: TRect;
  Value: string;
  GridValue: TGridValue;
begin
  if (FInfoHintWindow = nil) and HandleAllocated then
  begin
    GridValue := FValues.Fields[FInfoField];
    if GridValue <> nil then
      Value := FValues.Fields[FInfoField].AsString
    else
      Value := '';
    GetMem(pHintWindow, SizeOf(THintWindowParam));
    R := GetInfoRect;
    case FDrawStyle of
      fsNone:
        OffsetRect(R, 2, 2);
      fsSingle:
        OffsetRect(R, -1, -1);
      fcsNormal, fsFlat:
        OffsetRect(R, 3, 0);
    end;
    with pHintWindow^ do
    begin
      ShowMode := smShow;
      x := R.Left - 5;
      y := R.Top - 4;
      GetMem(lpText, (Length(Value) + 1) * SizeOf(Char));
      StrPCopy(lpText, Value);
    end;
    SendMessage(Handle, CM_POPUPHINTINFO, 1, Integer(pHintWindow));
  end;
end;

procedure TDCCustomGridEdit.CMPopupHintInfo(var Message: TMessage);
 var
  pHintWindow: PHintWindowParam_tag;
begin
  pHintWindow := PHintWindowParam_tag(Message.LParam);
  with pHintWindow^ do
  begin
    case ShowMode of
      smHide:
       begin
         UnHookPopupHooks;
         FInfoHintWindow.Free;
         FInfoHintWindow := nil;
       end;
     smShow:
       begin
         if not Assigned(FInfoHintWindow) then
         begin
           FInfoHintWindow := TDCMessageWindow.Create(Self);
           with FInfoHintWindow do
           begin
             Parent := Self;
             DialogStyle := dsSimple;
             PopupAlignment := wpOffset;
             Shadow.Visible := False;
           end;
         end
         else
           FInfoHintWindow.Hide;

         with FInfoHintWindow do
         begin
           BeginUpdate;
           Font := Self.Font;
           Caption := lpText;
           Left := x;
           Top := y;
           MaxTextWidth := 400;
           EndUpdate;
           Show;
           HookPopupHooks(Self, GetCurrentThreadID);
         end;
       end;
    end;
  end;
  if Assigned(pHintWindow^.lpText) then FreeMem(pHintWindow^.lpText);
  FreeMem(pHintWindow);
end;

procedure TDCCustomGridEdit.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  HideInfoHint;
end;

procedure TDCCustomGridEdit.CloseDataSet;
begin
  if _getFlag(FStates, GS_CLOSEDATASET) and (FDataSet <> nil) and
    FDataSet.Active then
  begin
    FDataSet.Active := False;
    _setFlag(FStates, GS_CLOSEDATASET, False);
  end;
end;

procedure TDCCustomGridEdit.ShowDropDown;
begin
  WndProcAction(1);
  FGrid.Show;
end;

function TDCCustomGridEdit.GetPreparedQueryText(Mode: integer;
  SQLText: string): string;
 var
  AOrderBy: string;

 function GetLexemPos(ALexem, AText: string): integer;
  const
   stDelim: set of char = [' ', #10, #13];
  var
   i: integer;
 begin
   Result := Pos(AnsiUpperCase(ALexem), AnsiUpperCase(AText));
   if (Result > 0) and
     not((AText[Result-1] in stDelim) and (AText[Result+Length(ALexem)] in stDelim)) then
   begin
     i := GetLexemPos(ALexem, Copy(AText, Result+Length(ALexem), MaxInt));
     if i > 0 then
       Result := Result + i - 1 + Length(ALexem)
     else
       Result := 0;
  end;
 end;

 function InsertWhereValue(ASQLText, AText, SQLField: string; Mode: integer; Quota: boolean): string;
  var
   i: integer;
   BSQLText1, BSQLText2: string;
 begin
   i := GetLexemPos(EDIT_STR_UNION, ASQLText);
   if i = 0 then
   begin
     case Mode of
       0:
         if GetLexemPos(EDIT_STR_WHERE, ASQLText) = 0 then
         begin
           if Quota then
             Result := ASQLText + ' '+ Format(EDIT_FQW_LOCATE, [SQLField, AText])
           else
             Result := ASQLText + ' '+ Format(EDIT_FNW_LOCATE, [SQLField, AText])
         end
         else begin
           if Quota then
             Result := ASQLText + ' '+ Format(EDIT_FQA_LOCATE, [SQLField, AText])
           else
             Result := ASQLText + ' '+ Format(EDIT_FNA_LOCATE, [SQLField, AText]);
         end;
       1:
          if GetLexemPos(EDIT_STR_WHERE, ASQLText) = 0 then
            Result := ASQLText + ' '+  Format(EDIT_FQW_LIKE, [SQLField, AText])
          else
            Result := ASQLText + ' '+  Format(EDIT_FQA_LIKE, [SQLField, AText]);
     end;
   end
   else begin
     BSQLText1 := (Copy(ASQLText, 1, i-1));
     BSQLText2 := (Copy(ASQLText, i+Length(EDIT_STR_UNION), maxInt));
     Result := InsertWhereValue(BSQLText1, AText, SQLField, Mode, Quota) + #13#10 + 
       EDIT_STR_UNION + InsertWhereValue(BSQLText2, AText, SQLField, Mode, Quota);
   end;
 end;

begin
  case Mode of
    0: {locate}
      SQLText := InsertWhereValue(SQLText, Self.Text, FSQLDataField, 0, True);
    1: {like}
      begin
        if (Length(Self.Text) >= 0) and not _getFlag(FStates, GS_FULLQUERY) then
          SQLText := InsertWhereValue(SQLText, Self.Text, FSQLDataField, 1, True);
        AOrderBy := GetGridOrderBy;
        if AOrderBy <> '' then begin
          if GetLexemPos('ORDER BY', SQLText) = 0 then
            SQLText := SQLText + ' '+ Format('ORDER BY %s', [AOrderBy])
          else
            SQLText := SQLText + ' '+ Format(', %s', [AOrderBy])
        end;
      end;
     2: {set KeyValue}
       begin
        SQLText := InsertWhereValue(SQLText, VarToStr(FKeyValue), FSQLKeyField, 0,
          not(VarType(FKeyValue) in [varSmallint, varInteger, varSingle,
            varDouble, varCurrency, varByte]));
       end;
  end;
  Result := SQLText;
end;

procedure TDCCustomGridEdit.OpenQuery(Mode: integer);
begin
  Query.DisableControls;
  try
    PrepareDataSet;
    DoInitQuery(Mode);
    if not _getFlag(FStates, GS_VALUESELECTED) then SetGridValues;
  finally
    Query.EnableControls;
  end;
end;

procedure TDCCustomGridEdit.SendControlMessage(Message, WParam, LParam: integer;
  bPerform: boolean);
begin
  if (Parent <> nil) and HandleAllocated then
    if bPerform then
      SendMessage(Handle, Message, WParam, LParam)
    else
      PostMessage(Handle, Message, WParam, LParam)
end;

procedure TDCCustomGridEdit.DoGridTitleClick(IndexChanged: boolean; Column: TColumn);
begin
  if Assigned(FOnGridTitleClick) then
    FOnGridTitleClick(Column)
  else
    if FQueryDataSet and IndexChanged then  Perform(CM_POPUPWINDOW, 1, 0)
end;

procedure TDCCustomGridEdit.SetImages(const Value: TImageList);
begin
  if Images <> nil then
    Images.UnRegisterChanges(FImageChangeLink);
  FImages := Value;
  if Images <> nil then
  begin
    Images.RegisterChanges(FImageChangeLink);
    Images.FreeNotification(Self);
  end;
  if DroppedDown then invalidate;
end;

procedure TDCCustomGridEdit.HookMessage(wParam: Integer; var Msg: TMsg);
begin
  inherited;
  with Msg do
  begin
    case message of
      WM_MOUSEMOVE:
        if not PtInHintInfoArea(LOWORD(lParam), HIWORD(lParam), False) then
          HideInfoHint;
      CM_DEACTIVATE, CM_RELEASE, WM_KILLFOCUS, WM_CLOSE:
        HideInfoHint;
    end;
  end;
end;

function TDCCustomGridEdit.PtInHintInfoArea(X, Y: integer; Convert: boolean): boolean;
 var
  R: TRect;
  P: TPoint;
begin
  R := GetInfoRect;
  if Convert then
    P := ScreenToClient(Point(X, Y))
  else
    P := Point(X, Y);
  Result := PtInRect(R, P);
end;

procedure TDCCustomGridEdit.WMNCHitTest(var Message: TWMNCHitTest);
begin
  inherited;
  if _getFlag(FStates, GS_SHOWINFOHINT) and not DroppedDown and
    PtInHintInfoArea(Message.XPos, Message.YPos, True) then ShowInfoHint;
end;

function TDCCustomGridEdit.GetDropDownControl: TWinControl;
begin
  if DroppedDown then
  begin
    if AutoCompleteActive(True) then
      Result := FListBox
    else
      Result := FGrid;
  end
  else
    Result := nil;
end;

function TDCCustomGridEdit.GetKeyValue: Variant;
begin
  Result := FKeyValue;
end;

function TDCCustomGridEdit.GetInfoField: string;
begin
  Result := FInfoField;
end;

function TDCCustomGridEdit.GetValues: TGridValues;
begin
  Result := FValues;
end;

procedure TDCCustomGridEdit.SetValues(const Value: TGridValues);
begin
  FValues := Value;
end;

function TDCCustomGridEdit.GetDroppedDown: boolean;
begin
  Result := _getFlag(FFlags, EM_DROPDOWNVISIBLE) or AutoCompleteActive(True);
end;

procedure TDCCustomGridEdit.CMPopupButtonClk(var Message: TMessage);
begin
  case TDCEditButton(Message.WParam).Tag of
    BTAG_EV_CLOSE{Close}: CloseUp(0, False);
  end;
end;

procedure TDCCustomGridEdit.SetGridOptions(
  const Value: TDCGridEditOptions);
 var
  NewOptions: TDCEditOptons;
  ChangedOptions: TDCGridEditOptions;
begin
  if FGridOptions <> Value then
  begin
    NewOptions := [];
    if geSkipValidate in Value then
      NewOptions := NewOptions + [eoSkipValidate];
    if geUndoEscapeBlocking in Value then
      NewOptions := NewOptions + [eoUndoEscapeBlocking];
      
    inherited Options := NewOptions;

    ChangedOptions := (FGridOptions + Value) - (FGridOptions * Value);
    FGridOptions := Value;
  end;
end;

function TDCCustomGridEdit.DoCreatePopupGrid: TDCCustomPopupDBGrid;
begin
  Result := TDCCustomPopupDBGrid.Create(Self);
end;

function TDCCustomGridEdit.AutoCompleteActive(CheckVisible: boolean): boolean;
begin
  Result := _getFlag(FStates, GS_LISTBOXVISIBLE) and (FListBox <> nil) and
   (not CheckVisible or FListBox.ListVisible);
end;

procedure TDCCustomGridEdit.CMHintActivate(var Message: TMessage);
 var
  pPause: ^Integer;
  pHintWindow: PHintWindowParam_tag;
begin
  pHintWindow := PHintWindowParam_tag(Message.LParam);
  if not pHintWindow^.Active then
  begin
    pPause  := Pointer(Message.WParam);
    pPause^ := 200;
  end;
end;

function TDCCustomGridEdit.GetGridOptions: TDCGridEditOptions;
begin
  Result := FGridOptions; 
end;

{ TGridEditThread }

procedure TGridEditThread.AddValue;
 var
  i: integer;
  GridValues: TGridValues;
  GridValue: TGridValue;
begin
  with FGridEdit, FGridEdit.DataSet do
  begin
    if not Assigned(FListBox) then Exit;
    if not FListBox.ListVisible then
        SendMessage(FGridEdit.Handle, CM_THREAD_SHOWBOX, 0, 0);
    GridValues := TGridValues.Create(nil);
    for i := 0 to Values.Count-1 do
    begin
      GridValue := TGridValue.Create(nil);
      with GridValue do
      begin
        FieldName := TGridValue(Values.Items[i]).FieldName;
        FieldType := TGridValue(Values.Items[i]).FieldType;
      end;
      GridValues.Fields[GridValue.FieldName] := GridValue;
      GridValue.Free;
    end;
    for i := 0 to GridValues.Count-1 do
      TGridValue(GridValues.Items[i]).AsString :=
        DataSet.FieldByName(TGridValue(GridValues.Items[i]).FieldName).AsString;

    SendGridMessage(CM_THREAD_ITEMADD, 0, LongInt(GridValues));
  end;
end;

constructor TGridEditThread.Create(GridEdit: TDCCustomGridEdit; Mode: TTHreadMode);
begin
  FGridEdit := GridEdit;
  Priority := tpHighest	;
  FMode := Mode;
  FGridEdit.FThreadMode  := tmIdle;
  _setFlag(FGridEdit.FStates, GS_THREADINUSE, True);
  inherited Create(False);
end;

procedure TGridEditThread.Execute;
begin
  SendGridMessage(CM_THREAD_START, 0, 0, True);
  FStoped := False;
  while not FStoped do
    case FMode of
     tmFind:
       FindDataSet;
     tmStop:
       FStoped := True;
    end;
  SendGridMessage(CM_THREAD_TERMINATE, 0, 0, True);
end;

procedure TGridEditThread.FindDataSet;
 var
  Msg: TMsg;
  BreakThread: boolean;
begin
  SendGridMessage(CM_THREAD_HIDEBOX, 0, 0);
  SendGridMessage(CM_THREAD_ITEMCLR, 0, 0);
  with FGridEdit, FGridEdit.DataSet do
  begin
    DataSet.DisableControls;
    BreakThread := False;
    FMode := tmSearching;
    try
      try
        First;
        while not(Eof or BreakThread) do
        begin
          if PeekMessage(Msg, 0, 0, 0, PM_REMOVE) then
          begin
            FGridEdit.FThreadMode := tmIdle;
            case Msg.Message of
              CM_THREAD_STOP:
                begin
                  BreakThread := True;
                  FMode := tmStop;
                end;
              CM_THREAD_SETMODE:
                begin
                  FMode := TThreadMode(Msg.WParam);
                  BreakThread := True;
                end;
            end;
          end
          else
            if FGridEdit.FThreadMode <> tmIdle then
            begin
              FMode := FGridEdit.FThreadMode;
              PeekMessage(Msg, 0, 0, 0, PM_REMOVE);
              FGridEdit.FThreadMode := tmIdle;
              BreakThread := True;
            end;
          if not BreakThread then
          begin
            if Pos(AnsiUpperCase(Text),
              AnsiUpperCase(FieldByName(FDataField).AsString)) = 1 then AddValue;
            Next;
            Application.ProcessMessages;
          end;
        end;
      except
        ErrorCode := ERR_GRID_EXCEPTONFIND;
        SendGridMessage(CM_THREAD_ERROR, 0, 0);
      end;
    finally
      if (FMode <> tmFind) and ((FListBox.Items.Count = 0) or BreakThread) then
         SendGridMessage(CM_THREAD_FREEBOX, 0, 0);
      while DataSet.ControlsDisabled do DataSet.EnableControls;
    end;
  end;
  FStoped := FMode <> tmFind;
  if FStoped then SendGridMessage(CM_THREAD_FINDCMPLT, 0, 0);
end;

procedure TGridEditThread.SendGridMessage(Msg: UINT; wParam: WPARAM;
  lParam: LPARAM; lPostMessage: boolean = False);
begin
  if lPostMessage then
    PostMessage(FGridEdit.Handle, Msg, wParam, lParam)
  else
    SendMessage(FGridEdit.Handle, Msg, wParam, lParam);
end;

procedure TGridEditThread.SetFindValue(const Value: string);
begin
  FFindValue := Value;
end;

{ TGridValue }

constructor TGridValue.Create(AOwner: TCollection);
begin
  inherited Create(AOwner);
end;

function TGridValue.GetAsString: string;
begin
  Result := VarToStr(FValue);
end;

procedure TGridValue.SetAsString(Value: string);
begin
  FValue := VarAsType(Value, varString);
end;

{ TGridValues }

function TGridValues.Add: TGridValue;
begin
  Result := TGridValue(inherited Add);
end;

constructor TGridValues.Create(AOwner: TComponent);
begin
  inherited Create(TGridValue);
  FIndex  := -1;
  FFieldsLoaded := False;
end;

function TGridValues.GetItem(Field: string): TGridValue;
 var
  Index: integer;
  GridValue: TGridValue;
begin
  FIndex := -1;
  Result := nil;
  for Index := 0 to Count-1 do
  begin
    GridValue := TGridValue(inherited GetItem(Index));
    if AnsiUpperCase(GridValue.FFieldName) = AnsiUpperCase(Field) then
    begin
      Result := GridValue;
      FIndex := Index;
      Break;
    end
  end;
end;

procedure TGridValues.SetItem(Field: string; Value: TGridValue);
 var
  GridValue: TGridValue;
begin
  GridValue := GetItem(Field);
  if FIndex = -1 then begin
    GridValue := TGridValue(Add);
  end;
  GridValue.FieldName:= Value.FieldName;
  GridValue.Value    := Value.Value;
  GridValue.FieldType:= Value.FieldType;
end;

procedure TDCCustomComboBox.GetHintOnError;
begin
  case FErrorCode of
    ERR_COMBO_ILLIGALVALUE  : FErrorHint := LoadStr(RES_COMB_ERR_WRONG);
   else
    FErrorHint := '';
  end;
  inherited;
end;

procedure TDCCustomComboBox.WMSetCursor(var Message: TWMSetCursor);
begin
  if NotEditControl then SetCursor(LoadCursor(0, IDC_ARROW)) else inherited;
end;

procedure TDCCustomComboBox.SetEditing(const Value: boolean);
 var
  sText: string;
begin
  if FEditing <> Value and (FStyle = csDropDownList) then
  begin
    FEditing := Value;
    sText := Text;
    RecreateWnd;
    Text := sText;
  end;
end;

procedure TDCCustomComboBox.Clear;
begin
  FItems.Clear;
  FItemIndex := -1;
end;

procedure TDCCustomChoiceEdit.SetCaret;
 var
  CaretHeight: integer;
begin
  CaretHeight := GetCharHeight(Handle, Font);
  CreateCaret(Handle, 0, 1, CaretHeight);
  ShowCaret(Handle);
end;

{ TDCCustomTreeEdit }

procedure TDCCustomTreeEdit.ChangeSelected(Sender: TObject; Node: TTreeNode);
begin
  if not (csDestroying in ComponentState) then
  begin
    if (Selected <> nil) and (Selected.Text <> '') then  SetText(Selected.Text)
  end;
end;

procedure TDCCustomTreeEdit.CMCancelMode(var Message: TCMCancelMode);
begin
  if (Message.Sender <> Self) and
     (Message.Sender <> FTreeView) and
     not FTreeView.ContainsControl(Message.Sender) then
  begin
    inherited;
  end;
end;

procedure TDCCustomTreeEdit.CMEnter(var Message: TCMEnter);
begin
  inherited;
  if FStyle = teDropDownList then PaintListItem(Focused and
    not _getFlag(FFlags, EM_DROPDOWNVISIBLE));
end;

constructor TDCCustomTreeEdit.Create(AOwner: TComponent);
begin
  inherited;
  _setFlag(FFlags, EM_DROPDOWNVISIBLE, False);
  _setFlag(FFlags, TE_NODESELECTED, True);
  _setFlag(FFlags, TE_TREEINITIALIZE, False);

  FTreeView := TDCPopupTreeView.Create(Self);
  ControlStyle:= ControlStyle - [csSetCaption, csFixedHeight];
  with FTreeView do
  begin
    Parent := Self;
    OnChange     := ChangeSelected;
    OnKeyPress   := TreeViewKeyPress;
    OnDblClick   := TreeViewDblClick;
    OnExpanded   := Expanded;
    OnExpanding  := Expanding;
    OnCollapsed  := Collapsed;
    OnCollapsing := Collapsing;
    OnCustomDrawItem := CustomDrawItem;
    case DrawStyle of
      fcsNormal: PopupBorderStyle := brRaised;
      fsNone   : PopupBorderStyle  := brRaised;
      fsSingle : PopupBorderStyle  := brRaised;
      fsFlat   : PopupBorderStyle  := brRaised;
    end;
  end;
  FStyle := teDropDownList;

  FImageChangeLink :=  TChangeLink.Create;
  FImageChangeLink.OnChange := ImageListChange;
end;

procedure TDCCustomTreeEdit.CreateParams(var Params: TCreateParams);
begin
  inherited;
  if FStyle = teDropDownList then
  begin
    with Params do
    begin
      Style := WS_CHILD or WS_CLIPSIBLINGS;
      AddBiDiModeExStyle(ExStyle);
      if csAcceptsControls in ControlStyle then
      begin
        Style := Style or WS_CLIPCHILDREN;
        ExStyle := ExStyle or WS_EX_CONTROLPARENT;
      end;
      if not (csDesigning in ComponentState) and not Enabled then
        Style := Style or WS_DISABLED;
      if TabStop then Style := Style or WS_TABSTOP;
      if Parent <> nil then
        WndParent := Parent.Handle else
        WndParent := ParentWindow;
      WindowClass.style := CS_VREDRAW + CS_HREDRAW + CS_DBLCLKS;
      WindowClass.lpfnWndProc := @DefWindowProc;
      WindowClass.hCursor := LoadCursor(0, IDC_ARROW);
      WindowClass.hbrBackground := 0;
      WindowClass.hInstance := HInstance;
      StrPCopy(WinClassName, ClassName);
    end;
  end;
end;

destructor TDCCustomTreeEdit.Destroy;
begin
  FImageChangeLink.Free;
  ClearTreeItems;
  FTreeView.Free;
  inherited;
end;

function TDCCustomTreeEdit.GetSelected: TTreeNode;
begin
  Result := FTreeView.Selected;
end;

function TDCCustomTreeEdit.GetTreeView: TTreeView;
begin
  Result := TTreeView(FTreeView);
end;

procedure TDCCustomTreeEdit.InitTree;
begin
  if Assigned(FOnInitTree) then FOnInitTree(Self, TTreeView(FTreeView));
  _setFlag(FFlags, TE_TREEINITIALIZE, True);
end;

procedure TDCCustomTreeEdit.KeyDown(var Key: Word; Shift: TShiftState);
 var
  KeyDownEvent: TKeyEvent;
begin
  KeyDownEvent := OnKeyDown;
  if _getFlag(FFlags, EM_DROPDOWNVISIBLE) and (FTreeView<>nil) then
    case Key of
      VK_PRIOR,
      VK_NEXT ,
      VK_UP   ,
      VK_DOWN ,
      VK_LEFT ,
      VK_RIGHT:
        begin
          if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
          SendMessage(FTreeView.Handle, WM_KEYDOWN, Key, 0);
          Key := 0;
        end;
      VK_ESCAPE:
        begin
          CloseUp(0, True);
          Key := 0;
        end;
    end
  else begin
    if [ssAlt]*Shift = [ssAlt] then
    begin
      case Key of
        VK_DOWN:
          begin
            if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
            if Key <> 0 then ChoiceButtonDown;
            Key := 0;
          end;
      end;
      Exit;
    end;
    case Key of
      VK_DOWN:
        begin
          if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
          if Key <> 0 then ChoiceButtonDown;
          Key := 0;
        end;
    end;
  end;
  case Key of
    VK_DELETE:
      if not ReadOnly then _setFlag(FFlags, TE_NODESELECTED, False);
  end;
  if Key <> 0 then inherited;
end;

procedure TDCCustomTreeEdit.Loaded;
begin
  inherited;
  if csDesigning in ComponentState then
    Text := Name
  else begin
    if Assigned(Selected) then
      SetText(Selected.Text)
    else
      SetText('');
  end;
end;

procedure TDCCustomTreeEdit.PaintListItem(bFocused: boolean);
const
  Alignments: array[Boolean, TAlignment] of DWORD =
    ((DT_LEFT, DT_RIGHT, DT_CENTER),(DT_RIGHT, DT_LEFT, DT_CENTER));
 var
  DC: HDC;
  R: TRect;
  ACanvas: TCanvas;
  ANodeIndex: integer;
begin
  if not(FStyle = teDropDownList) or (Parent = nil) then Exit;

  bFocused := bFocused and not _getFlag(FFlags, EM_DROPDOWNVISIBLE);

  ACanvas := TControlCanvas.Create;
  DC := GetWindowDC(Handle);

  GetWindowRect (Handle, R);  OffsetRect (R, -R.Left, -R.Top);
  if PaintCheckGlyph  then R.Left := R.Left + FCheckGlyph.Width + 2;
  if ButtonWidth > 0 then
  begin
    R.Right := R.Right - ButtonWidth;
    if FDrawStyle = fsFlat then R.Right := R.Right - 1
  end;
  case FDrawStyle of
    fsNone  :
     begin
       InflateRect(R, -1, -1);
       R.Left := R.Left -1;
     end;
    fsSingle  :
     begin
       InflateRect(R, -2, -2);
       R.Right := R.Right -1;
     end;
    fcsNormal,
    fsFlat  :
     InflateRect(R, -3, -3);
  end;

  ACanvas.Handle := DC;
  ACanvas.Font         := Font;
  ACanvas.Brush.Color  := Color;
  InflateRect(R, 1, 1);
  FillRect(ACanvas.Handle, R, ACanvas.Brush.Handle);
  InflateRect(R, -1, -1);

  if bFocused then
  begin
    ACanvas.Brush.Color := clHighlight;
    ACanvas.Font.Color  := clHighlightText;
  end;

  try
    if (Selected <> nil) and Assigned(FImages) and (Selected.ImageIndex <> -1)
    then begin
      R.Left := R.Left + 1;
      if bFocused then
        FImages.DrawingStyle := dsTransparent
      else
        FImages.DrawingStyle := dsTransparent;

      FImages.Draw(ACanvas, R.Left, R.Top, Selected.ImageIndex, True);
      R.Left := R.Left + FImages.Width + 1;
    end;
    if FDrawStyle = fsNone then
      R.Left  := R.Left  +1;
    FillRect(ACanvas.Handle, R, ACanvas.Brush.Handle);
    if bFocused then DrawFocusRect(ACanvas.Handle, R);
    InflateRect(R, -1, -1);
    SetBkMode(ACanvas.Handle, TRANSPARENT);
    case FDrawStyle of
      fcsNormal,
      fsFlat  ,
      fsNone  : R.Top := R.Top -1;
    end;

    R.Left := R.Left + 2;
    if Assigned(FOnDrawText) then
    begin
      if Assigned(Selected) then
        ANodeIndex := Selected.Index
      else
        ANodeIndex := -1;
      FOnDrawText(ACanvas, Self, ANodeIndex, R, []);
    end
    else
      DrawText(ACanvas.Handle, PChar(Text), Length(Text), R,
        Alignments[UseRightToLeftAlignment, FAlignment]);
  finally
    ReleaseDC(Handle, DC);
    ACanvas.Handle := 0;
    ACanvas.Free;
  end;
end;


procedure TDCCustomTreeEdit.SetSelected(const Value: TTreeNode);
begin
  FTreeView.Selected := Value;
  _setFlag(FFlags, TE_NODESELECTED, True);
end;

procedure TDCCustomTreeEdit.SetText(Value: string);
begin
  if Assigned(FOnSetText) then
    FOnSetText(Self)
  else
    Text := Value;
  if (Style = teDropDownList) and Assigned(FOnChange) then
     FOnChange(Self, Selected);
end;

procedure TDCCustomTreeEdit.SetTreeView(const Value: TTreeView);
begin
  FTreeView.Items.Assign(Value.Items);
  FImages := TImageList(Value.Images); 
end;

procedure TDCCustomTreeEdit.TreeViewDblClick(Sender: TObject);
begin
  CloseUp(1);
end;

procedure TDCCustomTreeEdit.TreeViewKeyPress(Sender: TObject; var Key: Char);
begin
  inherited;
end;

procedure TDCCustomTreeEdit.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  inherited;
  Message.Result := DLGC_WANTARROWS or DLGC_WANTCHARS or DLGC_WANTALLKEYS;
end;

procedure TDCCustomTreeEdit.WMLButtonDblClk(var Message: TWMLButtonDown);
begin
  if _getFlag(FFlags, EM_DROPDOWNVISIBLE) and
    (TMessage(Message).WParam = $AE) then CloseUp(1)
  else begin
    if FStyle = teDropDownList then Message.Result := $AE;
    inherited WMLButtonDblClk(Message);
  end;
end;

procedure TDCCustomTreeEdit.WMPaint(var Message: TWMPaint);
 var
  PS: TPaintStruct;
begin
  if FStyle = teDropDownList then
  begin
    BeginPaint(Handle, PS);
    RedrawBorder(True, 0);
    PaintListItem(Focused and not _getFlag(FFlags, EM_DROPDOWNVISIBLE));
    EndPaint(Handle, PS);
  end
  else
    inherited;
end;

procedure TDCCustomTreeEdit.WMSetCursor(var Message: TWMSetCursor);
begin
//  inherited;
  SetCursor(LoadCursor(0, IDC_ARROW));
end;

procedure TDCCustomTreeEdit.WMSetFocus(var Message: TWMSetFocus);
begin
  inherited;
  if FStyle = teDropDownList then HideCaret(Handle);
end;

procedure TDCCustomTreeEdit.WndProc(var Message: TMessage);
begin
  inherited WndProc(Message);
  if csDesigning in ComponentState then Exit;
  case Message.Msg of
    WM_LBUTTONDOWN, WM_LBUTTONDBLCLK:
      if not(Flags[EM_HITBUTTONAREA] or Flags[EM_HITCHECKAREA]) and
        (Message.WParam <> $AE) and (FStyle = teDropDownList) then
      begin
        if not Focused then SetFocus;
        if Focused then
          with FBtnChoice do UpdateButtonState(Left + 1, Top + 1, True, False);
      end;
  end;
end;

procedure TDCCustomComboBox.CheckClick(Sender: TObject);
begin
  inherited;
  if NotEditControl then HideCaret(Handle);
end;

procedure TDCCustomComboBox.CreateWnd;
begin
  inherited;
end;

procedure TDCCustomTreeEdit.CMTextChanged(var Message: TMessage);
begin
  inherited;
  if (FStyle = teDropDownList) then
    PaintListItem(Focused and not _getFlag(FFlags, EM_DROPDOWNVISIBLE));
end;

procedure TDCCustomTreeEdit.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited;
  if (Operation = opRemove) and (AComponent = FImages) then FImages := nil;
end;

procedure TDCCustomTreeEdit.CMExit(var Message: TCMExit);
begin
  inherited;
  if FStyle = teDropDownList then
  begin
    if not ShowError then
      PaintListItem(False)
    else
      PaintListItem(True)
  end;
end;

function TDCCustomComboBox.MinControlWidthBitmap: integer;
begin
  if Style <> csDropDownList then
    Result := inherited MinControlWidthBitmap
  else
    Result := 2;
end;

procedure TDCCustomChoiceEdit.SetLinkControl(const Value: TWinControl);
begin
  FLinkControl := Value;
  if Value <> nil then Value.FreeNotification(Self);
end;

procedure TDCCustomChoiceEdit.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (AComponent = FLinkControl) then FLinkControl := nil;
end;

procedure TDCCustomComboBox.EMGetSel(var Message: TMessage);
begin
  if FStyle = csDropDownList then
  with Message do
  begin
    lParam := 0;
    wParam := GetTextLen;
  end
  else
    inherited
end;

procedure TDCCustomTreeEdit.EMGetSel(var Message: TMessage);
begin
  with Message do
  begin
    lParam := 0;
    wParam := GetTextLen;
  end
end;

function TDCCustomChoiceEdit.GetButtonWidth: integer;
begin
  if BtnChoiceAssigned then
    Result := FBtnChoice.Width
  else
    Result := 0
end;

procedure TDCCustomTreeEdit.Collapsed(Sender: TObject; Node: TTreeNode);
begin
  if Assigned(FOnCollapsed) then FOnCollapsed(Sender, Node);
end;

procedure TDCCustomTreeEdit.Collapsing(Sender: TObject; Node: TTreeNode;
  var AllowExpansion: Boolean);
begin
  if Assigned(FOnCollapsing) then FOnCollapsing(Sender, Node, AllowExpansion);
end;

procedure TDCCustomTreeEdit.Expanded(Sender: TObject; Node: TTreeNode);
begin
  if Assigned(FOnExpanded) then FOnExpanded(Sender, Node);
end;

procedure TDCCustomTreeEdit.Expanding(Sender: TObject; Node: TTreeNode;
  var AllowExpansion: Boolean);
begin
  if Assigned(FOnExpanding) then FOnExpanding(Sender, Node, AllowExpansion);
end;

procedure TDCCustomChoiceEdit.AdjustClientRect(var Rect: TRect);
begin
  inherited;
  Rect.Right := Rect.Right-ButtonWidth;
end;

procedure TDCCustomChoiceEdit.DefineBtnChoiceStyle;
begin
  {}
end;

procedure TDCCustomComboBox.DefineBtnChoiceStyle;
begin
  if BtnChoiceAssigned then
  begin
    ButtonChoiceStyle := btsCombo;
    ButtonStyle := esDropDown;
  end;
end;

procedure TDCCustomTreeEdit.DefineBtnChoiceStyle;
begin
  if BtnChoiceAssigned then
  begin
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNTREE');
    ButtonStyle := esDropDown;
    ButtonChoiceStyle := btsCustom;
    if (FStyle = teDropDownList) and (FDrawStyle = fsSingle) then
      ButtonChoice.Height := ClientHeight;
    ButtonChoice.Options := ButtonChoice.Options - [boSimpleStyle];
  end;
end;

procedure TDCCustomComboBox.CMPopupWindow(var Message: TMessage);
begin
  case Message.WParam of
    0:
     if _getFlag(FFlags, EM_DROPDOWNVISIBLE) then
     begin
       if BtnChoiceAssigned then FBtnChoice.ResetProperties;
       _setFlag(FFlags, EM_DROPDOWNVISIBLE, False);
       FListBox.Free;
       FListBox := nil;
       ShowHint  := Flags[EM_SAVEDSHOWHINT];
       PaintListItem(Focused);
       DoCloseUp;
     end;
    1:
     begin
       PaintListItem(False);
       _setFlag(FFlags, EM_SAVEDSHOWHINT, ShowHint);
       ShowHint  := False;
       DropDown;
       FListBox := TDCPopupListBox.Create(Self);
       FCachedIndex := FItemIndex;
       FCachedText  := Text;
       with FListBox do
       begin
         //Color := Self.Color;
         Parent := Self;
         PopupAlignment := wpBottomLeft;
         DropDownRows := DropDownCount;
         case DrawStyle of
           fcsNormal,
           fsNone   : FListBox.PopupBorderStyle := brSingle;
           fsSingle : FListBox.PopupBorderStyle := brRaised;
           fsFlat   : FListBox.PopupBorderStyle := brRaised;
         end;
         if FDropDownWidth = 0 then Width := Self.Width
           else Width :=FDropDownWidth;
         OnMeasureItem := FOnMeasureItem;
         ItemHeight := FItemHeight;
         Items := Self.Items;
         OnDrawItem := FOnDrawItem;
         OnMouseUp  := ListMouseUp;
         if not( (FItemIndex < Self.Items.Count-1) and
                 (FItemIndex> -1) and
                 (AnsiCompareText(Self.Items.Strings[FItemIndex],Text)=0) ) then
           FItemIndex := GetFirstEntry(False);
         ItemIndex  := FItemIndex;
         SelectAll;
         ShowDropDown;
         _setFlag(FFlags, EM_DROPDOWNVISIBLE, True);
       end
     end;
  end;
end;

procedure TDCCustomTreeEdit.CMPopupWindow(var Message: TMessage);
 var
  lDropDown: boolean;
begin
  lDropDown := _getFlag(FFlags, EM_DROPDOWNVISIBLE);
  case Message.WParam of
    0:
      if _getFlag(FFlags, EM_DROPDOWNVISIBLE) then
      begin
        if BtnChoiceAssigned then FBtnChoice.ResetProperties;
        FTreeView.Hide;
        lDropDown := False;
        ShowHint := _getFlag(FFlags, EM_SAVEDSHOWHINT);
        if FStyle = teDropDownList then PaintListItem(Focused);
        DoCloseUp;
      end;
    1:
     begin
       if FStyle = teDropDownList then PaintListItem(Focused and not lDropDown);
       _setFlag(FFlags, EM_SAVEDSHOWHINT, ShowHint);
       ShowHint  := False;
       with FTreeView do
       begin
         lDropDown := True;
         Color := Self.Color;
         PopupAlignment := wpBottomLeft;
         Images := FImages;
         Caption := DBObject.Caption;
         if FDropDownWidth = 0 then
           Width := Self.Width
         else
           Width :=FDropDownWidth;
         PaintListItem(False);
         if not(csDesigning in ComponentState) then Buttons.SetWndProc;
         if not _getFlag(FFlags, TE_TREEINITIALIZE) then InitTree;
         SetScrollPos(Handle, SB_HORZ, 0, True);
         ShowDropDown;
       end
     end;
  end;
  _setFlag(FFlags, EM_DROPDOWNVISIBLE, lDropDown);
end;

procedure TDCCustomChoiceEdit.GetMargins(var LeftMargin: integer;
  var RightMargin: integer);
 var
  CharWidth, ABorderWidth: integer;
begin
  if HandleAllocated and PaintCheckGlyph then
  begin
    CharWidth := GetCharWidth(Handle, Font);
    LeftMargin    := FCheckGlyph.Width;
    if LeftMargin < CharWidth then
      LeftMargin := CharWidth + 5
    else
      Inc(LeftMargin, 2);
  end
  else
    LeftMargin := 0;

  ABorderWidth := 0;

  case FDrawStyle of
    fsNone   : ABorderWidth := 0;
    fsSingle,
    fcsNormal,
    fsFlat   : ABorderWidth := 6;
  end;
  if Assigned(FBtnChoice) then
  begin
    if (Width < MinControlWidthBitmap) then
    begin
       RightMargin  := 0;
       FBtnChoice.Free;
       FBtnChoice   := nil;
     end
     else begin
       RightMargin  := FBtnChoice.Width;
       if (Alignment = taRightJustify) or  (Alignment = taCenter) then
       begin
         Inc(RightMargin, 4);
       end;
     end;
     Inc(RightMargin, ABorderWidth);
  end
  else
    RightMargin := 0;

end;

procedure TDCCustomChoiceEdit.DoDrawMargins(DC: HDC);
begin
  {}
end;

procedure TDCCustomTreeEdit.SetStyle(const Value: TTreeEditStyle);
begin
  FStyle := Value;
  RecreateWnd;
end;

procedure TDCCustomTreeEdit.KillFocus(var Value: boolean);
 var
  Node: TTreeNode;
  AErrorCode: integer;
begin
  if CanModified and not _getFlag(FFlags, TE_NODESELECTED) then
  begin
    if Trim(Text) <> '' then
    begin
      AErrorCode := 0;
      if not GetNode(Text, Node, AErrorCode) then
      begin
        Value := True;
        if AErrorCode = 0 then
          ErrorCode := ERR_TREE_ILLIGALVALUE
        else
          ErrorCode := AErrorCode;
      end
      else if Assigned(Node) then SetSelected(Node)
    end
    else begin
      Selected := nil;
      _setFlag(FFlags, TE_NODESELECTED, False);
    end
  end;
  inherited;
end;

function TDCCustomTreeEdit.GetNode(Value: string;
  var Node: TTreeNode; var ErrorCode: integer): boolean;
 var
  ANode: TTreeNode;
  AValue, AText: string;
begin
  ANode := FTreeView.Items.GetFirstNode;
  AValue := AnsiUpperCase(Value);
  while ANode <> nil do
  begin
    if Assigned(FOnGetText) then
      FOnGetText(Self, ANode, AText)
    else
      AText := AnsiUpperCase(ANode.Text);
    if (CompareText(AValue, AText) = 0) and CanSelectNode(ANode) then
    begin
      Result := True;
      Node   := ANode;
      Exit;
    end;
    if ANode.HasChildren and not ANode.Expanded then
    begin
      ANode.Expand(False);
      ANode.Collapse(False);
    end;
    ANode := ANode.GetNext;
  end;

  Result := False;
end;

procedure TDCCustomTreeEdit.GetHintOnError;
begin
  case FErrorCode of
    ERR_TREE_ILLIGALVALUE: FErrorHint := LoadStr(RES_TREE_ERR_WRONG);
  else
    FErrorHint := '';
  end;
  inherited;
end;

procedure TDCCustomTreeEdit.WMPaste(var Message: TWMPaste);
begin
  inherited;
  _setFlag(FFlags, TE_NODESELECTED, False);
end;

procedure TDCCustomTreeEdit.WMChar(var Message: TWMChar);
begin
  if not (Message.CharCode in [0, 13, 27]) and (Message.KeyData <> 0) and not ReadOnly then
    _setFlag(FFlags, TE_NODESELECTED, False);
  inherited;
end;

function TDCCustomTreeEdit.DoMouseWheelDown(Shift: TShiftState;
  MousePos: TPoint): Boolean;
 var
  Key: Word;
begin
  Result := inherited DoMouseWheelDown(Shift, MousePos);
  if not Result then
  begin
    Key := VK_DOWN;
    KeyDown(Key,  Shift);
    Result := True;
  end;
end;

function TDCCustomTreeEdit.DoMouseWheelUp(Shift: TShiftState;
  MousePos: TPoint): Boolean;
 var
  Key: Word;
begin
  Result := inherited DoMouseWheelUp(Shift, MousePos);
  if not Result then
  begin
    Key := VK_UP;
    KeyDown(Key,  Shift);
    Result := True;
  end;
end;

procedure TDCCustomTreeEdit.Change;
begin
  inherited Changed;
  if Trim(Text) = '' then
  begin
    Selected := nil;
    _setFlag(FFlags, TE_NODESELECTED, False);
  end;
  if Assigned(FOnChange) then FOnChange(Self, Selected);
end;

procedure TDCCustomTreeEdit.CustomDrawItem(Sender: TCustomTreeView; Node: TTreeNode;
       State: TCustomDrawState; var DefaultDraw: Boolean);
begin
  if Assigned(FOnCustomDrawItem) then FOnCustomDrawItem(Sender, Node, State, DefaultDraw);
end;

procedure TDCCustomTreeEdit.ClearTreeItems;
begin
  if Assigned(FOnClearItems) then FOnClearItems(Self, TreeView);
  TreeView.Items.Clear;
  _setFlag(FFlags, TE_TREEINITIALIZE, False);
end;

procedure TDCCustomTreeEdit.ImageListChange(Sender: TObject);
begin
  invalidate;
end;

procedure TDCCustomTreeEdit.CloseUp(State: Byte; bPerform: boolean);
 var
  lCanSelected: boolean;
begin
  if _getFlag(FFlags, EM_DROPDOWNVISIBLE) then
  begin
    lCanSelected := CanSelectNode(Selected);
    if (State = 0) or lCanSelected then inherited;
    _setFlag(FFlags, TE_NODESELECTED, (State = 1) and lCanSelected);
  end
end;

function TDCCustomTreeEdit.CanSelectNode(Node: TTreeNode): boolean;
begin
  Result := True;
  if Assigned(FOnSelectNode) then FOnSelectNode(Self, Node, Result);
end;

procedure TDCCustomTreeEdit.ShowDropDown;
begin
  WndProcAction(1);
  FTreeView.Show;
end;

procedure TDCCustomTreeEdit.SetImages(const Value: TImageList);
begin
  if Images <> nil then
    Images.UnRegisterChanges(FImageChangeLink);
  FImages := Value;
  if Images <> nil then
  begin
    Images.RegisterChanges(FImageChangeLink);
    Images.FreeNotification(Self);
  end;
  if DroppedDown then invalidate;
end;

function TDCCustomTreeEdit.GetDropDownControl: TWinControl;
begin
  if DroppedDown then Result := FTreeView else Result := nil;
end;

function TDCCustomTreeEdit.GetTreeInitialized: boolean;
begin
  Result := _getFlag(FFlags, TE_TREEINITIALIZE);
end;

{ TDCCustomFloatEdit }

procedure TDCCustomFloatEdit.CalculatorCloseUp(Sender: TObject;
  State: Byte; bPerform: boolean);
begin
  CloseUp(State, bPerform);
end;

procedure TDCCustomFloatEdit.CloseUp(State: Byte; bPerform: boolean = False);
begin
  case State of
     0:;
     1:
      with FCalculator do
      begin
        if (ErrorCode = 0) and IsValidFloat(VisibleParam) then
        begin
          Value := StrToFloat(VisibleParam);
          SendMessage(Self.Handle, EM_SETSEL, 0, -1);
        end;
      end;
  end;
  inherited;
end;

procedure TDCCustomFloatEdit.CMCancelMode(var Message: TCMCancelMode);
begin
  if (Message.Sender <> Self) and
     (Message.Sender <> FCalculator) and
     not FCalculator.ContainsControl(Message.Sender) then
  begin
    inherited;
  end;
end;

procedure TDCCustomFloatEdit.CMPopupWindow(var Message: TMessage);
begin
  case Message.WParam of
    0:
     if _getFlag(FFlags, EM_DROPDOWNVISIBLE) then
     begin
       if BtnChoiceAssigned then FBtnChoice.ResetProperties;
       _setFlag(FFlags, EM_DROPDOWNVISIBLE, False);
       FCalculator.Free;
       FCalculator := nil;
       ShowHint  := Flags[EM_SAVEDSHOWHINT];
       ShowCaret(Handle);
       DoCloseUp;
     end;
    1:
     begin
       _setFlag(FFlags, EM_SAVEDSHOWHINT, ShowHint);
       ShowHint   := False;
       FCalculator:= TDCCustomCalculator.Create(Self);
       HideCaret(Handle);
       with FCalculator do
       begin
         OnCloseUp := CalculatorCloseUp;
         if IsValidFloat(Self.Text) then VisibleParam := Self.Text;
         VisibleParamToFloat;
         ShowDropDown;
       end;
       _setFlag(FFlags, EM_DROPDOWNVISIBLE, True);
     end;
  end;
end;

constructor TDCCustomFloatEdit.Create(AOwner: TComponent);
begin
  inherited;
  Alignment := taRightJustify;
  FDataType := TFloatDataType.Create(Self);
  FMasked := False;  
end;

procedure TDCCustomFloatEdit.DefineBtnChoiceStyle;
begin
  if BtnChoiceAssigned then
  begin
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNCALC');
    ButtonStyle  := esDropDown;
    ButtonChoiceStyle := btsCustom;
    ButtonChoice.Options := ButtonChoice.Options - [boSimpleStyle];
  end;
end;

destructor TDCCustomFloatEdit.Destroy;
begin
  Perform(CM_ERRORMESSAGE, 0, 0);
  FDataType.Free;
  inherited;
end;

procedure TDCCustomFloatEdit.EditMaskChanged;
begin
  if not CanEmpty or (Text <> '') then Text := GetEditValue(Text);
end;

function TDCCustomFloatEdit.GetDataType: TFloatDataType;
begin
  Result := FDataType;
end;

function TDCCustomFloatEdit.GetDropDownControl: TWinControl;
begin
  if DroppedDown then Result := FCalculator else Result := nil;
end;

function TDCCustomFloatEdit.GetEditValue(EditText: string): string;
begin
  Result := EditText;
  with DataType do
  begin
    case Kind of
      deFloat:
        if not CheckFloat(Result, Precision, Digits) then
        begin
          Result := '0';
          CheckFloat(Result, Precision, Digits);
        end;
      deCurrency:
        if not CheckCurrency(Result, CurrencyDecimals, Digits) then
        begin
          Result := '0';
          CheckCurrency(Result, CurrencyDecimals, Digits);
        end;
      deInteger:
        if not CheckInteger(Result, Digits) then Result := '0'
    end;
  end;
end;

procedure TDCCustomFloatEdit.GetHintOnError;
begin
  case FErrorCode of
    ERR_EDIT_INCORRECTFLOAT: FErrorHint := LoadStr(RES_EDIT_ERR_FLOAT);
    ERR_EDIT_INCORRECTCURR : FErrorHint := LoadStr(RES_EDIT_ERR_CURR);
    ERR_EDIT_INCORRECTDEC  : FErrorHint := LoadStr(RES_EDIT_ERR_DEC);
   else
    FErrorHint := '';
  end;
  inherited;
end;

function TDCCustomFloatEdit.GetValue: Extended;
begin
  Result := StrToFloat(GetEditValue(Text));
end;

function TDCCustomFloatEdit.IsMasked: boolean;
begin
  Result :=  FMasked and inherited IsMasked;
end;

procedure TDCCustomFloatEdit.KeyDown(var Key: Word; Shift: TShiftState);
 var
  KeyDownEvent: TKeyEvent;
begin
  KeyDownEvent := OnKeyDown;
  if _getFlag(FFlags, EM_DROPDOWNVISIBLE) and (FCalculator<>nil) then
  begin
    if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
    FCalculator.KeyDown(Key, Shift);
    Key := 0;
  end
  else
    case Key of
      VK_DOWN:
        if [ssAlt] * Shift = [ssAlt] then
        begin
          if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
          if Key <> 0 then ChoiceButtonDown;
          Key := 0;
        end;
    end;
  if Key <> 0 then inherited;
end;

procedure TDCCustomFloatEdit.KillFocus(var Value: boolean);
 var
  EditText: string;

 function CheckValue(AText: string): string;
 begin
   Result := AText;
   with DataType do
   begin
     case Kind of
       deFloat:
         if not CheckFloat(Result, Precision, Digits) then
         begin
           Value := True;
           ErrorCode := ERR_EDIT_INCORRECTFLOAT;
         end;
       deCurrency:
         if not CheckCurrency(Result, CurrencyDecimals, Digits) then
         begin
           Value := True;
           ErrorCode := ERR_EDIT_INCORRECTCURR;
         end;
       deInteger:
         if not CheckInteger(Result, Digits) then
         begin
           Value := True;
           ErrorCode := ERR_EDIT_INCORRECTDEC;
         end;
     end;
   end;
 end;

begin
  if CanModified and not Value and not(Trim(Text) = '') and not MaskMatched then
  begin
    EditText := CheckValue(Text);
    if not Value then Text := EditText;
  end
  else
    if not(Trim(Text) = '') then
    begin
      EditText := CheckValue(Text);
      if not Value then Self.Value := StrToFloat(EditText);
    end;
  inherited KillFocus(Value);
end;

procedure TDCCustomFloatEdit.SetDataType(const Value: TFloatDataType);
begin
  FDataType.Assign(Value);
end;

procedure TDCCustomFloatEdit.SetValue(const Value: Extended);
begin
  if not((FDataType.FKind = deInteger) or (FDataType.FDigits = -1)) then
    Text := GetEditValue(FloatToStrF(Value, ffGeneral,
      FDataType.FDigits, FDataType.FDigits))
  else begin
    Text := GetEditValue(FloatToStrF(Value, ffGeneral, 15, 15))
  end;
end;

procedure TDCCustomFloatEdit.ShowDropDown;
begin
  WndProcAction(1);
  FCalculator.Show;
end;

{ TFloatDataType }

procedure TFloatDataType.Assign(Source: TPersistent);
begin
  FKind      := TFloatDataType(Source).Kind;
  FPrecision := TFloatDataType(Source).Precision;
  FDigits    := TFloatDataType(Source).Digits;
  UpdateMask;
end;

constructor TFloatDataType.Create(AEdit: TDCCustomMaskEdit);
begin
  inherited Create;
  FEdit := AEdit;
  FKind := deFloat;
  FPrecision := -1;
  FDigits    := -1;
end;

procedure TFloatDataType.SetDigits(const Value: integer);
begin
  FDigits := Value;
  UpdateMask;
end;

procedure TFloatDataType.SetKind(const Value: TEditDataType);
begin
  FKind := Value;
  case Value of
    deFloat:;
    deInteger:
      Precision := 0;
    deCurrency:
      Precision := 0;
  end;
  UpdateMask;
end;

procedure TFloatDataType.SetPrecision(const Value: integer);
begin
  FPrecision := Value;
  UpdateMask;
end;

function TDCCustomChoiceEdit.IsGlyphStored: boolean;
begin
  Result := (FBtnChoiceStyle = btsCustom);
end;

function TDCCustomChoiceEdit.IsButtonWidthStored: boolean;
begin
  Result := (FBtnChoiceStyle = btsCustom);
end;

procedure TDCCustomComboBox.WMLButtonDblClk(var Message: TWMLButtonDown);
begin
  if ButtonEnabled and (FStyle = csDropDownList) then
  begin
    Message.Result := $AE;
    inherited WMLButtonDblClk(Message);
  end
  else inherited;
end;

function TDCCustomChoiceEdit.CanModified: boolean;
begin
  Result := inherited CanModified or (ButtonExist and ButtonEnabled);
end;

function TDCCustomComboBox.DoMouseWheel(Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint): Boolean;
 var
  ADelta, AIndex: integer;
  AMessage: TCMMouseWheel;
begin
  Result := inherited DoMouseWheel(Shift, WheelDelta, MousePos);
  if not Result then
  begin
    if not _getFlag(FFlags, EM_DROPDOWNVISIBLE) then
    begin
      ADelta := WheelDelta div WHEEL_DELTA;
      AIndex := ItemIndex - ADelta;
      if (AIndex >= 0) and (AIndex < FItems.Count) then ItemIndex := AIndex;
      Result := True;
      Change;
    end
    else begin
      AMessage.WheelDelta := WheelDelta;
      AMessage.ShiftState := Shift;
      AMessage.XPos        := MousePos.X;
      AMessage.YPos        := MousePos.Y;
      with TMessage(AMessage) do
        FListBox.Perform(CM_MOUSEWHEEL, WParam, LParam);
      Result := True;
    end;
  end;
end;

procedure TFloatDataType.UpdateMask;
 var
  sFormat: string;
begin
  sFormat := '';
  if FDigits > 0 then
  begin
    if FPrecision > 0 then
      sFormat := Format('9{%d}!(.,%1:s)%1:s9{%d}', [FDigits - FPrecision,
        DecimalSeparator, FPrecision])
    else
      sFormat := Format('9{%d}', [FDigits])
  end;
  if FEdit <> nil then FEdit.EditMask := sFormat;
end;

{ TDCBDEGridEdit }

constructor TDCBDEGridEdit.Create(AOwner: TComponent);
begin
  inherited;
end;

function TDCBDEGridEdit.CreateQuery: TDataSet;
begin
  Result := TQuery.Create(self);
end;

function TDCBDEGridEdit.DoCreatePopupGrid: TDCCustomPopupDBGrid;
begin
  Result := TDCBDEPopupDBGrid.Create(Self);
end;

procedure TDCBDEGridEdit.DoInitQuery(Mode: integer);
begin
  with TQuery(FQuery) do
  begin
    SQL.Text := GetPreparedQueryText(Mode, SQL.Text);
    Prepare;
    Open;
  end;
end;

function TDCBDEGridEdit.GetDatabaseName: string;
begin
  Result := TQuery(FQuery).DatabaseName;
end;

function TDCBDEGridEdit.GetParams: TParams;
begin
  Result := TQuery(FQuery).Params;
end;

function TDCBDEGridEdit.GetQueryText: string;
 var
  i: integer;
begin
  Result := '';
  for i := 0 to TQuery(Query).SQL.Count -1 do
  begin
    if Result <> '' then Result := Result+ #10;
    Result := Result + TQuery(Query).SQL.Strings[i];
  end;
end;

procedure TDCBDEGridEdit.PrepareDataSet;
 var
  AParams: TParams;
begin
  AParams := TParams.Create;
  try
    AParams.Assign(Params);
    with TQuery(FQuery) do
    begin
      Close;
      UnPrepare;
      SQL.Clear;
      SQL.Text := SQLText;
      Params.Assign(AParams);
    end;
  finally
    AParams.Free;
  end;
end;

procedure TDCBDEGridEdit.SetDatabaseName(const Value: string);
begin
  TQuery(FQuery).DatabaseName := Value;
end;

procedure TDCBDEGridEdit.SetInternalDataSet(const Value: TDataSet;
  var DataSet: TDataSet);
begin
  DataSet := Value;
  if FQuery.Active then FQuery.Close;
  if (FDataSet is TQuery) and not ListBoxEnabled then
  begin
    DatabaseName := TQuery(FDataSet).DatabaseName;
    SQLText      := TQuery(FDataSet).SQL.Text;
  end
  else
    if not FQueryDataSet then SQLText := '';

  if not FQueryDataSet then
  begin
    if (DataSet <> nil) and DataSet.Active then
      SetGridValues
    else
      if FValues.FFieldsLoaded then
      begin
        FValues.Clear;
        FValues.FFieldsLoaded := False;
      end;
  end
end;

procedure TDCBDEGridEdit.SetInternalSQLText(const Value: string;
  var SQLText: string);
begin
  if FQuery.Active then FQuery.Close;
  if Value <> '' then TQuery(FQuery).SQL.Text := SQLText;
end;

procedure TDCBDEGridEdit.SetParams(const Value: TParams);
begin
  TQuery(FQuery).Params.AssignValues(Value);
end;

procedure TDCCustomComboBox.DropDown;
begin
  if Assigned(FOnDropDown) then FOnDropDown(Self);
end;

{ TDCCustomFormEdit }

procedure TDCCustomFormEdit.CloseUp(State: Byte; bPerform: boolean);
begin
  case State of
     0:;
     1: if DroppedDown then GetFormResult(FEditForm);
  end;
  inherited;
end;

procedure TDCCustomFormEdit.CMCancelMode(var Message: TCMCancelMode);
begin
  inherited;
end;

procedure TDCCustomFormEdit.CMPopupWindow(var Message: TMessage);
begin
  case Message.WParam of
    0:
     begin
       if BtnChoiceAssigned then FBtnChoice.ResetProperties;
       if DroppedDown then FEditForm.Hide;
       ShowHint := Flags[EM_SAVEDSHOWHINT];
       ShowCaret(Handle);
       DoCloseUp;
     end;
    1:
     begin
       if FEditForm = nil then CreateEditForm(TCustomForm(FEditForm));
       if FEditForm <> nil then begin
         _setFlag(FFlags, EM_SAVEDSHOWHINT, ShowHint);
         ShowHint := False;
         HideCaret(Handle);
         with TCustomEditForm(FEditForm) do
         begin
           BorderIcons := [];
           BevelKind   := bkNone;
           FormStyle   := fsStayOnTop;
         end;
         with FEditForm do
         begin
           Caption := DBObject.Caption;
           BorderStyle := bsSizeToolWin;
           with TCustomEditForm(FEditForm) do
           begin
             AutoScroll  := False;
           end;
           InitEditFromParams(FEditForm);
           ShowDropDown;
         end;
       end;
     end;
  end;
end;

constructor TDCCustomFormEdit.Create(AOwner: TComponent);
begin
  inherited;
  FEditForm := nil;

  FEFDefWndProc := nil; 
  {$IFDEF DELPHI_V6}
    FEFNewWndProc := Classes.MakeObjectInstance(EFWndProc);
  {$ELSE}
    FEFNewWndProc := MakeObjectInstance(EFWndProc);
  {$ENDIF}
end;

function TDCCustomFormEdit.CreateEditForm(var EditForm: TCustomForm): boolean;
begin
  if Assigned(FOnCreateEditForm) then FOnCreateEditForm(Self, EditForm);
  Result := EditForm <> nil;
end;

procedure TDCCustomFormEdit.DefineBtnChoiceStyle;
begin
  if BtnChoiceAssigned then
  begin
    ButtonStyle := esDropDown;
    ButtonChoiceStyle := btsCustom;
  end;
end;

destructor TDCCustomFormEdit.Destroy;
begin
  if (FEditForm <> nil) then
  begin
    FEditForm.Free;
    FEditForm := nil
  end;
  {$IFDEF DELPHI_V6}
    Classes.FreeObjectInstance(FEFNewWndProc);
  {$ELSE}
    FreeObjectInstance(FEFNewWndProc);
  {$ENDIF}
  inherited;
end;

procedure TDCCustomFormEdit.EFWndProc(var Message: TMessage);
 var
  ParentForm: TCustomForm;
  ParentWnd: HWND;
  lCallNextProc: boolean;
begin
  lCallNextProc := True;
  try
    with Message do
    begin
      case Msg of
        CM_DEACTIVATE:
          begin
            ParentForm := GetParentForm(Self);
            if not((Screen.ActiveCustomForm = ParentForm) and (ParentForm <> nil) and
                   (ParentForm.ActiveControl = Self))
            then
               CloseUp(0, True);
            with FEditForm do if Visible then
              SetWindowPos(Handle, ParentForm.Handle - 1, 0, 0, 0, 0,
                SWP_NOACTIVATE or SWP_NOMOVE or SWP_NOSIZE);
          end;
        CM_CLOSEUP:
          CloseUp(WParam, True);
        WM_KILLFOCUS:
           with TWMKillFocus(Message) do
             if (FocusedWnd <> Handle) and (FEditForm <> nil) then
             begin
               ParentWnd := GetParent(FocusedWnd);
               while (ParentWnd <> 0) and (ParentWnd <> FEditForm.Handle) do
                 ParentWnd := GetParent(ParentWnd);
               if ParentWnd = 0 then CloseUp(0, True);
             end;
        CM_GETPOPUPSTATE:
          begin
            Result := ES_POPUPCONTROL;
            lCallNextProc := False;
          end;
      end;
      if lCallNextProc then
        Result := CallWindowProc(FEFDefWndProc, FEditForm.Handle, Msg, WParam, LParam);
    end;
  except
    {}
  end;
end;

function TDCCustomFormEdit.GetDroppedDown: boolean;
begin
  Result := (FEditForm <> nil) and (FEditForm.Visible);
end;

procedure TDCCustomFormEdit.GetFormResult(AEditForm: TCustomForm);
begin
  {}
end;

procedure TDCCustomFormEdit.InitEditFromParams(AEditForm: TCustomForm);
 var
  P: TPoint;
begin
  P := Point((ClientWidth - Width) div 2,
             ClientHeight + (Height - ClientHeight) shr 1);
  P := ClientToScreen(P);
  SetRectInDesktop(P, AEditForm.Width, AEditForm.Height,
     Point(0, (Screen.DesktopTop+Screen.DesktopHeight) - P.Y + Height));

  AEditForm.Left := P.X;
  AEditForm.Top  := P.Y;
end;

procedure TDCCustomFormEdit.WndProcAction(Action: integer);
begin
  inherited;
  if (FEditForm <> nil) and not (csDesigning in ComponentState) then
  begin
    case Action of
      0:
        if FEFDefWndProc <> nil then
        begin
          SetWindowLong(FEditForm.Handle, GWL_WNDPROC, LongInt(FEFDefWndProc));
          FEFDefWndProc := nil;
        end;
      1:
        begin
          FEFDefWndProc := Pointer(GetWindowLong(FEditForm.Handle, GWL_WNDPROC));
          SetWindowLong(FEditForm.Handle, GWL_WNDPROC, LongInt(FEFNewWndProc));
        end;
    end;
  end;
end;

procedure TDCCustomFormEdit.SetInfoFieldWidth(const Value: integer);
begin
  if (Value >= 0) and (FInfoFieldWidth <> Value) then
  begin
    FInfoFieldWidth := Value;
    SetEditRect;
  end;
end;

procedure TDCCustomFormEdit.GetMargins(var LeftMargin,
  RightMargin: integer);
 var
  CharWidth: integer;
begin
  inherited;
  if HandleAllocated and ExistInfo and (RightMargin > 0) then
  begin
    RightMargin := RightMargin + FInfoFieldWidth;
    CharWidth := GetCharWidth(Handle, Font);
    if (ClientWidth - RightMargin - LeftMargin - CharWidth) < 0 then
      RightMargin := ClientWidth - LeftMargin - CharWidth;
  end;
end;

function TDCCustomFormEdit.ExistInfo: boolean;
begin
  Result := FInfoFieldWidth > 0;
end;

procedure TDCCustomFormEdit.DoDrawMargins(DC: HDC);
 var
  RightMargin: integer;
  R: TRect;
  OldPos: TPoint;
  Value: string;
  Pen: HPEN;
  Brush: HBRUSH;
  ADefault: boolean;
begin
  inherited;
  RightMargin := Width - FMargins.Right;
  if ExistInfo and (RightMargin > 0) then
  begin
    SelectObject(DC, Font.Handle);
    if not Enabled and not(csDesigning in ComponentState) then
      SetTextColor(DC, ColorToRGB(clInactiveCaption))
    else
      SetTextColor(DC, ColorToRGB(Font.Color));
    SetBkColor(DC, ColorToRGB(Color));

    GetWindowRect (Handle, R);  OffsetRect (R, -R.Left, -R.Top);

    R.Left  := FMargins.Right + 2;
    R.Right := R.Right - GetButtonWidth - 2;

    case FDrawStyle of
      fsNone  :
       begin
         InflateRect(R, -1, -1);
         R.Left := R.Left -1;
       end;
      fsSingle  :
       InflateRect(R, -3, -3);
      fcsNormal,
      fsFlat  :
       InflateRect(R, -3, -3);
    end;

    ADefault := True;
    Value    := '';

    if Assigned(FOnDrawInfoText) then FOnDrawInfoText(Self, DC, R, Value, ADefault);

    if ADefault then
    begin
      if ColorToRGB(Color) = ColorToRGB(clBtnFace) then
        Pen := CreatePen(PS_SOLID, 1, ColorToRGB(clBtnShadow))
      else
        Pen := CreatePen(PS_SOLID, 1, ColorToRGB(clBtnFace));
      Brush := CreateSolidBrush(ColorToRGB(Color));
      try
        SelectObject(DC, Pen);
        MoveToEx(DC, R.Left, R.Top, @OldPos);
        LineTo(DC, R.Left, R.Bottom);
        R.Left := R.Left + 4;
        FillRect(DC, R, Brush);
        DrawText(DC, PChar(Value),  Length(Value), R, DT_LEFT);
      finally
        DeleteObject(Pen);
        DeleteObject(Brush);
      end
    end;
  end;
end;

procedure TDCCustomFormEdit.KeyDown(var Key: Word; Shift: TShiftState);
 var
  KeyDownEvent: TKeyEvent;
begin
  KeyDownEvent := OnKeyDown;
  if not DroppedDown then
  begin
    if [ssAlt]*Shift = [ssAlt] then
    begin
      case Key of
        VK_DOWN:
          begin
            if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
            if Key <> 0 then
            begin
              ChoiceButtonDown;
              Key := 0;
            end;
          end;
      end;
    end;
  end
  else begin
    case Key of
      VK_ESCAPE:
        begin
          CloseUp(0, True);
          Key := 0;
        end;
    end;
  end;
  if Key <> 0 then inherited;
end;

procedure TDCCustomFormEdit.ShowDropDown;
begin
  WndProcAction(1);
  FEditForm.Show;
end;

function TDCCustomFormEdit.GetDropDownControl: TWinControl;
begin
  if DroppedDown then Result := FEditForm else Result := nil;
end;

{ TDCCustomMaskEdit }

procedure TDCCustomMaskEdit.CMTextChanged(var Message: TMessage);
begin
  inherited;
  if IsMasked and (Text = '') then CompleteChars;
end;

procedure TDCCustomMaskEdit.CompleteChars;
 var
  ASelStart, ASelEnd, MaskEnd: integer;
  S: string;
begin
  with FMaskStruct do
  begin
    ASelStart := SelStart;
    MaskEnd := 0;
    S := '';
    EMCompeteChar(S, FMaskStruct, MaskEnd, ASelStart, ASelEnd);
    Text := S;
    SetSel(ASelStart, ASelStart);
  end;
end;

constructor TDCCustomMaskEdit.Create(AOwner: TComponent);
begin
  inherited;
end;

procedure TDCCustomMaskEdit.DeleteKey(Key: Word);
 var
  S: string;
  ASelStart, ASelEnd, MaskEnd: integer;
begin
  if Key <> 0 then
  begin
    ASelStart := SelStart;
    ASelEnd   := 0;
    S := Text;
    if (Key = VK_DELETE) or (SelLength > 0) then
    begin
      MaskEnd := EMDeleteChar(S, FMaskStruct, SelStart, SelStart + SelLength, DoCharCheck);
      EMCompeteChar(S, FMaskStruct, MaskEnd, ASelStart, ASelEnd);
    end
    else if SelStart > 0 then begin
      MaskEnd := EMDeleteChar(S, FMaskStruct, SelStart - 1, SelStart, DoCharCheck);
      EMCompeteChar(S, FMaskStruct, MaskEnd, ASelStart, ASelEnd);
      EMClearSymbols(S, FMaskStruct, MaskEnd, ASelStart);
      Dec(ASelStart);
    end;

    Text := S;
    SetSel(ASelStart, ASelStart);
  end;
end;

destructor TDCCustomMaskEdit.Destroy;
begin
  if IsMasked then EMClear(FMaskStruct);
  inherited;
end;

procedure TDCCustomMaskEdit.DoCharCheck(var C: Char;
  MaskItem: TMaskItem; ItemPos: integer; var CharValid: boolean);
begin
  if Assigned(FOnCharCheck) then FOnCharCheck(Self, C, MaskItem, ItemPos, CharValid);
end;

procedure TDCCustomMaskEdit.EditMaskChanged;
begin
  Text := '';
  CompleteChars;
end;

procedure TDCCustomMaskEdit.GetHintOnError;
begin
  case FErrorCode of
    ERR_MASK_MATCH:
      FErrorHint := Format('%s /{%s/}',[LoadStr(RES_MASK_ERR_WRONG), FEditMask]);
  end;
  inherited;
end;

function TDCCustomMaskEdit.GetHintTimeOut: integer;
begin
  if FErrorCode = ERR_MASK_MATCH then
    Result := 4000
  else
    Result := inherited GetHintTimeOut;
end;

procedure TDCCustomMaskEdit.InsertString(Insert: string);
 var
  S: string;
  ASelStart, ASelEnd: integer;
begin
  ASelStart := SelStart;
  ASelEnd   := ASelStart + SelLength;
  S := Text;
  EMInsertChar(S, Insert, FMaskStruct, ASelStart, ASelEnd, DoCharCheck);
  Text := S;
  SelStart  := ASelStart;
  SelLength := 0;
end;

function TDCCustomMaskEdit.IsMasked: boolean;
begin
  Result := FMaskStruct.Count > 0;
end;

procedure TDCCustomMaskEdit.KeyDown(var Key: Word; Shift: TShiftState);
 var
  KeyDownEvent: TKeyEvent;
begin
  if Key = VK_DELETE then Perform(CM_ERRORMESSAGE, 0, 0);
  if IsMasked then
  begin
    KeyDownEvent := OnKeyDown;
    case Key of
      VK_DELETE, VK_BACK:
        if not ReadOnly then
        begin
          if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
          DeleteKey(Key);
          Key := 0;
        end;
    end;
    if Key <> 0 then inherited;
  end
  else
    inherited
end;

procedure TDCCustomMaskEdit.KeyPress(var Key: Char);
begin
  if IsMasked and not ReadOnly then
  begin
    if (Key >= Chr(VK_SPACE)) then
    begin
      InsertString(string(Key));
      Key := #0;
    end;
    if Key = Chr(VK_BACK) then Key := #0;
  end;
  inherited;
end;

procedure TDCCustomMaskEdit.KillFocus(var Value: boolean);
begin
  if CanModified then
  begin
    if not Value and Flags[EM_REQUIRED] and (Trim(Text) = '')
    then begin
      Value := True;
      ErrorCode := ERR_EDIT_EMPTYVALUE;
    end;
    if not Value and (Trim(Text) <> '') and not MaskMatched then
    begin
      Value := True;
      ErrorCode := ERR_MASK_MATCH;
    end;
  end;
  inherited KillFocus(Value);
end;

function TDCCustomMaskEdit.MaskMatched: boolean;
 var
  MaskStart, SymbolsCount, MaskEnd: integer;
  AText: string;
begin
  if IsMasked then
  begin
   AText := Text;
   MaskStart := EMMatches(AText, FMaskStruct, False, SymbolsCount, True,
     MaskEnd, DoCharCheck);
   Result := MaskStart > -1;
   if Result and (CompareStr(Text, AText) <> 0) then Text := AText;
  end
  else
    Result := True;
end;

procedure TDCCustomMaskEdit.SetEditMask(const Value: string);
begin
  FEditMask := Value;
  EMInitStruct(Value, FMaskStruct);
  EditMaskChanged;
end;

procedure TDCCustomMaskEdit.SetSel(SelStart, SelEnd: Integer);
begin
  SendMessage(Handle, EM_SETSEL, SelStart, SelEnd);
end;

procedure TDCCustomMaskEdit.WMCut(var Message: TMessage);
begin
  if not IsMasked then
    inherited
  else
    DeleteKey(VK_DELETE);
end;

procedure TDCCustomMaskEdit.WMPaste(var Message: TMessage);
 var
  Value: string;
begin
  if not IsMasked then
    inherited
  else begin
    Clipboard.Open;
    Value := Clipboard.AsText;
    Clipboard.Close;
    InsertString(Value);
  end;
end;

{ TDCEditMessage }

constructor TDCErrorMessageWindow.Create(AOwner: TComponent);
begin
  inherited;
  Shadow.Visible := True;
  FDefaultItemWidth := -1;
end;

function TDCErrorMessageWindow.GetButtonSize(
  Button: TDCEditButton): TPoint;
begin
  Result := inherited GetButtonSize(Button);
  if FDefaultItemWidth <> -1 then Result.X := FDefaultItemWidth;
end;

function TDCErrorMessageWindow.GetEdit: TDCCustomEdit;
begin
  Result := TDCCustomEdit(Owner);
end;

procedure TDCErrorMessageWindow.Hide;
begin
  if Visible then
  begin
    UnHookErrorHooks;
    Edit.ShowError := False;
  end;
  if Edit.HandleAllocated and (Edit.ComponentState = []) then
     PostMessage(Edit.Handle, CM_ERRORMESSAGE, 0, 0);
  inherited;
end;

{ TDCBDEPopupDBGrid }

function TDCBDEPopupDBGrid.LocateRecord(var KeyValue: string): boolean;
 var
  VLocate: variant;
  ADate: string;
begin
  VLocate := null;
  Result := False;

  if Assigned(SelectedField) then with SelectedField do
  begin
    if FieldKind = fkLookup then
    begin
      if LookUpDataSet.Locate(LookUpResultField,
        KeyValue, [loCaseInsensitive, loPartialKey]) then
        DataSet.Locate(KeyFields, LookUpDataSet.FieldByName(LookUpKeyFields).AsString,
          [loCaseInsensitive, loPartialKey]);
    end
    else begin
      case DataType of
       ftString, ftWideString:
         VLocate := KeyValue;
       ftAutoInc, ftInteger, ftSmallInt, ftWord, ftLargeInt:
         if IsValidInteger(KeyValue) then VLocate := StrToInt(KeyValue);
       ftFloat:
         if IsValidFloat(KeyValue) then VLocate := StrToFloat(KeyValue);
       ftCurrency:
         if IsValidCurrency(KeyValue, CurrencyDecimals) then
           VLocate := StrToCurr(KeyValue);
       ftDate, ftTime, ftDateTime:
         if DateToStrY2K(KeyValue, ADate) then
           VLocate := StrToDateTime(ADate)
         else
           VLocate := KeyValue;
      end;

      if VLocate <> null then
        Result := DataSource.DataSet.Locate(FieldName, VLocate,
          [loCaseInsensitive, loPartialKey])
    end;
  end;
end;

initialization
  Set8087CW($133F);

finalization

end.
