{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x - 6.x
         Copyright (c) 1998-2001 Alex'EM

}
unit DCADOCtrl;

interface
{$I DCConst.inc}

{$IFDEF ADO_EXPRESS}

uses
  SysUtils, Classes, db, ADOdb, ADOInt,
  {$IFDEF DELPHI_V6}
    Variants,
  {$ENDIF}
  DCConst, DCChoice, DCDBGrids;

type
  TDCADOPopupDBGrid = class(TDCCustomPopupDBGrid)
  protected
    function LocateRecord(var KeyValue: string): boolean; override;
  end;

  TDCADOGridEdit = class(TDCCustomGridEdit)
  private
    procedure SetParameters(const Value: TParameters);
    function GetParameters: TParameters;
    function GetConnection: TADOConnection;
    procedure SetConnection(const Value: TADOConnection);
  protected
    function CreateQuery: TDataSet; override;
    function DoCreatePopupGrid: TDCCustomPopupDBGrid; override;
    procedure DoInitQuery(Mode: integer); override;
    function GetQueryText: string; override;
    procedure PrepareDataSet; override;
    procedure SetInternalDataSet(const Value: TDataSet; var DataSet: TDataSet); override;
    procedure SetInternalSQLText(const Value: string; var SQLText: string); override;
  public
    constructor Create(AOwner: TComponent); override;
    property ButtonEnabled;
  published
    property DrawStyle;
    property CheckGlyph;
    property CheckTag;
    property ReadOnly;
    property Parameters: TParameters read GetParameters write SetParameters;
    property Connection: TADOConnection read  GetConnection write SetConnection;
    property EditMask;
  end;

{$ENDIF}

implementation
{$IFDEF ADO_EXPRESS}

uses
  DCEditTools;

type
  TPrivateDataSet = class(TDataSet)
    {}
  end;

{ TDCADOGridEdit }
constructor TDCADOGridEdit.Create(AOwner: TComponent);
begin
  inherited;
end;

function TDCADOGridEdit.CreateQuery: TDataSet;
begin
  Result := TADOQuery.Create(Self);
end;

function TDCADOGridEdit.DoCreatePopupGrid: TDCCustomPopupDBGrid;
begin
  Result := TDCADOPopupDBGrid.Create(Self);
end;

procedure TDCADOGridEdit.DoInitQuery(Mode: integer);
begin
  with TADOQuery(Query) do
  begin
    SQL.Text := GetPreparedQueryText(Mode, SQL.Text);
    Open;
  end;
end;

function TDCADOGridEdit.GetConnection: TADOConnection;
begin
  Result := TADOQuery(Query).Connection;
end;

function TDCADOGridEdit.GetParameters: TParameters;
begin
  Result := TADOQuery(Query).Parameters;
end;

function TDCADOGridEdit.GetQueryText: string;
 var
  i: integer;
begin
  Result := '';
  for i := 0 to TADOQuery(Query).SQL.Count -1 do
  begin
    if Result <> '' then Result := Result+ #10;
    Result := Result + TADOQuery(Query).SQL.Strings[i];
  end;
end;

procedure TDCADOGridEdit.PrepareDataSet;
 var
  AParams: TParameters;
begin
  AParams := TParameters.Create(Self, TParameter);
  try
    AParams.Assign(Parameters);
    with TADOQuery(Query) do
    begin
      Close;
      SQL.Clear;
      SQL.Text := SQLText;
      Parameters.Assign(AParams);
    end;
  finally
    AParams.Free;
  end;
end;

procedure TDCADOGridEdit.SetConnection(const Value: TADOConnection);
begin
  TADOQuery(Query).Connection := Value;
end;

procedure TDCADOGridEdit.SetInternalDataSet(const Value: TDataSet; var DataSet: TDataSet);
begin
  DataSet := Value;
  if Query.Active then Query.Close;
  if (DataSet is TADOQuery) and not ListBoxEnabled then
    SetSQLTextPermanet(TADOQuery(DataSet).SQL.Text)
  else
    if not QueryDataSet then SetSQLTextPermanet('');

  if not QueryDataSet then
  begin
    if (DataSet <> nil) and DataSet.Active then
      SetGridValues
    else
      Values.Clear;
  end
end;

procedure TDCADOGridEdit.SetInternalSQLText(const Value: string;
  var SQLText: string);
begin
  if TADOQuery(Query).Active then TADOQuery(Query).Close;
  if Value <> '' then TADOQuery(Query).SQL.Text := SQLText;
end;

procedure TDCADOGridEdit.SetParameters(const Value: TParameters);
begin
  TADOQuery(Query).Parameters.AssignValues(Value);
end;

{$ENDIF}

{ TDCADOPopupDBGrid }

function TDCADOPopupDBGrid.LocateRecord(var KeyValue: string): boolean;
 var
  VLocate: variant;
  ADate: string;

  function InternalLocate(AValue: variant): boolean;
   var
    LookupCursor: _Recordset;
  begin
    with TCustomADODataSet(DataSet) do
    begin
      TPrivateDataSet(DataSet).DoBeforeScroll;
      LookupCursor := Recordset.Clone(adLockReadOnly);
      LookupCursor.Filter := '';
      LookupCursor.Find(AValue, 0, adSearchForward, EmptyParam);
      if not LookupCursor.EOF then
      begin
        Recordset.Bookmark := LookupCursor.Bookmark;
        if Recordset.EOF or Recordset.BOF then CursorPosChanged;
        Resync([rmExact, rmCenter]);
        TPrivateDataSet(DataSet).DoAfterScroll;
      end;
      Result := not(Recordset.EOF or Recordset.BOF);
      LookupCursor := nil;
    end;
  end;

  function InternalSelect(Field: TField; AValue: string): boolean;
   var
    LookupCursor: _Recordset;
    sDateValue: string;
  begin
    with TCustomADODataSet(DataSet) do
    begin
      TPrivateDataSet(DataSet).DoBeforeScroll;
      LookupCursor := Recordset.Clone(adLockReadOnly);
      LookupCursor.Filter := '';
      LookupCursor.MoveFirst;
      Result := False;
      while not(Result or LookupCursor.EOF) do
      begin
        DateToStrY2K(VarToStr(LookupCursor.Fields.Item[Field.Index].Value),
          sDateValue);
        Result := Pos(AValue, sDateValue) = 1;
        if not Result then LookupCursor.MoveNext;
      end;
      if Result then
      begin
        Recordset.Bookmark := LookupCursor.Bookmark;
        if Recordset.EOF or Recordset.BOF then CursorPosChanged;
        Resync([rmExact, rmCenter]);
        TPrivateDataSet(DataSet).DoAfterScroll;
      end;
      LookupCursor := nil;
    end;
  end;

begin
  VLocate := null;
  Result := False;
  if Assigned(SelectedField) then with SelectedField do
  begin
    if FieldKind = fkLookup then
    begin
      if LookUpDataSet.Locate(LookUpResultField,
        KeyValue, [loCaseInsensitive, loPartialKey]) then
        DataSet.Locate(KeyFields, LookUpDataSet.FieldByName(LookUpKeyFields).AsString,
          [loCaseInsensitive, loPartialKey]);
    end
    else begin
      case DataType of
       ftString, ftWideString:
         VLocate := KeyValue;
       ftAutoInc, ftInteger, ftSmallInt, ftWord, ftLargeInt:
         if IsValidInteger(KeyValue) then VLocate := StrToInt(KeyValue);
       ftFloat:
         if IsValidFloat(KeyValue) then VLocate := StrToFloat(KeyValue);
       ftCurrency:
         if IsValidCurrency(KeyValue, CurrencyDecimals) then
           VLocate := StrToCurr(KeyValue);
       ftDate, ftTime, ftDateTime:
         if DateToStrY2K(KeyValue, ADate) then
           VLocate := StrToDateTime(ADate)
         else begin
           Result := InternalSelect(SelectedField, KeyValue);
           Exit;
         end;
      end;

      if VLocate <> null then
      begin
        Result := DataSet.Locate(FieldName, VLocate,
          [loCaseInsensitive, loPartialKey]);
        if not Result and (SelectedField.DataType in [ftString, ftWideString]) and
          (VarToStr(VLocate) <> '') and
          (geSearchOnSubstring in TDCADOGridEdit(Self.Owner).Options) then
        begin
          Result := InternalLocate(Format('%s like ''*%s*''',
            [FieldName, VLocate]));
        end;
      end;
    end;
  end;
end;

end.
